var __index = {"config":{"lang":["en"],"separator":"[\\s\\-]+","pipeline":["stopWordFilter"],"fields":{"title":{"boost":1000.0},"text":{"boost":1.0},"tags":{"boost":1000000.0}}},"docs":[{"location":"index.html","title":"Frame Grabbers","text":"<p>Basler's frame grabbers cover a broad range of use case scenarios. Supporting various camera interfaces, Basler's portfolio reaches from simple plug-and-play frame grabbers to programmable high-performance boards.</p> <p></p> <p>Info</p> <p>Press F or S to start searching.</p> <p>For the latest version of the documentation, visit docs.baslerweb.com/frame-grabbers.</p>"},{"location":"index.html#models","title":"Models","text":"<ul> <li>Basler imaFlex CXP-12 Penta</li> <li>Basler imaWorx CXP-12 Quad</li> <li>Basler imaFlex CXP-12 Quad</li> <li>Basler microEnable 5 marathon</li> </ul>"},{"location":"accessing-parameters-via-api-micro-display-x.html","title":"Accessing Parameters via Framegrabber API (microDisplay X)","text":"<p>You can access all frame grabber and GenICam compatible camera parameters via the Framegrabber API.</p> <p>microDisplay X provides you with a getter/setter code example for each parameter.</p> <p>To view the getter/setter code example for a parameter:</p> <ol> <li>Start microDisplay X.</li> <li>Select the frame grabber you want to work with from the list in the left upper corner.</li> <li>Select one of the listed applets via double-click. The applet is loaded.</li> <li> <p>Select an active acquisition channel (DMA) or a connected camera (Cam).</p> <p></p> </li> <li> <p>Select the parameter.</p> </li> <li>Click the Details button.A new dialog opens, displaying additional parameter information and the example code.</li> <li> <p>Copy the displayed code to the clipboard by clicking the Copy to Clipboard button.</p> <p></p> </li> </ol>"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html","title":"Applets for imaFlex CXP-12 Penta","text":"<p>This topic tells you about the acquisition applets available for the imaFlex CXP-12 Penta frame grabber.</p> <p>To ensure optimum use of system resources, not all image acquisition and processing features designed for imaFlex CXP-12 Penta are loaded onto imaFlex CXP-12 Penta simultaneously. Instead, Basler provides various compilations of specific image acquisition and processing features that are combined to meet the requirements of a specific application field.</p> <p>Typically, an applet supports a specific camera interface standard and topology, specific image acquisition features, and possibly specific image (pre-)processing features. By loading an applet onto the frame grabber, you define the functionality of the frame grabber and adapt it to the requirements of your specific application.</p> <p>There are two kinds of applets: acquisition applets (*.dll) always delivered by Basler, and custom applets (*.hap) developed in VisualApplets either by yourself or by Basler. In addition to the acquisition applets that are included in the delivery, imaFlex CXP-12 Penta can be programmed to fulfill highly specific image processing tasks that are required by a specific application. The programming can be done by Basler, a certified partner, or by yourself using the easy-to-use graphical FPGA programming environment VisualApplets.</p> <p>The acquisition applets for imaFlex CXP-12 Penta are included in the Framegrabber SDK and also in the pylon Software Suite.</p>"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#requirements","title":"Requirements","text":"<ul> <li>Host software: Framegrabber SDK version 5.11.3 or higher</li> <li>Hardware: An imaFlex CXP-12 Penta frame grabber is connected to your system</li> </ul> <p>Limitation</p> <p>In all applets, buffers larger than 4GB can't be allocated. Even if the applet allows a larger buffer size, you can't allocate buffers larger than 4GB due to limitations in the driver and firmware.</p> <p>You can calculate the buffer size as follows:</p> <p>Buffer size = image height * image width * (pixel width / 8).</p> <p>For RGB images: buffer size = (image height * image width * (pixel width / 8)) * 3 .</p>"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#documentation","title":"Documentation","text":"<p>The following sections provide links to the acquisition applets documentation:</p>"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#area-acquisition-applets","title":"Area Acquisition Applets","text":"GenTL Fglib Acq_SingleCXP12Area PDF Acq_SingleCXP12Area PDF Acq_DualCXP12Area PDF Acq_DualCXP12Area PDF Acq_PentaCXP12Area PDF Acq_PentaCXP12Area PDF"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#line-acquisition-applets","title":"Line Acquisition Applets","text":"GenTL Fglib Acq_SingleCXP12Line PDF Acq_SingleCXP12Line PDF Acq_DualCXP12Line PDF Acq_DualCXP12Line PDF Acq_PentaCXP12line PDF Acq_PentaCXP12line PDF"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#frame-grabber-test-applet","title":"Frame Grabber Test Applet","text":"GenTL Fglib Frame Grabber Test Applet PDF Frame Grabber Test Applet PDF"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#area-scan-acquisition-applets","title":"Area Scan Acquisition Applets","text":"<p>The following Area Scan Acquisition Applets are available:</p> <ul> <li>Acq_SingleCXP12Area</li> <li>Acq_DualCXP12Area</li> <li>Acq_PentaCXP12Area</li> </ul> <p>The denominators \"single\", \"dual\", and \"penta\", in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Area Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#choosing-the-right-area-scan-acquisition-applet","title":"Choosing the Right Area Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the image received from the camera can't be processed or displayed correctly or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Max. Number of Cameras Number of 1-Channel Cameras Number of 2-Channel Cameras Number of 4-Channel Cameras Applet ROI Step Size [px] 5 1 Acq_PentaCXP12Area x: 8y: 1 5 2 Acq_PentaCXP12Area x: 8y: 1 5 3 Acq_PentaCXP12Area x: 8y: 1 5 4 Acq_PentaCXP12Area x: 8y: 1 5 5 Acq_PentaCXP12Area x: 8y: 1 2 1 Acq_DualCXP12Area<sup>a</sup> x: 16y: 1 2 2 Acq_DualCXP12Area<sup>a</sup> x: 16y: 1 2 1 1 Acq_DualCXP12Area x: 16y: 1 2 1 Acq_DualCXP12Area x: 16y: 1 2 2 Acq_DualCXP12Area x: 16y: 1 1 1 Acq_SingleCXP12Area<sup>a</sup> x: 32y: 1 1 1 Acq_SingleCXP12Area<sup>b</sup> x: 32y: 1 1 1 Acq_SingleCXP12Area x: 32y: 1"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#specifications-common-to-all-area-scan-acquisition-applets","title":"Specifications Common to All Area Scan Acquisition Applets","text":"Max. Image Size [px] 32k x 64k<sup>c</sup> CXP Ports 5 Max. CXP Speed CXP-12 Bit Depth Processing [bit] 16 (14 for Bayer Demosaicing) Bit Depth Output [bit] Mono8-16 RGB8-16 RGBa8 BGR8-16 BGRa8 Bayer8-14 YUV422_8 Mirroring Yes, horizontal and vertical Image Selector Yes Bayer Color Reconstruction (HQe) Yes, High Quality Extended (HQe) White Balance Yes LUT Full resolution Pixel Format Conversion RGB or Bayer to mono, Bayer or mono to RGB Bandwidth Total DMA [MB/s]<sup>d</sup> 7200"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#specifications-differing-between-area-scan-acquisition-applets","title":"Specifications Differing Between Area Scan Acquisition Applets","text":"ROI Step Size [px] Bandwidth: Mean per Camera [MP/s] Tap Geometry Sorting Acq_SingleCXP12Area x: 32y: 1 4850 1X-1Y, 1X-2YE Acq_DualCXP12Area x: 16y: 1 2400 1X-1Y, 1X-2YE Acq_PentaCXP12Area x: 8y: 1 1200 1X-1Y only"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#line-scan-acquisition-applets","title":"Line Scan Acquisition Applets","text":"<p>The following Line Scan Acquisition Applets are available:</p> <ul> <li>Acq_SingleCXP12Line</li> <li>Acq_DualCXP12Line</li> <li>Acq_PentaCXP12Line</li> </ul> <p>The denominators \"single\", \"dual\", and \"penta\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Line Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#choosing-the-right-line-scan-acquisition-applet","title":"Choosing the Right Line Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the camera may not work or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Max. Number of Cameras Number of 1-Channel Cameras Number of 2-Channel Cameras Number of 4-Channel Cameras Applet ROI Step Size [px] 5 1 Acq_PentaCXP12Line x: 8y: 1 5 2 Acq_PentaCXP12Line x: 8y: 1 5 3 Acq_PentaCXP12Line x: 8y: 1 5 4 Acq_PentaCXP12Line x: 8y: 1 5 5 Acq_PentaCXP12Line x: 8y: 1 2 1 Acq_DualCXP12Line<sup>e</sup> x: 16y: 1 2 2 Acq_DualCXP12Line<sup>e</sup> x: 16y: 1 2 1 1 Acq_DualCXP12Line x: 16y: 1 2 1 Acq_DualCXP12Line x: 16y: 1 2 2 Acq_DualCXP12Line x: 16y: 1 1 1 Acq_SingleCXP12Line<sup>e</sup> x: 32y: 1 1 1 Acq_SingleCXP12Line<sup>f</sup> x: 32y: 1 1 1 Acq_SingleCXP12Line x: 32y: 1"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#specifications-common-to-all-line-scan-acquisition-applets","title":"Specifications Common to All Line Scan Acquisition Applets","text":"Max. Image Size [px] 32k x 8M<sup>c</sup> Camera Ports 5 Camera Type CXP-12 Bit Depth Processing [bit] 16 (12 bit for BiColor to BGR/RGB conversion) Bit Depth Output [bit] Mono8-16 RGB8-16 RGBa8 BGR8-16 BGRa8 BiColor8-12  YUV422_8 Mirroring Yes, horizontal and vertical Tap Geometry Sorting 1X-1Y only Image Selector Yes Color Array Filter Yes, two lines BiColor White Balance Yes LUT Full resolution Pixel Format Conversion RGB or BiColor to mono, mono or BiColor to RGB Bandwidth: Total DMA [MB/s]<sup>d</sup> 7200"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#specifications-differing-between-line-scan-acquisition-applets","title":"Specifications Differing Between Line Scan Acquisition Applets","text":"ROI Step Size [px] Bandwidth: Mean per Camera [MP/s] Acq_SingleCXP12Line x: 32y: 1 4850 Acq_DualCXP12Line x: 16y: 1 2400 Acq_PentaCXP12Line x: 8y: 1 1200"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#frame-grabber-test-applet_1","title":"Frame Grabber Test Applet","text":"<p>This applet is a frame grabber test applet. Its purpose is to test the hardware.</p> <p>The applet offers the following features:</p> Feature Explanation DMA Performance Test Tests different image dimensions for varying memory sizes and interrupt rates RAM Test Checks for errors and processing Check Camera Port Image Acquisition Checks camera port image acquisition Send Trigger Signals to Camera Sends trigger signals to camera GPIO Monitoring Monitors the GPIs and set the GPOs Event Test Generates a software callback event General Monitoring Monitors FPGA temperature, power management, PoCXP, etc. DMAfromPC Transmits an image via DMA to the frame grabber."},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#using-acquisition-applets","title":"Using Acquisition Applets","text":""},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#using-acquisition-applets-with-the-framegrabber-sdk","title":"Using Acquisition Applets with the Framegrabber SDK","text":"<p>Find here general information about using the applets with the Framegrabber SDK:  Acquisition Applets.</p>"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#installing-applets","title":"Installing Applets","text":"<p>Before you can use a specific applet on your frame grabber, you need to install it on the frame grabber. Instructions for installing the applets are available at Managing Applets (microDiagnostics).</p>"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#adding-an-applet-manually","title":"Adding an Applet Manually","text":"<p>To add an applet you received as *.dll file (and not in form of an installer) to your host file system:</p> <ol> <li>Get the applet file (*.dll) you have received.</li> <li>Copy this file into the following directory: &lt;Framegrabber SDK installation directory&gt;/Dll/&lt;frame grabber model&gt;</li> </ol> <p>Now you can use the new applet.</p>"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#testing-image-acquisition","title":"Testing Image Acquisition","text":"<p>Before you start using an applet in your own software (via API), you might want to test the system set-up or an individual applet (and its parametrization options).</p> <p>For this purpose, you are provided with the tool microDisplay X that has been installed on your host computer as part of the Framegrabber SDK environment. For instructions how to load and test your applet, see Configuring the Applet (microDisplay X).</p>"},{"location":"acquisition-applets-for-imaFlex-cxp-12-penta.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration. For more information, see Other Tasks (microDisplay X).</p> <ol> <li> <p>Only recommended, if you need to mirror an image with more than 5456 pixels. Otherwise use PentaCXP12Area.\u00a0\u21a9\u21a9\u21a9</p> </li> <li> <p>Only recommended, if you need to mirror an image with more than 21840 pixels. Otherwise use DualCXP12Area.\u00a0\u21a9</p> </li> <li> <p>k Px and M Px in this case refer to a binary format. Examples for binary calculations are:</p> <p>16M px = 16384k px = 16777216 px</p> <p>8M px = 8192k px = 8388608 px</p> <p>64k px = 65536 px</p> <p>48k px = 49152 px</p> <p>32k px = 32768 px</p> <p>16k px = 16384 px\u00a0\u21a9\u21a9</p> </li> <li> <p>The actual DMA bandwidth depends on the specific mainboard and chip set of the host computer.\u00a0\u21a9\u21a9</p> </li> <li> <p>Only recommended, if you need to mirror an image with more than 8k pixels. Otherwise use PentaCXP12Line.\u00a0\u21a9\u21a9\u21a9</p> </li> <li> <p>Only recommended, if you need to mirror an image with more than 21840 pixels. Otherwise use DualCXP12Line.\u00a0\u21a9</p> </li> </ol>"},{"location":"acquisition-applets-for-imaflex-cxp-12.html","title":"Applets for imaFlex CXP-12 Quad","text":"<p>This topic tells you about the acquisition applets available for the imaFlex CXP-12 Quad frame grabber.</p> <p>To ensure optimum use of system resources, not all image acquisition and processing features designed for imaFlex CXP-12 Quad are loaded onto imaFlex CXP-12 Quad simultaneously. Instead, Basler provides various compilations of specific image acquisition and processing features that are combined to meet the requirements of a specific application field.</p> <p>Typically, an applet supports a specific camera interface standard and topology, specific image acquisition features, and possibly specific image (pre-)processing features. By loading an applet onto the frame grabber, you define the functionality of the frame grabber and adapt it to the requirements of your specific application.</p> <p>There are two kinds of applets: acquisition applets (*.dll) always delivered by Basler, and custom applets (*.hap) developed in VisualApplets either by yourself or by Basler. In addition to the acquisition applets that are included in the delivery, imaFlex CXP-12 Quad can be programmed to fulfill highly specific image processing tasks that are required by a specific application. The programming can be done by Basler, a certified partner, or by yourself using the easy-to-use graphical FPGA programming environment VisualApplets.</p> <p>The acquisition applets for imaFlex CXP-12 Quad are included in the Framegrabber SDK and also in the pylon Software Suite.</p> <p>In addition to the Acqusition Applets, you can also use the Enhanced Applets. The Enhanced Applets are a prototype and are only available upon request via your local Basler Sales representative or field application engineer. All Enhanced Applets have the additional features:</p> <ul> <li>Binning (currently only monochrome) of up to 4x4</li> <li>Block-based flat field correction (FFC) for monochrome cameras</li> <li>PGI high quality Debayering and image quality improvements</li> </ul>"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#requirements","title":"Requirements","text":"<ul> <li>Host software: Framegrabber SDK version 5.11.2 or higher</li> <li>Hardware: An imaFlex CXP-12 Quad frame grabber is connected to your system</li> </ul> <p>Limitation</p> <p>In all applets, buffers larger than 4GB can't be allocated. Even if the applet allows a larger buffer size, you can't allocate buffers larger than 4GB due to limitations in the driver and firmware.</p> <p>You can calculate the buffer size as follows:</p> <p>Buffer size = image height * image width * (pixel width / 8).</p> <p>For RGB images: buffer size = (image height * image width * (pixel width / 8)) * 3 .</p>"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#documentation","title":"Documentation","text":"<p>The following sections provide links to the acquisition applets documentation:</p>"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#area-acquisition-applets","title":"Area Acquisition Applets","text":"GenTL Fglib Acq_SingleCXP12Area PDF Acq_SingleCXP12Area PDF Acq_DualCXP12Area PDF Acq_DualCXP12Area PDF Acq_TripleCXP12Area PDF Acq_TripleCXP12Area PDF Acq_QuadCXP12Area PDF Acq_QuadCXP12Area PDF"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#line-acquisition-applets","title":"Line Acquisition Applets","text":"GenTL Fglib Acq_SingleCXP12Line PDF Acq_SingleCXP12Line PDF Acq_DualCXP12Line PDF Acq_DualCXP12Line PDF Acq_TripleCXP12Line PDF Acq_TripleCXP12Line PDF Acq_QuadCXP12line PDF Acq_QuadCXP12line PDF"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#frame-grabber-test-applet","title":"Frame Grabber Test Applet","text":"GenTL Fglib Frame Grabber Test Applet PDF Frame Grabber Test Applet PDF"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#area-scan-acquisition-applets","title":"Area Scan Acquisition Applets","text":"<p>The following Area Scan Acquisition Applets are available:</p> <ul> <li>Acq_SingleCXP12Area</li> <li>Acq_DualCXP12Area</li> <li>Acq_TripleCXP12Area</li> <li>Acq_QuadCXP12Area</li> </ul> <p>The denominators \"single\", \"dual\", \"triple\", and \"quad\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Area Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#choosing-the-right-area-scan-acquisition-applet","title":"Choosing the Right Area Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the image received from the camera can't be processed or displayed correctly or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Max. Number of Cameras Number of 1-Channel Cameras Number of 2-Channel Cameras Number of 4-Channel Cameras Applet ROI Step Size [px] 4 1 Acq_QuadCXP12Area x: 8y: 1 4 2 Acq_QuadCXP12Area x: 8y: 1 4 3 Acq_QuadCXP12Area x: 8y: 1 4 4 Acq_QuadCXP12Area x: 8y: 1 3 1 Acq_TripleCXP12Area<sup>a</sup> x: 16/8/8y: 1 3 2 Acq_TripleCXP12Area<sup>a</sup> x: 16/8/8y: 1 3 3 Acq_TripleCXP12Area<sup>a</sup> x: 16/8/8y: 1 3 1 Acq_TripleCXP12Area<sup>b</sup> x: 16/8/8y: 1 3 1 1 Acq_TripleCXP12Area x: 16/8/8y: 1 3 2 1 Acq_TripleCXP12Area x: 16/8/8y: 1 2 1 Acq_DualCXP12Area<sup>a</sup> x: 16y: 1 2 2 Acq_DualCXP12Area<sup>a</sup> x: 16y: 1 2 1 1 Acq_DualCXP12Area x: 16y: 1 2 1 Acq_DualCXP12Area<sup>c</sup> x: 16y: 1 2 2 Acq_DualCXP12Area x: 16y: 1 1 1 Acq_SingleCXP12Area<sup>a</sup> x: 32y: 1 1 1 Acq_SingleCXP12Area<sup>d</sup> x: 32y: 1 1 1 Acq_SingleCXP12Area x: 32y: 1"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#specifications-common-to-all-area-scan-acquisition-applets","title":"Specifications Common to All Area Scan Acquisition Applets","text":"Max. Image Size [px] 32k x 64k<sup>e</sup> Camera Ports 4 Camera Type CXP-12 Bit Depth Processing [bit] 16 (14 for Bayer Demosaicing) Bit Depth Output [bit] Mono8-16 RGB8-16 RGBa8 BGR8-16 BGRa8 Bayer8-14 YUV422_8 Mirroring Yes, horizontal and vertical Image Selector Yes Bayer Color Reconstruction (HQe) Yes, High Quality Extended (HQe) White Balance Yes LUT Full resolution Pixel Format Conversion RGB or Bayer to mono, Bayer or mono to RGB Bandwidth Total DMA [MB/s] <sup>f</sup> 7200"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#specifications-differing-between-area-scan-acquisition-applets","title":"Specifications Differing Between Area Scan Acquisition Applets","text":"ROI Step Size [px] Bandwidth: Mean per Camera [MP/s] Tap Geometry Sorting Acq_SingleCXP12Area x: 32y: 1 4850 1X-1Y, 1X-2YE Acq_DualCXP12Area x: 16y: 1 2400 1X-1Y, 1X-2YE Acq_TripleCXP12Area x: 8y: 1 1200 for the first two cameras 2400 for the third camera 1X-1Y only Acq_QuadCXP12Area x: 8y: 1 1200 1X-1Y only"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#line-scan-acquisition-applets","title":"Line Scan Acquisition Applets","text":"<p>The following Line Scan Acquisition Applets are available:</p> <ul> <li>Acq_SingleCXP12Line</li> <li>Acq_DualCXP12Line</li> <li>Acq_TripleCXP12Line</li> <li>Acq_QuadCXP12Line</li> </ul> <p>The denominators \"single\", \"dual\", \"triple\", and \"quad\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Line Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#choosing-the-right-line-scan-acquisition-applet","title":"Choosing the Right Line Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the camera may not work or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Max. Number of Cameras Number of 1-Channel Cameras Number of 2-Channel Cameras Number of 4-Channel Cameras Applet ROI Step Size [px] 4 1 Acq_QuadCXP12Line x: 8y: 1 4 2 Acq_QuadCXP12Line x: 8y: 1 4 3 Acq_QuadCXP12Line x: 8y: 1 4 4 Acq_QuadCXP12Line x: 8y: 1 3 1 Acq_TripleCXP12Line<sup>g</sup> x: 16/8/8y: 1 3 2 Acq_TripleCXP12Line<sup>g</sup> x: 16/8/8y: 1 3 2 Acq_TripleCXP12Line<sup>g</sup> x: 16/8/8y: 1 3 1 Acq_TripleCXP12Line<sup>h</sup> x: 16/8/8y: 1 3 1 1 Acq_TripleCXP12Line x: 16/8/8y: 1 3 2 1 Acq_TripleCXP12Line x: 16/8/8y: 1 2 1 Acq_DualCXP12Line<sup>g</sup> x: 16y: 1 2 2 Acq_DualCXP12Line<sup>g</sup> x: 16y: 1 2 1 Acq_DualCXP12Line x: 16y: 1 2 1 Acq_DualCXP12Line<sup>i</sup> x: 16y: 1 2 2 Acq_DualCXP12Line x: 16y: 1 1 1 Acq_SingleCXP12Line x: 32y: 1 1 1 Acq_SingleCXP12Line x: 32y: 1 1 1 Acq_SingleCXP12Line x: 32y: 1"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#specifications-common-to-all-line-scan-acquisition-applets","title":"Specifications Common to All Line Scan Acquisition Applets","text":"Max. Image Size [px] 32k x 8M<sup>e</sup> Camera Ports 4 Camera Type CXP-12 Bit Depth Processing [bit] 16 (12 bit for BiColor to BGR/RGB conversion) Bit Depth Output [bit] Mono8-16 RGB8-16 RGBa8 BGR8-16 BGRa8 BiColor8-12 YUV422_8 Mirroring Yes, horizontal and vertical Tap Geometry Sorting 1X-1Y only Image Selector Yes Color Array Filter Yes, two lines BiColor White Balance No LUT Full resolution Pixel Format Conversion RGB or BiColor to mono, mono or BiColor to RGB Bandwidth: Total DMA [MB/s] <sup>f</sup> 7200"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#specifications-differing-between-line-scan-acquisition-applets","title":"Specifications Differing Between Line Scan Acquisition Applets","text":"ROI Step Size [px] Bandwidth: Mean per Camera [MP/s] Acq_SingleCXP12Line x: 32y: 1 4850 Acq_DualCXP12Line x: 16y: 1 2400 Acq_TripleCXP12Line x: 16y: 1 1200 for the first two cameras 2400 for the third camera Acq_QuadCXP12Line x: 4y: 1 1200"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#frame-grabber-test-applet_1","title":"Frame Grabber Test Applet","text":"<p>This applet is a frame grabber test applet. Its purpose is to test the hardware.</p> <p>The applet offers the following features:</p> Feature Explanation DMA Performance Test Tests different image dimensions for varying memory sizes and interrupt rates RAM Test Checks for errors and processing Check Camera Port Image Acquisition Checks camera port image acquisition Send Trigger Signals to Camera Sends trigger signals to camera GPIO Monitoring Monitors the GPIs and set the GPOs Event Test Generates a software callback event General Monitoring Monitors FPGA temperature, power management, PoCXP, etc."},{"location":"acquisition-applets-for-imaflex-cxp-12.html#using-acquisition-applets","title":"Using Acquisition Applets","text":""},{"location":"acquisition-applets-for-imaflex-cxp-12.html#using-acquisition-applets-with-the-framegrabber-sdk","title":"Using Acquisition Applets with the Framegrabber SDK","text":"<p>Find here general information about using the applets with the Framegrabber SDK:  Acquisition Applets.</p>"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#installing-applets","title":"Installing Applets","text":"<p>Before you can use a specific applet on your frame grabber, you need to install it on the frame grabber. Instructions for installing the applets are available at Managing Applets (microDiagnostics).</p>"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#adding-an-applet-manually","title":"Adding an Applet Manually","text":"<p>To add an applet you received as *.dll file (and not in form of an installer) to your host file system:</p> <ol> <li>Get the applet file (*.dll) you have received.</li> <li>Copy this file into the following directory: &lt;Framegrabber SDK installation directory&gt;/Dll/&lt;frame grabber model&gt;</li> </ol> <p>Now you can use the new applet.</p>"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#testing-image-acquisition","title":"Testing Image Acquisition","text":"<p>Before you start using an applet in your own software (via API), you might want to test the system set-up or an individual applet (and its parametrization options).</p> <p>For this purpose, you are provided with the tool microDisplay X that has been installed on your host computer as part of the Framegrabber SDK environment. For instructions how to load and test your applet, see Configuring the Applet (microDisplay X).</p>"},{"location":"acquisition-applets-for-imaflex-cxp-12.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration. For more information, see Other Tasks (microDisplay X).</p> <ol> <li> <p>Only recommended, if you need to mirror an image with more than 8K pixel. Otherwise, use QuadCXP12Area.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Not recommended, use DualCXP12Area instead.\u00a0\u21a9</p> </li> <li> <p>Only recommended, if you need to mirror an image with more than 8K pixel. Otherwise, use TripleCXP12Area (single-channel camera only).\u00a0\u21a9</p> </li> <li> <p>Only recommended, if you need to mirror an image with more than 21840 pixel. Otherwise, use DualCXP12Area.\u00a0\u21a9</p> </li> <li> <p>k Px and M Px in this case refer to a binary format. Examples for binary calculations are:</p> <p>16M px = 16384k px = 16777216 px</p> <p>8M px = 8192k px = 8388608 px</p> <p>64k px = 65536 px</p> <p>48k px = 49152 px</p> <p>32k px = 32768 px</p> <p>16k px = 16384 px\u00a0\u21a9\u21a9</p> </li> <li> <p>The actual DMA bandwidth depends on the specific mainboard and chip set of the host computer.\u00a0\u21a9\u21a9</p> </li> <li> <p>Only recommended, if you need to mirror an image with more than 8K pixel. Otherwise, use QuadCXP12Line.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Not recommended, use DualCXP12Line instead.\u00a0\u21a9</p> </li> <li> <p>Only recommended, if you need to mirror an image with more than 8K pixel. Otherwise, use TripleCXP12Line (single-channel camera only).\u00a0\u21a9</p> </li> </ol>"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html","title":"Acquisition Applets for imaWorx CXP-12 Quad","text":"<p>This topic tells you about the acquisition applets available for the imaWorx CXP-12 Quad frame grabber.</p> <p>The functionality of a frame grabber is defined by a specific hardware-related program. This hardware implementation is called applet. For each frame grabber, several applets are available.</p> <p>By loading an applet onto the frame grabber, you define the functionality of the frame grabber and adapt it to the requirements of your specific application.</p> <p>The acquisition applets for imaWorx CXP-12 Quad are included in the Framegrabber SDK and also in the pylon Software Suite.</p> <p>On imaWorx CXP-12 Quad all delivered applets already are on the imaWorx CXP-12 Quad frame grabber, but only one is activated. If you want to activate a different applet on the imaWorx CXP-12 Quad, follow the instructions to Activate the Applet with the Framegrabber SDK or Configuring the Frame Grabber Using pylon.</p> <p>In addition to the Acqusition Applets, you can also use the Enhanced Applets. The Enhanced Applets are a prototype and are only available upon request via your local Basler Sales representative or field application engineer. All Enhanced Applets have the additional features:</p> <ul> <li>Binning (currently only monochrome) of up to 4x4</li> <li>Block-based flat field correction (FFC) for monochrome cameras</li> <li>PGI high quality Debayering and image quality improvements</li> </ul>"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#requirements","title":"Requirements","text":"<ul> <li>Host software: Framegrabber SDK (version 5.9 or higher) or pylon Software Suite (version 6.3 or higher) with hardware-dependent acquisition applets</li> <li>Hardware: An imaWorx CXP-12 Quad frame grabber is connected to your system</li> </ul> <p>Limitation</p> <p>In all applets, buffers larger than 4GB can't be allocated. Even if the applet allows a larger buffer size, you can't allocate buffers larger than 4GB due to limitations in the driver and firmware.</p> <p>You can calculate the buffer size as follows:</p> <p>Buffer size = image height * image width * (pixel width / 8).</p> <p>For RGB images: buffer size = (image height * image width * (pixel width / 8)) * 3 .</p>"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#documentation","title":"Documentation","text":"<p>The following sections provide links to the acquisition applets documentation:</p>"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#area-acquisition-applets","title":"Area Acquisition Applets","text":"GenTL Fglib Acq_SingleCXP12Area PDF Acq_SingleCXP12Area PDF Acq_DualCXP12Area PDF Acq_DualCXP12Area PDF Acq_TripleCXP12Area PDF Acq_TripleCXP12Area PDF Acq_QuadCXP12Area PDF Acq_QuadCXP12Area PDF"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#line-acquisition-applets","title":"Line Acquisition Applets","text":"GenTL Fglib Acq_SingleCXP12Line PDF Acq_SingleCXP12Line PDF Acq_DualCXP12Line PDF Acq_DualCXP12Line PDF Acq_TripleCXP12Line PDF Acq_TripleCXP12Line PDF Acq_QuadCXP12line PDF Acq_QuadCXP12line PDF"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#frame-grabber-test-applet","title":"Frame Grabber Test Applet","text":"GenTL Fglib Frame Grabber Test Applet PDF Frame Grabber Test Applet PDF"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#area-scan-acquisition-applets","title":"Area Scan Acquisition Applets","text":"<p>The following Area Scan Acquisition Applets are available:</p> <ul> <li>Acq_SingleCXP12Area</li> <li>Acq_DualCXP12Area</li> <li>Acq_TripleCXP12Area</li> <li>Acq_QuadCXP12Area</li> </ul> <p>The denominators \"single\", \"dual\", \"triple\", and \"quad\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Area Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#choosing-the-right-area-scan-acquisition-applet","title":"Choosing the Right Area Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the image received from the camera can't be processed or displayed correctly or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Max. Number of Cameras Number of 1-Channel Cameras Number of 2-Channel Cameras Number of 4-Channel Cameras Applet ROI Step Size [px] 4 1 Acq_QuadCXP12Area x: 8y: 1 4 2 Acq_QuadCXP12Area x: 8y: 1 4 3 Acq_QuadCXP12Area x: 8y: 1 4 4 Acq_QuadCXP12Area x: 8y: 1 3 1 Acq_TripleCXP12Area<sup>a</sup> x: 16/8/8y: 1 3 2 Acq_TripleCXP12Area<sup>a</sup> x: 16/8/8y: 1 3 3 Acq_TripleCXP12Area<sup>a</sup> x: 16/8/8y: 1 3 1 Acq_TripleCXP12Area<sup>b</sup> x: 16/8/8y: 1 3 1 1 Acq_TripleCXP12Area x: 16/8/8y: 1 3 2 1 Acq_TripleCXP12Area x: 16/8/8y: 1 2 1 Acq_DualCXP12Area<sup>a</sup> x: 16y: 1 2 2 Acq_DualCXP12Area<sup>a</sup> x: 16y: 1 2 1 1 Acq_DualCXP12Area x: 16y: 1 2 1 Acq_DualCXP12Area<sup>c</sup> x: 16y: 1 2 2 Acq_DualCXP12Area x: 16y: 1 1 1 Acq_SingleCXP12Area<sup>a</sup> x: 32y: 1 1 1 Acq_SingleCXP12Area<sup>d</sup> x: 32y: 1 1 1 Acq_SingleCXP12Area x: 32y: 1"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#specifications-common-to-all-area-scan-acquisition-applets","title":"Specifications Common to All Area Scan Acquisition Applets","text":"Max. Image Size [px] 32k x 64k<sup>e</sup> Camera Ports 4 Camera Type CXP-12 Bit Depth Processing [bit] 16 (14 for Bayer Demosaicing) Bit Depth Output [bit] Mono8-16 RGB8-16 RGBa8 BGR8-16 BGRa8 Bayer8-14 YUV422_8 Mirroring Yes, horizontal and vertical Image Selector Yes Bayer Color Reconstruction (HQe) Yes, High Quality Extended (HQe) White Balance Yes LUT Full resolution Pixel Format Conversion RGB or Bayer to mono, Bayer or mono to RGB Bandwidth Total DMA [MB/s] <sup>f</sup> 7200"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#specifications-differing-between-area-scan-acquisition-applets","title":"Specifications Differing Between Area Scan Acquisition Applets","text":"ROI Step Size [px] Bandwidth: Mean per Camera [MP/s] Tap Geometry Sorting Acq_SingleCXP12Area x: 32y: 1 4850 1X-1Y, 1X-2YE Acq_DualCXP12Area x: 16y: 1 2400 1X-1Y, 1X-2YE Acq_TripleCXP12Area x: 8y: 1 1200 for the first two cameras 2400 for the third camera 1X-1Y only Acq_QuadCXP12Area x: 8y: 1 1200 1X-1Y only"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#line-scan-acquisition-applets","title":"Line Scan Acquisition Applets","text":"<p>The following Line Scan Acquisition Applets are available:</p> <ul> <li>Acq_SingleCXP12Line</li> <li>Acq_DualCXP12Line</li> <li>Acq_TripleCXP12Line</li> <li>Acq_QuadCXP12Line</li> </ul> <p>The denominators \"single\", \"dual\", \"triple\", and \"quad\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Line Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#choosing-the-right-line-scan-acquisition-applet","title":"Choosing the Right Line Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the camera may not work or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Max. Number of Cameras Number of 1-Channel Cameras Number of 2-Channel Cameras Number of 4-Channel Cameras Applet ROI Step Size [px] 4 1 Acq_QuadCXP12Line x: 8y: 1 4 2 Acq_QuadCXP12Line x: 8y: 1 4 3 Acq_QuadCXP12Line x: 8y: 1 4 4 Acq_QuadCXP12Line x: 8y: 1 3 1 Acq_TripleCXP12Line<sup>g</sup> x: 16/8/8y: 1 3 2 Acq_TripleCXP12Line<sup>g</sup> x: 16/8/8y: 1 3 3 Acq_TripleCXP12Line<sup>g</sup> x: 16/8/8y: 1 3 1 Acq_TripleCXP12Line<sup>h</sup> x: 16/8/8y: 1 3 1 1 Acq_TripleCXP12Line x: 16/8/8y: 1 3 2 1 Acq_TripleCXP12Line x: 16/8/8y: 1 2 1 Acq_DualCXP12Line<sup>g</sup> x: 16y: 1 2 2 Acq_DualCXP12Line<sup>g</sup> x: 16y: 1 2 1 Acq_DualCXP12Line x: 16y: 1 2 1 1 Acq_DualCXP12Line<sup>i</sup> x: 16y: 1 2 2 Acq_DualCXP12Line x: 16y: 1 1 1 Acq_SingleCXP12Line x: 32y: 1 1 1 Acq_SingleCXP12Line x: 32y: 1 1 1 Acq_SingleCXP12Line x: 32y: 1"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#specifications-common-to-all-line-scan-acquisition-applets","title":"Specifications Common to All Line Scan Acquisition Applets","text":"Max. Image Size [px] 32k x 8M<sup>e</sup> Camera Ports 4 Camera Type CXP-12 Bit Depth Processing [bit] 16 (12 bit for BiColor to BGR/RGB conversion) Bit Depth Output [bit] Mono8-16 RGB8-16 RGBa8 BGR8-16 BGRa8 BiColor8-12 YUV422_8 Mirroring Yes, horizontal and vertical Tap Geometry Sorting 1X-1Y only Image Selector Yes Color Array Filter Yes, two lines BiColor White Balance No LUT Full resolution Pixel Format Conversion RGB or BiColor to mono, mono or BiColor to RGB Bandwidth: Total DMA [MB/s] <sup>f</sup> 7200"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#specifications-differing-between-line-scan-acquisition-applets","title":"Specifications Differing Between Line Scan Acquisition Applets","text":"ROI Step Size [px] Bandwidth: Mean per Camera [MP/s] Acq_SingleCXP12Line x: 32y: 1 4850 Acq_DualCXP12Line x: 16y: 1 2400 Acq_TripleCXP12Line x: 16y: 1 1200 for the first two cameras 2400 for the third camera Acq_QuadCXP12Line x: 4y: 1 1200"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#frame-grabber-test-applet_1","title":"Frame Grabber Test Applet","text":"<p>This applet is a frame grabber test applet. Its purpose is to test the hardware.</p> <p>The applet offers the following features:</p> Feature Explanation DMA Performance Test Tests different image dimensions for varying memory sizes and interrupt rates RAM Test Checks for errors and processing Check Camera Port Image Acquisition Checks camera port image acquisition Send Trigger Signals to Camera Sends trigger signals to camera GPIO Monitoring Monitors the GPIs and set the GPOs Event Test Generates a software callback event General Monitoring Monitors FPGA temperature, power management, PoCXP, etc."},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#using-acquisition-applets","title":"Using Acquisition Applets","text":""},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#using-acquisition-applets-with-the-framegrabber-sdk","title":"Using Acquisition Applets with the Framegrabber SDK","text":"<p>Find here general information about using the applets with the Framegrabber SDK:  Acquisition Applets.</p>"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#installing-applets","title":"Installing Applets","text":"<p>Before you can use a specific applet on your frame grabber, you must install it on the frame grabber. Instructions for installing the applets are available at Managing Applets (microDiagnostics).</p>"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#adding-an-applet-manually","title":"Adding an Applet Manually","text":"<p>To add an applet you received as *.dll file (and not in form of an installer) to your host file system:</p> <ol> <li>Get the applet file (*.dll) you have received.</li> <li>Copy this file into the following directory: &lt;Framegrabber SDK directory&gt;/Dll/&lt;Frame grabber model&gt;</li> </ol> <p>Now you can use the new applet.</p>"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#testing-image-acquisition","title":"Testing Image Acquisition","text":"<p>Before you start using an applet in your own software (via API), you might want to test the system set-up or an individual applet (and its parametrization options).</p> <p>For this purpose, you are provided with the tool microDisplay X that has been installed on your computer as part of the Framegrabber SDK environment. For instructions how to load and test your applet, see Configuring the Applet (microDisplay X).</p>"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration. For more information, see Other Tasks (microDisplay X).</p>"},{"location":"acquisition-applets-for-imaworx-cxp-12-quad.html#using-acquisition-applets-with-pylon","title":"Using Acquisition Applets with pylon","text":"<p>If you want to use the applets with pylon, see Configuring the Frame Grabber Using pylon.</p> <ol> <li> <p>Only recommended, if you need to mirror an image with more than 8K pixel. Otherwise, use QuadCXP12Area.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Not recommended, use DualCXP12Area instead.\u00a0\u21a9</p> </li> <li> <p>Only recommended, if you need to mirror an image with more than 8K pixel. Otherwise, use TripleCXP12Area (single-channel camera only).\u00a0\u21a9</p> </li> <li> <p>Only recommended, if you need to mirror an image with more than 21840 pixel. Otherwise, use DualCXP12Area.\u00a0\u21a9</p> </li> <li> <p>k Px and M Px in this case refer to a binary format. Examples for binary calculations are:</p> <p>16M px = 16384k px = 16777216 px</p> <p>8M px = 8192k px = 8388608 px</p> <p>64k px = 65536 px</p> <p>48k px = 49152 px</p> <p>32k px = 32768 px</p> <p>16k px = 16384 px\u00a0\u21a9\u21a9</p> </li> <li> <p>The actual DMA bandwidth depends on the specific mainboard and chip set of the host computer.\u00a0\u21a9\u21a9</p> </li> <li> <p>Only recommended, if you need to mirror an image with more than 8K pixel. Otherwise, use QuadCXP12Line.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Not recommended, use DualCXP12Line instead.\u00a0\u21a9</p> </li> <li> <p>Only recommended, if you need to mirror an image with more than 8K pixel. Otherwise, use TripleCXP12Line (single-channel camera only).\u00a0\u21a9</p> </li> </ol>"},{"location":"acquisition-applets-for-marathon-acl.html","title":"Acquisition Applets for marathon ACL","text":"<p>This topic tells you about the acquisition applets available for the marathon ACL frame grabber.</p> <p>The functionality of a frame grabber is defined by a specific hardware-related program. This hardware implementation is called applet. For each frame grabber, several applets are available.</p> <p>By loading an applet onto the frame grabber, you define the functionality of the frame grabber and adapt it to the requirements of your specific application.</p> <p>The acquisition applets for marathon ACL are included in the Framegrabber SDK.</p> <p>On marathon frame grabbers, an applet is available as soon as it is flashed onto the frame grabber.</p>"},{"location":"acquisition-applets-for-marathon-acl.html#requirements","title":"Requirements","text":"<ul> <li>Host software: Framegrabber SDK (5.7, 5.10<sup>a</sup>, or higher) with hardware-dependent acquisition applets</li> <li>Hardware: A marathon ACL frame grabber is connected to your system</li> </ul> <p>Limitation</p> <p>In all applets, buffers larger than 4GB can't be allocated. Even if the applet allows a larger buffer size, you can't allocate buffers larger than 4GB due to limitations in the driver and firmware.</p> <p>You can calculate the buffer size as follows:</p> <p>Buffer size = image height * image width * (pixel width / 8).</p> <p>For RGB images: buffer size = (image height * image width * (pixel width / 8)) * 3 .</p>"},{"location":"acquisition-applets-for-marathon-acl.html#documentation","title":"Documentation","text":"<p>The following sections provide links to the acquisition applets documentation:</p> Area Acquisition Applets Line Acquisition Applets Test Applet Acq_SingleBaseAreaBayer PDF Acq_SingleBaseAreaGray PDF Acq_SingleBaseLineGray PDF Acq_SingleBaseAreaRGB PDF Acq_SingleBaseLineRGB Acq_SingleFullAreaBayer PDF Acq_SingleFullLineBayer_RB_GG PDF Acq_SingleFullLineBayer_RG_GB PDF Acq_SingleFullAreaGray PDF Acq_SingleFullLineGray PDF Acq_SingleFullAreaRGB PDF Acq_SingleFullLineRGB PDF Acq_SingleMediumAreaBayer PDF Acq_SingleMediumAreaGray PDF Acq_SingleMediumLineGray PDF Acq_SingleMediumAreaRGB PDF Acq_SingleMediumLineRGB PDF Acq_DualBaseAreaBayer PDF Acq_DualBaseLineBayer_RG_GB PDF Acq_DualBaseAreaGray PDF Acq_DualBaseLineGray PDF Acq_DualBaseAreaRGB PDF Acq_DualBaseLineRGB PDF FrameGrabberTest PDF"},{"location":"acquisition-applets-for-marathon-acl.html#area-scan-acquisition-applets","title":"Area Scan Acquisition Applets","text":"<p>The following Area Scan Acquisition Applets are available:</p> <ul> <li>Acq_DualBaseAreaBayer</li> <li>Acq_DualBaseAreaGray</li> <li>Acq_DualBaseAreaRGB</li> <li>Acq_SingleBaseAreaBayer</li> <li>Acq_SingleBaseAreaGray</li> <li>Acq_SingleBaseAreaRGB</li> <li>Acq_SingleFullAreaBayer</li> <li>Acq_SingleFullAreaGray</li> <li>Acq_SingleFullAreaRGB</li> <li>Acq_SingleMediumAreaBayer</li> <li>Acq_SingleMediumAreaGray</li> <li>Acq_SingleMediumAreaRGB</li> </ul> <p>The denominators \"single\" and \"dual\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Area Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-acl.html#choosing-the-right-area-scan-acquisition-applet","title":"Choosing the Right Area Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the image received from the camera can't be processed or displayed correctly or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 1 2 Bayer Pattern Acq_SingleBaseAreaBayer x: 4y: 1 1 1 2 Grayscale Acq_SingleBaseAreaGray x: 4y: 1 1 1 2 RGB Acq_SingleBaseAreaRGB x: 8y: 1 1 2 2 Bayer Pattern Acq_SingleFullAreaBayerAcq_SingleMediumAreaBayer x: 8; y: 1x: 4; y: 1 1 2 2 Grayscale Acq_SingleFullAreaGrayAcq_SingleMediumAreaGray x: 16; y: 1x: 4; y: 1 1 2 2 RGB Acq_SingleFullAreaRGBAcq_SingleMediumAreaRGB x: 4; y: 1x: 4; y: 1 2 1 2 Bayer Pattern Acq_DualBaseAreaBayer x: 4y: 1 2 1 2 Grayscale Acq_DualBaseAreaGray x: 4y: 1 2 1 2 RGB Acq_DualBaseAreaRGB x: 1y: 1"},{"location":"acquisition-applets-for-marathon-acl.html#specifications-common-to-all-area-scan-acquisition-applets","title":"Specifications Common to All Area Scan Acquisition Applets","text":"Max. Image Size [px] 16k x 64k<sup>b</sup> Camera Clock Max. 85 MHz Image Selector Yes LUT Full resolution"},{"location":"acquisition-applets-for-marathon-acl.html#specifications-differing-between-area-scan-acquisition-applets","title":"Specifications Differing Between Area Scan Acquisition Applets","text":"Camera Ports Camera Type ROI Step Size [px] Bit Depth Processing [bit] Bit Depth Output [bit] Mode Mirroring Tap Geometry Sorting Bayer Color Reconstruction (HQe) White Balance Bandwidth: Mean per Camera [MP/s] Bandwidth Total DMA [MB/s] <sup>c</sup> Acq_DualBaseAreaBayer 2 BASE x: 4y: 1 8 per color component BGR 24 Bayer Pattern Yes, horizontal and vertical 1, 2, 4  (horizontal and vertical) Yes, High Quality Extended (HQe) Yes 255 1800 Acq_DualBaseAreaGray 2 BASE x: 4y: 1 16 Grayscale 8, 10 packed, 12 packed, or 16 Grayscale Yes, horizontal and vertical 1, 2, 4  (horizontal and vertical) No No 255 900 Acq_DualBaseAreaRGB 2 BASE x: 1y: 1 8 per color component BGR 24 RGB Yes, horizontal and vertical 1, 2, 4  (horizontal and vertical) No Yes 85 900 Acq_SingleBaseAreaBayer 1 BASE x: 4y: 1 12 per color component BGR 24, 48 Bayer Pattern Yes, horizontal and vertical 1, 2, 4  (horizontal and vertical) Yes, High Quality Extended (HQe) Yes 255 1800 Acq_SingleBaseAreaGray 1 BASE x: 4y: 1 16 Grayscale 8, 16 Grayscale Yes, horizontal and vertical 1, 2, 4  (horizontal and vertical) No No 255 1800 Acq_SingleBaseAreaRGB 1 BASE x: 8y: 1 8 per color component BGR 24 RGB Yes, horizontal and vertical 1, 2, 4  (horizontal and vertical) No Yes 85 1800 Acq_SingleFullAreaBayer 1 FULL x: 8y: 1 10 per color component BGR 24,or 48 Bayer Pattern Yes, horizontal 8, 10  (horizontal) Yes, High Quality Extended (HQe) Yes 850 1800 Acq_SingleFullAreaGray 1 FULL x: 16y: 1 10 Gray-scale 8, 10 packed, or 16 Grayscale Yes, horizontal 8, 10  (horizontal) No No 850 1800 Acq_SingleFullAreaRGB 1 FULL x: 4y: 1 10 per color component BGR 24, or 48 RGB Yes, horizontal 1, 2, 4  (horizontal and vertical) No Yes 284 1800 Acq_SingleMediumAreaBayer 1 MEDIUM x: 4y: 1 12 per color component BGR 24, or 48 Bayer Pattern Yes, horizontal and vertical 1, 2, 4  (horizontal and vertical) Yes, High Quality Extended (HQe) Yes 340 1800 Acq_SingleMediumAreaGray 1 MEDIUM x: 4y: 1 12 Grayscale 8, or 16 Grayscale Yes, horizontal and vertical 1, 2, 4  (horizontal and vertical) No No 340 1800 Acq_SingleMediumAreaRGB 1 MEDIUM x: 4y: 1 12 per color component BGR 24, or 48 RGB Yes, horizontal and vertical 1, 2, 4  (horizontal and vertical) No Yes 170 1800"},{"location":"acquisition-applets-for-marathon-acl.html#line-scan-acquisition-applets","title":"Line Scan Acquisition Applets","text":"<p>The following Line Scan Acquisition Applets are available:</p> <ul> <li>Acq_SingleBaseLineGray</li> <li>Acq_SingleBaseLineRGB</li> <li>Acq_SingleFullLineBayer_RB_GG</li> <li>Acq_SingleFullLineBayer_RG_GB</li> <li>Acq_SingleFullLineGray</li> <li>Acq_SingleFullLineRGB</li> <li>Acq_SingleMediumLineGray</li> <li>Acq_SingleMediumLineRGB</li> <li>Acq_DualBaseLineBayer_RG_GB</li> <li>Acq_DualBaseLineGray</li> <li>Acq_DualBaseLineRGB</li> </ul> <p>The denominators \"single\" and \"dual\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Line Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-acl.html#choosing-the-right-line-scan-acquisition-applet","title":"Choosing the Right Line Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the camera may not work or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 1 2 Grayscale Acq_SingleBaseLineGray x: 4y: 1 1 1 2 RGB Acq_SingleBaseLineRGB x: 1y: 1 1 2 2 Bayer Pattern Acq_SingleFullLineBayer_RB_GGAcq_SingleFullLineBayer_RB_GB x: 8; y: 1x: 8; y: 1 1 2 2 Grayscale Acq_SingleFullLineGrayAcq_SingleMediumLineGray x: 8; y: 1x: 8; y: 1 1 2 2 RGB Acq_SingleFullLineRGBAcq_SingleMediumLineRGB x: 4; y: 1x: 4; y: 1 2 1 2 Bayer Pattern Acq_DualBaseLineBayer_RG_GB x: 4y: 1 2 1 2 Grayscale Acq_DualBaseLineGray x: 4y: 1 2 1 2 RGB Acq_DualBaseLineRGB x: 1y: 1"},{"location":"acquisition-applets-for-marathon-acl.html#specifications-common-to-all-line-scan-acquisition-applets","title":"Specifications Common to All Line Scan Acquisition Applets","text":"Camera Clock 85 MHz Image Selector Yes LUT Full resolution"},{"location":"acquisition-applets-for-marathon-acl.html#specifications-differing-between-line-scan-acquisition-applets","title":"Specifications Differing Between Line Scan Acquisition Applets","text":"Image Size  [px] <sup>b</sup> Camera Ports Camera Type ROI Step Size [px] Bit Depth Processing [bit] Bit Depth Output [bit] Mode Mirroring Tap Geometry Sorting Bayer Color Reconstruction (HQe) White Balance Bandwidth: Mean per Camera [MP/s] Bandwidth Total DMA [MB/s] <sup>c</sup> Acq_DualBaseLineBayer_RG_GB 16k x 64k 2 BASE x: 4y: 1 8 per color component BGR 24 Bayer Pattern No No Yes (2 lines) Yes 566 900 Acq_DualBaseLineGray 48k x 16M 2 BASE x: 4y: 1 12 Grayscale 8, or 16 Grayscale Yes, horizontal 1, 2, 3, 4 (horizontal) No No 250 900 Acq_DualBaseLineRGB 32k x 16M 2 BASE x: 1y: 1 8 per color component BGR 24 RGB Yes, horizontal 1, 2, 4  (horizontal) No Yes 85 900 Acq_SingleBaseLineGray 48k x 16M 1 BASE x: 4y: 1 16 Grayscale 8, or 16 Grayscale Yes, horizontal 1, 2, 3, 4 (horizontal) No No 255 1800 Acq_SingleBaseLineRGB 64k x 16M 1 BASE x: 1y: 1 8 per color component BGR 24 RGB Yes, horizontal 1, 2, 4 (horizontal) No Yes 85 1800 Acq_SingleFullLineBayer_RB_GG 16k x 16M 1 FULL x: 8y: 1 8 per color component BGR 24 Bayer Pattern Yes, horizontal 8, 10 (horizontal) Yes (2 lines) Yes 850 1800 Acq_SingleFullLineBayer_RG_GB 16k x 16M 1 FULL x: 8y: 1 8 per color component BGR 24 Bayer Pattern Yes, horizontal 8, 10 (horizontal) Yes (2 lines) Yes 566 1800 Acq_SingleFullLineGray 51k x 16M 1 FULL x: 8y: 1 10 Grayscale 8, or 16 Grayscale Yes, horizontal 8, 10 (horizontal) No No 850 1800 Acq_SingleFullLineRGB 32k x 16M 1 FULL x: 4y: 1 10 per color component BGR 24, or 48 RGB Yes, horizontal 1, 2, 4 (horizontal) No Yes 284 1800 Acq_SingleMediumLineGray 48k x 16M 1 MEDIUM x: 8y: 1 12 Grayscale 8, or 16 Grayscale Yes, horizontal 1, 2, 3, 4 (horizontal) No No 340 1800 Acq_SingleMediumLineRGB 32k x 16M 1 MEDIUM x: 4y: 1 12 per color component BGR 24, or 48 RGB Yes, horizontal 1, 2, 4 (horizontal) No Yes 170 1800"},{"location":"acquisition-applets-for-marathon-acl.html#frame-grabber-test-applet","title":"Frame Grabber Test Applet","text":"<p>This applet is a frame grabber test applet. Its purpose is to test the hardware.</p> <p>The applet offers the following features:</p> Feature Explanation DMA Performance Test Tests different image dimensions for varying memory sizes and interrupt rates RAM Test Checks for errors and processing Check Camera Port Image Acquisition Checks camera port image acquisition Send Trigger Signals to Camera Sends trigger signals to camera GPIO Monitoring Monitors the GPIs and set the GPOs Event Test Generates a software callback event General Monitoring Monitors FPGA temperature, power management, PoCXP, etc."},{"location":"acquisition-applets-for-marathon-acl.html#using-acquisition-applets","title":"Using Acquisition Applets","text":"<p>Find here general information about using the applets with the Framegrabber SDK:  Acquisition Applets.</p>"},{"location":"acquisition-applets-for-marathon-acl.html#installing-applets","title":"Installing Applets","text":"<p>Before you can use a specific applet on your frame grabber, you must install it on the frame grabber. Instructions for installing the applets are available at Managing Applets (microDiagnostics).</p>"},{"location":"acquisition-applets-for-marathon-acl.html#adding-an-applet-manually","title":"Adding an Applet Manually","text":"<p>To add an applet you received as *.dll file (and not in form of an installer) to your host file system:</p> <ol> <li>Get the applet file (*.dll) you have received.</li> <li>Copy this file into the following directory: &lt;Framegrabber SDK directory&gt;/Dll/&lt;Frame grabber model&gt;</li> </ol> <p>Now you can use the new applet.</p>"},{"location":"acquisition-applets-for-marathon-acl.html#testing-image-acquisition","title":"Testing Image Acquisition","text":"<p>Before you start using an applet in your own software (via API), you might want to test the system set-up or an individual applet (and its parametrization options).</p> <p>For this purpose, you are provided with the tool microDisplay X that has been installed on your computer as part of the Framegrabber SDK environment. For instructions how to load and test your applet, see Configuring the Applet (microDisplay X).</p>"},{"location":"acquisition-applets-for-marathon-acl.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration. For more information, see Other Tasks (microDisplay X).</p> <ol> <li> <p>Framegrabber SDK version 5.9 doesn't support mE5 frame grabb\u00a0\u21a9</p> </li> <li> <p>k Px and M Px in this case refer to a binary format. Examples for binary calculations are:</p> <p>16M px = 16384k px = 16777216 px</p> <p>8M px = 8192k px = 8388608 px</p> <p>64k px = 65536 px</p> <p>48k px = 49152 px</p> <p>32k px = 32768 px</p> <p>16k px = 16384 px\u00a0\u21a9\u21a9</p> </li> <li> <p>The actual DMA bandwidth depends on the specific mainboard and chip set of the host computer.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"acquisition-applets-for-marathon-acx-dp.html","title":"Acquisition Applets for marathon ACX-DP","text":"<p>This topic tells you about the acquisition applets available for the marathon ACX-DP frame grabber.</p> <p>The functionality of a frame grabber is defined by a specific hardware-related program. This hardware implementation is called applet. For each frame grabber, several applets are available.</p> <p>By loading an applet onto the frame grabber, you define the functionality of the frame grabber and adapt it to the requirements of your specific application.</p> <p>The acquisition applets for marathon ACX-DP are included in the Framegrabber SDK.</p> <p>On marathon frame grabbers, an applet is available as soon as it is flashed onto the frame grabber.</p>"},{"location":"acquisition-applets-for-marathon-acx-dp.html#requirements","title":"Requirements","text":"<ul> <li>Host software: Framegrabber SDK (5.7, 5.10<sup>a</sup>, or higher)   with hardware-dependent acquisition applets</li> <li>Hardware: A marathon ACX-DP frame grabber is connected to your system</li> </ul> <p>Limitation</p> <p>In all applets, buffers larger than 4GB can't be allocated. Even if the applet allows a larger buffer size, you can't allocate buffers larger than 4GB due to limitations in the driver and firmware.</p> <p>You can calculate the buffer size as follows:</p> <p>Buffer size = image height * image width * (pixel width / 8).</p> <p>For RGB images: buffer size = (image height * image width * (pixel width / 8)) * 3 .</p>"},{"location":"acquisition-applets-for-marathon-acx-dp.html#documentation","title":"Documentation","text":"<p>The following sections provide links to the acquisition applets documentation:</p> Area Acquisition Applets Line Acquisition Applets Test Applet Acq_SingleCXP6x2AreaBayer PDF Acq_SingleCXP6x2AreaGray PDF Acq_SingleCXP6x2LineGray PDF Acq_SingleCXP6x2AreaRGB PDF Acq_SingleCXP6x2LineRGB PDF Acq_DualCXP6x1AreaBayer PDF Acq_DualCXP6x1AreaGray PDF Acq_DualCXP6x1LineGray PDF Acq_DualCXP6x1AreaRGB PDF Acq_DualCXP6x1LineRGB PDF FrameGrabberTest PDF"},{"location":"acquisition-applets-for-marathon-acx-dp.html#area-scan-acquisition-applets","title":"Area Scan Acquisition Applets","text":"<p>The following Area Scan Acquisition Applets are available:</p> <ul> <li>Acq_SingleCXP6x2AreaBayer</li> <li>Acq_SingleCXP6x2AreaGray</li> <li>Acq_SingleCXP6x2AreaRGB</li> <li>Acq_DualCXP6x1AreaBayer</li> <li>Acq_DualCXP6x1AreaGray</li> <li>Acq_DualCXP6x1AreaRGB</li> </ul> <p>The denominators \"single\" and \"dual\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Area Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-acx-dp.html#choosing-the-right-area-scan-acquisition-applet","title":"Choosing the Right Area Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the image received from the camera can't be processed or displayed correctly or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 2 2 Bayer Pattern Acq_SingleCXP6x2AreaBayer x: 8y: 1 1 2 2 Grayscale Acq_SingleCXP6x2AreaGray x: 16y: 1 1 2 2 RGB Acq_SingleCXP6x2AreaRGB x: 4y: 1 2 1 2 Bayer Pattern Acq_DualCXP6x1AreaBayer x: 8y: 1 2 1 2 Grayscale Acq_DualCXP6x1AreaGray x: 16y: 1 2 1 2 RGB Acq_DualCXP6x1AreaRGB x: 4y: 1"},{"location":"acquisition-applets-for-marathon-acx-dp.html#specifications-common-to-all-area-scan-acquisition-applets","title":"Specifications Common to All Area Scan Acquisition Applets","text":"Camera Type CXP-6 Mirroring Yes, horizontal and vertical Image Selector Yes LUT Full resolution Bandwidth Total DMA [MB/s] <sup>b</sup> 1800"},{"location":"acquisition-applets-for-marathon-acx-dp.html#specifications-differing-between-area-scan-acquisition-applets","title":"Specifications Differing Between Area Scan Acquisition Applets","text":"Max. Image Size [px] <sup>c</sup> Camera Ports ROI Step Size [px] Bit Depth Processing [bit] Bit Depth Output [bit] Mode Bayer Color Reconstruction (HQe) White Balance Bandwidth: Mean per Camera [MP/s] Acq_DualCXP6x1AreaBayer 16k x 64k 2 x: 8y: 1 14 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 Bayer Pattern Yes, High Quality Extended (HQe) Yes 600 Acq_DualCXP6x1AreaGray 64k x 64k 2 x: 16y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No No 600 Acq_DualCXP6x1AreaRGB 64k x 64k 2 x: 4y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB No Yes 200 Acq_SingleCXP6x2AreaBayer 48k x 64k 1 x: 8y: 1 14 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 Bayer Pattern Yes, High Quality Extended (HQe) Yes 1200 Acq_SingleCXP6x2AreaGray 64k x 64k 1 x: 16y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No No 1200 Acq_SingleCXP6x2AreaRGB 64k x 64k 1 x: 4y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB No Yes 400"},{"location":"acquisition-applets-for-marathon-acx-dp.html#line-scan-acquisition-applets","title":"Line Scan Acquisition Applets","text":"<p>The following Line Scan Acquisition Applets are available:</p> <ul> <li>Acq_SingleCXP6x2LineGray</li> <li>Acq_SingleCXP6x2LineRGB</li> <li>Acq_DualCXP6x1LineGray</li> <li>Acq_DualCXP6x1LineRGB</li> </ul> <p>The denominators \"single\" and \"dual\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Line Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-acx-dp.html#choosing-the-right-line-scan-acquisition-applet","title":"Choosing the Right Line Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the camera may not work or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 2 2 Grayscale Acq_SingleCXP6x2LineGray x: 16y: 1 1 2 2 RGB Acq_SingleCXP6x2LineRGB x: 4y: 1 2 1 2 Grayscale Acq_DualCXP6xLineGray x: 16y: 1 2 1 2 RGB Acq_DualCXP6xLineRGB x: 4y: 1"},{"location":"acquisition-applets-for-marathon-acx-dp.html#specifications-common-to-all-line-scan-acquisition-applets","title":"Specifications Common to All Line Scan Acquisition Applets","text":"Max. Image Size [px] 64k x 8M<sup>c</sup> Camera Type CXP-6 Mirroring Yes, horizontal and vertical Image Selector Yes Bayer Color Reconstruction (HQe) No LUT Full resolution Bandwidth Total DMA [MB/s] <sup>b</sup> 1800"},{"location":"acquisition-applets-for-marathon-acx-dp.html#specifications-differing-between-line-scan-acquisition-applets","title":"Specifications Differing Between Line Scan Acquisition Applets","text":"Camera Ports ROI Step Size [px] Bit Depth Processing [bit] Bit Depth Output [bit] Mode White Balance Bandwidth: Mean per Camera [MP/s] Acq_DualCXP6x1LineGray 2 x: 16y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No 600 Acq_DualCXP6x1LineRGB 2 x: 4y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB Yes 200 Acq_SingleCXP6x2LineGray 1 x: 16y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No 1200 Acq_SingleCXP6x2LineRGB 1 x: 4y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB Yes 400"},{"location":"acquisition-applets-for-marathon-acx-dp.html#frame-grabber-test-applet","title":"Frame Grabber Test Applet","text":"<p>This applet is a frame grabber test applet. Its purpose is to test the hardware.</p> <p>The applet offers the following features:</p> Feature Explanation DMA Performance Test Tests different image dimensions for varying memory sizes and interrupt rates RAM Test Checks for errors and processing Check Camera Port Image Acquisition Checks camera port image acquisition Send Trigger Signals to Camera Sends trigger signals to camera GPIO Monitoring Monitors the GPIs and set the GPOs Event Test Generates a software callback event General Monitoring Monitors FPGA temperature, power management, PoCXP, etc."},{"location":"acquisition-applets-for-marathon-acx-dp.html#using-acquisition-applets","title":"Using Acquisition Applets","text":"<p>Find here general information about using the applets with the Framegrabber SDK:  Acquisition Applets.</p>"},{"location":"acquisition-applets-for-marathon-acx-dp.html#installing-applets","title":"Installing Applets","text":"<p>Before you can use a specific applet on your frame grabber, you must install it on the frame grabber. Instructions for installing the applets are available at Managing Applets (microDiagnostics).</p>"},{"location":"acquisition-applets-for-marathon-acx-dp.html#adding-an-applet-manually","title":"Adding an Applet Manually","text":"<p>To add an applet you received as *.dll file (and not in form of an installer) to your host file system:</p> <ol> <li>Get the applet file (*.dll) you have received.</li> <li>Copy this file into the following directory: &lt;Framegrabber SDK directory&gt;/Dll/&lt;Frame grabber model&gt;</li> </ol> <p>Now you can use the new applet.</p>"},{"location":"acquisition-applets-for-marathon-acx-dp.html#testing-image-acquisition","title":"Testing Image Acquisition","text":"<p>Before you start using an applet in your own software (via API), you might want to test the system set-up or an individual applet (and its parametrization options).</p> <p>For this purpose, you are provided with the tool microDisplay X that has been installed on your computer as part of the Framegrabber SDK environment. For instructions how to load and test your applet, see Configuring the Applet (microDisplay X).</p>"},{"location":"acquisition-applets-for-marathon-acx-dp.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration. For more information, see Other Tasks (microDisplay X).</p> <ol> <li> <p>Framegrabber SDK version 5.9 doesn't support mE5 frame grabbers.\u00a0\u21a9</p> </li> <li> <p>The actual DMA bandwidth depends on the specific mainboard and chip set of the host computer.\u00a0\u21a9\u21a9</p> </li> <li> <p>k Px and M Px in this case refer to a binary format. Examples for binary calculations are:</p> <p>16M px = 16384k px = 16777216 px</p> <p>8M px = 8192k px = 8388608 px</p> <p>64k px = 65536 px</p> <p>48k px = 49152 px</p> <p>32k px = 32768 px</p> <p>16k px = 16384 px\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"acquisition-applets-for-marathon-acx-qp.html","title":"Acquisition Applets for marathon ACX-QP","text":"<p>This topic tells you about the acquisition applets available for the marathon ACX-QP frame grabber.</p> <p>The functionality of a frame grabber is defined by a specific hardware-related program. This hardware implementation is called applet. For each frame grabber, several applets are available.</p> <p>By loading an applet onto the frame grabber, you define the functionality of the frame grabber and adapt it to the requirements of your specific application.</p> <p>The acquisition applets for marathon ACX-QP are included in the Framegrabber SDK.</p> <p>On marathon frame grabbers, an applet is available as soon as it is flashed onto the frame grabber.</p>"},{"location":"acquisition-applets-for-marathon-acx-qp.html#requirements","title":"Requirements","text":"<ul> <li>Host software: Framegrabber SDK (5.7, 5.10<sup>a</sup>, or higher)   with hardware-dependent acquisition applets</li> <li>Hardware: A marathon ACX-QP frame grabber is connected to your system</li> </ul> <p>Limitation</p> <p>In all applets, buffers larger than 4GB can't be allocated. Even if the applet allows a larger buffer size, you can't allocate buffers larger than 4GB due to limitations in the driver and firmware.</p> <p>You can calculate the buffer size as follows:</p> <p>Buffer size = image height * image width * (pixel width / 8).</p> <p>For RGB images: buffer size = (image height * image width * (pixel width / 8)) * 3 .</p>"},{"location":"acquisition-applets-for-marathon-acx-qp.html#documentation","title":"Documentation","text":"<p>The following sections provide links to the acquisition applets documentation:</p> Area Acquisition Applets Line Acquisition Applets Test Applet Acq_SingleCXP6x4AreaBayer PDF Acq_SingleCXP6x4AreaGray PDF Acq_SingleCXP6x4LineGray PDF Acq_SingleCXP6x4AreaRGB PDF Acq_SingleCXP6x4LineRGB PDF Acq_DualCXP6x2AreaBayer PDF Acq_DualCXP6x2AreaGray PDF Acq_DualCXP6x2LineGray PDF Acq_DualCXP6x2AreaRGB PDF Acq_DualCXP6x2LineRGB PDF Acq_QuadCXP6x1AreaBayer PDF Acq_QuadCXP6x1AreaGray PDF Acq_QuadCXP6x1LineGray PDF Acq_QuadCXP6x1AreaRGB PDF Acq_QuadCXP6x1LineRGB PDF FrameGrabberTest PDF"},{"location":"acquisition-applets-for-marathon-acx-qp.html#area-scan-acquisition-applets","title":"Area Scan Acquisition Applets","text":"<p>The following Area Scan Acquisition Applets are available:</p> <ul> <li>Acq_DualCXP6x2AreaBayer</li> <li>Acq_DualCXP6x2AreaGray</li> <li>Acq_DualCXP6x2AreaRGB</li> <li>Acq_QuadCXP6x1AreaBayer</li> <li>Acq_QuadCXP6x1AreaGray</li> <li>Acq_QuadCXP6x1AreaRGB</li> <li>Acq_SingleCXP6x4AreaBayer</li> <li>Acq_SingleCXP6x4AreaGray</li> <li>Acq_SingleCXP6x4AreaRGB</li> </ul> <p>The denominators \"single\", \"dual\", and \"quad\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Area Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-acx-qp.html#choosing-the-right-area-scan-acquisition-applet","title":"Choosing the Right Area Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the image received from the camera can't be processed or displayed correctly or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 4 4 Bayer Pattern Acq_SingleCXP6x4AreaBayer x: 8y: 1 1 4 4 Grayscale Acq_SingleCXP6x4AreaGray x: 16y: 1 1 4 4 RGB Acq_SingleCXP6x4AreaRGB x: 8y: 1 2 2 4 Bayer Pattern Acq_DualCXP6x2AreaBayer x: 8y: 1 2 2 4 Grayscale Acq_DualCXP6x2AreaGray x: 16y: 1 2 2 4 RGB Acq_DualCXP6x2AreaRGB x: 4y: 1 4 1 4 Bayer Pattern Acq_QuadCXP6x1AreaBayer x: 4y: 1 4 1 4 Grayscale Acq_QuadCXP6x1AreaGray x: 8y: 1 4 1 4 RGB Acq_QuadCXP6x1AreaRGB x: 4y: 1"},{"location":"acquisition-applets-for-marathon-acx-qp.html#specifications-common-to-all-area-scan-acquisition-applets","title":"Specifications Common to All Area Scan Acquisition Applets","text":"Camera Type CXP-6 Mirroring Yes, horizontal and vertical Event Generation Yes Image Selector Yes LUT Full resolution Bandwidth Total DMA [MB/s] <sup>b</sup> 1800"},{"location":"acquisition-applets-for-marathon-acx-qp.html#specifications-differing-between-area-scan-acquisition-applets","title":"Specifications Differing Between Area Scan Acquisition Applets","text":"Camera Ports [px] <sup>c</sup> ROI Step Size [px] Bit Depth Processing [bit] Bit Depth Output [bit] Mode White Balance Bandwidth: Mean per Camera [MP/s] Acq_DualCXP6x2AreaBayer 16k x 64k x: 8y: 1 14 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 Bayer Pattern Yes 1200 Acq_DualCXP6x2AreaGray 64k x 64k x: 16y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No 1200 Acq_DualCXP6x2AreaRGB 64k x 64k x: 4y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB Yes 400 Acq_QuadCXP6x1AreaBayer 8k x 64k x: 4y: 1 14 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 Bayer Pattern Yes 600 Acq_QuadCXP6x1AreaGray 64k x 64k x: 8y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No 600 Acq_QuadCXP6x1AreaRGB 64k x 64k x: 4y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB Yes 200 Acq_SingleCXP6x4AreaBayer 48k x 64k x: 8y: 1 14 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 Bayer Pattern Yes 2400 Acq_SingleCXP6x4AreaGray 64k x 64k x: 16y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No 2400 Acq_SingleCXP6x4AreaRGB 64k x 64k x: 8y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB Yes 800"},{"location":"acquisition-applets-for-marathon-acx-qp.html#line-scan-acquisition-applets","title":"Line Scan Acquisition Applets","text":"<p>The following Line Scan Acquisition Applets are available:</p> <ul> <li>Acq_DualCXP6x2LineGray</li> <li>Acq_DualCXP6x2LineRGB</li> <li>Acq_QuadCXP6x1LineGray</li> <li>Acq_QuadCXP6x1LineRGB</li> <li>Acq_SingleCXP6x4LineGray</li> <li>Acq_SingleCXP6x4LineRGB</li> </ul> <p>The denominators \"single\", \"dual\", and \"quad\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Line Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-acx-qp.html#choosing-the-right-line-scan-acquisition-applet","title":"Choosing the Right Line Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the camera may not work or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 4 4 Grayscale Acq_SingleCXP6x4LineGray x: 16y: 1 1 4 4 RGB Acq_SingleCXP6x4LineRGB x: 8y: 1 2 2 4 Grayscale Acq_DualCXP6x2LineGray x: 16y: 1 2 2 4 RGB Acq_DualCXP6x2LineRGB x: 4y: 1 4 1 4 Grayscale Acq_QuadCXP6x1LineGray x: 8y: 1 4 1 4 RGB Acq_QuadCXP6x1LineRGB x: 4y: 1"},{"location":"acquisition-applets-for-marathon-acx-qp.html#specifications-common-to-all-line-scan-acquisition-applets","title":"Specifications Common to All Line Scan Acquisition Applets","text":"Max. Image Size [px] 64k x 8M<sup>c</sup> Camera Type CXP-6 Mirroring Yes, horizontal and vertical Event Generation Yes Image Selector Yes Bayer Color Reconstruction (HQe) No LUT Full resolution Bandwidth Total DMA [MB/s] <sup>b</sup> 1800"},{"location":"acquisition-applets-for-marathon-acx-qp.html#specifications-differing-between-line-scan-acquisition-applets","title":"Specifications Differing Between Line Scan Acquisition Applets","text":"Camera Ports ROI Step Size [px] Bit Depth Processing [bit] Bit Depth Output [bit] Mode White Balance Bandwidth: Mean per Camera [MP/s] Acq_DualCXP6x2LineGray 2 x: 16y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No 1200 Acq_DualCXP6x2LineRGB 2 x: 4y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB Yes 400 Acq_QuadCXP6x1LineGray 4 x: 8y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No 600 Acq_QuadCXP6x1LineRGB 4 x: 4y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB Yes 200 Acq_SingleCXP6x4LineGray 1 x: 16y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No 2400 Acq_SingleCXP6x4LineRGB 1 x: 8y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB Yes 800"},{"location":"acquisition-applets-for-marathon-acx-qp.html#frame-grabber-test-applet","title":"Frame Grabber Test Applet","text":"<p>This applet is a frame grabber test applet. Its purpose is to test the hardware.</p> <p>The applet offers the following features:</p> Feature Explanation DMA Performance Test Tests different image dimensions for varying memory sizes and interrupt rates RAM Test Checks for errors and processing Check Camera Port Image Acquisition Checks camera port image acquisition Send Trigger Signals to Camera Sends trigger signals to camera GPIO Monitoring Monitors the GPIs and set the GPOs Event Test Generates a software callback event General Monitoring Monitors FPGA temperature, power management, PoCXP, etc."},{"location":"acquisition-applets-for-marathon-acx-qp.html#using-acquisition-applets","title":"Using Acquisition Applets","text":"<p>Find here general information about using the applets with the Framegrabber SDK:  Acquisition Applets.</p>"},{"location":"acquisition-applets-for-marathon-acx-qp.html#installing-applets","title":"Installing Applets","text":"<p>Before you can use a specific applet on your frame grabber, you must install it on the frame grabber. Instructions for installing the applets are available at Managing Applets (microDiagnostics).</p>"},{"location":"acquisition-applets-for-marathon-acx-qp.html#adding-an-applet-manually","title":"Adding an Applet Manually","text":"<p>To add an applet you received as *.dll file (and not in form of an installer) to your host file system:</p> <ol> <li>Get the applet file (*.dll) you have received.</li> <li>Copy this file into the following directory: &lt;Framegrabber SDK directory&gt;/Dll/&lt;Frame grabber model&gt;</li> </ol> <p>Now you can use the new applet.</p>"},{"location":"acquisition-applets-for-marathon-acx-qp.html#testing-image-acquisition","title":"Testing Image Acquisition","text":"<p>Before you start using an applet in your own software (via API), you might want to test the system set-up or an individual applet (and its parametrization options).</p> <p>For this purpose, you are provided with the tool microDisplay X that has been installed on your computer as part of the Framegrabber SDK environment. For instructions how to load and test your applet, see Configuring the Applet (microDisplay X).</p>"},{"location":"acquisition-applets-for-marathon-acx-qp.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration. For more information, see Other Tasks (microDisplay X).</p> <ol> <li> <p>Framegrabber SDK version 5.9 doesn't support mE5 frame grabbers.\u00a0\u21a9</p> </li> <li> <p>The actual DMA bandwidth depends on the specific mainboard and chip set of the host computer.\u00a0\u21a9\u21a9</p> </li> <li> <p>k Px and M Px in this case refer to a binary format. Examples for binary calculations are:</p> <p>16M px = 16384k px = 16777216 px</p> <p>8M px = 8192k px = 8388608 px</p> <p>64k px = 65536 px</p> <p>48k px = 49152 px</p> <p>32k px = 32768 px</p> <p>16k px = 16384 px\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"acquisition-applets-for-marathon-acx-sp.html","title":"Acquisition Applets for marathon ACX-SP","text":"<p>This topic tells you about the acquisition applets available for the marathon ACX-SP frame grabber.</p> <p>The functionality of a frame grabber is defined by a specific hardware-related program. This hardware implementation is called applet. For each frame grabber, several applets are available.</p> <p>By loading an applet onto the frame grabber, you define the functionality of the frame grabber and adapt it to the requirements of your specific application.</p> <p>The acquisition applets for marathon ACX-SP are included in the Framegrabber SDK.</p> <p>On marathon frame grabbers, an applet is available as soon as it is flashed onto the frame grabber.</p>"},{"location":"acquisition-applets-for-marathon-acx-sp.html#requirements","title":"Requirements","text":"<ul> <li>Host software: Framegrabber SDK (5.7, 5.10<sup>a</sup>, or higher)   with hardware-dependent acquisition applets</li> <li>Hardware: A marathon ACX-SP frame grabber is connected to your system</li> </ul> <p>Limitation</p> <p>In all applets, buffers larger than 4GB can't be allocated. Even if the applet allows a larger buffer size, you can't allocate buffers larger than 4GB due to limitations in the driver and firmware.</p> <p>You can calculate the buffer size as follows:</p> <p>Buffer size = image height * image width * (pixel width / 8).</p> <p>For RGB images: buffer size = (image height * image width * (pixel width / 8)) * 3 .</p>"},{"location":"acquisition-applets-for-marathon-acx-sp.html#documentation","title":"Documentation","text":"<p>The following sections provide links to the acquisition applets documentation:</p> Area Acquisition Applets Line Acquisition Applets Test Applet Acq_SingleCXP6x1AreaBayer PDF Acq_SingleCXP6x1AreaGray PDF Acq_SingleCXP6x1LineGray PDF Acq_SingleCXP6x1AreaRGB PDF Acq_SingleCXP6x1LineRGB PDF FrameGrabberTest PDF"},{"location":"acquisition-applets-for-marathon-acx-sp.html#area-scan-acquisition-applets","title":"Area Scan Acquisition Applets","text":"<p>The following Area Scan Acquisition Applets are available:</p> <ul> <li>Acq_SingleCXP6x1AreaBayer</li> <li>Acq_SingleCXP6x1AreaGray</li> <li>Acq_SingleCXP6x1AreaRGB</li> </ul> <p>The denominator \"single\" in the name of the applet refers to the maximum number of cameras you can connect. For more information, see Choosing the Right Area Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-acx-sp.html#choosing-the-right-area-scan-acquisition-applet","title":"Choosing the Right Area Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the image received from the camera can't be processed or displayed correctly or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 1 1 Bayer Pattern Acq_SingleCXP6x1AreaBayer x: 8y: 1 1 1 1 Grayscale Acq_SingleCXP6x1AreaGray x: 4y: 1 1 1 1 RGB Acq_SingleCXP6x1AreaRGB x: 4y: 1"},{"location":"acquisition-applets-for-marathon-acx-sp.html#specifications-common-to-all-area-scan-acquisition-applets","title":"Specifications Common to All Area Scan Acquisition Applets","text":"Camera Ports 1 Camera Type CXP-6 Mirroring Yes, horizontal and vertical Image Selector Yes LUT Full resolution Bandwidth Total DMA [MB/s] <sup>b</sup> 1800"},{"location":"acquisition-applets-for-marathon-acx-sp.html#specifications-differing-between-area-scan-acquisition-applets","title":"Specifications Differing Between Area Scan Acquisition Applets","text":"Max. Image Size [px] <sup>c</sup> ROI Step Size [px] Bit Depth Processing [bit] Bit Depth Output [bit] Mode White Balance Bandwidth: Mean per Camera [MP/s] Acq_SingleCXP6x1AreaBayer 16k x 64k x: 8y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 Bayer Pattern Yes 600 Acq_SingleCXP6x1AreaGray 64k x 64k x: 4y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No 600 Acq_SingleCXP6x1AreaRGB 64k x 64k x: 4y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB Yes 200"},{"location":"acquisition-applets-for-marathon-acx-sp.html#line-scan-acquisition-applets","title":"Line Scan Acquisition Applets","text":"<p>The following Line Scan Acquisition Applets are available:</p> <ul> <li>Acq_SingleCXP6x1LineGray</li> <li>Acq_SingleCXP6x1LineRGB</li> </ul> <p>The denominator \"single\" in the name of the applet refers to the maximum number of cameras you can connect. For more information, see Choosing the Right Line Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-acx-sp.html#choosing-the-right-line-scan-acquisition-applet","title":"Choosing the Right Line Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the camera may not work or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 1 1 Grayscale Acq_SingleCXP6x1LineGray x: 4y: 1 1 1 1 RGB Acq_SingleCXP6x1LineRGB x: 4y: 1"},{"location":"acquisition-applets-for-marathon-acx-sp.html#specifications-common-to-all-line-scan-acquisition-applets","title":"Specifications Common to All Line Scan Acquisition Applets","text":"Camera Ports 1 Camera Type CXP-6 ROI Step Size [px] x: 4y: 1 Mirroring Yes, horizontal and vertical Image Selector Yes Bayer Color Reconstruction (HQe) No LUT Full resolution Bandwidth Total DMA [MB/s] <sup>b</sup> 1800"},{"location":"acquisition-applets-for-marathon-acx-sp.html#specifications-differing-between-line-scan-acquisition-applets","title":"Specifications Differing Between Line Scan Acquisition Applets","text":"Max. Image Size [px] <sup>c</sup> Camera Ports Bit Depth Processing [bit] Bit Depth Output [bit] Mode White Balance Bandwidth: Mean per Camera [MP/s] Acq_SingleCXP6x1LineGray 64k x 8M 1 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 16 Grayscale No 600 Acq_SingleCXP6x1LineRGB 48k x 8M 1 BGR 24, 30 packed, 36 packed, 42 packed, or 48 16 per color component RGB Yes 200"},{"location":"acquisition-applets-for-marathon-acx-sp.html#frame-grabber-test-applet","title":"Frame Grabber Test Applet","text":"<p>This applet is a frame grabber test applet. Its purpose is to test the hardware.</p> <p>The applet offers the following features:</p> Feature Explanation DMA Performance Test Tests different image dimensions for varying memory sizes and interrupt rates RAM Test Checks for errors and processing Check Camera Port Image Acquisition Checks camera port image acquisition Send Trigger Signals to Camera Sends trigger signals to camera GPIO Monitoring Monitors the GPIs and set the GPOs Event Test Generates a software callback event General Monitoring Monitors FPGA temperature, power management, PoCXP, etc."},{"location":"acquisition-applets-for-marathon-acx-sp.html#using-acquisition-applets","title":"Using Acquisition Applets","text":"<p>Find here general information about using the applets with the Framegrabber SDK:  Acquisition Applets.</p>"},{"location":"acquisition-applets-for-marathon-acx-sp.html#installing-applets","title":"Installing Applets","text":"<p>Before you can use a specific applet on your frame grabber, you must install it on the frame grabber. Instructions for installing the applets are available at Managing Applets (microDiagnostics).</p>"},{"location":"acquisition-applets-for-marathon-acx-sp.html#adding-an-applet-manually","title":"Adding an Applet Manually","text":"<p>To add an applet you received as *.dll file (and not in form of an installer) to your host file system:</p> <ol> <li>Get the applet file (*.dll) you have received.</li> <li>Copy this file into the following directory: &lt;Framegrabber SDK directory&gt;/Dll/&lt;Frame grabber model&gt;</li> </ol> <p>Now you can use the new applet.</p>"},{"location":"acquisition-applets-for-marathon-acx-sp.html#testing-image-acquisition","title":"Testing Image Acquisition","text":"<p>Before you start using an applet in your own software (via API), you might want to test the system set-up or an individual applet (and its parametrization options).</p> <p>For this purpose, you are provided with the tool microDisplay X that has been installed on your computer as part of the Framegrabber SDK environment. For instructions how to load and test your applet, see Configuring the Applet (microDisplay X).</p>"},{"location":"acquisition-applets-for-marathon-acx-sp.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration. For more information, see Other Tasks (microDisplay X).</p> <ol> <li> <p>Framegrabber SDK version 5.9 doesn't support mE5 frame grabbers.\u00a0\u21a9</p> </li> <li> <p>The actual DMA bandwidth depends on the specific mainboard and chip set of the host computer.\u00a0\u21a9\u21a9</p> </li> <li> <p>k Px and M Px in this case refer to a binary format. Examples for binary calculations are:</p> <p>16M px = 16384k px = 16777216 px</p> <p>8M px = 8192k px = 8388608 px</p> <p>64k px = 65536 px</p> <p>48k px = 49152 px</p> <p>32k px = 32768 px</p> <p>16k px = 16384 px\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"acquisition-applets-for-marathon-vcl.html","title":"Acquisition Applets for marathon VCL","text":"<p>This topic tells you about the acquisition applets available for the marathon VCL frame grabber.</p> <p>The functionality of a frame grabber is defined by a specific hardware-related program. This hardware implementation is called applet. For each frame grabber, several applets are available.</p> <p>By loading an applet onto the frame grabber, you define the functionality of the frame grabber and adapt it to the requirements of your specific application.</p> <p>The acquisition applets for marathon VCL are included in the Framegrabber SDK.</p> <p>On marathon frame grabbers, an applet is available as soon as it is flashed onto the frame grabber.</p>"},{"location":"acquisition-applets-for-marathon-vcl.html#requirements","title":"Requirements","text":"<ul> <li>Host software: Framegrabber SDK (5.7, 5.10<sup>a</sup>, or higher)   with hardware-dependent acquisition applets</li> <li>Hardware: A marathon VCL frame grabber is connected to your system</li> </ul> <p>Limitation</p> <p>In all applets, buffers larger than 4GB can't be allocated. Even if the applet allows a larger buffer size, you can't allocate buffers larger than 4GB due to limitations in the driver and firmware.</p> <p>You can calculate the buffer size as follows:</p> <p>Buffer size = image height * image width * (pixel width / 8).</p> <p>For RGB images: buffer size = (image height * image width * (pixel width / 8)) * 3 .</p>"},{"location":"acquisition-applets-for-marathon-vcl.html#documentation","title":"Documentation","text":"<p>The following sections provide links to the acquisition applets documentation:</p> Area Acquisition Applets Line Acquisition Applets Test Applet Acq_SingleFullAreaBayer PDF Acq_SingleFullLineBayer_RB_GG PDF Acq_SingleFullLineBayer_RG_GB PDF Acq_SingleFullAreaGray PDF Acq_SingleFullLineGray PDF Acq_SingleFullAreaRGB PDF Acq_SingleFullLineRGB PDF Acq_SingleMediumAreaBayer PDF Acq_SingleMediumAreaGray PDF Acq_SingleMediumLineGray PDF Acq_SingleMediumAreaRGB PDF Acq_SingleMediumLineRGB PDF Acq_DualBaseAreaBayer PDF Acq_DualBaseLineBayer_RG_GB PDF Acq_DualBaseAreaGray PDF Acq_DualBaseLineGray PDF Acq_DualBaseAreaRGB PDF Acq_DualBaseLineRGB PDF FrameGrabberTest PDF"},{"location":"acquisition-applets-for-marathon-vcl.html#area-scan-acquisition-applets","title":"Area Scan Acquisition Applets","text":"<p>The following Area Scan Acquisition Applets are available:</p> <ul> <li>Acq_DualBaseAreaBayer</li> <li>Acq_DualBaseAreaGray</li> <li>Acq_DualBaseAreaRGB</li> <li>Acq_SingleFullAreaBayer</li> <li>Acq_SingleFullAreaGray</li> <li>Acq_SingleFullAreaRGB</li> <li>Acq_SingleMediumAreaBayer</li> <li>Acq_SingleMediumAreaGray</li> <li>Acq_SingleMediumAreaRGB</li> </ul> <p>The denominators \"single\" and \"dual\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Area Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-vcl.html#choosing-the-right-area-scan-acquisition-applet","title":"Choosing the Right Area Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the image received from the camera can't be processed or displayed correctly or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 2 2 Bayer Pattern Acq_SingleFullAreaBayerAcq_SingleMediumAreaBayer x: 8; y: 1x: 4; y: 1 1 2 2 Grayscale Acq_SingleFullAreaGrayAcq_SingleMediumAreaGray x: 8; y: 1x: 4; y: 1 1 2 2 RGB Acq_SingleFullAreaRGBAcq_SingleMediumAreaRGB x: 4; y: 1x: 4; y: 1 2 1 2 Bayer Pattern Acq_DualBaseAreaBayer x: 4y: 1 2 1 2 Grayscale Acq_DualBaseAreaGray x: 4y: 1 2 1 2 RGB Acq_DualBaseAreaRGB x: 1y: 1"},{"location":"acquisition-applets-for-marathon-vcl.html#specifications-common-to-all-area-scan-acquisition-applets","title":"Specifications Common to All Area Scan Acquisition Applets","text":"Max. Image Size [px] 16k x 64k<sup>b</sup> Mirroring Yes, horizontal and vertical Camera Clock Max. 85 MHz Image Selector Yes LUT Full resolution Bandwidth Total DMA [MB/s] <sup>c</sup> 1800"},{"location":"acquisition-applets-for-marathon-vcl.html#specifications-differing-between-area-scan-acquisition-applets","title":"Specifications Differing Between Area Scan Acquisition Applets","text":"Camera Ports Camera Type ROI Step Size [px] Bit Depth Processing [bit] Bit Depth Output [bit] Mode Mirroring Tap Geometry Sorting Bayer Color Reconstruction (HQe) White Balance Bandwidth: Mean per Camera [MP/s] Acq_DualBaseAreaBayer 2 BASE x: 4y: 1 12 per color component BGR 24, 30 packed, 36 packed, or 48 Bayer Pattern Yes, horizontal and vertical 1, 2, 4 (horizontal and vertical) Yes, High Quality Extended (HQe) Yes 255 Acq_DualBaseAreaGray 2 BASE x: 4y: 1 16 Grayscale 8, 10 packed, 12 packed, or 16 Grayscale Yes, horizontal and vertical 1, 2, 4 (horizontal and vertical) No No 255 Acq_DualBaseAreaRGB 2 BASE x: 1y: 1 8 per color component BGR 24 RGB Yes, horizontal and vertical 1, 2, 4 (horizontal and vertical) No Yes 85 Acq_SingleFullAreaBayer 1 FULL x: 8y: 1 10 per color component BGR 24, 30 packed, or 48 Bayer Pattern Yes, horizontal 8, 10 (horizontal) Yes, High Quality Extended (HQe) Yes 850 Acq_SingleFullAreaGray 1 FULL x: 8y: 1 10 Grayscale 8, 10 packed, or 16 Grayscale Yes, horizontal 8, 10 (horizontal) No No 850 Acq_SingleFullAreaRGB 1 FULL x: 4y: 1 10 per color component BGR 24, 30 packed, or 48 RGB Yes, horizontal 1, 2, 4 (horizontal and vertical) No Yes 284 Acq_SingleMediumAreaBayer 1 MEDIUM x: 4y: 1 12 per color component BGR 24, 30 packed, 36 packed, or 48 Bayer Pattern Yes, horizontal and vertical 1, 2, 4 (horizontal and vertical) Yes, High Quality Extended (HQe) Yes 340 Acq_SingleMediumAreaGray 1 MEDIUM x: 4y: 1 12 Grayscale 8, 10 packed, or 16 Grayscale Yes, horizontal and vertical 1, 2, 4 (horizontal and vertical) No No 340 Acq_SingleMediumAreaRGB 1 MEDIUM x: 4y: 1 12 per color component BGR 24, 30 packed, 36 packed, or 48 RGB Yes, horizontal and vertical 1, 2, 4 (horizontal and vertical) No Yes 170"},{"location":"acquisition-applets-for-marathon-vcl.html#line-scan-acquisition-applets","title":"Line Scan Acquisition Applets","text":"<p>The following Line Scan Acquisition Applets are available:</p> <ul> <li>Acq_SingleFullLineBayer_RB_GG</li> <li>Acq_SingleFullLineBayer_RG_GB</li> <li>Acq_SingleFullLineGray</li> <li>Acq_SingleFullLineRGB</li> <li>Acq_SingleMediumLineGray</li> <li>Acq_SingleMediumLineRGB</li> <li>Acq_DualBaseLineBayer_RG_GB</li> <li>Acq_DualBaseLineGray</li> <li>Acq_DualBaseLineRGB</li> </ul> <p>The denominators \"single\" and \"dual\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Line Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-vcl.html#choosing-the-right-line-scan-acquisition-applet","title":"Choosing the Right Line Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the camera may not work or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 2 2 Bayer Pattern Acq_SingleFullLineBayer_RB_GGAcq_SingleFullLineBayer_RB_GB x: 8; y: 1x: 8; y: 1 1 2 2 Grayscale Acq_SingleFullLineGrayAcq_SingleMediumLineGray x: 8; y: 1x: 8; y: 1 1 2 2 RGB Acq_SingleFullLineRGBAcq_SingleMediumLineRGB x: 4; y: 1x: 4; y: 1 2 1 2 Bayer Pattern Acq_DualBaseLineBayer_RG_GB x: 4y: 1 2 1 2 Grayscale Acq_DualBaseLineGray x: 4y: 1 2 1 2 RGB Acq_DualBaseLineRGB x: 1y: 1"},{"location":"acquisition-applets-for-marathon-vcl.html#specifications-common-to-all-line-scan-acquisition-applets","title":"Specifications Common to All Line Scan Acquisition Applets","text":"Camera Clock 85 MHz Image Selector Yes LUT Full resolution"},{"location":"acquisition-applets-for-marathon-vcl.html#specifications-differing-between-line-scan-acquisition-applets","title":"Specifications Differing Between Line Scan Acquisition Applets","text":"Image Size [px] <sup>b</sup> Camera Ports Camera Type ROI Step Size [px] Bit Depth Processing [bit] Bit Depth Output [bit] Mode Mirroring Tap Geometry Sorting Bayer Color Reconstruction (HQe) White Balance Bandwidth: Mean per Camera [MP/s] Bandwidth Total DMA [MB/s] <sup>c</sup> Acq_DualBaseLineBayer_RG_GB 16k x 64k 2 BASE x: 4y: 1 8 per color component BGR 24 Bayer Pattern No No Yes (2 lines) Yes 566 900 Acq_DualBaseLineGray 48k x 16M 2 BASE x: 4y: 1 16 Grayscale 8, 10 packed, 12 packed, or 16 Grayscale Yes, horizontal 1, 2, 3, 4 (horizontal) No No 255 1800 Acq_DualBaseLineRGB 32k x 16M 2 BASE x: 1y: 1 8 per color component BGR 24 RGB Yes, horizontal 1, 2, 4 (horizontal) No Yes 85 1800 Acq_SingleFullLineBayer_RB_GG 16k x 16M 1 FULL x: 8y: 1 8 per color component BGR 24 Bayer Pattern Yes, horizontal 8, 10 (horizontal) Yes (2 lines) Yes 850 1800 Acq_SingleFullLineBayer_RG_GB 16k x 16M 1 FULL x: 8y: 1 8 per color component BGR 24 Bayer Pattern Yes, horizontal 8, 10 (horizontal) Yes (2 lines) Yes 566 1800 Acq_SingleFullLineGray 51k x 16M 1 FULL x: 8y: 1 10 Grayscale 8, 10 packed, or 16 Grayscale Yes, horizontal 8, 10 (horizontal) No No 850 1800 Acq_SingleFullLineRGB 32k x 16M 1 FULL x: 4y: 1 10 per color component BGR 24, 30 packed, or 48 RGB Yes, horizontal 1, 2, 4 (horizontal) No Yes 284 1800 Acq_SingleMediumLineGray 48k x 16M 1 MEDIUM x: 8y: 1 12 Grayscale 8, 10 packed, 12 packed, or 16 Grayscale Yes, horizontal 1, 2, 3, 4 (horizontal) No No 340 1800 Acq_SingleMediumLineRGB 32k x 16M 1 MEDIUM x: 4y: 1 12 per color component BGR 24, 30 packed, 36 packed, or 48 RGB Yes, horizontal 1, 2, 4 (horizontal) No Yes 170 1800"},{"location":"acquisition-applets-for-marathon-vcl.html#frame-grabber-test-applet","title":"Frame Grabber Test Applet","text":"<p>This applet is a frame grabber test applet. Its purpose is to test the hardware.</p> <p>The applet offers the following features:</p> Feature Explanation DMA Performance Test Tests different image dimensions for varying memory sizes and interrupt rates RAM Test Checks for errors and processing Check Camera Port Image Acquisition Checks camera port image acquisition Send Trigger Signals to Camera Sends trigger signals to camera GPIO Monitoring Monitors the GPIs and set the GPOs Event Test Generates a software callback event General Monitoring Monitors FPGA temperature, power management, PoCXP, etc."},{"location":"acquisition-applets-for-marathon-vcl.html#using-acquisition-applets","title":"Using Acquisition Applets","text":"<p>Find here general information about using the applets with the Framegrabber SDK:  Acquisition Applets.</p>"},{"location":"acquisition-applets-for-marathon-vcl.html#installing-applets","title":"Installing Applets","text":"<p>Before you can use a specific applet on your frame grabber, you must install it on the frame grabber. Instructions for installing the applets are available at Managing Applets (microDiagnostics).</p>"},{"location":"acquisition-applets-for-marathon-vcl.html#adding-an-applet-manually","title":"Adding an Applet Manually","text":"<p>To add an applet you received as *.dll file (and not in form of an installer) to your host file system:</p> <ol> <li>Get the applet file (*.dll) you have received.</li> <li>Copy this file into the following directory: &lt;Framegrabber SDK directory&gt;/Dll/&lt;Frame grabber model&gt;</li> </ol> <p>Now you can use the new applet.</p>"},{"location":"acquisition-applets-for-marathon-vcl.html#testing-image-acquisition","title":"Testing Image Acquisition","text":"<p>Before you start using an applet in your own software (via API), you might want to test the system set-up or an individual applet (and its parametrization options).</p> <p>For this purpose, you are provided with the tool microDisplay X that has been installed on your computer as part of the Framegrabber SDK environment. For instructions how to load and test your applet, see Configuring the Applet (microDisplay X).</p>"},{"location":"acquisition-applets-for-marathon-vcl.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration. For more information, see Other Tasks (microDisplay X).</p> <ol> <li> <p>Framegrabber SDK version 5.9 doesn't support mE5 frame grabbers.\u00a0\u21a9</p> </li> <li> <p>k Px and M Px in this case refer to a binary format. Examples for binary calculations are:</p> <p>16M px = 16384k px = 16777216 px</p> <p>8M px = 8192k px = 8388608 px</p> <p>64k px = 65536 px</p> <p>48k px = 49152 px</p> <p>32k px = 32768 px</p> <p>16k px = 16384 px\u00a0\u21a9\u21a9</p> </li> <li> <p>The actual DMA bandwidth depends on the specific mainboard and chip set of the host computer.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"acquisition-applets-for-marathon-vclx.html","title":"Acquisition Applets for marathon VCLx","text":"<p>This topic tells you about the acquisition applets available for the marathon VCLx frame grabber.</p> <p>The functionality of a frame grabber is defined by a specific hardware-related program. This hardware implementation is called applet. For each frame grabber, several applets are available.</p> <p>By loading an applet onto the frame grabber, you define the functionality of the frame grabber and adapt it to the requirements of your specific application.</p> <p>The acquisition applets for marathon VCLx are included in the Framegrabber SDK.</p> <p>On marathon frame grabbers, an applet is available as soon as it is flashed onto the frame grabber.</p>"},{"location":"acquisition-applets-for-marathon-vclx.html#requirements","title":"Requirements","text":"<ul> <li>Host software: Framegrabber SDK (5.7, 5.10<sup>a</sup>, or higher)   with hardware-dependent acquisition applets</li> <li>Hardware: A marathon VCLx frame grabber is connected to your system</li> </ul> <p>Limitation</p> <p>In all applets, buffers larger than 4GB can't be allocated. Even if the applet allows a larger buffer size, you can't allocate buffers larger than 4GB due to limitations in the driver and firmware.</p> <p>You can calculate the buffer size as follows:</p> <p>Buffer size = image height * image width * (pixel width / 8).</p> <p>For RGB images: buffer size = (image height * image width * (pixel width / 8)) * 3 .</p>"},{"location":"acquisition-applets-for-marathon-vclx.html#documentation","title":"Documentation","text":"<p>The following sections provide links to the acquisition applets documentation:</p> Area Acquisition Applets Line Acquisition Applets Test Applet Acq_SingleFullAreaBayer PDF Acq_SingleFullAreaGray PDF Acq_SingleFullLineGray PDF Acq_SingleFullAreaRGB PDF Acq_SingleFullLineRGB PDF Acq_SingleMediumAreaBayer PDF Acq_SingleMediumAreaGray PDF Acq_SingleMediumLineGray PDF Acq_SingleMediumAreaRGB PDF Acq_SingleMediumLineRGB PDF Acq_DualBaseAreaBayer PDF Acq_DualBaseAreaGray PDF Acq_DualBaseLineGray PDF Acq_DualBaseAreaRGB PDF Acq_DualBaseLineRGB PDF FrameGrabberTest PDF"},{"location":"acquisition-applets-for-marathon-vclx.html#area-scan-acquisition-applets","title":"Area Scan Acquisition Applets","text":"<p>The following Area Scan Acquisition Applets are available:</p> <ul> <li>Acq_DualBaseAreaBayer</li> <li>Acq_DualBaseAreaGray</li> <li>Acq_DualBaseAreaRGB</li> <li>Acq_SingleFullAreaBayer</li> <li>Acq_SingleFullAreaGray</li> <li>Acq_SingleFullAreaRGB</li> <li>Acq_SingleMediumAreaBayer</li> <li>Acq_SingleMediumAreaGray</li> <li>Acq_SingleMediumAreaRGB</li> </ul> <p>The denominators \"single\" and \"dual\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Area Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-vclx.html#choosing-the-right-area-scan-acquisition-applet","title":"Choosing the Right Area Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the image received from the camera can't be processed or displayed correctly or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 2 2 Bayer Pattern Acq_SingleFullAreaBayerAcq_SingleMediumAreaBayer x: 16; y: 1x: 8; y: 1 1 2 2 Grayscale Acq_SingleFullAreaGrayAcq_SingleMediumAreaGray x: 16; y: 1x: 8; y: 1 1 2 2 RGB Acq_SingleFullAreaRGBAcq_SingleMediumAreaRGB x: 8; y: 1x: 4; y: 1 2 1 2 Bayer Pattern Acq_DualBaseAreaBayer x: 8y: 1 2 1 2 Grayscale Acq_DualBaseAreaGray x: 8y: 1 2 1 2 RGB Acq_DualBaseAreaRGB x: 8y: 1"},{"location":"acquisition-applets-for-marathon-vclx.html#specifications-common-to-all-area-scan-acquisition-applets","title":"Specifications Common to All Area Scan Acquisition Applets","text":"Max. Image Size [px] 16k x 64k<sup>b</sup> Camera Clock Max. 85 MHz Image Selector Yes LUT Full resolution Bandwidth Total DMA [MB/s] <sup>c</sup> 1800"},{"location":"acquisition-applets-for-marathon-vclx.html#specifications-differing-between-area-scan-acquisition-applets","title":"Specifications Differing Between Area Scan Acquisition Applets","text":"Camera Ports Camera Type ROI Step Size [px] Bit Depth Processing [bit] Bit Depth Output [bit] Mode Mirroring Tap Geometry Sorting Bayer Color Reconstruction (HQe) White Balance Bandwidth: Mean per Camera [MP/s] Acq_DualBaseAreaBayer 2 BASE x: 8y: 1 12 per color component BGR 24, 30 packed, 36 packed, or 48 Bayer Pattern Yes, horizontal and vertical 1, 2, 4 (horizontal and vertical) Yes, High Quality Extended (HQe) Yes 255 Acq_DualBaseAreaGray 2 BASE x: 8y: 1 16 Grayscale 8, 10 packed, 12 packed, or 16 Grayscale Yes, horizontal and vertical 1, 2, 4 (horizontal and vertical) No No 255 Acq_DualBaseAreaRGB 2 BASE x: 8y: 1 8 per color component BGR 24 RGB Yes, horizontal and vertical 1, 2, 4 (horizontal and vertical) No Yes 85 Acq_SingleFullAreaBayer 1 FULL x: 16y: 1 10 per color component BGR 24, 30 packed, or 48 Bayer Pattern Yes, horizontal 8, 10 (horizontal) Yes, High Quality Extended (HQe) Yes 850 Acq_SingleFullAreaGray 1 FULL x: 16y: 1 10 Grayscale 8, 10 packed, 16 Grayscale Yes, horizontal 8, 10 (horizontal) No No 850 Acq_SingleFullAreaRGB 1 FULL x: 8y: 1 10 per color component BGR 24, 30 packed, or 48 RGB Yes, horizontal 1, 2, 4 (horizontal and vertical) No Yes 284 Acq_SingleMediumAreaBayer 1 MEDIUM x: 8y: 1 12 per color component BGR 24, 30 packed, 36 packed, or 48 Bayer Pattern Yes, horizontal and vertical 1, 2, 4 (horizontal and vertical) Yes, High Quality Extended (HQe) Yes 340 Acq_SingleMediumAreaGray 1 MEDIUM x: 8y: 1 12 Grayscale 8, 10 packed, 16 Grayscale Yes, horizontal and vertical 1, 2, 4 (horizontal and vertical) No No 340 Acq_SingleMediumAreaRGB 1 MEDIUM x: 4y: 1 12 per color component BGR 24, 30 packed, 36 packed, or 48 RGB Yes, horizontal and vertical 1, 2, 4 (horizontal and vertical) No Yes 170"},{"location":"acquisition-applets-for-marathon-vclx.html#line-scan-acquisition-applets","title":"Line Scan Acquisition Applets","text":"<p>The following Line Scan Acquisition Applets are available:</p> <ul> <li>Acq_SingleFullLineGray</li> <li>Acq_SingleFullLineRGB</li> <li>Acq_SingleMediumLineGray</li> <li>Acq_SingleMediumLineRGB</li> <li>Acq_DualBaseLineGray</li> <li>Acq_DualBaseLineRGB</li> </ul> <p>The denominators \"single\" and \"dual\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Line Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-vclx.html#choosing-the-right-line-scan-acquisition-applet","title":"Choosing the Right Line Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the camera may not work or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 2 2 Grayscale Acq_SingleFullLineGrayAcq_SingleMediumLineGray x: 8; y: 1x: 8; y: 1 1 2 2 RGB Acq_SingleFullLineRGBAcq_SingleMediumLineRGB x: 4; y: 1x: 4; y: 1 2 1 2 Grayscale Acq_DualBaseLineGray x: 4y: 1 2 1 2 RGB Acq_DualBaseLineRGB x: 1y: 1"},{"location":"acquisition-applets-for-marathon-vclx.html#specifications-common-to-all-line-scan-acquisition-applets","title":"Specifications Common to All Line Scan Acquisition Applets","text":"Mirroring Yes, horizontal Camera Clock 85 MHz Image Selector Yes Bayer Color Reconstruction (HQe) No LUT Full resolution Bandwidth Total DMA (MB/s) <sup>c</sup> 1800"},{"location":"acquisition-applets-for-marathon-vclx.html#specifications-differing-between-line-scan-acquisition-applets","title":"Specifications Differing Between Line Scan Acquisition Applets","text":"Image Size [px] <sup>b</sup> Camera Ports Camera Type ROI Step Size [px] Bit Depth Processing [bit] Bit Depth Output [bit] Mode Tap Geometry Sorting White Balance Bandwidth: Mean per Camera [MP/s] Acq_DualBaseLineGray 48k x 16M 2 BASE x: 4y: 1 16 Grayscale 8, 10 packed, 12 packed, or 16 Grayscale 1, 2, 3, 4 (horizontal) No 255 Acq_DualBaseLineRGB 32k x 16M 2 BASE x: 1y: 1 8 per color component BGR 24 RGB 1, 2, 4 (horizontal) Yes 85 Acq_SingleFullLineGray 51k x 16M 1 FULL x: 8y: 1 10 Grayscale 8, 10 packed, or 16 Grayscale 8, 10 (horizontal) No 850 Acq_SingleFullLineRGB 32k x 16M 1 FULL x: 4y: 1 10 per color component BGR 24, 30 packed, or 48 RGB 1, 2, 4 (horizontal) Yes 284 Acq_SingleMediumLineGray 48k x 16M 1 MEDIUM x: 8y: 1 12 Grayscale 8, 10 packed, 12 packed, or 16 Grayscale 1, 2, 3, 4 (horizontal) No 340 Acq_SingleMediumLineRGB 32k x 16M 1 MEDIUM x: 4y: 1 12 per color component BGR 24, 30 packed, 36 packed, or 48 RGB 1, 2, 4 (horizontal) Yes 170"},{"location":"acquisition-applets-for-marathon-vclx.html#frame-grabber-test-applet","title":"Frame Grabber Test Applet","text":"<p>This applet is a frame grabber test applet. Its purpose is to test the hardware.</p> <p>The applet offers the following features:</p> Feature Explanation DMA Performance Test Tests different image dimensions for varying memory sizes and interrupt rates RAM Test Checks for errors and processing Check Camera Port Image Acquisition Checks camera port image acquisition Send Trigger Signals to Camera Sends trigger signals to camera GPIO Monitoring Monitors the GPIs and set the GPOs Event Test Generates a software callback event General Monitoring Monitors FPGA temperature, power management, PoCXP, etc."},{"location":"acquisition-applets-for-marathon-vclx.html#using-acquisition-applets","title":"Using Acquisition Applets","text":"<p>Find here general information about using the applets with the Framegrabber SDK:  Acquisition Applets.</p>"},{"location":"acquisition-applets-for-marathon-vclx.html#installing-applets","title":"Installing Applets","text":"<p>Before you can use a specific applet on your frame grabber, you must install it on the frame grabber. Instructions for installing the applets are available at Managing Applets (microDiagnostics).</p>"},{"location":"acquisition-applets-for-marathon-vclx.html#adding-an-applet-manually","title":"Adding an Applet Manually","text":"<p>To add an applet you received as *.dll file (and not in form of an installer) to your host file system:</p> <ol> <li>Get the applet file (*.dll) you have received.</li> <li>Copy this file into the following directory: &lt;Framegrabber SDK directory&gt;/Dll/&lt;Frame grabber model&gt;</li> </ol> <p>Now you can use the new applet.</p>"},{"location":"acquisition-applets-for-marathon-vclx.html#testing-image-acquisition","title":"Testing Image Acquisition","text":"<p>Before you start using an applet in your own software (via API), you might want to test the system set-up or an individual applet (and its parametrization options).</p> <p>For this purpose, you are provided with the tool microDisplay X that has been installed on your computer as part of the Framegrabber SDK environment. For instructions how to load and test your applet, see Configuring the Applet (microDisplay X).</p>"},{"location":"acquisition-applets-for-marathon-vclx.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration. For more information, see Other Tasks (microDisplay X).</p> <ol> <li> <p>Framegrabber SDK version 5.9 doesn't support mE5 frame grabbers.\u00a0\u21a9</p> </li> <li> <p>k Px and M Px in this case refer to a binary format. Examples for binary calculations are:</p> <p>16M px = 16384k px = 16777216 px</p> <p>8M px = 8192k px = 8388608 px</p> <p>64k px = 65536 px</p> <p>48k px = 49152 px</p> <p>32k px = 32768 px</p> <p>16k px = 16384 px\u00a0\u21a9\u21a9</p> </li> <li> <p>The actual DMA bandwidth depends on the specific mainboard and chip set of the host computer.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"acquisition-applets-for-marathon-vcx-qp.html","title":"Acquisition Applets for marathon VCX-QP","text":"<p>This topic tells you about the acquisition applets available for the marathon VCX-QP frame grabber.</p> <p>The functionality of a frame grabber is defined by a specific hardware-related program. This hardware implementation is called applet. For each frame grabber, several applets are available.</p> <p>By loading an applet onto the frame grabber, you define the functionality of the frame grabber and adapt it to the requirements of your specific application.</p> <p>The acquisition applets for marathon VCX-QP are included in the Framegrabber SDK.</p> <p>On marathon frame grabbers, an applet is available as soon as it is flashed onto the frame grabber.</p>"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#requirements","title":"Requirements","text":"<ul> <li>Host software: Framegrabber SDK (5.7, 5.10<sup>a</sup>, or higher)   with hardware-dependent acquisition applets</li> <li>Hardware: A marathon VCX-QP frame grabber is connected to your system</li> </ul> <p>Limitation</p> <p>In all applets, buffers larger than 4GB can't be allocated. Even if the applet allows a larger buffer size, you can't allocate buffers larger than 4GB due to limitations in the driver and firmware.</p> <p>You can calculate the buffer size as follows:</p> <p>Buffer size = image height * image width * (pixel width / 8).</p> <p>For RGB images: buffer size = (image height * image width * (pixel width / 8)) * 3 .</p>"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#documentation","title":"Documentation","text":"<p>The following sections provide links to the acquisition applets documentation:</p> Area Acquisition Applets Line Acquisition Applets Test Applet Acq_SingleCXP6x4AreaBayer PDF Acq_SingleCXP6x4AreaGray PDF Acq_SingleCXP6x4LineGray PDF Acq_SingleCXP6x4AreaRGB PDF Acq_SingleCXP6x4LineRGB PDF Acq_DualCXP6x2AreaBayer PDF Acq_DualCXP6x2AreaGray PDF Acq_DualCXP6x2LineGray PDF Acq_DualCXP6x2AreaRGB PDF Acq_DualCXP6x2LineRGB PDF Acq_QuadCXP6x1AreaBayer PDF Acq_QuadCXP6x1AreaGray PDF Acq_QuadCXP6x1LineGray PDF Acq_QuadCXP6x1AreaRGB PDF Acq_QuadCXP6x1LineRGB PDF FrameGrabberTest PDF"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#area-scan-acquisition-applets","title":"Area Scan Acquisition Applets","text":"<p>The following Area Scan Acquisition Applets are available:</p> <ul> <li>Acq_DualCXP6x2AreaBayer</li> <li>Acq_DualCXP6x2AreaGray</li> <li>Acq_DualCXP6x2AreaRGB</li> <li>Acq_QuadCXP6x1AreaBayer</li> <li>Acq_QuadCXP6x1AreaGray</li> <li>Acq_QuadCXP6x1AreaRGB</li> <li>Acq_SingleCXP6x4AreaBayer</li> <li>Acq_SingleCXP6x4AreaGray</li> <li>Acq_SingleCXP6x4AreaRGB</li> </ul> <p>The denominators \"single\", \"dual\", and \"quad\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Area Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#choosing-the-right-area-scan-acquisition-applet","title":"Choosing the Right Area Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the image received from the camera can't be processed or displayed correctly or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 4 4 Bayer Pattern Acq_SingleCXP6x4AreaBayer x: 8y: 1 1 4 4 Grayscale Acq_SingleCXP6x4AreaGray x: 16y: 1 1 4 4 RGB Acq_SingleCXP6x4AreaRGB x: 8y: 1 2 2 4 Bayer Pattern Acq_DualCXP6x2AreaBayer x: 8y: 1 2 2 4 Grayscale Acq_DualCXP6x2AreaGray x: 16y: 1 2 2 4 RGB Acq_DualCXP6x2AreaRGB x: 4y: 1 4 1 4 Bayer Pattern Acq_QuadCXP6x1AreaBayer x: 4y: 1 4 1 4 Grayscale Acq_QuadCXP6x1AreaGray x: 8y: 1 4 1 4 RGB Acq_QuadCXP6x1AreaRGB x: 4y: 1"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#specifications-common-to-all-area-scan-acquisition-applets","title":"Specifications Common to All Area Scan Acquisition Applets","text":"Camera Type CXP-6 Mirroring Yes, horizontal and vertical Event Generation Yes Image Selector Yes LUT Full resolution Bandwidth Total DMA [MB/s] <sup>b</sup> 1800"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#specifications-differing-between-area-scan-acquisition-applets","title":"Specifications Differing Between Area Scan Acquisition Applets","text":"Camera Ports Max. Image Size [px] <sup>c</sup> ROI Step Size [px] Bit Depth Processing [bit] Bit Depth Output [bit] Mode Bayer Color Reconstruction (HQe) White Balance Bandwidth: Mean per Camera [MP/s] Acq_DualCXP6x2AreaBayer 2 16k x 64k x: 8y: 1 14 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 Bayer Pattern Yes, High Quality Extended (HQe) Yes 1200 Acq_DualCXP6x2AreaGray 2 64k x 64k x: 16y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No No 1200 Acq_DualCXP6x2AreaRGB 2 64k x 64k x: 4y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB No Yes 400 Acq_QuadCXP6x1AreaBayer 4 8k x 64k x: 4y: 1 14 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 Bayer Pattern Yes, High Quality Extended (HQe) Yes 600 Acq_QuadCXP6x1AreaGray 4 64k x 64k x: 8y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No No 600 Acq_QuadCXP6x1AreaRGB 4 64k x 64k x: 4y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB No Yes 200 Acq_SingleCXP6x4AreaBayer 1 48k x 48k x: 8y: 1 14 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 Bayer Pattern Yes, High Quality Extended (HQe) Yes 2400 Acq_SingleCXP6x4AreaGray 1 64k x 64k x: 16y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No No 2400 Acq_SingleCXP6x4AreaRGB 1 64k x 64k x: 8y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB No Yes 800"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#line-scan-acquisition-applets","title":"Line Scan Acquisition Applets","text":"<p>The following Line Scan Acquisition Applets are available:</p> <ul> <li>Acq_DualCXP6x2LineGray</li> <li>Acq_DualCXP6x2LineRGB</li> <li>Acq_QuadCXP6x1LineGray</li> <li>Acq_QuadCXP6x1LineRGB</li> <li>Acq_SingleCXP6x4LineGray</li> <li>Acq_SingleCXP6x4LineRGB</li> </ul> <p>The denominators \"single\", \"dual\", and \"quad\" in the name of the applet refer to the maximum number of cameras you can connect. For more information, see Choosing the Right Line Scan Acquisition Applet.</p>"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#choosing-the-right-line-scan-acquisition-applet","title":"Choosing the Right Line Scan Acquisition Applet","text":"<p>You must choose the right applet for your camera setup. Otherwise, the camera may not work or camera performance may be reduced significantly.</p> <p>Which applet is the right one depends on the number of cameras, the number of channels per camera, and the desired ROI step size.</p> <p>The ROI step size depends on the parallelism of the image preprocessing and therefore varies by camera and frame grabber.</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Applet ROI Step Size [px] Topology 1 4 4 Grayscale Acq_SingleCXP6x4LineGray x: 16y: 1 1 4 4 RGB Acq_SingleCXP6x4LineRGB x: 8y: 1 2 2 4 Grayscale Acq_DualCXP6x2LineGray x: 16y: 1 2 2 4 RGB Acq_DualCXP6x2LineRGB x: 4y: 1 4 1 4 Grayscale Acq_QuadCXP6x1LineGray x: 8y: 1 4 1 4 RGB Acq_QuadCXP6x1LineRGB x: 4y: 1"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#specifications-common-to-all-line-scan-acquisition-applets","title":"Specifications Common to All Line Scan Acquisition Applets","text":"Max. Image Size [px] 64k x 8M<sup>c</sup> Camera Type CXP-6 Mirroring Yes, horizontal and vertical Event Generation Yes Image Selector Yes Bayer Color Reconstruction (HQe) No LUT Full resolution Bandwidth Total DMA [MB/s] <sup>b</sup> 1800"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#specifications-differing-between-line-scan-acquisition-applets","title":"Specifications Differing Between Line Scan Acquisition Applets","text":"Camera Ports ROI Step Size [px] Bit Depth Processing [bit] Bit Depth Output [bit] Mode White Balance Bandwidth: Mean per Camera [MP/s] Acq_DualCXP6x2LineGray 2 x: 16y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No 1200 Acq_DualCXP6x2LineRGB 2 x: 4y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB Yes 400 Acq_QuadCXP6x1LineGray 4 x: 8y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No 600 Acq_QuadCXP6x1LineRGB 4 x: 4y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB Yes 200 Acq_SingleCXP6x4LineGray 1 x: 16y: 1 16 Grayscale 8, 10 packed, 12 packed, 14 packed, or 16 Grayscale No 2400 Acq_SingleCXP6x4LineRGB 1 x: 8y: 1 16 per color component BGR 24, 30 packed, 36 packed, 42 packed, or 48 RGB Yes 800"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#frame-grabber-test-applet","title":"Frame Grabber Test Applet","text":"<p>This applet is a frame grabber test applet. Its purpose is to test the hardware.</p> <p>The applet offers the following features:</p> Feature Explanation DMA Performance Test Tests different image dimensions for varying memory sizes and interrupt rates RAM Test Checks for errors and processing Check Camera Port Image Acquisition Checks camera port image acquisition Send Trigger Signals to Camera Sends trigger signals to camera GPIO Monitoring Monitors the GPIs and set the GPOs Event Test Generates a software callback event General Monitoring Monitors FPGA temperature, power management, PoCXP, etc."},{"location":"acquisition-applets-for-marathon-vcx-qp.html#using-acquisition-applets","title":"Using Acquisition Applets","text":"<p>Find here general information about using the applets with the Framegrabber SDK:  Acquisition Applets.</p>"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#installing-applets","title":"Installing Applets","text":"<p>Before you can use a specific applet on your frame grabber, you must install it on the frame grabber. Instructions for installing the applets are available at Managing Applets (microDiagnostics).</p>"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#adding-an-applet-manually","title":"Adding an Applet Manually","text":"<p>To add an applet you received as *.dll file (and not in form of an installer) to your host file system:</p> <ol> <li>Get the applet file (*.dll) you have received.</li> <li>Copy this file into the following directory: &lt;Framegrabber SDK directory&gt;/Dll/&lt;Frame grabber model&gt;</li> </ol> <p>Now you can use the new applet.</p>"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#testing-image-acquisition","title":"Testing Image Acquisition","text":"<p>Before you start using an applet in your own software (via API), you might want to test the system set-up or an individual applet (and its parametrization options).</p> <p>For this purpose, you are provided with the tool microDisplay X that has been installed on your computer as part of the Framegrabber SDK environment. For instructions how to load and test your applet, see Configuring the Applet (microDisplay X).</p>"},{"location":"acquisition-applets-for-marathon-vcx-qp.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration. For more information, see Other Tasks (microDisplay X).</p> <ol> <li> <p>Framegrabber SDK version 5.9 doesn't support mE5 frame grabbers.\u00a0\u21a9</p> </li> <li> <p>The actual DMA bandwidth depends on the specific mainboard and chip set of the host computer.\u00a0\u21a9\u21a9</p> </li> <li> <p>k Px and M Px in this case refer to a binary format. Examples for binary calculations are:</p> <p>16M px = 16384k px = 16777216 px</p> <p>8M px = 8192k px = 8388608 px</p> <p>64k px = 65536 px</p> <p>48k px = 49152 px</p> <p>32k px = 32768 px</p> <p>16k px = 16384 px\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"acquisition-applets.html","title":"Acquisition Applets","text":"<p>This topic tells you how to use the acquisition applets with the Framegrabber SDK.</p>"},{"location":"acquisition-applets.html#available-applets","title":"Available Applets","text":"<p>For information about the specific applets, see the documentation of your frame grabber:</p> <ul> <li>imaFlex CXP-12 Penta</li> <li>imaFlex CXP-12 Quad</li> <li>imaWorx CXP-12 Quad</li> <li>marathon ACX-SP</li> <li>marathon ACX-DP</li> <li>marathon ACX-QP</li> <li>marathon VCX-QP</li> <li>marathon ACL</li> <li>marathon VCL</li> <li>marathon VCLx</li> </ul>"},{"location":"acquisition-applets.html#using-acquisition-applets-with-the-framegrabber-sdk","title":"Using Acquisition Applets with the Framegrabber SDK","text":"<p>When is an applet available?</p> <ul> <li>On imaWorx and imaFlex frame grabbers, an applet is available as soon as it is available in the file system of your computer (Framegrabber SDK installation directory, sub-directories DLL or Hardware Applets). If the applet isn't there, run the applet installer that contains the applet you want to use, or, if you need an applet created with VisualApplets, copy the applet file (*.hap) into the Hardware Applets folder of your Framegrabber SDK installation (e.g., <code>...\\Basler\\FramegrabberSDK5.x.x\\Hardware Applets\\*.hap</code>).</li> <li>On marathon frame grabbers, an applet is available as soon as it is flashed onto the frame grabber. If the applet you want to use isn't flashed on the frame grabber yet, flash it according to the instructions in Managing Applets (microDiagnostics).</li> </ul>"},{"location":"acquisition-applets.html#pre-installed-applet","title":"Pre-Installed Applet","text":"<p>Your frame grabber is shipped with at least one pre-installed applet. The installed applet/applets are suitable for a first check of the overall system functionality. Later on (when you start to adapt the system to your specific image acquisition requirements), you may need to flash other applets onto Your frame grabber.</p> <p>The firmware for your frame grabber comes together with the applet in one *.dll or *.hap file. It is loaded onto the frame grabber together with the applet at FPGA configuration. Thus, when selecting an applet for your frame grabber, you don't need to bother about firmware versions and compatibilities.</p> <p>Basler provides a wide range of image acquisition and processing applets.</p> <p>Once you have made your decision, see Flashing or refer to the Framegrabber API documentation to learn how to get the firmware/applet onto marathon ACX-QP.</p>"},{"location":"acquisition-applets.html#hap-files-and-dll-files","title":"*.hap Files and *.dll Files","text":"<p>There are two kinds of applets: acquisition applets (*.dll) always delivered by Basler, and custom applets (*.hap) developed in VisualApplets either by yourself or by Basler.</p> Acquisition Applets Custom Applets Applet Functionality An acquisition applet is a compilation of specific image acquisition and processing functions that are combined to meet the requirements of a specific application field. Custom applets (also called VA applets) are designed to meet specific application purposes that aren't covered by one of the acquisition applets. Developed by Acquisition applets are developed by Basler. They are provided with the Framegrabber SDK delivery. VA applets are developed using the graphical programming environment VisualApplets (VA). The programming can be done either by Basler or by you. Prerequisite for programming VA applets yourself is that you hold a VisualApplets license. File Extension Acquisition applets have the file extension *.dll. VA applets have the file extension *.hap. Distribution Acquisition applets are provided by Basler in form of an applet set. The applet set for your frame grabber contains all acquisition applets for your frame grabber. VA applets always come as single *.hap file."},{"location":"acquisition-applets.html#installing-applets","title":"Installing Applets","text":"<p>Before you can use a specific applet on your frame grabber, you must install it on the frame grabber. Instructions for installing the applets are available at Managing Applets (microDiagnostics).</p>"},{"location":"acquisition-applets.html#adding-an-applet-manually","title":"Adding an Applet Manually","text":"<p>To add an applet you received as *.dll file (and not in form of an installer) to your host file system:</p> <ol> <li>Get the applet file (*.dll) you have received.</li> <li>Copy this file into the following directory: &lt;Framegrabber SDK directory&gt;/Dll/&lt;Frame grabber model&gt;</li> </ol> <p>Now you can use the new applet.</p>"},{"location":"acquisition-applets.html#testing-image-acquisition","title":"Testing Image Acquisition","text":"<p>Before you start using an applet in your own software (via API), you might want to test the system set-up or an individual applet (and its parametrization options).</p> <p>For this purpose, you are provided with the tool microDisplay X that has been installed on your computer as part of the Framegrabber SDK environment. For instructions how to load and test your applet, see Configuring the Applet (microDisplay X).</p>"},{"location":"acquisition-applets.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration. For more information, see Other Tasks (microDisplay X).</p>"},{"location":"bandwidth-information-in-microdiagnostics.html","title":"Bandwidth Information in microDiagnostics","text":"<p>When you open microDiagnostics, the tool scans the environment and provides you with some basic PCIe speed information in the log:</p> <p></p> <p>If you are using a PCIe slot that provides less PCIe lanes or a lower PCIe generation than possible for your frame grabber, the data transfer rate will be reduced. You are informed in microDiagnostics as follows:</p> <p></p> <p>To get detailed information about the actual bandwidth for your frame grabber:</p> <ol> <li>Open microDiagnostics.</li> <li>Select a board in the left upper corner.</li> <li>From the menu, select Diagnosis -&gt; Performance.</li> </ol> <p>The performance test gets started. The test is carried out for the applet that is the currently active applet on the frame grabber.</p> <p>The results of the performance test are displayed. You see the actual transfer rates for example image sizes (on the X axis, the image dimensions are stated (image width = image height):</p> <p></p> <p>The results will always be applet throughput max. bandwidth.</p> <p>You can run the performance test for all applets designed for your frame grabber.</p> <p>Info</p> <p>To find out about the maximum bandwidth of the frame grabber without regard to any applet specifics, use the Frame Grabber Test Applet (FrameGrabberTest) for testing the performance. The results inform you about the full frame grabber bandwidth available under the specific conditions (like PCIe generation provided by PCIe slot, available PCIe lanes, etc.).</p> <p>To test the performance with another applet:</p> <ol> <li>Select the applet you want to test on from the drop down list in the bottom area of the program window.</li> <li> <p>Repeat the performance test by selecting Diagnosis-&gt;Performance.</p> <p></p> </li> </ol>"},{"location":"binning-imaflex.html","title":"Binning (imaFlex CXP-12 Quad)","text":"<p>The Binning feature allows you to combine sensor pixel values into a single value.</p> <p>This may increase the signal-to-noise ratio, the camera's response to light, or the frame rate.</p>"},{"location":"binning-imaflex.html#binning-on-frame-grabbers","title":"Binning on Frame Grabbers","text":"<p>The applet offers several parameters to configure the binning. First, it's important to understand that in accordance to GenICam ROI (region of interest) width, height, and offsets define the image size after binning. For example, if your camera outputs an image width of 5120 and you want to use a horizontal binning by a factor of two, you must set a grabber ROI to 2560 and a binning factor of two.</p> <p>The following figure illustrates the behavior:</p> <p></p> <p>By default, the GenTL producer automatically configures the frame grabber ROI to synchronize it with the camera as described in Using the GenTL Interface. As for binning, you must set an ROI which isn't equal to the camera width and height, the Automatic ROI Control feature has to be disabled first. For the example above, set the following parameters in the correct order. All parameters are GenTL camera device parameters e.g. in the C++ pylon API:</p> <ul> <li> <p><code>Automatic ROI Control</code> = <code>false</code></p> <p></p> </li> <li> <p><code>Width</code>= <code>2560</code></p> </li> <li> <p><code>Height</code> = <code>5120</code></p> <p></p> </li> <li> <p>For Sensor Geometry, set the <code>Sensor Width</code> = <code>5120</code>and the <code>Sensor Height</code> = <code>5120</code>.</p> <p></p> </li> <li> <p>In category <code>Binning</code>, set <code>Horizontal Binning</code> = <code>2</code>, and <code>Vertical Binning</code> = <code>1</code></p> <p></p> </li> </ul> <p>You can calculate the average value out of the binning pixel to increase the signal-to-noise ratio without affecting the camera's response to light. Alternatively, you can sum up the pixels to increase the camera's response to light. To do so, select the <code>BinningHorizontalMode</code> and <code>BinningVerticalMode</code> parameters. The following images show the effect on a cameras' standard test pattern.</p> <p>Test Pattern Binning Horizontal Average:</p> <p></p> <p>Test Pattern Binning Horizontal Sum:</p> <p></p> <p>The frame grabber can't perform binning on sensor level as it's done inside cameras. Hence, if possible, a high bit rate should be used to transfer the pixel from the camera to the frame grabber and process the binning. Afterwards, the bit rate can be reduced at the DMA for the frame grabber to the computer memory transfer. Thus, choose the highest available camera bit width which allows the use at the desired frame rate.</p> <p>Again, the GenTL producer automatically configures the frame grabber setting to match with the camera. If you want to use the high bit width throughout the whole processing up to the computer memory, set the <code>PixelFormat</code> to the desired bit width inside the camera. However, if you want to reduce the bit width after the binning feature, disable the automatic frame grabber configuration of the GenTL producer. This is shown in the following:</p> <ul> <li> <p>Set the camera <code>Pixel Format</code> to e.g. <code>Mono 10</code></p> <p></p> </li> <li> <p>Set <code>Automatic Format Control</code> = <code>false</code></p> <p></p> </li> <li> <p>Set the frame grabber input pixel format <code>Pixel Format</code> = <code>Mono 10p</code></p> <p></p> </li> <li> <p>Set the frame grabber <code>Output Format</code> = <code>Mono 8</code></p> <p></p> </li> </ul> <p>This configuration gives the same results at a higher precision. To further increase the brightness and overall image quality, you can use the frame grabber features Gain, Offset, or Gamma.</p>"},{"location":"binning-imaworx.html","title":"Binning (imaWorx CXP-12 Quad)","text":"<p>The Binning feature allows you to combine sensor pixel values into a single value.</p> <p>This may increase the signal-to-noise ratio, the camera's response to light, or the frame rate.</p>"},{"location":"binning-imaworx.html#binning-on-frame-grabbers","title":"Binning on Frame Grabbers","text":"<p>The applet offers several parameters to configure the binning. First, it's important to understand that in accordance to GenICam ROI (region of interest) width, height, and offsets define the image size after binning. For example, if your camera outputs an image width of 5120 and you want to use a horizontal binning by a factor of two, you must set a grabber ROI to 2560 and a binning factor of two.</p> <p>The following figure illustrates the behavior:</p> <p></p> <p>By default, the GenTL producer automatically configures the frame grabber ROI to synchronize it with the camera as described in Using the GenTL Interface. As for binning, you must set an ROI which isn't equal to the camera width and height, the Automatic ROI Control feature has to be disabled first. For the example above, set the following parameters in the correct order. All parameters are GenTL camera device parameters e.g. in the C++ pylon API:</p> <ul> <li> <p><code>Automatic ROI Control</code> = <code>false</code></p> <p></p> </li> <li> <p><code>Width</code>= <code>2560</code></p> </li> <li> <p><code>Height</code> = <code>5120</code></p> <p></p> </li> <li> <p>For Sensor Geometry, set the <code>Sensor Width</code> = <code>5120</code>and the <code>Sensor Height</code> = <code>5120</code>.</p> <p></p> </li> <li> <p>In category <code>Binning</code>, set <code>Horizontal Binning</code> = <code>2</code>, and <code>Vertical Binning</code> = <code>1</code></p> <p></p> </li> </ul> <p>You can calculate the average value out of the binning pixel to increase the signal-to-noise ratio without affecting the camera's response to light. Alternatively, you can sum up the pixels to increase the camera's response to light. To do so, select the <code>BinningHorizontalMode</code> and <code>BinningVerticalMode</code> parameters. The following images show the effect on a cameras' standard test pattern.</p> <p>Test Pattern Binning Horizontal Average:</p> <p></p> <p>Test Pattern Binning Horizontal Sum:</p> <p></p> <p>The frame grabber can't perform binning on sensor level as it's done inside cameras. Hence, if possible, a high bit rate should be used to transfer the pixel from the camera to the frame grabber and process the binning. Afterwards, the bit rate can be reduced at the DMA for the frame grabber to the computer memory transfer. Thus, choose the highest available camera bit width which allows the use at the desired frame rate.</p> <p>Again, the GenTL producer automatically configures the frame grabber setting to match with the camera. If you want to use the high bit width throughout the whole processing up to the computer memory, set the <code>PixelFormat</code> to the desired bit width inside the camera. However, if you want to reduce the bit width after the binning feature, disable the automatic frame grabber configuration of the GenTL producer. This is shown in the following:</p> <ul> <li> <p>Set the camera <code>Pixel Format</code> to e.g. <code>Mono 10</code></p> <p></p> </li> <li> <p>Set <code>Automatic Format Control</code> = <code>false</code></p> <p></p> </li> <li> <p>Set the frame grabber input pixel format <code>Pixel Format</code> = <code>Mono 10p</code></p> <p></p> </li> <li> <p>Set the frame grabber <code>Output Format</code> = <code>Mono 8</code></p> <p></p> </li> </ul> <p>This configuration gives the same results at a higher precision. To further increase the brightness and overall image quality, you can use the frame grabber features Gain, Offset, or Gamma.</p>"},{"location":"c-wrapper.html","title":"C# Wrapper","text":"<p>To allow you to use the Framegrabber API in programs you create with C#, you are provided with a C# Framgrabber API wrapper. This wrapper wraps the functionality of the Framegrabber API into a C# API.</p> <p>All C Framegrabber API functions are wrapped as static functions in one C# class SiSoCsRt. The usage and function declaration is in most parts defined as described in the Framegrabber API documentation. The differences are detailed in the following sections.</p>"},{"location":"c-wrapper.html#components-of-the-wrapper","title":"Components of the Wrapper","text":"<p>The C# wrapper is installed together with the Framegrabber SDK.</p> <p>The C# wrapper consists of 2 files, SiSoCsInterface.dll and SiSoCsRt.dll:</p> <ul> <li>SiSoCsRt.dll is the class you use to access the C# API within your code.</li> <li>SiSoCsInterface.dll is the dll that communicates with the Framegrabber API.</li> </ul> <p>In addition, you are provided with some code examples for using the C# wrapper.</p>"},{"location":"c-wrapper.html#preparing-your-project","title":"Preparing Your Project","text":"<p>To get started using the wrapper:</p> <ol> <li>Add a reference to the SiSoCsInterface.dll in your C# project.     You find the file in your Framegrabber SDK installation:     Basler\\FramegrabberSDK5.x.x\\lib</li> <li>Copy <code>SiSoCsRt.dll</code> to your PATH directory before running your program.     You find the file in your Framegrabber SDK installation:     Basler\\FramegrabberSDK5.x.x\\bin</li> </ol>"},{"location":"c-wrapper.html#examples","title":"Examples","text":"<p>To get started with the image acquisition using the wrapper most easily, you find some C# examples in your Framegrabber SDK installation:</p> <p>Basler\\FramegrabberSDK5.x.x\\SDKWrapper\\CSharpWrapper\\Examples</p>"},{"location":"c-wrapper.html#framegrabber-api-mapping","title":"Framegrabber API Mapping","text":""},{"location":"c-wrapper.html#type-mapping","title":"Type Mapping","text":"<p>C data types are mapped to the corresponding C# data types as follows:</p> C Data Types C# Data Types int, int32_t int unsigned int, uint32_t uint int64_t long uint64_t, size_t ulong char * string <p>Pointers are either mapped into arrays or ref/out arguments.</p> <p>In/Out function arguments are defined as <code>ref</code>, while the out function arguments are defined as <code>out</code>. For example:</p> <pre><code>int clGetManufacturerInfo(string manufacturerName, ref uint bufferSize, out uint version)\n</code></pre> <p><code>bufferSize</code> is an in/out argument, while <code>version</code> is an out argument.</p> <p>C enums are directly translated into C# enums.</p> <p>C <code>structs</code> are mapped to C# classes, structs\u2019 fields are either still directly accessible, or via constructors or setters/getters.</p> <p>Void pointers are mapped to different types according to their usage. In many cases, it is mapped to byte.</p>"},{"location":"c-wrapper.html#function-mapping","title":"Function Mapping","text":"<p>Each function of the Framegrabber API has a corresponding public static function in the class <code>SiSoCsRt</code>.</p> <p>Framegrabber API functions that create a reference to a <code>struct</code> and return an error code, are modified such that they return the reference directly (or <code>null</code> if an error occurred), and write back the error code in an out argument. For example, the function <code>Fg_getAppletIterator</code> is defined as:</p> <p>Framegrabber API Definition:</p> <pre><code>int Fg_getAppletIterator(int boardIndex, const enum FgAppletIteratorSource src, Fg_AppletIteratorType * iter, int flags);\n</code></pre> <p>The return value is the result error code, and <code>iter</code> is the created reference.</p> <p>C# Definition:</p> <pre><code>Fg_AppletIteratorType Fg_getAppletIterator(int boardIndex, const enum FgAppletIteratorSource src, int flags, int *errorCode)\n</code></pre> <p>The return value is the created reference, and the result <code>errorCode</code> is the error code.</p>"},{"location":"c-wrapper.html#callback-functions","title":"Callback Functions","text":"<p>Each callback function must have the signature of its corresponding delegate. The <code>SiSoCallback</code> class includes all declarations of the available function delegates.</p> <p>For example, the following code is used to register an APC handler:</p> <pre><code>FgApcControl apcCtrl = new FgApcControl(10000,\n\n(uint)(Fg_Apc_Flag.FG_APC_DELIVER_ERRORS));\n\napcCtrl.setApcCallbackFunction(apcCallback, null);\n</code></pre> <p>The function <code>apcCallback</code> must have the same signature as <code>SiSoCallback.Fg_ApcFuncDelegate</code>, an example implementation is:</p> <pre><code>static int apcCallback(uint imgNr, fg_apc_data userData) {\n\nglobal_imgNr = (int)(imgNr);\n\nreturn 0;\n\n}\n</code></pre> <p>The declaration of <code>SiSoCallback.Fg_ApcFuncDelegate</code> looks as follows:</p> <pre><code>public delegate int Fg_ApcFuncDelegate(uint imgNr, fg_apc_data userData);\n</code></pre>"},{"location":"c-wrapper.html#c-wrapper-api-list","title":"C# Wrapper API List","text":"<p>The API of the wrapper is basically the same as that of the Framegrabber API. This section contains only the definitions of those functions that are renamed, or have a different order of arguments.</p> <p>The functions provided here are grouped by library:</p> <ul> <li>fg</li> <li>clser</li> <li>siso_genicam</li> <li>SisoDisplay</li> <li>SisoIo.h</li> </ul> <p>For detailed information about using a specific function, as well as for information regarding functions not listed here, refer to the Framegrabber API documentation.</p>"},{"location":"c-wrapper.html#fg","title":"fg","text":""},{"location":"c-wrapper.html#newly-defined-functions","title":"Newly Defined Functions","text":""},{"location":"c-wrapper.html#string-fg_geterrordescription-int-errornumber","title":"string Fg_getErrorDescription (int ErrorNumber)","text":"<p>This function replaces both of the following functions:</p> <pre><code>const char *const Fg_getErrorDescription (Fg_Struct*Fg, int ErrorNumber)\n</code></pre> <pre><code>const char *const getErrorDescription (int ErrorNumber)\n</code></pre>"},{"location":"c-wrapper.html#int-fg_getparameterwith-fg_struct-fg-int-parameter-out-value-uint-dmaindex","title":"int Fg_getParameterWith\u2026 (Fg_Struct Fg, int Parameter, out \u2026 Value, uint DmaIndex)","text":"<p>List of overloaded functions that are used to get frame grabber parameters with information of different types. They replace the Framegrabber API function <code>Fg_getParameterWithType</code>, according to the passed type as follows:</p> FgParamTypes C# Wrapper Function FG_PARAM_TYPE_INT32_T Fg_getParameterWithInt FG_PARAM_TYPE_UINT32_T Fg_getParameterWithUInt FG_PARAM_TYPE_INT64_T Fg_getParameterWithLong FG_PARAM_TYPE_UINT64_T Fg_getParameterWithULong FG_PARAM_TYPE_DOUBLE Fg_getParameterWithDouble FG_PARAM_TYPE_CHAR_PTR Fg_getParameterWithString FG_PARAM_TYPE_SIZE_T Fg_getParameterWithUInt /Fg_getParameterWithULong FG_PARAM_TYPE_STRUCT_FIELDPARAMACCESS Fg_getParameterWithIntArray /Fg_getParameterWithUIntArray /Fg_getParameterWithLongArray /Fg_getParameterWithULongArray FG_PARAM_TYPE_STRUCT_FIELDPARAMINT Fg_getParameterWithFieldParameterInt FG_PARAM_TYPE_STRUCT_FIELDPARAMDOUBLE Fg_getParameterWithFieldParameterDouble FG_PARAM_TYPE_COMPLEX_DATATYPE Not implemented"},{"location":"c-wrapper.html#int-fg_setparameterwithfg_struct-fg-int-parameter-value-uint-dmaindex","title":"int Fg_setParameterWith\u2026(Fg_Struct Fg, int Parameter, \u2026 Value, uint DmaIndex)","text":"<p>List of overloaded functions that are used to set frame grabber parameters with information of different types. They replace the Framegrabber API function <code>Fg_setParameterWithType</code>, according to the passed type as following:</p> FgParamTypes C# Wrapper Function FG_PARAM_TYPE_INT32_T Fg_setParameterWithInt FG_PARAM_TYPE_UINT32_T Fg_setParameterWithUInt FG_PARAM_TYPE_INT64_T Fg_setParameterWithLong FG_PARAM_TYPE_UINT64_T Fg_setParameterWithULong FG_PARAM_TYPE_DOUBLE Fg_setParameterWithDouble / Fg_setParameterWithFloat FG_PARAM_TYPE_CHAR_PTR Fg_setParameterWithString FG_PARAM_TYPE_SIZE_T Fg_setParameterWithUInt / Fg_setParameterWithULong FG_PARAM_TYPE_STRUCT_FIELDPARAMACCESS Fg_setParameterWithIntArray / Fg_setParameterWithUIntArray / Fg_setParameterWithLongArray /Fg_setParameterWithULongArray FG_PARAM_TYPE_STRUCT_FIELDPARAMINT Fg_setParameterWithFieldParameterInt FG_PARAM_TYPE_STRUCT_FIELDPARAMDOUBLE Fg_setParameterWithFieldParameterDouble FG_PARAM_TYPE_COMPLEX_DATATYPE Not implemented"},{"location":"c-wrapper.html#functions-with-different-arguments","title":"Functions with Different Arguments","text":"C# Framegrabber API Wrapper Framegrabber API <code>SisoImage Fg_getImagePtr(Fg_Struct Fg, int PicNr, uint DmaIndex)</code> <code>void *Fg_getImagePtr(Fg_Struct *\\Fg, const frameindex_t PicNr, const unsigned int DmaIndex)</code> <code>SisoImage Fg_getImagePtrEx(Fg_Struct Fg, int PicNr, uint DmaIndex, dma_mem pMem)</code> <code>void *Fg_getImagePtrEx(Fg_Struct *Fg, const frameindex_t PicNr, const unsigned int DmaIndex, dma_mem *pMem)</code> <p>In <code>Fg_getImagePtr</code>and <code>Fg_getImagePtrEx</code> function, the return type is changed from void pointer, which directly represents the image bytes, in the Framegrabber API into <code>SisoImage</code> instance.</p> <p>To get again the byte array from <code>SisoImage</code>, the function <code>SisoImage.toByteArray(uint imageSize)</code> can be called.</p> <p>Additionally, it can be used directly with <code>DrawBuffer</code> function.</p>"},{"location":"c-wrapper.html#clser","title":"clser","text":""},{"location":"c-wrapper.html#functions-with-reordered-arguments","title":"Functions with Reordered Arguments","text":"<p>In the following function, the error code is written into <code>out int errorCode</code> instead of being returned from the function. While the created handle is returned from the function instead of being passed as an argument. If an error occurred, <code>errorCode</code> will have a value other than 0, and the return value will be null.</p> C# Framegrabber API Wrapper Framegrabber API <code>CLSerialRef</code> <code>clSerialInit(uint serialIndex, out int errorCode)</code> <code>int clSerialInit(unsigned int serialIndex, void *serialRefPtr)</code>"},{"location":"c-wrapper.html#siso_genicam","title":"siso_genicam","text":""},{"location":"c-wrapper.html#functions-with-reordered-arguments_1","title":"Functions with Reordered Arguments","text":"<p>In the following functions, the error code is written into <code>out int errorCode</code> instead of being returned from the function. While the created handle is returned from the function instead of being passed as an argument. If an error occurred, <code>errorCode</code> will have a value other than 0, and the return value will be null.</p> C# Framegrabber API Wrapper Framegrabber API <code>SgcBoardHandle</code> <code>Sgc_initBoard(Fg_Struct fg, int initFlag, out int errorCode)</code> <code>int Sgc_initBoard(Fg_Struct* fg, int initFlag, SgcBoardHandle* boardHandle)</code> <code>SgcBoardHandle</code> <code>Sgc_initBoardEx(Fg_Struct fg, uint initFlag, uint portMask, uint slaveMode, out int errorCode)</code> <code>int Sgc_initBoardEx(Fg_Struct* fg, unsigned int initFlag, SgcBoardHandle* boardHandle, unsigned int portMask, unsigned int slaveMode)</code> <code>SgcCameraHandle</code> <code>Sgc_getCamera(SgcBoardHandle boardHandle, uint port, out int errorCode)</code> <code>int Sgc_getCamera(SgcBoardHandle* boardHandle, const unsigned int port, SgcCameraHandle* cameraHandle)</code> <code>SgcCameraHandle</code> <code>Sgc_getCameraByIndex(SgcBoardHandle boardHandle, uint index, out int errorCode)</code> <code>int Sgc_getCameraByIndex(SgcBoardHandle* boardHandle, const unsigned int index, SgcCameraHandle* cameraHandle)</code> <code>SgcConnectionProfile</code> <code>Sgc_LoadConnectionProfile(Fg_Struct fg, string boardConfigurationFilePath, out int errorCode)</code> <code>int Sgc_LoadConnectionProfile(Fg_Struct* fg, const char* boardConfigurationFilePath, SgcConnectionProfile* connectionProfilePtr)</code> <code>string</code> <code>Sgc_getStringValue(SgcCameraHandle cameraHandle, string name, out int errorCode)</code> <code>int Sgc_getStringValue(SgcCameraHandle* cameraHandle, const char* name, const char* valuePtr)</code> <code>string</code> <code>Sgc_getEnumerationValueAsString(SgcCamer aHandle cameraHandle, string name, out int errorCode)</code> <code>int Sgc_getEnumerationValueAsString(SgcCa meraHandle* cameraHandle, const char* name, const char* valuePtr)</code>"},{"location":"c-wrapper.html#sisodisplay","title":"SisoDisplay","text":""},{"location":"c-wrapper.html#functions-with-different-arguments_1","title":"Functions with Different Arguments","text":"C# Framegrabber API Wrapper Framegrabber API <code>void DrawBuffer(int nId, SisoImage ulpBuf, int nNr, string cpStr)</code> <code>void DrawBuffer(int nId, const void *ulpBuf, const int nNr, const char *cpStr)</code> <p>In <code>DrawBuffer</code> function, the <code>ulpBuf</code> argument type is changed from <code>void pointer</code>, which directly represents the image bytes, in the Framegrabber API into <code>SisoImage</code> instance.</p> <p><code>SisoImage</code> is created using <code>Fg_getImagePtr</code> and <code>Fg_getImagePtrEx</code> functions. Additionally, <code>SisoImage</code> can be created from byte array using the following constructor:</p> <pre><code>SisoImage(byte[] imagePtr, uint pixelCount)\n</code></pre> <p>If such a <code>SisoImage</code> instance is used as a DMA buffer by calling <code>fg_AddMem</code> on it, it must be ensured that the byte array is neither collected nor moved around in memory by the garbage collector. This can be achieved using <code>gcHandle = GCHandle.Alloc(image, GCHandleType.Pinned)</code>. The handle can be released with <code>gcHandle.Free()</code> after the memory was removed from the DMA buffer with <code>fg_DelMem</code>.</p>"},{"location":"c-wrapper.html#sisoioh","title":"SisoIo.h","text":""},{"location":"c-wrapper.html#functions-with-reordered-arguments_2","title":"Functions with Reordered Arguments","text":"<p>In the following functions, the error code is written into <code>out int errorCode</code> instead of being returned from the function. While the created handle is returned from the function instead of being passed as an argument. If an error occurred, <code>errorCode</code> will have a value other than 0, and the return value will be null.</p> C# Framegrabber API Wrapper Framegrabber API <code>AviRef IoCreateAVIGray(string filename, int width, int height, double fps, out int errorCode)</code> <code>int IoCreateAVIGray(void *AviRef, const char *filename, int width, int height, double fps)</code> <code>AviRef IoCreateAVIGrayW(string filename, int width, int height, double fps, out int errorCode)</code> <code>int IoCreateAVIGrayW(void *AviRef, const LPCWSTR filename, int width, int height, double fps)</code> <code>AviRef IoCreateAVIColor(string filename, int width, int height, double fps, out int errorCode)</code> <code>int IoCreateAVIGrayColor(void *AviRef, const char *filename, int width, int height, double fps)</code> <code>AviRef IoCreateAVIColorW(string filename, int width, int height, double fps, out int errorCode)</code> <code>int IoCreateAVIGrayColorW(void *AviRef, const LPCWSTR filename, int width, int height, double fps)</code> <code>AviRef IoOpenAVI(string fileName, out int width, out int height, out int bitDepth, out int errorCode)</code> <code>int IoOpenAVI(void *AviRef, const char *fileName, int *width, int *height, int *bitDepth)</code> <code>SeqRef IoCreateSeq(string pFilename, int width, int height, int bitdepth, int format, out int errorCode)</code> <code>int IoCreateSeq(void *SeqRef, const char *pFilename, int width, int height, int bitdepth, int format)</code> <code>SeqRef IoOpenSeq(string pFilename, out int width, out int height, out int bitdepth, int mode, out int errorCode)</code> <code>int IoOpenSeq(void *SeqRef, const char *pFilename, int* width, int* height, int* bitdepth, int mode)</code> <code>SisoIoImageEngine IoImageOpen(string filename, out int errorCode)</code> <code>int IoImageOpen(const char *filename, SisoIoImageEngine *handle)</code> <code>SisoIoImageEngine IoImageOpenEx(string filename, int RGBSequence, out int errorCode)</code> <code>int IoImageOpenEx(const char *filename, SisoIoImageEngine *handle, int RGBSequence)</code>"},{"location":"c-wrapper.html#functions-with-different-return-data-types-and-out-argument-data-types","title":"Functions With Different Return Data Types and Out Argument Data Types","text":"<p>In the following functions, the return type is changed from void pointer, which represents an image handle, to a more specific handle type.</p> <p>The output arguments unsigned char <code>** data</code>, which are set to a pointer to the raw image data, are changed to <code>SisoImage</code>, which is a handle for image data in unmanaged memory. To retrieve the data from <code>SisoImage</code> as a byte array, the functions <code>SisoImage.toByteArray(uint imageSize)</code> and <code>SisoImage.asByteArray()</code> are provided.</p> C# Framegrabber API Wrapper Framegrabber API <code>TIFFHandle IoReadTiff(string filename, out SisoImage data, out int width, out int height, out int bitPerSample, out int samplePerPixel)</code> <code>void *IoReadTiff(const char *filename, unsigned char*data, int *width, int *height, int *bitPerSample, int *samplePerPixel)</code> <code>TIFFHandle IoReadTiffW(string filename, out SisoImage data, out int width, out int height, out int bitPerSample, out int samplePerPixel)</code> <code>void *IoReadTiffW(const LPCWSTR filename, unsigned char*data, int *width, int *height, int *bitPerSample, int *samplePerPixel)</code> <code>TIFFHandle IoReadTiffEx(string filename, out SisoImage data, out int width, out int height, out int bitPerSample, out int samplePerPixel, int RGBSequence)</code> <code>void *IoReadTiffEx(const char *filename, unsigned char*data, int *width, int *height, int *bitPerSample, int *samplePerPixel, int RGBSequence)</code> <code>TIFFHandle IoReadTiffExW(string filename, out SisoImage data, out int width, out int height, out int bitPerSample, out int samplePerPixel, int RGBSequence)</code> <code>void *IoReadTiffExW(const LPCWSTR filename, unsigned char*data, int *width, int *height, int *bitPerSample, int *samplePerPixel, int RGBSequence)</code> <code>BMPHandle IoReadBmp(string filename, out SisoImage data, out int width, out int height, out int bits)</code> <code>void *IoReadBmp(const char *filename,unsigned char *data,int *width,int *height,int *bits)</code>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-10-0.html","title":"Changes and Fixed Issues in Framegrabber SDK 5.10.0","text":"<p>This section provides information about changes and fixed issues for the Basler Framegrabber SDK version 5.10.0.</p>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-10-0.html#general","title":"General","text":"<ul> <li>The product name has been changed from Basler Runtime to Basler Framegrabber SDK.</li> <li>The Framegrabber SDK now supports Windows 11 (64-bit) and Linux Ubuntu 22.04 (64-bit). (Ticket IDs: 231590 and 244875)</li> <li>The Framegrabber SDK installer for Windows has been updated. Among others, installation paths (e.g. &lt;Basler&gt;), environment variables (e.g. <code>BASLER_FG_SDK_DIR</code>), and names have been changed. For details, see Renaming of Environment Variables and Header Files. (Ticket IDs: 218027 and 227082)</li> <li>Windows 32-bit libraries are integrated in the Windows 64-bit installer now. (Ticket ID: 253234)</li> <li>The GenICam reference implementation library of the Framegrabber SDK has been moved into the main installation folder. (Ticket ID: 236467)</li> <li>On Linux, all GUI and Command Line tools, e.g., microDisplay X, FirmwareUpdater, etc., should be started via their related scripts located under /bin. (Ticket IDs: 250971 and 253097)</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-10-0.html#renaming-of-environment-variables-and-header-files","title":"Renaming of Environment Variables and Header Files","text":"<p>The environment variable set during installation has been renamed:</p> <p><code>SISODIR5</code> has been changed to <code>BASLER_FG_SDK_DIR</code>.</p> <p>The following header files have been renamed:</p> Old Name New Name Included in fgrab_define.h fg_define.h and fg_error_codes.h basler_fg.h fgrab_struct.h fg_struct.h basler_fg.h fgrab_prototyp.h basler_fg.h <p>The following header files have been restructured:</p> File Name Change fgrab_define.h The major part of fgrab_define.h exists now as renamed file fg_define.h. fgrab_define.h Error definitions, formerly in fgrab_define.h, are now in the new header file fg_error_define.h. <p>The following header files have been removed:</p> <ul> <li>fgrab_triangultion.h</li> <li>fgrab_blob.h</li> </ul> <p>The files fgrab_define.h, fgrab_struct.h, and fgrab_prototyp.h still exist as minimal headers. If you include one of the discontinued header files, the following happens:</p> <ul> <li>You get a \"depricated\"-warning.</li> <li>The new corresponding fg_ file is included automatically instead of the discontinued fgrab_ file.</li> </ul> <p>As of Framegrabber SDK version 5.10, only basler_fg.h should be used.</p>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-10-0.html#discontinuations","title":"Discontinuations","text":""},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-10-0.html#windows-32-bit","title":"Windows 32-bit","text":"<p>The Framegrabber SDK doesn't support Windows 32-bit and Linux 32-bit operating systems any longer. (Ticket ID: 231590)</p>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-10-0.html#frame-grabbers","title":"Frame Grabbers","text":"<p>The support for the following frame grabbers has been discontinued:</p> <ul> <li>microEnable IV</li> <li>microEnable 5 marathon CLHS</li> <li>microEnable 5 ironman</li> </ul> <p>For details on all discontinued products, refer to Basler's Discontinued Products Page</p>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-10-0.html#third-party-interfaces","title":"Third-party Interfaces","text":"<p>The following third-party interfaces have been discontinued:</p> <ul> <li>LabView (see also API Examples)</li> <li>The proprietary Cognex VisionPro adapter</li> <li>The proprietary MVTec HALCON adapter</li> <li>CVB</li> </ul> <p>The Cognex VisionPro adapter and MVTec HALCON adapter can be replaced by a GenTL interface. (Ticket IDs: 231588, 212114, 212120, 255221 )</p>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-10-0.html#framegrabber-api","title":"Framegrabber API","text":"<ul> <li>The wording of the logging message has been improved for the case that no applets are found. (Ticket ID: 225003)</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-10-0.html#tools-microdiagnostics-and-microdisplay-x","title":"Tools microDiagnostics and microDisplay X","text":"<ul> <li> <p>The position of the Help menu in microDisplay X has been changed. The Help menu is now located here:</p> <p></p> <p>(Ticket ID:230984)</p> </li> <li> <p>Before, when closing microDiagnostics with unflashed firmware, the exit dialog asked whether \"applets\" shall be flashed instead of \"firmware\". The wording in the exit dialog has been corrected. (Ticket ID: 212124)</p> </li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-10-0.html#api-examples","title":"API Examples","text":"<ul> <li>The C/C++ SDK examples can be built with modern Microsoft Visual Studio versions now, e.g., Visual Studio 2019 or newer. (Ticket IDs: 226757, 249321, 227119)</li> <li>The National Instruments LabView example programs have been removed from the Framegrabber SDK delivery. Refer to the Basler Technical Support to obtain example programs for NI LabView, if necessary. (Ticket IDs: 231588 and 227110)</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-10-0.html#drivers","title":"Drivers","text":"<ul> <li>The driver for the imaWorx CXP-12 Quad frame grabber has been improved regarding its automatic stop behavior. Now, the acquisition is stopped when the camera has delivered the requested number of frames. Also the frames, which end up in the dummy buffer, are now taken into account. Before, the acquisition was stopped when the user had received the number of requested frames in his user buffers. (Ticket ID: 235859)</li> <li>The driver for microEnable 5 frame grabbers now contains an API for getting the frame number. (Ticket ID: 227072)</li> <li>The buffer handling of the microEnable 5 driver has been improved. (Ticket ID: 235850 and 236981)</li> <li>The communication speed between the camera and the frame grabber via the ClSerComWrapper2 has been increased. (Ticket ID: 236732)</li> <li>The communication with microEnable 5 frame grabbers has been expanded to support different variants of the hardware. (Ticket IDs: 231003, 232694)</li> <li>The device discovery has been improved. (Ticket ID: 238309)</li> <li>The discovery of CXP and CameraLink cameras has been improved (Ticket IDs: 229754, 226742, 230948, 240393).</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-10-0.html#fixed-issues","title":"Fixed Issues","text":"<ul> <li>Before, the GenTL <code>BUFFER_INFO_FRAME_ID</code>, that can be queried via <code>DSGetBufferInfo</code>, didn't contain the source tag from the CXP image header. Instead, it contained a counter for all frames that had been delivered to the computer. This has been fixed. (Ticket ID: 197430)</li> <li>Before, when reading the URL of a CXP camera XML, the Framegrabber SDK assumed a register size of 256 bytes. However, assuming a certain register size when reading the URL of the camera XML violates the CXP standard. This has been fixed. Now, no register size is assumed and the Framegrabber SDK adheres to the CXP standard. (Ticket ID: 228438)</li> <li>Before, when reading the URL of a CXP camera XML, the Framegrabber SDK assumed that the XML root element is \"Local\" with a captital \"L\". However, the CXP standard states that the URL isn't case sensitive. This has been fixed. Now, the parsing of the URL was changed to work with any casing. (Ticket ID: 228439)</li> <li>Before, the GenICam GenTL producer did not provide values for \"Selecting\" for all nodes. This has been fixed. (Ticket ID: 212118)</li> <li>Before, the GenICam GenTL producer didn't provide the correct vendor name and interface ID in the properties. This has been fixed. (Ticket ID: 225073)</li> <li>A possible GenICam GenTL deadlock issue has been fixed. (Ticket ID: 238352)</li> <li>Before, changing the applet of a microEnable 5 frame grabber did not always work in microDisplay X. This has been fixed. (Ticket ID: 229736)</li> <li>The behavior of the ROI feature has been optimized. (Ticket ID: 229952)</li> <li>Before, when opening the Help function of the command line tool gpioTool via -h, the example displayed was incorrect and did not work. This has been fixed. (Ticket ID: 221628)</li> <li>Before, some error messages of the FirmwareUpdate tool were misleading or misspelled. Therefore, the wording of the error messages have been improved. (Ticket IDs: 223690, 223689)</li> <li>Before, when starting microDisplay X and microDiagnostics on Linux 20.04, the tools closed with an error. This has been fixed. (Ticket ID: 233534)</li> <li>Before, microDisplay X returned an error when loading and then unloading an applet. This has been fixed. (Ticket ID: 212132)</li> <li>Before, microDisplayX didn't stop the image acquisition when changing the applet. This has been fixed. (Ticket ID: 220077)</li> <li>Before, the buttons Save Parameters und Load Parameters in microDisplay X didn't work correctly. This has been fixed. (Ticket ID: 238752)</li> <li>Before, loading an applet in microDisplay X after a PC reboot led to an error. This has been fixed. (Ticket ID: 236228)</li> <li>Before, microDisplay X crashed when loading a sequences of images. This has been fixed. (Ticket ID: 212616)</li> <li>Before, translation loop parameters were not displayed correctly in in microDisplay X. This has been fixed. (Ticket ID: 234064)</li> <li>Before, microDisplay X didn't recognize Basler dual-channel CXP-12 cameras. This has been fixed. (Ticket ID: 235720)</li> <li>Before, microDisplay X crashed during image acquisition, if a window was scrolled. This has been fixed. (Ticket ID: 238904)</li> <li>Before, microDisplay X crashed when loading HAP files on imaWorx CXP-12 Quad. This has been fixed. (Ticket ID: 235946)</li> <li>Before, microDisplay X didn't show descriptions of parameter properties. This has been fixed. (Ticket ID: 242207)</li> <li>Before, microDisplay didn't display large images (e.g. 10500 x 43500 pixels) correctly. This has been fixed. (Ticket ID: 246410)</li> <li>Before, loading HDR0 in microDiagnostics X on microEnable 5 frame grabbers didn't always work correctly. This has been fixed. (Ticket ID: 234254)</li> <li>Before, initializing applets on imaWorx CXP-12 Quad on Linux Ubuntu systems with <code>Fg_init</code> failed. This has been fixed. (Ticket ID: 234499)</li> <li>Before, setting or selecting values for an applet for imaWorx CXP-12 Quad in the LookupTable didn't work. This has been fixed. (Ticket ID: 221621)</li> <li>Before, incrementing the ROI width of some imaWorx CXP-12 Quad applets led to an error. This has been fixed. (Ticket ID: 249177)</li> <li>Before, when calling <code>Fg_AllocMemHead</code> on imaWorx CXP-12 Quad multiple times, the execution time increased after each call of this function. This has been fixed. (Ticket ID: 247416)</li> <li>Before, calling <code>Sgc_(re)storeLowLevelLinkProfile()</code> on imaWorx CXP-12 Quad, an error occurred. This has been fixed. (Ticket ID: 246768)</li> <li>The frame grabber library events are thread-safe now. (Ticket ID: 236809)</li> <li>Before, loading an applet with more than one DMA per camera led to an error in microDisplay X. This has been fixed (Ticket ID: 237342)</li> <li>Before, initializing frame grabbers failed due to failed loading of HAP files. This has been fixed. (Ticket ID: 237013)</li> <li>The visibility of related parameters upon switching on/off the <code>AutomaticROIControl</code> parameter works correctly now. (Ticket ID: 217774)</li> <li><code>Fg_getSWVersion()</code> now returns the correct version number of your installed Framegrabber SDK. (Ticket ID: 202240)</li> <li>The latest version 13.0.11 of the former proprietary adapter for MVTec HALCON has been improved to support transfers up to 4 GBytes. This adapter is discontinued with Framegrabber SDK 5.10.0 and Basler recommends using the GenICam GenTL interface instead. (Ticket IDs: 231049, 231326, 218503)</li> <li>Before, image acquisition stopped unexpectedly when using the former proprietary adapter for MVTec HALCON. This has been fixed. This adapter is discontinued with Framegrabber SDK 5.10.0 and Basler recommends using the GenICam GenTL interface instead. (Ticket ID: 229938)</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-0.html","title":"Changes and Fixed Issues in Framegrabber SDK 5.11.0","text":"<p>This section provides information about changes and fixed issues for the Basler Framegrabber SDK version 5.11.0.</p>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-0.html#general","title":"General","text":"<ul> <li>Updated the Visual Studio Redistribution packages.</li> <li>Integrated the new version 5.3.0 of the Linux driver for marathon hardware redesign (SPI).</li> <li>Integrated the new version 2.2.0 of the Windows driver mE5 for marathon hardware redesign (SPI).</li> <li>Reduced the number of used file handles on Linux.</li> <li>Added support for kernel 5.19 in the Linux driver.</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-0.html#gentl-producer","title":"GenTL Producer","text":"<ul> <li>Connection Test Mode is now available as required by the CXP standard.</li> <li>Added the Automatic Tap Geometry checkbox to the device in the GenTL Producer.</li> <li>The GenTL Producer now provides CameraLink support via GenCP.</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-0.html#applets","title":"Applets","text":"<ul> <li>Updated line scan applets for CXP-12 Interface Card 1C/2C/4C.</li> <li>Updated line scan applets for imaWorx.</li> <li>Updated line scan applets for mE5 frame grabbers.</li> <li>Added support for tap geometry 1X-2YE to the following applets:<ul> <li>Single area applets for CXP-12 Interface Card 2C/4C and imaWorx</li> <li>Dual area applets for CXP-12 Interface Card 4C and imaWorx</li> </ul> </li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-0.html#framegrabber-api","title":"Framegrabber API","text":"<ul> <li>Added the <code>Sgc_getFloatValueLimits()</code> fglib function.</li> <li>Changed fglib update URLs to www.baslerweb.com.</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-0.html#microdiagnostics-and-microdisplay-x","title":"microDiagnostics and microDisplay X","text":"<ul> <li>Removed the buffer limit of 1024 in microDisplay X.</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-0.html#fixed-issues","title":"Fixed Issues","text":"<ul> <li>Before, the GenTL <code>BUFFER_INFO_FRAME_ID</code> setting that can be queried via <code>DSGetBufferInfo</code> didn't contain the source tag from the CXP image header. Instead, it contained a counter for all frames that had been delivered to the computer. This has been fixed. (Ticket ID: 197430)</li> <li>Before, the applet iterator reported an incorrect number of DMAs for HAP files in the <code>Fg_Helpers</code> project and in the GenTL Producer. This has been fixed. (Ticket ID: 273806)</li> <li>Before, the siso_genicam library was limited to a maximum number of CXP 1.0 tentative ACKs. This caused performance issues. This has been fixed. (Ticket ID: 274500)</li> <li>Before, running the C# wrapper could lead to a fatal error message. This has been fixed by improving the event handling in the C# wrapper. (Ticket ID: 271951)</li> <li>Before, the driver automatically enabled PoCXP whenever the CXP ports were reset. This happened, e.g., when the last application detached itself from the driver. This has been fixed. Now, the PoCXP state only changes when configured by the user. (Ticket ID: 273905)</li> <li>Fixed range verification when reading values from the camera. Before, the GenAPI cache in the GenTL Producer was incorrectly taken into account when verifying the min/max value range (<code>IntegerT::GetValue(bool Verify, bool IgnoreCache)</code> function). This has been fixed. (Ticket ID: 271134)</li> <li>Before, the GenTL Producer showed a blue screen when high frame rates were used on an mE5 frame grabber. This has been fixed. (Ticket ID: 262624)</li> <li>The Framegrabber SDK version 5.10.0 only detected cameras if they were connected in the correct link order. This has been fixed. Now, discovery detects CXP cameras correctly independent of the link order. (Ticket ID: 259300)</li> <li>Before, calling the GPIO Tool on Linux returned an \"Invalid board index\" error, even if a correct ID had been provided. This has been fixed. The GPIO Tool was moved from the <code>/bin</code> directory into the subdirectory <code>/impl</code>. A script named gpioTool in the <code>/bin</code> directory now calls the application after setting the appropriate environment variable. (Ticket ID: 256141)</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-2.html","title":"Changes and Fixed Issues in Framegrabber SDK 5.11.2","text":"<p>This section provides information about changes and fixed issues for the Basler Framegrabber SDK version 5.11.2.</p>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-2.html#clsercomwrapper2-clcomdriver","title":"CLSerCOMWrapper2 / ClComDriver","text":"<p>The CLSerCOMWrapper2 has been replaced by the ClComDriver. Before installing Framegrabber SDK 5.11.2 with ClCom support, you must uninstall all old instances of ClSerCOMWrapper1/2/3. For more details, see Installing the Basler CLComDriver Under Windows.</p>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-2.html#linux-driver","title":"Linux Driver","text":"<p>The Linux driver can now be built on kernel versions 6.3 and newer.</p>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-2.html#fixed-issues","title":"Fixed Issues","text":"<ul> <li>Before, calling <code>Fg_setStatusEx</code> when queueing a buffer and using <code>ACQ_SELECT</code> at high frame rates could have led to error -1. This has been fixed. (Ticket ID: 285576)</li> <li>Before, when connecting CXP cameras with more than one link to a mE5 marathon ACX-DP, QP or VCX-QP, sometimes the camera was not detected or was detected with the wrong number of links. This has been fixed. (Ticket ID: 284092)</li> <li>Before, the CIS Area Scan camera was not found during camera discovery. This has been fixed. (Ticket ID: 282915)</li> <li>Before, when calling <code>Fg_unregisterApcHandler()</code>, the function did always wait for the number of seconds specified as timeout before registering the APC. This has been fixed. (Ticket-ID: 291818)</li> <li>Before, after booting with Fast Boot enabled on Windows, microEnable 5 frame grabbers always showed partition 0 as boot partition, even if another partition was defined as boot partition before booting. Also, the boot partition couldn't be changed, and the serial number wasn't displayed correctly. This has been fixed. (Ticket ID 272272)</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-3.html","title":"Changes and Fixed Issues in Framegrabber SDK 5.11.3","text":"<p>This section provides information about changes and fixed issues for the Basler Framegrabber SDK version 5.11.3.</p>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-3.html#discontinuations","title":"Discontinuations","text":"<p>The Framegrabber SDK now supports Linux Ubuntu 20.04, and 22.04. Linux Ubuntu 18.04. isn't supported any longer. (Ticket ID: 273529)</p>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-3.html#miscellaneous","title":"Miscellaneous","text":"<ul> <li>Before fixing this issue, when saving a *.mcf or *.mfs configuration file in pylon, the files were empty. This has been fixed. (Ticket ID: 300801)</li> <li>Before, all applet *.hap files contained information about all DMA processes. As a result, all *.hap files were included in every DMA. This has been improved. Now, the applet *.hap files include only the process relevant to the current GenTL device, filtering out all others. (Ticket ID: 303262)</li> <li>Before, all applet *.hap files contained caches to registers that weren't included in the *.hap files. This has been improved: The caching has been removed from the *.hap files. (Ticket ID: 315763)</li> <li>Before, if you had a *.hap file with more than 1 DMA acquisition channel per VisualApplets channel process, you didn't know which DMAs were in the process. This has been improved. Now, the process identifiers for device names contain a prefix with which you can identify the DMAs. (Ticket ID: 303265)</li> <li>Before fixing this issue, the i2c core of the drivers continued running after detecting an error instead of leaving the function early. This led to follow-up errors and many error messages, which polluted the logs. This has been fixed. (Ticket ID: 304527)</li> <li>Before, the fglib5 library had no RPath or RunPath, so you needed to add its path to LD_LIBRARY_PATH to load it, and that dependencies were found. This has been improved: RPath has been added to fglib5 library. (Ticker ID: 314043)</li> <li>Added functionality for the Framegrabber SDK to run and load applets from paths with non-latin characters. (Ticket ID: 234116)</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-4.html","title":"Changes and Fixed Issues in Framegrabber SDK 5.11.4","text":"<p>This section provides information about changes and fixed issues for the Basler Framegrabber SDK version 5.11.4.</p>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-4.html#gentl-producer","title":"GenTL Producer","text":"<ul> <li> <p>The GenTl producer now supports camera XML discovery in Camera Link via GenCP or CLP in the FgSDk and in GenTL. In GenTL, you can activate this feature by setting the discovery mode to either <code>Mixed</code> or <code>Camera</code>. The ClpSharedLibraryPath is a feature in the GenTL interface module that specifies the location of the CLP library DLL. If the ClpSharedLibraryPath isn't set to an existing CLP DLL, GenCP becomes the default protocol. Loading the library takes effect after opening the GenTL interface, and the LoadedClpSharedLibraryPath node indicates whether the library was successfully loaded. This allows you to configure camera settings seamlessly based on the available protocols. (Ticket ID: 268175)</p> </li> <li> <p>Added support for BiColor formats in GenTL. The formats are automatically converted to BGR packed or unpacked formats depending on the value of the <code>OutputPackedFormats</code> feature in the device XML. (Ticket ID: 315154)</p> </li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-4.html#changes-in-logging-behavior","title":"Changes in Logging Behavior","text":"<ul> <li> <p>To be compatible with the pylon Event Logger, now the environment variable <code>PYLON_LOG_CONFIG</code> is evaluated when looking for a logging configuration. The search order is now:</p> <ol> <li>Environment variable <code>BASLER_FGSDK_LOGGING_CONFIG</code></li> <li>Environment variable <code>PYLON_LOG_CONFIG</code></li> <li>File <code>BaslerFgSdkLogging.properties</code> inside the SDK's <code>bin</code> directory. If logging has already been configured by pylon, no re-configuration is performed by the Framegrabber SDK. (Ticket ID: 320756)</li> </ol> </li> <li> <p>Applet events are now logged to the category <code>FgSdk.fglib.Events.&lt;eventname&gt;</code>, when they are received. The log includes a timestamp with microseconds resolution. Error events are now enabled by default in the GenTL producer (<code>CameraStreamStatus</code>, <code>Overflow</code>, <code>TriggerExceededPeriodLimits</code>, <code>FrameTriggerMissed</code>). (Ticket ID: 320807,323583)</p> </li> <li> <p>The registering and unregistering of event handlers is logged to the log category <code>FgSdk.fglib.EventControl</code>. (Ticket ID 330155)</p> </li> <li> <p>More details can now be logged for a running acquisition. Since some messages (like incoming frames) would be produced with the same frequency as the frame rate, you can now turn these messages on or off with the new log categories <code>basler.fglib.acq</code> and <code>basler.gentl.acq</code>. The messages are visible for the log level <code>NOTICE</code> or higher. When using the Framegrabber SDK directly, use <code>basler.fglib.acq</code>, when using it via the GenTL producer, use <code>basler.GenTL.Acq</code>. (Ticket ID: 316516)</p> </li> <li> <p>Added log messages when errors are detected on an established CXP link and when a link is considered disconnected. (Ticket ID: 320739,320740)</p> </li> <li> <p>The 1<sup>st</sup> level logging category is renamed from <code>basler</code> to <code>FgSdk</code>, so that it harmonizes better with the logging of the pylon SDK. (Ticket ID: 323587)</p> </li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-4.html#framegrabber-api","title":"Framegrabber API","text":"<ul> <li>The buffer-queueing API is available in the C# and Python Wrappers. (Ticket ID: 315155)</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-4.html#miscellaneous","title":"Miscellaneous","text":"<ul> <li>The examples in Linux and Windows now include a root CMake. (Ticket ID: 311719)</li> </ul>"},{"location":"changes-and-fixed-issues-in-framegrabber-sdk-5-11-4.html#fixed-issues","title":"Fixed Issues","text":"<ul> <li>Before fixing this issue, the acquisition in GPUDirect reported errors which were irrelevant for the user and made checking for real errors impossible. This has been fixed and error handling has been added to the GPUDirect examples. (Ticket ID: 322499)</li> <li>Before fixing this issue, the acquisition in GPUDirect was stopped when no images arrived for 5 seconds or longer. This has been fixed. Now, you can specify the timeout by calling <code>GDStartAcquisitionEx</code> or in a fgsdk.config file. (Ticket ID: 319200)</li> <li>Before fixing this issue, when using Camera Link serial in the Python SDK wrapper, the Python interpreter crashed. This has been fixed, and a simple example has been added. (Ticket ID: 292560)</li> <li>Before fixing this issue, the Windows installer changed the PATH environment variable to <code>REG_SZ</code>, which breaks the variable expansion. This has been fixed. (Ticket ID: 319997)</li> <li>Applets are now loadable on Ubuntu 24.04, which had been prevented by a dependency to <code>libtiff.so.5</code>. (Ticket ID: 316368)</li> <li>Before fixing this issue, <code>nullptr</code> in the output buffer for string types wasn't allowed, which resulted in incorrect string sizes. This has been fixed. Now, <code>nullptr</code> in the output buffer for string types is allowed, and the string size is correctly written to the additional value. (Ticket ID: 318444)</li> <li>References to the deprecated variables <code>SISODIR5</code>, <code>SISODIR5_32</code> and <code>SISODIR5_64</code> in the windows installer have been removed. (Ticket ID: 316211)</li> <li>The missing tool licenseTool has been addded to the Linux bin folder. (Ticket ID: 311719)</li> <li>Before fixing this issue, a GenICam header was missing. As a result, the GenICam example project couldn't be compiled. This has been fixed. (Ticket ID: 311719)</li> </ul>"},{"location":"changes-and-fixed-issues-in-runtime-5-9-0.html","title":"Changes and Fixed Issues in Runtime 5.9.0","text":"<p>This section provides information about changes and fixed issues for the Basler Runtime version 5.9.0.</p>"},{"location":"changes-and-fixed-issues-in-runtime-5-9-0.html#applets","title":"Applets","text":""},{"location":"changes-and-fixed-issues-in-runtime-5-9-0.html#all-boards","title":"All Boards","text":"Change Summary CXP-12 Interface Card 1C Requires Firmware Version S1.1 CXP-12 Interface Card 2C, CXP-12 Interface Card 4C and imaWorx CXP-12 Quad Require Firmware Version S1.0 Description All applets require a specific firmware version on the board. They are neither upwards nor downwards compatible. For CXP-12 Interface Card 1C, the applets delivered with this release require the firmware version S1.1. For CXP-12 Interface Card 2C, CXP-12 Interface Card 4C and imaWorx CXP-12 Quad, there is currently only firmware version S1.0 available, so for these boards this will become relevant in the future. Affected OS Windows and Linux Ticket ID TFS 191503"},{"location":"changes-and-fixed-issues-in-runtime-5-9-0.html#sdk","title":"SDK","text":"Fix Summary In Blocking Mode Acquisition Frames in the Dummy Buffer Are Now Taken into Account Behavior Before Fix When running a blocking mode acquisition for a finite number of frames, frames that were transferred to the dummy buffer (i.e. were dropped) were not taken into account for the frame limit. Behavior After Fix This has been fixed. Now, if the last requested frame is transferred to the dummy buffer, a call to <code>Fg_waitForLastPicNumberBlockingEx</code> will time out. Affected OS Windows and Linux Ticket ID TFS 201149 Fix Summary In Blocking Mode Acquisition the <code>Callback</code> Function Returns the Buffer Number for the Frame Behavior Before Fix When running a blocking mode acquisition using the APC API, the <code>Callback</code> function only returned a frame number without the buffer number. Behavior After Fix This has been fixed. Now, the Callback function returns the buffer number for the frame instead of the frame number. Instructions To determine the frame number, use <code>Fg_getParameterEx</code> with the new parameter identifier <code>FG_IMAGE_NUMBER</code>. Affected OS Windows and Linux Ticket ID \u2013 Fix Summary The Spelling of the Applet Parameter Values <code>EnumEntry_TriggerCameraOutSelect_NotBypassFronGPI[0..3]</code> Have Been Corrected Behavior Before Fix There was a typo in the Applet Parameter Values <code>EnumEntry_TriggerCameraOutSelect_NotBypassFronGPI[0..3]</code>. Behavior After Fix The spelling of the applet parameter values have been corrected from <code>EnumEntry_TriggerCameraOutSelect_NotBypassFronGPI[0..3]</code> to <code>EnumEntry_TriggerCameraOutSelect_NotBypassFron</code>t<code>GPI[0..3]</code>. Instruction Any software that uses the old misspelled names needs to be updated. Affected OS Windows and Linux Ticket ID TFS 197346"},{"location":"checking-for-latest-framegrabber-sdk-version.html","title":"Checking for Latest Framegrabber SDK Version","text":"<p>You can check via microDiagnostics or via microDisplay X whether a newer version of the Basler Framegrabber SDK is available.</p> <p>Info</p> <p>Preconditions for using the update check options:</p> <ul> <li> <p>To be able to use the update check options, you must have accepted the legal terms and conditions of using cryptographic software during the installation of Framegrabber SDK. In case you didn't accept them during Framegrabber SDK installation, update check will not work. You will get an according message (\"Network error\").</p> </li> <li> <p>Also, Framegrabber SDK version 5.6 or higher must be installed on your computer.</p> </li> </ul> <p>To check for newer versions of the Framegrabber SDK:</p> <ol> <li> <p>Open microDiagnostics or microDisplay X.</p> <ol> <li>In microDiagnostics, open the menu Info.</li> <li>In microDisplay X, open the menu Help.</li> </ol> <p>The following dialog opens:</p> <p></p> </li> <li> <p>Select whether you want to Check for updates now, or whether the tool should always Check for updates on startup, and whether you want the tool to Show message for updates on startup.</p> </li> </ol> <p>If a newer version is available, the following dialog opens:</p> <p></p> <p>To install a new Framegrabber SDK version:</p> <ol> <li> <p>Use one of the links in the message to download the installer of the newest Framegrabber SDK version.</p> <ol> <li>Clicking link FramegrabberSDKSetupWindows AMDxx 5.x.x-xxxx with Applets starts downloading the installer that contains the Framegrabber SDK and all freely available acquisition applets.</li> <li>Clicking link FramegrabberSDKSetupWindows AMDxx 5.x.x-xxxx starts downloading the Framegrabber SDK installer that comes without acquisition applets (smaller download package). If you use this link, you must install the applets for your frame grabber model after installing the Framegrabber SDK.</li> <li>Clicking link Release Notes opens the Release Notes for the suggested update.</li> </ol> </li> <li> <p>Uninstall all Framegrabber SDK versions prior to the version you are going to install. Make sure you also delete all related subfolders in the Framegrabber SDK installation folder.</p> </li> <li>Go to the directory where you downloaded the installer to. For installation instructions, refer to Installing the Framegrabber SDK.</li> </ol>"},{"location":"clsersis.html","title":"clsersis","text":"<p>The library clsersis manages communication with cameras conforming to the CameraLink standard.</p> <p>To use the library, the include file <code>clser.h</code> should be added to the source code.</p> <pre><code>#include &lt;clser.h&gt;\n</code></pre> <p>Additionally, <code>clsersis.lib</code> should be added to your Microsoft Visual Studio Project, or <code>libclsersis.so</code> to your Linux project. If you use CMake, the package name is ClSerSis, the libraries are stored in the variable <code>${clsersis_LIBRARIES}</code> and the the include directory is stored in the variable <code>${clsersis_INCLUDE_DIR}</code>. See Prerequisites for more details on projects and how to use CMake.</p> <p>Refer to the CameraLink Specifications document for further information on how to use CameraLink Serial. In addition, the documentation of the camera will contain details about how to implement the vendor specific protocol to access camera features.</p>"},{"location":"cognex-vision-pro-adapter.html","title":"Cognex VisionPro Adapter","text":"<p>Cognex VisionPro Adapter Has Been Discontinued</p> <p>With version 5.10 of the Framegrabber SDK, the Cognex VisionPro Adapter has been discontinued. See also the Framegrabber SDK 5.10 Release Notes. You can replace the Cognex VisionPro adapter by the GenTL Interface.</p> <p>Version 4</p> <p>The Basler adapter to Cognex VisionPro is a supporting tool for the integration of Basler frame grabbers and Framegrabber SDK software into Cognex' VisionPro software package. It maps the Basler Framegrabber API into according interfaces which are needed for the direct integration into VisionPro. The Basler Cognex VisionPro adapter version 4 supports all frame grabbers available from Basler.</p> <p>The Basler Cognex VisionPro Adapter allows you to implement configuration and control of Basler frame grabbers into your own software while you are using the Cognex VisionPro environment.</p> <p>In addition, the adapter allows you to implement the configuration of cameras connected to a frame grabber as long as the cameras support the GenICam standard.</p> <p>The adapter allows you to:</p> <ul> <li>Load different image processing functionality onto the frame grabber,</li> <li>Access and modify frame grabber configuration parameters,</li> <li>Grab images according to the frame grabber configuration,</li> <li>Use multiple Basler frame grabbers in a single system.</li> </ul> <p></p>"},{"location":"cognex-vision-pro-adapter.html#supported-frame-grabbers","title":"Supported Frame Grabbers","text":""},{"location":"cognex-vision-pro-adapter.html#frame-grabber-models","title":"Frame Grabber Models","text":"<p>The Basler Cognex VisionPro adapter supports all frame grabbers available from Basler.</p> <p>This includes microEnable V, and imaWorx frame grabbers.</p>"},{"location":"cognex-vision-pro-adapter.html#frame-grabber-functionality-applets","title":"Frame Grabber Functionality (Applets)","text":"<p>The functionality of a Basler frame grabber is defined in a specific hardware program, called applet. For each frame grabber model, a broad range of applets (i.e., a broad range of diverse functionalities) is available.</p> <p>Each applet is optimized for a specific interface, a specific group of cameras, or even a specific field of application. You define the functionality of a Basler frame grabber via the applet you select for use on the grabber.</p> <p>There are applet sets provided by Basler for each specific frame grabber model. In addition, you can build customized image processing applets using the graphical programming environment VisualApplets.</p> <p>The Basler Cognex VisionPro adapter supports any functionality of a Basler frame grabber, e.g., the adapter supports frame grabbers running applets provided by Basler as well as frame grabbers running applets built with VisualApplets.</p>"},{"location":"cognex-vision-pro-adapter.html#supported-output-formats","title":"Supported Output Formats","text":"<p>The Basler Cognex VisionPro Adapter supports the following frame grabber output formats:</p> Cognex Name Basler Name Format ck_pt_mono FG_GRAY Gray 8bit ck_pt_mono16 FG_GRAY16 Gray 16bit ck_pt_RGBplanar FG_COL24 Color 24bit ck_pt_RGB48 (not supported by Cognex) FG_COL48 Color 48bit"},{"location":"cognex-vision-pro-adapter.html#conversion-to-rgb-planar-output-formats","title":"Conversion to RGB Planar Output Formats","text":"<p>Cognex VisionPro supports RGB planar formats, but no RGB packed formats. Basler frame grabbers, however, support RGB packed formats, but no planar formats. Therefore, the Basler Cognex Vision Pro adapter converts the RGB packed formats (output by Basler frame grabbers) into RGB planar formats (supported by Cognex VisionPro). Conversion is done pixel by pixel. The data are buffered in the frame buffer separated by color channel (R,G, and B).</p> <p>Data storage format for RGB24 on the frame grabber:</p> <pre><code>R(Px1)G(Px1)B(Px1)R(Px2)G(Px2)B(Px3) ... R(Pxn*m)G(Pxn)B(Pxn)\n</code></pre> <p>(Pxn: pixel value on image position n.)</p> <p>Data storage format in frame buffer planar:</p> <pre><code>R(Px1)R(Px2)R(Px3) ... R(Pxn*m)\nG(Px1)G(Px2)G(Px3) ... G(Pxn*m)\nB(Px1)B(Px2)B(Px3) ... B(Pxn*m)\n</code></pre> <p>n = Image Width m = Image Height</p> <p>The formats are handed over to VisionPro according to frame grabber parameter FG_FORMAT.</p>"},{"location":"cognex-vision-pro-adapter.html#multiple-video-streams","title":"Multiple Video Streams","text":"<p>Basler frame grabbers are able to deliver multiple video streams. However, in Cognex VisionPro, each frame grabber (ICogFrameGrabber) is associated with only one video stream.</p> <p>Therefore, the adapter maps each video stream (DMA) output of a Basler frame grabber to one Cognex frame grabber instance (ICogFrameGrabber).</p> <p></p> <p>How many DMA channels are created by the frame grabber depends on the applet that is running on the frame grabber.</p>"},{"location":"cognex-vision-pro-adapter.html#requirements","title":"Requirements","text":"<p>To use the Basler Cognex Adapter, your system needs to meet the following requirements:</p>"},{"location":"cognex-vision-pro-adapter.html#hardware","title":"Hardware","text":"<ul> <li>At least one correctly installed Basler frame grabber</li> <li>Hardware Dongle for Cognex VisionPro (available at Cognex)</li> </ul>"},{"location":"cognex-vision-pro-adapter.html#software","title":"Software","text":"<ul> <li>Operating System: Windows 7, Windows 8.1, or Windows 10</li> <li>Installation of Cognex VisionPro (installer available via Cognex)</li> <li>Installation of Cognex Acquisition Integration Kit (installer available via Cognex)</li> <li>Installation of Basler Framegrabber SDK</li> <li>Installation of the Basler Cognex Adapter</li> </ul> <p>Info</p> <p>Basler recommends using version 4 of the Basler Cognex Adapter together with version 9 of the Cognex VisionPro software as the adapter has been optimized for and tested with Cognex VisionPro 9.0. Later versions of VisionPro contain an internal GenTL Consumer that may interfere with the Vision Pro adapter.</p>"},{"location":"cognex-vision-pro-adapter.html#installation","title":"Installation","text":"<p>For using the Basler Cognex VisionPro Adapter, it is essential you install</p> <ul> <li>the Basler Framegrabber SDK, and</li> <li>the Basler Cognex VisionPro Adapter itself.</li> </ul> <p>For installation, you have two options. You can either</p> <ul> <li>install the Basler Framegrabber SDK together with the Cognex VisionPro Adapter in one step (using the Framegrabber SDK installer for both), or</li> <li>install Framegrabber SDK and adapter via separate installers. This is especially helpful if the Framegrabber SDK is already installed on your system and you want to add the installation of the Basler Cognex VisonPro Adapter. In addition, you can install the adapter manually, without using the installer.</li> </ul> <p>The following sections describe all installation options:</p>"},{"location":"cognex-vision-pro-adapter.html#installing-framegrabber-sdk-and-adapter-in-one-step","title":"Installing Framegrabber SDK and Adapter in One Step","text":"<p>To install the Basler Framegrabber SDK and the Basler Cognex Adapter together in one step:</p> <ol> <li>Download the Framegrabber SDK installer from our website's download section. Make sure to select the corresponding installer:</li> <li>Start the Framegrabber SDK installer by double-clicking on the file name.</li> <li> <p>Make sure the Cognex adapter is selected in the Select Components dialog of the Framegrabber SDK installer:</p> <p></p> </li> <li> <p>Finish your Framegrabber SDK installation.</p> </li> </ol> <p>The Basler Cognex VisionPro Adapter will be installed together with the Basler Framegrabber SDK software.</p>"},{"location":"cognex-vision-pro-adapter.html#installing-the-adapter-separately","title":"Installing the Adapter Separately","text":"<p>In case you have the Basler Framegrabber SDK already installed on your system, you can run a separate installer to install the Basler Cognex Adapter.</p> <ol> <li>Download the Framegrabber SDK installer from the Basler website. Make sure to select the corresponding installer:</li> <li>Double-click on the installer file <code>SetupCognexAdapter_xxx.exe</code> and follow the instructions of the installation wizard.</li> </ol> <p>This is the normal installation procedure. However, in specific situations, e.g., when the adapter doesn't work as you might expect it, you can alternatively install the adapter manually.</p>"},{"location":"cognex-vision-pro-adapter.html#installing-the-adapter-manually","title":"Installing the Adapter Manually","text":"<p>To integrate the adapter for Basler frame grabber support manually, take the following steps:</p> <ol> <li>Copy the file <code>SiSoCognexAdapter.dll</code> into the subdirectory \\bin of your Basler Framegrabber SDK installation.</li> <li>Open the registry editor.</li> <li>In the registry editor, navigate to <code>[HKEY_LOCAL_MACHINE\\SOFTWARE\\Cognex\\AIK\\AdapterSiso]</code>.If you can't find these folders, create them as necessary.It is important that the registry key [HKEY_LOCAL_MACHINE\\SOFTWARE\\Cognex\\AIK] has write access for the actual user, otherwise VisionPro will have to be started with admin rights in order to load the Basler adapter DLL.</li> <li> <p>Add the following entries to <code>AdapterSiso</code>:</p> <pre><code>PoolSize=dword:04000000\nPoolSizeQuantum=dword:000000002\nServerNameBase=Cognex.AIKserver.AdapterSiSo\nUseExe=dword:00000001\nLibName=&lt;SISOINSTALLDIR&gt;\\bin\\SiSoCognexAdapter.dll\n</code></pre> <p>where \\&lt;SISOINSTALLDIR&gt; is your installation directory of the Basler Framegrabber SDK, e.g.: <code>C:\\Program Files\\Basler\\FramegrabberSDK5.x.x\\bin\\SiSoCognexAdapter.dll</code></p> <p></p> </li> </ol>"},{"location":"cognex-vision-pro-adapter.html#selecting-an-applet","title":"Selecting an Applet","text":"<p>Basler provides acquisition applet sets for each frame grabber model. Every frame grabber must load an applet to be initialized, and a different applet means a different set of features.</p> <p>For an applet to be loadable, it must be available both for the hardware and the software, and how this is done differs substantially between the different frame grabber families.</p> <p>You can find more information about how to make an applet loadable in the microDiagnostics documentation.</p> <p>One of the contained loadable applets is per default the active applet, as long as you don't define another applet to be the active one.</p> <p>You can select any applet out of the applet set for your specific frame grabber model, or select an applet that has been designed by VisualApplets.</p> <p>In version 4 of the Cognex adapter, the applet is selected according to these rules:</p> <ul> <li>First, the adapter checks if there is an environment variable SISO_COGNEX_APPLET_x, where \"_x\" represents the index for the board, e.g., \"_0\", pointing to an applet or an applet configuration file.</li> <li>If this environment variable isn't found, the adapter searches for the last configuration in the GenTL Producer for the frame grabber, saved under \"%Appdata%/Basler\" after closing GenTL.</li> <li>If this last configuration file also doesn't exist for the frame grabber, the adapter searches the actual active applet for the frame grabber.</li> <li>If the adapter doesn't find neither the environment variable, nor the last GenTL Producer configuration, and there is no active applet, the adapter will load the first loadable applet that it finds.</li> </ul> <p>To select an applet using an environment variable:</p> <ol> <li>Change the according system environment setting: <code>SISO_COGNEX_APPLET_&lt;x&gt; = &lt;AppletFilename&gt;</code><ul> <li> represents the index of the board, e.g. \"0\" for the first board <li> is the path and file name of the applet to be used, for example: <code>C:\\Program Files\\Basler\\FramegrabberSDK\\dll\\iW-CXP12-Q\\Acq_SingleCXP12x4Area.dll</code>. For further details regarding the enumeration of Basler frame grabbers, refer to the Basler Framegrabber SDK documentation. <li>Increase the pool size if necessary:<ol> <li>Open the registry editor.</li> <li>In the registry editor, navigate to <code>[HKEY_LOCAL_MACHINE\\SOFTWARE\\Cognex\\AIK\\AdapterSiso]</code>.</li> <li>Change the value of key \"PoolSize\".</li> </ol> </li> <li>Close Cognex VisionPro.</li> <li>Shut down the AIK Server via the Windows task manager.</li> <li>Restart Cognex VisionPro.</li> <p>Info</p> <p>Each time you change an environment variable, you have to shut down the AIK server via the Windows task manager. Closing VisionPro isn't enough since closing this program doesn\u2019t lead to a shut-down of the AIK server.</p> <p>Only after restarting the VisionPro software (and thus re-starting the AIK server), your changes of system variables are activated.</p> <p>The selected applet can be configured individually for each frame grabber which is installed in the system.</p> <p>For information about how to initialize a frame grabber using a pre-defined configuration file, see Frame Grabber Initialization Using an MCF File.</p> <p>Info</p> <p>When using Dual applets (supporting two connected cameras) or Quad applets (supporting four connected cameras):</p> <p>Even if only one physical frame grabber is installed, logically two/four different devices are listed in VisionPro under Image Acquisition Device/Frame Grabber \u2013 one for each possible camera. For more information, see Multiple Video Streams.</p>"},{"location":"cognex-vision-pro-adapter.html#testing-your-installation","title":"Testing Your Installation","text":"<p>You can test if the installation of the adapter was successful. You use the VisionPro tool QuickBuild for testing.</p> <p>To test the installation of the adapter:</p> <ol> <li>Make sure you selected an applet as described in Selecting an Applet.</li> <li>Start VisionPro (R) QuickBuild.</li> <li> <p>Double-click on Image Source:</p> <p></p> </li> <li> <p>Select Camera:</p> <p></p> </li> </ol> <p>If the installation of the adapter was successful, the Basler frame grabbers are listed in the combo box Image Acquisition Device / Frame Grabber with their model name, port connection number and serial number:</p> <p></p>"},{"location":"cognex-vision-pro-adapter.html#available-parameters","title":"Available Parameters","text":"<p>This section describes the parameters you have available for specific tasks.</p>"},{"location":"cognex-vision-pro-adapter.html#library-information","title":"Library Information","text":"<p>The following parameters allow to get information about the used libraries:</p> Parameter Name CogAdapterInterfaceID Description This feature returns the ID of the interface file used when the adapter was build. Type String Access Read Parameter Name CogAdapterVersion Description The version of the adapter DLL. Type String Access Read"},{"location":"cognex-vision-pro-adapter.html#configuring-a-frame-grabber","title":"Configuring a Frame Grabber","text":"<p>The functionality of your frame grabber you define via the applet you select for use on your frame grabber. An applet is a hardware program tailored for a specific camera interface, a specific topology, or even a specific field of application.</p> <p>When you start out to configure your frame grabber, you actually start to configure the applet that is loaded onto your frame grabber. Which parameters are available for frame grabber configuration therefore depends on the applet you use.</p> <p>Find all information about applet-specific parameters and their configuration in the according applet documentation.</p> <p>The following parameters allow to set the applet parameters:</p> Parameter Name FgFeatureKey Description This parameter holds the name of the applet parameter that you want to set or read via one of the parameters FgStringValue, FgIntValue, or FgFloatValue. Type String Access Read/Write Parameter Name FgStringValue Description Via this parameter, you can read/write applet parameters of type String.Make sure parameter FgFeatureKey points to the applet parameter you have in mind. Type String Access Read/Write Parameter Name FgIntValue Description Via this parameter, you can read/write applet parameters of type Integer.Make sure parameter FgFeatureKey points to the applet parameter you have in mind. Type Integer. Signed/unsigned and number of bytes depend on the applet parameter. Access Read/Write Parameter Name FgFloatValue Description Via this parameter, you can read/write applet parameters of type Double.Make sure parameter FgFeatureKey points to the applet parameter you have in mind. Type 64-bit Float Access Read/Write <p>Info</p> <p>Alternatively, you can use an *.mcf file to store and retrieve a specific applet configuration. For more information, see Frame Grabber Initialization Using an MCF File.</p>"},{"location":"cognex-vision-pro-adapter.html#configuring-the-cameras","title":"Configuring the Cameras","text":"<p>Configuring a camera you start by selecting a camera and establishing a connection to this camera. You do this via the Camera Connector Interface. Once you have selected and connected a specific camera, you can start the actual camera configuration.</p> <p>You can use a Cognex frame grabber object (DMA channel) for configuring any camera on the physical frame grabber, even if the selected camera doesn't influence the data stream of the Cognex frame grabber object you use for camera configuration.</p> <p>A Cognex frame grabber object has local access to one data stream, but global access to all cameras connected to a physical frame grabber.</p> <p>Thus, you can configure a camera via any Cognex frame grabber object, no matter if the selected camera sends data to this Cognex frame grabber object or not.</p> <p></p>"},{"location":"cognex-vision-pro-adapter.html#camera-connector-interface","title":"Camera Connector Interface","text":"<p>The camera connector interface allows to detect and configure cameras that support the GenICam standard (CL and CXP). Sending commands via this interface changes the interface's state, as you can see in the figure below.</p> <p></p> <p>The following commands and parameters are available:</p> Parameter Name InitializeCameraConnector Description If you are going to work with GenICam compatible cameras, start with calling this function. Type Command Access Execute Availability Always Parameter Name CloseCameraConnector Description Call this function when you are done and don't need to use the camera functions any longer. Type Command Access Execute Availability In following states: valid_lib, valid_port, invalid_port, valid_cam, invalid_cam Parameter Name Detect Description This function detects the available ports and the connected cameras. Type Command Access Execute Availability In following states: valid_lib, valid_port, invalid_port, valid_cam, invalid_cam Parameter Name StartAquisition Description Use exclusively this function to start image acquisition on the camera. Don't use the GenICam feature AcquisitionStart for this purpose. Type Command Access Execute Availability In state valid_cam Parameter Name StopAquisition Description Use exclusively this function to stop image acquisition on the camera. Don't use the GenICam feature AcquisitionStop for this purpose. Type Command Access Execute Availability In state valid_cam Parameter Name CameraCount Description This parameter holds the amount of cameras that have been detected on the active PortIndex. Type size_t<sup>a</sup> Access Read Availability In following states: valid_port, valid_cam, invalid_cam Parameter Name CameraIndex Description Use this parameter to select the camera you want to work with from the active PortIndex. Type size_t<sup>a</sup> Access Read/Write Availability In following states: valid_port, valid_cam, invalid_cam Parameter Name CameraName Description This parameter holds the name of the currently selected camera. Type String Access Read Availability In state valid_cam Parameter Name PortIndex Description Use this parameter to select the port you want to work on. Type size_t<sup>a</sup> Access Read/Write Availability In following states: valid_port, invalid_port, valid_cam, invalid_cam Parameter Name PortCount Description This parameter holds the number of available ports. Type size_t<sup>a</sup> Access Read Availability In following states: valid_port, invalid_port, valid_cam, invalid_cam"},{"location":"cognex-vision-pro-adapter.html#configuring-a-camera","title":"Configuring a Camera","text":"<p>For configuring a camera (which you have selected and connected as described in the previous sections), you have the following commands available.</p> <p>Info</p> <p>For detailed information on the specific target parameter names, refer to the camera documentation of the camera you are going to use.</p> <p>The following parameters allow to set the camera parameters:</p> Parameter Name CameraFeatureKey Description Use this parameter to specify the name of the camera parameter you are going to configure via CameraStringValue, CameraIntValue, CameraFloatValue, CameraBooleanValue, CameraEnumerationValue, or CameraCommand (see below). Type String Access Read/Write Parameter Name CameraStringValue Description Via this parameter, you can read/write camera parameters of type String.Make sure parameter CameraFeatureKey points to the target parameter you have in mind. Type String Access Read/Write Parameter Name CameraIntValue Description Via this parameter, you can read/write camera parameters of type Int.Make sure parameter CameraFeatureKey points to the target parameter you have in mind. Type Int Access Read/Write Parameter Name CameraFloatValue Description Via this parameter, you can read/write camera parameters of type Float.Make sure parameter CameraFeatureKey points to the target parameter you have in mind. Type Float Access Read/Write Parameter Name CameraBooleanValue Description Via this parameter, you can read/write camera parameters of type Boolean.Make sure parameter CameraFeatureKey points to the target parameter you have in mind. Type String Access Read/Write Parameter Name CameraEnumerationValue Description Via this parameter, you can read/write camera parameters of type Enumeration.Make sure parameter CameraFeatureKey points to the target parameter you have in mind. Type String Access Read/Write Parameter Name CameraCommand Description Use this parameter to execute the command you specified via parameter CameraFeatureKey. Type Command Access Read/Write"},{"location":"cognex-vision-pro-adapter.html#image-acquisition","title":"Image Acquisition","text":"<p>The following parameters allow to configure the actual image acquisition:</p> Parameter Name BufferCount Description With BufferCount you define the number of buffers that are used for adapter-internal image acquisition.Note that changing this parameter causes deletion or allocation of buffers. Type size_t<sup>a</sup> Access Read/Write Parameter Name FrameCountSinceLastStart Description Counter: Counts the number of images the adapter received after last start of image acquisition. Type size_t<sup>a</sup> Access Read Parameter Name TimestampFrequency Description A time stamp is assigned to each image. This parameter states the resolution of the timer. Type Uint64_t Access Read Parameter Name AcquisitionStrategy Description Via parameter AcquisitionStrategy you define the handling mode for the stream buffers. Type Enumeration Values The following buffer handling modes are available:<ul><li><code>OldestFirst</code>: See diagram below. The application always gets the buffer from the head of the Output Buffer Queue (thus, the oldest available one). If the Output Buffer Queue is empty, the application waits for a newly acquired buffer until the timeout expires. When data for a new buffer is available, the acquisition engine looks for any available buffer in the Input Buffer Pool, fills it, and appends it to the tail of the Output Buffer Queue. If the Input Buffer Pool is empty, the new data is dropped and an error is triggered. This buffer handling mode is typically used if every image frame is to be acquired and the mean processing time is lower than acquisition time. No buffer is discarded or overwritten in the Output Buffer Queue and all filled buffers are delivered in the order they were acquired.</li><li><code>OldestFirstOverwrite</code>: See diagram below. The application always gets the buffer from the head of the Output Buffer Queue (thus, the oldest available one). If the Output Buffer Queue is empty, the application waits for a newly acquired buffer until the timeout expires. When data for a new buffer is available, the acquisition engine looks for any available buffer in the Input Buffer Pool, fills it, and appends it to the tail of the Output Buffer Queue. If the Input Buffer Pool is empty and the Ouput Buffer Queue isn't empty, it discards the head of the Output Buffer Queue (i.e., the oldest buffer), overwrites it with the new data, and appends it to the tail of the Output Buffer Queue. If the Input Buffer Pool and the Output Buffer Queue are empty, the new data is dropped. This buffer handling mode is typically used if not every image frame is to be acquired and the application may not fall behind.</li><li><code>NewestOnly</code>: The application always gets the latest completed buffer (the newest one). If the Output Buffer Queue is empty, the application waits for a newly acquired buffer until the timeout expires. This buffer handling mode is typically used in a live display GUI where it is important that there is no lag between camera and display.</li></ul> Access Read/Write Availability While acquisition isn't active Parameter Name Transformation Description Cognex VisionPro doesn't accept RGB packed images. Via this parameter you define if images in RGB packed format are transformed into the Cognex compatible planar format or not.If you set the parameter to value <code>NoTransformation</code>, the images are discarded.If you set the parameter to value <code>RGB8PackedToPlanar</code>, RGB 8 packed images are transformed into RGB planar. The transformation is done in the CPU, therefore, setting the parameter to value <code>RGB8PackedToPlanar</code> may reduce the overall system performance.Note: At the moment, the adapter only supports conversion of Rgb8Packed images to planar format (and not, for example, the conversion of RGB16Packed). Type Enumeration Values <code>NoTransformation</code><code>RGB8PackedToPlanar</code> Access Read/Write Availability While acquisition isn't active"},{"location":"cognex-vision-pro-adapter.html#oldestfirst-buffer-handling-mode","title":"OldestFirst Buffer Handling Mode","text":""},{"location":"cognex-vision-pro-adapter.html#acquisition-engine","title":"Acquisition Engine","text":""},{"location":"cognex-vision-pro-adapter.html#buffer-delivery","title":"Buffer Delivery","text":""},{"location":"cognex-vision-pro-adapter.html#oldestfirstoverwrite-buffer-handling-mode","title":"OldestFirstOverwrite Buffer Handling Mode","text":""},{"location":"cognex-vision-pro-adapter.html#acquisition-engine_1","title":"Acquisition Engine","text":""},{"location":"cognex-vision-pro-adapter.html#buffer-delivery_1","title":"Buffer Delivery","text":""},{"location":"cognex-vision-pro-adapter.html#frame-grabber-initialization-using-an-mcf-file","title":"Frame Grabber Initialization Using an MCF File","text":"<p>A microEnable environmental configuration file (*.mcf) contains frame grabber parameterization data.</p> <p>The *.mcf file contains the name of the applet to be used at frame grabber initialization, and the parameterization of this applet.</p> <p>For information about how to create an *.mcf file, see the microDisplay X documentation.</p> <p>You can initialize the frame grabber with an *.mcf file in the software you build with VisionPro. The frame grabber is immediately pre-configured and ready-to-run.</p> <p>To initialize the frame grabber using an *.mcf file, change the following system environment variable:</p> <p><code>SISO_COGNEX_APPLET_[x] = [ConfigurationFilename]</code></p> <ul> <li><code>[x]</code> represents the index of the board, e.g. \"0\" for the first board</li> <li><code>[ConfigurationFilename]</code> is the path and file name of the *.mcf file to be used, for example: C:\\Program Files\\SiliconSoftware\\MyMCFs\\my configuration.mcf</li> </ul>"},{"location":"cognex-vision-pro-adapter.html#triggering","title":"Triggering","text":""},{"location":"cognex-vision-pro-adapter.html#trigger-parameters","title":"Trigger Parameters","text":"<p>VisionPro offers the following trigger parameters:</p> <ul> <li>Manual Triggering</li> <li>Hardware Auto</li> <li>Hardware Semi-Auto</li> <li>Free Run</li> </ul> <p>The parameter values can be changed individually for each parameter.</p> <p>The VisionPro trigger options aren't used when you initialize the frame grabber within the VisionPro software by using the Frame Grabber Configuration File (microEnable environmental configuration file *.mcf). The configurations taken from this file always overwrite the VisionPro trigger settings.</p> <p>The VisionPro trigger settings are only available if you don't use an *.mcf file for frame grabber initialization.</p> <p>The VisionPro trigger modes are mapped to the applet trigger models as follows:</p>"},{"location":"cognex-vision-pro-adapter.html#acquisition-applets-camera-link-area-scan-and-line-scan","title":"Acquisition Applets Camera Link \u2013 Area Scan and Line Scan","text":"Cognex Name Parameter Basler Default Value of Basler Cognex Adapter Basler Name Manual Triggering FG_TRIGGERMODEFG_EXSYNCONFG_CCSEL0 ASYNC_SOFTWARE_TRIGGER1CCEXSYNC Software trigger (software triggers image acquisition via frame grabber) Hardware Auto(setHardwareAutoTriggerMode) FG_TRIGGERMODEFG_EXSYNCONFG_CCSEL0 ASYNC_SOFTWARE_TRIGGER1CCEXSYNC External trigger Hardware Semi-Auto FG_TRIGGERMODEFG_EXSYNCONFG_CCSEL0 ASYNC_SOFTWARE_TRIGGER1CCEXSYNC No Basler name, since Hardware auto and Hardware Semi-Auto are the same in the Basler Cognex Adapter Free Run FG_TRIGGERMODE FREE_RUN Free run"},{"location":"cognex-vision-pro-adapter.html#advanced-acquisition-applets-camera-link-area-scan","title":"Advanced Acquisition Applets Camera Link \u2013 Area Scan","text":"Cognex Name Parameter Basler Default Value of Basler Cognex Adapter Basler Name Manual Triggering FG_AREATRIGGERMODE FG_TRIGGERCC_SELECT0FG_TRIGGERSTATE ATM_SOFTWARECC_PULSEGEN0TS_ACTIVE Software trigger (software triggers image acquisition via frame grabber) Hardware Auto(setHardwareAutoTriggerMode) FG_AREATRIGGERMODE FG_TRIGGERCC_SELECT0FG_TRIGGERSTATE ATM_SOFTWARECC_PULSEGEN0TS_ACTIVE External trigger Hardware Semi-Auto FG_AREATRIGGERMODE FG_TRIGGERCC_SELECT0FG_TRIGGERSTATE ATM_SOFTWARECC_PULSEGEN0TS_ACTIVE No Basler name, since Hardware auto and Hardware Semi-Auto are the same in the Basler Cognex Adapter Free Run FG_TRIGGERSTATE TS_SYNC_STOP Free run"},{"location":"cognex-vision-pro-adapter.html#advanced-acquisition-applets-camera-link-line-scan-and-others","title":"Advanced Acquisition Applets Camera Link \u2013 Line Scan (And Others)","text":"<p>For Advanced Acquisition Applets Line Scan on Camera Link frame grabbers, any trigger options are only available via the Frame Grabber Configuration File.</p>"},{"location":"cognex-vision-pro-adapter.html#example-configuring-and-using-the-software-trigger","title":"Example\u02d0 Configuring and Using the Software Trigger","text":"<p>To get a software trigger pulse in Cognex VisionPro with the Basler Cognex VisionPro Adapter:</p> <ol> <li> <p>Set the parameters as shown in the following flow chart:</p> <p></p> <p>Info</p> <p>The Camera Link parameter \"FG_CCSEL0\" is called \"FG_TRIGGWECC_SELCET0\" in the Cognex adapter.</p> <p>The following screenshot shows how to set the parameters:</p> <p></p> </li> <li> <p>Send a software trigger pulse to start the acquisition:</p> <ol> <li>Click the yellow Run QuickBuild Application button continuously.</li> <li>In the Imaging Device tab, enter <code>FgIntValue</code> in the Feature input field and click Read. Value 1 is displayed.</li> <li>Click Write to send the software trigger pulse.</li> </ol> </li> </ol> <ol> <li> <p>This data type is always unsigned. See the C++ reference for details.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"command-line-tool-me5boardsettings.html","title":"Command Line Tool mE5BoardSettings","text":"<p>The command line tool mE5BoardSettings allows to enable/disable Power over Camera Link (PoCL) via command line on frame grabbers that provide a PoCL on/off option.</p> <p>These are the following frame grabbers:</p> <ul> <li>mE5 marathon ACL</li> <li>mE5 marathon VCL</li> <li>mE5 marathon VCLx</li> </ul> <p>mE5BoardSettings is installed together with the Basler Framegrabber SDK. You find the tool in the Framegrabber SDK installation directory, sub-directory bin (%BASLER_FG_SDK_DIR%/bin).</p>"},{"location":"command-line-tool-me5boardsettings.html#why-do-i-need-to-enable-pocl-support","title":"Why do I Need to Enable PoCL Support?","text":"<p>Power over Camera Link (PoCL) support is disabled per default on the above mentioned frame grabbers. If you want to use PoCL on one of these frame grabbers, you must actively enable PoCL support on the frame grabber.</p> <p>Info</p> <p>Exception:</p> <p>You don't need to enable PoCL when using</p> <ul> <li>acquisition applets out of applet set version 1.x or</li> <li>custom applets built with VisualApplets 3.0.4 or lower)</li> </ul> <p>mE5 marathon ACL, or mE5 marathon VCL.</p>"},{"location":"command-line-tool-me5boardsettings.html#overview","title":"Overview","text":"<p>The table below shows when you must enable PoCL and which tools are available under the respective circumstances:</p> Frame Grabber Model Applet Set Version (Standard Applets) VisualApplets Version (Custom Applets) Framegrabber SDK Version PoCL Enabling required for PoCL operation Tool for Enabling PoCL mE5 marathon VCLx any applet set 1.0 or higher 3.1 (or higher) 5.6 or higher yes, always for this board Command line tool mE5BoardSettings, microDiagnostics mE5 marathon ACLmE5 marathon VCL 2.0 (or higher) 3.0.6 (or higher) 5.5.1 or higher yes Command line tool mE5BoardSettings, microDiagnostics mE5 marathon ACLmE5 marathon VCL 2.0 (or higher) 3.0.6 (or higher) 5.5. or lower yes Command line tool mE5BoardSettings mE5 marathon ACLmE5 marathon VCL 1.x 3.0.5 (or lower) any no <p>If you use the Framegrabber SDK version 5.5.1 or higher, you can alternatively enable PoCL support on your board via the GUI tool microDiagnostics that comes as part of the Framegrabber SDK. For information how to do that, see the microDiagnostics user manual, section PoCL Support.</p> <p>Prerequisites:</p> <ul> <li>You use marathon Camera Link frame grabbers (mE5 marathon ACL, mE5 marathon VCL, or mE5 marathon VCLx).</li> <li>Your cameras support Power Over Camera Link (PoCL).</li> <li>You want to use<ul> <li>acquisition applets from applet set version 2.0 (or higher)1 on marathon ACL/VCL</li> <li>acquisition applets from applet set version 1.0 (or higher) on marathon VCLx, or custom applets built with VisualApplets 3.0.6 (or higher). In applets built with VisualApplets 3.0.5 or lower, PoCL support is automatically enabled.</li> </ul> </li> <li>You have the Basler Framegrabber SDK (version 5.4 or higher) installed and working on your computer (Windows or Linux).</li> </ul> <p>You must enable PoCL if you want to use PoCL in your system and use the following components together:</p> Frame Grabber Model Applets Built with VisualApplets mE5 marathon ACL Standard Applets 2.0 (or higher)Custom Applet 3.0.6 (or higher) mE5 marathon VCL Standard Applets 2.0 (or higher)Custom Applet 3.0.6 (or higher) mE5 marathon VCLx Standard Applets 1.0 (or higher)Custom Applet 3.1 (or higher)"},{"location":"command-line-tool-me5boardsettings.html#enabling-and-disabling-pocl","title":"Enabling and Disabling PoCL","text":"<p>To enable or disable PoCL on your frame grabber via command line interface:</p> <ol> <li>Close all applications using the frame grabber.</li> <li>Open the command line interpreter (under Windows cmd.exe, under Linux in most distributions Terminal).</li> <li>In the command line interpreter, go to the bin folder of your Basler Framegrabber SDK installation.</li> <li> <p>Enter <code>mE5BoardSettings</code>, followed by some parameters depending on the task you want to perform:</p> <ul> <li> <p>Getting information about the settings of all boards in the system:</p> <p>Enter <code>mE5BoardSettings</code> without any parameters.</p> <p>The settings of all boards in the system are displayed. Example: In the follwoing image, you see one board (mE5 marathon VCL) with board index 0 is installed in the system. On this board, PoCL is disabled.</p> <p></p> </li> <li> <p>Enabling and Disabling PoCL support for all boards in your system:</p> <p>To enable PoCL support, enter <code>mE5BoardSettings -a -pocl enable -reconfigure</code>.</p> <p>To disable PoCL support, enter <code>mE5BoardSettings -a -pocl disable -reconfigure</code>.</p> <p><code>-a</code> stands for all boards in the system.</p> </li> <li> <p>Enabling and Disabling PoCL support for one board in your system:</p> <p>Enter <code>mE5BoardSettings -b &lt;board index&gt; -pocl enable -reconfigure</code>.</p> </li> <li> <p>Disabling PoCL support for one board in your system:</p> <p>To enable PoCL support, enter <code>mE5BoardSettings -b &lt;board index&gt; -pocl enable -reconfigure</code>.</p> <p>To disable PoCL support, enter <code>mE5BoardSettings -b &lt;board index&gt; -pocl disable -reconfigure</code></p> <p>Instead of <code>&lt;board index&gt;</code>, enter the actual board index of the board you want to enable PoCL support on, for example:</p> <p><code>mE5BoardSettings -b 0 -pocl enable -reconfigure</code> if you want to configure board 0 in your system.</p> </li> </ul> </li> </ol> <p>After successfully enabling or disabling PoCL support, you get the following message:</p> <p><code>Ok; Board reconfigured; Close all applications using the board.</code></p> <p>Close all applications using the board.</p> <p>Info</p> <p>If you're using virtual COM Ports using the Basler ClSerCOM Wrapper, you always need to re-start the host computer at this point to activate the feature.</p> <p>This isn't reflected in the messages output by the command line tool mE5BoardSettings.</p> <p>If the configuration failed, for example, because crash protection has been activated on the board, you get the message:</p> <p><code>Ok; Warning: Failed to reconfigure board; Powercycle required to activate board features.</code></p> <p>In this case, power cycle your computer. After power cycling, PoCL is (de-)activated on the frame grabber.</p>"},{"location":"command-line-tool-me5boardsettings.html#syntax-at-a-glance","title":"Syntax at a Glance","text":"<p>You call mE5BoardSettings in the command line tool by its name: <code>mE5BoardSettings</code></p> <p>The following parameters are available:</p> <p><code>-all</code> or <code>-a</code></p> <p><code>-board &lt;board-index&gt;</code> or <code>-b &lt;board-index&gt;</code></p> <p><code>-pocl enable|disable</code></p> <p><code>-reconfigure</code></p> <p>You have the following commands available:</p> Calling the tool Specifying the boards Setting the PoCL Support Starting Reconfiguration mE5BoardSettings -b &lt;board-index&gt; -pocl enable -reconfigure mE5BoardSetting -b &lt;board-index&gt; -pocl disable -reconfigure mE5BoardSetting -board &lt;board-index&gt; -pocl enable -reconfigure mE5BoardSetting -board &lt;board-index&gt; -pocl disable -reconfigure mE5BoardSetting -a &lt;board-index&gt; -pocl enable -reconfigure mE5BoardSetting -a &lt;board-index&gt; -pocl disable -reconfigure mE5BoardSetting -all &lt;board-index&gt; -pocl enable -reconfigure mE5BoardSetting -all &lt;board-index&gt; -pocl disable -reconfigure <p>For &lt;board-index&gt;, enter the actual index number of the board you want to enable/disable PoCL support for. The index numbers of your frame grabber boards are displayed, for example, in microDiagnostics.</p> <p>If you use <code>-a</code> or <code>-all</code> (instead of <code>-b &lt;board-index&gt;</code> or <code>-board &lt;board-index&gt;</code>), all frame grabbers in the system will be set at once.</p> <p>For activating your settings, you must reconfigure the FPGA on your frame grabber, therefore the parameter <code>-reconfigure</code> is added at the end of the command line.</p> <p>If you call the tool without specifying any parameters, the current settings of all boards in your system are displayed.</p>"},{"location":"command-line-tool-me5boardsettings.html#output-messages","title":"Output Messages","text":"<p>The Command Line tool mE5BoardSettings displays the following messages:</p> Message Meaning <code>Ok; Board reconfigured; Close all applications using the board</code> You have successfully enabled or disabled PoCL support and the FPGA on the board has been reconfigured. You must close all applications using the board and reopen them to get the change displayed in the applications. <code>Ok; Reconfiguration or powercycle required to activate feature</code> The PoCL support has been successfully enabled/disabled. However, you didn't add parameter <code>-reconfigure</code> at the end of the command line. As your settings get only active after FPGA reconfiguration, reconfigure the FPGA or power cycle the host computer. <code>Ok; Warning: Failed to reconfigure board; Powercycle required to activate board features</code> The PoCL support has been successfully enabled/disabled. However, reconfiguration failed (for example, because crash protection has been activated on the board, see Crash Protection. You must power cycle the host computer. <code>Ignored: Feature already enabled</code> If you try to overwrite a setting with exactly the same value, you get this message. The frame grabber is already configured as you want it to be. <code>Ignored: Board feature not supported by board type</code> The selected frame grabber board is no Camera Link board, therefore PoCL can't be used. <code>Warning: Board features not supported by firmware; Ok</code> The applets (including the firmware) flashed onto the board have PoCL support activated by default. This is so for acquisition applets sets version 1.7 or lower and for all custom applets built with VisualApplets version 3.0.5 or lower. For the use of these applets, you don't need to set PoCL support at all. However, as soon as you flash standard applets of version 2.0 or higher, or applets built with VisualApplets 3.0.6 or higher, your PoCL settings on the board will become relevant.The message outputs as <code>OK</code>, since the PoCL support has been successfully enabled/disabled. <code>Warning: Board features not supported by firmware; Ignored: Feature already enabled</code> The applets (including the firmware) flashed onto the board have PoCL support activated by default. This is so for acquisition applets sets version 1.7 or lower and for all custom applets built with VisualApplets version 3.0.5 or lower. For the use of these applets, you don't need to set PoCL support at all. However, as soon as you flash standard applets of version 2.0 or higher, or applets built with VisualApplets 3.0.6 or higher, your PoCL settings on the board will become relevant.The frame grabber is already configured as you want it to be. Therefore, your attempt to overwrite the setting with exactly the same value is ignored."},{"location":"configuring-the-applet-micro-display-x.html","title":"Configuring the Applet (microDisplay X)","text":"<p>To configure your applet and to test the configuration, proceed the following steps:</p> <ol> <li>Start microDisplay X on your computer.</li> <li> <p>Select the frame grabber you want to work with from the list in the left upper corner.A tool tip provides you with more information about the frame grabber:</p> <p></p> <p>When selecting a frame grabber, a list of applets should appear in the pane below:</p> <p></p> <p>Info</p> <p>If there are no applets displayed, install the applet set for your frame grabber model on the host computer as described in the User Manual of your frame grabber. After installation, select File -&gt; Rescan Applets in microDisplay X.</p> </li> <li> <p>Select an applet out of the applets list.A tool tip provides you with more information about each applet:</p> <p></p> <p>The applet you select must correspond to the connected cameras (number of connected cameras per frame grabber, area or line scan, etc.).</p> <p>The applet name displayed in bold is the applet that is currently active on the frame grabber.</p> <p>The applets displayed in black are the applets currently available for the selected frame grabber.</p> <p>When is an applet available?</p> <ul> <li>On imaWorx and imaFlex frame grabbers, an applet is available as soon as it is available in the file system of your computer (Framegrabber SDK installation directory, sub-directories DLL or Hardware Applets). If the applet isn't there, run the applet installer that contains the applet you want to use, or, if you need an applet created with VisualApplets, copy the applet file (*.hap) into the Hardware Applets folder of your Framegrabber SDK installation (e.g., <code>...\\Basler\\FramegrabberSDK5.x.x\\Hardware Applets\\*.hap</code>).</li> <li>On marathon frame grabbers, an applet is available as soon as it is flashed onto the frame grabber. If the applet you want to use isn't flashed on the frame grabber yet, flash it according to the instructions in Managing Applets (microDiagnostics).</li> </ul> </li> <li> <p>Double-click the applet name to load the applet.</p> <p></p> <p>The applet is loaded. The acquisition processes of the applet (together with the respective camera and DMA ports) are displayed in the left-hand pane, and the DMA outputs are visible in the viewing pane (tab Acquisition Channel):</p> <p></p> <p>For each process defined in the applet, an according acquisition process with camera IN ports (Cam 0, Cam 1, \u2026) and DMA OUT ports (DMA 0, DMA 1, \u2026) is displayed.</p> <p></p> <p>The tooltip of a DMA line (left-hand panel) informs you about the most important applet features and settings:</p> <p></p> <p>To connect another camera to a given applet process, click the Edit button in the Cam line and select the camera you want to connect. After this, the camera will show in the Cam line of the process and disappear from the Cam line of the process it was connected to before.</p> </li> <li> <p>Make sure your cameras are connected and detected. A detected camera (image source) is marked green:</p> <p></p> </li> <li> <p>If no camera is detected, deactivate the Windows Fast Startup option as described by www.windowscentral.com.</p> <p>Info</p> <p>Instead of a camera, you can use the Camera Simulator as image source if you have no camera at hand. To do so:</p> <ol> <li>Click the DMA line to configure the input source for a process (acquisition channel).</li> <li>Below, in the Parameter Selection pane, open the options for parameter Camera Simulator. Go to Image Source and from the value list, select Generator.</li> <li>The Cam line of the process should display a green disk now and display the information that an image generator is connected to the input of the acquisition channel.</li> </ol> </li> <li> <p>Click the DMA line to configure the applet for a process.</p> </li> <li> <p>Set the applet parameters in the pane below:</p> <p></p> <p>Double-click or right-click a parameter/value to get the list of available values or an input field.</p> </li> <li> <p>Define the time-out and the number of buffers to be allocated per acquisition channel: Keep the DMA line of the process active. Click the Edit button. In the dialog that opens, you can set the parameters:</p> <ul> <li>Timeout: Acquisition timeout. If no image has been received in the time span you define here, acquisition is aborted.</li> <li>Buffers: Number of buffers to be allocated per acquisition channel.</li> </ul> </li> <li> <p>Repeat steps 7 to 9 for all active DMA channels.</p> </li> <li>If necessary, adapt the camera settings as described in the Configuring the Camera topic.To avoid random data at the margins of the acquired images (displayed in red in the DMA output display panes), make sure the applet settings for frame width and height match the camera settings for frame width and height.</li> <li> <p>Acquire several images:</p> <ol> <li> <p>Click the DMA line of the process you want to start. The corresponding DMA output display pane (tab Acquisition Channel) becomes active:</p> <p></p> </li> <li> <p>Click the Grab button to start acquisition.If your system is correctly installed, the grabbed images are displayed in the corresponding DMA output display pane:</p> <p></p> </li> <li> <p>Use the Stop button to stop acquisition.</p> </li> </ol> </li> <li> <p>Examine the acquired images. They are displayed in the DMA output display pane.</p> </li> <li>If necessary, adjust the applet parameter settings so the acquired images fulfill your requirements.</li> <li> <p>If you want to reuse your applet configuration, save your applet configuration to an MCF file:</p> <p></p> <p>The MCF file contains the applet configuration for one frame grabber, including the configurations for all processes (acquisition channels) of the applet. For more information, see Saving Applet Configuration.</p> </li> </ol>"},{"location":"configuring-the-camera-micro-display-x.html","title":"Configuring the Camera (microDisplay X)","text":"<p>In microDisplay X, you can configure the cameras in your vision system using the GenICam interface of the camera.</p> <p>In addition, you can use microDisplay X to access camera registers directly. This might be helpful, for example, when you want to access a camera register that holds content not defined by the GenICam standard.</p> <p></p>"},{"location":"configuring-the-camera-micro-display-x.html#configuring-the-camera-via-genicam-interface","title":"Configuring the Camera via GenICam Interface","text":"<p>Requirements:</p> <ul> <li>Your camera supports the GenICam standard.</li> <li>Camera and frame grabber are plugged and powered (camera may be powered by the grabber via power over).</li> <li>The Framegrabber SDK has been installed.</li> </ul> <p>To adjust the camera settings:</p> <ol> <li>Start microDisplay X.</li> <li> <p>Select the frame grabber you want to work with from the list under Acquisition Devices (left upper corner).</p> <p>Immediately, a list of applets is displayed in the pane below.</p> <p>Info</p> <p>If there are no applets displayed, install the applet set for your frame grabber model on the host computer as described in the User Manual of your frame grabber. After installation, select File -&gt; Rescan Applets in microDisplay X.</p> </li> <li> <p>Select an applet out of the applets list.</p> </li> <li> <p>Double-click the applet name to load the applet.</p> <p>Wait until the camera is discovered. A discovered camera is marked by a green disk.</p> <p></p> </li> <li> <p>Switch to the Cameras tab.</p> <p></p> </li> <li> <p>In the Cameras tab, select the frame grabber that is connected to the cameras you want to configure. The cameras connected to this frame grabber are listed in the Model (UID) panel below:</p> <p></p> </li> <li> <p>Select a camera in the Model (UID) panel to work on this specific camera.</p> </li> <li> <p>Go to the GenICam tab to configure the camera.</p> <p></p> </li> <li> <p>Select a user role. You can choose between three display modes (right upper corner): Beginner, Expert, and Guru. If you set the display mode to Beginner, you can only see and alter the most important camera settings. In Expert mode, most settings are enabled and in Guru mode, all possible settings can be seen and adapted.</p> <p></p> </li> <li> <p>Click a parameter value to change it. Use the arrows (on the right of the value field) or type directly.</p> <p></p> <p>You can find more information about each parameter in the right hand bottom panel as soon as you click the parameter:</p> <p></p> </li> <li> <p>Click the Force Update button if you don't see the changes in your settings immediately.</p> <p></p> </li> <li> <p>Set all camera parameters as desired.Alternatively, you can load a camera configuration you have saved to file before. To load an existing camera configuration, click Load Parameters.</p> </li> <li> <p>Optional: Click Save Parameters to save the camera configuration.The camera configuration is stored in a *.txt file.</p> <p></p> </li> <li> <p>Repeat steps 4\u201313 for all connected cameras.</p> </li> </ol>"},{"location":"configuring-the-camera-micro-display-x.html#directly-accessing-camera-registers","title":"Directly Accessing Camera Registers","text":"<p>You can access camera registers directly, without using the GenICam layer. You have direct read and write access. This is useful if you want to access a camera register that holds content not defined by the GenICam standard.</p> <p>Requirements:</p> <ul> <li>You know the addresses of the registers you want to access.</li> </ul> <p>To get read/write access to a camera register:</p> <ol> <li>Start microDisplay X.</li> <li> <p>Switch to the Cameras tab.</p> <p></p> </li> <li> <p>In the Cameras tab, select the frame grabber that is connected to the cameras you want to configure. The cameras connected to this frame grabber are listed in the Model (UID) panel below:</p> <p></p> </li> <li> <p>Select a camera in the Model (UID) panel to work on this specific camera.</p> </li> <li> <p>Switch to the Direct Register Access tab to configure the camera.</p> <p></p> </li> <li> <p>Access the desired registers:</p> <ul> <li>Read Access:<ol> <li>Under Read Register, enter the address of the register into field Address. Click the Read button to read the value currently stored in the register.</li> </ol> </li> <li>Write Access:<ol> <li>Under Write Register, enter the address of the register into field Address.</li> <li>Enter the value you want to write into the register into field Value.</li> <li>Click the Write button to write the new value into the register.</li> </ol> </li> </ul> </li> </ol>"},{"location":"configuring-the-frame-grabber-using-pylon.html","title":"Configuring the Frame Grabber Using pylon","text":"<p>This topic tells you how to configure a pylon-compatible frame grabber using the pylon API, the pylon Viewer, or the gpioTool.</p> <p>Info</p> <p>This topic covers basic use cases. For in-depth information about the software features of the frame grabber, see the following documentation:</p> <ul> <li>Acquisition Applets for imaWorx CXP-12 Quad</li> <li>GenTL Interface Documentation</li> </ul> <p>Configuring the frame grabber is especially useful in the following situations:</p> <ul> <li>You want to change the applet used by the frame grabber.</li> <li>You want to trigger the connected Basler boost camera via the frame grabber.</li> <li>You want to perform debayering on the frame grabber to increase the performance of your imaging system.</li> <li>You want to use an output format that isn't available on your camera, e.g., a 16-bit mono format.</li> <li>You want to configure the trigger signals received or sent by the frame grabber.</li> </ul>"},{"location":"configuring-the-frame-grabber-using-pylon.html#changing-the-applet","title":"Changing the Applet","text":"<p>The applet running on the frame grabber defines its functionality. For certain camera setups, you may have to change the default applet.</p> <p>To change the applet used by the frame grabber, set the <code>InterfaceApplet</code> parameter to the name of the applet to be loaded, e.g., <code>Acq_DualCXP12Area</code>.</p> <p>To find out which applets are available, see Acquisition Applets for imaWorx CXP-12 Quad.</p>"},{"location":"configuring-the-frame-grabber-using-pylon.html#using-the-frame-grabber-to-trigger-a-basler-boost-camera","title":"Using the Frame Grabber to Trigger a Basler boost Camera","text":"<p>Info</p> <p>This section is only relevant if you specifically want to trigger the camera via the frame grabber. Usually, the camera is triggered via the camera's I/O connector. For more information, see Triggered Image Acquisition.</p>"},{"location":"configuring-the-frame-grabber-using-pylon.html#hardware-triggering-external","title":"Hardware Triggering (External)","text":"<p>With external triggering enabled, you can send trigger input signals to the frame grabber, and the frame grabber forwards these signals to the Basler boost camera.</p> <p>To configure the frame grabber for external hardware triggering:</p> <ol> <li>Set the <code>AreaTriggerMode</code> parameter to <code>External</code>.</li> <li>Set the <code>TriggerInSource</code> parameter to the desired \"Front GPI\" input line.For example, if you want to use GPI0 (pin 11 and 12 on the frame grabber) for external triggering, set the parameter to <code>FrontGpiTriggerSource0</code>.</li> <li>Set the <code>TriggerCameraOutSelect</code> parameter to the corresponding \"Bypass\" option.For example, if you selected <code>FrontGpiTriggerSource0</code>, set the <code>TriggerCameraOutSelect</code> parameter to <code>BypassFrontGpi0</code>.</li> <li>Set the <code>TriggerState</code> parameter to <code>Active</code>.</li> <li>If necessary, configure the trigger signals as described below.</li> </ol> <p>All trigger signals are forwarded to the camera's source signals <code>CxpTrigger0</code> and <code>CxpTrigger1</code> (there is currently no difference in behavior between the two lines). The signals can be used for various purposes. The most common use case is image acquisition. See the example below.</p>"},{"location":"configuring-the-frame-grabber-using-pylon.html#hardware-triggering-internal","title":"Hardware Triggering (Internal)","text":"<p>With internal triggering enabled, the frame grabber generates trigger signals internally at a specified frequency. All external trigger signals are ignored.</p> <p>To configure the frame grabber for internal hardware triggering:</p> <ol> <li>Set the <code>AreaTriggerMode</code> parameter to <code>Generator</code>.</li> <li>Set the <code>TriggerOutputFrequency</code> parameter to the desired trigger output frequency.    For example, if you set the parameter to 8, the frame grabber will generate 8 trigger signals per second.</li> <li>Set the <code>TriggerCameraOutSelect</code> parameter to the desired output line, e.g., <code>PulseGenerator0</code>.</li> <li>Set the <code>TriggerState</code> parameter to <code>Active</code>.</li> </ol> <p>Now, whenever you start image acquisition, the frame grabber will generate trigger signals at the specified frequency.</p> <p>All trigger signals are forwarded to the camera's source signals <code>CxpTrigger0</code> and <code>CxpTrigger1</code>. The signals can be used for various purposes. The most common use case is image acquisition. See the example below.</p>"},{"location":"configuring-the-frame-grabber-using-pylon.html#example-using-the-trigger-signals-for-image-acquisition","title":"Example: Using the Trigger Signals for Image Acquisition","text":"<p>To use the external or internal trigger signals generated by the frame grabber to acquire images:</p> <ol> <li>On the camera, set the <code>TriggerSelector</code> parameter to <code>FrameStart</code>.</li> <li>Set the <code>TriggerMode</code> parameter to <code>On</code>.</li> <li>Set the <code>ExposureMode</code> parameter to <code>Timed</code>.</li> <li>Set the <code>TriggerSource</code> parameter to <code>CxpTrigger0</code> or <code>CxpTrigger1</code>.As there is currently no difference in behavior between the two lines, you can choose either one of them.</li> </ol> <p>Now, the camera acquires an image each time the frame grabber receives or generates a trigger signal.</p> <p>Info</p> <p>You can use the trigger signals as the source for any Basler boost camera feature that can be controlled by a signal source. For example, setting the <code>CounterTriggerSource</code> parameter to <code>CxpTrigger0</code> allows you to control the Counter feature using the frame grabber.</p>"},{"location":"configuring-the-frame-grabber-using-pylon.html#performing-debayering-on-the-frame-grabber","title":"Performing Debayering on the Frame Grabber","text":"<p>You can perform debayering on the frame grabber. This reduces computing load on the camera and the host computer.</p> <p>To do so:</p> <ol> <li>On the camera, set the <code>PixelFormat</code> parameter to a Bayer pixel format, e.g., <code>BayerRG12</code>.</li> <li>On the frame grabber, set the <code>AutomaticFormatControl</code> parameter to <code>false</code>.This allows you to set the output format independently of the pixel format used by the camera.</li> <li>On the frame grabber, set the <code>Format</code> parameter to the corresponding RGB pixel format.The bit depth must be three times the bit depth of the Bayer pixel format. For example, BayerRG12 (camera) = Color36bit (frame grabber).</li> </ol> <p>Now, the frame grabber will perform debayering on the camera's raw image data and output RGB image data.</p> <p>Info</p> <p>Make sure that you set the correct RGB pixel format in step 3 above. Otherwise, images won't be acquired properly.</p>"},{"location":"configuring-the-frame-grabber-using-pylon.html#using-output-formats-not-available-on-the-camera","title":"Using Output Formats not Available on the Camera","text":"<p>The Basler boost camera can output image data in a number of pixel formats, e.g., Bayer RG 8 or RBG 8. For more information, see the pixel format topic.</p> <p>If your required pixel format isn't available on the camera and you also want to avoid image conversion on the host computer, you may be able to use one of the pixel formats provided by the frame grabber.</p> <p>The frame grabber provides the following formats:</p> Gray8bit Gray10bit Gray12bit Gray16bit Color24bit Color30bit Color36bit Color48bit Bayergr8 Bayergr10 Bayergr12 Bayergr16 Bayerrg8 Bayerrg10 Bayerrg12 Bayerrg16 Bayergb8 Bayergb10 Bayergb12 Bayergb16 Bayerbg8 Bayerbg10 Bayerbg12 Bayerbg16 <p>To use an output format not available on the camera:</p> <ol> <li>On the camera, set the <code>PixelFormat</code> parameter to the desired camera pixel format, e.g., <code>Mono12</code>.</li> <li>On the frame grabber, set the <code>AutomaticFormatControl</code> parameter to <code>false</code>.This allows you to set the output format independently of the pixel format used by the camera.</li> <li>On the frame grabber, set the <code>Format</code> parameter to the desired output format, e.g., <code>Gray16bit</code>.</li> </ol> <p>With the example values above, the frame grabber outputs 16-bit image data based on 12-bit camera image data. Padding bits (zeros) are inserted as illustrated below.</p> <p></p>"},{"location":"configuring-the-frame-grabber-using-pylon.html#configuring-the-trigger-signals-using-the-gpiotool","title":"Configuring the Trigger Signals using the gpioTool","text":"<p>With the gpioTool command-line tool, you can configure the physical properties of the trigger signals received or sent by the frame grabber:</p> <p>The gpioTool is included in the Framegrabber SDK and in the pylon Software Suite.</p> <p>For more information, see gpioTool.</p>"},{"location":"configuring-the-frame-grabber-using-pylon.html#sample-code","title":"Sample Code","text":"C++ (Native) <pre><code>// Select the Acq_SingleCXP12Area applet\ncamera.GetTLParams().InterfaceApplet.SetValue(Acq_SingleCXP12Area);\n// Configure the frame grabber for external triggering\ncamera.GetTLParams().AreaTriggerMode.SetValue(AreaTriggerMode_External);\ncamera.GetTLParams().TriggerInSource.SetValue(TriggerInSource_FrontGpiTriggerSource0);\ncamera.GetTLParams().TriggerCameraOutSelect.SetValue(TriggerCameraOutSelect_BypassFrontGpi0);\ncamera.GetTLParams().TriggerState.SetValue(TriggerState_Active);\n// Configure the frame grabber for internal triggering\ncamera.GetTLParams().AreaTriggerMode.SetValue(AreaTriggerMode_Generator);\ncamera.GetTLParams().TriggerOutputFrequency.SetValue(8);\ncamera.GetTLParams().TriggerCameraOutSelect.SetValue(TriggerCameraOutSelect_PulseGenerator0);\ncamera.GetTLParams().TriggerState.SetValue(TriggerState_Active);\n// Use the external or internal trigger signals for image acquisition\ncamera.TriggerSelector.SetValue(TriggerSelector_FrameStart);\ncamera.TriggerMode.SetValue(TriggerMode_On);\ncamera.ExposureMode.SetValue(ExposureMode_Timed);\ncamera.TriggerSource.SetValue(TriggerSource_CxpTrigger0);\n// Perform debayering on the frame grabber (Bayer RG 12 --&gt; RGB 36 bit)\ncamera.PixelFormat.SetValue(PixelFormat_BayerRG12);\ncamera.GetTLParams().AutomaticFormatControl.SetValue(false);\ncamera.GetTLParams().Format.SetValue(Format_Color36bit);\n// Configure the frame grabber to output 16-bit mono image data based on\n// 12-bit mono image data from the camera\ncamera.PixelFormat.SetValue(PixelFormat_Mono12);\ncamera.GetTLParams().AutomaticFormatControl.SetValue(false);\ncamera.GetTLParams().Format.SetValue(Format_Gray16bit);\n</code></pre> <p>This sample code is only available in C++ language.</p> <p>You can also use the pylon Viewer to set the parameters.</p>"},{"location":"connecting-cameras.html","title":"Connecting Cameras","text":"<p>This topic tells you how to set up your camera to work with a Basler frame grabber.</p>"},{"location":"connecting-cameras.html#connecting-coaxpress-cameras-to-the-frame-grabber","title":"Connecting CoaXPress Cameras to the Frame Grabber","text":"<p>These instructions apply to all CoaXPress frame grabbers.</p> <p>To connect a camera to the frame grabber:</p> <ol> <li>Plug the cables of your camera into the CoaXPress connectors on the slot bracket of the CoaXPress frame grabber (ports CXP 1, CXP 2, CXP 3, CXP 4, and CXP 5).</li> <li> <p>Plug the CoaXPress cables into the appropriate connectors of the camera:</p> <p></p> </li> </ol> <p>Info</p> <p>Basler recommends the following order of ports:</p> <ul> <li> <p>Connect camera connector 1 to port CXP 1 of the frame grabber, and proceed accordingly, connecting</p> <ul> <li>camera connector 2 to frame grabber port CXP 2 (if available),</li> <li>camera connector 3 to frame grabber port CXP 3 (if available),</li> <li>camera connector 4 to frame grabber port CXP 4 (if available),</li> <li>and camera connector 5 to frame grabber port CXP 5 (if available).</li> </ul> </li> <li> <p>Connect camera connector 2 to frame grabber port CXP 2 (if available).</p> </li> <li>Connect camera connector 3 to frame grabber port CXP 3 (if available).</li> <li>Connect camera connector 4 to frame grabber port CXP 4 (if available).</li> <li>Connect camera connector 5 to frame grabber port CXP 5 (if available).</li> </ul> <p>Info</p> <p>CoaXPress always supports Power Over functionality, i.e., the cameras are powered by via the CXP cables</p> <p>If you want to power the camera via the frame grabber, the frame grabber needs an extra connection to the computer power supply.</p> <p>When the camera is connected, a green blinking LED on the camera indicates that the camera is powered.</p> <p>If the LED on the camera isn't blinking, check if you connected the male power connector to the computer power supply.</p> <p></p> <p>If the power connector isn't connected:</p> <ol> <li>Shut down your computer.</li> <li>Disconnect your computer from power.</li> <li>Connect the female power connector to the frame grabber. If your computer doesn't provide a matching power supply, use a suitable adapter.</li> <li>Reconnect and boot your computer.</li> <li>If your frame grabber doesn't provide power to the camera, or if your camera doesn't use the power over feature, power the camera.</li> <li>Repeat the steps above to connect all cameras in your system.</li> </ol> <p>To configure the camera, open the microDisplay X tool. Instructions for configuring the camera via microDisplay X are available in the microDisplay X User's Manual.</p>"},{"location":"connecting-cameras.html#connecting-camera-link-cameras-to-the-frame-grabber","title":"Connecting Camera Link Cameras to the Frame Grabber","text":"<p>These instructions apply to all Camera Link frame grabbers.</p> <p>To connect a camera to the frame grabber:</p> <ol> <li>Plug the Camera Link cables of your camera into the connectors on the slot bracket of the Camera Link frame grabber.</li> <li>Plug the Camera Link cables into the appropriate connectors of the camera.</li> <li>If applicable: If your camera doesn't support Power Over Camera Link (PoCL), make sure to deactivate PoCL and connect the camera to a power supply.</li> </ol>"},{"location":"connecting-cameras.html#activatingdeactivating-pocl-support","title":"Activating/Deactivating PoCL Support","text":"<p>PoCL support is deactivated per default if you are running applets out of applet set version 2.0 (or higher) or an individual applet created with VisualApplets 3.0.6 (or higher).</p> <p>To activate or deactivate PoCL Support, see Enabling PoCL Support.</p>"},{"location":"connecting-frame-grabbers.html","title":"Connecting Frame Grabbers","text":"<p>This topic tells you how to connect your Basler frame grabber to a host computer.</p>"},{"location":"connecting-frame-grabbers.html#safety-information","title":"Safety Information","text":"<p>Electric Shock Hazard</p> <p>Installing the frame grabber while the computer is connected to power may cause electric shock. Serious injury or death may occur.</p> <ul> <li>Before installing the frame grabber, switch off the computer and the connected devices and unplug all power cables from the computer.</li> <li>Before power-up, close the computer case</li> </ul> <p>Electrostatic discharge may damage electronic components.</p> <ul> <li>Before touching the frame grabber, drain static charges from yourself to ground, e.g., by touching a metal water tap.</li> <li>During installation, make sure that you remain properly grounded, e.g., by wearing an antistatic wrist strap.</li> </ul> <p>Overheating may damage the frame grabber and other components.</p> <p>Make sure that you use an adequate ventilation system within your computer, and leave sufficient free space between your frame grabber and other cards. Boards with active cooling should have at least one free slot between cards.</p>"},{"location":"connecting-frame-grabbers.html#connecting-coaxpress-frame-grabbers-to-a-host-computer","title":"Connecting CoaXPress Frame Grabbers to a Host Computer","text":"<p>These instructions apply to all CoaXPress frame grabbers: imaWorx CXP-12 Quad, marathon ACX-SP, marathon ACX-DP, marathon ACX-QP, and marathon VCX-QP.</p> <p>To install the frame grabber:</p> <ol> <li>Turn off the Fast Start-Up Feature under Windows, see www.windowscentral.com.</li> <li>Shut down your computer.</li> <li>Disconnect your computer from power.</li> <li> <p>Plug your frame grabber into a free PCIe slot of your computer.To find out which PCIe interface is required on your computer for your frame grabber, see Hardware Requirements.</p> <p>Info</p> <p>To operate the frame grabber, you can either power it via the CoaxPress cable using the power over CoaXPress functionality (PoCXO), or you must connect the frame grabber to the computer power supply with an additional cable.</p> <p>If you want to power the camera via the frame grabber, the frame grabber needs an extra connection to the computer power supply.</p> </li> <li> <p>Plug the female computer power supply connector into the frame grabber. If your computer doesn't provide a matching power supply, use an according adapter.</p> <p></p> <p></p> </li> <li> <p>Re-connect your computer to the power outlet.</p> </li> <li>Boot your computer.</li> </ol> <p>Info</p> <p>If you are using Linux, proceed with Installing the Framegrabber SDK Software under Linux, and after installing the Framegrabber SDK, continue with section Board Test.</p>"},{"location":"connecting-frame-grabbers.html#connecting-camera-link-frame-grabbers-to-a-host-computer","title":"Connecting Camera Link Frame Grabbers to a Host computer","text":"<p>Connecting an externally powered Camera Link camera while it is powered on may damage electric components.</p> <p>Before connecting an externally powered Camera Link camera to the frame grabber, make sure it is powered off. This does not apply to cameras powered via Power over Camera Link (PoCL).</p> <p>These instructions apply to all Camera Link frame grabbers: marathon ACL, marathon VCL, and marathon VCLx.</p> <p>To install the frame grabber:</p> <ol> <li>Turn off the Fast Start-Up Feature under Windows.</li> <li>Shut down your computer.</li> <li>Disconnect your computer from power.</li> <li> <p>Plug your frame grabber into a free PCIe (Gen. 2) x4 slot of your computer.</p> <p></p> </li> <li> <p>Re-connect your computer to the power outlet.</p> </li> <li>Boot your computer.</li> </ol> <p>Info</p> <p>If you are using Linux, proceed with Installing the Framegrabber SDK Software under Linux, and after installing the Framegrabber SDK, continue with section Enabling PoCL Support.</p>"},{"location":"connecting-frame-grabbers.html#checking-whether-your-frame-grabber-is-recognized-in-the-windows-device-manager","title":"Checking Whether Your Frame Grabber is Recognized in the Windows Device Manager","text":"<p>After booting, your frame grabber is recognized in the Windows Device Manager under Multifunction adapters.</p> <p></p> <p>Info</p> <p>If your frame grabber isn't displayed under Multifunction adapters, or if even Multifunction adapters isn't displayed in the Windows Device Manager, the Framegrabber SDK software has not been installed yet on your computer.For installation instructions, see section Installing the Framegrabber SDK Software. The relevant driver will be installed together with the Framegrabber SDK.</p>"},{"location":"connecting-frame-grabbers.html#installing-the-framegrabber-sdk-software","title":"Installing the Framegrabber SDK Software","text":"<p>For instructions on how to install the Framegrabber SDK software, refer to section Installing the Framegrabber SDK Software.</p>"},{"location":"connecting-frame-grabbers.html#frame-grabber-licenses-for-programmable-frame-grabbers","title":"Frame Grabber Licenses for Programmable Frame Grabbers","text":"<p>This information applies to programmable frame grabbers, i.e., marathon VCX-QP, marathon VCL, and marathon VCLx.</p> <p>You must license your programmable frame grabber in the following cases:</p> <ul> <li>You are using a specific VisualApplets application, for instance 3D-StereoVision, which requires a separate frame grabber license.</li> <li>You are using user code related applets.</li> </ul> <p>Before running applets that require a frame grabber license, the system checks whether the according frame grabber license is stored in memory. If no license is found, the applet won't run.</p> <p>For more information, see Licensing a Programmable Frame Grabber.</p>"},{"location":"copy-deployment-guide.html","title":"Installing the Framegrabber SDK via Copy Deployment","text":"<p>With copy deployment, you copy single components from the Framegrabber SDK installation into a directory of your choice. Like this, you can control or reduce the package you deliver with your user application.</p> <p>Note that if you deploy the Framegrabber SDK via copying, you can't use all functionalities and tools of the Framegrabber SDK.</p>"},{"location":"copy-deployment-guide.html#prerequisites","title":"Prerequisites","text":"<ol> <li>You need a PC for which you have administrator rights so that you can install the Framegrabber SDK. This PC is called source PC in the following instructions.</li> <li>Download the Basler Framegrabber SDK from the Basler website and install it on the source PC.</li> <li>If you don't want to run Framegrabber SDK-based applications on the source PC, you can deselect all options during installation. This avoids that drivers are installed, and the environment variables or the registry are modified.</li> <li>Since you're only preparing files for copy deployment, you can ignore the request to reboot the source PC after installing the Framegrabber SDK.</li> <li>The installation folder into which you have installed the Framegrabber SDK, is called &lt;SDKRoot&gt; in the following instructions.</li> <li>Download the MSVC Redistributable Package for Visual Studio 2015, 2017, 2019, or 2022 from Microsoft and install it on the source PC.</li> <li>Since you're only preparing files for copy deployment, you can ignore the request to reboot the source PC after installing Visual Code.</li> <li> <p>Create the following folder hierarchy for copy deployment on the source PC:</p> <pre><code>FramegrabberSDK\n\u251c\u2500\u2500\u2500bin\n\u251c\u2500\u2500\u2500dll\n\u251c\u2500\u2500\u2500drivers\n\u2514\u2500\u2500\u2500lib\n</code></pre> </li> </ol> <p>This folder structure is called SDK package in the following instructions. Its root folder FramegrabberSDK is called  &lt;packageRoot&gt;.</p>"},{"location":"copy-deployment-guide.html#creating-the-package","title":"Creating the Package","text":""},{"location":"copy-deployment-guide.html#creating-essential-parts-of-the-package","title":"Creating Essential Parts of the Package","text":"<p>This section provides instructions for copying the essential parts of the Framegrabber SDK, i.e. the parts that are always needed regardless which frame grabber you use.</p> <ol> <li> <p>Copy the following files  from &lt;SDKRoot&gt; into the corresponding folder inside &lt;packageRoot&gt;:</p> <pre><code>&lt;SDKRoot&gt;\n\u2514\u2500\u2500\u2500bin\n    \u251c\u2500\u2500\u2500fglib5.dll\n    \u251c\u2500\u2500\u2500siso_hal.dll\n    \u251c\u2500\u2500\u2500siso_hw.dll\n    \u251c\u2500\u2500\u2500haprt.dll\n    \u251c\u2500\u2500\u2500iolibrt.dll\n    \u2514\u2500\u2500\u2500logging-context.dll\n</code></pre> </li> <li> <p>Copy the following files from C:\\Windows\\system32 to \\bin: <pre><code>Windows\n\u2514\u2500\u2500\u2500system32\n    \u251c\u2500\u2500\u2500vcruntime140.dll\n    \u251c\u2500\u2500\u2500vcruntime140_1.dll\n    \u2514\u2500\u2500\u2500msvcp140.dll\n</code></pre>"},{"location":"copy-deployment-guide.html#adding-support-for-frame-grabbers","title":"Adding Support for Frame Grabbers","text":""},{"location":"copy-deployment-guide.html#me5-marathon","title":"mE5 Marathon","text":"<ol> <li> <p>Copy the following folders and files from &lt;SDKRoot&gt; to the corresponding folders in &lt;packageRoot&gt;:</p> <pre><code>&lt;SDKRoot&gt;\n\u251c\u2500\u2500\u2500bin\n|   \u2514\u2500\u2500\u2500GrabberFirmwareFlasher.exe\n\u251c\u2500\u2500\u2500drivers\n|   \u2514\u2500\u2500\u2500me5\n\u2502       \u251c\u2500\u2500\u2500me5.cat\n\u2502       \u251c\u2500\u2500\u2500me5.inf\n\u2502       \u251c\u2500\u2500\u2500me5.sys\n\u2502       \u2514\u2500\u2500\u2500WdfCoInstaller01009.dll\n\u2514\u2500\u2500\u2500lib\n    \u2514\u2500\u2500\u2500siso_hw_me5.dll\n</code></pre> </li> <li> <p>Copy the applet folders and files for your application from &lt;SDKRoot&gt;\\dll\\&lt;board-type&gt; to the corresponding folders in &lt;packageRoot&gt;:</p> <pre><code>&lt;SDKRoot&gt;\n\u2514\u2500\u2500\u2500dll\n    \u251c\u2500\u2500\u2500mE5-MA-ACL\n    \u251c\u2500\u2500\u2500mE5-MA-ACX-DP\n    \u251c\u2500\u2500\u2500mE5-MA-ACX-QP\n    \u251c\u2500\u2500\u2500mE5-MA-ACX-SP\n    \u251c\u2500\u2500\u2500mE5-MA-VCL\n    \u251c\u2500\u2500\u2500mE5-MA-VCLx\n    \u2514\u2500\u2500\u2500mE5-MA-VCX-QP\n</code></pre> </li> <li> <p>Optionally: Copy your applets designed with VisualApplets to &lt;packageRoot&gt;\\Hardware Applets&lt;board-type&gt;.</p> </li> </ol>"},{"location":"copy-deployment-guide.html#imaflex-imaworx-interface-cards","title":"imaFlex / imaWorx / Interface Cards","text":"<ol> <li> <p>Copy the following folders and files from &lt;SDKRoot&gt; to the corresponding folders in &lt;packageRoot&gt;:</p> <pre><code>&lt;SDKRoot&gt;\n\u251c\u2500\u2500\u2500bin\n|   \u2514\u2500\u2500\u2500GrabberFirmwareUpdater.exe\n\u251c\u2500\u2500\u2500drivers\n|   \u2514\u2500\u2500\u2500me6\n\u2502       \u251c\u2500\u2500\u2500basler_ic.cat\n\u2502       \u251c\u2500\u2500\u2500basler_ic.inf\n\u2502       \u251c\u2500\u2500\u2500basler_ic.sys\n\u2502       \u2514\u2500\u2500\u2500WdfCoInstaller01009.dll\n\u2514\u2500\u2500\u2500lib\n    \u2514\u2500\u2500\u2500siso_hw_me6.dll\n</code></pre> </li> <li> <p>Copy the applet folders and files for your application from \\dll&lt;board-type&gt; to the corresponding folders in &lt;packageRoot&gt;: <pre><code>&lt;SDKRoot&gt;\n\u2514\u2500\u2500\u2500dll\n    \u251c\u2500\u2500\u2500CXP12-IC-1C\n    \u2502   \u251c\u2500\u2500\u2500S1.1\n    \u2502   \u2514\u2500\u2500\u2500S1.2\n    \u251c\u2500\u2500\u2500CXP12-IC-2C\n    \u2502   \u2514\u2500\u2500\u2500S1.0\n    \u251c\u2500\u2500\u2500CXP12-IC-4C\n    \u2502   \u2514\u2500\u2500\u2500S1.0\n    \u251c\u2500\u2500\u2500iF-CXP12-P\n    \u2502   \u2514\u2500\u2500\u2500S1.1\n    \u251c\u2500\u2500\u2500iF-CXP12-Q\n    \u2502   \u2514\u2500\u2500\u2500S2.0\n    \u2514\u2500\u2500\u2500iW-CXP12-Q\n        \u2514\u2500\u2500\u2500S1.0\n</code></pre> <li> <p>Optionally: Copy your applets designed with VisualApplets to &lt;packageRoot&gt;\\Hardware Applets&lt;board-type&gt;</p> </li>"},{"location":"copy-deployment-guide.html#adding-support-for-camera-protocols","title":"Adding Support for Camera Protocols","text":""},{"location":"copy-deployment-guide.html#coaxpress","title":"CoaXPress","text":"<p>If you use a CoaXPress frame grabber in your project, copy the following files from &lt;SDKRoot&gt; to the corresponding folders in &lt;packageRoot&gt;:</p> <pre><code>    &lt;SDKRoot&gt;\n    \u2514\u2500\u2500\u2500bin\n        \u251c\u2500\u2500\u2500GCBase_MD_VC141_v3_1_Basler_pylon_v3.dll\n        \u251c\u2500\u2500\u2500GenApi_MD_VC141_v3_1_Basler_pylon_v3.dll\n        \u251c\u2500\u2500\u2500Log_MD_VC141_v3_1_Basler_pylon_v3.dll\n        \u251c\u2500\u2500\u2500MathParser_MD_VC141_v3_1_Basler_pylon_v3.dll\n        \u251c\u2500\u2500\u2500NodeMapData_MD_VC141_v3_1_Basler_pylon_v3.dll\n        \u251c\u2500\u2500\u2500siso_genicam.dll\n        \u2514\u2500\u2500\u2500XmlParser_MD_VC141_v3_1_Basler_pylon_v3.dll\n</code></pre>"},{"location":"copy-deployment-guide.html#camera-link","title":"Camera Link","text":"<p>If you use a Camera Link frame grabber in your project, copy the following files from &lt;SDKRoot&gt; to the corresponding folders in &lt;packageRoot&gt;:</p> <pre><code>    &lt;SDKRoot&gt;\n    \u2514\u2500\u2500\u2500bin\n        \u251c\u2500\u2500\u2500clsersis.dll\n        \u2514\u2500\u2500\u2500clshell.exe\n</code></pre>"},{"location":"copy-deployment-guide.html#gentl","title":"GenTL","text":"<ol> <li> <p>To use the GenTL producer, copy the following files from &lt;SDKRoot&gt; to the corresponding folders in &lt;packageRoot&gt;:</p> <pre><code>&lt;SDKRoot&gt;\n\u2514\u2500\u2500\u2500bin\n    \u251c\u2500\u2500\u2500GCBase_MD_VC141_v3_1_Basler_pylon_v3.dll\n    \u251c\u2500\u2500\u2500GenApi_MD_VC141_v3_1_Basler_pylon_v3.dll\n    \u251c\u2500\u2500\u2500Log_MD_VC141_v3_1_Basler_pylon_v3.dll\n    \u251c\u2500\u2500\u2500MathParser_MD_VC141_v3_1_Basler_pylon_v3.dll\n    \u251c\u2500\u2500\u2500NodeMapData_MD_VC141_v3_1_Basler_pylon_v3.dll\n    \u2514\u2500\u2500\u2500XmlParser_MD_VC141_v3_1_Basler_pylon_v3.dll\n</code></pre> </li> <li> <p>To use the CXP GenTL producer, copy the following files from &lt;SDKRoot&gt; to the corresponding folders in &lt;packageRoot&gt;:</p> <pre><code>&lt;SDKRoot&gt;\n\u2514\u2500\u2500\u2500bin\n    \u251c\u2500\u2500\u2500ProducerCXP.cti\n    \u2514\u2500\u2500\u2500siso_genicam.dll\n</code></pre> </li> <li> <p>To use the Camera Link GenTL producer, copy the following files from &lt;SDKRoot&gt; to the corresponding folders in &lt;packageRoot&gt;:</p> <pre><code>&lt;SDKRoot&gt;\n\u2514\u2500\u2500\u2500bin\n    \u251c\u2500\u2500\u2500BaslerCLProtocol.dll\n    \u251c\u2500\u2500\u2500CLAllSerial_MD_VC141_v3_1_Basler_pylon_v3.dll\n    \u251c\u2500\u2500\u2500CLProtocol_MD_VC141_v3_1_Basler_pylon_v3.dll\n    \u251c\u2500\u2500\u2500clsercom.dll\n    \u251c\u2500\u2500\u2500clsersis.dll\n    \u251c\u2500\u2500\u2500GenCP_MD_VC141_v3_1_Basler_pylon_v3.dll\n    \u2514\u2500\u2500\u2500ProducerCL.cti\n</code></pre> </li> </ol>"},{"location":"copy-deployment-guide.html#adding-tools","title":"Adding Tools","text":""},{"location":"copy-deployment-guide.html#gpio-tool","title":"GPIO Tool","text":"<p>If you want to use the GPIO Tool in your project, copy the following files from &lt;SDKRoot&gt; to the corresponding folders in &lt;packageRoot&gt;:</p> <pre><code>    &lt;SDKRoot&gt;\n    \u2514\u2500\u2500\u2500bin\n        \u251c\u2500\u2500\u2500siso_auxport.dll\n        \u2514\u2500\u2500\u2500gpioTool.exe\n</code></pre>"},{"location":"copy-deployment-guide.html#logging","title":"Logging","text":"<p>To get logging output from a running Framegrabber SDK application, e.g. in log files or by attaching the pylon Event Logger, copy the following files from &lt;SDKRoot&gt; to the corresponding folders in &lt;packageRoot&gt;:</p> <pre><code>&lt;SDKRoot&gt;\n\u2514\u2500\u2500\u2500bin\n    \u251c\u2500\u2500\u2500common-logging-dispatcher.dll\n    \u251c\u2500\u2500\u2500common-logging-log4cpp.dll\n    \u251c\u2500\u2500\u2500BaslerFgSdkLogging.properties\n    \u251c\u2500\u2500\u2500GCBase_MD_VC141_v3_1_Basler_pylon_v3.dll\n    \u251c\u2500\u2500\u2500Log_MD_VC141_v3_1_Basler_pylon_v3.dll\n    \u2514\u2500\u2500\u2500log4cpp_MD_VC141_v3_1_Basler_pylon_v3.dll\n</code></pre> <p>Note that for the last two libraries, the version suffix (here: _v3) may vary or be missing, depending on the version of the Framegrabber SDK to be deployed.</p> <p>See Log Message System for details on how to configure logging.</p>"},{"location":"copy-deployment-guide.html#cognex-visionpro","title":"Cognex VisionPro","text":"<p>To use Basler frame grabbers with Cognex VisionPro, follow these instructions:</p> <ol> <li>Download the Framegrabber Runtime 5.7 and install it on the source PC.</li> <li>When you run the installer, make sure to select / clear the following options:<ul> <li>In the Select Components dialog, select Cognex Adapter.</li> <li>In the Select Additional Tasks dialog:<ul> <li>Clear Update Device Drivers and Update Environment Variables.</li> </ul> </li> <li>Ensure the registry isn't modified:<ul> <li>In the Select Start Menu Folder dialog, select Don't create a start menu folder.</li> <li>In the Select Addtitional Tasks dialog, clear Desktop icon, Activate Virtual COM Port, and Always Run COMWrapper Autorun at System Start.</li> </ul> </li> </ul> </li> <li>Copy the file SisoCognexAdapter.dll from the bin folder of the Runtime 5.7 installation to &lt;packageRoot&gt;\\bin.</li> </ol>"},{"location":"copy-deployment-guide.html#deploying-the-package","title":"Deploying the Package","text":""},{"location":"copy-deployment-guide.html#deploying-the-essentials","title":"Deploying the Essentials","text":"<p>To deploy the copied version of the Framegrabber SDK to your target PC:</p> <ol> <li>Copy the SDK package to the target PC.</li> <li>Install the driver(s) of the Framegrabber SDK.</li> <li>Set the environment variable <code>BASLER_FG_SDK_DIR</code> to the full path of the &lt;packageRoot&gt; folder.</li> <li>Add the bin folder of the SDK package to the <code>PATH</code> environment variable.</li> </ol>"},{"location":"copy-deployment-guide.html#deploying-the-cognex-visionpro-adapter","title":"Deploying the Cognex VisionPro Adapter","text":"<p>To use the Cognex VisionPro Adapter on the target PC, follow the chapter Installing the Adapter Manually of the Cognex VisionPro Adapter documentation.</p>"},{"location":"crash-protection-micro-diagnostics.html","title":"Crash Protection (microDiagnostics)","text":"<p>The Framegrabber SDK provides a crash protection which is enabled when the user application crashes during reconfiguration.</p>"},{"location":"crash-protection-micro-diagnostics.html#pci-bus-connection","title":"PCI Bus Connection","text":"<p>During FPGA live reconfiguration (which starts when you activate an applet), the frame grabber disappears from the PCI bus for a short time. However, the disappearance of a device from the PCI bus isn't supported by all motherboards.</p> <p>If the motherboard doesn't support disappearing of a device from the PCI bus: The FPGA reconfiguration fails, and a Windows blue screen may appear. In this case, the crash protection is enabled. To avoid a further blue screens, FPGA live reconfiguration (i.e., activating an applet) is disabled. This is effective in the tools microDiagnostics, microDisplay X, and in the Framegrabber API using the function call <code>Fg_Init</code>.</p> <p>You will only be able to load the already active applet. To activate another applet (that is, to configure the FPGA with another applet):</p> <ol> <li>In microDiagnostics, define the partition the other applet has been flashed to as boot partition.</li> <li>Power-cycle the computer.</li> </ol> <p>Since the partition the intended applet is stored on is the boot partition now, during booting, the FPGA is flashed with the applet stored in this partition.</p>"},{"location":"crash-protection-micro-diagnostics.html#user-application-crash","title":"User Application Crash","text":"<p>The crash protection is also activated when the user application crashes during reconfiguration. In this case, you can re-enable FPGA live reconfiguration in microDiagnostics (so that you can activate any of the flashed applets on the frame grabber). To do that:</p> <ol> <li>In microDiagnostics, select the the frame grabber device board you want to reconfigure.</li> <li>Activate the partition that contains applet you want to use.</li> <li> <p>In the dialog that appears (see below), click Activate Anyway. Now, the live configuration is enabled again.</p> <p></p> </li> </ol> <p>Info</p> <p>If you re-enable live configuration (by clicking Activate Anyway) although the crash protection was enabled due to a blue screen, this will result in a blue screen again.</p>"},{"location":"delivered-components-framegrabber-sdk-5-10-0.html","title":"Delivered Components","text":"<p>The following list contains all components and their versions delivered with Framegrabber SDK 5.10.0:</p> <ul> <li>Framegrabber SDK and GenTL Producer: 5.10.0</li> </ul>"},{"location":"delivered-components-framegrabber-sdk-5-10-0.html#drivers","title":"Drivers","text":"Operating System Driver Version Windows 2.0.0.0 Linux 5.1.0"},{"location":"delivered-components-framegrabber-sdk-5-10-0.html#applets","title":"Applets","text":""},{"location":"delivered-components-framegrabber-sdk-5-10-0.html#imaworx-cxp-12-quad","title":"imaWorx CXP-12 Quad","text":"Applet Name Version Acq_DualCXP12Area 2.0.5.0 Acq_DualCXP12Line 1.0.3.0 Acq_QuadCXP12Area 2.0.5.0 Acq_QuadCXP12Line 1.0.3.0 Acq_SingleCXP12Area 2.0.5.0 Acq_SingleCXP12Line 1.0.3.0 Acq_TripleCXP12Area 2.0.5.0 Acq_TripleCXP12Line 1.0.3.0 FrameGrabberTest 3.3.2.0"},{"location":"delivered-components-framegrabber-sdk-5-10-0.html#cxp-12-interface-card-1c","title":"CXP-12 Interface Card 1C","text":"Applet Name Version Acq_SingleCXP12x1Area 5.0.5.0 FrameGrabberTest 3.3.2.0"},{"location":"delivered-components-framegrabber-sdk-5-10-0.html#cxp-12-interface-card-2c","title":"CXP-12 Interface Card 2C","text":"Applet Name Version Acq_DualCXP12Area 2.0.5.0 Acq_SingleCXP12Area 2.0.5.0 FrameGrabberTest 3.3.2.0"},{"location":"delivered-components-framegrabber-sdk-5-10-0.html#cxp-12-interface-card-4c","title":"CXP-12 Interface Card 4C","text":"Applet Name Version Acq_DualCXP12Area 2.0.5.0 Acq_QuadCXP12Area 2.0.5.0 Acq_SingleCXP12Area 2.0.5.0 Acq_TripleCXP12Area 2.0.5.0 FrameGrabberTest 3.3.2.0"},{"location":"delivered-components-framegrabber-sdk-5-10-0.html#marathon-acx-sp","title":"marathon ACX-SP","text":"Applet Name Version Acq_SingleCXP6x1AreaBayer 2.2.4.0 Acq_SingleCXP6x1AreaGray 2.2.4.0 Acq_SingleCXP6x1AreaRGB 2.2.4.0 Acq_SingleCXP6x1LineGray 2.2.4.0 Acq_SingleCXP6x1LineRGB 2.2.4.0 FrameGrabberTest 2.2.4.0"},{"location":"delivered-components-framegrabber-sdk-5-10-0.html#marathon-acx-dp","title":"marathon ACX-DP","text":"Applet Name Version Acq_DualCXP6x1AreaBayer 2.2.4.0 Acq_DualCXP6x1AreaGray 2.2.4.0 Acq_DualCXP6x1AreaRGB 2.2.4.0 Acq_DualCXP6x1LineGray 2.2.4.0 Acq_DualCXP6x1LineRGB 2.2.4.0 Acq_SingleCXP6x2AreaBayer 2.2.4.0 Acq_SingleCXP6x2AreaGray 2.2.4.0 Acq_SingleCXP6x2AreaRGB 2.2.4.0 Acq_SingleCXP6x2LineGray 2.2.4.0 Acq_SingleCXP6x2LineRGB 2.2.4.0 FrameGrabberTest 2.2.4.0"},{"location":"delivered-components-framegrabber-sdk-5-10-0.html#marathon-acx-qp","title":"marathon ACX-QP","text":"Applet Name Version Acq_DualCXP6x2AreaBayer 2.2.4.0 Acq_DualCXP6x2AreaGray 2.2.4.0 Acq_DualCXP6x2AreaRGB 2.2.4.0 Acq_DualCXP6x2LineGray 2.2.4.0 Acq_DualCXP6x2LineRGB 2.2.4.0 Acq_QuadCXP6x1AreaBayer 2.2.4.0 Acq_QuadCXP6x1AreaGray 2.2.4.0 Acq_QuadCXP6x1AreaRGB 2.2.4.0 Acq_QuadCXP6x1LineGray 2.2.4.0 Acq_QuadCXP6x1LineRGB 2.2.4.0 Acq_SingleCXP6x4AreaBayer 2.2.4.0 Acq_SingleCXP6x4AreaGray 2.2.4.0 Acq_SingleCXP6x4AreaRGB 2.2.4.0 Acq_SingleCXP6x4LineGray 2.2.4.0 Acq_SingleCXP6x4LineRGB 2.2.4.0 FrameGrabberTest 2.2.4.0"},{"location":"delivered-components-framegrabber-sdk-5-10-0.html#marathon-vcx-qp","title":"marathon VCX-QP","text":"Applet Name Version Acq_DualCXP6x2AreaBayer 2.2.4.0 Acq_DualCXP6x2AreaGray 2.2.4.0 Acq_DualCXP6x2AreaRGB 2.2.4.0 Acq_DualCXP6x2LineGray 2.2.4.0 Acq_DualCXP6x2LineRGB 2.2.4.0 Acq_QuadCXP6x1AreaBayer 2.2.4.0 Acq_QuadCXP6x1AreaGray 2.2.4.0 Acq_QuadCXP6x1AreaRGB 2.2.4.0 Acq_QuadCXP6x1LineGray 2.2.4.0 Acq_QuadCXP6x1LineRGB 2.2.4.0 Acq_SingleCXP6x4AreaBayer 2.2.4.0 Acq_SingleCXP6x4AreaGray 2.2.4.0 Acq_SingleCXP6x4AreaRGB 2.2.4.0 Acq_SingleCXP6x4LineGray 2.2.4.0 Acq_SingleCXP6x4LineRGB 2.2.4.0 FrameGrabberTest 2.2.4.0"},{"location":"delivered-components-framegrabber-sdk-5-10-0.html#marathon-acl","title":"marathon ACL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.2.4.0 Acq_DualBaseAreaGray 2.2.4.0 Acq_DualBaseAreaRGB 2.2.4.0 Acq_DualBaseLineBayer_RG_GB 2.2.4.0 Acq_DualBaseLineGray 2.2.4.0 Acq_DualBaseLineRGB 2.2.4.0 Acq_SingleBaseAreaBayer 2.2.4.0 Acq_SingleBaseAreaGray 2.2.4.0 Acq_SingleBaseAreaRGB 2.2.4.0 Acq_SingleBaseLineGray 2.2.4.0 Acq_SingleBaseLineRGB 2.2.4.0 Acq_SingleFullAreaBayer 2.2.4.0 Acq_SingleFullAreaGray 2.2.4.0 Acq_SingleFullAreaRGB 2.2.4.0 Acq_SingleFullLineBayer_RB_GG 2.2.4.0 Acq_SingleFullLineBayer_RG_GB 2.2.4.0 Acq_SingleFullLineGray 2.2.4.0 Acq_SingleFullLineRGB 2.2.4.0 Acq_SingleMediumAreaBayer 2.2.4.0 Acq_SingleMediumAreaGray 2.2.4.0 Acq_SingleMediumAreaRGB 2.2.4.0 Acq_SingleMediumLineGray 2.2.4.0 Acq_SingleMediumLineRGB 2.2.4.0 FrameGrabberTest 2.2.4.0"},{"location":"delivered-components-framegrabber-sdk-5-10-0.html#marathon-vcl","title":"marathon VCL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.2.4.0 Acq_DualBaseAreaGray 2.2.4.0 Acq_DualBaseAreaRGB 2.2.4.0 Acq_DualBaseLineBayer_RG_GB 2.2.4.0 Acq_DualBaseLineGray 2.2.4.0 Acq_DualBaseLineRGB 2.2.4.0 Acq_SingleFullAreaBayer 2.2.4.0 Acq_SingleFullAreaGray 2.2.4.0 Acq_SingleFullAreaRGB 2.2.4.0 Acq_SingleFullLineBayer_RB_GG 2.2.4.0 Acq_SingleFullLineBayer_RG_GB 2.2.4.0 Acq_SingleFullLineGray 2.2.4.0 Acq_SingleFullLineRGB 2.2.4.0 Acq_SingleMediumAreaBayer 2.2.4.0 Acq_SingleMediumAreaGray 2.2.4.0 Acq_SingleMediumAreaRGB 2.2.4.0 Acq_SingleMediumLineGray 2.2.4.0 Acq_SingleMediumLineRGB 2.2.4.0 FrameGrabberTest 2.2.4.0"},{"location":"delivered-components-framegrabber-sdk-5-10-0.html#marathon-vclxdeepvcl","title":"marathon VCLx/deepVCL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.2.4.0 Acq_DualBaseAreaGray 2.2.4.0 Acq_DualBaseAreaRGB 2.2.4.0 Acq_DualBaseLineGray 2.2.4.0 Acq_DualBaseLineRGB 2.2.4.0 Acq_SingleFullAreaBayer 2.2.4.0 Acq_SingleFullAreaGray 2.2.4.0 Acq_SingleFullAreaRGB 2.2.4.0 Acq_SingleFullLineGray 2.2.4.0 Acq_SingleFullLineRGB 2.2.4.0 Acq_SingleMediumAreaBayer 2.2.4.0 Acq_SingleMediumAreaGray 2.2.4.0 Acq_SingleMediumAreaRGB 2.2.4.0 Acq_SingleMediumLineGray 2.2.4.0 Acq_SingleMediumLineRGB 2.2.4.0 FrameGrabberTest 2.2.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-0.html","title":"Delivered Components","text":"<p>The following list contains all components and their versions delivered with the Framegrabber SDK and GenTL Producer 5.11.0.</p>"},{"location":"delivered-components-framegrabber-sdk-5-11-0.html#drivers","title":"Drivers","text":"Operating System Driver Version Windows mE5 2.2.0.0 Windows mE6 2.2.0.0 Linux 5.3.0"},{"location":"delivered-components-framegrabber-sdk-5-11-0.html#applets","title":"Applets","text":""},{"location":"delivered-components-framegrabber-sdk-5-11-0.html#imaworx-cxp-12-quad","title":"imaWorx CXP-12 Quad","text":"Applet Name Version Acq_SingleCXP12Area 2.2.7.0 Acq_DualCXP12Area 2.2.7.0 Acq_TripleCXP12Area 2.2.7.0 Acq_QuadCXP12Area 2.2.7.0 Acq_SingleCXP12Line 2.3.8.0 Acq_DualCXP12Line 2.3.8.0 Acq_TripleCXP12Line 2.3.8.0 Acq_QuadCXP12Line 2.3.8.0 FrameGrabberTest 3.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-0.html#cxp-12-interface-card-1c","title":"CXP-12 Interface Card 1C","text":"Applet Name Version Acq_SingleCXP12x1Area 5.2.7.0 Acq_SingleCXP12Line 1.0.1.0 FrameGrabberTest 3.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-0.html#cxp-12-interface-card-2c","title":"CXP-12 Interface Card 2C","text":"Applet Name Version Acq_SingleCXP12Area 2.2.7.0 Acq_DualCXP12Area 2.2.7.0 Acq_SingleCXP12Line 1.0.1.0 Acq_DualCXP12Line 1.0.1.0 FrameGrabberTest 3.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-0.html#cxp-12-interface-card-4c","title":"CXP-12 Interface Card 4C","text":"Applet Name Version Acq_SingleCXP12Area 2.2.7.0 Acq_DualCXP12Area 2.2.7.0 Acq_TripleCXP12Area 2.2.7.0 Acq_QuadCXP12Area 2.2.7.0 Acq_SingleCXP12Line 1.0.1.0 Acq_DualCXP12Line 1.0.1.0 Acq_TripleCXP12Line 1.0.1.0 Acq_QuadCXP12Line 1.0.1.0 FrameGrabberTest 3.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-0.html#marathon-acx-sp","title":"marathon ACX-SP","text":"Applet Name Version Acq_SingleCXP6x1AreaBayer 2.3.5.0 Acq_SingleCXP6x1AreaGray 2.3.5.0 Acq_SingleCXP6x1AreaRGB 2.3.5.0 Acq_SingleCXP6x1LineGray 2.3.5.0 Acq_SingleCXP6x1LineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-0.html#marathon-acx-dp","title":"marathon ACX-DP","text":"Applet Name Version Acq_DualCXP6x1AreaBayer 2.3.5.0 Acq_DualCXP6x1AreaGray 2.3.5.0 Acq_DualCXP6x1AreaRGB 2.3.5.0 Acq_DualCXP6x1LineGray 2.3.5.0 Acq_DualCXP6x1LineRGB 2.3.5.0 Acq_SingleCXP6x2AreaBayer 2.3.5.0 Acq_SingleCXP6x2AreaGray 2.3.5.0 Acq_SingleCXP6x2AreaRGB 2.3.5.0 Acq_SingleCXP6x2LineGray 2.3.5.0 Acq_SingleCXP6x2LineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-0.html#marathon-acx-qp","title":"marathon ACX-QP","text":"Applet Name Version Acq_DualCXP6x2AreaBayer 2.3.5.0 Acq_DualCXP6x2AreaGray 2.3.5.0 Acq_DualCXP6x2AreaRGB 2.3.5.0 Acq_DualCXP6x2LineGray 2.3.5.0 Acq_DualCXP6x2LineRGB 2.3.5.0 Acq_QuadCXP6x1AreaBayer 2.3.5.0 Acq_QuadCXP6x1AreaGray 2.3.5.0 Acq_QuadCXP6x1AreaRGB 2.3.5.0 Acq_QuadCXP6x1LineGray 2.3.5.0 Acq_QuadCXP6x1LineRGB 2.3.5.0 Acq_SingleCXP6x4AreaBayer 2.3.5.0 Acq_SingleCXP6x4AreaGray 2.3.5.0 Acq_SingleCXP6x4AreaRGB 2.3.5.0 Acq_SingleCXP6x4LineGray 2.3.5.0 Acq_SingleCXP6x4LineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-0.html#marathon-vcx-qp","title":"marathon VCX-QP","text":"Applet Name Version Acq_DualCXP6x2AreaBayer 2.3.5.0 Acq_DualCXP6x2AreaGray 2.3.5.0 Acq_DualCXP6x2AreaRGB 2.3.5.0 Acq_DualCXP6x2LineGray 2.3.5.0 Acq_DualCXP6x2LineRGB 2.3.5.0 Acq_QuadCXP6x1AreaBayer 2.3.5.0 Acq_QuadCXP6x1AreaGray 2.3.5.0 Acq_QuadCXP6x1AreaRGB 2.3.5.0 Acq_QuadCXP6x1LineGray 2.3.5.0 Acq_QuadCXP6x1LineRGB 2.3.5.0 Acq_SingleCXP6x4AreaBayer 2.3.5.0 Acq_SingleCXP6x4AreaGray 2.3.5.0 Acq_SingleCXP6x4AreaRGB 2.3.5.0 Acq_SingleCXP6x4LineGray 2.3.5.0 Acq_SingleCXP6x4LineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-0.html#marathon-acl","title":"marathon ACL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.3.5.0 Acq_DualBaseAreaGray 2.3.5.0 Acq_DualBaseAreaRGB 2.3.5.0 Acq_DualBaseLineBayer_RG_GB 2.3.5.0 Acq_DualBaseLineGray 2.3.5.0 Acq_DualBaseLineRGB 2.3.5.0 Acq_SingleBaseAreaBayer 2.3.5.0 Acq_SingleBaseAreaGray 2.3.5.0 Acq_SingleBaseAreaRGB 2.3.5.0 Acq_SingleBaseLineGray 2.3.5.0 Acq_SingleBaseLineRGB 2.3.5.0 Acq_SingleFullAreaBayer 2.3.5.0 Acq_SingleFullAreaGray 2.3.5.0 Acq_SingleFullAreaRGB 2.3.5.0 Acq_SingleFullLineBayer_RB_GG 2.3.5.0 Acq_SingleFullLineBayer_RG_GB 2.3.5.0 Acq_SingleFullLineGray 2.3.5.0 Acq_SingleFullLineRGB 2.3.5.0 Acq_SingleMediumAreaBayer 2.3.5.0 Acq_SingleMediumAreaGray 2.3.5.0 Acq_SingleMediumAreaRGB 2.3.5.0 Acq_SingleMediumLineGray 2.3.5.0 Acq_SingleMediumLineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-0.html#marathon-vcl","title":"marathon VCL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.3.5.0 Acq_DualBaseAreaGray 2.3.5.0 Acq_DualBaseAreaRGB 2.3.5.0 Acq_DualBaseLineBayer_RG_GB 2.3.5.0 Acq_DualBaseLineGray 2.3.5.0 Acq_DualBaseLineRGB 2.3.5.0 Acq_SingleFullAreaBayer 2.3.5.0 Acq_SingleFullAreaGray 2.3.5.0 Acq_SingleFullAreaRGB 2.3.5.0 Acq_SingleFullLineBayer_RB_GG 2.3.5.0 Acq_SingleFullLineBayer_RG_GB 2.3.5.0 Acq_SingleFullLineGray 2.3.5.0 Acq_SingleFullLineRGB 2.3.5.0 Acq_SingleMediumAreaBayer 2.3.5.0 Acq_SingleMediumAreaGray 2.3.5.0 Acq_SingleMediumAreaRGB 2.3.5.0 Acq_SingleMediumLineGray 2.3.5.0 Acq_SingleMediumLineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-0.html#marathon-vclxdeepvcl","title":"marathon VCLx/deepVCL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.3.5.0 Acq_DualBaseAreaGray 2.3.5.0 Acq_DualBaseAreaRGB 2.3.5.0 Acq_DualBaseLineGray 2.3.5.0 Acq_DualBaseLineRGB 2.3.5.0 Acq_SingleFullAreaBayer 2.3.5.0 Acq_SingleFullAreaGray 2.3.5.0 Acq_SingleFullAreaRGB 2.3.5.0 Acq_SingleFullLineGray 2.3.5.0 Acq_SingleFullLineRGB 2.3.5.0 Acq_SingleMediumAreaBayer 2.3.5.0 Acq_SingleMediumAreaGray 2.3.5.0 Acq_SingleMediumAreaRGB 2.3.5.0 Acq_SingleMediumLineGray 2.3.5.0 Acq_SingleMediumLineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html","title":"Delivered Components","text":"<p>The following list contains all components and their versions delivered with the Framegrabber SDK and GenTL Producer 5.11.2.</p>"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#drivers","title":"Drivers","text":"Operating System Driver Version Windows mE5 2.3.0.0 Windows mE6 2.3.0.0 Linux 5.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#applets","title":"Applets","text":""},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#imaflex-cxp-12-quad","title":"imaFlex CXP-12 Quad","text":"Applet Name Version Acq_SingleCXP12Area 1.0.1.0 Acq_DualCXP12Area 1.0.1.0 Acq_TripleCXP12Area 1.0.1.0 Acq_QuadCXP12Area 1.0.1.0 Acq_SingleCXP12Line 1.0.1.0 Acq_DualCXP12Line 1.0.1.0 Acq_TripleCXP12Line 1.0.1.0 Acq_QuadCXP12Line 1.0.1.0 FrameGrabberTest 1.0.1.0"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#imaworx-cxp-12-quad","title":"imaWorx CXP-12 Quad","text":"Applet Name Version Acq_SingleCXP12Area 2.3.7.0 Acq_DualCXP12Area 2.3.7.0 Acq_TripleCXP12Area 2.3.7.0 Acq_QuadCXP12Area 2.3.7.0 Acq_SingleCXP12Line 2.4.8.0 Acq_DualCXP12Line 2.4.8.0 Acq_TripleCXP12Line 2.4.8.0 Acq_QuadCXP12Line 2.4.8.0 FrameGrabberTest 3.4.5.0"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#cxp-12-interface-card-1c","title":"CXP-12 Interface Card 1C","text":"Applet Name Version Acq_SingleCXP12x1Area 5.3.7.0 Acq_SingleCXP12Line 1.1.1.0 FrameGrabberTest 3.4.5.0"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#cxp-12-interface-card-2c","title":"CXP-12 Interface Card 2C","text":"Applet Name Version Acq_SingleCXP12Area 2.3.7.0 Acq_DualCXP12Area 2.3.7.0 Acq_SingleCXP12Line 1.1.1.0 Acq_DualCXP12Line 1.1.1.0 FrameGrabberTest 3.4.5.0"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#cxp-12-interface-card-4c","title":"CXP-12 Interface Card 4C","text":"Applet Name Version Acq_SingleCXP12Area 2.3.7.0 Acq_DualCXP12Area 2.3.7.0 Acq_TripleCXP12Area 2.3.7.0 Acq_QuadCXP12Area 2.3.7.0 Acq_SingleCXP12Line 1.1.1.0 Acq_DualCXP12Line 1.1.1.0 Acq_TripleCXP12Line 1.1.1.0 Acq_QuadCXP12Line 1.1.1.0 FrameGrabberTest 3.4.5.0"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#marathon-acx-sp","title":"marathon ACX-SP","text":"Applet Name Version Acq_SingleCXP6x1AreaBayer 2.3.5.0 Acq_SingleCXP6x1AreaGray 2.3.5.0 Acq_SingleCXP6x1AreaRGB 2.3.5.0 Acq_SingleCXP6x1LineGray 2.3.5.0 Acq_SingleCXP6x1LineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#marathon-acx-dp","title":"marathon ACX-DP","text":"Applet Name Version Acq_DualCXP6x1AreaBayer 2.3.5.0 Acq_DualCXP6x1AreaGray 2.3.5.0 Acq_DualCXP6x1AreaRGB 2.3.5.0 Acq_DualCXP6x1LineGray 2.3.5.0 Acq_DualCXP6x1LineRGB 2.3.5.0 Acq_SingleCXP6x2AreaBayer 2.3.5.0 Acq_SingleCXP6x2AreaGray 2.3.5.0 Acq_SingleCXP6x2AreaRGB 2.3.5.0 Acq_SingleCXP6x2LineGray 2.3.5.0 Acq_SingleCXP6x2LineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#marathon-acx-qp","title":"marathon ACX-QP","text":"Applet Name Version Acq_DualCXP6x2AreaBayer 2.3.5.0 Acq_DualCXP6x2AreaGray 2.3.5.0 Acq_DualCXP6x2AreaRGB 2.3.5.0 Acq_DualCXP6x2LineGray 2.3.5.0 Acq_DualCXP6x2LineRGB 2.3.5.0 Acq_QuadCXP6x1AreaBayer 2.3.5.0 Acq_QuadCXP6x1AreaGray 2.3.5.0 Acq_QuadCXP6x1AreaRGB 2.3.5.0 Acq_QuadCXP6x1LineGray 2.3.5.0 Acq_QuadCXP6x1LineRGB 2.3.5.0 Acq_SingleCXP6x4AreaBayer 2.3.5.0 Acq_SingleCXP6x4AreaGray 2.3.5.0 Acq_SingleCXP6x4AreaRGB 2.3.5.0 Acq_SingleCXP6x4LineGray 2.3.5.0 Acq_SingleCXP6x4LineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#marathon-vcx-qp","title":"marathon VCX-QP","text":"Applet Name Version Acq_DualCXP6x2AreaBayer 2.3.5.0 Acq_DualCXP6x2AreaGray 2.3.5.0 Acq_DualCXP6x2AreaRGB 2.3.5.0 Acq_DualCXP6x2LineGray 2.3.5.0 Acq_DualCXP6x2LineRGB 2.3.5.0 Acq_QuadCXP6x1AreaBayer 2.3.5.0 Acq_QuadCXP6x1AreaGray 2.3.5.0 Acq_QuadCXP6x1AreaRGB 2.3.5.0 Acq_QuadCXP6x1LineGray 2.3.5.0 Acq_QuadCXP6x1LineRGB 2.3.5.0 Acq_SingleCXP6x4AreaBayer 2.3.5.0 Acq_SingleCXP6x4AreaGray 2.3.5.0 Acq_SingleCXP6x4AreaRGB 2.3.5.0 Acq_SingleCXP6x4LineGray 2.3.5.0 Acq_SingleCXP6x4LineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#marathon-acl","title":"marathon ACL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.3.5.0 Acq_DualBaseAreaGray 2.3.5.0 Acq_DualBaseAreaRGB 2.3.5.0 Acq_DualBaseLineBayer_RG_GB 2.3.5.0 Acq_DualBaseLineGray 2.3.5.0 Acq_DualBaseLineRGB 2.3.5.0 Acq_SingleBaseAreaBayer 2.3.5.0 Acq_SingleBaseAreaGray 2.3.5.0 Acq_SingleBaseAreaRGB 2.3.5.0 Acq_SingleBaseLineGray 2.3.5.0 Acq_SingleBaseLineRGB 2.3.5.0 Acq_SingleFullAreaBayer 2.3.5.0 Acq_SingleFullAreaGray 2.3.5.0 Acq_SingleFullAreaRGB 2.3.5.0 Acq_SingleFullLineBayer_RB_GG 2.3.5.0 Acq_SingleFullLineBayer_RG_GB 2.3.5.0 Acq_SingleFullLineGray 2.3.5.0 Acq_SingleFullLineRGB 2.3.5.0 Acq_SingleMediumAreaBayer 2.3.5.0 Acq_SingleMediumAreaGray 2.3.5.0 Acq_SingleMediumAreaRGB 2.3.5.0 Acq_SingleMediumLineGray 2.3.5.0 Acq_SingleMediumLineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#marathon-vcl","title":"marathon VCL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.3.5.0 Acq_DualBaseAreaGray 2.3.5.0 Acq_DualBaseAreaRGB 2.3.5.0 Acq_DualBaseLineBayer_RG_GB 2.3.5.0 Acq_DualBaseLineGray 2.3.5.0 Acq_DualBaseLineRGB 2.3.5.0 Acq_SingleFullAreaBayer 2.3.5.0 Acq_SingleFullAreaGray 2.3.5.0 Acq_SingleFullAreaRGB 2.3.5.0 Acq_SingleFullLineBayer_RB_GG 2.3.5.0 Acq_SingleFullLineBayer_RG_GB 2.3.5.0 Acq_SingleFullLineGray 2.3.5.0 Acq_SingleFullLineRGB 2.3.5.0 Acq_SingleMediumAreaBayer 2.3.5.0 Acq_SingleMediumAreaGray 2.3.5.0 Acq_SingleMediumAreaRGB 2.3.5.0 Acq_SingleMediumLineGray 2.3.5.0 Acq_SingleMediumLineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-2.html#marathon-vclxdeepvcl","title":"marathon VCLx/deepVCL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.3.5.0 Acq_DualBaseAreaGray 2.3.5.0 Acq_DualBaseAreaRGB 2.3.5.0 Acq_DualBaseLineGray 2.3.5.0 Acq_DualBaseLineRGB 2.3.5.0 Acq_SingleFullAreaBayer 2.3.5.0 Acq_SingleFullAreaGray 2.3.5.0 Acq_SingleFullAreaRGB 2.3.5.0 Acq_SingleFullLineGray 2.3.5.0 Acq_SingleFullLineRGB 2.3.5.0 Acq_SingleMediumAreaBayer 2.3.5.0 Acq_SingleMediumAreaGray 2.3.5.0 Acq_SingleMediumAreaRGB 2.3.5.0 Acq_SingleMediumLineGray 2.3.5.0 Acq_SingleMediumLineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html","title":"Delivered Components","text":"<p>The following list contains all components and their versions delivered with the Framegrabber SDK and GenTL Producer 5.11.3.</p>"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#drivers","title":"Drivers","text":"Operating System Driver Version Windows mE5 2.4.0.0 Windows mE6 2.4.0.0 Linux 5.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#applets","title":"Applets","text":""},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#imaflex-cxp-12-penta","title":"imaFlex CXP-12 Penta","text":"Applet Name Version Acq_SingleCXP12Area 1.0.1.0 Acq_PentaCXP12Area 1.0.1.0 Acq_SingleCXP12Line 1.0.1.0 Acq_PentaCXP12Line 1.0.1.0 FrameGrabberTest 1.0.1.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#imaflex-cxp-12-quad","title":"imaFlex CXP-12 Quad","text":"Applet Name Version Acq_SingleCXP12Area 1.1.1.0 Acq_DualCXP12Area 1.1.1.0 Acq_TripleCXP12Area 1.1.1.0 Acq_QuadCXP12Area 1.1.1.0 Acq_SingleCXP12Line 1.1.1.0 Acq_DualCXP12Line 1.1.1.0 Acq_TripleCXP12Line 1.1.1.0 Acq_QuadCXP12Line 1.1.1.0 FrameGrabberTest 1.0.2.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#imaworx-cxp-12-quad","title":"imaWorx CXP-12 Quad","text":"Applet Name Version Acq_SingleCXP12Area 2.4.7.0 Acq_DualCXP12Area 2.4.7.0 Acq_TripleCXP12Area 2.4.7.0 Acq_QuadCXP12Area 2.4.7.0 Acq_SingleCXP12Line 2.5.8.0 Acq_DualCXP12Line 2.5.8.0 Acq_TripleCXP12Line 2.5.8.0 Acq_QuadCXP12Line 2.5.8.0 FrameGrabberTest 3.4.6.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#cxp-12-interface-card-1c","title":"CXP-12 Interface Card 1C","text":"Applet Name Version Acq_SingleCXP12x1Area 5.4.7.0 Acq_SingleCXP12Line 1.2.1.0 FrameGrabberTest 3.4.6.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#cxp-12-interface-card-2c","title":"CXP-12 Interface Card 2C","text":"Applet Name Version Acq_SingleCXP12Area 2.4.7.0 Acq_DualCXP12Area 2.4.7.0 Acq_SingleCXP12Line 1.2.1.0 Acq_DualCXP12Line 1.2.1.0 FrameGrabberTest 3.4.6.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#cxp-12-interface-card-4c","title":"CXP-12 Interface Card 4C","text":"Applet Name Version Acq_SingleCXP12Area 2.4.7.0 Acq_DualCXP12Area 2.4.7.0 Acq_TripleCXP12Area 2.4.7.0 Acq_QuadCXP12Area 2.4.7.0 Acq_SingleCXP12Line 1.2.1.0 Acq_DualCXP12Line 1.2.1.0 Acq_TripleCXP12Line 1.2.1.0 Acq_QuadCXP12Line 1.2.1.0 FrameGrabberTest 3.4.6.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#marathon-acx-sp","title":"marathon ACX-SP","text":"Applet Name Version Acq_SingleCXP6x1AreaBayer 2.3.5.0 Acq_SingleCXP6x1AreaGray 2.3.5.0 Acq_SingleCXP6x1AreaRGB 2.3.5.0 Acq_SingleCXP6x1LineGray 2.3.5.0 Acq_SingleCXP6x1LineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#marathon-acx-dp","title":"marathon ACX-DP","text":"Applet Name Version Acq_DualCXP6x1AreaBayer 2.3.5.0 Acq_DualCXP6x1AreaGray 2.3.5.0 Acq_DualCXP6x1AreaRGB 2.3.5.0 Acq_DualCXP6x1LineGray 2.3.5.0 Acq_DualCXP6x1LineRGB 2.3.5.0 Acq_SingleCXP6x2AreaBayer 2.3.5.0 Acq_SingleCXP6x2AreaGray 2.3.5.0 Acq_SingleCXP6x2AreaRGB 2.3.5.0 Acq_SingleCXP6x2LineGray 2.3.5.0 Acq_SingleCXP6x2LineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#marathon-acx-qp","title":"marathon ACX-QP","text":"Applet Name Version Acq_DualCXP6x2AreaBayer 2.3.5.0 Acq_DualCXP6x2AreaGray 2.3.5.0 Acq_DualCXP6x2AreaRGB 2.3.5.0 Acq_DualCXP6x2LineGray 2.3.5.0 Acq_DualCXP6x2LineRGB 2.3.5.0 Acq_QuadCXP6x1AreaBayer 2.3.5.0 Acq_QuadCXP6x1AreaGray 2.3.5.0 Acq_QuadCXP6x1AreaRGB 2.3.5.0 Acq_QuadCXP6x1LineGray 2.3.5.0 Acq_QuadCXP6x1LineRGB 2.3.5.0 Acq_SingleCXP6x4AreaBayer 2.3.5.0 Acq_SingleCXP6x4AreaGray 2.3.5.0 Acq_SingleCXP6x4AreaRGB 2.3.5.0 Acq_SingleCXP6x4LineGray 2.3.5.0 Acq_SingleCXP6x4LineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#marathon-vcx-qp","title":"marathon VCX-QP","text":"Applet Name Version Acq_DualCXP6x2AreaBayer 2.3.5.0 Acq_DualCXP6x2AreaGray 2.3.5.0 Acq_DualCXP6x2AreaRGB 2.3.5.0 Acq_DualCXP6x2LineGray 2.3.5.0 Acq_DualCXP6x2LineRGB 2.3.5.0 Acq_QuadCXP6x1AreaBayer 2.3.5.0 Acq_QuadCXP6x1AreaGray 2.3.5.0 Acq_QuadCXP6x1AreaRGB 2.3.5.0 Acq_QuadCXP6x1LineGray 2.3.5.0 Acq_QuadCXP6x1LineRGB 2.3.5.0 Acq_SingleCXP6x4AreaBayer 2.3.5.0 Acq_SingleCXP6x4AreaGray 2.3.5.0 Acq_SingleCXP6x4AreaRGB 2.3.5.0 Acq_SingleCXP6x4LineGray 2.3.5.0 Acq_SingleCXP6x4LineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#marathon-acl","title":"marathon ACL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.3.5.0 Acq_DualBaseAreaGray 2.3.5.0 Acq_DualBaseAreaRGB 2.3.5.0 Acq_DualBaseLineBayer_RG_GB 2.3.5.0 Acq_DualBaseLineGray 2.3.5.0 Acq_DualBaseLineRGB 2.3.5.0 Acq_SingleBaseAreaBayer 2.3.5.0 Acq_SingleBaseAreaGray 2.3.5.0 Acq_SingleBaseAreaRGB 2.3.5.0 Acq_SingleBaseLineGray 2.3.5.0 Acq_SingleBaseLineRGB 2.3.5.0 Acq_SingleFullAreaBayer 2.3.5.0 Acq_SingleFullAreaGray 2.3.5.0 Acq_SingleFullAreaRGB 2.3.5.0 Acq_SingleFullLineBayer_RB_GG 2.3.5.0 Acq_SingleFullLineBayer_RG_GB 2.3.5.0 Acq_SingleFullLineGray 2.3.5.0 Acq_SingleFullLineRGB 2.3.5.0 Acq_SingleMediumAreaBayer 2.3.5.0 Acq_SingleMediumAreaGray 2.3.5.0 Acq_SingleMediumAreaRGB 2.3.5.0 Acq_SingleMediumLineGray 2.3.5.0 Acq_SingleMediumLineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#marathon-vcl","title":"marathon VCL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.3.5.0 Acq_DualBaseAreaGray 2.3.5.0 Acq_DualBaseAreaRGB 2.3.5.0 Acq_DualBaseLineBayer_RG_GB 2.3.5.0 Acq_DualBaseLineGray 2.3.5.0 Acq_DualBaseLineRGB 2.3.5.0 Acq_SingleFullAreaBayer 2.3.5.0 Acq_SingleFullAreaGray 2.3.5.0 Acq_SingleFullAreaRGB 2.3.5.0 Acq_SingleFullLineBayer_RB_GG 2.3.5.0 Acq_SingleFullLineBayer_RG_GB 2.3.5.0 Acq_SingleFullLineGray 2.3.5.0 Acq_SingleFullLineRGB 2.3.5.0 Acq_SingleMediumAreaBayer 2.3.5.0 Acq_SingleMediumAreaGray 2.3.5.0 Acq_SingleMediumAreaRGB 2.3.5.0 Acq_SingleMediumLineGray 2.3.5.0 Acq_SingleMediumLineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-3.html#marathon-vclxdeepvcl","title":"marathon VCLx/deepVCL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.3.5.0 Acq_DualBaseAreaGray 2.3.5.0 Acq_DualBaseAreaRGB 2.3.5.0 Acq_DualBaseLineGray 2.3.5.0 Acq_DualBaseLineRGB 2.3.5.0 Acq_SingleFullAreaBayer 2.3.5.0 Acq_SingleFullAreaGray 2.3.5.0 Acq_SingleFullAreaRGB 2.3.5.0 Acq_SingleFullLineGray 2.3.5.0 Acq_SingleFullLineRGB 2.3.5.0 Acq_SingleMediumAreaBayer 2.3.5.0 Acq_SingleMediumAreaGray 2.3.5.0 Acq_SingleMediumAreaRGB 2.3.5.0 Acq_SingleMediumLineGray 2.3.5.0 Acq_SingleMediumLineRGB 2.3.5.0 FrameGrabberTest 2.3.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html","title":"Delivered Components","text":"<p>The following list contains all components and their versions delivered with the Framegrabber SDK and GenTL Producer 5.11.4.</p>"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#drivers","title":"Drivers","text":"Operating System Driver Version Windows mE5 2.4.0.0 Windows mE6 2.5.0.0 Linux 5.5.0"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#applets","title":"Applets","text":""},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#imaflex-cxp-12-penta","title":"imaFlex CXP-12 Penta","text":"Applet Name Version Acq_SingleCXP12Area 1.1.3.0 Acq_DualCXP12Area 1.1.1.0 Acq_PentaCXP12Area 1.1.3.0 Acq_SingleCXP12Line 1.1.3.0 Acq_DualCXP12Line 1.1.1.0 Acq_PentaCXP12Line 1.1.3.0 FrameGrabberTest 1.1.1.1"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#imaflex-cxp-12-quad","title":"imaFlex CXP-12 Quad","text":"Applet Name Version Acq_SingleCXP12Area 1.2.2.0 Acq_DualCXP12Area 1.2.2.0 Acq_TripleCXP12Area 1.2.2.0 Acq_QuadCXP12Area 1.2.2.0 Acq_SingleCXP12Line 1.2.2.0 Acq_DualCXP12Line 1.2.2.0 Acq_TripleCXP12Line 1.2.2.0 Acq_QuadCXP12Line 1.2.2.0 FrameGrabberTest 1.1.2.1"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#imaworx-cxp-12-quad","title":"imaWorx CXP-12 Quad","text":"Applet Name Version Acq_SingleCXP12Area 2.4.8.0 Acq_DualCXP12Area 2.4.8.0 Acq_TripleCXP12Area 2.4.8.0 Acq_QuadCXP12Area 2.4.8.0 Acq_SingleCXP12Line 2.5.9.0 Acq_DualCXP12Line 2.5.9.0 Acq_TripleCXP12Line 2.5.9.0 Acq_QuadCXP12Line 2.5.9.0 FrameGrabberTest 3.5.6.1"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#cxp-12-interface-card-1c","title":"CXP-12 Interface Card 1C","text":"Applet Name Version Acq_SingleCXP12x1Area 5.5.8.0 Acq_SingleCXP12Line 1.3.2.0 FrameGrabberTest 3.5.6.1"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#cxp-12-interface-card-2c","title":"CXP-12 Interface Card 2C","text":"Applet Name Version Acq_SingleCXP12Area 2.5.8.0 Acq_DualCXP12Area 2.5.8.0 Acq_SingleCXP12Line 1.3.2.0 Acq_DualCXP12Line 1.3.2.0 FrameGrabberTest 3.5.6.1"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#cxp-12-interface-card-4c","title":"CXP-12 Interface Card 4C","text":"Applet Name Version Acq_SingleCXP12Area 2.5.8.0 Acq_DualCXP12Area 2.5.8.0 Acq_TripleCXP12Area 2.5.8.0 Acq_QuadCXP12Area 2.5.8.0 Acq_SingleCXP12Line 1.3.2.0 Acq_DualCXP12Line 1.3.2.0 Acq_TripleCXP12Line 1.3.2.0 Acq_QuadCXP12Line 1.3.2.0 FrameGrabberTest 3.5.6.1"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#marathon-acx-sp","title":"marathon ACX-SP","text":"Applet Name Version Acq_SingleCXP6x1AreaBayer 2.4.6.0 Acq_SingleCXP6x1AreaGray 2.4.6.0 Acq_SingleCXP6x1AreaRGB 2.4.6.0 Acq_SingleCXP6x1LineGray 2.4.6.0 Acq_SingleCXP6x1LineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#marathon-acx-dp","title":"marathon ACX-DP","text":"Applet Name Version Acq_DualCXP6x1AreaBayer 2.4.6.0 Acq_DualCXP6x1AreaGray 2.4.6.0 Acq_DualCXP6x1AreaRGB 2.4.6.0 Acq_DualCXP6x1LineGray 2.4.6.0 Acq_DualCXP6x1LineRGB 2.4.6.0 Acq_SingleCXP6x2AreaBayer 2.4.6.0 Acq_SingleCXP6x2AreaGray 2.4.6.0 Acq_SingleCXP6x2AreaRGB 2.4.6.0 Acq_SingleCXP6x2LineGray 2.4.6.0 Acq_SingleCXP6x2LineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#marathon-acx-qp","title":"marathon ACX-QP","text":"Applet Name Version Acq_DualCXP6x2AreaBayer 2.4.6.0 Acq_DualCXP6x2AreaGray 2.4.6.0 Acq_DualCXP6x2AreaRGB 2.4.6.0 Acq_DualCXP6x2LineGray 2.4.6.0 Acq_DualCXP6x2LineRGB 2.4.6.0 Acq_QuadCXP6x1AreaBayer 2.4.6.0 Acq_QuadCXP6x1AreaGray 2.4.6.0 Acq_QuadCXP6x1AreaRGB 2.4.6.0 Acq_QuadCXP6x1LineGray 2.4.6.0 Acq_QuadCXP6x1LineRGB 2.4.6.0 Acq_SingleCXP6x4AreaBayer 2.4.6.0 Acq_SingleCXP6x4AreaGray 2.4.6.0 Acq_SingleCXP6x4AreaRGB 2.4.6.0 Acq_SingleCXP6x4LineGray 2.4.6.0 Acq_SingleCXP6x4LineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#marathon-vcx-qp","title":"marathon VCX-QP","text":"Applet Name Version Acq_DualCXP6x2AreaBayer 2.4.6.0 Acq_DualCXP6x2AreaGray 2.4.6.0 Acq_DualCXP6x2AreaRGB 2.4.6.0 Acq_DualCXP6x2LineGray 2.4.6.0 Acq_DualCXP6x2LineRGB 2.4.6.0 Acq_QuadCXP6x1AreaBayer 2.4.6.0 Acq_QuadCXP6x1AreaGray 2.4.6.0 Acq_QuadCXP6x1AreaRGB 2.4.6.0 Acq_QuadCXP6x1LineGray 2.4.6.0 Acq_QuadCXP6x1LineRGB 2.4.6.0 Acq_SingleCXP6x4AreaBayer 2.4.6.0 Acq_SingleCXP6x4AreaGray 2.4.6.0 Acq_SingleCXP6x4AreaRGB 2.4.6.0 Acq_SingleCXP6x4LineGray 2.4.6.0 Acq_SingleCXP6x4LineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#marathon-acl","title":"marathon ACL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.4.6.0 Acq_DualBaseAreaGray 2.4.6.0 Acq_DualBaseAreaRGB 2.4.6.0 Acq_DualBaseLineBayer_RG_GB 2.4.6.0 Acq_DualBaseLineGray 2.4.6.0 Acq_DualBaseLineRGB 2.4.6.0 Acq_SingleBaseAreaBayer 2.4.6.0 Acq_SingleBaseAreaGray 2.4.6.0 Acq_SingleBaseAreaRGB 2.4.6.0 Acq_SingleBaseLineGray 2.4.6.0 Acq_SingleBaseLineRGB 2.4.6.0 Acq_SingleFullAreaBayer 2.4.6.0 Acq_SingleFullAreaGray 2.4.6.0 Acq_SingleFullAreaRGB 2.4.6.0 Acq_SingleFullLineBayer_RB_GG 2.4.6.0 Acq_SingleFullLineBayer_RG_GB 2.4.6.0 Acq_SingleFullLineGray 2.4.6.0 Acq_SingleFullLineRGB 2.4.6.0 Acq_SingleMediumAreaBayer 2.4.6.0 Acq_SingleMediumAreaGray 2.4.6.0 Acq_SingleMediumAreaRGB 2.4.6.0 Acq_SingleMediumLineGray 2.4.6.0 Acq_SingleMediumLineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#marathon-vcl","title":"marathon VCL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.4.6.0 Acq_DualBaseAreaGray 2.4.6.0 Acq_DualBaseAreaRGB 2.4.6.0 Acq_DualBaseLineBayer_RG_GB 2.4.6.0 Acq_DualBaseLineGray 2.4.6.0 Acq_DualBaseLineRGB 2.4.6.0 Acq_SingleFullAreaBayer 2.4.6.0 Acq_SingleFullAreaGray 2.4.6.0 Acq_SingleFullAreaRGB 2.4.6.0 Acq_SingleFullLineBayer_RB_GG 2.4.6.0 Acq_SingleFullLineBayer_RG_GB 2.4.6.0 Acq_SingleFullLineGray 2.4.6.0 Acq_SingleFullLineRGB 2.4.6.0 Acq_SingleMediumAreaBayer 2.4.6.0 Acq_SingleMediumAreaGray 2.4.6.0 Acq_SingleMediumAreaRGB 2.4.6.0 Acq_SingleMediumLineGray 2.4.6.0 Acq_SingleMediumLineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-4.html#marathon-vclxdeepvcl","title":"marathon VCLx/deepVCL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.4.6.0 Acq_DualBaseAreaGray 2.4.6.0 Acq_DualBaseAreaRGB 2.4.6.0 Acq_DualBaseLineGray 2.4.6.0 Acq_DualBaseLineRGB 2.4.6.0 Acq_SingleFullAreaBayer 2.4.6.0 Acq_SingleFullAreaGray 2.4.6.0 Acq_SingleFullAreaRGB 2.4.6.0 Acq_SingleFullLineGray 2.4.6.0 Acq_SingleFullLineRGB 2.4.6.0 Acq_SingleMediumAreaBayer 2.4.6.0 Acq_SingleMediumAreaGray 2.4.6.0 Acq_SingleMediumAreaRGB 2.4.6.0 Acq_SingleMediumLineGray 2.4.6.0 Acq_SingleMediumLineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html","title":"Delivered Components","text":"<p>The following list contains all components and their versions delivered with the Framegrabber SDK and GenTL Producer 5.11.5.</p>"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#drivers","title":"Drivers","text":"Operating System Driver Version Windows mE5 2.4.0.0 Windows mE6 2.5.0.0 Linux 5.5.0"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#applets","title":"Applets","text":""},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#imaflex-cxp-12-penta","title":"imaFlex CXP-12 Penta","text":"Applet Name Version Acq_SingleCXP12Area 1.1.3.0 Acq_DualCXP12Area 1.1.1.0 Acq_PentaCXP12Area 1.1.3.0 Acq_SingleCXP12Line 1.1.3.0 Acq_DualCXP12Line 1.1.1.0 Acq_PentaCXP12Line 1.1.3.0 FrameGrabberTest 1.1.1.1"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#imaflex-cxp-12-quad","title":"imaFlex CXP-12 Quad","text":"Applet Name Version Acq_SingleCXP12Area 1.2.2.0 Acq_DualCXP12Area 1.2.2.0 Acq_TripleCXP12Area 1.2.2.0 Acq_QuadCXP12Area 1.2.2.0 Acq_SingleCXP12Line 1.2.2.0 Acq_DualCXP12Line 1.2.2.0 Acq_TripleCXP12Line 1.2.2.0 Acq_QuadCXP12Line 1.2.2.0 FrameGrabberTest 1.1.2.1"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#imaworx-cxp-12-quad","title":"imaWorx CXP-12 Quad","text":"Applet Name Version Acq_SingleCXP12Area 2.4.8.0 Acq_DualCXP12Area 2.4.8.0 Acq_TripleCXP12Area 2.4.8.0 Acq_QuadCXP12Area 2.4.8.0 Acq_SingleCXP12Line 2.5.9.0 Acq_DualCXP12Line 2.5.9.0 Acq_TripleCXP12Line 2.5.9.0 Acq_QuadCXP12Line 2.5.9.0 FrameGrabberTest 3.5.6.1"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#cxp-12-interface-card-1c","title":"CXP-12 Interface Card 1C","text":"Applet Name Version Acq_SingleCXP12x1Area 5.5.8.0 Acq_SingleCXP12Line 1.3.2.0 FrameGrabberTest 3.5.6.1"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#cxp-12-interface-card-2c","title":"CXP-12 Interface Card 2C","text":"Applet Name Version Acq_SingleCXP12Area 2.5.8.0 Acq_DualCXP12Area 2.5.8.0 Acq_SingleCXP12Line 1.3.2.0 Acq_DualCXP12Line 1.3.2.0 FrameGrabberTest 3.5.6.1"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#cxp-12-interface-card-4c","title":"CXP-12 Interface Card 4C","text":"Applet Name Version Acq_SingleCXP12Area 2.5.8.0 Acq_DualCXP12Area 2.5.8.0 Acq_TripleCXP12Area 2.5.8.0 Acq_QuadCXP12Area 2.5.8.0 Acq_SingleCXP12Line 1.3.2.0 Acq_DualCXP12Line 1.3.2.0 Acq_TripleCXP12Line 1.3.2.0 Acq_QuadCXP12Line 1.3.2.0 FrameGrabberTest 3.5.6.1"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#marathon-acx-sp","title":"marathon ACX-SP","text":"Applet Name Version Acq_SingleCXP6x1AreaBayer 2.4.6.0 Acq_SingleCXP6x1AreaGray 2.4.6.0 Acq_SingleCXP6x1AreaRGB 2.4.6.0 Acq_SingleCXP6x1LineGray 2.4.6.0 Acq_SingleCXP6x1LineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#marathon-acx-dp","title":"marathon ACX-DP","text":"Applet Name Version Acq_DualCXP6x1AreaBayer 2.4.6.0 Acq_DualCXP6x1AreaGray 2.4.6.0 Acq_DualCXP6x1AreaRGB 2.4.6.0 Acq_DualCXP6x1LineGray 2.4.6.0 Acq_DualCXP6x1LineRGB 2.4.6.0 Acq_SingleCXP6x2AreaBayer 2.4.6.0 Acq_SingleCXP6x2AreaGray 2.4.6.0 Acq_SingleCXP6x2AreaRGB 2.4.6.0 Acq_SingleCXP6x2LineGray 2.4.6.0 Acq_SingleCXP6x2LineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#marathon-acx-qp","title":"marathon ACX-QP","text":"Applet Name Version Acq_DualCXP6x2AreaBayer 2.4.6.0 Acq_DualCXP6x2AreaGray 2.4.6.0 Acq_DualCXP6x2AreaRGB 2.4.6.0 Acq_DualCXP6x2LineGray 2.4.6.0 Acq_DualCXP6x2LineRGB 2.4.6.0 Acq_QuadCXP6x1AreaBayer 2.4.6.0 Acq_QuadCXP6x1AreaGray 2.4.6.0 Acq_QuadCXP6x1AreaRGB 2.4.6.0 Acq_QuadCXP6x1LineGray 2.4.6.0 Acq_QuadCXP6x1LineRGB 2.4.6.0 Acq_SingleCXP6x4AreaBayer 2.4.6.0 Acq_SingleCXP6x4AreaGray 2.4.6.0 Acq_SingleCXP6x4AreaRGB 2.4.6.0 Acq_SingleCXP6x4LineGray 2.4.6.0 Acq_SingleCXP6x4LineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#marathon-vcx-qp","title":"marathon VCX-QP","text":"Applet Name Version Acq_DualCXP6x2AreaBayer 2.4.6.0 Acq_DualCXP6x2AreaGray 2.4.6.0 Acq_DualCXP6x2AreaRGB 2.4.6.0 Acq_DualCXP6x2LineGray 2.4.6.0 Acq_DualCXP6x2LineRGB 2.4.6.0 Acq_QuadCXP6x1AreaBayer 2.4.6.0 Acq_QuadCXP6x1AreaGray 2.4.6.0 Acq_QuadCXP6x1AreaRGB 2.4.6.0 Acq_QuadCXP6x1LineGray 2.4.6.0 Acq_QuadCXP6x1LineRGB 2.4.6.0 Acq_SingleCXP6x4AreaBayer 2.4.6.0 Acq_SingleCXP6x4AreaGray 2.4.6.0 Acq_SingleCXP6x4AreaRGB 2.4.6.0 Acq_SingleCXP6x4LineGray 2.4.6.0 Acq_SingleCXP6x4LineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#marathon-acl","title":"marathon ACL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.4.6.0 Acq_DualBaseAreaGray 2.4.6.0 Acq_DualBaseAreaRGB 2.4.6.0 Acq_DualBaseLineBayer_RG_GB 2.4.6.0 Acq_DualBaseLineGray 2.4.6.0 Acq_DualBaseLineRGB 2.4.6.0 Acq_SingleBaseAreaBayer 2.4.6.0 Acq_SingleBaseAreaGray 2.4.6.0 Acq_SingleBaseAreaRGB 2.4.6.0 Acq_SingleBaseLineGray 2.4.6.0 Acq_SingleBaseLineRGB 2.4.6.0 Acq_SingleFullAreaBayer 2.4.6.0 Acq_SingleFullAreaGray 2.4.6.0 Acq_SingleFullAreaRGB 2.4.6.0 Acq_SingleFullLineBayer_RB_GG 2.4.6.0 Acq_SingleFullLineBayer_RG_GB 2.4.6.0 Acq_SingleFullLineGray 2.4.6.0 Acq_SingleFullLineRGB 2.4.6.0 Acq_SingleMediumAreaBayer 2.4.6.0 Acq_SingleMediumAreaGray 2.4.6.0 Acq_SingleMediumAreaRGB 2.4.6.0 Acq_SingleMediumLineGray 2.4.6.0 Acq_SingleMediumLineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#marathon-vcl","title":"marathon VCL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.4.6.0 Acq_DualBaseAreaGray 2.4.6.0 Acq_DualBaseAreaRGB 2.4.6.0 Acq_DualBaseLineBayer_RG_GB 2.4.6.0 Acq_DualBaseLineGray 2.4.6.0 Acq_DualBaseLineRGB 2.4.6.0 Acq_SingleFullAreaBayer 2.4.6.0 Acq_SingleFullAreaGray 2.4.6.0 Acq_SingleFullAreaRGB 2.4.6.0 Acq_SingleFullLineBayer_RB_GG 2.4.6.0 Acq_SingleFullLineBayer_RG_GB 2.4.6.0 Acq_SingleFullLineGray 2.4.6.0 Acq_SingleFullLineRGB 2.4.6.0 Acq_SingleMediumAreaBayer 2.4.6.0 Acq_SingleMediumAreaGray 2.4.6.0 Acq_SingleMediumAreaRGB 2.4.6.0 Acq_SingleMediumLineGray 2.4.6.0 Acq_SingleMediumLineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"delivered-components-framegrabber-sdk-5-11-5.html#marathon-vclxdeepvcl","title":"marathon VCLx/deepVCL","text":"Applet Name Version Acq_DualBaseAreaBayer 2.4.6.0 Acq_DualBaseAreaGray 2.4.6.0 Acq_DualBaseAreaRGB 2.4.6.0 Acq_DualBaseLineGray 2.4.6.0 Acq_DualBaseLineRGB 2.4.6.0 Acq_SingleFullAreaBayer 2.4.6.0 Acq_SingleFullAreaGray 2.4.6.0 Acq_SingleFullAreaRGB 2.4.6.0 Acq_SingleFullLineGray 2.4.6.0 Acq_SingleFullLineRGB 2.4.6.0 Acq_SingleMediumAreaBayer 2.4.6.0 Acq_SingleMediumAreaGray 2.4.6.0 Acq_SingleMediumAreaRGB 2.4.6.0 Acq_SingleMediumLineGray 2.4.6.0 Acq_SingleMediumLineRGB 2.4.6.0 FrameGrabberTest 2.4.4.0"},{"location":"display_lib.html","title":"display_lib","text":"<p>The library display_lib provides functions to display image data in a simple window. The library doesn't replace a GUI toolkit and is intended only for debugging purposes for applications without a GUI. In particular, the library doesn't implement features for scaling or transforming images and is limited to display image data up to the size of the screen.</p> <p>To use the library, the include file <code>SisoDisplay.h</code> should be added to the source code.</p> <pre><code>#include &lt;SisoDisplay.h&gt;\n</code></pre> <p>Additionally, <code>display_lib.lib</code> should be added to your Microsoft Visual Studio Project, or <code>libdisplay_lib.so</code> to your Linux project. If you use CMake, the package name is SisoDisplayLib, the libraries are stored in the variable <code>${SISODISPLAYLIB_LIBRARIES}</code> and the the include directory is stored in the variable <code>${SISODISPLAYLIB_INCLUDE_DIR}</code>. See Prerequisites for more details on projects and how to use CMake.</p>"},{"location":"display_lib.html#creating-a-display-window","title":"Creating a Display Window","text":"<pre><code>int CreateDisplay(\n    unsigned int bitsPerPixel,\n    unsigned int width,\n    unsigned int height);\n\nvoid CloseDisplay(\n    int id);\n\nvoid SetBufferWidth(\n    int id,\n    unsigned int width,\n    unsigned int height);\n</code></pre> <p>To create a display window, the function <code>CreateDisplay()</code> can be called. The function expects the bits per pixel and the window dimensions in the parameters. If the call succeeds, it will return a value equal or greater than zero, which is an identifier for the display window. In case of an error, a negative value is returned.</p> <p>If the display window is no longer needed, the function <code>CloseDisplay()</code> should be called.</p> <p>The image buffer dimensions for the display window are initially set to the same width and height as the window. If the image to be displayed is very large, the window size can be set to smaller dimensions and the function <code>SetBufferWidth()</code> can be called to set the buffer size for the image data.</p> <p>Info</p> <p>The display library is limited to handle images up to 2 GB.</p> <p>The following example shows how to create a display window matching the image dimensions and pixel format of the applet:</p> <pre><code>// get image dimensions and pixel format from applet\nint result = FG_INVALID_PARAMETER;\nint width = 0, height = 0, fgFormat = 0;\nint widthId = Fg_getParameterIdByName(fg, \"FG_WIDTH\");\nint heightId = Fg_getParameterIdByName(fg, \"FG_HEIGHT\");\nint fgFormatId = Fg_getParameterIdByName(fg, \"FG_FORMAT\");\nif (widthId &gt; 0 &amp;&amp; heightId &gt; 0 &amp;&amp; fgFormatId &gt; 0) {\n    result = Fg_getParameterWithType(fg, widthId, &amp;width, dma);\n    if (result == FG_OK) {\n        result = Fg_getParameterWithType(fg, heightId, &amp;height, dma);\n    }\n    if (result == FG_OK) {\n        result = Fg_getParameterWithType(fg, fgFormatId, &amp;fgFormat, dma);\n    }\n}\n\n// get number of bits per pixel for the format\nint bitsPerPixel = FG_INVALID_VALUE;\nif (result == FG_OK) {\n    bitsPerPixel = Fg_getBitsPerPixel(fgFormat);\n}\nif (bitsPerPixel &lt;= 0) {\n    result = FG_INVALID_VALUE;\n}\n\n// create a display\nint display = FG_INVALID_HANDLE;\nif (result == FG_OK) {\n    display = CreateDisplay(bitsPerPixel, width, height);\n}\nif (display &gt;= 0) {\n    // use display ...\n\n    CloseDisplay(display);\n}\n</code></pre>"},{"location":"display_lib.html#drawing-to-the-display-window","title":"Drawing to the Display Window","text":"<pre><code>void DrawBuffer(\n    int id,\n    const void * buffer,\n    int frameNumber,\n    const char * title);\n</code></pre> <p>To draw the image data in the display window, the function <code>DrawBuffer()</code> can be called. The function expects the display window id in the first parameter and a pointer to the buffer which contains the image data in the second parameter. The remaining two parameters can be used to display a frame number and some text in the title of the display window.</p> <p>The following example shows how to display the image data in a simple acquisition loop:</p> <pre><code>frameindex_t nextFrame = 1;\nwhile (true) {\n    // wait for new images\n    frameindex_t newestFrame =\n        Fg_getLastPicNumberBlockingEx(fg, nextFrame, dma,\n                                      timeoutInSeconds, mem);\n    if (newestFrame &gt; 0) {\n        // get pointer to current frame buffer\n        void * ptr = Fg_getImagePtrEx(fg, newestFrame, dma, mem);\n\n        // draw current frame buffer\n        DrawBuffer(display, ptr, newestFrame &amp; 0x7fffffff,\n                   \"A Sample Image Display\");\n\n        // calculate next frame\n        nextFrame = (newestFrame &lt; FRAMEINDEX_MAX) ? newestFrame + 1 : 1;\n    } else {\n        // handle error ...\n    }\n}\n</code></pre>"},{"location":"enhanced-applets-imaflex.html","title":"Enhanced Applets (imaFlex CXP-12 Quad)","text":"<p>Prototypes</p> <p>Currently, the Enhanced Applets are in prototype state. More features and applets will follow in future versions. Moreover, the usability will be improved.</p> <p>Please provide feedback! To improve the applets, it is crucial to get feedback for real world problems. Provide your feedback to your local Basler Sales representative or field application engineer.</p> <p>This topic tells you about the Enhanced Applets. Enhanced Applets are a new set of ready-to-use applets for the Basler CXP-12 frame grabbers and for the Interface Cards.</p> <p>Currently, Enhanced Applets are available for:</p> <ul> <li>CXP-12 Interface Card 1C</li> <li>CXP-12 Interface Card 2C</li> <li>CXP-12 Interface Card 4C</li> <li>imaWorx CXP-12 Quad</li> <li>imaFlex CXP-12 Quad</li> </ul> <p>Enhanced Applets are the link between AcquisitionApplets and Custom Applets: Acquisition Applets include functions for the acquisition and pre-processing of image and signal data, as well as the processing of system information.</p> <p>The Enhanced Applets include the functional scope of the Acquisition Applets and additional sophisticated image processing functions.</p> <p>Custom Applets are created via VisualApplets and provide individual functions. They can be customized on the basis of Acquisition Applets or Enhanced Applets designs.</p> <p>Acquisition Applets and Enhanced Applets are supplied with the supported frame grabbers and CXP-12 Interface Cards.</p>"},{"location":"enhanced-applets-imaflex.html#adaptations-and-customizations","title":"Adaptations and Customizations","text":"<p>It will never be possible to fulfill all customer requirements in a single set of applets. The idea of the enhanced applets is to quickly adapt to specific requirements:</p> <ul> <li>To generate new or modified enhanced applets adapted to your requirements</li> <li>To generate custom enhanced applets which fulfill exactly your requirements but will not be included in a general release. Depending on the complexity of the custom processing, this might only be possible for imaFlex frame grabbers.</li> <li>To copy the functional blocks in VisualApplets for a highly flexible and custom processing and do the implementation on your own. This is possible for imaFlex frame grabber.</li> </ul>"},{"location":"enhanced-applets-imaflex.html#visualapplets-examples-of-the-functionalities","title":"VisualApplets Examples of the Functionalities","text":"<p>The functional blocks can be provided as VisualApplets User Libraries or hierarchical boxes in a design. This is done depending on your project and project environment. You can get the hierarchical box for the enhanced applets from your local Basler Sales representative or field application engineer.</p> <p>Other than doing custom processing in VisualApplets, check the possibilities for customization mentioned in section Adaptations and Customizations.</p>"},{"location":"enhanced-applets-imaflex.html#requirements","title":"Requirements","text":"<ul> <li>Host software: Framegrabber SDK version 5.11.3 and pylon Viewer 8.0.1 or 8.0.2.</li> <li>Hardware: One of the following frame grabbers or interface cards is connected to your system:<ul> <li>CXP-12 Interface Card 1C</li> <li>CXP-12 Interface Card 2C</li> <li>CXP-12 Interface Card 4C</li> <li>imaWorx CXP-12 Quad</li> <li>imaFlex CXP-12 Quad</li> </ul> </li> </ul> <p>Limitation</p> <p>In all applets, buffers larger than 4GB can't be allocated. Even if the applet allows a larger buffer size, you can't allocate buffers larger than 4GB due to limitations in the driver and firmware.</p> <p>You can calculate the buffer size as follows:</p> <p>Buffer size = image height * image width * (pixel width / 8).</p> <p>For RGB images: buffer size = (image height * image width * (pixel width / 8)) * 3 .</p>"},{"location":"enhanced-applets-imaflex.html#documentation","title":"Documentation","text":"<p>The following sections provide links to the acquisition applets documentation:</p>"},{"location":"enhanced-applets-imaflex.html#area-acquisition-applets","title":"Area Acquisition Applets","text":"GenTL Fglib Enh_SingleCXP12Area Enh_SingleCXP12Area Enh_DualCXP12Area Enh_DualCXP12Area Enh_QuadCXP12Area Enh_QuadCXP12Area"},{"location":"enhanced-applets-imaflex.html#area-scan-acquisition-applets","title":"Area Scan Acquisition Applets","text":"<p>Currently, Enhanced Applets are available for area scan cameras. The applets perfectly extend the functions of the boost v cameras to complete your image pre-processing requirements.</p> <p>The following area scan Enhanced Applets are available:</p> <ul> <li>Enh_SingleCXP12Area</li> <li>Enh_DualCXP12Area</li> <li>Enh_QuadCXP12Area</li> </ul>"},{"location":"enhanced-applets-imaflex.html#choosing-the-right-area-scan-acquisition-applet","title":"Choosing the Right Area Scan Acquisition Applet","text":"<p>Choosing the right applet for the Enhanced Applets depends solely on the amount of cameras connected to the frame grabber, not on the link configuration. Therefore, the matrix for choosing the right applet is as follows:</p> Number of Cameras Applet Topology 1 Enh_SingleCXP12Area 2 Enh_DualCXP12Area 4 Enh_QuadCXP12Area <p>For the specific specifications of the applet read the applet documentation, chapter \"Features\".</p> <p>In contrast to the Acqusition Applets, the Enhanced Applets all have the additional features:</p> <ul> <li>Binning (currently only monochrome) of up to 4x4</li> <li>Block-based flat field correction (FFC) for monochrome cameras</li> <li>PGI high quality Debayering and image quality improvements</li> </ul>"},{"location":"enhanced-applets-imaflex.html#using-enhanced-applets","title":"Using Enhanced Applets","text":""},{"location":"enhanced-applets-imaflex.html#using-enhanced-applets-with-the-framegrabber-sdk","title":"Using Enhanced Applets with the Framegrabber SDK","text":"<p>Find here general information about using the applets with the Framegrabber SDK:  Acquisition Applets.</p>"},{"location":"enhanced-applets-imaflex.html#installing-enhanced-applets","title":"Installing Enhanced Applets","text":"<p>Before you can use a specific applet on your frame grabber, you need to install it on the frame grabber. Instructions for installing the applets are available at Managing Applets (microDiagnostics).</p>"},{"location":"enhanced-applets-imaflex.html#adding-an-enhanced-applets-manually","title":"Adding an Enhanced Applets Manually","text":"<p>To add an applet you received as *.dll file (and not in form of an installer) to your host file system:</p> <ol> <li>Get the applet file (*.dll) you have received.</li> <li>Copy this file into the following directory: \\&lt;Framegrabber SDK installation directory&gt;/Dll/\\&lt;frame grabber model&gt;</li> <li>Ensure to have the GenTL environmental variable pointing to the Framegrabber SDK installation directory.</li> </ol> <p>Now you can use the new applets in microDisplayX, any GenTL consumer or your own SDK program using the Framegrabber SDK API.</p>"},{"location":"enhanced-applets-imaflex.html#testing-image-acquisition","title":"Testing Image Acquisition","text":"<p>Before you start using an applet in your own software (via API), you might want to test the system set-up or an individual applet (and its parametrization options).</p> <p>For this purpose, you are provided with the tool microDisplay X that has been installed on your host computer as part of the Framegrabber SDK environment. For instructions how to load and test your applet, see Configuring the Applet (microDisplay X).</p>"},{"location":"enhanced-applets-imaflex.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration. For more information, see Other Tasks (microDisplay X).</p>"},{"location":"enhanced-applets-imaflex.html#using-enhanced-applets-with-the-pylon-viewer","title":"Using Enhanced Applets with the pylon Viewer","text":"<p>The Enhanced Applets are provided as plugin for the pylon Viewer. Contact Basler Sales representative or field application engineer to ask for this plugin.</p>"},{"location":"enhanced-applets-imaflex.html#installing-the-enhanced-applets-plugin-for-pylon","title":"Installing the Enhanced Applets Plugin for pylon","text":"<p>You receive the Enhanced Applets plugin for pylon as *.dll files. To install the Enhanced Applets plugin for pylon:</p> <ol> <li>Copy the *.dll files into the pylon installation directory Runtime\\x64\\pylonCXP\\dll\\&lt;frame grabber name&gt;.</li> <li>Ensure to have the GenTL environmental variable pointing to the pylon installation directory.</li> </ol> <p>Now you can use the new applets in microDisplayX, any GenTL consumer or your own SDK program using the Framegrabber SDK API.</p>"},{"location":"enhanced-applets-imaworx.html","title":"Enhanced Applets (imaWorx CXP-12 Quad)","text":"<p>Prototypes</p> <p>Currently, the Enhanced Applets are in prototype state. More features and applets will follow in future versions. Moreover, the usability will be improved.</p> <p>Please provide feedback! To improve the applets, it is crucial to get feedback for real world problems. Provide your feedback to your local Basler Sales representative or field application engineer.</p> <p>This topic tells you about the Enhanced Applets. Enhanced Applets are a new set of ready-to-use applets for the Basler CXP-12 frame grabbers and for the Interface Cards.</p> <p>Currently, Enhanced Applets are available for:</p> <ul> <li>CXP-12 Interface Card 1C</li> <li>CXP-12 Interface Card 2C</li> <li>CXP-12 Interface Card 4C</li> <li>imaWorx CXP-12 Quad</li> <li>imaFlex CXP-12 Quad</li> </ul> <p>Enhanced Applets are the link between AcquisitionApplets and Custom Applets: Acquisition Applets include functions for the acquisition and pre-processing of image and signal data, as well as the processing of system information.</p> <p>The Enhanced Applets include the functional scope of the Acquisition Applets and additional sophisticated image processing functions.</p> <p>Custom Applets are created via VisualApplets and provide individual functions. They can be customized on the basis of Acquisition Applets or Enhanced Applets designs.</p> <p>Acquisition Applets and Enhanced Applets are supplied with the supported frame grabbers and CXP-12 Interface Cards.</p>"},{"location":"enhanced-applets-imaworx.html#adaptations-and-customizations","title":"Adaptations and Customizations","text":"<p>It will never be possible to fulfill all customer requirements in a single set of applets. The idea of the enhanced applets is to quickly adapt to specific requirements:</p> <ul> <li>To generate new or modified enhanced applets adapted to your requirements</li> <li>To generate custom enhanced applets which fulfill exactly your requirements but will not be included in a general release. Depending on the complexity of the custom processing, this might only be possible for imaFlex frame grabbers.</li> <li>To copy the functional blocks in VisualApplets for a highly flexible and custom processing and do the implementation on your own. This is possible for imaFlex frame grabber.</li> </ul>"},{"location":"enhanced-applets-imaworx.html#visualapplets-examples-of-the-functionalities","title":"VisualApplets Examples of the Functionalities","text":"<p>The functional blocks can be provided as VisualApplets User Libraries or hierarchical boxes in a design. This is done depending on your project and project environment. You can get the hierarchical box for the enhanced applets from your local Basler Sales representative or field application engineer.</p> <p>Other than doing custom processing in VisualApplets, check the possibilities for customization mentioned in section Adaptations and Customizations.</p>"},{"location":"enhanced-applets-imaworx.html#requirements","title":"Requirements","text":"<ul> <li>Host software: Framegrabber SDK version 5.11.3 and pylon Viewer 8.0.1 or 8.0.2.</li> <li>Hardware: One of the following frame grabbers or interface cards is connected to your system:<ul> <li>CXP-12 Interface Card 1C</li> <li>CXP-12 Interface Card 2C</li> <li>CXP-12 Interface Card 4C</li> <li>imaWorx CXP-12 Quad</li> <li>imaFlex CXP-12 Quad</li> </ul> </li> </ul> <p>Limitation</p> <p>In all applets, buffers larger than 4GB can't be allocated. Even if the applet allows a larger buffer size, you can't allocate buffers larger than 4GB due to limitations in the driver and firmware.</p> <p>You can calculate the buffer size as follows:</p> <p>Buffer size = image height * image width * (pixel width / 8).</p> <p>For RGB images: buffer size = (image height * image width * (pixel width / 8)) * 3 .</p>"},{"location":"enhanced-applets-imaworx.html#documentation","title":"Documentation","text":"<p>The following sections provide links to the acquisition applets documentation:</p>"},{"location":"enhanced-applets-imaworx.html#area-acquisition-applets","title":"Area Acquisition Applets","text":"GenTL Fglib Enh_SingleCXP12Area Enh_SingleCXP12Area Enh_DualCXP12Area Enh_DualCXP12Area Enh_QuadCXP12Area Enh_QuadCXP12Area"},{"location":"enhanced-applets-imaworx.html#area-scan-acquisition-applets","title":"Area Scan Acquisition Applets","text":"<p>Currently, Enhanced Applets are available for area scan cameras. The applets perfectly extend the functions of the boost v cameras to complete your image pre-processing requirements.</p> <p>The following area scan Enhanced Applets are available:</p> <ul> <li>Enh_SingleCXP12Area</li> <li>Enh_DualCXP12Area</li> <li>Enh_QuadCXP12Area</li> </ul>"},{"location":"enhanced-applets-imaworx.html#choosing-the-right-area-scan-acquisition-applet","title":"Choosing the Right Area Scan Acquisition Applet","text":"<p>Choosing the right applet for the Enhanced Applets depends solely on the amount of cameras connected to the frame grabber, not on the link configuration. Therefore, the matrix for choosing the right applet is as follows:</p> Number of Cameras Applet Topology 1 Enh_SingleCXP12Area 2 Enh_DualCXP12Area 4 Enh_QuadCXP12Area <p>For the specific specifications of the applet read the applet documentation, chapter \"Features\".</p> <p>In contrast to the Acqusition Applets, the Enhanced Applets all have the additional features:</p> <ul> <li>Binning (currently only monochrome) of up to 4x4</li> <li>Block-based flat field correction (FFC) for monochrome cameras</li> <li>PGI high quality Debayering and image quality improvements</li> </ul>"},{"location":"enhanced-applets-imaworx.html#using-enhanced-applets","title":"Using Enhanced Applets","text":""},{"location":"enhanced-applets-imaworx.html#using-enhanced-applets-with-the-framegrabber-sdk","title":"Using Enhanced Applets with the Framegrabber SDK","text":"<p>Find here general information about using the applets with the Framegrabber SDK:  Acquisition Applets.</p>"},{"location":"enhanced-applets-imaworx.html#installing-enhanced-applets","title":"Installing Enhanced Applets","text":"<p>Before you can use a specific applet on your frame grabber, you need to install it on the frame grabber. Instructions for installing the applets are available at Managing Applets (microDiagnostics).</p>"},{"location":"enhanced-applets-imaworx.html#adding-an-enhanced-applets-manually","title":"Adding an Enhanced Applets Manually","text":"<p>To add an applet you received as *.dll file (and not in form of an installer) to your host file system:</p> <ol> <li>Get the applet file (*.dll) you have received.</li> <li>Copy this file into the following directory: \\&lt;Framegrabber SDK installation directory&gt;/Dll/\\&lt;frame grabber model&gt;</li> <li>Ensure to have the GenTL environmental variable pointing to the Framegrabber SDK installation directory.</li> </ol> <p>Now you can use the new applets in microDisplayX, any GenTL consumer or your own SDK program using the Framegrabber SDK API.</p>"},{"location":"enhanced-applets-imaworx.html#testing-image-acquisition","title":"Testing Image Acquisition","text":"<p>Before you start using an applet in your own software (via API), you might want to test the system set-up or an individual applet (and its parametrization options).</p> <p>For this purpose, you are provided with the tool microDisplay X that has been installed on your host computer as part of the Framegrabber SDK environment. For instructions how to load and test your applet, see Configuring the Applet (microDisplay X).</p>"},{"location":"enhanced-applets-imaworx.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration. For more information, see Other Tasks (microDisplay X).</p>"},{"location":"enhanced-applets-imaworx.html#using-enhanced-applets-with-the-pylon-viewer","title":"Using Enhanced Applets with the pylon Viewer","text":"<p>The Enhanced Applets are provided as plugin for the pylon Viewer. Contact Basler Sales representative or field application engineer to ask for this plugin.</p>"},{"location":"enhanced-applets-imaworx.html#installing-the-enhanced-applets-plugin-for-pylon","title":"Installing the Enhanced Applets Plugin for pylon","text":"<p>You receive the Enhanced Applets plugin for pylon as *.dll files. To install the Enhanced Applets plugin for pylon:</p> <ol> <li>Copy the *.dll files into the pylon installation directory Runtime\\x64\\pylonCXP\\dll\\&lt;frame grabber name&gt;.</li> <li>Ensure to have the GenTL environmental variable pointing to the pylon installation directory.</li> </ol> <p>Now you can use the new applets in microDisplayX, any GenTL consumer or your own SDK program using the Framegrabber SDK API.</p>"},{"location":"examining-images.html","title":"Examining Images","text":"<p>Basler microDisplay X includes several tools that help you examine the acquired images.</p>"},{"location":"examining-images.html#overview","title":"Overview","text":"<p>Tips for Examining Images</p> <ul> <li>Use the mouse wheel to zoom in or out.</li> <li>Move the image in the DMA output display pane by dragging.</li> <li>Saving last frame / last sequence: Use the buttons in the right bottom corner to save an acquired sequence or the last acquired frame.</li> <li>Displaying pixel values: Zoom in to 32:1 or 64:1 and click the Display Pixel Value button. The pixel value is displayed directly on the pixel field. Use the Hex button to change value display from decimal to hexadecimal and vice versa.</li> <li>You can also open and save image files with the iolibrt. You find information about supported image formats and how these image formats are saved in the Working with Image Files section. </li> </ul>"},{"location":"examining-images.html#buffer-information","title":"Buffer Information","text":"<p>The background of the DMA Output Display pane informs you in case you don't use buffer space you have allocated:</p> <ul> <li>Blue background has no meaning.</li> <li>Red background: Invalid Data. There is buffer allocated, but not used because the frame of the acquired image is smaller than the buffer allocated via applet parameters ROI width and Height. Make sure the ROI dimensions in your applet (DMA) configuration don't exceed the dimensions of the images acquired by the camera. If ROI is bigger, invalid data are acquired and - in microDisplay X - displayed in red.</li> </ul>"},{"location":"examining-images.html#line-profile","title":"Line Profile","text":"<p>The Line Profile tool allows you to examine the pixel values of a specific line in your image.</p> <p>To use the tool:</p> <ol> <li> <p>Click the Line Profile button (right bottom corner in DMA output display pane) to open the Line Profile dialog.</p> <p></p> <p>The dialog opens:</p> <p></p> <p>The line profile presents the pixel values of a line (condensed view in upper pane) and of a line fraction (view 1:1 in lower pane).</p> </li> <li> <p>Select the line you want to examine in the Y Position box.</p> </li> <li>Use the slider to select the part of the line you want to see in detail.</li> <li> <p>Use the mouse pointer to get information on an individual pixel. Mouse over the lower display (horizontal direction) to get the pixel position within the line and the gray/color value this pixel has.</p> <p></p> </li> <li> <p>Use the line profile controls in the bottom part of the dialog to vary the display of the line:</p> <ul> <li>Zooming in: The line fraction you are inspecting gets smaller. You see the color values of a smaller number of line pixels in the lower display. In the upper display, you see that the gray highlighted line section gets smaller. Benefit: The value for each examined pixel is better visible.</li> <li>Zooming out: The line fraction you are inspecting gets bigger. You see the color values of a greater number of line pixels in the lower display. In the upper display, you see that the gray highlighted line section gets broader. Benefit: You get values for a bigger section of the inspected line.</li> <li>Vertical marker: Entering a value for the vertical marker allows you to highlight a specific X position (a specific pixel) of the line. This allows you to control how the color/gray values behave before or after a specific pixel in the line.</li> <li>Horizontal marker: Entering a value for the horizontal marker allows you to highlight a specific color/gray value in the display. This makes it easy for you to control your success if you don't want to achieve image pixels above or below a specific value. You can adapt your system accordingly (lighting, configurations) and check in the line profile if the result matches your requirements.</li> </ul> </li> </ol>"},{"location":"examining-images.html#line-histogram","title":"Line Histogram","text":"<p>The Line Histogram tool shows you how often a specific pixel value is used in the selected line.</p> <p>To use the tool:</p> <ol> <li> <p>Click the Line Histogram button (right bottom corner in DMA output display pane) to open the Line Histogram dialog.</p> <p></p> <p>The dialog opens:</p> <p></p> <p>In the example line above, there are no pixels of pure black (= 0) or pure white (= 255) color. You can see that darker gray values dominate the line.</p> </li> <li> <p>Select the line you want to examine in the Y Position box.</p> </li> </ol>"},{"location":"fglib5.html","title":"fglib5","text":"<p>The library fglib5 manages initialization and control of frame grabbers in the computer.</p> <p>To use the library, the include file <code>basler_fg.h</code> should be added to the source code.</p> <pre><code>#include &lt;basler_fg.h&gt;\n</code></pre> <p>Additionally, <code>fglib5.lib</code> should be added to your Microsoft Visual Studio Project, or <code>libfglib5.so</code> to your Linux project. If you use CMake, the package name is FgLib5. CMake will store the include directory in the variable <code>${FgLib5_INCLUDE_DIR}</code> and the libraries in <code>${FgLib5_LIBRARIES}</code>. See Prerequisites for more details on projects and how to use CMake.</p>"},{"location":"fglib5.html#error-handling-in-the-frame-grabber-library","title":"Error Handling in the Frame Grabber Library","text":"<pre><code>const char * Fg_getErrorDescription(\n    Fg_Struct * fg,\n    int result);\n\nint Fg_getLastErrorNumber(\n    Fg_Struct * fg);\n</code></pre> <p>Most functions of the API return an <code>int</code> result code. If the function call was executed successfully, the return value will be <code>FG_OK</code>. A negative value denotes an error condition in most cases. The error codes are defined in the header file <code>basler_fg.h</code>.</p> <p>The function <code>Fg_getErrorDescription()</code> can be used to get a string representation of a specific result code. The first argument to this function, a handle to a frame grabber, isn't used and is only included for API backwards compatibility. You should always pass <code>nullptr</code>.</p> <p>The function <code>Fg_getLastErrorNumber()</code> will always return the result code of the last function called in the same thread context. This is most useful in cases when a function doesn't return a result code itself. The function accepts a frame grabber handle as an argument, which can be <code>nullptr</code> in case the last function called did not receive a frame grabber handle. To request the result code of a function that requires a frame grabber handle, the same handle has to be passed to <code>Fg_getLastErrorNumber()</code>.</p> <p>Info</p> <p>Error codes are stored in thread-local storage. This means that by calling <code>Fg_getLastErrorNumber()</code> from one thread the application can't request error codes which occurred in another thread.</p> <p>The following code will print the last error which happened in a context not specific to a frame grabber handle, and a description:</p> <pre><code>int result = Fg_getLastErrorNumber(nullptr);\nif (result != FG_OK) {\n    const char * description = Fg_getErrorDescription(nullptr, result);\n\n    std::cout &lt;&lt; \"Error \" &lt;&lt; result\n              &lt;&lt; \": \" &lt;&lt; description\n              &lt;&lt; std::endl;\n}\n</code></pre> <p>The code examples in the rest of this part of the documentation will not include error handling as this is specific to the requirements of the application. As much as is feasible, return codes will be checked however for successful execution of the functions.</p>"},{"location":"fglib5.html#frame-grabber-library-initialization","title":"Frame Grabber Library Initialization","text":"<pre><code>int Fg_InitLibraries(\n    const char *);\n\nvoid Fg_FreeLibraries();\n</code></pre> <p>Before using the library fglib5, it should be initialized by calling the function <code>Fg_InitLibraries()</code>. The function accepts an argument which is used for internal purposes only and should be set to nullptr.</p> <p>After the application is no longer using the library, the function <code>Fg_FreeLibraries()</code> should be called to release any resources allocated by the previous initialization.</p> <pre><code>int result = Fg_InitLibraries(nullptr);\nif (result != FG_OK) {\n    // handle error ...\n}\n\n// use frame grabber ...\n\nFg_FreeLibraries();\n</code></pre>"},{"location":"fglib5.html#system-information","title":"System Information","text":"<p>Before initializing a frame grabber, information about the version of the Framegrabber API which is used, the number and type of frame grabbers installed in the computer and other information can be requested.</p>"},{"location":"fglib5.html#framegrabber-api-version","title":"Framegrabber API Version","text":"<pre><code>const char * Fg_getSWVersion();\n</code></pre> <p>A string representation of the version of the Framegrabber API can be requested using <code>Fg_getSWVersion()</code>.</p> <pre><code>const char * rtVersion = Fg_getSWVersion();\nstd::cout &lt;&lt; \"Runtime SDK version: \" &lt;&lt; rtVersion\n          &lt;&lt; std::endl;\n</code></pre>"},{"location":"fglib5.html#general-system-information","title":"General System Information","text":"<pre><code>int Fg_getIntSystemInformationGlobal(\n    Fg_Info_Selector information,\n    FgProperty propertyId,\n    int * value);\n</code></pre> <p>Info</p> <p>The function <code>Fg_getIntSystemInformationGlobal()</code> was added in version 5.9 of the Framegrabber API. See section System Information in Plain C for the old interface.</p> <p>The following information can be requested through the function <code>Fg_getIntSystemInformationGlobal()</code> using the property <code>PROP_ID_VALUE</code>:</p> Information Description Type INFO_NR_OF_BOARDS The number of boards found in the computer int32_t INFO_MAX_NR_OF_BOARDS Maximum number of boards supported int32_t INFO_SERVICE_ISRUNNING 0: service isn't running; 1: service is running int32_t <p>For example, the number of frame grabbers installed in the computer can be requested as shown below:</p> <pre><code>int numBoards = 0;\nint result = Fg_getIntSystemInformationGlobal(INFO_NR_OF_BOARDS, PROP_ID_VALUE, &amp;numBoards);\nif (result == FG_OK) {\n    std::cout &lt;&lt; \"Number of boards: \" &lt;&lt; numBoards\n              &lt;&lt; std::endl;\n}\n</code></pre>"},{"location":"fglib5.html#board-specific-system-information","title":"Board-Specific System Information","text":"<pre><code>int Fg_getIntSystemInformationForBoardIndex(\n    unsigned int board,\n    Fg_Info_Selector information,\n     FgProperty propertyId,\n     int * value);\n\nint Fg_getInt64SystemInformationForBoardIndex(\n    unsigned int board,\n    Fg_Info_Selector information,\n    FgProperty propertyId,\n    int64_t * value);\n\nint Fg_getStringSystemInformationForBoardIndex(\n    unsigned int board,\n    Fg_Info_Selector information,\n    FgProperty propertyId,\n    std::string &amp; value,\n    const std::string &amp; arg = \"\");\n\nint Fg_getIntSystemInformationForFgHandle(\n    Fg_Struct * fg,\n    Fg_Info_Selector information,\n    FgProperty propertyId,\n    int * value);\n\nint Fg_getInt64SystemInformationForFgHandle(\n    Fg_Struct * fg,\n    Fg_Info_Selector information,\n    FgProperty propertyId,\n    int64_t * value);\n\nint Fg_getStringSystemInformationForFgHandle(\n    Fg_Struct * fg,\n    Fg_Info_Selector information,\n    FgProperty propertyId,\n    std::string &amp; value,\n    const std::string &amp; arg = \"\");\n</code></pre> <p>Info</p> <p>The functions documented in this chapter were added in version 5.9 of the Framegrabber API. See section System Information in Plain C for the old interface.</p> <p>For any given frame grabber, most other information can be requested through the functions <code>Fg_getIntSystemInformationForBoardIndex()</code>, <code>Fg_getInt64SystemInformationForBoardIndex()</code> and <code>Fg_getStringSystemInformationForBoardIndex()</code> by using the board index or frame grabber handle and the property <code>PROP_ID_VALUE</code>:</p> Information Description Type INFO_TIMESTAMP_FREQUENCY The timestamp frequency used for the image timestamps int64_t INFO_BOARDNAME Board name as shown e.g. in microDiagnostics string INFO_BOARDTYPE Board type as defined in sisoboards.h int32_t INFO_BOARDSERIALNO Board serial number int32_t INFO_FIRMWAREVERSION Firmware version of the board string INFO_HARDWAREVERSION Hardware version of the board string INFO_CAMERA_INTERFACE Camera interface provided by the board ('CameraLink', or 'CXP') string INFO_DRIVERVERSION Driver version used for the board string INFO_DRIVERARCH Driver architecture used for the board string INFO_DRIVERFULLVERSION Full driver version including architecture used for the board string INFO_DRIVERGROUPAFFINITY The driver IRQ group affinity (see Support for Non-Uniform Memory Access) int32_t INFO_DRIVERAFFINITYMASK The driver IRQ processor affinity mask (see Support for Non-Uniform Memory Access) int64_t INFO_LICENSE_GROUP_CODE Frame grabber license group code (must be a superset of the applet license group code<sup>a</sup>) int32_t INFO_LICENSE_USER_CODE Frame grabber license user code (must match the applet license user code) int32_t INFO_IS_POCL 0: the board doesn't support PoCL; 1: the board supports PoCL int32_t INFO_NR_OF_CXP_PORTS Number of ports on a board with 'CXP' interface int32_t INFO_NR_OF_CL_PORTS Number of ports on a board with 'CameraLink' interface int32_t INFO_NR_OF_PORTS Number of ports on a board with 'CameraLinkHS' interface int32_t INFO_NR_OF_GIGE_PORTS Number of ports on a board with 'GigE' interface int32_t INFO_APPLET_DESIGN_ID The HAP id of an applet (the applet path must be passed in the parameter arg) string INFO_APPLET_BITSTREAM_ID The bit stream id of an applet (the applet path must be passed in the parameter arg) string INFO_STATUS_PCI_LINK_WIDTH Number of PCIe lanes used by the frame grabber int32_t INFO_STATUS_PCI_EXPECTED_LINK_WIDTH Number of PCIe lanes supported by the frame grabber int32_t INFO_STATUS_PCI_LINK_SPEED PCIe generation used by the frame grabber int32_t INFO_STATUS_PCI_EXPECTED_LINK_WIDTH PCIe generation supported by the frame grabber int32_t INFO_STATUS_PCI_PAYLOAD_SIZE PCIe payload size used by the frame grabber int32_t <p>The list above isn't complete and contains only the properties for the information useful to the application. See the Framegrabber API r for more use cases of the API.</p> <p>For example, the following code requests the board type and name.</p> <pre><code>const int boardIndex = 0;\n\nint boardType = 0;\nint result =\n    Fg_getIntSystemInformationForBoardIndex(boardIndex, INFO_BOARDTYPE,\n                                            PROP_ID_VALUE, &amp;boardType);\n\nstd::string boardName;\nif (result == FG_OK) {\n    result =\n        Fg_getStringSystemInformationForBoardIndex(boardIndex, INFO_BOARDNAME,\n                                                   PROP_ID_VALUE, boardName);\n}\n\nif (result == FG_OK) {\n    std::cout &lt;&lt; \"Board #\" &lt;&lt; boardIndex\n              &lt;&lt; \" is a \" &lt;&lt; boardName\n              &lt;&lt; \" (type \" &lt;&lt; std::hex &lt;&lt; boardType\n              &lt;&lt; std::dec &lt;&lt; \")\" &lt;&lt; std::endl;\n}\n</code></pre> <p>Once a frame grabber handle is available after initialization, the functions <code>Fg_getIntSystemInformationForFgHandle()</code>, <code>Fg_getInt64SystemInformationForFgHandle()</code> and <code>Fg_getStringSystemInformationForFgHandle()</code> can be used to get information specific to the board according to the list above. (See chapter Frame Grabber Initialization.) The following information can be requested using the frame grabber handle and the property <code>PROP_ID_VALUE</code>:</p> Information Description Type INFO_APPLET_CAPABILITY_TAGS A list of key-value-pairs describing the applet features string INFO_OWN_BOARDINDEX The board index of the frame grabber int32_t INFO_FPGA_BITSTREAM_ID The bit stream id for the applet active in the FPGA string INFO_APPLET_FULL_PATH The full applet path string INFO_APPLET_FILE_NAME The applet file name string INFO_APPLET_TYPE 0: HAP file; 1: DLL/SO file (see Applets) int32_t <p>The list above isn't complete and contains only the properties for the information useful to the application. See the Framegrabber API reference for more use cases of the API.</p>"},{"location":"fglib5.html#using-the-board-index","title":"Using the Board Index","text":"<p>A frame grabber is selected by using the board index. If you know the number of boards present in the system, in the default case, the first board is identified by the index 0, the second board by the index 1 and so on.</p> <p>The Framegrabber API allows the user to assign a unique index to each board using a configuration file, which can be generated from within microDiagnostics. In that case, the user should know their assignments and according board indices.</p>"},{"location":"fglib5.html#applets","title":"Applets","text":"<p>To work with the frame grabber, an applet is needed. An applet is a collection of several things, most generally:</p> <ul> <li>A design for the FPGA on the frame grabber which implements the image processing from receiving images from a camera device to sending the processed image into the computer memory</li> <li>A description of the design for the software which contains the VisualApplets operators used in the design and the information to map the parameters to FPGA registers</li> <li>A collection of software interface libraries which serve as generators for class instances for handling the translation of operator parameter values to and from FPGA register contents</li> <li>A top-level library, VAS, which handles instantiating all operator classes, initialization and interfacing with the applet</li> </ul> <p>Applets come in the form of a HAP file if they were designed using VisualApplets, or as a wrapped applet library file if they come pre-installed by the Framegrabber SDK. HAP files are usually stored inside a board-specific subdirectory of the <code>Hardware Applets</code> directory in the Framegrabber SDK installation, while wrapped applet library files are installed in a board-specific subdirectory of the <code>dll</code> directory. These subdirectories are referred to as standard locations for the corresponding type of applet throughout this documentation.</p> <p>Each applet provides a set of parameters to configure the provided features. Consult the documentation for the specific applet to be used for an in-depth description of the features and parameters provided by the applet.</p>"},{"location":"fglib5.html#choosing-the-right-applet","title":"Choosing the Right Applet","text":"<p>Applets which can be installed with the Framegrabber SDK usually come as a wrapped library file. The naming convention for those files follows some rules:</p> <ul> <li>The file name usually starts with <code>Acq_</code>. (These applets are referred to as Advanced Acquisition Applet, the previous generation was referred to as Standard Applet and had a different naming convention.)</li> <li>Next, the number of cameras supported by the applet is given in the form of <code>Single</code>, <code>Dual</code> or <code>Quad</code>.</li> <li>Then, the camera interface supported is given. For example, <code>CXP12</code> indicates the CoaXPress camera interface with up to 12 Gbit/s as specified in the CoaXPress Standard Version 2.0.</li> <li>On older frame grabber platforms, the maximum number of camera link connections is given in the form of <code>x1</code>, <code>x2</code> or <code>x4</code>. (This was dropped from the naming convention as <code>x4</code> includes support for <code>x2</code> and <code>x1</code>, <code>x2</code> supports <code>x1</code> and the maximum number of links supported usually should be clear from the number of cameras supported and the number of physical ports the frame grabber provides.)</li> <li>Then, the sensor type supported is given. This is either <code>Area</code> or <code>Line</code>. For applets supporting both area and line type sensors, this is dropped.</li> <li>The last part of the name is the data format supported by the applet, like <code>Gray8</code>, <code>Bayer16</code>, <code>RGB24</code>. For applets supporting multiple data formats, this is dropped.</li> </ul> <p>For example, the applet <code>Acq_SingleCXP12Area</code> is an Advanced Acquisition Applet which supports one CXP camera with up to 12 Gbit/s and an area sensor. The applet supports multiple data formats. To understand the supported data formats and sensor sizes the applet documentation has to be consulted.</p> <p>If the application for example requires two CXP cameras with 12 Gbit/s, a line type sensor with 10-bit gray scale output, look for applets called <code>Acq_DualCXP12Line</code>, <code>Acq_DualCXP12LineGray10</code> or <code>Acq_DualCXP12LineGray16</code> and read the accompanying documentation. If the cameras connect using only a single physical link, the <code>Quad</code> variants of the applets can be considered as well.</p>"},{"location":"fglib5.html#start-up-behavior","title":"Start-up Behavior","text":"<p>When the Framegrabber SDK starts to initialize the fglib5 library, access to the frame grabber is needed even before an applet is loaded as described in Frame Grabber Initialization. This is required, for example, to allow sorting boards according to their serial number or even to see all applets that are available for loading.</p> <p>Which applet is used for this initialization depends on the frame grabber you use. You can use the information in the following sections to configure your frame grabber to start with a pre-defined applet. Using a different applet than the pre-defined one when calling <code>Fg_Init</code> leads to a longer start-up time.</p> <p>At start-up, the Framegrabber SDK by default loads the last applet which was used by <code>Fg_Init</code>.</p> <p>You can deactivate this behavior by setting the system environment variable <code>FGSDK_LOAD_LAST_APPLET_ON_INIT=Off</code>.</p>"},{"location":"fglib5.html#start-up-behavior-of-microenable-5-marathon-frame-grabbers","title":"Start-up Behavior of microEnable 5 marathon Frame Grabbers","text":"<p>On a microEnable 5 marathon frame grabber, you must flash an applet to the board into one of the partitions available. The default behavior of the Framegrabber SDK is to set the applet used in <code>Fg_Init</code> as the boot partition. At start-up, the applet in the boot partition is used to initialize the board at system power-up. This applet is then also used in the first initialization phase of the Framegrabber SDK.</p>"},{"location":"fglib5.html#start-up-behavior-of-microenable-6-frame-grabbers","title":"Start-up Behavior of microEnable 6 Frame Grabbers","text":"<p>On a CXP-12 Interface Card, imaWorx CXP-12 Quad, imaFlex CXP-12 Quad or imaFlex CXP-12 Penta frame grabber, the Framegrabber SDK tries to open the last applet that was loaded. The last applet that was loaded is defined in the <code>LastApplet</code> key in the section <code>FG</code> in the configuration file named me6_&lt;n&gt;_init.config, where &lt;n&gt; is the driver index of the board. The driver index is very similar to the board index described in section Using the Board Index, but is driver-specific and isn't affected by re-sorting boards. On Windows, <code>driver index 0</code> refers to the first CXP-12 Interface Card, imaWorx CXP-12 or imaFlex CXP-12 frame grabber found by the driver, <code>driver index 1</code> refers to the second board and so on. On all other operating systems, the driver index is identical to the board index without any re-sorting applied.</p> <p>On Windows systems, the configuration file is usually located in the directory <code>%APPDATA%\\basler</code>. On all other operating systems, the configuration file is located in the <code>$HOME/.config/basler</code> directory. If no configuration file is found, then the Framegrabber SDK looks in the root folder of the Framegrabber SDK installation.</p> <p>If no configuration file was found for the frame grabber or if the initialization failed, the default applet is used. The default applet is usually the applet that supports one area sensor type camera per physical port.</p> <p>If the initialization fails also for the default applet, the Framegrabber SDK opens any applet which can be used.</p>"},{"location":"fglib5.html#enumerating-applets","title":"Enumerating Applets","text":"<pre><code>int Fg_getAppletIterator(\n    int board,\n    FgAppletIteratorSource source,\n    Fg_AppletIteratorType * iter,\n    int flags);\n\nFg_AppletIteratorItem Fg_getAppletIteratorItem(\n    Fg_AppletIteratorType iter,\n    int index);\n\nint64_t Fg_getAppletIntProperty(\n    Fg_AppletIteratorItem item,\n    FgAppletIntProperty property);\n\nconst char * Fg_getAppletStringProperty(\n    Fg_AppletIteratorItem item,\n    FgAppletIntProperty property);\n\nint Fg_freeAppletIterator(\n    Fg_AppletIteratorType iter);\n</code></pre> <p>Usually, an application will use one or maybe a few specific applets and the features will be known through the applet documentation and the following functions will not be useful to most applications. In cases where an application is designed more dynamically, the Framegrabber API provides functions through which the applets can be enumerated and various information about applets can be requested.</p> <p>To enumerate Applets, the function <code>Fg_getAppletIterator()</code> can be called. If you want to enumerate the applets which are available on the Framegrabber SDK installation, the source <code>FG_AIS_FILESYSTEM</code> should be used. To enumerate only applets which can be loaded on the given board, pass <code>FG_AF_IS_LOADABLE</code> for the flags. This ensures that any applets returned by the API can be used by a subsequent call to initialize the frame grabber. The function returns the number of items in the iterator.</p> <p>The items of the applet iterator can be retrieved by calling <code>Fg_getAppletIteratorItem()</code>.</p> <p>The following information can be requested from an item by calling <code>Fg_getAppletIntProperty()</code> or <code>Fg_getAppletStringProperty()</code>:</p> Property Description Type FG_AP_INT_FLAGS Flags which apply to the applet (FG_AF_\u2026 constants) int32_t FG_AP_INT_INFO Tags which apply to the applet (FG_AI_\u2026 constants) int32_t FG_AP_INT_PARTITION Partition on which the applet is flashed (mE5 only) int32_t FG_AP_INT_NR_OF_DMA Maximum number of DMA channels provided by the applet int32_t FG_AP_INT_NR_OF_CAMS Maximum number of cameras accessible when using the applet int32_t FG_AP_INT_GROUP_CODE Applet license group code (must be a subset of the frame grabber license group code<sup>a</sup>) int32_t FG_AP_INT_USER_CODE Applet license user code (must match the frame grabber license user code) int32_t FG_AP_INT_DESIGN_VERSION Major version of the FPGA design int32_t FG_AP_INT_DESIGN_REVISION Version revision of the FPGA design int32_t FG_AP_STRING_APPLET_UID UID identifying the applet file string FG_AP_STRING_BITSTREAM_UID UID identifying the FPGA design string FG_AP_STRING_DESIGN_NAME Name of the FPGA design string FG_AP_STRING_APPLET_NAME Name of the applet string FG_AP_STRING_DESCRIPTION Description of the applet string FG_AP_STRING_CATEGORY Category of the applet string FG_AP_STRING_APPLET_PATH Full path of the applet string FG_AP_STRING_SUPPORTED_PLATFORMS Comma separated list of supported platforms string FG_AP_STRING_TAGS Comma separated list of tags string FG_AP_STRING_VERSION Version of the applet string FG_AP_STRING_APPLET_FILE File name of the applet string FG_AP_STRING_RUNTIME_VERSION Required Framegrabber SDK version string <p>The list above isn't complete and contains only the properties for the information useful to the application. See the Framegrabber API reference for more use cases of the API.</p> <p>After using the applet iterator, it should be released by calling <code>Fg_freeAppletIterator()</code>.</p> <p>The applet name should be sufficient for a subsequent call to initialize the frame grabber, as long as the name is unique and the applets are located in one of the standard locations. If multiple applets use the same name, or an applet is located outside of one of the standard locations, then the full path should be used. The following example shows how to extract the applet name from all applets found in the standard locations:</p> <pre><code>const in boardIndex = 0;\n\nFg_AppletIteratorType iter = 0;\nint numItems =\n    Fg_getAppletIterator(boardIndex, FG_AIS_FILESYSTEM,\n                         &amp;iter, FG_AF_IS_LOADABLE);\n\nif (numItems &gt;= 0) {\n    std::cout &lt;&lt; \"Found \" &lt;&lt; numItems &lt;&lt; \" applets\";\n\n    for (int i = 0; i &lt; numItems; ++i) {\n        auto item = Fg_getAppletIteratorItem(iter, i);\n\n        const char * appletName =\n            Fg_getAppletStringProperty(item, FG_AP_STRING_APPLET_NAME);\n\n        std::cout &lt;&lt; \" \" &lt;&lt; appletName;\n    }\n\n    std::cout &lt;&lt; std::endl;\n    Fg_freeAppletIterator(iter);\n}\n</code></pre>"},{"location":"fglib5.html#frame-grabber-initialization","title":"Frame Grabber Initialization","text":"<pre><code>Fg_Struct * Fg_Init(\n    const char * applet,\n    unsigned int board);\n\nint Fg_FreeGrabber(\n    Fg_Struct * fg);\n</code></pre> <p>To work with a frame grabber, it has to be initialized first. This is done by loading an applet using the function <code>Fg_Init()</code>. The function returns a handle to the frame grabber for the given board index after initializing the frame grabber with the applet specified. The handle is used in most of the API functions described in the following chapters.</p> <p>After the application is done using the frame grabber, it should be released by calling <code>Fg_FreeGrabber()</code>.</p> <p>For example, the following code initializes a CXP-12 frame grabber with the applet <code>Acq_SingleCXP12Area</code>:</p> <pre><code>const int boardIndex = 0;\nconst char * applet = \"Acq_SingleCXP12Area\";\n\nFg_Struct * fg = Fg_Init(applet, boardIndex);\nif (fg != nullptr) {\n    // use frame grabber ...\n\n    Fg_FreeGrabber(fg);\n}\n</code></pre>"},{"location":"fglib5.html#configuration-files","title":"Configuration Files","text":"<pre><code>Fg_Struct * Fg_InitConfig(\n    const char * config,\n    unsigned int board);\n\nint Fg_loadConfig(\n    Fg_Struct * fg,\n    const char * config);\n\nint Fg_saveConfig(\n    Fg_Struct * fg,\n    const char * config);\n</code></pre> <p>If you use microDisplayX to initially configure a frame grabber and test your setup, the configuration can be saved from within the program. The main configuration file with have an extension <code>.mcf</code> and a second file with an extension <code>.mfs</code> will be created alongside. With these two files, instead of replicating the configuration through API calls, the application can directly initialize a frame grabber using these two files.</p> <p>Configuration in this context refers to the applet with which a frame grabber was initialized, and the settings of the parameters of the applet. See chapter Working with Applet Parameters for more information.</p> <p>Info</p> <p>Only the main configuration file with the extension <code>.mcf</code> is used in the parameters to the functions. The file with extension <code>.mfs</code> will be used automatically as long as the file name up to the extension is the same.</p> <p>To initialize a frame grabber from configuration files, the function <code>Fg_InitConfig()</code> can be called instead of <code>Fg_Init()</code>. The function returns a handle to the frame grabber for the given board index after initializing the frame grabber according to the main configuration file specified.</p> <p>After the application is done using the frame grabber, it should be released by calling <code>Fg_FreeGrabber()</code>.</p> <p>If the application requires different sets of configurations, these can be applied to a frame grabber by calling <code>Fg_loadConfig()</code> at any point after calling <code>Fg_Init()</code> or <code>Fg_InitConfig()</code>.</p> <p>The current configuration can be written to configuration files by calling <code>Fg_saveConfig()</code> at any point after calling <code>Fg_Init()</code> or <code>Fg_InitConfig()</code>.</p> <p>The following example shows how to save and restore the configuration of a frame grabber:</p> <pre><code>const char * config = \"SavedState.mcf\";\n\nint result = Fg_saveConfig(fg, config);\nif (result != FG_OK) {\n    // handle error ...\n}\n\n// change frame grabber configuration ...\n\nresult = Fg_loadConfig(fg, config);\nif (result != FG_OK) {\n    // handle error ...\n}\n</code></pre>"},{"location":"fglib5.html#working-with-applet-parameters","title":"Working with Applet Parameters","text":"<p>Once the frame grabber is initialized using an applet, the parameters of the applet can be read or manipulated. For example, to acquire images from a camera, the applet has to be configured to use the correct image dimensions and image format according to the image data the camera sends. Another example is configuring the trigger module provided by the applet to match the application requirements.</p>"},{"location":"fglib5.html#parameter-identifiers-and-parameter-names","title":"Parameter Identifiers and Parameter Names","text":"<pre><code>int Fg_getParameterIdByName(\n    Fg_Struct * fg,\n    const char * name);\n\nconst char * Fg_getParameterNameById(\n    Fg_Struct * fg,\n    unsigned int id,\n    unsigned int dma);\n\nFgParamTypes Fg_getParameterTypeById(\n    Fg_Struct * fg,\n    unsigned int id,\n    unsigned int dma);\n</code></pre> <p>Info</p> <p>The function <code>Fg_getParameterTypeById()</code> was added in version 5.9 of the Framegrabber SDK.</p> <p>Each parameter of the applet is identified by its name, but the API uses a numerical identifier to access the parameter value or properties. Many parameters have fixed numerical identifiers as specified in the header file <code>basler_fg.h</code>, however the use isn't recommended for all but the most common parameters. To get the numerical identifier for a parameter, the function <code>Fg_getParameterIdByName()</code> is used. The function returns 0 or a negative error code if an error occurred translating the name into an identifier.</p> <p>To get the name of a parameter for which the numerical identifier is known, the function <code>Fg_getParameterNameById()</code> can be used.</p> <p>To get the type of a parameter for which the numerical identifier is known, the function <code>Fg_getParameterTypeById()</code> can be used.</p>"},{"location":"fglib5.html#parameter-types","title":"Parameter Types","text":"<p>Parameters are typed and to get or set the value of a parameter the type must be known, either from the documentation of the applet, implicitly by applets designed in-house using VisualApplets, or by requesting the type by using the function <code>Fg_getParameterTypeById()</code>.</p> Parameter Type C/C++ Type FG_PARAM_TYPE_INT32_T int32_t FG_PARAM_TYPE_UINT32_T uint32_t FG_PARAM_TYPE_INT64_T int64_t FG_PARAM_TYPE_UINT64_T uint64_t FG_PARAM_TYPE_DOUBLE double FG_PARAM_TYPE_CHAR_PTR string FG_PARAM_TYPE_SIZE_T size_t FG_PARAM_TYPE_STRUCT_FIELDPARAMINT FieldParameterAccess FG_PARAM_TYPE_STRUCT_FIELDPARAMINT64 FieldParameterAccess FG_PARAM_TYPE_STRUCT_FIELDPARAMDOUBLE FieldParameterAccess <p>Parameters with one of the field parameter types should be handled using the <code>FG_PARAM_TYPE_STRUCT_FIELDPARAMACCESS</code> API described in subsection Accessing Field Parameters of chapter Considerations When Using Plain C.</p>"},{"location":"fglib5.html#accessing-parameter-values","title":"Accessing Parameter Values","text":"<pre><code>int Fg_getParameterWithType(\n    Fg_Struct * fg,\n    int id,\n    int32_t * value,\n    unsigned int dma);\n\n// Fg_getParameterWithType() is overloaded for:\n//     int32_t * value\n//     uint32_t * value\n//     int64_t * value\n//     uint64_t * value\n//     float * value\n//     double * value\n//     std::string &amp; value\n</code></pre> <pre><code>int Fg_setParameterWithType(\n    Fg_Struct * fg,\n    int id,\n    int32_t value,\n    unsigned int dma);\n\n// Fg_setParameterWithType() is overloaded for:\n//     int32_t value\n//     uint32_t value\n//     int64_t value\n//     uint64_t value\n//     float value\n//     double value\n//     const std::string &amp; value\n</code></pre> <p>To get or set the value of a parameter, the overloaded functions <code>Fg_getParameterWithType()</code> and <code>Fg_setParameterWithType()</code> should be used.</p> <p>For example, given a frame grabber handle <code>fg</code> from a previous call to <code>Fg_Init()</code>, the following code sets the width of the first DMA channel of the applet to 1024.</p> <pre><code>const int dma = 0;\nconst int width = 1024;\nint result = FG_INVALID_PARAMETER;\n\nint paramId = Fg_getParameterIdByName(fg, \"FG_WIDTH\");\nif (paramId &gt; 0) {\n    result = Fg_setParameterWithType(fg, paramId, width, dma);\n}\n</code></pre> <p>The last parameter which is passed to the functions <code>Fg_getParameterWithType()</code>  and <code>Fg_setParameterWithType()</code> in most cases refers to a DMA channel. Parameters like <code>FG_WIDTH</code>, <code>FG_HEIGHT</code> can be different for each DMA channel and each instance of these parameters can be requested or changed by passing the number of the DMA channel to the functions.</p> <p>In some cases, the last parameter can refer to other logical indices. For example, the parameters <code>FG_NR_OF_DMAS</code> or <code>FG_NR_OF_CAMS</code> exist in multiple instances for each process of the applet, which is a scope defined in VisualApplets.</p> <p>Other parameters are global in the context of an applet and the last parameter in the functions is ignored. One such parameter would be <code>FG_NR_OF_PROCESSES</code>. But even more prominently, if the application developer designs their own applets using VisualApplets, all parameters which control the applet can be considered global as they are identified by unique names, and the last parameter in the functions is ignored.</p> <p>Some parameters can be different for every image acquired and require both the DMA channel and the frame number or buffer number. This applies to any image meta data, like the time stamp when an image has been transferred to the computer memory, the length of the actual image data, and similar information. These parameters can't be handled by the functions mentioned above, and this topic will be discussed in more detail in chapter Image Acquisition.</p>"},{"location":"fglib5.html#accessing-parameter-properties","title":"Accessing Parameter Properties","text":"<pre><code>int Fg_getParameterPropertyWithType(\n    Fg_Struct * fg,\n    int id,\n    FgProperty propertyId,\n    int32_t * value);\n\n// Fg_getParameterPropertyWithType() is overloaded for:\n//     int32_t * value\n//     uint32_t * value\n//     int64_t * value\n//     uint64_t * value\n//     float * value\n//     double * value\n//     std::string &amp; value\n</code></pre> <pre><code>int Fg_getParameterPropertyWithTypeEx(\n    Fg_Struct * fg,\n    int id,\n    FgProperty propertyId,\n    int32_t * value,\n    unsigned int dma);\n\n// Fg_getParameterPropertyWithTypeEx() is overloaded for:\n//     int32_t * value\n//     uint32_t * value\n//     int64_t * value\n//     uint64_t * value\n//     float * value\n//     double * value\n//     std::string &amp; value\n</code></pre> <p>Info</p> <p>The functions documented in this chapter were added in version 5.9 of the Framegrabber SDK. See section Accessing Parameter Properties in Plain C for the old interface.</p> <p>Parameters have various properties besides the current value. Using the overloaded functions <code>Fg_getParameterPropertyWithType()</code> isn't recommended, as the function calls implicitly use DMA channel 0, parameter properties might differ though for different channels. Using the overloaded functions <code>Fg_getParameterPropertyWithTypeEx()</code> the following properties can be requested:</p> Property Description Type <code>PROP_ID_VALUE</code> Current parameter value same as parameter <code>PROP_ID_DATATYPE</code> Parameter type(enum value according to FgParamTypes) int32_t <code>PROP_ID_NAME</code> Descriptive name string <code>PROP_ID_PARAMETERNAME</code> Parameter name string <code>PROP_ID_VALUELLEN</code> Length required to encode the value to a string int32_t <code>PROP_ID_ACCESS</code> Access flags of the parameter int32_t <code>PROP_ID_MIN</code> Minimum parameter value<sup>b</sup> same as parameter <code>PROP_ID_MAX</code> Maximum parameter value<sup>b</sup> same as parameter <code>PROP_ID_STEP</code> Step size of the parameter<sup>b</sup> same as parameter <code>PROP_ID_IS_ENUM</code> 0: not an enumeration parametern: size of buffer needed for PROP_ID_ENUM_VALUES int32_t <code>PROP_ID_ENUM_VALUES</code> Enumeration values (see Accessing the Enum Values Parameter Property) FgPropertyEnumValues[] <code>PROP_ID_FIELD_SIZE</code> Number of elements in a field parameter int32_t <p>The list above isn't complete and contains only the properties for the information which isn't considered deprecated. See the Framegrabber API reference for more use cases of the API.</p> <p>The following example shows how to get the minimum value of a parameter, assuming paramId is a parameter of type <code>FG_PARAM_TYPE_INT32_T</code>:</p> <pre><code>int minVal = 0;\nint result =\n    Fg_getParameterPropertyWithTypeEx(fg, paramId, PROP_ID_MIN,\n                                      &amp;minVal, dma);\nif (result == FG_OK) {\n    // work with the property ...\n}\n</code></pre>"},{"location":"fglib5.html#memory-management","title":"Memory Management","text":"<p>To acquire images from a camera, memory is needed in the computer to transfer those images to and to access the image data from within a program. The Framegrabber API uses a circular buffer memory model. A memory buffer consists of at least two items, often referred to as frame buffers or sub-buffers, which will be re-used for subsequent frames acquired from the camera. How many frame buffers should be used depends on various factors, the most important one being how many further frames can arrive while a frame is still being processed. This will be discussed in more detail in section Acquisition Models of chapter Image Acquisition.</p> <p>Each frame buffer must be of the same size, and must be large enough to store the largest possible image for the application requirements, usually defined by the width <code>FG_WIDTH</code>, height <code>FG_HEIGHT</code> and pixel format <code>FG_FORMAT</code>. (For an applet designed in VisualApplets, the width, height and pixel format will usually be more complex to setup.)</p> <p>The circular buffer can be one large block of memory, contiguous in virtual address space and subdivided into equally sized frame buffers. Or it can consist of frame buffers which were individually allocated in memory and added to the management structure <code>dma_mem</code> used by the API.</p>"},{"location":"fglib5.html#basic-memory-management-not-recommended","title":"Basic Memory Management (Not Recommended)","text":"<pre><code>void * Fg_AllocMem(\n    Fg_Struct * fg,\n    size_t totalSize,\n    frameindex_t numFrames,\n    unsigned int dma);\n\nint Fg_FreeMem(\n    Fg_Struct * fg,\n    unsigned int dma);\n</code></pre> <p>There are three different sets of functions which can be used for memory management. However, using the functions <code>Fg_AllocMem()</code> and <code>Fg_FreeMem()</code> isn't recommended as it is limited to the use of the standard acquisition model (ACQ_STANDARD). The remaining two sets of functions will be discussed here in more detail as they can be used with all three acquisition models (ACQ_STANDARD, ACQ_BLOCK and ACQ_SELECT) and can be applied both to simple use cases as well as to more specific requirements of the application.</p>"},{"location":"fglib5.html#advanced-memory-management","title":"Advanced Memory Management","text":"<pre><code>dma_mem * Fg_AllocMemEx(\n    Fg_Struct * fg,\n    size_t totalSize,\n    frameindex_t numFrames);\n\nint Fg_FreeMemEx(\n    Fg_Struct * fg,\n    dma_mem * mem);\n</code></pre> <p>The function <code>Fg_AllocMemEx()</code> can be used to allocate one large contiguous memory buffer of size <code>totalSize</code> which is subdivided into <code>numFrames</code> equally sized frame buffers. The function returns a handle to the memory management structure, or nullptr in case of an error.</p> <p>The pointer returned isn't a pointer to the memory buffer itself and should not be used directly! After the memory is no longer needed it should be released using <code>Fg_FreeMemEx()</code>.</p> <p>In the following example, the code will allocate a memory buffer for 16 frame buffers which can hold 24-bit RGB images of a size of 1024 x 1024:</p> <pre><code>const int width = 1024, height = 1024;\nconst int bytesPerPixel = 3;\nconst frameindex_t numFrames = 16;\nconst size_t frameSize = static_cast&lt;size_t&gt;(width) * height * bytesPerPixel;\nconst size_t totalSize = frameSize * numFrames;\n\ndma_mem * mem = Fg_AllocMemEx(fg, totalSize, numFrames);\nif (mem != nullptr) {\n    // use memory, acquire and process images ...\n\n    Fg_FreeMem(fg, mem);\n}\n</code></pre> <p>The <code>static_cast&lt;size_t&gt;(width)</code> in the calculation of the <code>frameSize</code>. This is necessary to make sure that the size of very large images will be calculated correctly.</p>"},{"location":"fglib5.html#flexible-memory-management","title":"Flexible Memory Management","text":"<pre><code>dma_mem * Fg_AllocMemHead(\n    Fg_Struct * fg,\n    size_t totalSize,\n    frameindex_t numFrames);\n\nint Fg_AddMem(\n    Fg_Struct * fg,\n    void * frameBuffer,\n    size_t size,\n    frameindex_t index,\n    dma_mem * mem);\n\nint Fg_DelMem(\n    Fg_Struct * fg,\n    dma_mem * mem,\n    frameindex_t index);\n\nint Fg_FreeMemHead(\n    Fg_Struct * fg,\n    dma_mem * mem);\n</code></pre> <p>If the application has specific requirements for memory allocation instead of letting the Framegrabber API handle it, the function <code>Fg_AllocMemHead()</code> can be used to prepare the memory management structure. The function expects the same parameters as <code>Fg_AllocMemEx()</code>, but it will not allocate any memory. After allocating memory in the application, each frame buffer needs to be added individually using the function <code>Fg_AddMem()</code>. If the application requires dynamic changes of the frame buffers used for a memory buffer during acquisition runs, the function <code>Fg_DelMem()</code> can be used to remove frame buffers from the memory buffer. After the memory buffer is no longer needed, the management structure should be released first by calling <code>Fg_FreeMemHead()</code> before releasing the memory for the frame buffers.</p> <p>The following code shows how the function 'Fg_AllocMemEx()' is a convenience wrapper for the more flexible memory management API:</p> <pre><code>int Fg_AllocMemEx(Fg_Struct * fg, size_t totalSize, frameindex_t numFrames)\n{\n    const size_t frameSize = totalSize / numFrames;\n    char * buf = nullptr;\n\n    dma_mem * mem = Fg_AllocMemHead(fg, totalSize, numFrames);\n    if (mem != nullptr) {\n        try {\n            buf = new char[totalSize];\n            for (frameindex_t frame = 0; frame &lt; numFrames; ++frame) {\n                const int result =\n                    Fg_AddMem(fg, buf + frameSize*frame,\n                              frameSize, frame, mem);\n                if (result != FG_OK) {\n                    throw std::runtime_error(\"Failed to add frame buffer\");\n                }\n            }\n        }\n        catch (...) {\n            for (frameindex_t frame = 0; frame &lt; numFrames; ++frame) {\n                Fg_DelMem(fg, mem, frame);\n            }\n            Fg_FreeMemHead(fg, mem);\n            delete[] buf;\n            return nullptr;\n        }\n    }\n    return mem;\n}\n</code></pre>"},{"location":"fglib5.html#image-acquisition","title":"Image Acquisition","text":"<p>The Framegrabber API provides two modes of image data delivery which can be combined with three different acquisition models.</p> <p>Image data can be delivered in synchronous or asynchronous mode. In the synchronous mode, an acquisition loop has to be provided by the application. In the asynchronous mode, a callback function can be registered which will be called whenever new image data is available. The Framegrabber API will provide the image acquisition loop in a separate thread for asynchronous mode. For some GUI frameworks, synchronizing the Framegrabber API thread context back into the GUI thread context can be complicated, and running an acquisition loop in a thread context provided by the framework might prove more sensible.</p>"},{"location":"fglib5.html#registering-a-callback-function-for-asynchronous-mode","title":"Registering a Callback Function for Asynchronous Mode","text":"<pre><code>typedef int (* Fg_ApcFunc_t)(\n    frameindex_t frame,\n    void * data);\n\nint Fg_registerApcHandlerEx(\n    Fg_Struct * fg,\n    unsigned int dma,\n    Fg_ApcFunc_t func,\n    void * data,\n    unsigned int timeout,\n    unsigned int flags);\n\nint Fg_unregisterApcHandler(\n    Fg_Struct * fg,\n    unsigned int dma);\n</code></pre> <p>Info</p> <p>In version 5.9 of the Framegrabber API the functions <code>Fg_registerApcHandlerEx()</code> and <code>Fg_unregisterApcHandler()</code> were added and the behavior when using the blocking acquisition model <code>ACQ_BLOCK</code> was changed. See section Registering a Callback Function for Asynchronous Mode in Plain C for the old interface.</p> <p>The function <code>Fg_registerApcHandlerEx()</code> can be used to setup the asynchronous mode before starting the acquisition.</p> <p>Using <code>Fg_registerApcHandlerEx()</code>, a function of type <code>Fg_ApcFunc_t</code> can be registered to be called when image data is received. The function will be registered for a given frame grabber and DMA channel and will be passed two parameters when called. The first parameter to the callback function is a frame number (in <code>ACQ_STANDARD</code> and <code>ACQ_SELECT</code>) or buffer number (in <code>ACQ_BLOCK</code>) for the image received. The second parameter is a pointer which was supplied with the call to <code>Fg_registerApcHandlerEx()</code> and which can be used as a pointer to a context structure or class, for example the <code>this</code> pointer of a class instance which implements image processing.</p> <p>Only one callback function can be registered for each DMA channel on any given frame grabber.</p> <p>The callback function will be called from the acquisition loop provided by the Framegrabber API. This implies that callback function is called in the thread context of the acquisition loop. It also implies that the time the callback function takes until it returns is added to the general management overhead of the acquisition loop, and that during this time multiple images might have been received. If any images were received during that time, the callback function will be called again immediately after it returns.</p> <p>The handling of the image acquisition can be controlled through the <code>timeout</code> and <code>flags</code> parameters in the call to <code>Fg_registerApcHandlerEx()</code>. The timeout is given in seconds which the acquisition loop should wait for new images to arrive. For the parameter <code>flags</code>, the following values and combinations thereof combined with the operator <code>|</code> (binary OR) can be used:</p> Flag Description <code>FG_APC_DEFAULTS</code> Default handling in the acquisition loop <code>FG_APC_BATCH_FRAMES</code> Only the newest image may be delivered in a single call to the callback function if multiple images were received <code>FG_APC_DELIVER_ERRORS</code> Delivers errors to callback function as negative frameindex_t values <code>FG_APC_IGNORE_TIMEOUTS</code> Ignores image timeouts and continue processing <code>FG_APC_IGNORE_APCFUNC_RETURN</code> Ignores the callback return value and continue processing <code>FG_APC_IGNORE_STOP</code> Ignores when the acquisition is stopped and continue processing <code>FG_APC_HIGH_PRIORITY</code> Increases the priority of the thread implementing the acquisition loop. To use this value, elevated privileges of your operating system are required. <code>FG_APC_OLD_ACQ_BLOCK_BEHAVIOR</code> Uses <code>Fg_getLastPicNumberBlockingEx()</code> in ACQ_BLOCK<sup>c</sup> <p>The default handling for the acquisition loop is:</p> <ul> <li>Every single image is delivered to the callback function</li> <li>Error values aren't delivered to the callback function</li> <li>An image timeout ends the acquisition loop</li> <li>A non-zero return value from the callback function ends the acquisition loop</li> <li>Stopping the acquisition ends the acquisition loop</li> <li>The acquisition loop runs in a thread with the default priority</li> <li>The function <code>Fg_getLastPicNumberBlockingEx()</code> is called, and the result is delivered to the callback function</li> </ul> <p>Info</p> <p>Ending the acquisition loop will unregister the callback function automatically. While it may seem logical to always end the acquisition loop when the acquisition is stopped, this isn't necessarily the case. Consider for example, if the application requires to run the acquisition in bursts of a certain number of images by calling Fg_AcquireEx with a finite number of frames to acquire. After the number of frames is acquired, the acquisition is automatically stopped by the driver. It might be convenient to keep the acquisition loop running and start acquisition bursts from a separate thread.</p> <p>Info</p> <p>Setting <code>FG_APC_HIGH_PRIORITY</code> is only possible when the process has the necessary privileges to change the thread priority. Consult the documentation on privileges and rights management for the operating system used. For applications using Microsoft Windows, the function <code>SetThreadPriority</code> is used. On Linux, the function <code>pthread_setschedparam</code> is used.</p> <p>The following example shows how to register a callback function using a simple structure which holds information necessary for handling image acquisition:</p> <pre><code>struct ApcUserCallbackData\n{\n    Fg_Struct * fg;\n    dma_mem * mem;\n    unsigned int dma;\n    unsigned int timeoutInSeconds;\n    int mode;\n};\n\nint ApcUserCallback(frameindex_t frame, void * data)\n{\n    auto context = reinterpret_cast&lt;ApcUserCallbackData *&gt;(data);\n\n    if (frame &gt; 0) {\n        // process new image ...\n    } else {\n        // handle error ...\n    }\n\n    return 0;\n}\n\nvoid SetupApcUserCallback(ApcUserCallbackData * context)\n{\n    // register callback function\n    int result =\n        Fg_registerApcHandlerEx(\n            context-&gt;fg,\n            context-&gt;dma,\n            &amp;ApcUserCallback,\n            context,\n            context-&gt;timeoutInSeconds,\n            FG_APC_DELIVER_ERRORS | FG_APC_IGNORE_TIMEOUTS);\n    if (result != FG_OK) {\n        throw std::runtime_error(\"Failed to register callback function\");\n    }\n}\n</code></pre> <p>The allocation and management of the context structure isn't shown in the example. The pointer has to be valid while the callback function remains registered. One solution can be to keep everything together in a C++ class. To use a callback function in a C++ class context, a static function can be used to register the callback handler, and the <code>this</code> pointer should be used as context data pointer which can be casted back to a class pointer and used accordingly.</p> <p>After the callback function is no longer needed, it can be unregistered by calling <code>Fg_unregisterApcHandler()</code> using the same frame grabber handle and DMA channel:</p> <pre><code>Fg_unregisterApcHandler(context-&gt;fg, context-&gt;dma);\n</code></pre>"},{"location":"fglib5.html#starting-the-acquisition","title":"Starting the Acquisition","text":"<p>To enable transferring image data from the frame grabber to the application memory, the acquisition in the applet has to be started. This will inform the frame grabber about the frame buffers into which image data should be transferred and enable sending interrupts to the driver whenever the data for a new image has been successfully transferred. In most cases after starting the acquisition on the side of the frame grabber, you also have to start the acquisition on the side of the camera and start triggering the camera.</p> <p>See The Camera Control Library siso_genicam or The CameraLink Serial Interface Library clsersis for further information about controlling a camera. While triggering the camera is beyond the scope of this documentation, the documentation for the applet will give more information about the options the application has for triggering the camera through software or hardware signals to the frame grabber.</p>"},{"location":"fglib5.html#image-acquisition-using-basic-memory-management-not-recommended","title":"Image Acquisition Using Basic Memory Management (Not Recommended)","text":"<pre><code>int Fg_Acquire(\n    Fg_Struct * fg,\n    unsigned int dma,\n    frameindex_t frames);\n\nint Fg_stopAcquire(\n    Fg_Struct * fg,\n    unsigned int dma);\n</code></pre> <p>The functions <code>Fg_Acquire()</code> and <code>Fg_stopAcquire()</code> can be used only in combination with the memory management functions <code>Fg_AllocMem()</code> and <code>Fg_FreeMem()</code> and are limited to using the standard acquisition model <code>ACQ_STANDARD</code>. Using these functions isn't recommended and will not be documented. Instead the functions <code>Fg_AcquireEx()</code> and <code>Fg_stopAcquireEx()</code> should be used.</p>"},{"location":"fglib5.html#image-acquisition-using-advanced-or-flexible-memory-management","title":"Image Acquisition Using Advanced or Flexible Memory Management","text":"<pre><code>int Fg_AcquireEx(\n    Fg_Struct * fg,\n    unsigned int dma,\n    frameindex_t frames,\n    int flags,\n    dma_mem * mem);\n\nint Fg_stopAcquireEx(\n    Fg_Struct * fg,\n    unsigned int dma,\n    dma_mem * mem,\n    int flags);\n</code></pre> <p>The function <code>Fg_AcquireEx()</code> can be called to start the image acquisition on a single DMA channel on a frame grabber. This call will tie a DMA channel <code>dma</code> to a memory handle <code>mem</code> and thus will use the memory allocated for receiving image data.</p> <p>The acquisition will run until the number of frames given through the parameter <code>frames</code> is reached. If <code>GRAB_INFINITE</code> is passed to <code>frames</code>, the acquisition will run indefinitely. Through the parameter <code>flags</code>, the acquisition model can be selected. See section Acquisition Models for more information.</p> Model Description ACQ_STANDARD continuous acquisition with no frame buffer protection ACQ_BLOCK continuous acquisition with frame buffer blocking ACQ_SELECT fully application controlled acquisition with manual frame buffer handling <p>When specifying a number of frames to acquire in the call to <code>Fg_AcquireEx()</code>, the acquisition will be stopped automatically when the Framegrabber SDK encounters the expected number of frames. In some cases this can lead to unexpected behavior when processing the last frame. To avoid this, in addition to the acquisition model, <code>ACQ_NO_AUTOSTOP</code> can be specified in the parameter <code>flags</code>. When <code>ACQ_NO_AUTOSTOP</code> is used, the driver will stop acquiring frames when the requested number of frames is reached, but the rest of the Framegrabber SDK and the frame grabber remain in acquisition mode until <code>Fg_stopAcquireEx()</code> is called.</p> <p>To stop the acquisition and to reset the running state of the applet used, the function <code>Fg_stopAcquireEx()</code> should be called. Through the parameter <code>flags</code>, the stop mode can be selected:</p> Mode Description STOP_ASYNC stop the acquisition immediately STOP_SYNC_TO_APC synchronize stopping the acquisition in asynchronous mode to the callback functionthe time to wait for the callback to finish in milliseconds can be set using the parameter FG_APC_STOP_TIMEOUT STOP_SYNC synchronize stopping the acquisition with the driverthe time to wait for the next image to finish transferring in seconds can be set using the parameter FG_STOP_TIMEOUT STOP_ASYNC_FALLBACK can be used together with STOP_SYNCif the stop could not be synchronized, fall back to STOP_ASYNC"},{"location":"fglib5.html#writing-an-acquisition-loop-for-synchronous-mode","title":"Writing an Acquisition Loop for Synchronous Mode","text":"<p>In synchronous mode, the application has to handle receiving new images. This is usually done in the form of an acquisition loop which calls one of the functions provided by the Framegrabber API which wait for new images to be transferred on a specific DMA channel. To understand which function to use, see section Acquisition Models for more information. For each model, an example acquisition loop is given in the corresponding subsection.</p>"},{"location":"fglib5.html#waiting-for-images-using-basic-memory-management-not-recommended","title":"Waiting for Images Using Basic Memory Management (Not Recommended)","text":"<pre><code>frameindex_t Fg_getLastPicNumberBlocking(\n    Fg_Struct * fg,\n    frameindex_t frame,\n    unsigned int dma,\n    int timeout);\n</code></pre> <p>The function <code>Fg_getLastPicNumberBlocking()</code> can be used only in combination with the function <code>Fg_Acquire()</code> and is limited to the standard acquisition model <code>ACQ_STANDARD</code>. Using this function isn't recommended and will not be documented. Instead the functions <code>Fg_getLastPicNumberBlockingEx()</code> or <code>Fg_getImageEx()</code> should be used.</p>"},{"location":"fglib5.html#waiting-for-images-using-advanced-or-flexible-memory-management","title":"Waiting for Images Using Advanced or Flexible Memory Management","text":"<pre><code>frameindex_t Fg_getLastPicNumberBlockingEx(\n    Fg_Struct * fg,\n    frameindex_t frame,\n    unsigned int dma,\n    int timeout,\n    dma_mem * mem);\n\nframeindex_t Fg_getImageEx(\n    Fg_Struct * fg,\n    int strategy,\n    frameindex_t frame,\n    unsigned int dma,\n    unsigned int timeout,\n    dma_mem * mem);\n</code></pre> <p>The function <code>Fg_getLastPicNumberBlockingEx()</code> waits for the frame requested in the parameter <code>frame</code> to arrive within the number of seconds given in the parameter <code>timeout</code> on a given DMA channel as specified in the parameter <code>dma</code>. The first frame is numbered 1, not 0. The function returns a frame number larger than 0 in case of success, or a negative error code in case of a failure.</p> <p>Info</p> <p>The frame number returned can be larger than the frame number which was requested, as the function will always return the newest frame number available. This means that between two calls to the function, more than one frame might have arrived and the application needs to decide if only the newest frame or all frames should be processed.</p> <p>The following example shows a simple acquisition loop for <code>ACQ_STANDARD</code>:</p> <pre><code>const int timeoutInSeconds = 10;\n\nframeindex_t nextFrame = 1;\nwhile (true) {\n    // get new image\n    const frameindex_t newestFrame =\n        Fg_getLastPicNumberBlockingEx(fg, nextFrame, dma,\n                                      timeoutInSeconds, mem);\n\n    if (newestFrame &gt; 0) {\n        // process new images ...\n\n        nextFrame = (newestFrame &lt; FRAMEINDEX_MAX) ? newestFrame + 1 : 1;\n    } else {\n        // handle error ...\n    }\n}\n</code></pre> <p>The function <code>Fg_getImageEx()</code> is much more complex. The behavior of the function and the meaning of the return code in case of success depend on the parameters <code>strategy</code> and <code>timeout</code> and on the acquisition model in use. In case of an error, the result will always be a negative error code. A short description of the different strategies will be given below, but generally the use of the function should be limited to the use cases described in section The Blocking Acquisition Model. Any other use of the function is discouraged and will not be discussed in further detail in the context of this document.</p> <p><code>SEL_NEW_IMAGE</code>: The function requires a timeout to be specified and waits for at least one new image to arrive. In <code>ACQ_STANDARD</code> and <code>ACQ_SELECT</code> the frame number of the newest image is returned. In <code>ACQ_BLOCK</code>, the function blocks the frame buffer for the newest image, unblocks any frame buffers of additional images, and returns the buffer number of the blocked image.</p> <p><code>SEL_NEXT_IMAGE</code>: In <code>ACQ_STANDARD</code>, if no timeout is specified, the function will return the buffer number of the newest image received. If a timeout is specified, the function will wait for the next frame after the last one which was received in a previous call to the function, or frame number 1 if the function was not called previously. The function will return the frame number of the newest image received. In <code>ACQ_BLOCK</code>, the function blocks the frame buffer of the first image received which has not been blocked or unblocked yet and returns the buffer number of the blocked image. If no more images can be blocked and a timeout was specified, the function waits for at least one new image to arrive before performing the blocking operation.</p> <p><code>SEL_ACT_IMAGE</code>: In <code>ACQ_STANDARD</code>, the function behaves the same was as when <code>SEL_NEXT_IMAGE</code> is specified. In <code>ACQ_BLOCK</code>, the function blocks the frame buffer for the newest image, unblocks any frame buffers of additional images, and returns the buffer number of the blocked image. If no more images can be blocked and a timeout was specified, the function waits for at least one new image to arrive before performing the blocking operation.</p> <p><code>SEL_LAST_IMAGE</code>: The function returns the last value returned by the function, or by <code>Fg_getLastPicNumberBlockingEx()</code>. This is either the last frame number, or buffer number, depending on how the function was called last time.</p> <p><code>SEL_NUMBER</code>: The function mimics the behavior of <code>Fg_getLastPicNumberBlockingEx()</code>.</p> <p>The following example shows a simple acquisition loop for <code>ACQ_BLOCK</code> using <code>SEL_NEXT_IMAGE</code> (every image acquired is processed):</p> <pre><code>const int timeoutInSeconds = 10;\n\nwhile (true) {\n    // get new image\n    const frameindex_t buffer =\n        Fg_getImageEx(fg, SEL_NEXT_IMAGE, 0, dma, timeoutInSeconds, mem);\n\n    if (buffer &gt; 0) {\n        // process new image ...\n    } else {\n        // handle error ...\n    }\n}\n</code></pre>"},{"location":"fglib5.html#the-driver-image-acquisition-timeout-fg_timeout","title":"The Driver Image Acquisition Timeout FG_TIMEOUT","text":"<p>In addition to specifying a time to wait for images when calling the functions <code>Fg_getImageEx()</code> or <code>Fg_getLastPicNumberBlockingEx()</code>, or when setting up a callback function for the asynchronous mode, the driver also keeps track of the image acquisition in the context of handling image transfer interrupts. The driver will stop the image acquisition if no image data is received during the number of seconds specified in the parameter <code>FG_TIMEOUT</code>. If <code>FG_TIMEOUT</code> is set to <code>FG_TIMEOUT_INFINITE</code> (the value of <code>FG_TIMEOUT_INFINITE</code> is <code>INT_MAX</code> - 1) the driver will not stop the acquisition regardless of the time span between receiving two images.</p> <p>The value of the parameter <code>FG_TIMEOUT</code> is forwarded to the driver when the acquisition is started. Any change to the parameter after the start of the acquisition will not be taken into account by the driver until the acquisition is stopped and started again.</p> <p>After the driver has stopped the acquisition, any function call still waiting for images will return <code>FG_TIMEOUT_ERR</code> and any function called to wait for images after the acquisition was stopped will return <code>FG_TRANSFER_NOT_ACTIVE</code>.</p> <p>Info</p> <p>The default value for the parameter <code>FG_TIMEOUT</code> is not <code>FG_TIMEOUT_INFINITE</code>, but in most cases is set to 1000000 seconds (this equals about 277 hours and 46 minutes). It is recommended to explicitly set the parameter <code>FG_TIMEOUT</code> to <code>FG_TIMEOUT_INFINITE</code> before starting the acquisition.</p> <p>The following example shows how to disable the driver image acquisition timeout:</p> <pre><code>Fg_setParameterWithType(fg, FG_TIMEOUT, FG_TIMEOUT_INFINITE, dma);\n</code></pre>"},{"location":"fglib5.html#frame-and-acquisition-information","title":"Frame and Acquisition Information","text":"<pre><code>int Fg_getParameterEx(\n    Fg_Struct * fg,\n    int param,\n    void * value,\n    unsigned int dma,\n    dma_mem * mem,\n    frameindex_t frame);\n\nvoid * Fg_getImagePtrEx(\n    Fg_Struct * fg,\n    frameindex_t frame,\n    unsigned int dma,\n    dma_mem * mem);\n\nframeindex_t Fg_getStatusEx(\n    Fg_Struct * fg,\n    int status,\n    frameindex_t frame,\n    unsigned int dma,\n    dma_mem * mem);\n</code></pre> <p>For each frame received, the following information can be requested by calling the function <code>Fg_getParameterEx()</code>:</p> Parameter Description Type FG_TRANSFER_LEN The actual number of bytes transferred size_t FG_TIMESTAMP_LONG High resolution timestamp of the image uint64_t FG_TIMESTAMP_LONG_FREQUENCY High resolution timestamp frequency uint64_t FG_TIMESTAMP Timestamp of the image in milliseconds uint32_t FG_IMAGE_TAG Image tag uint32_t FG_IMAGE_NUMBER Frame number uint64_t <p>Info</p> <p>The frame number information was added in version 5.9 of the Framegrabber SDK.</p> <p>The information for each frame isn't available indefinitely, but is only valid as long as the corresponding buffer has not been queued for subsequent transfers. Depending on the acquisition model used, the function requires a frame number or a buffer number. See section Acquisition Models for more details.</p> <p>The following example shows how to request the timestamp for a given frame:</p> <pre><code>// get time stamp frequency\nuint64_t frequency = 0;\nFg_getParameterEx(fg, FG_TIMESTAMP_LONG_FREQUENCY, &amp;frequency, 0, nullptr, 0);\n\n// ...\n\n// get frame time stamp\nuint64_t timestamp = 0\nint result =\n    Fg_getParameterEx(fg, FG_TIMESTAMP_LONG, &amp;timestamp, dma, mem, frame);\nif (result == FG_OK) {\n    // this will probably be 'seconds since booting the computer' ...\n    // it makes more sense when you calculate the difference\n    // between timestamps of two frames\n    double seconds =\n        static_cast&lt;double&gt;(timestamp)/static_cast&lt;double&gt;(frequency);\n\n    // ...\n}\n</code></pre> <p>To get a pointer to a frame buffer, the function <code>Fg_getImagePtrEx()</code> can be called. The pointer for each frame isn't available indefinitely, but is only valid as long as the corresponding buffer has not been queued for subsequent transfers. Depending on the acquisition model used, the function requires a frame number or a buffer number. See section Acquisition Models for more details.</p> <p>The following example shows how to request the frame buffer pointer for a given frame:</p> <pre><code>// get a pointer to the frame buffer for the newest image\nvoid * buffer = Fg_getImagePtrEx(fg, frame, dma, mem);\n\n// get the actual number of bytes transferred\nsize_t length = 0;\nint result =\n    Fg_getParameterEx(fg, FG_TRANSFER_LEN, &amp;length, dma, mem, frame);\n\nif ((buffer != nullptr) &amp;&amp; (result == FG_OK) &amp;&amp; (length &gt; 0)) {\n        // process image data ...\n}\n</code></pre> <p>The function <code>Fg_getStatusEx()</code> can be called to request the following general status information, the parameter <code>frame</code> will be ignored for these:</p> Status Description NUMBER_OF_GRABBED_IMAGES the total number of frames transferred NUMBER_OF_LAST_IMAGE the last frame number reported by <code>Fg_getLastPicNumberBlockingEx()</code> NUMBER_OF_NEXT_IMAGE the frame number of the next frame after the last one reported GRAB_ACTIVE 0: the DMA channel isn't active1: the DMA channel is active <p>The following example shows how to request the acquisition status for a DMA channel:</p> <pre><code>frameindex_t active =\n    Fg_getStatusEx(fg, GRAB_ACTIVE, 0, dma, mem);\nif (active == 1) {\n    // the DMA channel is active ...\n} else if (active == 0) {\n    // the DMA channel is inactive ...\n} else {\n    // handle error ...\n}\n</code></pre>"},{"location":"fglib5.html#acquisition-models","title":"Acquisition Models","text":"<p>The Framegabber API provides three different acquisition models, which can be selected when calling <code>Fg_AcquireEx()</code>: standard, blocking and selective. All three acquisition models are based on the memory model explained in chapter Memory Management which uses at least two frame buffers for acquiring images.</p> <p>For the examples in this section, a memory buffer which consists of four frame buffers contiguous in virtual memory will be used.</p> <p></p>"},{"location":"fglib5.html#frame-numbers-and-buffer-numbers","title":"Frame Numbers and Buffer Numbers","text":"<p>Throughout the Framegrabber API, frame numbers and buffer numbers are used, both of which are of type <code>frameindex_t</code>.</p> <p>While frame numbers are strictly monotonic increasing natural numbers in the range of <code>[1; FRAMEINDEX_MAX]</code>, referring to the number of images acquired since the start of the acquisition, the type <code>frameindex_t</code> used for frame numbers is a signed type and is used to return negative error codes as well as frame numbers every so often in the API. Especially in 32-bit applications, care must be taken to handle the overflow of the frame number correctly: once <code>FRAMEINDEX_MAX</code> has been reached, image counting will wrap to 1! (In 64-bit applications even with extremely high frame rates, overflow of the image counter will happen only after hundreds of thousands of years.)</p> <p>The buffer number in contrast refers to the frame buffer in which image data resides, and for N buffers is in the range of <code>[1; N]</code>. In the examples used here, the buffer number is between 1 \u2026 4 and refers to <code>FB0</code> \u2026 <code>FB3</code> accordingly.</p>"},{"location":"fglib5.html#the-standard-acquisition-model-acq_standard","title":"The Standard Acquisition Model (ACQ_STANDARD)","text":"<pre><code>frameindex_t Fg_getLastPicNumberBlockingEx(\n    Fg_Struct * fg,\n    frameindex_t frame,\n    unsigned int dma,\n    int timeout,\n    dma_mem * mem);\n</code></pre> <pre><code>int Fg_getParameterEx(\n    Fg_Struct * fg,\n    int param,\n    void * value,\n    unsigned int dma,\n    dma_mem * mem,\n    frameindex_t frame);\n\nvoid * Fg_getImagePtrEx(\n    Fg_Struct * fg,\n    frameindex_t frame,\n    unsigned int dma,\n    dma_mem * mem);\n</code></pre> <p>The standard acquisition model is selected by passing <code>ACQ_STANDARD</code> to <code>flags</code> in the call to <code>Fg_AcquireEx()</code>. All frame buffers are always accessible both by the driver for acquiring image data and by the application to process image data.</p> <p>When acquisition is started, the driver queues at least one frame buffer in the frame grabber for image data transfer, starting with the first frame buffer <code>FB0</code>. Once an image has been transferred completely to the computer memory, the software is informed of the completed transfer, and the driver will queue one more frame buffer. The frame grabber will continue data transfer for the next image into the next buffer in the queue, in our example <code>FB1</code>.</p> <p>(The number of frame buffers queued depends on various factors, like the frame grabber used, the driver version, and settings in the Windows registry or parameters to the Linux driver. However, in standard acquisition mode, queueing will always be in a linear manner and will start with <code>FB0</code> again after the last frame buffer has been queued. While the number of buffers queued can have an effect on the maximum frame rate which can be achieved in a computer, this effect will only be measurable above ~10.000 frames per second.)</p> <p>Because the driver uses frame buffers in a consistent circular manner, frame numbers can be naively translated to buffer numbers using the relation <code>bufferNumber = 1 + ((frameNumber - 1) % numberOfBuffers)</code>. The function <code>Fg_getImagePtrEx()</code> can be used to get a pointer to the frame buffer for either a frame number, or a buffer number.</p> <p>In the standard acquisition model the application is fully responsible for ensuring that image acquisition will not \"overrun\" image processing. This can only be ensured if triggering the image source is controlled from the application in combination with the image processing, or in which the number of buffers are carefully tuned to the frame rate and the performance of the computer system used, or in which images can be skipped.</p> <p>In a scenario, where the application triggers only a single image while a previous image is still being processed, two buffers are sufficient, one for the image data being processed and one for transferring image data to. (If the application would make sure that triggers are only generated after an image has been completely processed, actually one buffer would be sufficient for processing. This is however not supported by the Framegrabber API, and the application has to allocate two buffers at least in all cases.)</p> <p>In a scenario, where images are generated continuously without control from the application side, both the image source and the buffer handling in the driver can be considered free running. In the following example, <code>FB0</code> and <code>FB1</code> contain valid image data. <code>FB0</code> is being processed by the application, <code>FB1</code> is pending processing. The driver has queued at least <code>FB2</code> and image data is currently being transferred. This situation is still safe, because <code>FB3</code> isn't in use yet, even though it might be queued already.</p> <p></p> <p>Calling the function <code>Fg_getLastPicNumberBlockingEx()</code> for the next frame number after processing <code>FB0</code> is finished would return a single new frame (the frame number for the image transferred to <code>FB1</code>) in this case if the transfer to <code>FB2</code> has not finished in the meantime.</p> <p>If image processing is slower than image acquisition, the application might have moved on to process <code>FB1</code>. However, in the following example in the meantime two more images were transferred, <code>FB2</code> and <code>FB3</code>, and the driver has started again with <code>FB0</code>. When the image transfer completes, the driver will use <code>FB1</code>, and thus the frame grabber might overwrite data which is currently being processed. This scenario is only safe, if the application can make sure that no image data is being generated by the image source while <code>FB1</code> is still being processed.</p> <p></p> <p>Calling the function <code>Fg_getLastPicNumberBlockingEx()</code> for the next frame number after processing <code>FB0</code> is finished would return two new frames (the frame number for the image transferred to <code>FB3</code>) in this case if the transfer to <code>FB0</code> has not finished in the meantime.</p> <p>The following example extends the structure of the acquisition loop given in section Writing an Acquisition Loop to process all frames:</p> <pre><code>const int timeoutInSeconds = 10;\n\nframeindex_t nextFrame = 1;\nwhile (true) {\n    // get new image\n    const frameindex_t newestFrame =\n        Fg_getLastPicNumberBlockingEx(fg, nextFrame, dma,\n                                      timeoutInSeconds, mem);\n\n    if (newestFrame &gt; 0) {\n        for (frameindex_t frame = nextFrame; frame &lt;= newestFrame; ++frame) {\n                // get a pointer to the frame buffer for the newest image\n                void * ptr =\n                    Fg_getImagePtrEx(fg, frame, dma, mem);\n\n            // get the actual number of bytes transferred\n            size_t length = 0;\n            int result =\n                Fg_getParameterEx(fg, FG_TRANSFER_LEN, &amp;length,\n                                  dma, mem, frame);\n\n            if ((ptr != nullptr) &amp;&amp; (result == FG_OK) &amp;&amp; (length &gt; 0)) {\n                    // process image data ...\n            }\n        }\n\n        nextFrame = (newestFrame &lt; FRAMEINDEX_MAX) ? newestFrame + 1 : 1;\n    } else {\n        // handle error ...\n    }\n}\n</code></pre> <p>If the application can skip images and only the newest frame received should be processed, the inner for-loop can be dropped from the acquisition loop, instead processing only <code>newestFrame</code>.</p> <p>The function <code>Fg_getImageEx()</code> should not be used in combination with the standard acquisition model.</p> <p>In asynchronous mode, the Framegrabber API will call <code>Fg_getLastPicNumberBlockingEx()</code> to wait for a new image, and will call the callback function once for the newest image if the flag <code>FG_APC_BATCH_FRAMES</code> was set, or multiple times if it was not set, once for each image received. The callback will receive a frame number for the image.</p> <p>To process frames in asynchronous mode, the content of the inner loop can be used in the callback function (ApcCallbackData is the structure as described in section Registering a Callback Function for Asynchronous Mode):</p> <pre><code>int ApcUserCallback(frameindex_t frame, void * data)\n{\n    auto context = reinterpret_cast&lt;ApcUserCallbackData *&gt;(data);\n\n    if (frame &gt; 0) {\n        // get a pointer to the frame buffer for the newest image\n        void * ptr =\n            Fg_getImagePtrEx(context-&gt;fg, frame, context-&gt;dma, context-&gt;mem);\n\n        // get the actual number of bytes transferred\n        size_t length = 0;\n        int result =\n            Fg_getParameterEx(context-&gt;fg, FG_TRANSFER_LEN, &amp;length,\n                              context-&gt;dma, context-&gt;mem, frame);\n\n        if ((ptr != nullptr) &amp;&amp; (result == FG_OK) &amp;&amp; (length &gt; 0)) {\n            // process image data ...\n        }\n    } else {\n        // handle error ...\n    }\n\n    return 0;\n}\n</code></pre> <p>This way, the callback function can be used both for processing only the newest image, when <code>FG_APC_BATCH_FRAMES</code> was passed in <code>flags</code> to <code>Fg_registerApcHandlerEx()</code>, as well as processing all images. The callback function will be called multiple times, once for each new image, when <code>FG_APC_BATCH_FRAMES</code> was not passed.</p>"},{"location":"fglib5.html#the-blocking-acquisition-model-acq_block","title":"The Blocking Acquisition Model (ACQ_BLOCK)","text":"<pre><code>frameindex_t Fg_getImageEx(\n    Fg_Struct * fg,\n    int strategy,\n    frameindex_t frame,\n    unsigned int dma,\n    unsigned int timeout,\n    dma_mem * mem);\n</code></pre> <pre><code>int Fg_getParameterEx(\n    Fg_Struct * fg,\n    int param,\n    void * value,\n    unsigned int dma,\n    dma_mem * mem,\n    frameindex_t buffer);\n\nvoid * Fg_getImagePtrEx(\n    Fg_Struct * fg,\n    frameindex_t buffer,\n    unsigned int dma,\n    dma_mem * mem);\n\nframeindex_t Fg_getStatusEx(\n    Fg_Struct * fg,\n    int status,\n    frameindex_t buffer,\n    unsigned int dma,\n    dma_mem * mem);\n</code></pre> <pre><code>int Fg_setStatusEx(\n    Fg_Struct * fg,\n    int status,\n    frameindex_t buffer,\n    unsigned int dma,\n    dma_mem * mem);\n</code></pre> <p>Info</p> <p>The behavior when using asynchronous mode in the blocking acquisition model <code>ACQ_BLOCK</code> was changed in version 5.9 of the Framegrabber API.</p> <p>The blocking acquisition model is selected by passing <code>ACQ_BLOCK</code> to <code>flags</code> in the call to <code>Fg_AcquireEx()</code>. Each frame buffer is either exclusively accessible by the driver for acquiring image data or queued or blocked for the application to process image data. Using frame buffers is always safe as long as they are blocked, but images may be lost when the driver encounters a situation where no more unblocked buffers are available for image data transfer.</p> <p>When acquisition is started, the driver queues at least one frame buffer in the frame grabber for image data transfer, starting with the first frame buffer <code>FB0</code>. Once an image has been transferred completely to the computer memory, the software is informed of the completed transfer, the frame buffer is queued for the application and the driver will not use it until the application has explicitly or implicitly unblocked it. The driver will queue one more frame buffer in the frame grabber as long as one or more unblocked frame buffers are available. If no more unblocked frame buffers are available, a special frame buffer called dummy buffer is queued in the frame grabber to keep image acquisition always running. The frame grabber will continue data transfer for the next image into the next buffer in the queue, in our example this would be <code>FB1</code>.</p> <p>(As mentioned in subsection The Standard Acquisition Model, the number of frame buffers queued in the frame grabber depends on various factors.)</p> <p>The dummy frame buffer can be considered infinitely large and can absorb data of arbitrary size, however not in a meaningful way for processing an image. Because of this, the dummy buffer isn't accessible to the application, and any image transferred to the dummy buffer will be lost. Because queueing the next buffer happens automatically each time a frame is transferred, this means that automatically at least one image will be lost if no unblocked frame buffers are available to the driver for queueing. This is true even if the data source is stopped and started again only after a frame buffer becomes available again!</p> <p>In synchronous mode, the function <code>Fg_getImageEx()</code> should be called to request and block one frame buffer for newly acquired images. The function will return a buffer number for the blocked frame buffer. The following strategies are relevant to the blocking acquisition model:</p> Strategy Description SEL_NEXT_IMAGE returns the buffer number for the next framethis strategy is used to process each single frame, one after the other in the order they were transferred SEL_ACT_IMAGE returns the buffer number for the newest framethis strategy is used to allow skipping frames when image processing is slower than the acquisition frame rate <p>The list above isn't complete, and only contains the strategies relevant to the blocking acquisition model.</p> <p>If <code>SEL_NEXT_IMAGE</code> is used, only the next frame buffer will be blocked, all others remain queued for the application to be requested at a later point. If <code>SEL_ACT_IMAGE</code> is used, only the newest frame buffer will be blocked, all other frame buffers which are queued for the application will be removed from the queue and unblocked implicitly.</p> <p>When calling the function <code>Fg_getImageEx()</code> using this model, 0 should always be passed to <code>frame</code>. The function can't be used to wait for a specific frame number or to translate frame numbers into buffer numbers. To get the frame number for a frame buffer, the function <code>Fg_getParameterEx()</code> can be called passing <code>FG_IMAGE_NUMBER</code> in the parameter <code>param</code>, a pointer to a variable of type <code>frameindex_t</code> for the frame number and the buffer number in the parameter <code>buffer</code>.</p> <p>The function <code>Fg_getStatusEx()</code> can be called to request the following status information relevant for the blocking acquisition model:</p> Status Description NUMBER_OF_LOST_IMAGES the number of frames lost NUMBER_OF_BLOCKED_IMAGES the number of frames currently blocked NUMBER_OF_IMAGES_IN_PROGRESS the number of frames available through <code>Fg_getImageEx()</code> BUFFER_STATUS 0: the frame buffer isn't blocked1: the frame buffer is blocked <p>The function <code>Fg_setStatusEx()</code> can be called to unblock frame buffers after they were requested an blocked by a previous call to <code>Fg_getImageEx()</code>:</p> Status Description FG_UNBLOCK unblock a single frame buffer FG_UNBLOCK_ALL unblock all currently blocked buffers <p><code>FG_UNBLOCK_ALL</code> will also remove any buffers still queued for the application which have not yet been requested and blocked.</p> <p>When using the function <code>Fg_AcquireEx()</code> to specify a number of images to be grabbed, lost images are considered as well as images delivered successfully. This may lead to unexpected <code>FG_TIMEOUT_ERR</code> or <code>FG_TRANSFER_NOT_ACTIVE</code> results when calling <code>Fg_getImageEx()</code> and only counting delivered images in the acquisition loop.</p> <p>In a scenario, where the application triggers only a single image while a previous image is still being processed, two buffers are sufficient, one for the image data being processed and one for transferring image data to. (Due to buffer locking taking place, even if the application would make sure that triggers are only generated after an image has been completely processed, two buffers are required at least in all cases.)</p> <p>In a scenario, where images are generated continuously without control from the application side, the image source can be considered free running. The driver however will only be able to deliver images to the application while there are still unblocked buffers available. In the following example, <code>FB0</code> and <code>FB1</code> contain valid image data. <code>FB0</code> is being processed by the application, <code>FB1</code> is pending processing. The driver has queued at least <code>FB2</code> and image data is currently being transferred. This situation is still safe, because <code>FB3</code> isn't in use yet, even though it might be queued already.</p> <p></p> <p>If image processing is slower than image acquisition, the application might have finished processing <code>FB0</code>, unblocked it and moved on to process <code>FB1</code>. However, in the following example in the meantime two more images were transferred, <code>FB2</code> and <code>FB3</code>, and the driver has started again with <code>FB0</code>. When the image transfer completes, if the application hasn't finished processing <code>FB1</code> and unlocked it, the driver will have no more free buffers available for queueing. The dummy buffer will be queued, and at least one image will be lost in the acquisition, but data integrity of the frame buffers not yet unblocked will be kept.</p> <p></p> <p>The following example extends the structure of the acquisition loop given in section Writing an Acquisition Loop to process all frames:</p> <pre><code>const int timeoutInSeconds = 10;\nwhile (true) {\n    // get new image\n    frameindex_t buffer =\n        Fg_getImageEx(fg, SEL_NEXT_IMAGE, 0, dma, timeoutInSeconds, mem);\n\n    if (buffer &gt; 0)\n        // get the frame number (if needed)\n        uint64_t frame = 0;\n        Fg_getParameterEx(fg, FG_IMAGE_NUMBER, &amp;frame, dma, mem, buffer);\n\n        // get a pointer to the frame buffer for the newest image\n        void * ptr = Fg_getImagePtrEx(fg, buffer, dma, mem);\n\n        // get the actual number of bytes transferred\n        size_t length = 0;\n        int result =\n            Fg_getParameterEx(fg, FG_TRANSFER_LEN, &amp;length, dma, mem, buffer);\n\n        if ((ptr != nullptr) &amp;&amp; (result == FG_OK) &amp;&amp; (length &gt; 0)) {\n            // process image data ...\n        }\n\n        // unblock frame buffer\n        Fg_setStatusEx(fg, FG_UNBLOCK, buffer, dma, mem);\n    } else {\n        // handle error ...\n    }\n}\n</code></pre> <p>The function <code>Fg_getLastPicNumberBlockingEx()</code> should not be used in combination with the blocking acquisition model.</p> <p>In asynchronous mode, the Framegrabber API will call <code>Fg_getImageEx()</code> using <code>SEL_ACT_IMAGE</code> if the flag <code>FG_APC_BATCH_FRAMES</code> was set, or using <code>SEL_NEXT_IMAGE</code> if it was not set. The callback function will receive a buffer number for the image.<sup>c</sup></p> <p>To process frames in asynchronous mode, the if-clause can be used in the callback function (ApcUserCallbackData is the structure as described in section Registering a Callback Function for Asynchronous Mode):</p> <pre><code>int ApcUserCallback(frameindex_t buffer, void * data)\n{\n    auto context = reinterpret_cast&lt;ApcUserCallbackData *&gt;(data);\n\n    if (buffer &gt; 0) {\n        // get the frame number (if needed)\n        uint64_t frame = 0;\n        Fg_getParameterEx(fg, FG_IMAGE_NUMBER, &amp;frame, dma, mem, buffer);\n\n        // get a pointer to the frame buffer for the newest image\n        void * ptr =\n            Fg_getImagePtrEx(context-&gt;fg, buffer, context-&gt;dma, context-&gt;mem);\n\n        // get the actual number of bytes transferred\n        size_t length = 0;\n        int result =\n            Fg_getParameterEx(context-&gt;fg, FG_TRANSFER_LEN, &amp;length,\n                              context-&gt;dma, context-&gt;mem, buffer);\n\n        if ((ptr != nullptr) &amp;&amp; (result == FG_OK) &amp;&amp; (length &gt; 0)) {\n            // process image data ...\n        }\n\n        // unblock frame buffer\n        Fg_setStatusEx(fg, FG_UNBLOCK, buffer, dma, mem);\n    } else {\n        // handle error ...\n    }\n\n    return 0;\n}\n</code></pre> <p>This way, the callback function can be used both for processing only the newest image, when <code>FG_APC_BATCH_FRAMES</code> was passed in <code>flags</code> to <code>Fg_registerApcHandlerEx()</code>, as well as processing all images. The callback function will be called multiple times, once for each new image, when <code>FG_APC_BATCH_FRAMES</code> was not passed.</p>"},{"location":"fglib5.html#the-selective-acquisition-model-acq_select","title":"The Selective Acquisition Model ACQ_SELECT","text":"<pre><code>frameindex_t Fg_getLastPicNumberBlockingEx(\n    Fg_Struct * fg,\n    frameindex_t frame,\n    unsigned int dma,\n    int timeout,\n    dma_mem * mem);\n</code></pre> <pre><code>int Fg_getParameterEx(\n    Fg_Struct * fg,\n    int param,\n    void * value,\n    unsigned int dma,\n    dma_mem * mem,\n    frameindex_t frame);\n\nvoid * Fg_getImagePtrEx(\n    Fg_Struct * fg,\n    frameindex_t buffer,\n    unsigned int dma,\n    dma_mem * mem);\n</code></pre> <pre><code>int Fg_setStatusEx(\n    Fg_Struct * fg,\n    int status,\n    frameindex_t buffer,\n    unsigned int dma,\n    dma_mem * mem);\n</code></pre> <p>Info</p> <p>The selective acquisition model <code>ACQ_SELECT</code> was added in version 5.9 of the Framegrabber SDK.</p> <p>The selective acquisition model is selected by passing <code>ACQ_SELECT</code> to <code>flags</code> in the call to <code>Fg_AcquireEx()</code>. The application has full control over the use of frame buffers by the driver.</p> <p>Frame buffers have to be selected explicitly for queueing in the frame grabber, and the driver will queue frame buffers in the exact order they were selected. When acquisition is started, the driver queues frame buffers in the frame grabber for image data transfer only if any frame buffers were selected, starting with the first frame buffer which was selected. Once an image has been transferred completely to the computer memory, the software is informed of the completed transfer, the frame buffer isn't considered selected anymore and the driver will not use it until it is selected explicitly again. The driver will queue one more frame buffers if available. If no more frame buffers are available, no frame buffer will be queued. The frame grabber will continue data transfer for the next image into the next buffer in the queue. If the queue in the frame grabber runs empty this may result in an internal buffer overflow and images might be lost.</p> <p>(As mentioned in subsection The Standard Acquisition Model, the number of frame buffers queued in the frame grabber depends on various factors.)</p> <p>Because the application has full control over the use of frame buffers, keeping track of the buffer numbers is also the responsibility of the application. Unless frame buffers are always selected in the same order, there is no naive way to translate frame numbers to buffer numbers. Also there is no API function to perform the translation.</p> <p>The function <code>Fg_setStatusEx()</code> can be called to select a frame buffer by using <code>FG_SELECT_BUFFER</code> and passing the buffer number.</p> <p>To keep things simple, in the following examples we assume that after starting the acquisition all four buffers <code>FB0</code> \u2026 <code>FB3</code> are selected in natural order. Further, after an image is transferred it is processed and the buffer selected again in order. This way, the sequence of buffers will always remain the same, and frame numbers can be naively translated to buffer numbers using the relation <code>bufferNumber = 1 + ((frameNumber - 1) % numberOfBuffers)</code>.</p> <p>In a scenario, where images are generated continuously without control from the application side, the image source can be considered free running. The driver however will only be able to deliver images to the application while there are still selected buffers available. In the following example, <code>FB0</code> and <code>FB1</code> contain valid image data and aren't selected. <code>FB0</code> is being processed by the application, <code>FB1</code> is pending processing. The driver has queued at least <code>FB2</code> and image data is currently being transferred. This situation is still safe, because <code>FB3</code> isn't in use yet, even though it might be queued already.</p> <p></p> <p>Calling the function <code>Fg_getLastPicNumberBlockingEx()</code> for the next frame number after processing <code>FB0</code> is finished would return a single new frame (the frame number for the image transferred to <code>FB1</code>) in this case if the transfer to <code>FB2</code> has not finished in the meantime.</p> <p>If image processing is slower than image acquisition, the application might have finished processing <code>FB0</code>, selected it and moved on to process <code>FB1</code>. However, in the following example in the meantime two more images were transferred, <code>FB2</code> and <code>FB3</code>, and the driver has started again with <code>FB0</code>. When the image transfer completes, if the application hasn't finished processing <code>FB1</code> and selected it, the driver will have no more free buffers available for queueing. As long as no further image arrives, this situation doesn't cause the same implicit image loss as would be encountered in <code>ACQ_BLOCK</code>. But as soon as another image is received, the internal memory buffers in the frame grabber can run into an overflow condition and data loss can occur.</p> <p></p> <p>The following example extends the structure of the acquisition loop given in section Writing an Acquisition Loop to process all frames:</p> <pre><code>const frameindex_t numberOfBuffers = 4;\nconst int timeoutInSeconds = 10;\n\nframeindex_t nextFrame = 1;\nwhile (true) {\n    // get new image\n    const frameindex_t newestFrame =\n        Fg_getLastPicNumberBlockingEx(fg, nextFrame, dma,\n                                      timeoutInSeconds, mem);\n\n    if (newestFrame &gt; 0) {\n        for (frameindex_t frame = nextFrame; frame &lt;= newestFrame; ++frame) {\n            // get the buffer number\n            frameindex_t buffer = 1 + ((frame - 1) % numberOfBuffers);\n\n            // get a pointer to the frame buffer for the newest image\n            void * ptr = Fg_getImagePtrEx(fg, buffer, dma, mem);\n\n            // get the actual number of bytes transferred\n            size_t length = 0;\n            int result =\n                Fg_getParameterEx(fg, FG_TRANSFER_LEN, &amp;length,\n                                  dma, mem, buffer);\n\n            if ((ptr != nullptr) &amp;&amp; (result == FG_OK) &amp;&amp; (length &gt; 0)) {\n                // process image data ...\n            }\n\n            // select frame buffer\n            Fg_setStatusEx(fg, FG_SELECT_BUFFER, buffer, dma, mem);\n        }\n\n        nextFrame = (newestFrame &lt; FRAMEINDEX_MAX) ? newestFrame + 1 : 1;\n    } else {\n        // handle error ...\n    }\n}\n</code></pre> <p>If the application can skip images and only the newest frame received should be processed, <code>Fg_setStatusEx()</code> has to be used with <code>FG_SELECT_BUFFER</code> to select buffers which were skipped. Otherwise the application will end up with unused buffers.</p> <p>The function <code>Fg_getImageEx()</code> should not be used in combination with the selective acquisition model.</p> <p>In asynchronous mode, the Framegrabber API will call <code>Fg_getLastPicNumberBlockingEx()</code> to wait for a new image, and will call the callback function once for the newest image if the flag <code>FG_APC_BATCH_FRAMES</code> was set, or multiple times if it was not set, once for each image received. The callback will receive a frame number for the image.</p> <p>To process frames in asynchronous mode, the content of the inner loop can be used in the callback function (ApcUserCallbackData is the structure as described in section Registering a Callback Function for Asynchronous Mode):</p> <pre><code>int ApcUserCallback(frameindex_t frame, void * data)\n{\n    auto context = reinterpret_cast&lt;ApcUserCallbackData *&gt;(data);\n\n    if (frame &gt; 0) {\n        // get the buffer number\n        frameindex_t buffer = 1 + ((frame - 1) % numberOfBuffers);\n\n        // get a pointer to the frame buffer for the newest image\n        void * ptr = Fg_getImagePtrEx(fg, buffer, dma, mem);\n\n        // get the actual number of bytes transferred\n        size_t length = 0;\n        int result =\n            Fg_getParameterEx(fg, FG_TRANSFER_LEN, &amp;length, dma, mem, buffer);\n\n        if ((ptr != nullptr) &amp;&amp; (result == FG_OK) &amp;&amp; (length &gt; 0)) {\n            // process image data ...\n        }\n\n        // select frame buffer\n        Fg_setStatusEx(fg, FG_SELECT_BUFFER, buffer, dma, mem);\n    } else {\n        // handle error ...\n    }\n\n    return 0;\n}\n</code></pre> <p>This way, the callback function can be used both for processing only the newest image, when <code>FG_APC_BATCH_FRAMES</code> was passed in <code>flags</code> to <code>Fg_registerApcHandlerEx()</code>, as well as processing all images. The callback function will be called multiple times, once for each new image, when <code>FG_APC_BATCH_FRAMES</code> was not passed.</p>"},{"location":"fglib5.html#transferring-data-to-the-frame-grabber","title":"Transferring Data to the Frame Grabber","text":"<p>Limitations</p> <p>This section describes a new API for applications using the VisualApplets operator <code>DmaFromPC</code>. The API has the following limitations:</p> <ul> <li>It is a preliminary feature preview. This means that function names and functionality may change in future versions of the Framegrabber SDK.</li> <li>It only works for applets that contain the VisualApplets operator <code>DmaFromPC</code>. Do not use the API for regular DMA channels using <code>DmaToPC</code> or the Advanced Acquisition Applets delivered with the Framegrabber SDK. The operator <code>DmaFromPC</code> is available in VisualApplets version 3.4.0 or higher.</li> <li>It is currently only implemented for Windows.</li> </ul> <p>With the VisualApplets operator <code>DmaFromPC</code>, data can be transferred from the PC to the frame grabber. Applications include, but are not limited to co-processing image data or providing additional parameters for complex image processing on the frame grabber.</p>"},{"location":"fglib5.html#allocating-memory","title":"Allocating Memory","text":"<p>The buffers to transfer data must be allocated using the functions documented in Advanced Memory Management, for example:</p> <pre><code>const size_t bufferSize = 1024 * 1024;\nconst size_t numBuffers = 16;\nconst size_t totalSize = bufferSize * numBuffers;\n\ndma_mem * mem = Fg_AllocMemEx(fg, totalSize, numBuffers);\nif (mem != nullptr) {\n    // use memory, send buffers ...\n\n    Fg_FreeMem(fg, mem);\n}\n</code></pre> <p>Or you can use the functions documented in Flexible Memory Management, for example:</p> <pre><code>dma_mem * mem = Fg_AllocMemHead(fg, totalSize, numBuffers);\nfor (int i = 0; i &lt; numBuffers; i++) {\n    auto buffer = new uint8_t[bufferSize];\n    Fg_AddMem(fg, buffer, bufferSize, i, mem);\n}\n</code></pre> <p>While buffers are all equally sized, the number of bytes for each single transfer is specified individually. The size of the data transfer must be a multiple of the parallelism of the operator <code>DmaFromPc</code>, which is 32 and the upper limit is the size of the buffer.</p>"},{"location":"fglib5.html#starting-data-transfer","title":"Starting Data Transfer","text":"<pre><code> int Fg_startBufferQueue(\n    Fg_Struct * fg,\n    uint32_t dma,\n    dma_mem * mem);\n\nint Fg_stopBufferQueue(\n    Fg_Struct * fg,\n    uint32_t dma,\n    int32_t flags);\n</code></pre> <p>To start the data transfer to the frame grabber, call the function <code>Fg_startBufferQueue()</code>. This call will tie a DMA channel <code>dma</code> to a memory handle <code>mem</code> and thus will use the memory allocated for data transfers.</p> <p>The parameter <code>dma</code> to the function <code>Fg_startBufferQueue()</code> is determined by the number of regular DMA channels for image transfer to the PC using the VisualApplets operator <code>DmaToPC</code> present in the VisualApplets design. The DMA channel for the VisualApplets operator <code>DmaFromPC</code> is always the last DMA channel.</p> <p>After all data has been transferred, a call to <code>Fg_stopBufferQueue()</code> stops the buffer queue and cuts the tie between the DMA channel and the memory handle used.</p>"},{"location":"fglib5.html#queueing-buffers-for-data-transfer","title":"Queueing Buffers for Data Transfer","text":"<pre><code>int Fg_queueBuffer(\n    Fg_Struct * fg,\n    frameindex_t buffer,\n    uint64_t numBytesToTransfer,\n    uint32_t dma,\n    dma_mem * mem);\n</code></pre> <p>Once data to be transferred to the frame grabber has been written to a buffer, and the buffer is ready for transfer, you can put the buffer in the buffer queue by calling <code>Fg_queueBuffer()</code>. For each buffer which you put in the queue, you must specify the number of bytes to be transferred.</p> <p>You can put up to 16 buffers in the buffer queue. The next buffer in the queue will be transferred to the frame grabber automatically by the driver. This way, a continuous stream of data to the frame grabber can be ensured when necessary.</p> <p>The parameter <code>mem</code> is only needed, if buffers are queued before the buffer queue is started. After <code>Fg_startBufferQueue()</code> is called, the parameter <code>mem</code> is optional and can be <code>NULL</code>.</p>"},{"location":"fglib5.html#waiting-for-buffer-transfer-to-complete","title":"Waiting for Buffer Transfer to Complete","text":"<pre><code>int Fg_waitForBuffers(\n    Fg_Struct * fg,\n    uint32_t dma,\n    uint64_t timeout,\n    void * /* reserved */,\n    size_t /* reserved */);\n</code></pre> <p>The function <code>Fg_waitForBuffers()</code> waits for at least one buffer to be completely transferred within the number of seconds given in the parameter <code>timeout</code> on a given DMA channel as specified in the parameter <code>dma</code>. The function returns the number of buffers completely transferred in case of success, or a negative error code in case of a failure.</p> <p>You can only re-use buffers which were queued using <code>Fg_queueBuffer()</code> and fill them with new data once the buffer has been completely transferred.</p> <p>The data transfer model for the VisualApplets operator <code>DmaFromPC</code> is very similar to The Selective Acquisition Model. This means that because the application has full control over the use of buffers, keeping track of the buffer numbers is also the responsibility of the application. Unless buffers are always selected in the same order, there is no naive way to translate a transfer counter to buffer numbers. Also there is no API function to perform the translation.</p>"},{"location":"fglib5.html#applet-events","title":"Applet Events","text":"<p>The applets that are included in the Framegrabber SDK installation can notify the application about various events related to image acquisition or processing in the frame grabber. Examples of such events are start of frame events, or end of frame events which are generated whenever the first, or last, pixel of an image is received from the camera, or trigger input rising events, or trigger input falling events which are generated whenever a trigger input signal edge is detected. Users of VisualApplets can use event operators within their design to generate events as needed by their application.</p> <p>Each event source has a unique name and is identified by a single bit of an unsigned 64-bit integer, called the event mask. This way, multiple event sources can be grouped together by setting multiple bits in an event mask, for example by using the binary or operator <code>|</code> for multiple event masks for several event sources. However, this also implies that any applet can support only up to 64 event sources.</p> <p>Events can be delivered in synchronous or asynchronous mode. In the synchronous mode, an event loop has to be provided by the application. In the asynchronous mode, a callback function can be registered which will be called whenever one or more events occur. Both approaches should not be used mixed in an application as this can cause resource conflicts.</p> <p>Since event sources can generate a high interrupt load on the computer system, each event source must be enabled explicitly, and should only be activated when needed.</p> <p>For every occurrence of an event, the time when the interrupt for the event source was received is recorded. In addition to the time stamp, some event sources can generate additional data with each event, called the event payload. Events that have a payload can't be grouped together by setting multiple bits for more than one event source. Consult the documentation for any applet you use to learn about whether or not event sources in an applet generate additional data, and how to interpret that data.</p>"},{"location":"fglib5.html#event-information","title":"Event Information","text":"<pre><code>uint64_t Fg_getEventMask(\n    Fg_Struct * fg,\n    const char * name);\n\nint Fg_getEventPayload(\n    Fg_Struct * fg,\n    uint64_t mask);\n\nint Fg_getEventCount(\n    Fg_Struct * fg);\n\nconst char * Fg_getEventName(\n    Fg_Struct * fg,\n    uint64_t mask);\n</code></pre> <p>If the name for an event source is known, the corresponding bit can be requested by calling the function <code>Fg_getEventMask()</code>. If the event name isn't recognized, the function will return 0.</p> <p>The size of the payload for any given event can be requested by calling the function <code>Fg_getEventPayload()</code>. The function will return a value greater or equal to zero if the event mask corresponds to a single valid event source, or a negative error code otherwise.</p> <p>To iterate over all event sources, the function <code>Fg_getEventCount()</code> can be called to request the number of event sources supported by an applet, and the function <code>Fg_getEventName()</code> can be used to get the name of an event source. This is shown in the following example:</p> <pre><code>int numEvents = Fg_getEventCount(fg);\nfor (int event = 0; event &lt; numEvents; ++event) {\n    // get the event mask for each event\n    const uint64_t eventMask = (1 &lt;&lt; event);\n\n    const char * eventName = Fg_getEventName(fg, eventMask);\n    if (eventName != nullptr) {\n        std::cout &lt;&lt; \"Event \" &lt;&lt; event &lt;&lt; \" is \" &lt;&lt; eventName &lt;&lt; std::endl;\n    }\n}\n</code></pre>"},{"location":"fglib5.html#registering-a-callback-function-for-asynchronous-event-handling","title":"Registering a Callback Function for Asynchronous Event Handling","text":"<pre><code>typedef int (* Fg_EventFunc_t)(\n    uint64_t events,\n    void * data,\n    const struct fg_event_info * info);\n\nint Fg_registerEventCallback(\n    Fg_Struct * fg,\n    uint64_t mask,\n    Fg_EventFunc_t handler,\n    void * data,\n    unsigned int flags,\n    struct fg_event_info * info);\n\nint Fg_unregisterEventCallback(\n    Fg_Struct * fg,\n    uint64_t mask);\n</code></pre> <p>Info</p> <p>In version 5.9 of the Framegrabber SDK the type <code>struct fg_event_data</code> was removed and the function <code>Fg_unregisterEventCallback()</code> was added. See section Unregistering a Callback Function for Asynchronous Event Handling in Plain C for the old interface.</p> <p>Using <code>Fg_registerEventCallback()</code>, a function of type <code>Fg_EventFunc_t</code> can be registered to be called back when one or more events from a group of event sources is received. The function will be registered for a given frame grabber and an event mask and will be passed three parameters when called. The first parameter to the callback function is an event mask of all event sources for which events were received. The second parameter is a pointer which was supplied with the call to <code>Fg_registerEventCallback()</code> and which can be used as a pointer to a context structure or class, for example the <code>this</code> pointer of a class instance which implements image processing. The third parameter is a pointer to a <code>struct fg_event_info</code> which has to be allocated by the application and passed in the call to <code>Fg_registerEventCallback()</code> and which is used to store information about the events.</p> <p>Only one callback function can be registered for the same group of events on any given frame grabber.</p> <p>The callback function will be called from an event loop provided by the Framegrabber API. This implies that callback function is called in the thread context of the event loop. It also implies that the time the callback function takes until it returns is added to the general management overhead of the event loop, and that during this time multiple events might have been received. If any events were received during that time, the callback function will be called again immediately after it returns.</p> <p>Through the parameter <code>flags</code> in the call to <code>Fg_registerEventCallback()</code>, the application can choose whether only a single event is delivered each time the callback function is called or if all pending events are grouped together. The default behavior when passing <code>FG_EVENT_DEFAULT_FLAGS</code> to the parameter <code>flags</code> is to deliver one event every time the callback function is called. By passing <code>FG_EVENT_BATCHED</code> all pending events will be grouped together.</p> <p>After the callback function is no longer needed, it can be unregistered by calling <code>Fg_unregisterEventCallback()</code>.</p> <p>The following example shows how to register a callback function using a simple structure which holds information necessary for handling image acquisition:</p> <pre><code>struct EventUserCallbackData\n{\n    Fg_Struct * fg;\n    fg_event_info info;\n    uint64_t mask;\n};\n\nint EventUserCallback(uint64_t events, void * data,\n                      const struct fg_event_info * info)\n{\n    auto context = reinterpret_cast&lt;EventUserCallbackData *&gt;(data);\n\n    // process events\n\n    return 0;\n}\n\nvoid SetupEventUserCallback(EventUserCallbackData * context)\n{\n    // register callback function\n    int result = Fg_registerEventCallback(\n        context-&gt;fg, context-&gt;mask, &amp;EventUserCallback, context,\n        FG_EVENT_DEFAULT_FLAGS, &amp;context-&gt;info);\n    if (result != FG_OK) {\n        throw std::runtime_error(\"Failed to register callback function\");\n    }\n}\n</code></pre> <p>The allocation and management of the context structure isn't shown in the example. The pointer has to be valid while the callback function remains registered. One solution can be to keep everything together in a C++ class. To use a callback function in a C++ class context, a static function can be used to register the callback handler, and the <code>this</code> pointer should be used as context data pointer which can be casted back to a class pointer and used accordingly.</p>"},{"location":"fglib5.html#waiting-for-events-synchronously","title":"Waiting for Events Synchronously","text":"<pre><code>uint64_t Fg_eventWait(\n    Fg_Struct * fg,\n    uint64_t mask,\n    unsigned int timeout,\n    unsigned int flags,\n    struct fg_event_info * info);\n</code></pre> <p>The application can wait for an event from a group of event sources synchronously by calling <code>Fg_eventWait()</code>. The parameter <code>flags</code> allows choosing whether only a single event is returned each time the function is called or if all pending events are grouped together. The default behavior when passing <code>FG_EVENT_DEFAULT_FLAGS</code> to the parameter <code>flags</code> is to return at most one event every time the function is called. By passing <code>FG_EVENT_BATCHED</code> all pending events will be grouped together. The function will wait until either an event is received for any of the event sources specified in the parameter <code>mask</code>, or the number of seconds specified in the parameter <code>timeout</code> has elapsed. If no events were received until a timeout occurs the function will return 0, otherwise it will return a mask containing the event or the group of events received.</p>"},{"location":"fglib5.html#activating-events","title":"Activating Events","text":"<pre><code>int Fg_activateEvents(\n    Fg_Struct * fg,\n    uint64_t mask,\n    int enable);\n</code></pre> <p>Before an event source can send events it has to be enabled. By calling <code>Fg_activateEvents()</code> a group of event sources can be enabled or disabled. If 1 is passed to the parameter <code>enable</code>, the group of event sources passed in the parameter <code>mask</code> is enabled. If 0 is passed to the parameter <code>enable</code>, they are disabled. All event sources should be disabled once they are no longer used by the application.</p> <p>Since event sources can fire events any time after they were enabled, it is recommended to activate event sources only after either a callback has been registered for them using <code>Fg_registerEventCallback()</code>, or a separate thread is ready and waiting for events using <code>Fg_eventWait()</code>.</p>"},{"location":"fglib5.html#support-for-using-a-frame-grabber-from-multiple-processes","title":"Support for using a Frame Grabber from Multiple Processes","text":"<p>Some applications might require access to a single frame grabber from different processes. One simple example is a process which monitors the activity of another process, for example an acquisition process. Another example might be separate acquisition processes using one camera each of a frame grabber with up to four cameras connected.</p> <p>The Framegrabber API provides limited support for such scenarios with the master/slave mode. When using master/slave processes it is important to understand the limitations. It is also important to understand the general challenges that application developers meet when two or more processes have to be synchronized. While the Framegrabber API provides support for using a frame grabber from multiple processes, it doesn't support inter-process synchronization beyond very basic features to synchronize the startup of processes when initializing a frame grabber. For general purpose inter-process communication and synchronization, other operating system features or support libraries have to be used.</p> <p>One particular limitation of the master/slave mode is that whenever two processes try to control the same feature on a frame grabber, the last process \"wins\" and overrides the actions of the first process. The first process might not even notice the override and make wrong assumptions as to the state of the frame grabber. (An experimental feature exists to synchronize the state between processes using inter-process communication, however, this approach has its own implications and will be discussed in section Experimental Support for Parameter and Acquisition Synchronization.)</p> <p>The general recommendation is to design processes in such a way that they take on unique tasks (the tasks are disjunct with respect to applet parameters and features) and don't have to know about the existence of the other processes. One exception is a monitoring process which only accesses read-only features of an applet or gathers information from other processes through inter-process communication means.</p> <p>Another limitation is that while only the master process will fully initialize the frame grabber, basic initialization has to be done in each process. This basic initialization can interfere with earlier processes if they already started image acquisition or camera discovery.</p>"},{"location":"fglib5.html#synchronizing-processes-during-initialization","title":"Synchronizing Processes During Initialization","text":"<pre><code>int Fg_InitLibrariesEx(\n    const char * path,\n    unsigned int flags,\n    const char * id,\n    unsigned int timeout);\n\nvoid Fg_AbortInitLibraries();\n\nvoid Fg_InitLibrariesStartNextSlave();\n</code></pre> <pre><code>Fg_Struct * Fg_InitEx(\n    const char * applet,\n    unsigned int board,\n    int flags);\n\nFg_Struct * Fg_InitConfigEx(\n    const char * config,\n    unsigned int board,\n    int flags);\n</code></pre> <p>When synchronizing multiple processes, the synchronization point provided by the Framegrabber API is the call to <code>Fg_InitLibrariesEx()</code>. As with <code>Fg_InitLibraries()</code>, the first parameter to the call isn't used and the application should always pass <code>nullptr</code>.</p> <p>Processes to be synchronized form a group and synchronization will only consider processes within a group. The group of processes which should be synchronized is identified through the parameter <code>id</code>. This way, a complex application can have multiple independent synchronization groups. The string which identifies the group should not be empty and should consist only of characters that are allowed in file names on the operating system used. Starting an identifier used by an application with <code>siso-</code> isn't recommended, the prefix <code>siso-</code> should be considered reserved for use by the Framegrabber API.</p> <p>The synchronization behavior can be configured through the parameter <code>flags</code>. The following values and macros can be used in the parameter <code>flags</code>:</p> Flag Description FG_INIT_LIBRARIES_SINGLE Default initialization, no synchronization FG_INIT_LIBRARIES_MASTER Master initialization, prepare slave synchronization FG_INIT_LIBRARIES_SLAVE Slave initialization, wait for master FG_INIT_LIBRARIES_SEQUENTIAL Strictly sequential startup FG_INIT_LIBRARIES_AUTOSTART_ON_INIT Start next slave on frame grabber initialization FG_INIT_LIBRARIES_SET_SLAVE_PRIORITY(n) Set slave priority FG_INIT_LIBRARIES_SET_NUMBER_OF_SLAVES(n) Set number of slaves <p>Using <code>FG_INIT_LIBRARIES_SINGLE</code> is the same as calling <code>Fg_InitLibraries()</code>.</p> <p>Using <code>FG_INIT_LIBRARIES_SEQUENTIAL</code> will only start the slave process with the highest priority from the master process. The slave process with the second highest priority has to be started from the slave process with the highest priority, and so on. This ensures a strict order of process initialization. If <code>FG_INIT_LIBRARIES_SEQUENTIAL</code> is used in a synchronization group, it has to be specified in all processes, including the master process. The macro <code>FG_INIT_LIBRARIES_SET_SLAVE_PRIORITY()</code> must be used in all slave processes when <code>FG_INIT_LIBRARIES_SEQUENTIAL</code> is used and defines the priority of the slave process. The highest priority is 1, the lowest priority is 63. Each process in a group must have a unique priority and priorities have to be assigned in a way not to leave gaps. (If process 2 wants to start process 3, but there is no process 3, then nobody will start process 4.) The macro <code>FG_INIT_LIBRARIES_SET_NUMBER_OF_SLAVES()</code> must be used in the master process when <code>FG_INIT_LIBRARIES_SEQUENTIAL</code> is used and defines the number of slave processes. The minimum value allowed is 1, the maximum is 63.</p> <p>The last parameter in the call to <code>Fg_InitLibrariesEx()</code> specifies the time in milliseconds to wait for the process to be scheduled before an error is reported to the application.</p> <p>The first process of the group, usually referred to as master process, establishes a group when <code>Fg_InitLibrariesEx()</code> is called. All following processes, usually referred to as slave processes, can choose to wait in the respective call to <code>Fg_InitLibrariesEx()</code> to be scheduled. Starting one or more slaves is triggered then by a call to <code>Fg_InitLibrariesStartNextSlave()</code> in the master process. The function <code>Fg_InitLibrariesStartNextSlave()</code> can be called automatically when a process initializes the frame grabber through a call to <code>Fg_Init()</code>, <code>Fg_InitEx()</code>, <code>Fg_InitConfig()</code> or <code>Fg_InitConfigEx()</code>.</p> <p>While the function <code>Fg_InitLibraries()</code> should never fail in normal circumstances, the same isn't true for <code>Fg_InitLibrariesEx()</code> when using synchronization. Specify waiting times sensibly and handle errors accordingly.</p> <p>In a multi-threaded application, waiting in a call to <code>Fg_InitLibrariesEx()</code> can be aborted from a different thread by calling <code>Fg_AbortInitLibraries()</code>. This will result in an error reported by the aborted call.</p> <p>While in a master process, a call to <code>Fg_Init()</code> or <code>Fg_InitConfig()</code> can be used to initialize the frame grabber, all slave processes must call either <code>Fg_InitEx()</code> or <code>Fg_InitConfigEx()</code> and pass <code>FG_INIT_FLAG_SLAVE</code> in the parameter <code>flags</code>. Calling <code>Fg_InitEx()</code> or <code>Fg_InitConfigEx()</code> with <code>FG_INIT_FLAG_DEFAULT</code> is the same as calling <code>Fg_Init()</code> or <code>Fg_InitConfig()</code>, respectively.</p> <p>The following example shows how a master process can set up a synchronization group for strictly sequential scheduling using two slave processes. The master uses a call to <code>Fg_InitLibrariesStartNextSlave()</code> to start the first slave process after some further initialization:</p> <pre><code>const char * syncGroupId = \"example\";\n\nint result =\n    Fg_InitLibrariesEx(\n        nullptr,\n        FG_INIT_LIBRARIES_MASTER\n            | FG_INIT_LIBRARIES_SEQUENTIAL\n            | FG_INIT_LIBRARIES_SET_NUMBER_OF_SLAVES(2),\n        syncGroupId,\n        0);\n\nif (result == FG_OK) {\n    const char * applet = \"Acq_SingleCXP12Area\";\n\n    Fg_Struct * fg = Fg_Init(applet, 0);\n    if (fg != nullptr) {\n        // further initialization ...\n\n        Fg_InitLibrariesStartNextSlave();\n\n        // use frame grabber ...\n    }\n\n    Fg_FreeLibraries();\n}\n</code></pre> <p>The slave processes in the example are identical save for the priority specified in the call to <code>Fg_InitLibrariesEx()</code>, only the first slave process is shown here. The slave process uses <code>FG_INIT_LIBRARIES_AUTOSTART_ON_INIT</code> to start the next slave process implicitly when <code>Fg_InitEx()</code> is called:</p> <pre><code>const char * syncGroupId = \"example\";\n\nint result =\n    Fg_InitLibrariesEx(\n        nullptr,\n        FG_INIT_LIBRARIES_SLAVE\n            | FG_INIT_LIBRARIES_SEQUENTIAL\n            | FG_INIT_LIBRARIES_AUTOSTART_ON_INIT\n            | FG_INIT_LIBRARIES_SET_SLAVE_PRIORITY(1),\n        syncGroupId,\n        10000);\n\nif (result == FG_OK) {\n    const char * applet = \"Acq_SingleCXP12Area\";\n\n    Fg_Struct * fg = Fg_InitEx(applet, 0, FG_INIT_FLAG_SLAVE);\n    if (fg != nullptr) {\n        // use frame grabber ...\n    }\n\n    Fg_FreeLibraries();\n}\n</code></pre> <p>If the slave process is started before the master process, it will wait in the call to <code>Fg_InitLibrariesEx()</code> for the master process to be started. Once the master process calls <code>Fg_InitLibrariesStartNextSlave()</code> the slave process is scheduled to run and the call to <code>Fg_InitLibrariesEx()</code> returns <code>FG_OK</code>. If the master process isn't started, or doesn't finish initialization before the waiting time of the slave runs out, then the slave can't be scheduled to run, and the call to <code>Fg_InitLibrariesEx()</code> will return a timeout error.</p> <p>The tool microDisplayX which is installed with the Framegrabber SDK supports master/slave synchronization and slave processes can synchronize to microDisplayX by using the group id <code>siso-microdisplay-master</code>. The flag <code>FG_INIT_LIBRARIES_SEQUENTIAL</code> isn't supported by microDisplayX.</p>"},{"location":"fglib5.html#experimental-support-for-parameter-and-acquisition-synchronization","title":"Experimental Support for Parameter and Acquisition Synchronization","text":"<p>Info</p> <p>The experimental support for parameter and acquisition synchronization was added in version 5.9 of the Framegrabber SDK.</p> <p>The Framegrabber API provides experimental support to synchronize all parameter changes and the acquisition state across the process synchronization group. To enable parameter and acquisition synchronization, <code>FG_INIT_FLAG_SLAVE_PARAM_SYNC</code> has to be added to the parameter <code>flags</code> in the call to <code>Fg_InitEx()</code> or <code>Fg_InitConfigEx()</code> for all processes in the group.</p> <p>There are a few things to consider when using parameter and acquisition synchronization, however.</p> <p>First, the synchronization provided by the Framegrabber API uses inter-process communication mechanisms provided by the operating system. Because getting and setting parameters is no longer done locally in the process but has to be synchronized among several processes, both the latency and jitter for these operations increases. For most applications, these drawbacks should not matter. However, if the application uses a real-time operating system and getting or setting one or more parameters is considered real-time critical, parameter and acquisition synchronization should not be enabled. If <code>FG_INIT_FLAG_SLAVE_PARAM_SYNC</code> isn't used explicitly, parameter and acquisition synchronization isn't enabled and the experimental feature has no impact on the performance compared to earlier versions of the Framegrabber API.</p> <p>Second, either the master or the slave processes can control acquisition when synchronization is used, never both. Acquisition in the master process can't be mixed with acquisition in one or more slave processes within a synchronization group. In most cases, the acquisition should be done in one or more slave processes, and <code>FG_INIT_FLAG_ACQUISITION_SLAVE</code> should be added to the parameter <code>flags</code> in the call to <code>Fg_InitEx()</code> or <code>Fg_InitConfigEx()</code> for the master process.</p>"},{"location":"fglib5.html#support-for-non-uniform-memory-access","title":"Support for Non-Uniform Memory Access","text":"<pre><code>int Fg_NumaPinThread(\n    Fg_Struct * fg);\n\nvoid * Fg_NumaAllocDmaBuffer(\n    Fg_Struct * fg,\n    size_t size);\n\nint Fg_NumaFreeDmaBuffer(\n    Fg_Struct * fg,\n    void * ptr);\n</code></pre> <p>In multi-processor computers using non-uniform memory access (NUMA), each physical processor has its own memory and peripheral busses. As long as a process accesses only resources on the same physical processor it is running on, the access is almost as fast as on a single-processor computer and considerably faster than on a multi-processor computer using symmetric multiprocessing (SMP). However, if a process running on one physical processor wants to access resources which belong to another physical processor, the data has to be moved between two physical processors, slowing down the access. See the article about non-uniform memory access on Wikipedia for more information.</p> <p>To support applications running on NUMA computers, all threads accessing a frame grabber should be pinned to the physical processor to which the device is attached locally. This can be done by calling <code>Fg_NumaPinThread()</code> in the context of each thread that accesses parameters or controls the acquisition on a frame grabber.</p> <p>Furthermore, memory should be allocated locally on the same physical processor as well. If the application uses the allocation functions provided by the Framegrabber API this is done automatically. However, if the application uses <code>Fg_AllocMemHead()</code> and <code>Fg_AddMem()</code>, memory should be allocated using NUMA-aware memory allocation. The Framegrabber API provides the functions <code>Fg_NumaAllocDmaBuffer()</code> and <code>Fg_NumaFreeDmaBuffer()</code> to allocate and release memory on the same physical processor a frame grabber is attached to locally.</p> <p>If the application uses other NUMA aware functions for allocating memory, the function <code>Fg_getIntSystemInformationForBoardIndex()</code> can be called using <code>INFO_DRIVERGROUPAFFINITY</code> to provide the driver IRQ group affinity, and the function <code>Fg_getInt64SystemInformationForBoardIndex()</code> can be called using <code>INFO_DRIVERAFFINITYMASK</code> to provide the driver IRQ processor affinity mask for the device.</p> <p>There might be other limitations on some NUMA computers. Some NUMA computers for example are designed in a way to balance access to the peripheral busses and don't allow for a single device to use all or even most of the bandwidth. While this is beneficial to most server applications, for image acquisition and processing applications this strategy might limit the bandwidth available to a frame grabber device.</p>"},{"location":"fglib5.html#considerations-when-using-plain-c","title":"Considerations When Using Plain C","text":"<p>When an application is limited to using a plain C compiler, some of the C++ wrappers provided for convenience or type-safety by the Framegrabber API can't be used. This chapter will explain for each topic how to use the underlying functionality used by the C++ wrapper.</p>"},{"location":"fglib5.html#system-information-in-plain-c","title":"System Information in Plain C","text":"<pre><code>int Fg_getSystemInformation(\n    Fg_Struct * fg,\n    enum Fg_Info_Selector info,\n    enum FgProperty property,\n    int arg,\n    void * buffer,\n    unsigned int * size);\n</code></pre> <p>In sections General System Information and Board-Specific System Information of chapter System Information a set of functions is documented to request various information about the system in general or a specific frame grabber. The functions in these two chapters are all C++ wrappers for the function <code>Fg_getSystemInformation()</code>.</p> <p>The function <code>Fg_getSystemInformation()</code> will always return the requested information as a string which is stored in a buffer passed to the function. To allocate a buffer of sufficient size, the size of the buffer can be requested by initializing the variable used for the parameter <code>size</code> to 0 and passing <code>NULL</code> to the parameter <code>buffer</code> in the call. If the information requested is of a numeric type, the string has to be converted after successfully requesting the information.</p> <p>To request information about the system in general, as documented in section General System Information, the function <code>Fg_getSystemInformation()</code> should be called with <code>NULL</code> passed to the parameter <code>fg</code> and 0 to the parameter <code>arg</code>.</p> <p>For example, the number of frame grabbers installed in the computer can be requested as shown below:</p> <pre><code>int numBoards = 0;\nchar buffer[256];\nunsigned int size = sizeof(buffer);\nint result =\n    Fg_getSystemInformation(NULL, INFO_NR_OF_BOARDS, PROP_ID_VALUE,\n                            0, buffer, &amp;size);\nif (result == FG_OK) {\n    numBoards = atoi(buffer);\n    std::cout &lt;&lt; \"Number of boards: \" &lt;&lt; numBoards &lt;&lt; std::endl;\n}\n</code></pre> <p>To request information about a specific frame grabber, as documented in section Board-Specific System Information, the function <code>Fg_getSystemInformation()</code> expects either a handle to the frame grabber passed in the parameter <code>fg</code>, or a board index passed in the parameter <code>arg</code>.</p> <p>For example, the following code requests the board type and name.</p> <pre><code>const int boardIndex = 0;\n\nchar buffer[256];\nunsigned int size = sizeof(buffer);\n\nint boardType = 0;\nstd::string boardName;\nint result =\n    Fg_getSystemInformation(NULL, INFO_BOARDTYPE, PROP_ID_VALUE,\n                            boardIndex, buffer, &amp;size);\nif (result == FG_OK) {\n    boardType = atoi(buffer);\n\n    size = sizeof(buffer);\n    result =\n        Fg_getSystemInformation(NULL, INFO_BOARDNAME, PROP_ID_VALUE,\n                                boardIndex, buffer, &amp;size);\n}\nif (result == FG_OK) {\n    boardName = buffer;\n\n    std::cout &lt;&lt; \"Board #\" &lt;&lt; boardIndex\n              &lt;&lt; \" is a \" &lt;&lt; boardName\n              &lt;&lt; \" (type \" &lt;&lt; std::hex &lt;&lt; boardType\n              &lt;&lt; std::dec &lt;&lt; \")\" &lt;&lt; std::endl;\n}\n</code></pre> <p>To request information which requires an additional argument on input, the buffer works two-ways. The additional argument has to be stored as a string in the buffer before the call. During the call the argument passed in the buffer is used and then overwritten, as the information requested is written to the buffer.</p>"},{"location":"fglib5.html#accessing-parameter-values-in-plain-c","title":"Accessing Parameter Values in Plain C","text":"<pre><code>int Fg_getParameterWithType(\n    Fg_Struct * fg,\n    int id,\n    void * value,\n    unsigned int dma,\n    enum FgParamTypes type);\n\nint Fg_freeParameterStringWithType(\n    Fg_Struct * fg,\n    int id,\n    void * value,\n    unsigned int dma,\n    enum FgParamTypes type);\n</code></pre> <pre><code>int Fg_setParameterWithType(\n    Fg_Struct * fg,\n    int id,\n    const void * value,\n    unsigned int dma,\n    enum FgParamTypes type);\n</code></pre> <p>In section Accessing Parameter Values of chapter Working with Applet Parameters, C++ wrappers to request parameters with the most common types are documented. To access parameters from plain C, or to access parameters of a type for which no C++ wrapper exists, the functions <code>Fg_getParameterWithType()</code> and <code>Fg_setParameterWithType()</code> can be used. A variable of the matching type is needed for the call, and the corresponding <code>FgParamTypes</code> value has to be passed in the parameter <code>type</code> in the call. The type values are documented in section Parameter Types and the applet documentation should be consulted to know the type of a specific parameter.</p> <p>For example, the following code sets the width of the first DMA channel of the applet to 1024.</p> <pre><code>const int dma = 0;\nconst int width = 1024;\nint result = FG_INVALID_PARAMETER;\nint paramId = Fg_getParameterIdByName(fg, \"FG_WIDTH\");\nif (paramId &gt; 0) {\n    result =\n        Fg_setParameterWithType(fg, paramId, &amp;width, dma,\n                                FG_PARAM_TYPE_INT32_T);\n}\n</code></pre> <p>One special case when calling <code>Fg_getParameterWithType()</code> is the type <code>FG_PARAM_TYPE_CHAR_PTR</code> which represents a string parameter. While the length of the string needed to allocate a buffer of sufficient size can be requested by calling <code>Fg_getParameterPropertyEx()</code>, this isn't the safest way to access dynamic parameters. A better approach is to request parameters with type <code>FG_PARAM_TYPE_CHAR_PTR</code> using <code>FG_PARAM_TYPE_CHAR_PTR_PTR</code> instead. This request will allocate a buffer of the right size, which can be released by calling <code>Fg_freeParameterStringWithType()</code> after the value is no longer needed.</p> <p>The following example shows how to use <code>FG_PARAM_TYPE_CHAR_PTR_PTR</code>, assuming <code>paramId</code> is a parameter of type <code>FG_PARAM_TYPE_CHAR_PTR</code>:</p> <pre><code>const char * val = NULL;\nint result =\n    Fg_getParameterWithType(fg, paramId, &amp;val, dma,\n                            FG_PARAM_TYPE_CHAR_PTR_PTR);\nif (result == FG_OK) {\n    // use the string value stored in val ...\n\n    Fg_freeParameterStringWithType(fg, paramId, val, dma,\n                                   FG_PARAM_TYPE_CHAR_PTR_PTR);\n}\n</code></pre> <p>The call to <code>Fg_freeParameterStringWithType()</code> receives a <code>char *</code>, not actually a <code>char **</code>.</p>"},{"location":"fglib5.html#accessing-field-parameters","title":"Accessing Field Parameters","text":"<pre><code>struct FieldParameterAccess {\n    enum FgParamTypes vtype;\n    unsigned int index;\n    unsigned int count;\n    union {\n        int32_t * p_int32_t;\n        uint32_t * p_uint32_t;\n        int64_t * p_int64_t;\n        uint64_t * p_uint64_t;\n        double * p_double;\n    };\n};\n</code></pre> <p>Field parameters are parameters which represent an array of two or more values of the same type. A typical example is a lookup table which can be used to remap pixel values. Field parameters can be of type <code>FG_PARAM_TYPE_STRUCT_FIELDPARAMINT</code>, <code>FG_PARAM_TYPE_STRUCT_FIELDPARAMINT64</code> or <code>FG_PARAM_TYPE_STRUCT_FIELDPARAMDOUBLE</code>.</p> <p>The size of a field parameter can be determined by requesting the parameter property <code>PROP_ID_FIELD_SIZE</code> as documented in section Accessing Parameter Properties of chapter Working with Applet Parameters. Also consult section Accessing Parameter Properties in Plain C if needed.</p> <p>To request or change values in the array of a field parameter, the functions <code>Fg_getParameterWithType()</code> and <code>Fg_setParameterWithType()</code> should be called using an instance of <code>struct FieldParameterAccess</code> and <code>FG_PARAM_TYPE_STRUCT_FIELDPARAMACCESS</code> should be passed in the parameter <code>type</code>. The member <code>vtype</code> of <code>struct FieldParameterAccess</code> has to be set to the <code>enum FgParamTypes</code> value corresponding to the type of a single value in the field, not the field parameter type itself. The members <code>index</code> and <code>count</code> specify the offset into the array of the field parameter and the number of items requested or provided in the function call. Finally, the pointer in the union corresponding to the type of a single value in the field has to be initialized with a pre-allocated buffer which contains the values to be changed on input if <code>Fg_setParameterWithType()</code> is called, or the values currently stored in the array after <code>Fg_getParameterWithType()</code> was called.</p> <p>The following example requests the first 256 values in a lookup table, assuming <code>paramId</code> is a parameter of type <code>FG_PARAM_TYPE_STRUCT_FIELDPARAMINT</code> and the field itself consists of at least 256 values of type <code>FG_PARAM_TYPE_INT32_T</code>:</p> <pre><code>int32_t field[256];\nstruct FieldParameterAccess fpa;\nfpa.vtype = FG_PARAM_TYPE_INT32_T;\nfpa.index = 0;\nfpa.count = 256;\nfpa.p_int32_t = &amp;field;\nint result =\n    Fg_getParameterWithType(fg, paramId, &amp;fpa, dma,\n                            FG_PARAM_TYPE_STRUCT_FIELDPARAMACCESS);\nif (result == FG_OK) {\n    // work with the values in field ...\n}\n</code></pre>"},{"location":"fglib5.html#accessing-parameter-properties-in-plain-c","title":"Accessing Parameter Properties in Plain C","text":"<pre><code>int Fg_getParameterProperty(\n    Fg_Struct * fg,\n    int id,\n    enum FgProperty property,\n    void * buffer,\n    int * size);\n\nint Fg_getParameterPropertyEx(\n    Fg_Struct * fg,\n    int id,\n    enum FgProperty property,\n    int dma,\n    void * buffer,\n    int * size);\n</code></pre> <p>In section Accessing Parameter Properties of chapter Working with Applet Parameters, C++ wrappers to request parameter properties with the most common types are documented. To access parameter properties from plain C, or to access parameter properties of a type for which no C++ wrapper exists, the function <code>Fg_getParameterPropertyEx()</code> can be used. Using the function <code>Fg_getParameterProperty()</code> isn't recommended, as the function call implicitly uses DMA channel 0, parameter properties might differ though for different channels.</p> <p>The function <code>Fg_getParameterPropertyEx()</code> will in all but one case return the requested information as a string which is stored in a buffer passed to the function. To allocate a buffer of sufficient size, the size of the buffer can be requested by initializing the variable used for the parameter <code>size</code> to 0 and passing <code>NULL</code> to the parameter <code>buffer</code> in the call. If the information requested is of a numeric type, the string has to be converted after successfully requesting the information.</p> <p>The following example shows how to get the minimum value of a parameter, assuming paramId is a parameter of type <code>FG_PARAM_TYPE_INT32_T</code>:</p> <pre><code>char buffer[256];\nint size = sizeof(buffer);\n\nint32_t minVal = 0;\nint result =\n    Fg_getParameterPropertyEx(fg, paramId, PROP_ID_MIN, dma, buffer, &amp;size);\nif (result == FG_OK) {\n    minVal = atoi(buffer);\n\n    // work with the property ...\n}\n</code></pre>"},{"location":"fglib5.html#accessing-the-enum-values-parameter-property","title":"Accessing the Enum Values Parameter Property","text":"<pre><code>struct FgPropertyEnumValues {\n    int32_t value;\n    char name[1];\n};\n\n#define FG_PROP_GET_NEXT_ENUM_VALUE(pev) ...\n</code></pre> <p>When requesting the property <code>PROP_ID_ENUM_VALUES</code> of an enumeration parameter, the call to <code>Fg_getParameterPropertyEx()</code> will not return the property as a string. Instead, the buffer will be filled using <code>struct FgPropertyEnumValues</code>. The macro <code>FG_PROP_GET_NEXT_ENUM_VALUE()</code> can be used to iterate over the elements in the buffer. For convenience, the property <code>PROP_ID_IS_ENUM</code> will return the size of the buffer needed for an enumeration parameter.</p> <p>The following example shows how to get and print the enum values property of a parameter, assuming paramId is an enumeration parameter:</p> <pre><code>const int defBufferSize = 256;\n\nint size = defBufferSize;\nchar * buffer = malloc(size);\n\nint result =\n    Fg_getParameterPropertyEx(fg, paramId, PROP_ID_IS_ENUM,\n                              dma, buffer, &amp;size);\nif (result == FG_OK) {\n    int newSize = atoi(buffer);\n    if (newSize &gt; 0) {\n        free(buffer);\n        size = newSize;\n        buffer = malloc(size);\n\n        result =\n            Fg_getParameterPropertyEx(fg, paramId, PROP_ID_ENUM_VALUES,\n                                      dma, buffer, &amp;size);\n    } else {\n        result = FG_INVALID_TYPE;\n    }\n}\nif (result == FG_OK) {\n    struct FgPropertyEnumValues * pev;\n    for (pev = (struct FgPropertyEnumValues *)buffer;\n         pev != NULL;\n         pev = FG_PROP_GET_NEXT_ENUM_VALUE(pev)) {\n            printf(\"%s is %d\\n\", pev-&gt;name, pev-&gt;value);\n    }\n}\nfree(buffer);\n</code></pre>"},{"location":"fglib5.html#registering-a-callback-function-for-asynchronous-mode-in-plain-c","title":"Registering a Callback Function for Asynchronous Mode in Plain C","text":"<pre><code>struct FgApcControl {\n    unsigned int version;\n    Fg_ApcFunc_t func;\n    void *data;\n    unsigned int timeout;\n    unsigned int flags;\n};\n\nint Fg_registerApcHandler(\n    Fg_Struct * fg,\n    unsigned int dma,\n    struct FgApcControl * control,\n    enum FgApcControlFlags flags);\n</code></pre> <p>The function <code>Fg_registerApcHandler()</code> can be used to setup the asynchronous mode before starting the acquisition.</p> <p>The callback function works in the same way as documented in section Registering a Callback Function for Asynchronous Mode of chapter Image Acquisition. When registering the callback function by calling the function <code>Fg_registerCallbackHandler()</code> the parameters which control the acquisition loop are passed in an instance of <code>struct FgApcControl</code>, whereas when calling the C++ wrapper function <code>Fg_registerApcHandlerEx()</code> these are passed as parameters to the function.</p> <p>There are two places where flags are passed when registering the callback function. The parameter <code>flags</code> of the function <code>Fg_registerApcHandler()</code> doesn't control the acquisition loop and isn't used. The application should always pass 0 to this parameter. Instead, the flags which control the acquisition loop are passed in the member <code>flags</code> of <code>struct FgApcControl</code>.</p> <p>The following example shows how to register a callback function using a simple structure which holds information necessary for handling image acquisition:</p> <pre><code>struct ApcUserCallbackData\n{\n    Fg_Struct * fg;\n    dma_mem * mem;\n    unsigned int dma;\n    unsigned int timeoutInSeconds;\n    int mode;\n};\n\nint ApcUserCallback(frameindex_t frame, void * data)\n{\n    auto context = reinterpret_cast&lt;ApcUserCallbackData *&gt;(data);\n\n    if (frame &gt; 0) {\n        // process new image ...\n    } else {\n        // handle error ...\n    }\n\n    return 0;\n}\n\nvoid SetupApcUserCallback(ApcUserCallbackData * context)\n{\n    // register callback function\n    FgApcControl control;\n    control.version = 0;\n    control.func = &amp;ApcUserCallback;\n    control.data = context;\n    control.timeout = context-&gt;timeoutInSeconds;\n    control.flags = FG_APC_DELIVER_ERRORS | FG_APC_IGNORE_TIMEOUTS;\n\n    int result = Fg_registerApcHandler(\n        context-&gt;fg, context-&gt;dma, &amp;control, 0);\n    if (result != FG_OK) {\n        throw std::runtime_error(\"Failed to register callback function\");\n    }\n}\n</code></pre> <p>The allocation and management of the context structure isn't shown in the example. The pointer has to be valid while the callback function remains registered. One solution can be to keep everything together in a C++ class. To use a callback function in a C++ class context, a static function can be used to register the callback handler, and the <code>this</code> pointer should be used as context data pointer which can be casted back to a class pointer and used accordingly.</p> <p>After the callback function is no longer needed, it can be unregistered by calling <code>Fg_registerApcHandler()</code> by using the same frame grabber handle and DMA channel, but passing <code>NULL</code> to the parameter <code>func</code>:</p> <pre><code>int result = Fg_registerApcHandler(context-&gt;fg, context-&gt;dma, NULL, 0);\n</code></pre>"},{"location":"fglib5.html#unregistering-a-callback-function-for-asynchronous-event-handling-in-plain-c","title":"Unregistering a Callback Function for Asynchronous Event Handling in Plain C","text":"<pre><code>int Fg_registerEventCallback(\n    Fg_Struct * fg,\n    uint64_t mask,\n    Fg_EventFunc_t handler,\n    void * data,\n    unsigned int flags,\n    struct fg_event_info * info);\n</code></pre> <p>Using <code>Fg_registerEventCallback()</code>, a function of type <code>Fg_EventFunc_t</code> can be registered to be called back when one or more events from a group of event sources is received as described in section Registering a Callback Function for Asynchronous Event Handling of chapter Image Acquisition.</p> <p>After the callback function is no longer needed, it can be unregistered by calling <code>Fg_registerEventCallback()</code>, passing the mask for the same group of events, <code>FG_EVENT_DEFAULT_FLAGS</code> to the parameter <code>flags</code> and <code>NULL</code> to the parameters <code>handler</code>, <code>data</code> and <code>info</code>:</p> <pre><code>// unregister event handler\nFg_registerEventCallback(fg, mask, NULL, NULL, FG_EVENT_DEFAULT_FLAGS, NULL);\n</code></pre> <ol> <li> <p>The group code is a bit field with each bit corresponding to a single feature of a license. Superset in this context means that for every bit in the applet group code the bit has to be set in the frame grabber group code. Subset in this context means that for every bit in the applet group code the bit has to be set in the frame grabber group code. If the applet uses features which a have not been activated through licensing on a frame grabber, the applet can't be loaded by the Framegrabber SDK.\u00a0\u21a9\u21a9</p> </li> <li> <p>The value of a parameter can be set to any value in <code>[PROP_ID_MIN; PROP_ID_MAX]</code> in steps of <code>PROP_ID_STEP</code> according to the linear relation <code>PROP_ID_VALUE = PROP_ID_MIN + n*PROP_ID_STEP</code>, where n is in <code>[0; (PROP_ID_MAX-PROP_ID_MIN)/PROP_ID_STEP[</code>.\u00a0\u21a9\u21a9\u21a9</p> </li> <li> <p>Older versions of the Framegrabber API used <code>Fg_getLastPicNumberBlockingEx()</code> in the acquisition loop, regardless of the acquisition model used. When <code>ACQ_BLOCK</code> is used, the new default behavior is to call <code>Fg_getImageEx()</code> with <code>SEL_ACT_IMAGE</code> when <code>FG_APC_BATCH_IMAGES</code> is set and <code>SEL_NEXT_IMAGE</code> otherwise. This means that in <code>ACQ_BLOCK</code>, the callback handler receives a buffer number, and not a frame number when the default behavior is used. Since there is no way to safely determine a buffer number for a given frame number when using <code>ACQ_BLOCK</code>, the use of <code>FG_APC_OLD_ACQ_BLOCK_BEHAVIOR</code> and calling <code>Fg_getImageEx()</code> from the callback handler isn't recommended and should only be used when backwards compatibility of application code is absolutely necessary.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"firmwareupdater.html","title":"FirmwareUpdater","text":"<p>The FirmwareUpdater command line tool can be used to check if updates for the frame grabber's firmware are available and to perform the update if necessary.</p> <p>To get a summary of all available options and parameters, call the FirmwareUpdater tool with the <code>--help</code> option:</p> <pre><code>FirmwareUpdater --help\n</code></pre>"},{"location":"firmwareupdater.html#general-information-about-the-firmware-version","title":"General Information about the Firmware Version","text":"<p>The firmware version is separated into three parts:</p> <ul> <li>The dynamic firmware version is given in the form of a major and minor version (for example: 1.0)</li> <li>The static version starts with S and is given in the form of a major and minor version (for example: S1.2)</li> <li>The PCIe core version starts with P and is given in the form of a major version (for example: P0)</li> </ul> <p>The dynamic firmware is fully integrated in the applets and isn't part of the flashed firmware. This is why the dynamic firmware version is omitted from the firmware flash files. In the FirmwareUpdater, only the static and PCIe core versions are used.</p> <p>Applets are only compatible with a specific static version. Usually, with each Framegrabber SDK installation, the firmware update file matching the version required by the applets is provided. The PCIe core depends on the static version like the applet. It starts with 0 for each new static version. For example, updating from S1.1 P1 to S1.2 P0 doesn't mean downgrading the PCIe core version.</p> <p>Info</p> <p>Unlike with the previous generation of Basler frame grabbers (the microEnable 5 marathon series), applets aren't flashed on the board. Applets can be loaded as long as they match the installed firmware version.</p> <p>The firmware update is partitioned and provides two separate partitions to make updating the firmware safer. Should anything go wrong during the firmware update process, e.g., due to a power failure, only one partition can be compromised. The other partition will automatically be used instead.</p>"},{"location":"firmwareupdater.html#checking-for-firmware-updates","title":"Checking for Firmware Updates","text":"<p>To check for available updates, run the FirmwareUpdater tool without any options and parameters:</p> <pre><code>FirmwareUpdater\n</code></pre> <p>In the following example, there are two boards in the system, and one requires an update:</p> <p></p> <p>The FirmwareUpdater tool will print a short message if any boards require firmware updates.</p>"},{"location":"firmwareupdater.html#updating-the-firmware","title":"Updating the Firmware","text":"<p>To update the frame grabber firmware, use the <code>--update</code> option:</p> <pre><code>FirmwareUpdater --update\n</code></pre> <p>Info</p> <p>Never close the window running FirmwareUpdater, don't press Ctrl-C or interrupt the update process in any other way, and don't shut down or power off your computer before all updates are finished.</p> <p>During the update process, activity and progress is shown with a simple progress bar. FirmwareUpdater will perform all updates automatically:</p> <p></p> <p>When the update process is finished, a short summary is shown and a message is printed, requesting you to power off the computer. Because the firmware is loaded during the power-up phase, activating the updated firmware requires a power-cycle of the computer.</p>"},{"location":"firmwareupdater.html#downgrading-to-an-older-firmware-version","title":"Downgrading to an Older Firmware Version","text":"<p>If a specific older firmware version is required for a frame grabber, the parameters <code>--board &lt;id&gt;</code>, <code>--file &lt;path&gt;</code> and the option <code>--force</code> are needed in combination:</p> <pre><code>FirmwareUpdater --board 0 --file ..\\firmware\\CXP12-IC-1C\\firmware.hap --force\n</code></pre> <p>The output of FirmwareUpdater is the same as during the update process:</p> <p></p> <p>Info</p> <p>Downgrading the frame grabber firmware is only possible using a Framegrabber SDK that provides applets matching the static version installed on the frame grabber.</p>"},{"location":"fixed-issues-in-framegrabber-sdk-5-11-5.html","title":"Fixed Issues in Framegrabber SDK 5.11.5","text":"<p>This section provides information about fixed issues for the Basler Framegrabber SDK version 5.11.5. The following issue has been fixed:</p> <ul> <li>Cameras connected to marathon Camera Link frame grabbers such as ACL or VCL can be accessed via GenPC and CLP as described in this topic. Before fixing this issue, this only worked for Area Scan Acquisition Applets and not for Line Scan Acquisition Applets. This has been fixed. (Ticket ID: 335339)</li> <li>Before fixing this issue, microDisplayX would crash when the Camera tab was clicked while cameras were still being detected. This has been fixed. (Ticket ID: 333828)</li> <li>Before fixing this issue, microDisplayX could freeze on Linux systems when attempting to re-scan an mE6 frame grabber for available applets after an applet had been deleted. This has been fixed. (Ticket ID: 334080)</li> </ul>"},{"location":"flashing-via-command-line.html","title":"Flashing via Command Line","text":"<p>To flash applets on the partitions of the flash memory of your frame grabber, you normally use the GUI tool microDiagnostics. However, you can alternatively flash your board directly via command line. For doing so, you use the command line tool FirmwareFlasherCLI.exe.</p> <p>You find FirmwareFlasherCLI.exe in the Framegrabber SDK installation directory [INSTALLDIR]\\Framegrabber_SDK_5.x.x\\bin.</p> <p>FirmwareFlasherCLI allows to write an applet (*.dll or *.hap file) onto a specific partition of the flash memory of a specific board. You need to specify:</p> <ul> <li>Board index (within your system)</li> <li>Flash memory partition</li> <li>File name (with extension) of applet file</li> <li>FirmwareFlasherCLI looks within your Framegrabber SDK software installation for the specified applet file (in directory [INSTALLDIR]\\Framegrabber_SDK_5.x.x\\firmware\\&lt;frame grabber type&gt;</li> </ul> <p>To start FirmwareFlasherCLI:</p> <ol> <li> <p>Go to the bin directory and enter FirmwareFlasherCLI.exe.</p> <p>The help information is displayed:</p> <p></p> </li> <li> <p>Specify board index, memory partition, and applet file name.     You have the following commands available:</p> <pre><code>FirmwareFlasherCLI.exe  --b &lt;board_index&gt;\n                        --spi   &lt;flashing partition&gt;\n                        &lt;name of applet file&gt;\n</code></pre> <p>Example:</p> <p><code>FirmwareFlasherCLI.exe --board 1 --spi 4 Acq_SingleCXP6X4LineGray.dll</code></p> </li> <li> <p>Press Enter.</p> <p>The tool starts flashing the named partition with the specified applet:</p> <p></p> <p>After successful flashing, you get an according message:</p> <p></p> </li> <li> <p>Follow the instructions of the tool.</p> </li> </ol> <p>If your computer supports live reconfiguration1 of the FPGA (see chipset lists below), you get one of the following messages (A, B or C) after flashing:</p> <p>A) Restart all applications using the board.</p> <ol> <li>Close all applications of the Basler Framegrabber SDK (microDisplay/microDisplay X, microDiagnostics, GenICam Explorer).</li> </ol> <p>After re-opening the Framegrabber SDK applications, the applications provide access to the applet you defined to be the active one. You can continue with configuring the applet via microDisplay X (see Initial System Test (microDisplay X)) or via Framegrabber API.</p> <p>Info</p> <p>High-end mainboards with server level chipset support this behavior. The following chipsets are known to support FPGA live configuration without reboot in some mainboards:</p> <ul> <li>Intel X58 Express</li> <li>Intel X79 Express</li> <li>Intel Z87 (Z99)</li> </ul> <p>Basler doesn`t guarantee behaviour A) with the aforementioned chipsets.</p> <p>B) You should reboot your computer for the changes to be completed.</p> <p>Reboot your computer for PCI performance: After selecting the new applet to be the active one, the PCI speed is reduced. This is so, because PCI may be reduced from generation 2 to generation 1, or the link width changes (e.g. 8 to 4, 4 to 1, \u2026). To get the full PCI bandwidth when using this applet, reboot your computer.</p> <p>Info</p> <p>Reboot not always required: If you intentionally flashed an applet that reduces the PCI speed (in comparison to the applet that has been on marathon before flashing), you don't need to reboot your computer.</p> <p>After re-boot, you get the full bandwidth on the PCI interface and the Framegrabber SDK applications provide access to the applet. You can continue with configuring this applet via microDisplay X (see Initial System Test (microDisplay X)) or via Framegrabber API.</p> <p>Info</p> <p>High-end mainboards with server level chipset support this behavior. The following chipsets are known to support FPGA live configuration without reboot in some mainboards:</p> <ul> <li>Intel X58 Express</li> <li>Intel X79 Express</li> <li>Intel Z87 (Z99)</li> </ul> <p>Basler doesn`t guarantee behaviour B with the aforementioned chipsets.</p> <p>C) You must reboot your computer for the changes to take effect.</p> <p>Reboot host computer:</p> <p>To configure the applet on the active partition, you reboot your computer.</p> <p>After re-boot, the Framegrabber SDK applications provide access to the applet on the active partition. You can continue with configuring this applet via microDisplay X (see Initial System Test (microDisplay X)) or via Framegrabber API.</p> <p>Info</p> <p>The following chipsets are known to require a reboot after FPGA configuration:</p> <ul> <li>Intel C220</li> <li>Intel H87</li> </ul>"},{"location":"flat-field-correction-ffc-imaflex.html","title":"Flat-Field Correction (FFC) (imaFlex CXP-12 Quad)","text":"<p>The Flat-Field Correction (FFC) feature allows you to remove non-uniformities in the image caused by differing light sensitivities of the sensor pixels or by inhomogeneous illumination.</p> <p>A correction of non-uniformities in the image caused by inhomogeneous illumination is called \"shading correction\" or \"vignetting correction\" and can be compensated with a flat field correction.</p> <p>Non-uniformities in the image caused by differing light sensitivities of the sensor pixels is caused by differences of the amplifiers and ADCs of the sensor. For older CMOS sensor, this can be seen in a strong column noise.</p> <p>This has three different effects:</p> <ul> <li>Dark signal non-uniformity (DSNU):<ul> <li>A possible offset for each individual pixel</li> <li>Is independent of the illumination</li> <li>Depends on the temperature of the sensor</li> <li>Has a stronger effect for long exposure times</li> </ul> </li> <li>Photo response non-uniformity (PRNU):<ul> <li>Is caused by different gains of each pixel</li> </ul> </li> <li>Different responses in sensor areas<ul> <li>Some sensors have different responses in specific sensor areas</li> <li>Reasons are the sensor design itself or temperature differences in specific areas</li> <li>For color cameras, this can cause color differences in some areas of the images</li> </ul> </li> </ul> <p>All effects can be corrected with a flat field correction. However, it should be noted that a pixel-wise correction isn't possible with a block flat field correction.</p> <p>The correction itself compensates these inhomogeneities. This is done by a subtraction of the offset values followed by a gain to correct lighting response.</p> <p></p> <p>The Flat-Field Correction (FFC) feature is delivered as plugin with the file name EnhAppletsFFC.dll for pylon. You find information for installing and using this plugin in section Using the Flat-Field Correction for Frame Grabbers in pylon.</p>"},{"location":"flat-field-correction-ffc-imaflex.html#how-it-works","title":"How It Works","text":"<p>The block flat field correction of the EnhancedApplets follow the following process:</p> <p></p>"},{"location":"flat-field-correction-ffc-imaflex.html#determine-offset-and-gain-coefficients","title":"Determine Offset and Gain Coefficients","text":"<p>Before calculation of the correction values some preparation is required.</p> <ul> <li>Your illumination should be as homogeneous as possible</li> <li>Lens aperture and focus should be correctly set</li> <li>The exposure time needs to be configured as well</li> <li>All pre-processing features in the camera such as analog gain, etc. need to be configured.</li> <li>The camera should run at normal operating temperature</li> </ul>"},{"location":"flat-field-correction-ffc-imaflex.html#offset","title":"Offset","text":"<p>Calculating the offset coefficients for the correction follows a standard way with some individual deviations which is explained in this section.</p> <p>To determine the offset coefficients to correct the DSNU or any sensor-related offsets, you must acquire a camera image where the sensor doesn't get any light e.g. with lens cap closed. In theory, the sensor should output all zero values, however, due to the DSNU, the pixel values can have an individual offset. Thus, the acquired dark image represents the offset field, i.e. the offset coefficients.</p> <p>As the DSNU varies with the camera settings and the temperature, you should acquire the images under real conditions, especially regarding exposure and analog gain settings. Moreover, the offset values should be derived from the mean value of multiple images to eliminate the noise.</p> <ul> <li>D(x, y): average dark pixel value over several images at position x,y</li> <li>Offset(x, y) = D(x, y)</li> </ul>"},{"location":"flat-field-correction-ffc-imaflex.html#gain","title":"Gain","text":"<p>The acquired objects in your application have different brightness values. You must identify the brightest parts in your image, e.g white or reflective parts. The exposure, aperture and lighting should be set so that these parts are close but not in saturation. (Unless you want to, because you are interested in dark parts only).</p> <p>For example, you want to investigate bright objects on a dark background. In this case put the object in front of the lens under real exhibition conditions. The brightest spot of the investgigated object should be close, but not in saturation. Lets say for 8 Bit at pixel value 240. Next, you need to illuminate the sensor homogenously with an object close to the same brightness value. For example, this could be a white paper without any structures. Again, none of the pixel should be in saturation. Record some of these reference images and calculate an average image P(x,y)</p> <p>Next, several methods exist to derive the reference pixel value for the gain correction.</p> <ol> <li> <p>Mean value in reference image:    If the brightest parts in P(x,y) are equal to the brightest parts of the acquired objects. Thus, you can use the mean pixel value of P(x,y) as a reference. PMean = Mean(P(x,y))    The gain coefficients will then be:</p> \\[ Gain(x,y) = \\frac{PMean}{(P(x,y)-Offset(x,y))} \\] </li> <li> <p>User define reference value or brightest spot:    If the mean brightness in your reference image is not equal to the desired maximum pixel values, you can define a reference value by yourself. This could be the value of the brightest spot in your image or the difference between your reference object and reference bright image.    The gain values will then be calculated so that the pixels of the homogenous images are corrected to this reference value Pref.</p> \\[ Gain(x,y) = \\frac{PRef}{(P(x,y)-Offset(x,y))} \\] </li> </ol> <p>In both formulas, the previously determined offset is subtracted prior to the division. This must not be done, if P(x,y) is already corrected by the offset in a two step procedure.</p>"},{"location":"flat-field-correction-ffc-imaflex.html#ffc-for-bayer-pixel-format","title":"FFC for Bayer Pixel Format","text":"<p>For the Bayer pixel format, the FFC is processed on the RAW Bayer images before converting them to RGB or any other color space. This gives a maximum precision. Calculating the correction coefficients is done individually for each color component. As a side effect, the FFC also does the color calibration as the reference image is corrected to a perfect white image.</p>"},{"location":"flat-field-correction-ffc-imaflex.html#definition-of-block-flat-field-correction","title":"Definition of Block Flat Field Correction","text":"<p>The block-based flat field correction is used when there isn't enough memory to store a correction value for each individual pixel. In that case, the image is split into blocks whose sizes you can define. Each block has its own starting offset and gain coefficient at the corners.</p> <p></p> <p>For all pixels in-between, the coefficients are determined using linear interpolation inside the frame grabber.</p> <p></p> <p>This results in a very precise correction, but it can't correct individual pixels especially for DSNU and PRNU caused by individual pixel variations.</p> <p></p>"},{"location":"flat-field-correction-ffc-imaflex.html#manual-calculation-of-the-block-size-and-applet-parameter-values","title":"Manual Calculation of the Block Size and Applet Parameter Values","text":"<p>To use the block FFC in the applet, you must perform two steps after the correction values have been calculated:</p> <ol> <li>Configure the block size.</li> <li>Load the correction coefficients onto the frame grabber.</li> </ol>"},{"location":"flat-field-correction-ffc-imaflex.html#configuring-the-block-size","title":"Configuring the Block Size","text":"<p>As you can connect any camera with different resolutions to the frame grabber, the applet implementation is made to adapt to different resolutions.</p> <p>All blocks have the same size, but they don't need to be squares, i.e. height and width might differ. The frame grabber offers a total of 16384 blocks for Offset and Gain correction values. Thus, you must adapt the block so that the blocks can be distributed to the image size.</p> <p>Example: The boost v boA5120-230cm has a resolution of 5120 x 4096 pixels. If you want to use the full resolution, you must distribute the available 16384 blocks to all these blocks.</p> <p>The blocks don't necessarily need to be square-shaped. Maybe your shading is stronger in X- than in Y-direction, so you should have a smaller block size in X and a larger block size in Y.</p> <p>The following image shows non-squared blocks, where the resolution in X-direction is higher than in Y-direction:</p> <p></p> <p>To equally distribute the 16384 blocks as square blocks over the whole image, use the following formulas.</p> <ul> <li>Image width: W</li> <li>Image height: H</li> <li>Total number of blocks: N</li> </ul> <p>The total area of the image is: Image Area = W x H</p> <p>Each block is square with a side length <code>s</code>. The area of one block is: Block Area = s<sup>2</sup></p> <p>The number of blocks is:</p> \\[ N = \\frac{Image\\space Area}{Block\\space Area} = \\frac{W\\times H}{s^2} \\] <p>To find <code>s</code>:</p> \\[ s = \\sqrt{\\frac{W\\times H}{N}} \\] <p>For the example above: W = 5120, H = 4096, N = 16384:</p> \\[ s = \\sqrt{\\frac{5120\\times 4096}{16384}} = \\sqrt{1280} = 35.78\\space pixels \\] <p>Not every block side length can be configured in the applets. For example, the block size in X-direction needs to be a multiple of 16.</p> <p>For the given example, the block size is rounded down to B<sub>x</sub>= 32.</p> <p>To calculate the block height, you need to consider non-squared blocks to fully use the available blocks:</p> <p>s<sup>2</sup> = block size in X x block size in Y = B<sub>x</sub> x B<sub>y</sub></p> <p>The block height can then be determined as:</p> \\[ B_y=\\left \\lceil\\frac{W\\times H}{N\\times B_x}\\right \\rceil \\] <p>For the example above, this will be:</p> \\[ B_y=\\left \\lceil\\frac{5120 \\times 4096}{16384 \\times 32}\\right \\rceil = 40 \\space pixels \\] <p>The actual used number of blocks will then be:</p> \\[ N_{actual}= \\left \\lceil\\frac{W}{B_x}\\right \\rceil \\times \\left \\lceil\\frac{H}{B_y}\\right \\rceil = 16384\\space blocks \\] <p>You can now set the applet parameters:</p> <ul> <li><code>FlatFieldCorrectionBlockWidth</code> = 32</li> <li><code>FlatFieldCorrectionBlockHeight</code> = 40</li> </ul> <p></p>"},{"location":"flat-field-correction-ffc-imaflex.html#loading-the-correction-coefficients-offset-and-gain","title":"Loading the Correction Coefficients Offset and Gain","text":"<p>Each block requires a set of four offset and gain coefficient values Q<sub>11</sub>,Q<sub>12</sub>,Q<sub>21</sub>,Q<sub>22</sub>. Those values are the support-positions at the edges of the block.</p> <p></p> <p>The end position of a block is the starting position of the next block. So Q<sub>11</sub>,Q<sub>12</sub> of a current block is equal to Q<sub>21</sub>,Q<sub>22</sub> of the next horizontal block.</p> <p>The following example shows a block size of 4x3 at an image of size 8x6. It's obvious that the end-positions overlap with the start-positions of the next block. Moreover, the block end support positions at the image edge are outside the image boundaries. If the block size isn't an integer divisor of the image size, the blocks at the image edge will be even further outside of the image.</p> <p></p> <ul> <li>Block 0<ul> <li>Q<sub>11</sub> at x = 0, y = 0</li> <li>Q<sub>12</sub> at x = 4, y = 0</li> <li>Q<sub>21</sub> at x = 0, y = 3</li> <li>Q<sub>22</sub> at x = 4, y = 3</li> </ul> </li> <li>Block 1<ul> <li>Q<sub>11</sub> at x = 4, y = 0</li> <li>Q<sub>12</sub> at x = 8, y = 0</li> <li>Q<sub>21</sub> at x = 4, y = 3</li> <li>Q<sub>22</sub> at x = 6, y = 3</li> </ul> </li> <li>Block 2<ul> <li>Q<sub>11</sub> at x = 0, y = 3</li> <li>Q<sub>12</sub> at x = 4, y = 3</li> <li>Q<sub>21</sub> at x = 0, y = 6</li> <li>Q<sub>22</sub> at x = 4, y = 6</li> </ul> </li> <li>Block 1<ul> <li>Q<sub>11</sub> at x = 4, y = 3</li> <li>Q<sub>12</sub> at x = 8, y = 3</li> <li>Q<sub>21</sub> at x = 4, y = 6</li> <li>Q<sub>22</sub> at x = 6, y = 6</li> </ul> </li> </ul> <p>The values for Offset and Gain are represented as fixed point values with a specific range and resolution. The applet has some info parameters to check the range.</p> <p></p> <p>For the given example, the Gain values have the following range:</p> \\[ \\left [0,2^{GainInteger} - \\frac{1}{2^{GainFractional}}\\right ] = \\left [0,2^{2} - \\frac{1}{2^{10}} \\right ] = \\left [0, \\space 3.999\\right ] \\] <p>In other words, the applet allows gain corrections up to 3.999. For example, a pixel value 50 could be corrected at maximum to 50 x 3.999 = 199.</p> <p>To convert a float value into a fixed point value, multiply it with the fractional bits and limit it to the ranges [0,2<sup>GainBits</sup> - 1], where GainBits = GainInteger + GainFractional.</p> \\[ Gain_{FixedPoint} = Gain_{Float} \\times 2^{GainFractional} \\] <p>The fixed- point values Q<sub>11</sub>,Q<sub>12</sub>,Q<sub>21</sub>,Q<sub>22</sub> are appended to a large integer value for each block.</p> \\[ Block(i) = Qfix_{11}\\times 2^0 + Qfix_{12} \\times 2^{GainBits} + Qfix_{21} \\times 2^{2\\times GainBits} + Qfix_{22} \\times 2^{3\\times GainBits} \\] <p>Or as a bit shift operation:</p> \\[ Block(i) = Qfix_{11} + Qfix_{12} \\ll  GainBits + Qfix_{21} \\ll  2\\times GainBits + Qfix_{22} \\ll  3\\times GainBits \\] <p>For example, float values:</p> \\[ Q_{11} = 1.1, Q_{12} = 1.3, Q_{21} = 0.9, Q_{22} = 1.4 \\] <p>are converted to fixed-point using the resolution above to</p> \\[ Q_{11} = 1126, Q_{12} = 1331, Q_{21} = 922, Q_{22} = 1433 \\] <p>The applet value becomes</p> \\[ Q_{11} = 1126, Q_{12} = 1331, Q_{21} = 922, Q_{22} = 1433 \\] <p>Hence the applet parameter value becomes</p> \\[ Block(i) = 1126 + 1331 \\ll 12 + 922 \\ll  2\\times 12 + 1433 \\ll  3\\times 12 = 98490484208742 \\] <p>In hexadecimal representation:</p> \\[ Block(i) = 0\\times 466 + 0\\times 533 \\ll  12 +0\\times 39A \\ll 2\\times 12 + 0\\times 599 \\ll 3\\times 12 = 0\\times 599\\space  39A\\space 533\\space 466 \\]"},{"location":"flat-field-correction-ffc-imaflex.html#using-the-flat-field-correction-for-frame-grabbers-in-pylon","title":"Using the Flat-Field Correction for Frame Grabbers in pylon","text":"<p>The Flat-Field Correction (FFC) feature is delivered as plugin with the file name EnhAppletsFFC.dll for pylon. To install the pylon FFC plugin, copy the file EnhAppletsFFC.dll to the pylon installation folder Applications\\x64\\lib\\pylonviewer\\plugins.</p> <p></p> <p>Before using the plugin, you should do some preparations:</p> <ul> <li>To understand the underlying theory, see the sections How It Works.</li> <li>To understand what the plugin is doing to determine the FFC correction values, see Determine Offset and Gain Coefficients.</li> </ul> <p>Before calculating the correction values, you must ensure the following:</p> <ul> <li>Your illumination should be as homogeneous as possible.</li> <li>Lens aperture and focus should be correctly set.</li> <li>The exposure time needs to be configured as well.</li> <li>All pre-processing features in the camera such as analog gain, etc. must be configured.</li> <li>The correct EnhancedApplet is loaded.</li> <li>Set the correct camera pixel format in camera and applet.</li> <li>The camera should run at normal operating temperature.</li> <li>Don't set any pre-processing in the applet. You must obtain an image at full ROI.</li> </ul> <p>Basler recommends to do this in microDisplay X first, so you can use the features Histogram and Line Profile for calibration.</p> <p></p> <p>The screenshot shows the acquisition of an image in pylon Viewer. As you can see from the line profile,  there is a strong shading towards the corners of the image. Furthermore, some pixels are in saturation. This is on purpose since the darker parts of the object are the ones of interest. This is also a realistic example for machine vision applications.</p> <p>Now, remove the object and provide a homogeneously illuminated background, which you see also in the example.</p> <p>Then you can start the plugin:</p> <ol> <li>A camera must be selected.</li> <li>Stop the acquisition.</li> <li>In the pylon Viewer, select Tools &gt; EnhancedApplets &gt; Flat Field Correction.</li> </ol> <p></p> <p>Once the plugin is started, you see information of your settings, whether the applet can do a block FFC and a live image:</p> <p></p> <p>Click Next to get to the next step. You can now calculate the offset correction values by acquiring a sequence of dark images. Click Calculate Offset. The plugin displays a scaled image and some statistics so that you can see the maximum and average offset values:</p> <p></p> <p>Click Next to get to the next step. On the next page, you can acquire a sequence of bright reference images to obtain the gain correction value. Place a homogenous bright object under the lens and start the calculation. Again, the displayed image visualizes the gain. You can select whether you want to see the acquired image or corrected image instead.</p> <p></p> <p>You can see in the screenshot above that the bright reference image isn't close to the saturation. So you might want to enter a reference value, which is higher than the automatically derived value from the image average. Set a value to e.g. <code>230</code>or even <code>300</code>.</p> <p></p> <p>Click Next. On the next page, set the block size or do an automatic calculation. For the given example, an image size of 5120 x5 120 px is used, so for example a block size of 48 x 34 px results in a total of 16157 blocks, which is less than the available total of 16384 blocks. Set edge handling to half block and set Linear extension.</p> <p></p> <p>Store the correction values to disc so that the FFC in the applet can load and apply them. Click Save to Folder\u2026 and select an empty folder. Once the calculation is successfully processed, files are generated into this folder.</p> <p>Click Next. On the next page, you can apply the determined coefficients directly to the loaded applet and you can see the results.</p> <p></p> <p>The Line Profile now shows a homogenous image and a high-quality image can be acquired. Use the <code>FFC mode parameter</code> to toggle the FFC on or off.</p> <p></p>"},{"location":"flat-field-correction-ffc-imaflex.html#using-correction-values-in-sdk-applications","title":"Using Correction Values in SDK Applications","text":"<p>Each time you restart your computer or open the frame grabber application, the FFC settings must be re-loaded to the frame grabber. A frame grabber has a volatile memory, so no data can be stored as opposed to the camera user sets on the cameras.</p> <p>Thus, in your SDK application (pylon API, GenApi, GenTL consumer or Framegrabber SDK), you must configure the FFC:</p> <ol> <li>Set the block width and height.</li> <li>Load the offset and gain correction files which you have stored using the plyon Viewer FFC plugin.</li> <li>While saving the files, the plugin also generates a configuration text file for your reference. pylon Viewer offers the possibility to obtain a sample C++ code for the pylon C++ API.</li> </ol>"},{"location":"flat-field-correction-ffc-imaflex.html#using-the-hierarchical-box-in-visualapplets","title":"Using the Hierarchical Box in VisualApplets","text":"<p>The functional blocks can be provided as VisualApplets User Libraries or hierarchical boxes in a design. This is done depending on your project and project environment. You can get the hierarchical box for the enhanced applets from your local Basler Sales representative or field application engineer.</p> <p>The use of the hierarchical box in VisualApplets is similar to the use of the Enhanced Applets. The process is as follows:</p> <ol> <li>Do the calculation of the coefficients with the pylon Viewer FFC plugin and Enhanced Applets.</li> <li>Write the correction coefficients and configuration to files  using the FFC plugin.</li> <li>Open the flat-field correction hierarchical box in a design of VisualApplets.</li> <li> <p>Configure the static parameters of the FFC hierarchical block in VisualApplets.</p> <p>The hierarchical box automatically adapts to the pixel bit width, parallelism and image format. First, you must parameterize the input link. It's important to do this before setting the static parameters.</p> <p>Allowed formats are:</p> <ul> <li><code>Bit width</code>: 8  to 16</li> <li><code>Artithmetic</code>: unsigned</li> <li><code>Parallelism</code>: 1 to 64</li> <li><code>Kernel Columns</code>, <code>Kernel Rows</code>: 1</li> <li><code>Color Forma</code>t: VAF_GRAY</li> <li><code>Color Flavor</code>: FL_NONE</li> <li><code>Max. Image Width</code>: any</li> <li><code>Max. Image Height</code>: any</li> </ul> <p>The static parameters define the precision and FPGA resource usage of the block-based FFC:</p> <ul> <li><code>OffsetBits</code>: Defines the number of bits used for offset correction. This is the sum of the integer and fractional bits.</li> <li><code>OffsetFractionalBits</code>: Defines the number of fractional bits. For fixed point arithmetic explanation see section Loading of the Correction Coefficients Offset and Gain.</li> <li><code>GainBits</code>: Defines the number of bits used for gain correction. This is the sum of the integer and fractional bits.</li> <li><code>GainFractionalBits</code>: Defines the number of fractional bits. For fixed point arithmetic explanation see section Loading of the Correction Coefficients Offset and Gain.</li> <li><code>MemoryType</code>: Select either UltraRAM, Block RAM, or LUT RAM. UltraRAM is recommended.</li> <li><code>MaxNumbrOfBlocks</code>: Select the maximum number of blocks used for the block FFC. If you had selected URAM as <code>MemoryType</code>, only 16384 blocks can be used.</li> <li><code>MaxNumberOfBlocksInX</code>: Define the maximum number of blocks in X-direction. Usually this should be <code>Max. Image Width</code> / <code>Parallelism</code>.</li> <li><code>MaxNumberOfBlocksInY</code>: Define the maximum number of blocks in Y-direction.</li> <li><code>MaxBlockSizeInX</code>: Define the maximum block size in X-direction. Choose a suitable value for your application. For a general purpose use, you can set the full image width.</li> <li><code>MaxBlockSizeInY</code>: Define the maximum block size in Y-direction. Choose a suitable value for your application. For a general purpose use, you can set the full image height.</li> </ul> <p>The dynamic parameters can be changed during runtime to the application requirements:</p> <ul> <li><code>CoefficientsXLength</code>: This value needs to match to the calculated and uploaded coefficient files, e.g. the ROI size of the Enhanced Applet which you have used in the pylon Viewer and the FFC plugin.</li> <li><code>CoefficientsYLength</code>: This value needs to match to the calculated and uploaded coefficient files, e.g. the ROI size of the Enhanced Applet which you have used in the pylon Viewer and the FFC plugin.</li> <li><code>BlockSizeMode</code>: Select <code>Manual</code> or <code>Auto</code>. In auto mode, the available blocks will be distributed over the image. For manual mode, the following parameters can be used to set the block size. If you used the FFC plugin in the pylon Viewer, copy the corresponding values:<ul> <li><code>BlockSizeInX</code>: Define the block size if <code>BlockSizeMode</code> is set to <code>Manual</code>. If you used the FFC plugin in the pylon Viewer, copy the corresponding values to this parameter.</li> <li><code>BlockSizeInY</code>: Define the block size if <code>BlockSizeMode</code> is set to <code>Manual</code>. If you used the FFC plugin in pylonViewer, copy the corresponding values to this parameter.</li> <li><code>EnoughBlocksForImageSize</code>: This read-only parameter indicates whether the defined maximum number of blocks are enough for the given block size and ROI setting.</li> <li><code>OffsetCoefficients</code>: Is a field parameter for the offset coefficients. Upload the text file from the FFC pylon plugin. You find a description of the format in section Loading of the Correction Coefficients Offset and Gain.</li> <li><code>GainCoefficients</code>: Is a field parameter for the offset coefficients. Upload the text file from the FFC pylon plugin. You find a description of the format in section Loading of the Correction Coefficients Offset and Gain.</li> <li><code>FlatFieldCorrectionMode</code>: Select, if you want the FFC Offset and Gain on or off. This can be done during image acquisition.</li> </ul> </li> </ul> </li> <li> <p>Configure the dynamic parameters of the FFC hierarchical block either during design time in VisualApplets or during runtime with your SDK application (pylon API, GenApi, GenTL consumer or Framegrabber SDK).</p> </li> </ol> <p>The following screenshot shows the use of the FFC hierarchical box in VisualApplets together with the parameters.</p> <p></p>"},{"location":"flat-field-correction-ffc-imaworx.html","title":"Flat-Field Correction (FFC) (imaWorx CXP-12 Quad)","text":"<p>The Flat-Field Correction (FFC) feature allows you to remove non-uniformities in the image caused by differing light sensitivities of the sensor pixels or by inhomogeneous illumination.</p> <p>A correction of non-uniformities in the image caused by inhomogeneous illumination is called \"shading correction\" or \"vignetting correction\" and can be compensated with a flat field correction.</p> <p>Non-uniformities in the image caused by differing light sensitivities of the sensor pixels is caused by differences of the amplifiers and ADCs of the sensor. For older CMOS sensor, this can be seen in a strong column noise.</p> <p>This has three different effects:</p> <ul> <li>Dark signal non-uniformity (DSNU):<ul> <li>A possible offset for each individual pixel</li> <li>Is independent of the illumination</li> <li>Depends on the temperature of the sensor</li> <li>Has a stronger effect for long exposure times</li> </ul> </li> <li>Photo response non-uniformity (PRNU):<ul> <li>Is caused by different gains of each pixel</li> </ul> </li> <li>Different responses in sensor areas<ul> <li>Some sensors have different responses in specific sensor areas</li> <li>Reasons are the sensor design itself or temperature differences in specific areas</li> <li>For color cameras, this can cause color differences in some areas of the images</li> </ul> </li> </ul> <p>All effects can be corrected with a flat field correction. However, it should be noted that a pixel-wise correction isn't possible with a block flat field correction.</p> <p>The correction itself compensates these inhomogeneities. This is done by a subtraction of the offset values followed by a gain to correct lighting response.</p> <p></p> <p>The Flat-Field Correction (FFC) feature is delivered as plugin with the file name EnhAppletsFFC.dll for pylon. You find information for installing and using this plugin in section Using the Flat-Field Correction for Frame Grabbers in pylon.</p>"},{"location":"flat-field-correction-ffc-imaworx.html#how-it-works","title":"How It Works","text":"<p>The block flat field correction of the EnhancedApplets follow the following process:</p> <p></p>"},{"location":"flat-field-correction-ffc-imaworx.html#determine-offset-and-gain-coefficients","title":"Determine Offset and Gain Coefficients","text":"<p>Before calculation of the correction values some preparation is required.</p> <ul> <li>Your illumination should be as homogeneous as possible</li> <li>Lens aperture and focus should be correctly set</li> <li>The exposure time needs to be configured as well</li> <li>All pre-processing features in the camera such as analog gain, etc. need to be configured.</li> <li>The camera should run at normal operating temperature</li> </ul>"},{"location":"flat-field-correction-ffc-imaworx.html#offset","title":"Offset","text":"<p>Calculating the offset coefficients for the correction follows a standard way with some individual deviations which is explained in this section.</p> <p>To determine the offset coefficients to correct the DSNU or any sensor-related offsets, you must acquire a camera image where the sensor doesn't get any light e.g. with lens cap closed. In theory, the sensor should output all zero values, however, due to the DSNU, the pixel values can have an individual offset. Thus, the acquired dark image represents the offset field, i.e. the offset coefficients.</p> <p>As the DSNU varies with the camera settings and the temperature, you should acquire the images under real conditions, especially regarding exposure and analog gain settings. Moreover, the offset values should be derived from the mean value of multiple images to eliminate the noise.</p> <ul> <li>D(x, y): average dark pixel value over several images at position x,y</li> <li>Offset(x, y) = D(x, y)</li> </ul>"},{"location":"flat-field-correction-ffc-imaworx.html#gain","title":"Gain","text":"<p>The acquired objects in your application have different brightness values. You must identify the brightest parts in your image, e.g white or reflective parts. The exposure, aperture and lighting should be set so that these parts are close but not in saturation. (Unless you want to, because you are interested in dark parts only).</p> <p>For example, you want to investigate bright objects on a dark background. In this case put the object in front of the lens under real exhibition conditions. The brightest spot of the investgigated object should be close, but not in saturation. Lets say for 8 Bit at pixel value 240. Next, you need to illuminate the sensor homogenously with an object close to the same brightness value. For example, this could be a white paper without any structures. Again, none of the pixel should be in saturation. Record some of these reference images and calculate an average image P(x,y)</p> <p>Next, several methods exist to derive the reference pixel value for the gain correction.</p> <ol> <li> <p>Mean value in reference image:    If the brightest parts in P(x,y) are equal to the brightest parts of the acquired objects. Thus, you can use the mean pixel value of P(x,y) as a reference. PMean = Mean(P(x,y))    The gain coefficients will then be:</p> \\[ Gain(x,y) = \\frac{PMean}{(P(x,y)-Offset(x,y))} \\] </li> <li> <p>User define reference value or brightest spot:    If the mean brightness in your reference image is not equal to the desired maximum pixel values, you can define a reference value by yourself. This could be the value of the brightest spot in your image or the difference between your reference object and reference bright image.    The gain values will then be calculated so that the pixels of the homogenous images are corrected to this reference value Pref.</p> \\[ Gain(x,y) = \\frac{PRef}{(P(x,y)-Offset(x,y))} \\] </li> </ol> <p>In both formulas, the previously determined offset is subtracted prior to the division. This must not be done, if P(x,y) is already corrected by the offset in a two step procedure.</p>"},{"location":"flat-field-correction-ffc-imaworx.html#ffc-for-bayer-pixel-format","title":"FFC for Bayer Pixel Format","text":"<p>For the Bayer pixel format, the FFC is processed on the RAW Bayer images before converting them to RGB or any other color space. This gives a maximum precision. Calculating the correction coefficients is done individually for each color component. As a side effect, the FFC also does the color calibration as the reference image is corrected to a perfect white image.</p>"},{"location":"flat-field-correction-ffc-imaworx.html#definition-of-block-flat-field-correction","title":"Definition of Block Flat Field Correction","text":"<p>The block-based flat field correction is used when there isn't enough memory to store a correction value for each individual pixel. In that case, the image is split into blocks whose sizes you can define. Each block has its own starting offset and gain coefficient at the corners.</p> <p></p> <p>For all pixels in-between, the coefficients are determined using linear interpolation inside the frame grabber.</p> <p></p> <p>This results in a very precise correction, but it can't correct individual pixels especially for DSNU and PRNU caused by individual pixel variations.</p> <p></p>"},{"location":"flat-field-correction-ffc-imaworx.html#manual-calculation-of-the-block-size-and-applet-parameter-values","title":"Manual Calculation of the Block Size and Applet Parameter Values","text":"<p>To use the block FFC in the applet, you must perform two steps after the correction values have been calculated:</p> <ol> <li>Configure the block size.</li> <li>Load the correction coefficients onto the frame grabber.</li> </ol>"},{"location":"flat-field-correction-ffc-imaworx.html#configuring-the-block-size","title":"Configuring the Block Size","text":"<p>As you can connect any camera with different resolutions to the frame grabber, the applet implementation is made to adapt to different resolutions.</p> <p>All blocks have the same size, but they don't need to be squares, i.e. height and width might differ. The frame grabber offers a total of 16384 blocks for Offset and Gain correction values. Thus, you must adapt the block so that the blocks can be distributed to the image size.</p> <p>Example: The boost v boA5120-230cm has a resolution of 5120 x 4096 pixels. If you want to use the full resolution, you must distribute the available 16384 blocks to all these blocks.</p> <p>The blocks don't necessarily need to be square-shaped. Maybe your shading is stronger in X- than in Y-direction, so you should have a smaller block size in X and a larger block size in Y.</p> <p>The following image shows non-squared blocks, where the resolution in X-direction is higher than in Y-direction:</p> <p></p> <p>To equally distribute the 16384 blocks as square blocks over the whole image, use the following formulas.</p> <ul> <li>Image width: W</li> <li>Image height: H</li> <li>Total number of blocks: N</li> </ul> <p>The total area of the image is: Image Area = W x H</p> <p>Each block is square with a side length <code>s</code>. The area of one block is: Block Area = s<sup>2</sup></p> <p>The number of blocks is:</p> \\[ N = \\frac{Image\\space Area}{Block\\space Area} = \\frac{W\\times H}{s^2} \\] <p>To find <code>s</code>:</p> \\[ s = \\sqrt{\\frac{W\\times H}{N}} \\] <p>For the example above: W = 5120, H = 4096, N = 16384:</p> \\[ s = \\sqrt{\\frac{5120\\times 4096}{16384}} = \\sqrt{1280} = 35.78\\space pixels \\] <p>Not every block side length can be configured in the applets. For example, the block size in X-direction needs to be a multiple of 16.</p> <p>For the given example, the block size is rounded down to B<sub>x</sub>= 32.</p> <p>To calculate the block height, you need to consider non-squared blocks to fully use the available blocks:</p> <p>s<sup>2</sup> = block size in X x block size in Y = B<sub>x</sub> x B<sub>y</sub></p> <p>The block height can then be determined as:</p> \\[ B_y=\\left \\lceil\\frac{W\\times H}{N\\times B_x}\\right \\rceil \\] <p>For the example above, this will be:</p> \\[ B_y=\\left \\lceil\\frac{5120 \\times 4096}{16384 \\times 32}\\right \\rceil = 40 \\space pixels \\] <p>The actual used number of blocks will then be:</p> \\[ N_{actual}= \\left \\lceil\\frac{W}{B_x}\\right \\rceil \\times \\left \\lceil\\frac{H}{B_y}\\right \\rceil = 16384\\space blocks \\] <p>You can now set the applet parameters:</p> <ul> <li><code>FlatFieldCorrectionBlockWidth</code> = 32</li> <li><code>FlatFieldCorrectionBlockHeight</code> = 40</li> </ul> <p></p>"},{"location":"flat-field-correction-ffc-imaworx.html#loading-the-correction-coefficients-offset-and-gain","title":"Loading the Correction Coefficients Offset and Gain","text":"<p>Each block requires a set of four offset and gain coefficient values Q<sub>11</sub>,Q<sub>12</sub>,Q<sub>21</sub>,Q<sub>22</sub>. Those values are the support-positions at the edges of the block.</p> <p></p> <p>The end position of a block is the starting position of the next block. So Q<sub>11</sub>,Q<sub>12</sub> of a current block is equal to Q<sub>21</sub>,Q<sub>22</sub> of the next horizontal block.</p> <p>The following example shows a block size of 4x3 at an image of size 8x6. It's obvious that the end-positions overlap with the start-positions of the next block. Moreover, the block end support positions at the image edge are outside the image boundaries. If the block size isn't an integer divisor of the image size, the blocks at the image edge will be even further outside of the image.</p> <p></p> <ul> <li>Block 0<ul> <li>Q<sub>11</sub> at x = 0, y = 0</li> <li>Q<sub>12</sub> at x = 4, y = 0</li> <li>Q<sub>21</sub> at x = 0, y = 3</li> <li>Q<sub>22</sub> at x = 4, y = 3</li> </ul> </li> <li>Block 1<ul> <li>Q<sub>11</sub> at x = 4, y = 0</li> <li>Q<sub>12</sub> at x = 8, y = 0</li> <li>Q<sub>21</sub> at x = 4, y = 3</li> <li>Q<sub>22</sub> at x = 6, y = 3</li> </ul> </li> <li>Block 2<ul> <li>Q<sub>11</sub> at x = 0, y = 3</li> <li>Q<sub>12</sub> at x = 4, y = 3</li> <li>Q<sub>21</sub> at x = 0, y = 6</li> <li>Q<sub>22</sub> at x = 4, y = 6</li> </ul> </li> <li>Block 1<ul> <li>Q<sub>11</sub> at x = 4, y = 3</li> <li>Q<sub>12</sub> at x = 8, y = 3</li> <li>Q<sub>21</sub> at x = 4, y = 6</li> <li>Q<sub>22</sub> at x = 6, y = 6</li> </ul> </li> </ul> <p>The values for Offset and Gain are represented as fixed point values with a specific range and resolution. The applet has some info parameters to check the range.</p> <p></p> <p>For the given example, the Gain values have the following range:</p> \\[ \\left [0,2^{GainInteger} - \\frac{1}{2^{GainFractional}}\\right ] = \\left [0,2^{2} - \\frac{1}{2^{10}} \\right ] = \\left [0, \\space 3.999\\right ] \\] <p>In other words, the applet allows gain corrections up to 3.999. For example, a pixel value 50 could be corrected at maximum to 50 x 3.999 = 199.</p> <p>To convert a float value into a fixed point value, multiply it with the fractional bits and limit it to the ranges [0,2<sup>GainBits</sup> - 1], where GainBits = GainInteger + GainFractional.</p> \\[ Gain_{FixedPoint} = Gain_{Float} \\times 2^{GainFractional} \\] <p>The fixed- point values Q<sub>11</sub>,Q<sub>12</sub>,Q<sub>21</sub>,Q<sub>22</sub> are appended to a large integer value for each block.</p> \\[ Block(i) = Qfix_{11}\\times 2^0 + Qfix_{12} \\times 2^{GainBits} + Qfix_{21} \\times 2^{2\\times GainBits} + Qfix_{22} \\times 2^{3\\times GainBits} \\] <p>Or as a bit shift operation:</p> \\[ Block(i) = Qfix_{11} + Qfix_{12} \\ll  GainBits + Qfix_{21} \\ll  2\\times GainBits + Qfix_{22} \\ll  3\\times GainBits \\] <p>For example, float values:</p> \\[ Q_{11} = 1.1, Q_{12} = 1.3, Q_{21} = 0.9, Q_{22} = 1.4 \\] <p>are converted to fixed-point using the resolution above to</p> \\[ Q_{11} = 1126, Q_{12} = 1331, Q_{21} = 922, Q_{22} = 1433 \\] <p>The applet value becomes</p> \\[ Q_{11} = 1126, Q_{12} = 1331, Q_{21} = 922, Q_{22} = 1433 \\] <p>Hence the applet parameter value becomes</p> \\[ Block(i) = 1126 + 1331 \\ll 12 + 922 \\ll  2\\times 12 + 1433 \\ll  3\\times 12 = 98490484208742 \\] <p>In hexadecimal representation:</p> \\[ Block(i) = 0\\times 466 + 0\\times 533 \\ll  12 +0\\times 39A \\ll 2\\times 12 + 0\\times 599 \\ll 3\\times 12 = 0\\times 599\\space  39A\\space 533\\space 466 \\]"},{"location":"flat-field-correction-ffc-imaworx.html#using-the-flat-field-correction-for-frame-grabbers-in-pylon","title":"Using the Flat-Field Correction for Frame Grabbers in pylon","text":"<p>The Flat-Field Correction (FFC) feature is delivered as plugin with the file name EnhAppletsFFC.dll for pylon. To install the pylon FFC plugin, copy the file EnhAppletsFFC.dll to the pylon installation folder Applications\\x64\\lib\\pylonviewer\\plugins.</p> <p></p> <p>Before using the plugin, you should do some preparations:</p> <ul> <li>To understand the underlying theory, see the sections How It Works.</li> <li>To understand what the plugin is doing to determine the FFC correction values, see Determine Offset and Gain Coefficients.</li> </ul> <p>Before calculating the correction values, you must ensure the following:</p> <ul> <li>Your illumination should be as homogeneous as possible.</li> <li>Lens aperture and focus should be correctly set.</li> <li>The exposure time needs to be configured as well.</li> <li>All pre-processing features in the camera such as analog gain, etc. must be configured.</li> <li>The correct EnhancedApplet is loaded.</li> <li>Set the correct camera pixel format in camera and applet.</li> <li>The camera should run at normal operating temperature.</li> <li>Don't set any pre-processing in the applet. You must obtain an image at full ROI.</li> </ul> <p>Basler recommends to do this in microDisplay X first, so you can use the features Histogram and Line Profile for calibration.</p> <p></p> <p>The screenshot shows the acquisition of an image in pylon Viewer. As you can see from the line profile,  there is a strong shading towards the corners of the image. Furthermore, some pixels are in saturation. This is on purpose since the darker parts of the object are the ones of interest. This is also a realistic example for machine vision applications.</p> <p>Now, remove the object and provide a homogeneously illuminated background, which you see also in the example.</p> <p>Then you can start the plugin:</p> <ol> <li>A camera must be selected.</li> <li>Stop the acquisition.</li> <li>In the pylon Viewer, select Tools &gt; EnhancedApplets &gt; Flat Field Correction.</li> </ol> <p></p> <p>Once the plugin is started, you see information of your settings, whether the applet can do a block FFC and a live image:</p> <p></p> <p>Click Next to get to the next step. You can now calculate the offset correction values by acquiring a sequence of dark images. Click Calculate Offset. The plugin displays a scaled image and some statistics so that you can see the maximum and average offset values:</p> <p></p> <p>Click Next to get to the next step. On the next page, you can acquire a sequence of bright reference images to obtain the gain correction value. Place a homogenous bright object under the lens and start the calculation. Again, the displayed image visualizes the gain. You can select whether you want to see the acquired image or corrected image instead.</p> <p></p> <p>You can see in the screenshot above that the bright reference image isn't close to the saturation. So you might want to enter a reference value, which is higher than the automatically derived value from the image average. Set a value to e.g. <code>230</code>or even <code>300</code>.</p> <p></p> <p>Click Next. On the next page, set the block size or do an automatic calculation. For the given example, an image size of 5120 x5 120 px is used, so for example a block size of 48 x 34 px results in a total of 16157 blocks, which is less than the available total of 16384 blocks. Set edge handling to half block and set Linear extension.</p> <p></p> <p>Store the correction values to disc so that the FFC in the applet can load and apply them. Click Save to Folder\u2026 and select an empty folder. Once the calculation is successfully processed, files are generated into this folder.</p> <p>Click Next. On the next page, you can apply the determined coefficients directly to the loaded applet and you can see the results.</p> <p></p> <p>The Line Profile now shows a homogenous image and a high-quality image can be acquired. Use the <code>FFC mode parameter</code> to toggle the FFC on or off.</p> <p></p>"},{"location":"flat-field-correction-ffc-imaworx.html#using-correction-values-in-sdk-applications","title":"Using Correction Values in SDK Applications","text":"<p>Each time you restart your computer or open the frame grabber application, the FFC settings must be re-loaded to the frame grabber. A frame grabber has a volatile memory, so no data can be stored as opposed to the camera user sets on the cameras.</p> <p>Thus, in your SDK application (pylon API, GenApi, GenTL consumer or Framegrabber SDK), you must configure the FFC:</p> <ol> <li>Set the block width and height.</li> <li>Load the offset and gain correction files which you have stored using the plyon Viewer FFC plugin.</li> <li>While saving the files, the plugin also generates a configuration text file for your reference. pylon Viewer offers the possibility to obtain a sample C++ code for the pylon C++ API.</li> </ol>"},{"location":"flat-field-correction-ffc-imaworx.html#using-the-hierarchical-box-in-visualapplets","title":"Using the Hierarchical Box in VisualApplets","text":"<p>The functional blocks can be provided as VisualApplets User Libraries or hierarchical boxes in a design. This is done depending on your project and project environment. You can get the hierarchical box for the enhanced applets from your local Basler Sales representative or field application engineer.</p> <p>The use of the hierarchical box in VisualApplets is similar to the use of the Enhanced Applets. The process is as follows:</p> <ol> <li>Do the calculation of the coefficients with the pylon Viewer FFC plugin and Enhanced Applets.</li> <li>Write the correction coefficients and configuration to files  using the FFC plugin.</li> <li>Open the flat-field correction hierarchical box in a design of VisualApplets.</li> <li> <p>Configure the static parameters of the FFC hierarchical block in VisualApplets.</p> <p>The hierarchical box automatically adapts to the pixel bit width, parallelism and image format. First, you must parameterize the input link. It's important to do this before setting the static parameters.</p> <p>Allowed formats are:</p> <ul> <li><code>Bit width</code>: 8  to 16</li> <li><code>Artithmetic</code>: unsigned</li> <li><code>Parallelism</code>: 1 to 64</li> <li><code>Kernel Columns</code>, <code>Kernel Rows</code>: 1</li> <li><code>Color Forma</code>t: VAF_GRAY</li> <li><code>Color Flavor</code>: FL_NONE</li> <li><code>Max. Image Width</code>: any</li> <li><code>Max. Image Height</code>: any</li> </ul> <p>The static parameters define the precision and FPGA resource usage of the block-based FFC:</p> <ul> <li><code>OffsetBits</code>: Defines the number of bits used for offset correction. This is the sum of the integer and fractional bits.</li> <li><code>OffsetFractionalBits</code>: Defines the number of fractional bits. For fixed point arithmetic explanation see section Loading of the Correction Coefficients Offset and Gain.</li> <li><code>GainBits</code>: Defines the number of bits used for gain correction. This is the sum of the integer and fractional bits.</li> <li><code>GainFractionalBits</code>: Defines the number of fractional bits. For fixed point arithmetic explanation see section Loading of the Correction Coefficients Offset and Gain.</li> <li><code>MemoryType</code>: Select either UltraRAM, Block RAM, or LUT RAM. UltraRAM is recommended.</li> <li><code>MaxNumbrOfBlocks</code>: Select the maximum number of blocks used for the block FFC. If you had selected URAM as <code>MemoryType</code>, only 16384 blocks can be used.</li> <li><code>MaxNumberOfBlocksInX</code>: Define the maximum number of blocks in X-direction. Usually this should be <code>Max. Image Width</code> / <code>Parallelism</code>.</li> <li><code>MaxNumberOfBlocksInY</code>: Define the maximum number of blocks in Y-direction.</li> <li><code>MaxBlockSizeInX</code>: Define the maximum block size in X-direction. Choose a suitable value for your application. For a general purpose use, you can set the full image width.</li> <li><code>MaxBlockSizeInY</code>: Define the maximum block size in Y-direction. Choose a suitable value for your application. For a general purpose use, you can set the full image height.</li> </ul> <p>The dynamic parameters can be changed during runtime to the application requirements:</p> <ul> <li><code>CoefficientsXLength</code>: This value needs to match to the calculated and uploaded coefficient files, e.g. the ROI size of the Enhanced Applet which you have used in the pylon Viewer and the FFC plugin.</li> <li><code>CoefficientsYLength</code>: This value needs to match to the calculated and uploaded coefficient files, e.g. the ROI size of the Enhanced Applet which you have used in the pylon Viewer and the FFC plugin.</li> <li><code>BlockSizeMode</code>: Select <code>Manual</code> or <code>Auto</code>. In auto mode, the available blocks will be distributed over the image. For manual mode, the following parameters can be used to set the block size. If you used the FFC plugin in the pylon Viewer, copy the corresponding values:<ul> <li><code>BlockSizeInX</code>: Define the block size if <code>BlockSizeMode</code> is set to <code>Manual</code>. If you used the FFC plugin in the pylon Viewer, copy the corresponding values to this parameter.</li> <li><code>BlockSizeInY</code>: Define the block size if <code>BlockSizeMode</code> is set to <code>Manual</code>. If you used the FFC plugin in pylonViewer, copy the corresponding values to this parameter.</li> <li><code>EnoughBlocksForImageSize</code>: This read-only parameter indicates whether the defined maximum number of blocks are enough for the given block size and ROI setting.</li> <li><code>OffsetCoefficients</code>: Is a field parameter for the offset coefficients. Upload the text file from the FFC pylon plugin. You find a description of the format in section Loading of the Correction Coefficients Offset and Gain.</li> <li><code>GainCoefficients</code>: Is a field parameter for the offset coefficients. Upload the text file from the FFC pylon plugin. You find a description of the format in section Loading of the Correction Coefficients Offset and Gain.</li> <li><code>FlatFieldCorrectionMode</code>: Select, if you want the FFC Offset and Gain on or off. This can be done during image acquisition.</li> </ul> </li> </ul> </li> <li> <p>Configure the dynamic parameters of the FFC hierarchical block either during design time in VisualApplets or during runtime with your SDK application (pylon API, GenApi, GenTL consumer or Framegrabber SDK).</p> </li> </ol> <p>The following screenshot shows the use of the FFC hierarchical box in VisualApplets together with the parameters.</p> <p></p>"},{"location":"framegrabber-api-examples.html","title":"Examples","text":""},{"location":"framegrabber-api-examples.html#framegrabber-api-examples","title":"Framegrabber API Examples","text":"<p>The Framegrabber SDK installation comes with several examples in the subdirectory <code>SDKExamples</code>. Some examples are located in a subdirectory called <code>vs10</code>. The examples come with project files for Visual Studio 2010 or newer and <code>CMakeLists.txt</code> files to generate build files for various other compilers and development environments using CMake. See Prerequisites for more details on projects and how to use CMake.</p> <p>The project in the subdirectory <code>SDKExamples/SimpleExample</code> is a starting point for a first project using the frame grabber library fglib5.</p> <p>The subdirectory <code>SDKExamples/GenICam</code> contains several projects to get started using the camera control library siso_genicam.</p> <p>To get started using the image input/output library iolibrt, the subdirectory <code>SDKExamples/SisoIoLib</code> provides one example project.</p> <p>The subdirectory <code>SDKExamples/Functionality</code> provides more in-depth examples for various topics of the frame grabber control library fglib5.</p> <p>The following table gives an overview which examples are available and what these examples demonstrate:</p> Example Name Description CameraLink\\ClSer An example for using the Camera Link serial interface library clsersis.lib, which is used to communicate with a camera connected to a Camera Link frame grabber. Functionality\\Acquisition_mode This folder contains the examples for the acquisition modes <code>ACQ_STANDARD</code>, <code>ACQ_BLOCK</code>, and <code>ACQ_SELECT</code> with and without asynchronous procedure call. Functionality\\Acquisition_mode\\AcqAPCStandard An example for the acquisition model <code>ACQ_STANDARD</code> with an APC handler to retrieve a frame index. Functionality\\Acquisition_mode\\AcqAPCBlock An example for the acquisition model <code>ACQ_BLOCK</code> with an APC handler to retrieve <code>FG_IMAGE_NUMBER</code> via <code>Fg_getParameterEx</code>, and to unblock a buffer via <code>Fg_setStatusEx</code> Functionality\\Acquisition_mode\\AcqAPCSelect An example for the acquisition model <code>ACQ_SELECT</code> with an APC handler for selecting the next buffer via <code>Fg_setStatusEx</code>. Functionality\\Acquisition_mode\\AcqStandard An example for the acquisition model <code>ACQ_STANDARD</code> with a simple acquisition loop. Functionality\\Acquisition_mode\\AcqBlock An example for the acquisition model <code>ACQ_BLOCK</code> with a simple acquisition loop. Functionality\\Acquisition_mode\\AcqSelect An example for the acquisition model <code>ACQ_SELECT</code> with a simple acquisition loop. Functionality\\Basic_Parametrization An example for setting and getting parameters such as <code>width</code>, <code>height</code>, <code>pixel format</code> or <code>alignment</code>. Functionality\\Configuration_file This folder contains the examples for using microEnable Configuration Files (MCFs). Functionality\\Configuration_file\\ConfigFileInit An example for initializing frame grabbers via parameters in an MCF file. Functionality\\Configuration_file\\ConfigFileLoad An example for loading parameters from an MCF file for initialized frame grabber. Functionality\\Data_Format This folder contains the examples for several pixel formats. For mE5 Boards, the available data format depends on the selected applet. Functionality\\Data_Format\\Gray8 An example for setting the pixel format <code>FG_GRAY</code> for the tap format <code>FG_CL_SINGLETAP_8_BIT</code> in a grayscale applet for a BASE camera. Functionality\\Data_Format\\Gray16 An example for setting the pixel format <code>FG_GRAY16</code> for the tap format <code>FG_CL_SINGLETAP_16_BIT</code> in a grayscale applet for a BASE camera. Functionality\\Data_Format\\MediumGray An example for setting the pixel format <code>FG_GRAY</code> for the tap format <code>FG_CL_MEDIUM_8_BIT</code> in a grayscale applet for a MEDIUM camera. Functionality\\Data_Format\\MediumGray16 An example for setting the pixel format <code>FG_GRAY16</code> for the tap format <code>FG_CL_MEDIUM_16_BIT</code> in a grayscale (gray-16) applet for a MEDIUM camera. Functionality\\Data_Format\\MediumRGB24 An example for setting the pixel format <code>FG_COL24</code> for the tap format <code>FG_CL_MEDIUM_RGB_30</code> in an RGB applet for a MEDIUM camera. Functionality\\Data_Format\\MediumRGB48 An example for setting the pixel format <code>FG_COL48</code> for the tap format <code>FG_CL_MEDIUM_RGB_30</code> in an RGB applet for a MEDIUM camera. Functionality\\Data_Format\\RGB24 An example for setting the pixel format <code>FG_COL24</code> for the tap format <code>FG_CL_MEDIUM_RGB_30</code> in an RGB (RGB36) applet for a MEDIUM camera. Functionality\\Events This folder contains the examples for the event subsystem. Functionality\\Events\\EventSubsystemAsync An example for using the event subsystem with the asynchronous event interface. Functionality\\Events\\EventSubsystemSync An example for using the event subsystem with the synchronous event interface. Functionality\\Info This folder contains the examples for several ways to retrieve frame and acquisition information. Functionality\\Info\\BoardInformation An example for listing board type, board name and board serial. Functionality\\Info\\ImageTag An example for retrieving image tag information for each image. Functionality\\Info\\SystemInfo An example for retrieving system information, such as number of board, name, index, type, serial, status, PCI payload mode or versions of firmware and driver. Functionality\\Info\\TimeStamps An example for retrieving time stamp and acquisition duration for each image. Functionality\\KneeLut This folder contains the examples for handling lookup tables. Functionality\\KneeLut\\KneeLutGray An example for initializing and setting a gray value lookup table. Functionality\\KneeLut\\KneeLutGrayFile An example for saving a single component KneeLUT to a file and for reading this file. Functionality\\KneeLut\\KneeLutRGB An example for initializing and setting the RGB value lookup table. Functionality\\KneeLut\\KneeLutRGBFile An example for saving a three component KneeLUT to a file and for reading this file. Functionality\\MasterSlave This folder contains the examples for interactions between master and slave processes accessing the same frame grabber. Functionality\\MasterSlave\\Master An example for the frame grabber in master mode and for grabbing images in standard acquisition mode on port A. Functionality\\MasterSlave\\Slave An example for the frame grabber in slave mode and for grabbing images in standard acquisition mode on port B. Functionality\\Memory_management This folder contains the examples for showing the differences of basic, advanced and flexible memory management. Functionality\\Memory_management\\AllocMem An example for basic memory management which is only available in <code>ACQ_STANDARD</code> mode. Functionality\\Memory_management\\AllocMemEx An example for advanced memory management which allocates one contiguous block of memory subdivided in equal frame buffers. Functionality\\Memory_management\\AllocUserMem An example for flexible memory management which is similar to advanced mode, but offers dynamic memory allocation per buffer. Functionality\\Operation_mode This folder contains the examples for comparing several ways to trigger an acquisition from external and internal generators. Functionality\\Operation_mode\\AreaExternal An example for acquisition of frames started from an external trigger source. Functionality\\Operation_mode\\AreaFreeRun An example for acquisition started in free run, as fast as the camera can provide frames. Functionality\\Operation_mode\\AreaGrabberControl An example for frame grabber-controlled acquisition, which means that the frame grabber actively requests frames from the camera. Functionality\\Operation_mode\\AreaSoftware An example for acquisition of frames started from a software trigger. Functionality\\Operation_mode\\LineFreeRunImg An example for acquisition started in free run, as fast as the camera can provide lines. Functionality\\Operation_mode\\LineGatedAsyncTriggerLine An example for acquisition via external trigger controlled by a gated line trigger. Functionality\\Operation_mode\\LineGatedGrabberControlledLine An example for acquisition via the frame grabber controlled by a gated line trigger. Functionality\\Operation_mode\\LineGrabberControlledLine An example for acquisition via the frame grabber controlled by a line trigger. Functionality\\Operation_mode\\LineStartTriggerImage An example for image acquisition started via an asynchronous external trigger. Functionality\\Operation_mode\\LineStartTriggerLine An example for line acquisition started via an asynchronous external trigger. Functionality\\Operation_mode\\LineTriggerGatedImg An example for image acquisition started via a gated asynchronous external trigger. Functionality\\Operation_mode\\LineTriggerGatedMultiBufferImg An example for image multi buffer acquisition started via a gated asynchronous external trigger. Functionality\\SensorReadout An example for accessing various sensor readouts from the board. GenICam\\BoardEvents An example for receiving various GenICam events from the frame grabber during camera discovery, e.g., link speed. GenICam\\CameraDiscovery An example for reading GenICam information from the camera, e.g., vendor name or serial number. GenICam\\ImageAcquisition An example for GenICam-compliant configuration and acquisition. GenICam\\UsingGenApi An example for accessing the GenICam nodemap through GenApi. SDKWrapper\\CSharpWrapper This folder contains the examples for the C# Wrapper. SDKWrapper\\CSharpWrapper\\AcqAPC An example in C# for defining an asynchronous procedure call and starting acquisition. SDKWrapper\\CSharpWrapper\\FgEvents An example in C# for registering events. SDKWrapper\\CSharpWrapper\\MyFirstSDK An example in C# for acquiring images via <code>ACQ_STANDARD</code> from the CameraSimulator. SDKWrapper\\PythonWrapper This folder contains the examples for the Python Wrapper. SDKWrapper\\PythonWrapper\\AcqAPC An example in python for defining an asynchronous procedure call, iterate boards and applets and start acquisition. SDKWrapper\\PythonWrapper\\MyFirstSDK An example in python for configuring and starting acquisition. SimpleExample A small example for an <code>ACQ_STANDARD</code> acquisition. SisoIoLib An example for loading and saving images using the iolibrt. GPUDIRECT This folder contains the examples for interacting with NVIDIA GPUDirect for video. GPUDIRECT\\cuda_example_cxp An example for initializing the frame grabber via a GenICam and CUDA device to apply a fish-eye kernel. GPUDIRECT\\simple_cuda_example An example for initializing a CUDA device and frame grabber and announcing a buffer location via <code>GDAnnounceCUDAArray</code>."},{"location":"framegrabber-api-history.html","title":"Framegrabber API History","text":""},{"location":"framegrabber-api-history.html#changes-from-framegrabber-version-57-to-59","title":"Changes from Framegrabber Version 5.7 to 5.9","text":""},{"location":"framegrabber-api-history.html#changes-to-the-frame-grabber-library-fglib5","title":"Changes to the Frame Grabber Library fglib5","text":"<ul> <li>The functions <code>Fg_getIntSystemInformationForBoardIndex()</code>, <code>Fg_getInt64SystemInformationForBoardIndex()</code>, <code>Fg_getStringSystemInformationForBoardIndex</code>, <code>Fg_getIntSystemInformationForFgHandle()</code>, <code>Fg_getInt64SystemInformationForFgHandle()</code> and <code>Fg_getStringSystemInformationForFgHandle</code> documented in chapter System Information wrap calls to <code>Fg_getSystemInformation()</code> for type-safety.</li> <li>The function <code>Fg_getParameterTypeById()</code> documented in chapter Working with Applet Parameters provides the type of an applet parameter.</li> <li>The functions <code>Fg_getParameterPropertyWithType()</code> and <code>Fg_getParameterPropertyWithTypeEx()</code> documented in chapter Working with Applet Parameters wrap calls to <code>Fg_getParameterProperty()</code> and <code>Fg_getParameterPropertyEx()</code>, respectively.</li> <li>The functions <code>Fg_registerApcHandlerEx()</code> and <code>Fg_unregisterApcHandler()</code> documented in chapter Image Acquisition wrap calls to <code>Fg_registerApcHandler()</code>.</li> <li>FG_IMAGE_NUMBER provides the frame number of a buffer when calling <code>Fg_getParameterEx()</code> as documented in chapter Image Acquisition.</li> <li>When using asynchronous mode in the blocking acquisition model <code>ACQ_BLOCK</code>, the function <code>Fg_getImageEx()</code> is called in the acquisition loop provided by the Framegrabber API as documented in chapter Image Acquisition.</li> <li>The selective acquisition model <code>ACQ_SELECT</code> documented in chapter Image Acquisition provides a GenICam compliant acqusition model.</li> <li>The function <code>Fg_unregisterEventHandler()</code> documented in chapter Applet Events wraps calls to <code>Fg_registerEventHandler()</code> to unregister an event handler. The type <code>struct fg_event_data</code> has been removed and pointers replaced by <code>void *</code> to allow the user more flexibility for providing context information when handling events.</li> </ul>"},{"location":"framegrabber-api-history.html#changes-to-the-camera-control-library-siso_genicam","title":"Changes to the Camera Control Library siso_genicam","text":"<ul> <li>Manual discovery is no longer supported by the Framegrabber API.</li> <li>The functions <code>Sgc_scanPorts()</code> and <code>Sgc_scanPortsEx()</code> documented in chapter Camera Discovery no longer perform the discovery directly but rather start a backround thread. Calling the function multiple times will not result in restarting the discovery. The function <code>Sgc_scanPortsEx()</code> can be used to restart the discovery by passing <code>SGC_SP_FLAG_RESET_DISCOVERY_INFOS</code> in the parameter <code>flags</code>.</li> <li>The function <code>Sgc_getCameraCount()</code> documented in the chapter Camera Discovery returns the number of cameras found during the discovery process and not the maximum number of cameras supported by the applet.</li> <li>The information previously available through the function <code>Sgc_getCameraInfo()</code> has been added to the function <code>Sgc_getCameraPropertyWithType()</code> documented in the chapter Camera Information. The function <code>Sgc_updateCameraInfos()</code> can be used after changing the camera user identifier to inform the Framegrabber API about the changes.</li> <li>The function <code>Sgc_registerBoardEventCallback()</code> documented in chapter Registering a Callback Function for Discovery Events provides a new way of monitoring dynamic discovery of cameras or link loss.</li> </ul>"},{"location":"framegrabber-api-prerequisites.html","title":"Framegrabber API Prerequisites","text":"<p>To write programs using the Framegrabber API a set of tools for compiling and linking programs written in C/C++ is required. For Microsoft Windows, the Framegrabber API comes with support for the Microsoft C/C++ compiler toolchains and in most projects the Microsoft Visual Studio Integrated Development Environment (IDE) will be used.</p> <p>When using the Linux operating system, the GNU C/C++ and Clang compiler toolchains are supported. These can usually be installed using the package manager that comes with the Linux distribution. Consult the documentation for the Linux distribution, specific online forums and communities.</p> <p>The code examples in this document generally assume that a modern C++ compiler with support for at least the C++11 standard will be used. If strict C compilation is required, see chapter Considerations When Using Plain C for more information.</p>"},{"location":"framegrabber-api-prerequisites.html#environment","title":"Environment","text":"<p>When installing the Framegrabber SDK, usually an environment variable <code>BASLER_FG_SDK_DIR</code> is registered with the system, which will be used in the following to denote the location of the Framegrabber SDK installation.</p> <p>If the Linux operating system is used, the script <code>setup_siso_env.sh</code> will setup the environment variables and can be added to the startup scripts by the system administrator. Due to the variations in startup used by different distributions, this isn't done automatically. If the script isn't called automatically when the system is started or a user logs on, you have to <code>source</code> the script manually both to compile and run applications using the Framegrabber API.</p>"},{"location":"framegrabber-api-prerequisites.html#operating-system-drivers","title":"Operating System Drivers","text":"<p>The Framegrabber API needs operating system drivers to access the frame grabbers installed in the computer. On Microsoft Windows, the drivers can be installed using the Framegrabber SDK installer. When using the Linux operating system, the drivers have to be downloaded, compiled and installed separately. Follow the <code>INSTALL</code> document in the Linux driver package for details on how to compile and install the drivers.</p>"},{"location":"framegrabber-api-prerequisites.html#using-microsoft-visual-studio","title":"Using Microsoft Visual Studio","text":"<p>When using Microsoft Visual Studio, you can start with a new project and select the \"Empty Project\" template from the \"Visual C++\" category. To use the libraries in the project which will be generated, first the directory <code>%BASLER_FG_SDK_DIR%\\include</code> should be added to the include paths used by the compiler.</p> <p>Info</p> <p>Always make sure that the target platform matches the Framegrabber SDK platform you are using. For Framegrabber SDK, it is always 64-bit.</p> <p></p> <p>Next, the directory <code>%BASLER_FG_SDK_DIR%\\lib\\visualc</code> should be added to the library paths used by the linker.</p> <p></p> <p>To link against a library in a Microsoft Visual Studio project it has to be added to the dependencies in the linker settings. In the following example the library <code>fglib5.lib</code> is added:</p> <p></p> <p>To add dependencies, you can click on the  Button, and select <code>&lt;Edit...&gt;</code>.</p>"},{"location":"framegrabber-api-prerequisites.html#using-linux","title":"Using Linux","text":"<p>When using the Linux operating system and the gcc or clang compilers, the switch <code>-I $BASLER_FG_SDK_DIR/include</code> adds the Framegrabber API include directory to the compiler settings, and the switch <code>-L $BASLER_FG_SDK_DIR/lib</code> adds the Framegrabber API library directory to the linker settings.</p> <p>To link against a library when using the gcc or clang compilers, the switch <code>-l</code> is used. For example, <code>-l fglib5</code> adds the library <code>libfglib5.so</code> to the linker dependencies. Given a source code file <code>main.cpp</code>, to compile and link the file into the executable <code>SimpleExample</code>, the following command can be entered on the command line:</p> <pre><code>g++ -o SimpleExample -I $BASLER_FG_SDK_DIR/include -L $BASLER_FG_SDK_DIR/lib -l fglib5 main.cpp\n</code></pre>"},{"location":"framegrabber-api-prerequisites.html#using-cmake","title":"Using CMake","text":"<p>CMake is a tool to generate project files from a simple text description of the project requirements for many integrated development environments (IDEs), such as Microsoft Visual Studio, as well as a build workflow using tools like <code>make</code>.</p> <p>The Framegrabber API comes with files to support the CMake <code>FIND_PACKAGE</code> command. Given a source code file <code>main.cpp</code>, a simple <code>CMakeLists.txt</code> file for a project to compile and link the file into the executable <code>SimpleExample</code> could look like this:</p> <pre><code>PROJECT(SimpleExample)\n\nFILE(TO_CMAKE_PATH \"$ENV{BASLER_FG_SDK_DIR}\" BASLER_FG_SDK_DIR)\nLIST(APPEND CMAKE_MODULE_PATH \"${BASLER_FG_SDK_DIR}/cmake/modules\")\n\nFIND_PACKAGE(FgLib5 REQUIRED)\n\nINCLUDE_DIRECTORIES(\n    ${FgLib5_INCLUDE_DIR}\n)\n\nSET (PRJ_SOURCES\n    SimpleExample.cpp\n)\n\nADD_EXECUTABLE(${PROJECT_NAME} ${PRJ_SOURCES})\n\nTARGET_LINK_LIBRARIES(${PROJECT_NAME}\n    ${FgLib5_LIBRARIES}\n)\n</code></pre>"},{"location":"framegrabber-api-prerequisites.html#using-cmake-with-microsoft-visual-studio","title":"Using CMake with Microsoft Visual Studio","text":"<p>To process the file <code>CMakeLists.txt</code> to generate a project for Microsoft Visual Studio, either the GUI tool can be used, or the project files can be generated by entering on the command line:</p> <pre><code>cmake -G \"Visual Studio 15 2017 Win64\" .\n</code></pre>"},{"location":"framegrabber-api-prerequisites.html#using-cmake-with-make","title":"Using CMake with make","text":"<p>To generate a <code>Makefile</code> for the build workflow using <code>make</code>, the following can be entered on the command line:</p> <pre><code>cmake -G \"Unix Makefiles\" .\n</code></pre>"},{"location":"framegrabber-api.html","title":"Framegrabber API","text":"<p>The Framegrabber API is split among several libraries which can be linked to a project:</p> Library Purpose fglib5 <ul><li>Initializing the frame grabber by loading an applet<li>Accessing applet parameters<li>Memory management<li>Image acquisition siso_genicam <ul><li>Discovering cameras conforming to the GenICam standard<li>Accessing camera parameters<li>Executing camera commands clsersis <ul><li>Communicating with cameras according to the Camera Link standard iolibrt <ul><li>Reading and writing of standard image file formats display_lib <ul><li>Presenting image data in a window <p>The Framegrabber API can be used to write applications which acquire and process images from a camera connected to a Basler frame grabber. Cameras using the standards CameraLink, and CoaXPress are supported by the Basler frame grabbers and the Framegrabber API.</p> <p>Info</p> <p>Starting with version 5.9 of the Framegrabber API, some changes were made to the API. Throughout the documentation, such changes are highlighted in the respective sections. All changes are summarized in part Change History of the documentation.</p> <p>The Basler frame grabbers transfer images from one or more cameras using direct memory access (DMA) directly into memory allocated by the application. The path the image data takes from the camera through the frame grabber into the application memory is referred to as DMA channel in the context of the Framegrabber API (from the view of Framegrabber API the image data enters the context of the application through a DMA transfer to the application memory).</p> <p>The application can be designed to wait in an acquisition loop for new images, or a function can be registered to be called by the Framegrabber API when new images are available. In both cases, the application is made aware of new images only after they have been completely transferred into the computer memory and the image data can be safely processed by the application.</p> <p>The application always has to specify a time, usually a number of seconds, to wait for new images. The functions called to wait for new images will call an operating system driver provided with the Framegrabber SDK installation and can put the calling thread to sleep until either new images arrive or the specified time passed, whichever happens first. If no images arrive in the specified waiting time, a timeout error will be generated and reported to the application.</p> <p>The way in which the Framegrabber API works ensures low processor usage while waiting for new images and low latency transfer of image data from a camera to the application. However, it implies that most applications will be implemented to run image acquisition in separate threads, or use the the callback mechanism which again runs an acquisition loop in a separate thread managed by the Framegrabber API. Otherwise the application main thread can be blocked while the application waits for new images.</p> <p>The time to wait for new images can also imply that an application can't exit without first waiting for threads to return from calls into the operating system driver. While this isn't so much of concern for an application running as the single user interface on a machine for example, applications running on multi-purpose computers, requiring a responsive user experience when exiting the application should rather use small waiting times and handle timeout errors accordingly.</p> <p>The functions in the Framegrabber API are safe to use from different threads, but different threads should not control the same features or DMA channels concurrently.</p> <p>The Basler frame grabbers can apply pre-processing to the image data before it is transferred to the application memory. While most frame grabbers support a standard set of commonly used pre-processing features, using Basler VisualApplets and the Basler's programmable frame grabbers, application developers can implement more sophisticated pre-processing, offloading image processing from the CPU to the FPGA of the frame grabber.</p>"},{"location":"framegrabber-sdk-end-user-license-agreement.html","title":"FRAMEGRABBER SDK END-USER LICENSE AGREEMENT","text":"<p>IMPORTANT - PLEASE READ CAREFULLY</p> <p>THIS END-USER LICENSE AGREEMENT (\"AGREEMENT\") IS A LEGAL AGREEMENT BETWEEN YOU, EITHER  AN INDIVIDUAL OR A LEGAL ENTITY, (\"CUSTOMER\"), AND BASLER AG (\"BASLER\") FOR THE BASLER SOFTWARE PRODUCTS ACCOMPANYING THIS AGREEMENT, WHICH INCLUDES COMPUTER SOFTWARE AND MAY INCLUDE \"ONLINE\" OR ELECTRONIC DOCUMENTATION, ASSOCIATED MEDIA, AND/OR PRINTED MATERIALS (\"SOFTWARE\"). BEFORE YOU DOWNLOAD, INSTALL OR USE THE SOFTWARE, CAREFULLY READ THIS AGREEMENT. BY DOWNLOADING, INSTALLING OR USING THE SOFTWARE, YOU CONSENT TO THE TERMS OF THIS AGREEMENT AND YOU AGREE TO BE BOUND BY THIS AGREEMENT. IF YOU DO NOT AGREE TO THE TERMS AND CONDITIONS OF THIS AGREEMENT, DO NOT DOWNLOAD, INSTALL OR USE THE SOFTWARE.</p> <p>1. SOFTWARE OF THIRD-PARTY MANUFACTURERS. Notwithstanding the terms and conditions of this AGREEMENT, all or any portion of the SOFTWARE which constitutes non-proprietary BASLER software or software provided under Open source license by third parties (\"third-party software\"), is licensed to CUSTOMER subject to the terms and conditions of the software license agreement accompanying such third-party software. Use of the third-party software by CUSTOMER shall be governed entirely by the terms and conditions of such license. CUSTOMER can find the license terms and conditions in the \"https://docs.baslerweb.com/frame-grabbers/third-party-license-notices-framegrabber-sdk\" of the online technical documentation or contact BASLER support. BASLER software includes some open source software source code that may be used and modified by anyone and everyone, provided they, in turn, make it available to everyone else with the same licensing agreement. Please contact BASLER support for the original source code of components licensed under Open source licenses.</p> <p>2. GRANT OF LICENSE, TERMINATION IN CASE OF VIOLATION. BASLER grants CUSTOMER a personal, non-exclusive, non-transferable right to use the SOFTWARE provided that CUSTOMER comply with all terms and conditions of this AGREEMENT. Should CUSTOMER violate the provisions of this Agreement, BASLER shall have the right to terminate the Agreement immediately. In this case CUSTOMER must delete the software including all copies or return it to BASLER.</p> <p>3. PERMITTED USE OF THE SOFTWARE. CUSTOMER may install and use the SOFTWARE as whole or in parts (single files, e.g. DLLs etc.) on an unlimited number of computers. CUSTOMER may solely use the SOFTWARE for the purpose to operate a BASLER frame grabber or interface card product.</p> <p>4. TRANSFER. CUSTOMER may transfer the SOFTWARE in whole or in parts (single files, e.g. DLLs etc.) to another individual/entity provided that the transferee accepts the terms of this AGREEMENT. CUSTOMER may not rent, lease, sub-license, or lend the SOFTWARE or any portions thereof to others, except as expressly granted in this section 4.</p> <p>5. RESTRICTIONS. CUSTOMER may not copy or use the SOFTWARE except as set forth in this AGREEMENT. CUSTOMER may not remove any proprietary notices or labels on the SOFTWARE; any copies that CUSTOMER is permitted to make pursuant to this Agreement must contain the same copyright and other proprietary notices that appear on and in the SOFTWARE. Notwithstanding the aforementioned, CUSTOMER may make copies as required by law.</p> <p>6. LIMITATION ON REVERSE ENGINEERING. CUSTOMER agree not to modify, adapt, reverse engineer, decompile, or disassemble the SOFTWARE or otherwise attempt to discover the source code of the SOFTWARE or algorithms contained therein or create any derivative works from the SOFTWARE, except as expressly provided in this AGREEMENT.</p> <p>7. PROPRIETARY RIGHTS. All intellectual property rights in the SOFTWARE are owned by BASLER or its suppliers and are protected by copyright laws and international copyright treaties. CUSTOMER shall not remove any product identification, copyright notices or proprietary restrictions from the SOFTWARE.</p> <p>8. DISCLAIMER OF WARRANTIES. TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, BASLER AND ITS SUPPLIERS PROVIDE THE SOFTWARE PRODUCT \"AS IS\" AND WITH ALL FAULTS, AND HEREBY DISCLAIM ALL OTHER WARRANTIES AND CONDITIONS, EITHER EXPRESS, IMPLIED, OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, WARRANTIES OF TITLE AND NON-INFRINGEMENT, ANY IMPLIED WARRANTIES, DUTIES OR CONDITIONS OF MERCHANTABILITY, OF FITNESS FOR A PARTICULAR PURPOSE, AND OF LACK OF VIRUSES ALL WITH REGARD TO THE SOFTWARE PRODUCT. Some states/jurisdictions do not allow exclusion of implied warranties or limitations on the duration of implied warranties, so the above disclaimer may not apply to CUSTOMER in its entirety.</p> <p>9. LIMITATION OF LIABILITY.</p> <p>9.1 BASLER SHALL SOLELY BE LIABLE, WITHOUT LIMTIATION, FOR ANY DAMAGES RESULTING FROM (i) INJURY, BODILY HARM OR LOSS OF LIFE DUE TO A NEGLIGENT OR INTENTIONAL BREACH OF DUTY BY BASLER OR BASLER\u2019s REPRESENTATIVES, (ii) ANY VIOLIATION OF AN OBLIGATION WHICH IS ESSENTIAL FOR THE PURPOSE OF THIS AGREEMENT (Kardinalspflicht) AND/OR (iii) A GROSSLY NEGLIGENT OR INTENTIONAL BREACH OF THIS AGREEMENT BY BASLER OR BASLER\u2019s REPRESENTATIVES.</p> <p>9.2 BASLERS LIABILITY UNDER THE PRODUCT LIABILITY ACT (ProdHaftG) REMAINS UNAFFECTED.</p> <p>9.3 IN ALL OTHER CASES THAN THE AFOREMENTIONED, BASLER SHALL NOT BE LIABLE FOR ANY DAMAGES (WETHER OR NOT SPECIAL, INCIDENTAL, INDIRECT, OR CONSEQUENTIAL DAMAGES) INCLUDING, BUT NOT LIMITED TO, DAMAGES FOR LOSS OF PROFITS OR CONFIDENTIAL OR OTHER INFORMATION, FOR BUSINESS INTERRUPTION, FOR PERSONAL INJURY, FOR LOSS OF PRIVACY, ARISING OUT OF OR IN ANY WAY RELATED TO THE USE OF OR INABILITY TO USE THE SOFTWARE PRODUCT, OR OTHERWISE IN CONNECTION WITH ANY PROVISION OF THIS AGREEMENT, EVEN IF BASLER OR ANY SUPPLIER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES AND EVEN IF THE REMEDY FAILS OF ITS ESSENTIAL PURPOSE, UNLESS SUCH DAMAGES OCCUR AS A RESULT OF AN INTENTIONAL BREACH OF THIS AGREEMENT BY BASLER AND/OR ITS REPRESENTATIVES.</p> <p>9.4 In cases of any breach of contract by BASLER, for which the liability of BASLER is not excluded under Section 9.3 above, BASLER\u2019s liability shall be limited to the amount of damages foreseeable under and typical for the Agreement.</p> <p>10. GOVERNING LAW AND JURISDICTION.</p> <p>10.1 This AGREEMENT shall be considered to have been entered into and construed in accordance with the laws of Germany, excluding its provisions on the conflict of laws and the CISG rules. For all controversies between the parties or claims based on this AGREEMENT the District Court Hamburg shall have jurisdiction. Failure by either party to enforce any term of this AGREEMENT shall not be deemed to be a waiver of future enforcement of that term or any other term.</p> <p>10.2 CUSTOMER agree that this AGREEMENT shall be enforceable in a court of equity and acknowledges that a breach by CUSTOMER of the terms of this AGREEMENT may not be adequately remedied by an award of damages and that BASLER shall therefore be entitled to injunctive or other equitable relief in the event of such breach. CUSTOMER further agree that the election by BASLER to seek equitable relief shall not preclude it from also seeking relief at law.</p> <p>11. GENERAL.</p> <p>11.1 This AGREEMENT is the complete and exclusive statement of the agreement between the parties and supersedes all prior agreements and communications with respect to the subject matter. This AGREEMENT shall be binding upon and inure to the benefit of the parties hereto and their respective successors and assigns.</p> <p>11.2 This AGREEMENT can only be modified by a written document signed by both parties.</p> <p>11.3 If any provision of this AGREEMENT is held invalid, the offending clause will be deleted and replaced by a clause which is valid and comes as close as possible to the offended clause. In any case the invalidity of one or more clauses shall not affect the validity of the remaining clauses and the remainder of this AGREEMENT will continue in full force and effect.</p>"},{"location":"framegrabber-sdk.html","title":"Framegrabber SDK","text":"<p>The Framegrabber SDK is a software suite with which you can operate your frame grabber.</p> <p>It provides the following software components:</p>"},{"location":"framegrabber-sdk.html#tools","title":"Tools","text":"<ul> <li>microDisplay X</li> <li>microDiagnostics</li> <li>FirmwareUpdater</li> <li>gpioTool</li> <li>mE5BoardSettings</li> <li>FirmwareFlasher</li> </ul>"},{"location":"framegrabber-sdk.html#framegrabber-api","title":"Framegrabber API","text":"<ul> <li>Framegrabber API Manual</li> </ul>"},{"location":"framegrabber-sdk.html#framegrabber-api-references","title":"Framegrabber API References","text":"<ul> <li>Framegrabber API Function Reference</li> <li>Framegrabber API CoaXPress Extension Reference</li> <li>I/O Library Function Reference</li> <li>Display Library Function Reference</li> </ul>"},{"location":"framegrabber-sdk.html#gentl-interface","title":"GenTL Interface","text":"<ul> <li>GenTL Interface Documentation</li> </ul>"},{"location":"framegrabber-sdk.html#third-party-interfaces","title":"Third-Party Interfaces","text":"<ul> <li>NVIDIA GPUDirect for Video</li> </ul>"},{"location":"framegrabber-sdk.html#wrappers","title":"Wrappers","text":"<ul> <li>C# Wrapper</li> <li>Python Wrapper</li> </ul>"},{"location":"framegrabber-sdk.html#log-message-system","title":"Log Message System","text":"<ul> <li>Log Message System Manual</li> </ul>"},{"location":"framegrabber-sdk.html#acquisition-applets","title":"Acquisition Applets","text":"<ul> <li>Acquisition Applets</li> </ul>"},{"location":"gpio-connectors.html","title":"GPIO Connectors","text":"<p>Basler frame grabbers are equipped with various trigger interfaces and connectors.</p> <p>This allows you to set up a detailed and complex trigger system, including:</p> <ul> <li>Receive trigger signals from external devices like Shaft Encoders, light barriers, etc. (trigger IN).</li> <li>Send trigger signals from the frame grabber to external devices like camera, lighting, etc. (trigger OUT)</li> <li>Receive software triggers.</li> </ul> <p>Info</p> <p>The triggers of the imaFlex CXP-12 Penta frame grabber can only be configured via applets, not via the trigger and GPIO options described here. However, you can configure the trigger via any applet. For detailed information, refer to the following documentation:</p> <ul> <li>VisualApplets documentation, specifically, the AppletProperties Operator Documentation</li> <li>The Application Note: Designing Signal Processing Applets for Programmable Frame Grabbers</li> <li>Chapter Miscellaneous/GPIO Configuration of your standard applet documentation for imaFlex CXP-12 Penta</li> </ul> <p>Info</p> <p>Programmable frame grabbers (i.e., imaFlex CXP-12 Quad, marathon VCX-QP, marathon VLC, and marathon VLCx): In addition to the trigger and GPIO options described here, you can also develop your own trigger system using VisualApplets. For detailed information, refer to the following documentation:</p> <ul> <li>VisualApplets documentation, specifically, the AppletProperties Operator Documentation</li> <li>The Application Note: Designing Signal Processing Applets for Programmable Frame Grabbers</li> </ul> <p>By using triggers, you are able to control the image acquisition process. You can, for example, acquire an image at a particular moment in time, define when to accept an image delivered by the camera, specify how many lines should be acquired, or control the lighting.</p>"},{"location":"gpio-connectors.html#trigger-interfaces-on-basler-frame-grabbers","title":"Trigger Interfaces on Basler Frame Grabbers","text":"<p>Basler frame grabbers offers the following trigger interfaces:</p> <ul> <li>One 15-pin D-Sub Micro-D connector (trigger unit \"Front GPIO\" on the slot bracket).</li> <li>One 34-pin socket (trigger unit \"GPIO\") for connecting an additional trigger board (Opto Trigger 5 or TTL Trigger).</li> <li>Two software triggers (A and B).</li> <li>marathon ACL, marathon VCL, and marathon VCLx: Four camera control signals (CC signals) per Camera Link port for controlling the camera.</li> </ul> <p>On imaFlex CXP-12 Penta, imaFlex CXP-12 Quad, marathon VCX-QP, marathon VCL, and marathon VCLx, you can configure the individual pins of the Front GPIO and the trigger extension board as well as the software triggers (and for all CL frame grabbers: CC signals) with VisualApplets.</p>"},{"location":"gpio-connectors.html#input-configuration","title":"Input Configuration","text":"<p>For GPI configuration, you have two signal modes available: \"Differential\" and \"Single-ended\". \"Differential\" is the default mode.</p> <ul> <li>In Differential mode, you can use the GPIs on the Front GPIO for receiving either up to 3 differential signals, or for receiving two differential signals and one single-ended signal.</li> <li>In Single-ended mode, you can use the GPIs on the Front GPIO for receiving up to 4 single-ended signals.</li> </ul> <p></p> <p>You can switch between modes using the gpioTool command line tool.</p> <p>Info</p> <p>The gpioTool doesn't work for the imaFlex CXP-12 Penta frame grabber. The triggers of the imaFlex CXP-12 Penta frame grabber can only be configured via applets. However, you can configure the trigger via any applet. For detailed information, refer to the following documentation:</p> <ul> <li>VisualApplets documentation, specifically, the AppletProperties Operator Documentation</li> <li>The Application Note: Designing Signal Processing Applets for Programmable Frame Grabbers</li> <li>Chapter Miscellaneous/GPIO Configuration of your standard applet documentation for imaFlex CXP-12 Penta</li> </ul>"},{"location":"gpio-connectors.html#differential-mode","title":"Differential Mode","text":"<p>In the default \"Differential\" mode, all the six input pins of the Front GPIO are configured to receive differential signals (in pull-up mode):</p> Pin # Signal 8/9 1 differential signal (pin 8+, pin 9- ) 11/12 1 differential signal (pin 11+, pin 12-) 13/14 1 differential signal (pin 13+, pin 14-) 10 GPI voltage IN (4.5\u201328 VDC): The GPI voltage IN must be the same voltage as the signal source voltage. 15 GPI GND <p>Alternatively, you can use pin pair 8/9 to receive one single-ended signal. To do so, you connect the single-ended incoming signal to physical pin 9. Pin 8 isn't connected.</p>"},{"location":"gpio-connectors.html#single-ended-mode","title":"Single-Ended Mode","text":"<p>If you need more than one single-ended input signal, you can switch the GPIs of your Front GPIO into \"Single-ended\" mode. In \"Single-ended\" mode, the six input pins of the Front GPIO are configured to receive four single-ended signals:</p> Pin # Signal 8 1 single-ended signal 9 1 single-ended signal 11 1 single-ended signal (pin 12 not used) 13 1 single-ended signal (pin 14 not used) 10 GPI voltage IN (4.5\u201328 VDC): The GPI voltage IN must be the same voltage as the signal source voltage. 15 GPI GND <p>You can switch between \"Single-ended\" and \"Differential\" mode using the gpioTool command line tool.</p> <p>Info</p> <p>Both configurations (Differential and Single-ended) can be used in pull-up and pull-down mode. Pull-up mode is the default. If you want to use the inputs in pull-down mode, you can configure the pins accordingly using the gpioTool command line tool.</p>"},{"location":"gpio-connectors.html#front-gpio","title":"Front GPIO","text":""},{"location":"gpio-connectors.html#schematic-circuit-diagram-front-gpio-for-all-frame-grabbers-except-imaflex-cxp-12-penta","title":"Schematic Circuit Diagram Front GPIO for All Frame Grabbers Except imaFlex CXP-12 Penta","text":""},{"location":"gpio-connectors.html#schematic-circuit-diagram-front-gpio-for-imaflex-cxp-12-penta","title":"Schematic Circuit Diagram Front GPIO for imaFlex CXP-12 Penta","text":""},{"location":"gpio-connectors.html#electrical-characteristics-of-the-physical-inputs","title":"Electrical Characteristics of the Physical Inputs","text":"Description Minimum Typical Maximum Unit Supply voltage 4.5 28 VDC Input threshold 20% Supply Voltage VDC Differential input offset voltage 10 mV Current at GPI pin 4 mA Total current at GPI voltage IN 50 mA"},{"location":"gpio-connectors.html#timing-characteristics-of-the-physical-inputs","title":"Timing Characteristics of the Physical Inputs","text":"Timing Minimum Typical Maximum Unit Propagation delay 40 60 80 ns Min. pulse width 200 ns Max. frequency 2.5 MHz <p>Info</p> <p>Basler frame grabbers are equipped with a varistor that opens at an input voltage of 30 VDC (on the GPIOs). This activates the onboard surge protector to protect the board. At a total supply voltage of 36 VDC, electronics would become defective.</p>"},{"location":"gpio-connectors.html#trigger-output-ttl","title":"Trigger Output TTL","text":""},{"location":"gpio-connectors.html#schematic-circuit-diagram-for-all-frame-grabbers-except-imaflex-cxp-12-penta","title":"Schematic Circuit Diagram for all Frame Grabbers Except imaFlex CXP-12 Penta","text":"<p>For all frame grabbers except imaFlex CXP-12 Penta, pins 1 and 2 can be used to send TTL trigger output signals (5 VDC).</p> <p></p>"},{"location":"gpio-connectors.html#schematic-circuit-diagram-for-imaflex-cxp-12-penta","title":"Schematic Circuit Diagram for imaFlex CXP-12 Penta","text":"<p>For imaFlex CXP-12 Penta, pins 1, 2, 3 and 4 can be used to send TTL trigger output signals (5 VDC).</p> <p></p>"},{"location":"gpio-connectors.html#electrical-characteristics-of-the-physical-outputs","title":"Electrical Characteristics of the Physical Outputs","text":"Description Minimum Typical Maximum Unit Output voltage high (VOH) 3.8 5 VDC Output voltage low (VOL) 0.58 VDC Output current (IO) 18 mA <p>5V Out (max. current 500 mA): The Front GPIO offers a voltage out pin that provides 5 VDC. It can be used for a current of maximal 500 mA.</p>"},{"location":"gpio-connectors.html#timing-characteristics-of-the-physical-outputs","title":"Timing Characteristics of the Physical Outputs","text":"Timing Minimum Typical Maximum Unit Rise TimeFall Time 2.5 ns <p>Info</p> <p>For details on the electrical and timing characteristics of the Front GPIO outputs, refer to the TI SN74LVC1G97 data sheet.</p> <p>For details on the RS 485 transceiver, refer to the TI SN65HVD1176 data sheet.</p>"},{"location":"gpio-connectors.html#gpio-34-pin-flat-cable-connector","title":"GPIO 34-Pin Flat Cable Connector","text":"<p>Via the 34-pin flat cable connector (GPIO), you can connect the frame grabber to a trigger extension board.</p> <p></p> <p>The following figure shows how the frame grabber may be used in conjunction with a trigger extension board:</p> <p></p> <p>The GPIO connector offers</p> <ul> <li>8 digital inputs (IN 0\u20137)</li> <li>8 digital outputs (OUT 0\u20137).</li> </ul> <p>The eight inputs are numbered from 0 to 7. The eight outputs range from 0 to 7.</p> <p>The GPIO connector is used for connecting a trigger extension board. How the physical interface of the trigger extension board is configured (TTL or opto-decoupled, pull-up, pull-down, differential, or single-ended signals) depends on the trigger extension board you are using. For details, see Opto-Coupled Trigger 5 or TTL Trigger.</p> <p>For installation instructions, see Installing a Trigger Extension Board.</p> <p>For details on connecting one or multiple frame grabber devices to one or multiple trigger boards, see Synchronizing Multiple Boards.</p>"},{"location":"gpio-connectors.html#pin-layout-for-the-gpio-34-pin-flat-cable-connector","title":"Pin Layout for the GPIO 34-Pin Flat Cable Connector","text":"<p>The 34-pin flat cable can connect the frame grabber to an external trigger board. All Basler frame grabbers offer 8 digital inputs (IN 0\u20137) and 8 digital outputs (OUT 0\u20137).</p> <p>You can configure how the individual inputs and outputs are used via applet. Refer to the documentation of the applet you're using.</p> <p></p> Pin # (Odd) I/O Name Pin # (Even) I/O Name 1 Trigger Output 0 2 +3.3 VDC 3 Trigger Output 1 4 +3.3 VDC 5 Trigger Output 2 6 GND 7 Trigger Output 3 8 GND 9 Trigger Input 0 10 GND 11 Trigger Input 1 12 GND 13 Trigger Input 2 14 GND 15 Trigger Input 3 16 GND 17 Trigger Output 4 18 GND 19 Trigger Output 5 20 GND 21 Trigger Output 6 22 GND 23 Trigger Output 7 24 GND 25 Trigger Input 4 26 GND 27 Trigger Input 5 28 GND 29 Trigger Input 6 30 GND 31 Trigger Input 7 32 VCCIO (+2.5 VDC/ 3.3 VDC) 33 Presence Detect 34 VCCIO (+2.5 VDC/ 3.3 VDC) <p>Per default, signals are driven by open-collector drivers, but can be switched to push-pull by software. Pull-ups are on-board.</p> <p>Refer to the sections Opto Trigger 5 and TTL Trigger to learn how trigger extension boards are connected and used. Refer to the specific applet documentation to learn how the trigger signals can be used.</p> <p>Notice</p> <p>The frame grabber trigger system needs to get supply voltage on the Voltage IN pins. If you want to connect devices that have no PWR pin, you must provide the power supply to the Voltage IN pin from an external source.</p>"},{"location":"gpio-connectors.html#trigger-extension-boards","title":"Trigger Extension Boards","text":"<p>Trigger extension boards are useful to perform various tasks at small latencies, for example:</p> <ul> <li>Controlling cameras</li> <li>Controlling peripheral devices</li> <li>Synchronizing multiple frame grabbers</li> </ul> <p>All trigger extension boards available for Basler frame grabbers offer the following:</p> <ul> <li>8 digital inputs (IN 0\u20137) (8 single-ended signals or 4 differential signals)</li> <li>8 digital outputs (OUT 0\u20137).</li> </ul> <p>For more information, see Opto-Coupled Trigger 5 and TTL Trigger.</p>"},{"location":"gpio-connectors.html#applet-specific-trigger-settings","title":"Applet-Specific Trigger Settings","text":"<p>Using applets, you can configure how the individual I/Os of the trigger extension board are employed. Refer to Configuring the Trigger Options within an Applet and to the documentation of the specific applet you're using.</p>"},{"location":"gpio-connectors.html#configuring-the-trigger-options-within-an-applet","title":"Configuring the Trigger Options within an Applet","text":"<p>You can access the trigger configuration of an applet as follows:</p> <ul> <li>microDisplay X: Allows you to trigger parameter values via GUI.</li> <li>Framegrabber API: Allows the frame grabber to be integrated into a specific image processing application.</li> </ul> <p>The demands on the trigger system vary depending on your application:</p> <ul> <li>For area scan, only one trigger type is required (frame trigger).</li> <li>For line scan, two trigger types are required: Line trigger (sends a trigger pulse for each line) and frame trigger. In a line scan application, the frame trigger controls how many lines are appended to an image.</li> </ul> <p>For information which parameters are available (and which effects settings may have), refer to the documentation of the applet you are using.</p>"},{"location":"gpiotool.html","title":"gpioTool","text":"<p>The gpioTool command-line tool allows you to configure the physical properties of the trigger signals received or sent by a frame grabber or trigger board.</p> <ul> <li>You can configure the input lines to receive single-ended or differential signals.</li> <li>You can configure the input lines to operate in pull-up or pull-down mode.</li> <li>You can specify whether output signals should be inverted.</li> </ul> <p>The gpioTool is included in the Framegrabber SDK and in the pylon Software Suite.</p> <p>To start the tool:</p> <ol> <li>Open a command line.</li> <li>If you're using the Framegrabber SDK, change to the <code>bin</code> directory of your Framegrabber SDK installation: cd /D %BASLER_FG_SDK_DIR%\\bin.</li> <li> <p>If you're using pylon, change to the bin directory of your pylon installation:</p> <ul> <li>Windows: %programfiles%\\Basler\\pylon[version]\\Runtime\\x64\\pylonCXP\\bin</li> <li>Linux: /opt/pylon/lib/pylonCXP/bin</li> </ul> </li> <li> <p>Start the gpioTool using the options described below.</p> </li> </ol>"},{"location":"gpiotool.html#options","title":"Options","text":"<p>The following options are available:</p> <pre><code>gpioTool -b [board_index]\n         -g\n         -v\n         -s [bank]:[settings]\n         -h\n</code></pre> <p><code>-b [board_index]</code> Specify which board (frame grabber or trigger board) in your system you want to address. This parameter is mandatory for all options except <code>-h</code>. The value range of <code>[board_index]</code> is the index numbers of all boards installed in your system. If you only have one board in your system, set <code>[board_index]</code> to 0.</p> <p><code>-b [board_index] -g</code> Show the current GPIO bank settings of the board specified.</p> <p><code>-b [board_index] -v</code> Show the current GPIO bank settings with verbose output.</p> <p><code>-b [board_index] -s [bank]:[settings]</code> Configure the GPIO bank on the board specified. <code>[bank]</code> specifies the index number of the GPIO bank. <code>[settings]</code> configures the settings. See below.</p> <p><code>-h</code> Show help.</p>"},{"location":"gpiotool.html#settings","title":"Settings","text":"<p>For the <code>[settings]</code> part in <code>-b [board_index] -s [bank]:[settings]</code>, the following settings are available:</p> Setting Value Result <code>[signal]</code> se Configures the input lines to receive single-ended signals. <code>[signal]</code> ds Configures the input lines to receive differential signals. <code>[pull-up-down]</code> pu Configures the input lines to operate in pull-up mode.<sup>a</sup> <code>[pull-up-down]</code> pd Configures the input lines to operate in pull-down mode.<sup>b</sup> <code>[inversion]</code> ni Disables inversion for the output lines. <code>[inversion]</code> in Enables inversion for the output lines. <ol> <li> <p>For most applications, use this mode. The board activates a 10 k\u03a9 pull-up resistor to receive signals from NPN transistors (open collector, open drain).\u00a0\u21a9</p> </li> <li> <p>The board activates a 10 k\u03a9 pull-down resistor to receive signals from PNP transistors (open emitter, open source).\u00a0\u21a9</p> </li> </ol> <p>You must enter the settings in the following format: <code>[signal],[pull-up-down],[inversion]</code>. Example: ds,pu,ni</p> <p>Alternatively, you can set <code>[settings]</code> to <code>default</code>. This resets the configuration of a GPIO bank.</p>"},{"location":"gpiotool.html#example","title":"Example","text":"<p><code>gpioTool -b 0 -s 0:ds,pu,ni</code></p> <p>This command configures the board as follows:</p> <ul> <li><code>-b 0</code>: Configure the GPIOs on board 0.</li> <li><code>-s</code>: Start the actual configuration.</li> <li><code>0:</code>: Configure GPIO bank 0 (front GPIO).</li> <li><code>ds,pu,ni</code>: Configure the front GPIO to receive differential signals (ds), to work in pull-up mode (pu), and to send the outgoing signals not inverted (ni).</li> </ul>"},{"location":"gpiotool.html#resetting-the-configuration","title":"Resetting the Configuration","text":"<p>To reset a board and GPIO bank to the default settings, start the gpioTool with <code>[settings]</code> set to <code>default</code>:</p> <p><code>gpioTool -b [board_index] -s [bank]:default</code></p> <p>Example: <code>gpioTool -b 0 -s 0:default</code></p>"},{"location":"gpiotool.html#resetting-to-dip-switch-settings","title":"Resetting to DIP Switch Settings","text":"<p>You can reset a board to the current DIP switch settings. This overrides the software configuration.</p> <p>To reset a board to DIP switch settings, start the gpioTool with <code>[settings]</code> set to <code>dip-switch</code>:</p> <p><code>gpioTool -b [board_index] -s [bank]:dip-switch</code></p> <p>Example: <code>gpioTool -b 0 -s 0:dip-switch</code></p>"},{"location":"history.html","title":"History","text":""},{"location":"history.html#version-22-october-2025","title":"Version 22 (October 2025)","text":"<ul> <li>Added the function <code>GDStartAcquisitionEx</code> to the Function Reference of NVIDIA GPUDirect for Video.</li> <li>Added the section Discovery Modes Overview to the \"Using the GenTL Interface\" topic.</li> <li>Added the new topic Installing pylon and the Framegrabber SDK in Parallel.</li> <li>Added entries for ticket IDs 334080, and 333828 for Framegrabber SDK version 5.11.4, added fixed issues entries for ticket IDs 334080, and 333828 for Framegrabber SDK version 5.11.5; corrected ticket ID 335339 (was before: 334080) in Known Issues 5.11.4 and Fixed Issues 5.11.5.</li> <li>Updated the Enhanced Applets PDF documentation for the imaFlex CXP-12 Quad and for the imaWorx CXP-12 Quad.</li> </ul>"},{"location":"history.html#version-21-may-2025","title":"Version 21 (May 2025)","text":"<ul> <li>Updated the documentation for the Framegrabber SDK release 5.11.5. For a detailed list of all changes, see the Release Notes for Framegrabber SDK 5.11.5 topic.</li> <li>Removed all occurrences of \"marathon deepVCL\" from the documentation as this product has been discontinued.</li> <li>Added entries #336093 and #334080 to the \"Known Issues Framegrabber SDK 5.11.4\" topic.</li> <li>Corrected some specifications in all frame grabber hardware topics.</li> </ul>"},{"location":"history.html#version-20-march-2025","title":"Version 20 (March 2025)","text":"<ul> <li>Updated the documentation for the Framegrabber SDK release 5.11.4. For a detailed list of all changes, see the Release Notes for Framegrabber SDK 5.11.4 topic.</li> <li>Updated all acquisition applet documentation. imaFlex CXP-12 Penta now also provides dual applets.</li> <li>Improved the \"Choosing the Right Area/line Scan Acquisition Applet\" table for imaWorx CXP-12 Quad, imaFlex CXP-12 Quad, and imaFlex CXP-12 Penta.</li> <li>Added the Installing the Framegrabber SDK via Copy Deployment topic.</li> </ul>"},{"location":"history.html#version-19-january-2025","title":"Version 19 (January 2025)","text":"<ul> <li>Updated the Enhanced Applets Documentation for applet version 1.4.3.0.</li> <li>Updated the screenshots in Binning topic of the Enhanced Applets.</li> <li>Updated the mathematical formulas in Flat-Filed Correction (FFC) topic.</li> </ul>"},{"location":"history.html#version-18-december-2024","title":"Version 18 (December 2024)","text":"<ul> <li>Added the Enhanced Applets for imWorx and Enhanced Applets for imaFlex topics with the additional features:<ul> <li>Binning</li> <li>Flat-Field Correction</li> <li>PGI Feature Set.</li> </ul> </li> </ul>"},{"location":"history.html#version-17-december-2024","title":"Version 17 (December 2024)","text":"<ul> <li>Added \"UL Recognized\" and \"KC\" to \"Compliance\" in the specifications table of the imaWorx CXP-12 Quad, imaFlex CXP-12 Quad and imeFlex CXP-12 Penta.</li> <li>Improved instructions of fglib5/Starting the Acquisition.</li> </ul>"},{"location":"history.html#version-16-september-2024","title":"Version 16 (September 2024)","text":"<ul> <li>Added the imaFlex CXP-12 Penta documentation.</li> <li>Updated the documentation for the Framegrabber SDK release 5.11.3. For a detailed list of all changes, see the Release Notes for Framegrabber SDK 5.11.3 topic.</li> </ul>"},{"location":"history.html#version-15-july-2024","title":"Version 15 (July 2024)","text":"<ul> <li>Added link from the Installation navigation menu to Configuring CXP Line Scan Cameras and Frame Grabbers.</li> <li>Added info of header file for .raw image files in iolibrt topic.</li> </ul>"},{"location":"history.html#version-14-june-2024","title":"Version 14 (June 2024)","text":"<ul> <li>Changed name of pylon Camera Software Suite to pylon Software Suite.</li> <li>Added Log4cpp to the Third-Party License Notices (Framegrabber SDK).</li> <li>Added instructions for configuring a shaft encoder in topic Trigger Applications</li> </ul>"},{"location":"history.html#version-13-april-2024","title":"Version 13 (April 2024)","text":"<ul> <li>Deleted Power Consumption and Ambient Temperature from the Specifications table for the imaWorx CXP-12 Quad and imaFlex CXP-12 Quad frame grabbers.</li> <li>Set function of PGEXT LED of the imaWorx CXP-12 Quad and imaFlex CXP-12 Quad frame grabbers to \"not defined\".</li> </ul>"},{"location":"history.html#version-12-january-2024","title":"Version 12 (January 2024)","text":"<ul> <li>Added the imaFlex CXP-12 Quad documentation.</li> <li>Updated the documentation for the Framegrabber SDK release 5.11.2. For a detailed list of all changes, see the Release Notes for Framegrabber SDK 5.11.2 topic.</li> </ul>"},{"location":"history.html#version-11-december-2023","title":"Version 11 (December 2023)","text":"<ul> <li>Updated product image in overview topic.</li> </ul>"},{"location":"history.html#version-10-july-2023","title":"Version 10 (July 2023)","text":"<ul> <li>Updated the documentation for the Framegrabber SDK release 5.11.0. For a detailed list of all changes, see the Release Notes Framegrabber SDK 5.11.0 topic topic.</li> <li>Updated the applet documentation for the CXP-12 Interface Cards and the imaWorx CXP-12 Quad frame grabber. Additionally, the following new applet documentation is now available:<ul> <li>Line scan applet documentation for the CXP-12 Interface Cards</li> <li>FGLib variant of the applet documentation for all CXP-12 Interface Cards</li> </ul> </li> </ul>"},{"location":"history.html#version-09-may-2023","title":"Version 09 (May 2023)","text":"<ul> <li>Framegrabber SDK:<ul> <li>Added issue 272272 to the list of known issues.</li> <li>Moved issue 197430 from the list of known issues to the list of fixed issues.</li> <li>Revised instructions in the \"Installing the Driver for Frame Grabbers\" section in the Installing the Framegrabber SDK topic.</li> </ul> </li> <li>Updated bandwidth specifications in the imaWorx CXP-12 Quad Acquisition Applets topic.</li> </ul>"},{"location":"history.html#version-08-february-2023","title":"Version 08 (February 2023)","text":"<ul> <li>Added the \"Processors\" section to the System Requirements for Framegrabber SDK 5.10.0 topic.</li> <li>Added further discontinued frame grabbers to the \"Discontinuations\" list in the Changes and Fixed Issues in Framegrabber SDK 5.10.0 topic.</li> <li>Added a known issues entry regarding the PATH environment variable for Windows 32-bit installations. See Known Issues Framegrabber SDK 5.10.0.</li> <li>Added the Determining the Frame Number Using the Framegrabber API knowledge article.</li> </ul>"},{"location":"history.html#version-07-december-2022","title":"Version 07 (December 2022)","text":"<ul> <li>Revised the entire documentation. Design and wording are now in line with Basler's documentation style. Also, most frame grabber content is now searchable via the search function.</li> <li>Restructured the frame grabber documentation to match the structure of the Basler Product Documentation. Separated hardware-specific and software-specific topics.</li> <li>Added the imaWorx CXP-12 Quad documentation.</li> <li>Renamed the Runtime software to \"Framegrabber SDK\" and updated the documentation for Framegrabber SDK release 5.10.0. For a detailed list of all changes, see the Release Notes.</li> <li>Updated the applet documentation. The applet documentation now appears in Basler's documentation style.</li> </ul>"},{"location":"history.html#version-06-june-2022","title":"Version 06 (June 2022)","text":"<ul> <li>Moved the following topics from this documentation to the \"Acquisition Cards\" section of the Basler Product Documentation:<ul> <li>Configuring a CXP-12 Interface Card</li> <li>CXP-12 Interface Card 1C</li> <li>CXP-12 Interface Card 2C</li> <li>CXP-12 Interface Card 4C</li> <li>CXP-12 Interface Cards</li> <li>Updating the Firmware of a CXP-12 Interface Card</li> </ul> </li> </ul>"},{"location":"history.html#version-05-may-2022","title":"Version 05 (May 2022)","text":"<ul> <li>Linked all mE5 frame grabber documentations to the correct Runtime release notes.</li> </ul>"},{"location":"history.html#version-04-march-2022","title":"Version 04 (March 2022)","text":"<ul> <li>Revised the Configuring a CXP-12 Interface Card topic.</li> </ul>"},{"location":"history.html#version-03-october-2021","title":"Version 03 (October 2021)","text":"<ul> <li>Moved the following products from the \"PC Cards\" section of the Basler Product Documentation to this documentation:<ul> <li>CXP-12 Interface Card 1C</li> <li>CXP-12 Interface Card 2C</li> <li>CXP-12 Interface Card 4C</li> </ul> </li> <li>Removed the following discontinued products from the documentation:<ul> <li>microEnable IV AQ4-GE</li> <li>microEnable IV AQ4-GPoE</li> <li>microEnable IV VQ4-GE</li> <li>microEnable IV VQ4-GPoE</li> </ul> </li> </ul>"},{"location":"history.html#version-02-september-2021","title":"Version 02 (September 2021)","text":"<ul> <li>Added link to the documentation of the Basler imaWorx CXP-12 Quad frame grabber.</li> </ul>"},{"location":"history.html#version-01-february-2021","title":"Version 01 (February 2021)","text":"<p>Initial version of this documentation.</p> <p>Content is based on the \"Frame Grabbers\" section of the Basler Product Documentation (AW001406), version 45, with the following changes:</p> <ul> <li>Revised the Frame Grabbers topic.</li> <li>Added the \"Models\" section and the Frame Grabber Models topic.</li> <li>Updated design and wording in line with Basler's documentation style.</li> </ul>"},{"location":"imaflex-cxp-12-penta.html","title":"imaFlex CXP-12 Penta","text":"<p>imaFlex CXP-12 Penta is a fully programmable CXP-12 frame grabber. When connected to the computer power supply, imaFlex CXP-12 Penta supports Power over CXP (PoCXP).</p> <p></p> <p>To install the imaFlex CXP-12 Penta in your host computer, plug it into a PCIe Gen. 3.0 x8 slot or higher. The following image shows an imaFlex CXP-12 Penta with five cameras connected to it:</p> <p></p>"},{"location":"imaflex-cxp-12-penta.html#image-processing","title":"Image Processing","text":"<p>The frame grabber is fully programmable by VisualApplets. You can design your own image processing application tuned to your specific needs. Basler offers consultancy support, VisualApplets trainings and of course Basler can also implement for you your specific application.</p> <p>For information on how to write your own applets with VisualApplets.</p>"},{"location":"imaflex-cxp-12-penta.html#production-line-integration","title":"Production Line Integration","text":"<p>For integration into a production line, imaFlex CXP-12 Penta offers multiple general purpose inputs and outputs. 8 (with the TTL Trigger board) or 24 (with the Opto-Coupled Trigger 5 board) of the GPIOs (depending on the hardware add-ons used) are galvanically isolated.</p> <p>These GPIOs enable you to do the following:</p> <ul> <li>Control peripheral devices by sending trigger signals, e.g. lighting signals and cameras signals</li> <li>Receive various trigger signals from peripheral devices, e.g., shaft encoders and light barriers</li> <li>Synchronize multiple imaFlex CXP-12 Penta frame grabbers, and/or</li> <li>Synchronize connected devices.</li> </ul> <p></p>"},{"location":"imaflex-cxp-12-penta.html#software-programming-and-configuration-interface","title":"Software Programming and Configuration Interface","text":"<p>imaFlex CXP-12 Penta offers an easy-to-use API. The Framegrabber API allows to integrate the frame grabber into any image processing application. You can use the Framegrabber API to write code in the following languages:</p> <ul> <li>C/C++</li> <li>C# (wrapper available)</li> <li>Python (wrapper available)</li> </ul> <p>For more information about the Framegrabber API, see the Framegrabber API documentation.</p> <p>Alternatively, you can use Basler's GenTL Interface to develop your application in form of a GenTL consumer. For more information about the Basler GenTL Interface, see GenTL Interface documentation.</p>"},{"location":"imaflex-cxp-12-penta.html#connectors-and-leds","title":"Connectors and LEDs","text":""},{"location":"imaflex-cxp-12-penta.html#connectors","title":"Connectors","text":"<p>imaFlex CXP-12 Penta has the following connectors:</p> <p></p>"},{"location":"imaflex-cxp-12-penta.html#leds-on-the-slot-bracket","title":"LEDs on the Slot Bracket","text":"<p>There are five LEDs located on the slot bracket of imaFlex CXP-12 Penta that indicate the state of the individual CXP links:</p> <p> Connection at CXP link ready for operation</p> <p> No connection at CXP link</p>"},{"location":"imaflex-cxp-12-penta.html#leds-on-the-board","title":"LEDs on the Board","text":"LED Name LED Color Meaning TRG Yellow External voltage supplied via the 15-pin connector. READY Orange The FPGA has been configured successfully and is ready for operation. PG_INT Green PG_INT=Power Good InternalVoltage on the PCIe slot is stable. The voltage generated internally is also stable. PGEXT Green Not defined/internal function. USR1 to USR6 Green User-defined. The LEDs can be controlled via VisualApplets software. They are not related to camera connectors and can be used for any purpose. 12V Green or red Off: The framegrabber is not powered.Red: The frame grabber receives power only via the PCIe slot (12 VDC IN). Green: The frame grabber's 6-pin (12V) power connector is connected to a power supply via the host computer."},{"location":"imaflex-cxp-12-penta.html#specifications","title":"Specifications","text":"imaFlex CXP-12 Penta Host Interface PCIe Gen 3 x8 (Direct Memory Access) Bandwidth (typ./max.) 6520 MB/s On-Board Memory 2.5 GB DDR4-RAM Power Supply (Input) / Current PCIe Slot 12 V (\u00b15 %) / &lt;1.5 A (actual values depend on processing) Power Supply (Input) / Current PCIe 6-pin Connector 12 V (\u00b15 %) / &lt;6.5 A (actual values depend on connected PoCXP cameras) PoCXP Supply (Output) 17 W of 24 V DC regulated power per CoaXPress connector Size (L x H) PCIe standard heightHalf length card:167.64 mm x 111.15 mm Weight 270 g Camera Interface 5 x CXP-12 (CXP-1 to CXP-12, micro-BNC/HD-BNC connector) Ambient Temperature 50 \u00b0CAn adequate airflow in the computer is recommended. Operating Temperature 0\u201350 \u00b0C at 100 LFM<sup>a</sup> Storage Temperature -50\u201380 \u00b0C Humidity during Operation 5\u201390 % Humidity during Storage 5\u201395 % Compliance CE, FCC, RoHS, WEEE, REACH, UKCA, UL Recognized, KCCertificates for your interface cardFor more information, see the Compliance section of the Basler website. <ol> <li> <p>LFM = Linear Feet per Minute, unit for measuring airflow velocity.\u00a0\u21a9</p> </li> </ol> <p>Info</p> <p>The PCIe bus data throughput depends on the mainboard, the chip set, and the BIOS configuration of the host computer. The number of installed PCIe boards also affects the throughput, e.g. a PCIe x8 connector may support only x4 performance. Always check the mainboard manual thoroughly to be sure.</p>"},{"location":"imaflex-cxp-12-penta.html#the-front-gpio-connector","title":"The Front GPIO Connector","text":"<p>The front GPIO connector covers the basic trigger setup of your frame grabber. Its trigger connector allows you to control peripheral devices (PLC).</p> <p>The socket is located directly on the slot bracket:</p> <p></p> <p>In default configuration, the trigger connector of the front GPIO connector offers:</p> <ul> <li>3 differential input signals or 2 differential and 1 single-ended input signal in pull-up mode</li> <li>4 TTL output signals</li> </ul> <p>Info</p> <p>You can configure the pin assignment of the front GPIO connector to provide different input signals, e.g.:</p> <ul> <li>Pull-down</li> <li>4 single-ended signals (and no differential signals).</li> </ul> <p>To change the GPIO configuration, use the command line tool installed with the Framegrabber SDK.</p> <p>For more information, see Input Configuration and Configuring the Physical Properties of Trigger Signals with the gpioTool.</p>"},{"location":"imaflex-cxp-12-penta.html#pin-layout-of-the-front-gpio-connector","title":"Pin Layout of the Front GPIO Connector","text":"<p>Info</p> <p>The front GPIO connector is provided in form of a MOLEX 83612-9020 connector. For this connector, a matching, ready-made MOLEX D-Sub cable is available (MOLEX 083422-9018).</p> PIN Number (3P FPGA) Galvanically Isolated Signal Reference Signal 1 Yes GPO 0 (TTL) 5 V / GPIO GND (pin 6 and 15) 2 Yes GPO 1 (TTL) 5 V / GPIO GND (pin 6 and 15) 3 Yes GPO 2 (TTL) 5 V / GPIO GND (pin 6 and 15) 4 Yes GPO 3 (TTL) 5 V / GPIO GND (pin 6 and 15) 5 No 5 V_OUT (isolated 5V output, max 500mA) GPIO GND (pin 6 and 15) 6 No GPIO GND (Isolated GND) 7 No \u2014 (not connected) 8 Yes GPI 2 (GPI2+ if used for differential signal) GPI voltage IN (pin 10) / GPIO GND (pin 6 and 15) 9 Yes GPI 3 (GPI2- if used for differential signal) GPI voltage IN (pin 10) / GPIO GND (pin 6 and 15) 10 Yes GPI voltage IN (4.5\u201328 V input for pullups / comparators. VIN_REF is 20% of VIN) GPIO GND (pin 6 and 15) 11 Yes GPI 0+ GPI voltage IN (pin 10) / GPIO GND (pin 6 and 15) 12 Yes GPI 0- GPI voltage IN (pin 10) / GPIO GND (pin 6 and 15) 13 Yes GPI 1+ GPI voltage IN (pin 10) / GPIO GND (pin 6 and 15) 14 Yes GPI 1- GPI voltage IN (pin 10) / GPIO GND (pin 6 and 15) 15 Yes GPIO GND (isolated GND) Shield No GND (Non-isolated ground / Earth / bracket)"},{"location":"imaflex-cxp-12-penta.html#possible-topologies","title":"Possible Topologies","text":"<p>There are many possibilities to connect cameras with 1, 2, or 4 CXP channels to imaFlex CXP-12 Penta. The maximal amount of used CXP channels in total over all cameras is 5 CXP-12 channels. Each camera can operate at different CXP bitrates. All CXP 2.0 bitrates are supported for each CXP camera independently.</p> <p>You can operate imaFlex CXP-12 Penta as follows:</p> Topology Number of Cameras Number of Channels Topology One camera one channel single 1 1 One camera two channels single 1 2 One camera four channels single 1 4 Two cameras one channel each penta 2 2 Three cameras one channel each penta 3 3 Four cameras one channel each penta 4 4 Five cameras one channel each penta 5 1 <p>When connected to the computer power supply via the PCIe 6-pin connector, which always provides 12 V, imaFlex CXP-12 Penta supports Power over CXP (PoCXP).</p> <p>You may connect the cameras in any order. The connection topology is totally independent on the port number. Any camera channel can be connected to any frame grabber CXP port. The CXP 2.0 topology discovery will reorder the channels virtually in software according to the cameras and VisualApplets applet configuration.</p> <p>Info</p> <p>If you are going to use multiple imaFlex CXP-12 Penta boards in one host computer, make sure you have one PCIe Gen. 3.0 x8 slot or higher per board available in the host computer. For more information, see the following topics:</p> <ul> <li>Using Multiple Boards in one Host</li> <li>Synchronizing Multiple Boards</li> </ul>"},{"location":"imaflex-cxp-12-penta.html#acquisition-applets","title":"Acquisition Applets","text":"<p>To ensure optimum use of system resources, not all image acquisition and processing features designed for imaFlex CXP-12 Penta are loaded onto imaFlex CXP-12 Penta simultaneously.</p> <p>Instead, Basler provides various compilations of specific image acquisition and processing features that are combined to meet the requirements of a specific application field.</p> <p>Typically, an applet supports a specific camera interface standard and topology, specific image acquisition features, and possibly specific image (pre-)processing features.</p> <p>There are two kinds of applets: acquisition applets (*.dll) always delivered by Basler, and custom applets (*.hap) developed in VisualApplets either by yourself or by Basler. imaFlex CXP-12 Penta is delivered with one Test Applet. All other applets need to be designed with VisualApplets.</p> <p>Refer to Acquisition Applets for imaFlex CXP-12 Penta for more information about the Test Applet.</p>"},{"location":"imaflex-cxp-12-quad.html","title":"imaFlex CXP-12 Quad","text":"<p>imaFlex CXP-12 Quad is a fully programmable CXP-12 frame grabber. When connected to the computer power supply, imaFlex CXP-12 Quad supports Power over CXP (PoCXP).</p> <p></p> <p>To install the imaFlex CXP-12 Quad in your host computer, plug it into a PCIe Gen. 3.0 x8 slot or higher. The following image shows an imaFlex CXP-12 Quad with two cameras connected to it:</p> <p></p>"},{"location":"imaflex-cxp-12-quad.html#image-processing","title":"Image Processing","text":"<p>The frame grabber is fully programmable by VisualApplets. You can design your own image processing application tuned to your specific needs. Basler offers consultancy support, VisualApplets trainings and of course Basler can also implement for you your specific application.</p> <p>For information on how to write your own applets with VisualApplets.</p>"},{"location":"imaflex-cxp-12-quad.html#production-line-integration","title":"Production Line Integration","text":"<p>For integration into a production line, imaFlex CXP-12 Quad offers multiple general purpose inputs and outputs. 4 to 20 of the GPIOs (depending on the hardware add-ons used) are galvanically isolated.</p> <p>These GPIOs enable you to do the following:</p> <ul> <li>Control peripheral devices by sending trigger signals, e.g. lighting signals and cameras signals</li> <li>Receive various trigger signals from peripheral devices, e.g., shaft encoders and light barriers</li> <li>Synchronize multiple imaFlex CXP-12 Quad frame grabbers, and/or</li> <li>Synchronize connected devices.</li> </ul> <p></p>"},{"location":"imaflex-cxp-12-quad.html#software-programming-and-configuration-interface","title":"Software Programming and Configuration Interface","text":"<p>imaFlex CXP-12 Quad offers an easy-to-use API. The Framegrabber API allows to integrate the frame grabber into any image processing application. You can use the Framegrabber API to write code in the following languages:</p> <ul> <li>C/C++</li> <li>C# (wrapper available)</li> <li>Python (wrapper available)</li> </ul> <p>For more information about the Framegrabber API, see the Framegrabber API documentation.</p> <p>Alternatively, you can use Basler's GenTL Interface to develop your application in form of a GenTL consumer. For more information about the Basler GenTL Interface, see GenTL Interface documentation.</p>"},{"location":"imaflex-cxp-12-quad.html#connectors-and-leds","title":"Connectors and LEDs","text":""},{"location":"imaflex-cxp-12-quad.html#connectors","title":"Connectors","text":"<p>imaFlex CXP-12 Quad has the following connectors:</p> <p></p>"},{"location":"imaflex-cxp-12-quad.html#leds-on-the-slot-bracket","title":"LEDs on the Slot Bracket","text":"<p>There are four LEDs located on the slot bracket of imaFlex CXP-12 Quad that indicate the state of the individual CXP links:</p> <p> Connection at CXP link ready for operation</p> <p> No connection at CXP link</p>"},{"location":"imaflex-cxp-12-quad.html#leds-on-the-board","title":"LEDs on the Board","text":"LED Name LED Color Meaning TRG Yellow External voltage supplied via the 15-pin connector. READY Orange The FPGA has been configured successfully and is ready for operation. PGINT Green PGINT=Power Good InternalVoltage on the PCIe slot is stable. The voltage generated internally is also stable. PGEXT Green Not defined/internal function. USR1 to USR6 Green User-defined. The LEDs can be controlled via VisualApplets software. They are not related to camera connectors and can be used for any purpose. 12EXT Green The frame grabber's PCIe power connector is connected to a power supply via the host computer. 12PCI Green or red Green: The frame grabber receives power via the PCIe slot (12 VDC IN). Red: The frame grabber doesn't get power via PCIe slot."},{"location":"imaflex-cxp-12-quad.html#specifications","title":"Specifications","text":"imaFlex CXP-12 Quad Host Interface PCIe Gen 3 x8 (Direct Memory Access) Bandwidth (typ./max.) 6520 MB/s On-Board Memory 1.5 GB DDR4-RAM Power Supply (Input) / Current PCIe Slot 12 V (\u00b15 %) / &lt;1.5 A (actual values depend on processing) Power Supply (Input) / Current PCIe 6-pin Connector 12 V (\u00b15 %) / &lt;6.5 A (actual values depend on connected PoCXP cameras) PoCXP Supply (Output) 17 W of 24 V DC regulated power per CoaXPress connector Size (L x H) PCIe standard heightHalf length card:167.64 mm x 111.15 mm Weight 274 g Camera Interface 4 x CXP-12 (CXP-1 to CXP-12, micro-BNC/HD-BNC connector) Operating Temperature 0\u201350 \u00b0C at 100 LFM<sup>a</sup> Storage Temperature -50\u201380 \u00b0C Humidity during Operation 5\u201390 % Humidity during Storage 5\u201395 % Compliance CE, FCC, RoHS, WEEE, REACH, UKCA, UL Recognized, KCCertificates for your interface cardFor more information, see the Compliance section of the Basler website. <ol> <li> <p>LFM = Linear Feet per Minute, unit for measuring airflow velocity.\u00a0\u21a9</p> </li> </ol> <p>Info</p> <p>The PCIe bus data throughput depends on the mainboard, the chip set, and the BIOS configuration of the host computer. The number of installed PCIe boards also affects the throughput, e.g. a PCIe x8 connector may support only x4 performance. Always check the mainboard manual thoroughly to be sure.</p>"},{"location":"imaflex-cxp-12-quad.html#the-front-gpio-connector","title":"The Front GPIO Connector","text":"<p>The front GPIO connector covers the basic trigger setup of your frame grabber. Its trigger connector allows you to control peripheral devices (PLC).</p> <p>The socket is located directly on the slot bracket:</p> <p></p> <p>In default configuration, the trigger connector of the front GPIO connector offers:</p> <ul> <li>3 differential input signals or 2 differential and 1 single-ended input signal in pull-up mode</li> <li>2 TTL output signals</li> </ul> <p>Info</p> <p>You can configure the pin assignment of the front GPIO connector to provide different input signals, e.g.:</p> <ul> <li>Pull-down</li> <li>4 single-ended signals (and no differential signals).</li> </ul> <p>To change the GPIO configuration, use the command line tool installed with the Framegrabber SDK.</p> <p>For more information, see Input Configuration and Configuring the Physical Properties of Trigger Signals with the gpioTool.</p>"},{"location":"imaflex-cxp-12-quad.html#pin-layout-of-the-front-gpio-connector","title":"Pin Layout of the Front GPIO Connector","text":"<p>Info</p> <p>The front GPIO connector is provided in form of a MOLEX 83612-9020 connector. For this connector, a matching, ready-made MOLEX D-Sub cable is available (MOLEX 083422-9018).</p> PIN Number (3P FPGA) Galvanically Isolated Signal Reference Signal 1 No GPO 0 (TTL) 5 V / global GND (pin 6) 2 No GPO 1 (TTL) 5 V / global GND (pin 6) 3 No Reserved for RS 485 (GND) 4 No Reserved for RS 485 5 No 5 V_OUT (0.5 A max) 6 No GND (global GND) 7 No \u2014 8 Yes GPI 2 (GPI2+ if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 9 Yes GPI 3 (GPI2- if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 10 Yes GPI voltage IN (4.5\u201328 V) GPI GND (pin 15) 11 Yes GPI 0+ GPI voltage IN (pin 10) / GPI GND (pin 15) 12 Yes GPI 0- GPI voltage IN (pin 10) / GPI GND (pin 15) 13 Yes GPI 1+ GPI voltage IN (pin 10) / GPI GND (pin 15) 14 Yes GPI 1- GPI voltage IN (pin 10) / GPI GND (pin 15) 15 Yes GPI GND Shield No GND (Non-isolated ground / Earth / bracket)"},{"location":"imaflex-cxp-12-quad.html#possible-topologies","title":"Possible Topologies","text":"<p>You can operate imaFlex CXP-12 Quad as follows:</p> Number of Cameras Number of Channels Topology 1 1 1 2 1 4 2 2 2 3 2 4 3 3 3 4 4 4 <p>When connected to the computer power supply via the PCIe 6-pin connector, which always provides 12 V, imaFlex CXP-12 Quad supports Power over CXP (PoCXP).</p> <p>You may connect the cameras in any order.</p> <p>Info</p> <p>If you are going to use multiple imaFlex CXP-12 Quad boards in one host computer, make sure you have one PCIe Gen. 3.0 x8 slot or higher per board available in the host computer. For more information, see Using Multiple Boards in one Host.</p>"},{"location":"imaflex-cxp-12-quad.html#applets","title":"Applets","text":"<p>To ensure optimum use of system resources, not all image acquisition and processing features designed for imaFlex CXP-12 Quad are loaded onto imaFlex CXP-12 Quad simultaneously. Instead, Basler provides various compilations of specific image acquisition and processing features that are combined to meet the requirements of a specific application field.</p> <p>Typically, an applet supports a specific camera interface standard and topology, specific image acquisition features, and possibly specific image (pre-)processing features. By loading an applet onto the frame grabber, you define the functionality of the frame grabber and adapt it to the requirements of your specific application.</p> <p>There are three kinds of applets: acquisition applets (*.dll) always delivered by Basler, custom applets (*.hap) developed in VisualApplets either by yourself or by Basler, and Enhanced Applets. In addition to the acquisition applets that are included in the delivery, imaFlex CXP-12 Quad can be programmed to fulfill highly specific image processing tasks that are required by a specific application. The programming can be done by Basler, a certified partner, or by yourself using the easy-to-use graphical FPGA programming environment VisualApplets.</p> <p>The Enhanced Applets are a new set of ready-to-use applets, available for imaFlex CXP-12 Quad. Enhanced Applets are the link between AcquisitionApplets and Custom Applets: Enhanced Applets include functions for the acquisition and pre-processing of image and signal data, as well as the processing of system information. They provide the features Binning, Flat-Field Correction (FFC), and PGI Feature Set.</p> <p>Refer to Acquisition Applets for imaFlex CXP-12 for more information about the Acquisition Applets and to Enhanced Applets (imaFlex CXP-12 Quad) for more information about Enhanced Applets.</p>"},{"location":"imaworx-cxp-12-quad.html","title":"imaWorx CXP-12 Quad","text":"<p>imaWorx CXP-12 Quad is a CXP-12 frame grabber. When connected to the computer power supply, imaWorx CXP-12 Quad supports Power over CXP (PoCXP).</p> <p></p> <p>To install the imaWorx CXP-12 Quad in your computer, plug it into a PCIe Gen. 3.0 x8 slot or higher. The following image shows an imaWorx CXP-12 Quad with two cameras connected to it:</p> <p></p>"},{"location":"imaworx-cxp-12-quad.html#image-processing","title":"Image Processing","text":"<p>Image processing functionality is available on request. If you are interested, contact Basler Support.</p>"},{"location":"imaworx-cxp-12-quad.html#production-line-integration","title":"Production Line Integration","text":"<p>For integration into a production line, imaWorx CXP-12 Quad offers multiple general purpose inputs and outputs. 4 to 20 of the GPIOs (depending on the hardware add-ons used) are galvanically isolated.</p> <p>These GPIOs enable you to do the following:</p> <ul> <li>Control peripheral devices by sending trigger signals, e.g. lighting signals and cameras signals.</li> <li>Receive various trigger signals from peripheral devices, e.g., shaft encoders and light barriers.</li> <li>Synchronize multiple imaWorx CXP-12 Quad frame grabbers.</li> <li>Synchronize connected devices.</li> </ul> <p></p>"},{"location":"imaworx-cxp-12-quad.html#software-programming-and-configuration-interface","title":"Software Programming and Configuration Interface","text":"<p>imaWorx CXP-12 Quad offers an easy-to-use API. The Framegrabber API allows to integrate the frame grabber into any image processing application. You can use the Framegrabber API to write code in the following languages:</p> <ul> <li>C/C++</li> <li>C# (wrapper available)</li> <li>Python (wrapper available)</li> </ul> <p>For more information about the Framegrabber API, see the Framegrabber API documentation.</p> <p>Alternatively, you can use Basler's GenTL Interface to develop your application in form of a GenTL consumer. For more information about the Basler GenTL Interface, see GenTL Interface documentation.</p>"},{"location":"imaworx-cxp-12-quad.html#connectors-and-leds","title":"Connectors and LEDs","text":""},{"location":"imaworx-cxp-12-quad.html#connectors","title":"Connectors","text":"<p>imaWorx CXP-12 Quad has the following connectors:</p> <p></p>"},{"location":"imaworx-cxp-12-quad.html#leds-on-the-slot-bracket","title":"LEDs on the Slot Bracket","text":"<p>There are four LEDs located on the slot bracket of imaWorx CXP-12 Quad that indicate the state of the individual CXP links:</p> <p> Connection at CXP link ready for operation</p> <p> No connection at CXP link</p>"},{"location":"imaworx-cxp-12-quad.html#leds-on-the-board","title":"LEDs on the Board","text":"LED Name LED Color Meaning TRG Yellow External voltage supplied via the 15-pin connector. READY Orange The FPGA has been configured successfully and is ready for operation. PGINT Green PGINT=Power Good InternalVoltage on the PCIe slot is stable. The voltage generated internally is also stable. PGEXT Green Not defined/internal function. USR1 to USR6 Green User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. 12EXT Green The frame grabber's PCIe power connector is connected to a power supply via the host computer. 12PCI Green or red Green: The frame grabber receives power via the PCIe slot (12 VDC IN). Red: The frame grabber doesn't get power via PCIe slot."},{"location":"imaworx-cxp-12-quad.html#specifications","title":"Specifications","text":"imaWorx CXP-12 Quad Order Number 2200000482 Host Interface PCIe Gen 3 x8 (Direct Memory Access) Bandwidth (typ./max.) 6520 MB/s On-Board Memory 1.5 GB DDR4-RAM Power Supply (Input) / Current PCIe Slot 12 VDC (\u00b15 %) / &lt;1.5 A (actual values depend on processing) Power Supply (Input) / Current PCIe 6-pin Connector 12 VDC (\u00b15 %) / &lt;6.5 A (actual values depend on connected PoCXP cameras) PoCXP Supply (Output) 17 W of 24 VDC regulated power per CoaXPress connector Size (L x H) PCIe standard heightHalf length card:167.64 mm x 111.15 mm Weight 274 g Camera Interface 4 x CXP-12 (CXP-1 to CXP-12, micro-BNC/HD-BNC connector) Operating Temperature 0\u201350 \u00b0C at 100 LFM<sup>a</sup> Storage Temperature -50\u201380 \u00b0C Humidity during Operation 5\u201390 % Humidity during Storage 5\u201395 % Compliance CE, FCC, RoHS, WEEE, REACH, UKCA, UL Recognized, KCCertificates for your interface cardFor more information, see the Compliance section of the Basler website. <ol> <li> <p>LFM = Linear Feet per Minute, unit for measuring airflow velocity.\u00a0\u21a9</p> </li> </ol> <p>Info</p> <p>The PCIe bus data throughput depends on the mainboard, the chip set, and the BIOS configuration of the host computer. The number of installed PCIe boards also affects the throughput, e.g. a PCIe x8 connector may support only x4 performance. Always check the mainboard manual thoroughly to be sure.</p>"},{"location":"imaworx-cxp-12-quad.html#the-front-gpio-connector","title":"The Front GPIO Connector","text":"<p>The front GPIO connector covers the basic trigger setup of your frame grabber. Its trigger connector allows you to control peripheral devices (PLC).</p> <p>The socket is located directly on the slot bracket:</p> <p></p> <p>In default configuration, the trigger connector of the front GPIO connector offers:</p> <ul> <li>3 differential input signals or 2 differential and 1 single-ended input signal in pull-up mode</li> <li>2 TTL output signals</li> </ul> <p>Info</p> <p>You can configure the pin assignment of the front GPIO connector to provide different input signals, e.g.:</p> <ul> <li>Pull-down</li> <li>4 single-ended signals (and no differential signals).</li> </ul> <p>To change the GPIO configuration, use the command line tool installed with the Framegrabber SDK.</p> <p>For more information, see Input Configuration and gpioTool.</p>"},{"location":"imaworx-cxp-12-quad.html#pin-layout-of-the-front-gpio-connector","title":"Pin Layout of the Front GPIO Connector","text":"<p>Info</p> <p>The front GPIO connector is provided in form of a MOLEX 83612-9020 connector. For this connector, a matching, ready-made MOLEX D-Sub cable is available (MOLEX 083422-9018).</p> PIN Number (3P FPGA) Galvanically Isolated Signal Reference Signal 1 No GPO 0 (TTL) 5 VDC / global GND (pin 6) 2 No GPO 1 (TTL) 5 VDC / global GND (pin 6) 3 No Reserved for RS 485 (GND) 4 No Reserved for RS 485 5 No 5 V_OUT (0.5 A max) 6 No GND (global GND) 7 No \u2014 8 Yes GPI 2 (GPI2+ if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 9 Yes GPI 3 (GPI2- if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 10 Yes GPI voltage IN (4.5\u201328 VDC) 11 Yes GPI 0+ GPI voltage IN (pin 10) / GPI GND (pin 15) 12 Yes GPI 0- GPI voltage IN (pin 10) / GPI GND (pin 15) 13 Yes GPI 1+ GPI voltage IN (pin 10) / GPI GND (pin 15) 14 Yes GPI 1- GPI voltage IN (pin 10) / GPI GND (pin 15) 15 Yes GPI GND"},{"location":"imaworx-cxp-12-quad.html#possible-topologies","title":"Possible Topologies","text":"<p>You can operate imaWorx CXP-12 Quad as follows:</p> Number of Cameras Number of Channels Topology 1 1 1 2 1 4 2 2 2 3 2 4 3 3 3 4 4 4 <p>When connected to the computer power supply via the PCIe 6-pin connector, which always provides 12 V, imaWorx CXP-12 Quad supports Power over CXP (PoCXP).</p> <p>You may connect the cameras in any order.</p> <p>Info</p> <p>If you are going to use multiple imaWorx CXP-12 Quad boards in one host computer, make sure you have one PCIe Gen. 3.0 x8 slot or higher per board available in the host computer. For more information, see Using Multiple Boards in one Host.</p> <p>To find out which topology you can use with which applet, refer to Choosing the Right Area Scan Applet or Choosing the Right Line Scan Applet.</p>"},{"location":"imaworx-cxp-12-quad.html#applets","title":"Applets","text":"<p>To ensure optimum use of system resources, not all image acquisition and processing features designed for imaWorx CXP-12 Quad are loaded onto imaWorx CXP-12 Quad simultaneously.</p> <p>Instead, Basler provides various compilations of specific image acquisition and processing features that are combined to meet the requirements of a specific application field.</p> <p>Typically, an applet supports a specific camera interface standard and topology, specific image acquisition features, and possibly specific image (pre-)processing features.</p> <p>Applets come in .dll files.</p> <p>Additionally, the Enhanced Applets are a new set of ready-to-use applets, available for imaWorx CXP-12 Quad. Enhanced Applets are the link between AcquisitionApplets and Custom Applets: Enhanced Applets include functions for the acquisition and pre-processing of image and signal data, as well as the processing of system information. They provide the features Binning, Flat-Field Correction (FFC), and PGI Feature Set.</p> <p>Refer to Acquisition Applets for imaFlex CXP-12 Quad for more information about the Acquisition Applets and to Enhanced Applets (imaFlex CXP-12 Quad) for more information about Enhanced Applets.</p>"},{"location":"initial-system-test-micro-display-x.html","title":"Initial System Test (microDisplay X)","text":"<p>Basler recommends performing an initial system test to check if your installation is working.</p> <p>Info</p> <p>The screenshots in this section show a CXP-12 frame grabber with its applets. However, the basic steps for acquiring an image are the same on all frame grabbers.</p>"},{"location":"initial-system-test-micro-display-x.html#performing-a-system-test","title":"Performing a System Test","text":"<p>To perform a system test:</p> <ol> <li>Start microDisplay X on your computer.</li> <li> <p>Select the frame grabber you want to work with from the list in the left upper corner.A tool tip provides you with additional information on the frame grabber:</p> <p></p> <p>When selecting a frame grabber, a list of applets should appear in the pane below:</p> <p></p> <p>Info</p> <p>If there are no applets displayed, install the applet set for your frame grabber model on the host computer as described in Managging Applets (microDiagnostics). After installation, select File -&gt; Rescan Applets in microDisplay X.</p> </li> <li> <p>Select an applet out of the applets list.A tool tip provides you with additional information on each applet:</p> <p></p> <p>The applet you select must correspond to the connected cameras (number of connected cameras per frame grabber, area or line scan, etc.).</p> <p>The applet name displayed in bold is the applet that is currently active on the frame grabber.</p> <p>The applets displayed in black are the applets currently available for the selected frame grabber.</p> <p>When is an applet available?</p> <ul> <li>On imaWorx and imaFlex frame grabbers, an applet is available as soon as it is available in the file system of your computer (Framegrabber SDK installation directory, sub-directories DLL or Hardware Applets). If the applet isn't there, run the applet installer that contains the applet you want to use, or, if you need an applet created with VisualApplets, copy the applet file (*.hap) into the Hardware Applets folder of your Framegrabber SDK installation (e.g., <code>...\\Basler\\FramegrabberSDK5.x.x\\Hardware Applets\\*.hap</code>).</li> <li>On marathon frame grabbers, an applet is available as soon as it is flashed onto the frame grabber. If the applet you want to use isn't flashed on the frame grabber yet, flash it according to the instructions in Managing Applets (microDiagnostics).</li> </ul> </li> <li> <p>Double-click on the applet name to load the applet.</p> <p></p> <p>The applet is loaded. The acquisition processes of the applet (together with the respective camera and DMA ports) are displayed in the left-hand pane, and the DMA outputs are visible in the viewing pane (tab Acquisition Channel):</p> <p></p> <p>For each process defined in the applet, an according acquisition process with camera IN ports (Cam 0, Cam 1, \u2026) and DMA OUT ports (DMA 0, DMA 1, \u2026) is displayed.</p> <p></p> <p>The tooltip of a DMA line (left-hand panel) informs you about the most important applet features and settings:</p> <p></p> <p>To connect another camera to a given applet process, click the Edit button in the Cam line and select the camera you want to connect. After this, the camera will show in the Cam line of the process and disappear from the Cam line of the process it was connected to before.</p> </li> <li> <p>Make sure your cameras are connected and detected. A detected camera (image source) is marked green:</p> <p></p> </li> <li> <p>If no camera is detected, deactivate the Windows Fast Startup option as described by www.windowscentral.com.</p> <p>Info</p> <p>Instead of a camera, you can use the Camera Simulator as image source if you have no camera at hand. To do so:</p> <ol> <li>Click on the DMA line to configure the input source for a process (acquisition channel).</li> <li>Below, in the Parameter Selection pane, open the options for parameter Camera Simulator. Go to Image Source and from the value list, select Generator.</li> <li>The Cam line of the process should display a green disk now and display the information that an image generator is connected to the input of the acquisition channel.</li> </ol> </li> <li> <p>Click on the DMA line of the process you want to start. The corresponding DMA output display pane (tab Acquisition Channel) becomes active:</p> <p></p> </li> <li> <p>Click the Grab button to start acquisition.If your system is correctly installed, the grabbed images are displayed in the corresponding DMA output display pane:</p> <p></p> </li> <li> <p>Use the Stop button to stop acquisition.</p> </li> <li> <p>If necessary, you can configure the applet and the camera for the test. To do so, click on the DMA line. Set the applet parameters in the pane below:</p> <p></p> <p>Double-click or right-click on a parameter/value to get the list of available values or an input field.</p> </li> <li> <p>To configure the camera parameters for a first system test, click on the Cam line. Set the camera parameters in the pane below:</p> <p></p> <p>To see all available parameters, set Visibility to Guru.</p> <p>Alternatively, you can configure the camera settings as described in Configuring a Camera.</p> </li> </ol>"},{"location":"installing-a-trigger-extension-board.html","title":"Installing a Trigger Extension Board","text":"<p>This topic tells you how to install a trigger extension board for Basler frame grabbers.</p>"},{"location":"installing-a-trigger-extension-board.html#prerequisites","title":"Prerequisites","text":"<p>You can only install one of the following trigger extension boards:</p> <ul> <li>Opto-Coupled Trigger 5</li> <li>TTL Trigger</li> </ul> <p>Both boards must be purchased separately.</p> <p>Info for Opto-Coupled Trigger 5</p> <p>Before installation, check whether you'll be able to access the DIP switches on the board after the board has been installed. If not, Basler recommends setting the DIP switches before installing the board into the host computer.</p> <p>For more information about the DIP switches, see Configuring the Physical Interface.</p> <p>Info</p> <p>Make sure there's an adequate ventilation system within your computer, especially in the following cases:</p> <ul> <li>There is little space between boards in a multi-board installation.</li> <li>A board is installed close to a graphics card.</li> </ul> <p>Basler recommends leaving enough free space between boards.</p> <p>You need the following components:</p> <ul> <li>microEnable frame grabber</li> <li>Trigger extension board</li> <li>34-pin flat cable</li> </ul>"},{"location":"installing-a-trigger-extension-board.html#installing-the-board","title":"Installing the Board","text":"<p>To install the trigger extension board:</p> <ol> <li>Shut down the host computer.</li> <li>Disconnect the host computer from power.</li> <li> <p>Insert the trigger board into an empty slot on the slot bracket of the host computer.</p> <p> </p> </li> <li> <p>Attach the trigger board to the computer case with screws.</p> </li> <li> <p>Connect the trigger board with the GPIO socket of your microEnable frame grabber using the 34-pin flat cable.</p> <p></p> </li> <li> <p>Reboot your computer.</p> </li> </ol> <p>Now, the trigger board is ready for use.</p> <p>Info</p> <p>For information about using multiple microEnable frame grabbers with one trigger board or vice versa, see Using Multiple Boards.</p>"},{"location":"installing-pylon-and-the-fgsdk-in-parallel.html","title":"Installing pylon and the Framegrabber SDK in Parallel","text":"<p>Some use-cases require the installation of both pylon and the Framegrabber SDK.</p> <p>This topic describes how pylon and the Framegrabber SDK are linked and can be used in parallel in different scenarios.</p>"},{"location":"installing-pylon-and-the-fgsdk-in-parallel.html#support-for-coaxpress-and-visualapplets-in-pylon","title":"Support for CoaXPress and VisualApplets in pylon","text":"<p>When installing the support for CoaXPress in pylon, the pylon installer copies a small subset of the Framegrabber SDK to the <code>&lt;pylon-dir&gt;/Runtime/x64/producerCXP</code> subfolder (and the 32-bit counterpart). This subset contains only the files necessary to use the GenTL producer of the Framegrabber SDK and to support the frame grabbers of the CXP-12 acquisition cards (CXP-12 Interface Card, imaWorx CXP-12 Quad, imaFlex CXP-12 Quad and Penta). Many of the libraries you find in the <code>bin</code> folder of a full Framegrabber SDK installation is used by the pylon installation.</p> <p>For pylon to find and use the GenTL producer, the environment variable <code>GENICAM_GENTL64_PATH</code> (or <code>GENICAM_GENTL32_PATH</code> for 32-bit applications) must be set. Therefore, when you install pylon with support for CoaXPress, pylon also sets the environment variable <code>GENICAM_GENTL64_PATH</code> to <code>&lt;pylon-dir&gt;/Runtime/x64/producerCXP/bin</code>.</p> <p>The support for the Basler frame grabbers in pylon is limited and provides only the features provided by the acquisition applets.</p> <p>If you want to use custom applets designed with Visual Applets in pylon, the recommended way is to install pylon without support for CoaXPress and additionally install the version of the Framegrabber SDK that supports the frame grabber you are using. The installer for the Framegrabber SDK will modify the variable <code>GENICAM_GENTL64_PATH</code> and set it to <code>&lt;fgsdk-dir&gt;/bin</code>. If pylon is already installed with support for CoaXPress, make sure that <code>GENICAM_GENTL64_PATH</code> is set to <code>&lt;fgsdk-dir&gt;/bin</code>, and not to <code>&lt;pylon-dir&gt;/Runtime/x64/producerCXP/bin</code>. This way, pylon finds and uses the GenTL producer that is delivered with the Framegrabber SDK to support CoaXPress.</p> <p>See Using the GenTL Interface for general information about the GenTL Interface. The sections VisualApplets Design Considerations for GenTL and Using Applets Designed with VisualApplets in GenTL contain important information for VisualApplets users.</p>"},{"location":"installing-pylon-and-the-fgsdk-in-parallel.html#support-for-basler-cameralink-cameras","title":"Support for Basler CameraLink Cameras","text":"<p>When using both Basler CameraLink cameras and frame grabbers, pylon works as a configuration tool for the camera and the Framegrabber SDK is used for image acquisition. The link between pylon and the Framegrabber SDK is the CameraLink Serial library <code>clsersis</code>.</p> <p>While there are no conflicts between pylon and the Framergabber SDK in this scenario, there are various known issues in both products which can complicate things. Basler therefore recommends to install pylon version 7.5 and the Framegrabber SDK version 5.11.2 or newer. This combination of versions has been tested and verified.</p>"},{"location":"installing-the-basler-clcomdriver-under-windows.html","title":"Installing the Basler CLComDriver Under Windows","text":"<p>The CLComDriver is a driver for Camera Link (CL) cameras. It's only relevant for you, if you use an mE5 Camera Link frame grabber and your camera doesn't call clsersis.dll or clserall.dll by itself. The CLComDriver is only available for Windows systems and is delivered and installed with the Framegrabber SDK.</p> <p>Info</p> <p>Make sure to remove or shut down any old versions of CLSerCOMWrapper or CLSerCOMWrapper2 before continuing. This CLComDriver version uses a new driver and isn't compatible with any previous version.</p> <p>To run the Basler CLComDriver, run the application ClComConfigurator.exe, which you find in the ClCom folder of your Framegrabber SDK installation.</p> <p></p> <p>Info</p> <p>To run the ClComConfigurator.exe, you need administrator rights.</p> <p>Once the application is started, a window showing installed drivers opens up. On the first launch, the list is empty.</p> <p></p> <p>To add ports, select Install COM driver or Install COM driver(s) for all Ports from the COM menu. Adding ports can take a few seconds.</p> <p></p> <p>Once a driver is installed for a port, you can re-assign the port to any CLSer port available in the system.</p> <p></p> <p>In the screenshot above, the second port on board 0 isn't available, because a single medium or full applet is used. Both ports are only available when using dual base applets on the frame grabber. This behavior is intended. If you only use single medium or full applets, you can remove the additional ports manually.</p> <p>The drivers are then visible in the Device Manager in the Ports (COM &amp; LPT) section:</p> <p></p> <p>To configure the port settings, double-click the device in the Device Manager.</p> <p></p> <p>You can only change the assigned COM port. To change the port settings, click the Advanced\u2026 button and change the port settings in the Advanced Settings dialog.</p> <p></p>"},{"location":"installing-the-basler-clcomdriver-under-windows.html#known-issues","title":"Known Issues","text":"<p>There are some known issues with CLComDriver, see Known Issues.</p>"},{"location":"installing-the-framegrabber-sdk.html","title":"Installing the Framegrabber SDK","text":"<p>The Framegrabber SDK includes a runtime environment and the applets of your frame grabber.</p> <p>If you want to operate only Basler cameras with your frame grabber, you can also use the pylon Software Suite.</p>"},{"location":"installing-the-framegrabber-sdk.html#installing-the-framegrabber-sdk-under-windows","title":"Installing the Framegrabber SDK under Windows","text":"<p>Info</p> <p>Basler recommends uninstalling all Framegrabber SDK installations on your computer before you start installing the current version.</p> <p>Prerequisites</p> <p>To run the Framegrabber SDK setup, you need the following:</p> <ul> <li>Internet connection</li> <li>Administrator rights on your computer</li> </ul> <p>To install the Framegrabber SDK under Windows:</p> <ol> <li> <p>Download the Framegrabber SDK setup from the Downloads Software section of the Basler website.</p> <ol> <li>If you have no restrictions on the size of the download package, use the standard setup Complete Installation for Windows 64bit (ver 5.x.x). This complete setup contains the Framegrabber SDK as well as the free applet sets for your frame grabber.</li> <li>If you prefer small download packages, select Setup Framegrabber SDK 5 for Windows 64bit (ver 5.x.x), which includes the Framegrabber SDK only. You can install the applet set for your frame grabber at a later stage of the installation process.</li> </ol> </li> <li> <p>Start the Framegrabber SDK setup by double-clicking the file name.</p> </li> <li>Select your preferred language for the setup dialogs.</li> <li> <p>The Checking Installed Versions dialog opens. It shows all existing installations of the Framegrabber SDK on your computer, as well as the active installation:</p> <p></p> <p>The active installation is the Framegrabber SDK installation you last installed on your computer. The environment variable %BASLER_FG_SDK_DIR% points to this installation. This isn't necessarily the latest version of the software. After finishing the installation process, the environment variable points to the new installation.</p> </li> <li> <p>The License Agreement dialog opens.</p> <p></p> <p>In this dialog, you must accept the legal terms and conditions. If you are unsure, click Decline.</p> <p>Accepting allows you to make use of the Update feature, which allows you to check for new Framegrabber SDK versions in microDiagnostics.</p> <p>If you click Accept and Next, a download of two OpenSSL libraries starts that are used to open a SSL/TLS secured connection to Basler's server.<sup>a</sup></p> </li> <li> <p>The Select Destination Location dialog opens.</p> <p></p> <p>Select the installation directory and click Next.</p> <p>Access Rights Required</p> <p>Make sure you choose an installation directory to which you have full write access rights, even after the installation process is finished.</p> </li> <li> <p>The Select Components dialog opens. Select the installation mode you want to use. Full Installation is the default mode.</p> <p></p> <ul> <li>In Full Installation mode, all components are selected by default. When you clear one of the components, the setup switches to Custom Installation mode.</li> <li>In Custom Installation mode, all components are selected by default. To save disk space, you can clear the components you don't need.   If you want to configure your cameras via the Basler GenICam interface, make sure you select Platforms/ GenICam support.</li> <li>In Compact Installation mode, all components are cleared by default. You can freely select which components you want to install. Depending on your selection, the installed Framegrabber SDK may not be functional. When you select one of the components, the setup switches to Custom Installation mode.</li> </ul> <p>Click Next.</p> </li> <li> <p>The Select Start Menu Folder dialog opens.</p> <p></p> <p>Select a directory for the tool shortcuts and click Next.</p> </li> <li> <p>The Select Additional Tasks dialog opens.</p> <p></p> <p>Select the additional tasks you want to have carried out during installation and click Next.</p> </li> <li> <p>The Ready to Install dialog displays your installation configuration and all components you have selected for installation.</p> <p></p> <p>If you are ready to install the Framegrabber SDK, click Install.</p> </li> <li> <p>The Installing dialog opens. The Framegrabber SDK, the drivers, and all related software tools are installed on your system.</p> <p></p> <p>If you are asked for driver installations, Basler recommends to accept and install the drivers for your hardware.</p> </li> <li> <p>The Completing the Basler Framegrabber SDK Setup Wizard dialog opens.</p> <p></p> <p>You must restart your computer before you can use the Framegrabber SDK.</p> </li> </ol> <p>After installing the Framegrabber SDK, frame grabbers are recognized in the Windows Device Manager under Multifunction adapters with their full device name.</p> <p></p> <p>For imaWorx CXP-Quad only</p> <p>If you selected a Framegrabber SDK standalone setup, you should install the applets after installing the Framegrabber SDK.</p> <p>You can also install a newer applet set version containing enhanced or new applets and use it with your existing Framegrabber SDK installation.</p> <p>Download the updated applet setup from the Downloads Software section on the Basler website.</p>"},{"location":"installing-the-framegrabber-sdk.html#silent-installation-under-windows","title":"Silent Installation under Windows","text":"<p>The Framegrabber SDK setup supports silent installation. The setup program accepts optional command line parameters. These can be useful for system administrators or other programs calling the setup program.</p>"},{"location":"installing-the-framegrabber-sdk.html#setup-command-line-parameters","title":"Setup Command Line Parameters","text":"<p>/SILENT, /VERYSILENT</p> <p>Instructs the setup to be silent or very silent.</p> <ul> <li>Silent setup: The wizard and the background window aren't displayed, but the installation progress window is visible on screen.</li> <li>Very silent setup: The wizard and the background window aren't displayed. The installation progress window also isn't displayed.</li> </ul> <p>Other parts of the setup aren't changed, e.g., error messages during installation are displayed, as well as the start screen. You can disable the start screen using <code>DisableStartupPrompt</code> or the <code>/SP-</code> command line option.</p> <p>If a restart is necessary and the <code>/NORESTART</code> command (see below) isn't used:</p> <ul> <li>Silent setup: A Reboot now? message box is displayed.</li> <li>Very silent setup: The system reboots without asking.</li> </ul> <p>/SUPPRESSMSGBOXES</p> <p>Suppresses message boxes. This command line parameter has only an effect when combined with <code>/SILENT</code> or <code>/VERYSILENT</code>.</p> <p>The following defaults are used:</p> <ul> <li>'Keep newer file?' Yes</li> <li>'File exists, confirm overwrite.' No</li> <li>Abort/Retry: Abort</li> <li>Retry/Cancel: Cancel</li> <li>DiskSpaceWarning / DirExists/ DirDoesntExist/ NoUninstallWarning / ExitSetupMessage / ConfirmUninstall: Yes (=continue)</li> <li>FinishedRestartMessage / UninstalledAndNeedsRestart: Yes (=restart)</li> </ul> <p>The following message boxes aren't suppressible:</p> <ul> <li>\"About Setup\" message box</li> <li>\"Exit Setup?\" message box</li> <li>\"FileNotInDir2\" message box, which is displayed when setup requires a new disk to be inserted and the disk was not found.</li> <li>Any (error) message box displayed before setup (or uninstall) that could read the command line parameters.</li> <li>Any message box displayed by the MsgBox support function.</li> </ul> <p>/LOG=\"filename\"</p> <p>Same as /LOG, except that this parameter allows you to specify a fixed path or filename to use for the log file. If a file with the specified name already exists, it will be overwritten. If the file can't be created, setup will abort with an error message.</p> <p>/NORESTART</p> <p>Instructs setup not to reboot even if a reboot is necessary.</p> <p>/DIR=\"x:\\dirname\"</p> <p>Overrides the default directory name displayed on the Select Destination Location wizard page. A fully qualified pathname must be specified.</p> <p>/GROUP=\"folder name\"</p> <p>Overrides the default directory name displayed on the Select Start Menu Folder wizard page. If the DisableProgramGroupPage directive was set to \"yes\", this command line parameter is ignored.</p> <p>/NOICONS</p> <p>Instructs setup to initially check the Don't create a Start Menu Folder check box on the Select Start Menu Folder wizard page.</p> <p>/COMPONENTS=\"comma separated list of component names\"</p> <p>Overrides the default component settings. Using this command line parameter causes the setup to automatically select a custom type. If no custom type is defined, this parameter is ignored.</p> <p>Only the specified components will be selected. The rest will be cleared. If a component name is prefixed with a \"*\" character, any child components will be selected as well, except for those that include the <code>dontinheritcheck</code> flag. If a component name is prefixed with a \"!\" character, the component will be cleared.</p> <p>This parameter doesn't change the state of components that include the <code>fixed</code> flag.</p> <p>Usage:</p> <p>&lt;BASLER_INSTALLER_EXE.exe&gt;/Components = \"&lt;component1&gt;,&lt;component2&gt;\"</p> <p>Available components:</p> Component Description core Install core components (required) tools_cli Install command line tools tools_gui Install GUI tools doc Install documentation dev\\core Install libs and header files dev\\examples Install SDK examples dev\\examples_source Install the source code of the examples dev\\examples_bin Install example binaries dev\\cmake Install cmake files acq_applets Install AcquisitionApplets for microEnable frame grabbers acq_applets\\me5maacl Install frame-grabber specific AcquisitionApplets for mE5 marathon ACL acq_applets\\me5mavcl Install frame-grabber specific AcquisitionApplets for mE5 marathon VCL acq_applets\\me5maacxqp Install frame-grabber specific AcquisitionApplets for mE5 marathon ACX QP acq_applets\\iwcxp12q Install frame-grabber specific AcquisitionApplets for mE6 imaWorx CXP-Quad UpdateEnvironment Update of the environment variables CompCLStandardVersion_2 Install CLser as defined in Camera Link 2.0 Com_0_Com Install virtual null modem bin_libs Install libs into the system directory redist_package Install redistributable packages <p>Notes:</p> <ul> <li>Multiple components are applied by a comma separated list.</li> <li>The list may not contain any blanks.</li> </ul> <p>/TASKS=\"comma separated list of task names\"</p> <p>Specifies a list of tasks that should be initially selected.</p> <p>Only the specified tasks will be selected. The rest will be cleared. Use the <code>/MERGETASKS</code> parameter instead if you want to keep the default set of tasks and only select some of them.</p> <p>If a task name is prefixed with a \"*\" character, any child tasks will be selected as well, except for those that include the <code>dontinheritcheck</code> flag. If a task name is prefixed with a \"!\" character, the task will be cleared.</p> <p>Usage:</p> <p>&lt;BASLER_INSTALLER_EXE.exe&gt;/Tasks = \"&lt;task1&gt;,&lt;task2&gt;\"</p> <p>Available tasks:</p> Task Description taskDesktopicon installs a desktop icon taskDrvInstall64 update of the device drivers <p>Example for a silent installation:</p> <pre><code>FramegrabberSDK_Setup_v5.x_Win64.exe\n\n/components= core,tools_cli,acq_applets\\iwcxp12q\ncl /silent\n</code></pre>"},{"location":"installing-the-framegrabber-sdk.html#installing-the-framegrabber-sdk-under-linux","title":"Installing the Framegrabber SDK under Linux","text":"<p>The Framegrabber SDK needs to be installed on the host computer to run your frame grabber.</p> <p>Info</p> <p>Basler recommends to uninstall all Framegrabber SDK installations on your computer before you start installing the current version.</p> <p>To install the Framegrabber SDK, the following steps are required:</p> <ul> <li>Install the device driver for your frame grabber (Installing the Driver)</li> <li>Install the software components and documentation (Installing the Software Components under Linux)</li> <li>Adapt the system environment (Adapting the Environment)</li> </ul> <p>Info</p> <p>The Framegrabber SDK environment is designed for machine vision applications with particular focus on durable systems.</p> <p>Ubuntu with LTS support and Red Hat Enterprise Linux offer a longer life cycle and a longer maintenance period than other Linux distributions. The Framegrabber SDK doesn't use a distribution-dependent implementation and should work on other distributions as well. Choose the distribution that is best suited for your application.</p>"},{"location":"installing-the-framegrabber-sdk.html#requirements","title":"Requirements","text":"<p>To install and use the Framegrabber SDK, you need the following components:</p> <ul> <li>Kernel version: 5.0 or higher</li> <li>Distributions: Ubuntu LTS 22.04 (min. 18.04, max. 22.04)</li> <li>glibc2.0</li> <li>zlib version: 1.2.3 or higher</li> <li>libtiff version: version 4.0.9 or higher</li> <li>C-Compiler: tested with gcc 8 or higher</li> <li>dkms Linux package</li> </ul> <p>Info</p> <p>Ubuntu LTS 22.04 is the Linux distribution and version supported by the Framegrabber SDK version 5.10 or higher. All other Linux distributions may require additional configuration work by the user and can be supported by Basler Support only to a limited extent.</p>"},{"location":"installing-the-framegrabber-sdk.html#further-prerequisites","title":"Further Prerequisites","text":"<p>Root User Access Rights: For installing the Framegrabber SDK, you need the according access rights on the system. Therefore, you must be able to either use sudo or log in as root for certain steps of the installation process.</p> <p>Frame Grabber Hardware: To install the Framegrabber SDK components, you don't need to install a Basler frame grabber or interface card. Nevertheless, available hardware makes it a lot easier to verify if an installation has been successful.</p>"},{"location":"installing-the-framegrabber-sdk.html#known-issues","title":"Known Issues","text":"<p>Compatibility notice for Linux kernels 4.5 or newer:</p> <p>The Linux kernel starting with version 4.5 allows a stricter management of PCI resources via setting CONFIG_IO_STRICT_DEVMEM. The current Framegrabber SDK will not work when this setting is enabled. This is a known issue on some Linux distributions. To work around this issue, boot the Linux kernel with the <code>iomem=relaxed</code> option, or recompile the kernel with <code>CONFIG_IO_STRICT_DEVMEM=n</code>.</p> <p>Compatibility notice for UEFI Secure Boot:</p> <p>If you install Linux on an UEFI machine using the Secure Boot option enabled in the UEFI settings, drivers might need to be signed. Currently, the Framegrabber SDK's Linux driver doesn't support signing during the build process. Signing requires for the user to create a certificate, sign the driver using the certificate and install the certificate into the UEFI certificate store. There are several How-Tos that can be found online if you want to sign the driver yourself. The easiest workaround, however, is to disable the UEFI Secure Boot feature in your mainboard settings.</p> <p>Notice on install-time error messages:</p> <p>When you install the driver on modern Linux distributions, you may encounter error messages referring to driver signing. You can safely ignore those error messages if the UEFI Secure Boot feature is disabled in your mainboard settings.</p>"},{"location":"installing-the-framegrabber-sdk.html#installation-components","title":"Installation Components","text":"<p>The installation of the Framegrabber SDK consists of three components:</p> <ul> <li>Driver package</li> <li>Software components and documentation package</li> <li>Installation script</li> </ul> <p>Driver package: The driver is distributed as source code and has to be compiled and installed before usage. The file name of the device driver package is menable_linuxdrv_src_x.x.x.tar.bz2.</p> <p>The driver package is part of the software components and documentation package (see below). Alternatively, you can download it from the Basler website (search for \"Setup Drivers for Linux 64bit\").</p> <p>Software components and documentation package: The package contains all software components and the documentation. The components come as ready-to-use binary files. You can use the installation script to extract and copy the files to their final destinations within the file system.</p> <p>The file name of the software and documentation package is: basler-fgsdk5-x.x.x-linux-amd64.tar.bz2.</p> <p>Amongst others, the following software components are included:</p> <ul> <li>Framegrabber API libraries as library (*.so)</li> <li>Applets (*.so)</li> <li>Header files and linker libraries (.h and .a) of the Framegrabber API</li> <li>Tools (command line and GUI tools for support, diagnosis and parametrization)</li> <li>Firmware files for the individual frame grabber types and models (*.hap)</li> <li>Documentation</li> </ul> <p>Installation script: To facilitate the installation of the software components, a shell script is delivered which copies the software components to the installation folder and makes entries in the system environment (see below for details). The file name of the installation script is: basler-fgsdk5-5.x.x-linux-amd64-setup.sh.</p>"},{"location":"installing-the-framegrabber-sdk.html#installing-the-driver-for-frame-grabbers","title":"Installing the Driver for Frame Grabbers","text":"<p>Before using a frame grabber, you need to install the driver for frame grabbers. To install the driver, the following steps are required:</p> <ol> <li>Extract the driver source code files (the drivers are distributed as source code in a *.tar.bz2 archive)</li> <li>Compile and link the driver sources</li> <li>Load the driver</li> <li>Set the access rights</li> </ol> <p>On many Debian-based Linux distributions (e.g. Ubuntu), you can skip these steps and use the Debian package to install the driver instead:</p> <ol> <li> <p>Double-click the driver, which is located at /basler-fgsdk&lt;version_number&gt;-linux-amd64/driver/menable-dkms_*.deb. or use the following command:</p> <p><code>sudo apt-get install /basler-fgsdk5-5.10.0.75002-linux-amd64/driver/menable-dkms_*.deb</code></p> </li> <li> <p>Reboot your system to load the driver.</p> </li> </ol> <p>Info</p> <p>In addition to the following instructions, you may also refer to the INSTALL file included in the *.tar.bz2 archive. It contains a detailed description of the driver installing procedure, and tips for troubleshooting.</p> <p>If you encounter problems during driver installation, read the troubleshooting tips in the INSTALL file.</p> <p>Info</p> <p>During installation, error messages might occur that refer to driver signing starting with \"SSL error\" or \"sign-file\". You can ignore these messages, if the UEFI Secure Boot feature is disabled in your mainboard settings.</p>"},{"location":"installing-the-framegrabber-sdk.html#extracting-the-driver-sources","title":"Extracting the Driver Sources","text":"<p>To extract the driver source files:</p> <ol> <li>Open a command line.</li> <li> <p>Change to the directory where you want to extract the sources to.</p> <p>Info</p> <p>Make sure the path to the directory you want to use for compilation of the source files contains no spaces. The kernel build scripts accept no spaces in a path.</p> </li> <li> <p>Start extracting the driver sources by entering the tar xjvf menable_linuxdrv_src_5.0.0.tar.bz2 command.</p> </li> </ol>"},{"location":"installing-the-framegrabber-sdk.html#compiling-and-linking-the-driver-sources","title":"Compiling and Linking the Driver Sources","text":"<p>To compile and link the driver:</p> <ol> <li>Open a command line.</li> <li>Change to the directory where you unpacked the driver sources.</li> <li> <p>Enter the following commands:</p> <p><code>cd linux</code></p> <p><code>make &amp;&amp; sudo make install</code></p> </li> <li> <p>Provide your password when asked.</p> </li> </ol> <p>All necessary files are built and installed.</p>"},{"location":"installing-the-framegrabber-sdk.html#loading-the-driver","title":"Loading the Driver","text":"<p>To load the driver, enter command <code>sudo modprobe menable</code>.</p> <p>If you have a frame grabber plugged into your system, you can check if the driver is loaded and fully functional by entering <code>dmesg | grep menable</code>.</p>"},{"location":"installing-the-framegrabber-sdk.html#setting-the-access-rights","title":"Setting the Access Rights","text":"<p>After the driver has been loaded, the frame grabbers can only be accessed by users that have administrative access rights.</p> <p>Info</p> <p>Basler recommends to assign all users you want to be able to access the driver to the group \"video\".</p> <p>To assign users to the group \"video\", enter the <code>sudo usermod -aG video &lt;username&gt;</code> command. Replace &lt;username&gt; with the name of the user.</p> <p>After a reboot of the system, the changes in group membership are active. The user is now able to fully use the frame grabbers.</p>"},{"location":"installing-the-framegrabber-sdk.html#driver-entries","title":"Driver Entries","text":"<p>Entries by the driver are written into the file /etc/udev/rules.d/10-siso.rules.</p>"},{"location":"installing-the-framegrabber-sdk.html#additional-helpful-commands-for-setting-up-the-driver","title":"Additional Helpful Commands for Setting Up the Driver","text":"Command Result Application Area insmod Show loaded modules and accessing programs Diagnosis modinfomodinfo &lt;modulename&gt; Show information on loaded modules Diagnosis modprobeLoading:modprobe \u2013a &lt;modulename&gt;Unloading:modprobe \u2013r &lt;modulename&gt; Load or unload modules including implicit dependencies Loading and unloading manually depmod Enter information on module dependencies into file /lib/module/&lt;Kernelversion&gt;/modules.dep so that module can be loaded automatically during system start. Important step during installation - Load module automatically during system start:Entry in file /etc/modules Important step during installation"},{"location":"installing-the-framegrabber-sdk.html#installing-the-framegrabber-sdk-under-linux-using-the-installation-script","title":"Installing the Framegrabber SDK under Linux Using the Installation Script","text":"<p>Read here how to install the Framegrabber SDK under Linux using the installation script via shell.</p> <p>Info</p> <p>If you use the shell script as described below, you will have to enter some installation-relevant data during installation. Alternatively, you can use the according call parameters of the installation script.</p> <p>Use the command <code>[prompt] sudo ./[NameOfFramegrabberSDKInstallerFile]-h</code> to get an overview listing all available installation parameters, together with their preset default values. The order in which you enter the parameters is of no relevance.</p> <p>To install the Framegrabber SDK using the shell script in the default location:</p> <ol> <li>Boot the system.</li> <li>Go to the directory that contains the Framegrabber SDK setup. You will have been provided with the following setup file: basler-fgsdk5-5.x.x-linux-amd64-setup.sh</li> <li>Enter <code>[prompt] sudo ./</code></li> </ol> <p>Info</p> <p>Make sure you have full administrative access to the folder where you want to install the Framegrabber SDK in (e.g., as a root user). You must be able to execute files within this installation folder.</p> <p>Make sure the file can be executed. If not, use the <code>chmod</code> command. You can change access permissions so that they correspond to the required setting by using the <code>chmod</code> command: <code>sudo chmod +x [NameOfFramegrabberSDKInstallerFile]</code></p> <p>This will install into the default location <code>/opt/SiliconSoftware</code>.</p> <p>Alternatively, if you want to install the Framegrabber SDK in a different location:</p> <ol> <li> <p>Use the <code>-d</code> command to specify the directory where you want to install the Framegrabber SDK in (without a slash at the end of the path):</p> <p><code>[prompt] ./[NameOfFramegrabberSDKInstallerFile]  -d [PathToTargetDirectory]</code></p> <p>Now, the target directory you specified is displayed.</p> </li> <li> <p>Confirm the target directory by entering yes.</p> <p>Info</p> <p>Alternatively to the last steps, you can also specify an installation directory and directly affirm your choice.</p> <p>To do so, add an <code>-y</code> after the installation command: <code>[prompt] ./[NameOfFramegrabberSDKInstallerFile]  -d [PathToTargetDirectory] \u2013y</code></p> </li> <li> <p>Depending on where you install the Framegrabber SDK, you might have to elevate the access rights by calling the setup with <code>sudo</code>.</p> </li> </ol> <p>Now, the installation process is started:</p> <p>The setup file will be unzipped into the directory you specified.</p> <ul> <li>The extracted files will be modified in so far as absolute paths are being set.</li> <li>After successful installation, the absolute paths are displayed in the shell.</li> </ul> <p>If you want to read the full installation log, go to the installation directory (using the <code>cd</code> command) and enter <code>[prompt] cat install.log.txt</code></p> <p>Now, the content of the installation log file install.log.txt is displayed in the shell.</p>"},{"location":"installing-the-framegrabber-sdk.html#adapting-the-environment","title":"Adapting the Environment","text":"<p>After installing the Framegrabber SDK, the environment variables have to be set. You can either do this automatically, or manually.</p>"},{"location":"installing-the-framegrabber-sdk.html#setting-important-environment-variables-manually","title":"Setting Important Environment Variables Manually","text":"<p>After (re)installation of the Framegrabber SDK, at least one environment variable needs to be updated: <code>BASLER_FG_SDK_DIR</code>.</p> <p>The variable <code>BASLER_FG_SDK_DIR</code> must point to the installation directory where the Framegrabber SDK is installed.</p> <ol> <li> <p>Set <code>BASLER_FG_SDK_DIR</code> by using the following command:</p> <p><code>export BASLER_FG_SDK_DIR=/opt/Basler/FramegrabberSDK5.x.x</code></p> <p>In this example, <code>/opt/Basler/FramegrabberSDK5.x.x</code> is the directory where the Framegrabber SDK is installed. Specify the path to the installation directory according to your file system.</p> </li> <li> <p>Set the GenICam environment for the Framegrabber SDK:</p> <pre><code>export GENICAM_ROOT=$BASLER_FG_SDK_DIR\n\nexport GENICAM_CACHE_V3_1=$BASLER_FG_SDK_DIR/genicam/cache\n\nexport GENICAM_LOG_CONFIG_V3_1=$BASLER_FG_SDK_DIR/genicam/log/config/SisoLogging.properties\n</code></pre> </li> <li> <p>To locate the corresponding modules PATH and LD_LIBRARY_PATH, use the following commands:</p> <pre><code>export GENICAM_ROOT=$BASLER_FG_SDK_DIR\n\nexport LD_LIBRARY_PATH=$BASLER_FG_SDK_DIR/lib:$BASLER_FG_SDK_DIR/bin/impl:$LD_LIBRARY_PATH\n</code></pre> </li> </ol> <p>Info</p> <p>When using Ubuntu 18.04 LTS or later or Red Hat Enterprise Linux 7.1 or later, you can make these entries for the current terminal in file</p> <p>/etc/profile</p> <p>or</p> <p>~/.profile</p>"},{"location":"installing-the-framegrabber-sdk.html#adapting-the-environment-variables-automatically","title":"Adapting the Environment Variables Automatically","text":"<p>After installing the Framegrabber SDK, the environment variables have to be set. This can be done automatically. In this case, you have to start the process.</p> <p>Info</p> <p>Environment variables are only set when they don't exist yet. If the same environment variable already exists, it is extended.</p> <ol> <li>To start the automatic setting of the necessary environment variables, enter <code>[prompt] source &lt;INSTALLDIR&gt;setup-fgsdk-env.sh</code>. Upon pressing ENTER, all environment variables required for using the Framegrabber SDK are set to the appropriate values automatically.</li> <li>You can read which environment variables have been set, and which values are being used. To read the according file, enter <code>[prompt] cat &lt;INSTALLDIR&gt;setup-fgsdk-env.sh</code>. Now, the content of the file is displayed in the shell.</li> </ol>"},{"location":"installing-the-framegrabber-sdk.html#setting-user-access-rights","title":"Setting User Access Rights","text":"<p>Basler recommends to grant full access rights to all users to the directories</p> <p><code>&lt;INSTALLDIR&gt;/bin/log</code> <code>&lt;INSTALLDIR&gt;/genicam/cache</code></p> <p>To grant anyone in the group video write access, call</p> <pre><code>sudo chown -R root:video &lt;INSTALLDIR&gt;/bin/log\n\nsudo chmod -R g+w &lt;INSTALLDIR&gt;/bin/log\n\nsudo chown -R root:video &lt;INSTALLDIR&gt;/genicam/cache\n\nsudo chmod -R g+w &lt;INSTALLDIR&gt;/genicam/cache\n</code></pre> <p>Only when write access is enabled, the Framegrabber SDK can place log files in these directories. Without sufficient access rights, some tools and features may not work properly (e.g., microDiagnostics).</p>"},{"location":"installing-the-framegrabber-sdk.html#placing-the-applet-files","title":"Placing the Applet Files","text":"<p>To use VisualApplets (*.hap) files created by VisualApplets, copy the (*.hap) files into this folder:</p> <p><code>&lt;INSTALLDIR&gt;/Hardware Applets/&lt;Platform&gt;</code></p> <p><code>&lt;PLATFORM&gt;</code> refers here to the hardware platform, e.g, imaWorx CXP-12 Quad or Interface Card IC-2C.</p> <p>VisualApplets (*.hap) files enhance the image processing functionality of the frame grabber.</p>"},{"location":"installing-the-framegrabber-sdk.html#deinstalling-the-framegrabber-sdk-under-linux","title":"Deinstalling the Framegrabber SDK under Linux","text":"<p>To deinstall the Framegrabber SDK under Linux, you have to deinstall the drivers and the software components.</p>"},{"location":"installing-the-framegrabber-sdk.html#deinstalling-the-driver","title":"Deinstalling the Driver","text":"<p>To uninstall the driver manually, enter the following commands in a terminal:</p> <pre><code>sudo rmmod menable.ko\n\nsudo rm /etc/udev/rules.d/10-siso.rules\n\nsudo rm /sbin/men_path_id /sbin/men_uiq\n\nsudo rm `find /etc/modules -name menable.ko`\n</code></pre> <p>Info</p> <p>Note that ` above must be a backtick, usually entered as an accent grave. Alternatively, you can:</p> <ul> <li>Enter the <code>find</code> command separately,</li> <li>Specify the path of <code>menable.ko</code>, and then</li> <li>Call <code>sudo rm</code> using the specified path.</li> </ul>"},{"location":"installing-the-framegrabber-sdk.html#deinstalling-software-components","title":"Deinstalling Software Components","text":"<p>To deinstall software components of the Framegrabber SDK:</p> <ol> <li>Delete all files in the corresponding install directory.</li> <li>Undo all manual changes you made to the system.</li> </ol> <ol> <li> <p>The download of the OpenSSL libraries will be run using a secured connection running standard Windows libraries for network traffic encryption.\u00a0\u21a9</p> </li> </ol>"},{"location":"iolibrt.html","title":"iolibrt","text":"<p>The library iolibrt provides functions to load and store commonly used image formats. On Windows, the library also allows loading a sequence of images from, or saving to an <code>.avi</code> video file.</p> <p>To use the library, the include file <code>sisoIo.h</code> should be added to the source code.</p> <pre><code>#include &lt;sisoIo.h&gt;\n</code></pre> <p>Additionally, <code>iolibrt.lib</code> should be added to your Microsoft Visual Studio Project, or <code>libiolibrt.so</code> to your Linux project. If you use CMake, the package name is SisoIoLib, the libraries are stored in the variable <code>${SISOIOLIB_LIBRARIES}</code> and the the include directory is stored in the variable <code>${SISOIOLIB_INCLUDE_DIR}</code>. See Prerequisites for more details on projects and how to use CMake.</p>"},{"location":"iolibrt.html#error-handling-in-iolibrt","title":"Error Handling in iolibrt","text":"<p>Most functions of the API return an <code>int</code> result code. If the function call was executed successfully, the return value will be 0 or for some functions a value equal or greater than zero. A negative value denotes an error condition in most cases. The error codes are defined in the header files <code>sisoIoFileErrorCodes.h</code> for general errors related to reading and writing files, and <code>sisoIoBmpErrorCodes.h</code>, <code>sisoIoRawErrorCodes.h</code> and <code>sisoIoTiffErrorCodes.h</code> for errors related to the specific file format.</p> <p>The code examples in the rest of this part of the documentation will not include error handling as this is specific to the requirements of the application. As much as is feasible, return codes will be checked however for successful execution of the functions.</p>"},{"location":"iolibrt.html#working-with-image-files","title":"Working with Image Files","text":"<p>The image input/output library supports two standard image file formats: Windows Bitmap (.bmp) and Tagged Image File Format (.tif or .tiff). In addition, a raw data file format (.raw) with a minimal header is supported for data which can't be represented by the standard file formats. The header of the .raw file contains the following information in this order:</p> <ol> <li>4 bytes describing the image width</li> <li>4 bytes describing the image height</li> <li>4 bytes describing the bits per pixel. E.g. 8-bit grey = 8; 14-bit grey = 14; 10-bit rgb = 30</li> <li>4 bytes describing the bytes per pixel; bytes per pixel are rounded up, e.g. 10 bits = 2 bytes</li> <li>The raw data</li> </ol> <p>The functions in this chapter will determine the file format from the file extension of the file name.</p>"},{"location":"iolibrt.html#opening-image-files","title":"Opening Image Files","text":"<pre><code>int IoImageOpen(\n    const char * file,\n    SisoIoImageEngine ** handle);\n\nint IoImageOpenEx(\n    const char * file,\n    SisoIoImageEngine ** handle,\n    int rgbSequence);\n\nint IoFreeImage(\n    SisoIoImageEngine * handle);\n</code></pre> <pre><code>int IoGetWidth(\n    const SisoIoImageEngine * handle);\n\nint IoGetHeight(\n    const SisoIoImageEngine * handle);\n\nint IoGetBitsPerPixel(\n    const SisoIoImageEngine * handle);\n\nint IoGetBitsPerComponent(\n    const SisoIoImageEngine * handle) ;\n\nint IoGetNrOfComponents(\n    const SisoIoImageEngine * handle);\n\nconst void * IoImageGetData(\n    const SisoIoImageEngine * handle);\n</code></pre> <pre><code>size_t IoCalculateBufferSize(\n    int width,\n    int height,\n    int bitsPerPixel);\n</code></pre> <p>To open an image file, the functions <code>IoImageOpen()</code> or <code>IoImageOpenEx()</code> can be called. Both functions expect the file name in the first parameter and a pointer to a variable of type <code>SisoIoImageEngine *</code> which will be used in functions to access the image data. The function <code>IoImageOpenEx()</code> can be called for images with a reversed sequence of red, green and blue data with the parameter <code>rgbSequence</code> set to 1.</p> <p>After an image is no longer needed, the function <code>IoFreeImage()</code> should be called to release the memory for the image data.</p> <p>To get the dimensions and data format of the image data, the functions <code>IoGetWidth()</code>, <code>IoGetHeight()</code>, <code>IoGetBitsPerPixel()</code>, <code>IoGetBitsPerComponent()</code> and <code>IoGetNrOfComponents()</code> can be called.</p> <p>The image data can be accessed by calling the function <code>IoImageGetData()</code> which will return a pointer to the buffer containing the image data. To get the size of the buffer, the function <code>IoCalculateBufferSize()</code> can be used.</p> <p>The image data is usually divided into lines. The height of the image is the number of lines of which the image data is composed. Each line consists of pixels and the width of the image is the number of pixels in a line. Each pixel is represented by one or more color components. Grayscale images usually have a single component per pixel, the gray value. Color images usually contain three components, one value for red, green and blue each. An additional component might be a value for the opacity, or an infra-red or x-ray component. The components usually are encoded using the same number of bits. The number of components and the bits per pixel are referred to as pixel format. (Sometimes, the bits per component are used instead of bits per pixel.)</p> <p>Depending on the pixel format, each line can contain some padding at the end to make sure that the first pixel of each line starts with a defined alignment. The function <code>IoCalculateBufferSize()</code> assumes that lines always start at a byte boundary, so for pixel formats which don't use a multiple of 8 bits per pixel, the end of a line might contain padding bits, and the next line starts at the next byte in the buffer.</p>"},{"location":"iolibrt.html#saving-image-files","title":"Saving Image Files","text":"<pre><code>int IoSaveImageExt(\n    const char * file,\n    void * data,\n    int width,\n    int height,\n    int bitsPerPixel);\n</code></pre> <p>To save image data to a file, the function <code>IoSaveImageExt()</code> can be called. The function expects the file name in the first parameter and a pointer to the buffer which contains the image data in the second. The three remaining parameters pass the image dimensions and the bits per pixel to the function.</p> <p>You can save the following file formats: .tif,.tiff, .bmp, .raw. The file formats are detected automatically from the <code>const char * file</code>.</p>"},{"location":"iolibrt.html#working-with-image-sequence-files","title":"Working with Image Sequence Files","text":"<p>The image input/output library provides support for a simple image sequence file format. Image sequence files contain a number of images of the same dimensions and pixel format. Each image is assigned a a sequence index and a frame number. The sequence index corresponds to the position of the image within the file, sequence index 0 is the first image in the sequence file, 1 the second, and so on. The frame number is obtained during acquisition, usually starts with 1 and the sequence can contain gaps in the frame numbers when not all consecutive images were written to the sequence.</p> <p>There is no standard file extension defined for image sequence files, recommended choices are <code>.isq</code> or <code>.imageseq</code>.</p>"},{"location":"iolibrt.html#opening-image-sequence-files","title":"Opening Image Sequence Files","text":"<pre><code>int IoOpenSeq(\n    void ** handle,\n    const char * file,\n    int * width,\n    int * height,\n    int * bitsPerPixel,\n    int flags);\n\nint IoCloseSeq(\n    void * handle);\n</code></pre> <pre><code>int IoGetSeqInfo(\n    void * handle,\n    int * nrOfFrames,\n    int * nrOfLostFrames);\n\nint IoReadNextSeqPicture(\n    void * handle,\n    int * frame,\n    void * buffer);\n</code></pre> <p>To open an existing image sequence file for reading images from, the function <code>IoOpenSeq()</code> can be called. The function expects a pointer to a variable of type <code>void *</code> in the parameter <code>handle</code> which will be used in functions to access the data in the image sequence file, the file name in the parameter <code>file</code> and three pointers to variables for the image dimensions in the parameters <code>width</code> and <code>height</code> and the number of bits per pixel in the parameter <code>bitsPerPixel</code>. The parameter <code>flags</code> is reserved for future extensions and should always be set to 0.</p> <p>When the application is finished accessing the data in an image sequence file, the function <code>IoCloseSeq()</code> should be called.</p> <p>To read the next image from the image sequence file, the function <code>IoReadNextSeqPicture()</code> can be called. The function expects a handle from a previous call to <code>IoOpenSeq()</code> in the parameter <code>handle</code>, a pointer to a variable of type <code>int</code> to store the frame number of the image in the paramater <code>frame</code> and a pointer to the buffer to store the image data in the parameter <code>buffer</code>. The buffer must be large enough to store the image data according to the image diemnsions and pixel format and can be calculated for example by a call to <code>IoCalculateBufferSize()</code>.</p> <p>The function <code>IoGetSeqInfo()</code> can be called to request information about the number of images stored in the image sequence files and the sum of gaps between frame numbers in the sequence.</p>"},{"location":"iolibrt.html#writing-image-sequence-files","title":"Writing Image Sequence Files","text":"<pre><code>int IoCreateSeq(\n    void ** handle,\n    const char * file,\n    int width,\n    int height,\n    int bitsPerPixel,\n    int flags);\n\nint IoCloseSeq(\n    void * handle);\n\nint IoWriteNextSeqPicture(\n    void * handle,\n    int frame,\n    const void * buffer);\n</code></pre> <p>To create a new image sequence file for writing images to, the function <code>IoCreateSeq()</code> can be called. The function expects a pointer to a variable of type <code>void *</code> in the parameter <code>handle</code> which will be used in functions to access the data in the image sequence file, the file name in the parameter <code>file</code>, the image dimensions in the parameters <code>width</code> and <code>height</code> and the number of bits per pixel in the parameter <code>bitsPerPixel</code>. The parameter <code>flags</code> is reserved for future extensions and should always be set to 0.</p> <p>When the application is finished accessing the data in an image sequence file, the function <code>IoCloseSeq()</code> should be called.</p> <p>To append the next image to the image sequence file, the function <code>IoWriteNextSeqPicture()</code> can be called. The function expects a handle from a previous call to <code>IoCreateSeq()</code> in the parameter <code>handle</code>, the frame number of the image in the paramater <code>frame</code> and a pointer to the buffer which contains the image data in to in the parameter <code>buffer</code>. The buffer must be large enough to provide the image data according to the image diemnsions and pixel format and can be calculated for example by a call to <code>IoCalculateBufferSize()</code>.</p>"},{"location":"iolibrt.html#working-with-video-files-windows-only","title":"Working with Video Files (Windows Only)","text":"<p>When using the Framegrabber API for the Microsoft Windows Operating System, the image input/output library provides limited support for the Audio Video Interleave (.avi) file format.</p>"},{"location":"iolibrt.html#opening-video-files","title":"Opening Video Files","text":"<pre><code>int IoOpenAVI(\n    void ** handle,\n    const char * file,\n    int * width,\n    int * height,\n    int * bitDepth);\n\nint IoCloseAVI(\n    void * handle);\n\nint IoReadAVIPicture(\n    void * handle,\n    int index,\n    void * buffer);\n</code></pre> <p>To open an existing video file for reading images from, the function <code>IoOpenAVI()</code> can be called. The function expects a pointer to a variable of type <code>void *</code> in the parameter <code>handle</code> which will be used in functions to access the data in the video file, the file name in the parameter <code>file</code> and three pointers to variables for the image dimensions in the parameters <code>width</code> and <code>height</code> and the number of bits per pixel in the parameter <code>bitsPerPixel</code>.</p> <p>When the application is finished accessing the data in a video file, the function <code>IoCloseAVI()</code> should be called.</p> <p>To read an image from the video file, the function <code>IoReadAVIPicture()</code> can be called. The function expects a handle from a previous call to <code>IoOpenSeq()</code> in the parameter <code>handle</code>, the index of the image to read and a pointer to the buffer to store the image data in the parameter <code>buffer</code>. The buffer must be large enough to store the image data according to the image diemnsions and pixel format and can be calculated for example by a call to <code>IoCalculateBufferSize()</code>.</p>"},{"location":"iolibrt.html#writing-video-files","title":"Writing Video Files","text":"<pre><code>int IoCreateAVIGray(\n    void ** handle,\n    const char * file,\n    int width,\n    int height,\n    double fps);\n\nint IoCreateAVIGrayW(\n    void ** handle,\n    const LPCWSTR file,\n    int width,\n    int height,\n    double fps);\n\nint IoCreateAVIColor(\n    void ** handle,\n    const char * file,\n    int width,\n    int height,\n    double fps);\n\nint IoCreateAVIColorW(\n    void ** handle,\n    const LPCWSTR file,\n    int width,\n    int height,\n    double fps);\n\nint IoCloseAVI(\n    void * handle);\n\nint IoWriteAVIPicture(\n    void * handle,\n    int index,\n    const void * buffer);\n</code></pre> <p>To create a new video file for writing images to, one of the functions <code>IoCreateAVIGray()</code>, <code>IoCreateAVIGrayW()</code>, <code>IoCreateAVIColor()</code> or <code>IoCreateAVIColorW()</code> can be called. The functions expects a pointer to a variable of type <code>void *</code> in the parameter <code>handle</code> which will be used in functions to access the data in the video file, the file name in the parameter <code>file</code>, the image dimensions in the parameters <code>width</code> and <code>height</code> and the number of frames per second in the parameter <code>fps</code>. The pixel format is determined by the variant of the function: <code>IoCreateAVIGray()</code> and <code>IoCreateAVIGrayW()</code> create a video file for 8-bit grayscale image data, and <code>IoCreateAVIColor()</code> and <code>IoCreateAVIColorW()</code> create a file for 24-bit RGB image data. The variants ending in <code>W</code> allow file names using a wide-character string.</p> <p>When the application is finished accessing the data in a video file, the function <code>IoCloseAVI()</code> should be called.</p> <p>To write an image to the video file, the function <code>IoWriteAVIPicture()</code> can be called. The function expects a handle from a previous call to one of the functions for creating a video file in the parameter <code>handle</code>, the index of the image in the video sequence in the paramater <code>index</code> and a pointer to the buffer which contains the image data in to in the parameter <code>buffer</code>. The buffer must be large enough to provide the image data according to the image diemnsions and pixel format and can be calculated for example by a call to <code>IoCalculateBufferSize()</code>.</p>"},{"location":"iolibrt.html#creating-video-files-from-image-sequence-files","title":"Creating Video Files from Image Sequence Files","text":"<pre><code>int IoSeqCreateAvi(\n    void * handle,\n    const char * file,\n    int fromSeqIndex,\n    int toSeqIndex);\n</code></pre> <p>The function <code>IoSeqCreateAvi()</code> can be called to create a video file from an existing image sequence file. The function expects a handle from a previous call to <code>IoOpenSeq()</code> in the parameter <code>handle</code>, the file name of the video file to be created in the parameter <code>file</code> and the first and the last sequence index from the image sequence file to include in the video file in the parameters <code>fromSeqIndex</code> and <code>toSeqIndex</code>. If the value -1 is passed to the parameter <code>toSeqIndex</code>, all images in the image sequence file starting with <code>fromSeqIndex</code> are included in the video file.</p>"},{"location":"known-issues-frame-grabbers.html","title":"Known Issues (Frame Grabbers)","text":"<p>This section provides information about known issues for Basler frame grabbers.</p>"},{"location":"known-issues-frame-grabbers.html#all-components","title":"All Components","text":"Summary Using the Basler CXP-12 Interface Card 1C/2C/4C and imaworx CXP-12 Quad Frame Grabbers with PCIe Lower than Gen 3x8 May Reduce the Camera's Acquisition Frame Rate and Cause Image Loss Description The Basler CXP-12 Interface Card 1C/2C/4C and imaWorx CXP-12 Quad frame grabbers require a host interface with PCIe Gen 3x8 (Direct Memory Access) or better. Using slower host interfaces may reduce the camera's acquisition frame rate and cause image loss. Workaround No workaround is available. Ticket ID \u2013 Summary Camera Does Not Deliver Correct Images Description If a camera with multiple links doesn't comply with the CXP standard regarding the distribution of the image data over the links, no correct images are delivered to the computer. This issue was observed with a JAI SP-12000C-CXP4 camera. Workaround No workaround is available. Ticket ID TFS 211645 Summary Unexpected Behavior of the Camera Simulator Description The usage of the applet's internal camera simulator may show a lower bandwidth than expected. This does mean that certain overflow conditions may occur when the current simulator is used. When a real camera is used, this behavior doesn't show. The issue is only related to the internal camera simulator. Workaround No workaround is available. Ticket ID \u2013 Summary Frame Grabber Do Not Work with Windows Fast Startup Description Under Windows 8 or higher with Fast Startup enabled (also known as Hybrid Boot or Hybrid Shutdown), the frame grabber may no longer work after changing the hardware setup and restarting the system. Workaround A restart (explicit restart, not shutdown) solves these problems. To avoid the problems completely, disable Fast Startup as described by www.windowscentral.com. Ticket ID \u2013 Summary Linux Drivers can't be Signed with a Trusted Basler Certificate Description Using secure boot (UEFI mode) with Linux requires a driver that is signed with a trusted certificate. Since the driver is provided as source code, there is no way to sign it with a trusted Basler certificate. Workaround To work with the driver, secure boot can be disabled. Alternatively, you can sign the driver as described in this Ubuntu blog entry. Ticket ID \u2013"},{"location":"known-issues-frame-grabbers.html#imaworx","title":"imaWorx","text":"Summary LED 12EXT Illuminates Red on Wrong Event Description The LED 12EXT is supposed to illuminate red when imaWorx isn't connected to an external power supply. However, the LED only illuminates red, if the external power connector is connected and falsely reflects the state of 12V_DC_UP instead of 12V_EXT. Workaround No workaround is available. Ticket ID TFS 206709"},{"location":"known-issues-frame-grabbers.html#interface-cards","title":"Interface Cards","text":"Summary Grabbing High Frame Rates Using the Basler CXP-12 Interface Card 1C Isn't Supported Description Grabbing with very high frame rates above 50000 fps using the Basler CXP-12 Interface Card 1C isn't supported. Workaround No workaround is available. Ticket ID \u2013 Summary Changing the Applet with an Interface Card Leads to Incorrect Device List Description During an applet change, the cameras attached to an interface card are still displayed in the devices list even though they are not accessible anymore. An attempt to open a camera in this state leads to an error message. Workaround No workaround is available. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-10-0.html","title":"Known Issues Framegrabber SDK 5.10.0","text":"<p>This section provides information about known issues for the Basler Runtime version 5.10.0.</p>"},{"location":"known-issues-framegrabber-sdk-5-10-0.html#all-components","title":"All Components","text":"Summary mE5 Frame Grabbers Have Boot Partition Set to Partition 0 and Show Wrong Serial Number Description After booting, microEnable 5 frame grabbers always show partition 0 as boot partition even if another partition was defined as boot partition before booting and the boot partition can't be changed. In addition, the serial number isn't displayed correctly. Affected OS Windows Workaround Turn off the Fast Start-Up Feature under Windows. Ticket ID TFS 272272 Summary mE5 CXP Frame Grabbers Only Discover Cameras Connected in Correct Link Order Description microEnable 5 CXP frame grabbers only discover cameras, if they are connected in the correct link order: camera port 0 connected to frame grabber port 0, camera port 1 connected to frame grabber port 1 etc. If the cameras are connected in a different order, they are not discovered by the frame grabber. Affected OS Windows and Linux Workaround Connect the cameras in the correct link order with the frame grabber. Ticket ID TFS 259300 Summary For Windows 32-Bit Installations, the PATH Environment Variable Is Not Set Automatically Description If you install the Framegrabber SDK for a Windows 32-bit, the he windows installer does not set the win32 bin folder in the PATH environment variable. Affected OS Windows Workaround Set the win32 bin folder as PATH environment variable manually. Ticket ID TFS 260409 Summary Camera Doesn't Deliver Correct Images Description If a camera with multiple links doesn't comply with the CXP standard regarding the distribution of the image data over the links, no correct images are delivered to the computer. This issue was observed with a JAI SP-12000C-CXP4 camera. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID TFS 211645 Summary Linux Drivers Can't Be Signed with a Trusted Basler Certificate Description Using secure boot (UEFI mode) with Linux requires a driver that is signed with a trusted certificate. Since the driver is provided as source code, there is no way to sign it with a trusted Basler certificate. Affected OS Linux Workaround To work with the driver, secure boot can be disabled. Alternatively, you can sign the driver as described in this Ubuntu blog entry. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-10-0.html#framegrabber-api","title":"Framegrabber API","text":"Summary Displaying Images with High Frame Rates May Lead to Slow Reactions to User Input Description When using the Framegrabber API library display_lib (only available on Windows), displaying images with high frame rates (about 10.000 frames per second) may lead to slow reactions to user input (e.g. keyboard and mouse) of the host computer. Affected OS Windows Workaround No workaround is available. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-10-0.html#gentl-producer","title":"GenTL Producer","text":"Summary Camera Parameters Changed after Image Acquisition Start Are Not Reflected in the Frame Grabber Description When camera parameters are changed during image acquisition, the change isn't reflected in the frame grabber. This is so, because the GenTL Producer enquires the relevant parameters (width, height, image format, etc.) before starting the acquisition and synchronizes these with the frame grabber. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID TFS 195482 and 225591 Summary The GenTL Device ID Changes when the Applet Is Changed Description According to the GenTL standard, the device ID should remain constant between two sessions. However, the GenTL device ID changes when the applet is changed. Therefore, the device ID that was queried with one applet can be used with a different board and a different applet only, if the applet has the same name as the original one with which the device ID was generated. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-10-0.html#microdisplayx","title":"microDisplayX","text":"Summary On a Clean Linux Installation, microDisplayX Doesn't Start Description On a clean Linux installation, microDisplayX doesn't start. The reason for this issue is that on a clean Linux installation the QT platform plugin <code>xcb</code> is missing. Affected OS Linux Workaround Install the missing plugin with the command <code>sudo apt install libxcb-xinerama0</code>. Ticket ID TFS 259941 Summary On Linux, microDisplayX Might Crash When It Is Being Closed Description On Linux, microDisplayX might crash when it is being closed. This has no further consequences and can be ignored. Affected OS Linux Workaround No workaround is available. Ticket ID TFS 211811"},{"location":"known-issues-framegrabber-sdk-5-11-0.html","title":"Known Issues Framegrabber SDK 5.11.0","text":"<p>This section provides information about known issues for the Basler Runtime version 5.11.0.</p>"},{"location":"known-issues-framegrabber-sdk-5-11-0.html#all-components","title":"All Components","text":"Summary Storing and Loading MCF-Files Results in Double Values Rounded to a Whole Number Description When loading a configuration from an MCF-file, double values with comma delimiter might be rounded to the nearest whole number. This is caused by the current locale setting of the Linux operating system. Rounding doesn't occur if the locale defines a dot as delimiter. Affected OS Linux Workaround Set an appropriate locale, e.g., <code>LC_NUMERIC=\"C\" ./&lt;applicationName&gt;</code>, before you start microDisplay X or microDiagnostics. Ticket ID 265213 Summary mE5 Frame Grabbers Have Boot Partition Set to Partition 0 and Show Wrong Serial Number Description After booting, microEnable 5 frame grabbers always show partition 0 as boot partition, even if another partition was defined as boot partition before booting. Also, the boot partition can't be changed, and the serial number isn't displayed correctly. Affected OS Windows Workaround Turn off the Fast Start-Up Feature under Windows. Ticket ID TFS 272272 Summary Camera Doesn't Deliver Correct Images Description If a camera with multiple links doesn't comply with the CXP standard regarding the distribution of the image data over the links, the camera won't transmit images correctly. This issue was observed with a JAI SP-12000C-CXP4 camera. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID TFS 211645 Summary Linux Drivers Can't Be Signed with a Trusted Basler Certificate Description Using secure boot (UEFI mode) with Linux requires a driver that is signed with a trusted certificate. Since the driver is provided as source code, there is no way to sign it with a trusted Basler certificate. Affected OS Linux Workaround To work with the driver, secure boot can be disabled. Alternatively, you can sign the driver as described in this Ubuntu blog entry. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-0.html#framegrabber-api","title":"Framegrabber API","text":"Summary Displaying Images with High Frame Rates May Lead to Input Lag Description When using the display_lib Framegrabber API library (only available on Windows), displaying images with high frame rates (about 10.000 frames per second) may lead to input lag (e.g., keyboard and mouse lag) on the host computer. Affected OS Windows Workaround No workaround is available. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-0.html#gentl-producer","title":"GenTL Producer","text":"Summary Camera Parameters Changed after Image Acquisition Start Aren't Reflected in the Frame Grabber Description When camera parameters are changed during image acquisition, the change isn't reflected in the frame grabber. This is because the GenTL Producer retrieves the relevant parameters (width, height, image format, etc.) before starting the acquisition and synchronizes these with the frame grabber. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID TFS 195482 and 225591 Summary The GenTL Device ID Changes When the Applet Is Changed Description According to the GenTL standard, the device ID should remain constant between two sessions. However, the GenTL device ID changes when the applet is changed. Therefore, the device ID can only be reused if the applet has the same name as the applet with which the device ID was generated. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-0.html#microdisplayx","title":"microDisplayX","text":"Summary On a Clean Linux Installation, microDisplayX Doesn't Start Description On a clean Linux installation, microDisplayX doesn't start. The reason for this issue is that on a clean Linux installation, the <code>xcb</code> QT platform plugin is missing. Affected OS Linux Workaround Install the missing plugin with the <code>sudo apt install libxcb-xinerama0</code> command. Ticket ID TFS 259941 Summary On Linux, microDisplayX Might Crash When It Is Being Closed Description On Linux, microDisplayX might crash when it is being closed. This has no further consequences and can be ignored. Affected OS Linux Workaround No workaround is available. Ticket ID TFS 211811"},{"location":"known-issues-framegrabber-sdk-5-11-2.html","title":"Known Issues Framegrabber SDK 5.11.2","text":"<p>This section provides information about known issues for the Basler Framegrabber SDK version 5.11.2.</p>"},{"location":"known-issues-framegrabber-sdk-5-11-2.html#all-components","title":"All Components","text":"Summary Storing and Loading MCF-Files Results in Double Values Rounded to a Whole Number Description When loading a configuration from an MCF-file, double values with comma delimiter might be rounded to the nearest whole number. This is caused by the current locale setting of the Linux operating system. Rounding doesn't occur if the locale defines a dot as delimiter. Affected OS Linux Workaround Set an appropriate locale, e.g., <code>LC_NUMERIC=\"C\" ./&lt;applicationName&gt;</code>, before you start microDisplay X or microDiagnostics. Ticket ID 265213 Summary Camera Doesn't Deliver Correct Images Description If a camera with multiple links doesn't comply with the CXP standard regarding the distribution of the image data over the links, the camera won't transmit images correctly. This issue was observed with a JAI SP-12000C-CXP4 camera. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID 211645 Summary Linux Drivers Can't Be Signed with a Trusted Basler Certificate Description Using secure boot (UEFI mode) with Linux requires a driver that is signed with a trusted certificate. Since the driver is provided as source code, there is no way to sign it with a trusted Basler certificate. Affected OS Linux Workaround To work with the driver, secure boot can be disabled. Alternatively, you can sign the driver as described in this Ubuntu blog entry. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-2.html#framegrabber-api","title":"Framegrabber API","text":"Summary Displaying Images with High Frame Rates May Lead to Input Lag Description When using the display_lib Framegrabber API library (only available on Windows), displaying images with high frame rates (about 10.000 frames per second) may lead to input lag (e.g., keyboard and mouse lag) on the host computer. Affected OS Windows Workaround No workaround is available. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-2.html#clcomdriver","title":"CLComDriver","text":"Summary There Are More Drivers Installed Than CLSer Ports in the System Description Sometimes when using Install COM driver(s) for all Ports, more drivers are installed than there are CLSer ports in the system. Affected OS Windows Workaround Select the additional port(s) and remove them using the command Remove selected COM driver. Ticket ID \u2013 Summary With Basler Runtime 5.9.0 or Earlier, the Board Type Isn't Recognized Description With Basler Runtime 5.9.0 or earlier, the board type isn't recognized and ports are only displayed using the CLSer identifier. Affected OS Windows Workaround Update your Basler Runtime/Framegrabber SDK version to 5.10 or higher. Ticket ID \u2013 Summary Port Settings in the Device Manager Don't Reflect Actual Settings Description Port settings in the device manager don't reflect actual settings and changes aren't considered. Affected OS Windows Workaround Use the Windows COM Port API to change port settings. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-2.html#gentl-producer","title":"GenTL Producer","text":"Summary Camera Parameters Changed after Image Acquisition Start Aren't Reflected in the Frame Grabber Description When camera parameters are changed during image acquisition, the change isn't reflected in the frame grabber. This is because the GenTL Producer retrieves the relevant parameters (width, height, image format, etc.) before starting the acquisition and synchronizes these with the frame grabber. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID TFS 195482 and 225591 Summary The GenTL Device ID Changes When the Applet Is Changed Description According to the GenTL standard, the device ID should remain constant between two sessions. However, the GenTL device ID changes when the applet is changed. Therefore, the device ID can only be reused if the applet has the same name as the applet with which the device ID was generated. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-2.html#microdisplayx","title":"microDisplayX","text":"Summary On a Clean Linux Installation, microDisplayX Doesn't Start Description On a clean Linux installation, microDisplayX doesn't start. The reason for this issue is that on a clean Linux installation, the <code>xcb</code> QT platform plugin is missing. Affected OS Linux Workaround Install the missing plugin with the <code>sudo apt install libxcb-xinerama0</code> command. Ticket ID TFS 259941 Summary On Linux, microDisplayX Might Crash When It Is Being Closed Description On Linux, microDisplayX might crash when it is being closed. This has no further consequences and can be ignored. Affected OS Linux Workaround No workaround is available. Ticket ID TFS 211811"},{"location":"known-issues-framegrabber-sdk-5-11-3.html","title":"Known Issues Framegrabber SDK 5.11.3","text":"<p>This section provides information about known issues for the Basler Framegrabber SDK version 5.11.3.</p>"},{"location":"known-issues-framegrabber-sdk-5-11-3.html#all-components","title":"All Components","text":"Summary Storing and Loading MCF-Files Results in Double Values Rounded to a Whole Number Description When loading a configuration from an MCF-file, double values with comma delimiter might be rounded to the nearest whole number. This is caused by the current locale setting of the Linux operating system. Rounding doesn't occur if the locale defines a dot as delimiter. Affected OS Linux Workaround Set an appropriate locale, e.g., <code>LC_NUMERIC=\"C\" ./&lt;applicationName&gt;</code>, before you start microDisplay X or microDiagnostics. Ticket ID 265213 Summary Camera Doesn't Deliver Correct Images Description If a camera with multiple links doesn't comply with the CXP standard regarding the distribution of the image data over the links, the camera won't transmit images correctly. This issue was observed with a JAI SP-12000C-CXP4 camera. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID 211645 Summary Linux Drivers Can't Be Signed with a Trusted Basler Certificate Description Using secure boot (UEFI mode) with Linux requires a driver that is signed with a trusted certificate. Since the driver is provided as source code, there is no way to sign it with a trusted Basler certificate. Affected OS Linux Workaround To work with the driver, secure boot can be disabled. Alternatively, you can sign the driver as described in this Ubuntu blog entry. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-3.html#framegrabber-api","title":"Framegrabber API","text":"Summary Displaying Images with High Frame Rates May Lead to Input Lag Description When using the display_lib Framegrabber API library (only available on Windows), displaying images with high frame rates (about 10.000 frames per second) may lead to input lag (e.g., keyboard and mouse lag) on the host computer. Affected OS Windows Workaround No workaround is available. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-3.html#clcomdriver","title":"CLComDriver","text":"Summary There Are More Drivers Installed Than CLSer Ports in the System Description Sometimes when using Install COM driver(s) for all Ports, more drivers are installed than there are CLSer ports in the system. Affected OS Windows Workaround Select the additional port(s) and remove them using the command Remove selected COM driver. Ticket ID \u2013 Summary With Basler Runtime 5.9.0 or Earlier, the Board Type Isn't Recognized Description With Basler Runtime 5.9.0 or earlier, the board type isn't recognized and ports are only displayed using the CLSer identifier. Affected OS Windows Workaround Update your Basler Runtime/Framegrabber SDK version to 5.10 or higher. Ticket ID \u2013 Summary Port Settings in the Device Manager Don't Reflect Actual Settings Description Port settings in the device manager don't reflect actual settings and changes aren't considered. Affected OS Windows Workaround Use the Windows COM Port API to change port settings. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-3.html#gentl-producer","title":"GenTL Producer","text":"Summary Camera Parameters Changed after Image Acquisition Start Aren't Reflected in the Frame Grabber Description When camera parameters are changed during image acquisition, the change isn't reflected in the frame grabber. This is because the GenTL Producer retrieves the relevant parameters (width, height, image format, etc.) before starting the acquisition and synchronizes these with the frame grabber. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID 195482 and 225591 Summary The GenTL Device ID Changes When the Applet Is Changed Description According to the GenTL standard, the device ID should remain constant between two sessions. However, the GenTL device ID changes when the applet is changed. Therefore, the device ID can only be reused if the applet has the same name as the applet with which the device ID was generated. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-3.html#microdisplayx","title":"microDisplayX","text":"Summary Camera Detection Sometimes Doesn't Work in microDisplayX for VisualApplets Designs That Contain Two Camera Operators Description Camera detection doesn't work in microDisplayX for VisualApplets designs that contain two camera operators of which at least one operator has two channels and the resource indices are assigned in direct ascending order. For example, two camera operators with two channels each, operator A uses ports 0 and 1 and operator B uses ports 2 and 3. Affected OS Windows and Linux Workaround Don't assign the resource indices in direct ascending order. For example, assign the channels of operator A to ports 0 and 2, and the channels of operator B to ports 1 and 3. Ticket ID 314206 Summary microDisplay X Crashes When Loading HAP Files with Complex Designs Description Some very complex VisualApplet designs may lead to crashes during or immediately after loading the applet in microDisplayX. No such crashes have been observed in SDK programs. Affected OS Windows and Linux Workaround Load the applet in microDisplayX again. Loading the applet in microDisplayX usually works after the second or third attempt. Ticket ID 314234 Summary On a Clean Linux Installation, microDisplayX Doesn't Start Description On a clean Linux installation, microDisplayX doesn't start. The reason for this issue is that on a clean Linux installation, the <code>xcb</code> QT platform plugin is missing. Affected OS Linux Workaround Install the missing plugin with the <code>sudo apt install libxcb-xinerama0</code> command. Ticket ID 259941 Summary On Linux, microDisplayX Might Crash When It Is Being Closed Description On Linux, microDisplayX might crash when it is being closed. This has no further consequences and can be ignored. Affected OS Linux Workaround No workaround is available. Ticket ID 211811"},{"location":"known-issues-framegrabber-sdk-5-11-3.html#python-wrapper","title":"python Wrapper","text":"Summary No python Wrapper Examples for the imaFlex Platforms Are Available Description No python Wrapper examples for the imaFlex platforms are delivered with the Framegrabber SDK. Affected OS Windows and Linux Workaround Use examples for other platforms and adapt them. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-4.html","title":"Known Issues Framegrabber SDK 5.11.4","text":"<p>This section provides information about known issues for the Basler Framegrabber SDK version 5.11.4.</p>"},{"location":"known-issues-framegrabber-sdk-5-11-4.html#all-components","title":"All Components","text":"Summary Using the Basler CXP-12 Interface Card 1C/2C/4C and imaworx CXP-12 Quad Frame Grabbers with PCIe Lower than Gen 3x8 May Reduce the Camera's Acquisition Frame Rate and Cause Image Loss Description The Basler CXP-12 Interface Card 1C/2C/4C and imaWorx CXP-12 Quad frame grabbers require a host interface with PCIe Gen 3x8 (Direct Memory Access) or better. Using slower host interfaces may reduce the camera's acquisition frame rate and cause image loss. Affected OS Linux and Windows Workaround No workaround is available. Ticket ID \u2013 Summary If Images Are Lost on a Frame Grabber or Interface Card the Lost Images Are Indicated by the Next Delivered Buffer Description If images are lost on a frame grabber or interface card due to a buffer overflow, e.g., when the user application doesn't (re)queue buffers fast enough to deliver the images, the lost images are indicated by the next delivered buffer. The lost images are marked as <code>INCOMPLETE</code>, their file size is <code>0</code>, and the custom error code <code>BUFFER_INFO_BASLER_XAPI_ERROR_CODE</code> is set to <code>42</code>. Additionally, one lost frame is added to the stream info. Note that only one lost frame is added regardless of how many frames were lost due to the overflow. Affected OS Linux and Windows Workaround No workaround is available. Ticket ID \u2013 Summary Changing the Applet with an Interface Card Leads to Incorrect Device List Description During an applet change, the cameras attached to an interface card are still displayed in the devices list even though they are not accessible anymore. An attempt to open a camera in this state leads to an error message. Affected OS Linux and Windows Workaround No workaround is available. Ticket ID \u2013 Summary The Camera Might Not Be Detected after Booting the Computer Description In rare cases, the camera isn't detected after booting the computer. Affected OS Linux and Windows Workaround To detect the camera, power-cycle the camera. Ticket ID \u2013 Summary Allocating Buffers Used for Grabbing Must Be Done Using Heap Memory Description When allocating buffers used for grabbing, the buffer address must be aligned to 8-byte increments. This is automatically the case, if you use heap memory. Affected OS Linux and Windows Workaround Use heap memory. Ticket ID \u2013 Summary Incompatabilities When Installing pylon and Framegrabber SDK Simultaneously on Your PC Description If pylon and the Framegrabber SDK are both installed on your computer, Basler recommends to de-select the CXP option in the pylon installation. To avoid issues resulting from competing CXP-producers, either pylon or Framegrabber SDK should be responsible to operate the Basler frame grabbers and/or interface cards. Affected OS Linux and Windows Workaround If pylon and the Framegrabber SDK are both installed on your computer, de-select the CXP option in the pylon installation. Ticket ID \u2013 Summary The Frames per Second (fps) Limit Is between 50000 fps and 90000 Description The frames per second (fps) limit is between 50000 fps and 90000, depending on the number of buffers and image size: <ul><li>10 buffers and a minimal image size of 48x1 give a limit of about 50000 fps</li><li>50 buffers and a minimal image size of 48x1 give a limit of about 90000 fps</li><li>50 buffers and an image size of 8192x1 give a limit of about 50000 fps</li></ul> Affected OS Linux and Windows Workaround No workaround is available. Ticket ID \u2013 Summary Storing and Loading MCF-Files Results in Double Values Rounded to a Whole Number Description When loading a configuration from an MCF-file, double values with comma delimiter might be rounded to the nearest whole number. This is caused by the current locale setting of the Linux operating system. Rounding doesn't occur if the locale defines a dot as delimiter. Affected OS Linux Workaround Set an appropriate locale, e.g., <code>LC_NUMERIC=\"C\" ./&lt;applicationName&gt;</code>, before you start microDisplay X or microDiagnostics. Ticket ID 265213 Summary Camera Doesn't Deliver Correct Images Description If a camera with multiple links doesn't comply with the CXP standard regarding the distribution of the image data over the links, the camera won't transmit images correctly. This issue was observed with a JAI SP-12000C-CXP4 camera. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID 211645 Summary Linux Drivers Can't Be Signed with a Trusted Basler Certificate Description Using secure boot (UEFI mode) with Linux requires a driver that is signed with a trusted certificate. Since the driver is provided as source code, there is no way to sign it with a trusted Basler certificate. Affected OS Linux Workaround To work with the driver, secure boot can be disabled. Alternatively, you can sign the driver as described in this Ubuntu blog entry. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-4.html#framegrabber-api","title":"Framegrabber API","text":"Summary Displaying Images with High Frame Rates May Lead to Input Lag Description When using the display_lib Framegrabber API library (only available on Windows), displaying images with high frame rates (about 10.000 frames per second) may lead to input lag (e.g., keyboard and mouse lag) on the host computer. Affected OS Windows Workaround No workaround is available. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-4.html#clcomdriver","title":"CLComDriver","text":"Summary There Are More Drivers Installed Than CLSer Ports in the System Description Sometimes when using Install COM driver(s) for all Ports, more drivers are installed than there are CLSer ports in the system. Affected OS Windows Workaround Select the additional port(s) and remove them using the command Remove selected COM driver. Ticket ID \u2013 Summary With Basler Runtime 5.9.0 or Earlier, the Board Type Isn't Recognized Description With Basler Runtime 5.9.0 or earlier, the board type isn't recognized and ports are only displayed using the CLSer identifier. Affected OS Windows Workaround Update your Basler Runtime/Framegrabber SDK version to 5.10 or higher. Ticket ID \u2013 Summary Port Settings in the Device Manager Don't Reflect Actual Settings Description Port settings in the device manager don't reflect actual settings and changes aren't considered. Affected OS Windows Workaround Use the Windows COM Port API to change port settings. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-4.html#linux-driver","title":"Linux Driver","text":"Summary Acquisition on marathon Frame Grabbers Delivers Distorted Images Description Acquired images on marathon CXP and CL frame grabbers might display distorted images. This is, because the Linux driver doesn't support using the Input-Output Memory Management Unit (IOMMU). Affected OS Linux Workaround Deactivate the Input-Output Memory Management Unit (IOMMU) by adding the following line to the file etc/default/grub.txt: <code>GRUB_CMDLINE_LINUX_DEFAULT=\"intel_iommu=off\"</code> Ticket ID 336093"},{"location":"known-issues-framegrabber-sdk-5-11-4.html#gentl-producer","title":"GenTL Producer","text":"Summary Gentl Device Discovery Doesn't Work with Camera Link Line Applets Description Cameras connected to marathon Camera Link frame grabbers such as ACL or VCL can be accessed via GenPC and CLP as described in this topic. Currently this only works for Area Scan Acquisition Applets and not for Line Scan Acquisition Applets. Affected OS Linux and Windows Workaround No workaround is available. Ticket ID 335339 Summary The GenTL <code>BUFFER_INFO_FRAME_ID</code> Contains a Counter for All Frames Instead of the CXP Image Header Source Tag Description The GenTL <code>BUFFER_INFO_FRAME_ID</code>, which can be queried via <code>DSGetBufferInfo</code>, doesn't contain the source tag from the CXP image header. Instead, it contains a counter for all frames that have been delivered to the computer. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013 Summary Restart Required after Changing the <code>DeviceUserID</code> of a Camera Description When the <code>DeviceUserID</code> of a camera is changed, a restart of the GenTL Producer is required for the change to be reflected. This affects both ways to use the GenTL Producer: via the GenTL API and using a GUI to interact with the camera via GenTL i.e., the pylon Viewer. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013 Summary Limited Gentl Support for Producers with Gentl Version 1.4 and Below Description Limited GenTL support for producers with GenTL version 1.4 and below. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013 Summary Image Sizes Are Limited to 2 GB Description Due to a limitation in the buffer size of the GenTL Producer, image sizes are limited to  2 GB. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013 Summary Camera Parameters Changed after Image Acquisition Start Aren't Reflected in the Frame Grabber Description When camera parameters are changed during image acquisition, the change isn't reflected in the frame grabber. This is because the GenTL Producer retrieves the relevant parameters (width, height, image format, etc.) before starting the acquisition and synchronizes these with the frame grabber. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID 195482 and 225591 Summary The GenTL Device ID Changes When the Applet Is Changed Description According to the GenTL standard, the device ID should remain constant between two sessions. However, the GenTL device ID changes when the applet is changed. Therefore, the device ID can only be reused if the applet has the same name as the applet with which the device ID was generated. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-4.html#microdisplayx","title":"microDisplayX","text":"Summary microDisplayX Crashes When Opening the Camera Tab Description microDisplayX crashes when the Camera tab is clicked while cameras are still being detected. Affected OS Linux and Windows Workaround This has been fixed in the Framegrabber SDK version 5.11.5. Update your Framegrabber SDK version to 5.11.5 or higher. Ticket ID 333828 Summary microDisplayX Freezes After Deleting a Loaded Applet Description On Linux systems, microDisplayX may freeze when attempting to re-scan an mE6 frame grabber for available applets after an applet has been deleted. Affected OS Linux Workaround This has been fixed in the Framegrabber SDK version 5.11.5. Update your Framegrabber SDK version to 5.11.5 or higher. Ticket ID 334080 Summary Camera Detection Sometimes Doesn't Work in microDisplayX for VisualApplets Designs That Contain Two Camera Operators Description Camera detection doesn't work in microDisplayX for VisualApplets designs that contain two camera operators of which at least one operator has two channels and the resource indices are assigned in direct ascending order. For example, two camera operators with two channels each, operator A uses ports 0 and 1 and operator B uses ports 2 and 3. Affected OS Windows and Linux Workaround Don't assign the resource indices in direct ascending order. For example, assign the channels of operator A to ports 0 and 2, and the channels of operator B to ports 1 and 3. Ticket ID 314206 Summary microDisplay X Crashes When Loading HAP Files with Complex Designs Description Some very complex VisualApplet designs may lead to crashes during or immediately after loading the applet in microDisplayX. No such crashes have been observed in SDK programs. Affected OS Windows and Linux Workaround Load the applet in microDisplayX again. Loading the applet in microDisplayX usually works after the second or third attempt. Ticket ID 314234 Summary On a Clean Linux Installation, microDisplayX Doesn't Start Description On a clean Linux installation, microDisplayX doesn't start. The reason for this issue is that on a clean Linux installation, the <code>xcb</code> QT platform plugin is missing. Affected OS Linux Workaround Install the missing plugin with the <code>sudo apt install libxcb-xinerama0</code> command. Ticket ID 259941 Summary On Linux, microDisplayX Might Crash When It Is Being Closed Description On Linux, microDisplayX might crash when it is being closed. This has no further consequences and can be ignored. Affected OS Linux Workaround No workaround is available. Ticket ID 211811"},{"location":"known-issues-framegrabber-sdk-5-11-4.html#python-wrapper","title":"python Wrapper","text":"Summary No python Wrapper Examples for the imaFlex Platforms Are Available Description No python Wrapper examples for the imaFlex platforms are delivered with the Framegrabber SDK. Affected OS Windows and Linux Workaround Use examples for other platforms and adapt them. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-5.html","title":"Known Issues Framegrabber SDK 5.11.5","text":"<p>This section provides information about known issues for the Basler Framegrabber SDK version 5.11.5.</p>"},{"location":"known-issues-framegrabber-sdk-5-11-5.html#all-components","title":"All Components","text":"Summary Using the Basler CXP-12 Interface Card 2C/4C and imaworx CXP-12 Quad Frame Grabbers with PCIe Lower than Gen 3x8 May Reduce the Camera's Acquisition Frame Rate and Cause Image Loss Description The Basler CXP-12 Interface Card 2C/4C and imaWorx CXP-12 Quad frame grabbers require a host interface with PCIe Gen 3x8 (Direct Memory Access) or better. Using slower host interfaces may reduce the camera's acquisition frame rate and cause image loss. Affected OS Linux and Windows Workaround No workaround is available. Ticket ID \u2013 Summary If Images Are Lost on a Frame Grabber or Interface Card the Lost Images Are Indicated by the Next Delivered Buffer Description If images are lost on a frame grabber or interface card due to a buffer overflow, e.g., when the user application doesn't (re)queue buffers fast enough to deliver the images, the lost images are indicated by the next delivered buffer. The lost images are marked as <code>INCOMPLETE</code>, their file size is <code>0</code>, and the custom error code <code>BUFFER_INFO_BASLER_XAPI_ERROR_CODE</code> is set to <code>42</code>. Additionally, one lost frame is added to the stream info. Note that only one lost frame is added regardless of how many frames were lost due to the overflow. Affected OS Linux and Windows Workaround No workaround is available. Ticket ID \u2013 Summary Changing the Applet with an Interface Card Leads to Incorrect Device List Description During an applet change, the cameras attached to an interface card are still displayed in the devices list even though they are not accessible anymore. An attempt to open a camera in this state leads to an error message. Affected OS Linux and Windows Workaround No workaround is available. Ticket ID \u2013 Summary The Camera Might Not Be Detected after Booting the Computer Description In rare cases, the camera isn't detected after booting the computer. Affected OS Linux and Windows Workaround To detect the camera, power-cycle the camera. Ticket ID \u2013 Summary Allocating Buffers Used for Grabbing Must Be Done Using Heap Memory Description When allocating buffers used for grabbing, the buffer address must be aligned to 8-byte increments. This is automatically the case, if you use heap memory. Affected OS Linux and Windows Workaround Use heap memory. Ticket ID \u2013 Summary Incompatabilities When Installing pylon and Framegrabber SDK Simultaneously on Your PC Description If pylon and the Framegrabber SDK are both installed on your computer, Basler recommends to de-select the CXP option in the pylon installation. To avoid issues resulting from competing CXP-producers, either pylon or Framegrabber SDK should be responsible to operate the Basler frame grabbers and/or interface cards. Affected OS Linux and Windows Workaround If pylon and the Framegrabber SDK are both installed on your computer, de-select the CXP option in the pylon installation. Ticket ID \u2013 Summary The Frames per Second (fps) Limit Is between 50000 fps and 90000 fps Description The frames per second (fps) limit is between 50000 fps and 90000 fps, depending on the number of buffers and image size: <ul><li>10 buffers and a minimal image size of 48x1 give a limit of about 50000 fps</li><li>50 buffers and a minimal image size of 48x1 give a limit of about 90000 fps</li><li>50 buffers and an image size of 8192x1 give a limit of about 50000 fps</li></ul> Affected OS Linux and Windows Workaround No workaround is available. Ticket ID \u2013 Summary Storing and Loading MCF-Files Results in Double Values Rounded to a Whole Number Description When loading a configuration from an MCF-file, double values with comma delimiter might be rounded to the nearest whole number. This is caused by the current locale setting of the Linux operating system. Rounding doesn't occur if the locale defines a dot as delimiter. Affected OS Linux Workaround Set an appropriate locale, e.g., <code>LC_NUMERIC=\"C\" ./&lt;applicationName&gt;</code>, before you start microDisplay X or microDiagnostics. Ticket ID 265213 Summary Camera Doesn't Deliver Correct Images Description If a camera with multiple links doesn't comply with the CXP standard regarding the distribution of the image data over the links, the camera won't transmit images correctly. This issue was observed with a JAI SP-12000C-CXP4 camera. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID 211645 Summary Linux Drivers Can't Be Signed with a Trusted Basler Certificate Description Using secure boot (UEFI mode) with Linux requires a driver that is signed with a trusted certificate. Since the driver is provided as source code, there is no way to sign it with a trusted Basler certificate. Affected OS Linux Workaround To work with the driver, secure boot can be disabled. Alternatively, you can sign the driver as described in this Ubuntu blog entry. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-5.html#framegrabber-api","title":"Framegrabber API","text":"Summary Displaying Images with High Frame Rates May Lead to Input Lag Description When using the display_lib Framegrabber API library (only available on Windows), displaying images with high frame rates (about 10.000 frames per second) may lead to input lag (e.g., keyboard and mouse lag) on the host computer. Affected OS Windows Workaround No workaround is available. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-5.html#clcomdriver","title":"CLComDriver","text":"Summary There Are More Drivers Installed Than CLSer Ports in the System Description Sometimes when using Install COM driver(s) for all Ports, more drivers are installed than there are CLSer ports in the system. Affected OS Windows Workaround Select the additional port(s) and remove them using the command Remove selected COM driver. Ticket ID \u2013 Summary With Basler Runtime 5.9.0 or Earlier, the Board Type Isn't Recognized Description With Basler Runtime 5.9.0 or earlier, the board type isn't recognized and ports are only displayed using the CLSer identifier. Affected OS Windows Workaround Update your Basler Runtime/Framegrabber SDK version to 5.10 or higher. Ticket ID \u2013 Summary Port Settings in the Device Manager Don't Reflect Actual Settings Description Port settings in the device manager don't reflect actual settings and changes aren't considered. Affected OS Windows Workaround Use the Windows COM Port API to change port settings. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-5.html#linux-driver","title":"Linux Driver","text":"Summary Acquisition on marathon Frame Grabbers Delivers Distorted Images Description Acquired images on marathon CXP and CL frame grabbers might display distorted images. This is, because the Linux driver doesn't support using the Input-Output Memory Management Unit (IOMMU). Affected OS Linux Workaround Deactivate the Input-Output Memory Management Unit (IOMMU) by adding the following line to the file etc/default/grub.txt: <code>GRUB_CMDLINE_LINUX_DEFAULT=\"intel_iommu=off\"</code> Ticket ID 336093"},{"location":"known-issues-framegrabber-sdk-5-11-5.html#gentl-producer","title":"GenTL Producer","text":"Summary The GenTL <code>BUFFER_INFO_FRAME_ID</code> Contains a Counter for All Frames Instead of the CXP Image Header Source Tag Description The GenTL <code>BUFFER_INFO_FRAME_ID</code>, which can be queried via <code>DSGetBufferInfo</code>, doesn't contain the source tag from the CXP image header. Instead, it contains a counter for all frames that have been delivered to the computer. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013 Summary Restart Required after Changing the <code>DeviceUserID</code> of a Camera Description When the <code>DeviceUserID</code> of a camera is changed, a restart of the GenTL Producer is required for the change to be reflected. This affects both ways to use the GenTL Producer: via the GenTL API and using a GUI to interact with the camera via GenTL i.e., the pylon Viewer. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013 Summary Limited Gentl Support for Producers with Gentl Version 1.4 and Below Description Limited GenTL support for producers with GenTL version 1.4 and below. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013 Summary Image Sizes Are Limited to 2 GB Description Due to a limitation in the buffer size of the GenTL Producer, image sizes are limited to  2 GB. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013 Summary Camera Parameters Changed after Image Acquisition Start Aren't Reflected in the Frame Grabber Description When camera parameters are changed during image acquisition, the change isn't reflected in the frame grabber. This is because the GenTL Producer retrieves the relevant parameters (width, height, image format, etc.) before starting the acquisition and synchronizes these with the frame grabber. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID 195482 and 225591 Summary The GenTL Device ID Changes When the Applet Is Changed Description According to the GenTL standard, the device ID should remain constant between two sessions. However, the GenTL device ID changes when the applet is changed. Therefore, the device ID can only be reused if the applet has the same name as the applet with which the device ID was generated. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013"},{"location":"known-issues-framegrabber-sdk-5-11-5.html#microdisplayx","title":"microDisplayX","text":"Summary Camera Detection Sometimes Doesn't Work in microDisplayX for VisualApplets Designs That Contain Two Camera Operators Description Camera detection doesn't work in microDisplayX for VisualApplets designs that contain two camera operators of which at least one operator has two channels and the resource indices are assigned in direct ascending order. For example, two camera operators with two channels each, operator A uses ports 0 and 1 and operator B uses ports 2 and 3. Affected OS Windows and Linux Workaround Don't assign the resource indices in direct ascending order. For example, assign the channels of operator A to ports 0 and 2, and the channels of operator B to ports 1 and 3. Ticket ID 314206 Summary microDisplay X Crashes When Loading HAP Files with Complex Designs Description Some very complex VisualApplet designs may lead to crashes during or immediately after loading the applet in microDisplayX. No such crashes have been observed in SDK programs. Affected OS Windows and Linux Workaround Load the applet in microDisplayX again. Loading the applet in microDisplayX usually works after the second or third attempt. Ticket ID 314234 Summary On a Clean Linux Installation, microDisplayX Doesn't Start Description On a clean Linux installation, microDisplayX doesn't start. The reason for this issue is that on a clean Linux installation, the <code>xcb</code> QT platform plugin is missing. Affected OS Linux Workaround Install the missing plugin with the <code>sudo apt install libxcb-xinerama0</code> command. Ticket ID 259941 Summary On Linux, microDisplayX Might Crash When It Is Being Closed Description On Linux, microDisplayX might crash when it is being closed. This has no further consequences and can be ignored. Affected OS Linux Workaround No workaround is available. Ticket ID 211811 Summary microDisplayX Might Crash If Camera Tab Is Opened Description microDisplay X might crash if the Camera tab is opened. This happens, if exactly one mE6 grabber is installed with a single camera attached, and discovery is completed, and your first click in microDisplay X is on the Camera tab. Affected OS Windows and Linux Workaround Open the Camera tab before the camera is discovered. Ticket ID 333828"},{"location":"known-issues-framegrabber-sdk-5-11-5.html#python-wrapper","title":"python Wrapper","text":"Summary No python Wrapper Examples for the imaFlex Platforms Are Available Description No python Wrapper examples for the imaFlex platforms are delivered with the Framegrabber SDK. Affected OS Windows and Linux Workaround Use examples for other platforms and adapt them. Ticket ID \u2013"},{"location":"known-issues-runtime-5-9-0.html","title":"Known Issues Runtime 5.9.0","text":"<p>This section provides information about known issues for the Basler Runtime version 5.9.0.</p>"},{"location":"known-issues-runtime-5-9-0.html#all-components","title":"All Components","text":"Summary Camera Does Not Deliver Correct Images Description If a camera with multiple links doesn't comply with the CXP standard regarding the distribution of the image data over the links, no correct images are delivered to the computer. This issue was observed with a JAI SP-12000C-CXP4 camera. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID TFS 211645 Summary Unexpected Behavior of the Camera Simulator Description The usage of the applet\u2019s internal camera simulator may show a lower bandwidth than expected. This does mean that certain overflow conditions may occur when the current simulator is used. When a real camera is used, this behavior doesn't show. The issue is only related to the internal camera simulator. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013 Summary Frame Grabber Do Not Work with Windows Fast Startup Description Under Windows 8 or higher with Fast Startup enabled (also known as Hybrid Boot or Hybrid Shutdown), the frame grabber may no longer work after changing the hardware setup and restarting the system. Affected OS Windows 8 or higher Workaround A restart (explicit restart, not shutdown) solves these problems. To avoid the problems completely, disable Fast Startup as described by www.windowscentral.com. Ticket ID \u2013 Summary Displaying Images with High Frame Rates May Lead to Slow Reactions to User Input Description When using the Framegrabber API library display_lib (only available on Windows), displaying images with high frame rates (about 10.000 frames per second) may lead to slow reactions to user input (e.g. keyboard and mouse) of the host computer. Affected OS Windows Workaround No workaround is available. Ticket ID \u2013 Summary Linux Drivers can't be Signed with a Trusted Basler Certificate Description Using secure boot (UEFI mode) with Linux requires a driver that is signed with a trusted certificate. Since the driver is provided as source code, there is no way to sign it with a trusted Basler certificate. Affected OS Linux Workaround To work with the driver, secure boot can be disabled. Alternatively, you can sign the driver as described in this Ubuntu blog entry. Ticket ID \u2013"},{"location":"known-issues-runtime-5-9-0.html#frame-grabber","title":"Frame Grabber","text":"Summary LED 12EXT Illuminates Red on Wrong Event Description The LED 12EXT is supposed to illuminate red when imaWorx isn't connected to an external power supply. However, the LED only illuminates red, if the external power connector is connected and falsely reflects the state of 12V_DC_UP instead of 12V_EXT. Workaround No workaround is available. Ticket ID TFS 206709"},{"location":"known-issues-runtime-5-9-0.html#firmware","title":"Firmware","text":"Summary Data Loss and System Freeze Caused by the PCIe Communication Module of the CXP-12 Interface Card 1C Card Description Due to an issue in the PCIe communication module of the CXP-12 Interface Card 1C card with firmware version 3.0 S1.1 P1 (and the corresponding applet), data transfers may fail and the system could freeze, depending on how sensitive the computer's PCI hardware is. This can happen, when:<ul><li>A buffer has a memory address that starts 4 bytes after or ends 4 bytes before a PCI payload size boundary.</li><li>The camera produces a frame with a size in bytes that is a multiple of 4 but not of 8.</li> Affected OS Windows and Linux Affected Hardware CXP-12 Interface Card 1C card with firmware version 3.0 S1.1 P1 Workaround Create buffers at memory addresses that are divisible by 8. If the desired buffer size isn't divisible by 8, allocate additional bytes to match this requirement and ignore this padding when processing the data.<sup>a</sup> Ticket ID TFS 184670 Summary Changes in  <code>DeviceUserID</code> Require a Restart of GenTL Producer or Other Applications Description When the <code>DeviceUserID</code> (precisely: the value of the CXP bootstrap register <code>DeviceUserID</code>) of the camera is changed, a restart of the GenTL Producer is required for the change to be reflected via the GenTL API. When using a GUI to interact with the camera via GenTL (i.e. pylon Viewer), a restart of that application is required for the change to become visible. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID TFS 207518"},{"location":"known-issues-runtime-5-9-0.html#cxp-12-interface-card-1c-applet","title":"CXP-12 Interface Card 1C Applet","text":"Summary Frequently Changed Link Speed Leads to Errors Description When the CXP link speed is frequently changed on one port, it can happen that the speed change doesn't work anymore. In that case, the error messages \"Failed to set bitrate of uplink transceivers\" and \"Failed to set bitrate of downlink transceivers\" are logged. Since the camera discovery probes the unconnected ports and therefore changes their link speed, this issue can occur when an application frequently tries to discover new cameras on unconnected ports. Affected OS Windows and Linux Workaround Reload the applet: Reloading the applet is possible by loading a different applet and then loading the original one again. If an environment variable with the name <code>SISO_FORCE_RELOAD_APPLET</code> is defined with the value yes, the reloading also works without loading a different applet first. Ticket ID TFS 197127"},{"location":"known-issues-runtime-5-9-0.html#sdk","title":"SDK","text":"Summary Corrupted Frames Due to Slow Image Delivery from Camera to Frame Grabber Description If (re-)queuing the buffers is slower than transferring the images from the camera to the frame grabber, corrupt images are delivered. This behavior can only be detected by examining the image data. Affected OS Windows and Linux Workaround To avoid these corrupt images, image processing and requeuing of buffers must be faster than the frame rate of the camera. The internal buffer on the frame grabber is sufficient to balance out smaller delays due to scheduling etc. A broken frame produced due to this issue is smaller than the configured dimensions, so an unexpectedly smaller frame can be used as an indicator for this. You can determine the size of the frame data as follows:<ul><li>Using the GenTL Producer:Call <code>DSGetBufferInfo</code> with <code>BUFFER_INFO_SIZE_FILLED</code> as command.Do NOT use <code>BUFFER_INFO_IS_INCOMPLETE</code> and don't check for <code>BUFFER_INFO_SIZE_FILLED</code> &lt; <code>BUFFER_INFO_DATA_SIZE</code>. These checks will always be false. For details, see section GenTL Producer.</li><li>Using the frame grabber SDK / fglib:Call <code>Fg_getParameterEx</code> with <code>FG_TRANSFER_LEN</code> as parameter.</li></ul> Ticket ID TFS 207873"},{"location":"known-issues-runtime-5-9-0.html#cognex-adapter","title":"Cognex Adapter","text":"Summary Cognex VisionPro Must Be Started with Admin User Rights Description Cognex VisionPro must be started with Admin user rights to access the frame grabber. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID TFS 187245 Summary Limited Memory Leads to Failed Acquisition for Large Images Description When setting up a large ROI (i.e 4096 x 3000), starting the acquisition may fail with the message \"The acquisition failed abnormally. (Adapter image pool full.)\" This happens, because VisionPro limits the memory that can be used by the vendor-specific adapters. Affected OS Windows Workaround To avoid this, increase the limit via the Windows Registry as described in the Basler Cognex VisionPro Adapter Manual Ticket ID TFS 203605"},{"location":"known-issues-runtime-5-9-0.html#gentl-producer","title":"GenTL Producer","text":"Summary Camera Parameters Changed after Image Acquisition Start Are Not Reflected In the Frame Grabber Description When camera parameters are changed during image acquisition, the change isn't reflected in the frame grabber. This is so, because the GenTL Producer enquires the relevant parameters (width, height, image format, etc.) before starting the acquisition and synchronizes these with the frame grabber. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID TFS 195482 Summary <code>BUFFER_INFO_DATA_SIZE</code> Contains Number of Transferred Bytes Instead of Frame Size Description The buffer property <code>BUFFER_INFO_DATA_SIZE</code> doesn't work as expected: <code>BUFFER_INFO_DATA_SIZE</code> is supposed to contain the configured size of the frame. However, it does contain the actual number of transferred bytes as does <code>BUFFER_INFO_SIZE_FILLED</code>. Therefore, the property <code>BUFFER_INFO_IS_INCOMPLETE</code> will always be false. Affected OS Windows and Linux Workaround The intended value of <code>BUFFER_INFO_DATA_SIZE</code> usually equals the image's <code>width * height * pixel size</code>. Ticket ID TFS 211972 Summary The GenTL Device ID Changes When the Applet Is Changed Description According to the GenTL standard, the device ID should remain constant between two sessions. However, the GenTL device ID changes when the applet is changed. Therefore, the device ID that was queried with one applet can be used with a different board and a different applet only, if the applet has the same name as the original one with which the device ID was generated. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID \u2013 Summary <code>BUFFER_INFO_FRAME_ID</code> Contains a Counter for All Frames Instead of the Source Tag from the CXP Image Header Description The GenTL <code>BUFFER_INFO_FRAME_ID</code>, that can be queried via <code>DSGetBufferInfo</code>, doesn't contain the source tag from the CXP image header. Instead, it contains a counter for all frames that have been delivered to the computer. Affected OS Windows and Linux Workaround No workaround is available. Ticket ID TFS 197430"},{"location":"known-issues-runtime-5-9-0.html#microdisplayx","title":"microDisplayX","text":"Summary Setting <code>TriggerState</code> to active May Cause the Acquisition to Time Out Description Setting the applet parameter <code>TriggerState</code> to active before starting the acquisition on the camera may cause the acquisition to time out without any images being delivered. Affected OS Windows and Linux Workaround To avoid this, make sure that <code>TriggerState</code> is only activated after the acquisition has been started. Ticket ID TFS 191631 Summary On Linux, microDisplayX Might Crash When It Is Being Closed Description On Linux, microDisplayX might crash when it is being closed. This has no further consequences and can be ignored. Affected OS Linux Workaround No workaround is available. Ticket ID TFS 211811 <ol> <li> <p>You can use the following code example to create a buffer that doesn't have this data transfer issue:</p> <p> <code><p></p> <pre><code>// create a ROI that could trigger the issue (for demonstration purposes only!)\n\n    size_t imageWidthPx = 252;\n\n    size_t imageHeightPx = 15;\n\n    size_t pixelSizeBytes = 1;\n\n// compute the required buffer size for one image\n\nsize_t imageSizeBytes = imageWidthPx * imageHeightPx * pixelSizeBytes;\n\n// set the buffer size to the nearest larger size that is divisible by 8\n\nsize_t bufferSizeBytes = ((imageSizeBytes + 7) / 8) * 8;\n\n// add 4 more bytes so we can add an offset of 4 bytes if the address ends up being only 4 byte aligned\n\nbufferSizeBytes += 4;\n\n// allocate the buffer\n\nuint8_t* imageBuffer = (uint8_t*)malloc(bufferSizeBytes);\n\n// sanitize the address\n\nuint8_t* sanitizedImageBuffer = (((uintptr_t)(imageBuffer)) % 8 == 0)\n\n    ? imageBuffer\n\n    : imageBuffer + 4;\n\n /* [use the sanitized buffer] */\n\n// free the original(!) buffer\n\nfree(imageBuffer);\n</code></pre> <p></p> </code> \u21a9</p> </li> </ol>"},{"location":"legal-info.html","title":"Legal Info","text":""},{"location":"legal-info.html#responsible","title":"Responsible","text":"<p>Basler AG An der Strusbek 60-62 22926 Ahrensburg</p> <p>Tel. +49 4102 463 0 Fax +49 4102 463 109</p> <p>info@baslerweb.com</p> <p>Management board: Dr.Ing. Dietmar Ley (CEO), Ines Br\u00fcckel (CFO), Hardy Mehl (CCO/COO)</p> <p>Chairman of the supervisory board: Norbert Basler</p> <p>Amtsgericht Luebeck HRB 4090</p> <p>Value added tax ID: DE 135 098 121</p> <p>WEEE registration number: DE 83888045</p>"},{"location":"log-file-micro-diagnostics.html","title":"Log File (microDiagnostics)","text":"<p>microDiagnostics is logging all activities carried out during one session (instantiation). As you work with the program, all activities are continuously logged to file. When you close microDiagnostics, the log file is discarded.</p> <p>To get information out of the log file, select the Log category from the left-hand panel.</p> <p></p> <p>At program start, microDisplay X automatically starts a system check, writes the results into a fresh log file and provides this information in the display window.</p>"},{"location":"log-message-system.html","title":"Log Message System","text":"<p>The log message system of the Framegrabber SDK provides additional information which can be useful in tracking down problems observed in a user application. Around 1000 individual messages provide information about the system configuration, warnings when conditions aren't as expected, and more detailed error descriptions.</p> <p>At the core of the log message system is a dispatcher which forwards messages to log4cpp<sup>a</sup> and the siso_log library. The logging library log4cpp is used by GenICam and the pylon SDK to provide logging to the console, log files, syslog, the pylon Event Logger Application, and other destinations. Using the siso_log library, the user application can register a callback handler to receive warnings and error messages.</p> <ol> <li> <p>log4cpp is a C++ adaptation of Log4j and you find it on SourceForge. log4cpp was first used in the Framegrabber SDK version 5.11.3. Older versions of the Framegrabber SDK used log4cxx, an alternative to log4cpp.\u00a0\u21a9</p> </li> </ol>"},{"location":"log-message-system.html#configuring-log4cpp-for-logging","title":"Configuring Log4cpp for Logging","text":"<p>The log4cpp library can be configured using a configuration file. You find the default configuration for the Framegrabber SDK in the installation directory in the file bin/BaslerFgSdkLogging.properties. To change the configuration, you can edit this file, or you can provide your own configuration file and set the environment variable <code>BASLER_FGSDK_LOGGING_CONFIG</code> to point to the location of the file.</p> <p>The configuration file for log4cpp is a text file. Each line of the file can contain one configuration option, which is given in the form <code>&lt;key&gt;=&lt;value&gt;</code>, and an optional comment starting with a <code>#</code> character. Empty lines and lines only containing a comment are also allowed.</p> <p><code>&lt;key&gt;</code> is a hierarchical element, the levels of hierarchy are separated by a <code>.</code> character. The top level of the hierarchy is always <code>log4cpp</code>, alternatively you can use <code>log4j</code>. The second level of the hierarchy is either <code>category</code> (including <code>rootCategory</code>), or <code>appender</code>.</p> <p>A category designates where the log messages come from, and an appender designates a destination for the log messages.</p>"},{"location":"log-message-system.html#configuring-log4cpp-categories","title":"Configuring Log4cpp Categories","text":"<p>The options for a category are <code>&lt;min-severity&gt;[, &lt;appender&gt;[...]]</code>. The value for <code>&lt;min-severity&gt;</code> can be:</p> <ul> <li><code>FATAL</code>,</li> <li><code>ALERT</code>,</li> <li><code>CRIT</code>,</li> <li><code>ERROR</code>,</li> <li><code>WARN</code>,</li> <li><code>NOTICE</code>,</li> <li><code>INFO</code>, or</li> <li><code>DEBUG</code></li> </ul> <p><code>&lt;min-severity&gt;</code> specifies the severity threshold of the log messages to be reported for the category and all its sub-categories. The optional list of <code>&lt;appender&gt;</code> specifies to which appender the log messages should be forwarded for the category and all its sub-categories.</p> <p>Category options are inherited by all sub-categories, but can be overwritten by providing a separate option for a sub-category. Again, all sub-sub-categories inherit the configuration of the sub-category.</p> <p>Most configuration files start with setting up reasonable defaults for all categories, using the special designation <code>rootCategory</code>. For example:</p> <pre><code>log4j.rootCategory=NOTICE, stdout\n</code></pre> <p>This configuration option sends all messages of the severity <code>FATAL</code>, <code>ALERT</code>, <code>CRIT</code>, <code>ERROR</code>, <code>WARN</code>, and <code>NOTICE</code> to the appender <code>stdout</code>. You must define the appender in the configuration file, as described at Configuring Log4cpp Appenders.</p>"},{"location":"log-message-system.html#mapping-of-log-levels","title":"Mapping of Log Levels","text":"<p>The Framegrabber SDK internally uses a different set of names for the severity of log messages, which follow the naming of the library log4cxx used in previous versions of the Framegrabber SDK. You might come across these internal log levels, for example, when using the siso_log library or the Debug dialog in microDisplayX.</p> Severity siso_log log4cpp lower TRACE DEBUG DEBUG INFO INFO NOTICE WARN WARN ERROR ERROR higher FATAL CRIT, FATAL, ALERT"},{"location":"log-message-system.html#configuring-log4cpp-appenders","title":"Configuring Log4cpp Appenders","text":"<p>To direct log messages to a destination, you must define and configure appenders in the configuration file. The appender must be included in a category configuration in the configuration file.</p> <p>There are different types of appenders provided by the log4cpp library, which is installed with the Framegrabber SDK. Each type of appender has a set of configurable parameters that define, for example, how a log file should be named, where it should be saved, and if it should be limited in size.</p> <p>To define an appender, the name is given as a key in the <code>log4cpp.appender</code> hierarchy and the type is specified as value. For example, the following line defines an appender named <code>stdout</code> which writes log messages to the console:</p> <pre><code>log4cpp.appender.stdout=ConsoleAppender\n</code></pre> <p>You can further configure the appender by setting options in the hierarchy below the named appender. For example, the following lines change the format of the log messages:</p> <pre><code>log4cpp.appender.stdout.layout=PatternLayout\nlog4cpp.appender.stdout.layout.ConversionPattern=[%d:%t:%c] %p: %m%n\n</code></pre>"},{"location":"log-message-system.html#formatting-log-messages","title":"Formatting Log Messages","text":"<p>All appenders share some common options for formatting log messages by setting and configuring the <code>layout</code>. There are two simple, fixed layouts which can't be further configured: <code>SimpleLayout</code> and <code>BasicLayout</code>. <code>PatternLayout</code> can be configured by setting the <code>ConversionPattern</code>.</p> <p>The option <code>ConversionPattern</code> is a format string and can contain the following format specifiers plus text that should appear in all log messages:</p> Specifier Meaning %% The character <code>%</code> %c Category %d Date (see below) %m Log message %n Line separator %p Priority (severity) %r Milliseconds since creating the layout %R Seconds since Jan 1, 1970 %t Thread ID %u Clock ticks since start of process <p>The date format specifier adds the date and time according to the short date format specified by the system. To customize the date format, the date format specifier can be followed by a strftime format specifier enclosed in curly braces (<code>%d{...}</code>). Refer to the strftime documentation for further details. The only change to the strftime format specifiers is, that the specifier <code>%l</code> prints milliseconds padded with zeroes to make three digits. For example, to print the date and time in an extended ISO 8601 format including milliseconds, use either <code>%d{%FT%T.%l%z}</code>, or <code>%d{%Y-%m-%dT%H:%M:%S.%l%z}</code>.</p>"},{"location":"log-message-system.html#logging-to-files","title":"Logging to Files","text":"<p>There are two appenders store log messages in files: <code>FileAppender</code> and <code>RollingFileAppender</code>.</p> <p>The <code>FileAppender</code> has one required option, <code>fileName</code>, to set the file name. For example, to log messages to a file named <code>fglib.log</code> in addition to the console, the configuration file could look like this:</p> <pre><code>log4cpp.rootCategory=NOTICE, stdout, logfile\n\nlog4cpp.appender.stdout=ConsoleAppender\nlog4cpp.appender.stdout.layout=SimpleLayout\n\nlog4cpp.appender.logfile=FileAppender\nlog4cpp.appender.logfile.fileName=fglib.log\nlog4cpp.appender.logfile.layout=BasicLayout\n</code></pre> <p>The <code>RollingFileAppender</code> only writes to the log file up to a specified file size, then creates a backup of the file and clears the file to start anew. As with <code>FileAppender</code>, <code>fileName</code> is used to specify the name for the log file. In addition, <code>maxFileSize</code> can be set to change the maximum file size before rolling over. The default for <code>maxFileSize</code> is 10 MB. To set the number of backup files allowed, you can set <code>maxBackupIndex</code>. The default for <code>maxBackupIndex</code> is 1.</p>"},{"location":"log-message-system.html#using-the-pylon-event-logger","title":"Using the Pylon Event Logger","text":"<p>Alternatively to the log4cpp library, you can use the pylon Event Logger Application to display, filter and highlight log messages.</p> <p>If you start the user application from the pylon Event Logger application, a configuration file is automatically generated and used, which makes sure that the pylon Event Logger application receives log messages from the user application.</p> <p>If you start the user application in a different way, then the log4cpp configuration must include the <code>EltAppender</code>. The <code>EltAppender</code> works by sending log messages via the network interface and you must specify the port used with <code>portNumber</code>. The port must match the setup of the pylon Event Logger application. The default configuration for this scenario looks like this:</p> <pre><code>log4j.rootCategory=NOTICE, pylonEventLogger, stdout\n\nlog4j.appender.stdout=ConsoleAppender\nlog4j.appender.stdout.layout=PatternLayout\nlog4j.appender.stdout.layout.ConversionPattern=[%d:%t:%c] %p: %m%n\n\nlog4j.appender.pylonEventLogger=org.apache.log4j.EltAppender\nlog4j.appender.pylonEventLogger.layout=org.apache.log4j.PatternLayout\nlog4j.appender.pylonEventLogger.layout.ConversionPattern=[%d:%t:%c] %p: %m%n\nlog4j.appender.pylonEventLogger.portNumber=12320\n</code></pre>"},{"location":"log-message-system.html#using-the-siso_log-library-to-receive-log-message-in-an-application","title":"Using the siso_log Library to Receive Log Message in an Application","text":"<pre><code>int SisoLog_InitLibrary();\n</code></pre> <pre><code>typedef void FuncType_LogMsgCallback(\n    tProcessId pid,\n    tThreadId tid,\n    const char * const logger,\n    unsigned int level,\n    const char * const msg,\n    unsigned int tagcount,\n    const tSisoLogTag * const tags,\n    void * userdata\n);\n\nint SisoLog_RegisterLogMsgCallback(\n    FuncType_LogMsgCallback * callback,\n    void * userdata);\n</code></pre> <pre><code>int SisoLog_SetMode(\n    unsigned int mode);\n\nint SisoLog_GetMode(\n    unsigned int * mode);\n</code></pre> <p>To receive log messages from the log message system of the Framegrabber SDK, add the library siso_log to your application project and include <code>siso_log.h</code> in your source code. Refer to the chapter Prerequisites of the Framegrabber API Manual for further details.</p> <p>To start using the siso_log library, first call <code>SisoLog_InitLibrary()</code> to perform initialization.</p> <p>With <code>SisoLog_RegisterLogMsgCallback()</code> you can register a function of the type <code>FuncType_LogMsgCallback</code>, which is then called whenever a log message of the severity <code>WARN</code>, <code>ERROR</code>, or <code>FATAL</code> is reported from the log message system. You can register only one function in a process.</p> <p>Parameters of the <code>SisoLog_RegisterLogMsgCallback()</code> callback function:</p> <ul> <li>The first two parameters to the callback functions are the process and thread IDs.</li> <li>The third parameter is the name of the logger (category).</li> <li>The fourth parameter is the severity, also called \"log level\" or \"priority\".</li> <li>The fifth parameter is the log message.</li> <li>The sixth and seventh parameters are the number of tags and a pointer to the array of tags. Tags are used to add additional metadata to log messages, such as the device relations.</li> <li>The last parameter to the callback function is a pointer which was supplied with the call to <code>SisoLog_RegisterLogMsgCallback()</code> and which can be used as a pointer to a context structure or class, for example this pointer of a class instance which represents the user application.</li> </ul> <p>After a callback function has been registered, the application must call <code>SisoLog_SetMode()</code> and pass <code>SISOLOG_MODE_DEFAULT</code> to eanble forwarding log messages.</p>"},{"location":"log-message-system.html#stop-receiving-log-messages","title":"Stop Receiving Log Messages","text":"<pre><code>int SisoLog_RegisterLogMsgCallback(\n    FuncType_LogMsgCallback * callback,\n    void * userdata);\n</code></pre> <pre><code>int SisoLog_SetMode(\n    unsigned int mode);\n</code></pre> <pre><code>int SisoLog_FreeLibrary();\n</code></pre> <p>To stop receiving log messages from the log message system of the Framegrabber SDK:</p> <ol> <li>To disable forwarding log messages, call <code>SisoLog_SetMode()</code> and pass <code>SISOLOG_MODE_OFF</code>.</li> <li>Unregister the callback function by calling <code>SisoLog_RegisterLogMsgCallback()</code> and pass <code>nullptr</code> for both the callback function and the user context pointer.</li> <li>Before terminating the application, call <code>SisoLog_FreeLibrary()</code>.</li> </ol>"},{"location":"logging-events-micro-display-x.html","title":"Logging Events (microDisplay X)","text":"<p>You have the option to log events that take place on the frame grabber. This is especially interesting if you want to test the trigger system you have set up.</p> <ol> <li>Start microDisplay X.</li> <li>Load an applet as described in Initial System Test.</li> <li> <p>Under Applet Layout/Global, click Grabber Events.</p> <p></p> </li> <li> <p>Under Parameter Selection, select the events you want to have logged.In the example below, the events start of frame and end of frame on camera port A are selected for being logged:</p> <p></p> </li> <li> <p>Start image acquisition.The log is visible in the logging pane below the Grabber Events tab:</p> <p></p> <p>If you switch to another tab in the logging frame, the number of grabber events you missed after leaving tab Grabber Events is displayed directly on the tab:</p> <p></p> </li> </ol> <p>Info</p> <p>To read individual lines of the log while the logging is taking place, you can stop the running through of lines. Right-click the lines. In the context menu, click Auto Scrolling Enabled to stop auto scrolling.</p> <p></p>"},{"location":"managing-applets-micro-diagnostics.html","title":"Managing Applets (microDiagnostics)","text":""},{"location":"managing-applets-micro-diagnostics.html#configuring-the-frame-grabber","title":"Configuring the Frame Grabber","text":"<p>How to configure the frame grabber depends on your frame grabber model. See the sections below.</p> <p>When is an applet available?</p> <ul> <li>On imaWorx and imaFlex frame grabbers, an applet is available as soon as it is available in the file system of your computer (Framegrabber SDK installation directory, sub-directories DLL or Hardware Applets). If the applet isn't there, run the applet installer that contains the applet you want to use, or, if you need an applet created with VisualApplets, copy the applet file (*.hap) into the Hardware Applets folder of your Framegrabber SDK installation (e.g., <code>...\\Basler\\FramegrabberSDK5.x.x\\Hardware Applets\\*.hap</code>).</li> <li>On marathon frame grabbers, an applet is available as soon as it is flashed onto the frame grabber. If the applet you want to use isn't flashed on the frame grabber yet, flash it according to the instructions in Flashing Applets onto marathon Frame Grabbers.</li> </ul>"},{"location":"managing-applets-micro-diagnostics.html#which-applets-are-available","title":"Which Applets are Available?","text":"<p>To see which applets are flashed onto the frame grabber:</p> <ol> <li>Start microDiagnostics (e.g. <code>[Framegrabber SDK installation directory]/bin/microDiagnostics.exe</code>).</li> <li>In microDiagnostics, select the the frame grabber device you want to install the applets on.</li> <li> <p>Click Manage Firmware/Applet(s) in the toolbar.</p> <p></p> </li> <li> <p>In the lower part of the program window, the applets currently flashed on the frame grabber are listed:</p> <p></p> </li> </ol> <p>Info</p> <p>If the applet you want to use for configuring the FPGA isn't available on partitions 1\u20137, you must flash this applet onto the frame grabber. See Flashing Applets onto marathon Frame Grabbers.</p> <p>The applets are marked as follows:</p> Icon Meaning This is the currently active applet, i.e., the applet the frame grabber is configured with at the moment. The frame grabber will be configured with this applet at system start (boot partition). This applet is available in the file system (in the same version). No newer version available in the file system. This applet isn't available in the file system (or in another version than the one that is flashed on the frame grabber). This is the SAVE Configuration, a fall back option. In case a problem occurs with the active configuration (i.e., during flashing), the frame grabber uses this configuration. The SAVE Configuration is always stored on partition 0."},{"location":"managing-applets-micro-diagnostics.html#changing-the-active-applet","title":"Changing the Active Applet","text":"<p>If you want to configure the FPGA on the frame grabber with an applet other than the active applet, proceed as follows:</p> <ol> <li>Right-click into the line listing the applet you want to use for FPGA configuration.</li> <li>From the context menu, select Activate Now.</li> </ol> <p></p> <p>Info</p> <p>If you encounter problems during FPGA configuration, refer to Crash Protection.</p> <p>If your computer supports live reconfiguration of the FPGA (see chipset lists below), you get one of the following messages (A or B):</p>"},{"location":"managing-applets-micro-diagnostics.html#message-a-please-restart-all-applications-using-the-board","title":"Message A: \"Please restart all applications using the board\"","text":"<p>Close all applications of the Framegrabber SDK (microDisplay/microDisplay X, microDiagnostics, GenICam Explorer).</p> <p>After re-opening the Framegrabber SDK programs, the programs will provide access to the applet you defined to be the active one. You can continue with configuring the applet via microDisplay X or via Framegrabber API.</p> <p>Info</p> <p>High-end mainboards with server level chipset support this behavior. The following chipsets are known to support FPGA live configuration without reboot in some mainboards:</p> <ul> <li>Intel X58 Express</li> <li>Intel X79 Express</li> <li>Intel Z87 (Z99)</li> </ul> <p>We don't guarantee behavior A with the aforementioned chipsets.</p>"},{"location":"managing-applets-micro-diagnostics.html#message-b-you-should-reboot-your-computer-for-the-changes-to-be-completed","title":"Message B: \"You should reboot your computer for the changes to be completed\"","text":"<p>After selecting the new applet to be the active one, the PCI speed is reduced. To get the full PCI bandwidth when using this applet, you must reboot your computer.</p> <p>After reboot, you get the full bandwidth on the PCI interface. The Framegrabber SDK programs will provide access to the applet. You can continue with configuring this applet via microDisplay X or via API.</p> <p>Info</p> <p>High-end mainboards with server level chipset support this behavior. The following chipsets are known to support FPGA live configuration without reboot in some mainboards:</p> <ul> <li>Intel X58 Express</li> <li>Intel X79 Express</li> <li>Intel Z87 (Z99)</li> </ul> <p>We don't guarantee behavior B with the aforementioned chipsets.</p> <p>Info</p> <p>Activating a partition (i.e., reconfiguring the FPGA with a new applet) on the frame grabber will result in the following system behavior if the Generic Service (gs) is used to manage camera connections:</p> <p>The Generic Service (gs) is re-started for all frame grabbers in the host computer that use the service. Depending on the number of boards installed in the host, this may take some time. The camera connections on all frame grabbers connected to the host computer are reset. The cameras need to be re-discovered.</p> <p>During restart of the Generic Service (gs) , all GUI applications (microDisplay/microDisplay X, microDiagnostics, GenICam Explorer) will appear as \"Not Responding\".</p>"},{"location":"managing-applets-micro-diagnostics.html#setting-the-boot-partition","title":"Setting the Boot Partition","text":"<p>On microEnable 5 marathon frame grabbers, the boot partition contains the applet that is used for frame grabber configuration at system start. To select which partition is used as boot partition, proceed as follows:</p> <ol> <li>Open microDiagnostics.</li> <li>Click the Manage Firmware/Applet(s) button or from menu Tools, select menu item Manage Applets.</li> <li>Right-click into the line listing the applet you want to use for FPGA configuration.</li> <li>From the context menu, select Set as Boot Partition.</li> </ol> <p></p>"},{"location":"managing-applets-micro-diagnostics.html#loading-applets-onto-imaworx-cxp-12-quad","title":"Loading Applets onto imaWorx CXP-12 Quad","text":"<p>On imaWorx CXP-12 Quad all delivered applets already are on the imaWorx CXP-12 Quad frame grabber, but only one is activated. If you want to activate a different applet on the imaWorx CXP-12 Quad, follow the instructions to Activate the Applet.</p>"},{"location":"managing-applets-micro-diagnostics.html#flashing-applets-onto-marathon-frame-grabbers","title":"Flashing Applets onto marathon Frame Grabbers","text":"<p>Info</p> <p>If you got an individual applet not in form of an installer, but as a single HAP file from an external source: Make sure you received the applet as a ZIP archive.</p> <p>The applet file (HAP) has to be transferred from the VisualApplet developers machine savely protected in a ZIP archive. Otherwise, it may get corrupted under way. If you flash your frame grabber with a corrupted HAP file, the frame grabber configures its FPGA with the SAVE Configuration. Use of the SAVE Configuration is indicated by on-board SAVE LED giving read light. In this case, make sure you get an uncorrupted version of the HAP file you intend to use, and re-flash the frame grabber.</p>"},{"location":"managing-applets-micro-diagnostics.html#prerequisites","title":"Prerequisites","text":"<p>Before you can flash the frame grabber with an applet file (HAP or DLL), you must copy this file to the file system of your computer.</p> <p>Acquisition Applets that come as part of the Framegrabber SDK (DLL files) you have probably installed together with the Framegrabber SDK. If you want to flash individual applets (HAP files), copy them into <code>[Framegrabber SDK installation directory]/Hardware Applets</code>.</p>"},{"location":"managing-applets-micro-diagnostics.html#flashing","title":"Flashing","text":"<p>To flash applets onto the frame grabber:</p> <ol> <li>Close microDisplay X if open and make sure no instance of microDisplay X is open on your system.</li> <li>Start microDiagnostics (e.g., directly out of the installation directory <code>[Framegrabber SDK installation directory]/bin/microDiagnostics.exe</code>)</li> <li> <p>In microDiagnostics, select the frame grabber device you want to install the applets on:</p> <p></p> </li> <li> <p>Click the button Manage Firmware/Applet(s).</p> <p>In the lower part of the program window, the firmware currently flashed on the board is listed:</p> <p></p> <p>The frame grabber offers up to 8 partitions for applets (depending on the frame grabber model you are using). Each partition contains one applet. On partition 0, the SAVE Configuration is stored. For partitions (1 to 7), you can define which applets you want to store there.</p> <p></p> <p>You can use any of the applets you flashed onto partitions 1 to 7 for frame grabber (FPGA) configuration. To switch between these applets doesn't require new flashing. (How to switch, see Changing the Active Applet .</p> <p>The applets are marked as follows:</p> Icon Meaning This is the currently active applet, i.e., the applet the frame grabber is configured with at the moment. The frame grabber will be configured with this applet at system start (boot partition). This applet is available in the file system (in the same version). No newer version available in the file system. This applet isn't available in the file system (or in another version than the one that is flashed on the frame grabber). This is the SAVE Configuration, a fall back option. In case a problem occurs with the active configuration (i.e., during flashing), the frame grabber uses this configuration. The SAVE Configuration is always stored on partition 0. <p>To flash a partition with an applet, or to re-flash a partition with another applet:</p> </li> <li> <p>Click the Load new applet button.</p> <p></p> <p>The program leads you to a file selection dialog.</p> </li> <li> <p>Select the desired applet (DLL or HAP file) and click Open.The selected file is displayed now for the partition. The selected file is highlighted in yellow.</p> <p></p> </li> <li> <p>Continue and select applets for all partitions you want to flash.</p> </li> <li>Repeat steps 3 to 7 for all the frame grabbers in your system you want to flash.</li> <li>Click the Flash Now button.The Flash Dialog dialog opens.</li> <li>Check if stated selected board and firmware version are the ones you intend to flash.</li> <li>Click on Flash. The flashing process starts. One applet is installed after another (per board).</li> <li>Wait until all applets are completely installed. You will get an according message.</li> </ol> <p>Info</p> <p>Flashing an active partition on the frame grabber will result in the following system behavior if the Generic Service (gs) is used to manage camera connections:</p> <ul> <li>The Generic Service (gs) is re-started for all frame grabbers in the host computer that use the service. Depending on the number of boards installed in the host, this may take some time.</li> <li>The camera connections on all frame grabbers connected to the host computer are reset. The cameras need to be re-discovered.</li> <li>During restart of the Generic Service (gs), all GUI applications (microDisplay X, microDiagnostics, GenICam Explorer) will appear as \"Not Responding\".</li> </ul>"},{"location":"managing-applets-micro-diagnostics.html#after-flashing-non-active-partitions","title":"After Flashing Non-Active Partitions","text":"<p>If you flashed only partitions that did not contain the currently active applet, you will get the following message: Flashing Done.</p> <p>In this case, you are done with flashing and can continue with other activities, e.g., with configuring the FPGA on the frame grabber.</p>"},{"location":"managing-applets-micro-diagnostics.html#after-flashing-active-partitions","title":"After Flashing Active Partitions","text":"<p>If you flashed the partition that did contain the active applet, and if your computer supports live reconfiguration of the FPGA (see chipset lists below), you get one of the following messages (A, B or C) after flashing:</p>"},{"location":"managing-applets-micro-diagnostics.html#message-a-please-restart-all-applications-using-the-board_1","title":"Message A: \"Please restart all applications using the board.\"","text":"<p>The applets have been flashed successfully.</p> <p>Close all applications of the Basler Framegrabber SDK (microDisplay/microDisplay X, microDiagnostics, GenICam Explorer).</p> <p>After re-opening the Framegrabber SDK programs, the programs will provide access to the applet you flashed onto the active partition of the FPGA. You can continue with configuring the applet via microDisplay X or via Framegrabber API.</p> <p>Info</p> <p>High-end mainboards with server level chipset support this behavior. The following chipsets are known to support FPGA live configuration without reboot in some mainboards:</p> <ul> <li>Intel X58 Express</li> <li>Intel X79 Express</li> <li>Intel Z87 (Z99)</li> </ul> <p>We don't guarantee behavior A with the aforementioned chipsets.</p>"},{"location":"managing-applets-micro-diagnostics.html#message-b-you-should-reboot-your-computer-for-the-changes-to-be-completed_1","title":"Message B: \"You should reboot your computer for the changes to be completed.\"","text":"<p>The applets have been flashed successfully, but due to the new applet on the active partition of the FPGA, the PCI speed is reduced after flashing. To get the full PCI bandwidth when using this applet, you must reboot your computer:</p> <p>Reboot your computer to get the full PCI bandwidth.</p> <p>After re-boot, you get the full bandwidth on the PCI interface. The Framegrabber SDK programs will provide access to the applet you flashed onto the active partition of the FPGA. You can continue with configuring this applet via microDisplay X or via Framegrabber API.</p> <p>Info</p> <p>High-end mainboards with server level chipset support this behavior. The following chipsets are known to support FPGA live configuration without reboot in some mainboards:</p> <ul> <li>Intel X58 Express</li> <li>Intel X79 Express</li> <li>Intel Z87 (Z99)</li> </ul> <p>We don't guarantee behavior B with the aforementioned chipsets.</p>"},{"location":"managing-applets-micro-diagnostics.html#message-c-you-must-reboot-your-computer-for-the-changes-to-take-effect","title":"Message C: \"You must reboot your computer for the changes to take effect.\"","text":"<p>The applets have been successfully flashed, also the one that has been flashed onto the active partition of the frame grabber. To configure the applet on the active partition, you must reboot your computer.</p> <p>After re-boot, the Framegrabber SDK programs will provide access to the applet on the active partition. You can continue with configuring this applet via microDisplay X or via Framegrabber API.</p> <p>Info</p> <p>The following chipsets are known to require a reboot after FPGA configuration:</p> <ul> <li>Intel C220</li> <li>Intel H87</li> </ul>"},{"location":"marathon-acl.html","title":"marathon ACL","text":"<p>marathon ACL is a Camera Link frame grabber. When connected to the computer power supply, marathon ACL supports Power over Camera Link (PoCL SafePower 4W/12V per port).</p> <p>Depending on the applets you are running on the board, you may need to enable the PoCL support via microDiagnostics. The automatic PoCL detection is disabled per default on marathon ACL when running standard applets version 2.0 or higher, or when running individual applets created with VisualApplets version 3.0.6 or higher. When you use PoCL cameras together with such applets, you must enable automatic PoCL detection. This is possible in microDiagnostics (runtime version 5.5.1 or higher). For details, see Enabling PoCL Support.</p> <p></p> <p>To install the marathon ACL in your computer, plug it into a PCIe Gen. 2 x4 slot or higher. The following image shows a marathon ACL with two Camera Link cameras connected:</p> <p></p>"},{"location":"marathon-acl.html#image-processing","title":"Image Processing","text":"<p>Image processing functionality is available on request. If you are interested, contact Basler Support.</p>"},{"location":"marathon-acl.html#production-line-integration","title":"Production Line Integration","text":"<p>For integration into a production line, marathon ACL offers multiple general purpose inputs and outputs. Depending on the hardware add-ons used, 4 to 20 GPIOs are available, also galvanically isolated.</p> <p>These GPIOs enable you to do the following:</p> <ul> <li>Control peripheral devices by sending trigger signals, e.g. lighting signals and cameras signals.</li> <li>Receive various trigger signals from peripheral devices, e.g., shaft encoders and light barriers.</li> <li>Synchronize multiple marathon ACL frame grabbers</li> <li>Synchronize connected devices.</li> </ul> <p></p> <p>Communication between camera and marathon ACL is realized via  serial interface and four CC signals per Camera Link cable.</p>"},{"location":"marathon-acl.html#software-programming-and-configuration-interface","title":"Software Programming and Configuration Interface","text":"<p>marathon ACL offers an easy-to-use API. The Framegrabber API allows to integrate the frame grabber into any image processing application. You can use the Framegrabber API to write code in the following languages:</p> <ul> <li>C/C++</li> <li>C# (wrapper available)</li> <li>Python (wrapper available)</li> </ul> <p>For more information about the Framegrabber API, see the Framegrabber API documentation.</p> <p>Alternatively, you can use Basler's GenTL Interface to develop your application in form of a GenTL consumer. For more information about the Basler GenTL Interface, see GenTL Interface documentation.</p>"},{"location":"marathon-acl.html#connectors-and-leds","title":"Connectors and LEDs","text":""},{"location":"marathon-acl.html#connectors","title":"Connectors","text":"<p>marathon ACL has the following connectors:</p> <p></p>"},{"location":"marathon-acl.html#configuration-switch","title":"Configuration Switch","text":"<p>marathon ACL offers an on-board configuration switch for activating a fall-back FPGA configuration, called SAVE configuration. For details regarding the SAVE configuration, see FPGA Fall-Back Configuration.</p> <p></p>"},{"location":"marathon-acl.html#leds-on-the-board","title":"LEDs on the Board","text":"<p>marathon ACL provides the following LEDs on the board:</p> <p></p> LED Name LED Color Meaning TRG_PWR Green Front GPIO is connected to external power (power IN). SAVE RED SAVE configuration is used for FPGA configuration READY Orange The FPGA has been configured successfully and is ready for operation. LED READY also gives light when SAVE configuration is used on FPGA. PGOOD Orange PGOOD=Power Good All voltages are applied correctly. CL A Orange Port A is connected to a camera that provides a clock. CL B Orange Port B is connected to a camera that provides a clock. PoCL A Green Power over Camera Link active on port A: Camera on port A is provided with power by frame grabber via Camera Link cable. PoCL B Green Power over Camera Link active on port B: Camera on port B is provided with power by frame grabber via Camera Link cable. USR1 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. USR2 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. PWR Green Frame grabber gets 12 VDC IN via PCIe interface."},{"location":"marathon-acl.html#specifications","title":"Specifications","text":"marathon ACL Order Number 2200000358 Host Interface PCIe Gen 2 x4 (Direct Memory Access) Bandwidth (typ./max.) Up to 1.8 GB/s sustainable data bandwidth (maximal Camera Link data rate 850 MByte/s) On-Board Memory 512 MByte DDR3-RAM Power Supply (Input) / Current PCIe Slot 12 VDC (\u00b15 %) / &lt;1.5 A (actual values depend on processing) PoCXP Supply (Output) 4 W of 12 VDC regulated power per each Camera Link connector Power Consumption Typ. 1 A @ 12 VDC (actual values depend on processing) Size (L x H) PCIe standard heightHalf length card:167.64 mm x 111.15 mm Weight 200 g Camera Interface 2 x Camera Link 2.0 standard (2 * SDR 26) (mini CL) Ambient Temperature 50 \u00b0C (0 LFM<sup>a</sup>)60 \u00b0C (100 LFM<sup>a</sup>)An adequate airflow in the computer is recommended. FPGA Operating Temperature<sup>b</sup> 0\u201385 \u00b0C at 100 LFM<sup>a</sup> Storage Temperature -50\u201380 \u00b0C Humidity during Operation 5\u201390 % non-condensing Humidity during Storage 5\u201395 % Compliance CE, FCC, UKCA, RoHS <ol> <li> <p>LFM = Linear Feet per Minute, unit for measuring airflow velocity.\u00a0\u21a9\u21a9\u21a9</p> </li> <li> <p>Temperature being measured directly on the FPGA. You can read out the measured value in all applets that are available for marathon ACL via the applet parameter <code>FG_SYSTEMMONITOR_FPGA_TEMPERATURE</code>.\u00a0\u21a9</p> </li> </ol> <p>Info</p> <p>The PCIe bus data throughput depends on the mainboard, the chip set, and the BIOS configuration of the host computer. The number of installed PCIe boards also affects the throughput, e.g. a PCIe x4 connector may support only x1 performance. Always check the mainboard manual thoroughly to be sure.</p>"},{"location":"marathon-acl.html#the-front-gpio-connector","title":"The Front GPIO Connector","text":"<p>The front GPIO connector covers the basic trigger setup of your frame grabber. Its trigger connector allows you to control peripheral devices (PLC) and to synchronize multiple marathon ACL boards.</p> <p></p> <p>The socket is located directly on the slot bracket:</p> <p></p> <p>In default configuration, the trigger connector of the front GPIO connector offers:</p> <ul> <li>3 differential input signals or 2 differential and 1 single-ended input signal in pull-up mode</li> <li>2 TTL output signals</li> </ul> <p>Info</p> <p>You can configure the pin assignment of the front GPIO connector to provide different input signals, e.g.:</p> <ul> <li>Pull-down</li> <li>4 single-ended signals (and no differential signals).</li> </ul> <p>To change the GPIO configuration, use the command line tool installed with the Framegrabber SDK.</p> <p>For more information, see Input Configuration and gpioTool.</p>"},{"location":"marathon-acl.html#pin-layout-of-the-front-gpio-connector","title":"Pin Layout of the Front GPIO Connector","text":"PIN Number (3P FPGA) Galvanically Isolated Signal Reference Signal 1 No GPO 0 (TTL) 5 VDC / global GND (pin 6) 2 No GPO 1 (TTL) 5 VDC / global GND (pin 6) 3 No Reserved for RS 485 (GND) 4 No Reserved for RS 485 5 No \u2014 6 No GND (global GND) 7 No 5 V_OUT (0.5 A max) 8 Yes GPI 2 (GPI2+ if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 9 Yes GPI 3 (GPI2- if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 10 Yes GPI voltage IN (4.5\u201328 VDC) 11 Yes GPI 0+ GPI voltage IN (pin 10) / GPI GND (pin 15) 12 Yes GPI 0- GPI voltage IN (pin 10) / GPI GND (pin 15) 13 Yes GPI 1+ GPI voltage IN (pin 10) / GPI GND (pin 15) 14 Yes GPI 1- GPI voltage IN (pin 10) / GPI GND (pin 15) 15 Yes GPI GND"},{"location":"marathon-acl.html#extra-voltage-ingnd-for-galvanically-isolated-circuit","title":"Extra Voltage IN/GND for Galvanically Isolated Circuit","text":"<p>All General Purpose Inputs (GPIs) of the front GPIO connector are galvanically isolated. The incoming signals are transferred to the frame grabber via digital isolators. This way, the frame grabber is securely protected against high incoming voltages.</p> <p>However, to operate the internal GPI circuits, you must connect a voltage source and ground: On pin 10, you apply the voltage (GPI voltage IN) that serves as operating voltage for the internal operational amplifiers. On pin 15, you connect the according ground (GPI GND).</p> <p>Supply Voltage Required</p> <p>The marathon ACL trigger system needs to get supply voltage on the GPI Voltage IN pin (pin 10). If you want to connect devices that have no PWR pin, you must provide the power supply to the GPI Voltage IN pin (pin 10) from an external source.</p>"},{"location":"marathon-acl.html#possible-topologies","title":"Possible Topologies","text":"<p>You can operate marathon ACL as follows:</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Topology 1 1 2 Bayer Pattern 1 1 2 Grayscale 1 1 2 RGB 1 2 2 Bayer Pattern 1 2 2 Grayscale 1 2 2 RGB 2 1 2 Bayer Pattern 2 1 2 Grayscale 2 1 2 RGB <p>To find out which topology you can use with which applet, refer to Choosing the Right Area Scan Applet or Choosing the Right Line Scan Applet.</p>"},{"location":"marathon-acl.html#acquisition-applets","title":"Acquisition Applets","text":"<p>To ensure optimum use of system resources, not all image acquisition and processing features designed for marathon ACL are loaded onto marathon ACL simultaneously.</p> <p>Instead, Basler provides various compilations of specific image acquisition and processing features that are combined to meet the requirements of a specific application field.</p> <p>Typically, an applet supports a specific camera interface standard and topology, specific image acquisition features, and possibly specific image (pre-)processing features.</p> <p>Applets come in .dll files.</p> <p>Refer to Acquisition Applets for marathon ACL for more detailed information about applets and their dependency on the topology used.</p>"},{"location":"marathon-acx-dp.html","title":"marathon ACX-DP","text":"<p>marathon ACX-DP is a CXP-6 frame grabber. When connected to the computer power supply, marathon ACX-DP supports Power over CXP (PoCXP).</p> <p></p> <p>To install the marathon ACX-DP in your computer, plug it into a PCIe Gen. 2 x4 slot or higher. The following image shows a marathon ACX-DP with two cameras connected:</p> <p></p>"},{"location":"marathon-acx-dp.html#image-processing","title":"Image Processing","text":"<p>Image processing functionality is available on request. If you are interested, contact Basler Support.</p>"},{"location":"marathon-acx-dp.html#production-line-integration","title":"Production Line Integration","text":"<p>For integration into a production line, marathon ACX-DP offers multiple general purpose inputs and outputs. 4 to 20 of the GPIOs (depending on the hardware add-ons used) are galvanically isolated.</p> <p>These GPIOs enable you to do the following:</p> <ul> <li>Control peripheral devices by sending trigger signals, e.g. lighting signals and cameras signals.</li> <li>Receive various trigger signals from peripheral devices, e.g., shaft encoders and light barriers.</li> <li>Synchronize multiple marathon ACX-DP frame grabbers.</li> <li>Synchronize connected devices.</li> </ul> <p></p>"},{"location":"marathon-acx-dp.html#software-programming-and-configuration-interface","title":"Software Programming and Configuration Interface","text":"<p>marathon ACX-DP offers an easy-to-use API. The Framegrabber API allows to integrate the frame grabber into any image processing application. You can use the Framegrabber API to write code in the following languages:</p> <ul> <li>C/C++</li> <li>C# (wrapper available)</li> <li>Python (wrapper available)</li> </ul> <p>For more information about the Framegrabber API, see the Framegrabber API documentation.</p> <p>Alternatively, you can use Basler's GenTL Interface to develop your application in form of a GenTL consumer. For more information about the Basler GenTL Interface, see GenTL Interface documentation.</p>"},{"location":"marathon-acx-dp.html#connectors-and-leds","title":"Connectors and LEDs","text":""},{"location":"marathon-acx-dp.html#connectors","title":"Connectors","text":"<p>marathon ACX-DP has the following connectors:</p> <p></p>"},{"location":"marathon-acx-dp.html#configuration-switch","title":"Configuration Switch","text":"<p>In addition to its ports, marathon ACX-DP offers an on-board configuration switch for activating a fall-back FPGA configuration, called SAVE configuration. For details regarding the SAVE configuration, see FPGA Fall-Back Configuration.</p> <p></p>"},{"location":"marathon-acx-dp.html#leds-on-the-slot-bracket","title":"LEDs on the Slot Bracket","text":"<p>There is one LED located on the slot bracket of marathon ACX-DP that indicate the state of the CXP link:</p> <p></p> <p> Connection at CXP link ready for operation</p> <p> No connection at CXP link</p>"},{"location":"marathon-acx-dp.html#leds-on-the-board","title":"LEDs on the Board","text":"LED Name LED Color Meaning TRG_PWR Green Front GPIO is connected to external power (power IN). SAVE RED SAVE configuration is used for FPGA configuration READY Orange The FPGA has been configured successfully and is ready for operation. LED READY also gives light when SAVE configuration is used on FPGA. PGOOD Orange PGOOD=Power Good All voltages are applied correctly. 1 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. 2 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. 3 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. 4 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. PWR (upper LED) Green Frame grabber gets 12 VDC IN via PCIe interface. PWR (lower LED) Green Frame grabber gets voltage IN via the computer power supply connector for powering the cameras via CXP cable."},{"location":"marathon-acx-dp.html#specifications","title":"Specifications","text":"marathon ACX-DP Order Number 2200000355 Host Interface PCIe Gen 2 x4 (Direct Memory Access) Bandwidth (typ./max.) Up to 1.8 GB/s sustainable data bandwidth On-Board Memory 1 GByte DDR3-RAM Power Supply (Input) / Current PCIe Slot 12 VDC (\u00b15 %) / &lt;1.5 A (actual values depend on processing) Power Supply (Input) / Current PCIe 6-pin Connector 12 VDC (\u00b15 %) / &lt;6.5 A (actual values depend on connected PoCXP cameras) PoCXP Supply (Output) 17 W of 24 VDC regulated power per CoaXPress connector Power Consumption Typ. 0.96 A @ 12 VDC (actual values depend on processing), max load ca. 2.15 A Size (L x H) PCIe standard heightHalf length card:167.64 mm x 111.15 mm Weight 200 g Camera Interface 2 x CXP-6 (CXP-1 to CXP-6, DIN connectors) Ambient Temperature 50 \u00b0C (0 LFM<sup>a</sup>)60 \u00b0C (100 LFM<sup>a</sup>)An adequate airflow in the computer is recommended. FPGA Operating Temperature<sup>b</sup> 0\u201385 \u00b0C at 100 LFM<sup>a</sup> Storage Temperature -50\u201380 \u00b0C Humidity during Operation 5\u201390 % non-condensing Humidity during Storage 5\u201395 % Compliance CE, RoHS, UKCA <ol> <li> <p>LFM = Linear Feet per Minute, unit for measuring airflow velocity.\u00a0\u21a9\u21a9\u21a9</p> </li> <li> <p>Temperature being measured directly on the FPGA. You can read out the measured value in all applets that are available for marathon ACX-DP via the applet parameter <code>FG_SYSTEMMONITOR_FPGA_TEMPERATURE</code>.\u00a0\u21a9</p> </li> </ol> <p>Info</p> <p>The PCIe bus data throughput depends on the mainboard, the chip set, and the BIOS configuration of the host computer. The number of installed PCIe boards also affects the throughput, e.g. a PCIe x8 connector may support only x4 performance. Always check the mainboard manual thoroughly to be sure.</p>"},{"location":"marathon-acx-dp.html#the-front-gpio-connector","title":"The Front GPIO Connector","text":"<p>The front GPIO connector covers the basic trigger setup of your frame grabber. Its trigger connector allows you to control peripheral devices (PLC) and to synchronize multiple marathon ACX-DP boards.</p> <p></p> <p>The socket is located directly on the slot bracket:</p> <p></p> <p>In default configuration, the trigger connector of the front GPIO connector offers:</p> <ul> <li>3 differential input signals or 2 differential and 1 single-ended input signal in pull-up mode</li> <li>2 TTL output signals</li> </ul> <p>Info</p> <p>You can configure the pin assignment of the front GPIO connector to provide different input signals, e.g.:</p> <ul> <li>Pull-down</li> <li>4 single-ended signals (and no differential signals).</li> </ul> <p>To change the GPIO configuration, use the command line tool installed with the Framegrabber SDK.</p> <p>For more information, see Input Configuration and gpioTool.</p>"},{"location":"marathon-acx-dp.html#pin-layout-of-the-front-gpio-connector","title":"Pin Layout of the Front GPIO Connector","text":"PIN Number (3P FPGA) Galvanically Isolated Signal Reference Signal 1 No GPO 0 (TTL) 5 VDC / global GND (pin 6) 2 No GPO 1 (TTL) 5 VDC / global GND (pin 6) 3 No Reserved for RS 485 (GND) 4 No Reserved for RS 485 5 No \u2014 6 No GND (global GND) 7 No 5 V_OUT (0.5 A max) 8 Yes GPI 2 (GPI2+ if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 9 Yes GPI 3 (GPI2- if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 10 Yes GPI voltage IN (4.5\u201328 VDC) 11 Yes GPI 0+ GPI voltage IN (pin 10) / GPI GND (pin 15) 12 Yes GPI 0- GPI voltage IN (pin 10) / GPI GND (pin 15) 13 Yes GPI 1+ GPI voltage IN (pin 10) / GPI GND (pin 15) 14 Yes GPI 1- GPI voltage IN (pin 10) / GPI GND (pin 15) 15 Yes GPI GND"},{"location":"marathon-acx-dp.html#extra-voltage-ingnd-for-galvanically-isolated-circuit","title":"Extra Voltage IN/GND for Galvanically Isolated Circuit","text":"<p>All General Purpose Inputs (GPIs) of the front GPIO connector are galvanically isolated. The incoming signals are transferred to the frame grabber via digital isolators. This way, the frame grabber is securely protected against high incoming voltages.</p> <p>However, to operate the internal GPI circuits, you must connect a voltage source and ground: On pin 10, you apply the voltage (GPI voltage IN) that serves as operating voltage for the internal operational amplifiers. On pin 15, you connect the according ground (GPI GND).</p> <p>Supply Voltage Required</p> <p>The marathon ACX-DP trigger system needs to get supply voltage on the GPI Voltage IN pin (pin 10). If you want to connect devices that have no PWR pin, you must provide the power supply to the GPI Voltage IN pin (pin 10) from an external source.</p>"},{"location":"marathon-acx-dp.html#possible-topologies","title":"Possible Topologies","text":"<p>You can operate marathon ACX-DP as follows:</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Topology 1 2 2 Bayer Pattern 1 2 2 Grayscale 1 2 2 RGB 2 1 2 Bayer Pattern 2 1 2 Grayscale 2 1 2 RGB <p>When connected to the computer power supply via the PCIe 6-pin connector, which always provides 12 V, marathon ACX-DP supports Power over CXP (PoCXP).</p> <p>Info</p> <p>If you are going to use multiple imaFlex CXP-12 Quad boards in one host computer, make sure you have one PCIe Gen. 3.0 x8 slot or higher per board available in the host computer. For more information, see Using Multiple Boards in one Host.</p> <p>To find out which topology you can use with which applet, refer to Choosing the Right Area Scan Applet or Choosing the Right Line Scan Applet.</p>"},{"location":"marathon-acx-dp.html#acquisition-applets","title":"Acquisition Applets","text":"<p>To ensure optimum use of system resources, not all image acquisition and processing features designed for marathon ACX-DP are loaded onto marathon ACX-DP simultaneously.</p> <p>Instead, Basler provides various compilations of specific image acquisition and processing features that are combined to meet the requirements of a specific application field.</p> <p>Typically, an applet supports a specific camera interface standard and topology, specific image acquisition features, and possibly specific image (pre-)processing features.</p> <p>Applets come in .dll files.</p> <p>Refer to Acquisition Applets for marathon ACX-DP for more detailed information about applets and their dependency on the topology used.</p>"},{"location":"marathon-acx-qp.html","title":"marathon ACX-QP","text":"<p>marathon ACX-QP is a CXP-6 frame grabber. When connected to the computer power supply, marathon ACX-QP supports Power over CXP (PoCXP).</p> <p></p> <p>To install the marathon ACX-QP in your computer, plug it into a PCIe Gen. 2 x4 slot or higher. The following image shows a marathon ACX-QP with two cameras connected:</p> <p></p>"},{"location":"marathon-acx-qp.html#image-processing","title":"Image Processing","text":"<p>Image processing functionality is available on request. If you are interested, contact Basler Support.</p>"},{"location":"marathon-acx-qp.html#production-line-integration","title":"Production Line Integration","text":"<p>For integration into a production line, marathon ACX-QP offers multiple general purpose inputs and outputs. 4 to 20 of the GPIOs (depending on the hardware add-ons used) are galvanically isolated.</p> <p>These GPIOs enable you to do the following:</p> <ul> <li>Control peripheral devices by sending trigger signals, e.g. lighting signals and cameras signals.</li> <li>Receive various trigger signals from peripheral devices, e.g., shaft encoders and light barriers.</li> <li>Synchronize multiple marathon ACX-QP frame grabbers.</li> <li>Synchronize connected devices.</li> </ul> <p></p>"},{"location":"marathon-acx-qp.html#software-programming-and-configuration-interface","title":"Software Programming and Configuration Interface","text":"<p>marathon ACX-QP offers an easy-to-use API. The Framegrabber API allows to integrate the frame grabber into any image processing application. You can use the Framegrabber API to write code in the following languages:</p> <ul> <li>C/C++</li> <li>C# (wrapper available)</li> <li>Python (wrapper available)</li> </ul> <p>For more information about the Framegrabber API, see the Framegrabber API documentation.</p> <p>Alternatively, you can use Basler's GenTL Interface to develop your application in form of a GenTL consumer. For more information about the Basler GenTL Interface, see GenTL Interface documentation.</p>"},{"location":"marathon-acx-qp.html#connectors-and-leds","title":"Connectors and LEDs","text":""},{"location":"marathon-acx-qp.html#connectors","title":"Connectors","text":"<p>marathon ACX-QP has the following connectors:</p> <p></p>"},{"location":"marathon-acx-qp.html#configuration-switch","title":"Configuration Switch","text":"<p>In addition to its ports, marathon ACX-QP offers an on-board configuration switch for activating a fall-back FPGA configuration, called SAVE configuration. For details regarding the SAVE configuration, see FPGA Fall-Back Configuration.</p> <p></p>"},{"location":"marathon-acx-qp.html#leds-on-the-slot-bracket","title":"LEDs on the Slot Bracket","text":"<p>There is one LED located on the slot bracket of marathon ACX-QP that indicate the state of the CXP link:</p> <p></p> <p> Connection at CXP link ready for operation</p> <p> No connection at CXP link</p>"},{"location":"marathon-acx-qp.html#leds-on-the-board","title":"LEDs on the Board","text":"LED Name LED Color Meaning TRG_PWR Green Front GPIO is connected to external power (power IN). SAVE RED SAVE configuration is used for FPGA configuration READY Orange The FPGA has been configured successfully and is ready for operation. LED READY also gives light when SAVE configuration is used on FPGA. PGOOD Orange PGOOD=Power Good All voltages are applied correctly. 1 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. 2 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. 3 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. 4 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. PWR (upper LED) Green Frame grabber gets 12 VDC IN via PCIe interface. PWR (lower LED) Green Frame grabber gets voltage IN via the computer power supply connector for powering the cameras via CXP cable."},{"location":"marathon-acx-qp.html#specifications","title":"Specifications","text":"marathon ACX-QP Order Number 2200000354 Host Interface PCIe Gen 2 x4 (Direct Memory Access) Bandwidth (typ./max.) Up to 1.8 GB/s sustainable data bandwidth On-Board Memory 1 GByte DDR3-RAM Power Supply (Input) / Current PCIe Slot 12 VDC (\u00b15 %) / &lt;1.5 A (actual values depend on processing) Power Supply (Input) / Current PCIe 6-pin Connector 12 VDC (\u00b15 %) / &lt;6.5 A (actual values depend on connected PoCXP cameras) PoCXP Supply (Output) 17 W of 24 VDC regulated power per CoaXPress connector Power Consumption Typ. 1.075 A @ 12 VDC (actual values depend on image pre-processing), maximum load: 3.15 A (single supply over 4-pin power connector) Size (L x H) PCIe standard heightHalf length card:167.64 mm x 111.15 mm Weight 200 g Camera Interface 4 x CXP-6 (CXP-1 to CXP-6, DIN connectors) Ambient Temperature 50 \u00b0C (0 LFM<sup>a</sup>)60 \u00b0C (100 LFM<sup>a</sup>)An adequate airflow in the computer is recommended. FPGA Operating Temperature<sup>b</sup> 0\u201385 \u00b0C at 100 LFM<sup>a</sup> Storage Temperature -50\u201380 \u00b0C Humidity during Operation 5\u201390 % non-condensing Humidity during Storage 5\u201395 % Compliance CE, RoHS, UKCA <ol> <li> <p>LFM = Linear Feet per Minute, unit for measuring airflow velocity.\u00a0\u21a9\u21a9\u21a9</p> </li> <li> <p>Temperature being measured directly on the FPGA. You can read out the measured value in all applets that are available for marathon ACX-QP via the applet parameter <code>FG_SYSTEMMONITOR_FPGA_TEMPERATURE</code>.\u00a0\u21a9</p> </li> </ol> <p>Info</p> <p>The PCIe bus data throughput depends on the mainboard, the chip set, and the BIOS configuration of the host computer. The number of installed PCIe boards also affects the throughput, e.g. a PCIe x8 connector may support only x4 performance. Always check the mainboard manual thoroughly to be sure.</p>"},{"location":"marathon-acx-qp.html#the-front-gpio-connector","title":"The Front GPIO Connector","text":"<p>The front GPIO connector covers the basic trigger setup of your frame grabber. Its trigger connector allows you to control peripheral devices (PLC) and to synchronize multiple marathon ACX-QP boards.</p> <p></p> <p>The socket is located directly on the slot bracket:</p> <p></p> <p>In default configuration, the trigger connector of the front GPIO connector offers:</p> <ul> <li>3 differential input signals or 2 differential and 1 single-ended input signal in pull-up mode</li> <li>2 TTL output signals</li> </ul> <p>Info</p> <p>You can configure the pin assignment of the front GPIO connector to provide different input signals, e.g.:</p> <ul> <li>Pull-down</li> <li>4 single-ended signals (and no differential signals).</li> </ul> <p>To change the GPIO configuration, use the command line tool installed with the Framegrabber SDK.</p> <p>For more information, see Input Configuration and gpiotool.</p>"},{"location":"marathon-acx-qp.html#pin-layout-of-the-front-gpio-connector","title":"Pin Layout of the Front GPIO Connector","text":"PIN Number (3P FPGA) Galvanically Isolated Signal Reference Signal 1 No GPO 0 (TTL) 5 VDC / global GND (pin 6) 2 No GPO 1 (TTL) 5 VDC / global GND (pin 6) 3 No Reserved for RS 485 (GND) 4 No Reserved for RS 485 5 No \u2014 6 No GND (global GND) 7 No 5 V_OUT (0.5 A max) 8 Yes GPI 2 (GPI2+ if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 9 Yes GPI 3 (GPI2- if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 10 Yes GPI voltage IN (4.5\u201328 VDC) 11 Yes GPI 0+ GPI voltage IN (pin 10) / GPI GND (pin 15) 12 Yes GPI 0- GPI voltage IN (pin 10) / GPI GND (pin 15) 13 Yes GPI 1+ GPI voltage IN (pin 10) / GPI GND (pin 15) 14 Yes GPI 1- GPI voltage IN (pin 10) / GPI GND (pin 15) 15 Yes GPI GND"},{"location":"marathon-acx-qp.html#extra-voltage-ingnd-for-galvanically-isolated-circuit","title":"Extra Voltage IN/GND for Galvanically Isolated Circuit","text":"<p>All General Purpose Inputs (GPIs) of the front GPIO connector are galvanically isolated. The incoming signals are transferred to the frame grabber via digital isolators. This way, the frame grabber is securely protected against high incoming voltages.</p> <p>However, to operate the internal GPI circuits, you must connect a voltage source and ground: On pin 10, you apply the voltage (GPI voltage IN) that serves as operating voltage for the internal operational amplifiers. On pin 15, you connect the according ground (GPI GND).</p> <p>Supply Voltage Required</p> <p>The marathon ACX-QP trigger system needs to get supply voltage on the GPI Voltage IN pin (pin 10). If you want to connect devices that have no PWR pin, you must provide the power supply to the GPI Voltage IN pin (pin 10) from an external source.</p>"},{"location":"marathon-acx-qp.html#possible-topologies","title":"Possible Topologies","text":"<p>You can operate marathon ACX-QP as follows:</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Topology 1 4 4 Bayer Pattern 1 4 4 Grayscale 1 4 4 RGB 2 2 4 Bayer Pattern 2 2 4 Grayscale 2 2 4 RGB 4 1 4 Bayer Pattern 4 1 4 Grayscale 4 1 4 RGB <p>When connected to the computer power supply via the PCIe 6-pin connector, which always provides 12 V, marathon ACX-QP supports Power over CXP (PoCXP).</p> <p>Info</p> <p>If you are going to use multiple imaFlex CXP-12 Quad boards in one host computer, make sure you have one PCIe Gen. 3.0 x8 slot or higher per board available in the host computer. For more information, see Using Multiple Boards in one Host.</p> <p>To find out which topology you can use with which applet, refer to Choosing the Right Area Scan Applet or Choosing the Right Line Scan Applet.</p>"},{"location":"marathon-acx-qp.html#acquisition-applets","title":"Acquisition Applets","text":"<p>To ensure optimum use of system resources, not all image acquisition and processing features designed for marathon ACX-QP are loaded onto marathon ACX-QP simultaneously.</p> <p>Instead, Basler provides various compilations of specific image acquisition and processing features that are combined to meet the requirements of a specific application field.</p> <p>Typically, an applet supports a specific camera interface standard and topology, specific image acquisition features, and possibly specific image (pre-)processing features.</p> <p>Applets come in .dll files.</p> <p>Refer to Acquisition Applets for marathon ACX-QP for more detailed information about applets and their dependency on the topology used.</p>"},{"location":"marathon-acx-sp.html","title":"marathon ACX-SP","text":"<p>marathon ACX-SP is a CXP-6 frame grabber. When connected to the computer power supply, marathon ACX-SP supports Power over CXP (PoCXP).</p> <p></p> <p>To install the marathon ACX-SP in your computer, plug it into a PCIe Gen. 2 x4 slot or higher. The following image shows a marathon ACX-SP with one camera connected:</p> <p></p>"},{"location":"marathon-acx-sp.html#image-processing","title":"Image Processing","text":"<p>Image processing functionality is available on request. If you are interested, contact Basler Support.</p>"},{"location":"marathon-acx-sp.html#production-line-integration","title":"Production Line Integration","text":"<p>For integration into a production line, marathon ACX-SP offers multiple general purpose inputs and outputs. 4 to 20 of the GPIOs (depending on the hardware add-ons used) are galvanically isolated.</p> <p>These GPIOs enable you to do the following:</p> <ul> <li>Control peripheral devices by sending trigger signals, e.g. lighting signals and cameras signals.</li> <li>Receive various trigger signals from peripheral devices, e.g., shaft encoders and light barriers.</li> <li>Synchronize multiple marathon ACX-SP frame grabbers.</li> <li>Synchronize connected devices.</li> </ul> <p></p>"},{"location":"marathon-acx-sp.html#software-programming-and-configuration-interface","title":"Software Programming and Configuration Interface","text":"<p>marathon ACX-SP offers an easy-to-use API. The Framegrabber API allows to integrate the frame grabber into any image processing application. You can use the Framegrabber API to write code in the following languages:</p> <ul> <li>C/C++</li> <li>C# (wrapper available)</li> <li>Python (wrapper available)</li> </ul> <p>For more information about the Framegrabber API, see the Framegrabber API documentation.</p> <p>Alternatively, you can use Basler's GenTL Interface to develop your application in form of a GenTL consumer. For more information about the Basler GenTL Interface, see GenTL Interface documentation.</p>"},{"location":"marathon-acx-sp.html#connectors-and-leds","title":"Connectors and LEDs","text":""},{"location":"marathon-acx-sp.html#connectors","title":"Connectors","text":"<p>marathon ACX-SP has the following connectors:</p> <p></p>"},{"location":"marathon-acx-sp.html#configuration-switch","title":"Configuration Switch","text":"<p>In addition to its ports, marathon ACX-SP offers an on-board configuration switch for activating a fall-back FPGA configuration, called SAVE configuration. For details regarding the SAVE configuration, see FPGA Fall-Back Configuration.</p> <p></p>"},{"location":"marathon-acx-sp.html#leds-on-the-slot-bracket","title":"LEDs on the Slot Bracket","text":"<p>There is one LED located on the slot bracket of marathon ACX-SP that indicate the state of the CXP link:</p> <p></p> <p> Connection at CXP link ready for operation</p> <p> No connection at CXP link</p>"},{"location":"marathon-acx-sp.html#leds-on-the-board","title":"LEDs on the Board","text":"LED Name LED Color Meaning TRG_PWR Green Front GPIO is connected to external power (power IN). SAVE RED SAVE configuration is used for FPGA configuration READY Orange The FPGA has been configured successfully and is ready for operation. LED READY also gives light when SAVE configuration is used on FPGA. PGOOD Orange PGOOD=Power Good All voltages are applied correctly. 1 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. 2 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. 3 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. 4 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. PWR (upper LED) Green Frame grabber gets 12 VDC IN via PCIe interface. PWR (lower LED) Green Frame grabber gets voltage IN via the computer power supply connector for powering the cameras via CXP cable."},{"location":"marathon-acx-sp.html#specifications","title":"Specifications","text":"marathon ACX-SP Order Number 2200000356 Host Interface PCIe Gen 2 x4 (Direct Memory Access) Bandwidth (typ./max.) Up to 1.8 GB/s sustainable data bandwidth On-Board Memory 512 MB DDR3-RAM Power Supply (Input) / Current PCIe Slot 12 VDC (\u00b15 %) / &lt;1.5 A (actual values depend on processing) Power Supply (Input) / Current PCIe 6-pin Connector 12 VDC (\u00b15 %) / &lt;6.5 A (actual values depend on connected PoCXP cameras) PoCXP Supply (Output) 17 W of 24 VDC regulated power per CoaXPress connector Power Consumption Typ. 0.8 A @ 12 VDC (actual values depend on image pre-processing) Size (L x H) PCIe standard heightHalf length card:167.64 mm x 111.15 mm Weight 200 g Camera Interface 1 x CXP-6 (CXP-1 to CXP-6, DIN connector) Ambient Temperature 50 \u00b0C (0 LFM<sup>a</sup>)60 \u00b0C (100 LFM<sup>a</sup>)An adequate airflow in the computer is recommended. FPGA Operating Temperature<sup>b</sup> 0\u201385 \u00b0C at 100 LFM<sup>a</sup> Storage Temperature -50\u201380 \u00b0C Humidity during Operation 5\u201390 % non-condensing Humidity during Storage 5\u201395 % Compliance CE, RoHS, UKCA <ol> <li> <p>LFM = Linear Feet per Minute, unit for measuring airflow velocity.\u00a0\u21a9\u21a9\u21a9</p> </li> <li> <p>Temperature being measured directly on the FPGA. You can read out the measured value in all applets that are available for marathon ACX-SP via the applet parameter <code>FG_SYSTEMMONITOR_FPGA_TEMPERATURE</code>.\u00a0\u21a9</p> </li> </ol> <p>Info</p> <p>The PCIe bus data throughput depends on the mainboard, the chip set, and the BIOS configuration of the host computer. The number of installed PCIe boards also affects the throughput, e.g. a PCIe x8 connector may support only x4 performance. Always check the mainboard manual thoroughly to be sure.</p>"},{"location":"marathon-acx-sp.html#the-front-gpio-connector","title":"The Front GPIO Connector","text":"<p>The front GPIO connector covers the basic trigger setup of your frame grabber. Its trigger connector allows you to control peripheral devices (PLC) and to synchronize multiple marathon ACX-SP boards.</p> <p></p> <p>The socket is located directly on the slot bracket:</p> <p></p> <p>In default configuration, the trigger connector of the front GPIO connector offers:</p> <ul> <li>3 differential input signals or 2 differential and 1 single-ended input signal in pull-up mode</li> <li>2 TTL output signals</li> </ul> <p>Info</p> <p>You can configure the pin assignment of the front GPIO connector to provide different input signals, e.g.:</p> <ul> <li>Pull-down</li> <li>4 single-ended signals (and no differential signals).</li> </ul> <p>To change the GPIO configuration, use the command line tool installed with the Framegrabber SDK.</p> <p>For more information, see Input Configuration and gpiotool.</p>"},{"location":"marathon-acx-sp.html#pin-layout-of-the-front-gpio-connector","title":"Pin Layout of the Front GPIO Connector","text":"PIN Number (3P FPGA) Galvanically Isolated Signal Reference Signal 1 No GPO 0 (TTL) 5 VDC / global GND (pin 6) 2 No GPO 1 (TTL) 5 VDC / global GND (pin 6) 3 No Reserved for RS 485 (GND) 4 No Reserved for RS 485 5 No \u2014 6 No GND (global GND) 7 No 5 V_OUT (0.5 A max) 8 Yes GPI 2 (GPI2+ if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 9 Yes GPI 3 (GPI2- if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 10 Yes GPI voltage IN (4.5\u201328 VDC) 11 Yes GPI 0+ GPI voltage IN (pin 10) / GPI GND (pin 15) 12 Yes GPI 0- GPI voltage IN (pin 10) / GPI GND (pin 15) 13 Yes GPI 1+ GPI voltage IN (pin 10) / GPI GND (pin 15) 14 Yes GPI 1- GPI voltage IN (pin 10) / GPI GND (pin 15) 15 Yes GPI GND"},{"location":"marathon-acx-sp.html#extra-voltage-ingnd-for-galvanically-isolated-circuit","title":"Extra Voltage IN/GND for Galvanically Isolated Circuit","text":"<p>All General Purpose Inputs (GPIs) of the front GPIO connector are galvanically isolated. The incoming signals are transferred to the frame grabber via digital isolators. This way, the frame grabber is securely protected against high incoming voltages.</p> <p>However, to operate the internal GPI circuits, you must connect a voltage source and ground: On pin 10, you apply the voltage (GPI voltage IN) that serves as operating voltage for the internal operational amplifiers. On pin 15, you connect the according ground (GPI GND).</p> <p>Supply Voltage Required</p> <p>The marathon ACX-SP trigger system needs to get supply voltage on the GPI Voltage IN pin (pin 10). If you want to connect devices that have no PWR pin, you must provide the power supply to the GPI Voltage IN pin (pin 10) from an external source.</p>"},{"location":"marathon-acx-sp.html#possible-topologies","title":"Possible Topologies","text":"<p>You can operate marathon ACX-SP with one camera: The camera can be connected to marathon ACX-SP via one CXP line at a maximum speed of 6.25 Gbit/s (CXP6):</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Topology 1 1 1 Bayer Pattern 1 1 1 Grayscale 1 1 1 RGB <p>When connected to the computer power supply via the PCIe 6-pin connector, which always provides 12 V, marathon ACX-SP supports Power over CXP (PoCXP).</p> <p>Info</p> <p>If you are going to use multiple imaFlex CXP-12 Quad boards in one host computer, make sure you have one PCIe Gen. 3.0 x8 slot or higher per board available in the host computer. For more information, see Using Multiple Boards in one Host.</p> <p>To find out which topology you can use with which applet, refer to Choosing the Right Area Scan Applet or Choosing the Right Line Scan Applet.</p>"},{"location":"marathon-acx-sp.html#acquisition-applets","title":"Acquisition Applets","text":"<p>To ensure optimum use of system resources, not all image acquisition and processing features designed for marathon ACX-SP are loaded onto marathon ACX-SP simultaneously.</p> <p>Instead, Basler provides various compilations of specific image acquisition and processing features that are combined to meet the requirements of a specific application field.</p> <p>Typically, an applet supports a specific camera interface standard and topology, specific image acquisition features, and possibly specific image (pre-)processing features.</p> <p>Applets come in .dll files.</p> <p>Refer to Acquisition Applets for marathon ACX-SP for more detailed information about applets and their dependency on the topology used.</p>"},{"location":"marathon-vcl.html","title":"marathon VCL","text":"<p>marathon VCL is a fully programmable Camera Link frame grabber. When connected to the computer power supply, marathon VCL supports Power over Camera Link (PoCL SafePower 4W/12V per port).</p> <p>Depending on the applets you are running on the board, you may need to enable the PoCL support via microDiagnostics. The automatic PoCL detection is disabled per default on marathon VCL when running standard applets version 2.0 or higher, or when running individual applets created with VisualApplets version 3.0.6 or higher. When you use PoCL cameras together with such applets, you must enable automatic PoCL detection. This is possible in microDiagnostics (runtime version 5.5.1 or higher). For details, see Enabling PoCL Support.</p> <p></p> <p>To install the marathon VCL in your computer, plug it into a PCIe Gen. 2 x4 slot or higher. The following image shows a marathon VCL with two Camera Link cameras connected:</p> <p></p>"},{"location":"marathon-vcl.html#image-processing","title":"Image Processing","text":"<p>In addition to the image acquisition and image processing functions that are included in the delivery, marathon VCL can be programmed to fulfill highly specific image processing tasks that are required by a specific application. The programming can be done by Basler, a certified partner, or by yourself using the easy-to-use graphical FPGA programming environment VisualApplets.</p>"},{"location":"marathon-vcl.html#production-line-integration","title":"Production Line Integration","text":"<p>For integration into a production line, marathon VCL offers multiple general purpose inputs and outputs. Depending on the hardware add-ons used, 4 to 20 GPIOs are available, also galvanically isolated. These GPIOs enable you to do the following:</p> <ul> <li>Control peripheral devices by sending trigger signals, e.g. lighting signals and cameras signals.</li> <li>Receive various trigger signals from peripheral devices, e.g., shaft encoders and light barriers.</li> <li>Synchronize multiple marathon VCL frame grabbers.</li> <li>Synchronize connected devices.</li> </ul> <p></p> <p>Communication between camera and marathon VCL is realized via serial interface and four CC signals per Camera Link cable.</p>"},{"location":"marathon-vcl.html#software-programming-and-configuration-interface","title":"Software Programming and Configuration Interface","text":"<p>marathon VCL offers an easy-to-use API. The Framegrabber API allows to integrate the frame grabber into any image processing application. You can use the Framegrabber API to write code in the following languages:</p> <ul> <li>C/C++</li> <li>C# (wrapper available)</li> <li>Python (wrapper available)</li> </ul> <p>For more information about the Framegrabber API, see the Framegrabber API documentation.</p> <p>Alternatively, you can use Basler's GenTL Interface to develop your application in form of a GenTL consumer. For more information about the Basler GenTL Interface, see GenTL Interface documentation.</p>"},{"location":"marathon-vcl.html#connectors-and-leds","title":"Connectors and LEDs","text":""},{"location":"marathon-vcl.html#connectors","title":"Connectors","text":"<p>marathon VCL has the following connectors:</p> <p></p>"},{"location":"marathon-vcl.html#configuration-switch","title":"Configuration Switch","text":"<p>marathon VCL offers an on-board configuration switch for activating a fall-back FPGA configuration, called SAVE configuration. For details regarding the SAVE configuration, see FPGA Fall-Back Configuration.</p> <p></p>"},{"location":"marathon-vcl.html#leds-on-the-board","title":"LEDs on the Board","text":"<p>marathon VCL provides the following LEDs on the board:</p> <p></p> LED Name LED Color Meaning TRG_PWR Green Front GPIO is connected to external power (power IN). SAVE RED SAVE configuration is used for FPGA configuration READY Orange The FPGA has been configured successfully and is ready for operation. LED READY also gives light when SAVE configuration is used on FPGA. PGOOD Orange PGOOD=Power Good All voltages are applied correctly. CL A Orange Port A is connected to a camera that provides a clock. CL B Orange Port B is connected to a camera that provides a clock. PoCL A Green Power over Camera Link active on port A: Camera on port A is provided with power by frame grabber via Camera Link cable. PoCL B Green Power over Camera Link active on port B: Camera on port B is provided with power by frame grabber via Camera Link cable. USR1 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. USR2 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. PWR Green Frame grabber gets 12 VDC IN via PCIe interface."},{"location":"marathon-vcl.html#specifications","title":"Specifications","text":"marathon VCL Order Number 2200000359 Host Interface PCIe Gen 2 x4 (Direct Memory Access) Bandwidth (typ./max.) Up to 1.8 GB/s sustainable data bandwidth (maximal Camera Link data rate 850 MByte/s) On-Board Memory 2 GByte DDR3-RAM Power Supply (Input) / Current PCIe Slot 12 VDC (\u00b15 %) / &lt;1.5 A (actual values depend on processing) PoCXP Supply (Output) 4 W of 12 VDC regulated power per each Camera Link connector Power Consumption Typ. current 1 A @ 12 VDC (actual values depend on processing) Size (L x H) PCIe standard heightHalf length card:167.64 mm x 111.15 mm Weight 200 g Camera Interface 2 x Camera Link 2.0 standard (2 * SDR 26) (mini CL) Ambient Temperature 50 \u00b0C (0 LFM<sup>a</sup>)60 \u00b0C (100 LFM<sup>a</sup>)An adequate airflow in the computer is recommended. FPGA Operating Temperature<sup>b</sup> 0\u201385 \u00b0C at 100 LFM<sup>a</sup> Storage Temperature -50\u201380 \u00b0C Humidity during Operation 5\u201390 % non-condensing Humidity during Storage 5\u201395 % Compliance CE, FCC, UKCA, RoHS <ol> <li> <p>LFM = Linear Feet per Minute, unit for measuring airflow velocity.\u00a0\u21a9\u21a9\u21a9</p> </li> <li> <p>Temperature being measured directly on the FPGA. You can read out the measured value in all applets that are available for marathon VCL via the applet parameter <code>FG_SYSTEMMONITOR_FPGA_TEMPERATURE</code>.\u00a0\u21a9</p> </li> </ol> <p>Info</p> <p>The PCIe bus data throughput depends on the mainboard, the chip set, and the BIOS configuration of the host computer. The number of installed PCIe boards also affects the throughput, e.g. a PCIe x4 connector may support only x1 performance. Always check the mainboard manual thoroughly to be sure.</p>"},{"location":"marathon-vcl.html#the-front-gpio-connector","title":"The Front GPIO Connector","text":"<p>The front GPIO connector covers the basic trigger setup of your frame grabber. Its trigger connector allows you to control peripheral devices (PLC) and to synchronize multiple marathon VCL boards.</p> <p></p> <p>The socket is located directly on the slot bracket:</p> <p></p> <p>In default configuration, the trigger connector of the front GPIO connector offers:</p> <ul> <li>3 differential input signals or 2 differential and 1 single-ended input signal in pull-up mode</li> <li>2 TTL output signals</li> </ul> <p>Info</p> <p>You can configure the pin assignment of the front GPIO connector to provide different input signals, e.g.:</p> <ul> <li>Pull-down</li> <li>4 single-ended signals (and no differential signals).</li> </ul> <p>To change the GPIO configuration, use the command line tool installed with the Framegrabber SDK.</p> <p>For more information, see Input Configuration and gpiotool.</p>"},{"location":"marathon-vcl.html#pin-layout-of-the-front-gpio-connector","title":"Pin Layout of the Front GPIO Connector","text":"PIN Number (3P FPGA) Galvanically Isolated Signal Reference Signal 1 No GPO 0 (TTL) 5 VDC / global GND (pin 6) 2 No GPO 1 (TTL) 5 VDC / global GND (pin 6) 3 No Reserved for RS 485 (GND) 4 No Reserved for RS 485 5 No \u2014 6 No GND (global GND) 7 No 5 V_OUT (0.5 A max) 8 Yes GPI 2 (GPI2+ if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 9 Yes GPI 3 (GPI2- if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 10 Yes GPI voltage IN (4.5\u201328 VDC) 11 Yes GPI 0+ GPI voltage IN (pin 10) / GPI GND (pin 15) 12 Yes GPI 0- GPI voltage IN (pin 10) / GPI GND (pin 15) 13 Yes GPI 1+ GPI voltage IN (pin 10) / GPI GND (pin 15) 14 Yes GPI 1- GPI voltage IN (pin 10) / GPI GND (pin 15) 15 Yes GPI GND"},{"location":"marathon-vcl.html#extra-voltage-ingnd-for-galvanically-isolated-circuit","title":"Extra Voltage IN/GND for Galvanically Isolated Circuit","text":"<p>All General Purpose Inputs (GPIs) of the front GPIO connector are galvanically isolated. The incoming signals are transferred to the frame grabber via digital isolators. This way, the frame grabber is securely protected against high incoming voltages.</p> <p>However, to operate the internal GPI circuits, you must connect a voltage source and ground: On pin 10, you apply the voltage (GPI voltage IN) that serves as operating voltage for the internal operational amplifiers. On pin 15, you connect the according ground (GPI GND).</p> <p>Supply Voltage Required</p> <p>The marathon VCL trigger system needs to get supply voltage on the GPI Voltage IN pin (pin 10). If you want to connect devices that have no PWR pin, you must provide the power supply to the GPI Voltage IN pin (pin 10) from an external source.</p>"},{"location":"marathon-vcl.html#possible-topologies","title":"Possible Topologies","text":"<p>You can operate marathon VCL as follows:</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Topology 1 2 2 Bayer Pattern 1 2 2 Grayscale 1 2 2 RGB 2 1 2 Bayer Pattern 2 1 2 Grayscale 2 1 2 RGB <p>To find out which topology you can use with which applet, refer to Choosing the Right Area Scan Applet or Choosing the Right Line Scan Applet.</p>"},{"location":"marathon-vcl.html#acquisition-applets","title":"Acquisition Applets","text":"<p>To ensure optimum use of system resources, not all image acquisition and processing features designed for marathon VCL are loaded onto marathon VCL simultaneously.</p> <p>Instead, Basler provides various compilations of specific image acquisition and processing features that are combined to meet the requirements of a specific application field.</p> <p>Typically, an applet supports a specific camera interface standard and topology, specific image acquisition features, and possibly specific image (pre-)processing features.</p> <p>Applets come in .dll files.</p> <p>Refer to Acquisition Applets for marathon VCL for more detailed information about the standard applets delivered with your frame grabber and their dependency on the topology used.</p> <p>In addition to the acquisition applets that are included in the delivery, marathon VCL can be programmed to fulfill highly specific image processing tasks that are required by a specific application. The programming can be done by Basler, a certified partner, or by yourself using the easy-to-use graphical FPGA programming environment VisualApplets.</p>"},{"location":"marathon-vclx.html","title":"marathon VCLx","text":"<p>marathon VCLx is a fully programmable Camera Link frame grabber fit for especially complex image processing. When connected to the computer power supply, marathon VCLx supports Power over Camera Link (PoCL SafePower 4 W / 12 VDC per port).</p> <p>Depending on the applets you are running on the board, you may need to enable the PoCL support via microDiagnostics. The automatic PoCL detection is disabled per default on marathon VCLx when running standard applets version 2.0 or higher, or when running individual applets created with VisualApplets version 3.0.6 or higher. When you use PoCL cameras together with such applets, you must enable automatic PoCL detection. This is possible in microDiagnostics (Framegrabber SDK version 5.5.1 or higher). For details, see Enabling PoCL Support.</p> <p></p> <p>To install the marathon VCLx in your computer, plug it into a PCIe Gen. 2 x4 slot or higher. The following image shows a marathon VCLx with two Camera Link cameras connected:</p> <p></p>"},{"location":"marathon-vclx.html#image-processing","title":"Image Processing","text":"<p>In addition to the image acquisition and image processing functions that are included in the delivery, marathon VCLx can be programmed to fulfill highly specific image processing tasks that are required by a specific application. The programming can be done by Basler, a certified partner, or by yourself using the easy-to-use graphical FPGA programming environment VisualApplets.</p>"},{"location":"marathon-vclx.html#production-line-integration","title":"Production Line Integration","text":"<p>For integration into a production line, marathon VCLx offers multiple general purpose inputs and outputs. Depending on the hardware add-ons used, 4 to 20 GPIOs are available, also galvanically isolated.</p> <p>These GPIOs enable you to do the following:</p> <ul> <li>Control peripheral devices by sending trigger signals, e.g. lighting signals and cameras signals.</li> <li>Receive various trigger signals from peripheral devices, e.g., shaft encoders and light barriers.</li> <li>Synchronize multiple marathon VCLx frame grabbers.</li> <li>Synchronize connected devices.</li> </ul> <p></p> <p>Communication between camera and marathon VCLx is realized via serial interface and four CC signals per Camera Link cable.</p>"},{"location":"marathon-vclx.html#software-programming-and-configuration-interface","title":"Software Programming and Configuration Interface","text":"<p>marathon VCLx offers an easy-to-use API. The Framegrabber API allows to integrate the frame grabber into any image processing application. You can use the Framegrabber API to write code in the following languages:</p> <ul> <li>C/C++</li> <li>C# (wrapper available)</li> <li>Python (wrapper available)</li> </ul> <p>For more information about the Framegrabber API, see the Framegrabber API documentation.</p> <p>Alternatively, you can use Basler's GenTL Interface to develop your application in form of a GenTL consumer. For more information about the Basler GenTL Interface, see GenTL Interface documentation.</p>"},{"location":"marathon-vclx.html#connectors-and-leds","title":"Connectors and LEDs","text":""},{"location":"marathon-vclx.html#connectors","title":"Connectors","text":"<p>marathon VCLx has the following connectors:</p> <p></p>"},{"location":"marathon-vclx.html#configuration-switch","title":"Configuration Switch","text":"<p>marathon VCLx offers an on-board configuration switch for activating a fall-back FPGA configuration, called SAVE configuration. For details regarding the SAVE configuration, see FPGA Fall-Back Configuration.</p> <p></p>"},{"location":"marathon-vclx.html#leds-on-the-board","title":"LEDs on the Board","text":"<p>marathon VCLx provides the following LEDs on the board:</p> <p></p> LED Name LED Color Meaning TRG_PWR Green Front GPIO is connected to external power (power IN). SAVE RED SAVE configuration is used for FPGA configuration READY Orange The FPGA has been configured successfully and is ready for operation. LED READY also gives light when SAVE configuration is used on FPGA. PGOOD Orange PGOOD=Power Good All voltages are applied correctly. CL A Orange Port A is connected to a camera that provides a clock. CL B Orange Port B is connected to a camera that provides a clock. PoCL A Green Power over Camera Link active on port A: Camera on port A is provided with power by frame grabber via Camera Link cable. PoCL B Green Power over Camera Link active on port B: Camera on port B is provided with power by frame grabber via Camera Link cable. USR1 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. USR2 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. PWR Green Frame grabber gets 12 VDC IN via PCIe interface."},{"location":"marathon-vclx.html#specifications","title":"Specifications","text":"marathon VCLx Order Number 2200000360 Host Interface PCIe Gen 2 x4 (Direct Memory Access) Bandwidth (typ./max.) Up to 1.8 GB/s sustainable data bandwidth (maximal Camera Link data rate 850 MByte/s) On-Board Memory 2 GByte DDR3-RAM Power Supply (Input) / Current PCIe Slot 12 VDC (\u00b15 %) / &lt;2 A (actual values depend on processing) PoCXP Supply (Output) 4 W of 12 VDC regulated power per each Camera Link connector Power Consumption Typ. current 1.4 A @12 VDC (actual values depend on processing) Size (L x H) PCIe standard heightHalf length card:167.64 mm x 111.15 mm Weight 200 g Camera Interface 2 x Camera Link 2.0 standard (2 * SDR 26) (mini CL) Ambient Temperature 50 \u00b0C (0 LFM<sup>a</sup>)60 \u00b0C (100 LFM<sup>a</sup>)An adequate airflow in the computer is recommended. FPGA Operating Temperature<sup>b</sup> 0\u201385 \u00b0C at 100 LFM<sup>a</sup> Storage Temperature -50\u201380 \u00b0C Humidity during Operation 5\u201390 % non-condensing Humidity during Storage 5\u201395 % Compliance CE, FCC, UKCA, RoHS <ol> <li> <p>LFM = Linear Feet per Minute, unit for measuring airflow velocity.\u00a0\u21a9\u21a9\u21a9</p> </li> <li> <p>Temperature being measured directly on the FPGA. You can read out the measured value in all applets that are available for marathon VCLx via the applet parameter <code>FG_SYSTEMMONITOR_FPGA_TEMPERATURE</code>.\u00a0\u21a9</p> </li> </ol> <p>Info</p> <p>The PCIe bus data throughput depends on the mainboard, the chip set, and the BIOS configuration of the host computer. The number of installed PCIe boards also affects the throughput, e.g. a PCIe x4 connector may support only x1 performance. Always check the mainboard manual thoroughly to be sure.</p>"},{"location":"marathon-vclx.html#the-front-gpio-connector","title":"The Front GPIO Connector","text":"<p>The front GPIO connector covers the basic trigger setup of your frame grabber. Its trigger connector allows you to control peripheral devices (PLC) and to synchronize multiple marathon VCLx boards.</p> <p></p> <p>The socket is located directly on the slot bracket:</p> <p></p> <p>In default configuration, the trigger connector of the front GPIO connector offers:</p> <ul> <li>3 differential input signals or 2 differential and 1 single-ended input signal in pull-up mode</li> <li>2 TTL output signals</li> </ul> <p>Info</p> <p>You can configure the pin assignment of the front GPIO connector to provide different input signals, e.g.:</p> <ul> <li>Pull-down</li> <li>4 single-ended signals (and no differential signals).</li> </ul> <p>To change the GPIO configuration, use the command line tool installed with the Framegrabber SDK.</p> <p>For more information, see Input Configuration and gpiotool.</p>"},{"location":"marathon-vclx.html#pin-layout-of-the-front-gpio-connector","title":"Pin Layout of the Front GPIO Connector","text":"PIN Number (3P FPGA) Galvanically Isolated Signal Reference Signal 1 No GPO 0 (TTL) 5 VDC / global GND (pin 6) 2 No GPO 1 (TTL) 5 VDC / global GND (pin 6) 3 No Reserved for RS 485 (GND) 4 No Reserved for RS 485 5 No \u2014 6 No GND (global GND) 7 No 5 V_OUT (0.5 A max) 8 Yes GPI 2 (GPI2+ if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 9 Yes GPI 3 (GPI2- if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 10 Yes GPI voltage IN (4.5\u201328 VDC) 11 Yes GPI 0+ GPI voltage IN (pin 10) / GPI GND (pin 15) 12 Yes GPI 0- GPI voltage IN (pin 10) / GPI GND (pin 15) 13 Yes GPI 1+ GPI voltage IN (pin 10) / GPI GND (pin 15) 14 Yes GPI 1- GPI voltage IN (pin 10) / GPI GND (pin 15) 15 Yes GPI GND"},{"location":"marathon-vclx.html#extra-voltage-ingnd-for-galvanically-isolated-circuit","title":"Extra Voltage IN/GND for Galvanically Isolated Circuit","text":"<p>All General Purpose Inputs (GPIs) of the front GPIO connector are galvanically isolated. The incoming signals are transferred to the frame grabber via digital isolators. This way, the frame grabber is securely protected against high incoming voltages.</p> <p>However, to operate the internal GPI circuits, you must connect a voltage source and ground: On pin 10, you apply the voltage (GPI voltage IN) that serves as operating voltage for the internal operational amplifiers. On pin 15, you connect the according ground (GPI GND).</p> <p>Supply Voltage Required</p> <p>The marathon VCLx trigger system needs to get supply voltage on the GPI Voltage IN pin (pin 10). If you want to connect devices that have no PWR pin, you must provide the power supply to the GPI Voltage IN pin (pin 10) from an external source.</p>"},{"location":"marathon-vclx.html#possible-topologies","title":"Possible Topologies","text":"<p>You can operate marathon VCLx as follows:</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Topology 1 2 2 Bayer Pattern 1 2 2 Grayscale 1 2 2 RGB 2 1 2 Bayer Pattern 2 1 2 Grayscale 2 1 2 RGB <p>To find out which topology you can use with which applet, refer to Choosing the Right Area Scan Applet or Choosing the Right Line Scan Applet.</p>"},{"location":"marathon-vclx.html#acquisition-applets","title":"Acquisition Applets","text":"<p>To ensure optimum use of system resources, not all image acquisition and processing features designed for marathon VCLx are loaded onto marathon VCLx simultaneously.</p> <p>Instead, Basler provides various compilations of specific image acquisition and processing features that are combined to meet the requirements of a specific application field.</p> <p>Typically, an applet supports a specific camera interface standard and topology, specific image acquisition features, and possibly specific image (pre-)processing features.</p> <p>Applets come in .dll files.</p> <p>Refer to Acquisition Applets for marathon VCLx for more detailed information about the standard applets delivered with your frame grabber and their dependency on the topology used.</p> <p>In addition to the acquisition applets that are included in the delivery, marathon VCLx can be programmed to fulfill highly specific image processing tasks that are required by a specific application. The programming can be done by Basler, a certified partner, or by yourself using the easy-to-use graphical FPGA programming environment VisualApplets.</p>"},{"location":"marathon-vcx-qp.html","title":"marathon VCX-QP","text":"<p>marathon VCX-QP is a fully programmable CXP-6 frame grabber. When connected to the computer power supply, marathon VCX-QP supports Power over CXP (PoCXP).</p> <p></p> <p>To install the marathon VCX-QP in your computer, plug it into a PCIe Gen. 2 x4 slot or higher. The following image shows a marathon VCX-QP with two cameras connected:</p> <p></p>"},{"location":"marathon-vcx-qp.html#image-processing","title":"Image Processing","text":"<p>In addition to the image acquisition and image processing functions that are included in the delivery, marathon VCX-QP can be programmed to fulfill highly specific image processing tasks that are required by a specific application. The programming can be done by Basler, a certified partner, or by yourself using the easy-to-use graphical FPGA programming environment VisualApplets.</p>"},{"location":"marathon-vcx-qp.html#production-line-integration","title":"Production Line Integration","text":"<p>For integration into a production line, marathon VCX-QP offers multiple general purpose inputs and outputs. 4 to 20 of the GPIOs (depending on the hardware add-ons used) are galvanically isolated.</p> <p>These GPIOs enable you to do the following:</p> <ul> <li>Control peripheral devices by sending trigger signals, e.g. lighting signals and cameras signals.</li> <li>Receive various trigger signals from peripheral devices, e.g., shaft encoders and light barriers.</li> <li>Synchronize multiple marathon VCX-QP frame grabbers.</li> <li>Synchronize connected devices.</li> </ul> <p></p>"},{"location":"marathon-vcx-qp.html#software-programming-and-configuration-interface","title":"Software Programming and Configuration Interface","text":"<p>marathon VCX-QP offers an easy-to-use API. The Framegrabber API allows to integrate the frame grabber into any image processing application. You can use the Framegrabber API to write code in the following languages:</p> <ul> <li>C/C++</li> <li>C# (wrapper available)</li> <li>Python (wrapper available)</li> </ul> <p>For more information about the Framegrabber API, see the Framegrabber API documentation.</p> <p>Alternatively, you can use Basler's GenTL Interface to develop your application in form of a GenTL consumer. For more information about the Basler GenTL Interface, see GenTL Interface documentation.</p>"},{"location":"marathon-vcx-qp.html#connectors-and-leds","title":"Connectors and LEDs","text":""},{"location":"marathon-vcx-qp.html#connectors","title":"Connectors","text":"<p>marathon VCX-QP has the following connectors:</p> <p></p>"},{"location":"marathon-vcx-qp.html#configuration-switch","title":"Configuration Switch","text":"<p>In addition to its ports, marathon VCX-QP offers an on-board configuration switch for activating a fall-back FPGA configuration, called SAVE configuration. For details regarding the SAVE configuration, see FPGA Fall-Back Configuration.</p> <p></p>"},{"location":"marathon-vcx-qp.html#leds-on-the-slot-bracket","title":"LEDs on the Slot Bracket","text":"<p>There is one LED located on the slot bracket of marathon VCX-QP that indicate the state of the CXP link:</p> <p></p> <p> Connection at CXP link ready for operation</p> <p> No connection at CXP link</p>"},{"location":"marathon-vcx-qp.html#leds-on-the-board","title":"LEDs on the Board","text":"LED Name LED Color Meaning TRG_PWR Green Front GPIO is connected to external power (power IN). SAVE RED SAVE configuration is used for FPGA configuration READY Orange The FPGA has been configured successfully and is ready for operation. LED READY also gives light when SAVE configuration is used on FPGA. PGOOD Orange PGOOD=Power Good All voltages are applied correctly. 1 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. 2 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. 3 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. 4 Orange User-defined. The LEDs can be controlled via software. They aren't related to camera connectors and can be used for any purpose. PWR (upper LED) Green Frame grabber gets 12 VDC IN via PCIe interface. PWR (lower LED) Green Frame grabber gets voltage IN via the computer power supply connector for powering the cameras via CXP cable."},{"location":"marathon-vcx-qp.html#specifications","title":"Specifications","text":"marathon VCX-QP Order Number 2200000357 Host Interface PCIe Gen 2 x4 (Direct Memory Access) Bandwidth (typ./max.) Up to 1.8 GB/s sustainable data bandwidth On-Board Memory 2 GByte DDR3-RAM Power Supply (Input) / Current PCIe Slot 12 VDC (\u00b15 %) / &lt;1.5 A (actual values depend on processing) Power Supply (Input) / Current PCIe 6-pin Connector 12 VDC (\u00b15 %) / &lt;6.5 A (actual values depend on connected PoCXP cameras) PoCXP Supply (Output) 17 W of 24 VDC regulated power per CoaXPress connector Power Consumption Typ. 1.175 A @ 12 VDC (actual values depend on image pre-processing), maximum load: 3.35 A (single supply over 4-pin power connector) Size (L x H) PCIe standard heightHalf length card:167.64 mm x 111.15 mm Weight 200 g Camera Interface 4 x CXP-6 (CXP-1 to CXP-6, DIN connectors) Ambient Temperature 50 \u00b0C (0 LFM<sup>a</sup>)60 \u00b0C (100 LFM<sup>a</sup>)An adequate airflow in the computer is recommended. FPGA Operating Temperature<sup>b</sup> 0\u201385 \u00b0C at 100 LFM<sup>a</sup> Storage Temperature -50\u201380 \u00b0C Humidity during Operation 5\u201390 % non-condensing Humidity during Storage 5\u201395 % Compliance CE, RoHS, UKCA <ol> <li> <p>LFM = Linear Feet per Minute, unit for measuring airflow velocity.\u00a0\u21a9\u21a9\u21a9</p> </li> <li> <p>Temperature being measured directly on the FPGA. You can read out the measured value in all applets that are available for marathon VCX-QP via the applet parameter <code>FG_SYSTEMMONITOR_FPGA_TEMPERATURE</code>.\u00a0\u21a9</p> </li> </ol> <p>Info</p> <p>The PCIe bus data throughput depends on the mainboard, the chip set, and the BIOS configuration of the host computer. The number of installed PCIe boards also affects the throughput, e.g. a PCIe x8 connector may support only x4 performance. Always check the mainboard manual thoroughly to be sure.</p>"},{"location":"marathon-vcx-qp.html#the-front-gpio-connector","title":"The Front GPIO Connector","text":"<p>The front GPIO connector covers the basic trigger setup of your frame grabber. Its trigger connector allows you to control peripheral devices (PLC) and to synchronize multiple marathon VCX-QP boards.</p> <p></p> <p>The socket is located directly on the slot bracket:</p> <p></p> <p>In default configuration, the trigger connector of the front GPIO connector offers:</p> <ul> <li>3 differential input signals or 2 differential and 1 single-ended input signal in pull-up mode</li> <li>2 TTL output signals</li> </ul> <p>Info</p> <p>You can configure the pin assignment of the front GPIO connector to provide different input signals, e.g.:</p> <ul> <li>Pull-down</li> <li>4 single-ended signals (and no differential signals).</li> </ul> <p>To change the GPIO configuration, use the command line tool installed with the Framegrabber SDK.</p> <p>For more information, see Input Configuration and gpiotool.</p>"},{"location":"marathon-vcx-qp.html#pin-layout-of-the-front-gpio-connector","title":"Pin Layout of the Front GPIO Connector","text":"PIN Number (3P FPGA) Galvanically Isolated Signal Reference Signal 1 No GPO 0 (TTL) 5 VDC / global GND (pin 6) 2 No GPO 1 (TTL) 5 VDC / global GND (pin 6) 3 No Reserved for RS 485 (GND) 4 No Reserved for RS 485 5 No \u2014 6 No GND (global GND) 7 No 5 V_OUT (0.5 A max) 8 Yes GPI 2 (GPI2+ if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 9 Yes GPI 3 (GPI2- if used for differential signal) GPI voltage IN (pin 10) / GPI GND (pin 15) 10 Yes GPI voltage IN (4.5\u201328 VDC) 11 Yes GPI 0+ GPI voltage IN (pin 10) / GPI GND (pin 15) 12 Yes GPI 0- GPI voltage IN (pin 10) / GPI GND (pin 15) 13 Yes GPI 1+ GPI voltage IN (pin 10) / GPI GND (pin 15) 14 Yes GPI 1- GPI voltage IN (pin 10) / GPI GND (pin 15) 15 Yes GPI GND"},{"location":"marathon-vcx-qp.html#extra-voltage-ingnd-for-galvanically-isolated-circuit","title":"Extra Voltage IN/GND for Galvanically Isolated Circuit","text":"<p>All General Purpose Inputs (GPIs) of the front GPIO connector are galvanically isolated. The incoming signals are transferred to the frame grabber via digital isolators. This way, the frame grabber is securely protected against high incoming voltages.</p> <p>However, to operate the internal GPI circuits, you must connect a voltage source and ground: On pin 10, you apply the voltage (GPI voltage IN) that serves as operating voltage for the internal operational amplifiers. On pin 15, you connect the according ground (GPI GND).</p> <p>Supply Voltage Required</p> <p>The marathon VCX-QP trigger system needs to get supply voltage on the GPI Voltage IN pin (pin 10). If you want to connect devices that have no PWR pin, you must provide the power supply to the GPI Voltage IN pin (pin 10) from an external source.</p>"},{"location":"marathon-vcx-qp.html#possible-topologies","title":"Possible Topologies","text":"<p>You can operate marathon VCX-QP as follows:</p> Number of Cameras Number of Camera Ports Number of Frame Grabber Ports Mode Topology 1 4 4 Bayer Pattern 1 4 4 Grayscale 1 4 4 RGB 2 2 4 Bayer Pattern 2 2 4 Grayscale 2 2 4 RGB 4 1 4 Bayer Pattern 4 1 4 Grayscale 4 1 4 RGB <p>When connected to the computer power supply via the PCIe 6-pin connector, which always provides 12 V, marathon VCX-QP supports Power over CXP (PoCXP).</p> <p>Info</p> <p>If you are going to use multiple imaFlex CXP-12 Quad boards in one host computer, make sure you have one PCIe Gen. 3.0 x8 slot or higher per board available in the host computer. For more information, see Using Multiple Boards in one Host.</p> <p>To find out which topology you can use with which applet, refer to Choosing the Right Area Scan Applet or Choosing the Right Line Scan Applet.</p>"},{"location":"marathon-vcx-qp.html#acquisition-applets","title":"Acquisition Applets","text":"<p>To ensure optimum use of system resources, not all image acquisition and processing features designed for marathon VCX-QP are loaded onto marathon VCX-QP simultaneously.</p> <p>Instead, Basler provides various compilations of specific image acquisition and processing features that are combined to meet the requirements of a specific application field.</p> <p>Typically, an applet supports a specific camera interface standard and topology, specific image acquisition features, and possibly specific image (pre-)processing features.</p> <p>Applets come in .dll files.</p> <p>Refer to Acquisition Applets for marathon VCX-QP for more detailed information about the standard applets delivered with your frame grabber and their dependency on the topology used.</p> <p>In addition to the acquisition applets that are included in the delivery, marathon VCX-QP can be programmed to fulfill highly specific image processing tasks that are required by a specific application. The programming can be done by Basler, a certified partner, or by yourself using the easy-to-use graphical FPGA programming environment VisualApplets.</p>"},{"location":"microenable-5-marathon.html","title":"microEnable 5 marathon","text":"<p>Basler's microEnable frame grabbers cover a broad range of use case scenarios. Supporting various camera interfaces, Basler's portfolio reaches from simple plug-and-play frame grabbers to programmable high-performance boards.</p> <p>Each frame grabber is equipped with one FPGA (Field Programming Gate Array). By making maximum use of the parallelized data processing on FPGAs, our frame grabbers offer real time image processing, including real time triggering directly from the frame grabber.</p> <p>In solutions using our frame grabbers, the main image processing takes place directly on the FPGA. Only the processing results are forwarded to the CPU, which leads to a tremendous reduction of the CPU load. If required, the actual images are transferred to the host computer via Direct Memory Access (DMA) without any CPU involvement.</p> <p></p>"},{"location":"microenable-5-marathon.html#the-concept-of-applets","title":"The Concept of Applets","text":"<p>What makes our frame grabbers unique is the use of applets. An applet is an application that runs on the frame grabber's FPGA. We call these applications applets since they work like the apps for mobile devices.</p> <p>An applet contains the FPGA firmware for image acquisition and image processing. We don't pack all image acquisition and processing functions available for a specific frame grabber model into one big applet. Instead, we tailor each applet for a specific camera interface, a specific topology (how many cameras, how many links per camera), and a specific field of application. This allows for a maximum use of FPGA resources. Anything not required for a specific use case isn't loaded onto the FPGA.</p> <p>We provide a free set of applets for each frame grabber model. You can select the applet of your choice and load it onto the frame grabber FPGA. Each applet comes with a comprehensive applet documentation. Applet overviews listing the main features of the individual applets enable you to select the applet that fits your use case best.</p> <p>You can parameterize each applet, either via GUI application microDisplay X, or via the provided Framegrabber API. A description of all parametrization options you find in the applet documentation.</p> <p>In addition to the freely available applets out of the applet sets, you can use custom applets that contain complex and specific algorithms. These applets are developed either by Basler or by yourself. To program your own applets, you use the graphical development environment VisualApplets. As it is a graphical environment, you need no HDL knowledge to create your own, unique applets.</p>"},{"location":"microenable-5-marathon.html#a-series-and-v-series","title":"A Series and V Series","text":"<p>Each microEnable frame grabber model is offered in two product variants:</p> <ul> <li>A Series: Allow to run the freely available applets. A Series frame grabbers focus on real-time image acquisition, including image pre-processing and triggering.</li> <li>V Series: Programmable frame grabbers. Allow to run custom specific applets developed by yourself using VisualApplets, or by Basler application engineers. While providing all functionality offered by A Series grabbers, V Series frame grabbers focus on the use of highly complex, individualized image processing solutions.</li> </ul>"},{"location":"microenable-5-marathon.html#designing-your-own-applets","title":"Designing Your Own Applets","text":"<p>The design of all V-grabbers (i.e. marathon VCX-QP, marathon VCL, and marathon VCLx) allows you to program you own individual image processing solutions (applets) using the graphical FPGA programming environment VisualApplets.</p> <p>VisualApplets is an intuitive, graphical tool for programming FPGAs used in machine vision. You can develop applications handling very specific and highly complex image processing tasks in a time and cost effective manner. You are supported by features like visual debugging, analyzing options, and pixel-accurate simulation. An integrated SDK generator and the accompanying microDisplay X program make the implementation on your V-grabber easy.</p> <p>Info</p> <p>Building applications with this development tool requires an according license, see section VisualApplets Licensing.</p> <p>For information about how to install VisualApplets, refer to Installing VisualApplets.</p> <p>For information about how to create your own applets with VisualApplets, refer to the VisualApplets User Documentation.</p>"},{"location":"microenable-5-marathon.html#supported-camera-interfaces","title":"Supported Camera Interfaces","text":"<p>The microEnable frame grabbers support the following camera standards:</p> <ul> <li>CoaXPress</li> <li>Camera Link</li> </ul>"},{"location":"microenable-5-marathon.html#models","title":"Models","text":"<ul> <li>marathon ACX-SP: One-channel CoaXPress frame grabber, A Series</li> <li>marathon ACX-DP: Two-channel CoaXPress frame grabber, A Series</li> <li>marathon ACX-QP: Four-channel CoaXPress frame grabber, A Series</li> <li>marathon VCX-QP: Four-channel CoaXPress frame grabber, V Series (programmable)</li> <li>marathon ACL: Two-channel Camera Link frame grabber, A Series</li> <li>marathon VCL: Two-channel Camera Link frame grabber, V Series (programmable)</li> <li>marathon VCLx: Two-channel Camera Link frame grabber, V Series (programmable, especially fit for complex image processing)</li> </ul>"},{"location":"microenable-5-marathon.html#release-notes-and-troubleshooting","title":"Release Notes and Troubleshooting","text":"<ul> <li>New Features</li> <li>Changes and Fixed Issues in Runtime 5.9.0</li> <li>Known Issues</li> <li>Troubleshooting</li> </ul>"},{"location":"microenable-5-marathon.html#software","title":"Software","text":""},{"location":"microenable-5-marathon.html#framegrabber-sdk","title":"Framegrabber SDK","text":"<p>The Framegrabber SDK is a software suite with which you can operate your frame grabber. The Framegrabber SDK provides the following software components:</p>"},{"location":"microenable-5-marathon.html#tools","title":"Tools","text":"<ul> <li>microDisplay X</li> <li>microDiagnostics</li> <li>FirmwareUpdater</li> <li>gpioTool</li> <li>mE5BoardSettings</li> <li>FirmwareFlasher</li> </ul>"},{"location":"microenable-5-marathon.html#framegrabber-api","title":"Framegrabber API","text":"<ul> <li>Framegrabber API Manual</li> <li>Framegrabber API Function Reference</li> <li>Framegrabber API CoaXPress Extension Reference</li> <li>I/O Library Function Reference</li> <li>Display Library Function Reference</li> <li>GenTL Interface Documentation</li> <li>C# Wrapper</li> <li>Python Wrapper</li> <li>Log Message System Manual</li> </ul>"},{"location":"microenable-5-marathon.html#acquisition-applets","title":"Acquisition Applets","text":"<ul> <li>Acquisition Applets</li> </ul>"},{"location":"microenable-5-marathon.html#visualapplets","title":"VisualApplets","text":"<p>For information about our graphical development environment, see the VisualApplets documentation.</p> <p>Info</p> <p>Can't find your model here? To access the documentation of discontinued products, install the runtime software included with your frame grabber. This contains the relevant documentation.</p>"},{"location":"new-features-framegrabber-sdk-5-10-0.html","title":"New Features in Framegrabber SDK 5.10.0","text":"<p>This section provides information about new features for the Basler Framegrabber SDK version 5.10.0.</p>"},{"location":"new-features-framegrabber-sdk-5-10-0.html#microenable-6-support","title":"microEnable 6 Support","text":"<ul> <li>The Framegrabber SDK 5.10.0 now supports both Basler imaWorx CXP-12 Quad and Basler microEnable 5 CameraLink and CXP-6 frame grabbers. Therefore Basler now offers one Framegrabber SDK version that supports all current frame grabbers. (Ticket IDs: 231592 and 238357 )</li> <li>The .NET API examples also work with both imaWorx CXP-12 Quad and microEnable 5 frame grabbers now. (Ticket ID: 249175)</li> <li>The python API examples also work with both imaWorx CXP-12 Quad and microEnable 5 frame grabbers now. (Ticket ID: 249176)</li> </ul>"},{"location":"new-features-framegrabber-sdk-5-10-0.html#microdiagnostics","title":"microDiagnostics","text":"<ul> <li>In microDiagnostics, a button has been added for rescanning applets. With this new button, you can now update .hap files automatically just like .dll files. The functionality is mostly important for the mE5 when developing applets in VisualApplets. (Ticket ID: 208687)</li> </ul>"},{"location":"new-features-framegrabber-sdk-5-10-0.html#gentl-producer","title":"GenTL Producer","text":"<ul> <li>The GenTL interface of the Basler Framegrabber SDK has been improved to comply with the GenICam GenTL 1.5 standard. Basler recommends using the Framegrabber SDK GenTL producer when using third-party libraries, e.g., MVTec HALCON. (Ticket IDs: 231576, 236695, 212794, 241717, and 254061)</li> <li>The Framegrabber SDK now provides a separate GenICam GenTL producer for Camera Link frame grabbers. (Ticket ID: 241934)</li> <li>GenICam GenTL events have been implemented. (Ticket IDs: 217764, 229968, 233813, 236698, 229976, 229968, 250936, 251822 and 251821)</li> <li>The GenICam GenTL interface now supports enumeration parameters with a single entry correctly. (Ticket ID: 233604)</li> <li>The GenICam GenTL producer supports additional XML entries now. (Ticket ID: 229950)</li> </ul>"},{"location":"new-features-framegrabber-sdk-5-10-0.html#support-for-nvidia-gpudirect-for-imaworx-cxp-12-quad","title":"Support for Nvidia GPUDirect for imaWorx CXP-12 Quad","text":"<ul> <li>The Framegrabber SDK now supports Nvidia GPUDirect for imaWorx CXP-12 Quad, too. See the documentation for details.(Ticket ID: 231588, 225714, 227104, 255226)</li> </ul>"},{"location":"new-features-framegrabber-sdk-5-10-0.html#imaworx-cxp-12-quad-frame-grabber-applets","title":"imaWorx CXP-12 Quad Frame Grabber Applets","text":"<ul> <li>The imaWorx CXP-12 Quad frame grabber applets for area scan cameras now support buffer overflow handling. (Ticket IDs: 229959, 239400)</li> </ul>"},{"location":"new-features-framegrabber-sdk-5-10-0.html#documentation","title":"Documentation","text":"<ul> <li>The Framegrabber SDK documentation and the frame grabber documentation have been migrated and are now included in the Basler Product Documentation. You can now use the search function over all topics. (Ticket IDs: 230700 and 230701)</li> <li>The Framegrabber SDK documentation is now available as offline version via the Help menu in microDisplay X. (Ticket ID: 247804)</li> <li>The Basler Product Documentation has been updated to reflect all changes in Framegrabber SDK 5.10.0. (Ticket ID: 229717)</li> </ul>"},{"location":"new-features-framegrabber-sdk-5-11-0.html","title":"New Features in Framegrabber SDK 5.11.0","text":"<p>This section provides information about new features for the Basler Framegrabber SDK version 5.11.0.</p>"},{"location":"new-features-framegrabber-sdk-5-11-0.html#gentl-producer","title":"GenTL Producer","text":"<ul> <li>The GenTL Producer now provides the Compatibility Status category. For details, see the Using the GenTL Interface topic.</li> <li>The GenTL Producer now sets the tap geometry in the applet according to the camera configuration.</li> </ul>"},{"location":"new-features-framegrabber-sdk-5-11-2.html","title":"New Features in Framegrabber SDK 5.11.2","text":"<p>This section provides information about new features for the Basler Framegrabber SDK version 5.11.2.</p>"},{"location":"new-features-framegrabber-sdk-5-11-2.html#imaflex-cxp-12-quad-support","title":"imaFlex CXP-12 Quad Support","text":"<p>The Framegrabber SDK now supports the new programmable frame grabber imaFlex CXP-12 Quad. Framegrabber SDK 5.11.2 also delivers an applet set for imaFlex CXP-12 Quad.</p>"},{"location":"new-features-framegrabber-sdk-5-11-2.html#visualapplets-340-support","title":"VisualApplets 3.4.0 Support","text":"<p>The Framegrabber SDK now supports VisualApplets 3.4 including <code>DMAfromPC</code>.</p>"},{"location":"new-features-framegrabber-sdk-5-11-2.html#dmafrompc","title":"DmaFromPC","text":"<p>Framegrabber SDK supports the function <code>DmaFromPC</code>. The function <code>DmaFromPC</code> only works for applets that contain the VisualApplets operator <code>DmaFromPC</code>. This operator is available in VisualApplets version 3.4.0 or higher.</p> <p>Documentation for <code>DmaFromPC</code> is available in topic fglib5.</p>"},{"location":"new-features-framegrabber-sdk-5-11-2.html#applets","title":"Applets","text":"<ul> <li>Updated applets for CXP-12 Interface Card 1C/2C/4C and imaWorx CXP-12 Quad:<ul> <li>CoaXPress trigger packets updated to CoaXPress 2.1.</li> <li>The parameters <code>FG_CXP_TRIGGER_PACKET_MODE</code> / <code>CxpTriggerPacketMode</code> and <code>FG_TRIGGERCAMERA_OUT_SELECT</code> / <code>TriggerCameraOutSelect</code> became legacy.</li> </ul> </li> <li>First delivery of applets for imaFlex CXP-12 Quad. The features are exactly the same as in the applets for imaWorx CXP-12 Quad.</li> </ul>"},{"location":"new-features-framegrabber-sdk-5-11-3.html","title":"New Features in Framegrabber SDK 5.11.3","text":"<p>This section provides information about new features for the Basler Framegrabber SDK version 5.11.3.</p>"},{"location":"new-features-framegrabber-sdk-5-11-3.html#imaflex-cxp-12-penta-support","title":"imaFlex CXP-12 Penta Support","text":"<p>The Framegrabber SDK now supports the new programmable frame grabber imaFlex CXP-12 Penta. Framegrabber SDK 5.11.3 also delivers an applet set for imaFlex CXP-12 Penta.</p>"},{"location":"new-features-framegrabber-sdk-5-11-3.html#visualapplets-350-support","title":"VisualApplets 3.5.0 Support","text":"<p>The Framegrabber SDK now supports VisualApplets 3.5.0.</p>"},{"location":"new-features-framegrabber-sdk-5-11-3.html#event-logging","title":"Event Logging","text":"<p>Framegrabber SDK supports the new pylon Event Logging Tool. For this, the existing log messages have been restructured for compliance with the pylon event logging (PEL) framework. Additionally, the log messages now contain IDs.</p>"},{"location":"new-features-framegrabber-sdk-5-11-3.html#applets","title":"Applets","text":"<ul> <li>Updated applets for CXP-12 Interface Card 1C/2C/4C, imaWorx CXP-12 Quad and imaFlex CXP-12 Quad:<ul> <li>The applets have been extended with additional parameters and events for problem analysis, e.g. to find   errors in the CXP stream. The new parameters and events have been added to the parameter tree.</li> <li>Bug fixes.</li> </ul> </li> <li>First delivery of applets for imaFlex CXP-12 Penta.</li> </ul>"},{"location":"new-features-framegrabber-sdk-5-11-4.html","title":"New Features in Framegrabber SDK 5.11.4","text":"<p>This section provides information about new features for the Basler Framegrabber SDK version 5.11.4.</p>"},{"location":"new-features-framegrabber-sdk-5-11-4.html#event-logging","title":"Event Logging","text":"<p>Framegrabber SDK supports the new pylon Event Logger. For this, the existing log messages of the Framegrabber SDK have been restructured for compliance with the pylon event logging (PEL) framework. Additionally, the log messages now contain IDs. See also Changes and Fixed Issues in Framegrabber SDK 5.11.4 for all details of the logging behavior.</p> <p>You can install the pylon Event Logger with your Framgrabber SDK installer as a component you can select. To start the Event Logger:</p> <ul> <li>Framegrabber SDK: Start the pyloneventlogger.exe from the &lt;Framegrabber SDK installation directory&gt;\\Applications\\bin.</li> <li>GenTL/CXP: Start the pylon Event Logger with the start script bin\\pyloneventlogger.</li> </ul>"},{"location":"new-features-framegrabber-sdk-5-11-4.html#applets","title":"Applets","text":"<ul> <li>First delivery of dual applets for imaFlex CXP-12 Penta.</li> <li>Updated all applets for all frame grabbers and interface cards with bug fixes.</li> </ul>"},{"location":"new-features-framegrabber-sdk-5-11-5.html","title":"New Features in Framegrabber SDK 5.11.5","text":"<p>The Framegrabber SDK 5.11.5 is a patch version. It provides only fixed issues, no new features.</p>"},{"location":"new-features-runtime-5-9-0.html","title":"New Features in Runtime 5.9.0","text":"<p>This section provides information about new features for the Basler Runtime version 5.9.0.</p>"},{"location":"new-features-runtime-5-9-0.html#gentl-producer","title":"GenTL Producer","text":"<ul> <li>The GenTL Producer was newly developed. Refer to the GenTL Interface Documentation for usage instructions.</li> <li>The firmware version of the interface cards can now be queried from the GenTL Producer. In pylon viewer, the firmware version is displayed in the Inferface Information section of the interface features. (Ticket ID: TFS 206576)</li> </ul>"},{"location":"new-features-runtime-5-9-0.html#microdisplayx","title":"microDisplayX","text":"<ul> <li>You can now configure in microDisplayX the number of links to be used by the camera. You can do this in microDisplayX under Cameras -&gt; Connection -&gt; Number of Links. (Ticket ID: TFS 197438)</li> </ul>"},{"location":"new-features-runtime-5-9-0.html#sdk","title":"SDK","text":"<ul> <li>To avoid name clashes between GenICam header files with frame grabber header files, a new function has been implemented. To use this feature, add <code>#define FGRAB_PREVENT_PFNC_NAMECLASHES</code> before any include of fgrab_define.h. Then, the enum entries in fgrab_define.h will be prefixed with FGrab_. (Ticket ID: TFS 198602)</li> </ul>"},{"location":"nvidia-gpu-direct-for-video.html","title":"NVIDIA GPUDirect for Video","text":"<p>Basler supports NVIDIA GPUDirect for Video technology. You can access and control the use of NVIDIA GPUDirect for Video technology via the Basler Framegrabber API. NVIDIA GPUDirect for Video is tailored for systems that use an NVIDIA graphics processing unit (GPU).</p> <p>The technology allows to efficiently transfer video frames into NVIDIA GPU memory at low latencies. It gives you full control to stream video into the GPU at sub-frame transfer times.</p> <p>GPUDirect for Video technology is available through the Basler Framegrabber API on host PCs using a Windows OS in</p> <ul> <li>OpenGL (Open Graphics Library), or</li> <li>CUDA (Compute Unified Device Architecture), a parallel programming framework by NVIDIA.</li> </ul> <p>NVIDIA GPUDirect for Video is tailored for systems that use an NVIDIA graphics processing unit (GPU). The technology allows to efficiently transfer video frames into NVIDIA GPU memory at low latencies. It gives you full control to stream video into the GPU at sub-frame transfer times.</p> <p>For details, refer to the manufacturers site, sections NVIDIA GPUDirect for Video technology and GPUDirect Technology Overview.</p>"},{"location":"nvidia-gpu-direct-for-video.html#requirements","title":"Requirements","text":"<p>To use GPUDirect for Video technology in combination with Basler frame grabbers, your system has to meet the following requirements:</p>"},{"location":"nvidia-gpu-direct-for-video.html#hardware","title":"Hardware","text":"<p>For the latest list of supported NVIDIA GPUs, see here.</p> <p>Basler frame grabber of your choice.</p>"},{"location":"nvidia-gpu-direct-for-video.html#software","title":"Software","text":"<ul> <li>Basler Framegrabber SDK: Version 5.10.0 or higher</li> <li>Operating System on Host PC: Windows 10 (64bit)</li> <li>Parallel Computing Platform/API (see Installation):<ul> <li>CUDA (Compute Unified Device Architecture), version 11.6, or</li> <li>OpenGL (Open Graphics Library)</li> </ul> </li> <li>Recommended IDE: Visual Studio 15.x or higher</li> </ul> <p>Info</p> <p>You may need additional DLL and header files to get GPUDirect for Video running. For more information, contact Basler Technical Support.</p> <p>The support of GPUDirect for Video technology has been tested under Windows 10 and can be guaranteed for this Windows version.</p>"},{"location":"nvidia-gpu-direct-for-video.html#installation","title":"Installation","text":""},{"location":"nvidia-gpu-direct-for-video.html#prerequisites","title":"Prerequisites","text":"<ul> <li>GPU Hardware: An NVIDIA GPU that supports GPUDirect for Video technology has been plugged into your host PC.</li> <li>Parallel Computing Platform/API: One of the following packages has been installed on your host PC:<ul> <li>CUDA (Compute Unified Device Architecture), a parallel programming framework by Nvidia</li> <li>OpenGL (Open Graphics Library)</li> </ul> </li> <li>Frame Grabber Hardware: The Basler frame grabber of your choice has been connected to your host PC. For information how to connect the frame grabber, see Connecting the Frame Grabber.</li> <li>Framegrabber SDK: The Basler Framegrabber SDK 5.10.0 or higher has been installed. For information how to install the runtime software, see Installing the Framegrabber SDK.</li> <li>Applet: The applet of your choice has been flashed onto your frame grabber (only for marathon frame grabbers) and is selected as active applet. For information how to flash the marathon frame grabber, see Flashing. For information how to select an applet as active applet, see Changing the Active Applet.</li> <li>GPUDirect for Video Support Files: Basler provides you with the following files:<ul> <li>siso_gpudirect.dll: library file</li> <li>siso_gpudirect.h: header file covering the general functions always required</li> <li>siso_gpudirect_cuda.h: header file required for working with CUDA</li> <li>siso_gpudirect_gl.h: header file required for working in OpenGL.</li> </ul> </li> </ul>"},{"location":"nvidia-gpu-direct-for-video.html#installing-gpudirect-for-video-support","title":"Installing GPUDirect for Video Support","text":"<p>To install GPUDirect for Video support on your host PC:</p> <ol> <li>Copy the library file siso_gpudirect.dll into your Basler Framegrabber SDK installation directory into subfolder bin, e.g., C:\\Program Files\\Basler\\FramegrabberSDK_5.XX.X\\bin.</li> <li>Copy the header files into the into the subfolder include of your Basler Framegrabber SDK installation directory into , e.g., C:\\Program Files\\Basler\\FramegrabberSDK_5.XX.X\\include.</li> </ol> <p>After copying the files into the mentioned subfolders of your installation, you can use the functions of GPUDirect for Video via the Basler Framegrabber API.</p>"},{"location":"nvidia-gpu-direct-for-video.html#function-reference","title":"Function Reference","text":"<p>You use either CUDA or OpenGL for controlling GPUDirect for Video via the Basler Framegrabber API.</p>"},{"location":"nvidia-gpu-direct-for-video.html#prerequisites-for-using-cuda","title":"Prerequisites for Using CUDA","text":"<ul> <li>The library file siso_gpudirect.dll has been copied into the subfolder bin of your Framegrabber SDK installation.</li> <li>The header files siso_gpudirect.h and siso_gpudirect_cuda.h have been copied into the subfolder include of your Framegrabber SDK installation.</li> </ul>"},{"location":"nvidia-gpu-direct-for-video.html#prerequisites-for-using-opengl","title":"Prerequisites for Using OpenGL","text":"<ul> <li>The library file siso_gpudirect.dll has been copied into the subfolder bin of your Framegrabber SDK installation.</li> <li>The header files siso_gpudirect.h and siso_gpudirect_gl.h have been copied into the subfolder include of your Framegrabber SDK installation.</li> </ul>"},{"location":"nvidia-gpu-direct-for-video.html#available-functions","title":"Available Functions","text":"<p>The functions for controlling the GPUDirect for Video technology via the Basler Framegrabber API are the same for CUDA and OpenGL. The Basler Framegrabber API offers the following functions:</p> Function <code>GDInitLib</code> Description Global Initialization. Call this function prior to any other function for initialization. Parameters <ul><li> <code>[in] Fg_Struct* iFgHandle</code>:Handle of a valid frame grabber instance. See documentation of library fglib in the Framegrabber API Manual.</li><li><code>[in] GD_CONTEXT iFlag</code>:Define here which technology you are going to use. Possible Values (GD_CTX_LIST):<ul><li><code>GD_CTX_CUDA</code>: indicating use with CUDA</li><li><code>GD_CTX_OPENGL</code>: indicating use with OpenGL</li><li><code>GD_CTX_D3D9</code>: not supported</li><li><code>GD_CTX_D3D11</code>: not supported</li></ul></li></ul> Function <code>GDCloseLib</code> Description After no function of the library is needed anymore, you must call this function to clean up the resources from the <code>GDInitLib</code> function call. Each call to <code>GCCloseLib</code> has to be accompanied by a preceding call to <code>GDInitLib</code>. Parameters None Function <code>GDGetContextInfo</code> Description Use this function to get information about the current context. Parameters <ul><li> <code>[in] GD_CONTEXT_INFO_CMD iInfoCmd</code>:Use this parameter to indicate the information you want to get. Only available value: <code>GD_CONTEXT_STRIDE_LENGTH</code>. :The stride length is defined as follows: When a video image is stored in memory, the memory buffer might contain extra padding bytes after each row of pixels. The padding bytes affect how the image is stored in memory, but don't affect how the image is displayed. The stride is the number of bytes from one row of pixels in memory to the next row of pixels in memory. Stride is also called pitch. If padding bytes are present, the stride is wider than the width of the image, as shown in the following illustration. Two buffers that contain video frames with equal dimensions can have two different strides. If you process a video image, you must take the stride into account.:Source: https://msdn.microsoft.com/en-us/library/windows/desktop/aa473780(v=vs.85).aspx:Make sure the image dimensions you define match the padding constraints.</li><li><code>[out] void * pBuffer</code>&lt;:/br&gt;The information provided (i.e. input value), for example, the value of the stride length, is written into this buffer. If <code>pBuffer = NULL</code>, <code>piSize</code> provides the size that is needed by the buffer in order to be able to save the information (i.e., the output value).</li><li><code>[in/out] size_t * piSize</code>:When calling this function, you must define the size of <code>pBuffer</code> in this parameter. In case the size is to small (for the length of the buffer that is handed over), the value for <code>size</code> is automatically adapted to fit the size of the buffer. After being called, this parameter holds the number of bytes that have been written into <code>pBuffer</code>.</li></ul> Function <code>GDRevokeBuffer</code> Description Removes an announced buffer from the acquisition engine. This function will free all internally allocated resources associated with this buffer. A buffer can only be revoked if it isn't queued in any queue. Parameters <code>[in] BUFFER_HANDLE</code>:Handle referencing to the buffer. The buffer itself has been announced via the function <code>GDAllocateSourceBuffer</code>, <code>GDAnnounceCUDAArray</code>, <code>GDAnnounceTextureGL</code>, or <code>GDAnnounceBufferGL</code>. Function <code>GDStartAcquisition</code> Description Starts the acquisition engine. Parameters None Function <code>GDStartAcquisitionEx</code> Description Starts the acquisition engine. Parameters <ul><li> <code>[in] unsigned int apcTimeout</code>:Sets the time-out duration (in seconds) for the acquisition engine.Default: 5 seconds.</li><li><code>[in] unsigned int apcFlags</code>:Flags to enable or disable specific features of the acquisition engine.Refer to Registering a Callback Function for Asynchronous Mode for a list of flags.Default: <code>GD_ACQUISITION_DEFAULT_FLAGS</code>\u2192 This evaluates to: <code>FG_APC_IGNORE_TIMEOUTS | FG_APC_DELIVER_ERRORS</code>.Flag details:<ul><li><code>FG_APC_DELIVER_ERRORS</code>: Required for <code>GDGetLastError</code> to function correctly.</li><li><code>FG_APC_IGNORE_TIMEOUTS</code>: Ensures that the acquisition engine continues running even if no image data is received within the time specified in <code>apcTimeout</code>.</li></ul></li></ul> Function <code>GDStopAcquisition</code> Description Stops the acquisition engine. Parameters None Function <code>GDAllocateSourceBuffer</code> Description This function allocates the memory for a single source buffer, announces this buffer to the acquisition engine, and returns a buffer handle which references that single buffer. Parameters <ul><li><code>[in] uint32_t width</code>:  image width</li><li><code>[in] uint32_t height</code>: image height</li><li><code>[in] GDBufferTypes type</code>: Use this parameter to define the pixel format. Possible Values: <ul><li><code>GD_UNSIGNED_BYTE</code></li><li><code>GD_BYTE</code></li><li><code>GD_UNSIGNED_SHORT</code></li><li><code>GD_SHORT</code></li><li><code>GD_UNSIGNED_INT</code></li><li><code>GD_INT</code></li><li><code>GD_FLOAT</code></li><li><code>GD_HALF_FLOAT</code></li><li><code>GD_UNSIGNED_BYTE_3_3_2</code></li><li><code>GD_UNSIGNED_BYTE_2_3_3_REV</code></li><li><code>GD_UNSIGNED_SHORT_5_6_5</code></li><li><code>GD_UNSIGNED_SHORT_5_6_5_REV</code></li><li><code>GD_UNSIGNED_SHORT_4_4_4_4</code></li><li><code>GD_UNSIGNED_SHORT_4_4_4_4_REV</code></li><li><code>GD_UNSIGNED_SHORT_5_5_5_1</code></li><li><code>GD_UNSIGNED_SHORT_1_5_5_5_REV</code></li><li><code>GD_UNSIGNED_INT_8_8_8_8</code></li><li><code>GD_UNSIGNED_INT_8_8_8_8_REV</code></li><li><code>GD_UNSIGNED_INT_10_10_10_2</code></li><li><code>GD_UNSIGNED_INT_2_10_10_10_REV</code></li></ul></li><li><code>[out] BUFFER_HANDLE*</code>: handle</li></ul> Function <code>GDRegisterEvent</code> Description Registers an event object to a certain <code>iEventID</code>. Parameters <ul><li>[in] <code>EVENT_TYPE iEventID</code>:Possible values:<ul><li><code>EVENT_ERROR</code>: Notification on module errors.</li><li><code>EVENT_COPY_FINISHED</code>: Notification on newly filled buffers. The event data are stored in an <code>EVENT_NEW_BUFFER_DATA</code>. Alternatively, you can use the function <code>GDMemcpy</code>.</li></ul> </li><li><code>[out] EVENT_HANDLE* phEvent</code>:Use this handle to get the events via the function <code>GDEventGetData</code>.</li></ul> Function <code>GDEventGetData</code> Description Retrieves the next event data entry from the event data queue associated with the event handle. Parameters <ul><li><code>[in] EVENT_HANDLE phEvent</code>: You have already created this handle via function <code>GDRegisterEvent</code>.</li><li><code>[out] void * pBuffer</code>:The information provided (i.e. the output value) is written into this buffer. If <code>pBuffer = NULL</code>, <code>piSize</code> provides the size that is needed by the buffer in order to be able to save the information (i.e., the output value).</li><li><code>[in/out] size_t * piSize</code>:When calling this function, you must define the size of <code>pBuffer</code> in this parameter. In case the size is to small (for the length of the buffer that is handed over), the value for <code>size</code> is automatically adapted to fit the size of the buffer. After being called, this parameter holds the number of bytes that have been written into <code>pBuffer</code>.</li><li><code>[in] uint64_t iTimeout</code>&lt;:/br/&gt; The function doesn't deliver any output until the time-out is over (in this case, the function returns state <code>GD_ERR_TIMEOUT</code> ), or until the specified event occurs.</li></ul> Function <code>GDMemcpy</code> Description Copies the next frame that has been delivered by the frame grabber into the GPU. Use this function if you want to trigger the copy process. The result is delivered as <code>EVENT_NEW_BUFFER_DATA</code> type. Parameters <ul><li><code>[out] void * pBuffer</code>:The value is written into this buffer. If <code>pBuffer = NULL</code>, <code>piSize</code> provides the size that is needed by the buffer in order to be able to save the <code>EVENT_NEW_BUFFER_DATA</code> type.</li><li><code>[in/out] size_t * piSize</code>:When calling this function, you must define the size of <code>pBuffer</code> in this parameter. In case the size is to small (for the length of the buffer that is handed over), the value for <code>size</code> is automatically adapted to fit the size of the buffer. After being called, this parameter holds the number of bytes that have been written into <code>pBuffer</code>. Function <code>GDBufferUnblock</code> Description This function unblocks buffer for the copying process. Each buffer that you have received as member of <code>EVENT_NEW_BUFFER_DATA</code> needs to be unblocked via this function (e.g., in order to have buffer for new copy processes). Make sure your operations on the buffer content have been completed before you unblock a buffer. Parameters <code>[in] BUFFER_HANDLE phBuffer</code> Function <code>GDBufferGetDataPtr</code> Description This function returns the pointer to the starting point of the memory location of the buffer. The buffer must have been created with the <code>GDAllocateSourceBuffer</code> function. Parameters <ul><li><code>[in] BUFFER_HANDLE phBuffer</code></li><li><code>[out] void** mDataPtr</code> :Contains the pointer that points to the raw data that are managed by this buffer.</li></ul> Function <code>GGDGetBufferInfo</code> Description Use this function to inquire information about the buffer module associated with this buffer handle. Parameters <ul><li> <code>[in] BUFFER_HANDLE hBuffer</code></li><li><code>[in] GD_BUFFER_INFO_CMD iInfoCmd</code>:Possible values:<ul><li><code>GD_BUFFER_TIMESTAMP</code>: Time stamp last change in buffer.</li><li><code>GD_BUFFER_TIMESTAMP_FREQUENCY</code>: Frequency for time stamp.</li><li><code>GD_BUFFER_PICNUMBER</code>: Index for buffer content.</li><li><code>GD_BUFFER_DATA_PTR</code>: Pointer to the raw data that are managed by the buffer.</li></ul></li><li><code>[out] void * pBuffer</code>:The value is written into this buffer. If <code>pBuffer = NULL</code>, <code>piSize</code> provides the size that is needed by the buffer in order to be able to save the data.</li><li><code>[in/out] size_t * piSize</code> :When calling this function, you must define the size of <code>pBuffer</code> in this parameter. In case the size is to small (for the length of the buffer that is handed over) the value for size is automatically adapted to fit the size of the buffer. After being called, this parameter holds the number of bytes that have been written into <code>pBuffer</code>. Function <code>GDGetLastError</code> Description Use this function to inquire the message associated with the last error that occurred. Parameters <ul><li><code>[out] char * pMsgBuffer</code>:The value is written into this buffer. If <code>pMsgBuffer = NULL</code>, <code>piSize</code> provides the size that is needed by the buffer in order to be able to save the error message.</li><li><code>[in/out] size_t * piSize</code> :When calling this function, you must define the size of <code>pMsgBuffer</code> in this parameter. In case the size is to small (for the message that is handed over) the value for <code>size</code> is automatically adapted to fit the size of the message. After being called, this parameter holds the number of bytes that have been written into <code>pBuffer</code>.</li></ul> Function <code>GDAnnounceTextureGL</code> Description This function announces a target object as a destination for copy operations and returns a buffer handle which references that single buffer. Parameters <ul><li><code>[in]GLuint texture</code>:ID of the texture you have created with openGL.</li><li><code>[out]BUFFER_HANDLE* handle</code>: The handle that points to this buffer.</li></ul> Function <code>GDAnnounceBufferGL</code> Description This function announces a target object as a destination for copy operations and returns a buffer handle which references that single buffer. Parameters <ul><li><code>[in]GLuint buffer</code>:ID of the texture you have created with openGL.</li><li><code>[out]BUFFER_HANDLE* handle</code>: The handle that points to this buffer.</li></ul> Function <code>GDAnnounceCUDAArray</code> Description This function announces a target object as a destination for copy operations and returns a buffer handle which references that single buffer. Parameters <ul><li><code>CUarray array</code>:The handle that references the buffer you have created with CUDA.</li><li><code>BUFFER_HANDLE* handle</code>: The handle that points to this buffer.</li></ul>"},{"location":"nvidia-gpu-direct-for-video.html#data-types","title":"Data Types","text":"Name of STRUCT <code>EVENT_NEW_BUFFER_DATA</code> Description The event has copied the content of the source buffer into the target buffer. Parameters <ul><li><code>BUFFER_HANDLE SourceBufferHandle</code>:You have created this buffer via function <code>GDAllocateSourceBuffer</code>.</li><li><code>BUFFER_HANDLE TargetBufferHandle</code>: You have created this buffer via function <code>GDAnnounceCUDAArray</code> (CUDA), or via function <code>GDAnnounceTextureGL</code> or <code>PGDAnnounceBufferGL</code> (OpenGL).</li></ul>"},{"location":"nvidia-gpu-direct-for-video.html#enumerations","title":"Enumerations","text":"<code>GD_CTX_LIST</code> <code>GD_CTX_CUDA</code> Name of CUDA context <code>GD_CTX_OPENGL</code> Name of OpenGL context <code>GD_CTX_D3D9</code> Not supported <code>GD_CTX_D3D11</code> Not supported <code>GD_CONTEXT_INFO_LIST</code> <code>GD_CONTEXT_STRIDE_LENGTH</code> :Source: https://msdn.microsoft.com/en-us/library/windows/desktop/aa473780(v=vs.85).aspx <code>GDBufferTypes</code> <code>GD_UNSIGNED_BYTE</code> <code>GD_BYTE</code> <code>GD_UNSIGNED_SHORT</code> <code>GD_SHORT</code> <code>GD_UNSIGNED_INT</code> <code>GD_INT</code> <code>GD_FLOAT</code> <code>GD_HALF_FLOAT</code> <code>GD_UNSIGNED_BYTE_3_3_2</code> <code>GD_UNSIGNED_BYTE_2_3_3_REV</code> <code>GD_UNSIGNED_SHORT_5_6_5</code> <code>GD_UNSIGNED_SHORT_5_6_5_REV</code> <code>GD_UNSIGNED_SHORT_4_4_4_4</code> <code>GD_UNSIGNED_SHORT_4_4_4_4_REV</code> <code>GD_UNSIGNED_SHORT_5_5_5_1</code> <code>GD_UNSIGNED_SHORT_1_5_5_5_REV</code> <code>GD_UNSIGNED_INT_8_8_8_8</code> <code>GD_UNSIGNED_INT_8_8_8_8_REV</code> <code>GD_UNSIGNED_INT_10_10_10_2</code> <code>GD_UNSIGNED_INT_2_10_10_10_REV</code> <code>EVENT_TYPE_LIST</code> <code>EVENT_ERROR</code> Notification on module errors. <code>EVENT_COPY_FINISHED</code> Notification on newly filled buffers. The event data are stored in an <code>EVENT_NEW_BUFFER_DATA</code>. <code>GD_BUFFER_INFO_LIST</code> <code>GD_BUFFER_TIMESTAMP</code> Time stamp last change in buffer <code>GD_BUFFER_TIMESTAMP_FREQUENCY</code> Frequency for time stamp <code>GD_BUFFER_PICNUMBER</code> Index for buffer content <code>GD_BUFFER_DATA_PTR</code> Pointer to the raw data that are managed by the buffer"},{"location":"nvidia-gpu-direct-for-video.html#examples","title":"Examples","text":""},{"location":"nvidia-gpu-direct-for-video.html#prerequisites_1","title":"Prerequisites","text":"<ul> <li>You have the examples folder you received from Basler available.</li> <li>Visual Studio 15.x or higher is installed on your PC.</li> <li>CMake is installed on your PC.</li> <li>The according libraries are installed on your PC.</li> </ul>"},{"location":"nvidia-gpu-direct-for-video.html#using-the-examples","title":"Using the Examples","text":"<p>To use the examples provided by Basler:</p> <ol> <li> <p>Copy the examples folder you received from Basler to the hard drive of your host PC.</p> <p>CUDA Example</p> <p>For the CUDA example you only need cuda.lib and cudart.lib in addition to the libraries already installed on your PC.</p> <p>OpenGL Example: Glew must be found by CMake</p> <p>Make sure CMake can find the glew - otherwise, the project will not be built correctly.</p> <p>CMake should be able to find the glew without your interaction. However, in case it doesn't find the glew:</p> <ol> <li> <p>Set the according enviromnent variables:</p> <p><code>GLUT_ROOT_PATH</code> for example to D:\\libs\\freeglut-2.8.1\\win32</p> <p><code>GLEW_ROOT_PATH</code> for example to D:\\libs\\glew-1.13.0\\glew-1.13.0\\Win32</p> </li> <li> <p>If CMake has still trouble to find the glew, set the CMake project variables manually:</p> <p><code>GLEW_INCLUDE_DIR</code> for example to D:/libs/glew-1.13.0/glew-1.13.0/x64/include</p> <p><code>GLEW_LIBRARY</code> for example to D:/libs/glew-1.13.0/glew-1.13.0/x64/lib/glew32.lib</p> <p><code>OPENGL_gl_LIBRARY</code> for example to opengl32</p> <p><code>OPENGL_glu_LIBRARY</code> for example to glu32</p> </li> </ol> </li> <li> <p>Create a project using CMake with examples\\gpudirect\\cuda or examples\\gpudirect\\opengl as source directory.</p> </li> <li>Run the example.</li> </ol> <p>While executing the examples, you will be asked to select an applet. Select a grayscale applet, for example, Acq_SingleCXP6X4AreaGray.dll for a marathon frame grabber. The name is somewhat cut off, you'll only see the end.</p> <p>For marathon Frame Grabbers: Use Grayscale Applet for Examples</p> <p>The Basler NVIDIA GPUDirect for Video support works with color formats as well as with grayscale formats.</p> <p>However, as both examples are designed for use with grayscale applets, make sure you select a grayscale applet for using the examples, e.g., Acq_SingleCXP6X4AreaGray.dll (only for marathon frame grabbers).</p>"},{"location":"opto-coupled-trigger-5.html","title":"Opto-Coupled Trigger 5","text":"<p>The Opto-Coupled Trigger 5 board is a trigger extension board that can be used with all frame grabbers of the microEnable 5 marathon and microEnable 6 imaWorx and imaFlex series.</p> <p>It offers 16 opto-coupled (galvanically isolated) trigger signals for controlling cameras and peripheral devices. Its signals can be adapted to the industrial signal level (typically 5\u201324 VDC).</p> <p>Using the board, you can synchronize multiple frame grabbers. It is configurable and can replace any of the six variants of its predecessor Basler OPTO trigger board IV.</p> <p>Info</p> <p>The Opto-Coupled Trigger 5 board is a hardware extension that must be purchased separately. For availability and pricing, see the product page on the Basler website.</p> <p>The board can be connected to a frame grabber via a 34-pin flat cable:</p> <p></p> <p>The following image shows the board installed in a computer:</p> <p></p> <p>The following image shows an example of a production line using the Opto-Coupled Trigger 5 board:</p> <p></p> <p>Info</p> <p>You can configure the individual I/Os of the trigger extension board using applets. Refer to the documentation of your specific applet.</p>"},{"location":"opto-coupled-trigger-5.html#package-contents","title":"Package Contents","text":"<p>The following items are included in the package:</p> <ul> <li>Opto-Coupled Trigger 5 board (order number 2200000371)</li> <li>34-pin flat cable for connecting the trigger board to the frame grabber</li> </ul> <p></p> <p>Info</p> <ul> <li>You can order additional equipment, such as a 34-pin flat cables for multi-board installation, directly from Basler.</li> <li>To connect to multiple trigger boards, Basler recommends using a specific 34-pin flat cable provided by Basler, the \"Multi-Board Trigger Cable\". It offers a connector for the trigger board and multiple connectors for Opto-Coupled Trigger 5 devices. The signals of the cable use open collector drivers.The Multi-Board Trigger Cable is available in two variants:<ul> <li>Multi-Board Trigger Cable \u2013 Left (order number 2200000374)</li> <li>Multi-Board Trigger Cable \u2013 Right (order number 2200000480)</li> </ul> </li> </ul> <p>Contact Basler Sales for additional ordering information.</p>"},{"location":"opto-coupled-trigger-5.html#ports-and-leds","title":"Ports and LEDs","text":"<p>The following ports and LEDs are available on the board:</p> <p></p> <p>The GPIs and GPOs are mapped to two ports, port A and port B:</p> <p></p> <p>The board offers 8 inputs and 8 outputs on its two female SUB-D 15 sockets:</p> Port A Port B 4 inputs  4 inputs  4 outputs  4 outputs  <p>You can configure various parameters that allow you to use the board in different operation modes:</p> <ul> <li>You can configure the IN pins of port A to receive single-ended or differential incoming signals.</li> <li>You can configure the IN pins of port B to receive single-ended or differential incoming signals.</li> <li>You can configure whether you want to use the IN pins in pull-up or pull-down mode.</li> <li>You can configure whether the outgoing signals are inverted or not.</li> </ul> <p>For details on configuring the board, refer to the Configuring the Physical Interface section.</p> <p>For information which signals are received by the board via the flat cable, see Flat Cable Pinout.</p>"},{"location":"opto-coupled-trigger-5.html#pin-layout-opto-coupled-trigger-5","title":"PIN Layout Opto-Coupled Trigger 5","text":"<p>All GPIs and GPOs available on the board are mapped to the two SUB D15 sockets (Port A and Port B). They have the following indices:</p> Port A Port B 4 IN port A  (indices 0\u20133)  4 IN port B  (indices 4\u20137)  4 OUT port A (indices 0\u20133)  4 OUT port B  (indices 4\u20137)  Pin Number Signal Name Signal Name 1 Trigger Output 0 Port A Trigger Output 4 Port B 2 Trigger Output 1 Port A Trigger Output 5 Port B 3 Trigger Output 2 Port A Trigger Output 6 Port B 4 Trigger Output 3 Port A Trigger Output 7 Port B 5 V_IN (VCC Input Port A) V_IN (VCC Input Port B) 6 GND Port A GND Port B 7 nc nc 8 nc nc 9 nc nc 10 V_IN (VCC Input Port A) V_IN (VCC Input Port B) 11 Trigger Input 0 Port A (+ if used for diff. signal) Trigger Input 4 Port B  (+ if used for diff. signal) 12 Trigger Input 1 Port A (- if used for diff. signal) Trigger Input 5 Port B(- if used for diff. signal) 13 Trigger Input 2 Port A(+ if used for diff. signal) Trigger Input 6 Port B (+ if used for diff. signal) 14 Trigger Input 3 Port A (- if used for diff. signal) Trigger Input 7 Port B   (- if used for diff. signal) 15 GND Port A GND Port B <p>Info</p> <ul> <li>The power must be delivered by an external power source.</li> <li>The input signals aren't passed directly to the opto-couplers but sent to differential comparators. This has the benefit that the input can accept low current, voltage driven signals between 5 and 25 VDC. (Input signals can have pull-up or pull-down resistor of 10 k\u03a9.) The polarity of the input signals is not inverted.</li> <li>On Opto-Coupled Trigger 5 boards, the opto-couplers don't connect directly to the output, but are buffered by MOSFET transistors. These transistors build an easy-to-use open collector driver with a 20 mA static current diode as pull-up.</li> </ul>"},{"location":"opto-coupled-trigger-5.html#configuring-the-physical-interface","title":"Configuring the Physical Interface","text":"<p>You can configure various parameters that allow you to use the Opto-Coupled Trigger 5 board in different operation modes:</p> <ul> <li>You can configure the IN pins of port A to receive single-ended or differential signals.</li> <li>You can configure the IN pins of port B to receive single-ended or differential signals.</li> <li>You can configure whether the IN pins of both ports should operate in pull-up or pull-down mode.</li> <li>You can configure whether outgoing signals are inverted or not.</li> </ul> <p>You set the individual parameters via the DIP switches located directly on the trigger board.</p> <p>Info</p> <p>When using a microEnable 5 marathon frame grabber, you can change the configuration using the <code>gpiotool</code> command line tool. Configuration by software overrides the DIP switch setting.</p> <p>The LEDs on the board inform you which settings are active.</p> <p></p> <p>Info</p> <p>The software configuration always overrides the position of the DIP switches. Therefore, the position of the DIP switches on the board may not represent the actual setting. To know which settings are active, always rely on the LEDs.</p>"},{"location":"opto-coupled-trigger-5.html#default-settings","title":"Default Settings","text":"<p>At delivery, the default settings are active. All DIP switches and all LEDs on the Opto-Coupled Trigger 5 board are set to Off.</p> <p>The default settings for the Opto-Coupled Trigger 5 board are as follows:</p> <ul> <li>Port A receives four single-ended incoming signals.</li> <li>Port B receives four single-ended incoming signals.</li> <li>The trigger board is in pull-up mode.</li> <li>The outgoing signals aren't inverted.</li> </ul> <p>By default, the four LEDs are set to Off:</p> <p></p>"},{"location":"opto-coupled-trigger-5.html#single-ended-differential-in-signals","title":"Single Ended / Differential IN Signals","text":"<p>You can configure the IN pins of the Opto-Coupled Trigger 5 board as follows:</p> <ol> <li> <p>All IN pins of port A and B receive single ended inputs (= 8 single-ended IN signals):</p> <p></p> <p>This is the default setting. The DIP switches for port A (switch 1) and port B (switch 2) are in Off position. The LEDs for port A (A DS) and port B (B DS) are off:</p> <p> 2. All IN pins of port A and B receive differential inputs (= 4 differential IN signals, i.e., 4 pairs):</p> <p></p> <p>The DIP switches for port A (switch 1) and port B (switch 2) are in On position. The LEDs for port A (A DS) and B (B DS) are on:</p> <p> 3. All IN pins of port A receive single-ended inputs, all IN pins of port B receive differential inputs (= four single-ended IN signals on A + two differential signals on B):</p> <p></p> <p>The DIP switch for port A (switch 1) is in Off position. The LED for port A (A DS) is off. The DIP switch for port B (switch 2) is in On position. The LED for port B (B DS) is on:</p> <p></p> </li> <li> <p>All IN pins of port A receive differential inputs, all IN pins of port B receive single-ended inputs (= two differential signals on A + four single-ended IN signals on B):</p> <p></p> <p>The DIP switch for port A (switch 1) is in On position. The LED for port A (A DS) is on. The DIP switch for port B (switch 2) is in Off position. The LED for port B (B DS) is off:</p> <p></p> </li> </ol>"},{"location":"opto-coupled-trigger-5.html#pull-up-pull-down","title":"Pull Up / Pull Down","text":"<p>You can configure the Opto-Coupled Trigger 5 board according to the electrical source of the incoming signal:</p> <ul> <li>Use pull-up (10 k\u03a9) to receive signals from NPN transistors (open collector, open drain).</li> <li>Use pull-down (10 k\u03a9) to receive signals from PNP transistors (open emitter, open source).</li> </ul> <p>In most application scenarios, you should configure the Opto-Coupled Trigger 5 board to pull-up.</p> <ul> <li> <p>Pull-up: This is the default setting.  The DIP switch for transistor mode (switch 3) is in Off position. The LED P DN is off:</p> <p></p> </li> <li> <p>Pull-Down: The DIP switch for transistor mode (switch 3) is in Off position. The LED P DN is off:</p> <p></p> </li> </ul>"},{"location":"opto-coupled-trigger-5.html#inverted-out-signals","title":"Inverted OUT Signals","text":"<p>You can configure the OUT pins of the trigger board to invert the outgoing trigger signals.</p> <p>All high (1) signals are converted to low (0) signals and vice versa.</p> <ul> <li> <p>Not Inverted: This is the default setting. The DIP switch for inversion (switch 4) is in Off position. The LED O INV is off:</p> <p></p> </li> <li> <p>Inverted: The DIP switch for inversion (switch 4) is in On position. The LED O INV is on:</p> <p></p> </li> </ul>"},{"location":"opto-coupled-trigger-5.html#configuration-via-software","title":"Configuration via Software","text":"<p>If you use the Opto-Coupled Trigger 5 board with a marathon frame grabber, you can also use software to configure the physical interface of the Opto-Coupled Trigger 5 board.</p> <p>When you configure the Opto-Coupled Trigger 5 board via software, the position of the DIP switches doesn't provide any information about the actual configuration.</p> <p>However, the LEDs on the Opto-Coupled Trigger 5 board always inform you which setting is active. In addition, you can use the software to get information about the current settings.</p> <p>Info</p> <ul> <li>You can reset a board to the current DIP switch settings. This overrides the software configuration. For more information, see gpioTool.</li> <li>When the Opto-Coupled Trigger 5 board has been configured via software, the O INV LED may appear less bright than the other LEDs. This is a known issue and has no impact on functionality.</li> </ul>"},{"location":"opto-coupled-trigger-5.html#configuration-via-command-line","title":"Configuration via Command Line","text":"<p>To configure the physical interface of the Opto-Coupled Trigger 5 board via command line, use the <code>gpioTool</code> command line tool.</p>"},{"location":"opto-coupled-trigger-5.html#led-status","title":"LED Status","text":"LED Label LED not active LED active A DS Port A receives 4 single-ended incoming signals. Port A receives 2 differential incoming signals. B DS Port B receives 4 single-ended incoming signals. Port B receives 2 differential incoming signals. P DN The trigger board is in pull-up mode. The trigger board is in pull-down mode. O INV The outgoing signals aren't inverted. The outgoing signals are inverted. <p>Info</p> <p>The LEDs always show the actual configuration, regardless of whether it was made via DIP switches or via software.</p>"},{"location":"opto-coupled-trigger-5.html#electrical-characteristics","title":"Electrical Characteristics","text":"<p>There are three power and ground systems on the Opto-Coupled Trigger 5 board. One supplies the signals of the port A connector, another one the signals of the port B connector, and the third one the signals of the flat cable connector. There is no electrical connection between these three systems.</p> <p>Each of the systems may have a different supply voltage. The voltage range is between 5 and 25.0 VDC. The signal voltage is defined by the supply voltage for both input and output. See below for details on the electrical characteristics.</p> <p>The following information applies to the physical input and output ports of both ports A and B.</p>"},{"location":"opto-coupled-trigger-5.html#inputs","title":"Inputs","text":"Min Typical Max Unit Supply Voltage 4.5 VDC 28 VDC V Input Threshold 20% supply voltage V Differential InputOffset Voltage 10 mV mV Input Current 4 mA (per channel) <p>Info</p> <ul> <li>The input signals aren't passed directly to the opto-couplers but sent to differential comparators. This has the benefit that the input can accept low current, voltage driven signals between 5 and 25 VDC. (Input signals can have pull-up or pull-down resistor of 10 k\u03a9.) The polarity of the input signals is not inverted.</li> <li>The board has been designed with a varistor which opens at an input voltage of 30 VDC to let the onboard surge protector get active to protect the board. At a total supply voltage of 36 VDC, the electronic chips will become defective.</li> </ul>"},{"location":"opto-coupled-trigger-5.html#outputs","title":"Outputs","text":"Min Typical Max Unit Supply Voltage (Max. Supply Current per Port) 4.5 VDC 28 VDC V Output Signal Voltage High -0.3 VDC Supply Voltage V Output Signal Voltage Low 0.3 mV Output Current 20 mA (per channel) <p>The supply current required for each port of the Opto-Coupled Trigger 5 board depends on the number of used inputs and outputs, the signal and the voltage level. Typical supply current required per port: &lt; 200 mA/port</p> <p>Info</p> <ul> <li>On Opto-Coupled Trigger 5 boards, the opto-couplers don't directly connect to the output, but are buffered by MOSFET transistors. These transistors build an easy-to-use open collector driver with a 20 mA static current diode as pull-up. Note that the power must be delivered by the external power source.</li> <li>The board has been designed with a varistor which opens at an input voltage of 30 VDC to let the onboard surge protector get active to protect the board. At a total supply voltage of 36 VDC, the electronic chips will become defective.</li> </ul>"},{"location":"opto-coupled-trigger-5.html#timing-characteristics","title":"Timing Characteristics","text":""},{"location":"opto-coupled-trigger-5.html#inputs_1","title":"Inputs","text":"Min Typical Max Unit Propagation Delay 200 230 260 ns Min. Pulse Width 200 ns Max. Frequency (50% Duty Cycle) 2.5 MHz"},{"location":"opto-coupled-trigger-5.html#outputs_1","title":"Outputs","text":"Min Typical Max Unit Propagation Delay 40 60 80 ns Min. Pulse Width 200 ns Max. Frequency (50% Duty Cycle) 2.5 MHz <p>Because a static current diode is used as a pull-up of the output signal, there is a static rise time that leads to different low-high transition delays for different voltages and loads. The delay time is measured without load from and to 50 % of the signal level.</p>"},{"location":"opto-coupled-trigger-5.html#schematic-drawings","title":"Schematic Drawings","text":""},{"location":"opto-coupled-trigger-5.html#input-circuits","title":"Input Circuits","text":""},{"location":"opto-coupled-trigger-5.html#port-a","title":"Port A","text":"<p>Port A offers the trigger inputs 0, 1, 2, and 3. Voltage IN (V_IN) and Ground (GND_IN) are galvanically isolated from the host computer:</p> <p></p>"},{"location":"opto-coupled-trigger-5.html#port-b","title":"Port B","text":"<p>Port B offers the trigger inputs 4, 5, 6, and 7. Voltage IN (V_IN) and Ground (GND_IN) are galvanically isolated from the host computer:</p> <p></p>"},{"location":"opto-coupled-trigger-5.html#output-circuits","title":"Output Circuits","text":"<p>Voltage IN (V_IN) and ground IN (GND_IN) are galvanically isolated from the host computer:</p> <p></p>"},{"location":"opto-coupled-trigger-5.html#appendix","title":"Appendix","text":""},{"location":"opto-coupled-trigger-5.html#flat-cable-pinout","title":"Flat Cable Pinout","text":"<p>Odd Pin Numbers</p> Pin Number I/O Name 1 Trigger Output 0 3 Trigger Output 1 5 Trigger Output 2 7 Trigger Output 3 9 Trigger Input 0 11 Trigger Input 1 13 Trigger Input 2 15 Trigger Input 3 17 Trigger Output 4 19 Trigger Output 5 21 Trigger Output 6 23 Trigger Output 7 25 Trigger Input 4 27 Trigger Input 5 29 Trigger Input 6 31 Trigger Input 7 33 Presence Detect <p>Even Pin Numbers</p> Pin Number I/O Name 2 +3.3 VDC 4 +3.3 VDC 6 GND 8 GND 10 GND 12 GND 14 GND 16 GND 18 GND 20 GND 22 GND 24 GND 26 GND 28 GND 30 GND 32 VCCIO (+2.5 VDC / 3.3 VDC) 34 VCCIO (+2.5 VDC / 3.3 VDC)"},{"location":"other-tasks-micro-diagnostics.html","title":"Other Tasks (microDiagnostics)","text":""},{"location":"other-tasks-micro-diagnostics.html#re-sorting-boards","title":"Re-Sorting Boards","text":"<p>Each frame grabber in the host computer has a unique board ID. The board ID is used as frame grabber handle in the Framegrabber API.</p> <p>The board ID is displayed in microDiagnostics:</p> <p></p> <p>The numbering doesn't necessarily correspond to the order of the frame grabbers in the computer. You can re-number the board IDs using the option Tools -&gt; Re-Sort Boards in microDiagnostics.</p> <p>For managing the DMA transfers of multiple frame grabbers in one system, you have the DMA indexes (DmaIndex) available for handling the DMA channels of the individual boards.</p> <p>You can change the order of the frame grabber boards in your system. To do so, it is enough to assign new Board IDs to the individual frame grabber boards.</p> <p>To re-sort the frame grabber boards:</p> <ol> <li>From the menu, select Tools -&gt; Re-Sort Boards.</li> <li>Double-click the Board ID field.</li> <li> <p>Enter the designated board ID. The designated board ID is displayed in brackets behind the current board ID:</p> <p></p> <p>Do the same for all other boards you want to re-sort. Make sure each ID is used only once. 4. Click the Save button.</p> <p>The ID change is logged in the log file:</p> <p></p> </li> </ol> <p>After restarting microDiagnostics, you see the new order displayed in the frame grabber board listing:</p> <p></p>"},{"location":"other-tasks-micro-diagnostics.html#licensing-a-programmable-frame-grabber","title":"Licensing a Programmable Frame Grabber","text":"<p>You must license your programmable frame grabber (i.e. marathon VCX-QP, marathon VCL, and marathon VCLx), if:</p> <ul> <li>You are using a specific VisualApplets Application for instance 3D-StereoVision, which requires a separate Framegrabber SDK license.</li> </ul> <p>You get the license information directly from Basler, or from your local sales representative/distributor.</p> <p>To license a frame grabber:</p> <ol> <li> <p>Select the board you want to license.</p> <p></p> </li> <li> <p>From the menu, select Tools -&gt; License Board.</p> <p></p> </li> <li> <p>In the dialog that opens, enter the license you received for licensing.</p> </li> <li>Click Load to write the license information into the according memory on the frame grabber.</li> </ol>"},{"location":"other-tasks-micro-display-x.html","title":"Other Tasks (microDisplay X)","text":""},{"location":"other-tasks-micro-display-x.html#setting-user-preferences","title":"Setting User Preferences","text":"<p>You can set parameters in microDisplay X that affect the following:</p> <ul> <li>GUI display of microDisplay X (display of applet and dec/hex/bin display of parameter values)</li> <li>Acquisition parameters (number of buffers, acquisition time out, max. DMA buffer size)</li> <li>Behavior of camera detection and camera control</li> </ul> <p>To set your preferences for working with microDisplay X:</p> <ol> <li>In microDisplay X, from the Tools menu, select Settings.</li> <li> <p>In the dialog that opens, adapt the settings you want to change:</p> <ul> <li>Display of applets: Click GUI, and under Applet Layout / View Mode, decide about the way the applet is displayed in the applet layout pane of the program window. Select if you want get the resources (ports) of an applet listed by process (Process Mode) or by resource type (Resource Mode):<ul> <li>In process mode, the resources (ports) belonging to one process (one acquisition channel) are listed as an entity Acquisition Process in the applet layout pane.</li> <li>In resource mode, under DMAs, all active DMA ports (of applets loaded in microDisplay X) are listed. Under Camera Ports, all cameras connected to the involved frame grabbers are listed.</li> </ul> </li> <li>Default integer display mode: For the display of parameter and pixel values in the program window, you have the options decimal, hexadecimal, and binary available.</li> <li> <p>Acquisition parameters: To set the acquisition parameters, click Acquisition and define your preferences:</p> <p></p> </li> <li> <p>Discovery settings: To set the discovery parameters, click Discovery and define your preferences:</p> <p></p> </li> </ul> </li> </ol>"},{"location":"other-tasks-micro-display-x.html#saving-applet-configuration","title":"Saving Applet Configuration","text":"<p>After you have configured your applet (in microDisplay X or via Framegrabber API), you can save your configuration.</p> <p>Saving the applet configuration allows you to load the applet (on the frame grabber, in microDisplay X and/or in your software) next time with all parameters already set.</p> <p>Info</p> <p>Make sure you work with the same Framegrabber SDK version for saving the applet configuration and for using it. For example, if you configure your applet and save this configuration using the Framegrabber SDK version 5.9.0, you should load the configuration only in a version 5.9.0 environment.</p> <p>The following sections provide all information you need for working with MCF files.</p>"},{"location":"other-tasks-micro-display-x.html#mcf-and-mfs-files","title":"MCF and MFS Files","text":""},{"location":"other-tasks-micro-display-x.html#mcf-files","title":"MCF Files","text":"<p>When you save your applet configuration, the configuration data are saved to file. The configuration file has the file extension *.mcf. (MCF = microEnable Configuration File)</p> <p>The MCF file is saved in text format, so that you can change the settings of individual parameters not only via microDisplay X or API, but also directly in this file.</p> <p></p> <p>The MCF file contains:</p> <ul> <li>The name of the applet it belongs to.</li> <li>All parameter settings you have made (only exception: field values).</li> <li>If required, a link to an MFS file (which contains the field values you have defined during applet configuration).</li> </ul> <p>Camera Configuration in Separate XML File</p> <p>MCF files don't contain the camera configuration. You can save the camera configuration in a separate *.xml file. The MCF file only contains the applet configuration.</p>"},{"location":"other-tasks-micro-display-x.html#mfs-files","title":"MFS Files","text":"<p>The configuration of an applet may contain field parameters, for example, LUTs. These field parameters aren't directly stored in the MCF file, but in a separate file with file extension *.mfs. (MFS = microEnable Field Storage)</p> <p>You never need to handle the MFS file directly:</p> <ul> <li>If your applet configuration contains field parameters, the MFS file is created automatically, together with the MCF file, while you save the applet configuration.</li> <li>When loading an applet configuration, it is enough to load the MCF file, as the contents of the MFS file (field parameters) will be loaded automatically together with the MCF file.</li> </ul> <p>Info</p> <p>For each frame grabber model, a set of applets is available for free. These applets are called acquisition applets. All acquisition applets have the file extension *.dll. Acquisition applets come in applet sets (one set per frame grabber model). Applet sets can be installed together with the Framegrabber SDK or via an individual applet set installer (available on the Basler website's download section. After installation, acquisition applets are located in the Framegrabber SDK installation directory, sub-directory Dll. (Example: C:\\Program Files\\Basler\\FramegrabberSDK5.x.x\\Dll.) Acquisition applets run on programmable and non-programmable frame grabbers (i.e. A Series and V Series Frame Grabbers).</p> <p>All acquisition applets contain field parameters. Thus, each time you save the configuration of an acquisition applet, two files are created, the *.mcf file and the *.mfs file. However, you don't need to handle the *.mfs file separately, as it is always automatically created/loaded when you save/load the *.mfs file.</p> <p>The following arrays (field parameters) are part of all or some acquisition applets:</p> <ul> <li>LUTs</li> <li>KneeLUTs</li> <li>PoCXPStatePort_x (marathon CXP boards only)</li> <li>PoCXPCurrentPort_x (marathon CXP boards only)</li> <li>PoCXPVoltagePort_x (marathon CXP boards only)</li> </ul> <p>Info</p> <p>Saving all field data into a separate file keeps the applet configuration file MCF clear and allows for downward compatibility.</p>"},{"location":"other-tasks-micro-display-x.html#saving-and-loading-in-mdisplay-x","title":"Saving and Loading in mDisplay X","text":""},{"location":"other-tasks-micro-display-x.html#saving-the-applet-configuration-to-file-in-microdisplay-x","title":"Saving the Applet Configuration to File in microDisplay X","text":"<p>In microDisplay X, you can save the configuration of the currently loaded applet to file.</p> <ol> <li> <p>From menu File, select Save Configuration.</p> <p></p> </li> <li> <p>Select the directory where you want to store the applet configuration file (*.mcf).</p> </li> <li>Give a name to your *.mcf file.</li> <li>Click Save.</li> </ol> <p>The *.mcf file is created and stored in the directory you have specified in step two. If the applet configuration contains field values, an additional *.mfs file is created that contains all field parameter values of the applet configuration. The MFS file is created automatically if the applet contains field parameters.</p>"},{"location":"other-tasks-micro-display-x.html#loading-the-applet-configuration-from-file-in-microdisplay-x","title":"Loading the Applet Configuration from File in microDisplay X","text":"<ol> <li> <p>In microDisplay X, select the frame grabber you want to use the configured applet on.</p> <p></p> </li> <li> <p>From menu File, select Open Configuration.</p> <p></p> </li> <li> <p>In the dialog that opens, navigate to the directory that contains your applet configuration.</p> </li> <li>Select the *.mcf file you want to use and click Open.</li> </ol> <p>The configured applet is loaded in microDisplay X and is activated on the frame grabber. If the applet configuration contains field parameters, the field values are loaded from the according *.mfs file automatically. You don't need to load the *.mfs file separately.</p>"},{"location":"other-tasks-micro-display-x.html#saving-and-loading-via-framegrabber-api","title":"Saving and Loading via Framegrabber API","text":""},{"location":"other-tasks-micro-display-x.html#saving-the-applet-configuration-to-file-via-framegrabber-api","title":"Saving the Applet Configuration to File via Framegrabber API","text":"<p>For saving applet configuration files, the following function is available in the Framegrabber API (library <code>fglib5.lib</code>, header file <code>basler_fg.h</code>):</p> <p><code>int Fg_saveConfig (Fg_Struct *Fg, const char *Filename)</code></p> <p>Parameters:</p> <ul> <li><code>Fg</code>: Frame grabber (board index) in your system. Specify here the frame grabber from which you want to save the active configuration (active applet and its parametrization).</li> <li><code>Filename</code> : Specify here the name of and the path to the configuration file. File extension is always *.mcf.</li> </ul> <p>If the applet configuration contains field values, an additional *.mfs file is created that contains all field parameter values of the applet configuration. The MFS file is created automatically if the applet contains field parameters.</p>"},{"location":"other-tasks-micro-display-x.html#loading-the-applet-configuration-from-file-via-framegrabber-api","title":"Loading the Applet Configuration from File via Framegrabber API","text":"<p>For loading an applet configuration from file, various functions are available (library <code>fglib5.lib</code>, header file <code>basler_fg.h</code>):</p>"},{"location":"other-tasks-micro-display-x.html#frame-grabber-initialization","title":"Frame Grabber Initialization","text":"<p>You can initialize a board directly via an *.mcf file. As the MCF file contains the applet name, the frame grabber is initialized with the applet specified in the MCF file, and the applet configuration (parametrization) stored in the *.mcf file is already set on the frame grabber.</p> <p>If your applet configuration contains field parameters and an according *.mfs file is stored in the same directory as the *.mcf file, the field parameters are loaded automatically when you call this function.</p> <p><code>Fg_Struct* Fg_InitConfig (const char * Config_Name, unsigned int BoardIndex)</code></p> <p>Parameters:</p> <ul> <li><code>Config_Name</code>: Specify here the name of and the path to the configuration file. File extension is always *.mcf.</li> <li><code>BoardIndex</code>: Specify here (via its board index) the frame grabber which you want to initialize with the *.mcf file. After calling <code>Fg_InitConfig</code>, the frame grabber is initialized with the applet named in the *.mcf file and the applet configuration specified in the same file.</li> </ul>"},{"location":"other-tasks-micro-display-x.html#loading-applet-configuration","title":"Loading Applet Configuration","text":"<p>You can also load the configuration of an applet after you have already initialized a frame grabber with the applet.</p> <p>Prerequisites for using this function:</p> <ul> <li>The frame grabber has already been initialized via function <code>FG_Init</code> or as a master with <code>FG_InitEx</code>.</li> <li>The applet configuration stored in the *.mcf file applies to the applet the frame grabber has been initialized with. (In case of doubt, have a look into the *.mcf file. The applet name is mentioned in the first lines of the *.mcf file.)</li> </ul> <p>If your applet configuration contains field parameters, and an according *.mfs file is stored in the same directory as the *.mcf file, the field parameters are loaded automatically when you call this function.</p> <p>Function for loading the applet configuration after frame grabber initialization:</p> <p><code>int Fg_loadConfig (Fg_Struct *Fg, const char *Filename)</code></p> <p>Parameters:</p> <ul> <li><code>Fg</code>: Specify here the frame grabber (via board index) which you want to parametrize with the applet configuration contained in the *.mcf file.</li> <li><code>Filename</code>: Specify here the name of and the path to the configuration file. File extension is always *.mcf.</li> </ul> <p>Info</p> <p>Don't forget to release frame grabber resources after using the frame grabber via function</p> <p><code>int Fg_FreeGrabber (Fg_Struct *Fg)</code></p> <p>This function also frees frame buffer that has been allocated for this frame grabber earlier via <code>Fg_AllocMem()</code>.</p>"},{"location":"pgi-feature-set-imaflex.html","title":"PGI Feature Set (imaFlex CXP-12 Quad)","text":"<p>The PGI feature set allows you to optimize the quality of your images.</p> <p>The main purpose of the PGI feature set is to optimize images to meet the needs of human vision. It combines up to four image optimization processes.</p>"},{"location":"pgi-feature-set-imaflex.html#using-the-feature","title":"Using the Feature","text":""},{"location":"pgi-feature-set-imaflex.html#how-it-works","title":"How It Works","text":"<p>Depending on your applet, a selection of the following image optimizations will be performed:</p>"},{"location":"pgi-feature-set-imaflex.html#noise-reduction","title":"Noise Reduction","text":"<p>The noise reduction (also called \"denoising\") reduces random variations in brightness or color information in your images.</p>"},{"location":"pgi-feature-set-imaflex.html#improved-sharpness","title":"Improved Sharpness","text":"<p>This optimization increases the sharpness of the images. The higher the sharpness, the more distinct the contours of the image objects will be. This is especially useful in applications where cameras must correctly identify numbers or letters.</p>"},{"location":"pgi-feature-set-imaflex.html#55-debayering","title":"5\u00d75 Debayering","text":"<p>5\u00d75 debayering (also called \"demosaicing\") carries out color interpolation on regions of 5\u00d75 pixels on the sensor and is therefore more elaborate than the \"simple\" 2\u00d72 debayering used otherwise by the camera.</p>"},{"location":"pgi-feature-set-imaflex.html#color-anti-aliasing","title":"Color Anti-Aliasing","text":"<p>Color errors, especially on sharp edges and in sections of the image with high spatial frequencies, are a common side effect of debayering algorithms. Even colorless structures can suddenly appear to have color. The color anti-aliasing optimization analyzes and corrects the discolorations.</p> <p>For more information about the PGI image optimizations, see the Better Image Quality with Basler PGI white paper.</p>"},{"location":"pgi-feature-set-imaflex.html#enabling-the-pgi-feature-set","title":"Enabling the PGI Feature Set","text":"<p>The implementation of this feature may varies depending on the applet and frame grabber / interface card:</p>"},{"location":"pgi-feature-set-imaflex.html#enhanced-applets-on-the-cxp-12-frame-grabber-interface-cards","title":"Enhanced Applets on the CXP-12 Frame Grabber/ Interface cards","text":"<p>To enable the PGI image optimizations on Basler a frame grabber:</p> <ul> <li> <p>Make sure your camera is in Bayer mode and debayering is done on the frame grabber as described in Performing Debayering on the Interface Card/Frame Grabber </p> </li> <li> <p>PGI image optimizations are enabled automatically when any of the following parameters isn't set to its default value and your frame grabber is used to debayer the image:</p> <ul> <li><code>NoiseReduction</code></li> <li><code>SharpnessEnhancement</code></li> </ul> </li> </ul>"},{"location":"pgi-feature-set-imaflex.html#setting-the-pgi-image-optimizations","title":"Setting the PGI Image Optimizations","text":"<p>Once you have enabled the PGI feature set, you can configure the individual image optimization processes.</p> <p>Which image optimizations are available and can be configured depends on your applet and frame grabber / interface card.</p>"},{"location":"pgi-feature-set-imaflex.html#configuring-noise-reduction","title":"Configuring Noise Reduction","text":"<p>If this optimization is configurable for your camera, set the <code>NoiseReduction</code> parameter to specify the desired noise reduction. The higher the parameter value, the more noise reduction is applied.</p> <p>If this optimization isn't configurable, noise reduction is applied automatically.</p> <p>Noise reduction is best used together with improved sharpness. If the parameter value is set too high, fine structure in the image can become indistinct or even disappear.</p>"},{"location":"pgi-feature-set-imaflex.html#configuring-improved-sharpness","title":"Configuring Improved Sharpness","text":"<p>If this optimization is configurable for your camera, set the <code>SharpnessEnhancement</code> parameter to specify the desired level of sharpness. The higher the parameter value, the more sharpening is applied.</p> <p>If this optimization is not configurable, sharpness is improved automatically.</p> <p>In most cases, best results are obtained at low parameter value settings and when using noise reduction at the same time.</p>"},{"location":"pgi-feature-set-imaflex.html#configuring-55-debayering","title":"Configuring 5\u00d75 Debayering","text":"<p>5\u00d75 debayering is performed automatically whenever the PGI feature set is enabled. You can't configure this optimization.</p>"},{"location":"pgi-feature-set-imaflex.html#configuring-color-anti-aliasing","title":"Configuring Color Anti-Aliasing","text":"<p>Color anti-aliasing is performed automatically whenever the PGI feature set is enabled. You can't configure this optimization.</p>"},{"location":"pgi-feature-set-imaworx.html","title":"PGI Feature Set (imaWorx CXP-12 Quad)","text":"<p>The PGI feature set allows you to optimize the quality of your images.</p> <p>The main purpose of the PGI feature set is to optimize images to meet the needs of human vision. It combines up to four image optimization processes.</p>"},{"location":"pgi-feature-set-imaworx.html#using-the-feature","title":"Using the Feature","text":""},{"location":"pgi-feature-set-imaworx.html#how-it-works","title":"How It Works","text":"<p>Depending on your applet, a selection of the following image optimizations will be performed:</p>"},{"location":"pgi-feature-set-imaworx.html#noise-reduction","title":"Noise Reduction","text":"<p>The noise reduction (also called \"denoising\") reduces random variations in brightness or color information in your images.</p>"},{"location":"pgi-feature-set-imaworx.html#improved-sharpness","title":"Improved Sharpness","text":"<p>This optimization increases the sharpness of the images. The higher the sharpness, the more distinct the contours of the image objects will be. This is especially useful in applications where cameras must correctly identify numbers or letters.</p>"},{"location":"pgi-feature-set-imaworx.html#55-debayering","title":"5\u00d75 Debayering","text":"<p>5\u00d75 debayering (also called \"demosaicing\") carries out color interpolation on regions of 5\u00d75 pixels on the sensor and is therefore more elaborate than the \"simple\" 2\u00d72 debayering used otherwise by the camera.</p>"},{"location":"pgi-feature-set-imaworx.html#color-anti-aliasing","title":"Color Anti-Aliasing","text":"<p>Color errors, especially on sharp edges and in sections of the image with high spatial frequencies, are a common side effect of debayering algorithms. Even colorless structures can suddenly appear to have color. The color anti-aliasing optimization analyzes and corrects the discolorations.</p> <p>For more information about the PGI image optimizations, see the Better Image Quality with Basler PGI white paper.</p>"},{"location":"pgi-feature-set-imaworx.html#enabling-the-pgi-feature-set","title":"Enabling the PGI Feature Set","text":"<p>The implementation of this feature may varies depending on the applet and frame grabber / interface card:</p>"},{"location":"pgi-feature-set-imaworx.html#enhanced-applets-on-the-cxp-12-frame-grabber-interface-cards","title":"Enhanced Applets on the CXP-12 Frame Grabber/ Interface cards","text":"<p>To enable the PGI image optimizations on Basler a frame grabber:</p> <ul> <li> <p>Make sure your camera is in Bayer mode and debayering is done on the frame grabber as described in Performing Debayering on the Interface Card/Frame Grabber </p> </li> <li> <p>PGI image optimizations are enabled automatically when any of the following parameters isn't set to its default value and your frame grabber is used to debayer the image:</p> <ul> <li><code>NoiseReduction</code></li> <li><code>SharpnessEnhancement</code></li> </ul> </li> </ul>"},{"location":"pgi-feature-set-imaworx.html#setting-the-pgi-image-optimizations","title":"Setting the PGI Image Optimizations","text":"<p>Once you have enabled the PGI feature set, you can configure the individual image optimization processes.</p> <p>Which image optimizations are available and can be configured depends on your applet and frame grabber / interface card.</p>"},{"location":"pgi-feature-set-imaworx.html#configuring-noise-reduction","title":"Configuring Noise Reduction","text":"<p>If this optimization is configurable for your camera, set the <code>NoiseReduction</code> parameter to specify the desired noise reduction. The higher the parameter value, the more noise reduction is applied.</p> <p>If this optimization isn't configurable, noise reduction is applied automatically.</p> <p>Noise reduction is best used together with improved sharpness. If the parameter value is set too high, fine structure in the image can become indistinct or even disappear.</p>"},{"location":"pgi-feature-set-imaworx.html#configuring-improved-sharpness","title":"Configuring Improved Sharpness","text":"<p>If this optimization is configurable for your camera, set the <code>SharpnessEnhancement</code> parameter to specify the desired level of sharpness. The higher the parameter value, the more sharpening is applied.</p> <p>If this optimization is not configurable, sharpness is improved automatically.</p> <p>In most cases, best results are obtained at low parameter value settings and when using noise reduction at the same time.</p>"},{"location":"pgi-feature-set-imaworx.html#configuring-55-debayering","title":"Configuring 5\u00d75 Debayering","text":"<p>5\u00d75 debayering is performed automatically whenever the PGI feature set is enabled. You can't configure this optimization.</p>"},{"location":"pgi-feature-set-imaworx.html#configuring-color-anti-aliasing","title":"Configuring Color Anti-Aliasing","text":"<p>Color anti-aliasing is performed automatically whenever the PGI feature set is enabled. You can't configure this optimization.</p>"},{"location":"pocl-support-micro-diagnostics.html","title":"PoCL Support (microDiagnostics)","text":""},{"location":"pocl-support-micro-diagnostics.html#enabling-pocl-support","title":"Enabling PoCL Support","text":"<p>You must enable PoCL support on the frame grabber if you want to use the following components together:</p> <ul> <li>Power over Camera Link (PoCL) camera</li> <li>marathon Camera Link frame grabber</li> <li>Applet set 2.0 (or higher) or individual applet (*.hap file) created with VisualApplets 3.0.6 (or higher)</li> </ul> <p>PoCL support is disabled per default for marathon frame grabbers if you are running applets out of applet set version 2.0 (or higher) or an individual applet created with VisualApplets 3.0.6 (or higher).</p> <p>You enable PoCL support in microDiagnostics. This tool comes as part of the Framegrabber SDK installation. To enable PoCL support, you must install Framegrabber SDK version 5.5.1 or higher.</p> <p>To enable PoCL support for using a PoCL camera with a marathon frame grabber:</p> <ol> <li>Open the tool microDiagnostics, which comes as part of the Framegrabber SDK installation (installation directory, subdirectory bin). For activating PoCL support, you must use Framegrabber SDK version 5.5.1 or higher.</li> <li>In the Frame Grabber pane of microDiagnostics, select the board you want to enable the PoCL support for.</li> <li>From the Tools menu, select Board Settings.</li> <li> <p>In the dialog, select Enable PoCL Detection.</p> <p></p> </li> <li> <p>Re-configure the FPGA on the frame grabber. To do so, you can either activate/load another applet, or cold-boot your computer.Now, PoCL support on the frame grabber is enabled.</p> </li> </ol>"},{"location":"pocl-support-micro-diagnostics.html#disabling-pocl-support","title":"Disabling PoCL Support","text":"<p>To disable PoCL support, clear the Enable PoCL Detection checkbox shown above.</p>"},{"location":"privacy-policy.html","title":"Privacy Policy","text":"<p>Thank you for visiting our website. We would like to inform you about the handling of your data according to Article 13 of the German Data Protection Regulation (DSGVO).</p>"},{"location":"privacy-policy.html#responsibility","title":"Responsibility","text":"<p>Responsibility for the data processing described below is held by the body named in the imprint.</p>"},{"location":"privacy-policy.html#usage-data","title":"Usage Data","text":"<p>When you visit our web pages, usage data is stored on our web server as a log for statistical purposes and evaluated to improve the quality of our web pages. This data set consists of:</p> <ul> <li>the name and address of the requested content;</li> <li>the date and time of the query;</li> <li>the amount of data transferred;</li> <li>the access status (content transferred, content not found);</li> <li>the description of the web browser and operating system used; and</li> <li>the referral link, which indicates from which page you have reached our page.</li> </ul> <p>This log data is evaluated without identifying information.</p>"},{"location":"privacy-policy.html#data-security","title":"Data Security","text":"<p>To protect your data from unwanted access as comprehensively as possible, we take technical and organizational measures. We use an encryption process on our websites. Your data is transferred from your computer to our server and vice versa via the Internet using TLS encryption. In most cases you can recognize this by the appearance of the closed lock symbol in the status bar of your browser, and the prefix https:// in the address line.</p>"},{"location":"privacy-policy.html#required-cookies","title":"Required Cookies","text":"<p>We use cookies on our websites, which are necessary for the use of our websites.</p> <p>Cookies are small text files that are stored on your terminal device and can be read. A distinction is made between session cookies, which are deleted as soon as you close your browser, and permanent cookies, which are stored beyond the individual session. We do not use these required cookies for analysis, tracking or advertising purposes.</p> <p>These cookies only contain information about certain settings and do not identify a user. They may also be necessary to enable user guidance, security and implementation of the site. We use these cookies on the basis of Article 6 paragraph 1 p. 1 lit. f DSGVO.</p> <p>You can set your browser to inform you about the placement of cookies. This makes the use of cookies transparent for you. You can also delete cookies at any time via the appropriate browser setting and prevent the setting of new cookies. Please note that our websites may then not be displayed correctly and some functions may no longer be technically available.</p>"},{"location":"privacy-policy.html#visitor-measurement","title":"Visitor Measurement","text":"<p>We use web analysis tools to design our websites in line with requirements. These create usage profiles based on pseudonyms. For this purpose, permanent cookies are stored on your end device and read by us. In addition, it is possible that we retrieve recognition features for your browser or end device (e.g. a so-called browser fingerprint or your unabbreviated IP address). In this way, we are able to recognize returning visitors and count them as such.</p> <p>These usage profiles, which are created on the basis of pseudonyms, contain evaluations of the following usage parameters, among others:</p> <ul> <li>If possible, the source of the user (via search engine ads, redirection through other websites or similar);</li> <li>The duration of website use;</li> <li>The amount, sequence and names of visited pages;</li> <li>The number of sessions (sessions) on the website;</li> <li>Country, region and, if applicable, city from which the access is made;</li> <li>Functions used on the website and clicks made (\"events\");</li> <li>Searches performed on the website;</li> <li>Information about the used variants of the website within the scope of so-called A/B tests;</li> <li>Information about the browser, device, operating system, etc. used during access.</li> </ul> <p>The data processing is based on your consent according to Article 6 paragraph 1 p. 1 lit. a DSGVO or \u00a7 15 para. 3 p. 1 TMG, if you have given your consent via our banners.</p>"},{"location":"privacy-policy.html#which-third-party-providers-do-we-use-in-this-context","title":"Which Third-Party Providers Do We Use in This Context?","text":"<p>Below we list the third-party providers with whom we work in connection with visitor measurement. If the data is processed outside the EU or EEA in this context, please note that there is a risk that authorities may access the data for security and monitoring purposes without you being informed or having the right to appeal.</p> Provider Maximum storage time Adequate level of data protection Google LLC (USA) 2 years Third-country transfers based on the EU standard contractual clauses <p>Click here to opt-out of Google Analytics</p>"},{"location":"privacy-policy.html#storage-duration","title":"Storage Duration","text":"<p>Unless we have already informed you in detail about the storage period, we delete personal data when they are no longer required for the aforementioned processing purposes and no legal retention obligations prevent deletion.</p>"},{"location":"privacy-policy.html#other-processors","title":"Other Processors","text":"<p>We share your data with service providers who support us in the operation of our websites and related processes as part of order processing pursuant to Article 28 of the DSGVO. These are, for example, hosting service providers. Our service providers are strictly bound by instructions to us and are contractually obligated accordingly.</p> <p>Below, we name the processors with whom we work, where have not already done so in the preceding text of the privacy policy. If data is transferred outside the EU or EEA in this context, we provide information on the appropriate level of data protection.</p> Processor Purpose Adequate level of data protection Kernpunkt GmbH Web hosting and support Processing only within EU/EEA Netlify Inc. (USA) Web hosting and support Third-country transfers based on the EU standard contractual clauses"},{"location":"privacy-policy.html#your-rights-as-a-data-subject","title":"Your Rights as a Data Subject","text":"<p>When your personal data is processed, the GDPR grants you certain rights as a data subject:</p>"},{"location":"privacy-policy.html#right-of-access-article-15-gdpr","title":"Right of Access (Article 15 GDPR)","text":"<p>You have the right to request confirmation as to whether personal data concerning you is being processed; if this is the case, you have a right to information about this personal data and to the information listed in detail in Article 15 of the GDPR.</p>"},{"location":"privacy-policy.html#right-to-rectification-article-16-dsgvo","title":"Right to Rectification (Article 16 DSGVO)","text":"<p>You have the right to request the correction of inaccurate personal data concerning you and, if necessary, the completion of incomplete data without delay.</p>"},{"location":"privacy-policy.html#right-to-erasure-article-17-dsgvo","title":"Right to Erasure (Article 17 DSGVO)","text":"<p>You have the right to request that personal data concerning you be deleted without undue delay, provided that one of the reasons listed in detail in Article 17 of the DSGVO applies.</p>"},{"location":"privacy-policy.html#right-to-restriction-of-processing-article-18-dsgvo","title":"Right to Restriction of Processing (Article 18 DSGVO)","text":"<p>You have the right to request the restriction of processing if one of the conditions listed in Article 18 of the DSGVO is met, e.g. if you have objected to the processing, for the duration of the review by the controller.</p>"},{"location":"privacy-policy.html#right-to-data-portability-article-20-dsgvo","title":"Right to Data Portability (Article 20 DSGVO)","text":"<p>In certain cases, which are listed in detail in Article 20 of the DSGVO, you have the right to receive the personal data concerning you in a structured, common and machine-readable format or to request the transfer of this data to a third party.</p>"},{"location":"privacy-policy.html#right-of-withdrawal-article-7-dsgvo","title":"Right of Withdrawal (Article 7 DSGVO)","text":"<p>If the processing of data is based on your consent, you are entitled to revoke your consent to the use of your personal data at any time in accordance with Art. 7 (3) DSGVO. Please note that the revocation is only effective for the future. Processing that took place before the revocation is not affected.</p>"},{"location":"privacy-policy.html#right-of-objection-article-21-dsgvo","title":"Right of Objection (Article 21 DSGVO)","text":"<p>If data is collected on the basis of Article 6 (1) p. 1 lit. f DSGVO (data processing for the protection of legitimate interests) or on the basis of Article 6 (1) p. 1 lit. e DSGVO (data processing for the protection of public interest or in the exercise of official authority), you have the right to object to the processing at any time for reasons arising from your particular situation. We will then no longer process the personal data unless there are demonstrably compelling legitimate grounds for the processing which override your interests, rights and freedoms, or the processing serves to assert, exercise or defend legal claims.</p>"},{"location":"privacy-policy.html#right-of-appeal-to-a-supervisory-authority-article-77-dsgvo","title":"Right of Appeal to a Supervisory Authority (Article 77 Dsgvo)","text":"<p>Pursuant to Article 77 of the DSGVO, you have the right to lodge a complaint with a supervisory authority if you are of the opinion that the processing of data relating to you violates data protection provisions. The right of complaint may be asserted in particular before a supervisory authority in the Member State of your habitual residence, your place of work or the place of the alleged infringement.</p>"},{"location":"privacy-policy.html#assertion-of-your-rights","title":"Assertion of Your Rights","text":"<p>Unless otherwise described above, please contact the office mentioned in the imprint to assert your data protection rights.</p>"},{"location":"privacy-policy.html#contact-details-of-the-data-protection-officer","title":"Contact Details of the Data Protection Officer","text":"<p>Our external data protection officer will be happy to provide you with information on the subject of data protection under the following contact details:</p> <p>datenschutz nord GmbH Konsul-Smidt-Stra\u00dfe 88 28217 Bremen (Germany)</p> <p>Web: www.datenschutz-nord-gruppe.de E-Mail: office@datenschutz-nord.de</p> <p>If you contact our data protection officer, please also indicate the responsible office in the imprint.</p>"},{"location":"program-window-micro-diagnostics.html","title":"Program Window (microDiagnostics)","text":""},{"location":"program-window-micro-diagnostics.html#starting-microdiagnostics","title":"Starting microDiagnostics","text":"<p>To start microDiagnostics, click the microDiagnostics entry in the start menu.</p> <p>The following program window opens:</p> <p></p>"},{"location":"program-window-micro-diagnostics.html#board-listing","title":"Board Listing","text":"<p>In the upper pane, you find information about all Basler frame grabbers installed in the host computer.</p> <p>This information includes:</p> <ul> <li>Type: Specific grabber model</li> <li>Board ID: Board ID of individual frame grabber within the image acquisition system. Important when using the Framegrabber API.</li> <li>Serial: Serial number of individual frame grabber.</li> <li>Firmware Version: Version of the firmware the frame grabber is using.</li> <li>Driver Version: Version number of the device driver that is currently installed.</li> <li>License: License that is installed for the specific frame grabber.</li> <li>Security Code: Special License for individual licensing.</li> <li>PCI Express Speed: Information about the features of the PCIe slot the frame grabber is connected to.</li> </ul> <p></p> <p>Info</p> <p>You can re-organize the order of board numbers. See Re-Sorting Boards.</p>"},{"location":"program-window-micro-diagnostics.html#lower-part-of-program-window","title":"Lower Part of Program Window","text":"<p>The lower part of the program window you can use to view the test results of the tests you carried out lately.</p> <p>Info</p> <p>At program start, the pane displays information on the frame grabbers detected in the system (category Log).</p> <p>To display information:</p> <ol> <li>Select a frame grabber board in the upper pane.</li> <li>Select the category of test in the left hand pane.</li> <li>In the right hand pane, you are provided with the results of the test you carried out last in this category.</li> </ol> <p></p>"},{"location":"program-window-micro-display-x.html","title":"Program Window (microDisplay X)","text":"<p>To start microDiagnostics, click the microDisplay X entry in the start menu.</p> <p>The following program window opens:</p> <p></p>"},{"location":"program-window-micro-display-x.html#viewing-pane","title":"Viewing Pane","text":"<p>In the Viewing pane, you can view various information by selecting the according tab:</p> <ul> <li>Getting Started: Here, the first steps for using microDisplay X are listed.</li> <li>Acquisition Channel: Here, you can view the images that are being grabbed (during image acquisition) or that have been grabbed (after acquisition has been stopped).</li> <li>Hardware: Here, you get information on the connected frame grabber boards and on the installed driver and firmware versions. If you use a CoaXPress camera, you can also find information on the detected link configuration (subtab Link Configuration).</li> <li>Cameras: If you use CoaXPress cameras, you can configure your cameras here, using the GenICam interface of the frame grabber runtime environment.</li> </ul>"},{"location":"program-window-micro-display-x.html#log-pane","title":"Log Pane","text":"<p>The Log pane displays various information:</p> <ul> <li>Log: If an error occurs, the according error messages are displayed here.<ul> <li>If you switch to another tab in the logging frame while an acquisition is running, the number of messages you missed after leaving the Log tab is displayed directly on the tab.</li> </ul> </li> <li>Grabber Events: Lists events on the frame grabber that have occurred. (See here for details.)<ul> <li>To read individual lines of the log while the logging is taking place, you can stop the running through of lines. Right-click directly on the running lines and in the context menu, click Auto Scrolling Enabled to stop auto scrolling.</li> <li>If you switch to another tab in the logging frame, the number of grabber events you missed after leaving tab Grabber Events is displayed directly on the tab.</li> </ul> </li> <li>Camera Discovery Log: Lists all events that occur during link configuration and camera discovery.</li> <li>Camera Connection Log: Lists all events that occur during GenICam communication.</li> <li>System Status: Displays the current system status:</li> </ul> <p></p>"},{"location":"program-window-micro-display-x.html#configuring-the-gui-settings","title":"Configuring the GUI Settings","text":"<p>You have various options to change the display of information in the graphical user interface of microDisplay X. Refer to Setting User Preferences for details.</p>"},{"location":"program-window-micro-display-x.html#applet-pane","title":"Applet Pane","text":"<p>After loading an applet, the Applet Layout pane states:</p> <ul> <li>The board index of frame grabber board together with the applet that is loaded onto the board</li> <li>All processes of the loaded applet</li> <li>For each applet process:<ul> <li>All camera input ports of the process</li> <li>All DMA output ports of the process</li> <li>On the Cam lines, a tooltip provides you with information on the connected camera. You can change the connected camera by clicking the Edit button in the camera line.</li> </ul> </li> </ul> <p>Example 1: Applet with 4 processes. Each process has 1 camera input port and 1 DMA output port:</p> <p></p> <p>Example 2: Applet with 1 process. The process has 2 camera input ports and 2 DMA output ports:</p> <p></p>"},{"location":"program-window-micro-display-x.html#loading-multiple-applets","title":"Loading Multiple Applets","text":"<p>In microDisplay X, it is possible to load multiple applets (one applet per plugged frame grabber board). The Applet Layout pane lists all applets you have loaded (one below the other):</p> <p></p>"},{"location":"program-window-micro-display-x.html#display-by-source-type","title":"Display by Source Type","text":"<p>You can switch the display so that the camera input and DMA output ports are displayed by source type:</p> <p></p> <p>Which DMA/camera belongs to which frame grabber board you can see by the board index that is displayed directly after the status display.</p> <p>To get the display sorted by source type:</p> <ol> <li>From menu Tools, select Settings.</li> <li> <p>In the dialog that opens, under GUI, Applet Layout, set View Mode to Resource Mode.</p> <p></p> </li> </ol>"},{"location":"pylon-event-logger.html","title":"pylon Event Logger","text":"<p>The Framegrabber SDK provides an event logging tool you can install with the Framegrabber SDK. This tool is the pylon Event Logger.</p> <p>To install the pylon Event Logger, select it during installation in the Select Components dialog of the Framebrabber SDK installer:</p> <p></p> <p>To start the pylon Event Logger:</p> <ul> <li>Framegrabber SDK: Start the pyloneventlogger.exe from the &lt;Framegrabber SDK installation directory&gt;\\Applications\\bin.</li> <li>GenTL/CXP: Start the pylon Event Logger with the start script bin\\pyloneventlogger.</li> </ul> <p>You find the documentation of the pylon Event Logger in the pylon documentation.</p>"},{"location":"python-wrapper.html","title":"Python Wrapper","text":"<p>To allow you to use the Framegrabber API in programs you create with Python, you are provided with a Python wrapper. The Python wrapper wraps the Framegrabber API functionality into a Python module.</p> <p>All C/C++ Framgrabber API functions are wrapped in one Python module <code>SiSoPyInterface</code>.</p> <p>The major part of the Pyton API works similar to the C/C++ API, so you can refer to the general C/C++ Framegrabber API documentation in most cases. All cases where the Python API differs from the C/C++ API are detailed in the following sections.</p>"},{"location":"python-wrapper.html#components-of-the-wrapper","title":"Components of the Wrapper","text":"<p>The Python wrapper is installed together with the Framegrabber SDK. You find the wrapper in the following subfolder of your Framgrabber SDK installation:</p> <p>Basler/FramegrabberSDK/SDKWrapper/PythonWrapper/pythonxx</p> <p>Info</p> <p>Basler offers wrapper versions that support Python versions 3.7, 3.8, 3.9 or 3.10 on Windows and Linux. You find the versions in the according subfolders python37, python38, python 39 and python310.</p> <p>The Python Framegrabber API wrapper consists of 2 files, <code>SiSoPyInterface.py</code> and <code>_SiSoPyRt_xx.pyd</code>:</p> <ul> <li> <p>SiSoPyInterface.py is the wrapping module.     You find this file in your Framegrabber SDK installation:</p> <p>Basler/FramegrabberSDK/SDKWrapper/PythonWrapper/pythonxx/lib</p> </li> <li> <p>_SiSoPyRt_xx.pyd is the dll that communicates with the Framegrabber API.     You find this file in your Framegrabber SDK installation:</p> <p>Basler/FramegrabberSDK/bin</p> </li> </ul>"},{"location":"python-wrapper.html#installation","title":"Installation","text":"<p>To get started using the wrapper:</p> <ol> <li> <p>Before using the wrapper, download Python and install it if you don't already have it on your machine.     Basler recommends to also install the NumPy package. Alternatively, you can directly use WinPython that already contains NumPy.</p> </li> <li> <p>Install NumPy:</p> <ol> <li>Pre-Requisite: Make sure Python is already installed on your host.</li> <li>Download and install pip, the PyPA recommended tool for installing Python packages.</li> <li>Download the numpy package from https://pypi.org/.</li> <li> <p>In the command line tool, enter:</p> <p><code>python -m pip install --user numpy</code></p> </li> </ol> <p>For more details, see https://scipy.org/install.html or https://packaging.python.org/tutorials/installing-packages/</p> </li> <li> <p>Import <code>SiSoPyInterface.py</code> in your Python project. The Framegrabber API can be accessed through the imported module.</p> </li> <li>Set the following environment variables before running your program as in the example below. Adapt the paths according to your installation. (In the example below, Python 3.9 has been installed to C:\\Python\\python39.)</li> </ol> <pre><code>set PYTHON_ROOT=C:\\Python\\python39\n\nset PATH=%PYTHON_ROOT%;%BASLER_FG_SDK_DIR%\\bin;%BASLER_FG_SDK_DIR%\\SDKWrapper\\PythonWrapper\\python39\\bin;%BASLER_FG_SDK_DIR%\\SDKWrapper\\PythonWrapper\\python39\\lib;%PATH%\n\nset PYTHONPATH=%PYTHON_ROOT%;%PYTHON_ROOT%\\Lib;%BASLER_FG_SDK_DIR%\\SDKWrapper\\PythonWrapper\\python39\\bin;%BASLER_FG_SDK_DIR%\\SDKWrapper\\PythonWrapper\\python39\\lib;%BASLER_FG_SDK_DIR%\\bin;%APPDATA%\\Python\\Python39\\site-packages\n</code></pre>"},{"location":"python-wrapper.html#examples","title":"Examples","text":"<p>To get started with the image acquisition using the wrapper most easily, you find two examples per Python version in your Framegrabber SDK installation:</p> <p>Basler/FramegrabberSDK/SDKWrapper/PythonWrapper/pythonXX/Examples</p>"},{"location":"python-wrapper.html#function-mapping","title":"Function Mapping","text":"<p>Each function of the Framegrabber API has a corresponding function in the Python wrapper module (<code>SiSoPyRt</code>).</p> <p>Since Python has no notion of output arguments, but can instead return multiple values, the C/C++ output arguments become additional return values in Python.</p> <p>The mappin