#include "mainwindow.h"
#include "ui_mainwindow.h"
//#include "opencv2/core/core.hpp"
//#include "opencv2/highgui/highgui.hpp"
//#include "opencv2/imgproc/imgproc.hpp"
#include <pylon/PylonIncludes.h>
#include <pylon/DeviceInfo.h>
#include <QTreeView>
#include <QStandardItemModel>
#include <QItemSelectionModel>
#include <math.h>
#include <QMessageBox>
#include <QGraphicsView>
#include <QGraphicsPixmapItem>
#include <QFileDialog>
using namespace GenApi;



string strSelectedCameraSN;
const char* CV_Window_Name="Camera Live Image";
static const uint32_t c_countOfImagesToGrab = 100;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ui->l_Infotext->setText(CV_Window_Name);
    ui->tabWidget->setCurrentIndex(0);
    ui->tabWidget->setTabText(0,"Camera List");
    ui->tabWidget->setTabText(1,"Camera Live");
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::on_listView_doubleClicked(const QModelIndex &index)
{

  QString QstrSelectedCamera = index.data(Qt::DisplayRole).toString();
   ui->statusBar->showMessage("Selected camera is :"+QstrSelectedCamera,10000);
   strSelectedCameraSN=QstrSelectedCamera.toStdString();
}


void MainWindow::on_b_Enumerate_Device_clicked()
{

    DeviceInfoList_t dList;
    CTlFactory::GetInstance().EnumerateDevices(dList,true);
    if ( dList.size() == 0 )
    {
        throw RUNTIME_EXCEPTION( "No camera present.");
    }
    else
    {
        QStandardItemModel *model = new QStandardItemModel( 6, 1, this );
        for( int r=0; r<dList.size(); r++ )
        {

            QStandardItem *item = new QStandardItem(QString(dList[r].GetSerialNumber()));
            model->setItem(r, 0, item);
        }
        ui->listView->setModel(model);
        ui->listView->setEditTriggers(QAbstractItemView::NoEditTriggers);  // change the stauts of the List view to readonly
    }
}

void MainWindow::on_b_single_Grab_clicked()
{
    int exitCode = 0;
    if(strSelectedCameraSN.length()<=0)
        QMessageBox::information(NULL, "error","Please select a camera first",0);
   else
    {

        try
            {
               ui->tabWidget->setTabText(1,"Camera Image");
              // Create an instant camera object with the camera device found first.
                CDeviceInfo info;
                info.SetSerialNumber(strSelectedCameraSN.c_str());
                CInstantCamera camera( CTlFactory::GetInstance().CreateFirstDevice(info));
                camera.Open();
                INodeMap& nodemap=camera.GetNodeMap();
                CIntegerPtr  Hight( nodemap.GetNode( "Height"));
                if ( IsAvailable(Hight->GetNode()))
                            {
                              Hight->SetValue(300);
                            }

                CIntegerPtr  Width( nodemap.GetNode( "Width"));
                if ( IsAvailable(Width->GetNode()))
                            {
                              Width->SetValue(300);
                            }
                CEnumerationPtr TestImageSelector( nodemap.GetNode( "TestImageSelector"));
                if ( IsAvailable(TestImageSelector->GetNode()))
                            {
                              TestImageSelector->FromString("Testimage4");
                            }

                // Print the model name of the camera.
                cout << "Using device " << camera.GetDeviceInfo().GetModelName() << endl;

                // The parameter MaxNumBuffer can be used to control the count of buffers
                // allocated for grabbing. The default value of this parameter is 10.
                camera.MaxNumBuffer = 1;

                // Start the grabbing of c_countOfImagesToGrab images.
                // The camera device is parameterized with a default configuration which
                // sets up free-running continuous acquisition.


                // This smart pointer will receive the grab result data.
                CGrabResultPtr ptrGrabResult;
                CImageFormatConverter fc;
                fc.OutputPixelFormat = PixelType_BGR8packed;
                CPylonImage image;
                 camera.GrabOne(5000,ptrGrabResult,TimeoutHandling_ThrowException);
                // Camera.StopGrabbing() is called automatically by the RetrieveResult() method
                // when c_countOfImagesToGrab images have been retrieved.

                    // Image grabbed successfully?
                    if (ptrGrabResult->GrabSucceeded())
                    {
                        // Access the image data.
                        cout << "SizeX: " << ptrGrabResult->GetWidth() << endl;
                        cout << "SizeY: " << ptrGrabResult->GetHeight() << endl;
                        const uint8_t *pImageBuffer = (uint8_t *) ptrGrabResult->GetBuffer();
                        cout << "Gray value of first pixel: " << (uint32_t) pImageBuffer[0] << endl << endl;

                        //there are 2 way to create a Qimage.
                       // QImage* QtImage= new QImage((uchar*)frame.data, frame.cols, frame.rows,QImage::Format_RGB888);
                        fc.OutputPixelFormat = PixelType_RGB8packed;
                        fc.Convert(image, ptrGrabResult);
                        QImage* QtImage= new QImage((uint8_t*)image.GetBuffer(), ptrGrabResult->GetWidth(), ptrGrabResult->GetHeight(),QImage::Format_RGB888);

                        QGraphicsPixmapItem *item=new QGraphicsPixmapItem(QPixmap::fromImage(*QtImage));
                        QGraphicsScene *scene = new QGraphicsScene();
                        scene->addPixmap(item->pixmap());
                        ui->graphicsView->setScene(scene);
                        ui->graphicsView->update();
                        ui->tabWidget->setCurrentIndex(1);
                        QtImage->save("/opt/QTImage_c.jpeg","JPEG");
                        QtImage->save("/opt/QTImage_c.bmp","BMP");
                        image.AttachGrabResultBuffer(ptrGrabResult);
                        image.Save(ImageFileFormat_Png,"/opt/image_c.png",0);

                    }
                    else
                    {
                        cout << "Error: " << ptrGrabResult->GetErrorCode() << " " << ptrGrabResult->GetErrorDescription() << endl;
                    }

            }
            catch (GenICam::GenericException &e)
            {
                // Error handling.
                cerr << "An exception occurred." << endl
                << e.GetDescription() << endl;
                exitCode = 1;
            }
    }


}


void MainWindow::on_b_Continues_Grab_clicked()
{
    int exitCode = 0;
       if(strSelectedCameraSN.length()<=0)
           QMessageBox::information(NULL, "error","Please select a camera first",0);
      else
       {

           try
               {
                  ui->tabWidget->setTabText(1,"Camera Image");
                 // Create an instant camera object with the camera device found first.
                   CDeviceInfo info;
                   info.SetSerialNumber(strSelectedCameraSN.c_str());
                   CInstantCamera camera( CTlFactory::GetInstance().CreateFirstDevice(info));

                   camera.Open();

                   INodeMap& nodemap=camera.GetNodeMap();
                   CIntegerPtr  Hight( nodemap.GetNode( "Height"));
                   if ( IsAvailable(Hight->GetNode()))
                               {
                                 Hight->SetValue(300);
                               }

                   CIntegerPtr  Width( nodemap.GetNode( "Width"));
                   if ( IsAvailable(Width->GetNode()))
                               {
                                 Width->SetValue(300);
                               }
                   CEnumerationPtr TestImageSelector( nodemap.GetNode( "TestImageSelector"));
                   if ( IsAvailable(TestImageSelector->GetNode()))
                               {
                                 TestImageSelector->FromString("Testimage4");
                               }


                   // Print the model name of the camera.
                   cout << "Using device " << camera.GetDeviceInfo().GetModelName() << endl;

                   // The parameter MaxNumBuffer can be used to control the count of buffers
                   // allocated for grabbing. The default value of this parameter is 10.
                   camera.MaxNumBuffer = 10;

                   // Start the grabbing of c_countOfImagesToGrab images.
                   // The camera device is parameterized with a default configuration which
                   // sets up free-running continuous acquisition.


                   // This smart pointer will receive the grab result data.
                   CGrabResultPtr ptrGrabResult;
                   CImageFormatConverter fc;
                   fc.OutputPixelFormat = PixelType_BGR8packed;
                   CPylonImage image;
                   camera.StartGrabbing(c_countOfImagesToGrab);
                   // camera.GrabOne(5000,ptrGrabResult,TimeoutHandling_ThrowException);
                   // Camera.StopGrabbing() is called automatically by the RetrieveResult() method
                   // when c_countOfImagesToGrab images have been retrieved.
                   while ( camera.IsGrabbing())
                   {
                       camera.RetrieveResult(5000,ptrGrabResult,TimeoutHandling_ThrowException);

                       // Image grabbed successfully?
                       if (ptrGrabResult->GrabSucceeded())
                       {
                           // Access the image data.
                           const uint8_t *pImageBuffer = (uint8_t *) ptrGrabResult->GetBuffer();
                           cout << "Gray value of first pixel: " << (uint32_t) pImageBuffer[0] << endl << endl;


                           fc.OutputPixelFormat = PixelType_RGB8packed;
                           fc.Convert(image, ptrGrabResult);
                           QImage* QtImage= new QImage((uint8_t*)image.GetBuffer(), ptrGrabResult->GetWidth(), ptrGrabResult->GetHeight(),QImage::Format_RGB888);
                           QGraphicsPixmapItem *item=new QGraphicsPixmapItem(QPixmap::fromImage(*QtImage));
                           QGraphicsScene *scene = new QGraphicsScene();
                           scene->addPixmap(item->pixmap());
                           ui->graphicsView->setScene(scene);
                           ui->graphicsView->update();
                           ui->tabWidget->setCurrentIndex(1);



           #ifdef PYLON_WIN_BUILD
                           // Display the grabbed image.
                           Pylon::DisplayImage(1, ptrGrabResult);
           #endif
                       }
                       else
                       {
                           cout << "Error: " << ptrGrabResult->GetErrorCode() << " " << ptrGrabResult->GetErrorDescription() << endl;
                       }
                  }
               }
               catch (GenICam::GenericException &e)
               {
                   // Error handling.
                   cerr << "An exception occurred." << endl
                   << e.GetDescription() << endl;
                   exitCode = 1;
               }
       }

}

void MainWindow::on_b_Exit_clicked()
{
    QApplication::quit();
}
