// Grab.cpp
/*
   This sample illustrates how to grab and process images using the CInstantCamera class.
   The images are grabbed and processed asynchronously, i.e.,
   while the application is processing a buffer, the acquisition of the next buffer is done
   in parallel.

   The CInstantCamera class uses a pool of buffers to retrieve image data
   from the camera device. Once a buffer is filled and ready,
   the buffer can be retrieved from the camera object for processing. The buffer
   and additional image data are collected in a grab result. The grab result is
   held by a smart pointer after retrieval. The buffer is automatically reused
   when explicitly released or when the smart pointer object is destroyed.
*/

// Include files to use the PYLON API.
#include <pylon/PylonIncludes.h>
#ifdef PYLON_WIN_BUILD
#    include <pylon/PylonGUI.h>
#endif

// Namespace for using pylon objects.
using namespace Pylon;
using namespace GenApi;

#include <opencv2/highgui/highgui.hpp>
#include <opencv2/core/core.hpp>
#include <opencv2/video/video.hpp>
using namespace cv;

// Namespace for using cout.
using namespace std;

#include <stdio.h>
#include "kbhit.h"

#include <sys/stat.h>  // for checking the file size
#include <sstream>

// Number of images to be grabbed.
//static const uint32_t c_countOfImagesToGrab = 100;




int main(int argc, char* argv[])
{
    // The exit code of the sample application.
    int exitCode = 0;

    // Automagically call PylonInitialize and PylonTerminate to ensure the pylon runtime system
    // is initialized during the lifetime of this object.
    Pylon::PylonAutoInitTerm autoInitTerm;
    VideoWriter cvVideoCreator;
    struct stat statbuf;
    string filenameBase = "/opt/PylonTestAVI";
    uint filecounter = 1;
    string filename = "";


    try
    {
        // Create an instant camera object with the camera device found first.
        CInstantCamera camera( CTlFactory::GetInstance().CreateFirstDevice());

        camera.Open();

		INodeMap& nodeMap = camera.GetNodeMap();
		CEnumerationPtr TestImageSelector = nodeMap.GetNode("TestImageSelector");
		if(IsAvailable(TestImageSelector))
		{
		   TestImageSelector->FromString("Testimage4");
		}
		else
		{
		   CEnumerationPtr TestPattern = nodeMap.GetNode("TestPattern");
		   TestPattern->FromString("ColorDiagonalSawtooth8");
		} 



		CIntegerPtr DeviceLinkThroughputLimit = nodeMap.GetNode("DeviceLinkThroughputLimit");
		if(IsAvailable(DeviceLinkThroughputLimit))
		{
			DeviceLinkThroughputLimit->SetValue(8300000);
		}
		CEnumerationPtr PixelFormat = nodeMap.GetNode("PixelFormat");


		if(IsAvailable(PixelFormat))
		{
			PixelFormat->FromString("BayerGB8");
		}
	

		CIntegerPtr Width = nodeMap.GetNode("Width");
		Width->SetValue(1000);
		CIntegerPtr Height = nodeMap.GetNode("Height");
		Height->SetValue(1000);
		Size FrameSize = Size(Width->GetValue(),Height->GetValue());
        stringstream s ;
        s<<"_" ;
        s<< filecounter;
        filename = filenameBase;
        filename += s.str() + ".avi";

		//cvVideoCreator.open("/opt/PylonTest_DIVX.avi",CV_FOURCC('M','P','4','2'),20,FrameSize,true);
		cvVideoCreator.open(filename,CV_FOURCC('D','I','V','X'),20,FrameSize,true);
        //cvVideoCreator.open("/opt/PylonTest.avi",CV_FOURCC('M','J','P','G'),20,FrameSize,true);


        // Print the model name of the camera.
        cout << "Using device " << camera.GetDeviceInfo().GetModelName() << endl;

        // The parameter MaxNumBuffer can be used to control the count of buffers
        // allocated for grabbing. The default value of this parameter is 10.
        camera.MaxNumBuffer = 5;
        CImageFormatConverter fc;
        fc.OutputPixelFormat = PixelType_BGR8packed;
        CPylonImage image;

        // Start the grabbing of c_countOfImagesToGrab images.
        // The camera device is parameterized with a default configuration which
        // sets up free-running continuous acquisition.
        camera.StartGrabbing();

        // This smart pointer will receive the grab result data.
        CGrabResultPtr ptrGrabResult;



        // Camera.StopGrabbing() is called automatically by the RetrieveResult() method
        // when c_countOfImagesToGrab images have been retrieved.
        while ( camera.IsGrabbing())
        {
            // Wait for an image and then retrieve it. A timeout of 5000 ms is used.
            camera.RetrieveResult( 5000, ptrGrabResult, TimeoutHandling_ThrowException);

            // Image grabbed successfully?
            if (ptrGrabResult->GrabSucceeded())
            {
                // Access the image data.
                cout << "SizeX: " << ptrGrabResult->GetWidth() << endl;
                cout << "SizeY: " << ptrGrabResult->GetHeight() << endl;
                const uint8_t *pImageBuffer = (uint8_t *) ptrGrabResult->GetBuffer();
                cout << "Gray value of first pixel: " << (uint32_t) pImageBuffer[0] << endl << endl;
                fc.Convert(image,ptrGrabResult);
				Mat cv_img = cv::Mat(ptrGrabResult->GetHeight(),ptrGrabResult->GetWidth(), CV_8UC3,(uint8_t*)image.GetBuffer() ) ;
				imshow("ImageWindows",cv_img);
				waitKey(1);

                cvVideoCreator.write(cv_img);

                if(_kbhit() && _getch() == 27)
                {
                	printf( "Escaped pressed. I'm out of here" );
                	camera.StopGrabbing();

                }
                if (ptrGrabResult->GetBlockID() % 20 == 0)
                {
					const char* ptrFilename = filename.c_str() ;
					cout << "Current File name " << filename.c_str() <<endl;
					if( stat(ptrFilename,&statbuf) != -1  &&  statbuf.st_size   > 6 * 1024 *1024)
					{
						cvVideoCreator.release();

						filecounter++;
						stringstream s ;
						s<<"_" ;
						s<< filecounter;
						string filename_local = filenameBase;
						filename_local += s.str() + ".avi";
                        filename = filename_local;
						//cvVideoCreator.open("/opt/PylonTest_DIVX.avi",CV_FOURCC('M','P','4','2'),20,FrameSize,true);
						cvVideoCreator.open(filename,CV_FOURCC('D','I','V','X'),20,FrameSize,true);
						//cvVideoCreator.open("/opt/PylonTest.avi",CV_FOURCC('M','J','P','G'),20,FrameSize,true);

					}
                }

            }
            else
            {
                cout << "Error: " << ptrGrabResult->GetErrorCode() << " " << ptrGrabResult->GetErrorDescription();
            }
        }
    }
    catch (GenICam::GenericException &e)
    {
        // Error handling.
        cerr << "An exception occurred." << endl
        << e.GetDescription() << endl;
        exitCode = 1;
    }
    cvVideoCreator.release();
    // Comment the following two lines to disable waiting on exit.
    cerr << endl << "Press Enter to exit." << endl;
    while( cin.get() != '\n');

    return exitCode;
}
