/*
 * This sample code has been created to demontrate the useage of pylon sdk in cambination with QT Lib
 *
 * */


#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "featuretreedialog.h"

#include <QMessageBox>
#include <QGraphicsView>
#include <QGraphicsPixmapItem>
#include <QTimer>
#include <QDebug>


#include <pylon/PylonIncludes.h>
#include <pylon/DeviceInfo.h>


using namespace std;
using namespace GenApi;
using namespace GenICam ;

using namespace Pylon;

QString FullNameOfSelectedDevice ="";



MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{

   

    ui->setupUi(this);
    ui->menuBar->show();

    toolbar =new QToolBar(this);
    toolbarActionopen = new QAction(tr("open"),this);
    toolbarActionclose = new QAction(tr("close"),this);
    toolbarActionSingleGrab = new QAction(tr("Single"),this);
    toolbarActionopenContinuesGrab = new QAction(tr("Continus"),this);
    toolbarActionPlaybackStop = new QAction(tr("Stop"),this);

    // camera open button
    QIcon icon("://icons/connect.png");
    QSize size(30,30);
    toolbar->setIconSize(size);
    toolbar->setObjectName("Toolbar");
    this->addToolBar(Qt::TopToolBarArea,toolbar);

    toolbarActionopen->setIcon(icon);  // Camera open
    toolbar->addAction(toolbarActionopen);
    connect(toolbarActionopen, SIGNAL(triggered()), this, SLOT(on_Toolbar_open()));


    icon.addFile("://icons/disconnect.png");
    toolbarActionclose->setIcon(icon);
    toolbar->addAction(toolbarActionclose);
    connect(toolbarActionclose, SIGNAL(triggered()), this, SLOT(on_Toolbar_close()));

    icon.addFile("://icons/OneShot.png");
    toolbarActionSingleGrab->setIcon(icon);
    toolbar->addAction(toolbarActionSingleGrab);
    connect(toolbarActionSingleGrab, SIGNAL(triggered()), this, SLOT(on_Toolbar_SingleGrab()));

    icon.addFile("://icons/ContinuousShot.png");
    toolbarActionopenContinuesGrab->setIcon(icon);
    toolbar->addAction(toolbarActionopenContinuesGrab);
    connect(toolbarActionopenContinuesGrab, SIGNAL(triggered()), this, SLOT(on_Toolbar_ContinuesGrab()));

    QIcon iconPlyback("://icons/media-playback-stop.png");
    toolbarActionPlaybackStop->setIcon(iconPlyback);
    toolbar->addAction(toolbarActionPlaybackStop);
    connect(toolbarActionPlaybackStop, SIGNAL(triggered()), this, SLOT(on_Toolbar_PlayBackStop()));



    setButtonStaus(true,false,false,false,false);
    toolbar->show();

    autoenumerate() ; // display all available Basler Cameras
    setEnableCotrols(false);

    timerAutoEnumeration = new QTimer(this);
    connect(timerAutoEnumeration, SIGNAL(timeout()), this, SLOT(timerUpdate()));
    timerAutoEnumeration->setObjectName("AutoEnumeration");
}

MainWindow::~MainWindow()
{
    timerAutoEnumeration->stop();
    delete timerAutoEnumeration;
    delete toolbar;
    delete toolbarActionopen;
    delete ui;
}

void MainWindow::on_pushButton_clicked()
{
    ui->WidgetDevice->setGeometry(20,20,100,200);

    ui->WidgetDevice->show();
    ui->WidgetDevice->setAllowedAreas(Qt::RightDockWidgetArea | Qt::TopDockWidgetArea);

}

void MainWindow::autoenumerate()
{
    DeviceInfoList_t dList;
    CTlFactory::GetInstance().EnumerateDevices(dList,true);
     if ( dList.size() == 0 )
     {
         addText("No camera found",QColor ("red"));
     }
     else
     {
         bool found =false;  // in case that auto can is active, it will add item only if a new one is found.

         for( uint i=0; i < dList.size(); i++ )
         {
            QListWidgetItem *item = new QListWidgetItem(QString(dList[i].GetFriendlyName()));

            QAbstractItemModel* model = ui->listWidget_devices->model() ;
            for(int j = 0; j < ui->listWidget_devices->count(); j++)
            {
                if(model->index(j, 0).data(Qt::DisplayRole).toString().contains(dList[i].GetFriendlyName().c_str()))
                {
                    found = true;
                     break;
                }
            }
            if(!found)
            {
                ui->listWidget_devices->addItem(item);
            }
            found = false;
         }

         if(ui->listWidget_devices->count() > dList.size())
         {
             ui->listWidget_devices->clear();
             for( uint i=0; i < dList.size(); i++ )
             {
                 QListWidgetItem *item = new QListWidgetItem(QString(dList[i].GetFriendlyName()));
                 ui->listWidget_devices->addItem(item);
             }
         }
     }
}

void MainWindow::on_actionShow_devices_triggered()
{

}
void MainWindow::on_Toolbar_open()
{
    if(FullNameOfSelectedDevice.length() > 0)
    {
        opencamera(FullNameOfSelectedDevice.toStdString().c_str());
    }
    else
    {
         QMessageBox::information(NULL, "error","Please select a camera first",0);
    }

}
void MainWindow::on_Toolbar_close()
{
   if(m_camera.IsOpen())
   {
       m_camera.Close();
       resetValues();
       setButtonStaus(true,false,false,false,false);
       setEnableCotrols(false);

   }
}

void MainWindow::on_Toolbar_SingleGrab()
{
    if(FullNameOfSelectedDevice.length() > 0)
    {
       try
        {
            setButtonStaus(false,false,false,false,true);
            // The parameter MaxNumBuffer can be used to control the count of buffers
            // allocated for grabbing. The default value of this parameter is 10.
            m_camera.MaxNumBuffer = 1;

            // Start the grabbing of c_countOfImagesToGrab images.
            // The camera device is parameterized with a default configuration which
            // sets up free-running continuous acquisition.


            // This smart pointer will receive the grab result data.
            CGrabResultPtr ptrGrabResult;
            CImageFormatConverter fc;
            fc.OutputPixelFormat = PixelType_BGR8packed;
            CPylonImage image;
            m_camera.StartGrabbing(1);
           // m_camera.GrabOne(5000,ptrGrabResult,TimeoutHandling_ThrowException);
            // Camera.StopGrabbing() is called automatically by the RetrieveResult() method
            // when c_countOfImagesToGrab images have been retrieved.
            // Wait for an image and then retrieve it. A timeout of 5000 ms is used.
            m_camera.RetrieveResult( 5000, ptrGrabResult, TimeoutHandling_Return);

                // Image grabbed successfully?
                if (ptrGrabResult->GrabSucceeded())
                {
                   addText(QString("Image width : %1").arg(ptrGrabResult->GetWidth()));
                   addText(QString("Image height : %1").arg(ptrGrabResult->GetHeight()));

                    //there are 2 way to create a Qimage.
                   // QImage* QtImage= new QImage((uchar*)frame.data, frame.cols, frame.rows,QImage::Format_RGB888);
                   fc.OutputPixelFormat = PixelType_RGB8packed;
                   fc.Convert(image, ptrGrabResult);
                   QImage qtImage((uint8_t*)image.GetBuffer(), ptrGrabResult->GetWidth(), ptrGrabResult->GetHeight(),QImage::Format_RGB888);

                   QGraphicsScene *scene = new QGraphicsScene();
                   scene->addPixmap(QPixmap::fromImage(qtImage));

                   ui->Img_Disply->setScene(scene);
                   ui->Img_Disply->update();
                   scene = NULL;
                }
                else
                {
                    cout << "Error: " << ptrGrabResult->GetErrorCode() << " " << ptrGrabResult->GetErrorDescription() << endl;
                }
                m_camera.StopGrabbing();

        }
        catch (GenICam::GenericException &e)
        {
            // Error handling.
            cerr << "An exception occurred." << endl
            << e.GetDescription() << endl;

        }
    }
    else
    {
         QMessageBox::information(NULL, "error","Please select a camera first",0);
    }
     setButtonStaus(true,true,true,true,false);
}
void MainWindow::on_Toolbar_ContinuesGrab()
{

    if(FullNameOfSelectedDevice.length() > 0)
    {
       try
        {
            setButtonStaus(false,false,false,false,true);
            // The parameter MaxNumBuffer can be used to control the count of buffers
            // allocated for grabbing. The default value of this parameter is 10.
            m_camera.MaxNumBuffer = 20;

            // Start the grabbing of c_countOfImagesToGrab images.
            // The camera device is parameterized with a default configuration which
            // sets up free-running continuous acquisition.


            // This smart pointer will receive the grab result data.
            CGrabResultPtr ptrGrabResult;
            CImageFormatConverter fc;
            fc.OutputPixelFormat = PixelType_BGR8packed;
            CPylonImage image;
            m_camera.StartGrabbing();
           // m_camera.GrabOne(5000,ptrGrabResult,TimeoutHandling_ThrowException);
            // Camera.StopGrabbing() is called automatically by the RetrieveResult() method
            // when c_countOfImagesToGrab images have been retrieved.
            // Wait for an image and then retrieve it. A timeout of 5000 ms is used.

            while(m_camera.IsGrabbing())
            {
                 m_camera.RetrieveResult( 5000, ptrGrabResult, TimeoutHandling_ThrowException);

                // Image grabbed successfully?
                if (ptrGrabResult->GrabSucceeded())
                {
                   addText(QString("Image width : %1").arg(ptrGrabResult->GetWidth()));
                   addText(QString("Image height : %1").arg(ptrGrabResult->GetHeight()));

                    //there are 2 way to create a Qimage.
                   // QImage* QtImage= new QImage((uchar*)frame.data, frame.cols, frame.rows,QImage::Format_RGB888);
                       //there are 2 way to create a Qimage.
                      // QImage* QtImage= new QImage((uchar*)frame.data, frame.cols, frame.rows,QImage::Format_RGB888);
                   fc.OutputPixelFormat = PixelType_RGB8packed;
                   fc.Convert(image, ptrGrabResult);
                   QImage qtImage((uint8_t*)image.GetBuffer(), ptrGrabResult->GetWidth(), ptrGrabResult->GetHeight(),QImage::Format_RGB888);

                   QGraphicsScene *scene = new QGraphicsScene();
                   scene->addPixmap(QPixmap::fromImage(qtImage));


                   ui->Img_Disply->setScene(scene);
                   //ui->Img_Disply->update();
                   qApp->processEvents();
                   if(ui->graphicsView->height() < ptrGrabResult->GetHeight() ||  ui->graphicsView->width() < ptrGrabResult->GetWidth() )
                   {
                       ui->graphicsView->setGeometry(qtImage.rect());
                   }

                   delete scene;

               }
               else
               {
                   cout << "Error: " << ptrGrabResult->GetErrorCode() << " " << ptrGrabResult->GetErrorDescription() << endl;
               }

            }
        }
        catch (GenICam::GenericException &e)
        {
            // Error handling.
            cerr << "An exception occurred." << endl
            << e.GetDescription() << endl;
        }
    }
    else
    {
         QMessageBox::information(NULL, "error","Please select a camera first",0);
    }
     setButtonStaus(true,true,true,true,false);

}

void MainWindow::on_actionShow_devices_changed()
{
  if (ui->actionShow_devices->isChecked())
  {


      //addText("enabled");
  }
  else
  {
     // addText("disenabled");
  }

}
void MainWindow::addText(QString msg)
{
    ui->textEdit_logbox->append(msg);
}


void MainWindow::addText(QString msg, QColor setTextColor)
{
    ui->textEdit_logbox->setTextColor(setTextColor);
    ui->textEdit_logbox->moveCursor(QTextCursor::End);
    ui->textEdit_logbox->append(msg);
    ui->textEdit_logbox->setHtml(msg);

    ui->textEdit_logbox->moveCursor(QTextCursor::End);
    ui->textEdit_logbox->setTextColor(QColor("black"));
}


void MainWindow::on_action_Exit_triggered()
{
    QApplication::exit();
}

void MainWindow::on_actionDefault_layout_triggered()
{
    ui->Widget_logbox->show();
    ui->WidgetDevice->show();
    ui->Widget_disply->show();
    ui->WidgetParameters->show();
}
void MainWindow::setButtonStaus (bool Connect,bool Disconnect ,bool singleGrab,bool continuesGrab,bool stopPlyBack)
{
    this->toolbarActionopen->setEnabled(Connect);
    this->toolbarActionclose->setEnabled(Disconnect);
    this->toolbarActionSingleGrab->setEnabled(singleGrab);
    this->toolbarActionopenContinuesGrab->setEnabled(continuesGrab);
    this->toolbarActionPlaybackStop->setEnabled(stopPlyBack);


}

void MainWindow::on_actionEnumerateDevices_triggered()
{
   autoenumerate();
}

void MainWindow::on_listWidget_devices_clicked(const QModelIndex &index)
{
    FullNameOfSelectedDevice = index.data().toString();
    addText("last selected Device : " + FullNameOfSelectedDevice,QColor("green"));
    //setButtonStaus(true,true,false,false);
}

void MainWindow::on_listWidget_devices_doubleClicked(const QModelIndex &index)
{
     FullNameOfSelectedDevice = index.data().toString();
     addText("last selected Device : " + FullNameOfSelectedDevice,QColor("green"));
     // Create an instant camera object with the camera device found first.
     opencamera(FullNameOfSelectedDevice);
}

void MainWindow::opencamera(QString fulname)
{
    try
      {
        if(fulname.length() > 0)
        {
             CDeviceInfo info;
             info.SetFriendlyName(fulname.toStdString().c_str());
             m_camera.Attach(CTlFactory::GetInstance().CreateFirstDevice(info));
             m_camera.Open();
             GenApi::INodeMap& nodemap = m_camera.GetNodeMap();
             m_nodemap =&nodemap;

             m_DeviceSFNCVersion = m_camera.GetSfncVersion();


             CIntegerPtr Width (nodemap.GetNode("Width"));
             ui->ScrollBar_Width->setMaximum(Width->GetMax());
             ui->ScrollBar_Width->setMinimum(Width->GetMin());
             //ui->ScrollBar_Width->setSingleStep(Width->GetInc());
             ui->ScrollBar_Width->setValue(Width->GetValue());
             ui->spinBox_2->setValue((int)Width->GetValue());


             CIntegerPtr Height (nodemap.GetNode("Height"));
             qDebug() << QString("height in open 1:  %1").arg(Height->GetValue());
             ui->ScrollBar_Height->setMaximum(Height->GetMax());
             ui->ScrollBar_Height->setMinimum(Height->GetMin());
             ui->ScrollBar_Height->setSingleStep(Height->GetInc());
             ui->ScrollBar_Height->setValue(Height->GetValue());
             ui->spinBox->setValue((int)Height->GetValue());
             qDebug() << QString("height in open 2 %1").arg(Height->GetValue());

             QStringList enumFeatureList;

             getAllEnumValues(enumFeatureList,m_camera,"PixelFormat");
             ui->comboBox_PixelFormat->clear();
             ui->comboBox_PixelFormat->addItems(enumFeatureList);
             enumFeatureList.clear();


             if(m_DeviceSFNCVersion < Sfnc_2_0_0 )  // ace GigE
             {
                 CIntegerPtr ExposureTimeRaw (nodemap.GetNode("ExposureTimeRaw"));
                 ui->ScrollBar_Exposure->setMaximum(ExposureTimeRaw->GetMax());
                 ui->ScrollBar_Exposure->setMinimum(ExposureTimeRaw->GetMin());
                 ui->ScrollBar_Exposure->setSingleStep(ExposureTimeRaw->GetInc());
                 ui->ScrollBar_Exposure->setValue(ExposureTimeRaw->GetValue());
                 ui->spinBox_3->setValue(ExposureTimeRaw->GetValue());
                 qDebug() << QString("Expoure%1 :: %2").arg(ExposureTimeRaw->GetValue()).arg(ui->ScrollBar_Exposure->maximum());

                 // Test Iamge Selector
                 getAllEnumValues(enumFeatureList,m_camera,"TestImageSelector");
                 ui->comboBox_TestImageSelector->clear();
                 ui->comboBox_TestImageSelector->addItems(enumFeatureList);
                 enumFeatureList.clear();
             }
             else if (m_DeviceSFNCVersion == Sfnc_2_1_0 )  // ace USB
             {   // Basler USB Cameras
                 CFloatPtr ExposureTime (nodemap.GetNode("ExposureTime"));
                 ui->ScrollBar_Exposure->setMaximum((int)ExposureTime->GetMax());
                 ui->ScrollBar_Exposure->setMinimum((int)ExposureTime->GetMin());
                 //getIng cause app crash
                // ui->ScrollBar_Exposure->setSingleStep((int64_t)ExposureTime->GetInc());
                 ui->ScrollBar_Exposure->setValue((int)ExposureTime->GetValue());
                 ui->spinBox_3->setValue((int)ExposureTime->GetValue());

                 // Test Iamge Selector
                 getAllEnumValues(enumFeatureList,m_camera,"TestImageSelector"); //TestImageSelector TestPattern
                 ui->comboBox_TestImageSelector->clear();
                 ui->comboBox_TestImageSelector->addItems(enumFeatureList);
                 enumFeatureList.clear();

             }
             else if (m_DeviceSFNCVersion == Sfnc_2_2_0 )  // Dart Cameras
             {   // Basler USB Cameras
                 CFloatPtr ExposureTime (nodemap.GetNode("ExposureTime"));
                 ui->ScrollBar_Exposure->setMaximum((int)ExposureTime->GetMax());
                 ui->ScrollBar_Exposure->setMinimum((int)ExposureTime->GetMin());
                 //getIng cause app crash
                // ui->ScrollBar_Exposure->setSingleStep((int64_t)ExposureTime->GetInc());
                 ui->ScrollBar_Exposure->setValue((int)ExposureTime->GetValue());
                 ui->spinBox_3->setValue((int)ExposureTime->GetValue());

                 // Test Iamge Selector
                 getAllEnumValues(enumFeatureList,m_camera,"TestPattern"); //TestImageSelector TestPattern
                 ui->comboBox_TestImageSelector->clear();
                 ui->comboBox_TestImageSelector->addItems(enumFeatureList);
                 enumFeatureList.clear();

             }
             setButtonStaus(false,true,true,true,false);
             setEnableCotrols(true);
        }
    } // try
    catch(GenICam::GenericException &e)
    {
       addText("An exception occurred.");
       addText (e.GetDescription());
    }

}

void MainWindow::getAllEnumValues(QStringList &Featurelist, CInstantCamera &camera, GenICam::gcstring EnumFeatureName)
{

    GenApi::INodeMap& nodemap =camera.GetNodeMap();
    CEnumerationPtr EnumFeature(nodemap.GetNode(EnumFeatureName));
    GenApi::NodeList_t my_featurelist;
    EnumFeature->GetEntries(my_featurelist);

    for (GenApi::NodeList_t::iterator it = my_featurelist.begin(); it != my_featurelist.end(); ++it)
        {
            GenApi::CEnumEntryPtr pEnumEntry(*it);
            if (GenApi::IsAvailable(*it))
             {
                Featurelist.append(pEnumEntry->GetSymbolic().c_str());
             }
        }
}


void MainWindow::setEnableCotrols(bool status)
{
    ui->ScrollBar_Exposure->setEnabled(status);
    ui->ScrollBar_Height->setEnabled(status);
    ui->ScrollBar_Width->setEnabled(status);
    ui->comboBox_PixelFormat->setEnabled(status);
    ui->comboBox_TestImageSelector->setEnabled(status);
}

void MainWindow::on_ScrollBar_Height_sliderReleased()
{
    qDebug() << QString ("height value in ScrollBar : %1").arg(ui->ScrollBar_Height->value());

    int setValue =setIntergerValue("Height",ui->ScrollBar_Height->value());
    ui->ScrollBar_Height->setValue(setValue);
    ui->spinBox->setValue(setValue);
}



void MainWindow::on_ScrollBar_Width_sliderReleased()
{
    qDebug() << QString("slider released %1 ").arg(ui->ScrollBar_Width->value());
    int x = setIntergerValue("Width",ui->ScrollBar_Width->value());
    ui->ScrollBar_Width->setValue(x);
    ui->spinBox_2->setValue(x);
    qDebug() << QString ("Width value in ScrollBar: %1").arg(x);

}

void MainWindow::on_ScrollBar_Exposure_sliderReleased()
{
    if(ui->spinBox_3->value() !=  ui->ScrollBar_Exposure->value())
    {
        int x = 0;
        if(m_DeviceSFNCVersion < Sfnc_2_0_0)
         {
             x = setIntergerValue("ExposureTimeRaw",ui->ScrollBar_Exposure->value());
         }
         else if (m_DeviceSFNCVersion == Sfnc_2_1_0) // Ace USB
         {
             x = setFloatValue("ExposureTime",ui->ScrollBar_Exposure->value());
         }
        else if (m_DeviceSFNCVersion == Sfnc_2_2_0)   // Dart Cameras
        {
            x = setFloatValue("ExposureTime",ui->ScrollBar_Exposure->value());
        }


        if(x > 0)
        {
            ui->ScrollBar_Exposure->setValue(x);
            ui->spinBox_3->setValue(x);
        }
        else
        {
            addText(QString ("faild to set the value : %1 ").arg(x).toStdString().c_str() );

        }
    }

}



void MainWindow::on_spinBox_editingFinished()
{
    if(ui->spinBox->value() !=  ui->ScrollBar_Height->value())  // to avoid a loop
    {
        int x = setIntergerValue("Height",ui->spinBox->value());
        ui->ScrollBar_Height->setValue(x);
        ui->spinBox->setValue(x);
    }
}

void MainWindow::on_spinBox_2_editingFinished()
{
    if(ui->spinBox_2->value() !=  ui->ScrollBar_Width->value())
    {
      int x = setIntergerValue("Width",ui->spinBox_2->value());
      ui->ScrollBar_Width->setValue(x);
      ui->spinBox_2->setValue(x);
    }
}
void MainWindow::on_spinBox_3_editingFinished()
{
    if(ui->spinBox_3->value() !=  ui->ScrollBar_Exposure->value())
    {
        int x = 0;
        if(m_DeviceSFNCVersion < Sfnc_2_0_0 )
         {
             x = setIntergerValue("ExposureTimeRaw",ui->spinBox_3->value());
         }
         else if (m_DeviceSFNCVersion == Sfnc_2_1_0)
         {
              x = setFloatValue("ExposureTime",ui->spinBox_3->value());
         }
        else if (m_DeviceSFNCVersion == Sfnc_2_2_0)
        {
             x = setFloatValue("ExposureTime",ui->spinBox_3->value());
        }
        ui->ScrollBar_Exposure->setValue(x);
        ui->ScrollBar_Exposure->setSliderPosition(x);
        ui->spinBox_3->setValue(x);
    }
}


void MainWindow::on_comboBox_PixelFormat_currentIndexChanged(const QString &arg1)
{
    if(arg1.length() > 1)
    {
       if(!m_camera.IsOpen())
       {
              m_camera.Open();
       }

        GenApi::INodeMap& nodemap = m_camera.GetNodeMap();
        CEnumerationPtr PixelFormat(nodemap.GetNode("PixelFormat"));

        if ( IsWritable( PixelFormat))
        {
            PixelFormat->FromString(arg1.toStdString().c_str());
        }

    }
}

void MainWindow::on_actionAutoScan_triggered()
{
    if(ui->actionAutoScan->isChecked())
    {
        //m_TimerID = startTimer(5000);
        timerAutoEnumeration->start(1000);
    }
    else
    {
        timerAutoEnumeration->stop();
    }
}

void MainWindow::timerUpdate()
{

    addText("Timer interval reached",QColor("red"));
    qDebug() << "timer reached";
    autoenumerate();
    timerAutoEnumeration->start(10000);
}

void MainWindow::on_comboBox_TestImageSelector_currentTextChanged(const QString &arg1)
{
    if(arg1.length() > 1)
    {
       if(!m_camera.IsOpen())
       {
              m_camera.Open();
              m_nodemap = &m_camera.GetNodeMap();
       }

       if (m_DeviceSFNCVersion < Sfnc_2_2_0)
       {
            CEnumerationPtr TestImageSelector(m_nodemap->GetNode("TestImageSelector"));

            if ( IsWritable( TestImageSelector))
            {
                TestImageSelector->FromString(arg1.toStdString().c_str());
            }
       }
       else if(m_DeviceSFNCVersion == Sfnc_2_2_0)
       {
           CEnumerationPtr TestPattern(m_nodemap->GetNode("TestPattern"));

           if ( IsWritable( TestPattern))
           {
               TestPattern->FromString(arg1.toStdString().c_str());
           }

       }

    }

}

int MainWindow::setIntergerValue(QString Nodename,int value)
{
   try
    {
        if(!m_camera.IsOpen())
        {
            m_camera.Open();
            m_nodemap = &m_camera.GetNodeMap();
        }
        CIntegerPtr Parameter(m_nodemap->GetNode(Nodename.toStdString().c_str()));
        int valuetobeset = value - (value % Parameter->GetInc());  // some time it will not set all values in the cameras.
        if( valuetobeset >= Parameter->GetMin() && valuetobeset <= Parameter->GetMax() )
        {
            Parameter->SetValue(valuetobeset);
            return valuetobeset;
        }
    }
    catch (GenICam::GenericException &e)
      {

          // Error handling.
          cerr << "An exception occurred." << endl
          << e.GetDescription() << endl;

      }
     return 0;

}
int MainWindow::setFloatValue(QString Nodename,int value)
{
   try
    {
        if(!m_camera.IsOpen())
        {
            m_camera.Open();
        }
        m_nodemap = &m_camera.GetNodeMap();
        CFloatPtr Parameter(m_nodemap->GetNode(Nodename.toStdString().c_str()));

        if( value >= Parameter->GetMin() && value <= Parameter->GetMax() )
        {
             Parameter->SetValue((double)value);
              return value;
        }

    }
    catch (GenICam::GenericException &e)
      {
          // Error handling.
          cerr << "An exception occurred." << endl
          << e.GetDescription() << endl;
      }
    return 0;
}


void MainWindow::on_Toolbar_PlayBackStop()
{
    if(m_camera.IsGrabbing())
    {
        m_camera.StopGrabbing();
        setButtonStaus(true,true,true,true,false);
    }

}




void MainWindow::on_actionDisplay_all_Parameters_triggered()
{
   // TBD  // make sure that the camera is opened.

  FeatureTreeDialog* childDialog = new FeatureTreeDialog();
  QTreeWidget * treeView = childDialog->findChild<QTreeWidget*>("treeWidget");

      QTreeWidgetItem* Titel = new QTreeWidgetItem();
      Titel->setText(0,QString("Parameter Name"));
      Titel->setText(1,QString("Value "));
      Titel->setText(2,QString("Parameter Type"));
      treeView->setHeaderItem(Titel);

      NodeList_t nodes;
      m_nodemap->GetNodes(nodes);

      QTreeWidgetItem* item = new QTreeWidgetItem();

      // prepaire the camera ICON (main Node)
      item->setText(0,m_camera.GetDeviceInfo().GetFriendlyName().c_str());
      item->setIcon(0,*(new QIcon("://files/Icon_48x48.png")));
      treeView->addTopLevelItem(item);

      INode* pNode = m_nodemap->GetNode("Root");
      handelCategory(item,pNode,treeView);
      treeView->addTopLevelItem(item);

      // stream parameters

      INodeMap& nodemap_stream = m_camera.GetStreamGrabberNodeMap();
     // INode* pNode_s = nodemap_stream.GetNode("Root");

      NodeList_t entries;
      nodemap_stream.GetNodes( entries );
      QTreeWidgetItem* itemStream = new QTreeWidgetItem();
      itemStream->setText(0,"Streaming Parameters");
      itemStream->setIcon(0,*(new QIcon("://files/Category.png")));
      item->addChild(itemStream);

      for ( NodeList_t::iterator it = entries.begin(); it != entries.end(); ++it)
      {
          INode* pStream_Node = (*it);
          handelCategory(itemStream,pStream_Node,treeView);

      }
      // Transportlayer parameters

      INodeMap& nodemap_Transport =m_camera.GetTLNodeMap();
      entries.clear();
      nodemap_Transport.GetNodes( entries );
      QTreeWidgetItem* itemTransport = new QTreeWidgetItem();
      itemTransport->setText(0,"Transport Layer");
      itemTransport->setIcon(0,*(new QIcon("://files/Category.png")));
      item->addChild(itemTransport);

      for ( NodeList_t::iterator it = entries.begin(); it != entries.end(); ++it)
      {
          INode* pStream_Node = (*it);
          handelCategory(itemTransport,pStream_Node,treeView);
      }

      childDialog->exec();
      delete childDialog;
}

void MainWindow::handelCategory(QTreeWidgetItem* Subitem, INode* pNode, QTreeWidget* Treeview )
{
   try
    {
        QString s= pNode->GetName().c_str();
        QTreeWidgetItem* CategoryItem = new QTreeWidgetItem();

        if( s != "Root")
        {
        CategoryItem->setText(0,pNode->GetName().c_str());
        CategoryItem->setIcon(0,*(new QIcon("://files/Category.png")));
        Subitem->addChild(CategoryItem);
        }

        NodeList_t nodes;
        NodeList_t::iterator  it;
        pNode->GetChildren(nodes);
        for(it = nodes.begin() ; it!=nodes.end();it++)
        {

                INode* pNode = (*it);
                if( s !="Root" && IsImplemented(pNode))
                {
                std::string s = pNode->GetName().c_str();
                qDebug() << QString("current Category Name : %1").arg(s.c_str());

                QTreeWidgetItem* subitem = new QTreeWidgetItem();
                subitem->setText(0,pNode->GetName().c_str());
                subitem->setIcon(0,*(new QIcon("://files/Parameter.png")));
                CategoryItem->addChild(subitem);

                // the node could be different type
                if(CIntegerPtr(pNode))
                {
                    CIntegerPtr Parameter( pNode->GetNodeMap()->GetNode(s.c_str()));
                    int64_t x=  Parameter->GetValue();
                    QSpinBox* valuebox = new QSpinBox(Treeview);
                    valuebox->setValue(x);
                    Treeview->setItemWidget(subitem,1,valuebox);
                    subitem->setText(2,"Interger");

                }
                else if(CFloatPtr(pNode))
                {
                    CFloatPtr Parameter( pNode->GetNodeMap()->GetNode(s.c_str()));
                    double x=  Parameter->GetValue();
                    QSpinBox* valuebox = new QSpinBox(Treeview);
                    valuebox->setValue(x);
                    Treeview->setItemWidget(subitem,1,valuebox);
                    subitem->setText(1,QString("%1").arg(x));
                    subitem->setText(2,"Interger");

                }
                else if(CEnumerationPtr(pNode))
                {
                     CEnumerationPtr Parameter(pNode);
                     QComboBox* valuebox = new QComboBox(Treeview);

                     NodeList_t entries;
                     Parameter->GetEntries( entries );
                     for ( NodeList_t::iterator it = entries.begin(); it != entries.end(); ++it)
                    {
                         CEnumEntryPtr pEntry = (*it);
                         if (  IsAvailable (pEntry))
                         {
                             valuebox->addItem(pEntry->GetSymbolic().c_str());

                         }                                       
                     }
                    Treeview->setItemWidget(subitem,1,valuebox);
                    subitem->setText(1,"");
                    subitem->setText(2,"Enumeration");
                }
                else if ( CCommandPtr(pNode))
                {
                    QPushButton* Button = new QPushButton(Treeview);
                    Button->setText("Excecute");
                    Treeview->setItemWidget(subitem,1,Button);
                    subitem->setText(1,"");
                    subitem->setText(2,"Command");
                }
                else if ( CStringPtr(pNode))
                {
                    CStringPtr Parameter(pNode);
                    subitem->setText(1,Parameter->GetValue().c_str());
                    subitem->setText(2,"String");
                }
                else if ( CBooleanPtr(pNode))
                {
                    QRadioButton* Button = new QRadioButton (Treeview);
                    CStringPtr Parameter(pNode);
                    Treeview->setItemWidget(subitem,1,Button);
                    subitem->setText(1,Parameter->GetValue().c_str());
                    subitem->setText(2,"Boolan");
                }
            }
            else if(CCategoryPtr(pNode))
            {
               handelCategory (Subitem,pNode,Treeview);
            }

        } // for
    }
    catch (GenICam::GenericException &e)
    {
        // Error handling.
        cerr << "An exception occurred." << endl
        << e.GetDescription() << endl;
    }
}



void MainWindow::setParameter(INode* pNode , gcstring ParameterName,QString value)
{
    //TBD  it has to extened to another paramtertypes
    if(CIntegerPtr(pNode))
    {
       CIntegerPtr Parameter( pNode->GetNodeMap()->GetNode(ParameterName.c_str()));
       if (IsWritable(Parameter))
       {
           try
           {
               Parameter->SetValue( value.toInt());
               pNode->GetNodeMap()->InvalidateNodes();
           }
           catch(...)
           {
               addText("WARNING: the value could not be converted to int !" );
           }

       }
       else
       {
           addText(QString("Parameter is not writeable %1").arg( ParameterName.c_str()));
       }

    }
    else if (CEnumerationPtr(pNode))
    {
        CEnumerationPtr Parameter( pNode->GetNodeMap()->GetNode(ParameterName.c_str()));
        Parameter->FromString(value.toStdString().c_str());

    }
    else if (CFloatPtr(pNode))
    {
        CFloatPtr Parameter( pNode->GetNodeMap()->GetNode(ParameterName.c_str()));
        if (IsWritable(Parameter))
        {
            try
            {
                Parameter->SetValue( value.toFloat());
                pNode->GetNodeMap()->InvalidateNodes();
            }
            catch(...)
            {
                addText("WARNING: the value could not be converted to float !" );
            }

        }
        else
        {
            addText(QString("Parameter is not writeable %1").arg( ParameterName.c_str()));
        }
    }
}

void MainWindow::getParameter(INode* pNode , gcstring ParameterName,QString& value)
{
    //TBD  it has to extened to another paramtertypes

    if(CIntegerPtr(pNode))
    {
       CIntegerPtr Parameter( pNode->GetNodeMap()->GetNode(ParameterName.c_str()));
       value = QString::number( Parameter->GetValue());
    }
    else if (CEnumerationPtr(pNode))
    {
        CEnumerationPtr Parameter( pNode->GetNodeMap()->GetNode(ParameterName.c_str()));
        value = Parameter->GetCurrentEntry()->GetSymbolic();

    }
    else if (CFloatPtr(pNode))
    {
         CFloatPtr Parameter( pNode->GetNodeMap()->GetNode(ParameterName.c_str()));
         value = QString::number( Parameter->GetValue());
    }

    // TBD  the cod ehas to be extened to handel another type of parameters.


}

void MainWindow::resetValues()
{
    //reset the value of editable controlls on GUI
    ui->textEdit_logbox->clear();
    ui->lineEdit_parameter->clear();
    ui->lineEdit_Value->clear();
    ui->ScrollBar_Exposure->setRange(0,10);
    ui->ScrollBar_Exposure->setValue(0);
    ui->ScrollBar_Exposure->update();
    ui->ScrollBar_Height->setRange(0,10);
    ui->ScrollBar_Height->setValue(0);
    ui->ScrollBar_Width->setRange(0,10);
    ui->ScrollBar_Width->setValue(0);
    ui->spinBox->setValue(0);
    ui->spinBox_2->setValue(0);
    ui->spinBox_3->setValue(0);

}



void MainWindow::on_pB_GetValue_clicked()
{

    try
    {
        if(!m_camera.IsOpen())
        {
            m_camera.Open();
        }
        m_nodemap = &m_camera.GetNodeMap();
        GenICam::gcstring parameterName = ui->lineEdit_parameter->text().toStdString().c_str();
        QString returnValue = "";


        if(parameterName.length() > 3)
        {
            INode* pNode = m_camera.GetNodeMap().GetNode(parameterName);
            getParameter(pNode,parameterName,returnValue);
        }
        if(returnValue.length() > 0)
        {
            ui->lineEdit_Value->setText(returnValue);
        }

    }
    catch (GenICam::GenericException &e)
    {
        // Error handling.
        cerr << "An exception occurred." << endl
             << e.GetDescription() << endl;
    }

}



void MainWindow::on_pB_SetValue_clicked()
{
    try
    {
        if(!m_camera.IsOpen())
        {
            m_camera.Open();
        }
        m_nodemap = &m_camera.GetNodeMap();
        GenICam::gcstring parameterName = ui->lineEdit_parameter->text().toStdString().c_str();
        QString Value = ui->lineEdit_Value->text();

        if(parameterName.length() > 3)
        {
            INode* pNode = m_camera.GetNodeMap().GetNode(parameterName);
            setParameter(pNode,parameterName,Value);
        }
    }
    catch (GenICam::GenericException &e)
    {
        // Error handling.
        cerr << "An exception occurred." << endl
             << e.GetDescription() << endl;
    }


}

void MainWindow::on_actionSetIpAddress_triggered()
{
    int x = 2;
}
