#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTreeWidget>

#include <QTableWidgetItem>
#include <QtGui>
#include<QTreeWidgetItem>
#include<QTreeWidget>
#include <QtCore>
#include <QtWidgets>
#include <pylon/PylonIncludes.h>
using namespace Pylon;
using namespace GenApi;

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    void handelCategory(QTreeWidgetItem* Subitem, INode* pNode, QTreeWidget* Treeview );
    ~MainWindow();

private slots:
    void on_pushButton_clicked();

    void on_actionShow_devices_triggered();

    void on_actionShow_devices_changed();
    void on_Toolbar_open();
    void on_Toolbar_close();
    void on_Toolbar_SingleGrab();
    void on_Toolbar_ContinuesGrab();
    void on_Toolbar_PlayBackStop();
    void autoenumerate();
    void opencamera(QString Fullname);
    void timerUpdate();   // used by timer that enumerates devices.

    void getAllEnumValues(QStringList &FeatureList,Pylon::CInstantCamera &camera,GenICam::gcstring EnumFeatureName); // used to read emum vaules form the camera.

    // set and read parameter to/form the camera 
    void setParameter(INode* pNode , gcstring ParameterName,QString value);
    void getParameter(INode* pNode , gcstring ParameterName,QString& value);

    // add the text into the logbox
    void addText(QString msg,QColor);
    void addText(QString msg);

    // reset the values on GUI.
    void resetValues();


    void on_action_Exit_triggered();

    void on_actionDefault_layout_triggered();

    // set the staus of the buttons
    void setButtonStaus(bool bConnect,bool bDisconnect ,bool singleGrab,bool continuesGrab,bool Playbackstop);
    // set the status of the camera parameter controlls
    void setEnableCotrols(bool status);
    // set a interger value to the given parameter.
    int setIntergerValue(QString ,int);
    // set a float value to the given parameter.
    int setFloatValue(QString,int);


    void on_actionEnumerateDevices_triggered();

    void on_listWidget_devices_clicked(const QModelIndex &index);


    void on_listWidget_devices_doubleClicked(const QModelIndex &index);


    //void on_spinBox_3_valueChanged(int arg1);

    void on_comboBox_PixelFormat_currentIndexChanged(const QString &arg1);

    void on_actionAutoScan_triggered();


    void on_comboBox_TestImageSelector_currentTextChanged(const QString &arg1);

    void on_spinBox_editingFinished();

    void on_spinBox_2_editingFinished();

    void on_spinBox_3_editingFinished();

    void on_ScrollBar_Width_sliderReleased();

    void on_ScrollBar_Height_sliderReleased();

    void on_ScrollBar_Exposure_sliderReleased();

    void on_actionDisplay_all_Parameters_triggered();


    void on_pB_GetValue_clicked();


    void on_pB_SetValue_clicked();

    void on_actionSetIpAddress_triggered();

private:
    Ui::MainWindow *ui;
    QToolBar *toolbar;
    QAction *toolbarActionopen ;
    QAction *toolbarActionclose ;
    QAction *toolbarActionSingleGrab;
    QAction *toolbarActionopenContinuesGrab ;
    QAction *toolbarActionPlaybackStop;
    Pylon::CInstantCamera m_camera;
    VersionInfo m_DeviceSFNCVersion;
    QTimer *timerAutoEnumeration ;  // auto ennumeration of pylon devices
    GenApi::INodeMap *m_nodemap;

protected:


};



#endif // MAINWINDOW_H
