var __index = {"config":{"lang":["en"],"separator":"[\\s\\-]+","pipeline":["stopWordFilter"],"fields":{"title":{"boost":1000.0},"text":{"boost":1.0},"tags":{"boost":1000000.0}}},"docs":[{"location":"index.html","title":"VisualApplets","text":"<p>VisualApplets is a graphical development environment for programming frame grabbers and other image-processing hardware platforms.</p> <p></p> <p>Info</p> <p>Press F or S to start searching.</p> <p>For the latest version of the documentation, visit docs.baslerweb.com/visualapplets.</p>"},{"location":"index.html#user-documentation","title":"User Documentation","text":"<ul> <li>Overview of VisualApplets</li> <li>User Manual</li> <li>Tutorial &amp; Examples</li> <li>Operator Reference</li> <li>Custom Operators User Guide</li> <li>Device Resources</li> <li>Scripting</li> </ul> <p> PDF version of the User Manual, Operator Reference, and more</p>"},{"location":"index.html#application-notes","title":"Application Notes","text":"<ul> <li>Blob Analysis</li> <li>JPEG Compression</li> <li>Shared Memory</li> <li>Designing Applets for Programmable Frame Grabbers</li> </ul>"},{"location":"index.html#installation","title":"Installation","text":"<ul> <li>Installing VisualApplets</li> </ul>"},{"location":"index.html#release-notes-and-known-issues","title":"Release Notes and Known Issues","text":"<ul> <li>VisualApplets 3.6.1 Release Notes</li> <li>VisualApplets 3.6.0 Release Notes</li> <li>VisualApplets 3.5.1 Release Notes</li> <li>VisualApplets 3.5.0 Release Notes</li> <li>VisualApplets 3.4.1 Release Notes</li> <li>VisualApplets 3.4.0 Release Notes</li> <li>VisualApplets 3.3.2 Release Notes</li> <li>VisualApplets 3.3.1 Release Notes</li> <li>VisualApplets 3.3.0 Release Notes</li> <li>VisualApplets 3.2.1 Release Notes</li> <li>VisualApplets 3.2.0 Release Notes</li> <li>VisualApplets 3.1.2 Release Notes</li> <li>VisualApplets 3.1.1 Release Notes</li> <li>VisualApplets 3.1 Release Notes</li> <li>VisualApplets 3.0.6 Release Notes</li> <li>VisualApplets 3.0.4 Release Notes</li> <li>VisualApplets 3.0.3 Release Notes</li> <li>VisualApplets 3.0 Release Notes</li> </ul>"},{"location":"index.html#embedded-visualapplets-eva","title":"Embedded VisualApplets (eVA)","text":"<ul> <li>Overview of Embedded VisualApplets</li> <li>User Manual Embedded VisualApplets/eVA Designer</li> <li>Application Notes:<ul> <li>Designing for Non-Stoppable Image Sources</li> <li>GenICam API</li> <li>Deviating Parameter Interface During Runtime</li> </ul> </li> </ul>"},{"location":"index.html#licenses","title":"Licenses","text":"<ul> <li>VisualApplets Licensing</li> <li>VisualApplets End-User License Agreement</li> <li>Third-Party Licenses</li> </ul>"},{"location":"application-note-blob-analysis.html","title":"Application Note: Blob Analysis","text":"<p>This application note explains VisualApplets Blob Analysis designs.</p> <p>You learn how to use the Blob Analysis operators in combination with other operators in VisualApplets. The examples use the Blob Analysis operators for basic object detection and classification inside the FPGA. A line applet shows the use of the Blob Analysis 1D operator. Furthermore, C++ SDK projects for the given examples are available. They allow an understanding of the interpretation of Blob Analysis results on PC side. (Application Note SAN011)</p> <p>The following design examples illustrate the use of the VisualApplets blob analysis operators:</p> <ul> <li>Simple Blob Analysis Application Including SDK Project for Object Visualization: This example uses the Blob Analysis for basic object detection. All detected objects are transferred to the host PC.</li> <li>Using the Blob Analysis for Classification and ROI Selection: This example shows the use of the Blob Analysis for object detection and classification inside the FPGA.</li> <li>Blob Analysis 1D: This example explains the use of the Blob Analysis 1D operator for endless line scan images.</li> </ul>"},{"location":"application-note-blob-analysis.html#simple-blob-analysis-application-including-sdk-project-for-object-visualization","title":"Simple Blob Analysis Application Including SDK Project for Object Visualization","text":"<p>The first example is a basic Blob Analysis applet. A camera image is binarized. Next, the binary image is send to DMA in path and on the other path a Blob Analysis is performed and the results are output via a second DMA channel.</p> Figure 1: Visual Applets Design for simple Blob Analysis Application <p>The binarization used in this example is based on simple thresholding. The Blob Analysis assumes every white pixel to be an object pixel. Figure 2 shows that a foreground value range is selected using two threshold values. This allows the use of images where the objects are formed by dark pixels or images where objects are brighter in contrast to their background. After the binarization itself the image is buffered. From the buffer, the images are passed to the Blob Analysis and are transferred to the host PC to monitor the binarized images.</p> Figure 2: Binarization <p>The configuration of the Blob Analysis parameters can be seen in the following figure:</p> Figure 3: Blob Analysis Parameters for Simple Blob2D Applet Figure 4: The Merging of the Blob Streams into one Link for Blob2D Applet <p>In the image above you see how the Blob Analysis data is merged into one link only. In this example, the features <code>Bounding Box</code> and <code>Area</code> are used. First, the bounding box links of 16Bits each are merged together which results in a link width of 64 Bits. The area is extended to 64Bits as well. Using the <code>InsertPixel</code> operator, both links are merged together. The resulting DMA transmission will therefore be of the following format:</p>"},{"location":"application-note-blob-analysis.html#blob-dma-byte-order-for-simple-blob2d-applet","title":"Blob DMA Byte Order for Simple Blob2D Applet","text":"Byte No. Object Feature 0 to 1 Bounding Box X0 2 to 3 Bounding Box X1 4 to 5 Bounding Box Y0 6 to 7 Bounding Box Y1 8 to 15 Area <p>Note the varying byte order in the PC. The object features bit widths are extended. In real, the Bounding Box uses 10Bits only to represent the values between 0 and 1023 and the Area uses 21Bits only. A small SDK C++ project is attached to this applet to show its functionality. It can be found together with the design file in folder <code>Examples\\Processing\\BlobAnalysis\\Blob2D</code> of the VisualApplets installation path.</p>"},{"location":"application-note-blob-analysis.html#using-the-blob-analysis-for-classification-and-roi-selection","title":"Using the Blob Analysis for Classification and ROI Selection","text":"<p>This example shows an approach to cut out a region of interest based on extracted object features. The aim is to find the object with the maximum area and to extract the center of gravity of this object used to form the ROI.</p> <p>The example shows the capability of Visual Applets to use the Blob Analysis results for classification inside the applet which allows a significant enhancement of image processing possibilities inside the frame grabber. Figure 1 shows a screenshot of the design. The main parts are the binarization, the Blob Analysis, the classification and the cut-out of the ROI. These parts will be explained in detail in the following.</p> Figure 1: Blob Analysis Design for ROI Selection <p>The binarization used in this example is based on simple thresholding. The Blob Analysis assumes every white pixel to be an object pixel. Figure 2 shows that a foreground value range is selected using two threshold values. This allows the use of images where the objects are formed by dark pixels or images where objects are brighter in contrast to their background. After the binarization itself the image is buffered. From the buffer, the images are passed to the Blob Analysis and are transferred to the host PC to monitor the binarized images.</p> Figure 2: Binarization <p>The Blob Analysis is performed post to the binarization. Here, only the object features center of gravity in x and y-direction as well as the area are used for further processing. All other features are not used in this example.</p> <p>The applet continues with the classification of the Blob Analysis results (Figure 3). First, the center of gravity values are normalized by dividing them with the area. This is simply done by using the DIV operator. Meanwhile the detection of the object with the largest area is performed. Here, the operator <code>FrameMax</code> and Registers are used. The idea of the classification algorithm is to suppress every object whose area is less than the objects which have been investigated so far. In detail, the Blob Analysis outputs a stream of objects. The <code>FrameMax</code> operator detects if a current object is larger than the objects which have been investigated so far and outputs logic one at its output <code>IsMax</code>.This value is used at the <code>Capture</code> input of the registers. If the current object is larger than the previous objects the center of gravity coordinates are latched to the output. Hence, the last output of the frame i.e. the blob stream represents the center of gravity coordinates of the object which has the maximum area. Figure 3 illustrates this behavior.</p> Figure 3: Finding the Object with Maximum Area Table: Example of Algorithm to find Object with Maximum Area <p>The classification module now outputs the center of gravity coordinates of the largest object found in the image. Next, the coordinates have to be transformed to the ROI coordinates <code>XOffset</code>, <code>XLength</code>, <code>YOffset</code> and <code>YLength</code>. Figure 4 shows the design of this transformation. The <code>XLength</code> and <code>YLength</code> is set to a constant whereas the center of gravity coordinates are reduced by half of the ROI size.</p> Figure 4: Generation of ROI Coordinates <p>The four ROI values are now used to cut-out the ROI from the original image using the DynamicROI operator. As explained previously the classification module outputs the object with the maximum area with the last value of the frame. This is favorable as the <code>DynamicROI</code> operator only considers the last ROI coordinates received. Hence, the correct coordinates are used and the largest object is cut-out from the original image. The design file of this VisualApplets project can be found in folder <code>Examples\\Processing\\BlobAnalysis\\Blob2D_ROI_select</code> in the VisualApplets installation path. The applet can be run in microDisplay and the results can directly be seen. Moreover, a small SDK project is added to the example. To use the SDK project it is required to change the DMA size of the ROI to the DMA size set by modules <code>ROIsizeX</code> and <code>ROIsizeY</code>. Use the display settings in microDisplay or the <code>widht1</code> and <code>height1</code> parameters in the SDK project to perform the adaptation.</p>"},{"location":"application-note-blob-analysis.html#blob-analysis-1d","title":"Blob Analysis 1D","text":"<p>The Blob Analysis 1D example illustrates the use of the 1D blob operator in a VisualApplets environment.</p> <p>The 1D Blob Analysis example is a simple applet based on a base line camera. The camera is used with a line trigger only. Hence, the applet is based on real 1D images. For DMA transmission, the original image is transformed into small pieces of successive lines forming a 2D image. All parts of the applet will be explained in detail in the following. Figure 1 shows the main sheet of the design.</p> Figure 1: Blob Analysis 1D Design <p>For acquisition, a line camera operator connected to an <code>ImageBuffer</code> is used. This buffer allows the buffering of 1D image lines. Next, in the Hierarchical Box <code>Binarize</code> a simple thresholding is performed to convert the pixels into foreground and background pixels. A selector allows switching the original image and the binary image to the image output path. This is simply done by an IF operator and a <code>CONST</code> operator. The <code>dynamic</code> parameter of the <code>CONST</code> operator allows the modification of the <code>IF</code> operator's condition input to switch its inputs. Hence, during runtime it is possible to switch between the original grayscale image and the binarized image.</p> Figure 2: Switching Between Grayscale and Binary Image <p>As the applet's application purpose will be the visualization of the objects found in the original image it is required to allow a synchronization of both DMA channels in the PC. A line marker is used to mark every line of the original image and every blob. Hence a counter is used to count every line. The line counter is contained in the Hierarchical Box <code>1DBlobAnalysis</code> together with the blob analysis operator and the line count value leaves the box through the upper link O000. The counter has a range of 10 bits. Hence, an overflow occurs at value 1024 and the counter starts from zero again.</p> <p>In <code>ReplaceFirstPixelByLineNo</code> the first four pixels of a line are replaced by the line count. For that purpose the parallelism is changed so operation is done at a granularity of 32 bit. The x-coordinate is count and every time the x-coordinate is zero, the line number (expanded to 32 bit) is forwarded instead of the original pixel values.</p> Figure 3: Replacing of Leading Pixels by Line Number <p>Beside the line marker it is required generating a flush condition for the Blob Analysis operation. The flush may be implemented as a trigger input or in this case, a flush condition is produced once every line. Hence, the Blob Analysis will finalize (Eof) its output once a line. However, the Blob Analysis is configured to this behavior only if the output frame is not empty by using parameter <code>supres_empty_output_frames</code>. Furthermore, the Blob Analysis is configured to a maximum object height of 10 bits i.e., 1024 pixels. The maximum output frame size of the operator is set to 20. If more objects have to be output and no flush condition occurs, the operator will generate a new frame. These small output frames allow a minimization of the time the object has been detected and the time it can be analyzed in the PC.</p> Figure 4: Line Counting And Blob Analysis Figure 5: The Blob 1D Example Configuration Parameters <p>The 11 Blob Analysis output streams are merged into one stream which is connected to the DMA. This is simply done using <code>MergePixel</code> and <code>InsertPixel</code> operators. The order of the object features is shown in the table below.</p> Figure 6: The Merging of the Blob Streams into One Link for Blob1D Applet Byte No. Object Feature 0 to 3 Line Marker 4 to 5 Bounding Box X0 6 to 7 Bounding Box X1 8 to 11 Center of Gravity Y 12 to 15 Center of Gravity Y 16 to 17 Bounding Box Y0 18 to 19 Bounding Box Y1 20 to 23 Area 24 to 25 Contour Length Diagonal 26 to 27 Contour Length Orthogonal 28 to 31 Error Flags <p>The run of this project in hardware requires a special hardware setup with line camera and trigger encoder system. The design file can be found in folder <code>Examples\\Processing\\BlobAnalysis\\Blob1D</code> in the Visual Applets installation path. A complex SDK project is added to the design which mostly demonstrates the displaying of objects.</p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html","title":"Application Note: Designing Signal Processing Applets for Programmable Frame Grabbers","text":"<p>The design of all programmable frame grabbers allows you to program your own individual image processing solutions (applets) using the graphical FPGA programming environment VisualApplets.</p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#gpigpo-operators-in-visualapplets","title":"GPI/GPO Operators in VisualApplets","text":"<p>Using VisualApplets, you can design your own, application-specific trigger system. You can, e.g., determine which signal is sent or received by which individual physical input/output pin.</p> <p>In VisualApplets, you have two operators available to wire up an individual pin with your applet design:</p> <p>Operator GPI (for trigger IN signals)</p> <p>Operator GPO (for trigger OUT signals)</p> <p></p> <p>The figure above shows an example on how to implement signal processing. The signal processing functionality you want to implement depends on your specific requirements. To find the right operator for your application, visit the Signal Library. Also choose the Front GPIO according to your requirements.</p> <p>The example above shows a downscaling functionality for two input signals. Two signals are input from GPI1 and Front GPI0 to the programmable frame grabber. The signals are first debounced, the rising or falling edges are selected, and the signals are then downscaled by a factor 8 or 3. A signal length for both signals is set and the signals are then forwarded to FrontGPO0, GPO1, GPO2 and the camera to control image acquisition.</p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#using-gpigpo-operators","title":"Using GPI/GPO Operators","text":"<p>Each trigger IN / trigger OUT pin you want to use on the Front GPIO or the trigger extension board you have to interconnect with an instance of a GPI/GPO operator.</p> <p>Info</p> <p>Since operator GPI and operator GPO have the same functionality, in the following both operators are described together.</p> <ol> <li>Double-click on the operator icon in your design to open the Module Properties window.</li> </ol> <p></p> <p>The Module Properties window opens:</p> <p></p> <p>As you see, the operator has two parameters:</p> <ul> <li><code>Pin_ID</code>: Parameter Pin_ID allows you to define which individual pin on the selected connector you want to address.</li> <li><code>ConnectorType</code>: Parameter ConnectorType allows you to define which connector (Front GPIO or trigger extension board via GPIO) you want to address.</li> </ul> <p>Info</p> <p>For CXP-12 frame grabbers, the <code>ConnectorType</code> parameter is included in the <code>Pin_ID</code> parameter.</p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#parameter-connector-type","title":"Parameter Connector Type","text":"<p>This parameter allows you to define which group of trigger pins you want to address, the ones provided in the 15-pin D-Sub socket (<code>Front GPIO</code>), or the ones provided on the trigger extension board (<code>GPIO</code>). The parameter has the value range {Front GPIO, GPIO}.</p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#value-front-gpio","title":"Value <code>Front GPIO</code>","text":"<p>If you select value <code>Front GPIO</code>, you address the following connector (group of trigger pins) on the slot bracket of your programmable frame grabber:</p> <p></p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#value-gpio","title":"Value <code>GPIO</code>","text":"<p>If you select value <code>GPIO</code>, you address the following group of trigger pins on your programmable frame grabber:</p> <p></p> <p>The GPIO is used for connection to a trigger extension board:</p> <p></p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#parameter-pin_id","title":"Parameter <code>Pin_ID</code>","text":"<p>This parameter allows you to define which individual pin on the chosen connector (group of trigger pins) you address. The value range of parameter <code>Pin_ID</code> is {0;7} or {0;3} for connector type <code>GPIO</code> or <code>Front GPIO</code>.</p> <p>Info</p> <p>The value range of parameter <code>Pin_ID</code> for marathon frame grabbers and operator GPO is {0;1}.</p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#pin-configuration-on-the-front-gpio-with-visualapplet-operator-reference","title":"Pin Configuration on the Front GPIO with VisualApplet Operator Reference","text":"<p>In differential mode, pin 9 can be used to receive ONE single-ended signal on a GPI operator with Pin_ID=3, see Mode \"Differential\" (Default).</p> <p>Caution</p> <p>The frame grabber trigger system needs to get supply voltage on the Voltage IN pins. If you want to connect devices that have no PWR pin, you need to provide the power supply to the Voltage IN pin from an external source.</p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#trigger-input-on-the-front-gpio","title":"Trigger INPUT on the Front GPIO","text":"<p>If you</p> <ul> <li>are using the <code>GPI</code> operator (for defining trigger input signals),</li> <li>have set parameter <code>Connector Type</code> to <code>Front GPIO</code>,</li> </ul> <p>the values of parameter <code>Pin_ID</code> address the following pins:</p> <p></p> <p>The input (GPI) pins of the Front GPIO are configurable. You can use the six input pins to receive either:</p> <ol> <li>3 differential signals, or</li> <li>2 differential signals and 1 single-ended signal , or</li> <li>4 single-ended signals.</li> </ol> <p>To configure the input pins on Front GPIO for a specific signal type (differential or single-ended), you have two modes available:</p> <ul> <li>Mode <code>Differential</code> (providing options a and b)</li> <li>Mode <code>Single-ended</code> (providing option c)</li> </ul> <p>Default mode for the Front GPIO is mode <code>Differential</code>. How to switch modes, see topic Input Configuration in the frame grabbers` manual.</p> <p>Caution</p> <p>In default configuration, the GPIO pins of the Front GPIO offer:</p> <ul> <li>3 differential input signals or 2 differential and 1 single-ended input signal in pull-up mode</li> <li>Two TTL output signals</li> </ul> <p>If you need another configuration of the input signals, i.e.:</p> <ul> <li>Pull-down mode,</li> <li>4 single-ended signals (and no differential signals),</li> </ul> <p>you can easily configure the GPIs according to your needs. For configuration, you use a command line tool which has been installed on your system together with the Framegrabber SDK.</p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#mode-differential-default","title":"Mode <code>Differential</code> (Default)","text":"<p>In mode <code>Differential</code> (default), all the six input pins of the Front GPIO are configured to receive differential signals:</p> <ul> <li>Pins 8/9 -&gt; 1 differential signal</li> <li>Pins 11/12 -&gt; 1 differential signal</li> <li>Pins 13/14 -&gt; 1 differential signal</li> </ul> <p>Alternatively, you can use pin pair 8/9 (in mode <code>Differential</code>) for receiving one single-ended signal:</p> <ul> <li>Pin 9 -&gt; 1 single-ended signal</li> <li>Pins 11/12 -&gt; 1 differential signal</li> <li>Pins 13/14 -&gt; 1 differential signal</li> </ul> <p>Individual Pins in Mode <code>Differential</code>:</p> <p></p> <p>Pins 11 and 12:</p> <ul> <li>The incoming signals on pins 11 and 12 are interpreted as one differential signal (pin 11 with the +, pin 12 with the - value).</li> <li>To receive this differential signal within VisualApplets, use a GPI operator instance with Pin_ID = 0.</li> </ul> <p>Pins 13 and 14:</p> <ul> <li>The incoming signals on pins 13 and 14 are interpreted as one differential signal (pin 13 with the +, pin 14 with the - value) .</li> <li>To receive this differential signal within VisualApplets, use a GPI operator instance with Pin_ID = 1.</li> </ul> <p>Pins 8 and 9:</p> <ul> <li>The incoming signals on pins 8 and 9 are interpreted as one differential signal (pin 8 with the +, pin 9 with the - value) .</li> <li>To receive this differential signal within VisualApplets, use a GPI operator instance with Pin_ID = 2.</li> </ul> <p>Alternatively, you can use pin pair 8/9 for receiving one single-ended signal (although in mode <code>Differential</code>): In this case,</p> <ul> <li>you connect the single-ended incoming signal to the physical pin 9.</li> <li>To receive this single-ended signal within VisualApplets, use a GPI operator instance with Pin_ID = 3.</li> </ul>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#mode-single-ended","title":"Mode <code>Single-Ended</code>","text":"<p>In mode <code>Single-ended</code> (configurable), the six input pins of the Front GPIO are configured to receive 4 single-ended signals:</p> <ul> <li>Pin 8 -&gt; 1 single-ended signal</li> <li>Pin 9 -&gt; 1 single-ended signal</li> <li>Pin 11 -&gt; 1 single-ended signal</li> <li>Pin 13 -&gt; 1 single-ended signal</li> </ul> <p>Individual Pins in Mode <code>Single-ended</code>:</p> <p></p> <p>Signals on Pin 11 and 12:</p> <ul> <li>The incoming signal on pin 11 is interpreted as a single-ended signal.</li> <li>To receive this single-ended signal within VisualApplets, use a GPI operator instance with Pin_ID = 0.</li> <li>Pin 12 is not used in mode <code>Single-ended</code>.</li> </ul> <p>Signals on Pin 13 and 14:</p> <ul> <li>The incoming signal on pin 13 is interpreted as a single-ended signal.</li> <li>To receive this single-ended signal within VisualApplets, use a GPI operator instance with Pin_ID = 1.</li> <li>Pin 14 is not used in mode <code>Single-ended</code>.</li> </ul> <p>Pins 8 and 9:</p> <ul> <li>The incoming signals on pins 8 and 9 are interpreted as two single-ended signals.</li> <li> <p>To receive these single-ended signals within VisualApplets, use</p> <ul> <li>a GPI operator instance with Pin_ID = 2 for pin 8, and</li> <li>a GPI operator instance with Pin_ID = 3 for pin 9.</li> </ul> </li> </ul>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#trigger-output-ttl-on-the-front-gpio","title":"Trigger OUTPUT <code>TTL</code> on the Front GPIO","text":"<p>If you</p> <ul> <li>use the GPO operator for defining trigger output signals,</li> <li>you have set parameter Connector Type to Front GPIO,</li> </ul> <p>the values of parameter Pin_ID address the following pins:</p> <p></p> <p>These two pins are sending TTL signals (5 V).</p> <p>Outgoing TTL signals on Front GPIO (5 V):</p> <p></p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#trigger-signals-addressing-the-trigger-extension-boards-via-gpio","title":"Trigger Signals Addressing the Trigger Extension Boards (via GPIO)","text":"<p>The GPIO connector is the physical trigger interface of programmable frame grabbers that is designed for connection to a trigger extension board:</p> <p></p> <p>The GPIO connector, i.e., each trigger extension board, offers</p> <ul> <li>8 digital inputs (IN 0 - 7) (8 single-ended signals or 4 differential signals)</li> <li>8 digital outputs (OUT 0 - 7)</li> </ul> <p>The eight inputs have the indices 0 to 7. The eight outputs also have indices from 0 to 7.</p> <p>For more information about the pin layout, see Pin Layout on SUB-D15 - TTL Trigger Board or PIN Layout Opto-Coupled Trigger 5 - Opto-Coupled Trigger 5 Board extension boards.</p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#pin_id-assignment-on-ttl-trigger-extension-boards","title":"<code>Pin_ID</code> Assignment on TTL Trigger Extension Boards","text":""},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#port-a","title":"Port A","text":"Pin Number <code>Pin_ID</code> in Visual Applets 1 0 2 1 3 2 4 3 5 6 7 8 9 10 11 0 12 1 13 2 14 3 15 0"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#port-b","title":"Port B","text":"Pin Number <code>Pin_ID</code> in Visual Applets(single-ended-signals) 1 4 2 5 3 6 4 7 5 6 7 8 9 10 11 4 12 5 13 6 14 7 15"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#pin_id-assignment-on-opto-trigger-5-extension-boards","title":"<code>Pin_ID</code> Assignment on OPTO Trigger 5 Extension Boards","text":""},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#port-a_1","title":"Port A","text":"Pin Number <code>Pin_ID</code> in Visual Applets(single-ended-signals) <code>Pin_ID</code> in Visual Applets(differential signals) 1 0 2 1 3 2 4 3 5 6 7 8 9 10 11 0 0 12 1 0 13 2 2 14 3 2 15"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#port-b_1","title":"Port B","text":"Pin Number <code>Pin_ID</code> in Visual Applets(single-ended-signals) <code>Pin_ID</code> in Visual Applets(differential signals) 1 4 2 5 3 6 4 7 5 6 7 8 9 10 11 4 4 12 5 4 13 6 6 14 7 6 15"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#configuring-the-trigger-system","title":"Configuring the Trigger System","text":"<p>You can access the trigger configuration via two ways:</p> <ul> <li>microDisplay X: Here, you can enter trigger parameter values via GUI to check the outcome of specific configurations.</li> <li>SDK: For implementing the frame grabber programming interface into a specific image processing software application.</li> </ul> <p>The demands on the trigger system vary, depending on your application:</p> <ul> <li>For Area Scan, only one trigger type (frame trigger) is required.</li> <li>For Line Scan, two trigger types are required: Line trigger (sends a trigger pulse for each line) and frame trigger. In a line scan application, the frame trigger controls how many lines are appended to an image.</li> </ul> <p>You may find further information on how to trigger area and line scan cameras here.</p> <p>Info</p> <p>For further information about the frame grabber trigger system, refer to topic GPIO Connectors.</p> <p>Info</p> <p>For information which parameters are available (and which effects specific settings may cause), refer to the documentation of the applet you are using.</p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#running-your-applet-on-hardware","title":"Running Your Applet on Hardware","text":"<p>Prerequisites:</p> <ul> <li>Your programmable frame grabber is installed on your system as described in topic Connecting Frame Grabbers.</li> <li>The Basler Framegrabber SDK is installed on your system as described at Installing the Framegrabber SDK.</li> </ul> <p>Before you can run your applet on your programmable frame grabber, you have to copy your <code>*.hap</code> file (applet) into the Basler Framegrabber SDK installation on your host PC and flash it onto your programmable frame grabber.</p> <p>Info</p> <p>Flashing is only required for marathon frame grabbers.</p> <p>You find detailed information on how to translate a VisualApplets design to a hardware applet under Hardware Applet: From Idea to Application.</p> <ol> <li> <p>Copy the <code>*.hap</code> file that you have built in VisualApplets into the directory <code>[Framegrabber SDK installation directory]/Hardware Applets/[frame grabber model]</code>. If there is no subdirectory with the programmable frame grabber model name, create it. If you have used the default settings in VisualApplets, you will find your <code>*.hap</code> file in your VisualApplets installation directory, subdirectory <code>Designs</code>.</p> </li> <li> <p>Install your applet on your programmable frame grabber as described in Flashing.</p> </li> </ol> <p>After you have done this, you can:</p> <ul> <li>Test your applet and directly see image processing results of your applet with the Basler tool microDisplay X, which comes as part of the Framegrabber SDK. See the topic Configuring the Applet (microDisplay X).</li> </ul> <p>Example: When you load the hardware applet of the signal processing example design into microDisplay X, you can set the dynamic parameters like the downscaling factor and the signal width in the parameter tree as shown in the figure below.</p> <p></p>"},{"location":"application-note-designing-signal-processing-applets-for-programmable-frame-grabbers.html#starting-the-applet-in-your-own-software","title":"Starting the Applet in Your Own Software","text":"<p>To start using the applet in your own software:</p> <ol> <li>On the Basler application programming interface, use the call <code>Fg_Init</code> to start the applet. Specify the path to the location of the <code>*.hap</code> file you created with VisualApplets.</li> </ol> <p>For a detailed description and reference of all available function calls, see the Framegrabber API Manual and the Framegrabber API Function Reference.</p> <p>As base of a C++ SDK you can use the VisualApplets internal SDK code generator, which you find in the icon menu or under Build and Generate SDK example in VisualApplets. This function automatically generates the corresponding CMake File and the VisualStudio project files (see also Hardware Applet: From Idea to Application).</p> <p>The automatic SDK code contains the following functional blocks, which are necessary for image acquisition and parameter configuration:</p> <ul> <li>Frame grabber initialization</li> <li>Allocation of memory for buffer(s)</li> <li>Definition of <code>Get</code> and <code>Set</code> parameters</li> <li>Creation of the display(s)</li> <li>Start of acquisition at applet and camera for each present port</li> <li>Grabbing images</li> <li>Stop of acquisition</li> <li>Closing the display</li> <li>Release of memory for buffer(s)</li> <li>Frame grabber uninitialization</li> </ul> <p>In the following you can see the example C++ Framegrabber API code for the signal processing example.</p> <ul> <li>Frame Grabber initialization and allocation of memory for buffer(s):</li> </ul> <pre><code>int main ()\n{\n\n    // ---------------------------------------------------------------------------\n    // Frame Grabber: Initialization\n    // ---------------------------------------------------------------------------\n\n\n    int nrOfCycles = 5000; // Acquire 5000 frames, TODO: insert the number according to your needs\n    unsigned int boardIndex = 0; // TODO: Use the correct board index at multi frame grabber systems\n    int rc = 0; // return code\n\n    Fg_Struct* fg = Fg_Init(\"SignalProcessingDesign.hap\", boardIndex);\n    if(fg == NULL){\n        fprintf(stderr, \"Error in Fg_Init(): %s\\n\", Fg_getLastErrorDescription(NULL));\n        fprintf(stderr, \"Press &lt;Return&gt; to continue...\\n\");\n        getchar();\n        return -1;\n    }\n\n    int nrOfParameter = Fg_getNrOfParameter(fg);\n    fprintf(stderr, \"No. of Parameter: %d\\n\", nrOfParameter);\n\n    int i;\n    for (i = 0; i &lt; nrOfParameter; i++) {\n        const char *name = Fg_getParameterName(fg,i);\n        fprintf(stderr,\" Param %d: %s,%x\\n\",i,name,Fg_getParameterId(fg,i));\n    }\n\n\n    / ---------------------------------------------------------------------------\n    // Frame Grabber: Allocate memory for buffer(s)\n    // ---------------------------------------------------------------------------\n\n\n    // Feature Cnt 0,0\n    int width0 = 1024;\n    int height0 = 1024;\n    int byteWidth0 = 1;\n    size_t bufSize0 = width0 * height0 * (size_t)byteWidth0;\n    const unsigned int mem0_bufs = 4;\n    dma_mem *pmem0 = Fg_AllocMemEx(fg, bufSize0 * mem0_bufs, mem0_bufs);\n    if(pmem0 == NULL){\n        fprintf(stderr, \"Error in Fg_AllocMemEx(): %s\\n\", Fg_getLastErrorDescription(fg));\n        Fg_FreeGrabber(fg);\n        fg = NULL;\n        fprintf(stderr, \"Press &lt;Return&gt; to continue...\\n\");\n        getchar();\n        return -1;\n    }\n</code></pre> <ul> <li>Extract of the <code>Get</code> and <code>Set</code> parameter section. Here you can see how to set the dynamic parameters. The following code shows how to set the downscale factor and how to select a specific pulse as parameter of operator <code>Device1_Process0_ByFactor8</code>:</li> </ul> <pre><code>// ---------------------------------------------------------------------------\n// Frame Grabber: Get* and Set* parameters for Process0\n// ---------------------------------------------------------------------------\n\n\n/*============ Downscale : ByFactor8 ============== */\n\n\nint Device1_Process0_ByFactor8_Downscale_Id = Fg_getParameterIdByName(fg, \"Device1_Process0_ByFactor8_Downscale\");\nif(Device1_Process0_ByFactor8_Downscale_Id &lt;= 0) {\n    fprintf(stderr, \"\\n\");\n    fprintf(stderr, \"Error in Fg_getParameterIdByName(Device1_Process0_ByFactor8_Downscale): %s (%d)\\n\", Fg_getLastErrorDescription(fg), Device1_Process0_ByFactor8_Downscale_Id);\n    fprintf(stderr, \"Press &lt;Return&gt; to continue...\\n\");\n    getchar();\n}\n\nunsigned int Device1_Process0_ByFactor8_Downscale;\nDevice1_Process0_ByFactor8_Downscale = 8;\nrc = Fg_setParameterWithType(fg, Device1_Process0_ByFactor8_Downscale_Id, Device1_Process0_ByFactor8_Downscale, 0);\nif(rc &lt; 0) {\n    fprintf(stderr, \"\\n\");\n    fprintf(stderr, \"Error in Fg_setParameterWithType(Device1_Process0_ByFactor8_Downscale_Id): %s (%d)\\n\", Fg_getLastErrorDescription(fg), rc);\n    fprintf(stderr, \"Press &lt;Return&gt; to continue...\\n\");\n    getchar();\n}\n\nint Device1_Process0_ByFactor8_SelectedPulse_Id = Fg_getParameterIdByName(fg, \"Device1_Process0_ByFactor8_SelectedPulse\");\nif(Device1_Process0_ByFactor8_SelectedPulse_Id &lt;= 0) {\n    fprintf(stderr, \"\\n\");\n    fprintf(stderr, \"Error in Fg_getParameterIdByName(Device1_Process0_ByFactor8_SelectedPulse): %s (%d)\\n\", Fg_getLastErrorDescription(fg), Device1_Process0_ByFactor8_SelectedPulse_Id);\n    fprintf(stderr, \"Press &lt;Return&gt; to continue...\\n\");\n    getchar();\n}\n\nunsigned int Device1_Process0_ByFactor8_SelectedPulse;\nDevice1_Process0_ByFactor8_SelectedPulse = 1;\nrc = Fg_setParameterWithType(fg, Device1_Process0_ByFactor8_SelectedPulse_Id, Device1_Process0_ByFactor8_SelectedPulse, 0);\nif(rc &lt; 0) {\n    fprintf(stderr, \"\\n\");\n    fprintf(stderr, \"Error in Fg_setParameterWithType(Device1_Process0_ByFactor8_SelectedPulse_Id): %s (%d)\\n\", Fg_getLastErrorDescription(fg), rc);\n    fprintf(stderr, \"Press &lt;Return&gt; to continue...\\n\");\n    getchar();\n}\n</code></pre> <p>Info</p> <p>You may delete all parameters that are not relevant for parameter setting during acquisition from the automatically generated C++ Framegrabber API code. Only keep the parameters you need to configure during acquisition.</p> <ul> <li>Create the display(s), start of acquisition, and grab images:</li> </ul> <pre><code>// ---------------------------------------------------------------------------\n// Frame Grabber: Create the display(s)\n// ---------------------------------------------------------------------------\n\nint id0 = CreateDisplay(8 * byteWidth0, width0, height0);\nif(id0 &lt; 0) {\n    fprintf(stderr, \"Error in CreateDisplay(): %s (%d)\\n\", Fg_getLastErrorDescription(fg), id0);\n    Fg_FreeMemEx(fg, pmem0);\n    pmem0 = NULL;\n    Fg_FreeGrabber(fg);\n    fg = NULL;\n    fprintf(stderr, \"Press &lt;Return&gt; to continue...\\n\");\n    getchar();\n    return id0;\n}\nSetBufferWidth(id0, width0, height0);\n\n\n// ---------------------------------------------------------------------------\n// Frame Grabber: Start acquisition at applet and camera for each present port\n// ---------------------------------------------------------------------------\n\nrc = Fg_AcquireEx(fg, 0, nrOfCycles, ACQ_STANDARD, pmem0);\nif(rc != 0) {\n    fprintf(stderr, \"Error in Fg_AcquireEx() for channel 0: %s\\n\", Fg_getErrorDescription(fg, rc));\n    CloseDisplay(id0);\n    Fg_FreeMemEx(fg, pmem0);\n    pmem0 = NULL;\n    Fg_FreeGrabber(fg);\n    fg = NULL;\n    fprintf(stderr, \"Press &lt;Return&gt; to continue...\\n\");\n    getchar();\n    return rc;\n}\n\n// ---------------------------------------------------------------------------\n// Frame Grabber: Grab images\n// ---------------------------------------------------------------------------\n\nframeindex_t frameNo0 = 0;\nfor(i = 1; i &lt;= nrOfCycles; ++i){\nframeNo0 = Fg_getLastPicNumberBlockingEx(fg, frameNo0 + 1, 0, 5, pmem0);\n    if(frameNo0 &lt; 0) {\n        fprintf(stderr, \"Error in Fg_getLastPicNumberBlockingEx(): %s (%d)\\n\", Fg_getLastErrorDescription(fg), frameNo0);\n        fprintf(stderr, \"Press &lt;Return&gt; to continue...\\n\");\n        getchar();\n        break;\n    } else {\n        fprintf(stderr, \"grabbed image %d\\n\", frameNo0 );\n    }\n\n    void *iPtr0 = Fg_getImagePtrEx(fg, frameNo0, 0, pmem0);\n    if(iPtr0 == NULL) {\n        fprintf(stderr, \"Error in Fg_getImagePtrEx(): %s\\n\", Fg_getLastErrorDescription(fg));\n        Fg_stopAcquireEx(fg, 0, pmem0, 0);\n        CloseDisplay(id0);\n        Fg_FreeMemEx(fg, pmem0);\n        pmem0 = NULL;\n        Fg_FreeGrabber(fg);\n        fg = NULL;\n        fprintf(stderr, \"Press &lt;Return&gt; to continue...\\n\");\n        getchar();\n        return -1;\n    }\n    DrawBuffer(id0, iPtr0, frameNo0, \"\");\n}\n</code></pre> <ul> <li>Stop acquisition, close the display, release of memory for buffer(s):</li> </ul> <pre><code>// ---------------------------------------------------------------------------\n// Frame Grabber: Stop acquisition\n// ---------------------------------------------------------------------------\n\nrc = Fg_stopAcquireEx(fg, 0, pmem0, 0);\nif(rc &lt; 0) {\n    fprintf(stderr, \"Error in Fg_stopAcquireEx(): %s (%d)\\n\", Fg_getLastErrorDescription(fg), rc);\n    fprintf(stderr, \"Press &lt;Return&gt; to continue...\\n\");\n    getchar();\n}\n\n\n// ---------------------------------------------------------------------------\n// Frame Grabber: Close the display\n// ---------------------------------------------------------------------------\n\nCloseDisplay(id0);\n\n\n// ---------------------------------------------------------------------------\n// Frame Grabber: Release the memory for buffer(s)\n// ---------------------------------------------------------------------------\n\nrc = Fg_FreeMemEx(fg, pmem0);\nif(rc &lt; 0) {\n    fprintf(stderr, \"Error in Fg_FreeMemEx(): %s (%d)\\n\", Fg_getLastErrorDescription(fg), rc);\n    fprintf(stderr, \"Press &lt;Return&gt; to continue...\\n\");\n    getchar();\n}\npmem0 = NULL;\n\n\n// ---------------------------------------------------------------------------\n// Frame Grabber: Uninitialization\n// ---------------------------------------------------------------------------\n\nrc = Fg_FreeGrabber(fg);\nif(rc &lt; 0) {\n    fprintf(stderr, \"Error in Fg_FreeGrabber(): %s\\n\", Fg_getLastErrorDescription(NULL));\n    fprintf(stderr, \"Press &lt;Return&gt; to continue...\\n\");\n    getchar();\n}\nfg = NULL;\n\n\nfprintf(stderr, \"Press &lt;Return&gt; to exit...\\n\");\ngetchar();\n\nreturn (0);\n}\n</code></pre> <p>You may integrate this example code into a larger SDK environment.</p>"},{"location":"application-note-jpeg-compression.html","title":"Application Note: JPEG Compression","text":"<p>This application note explains the use of the Basler JPEG compression operators (Application Note SAN013).</p> <p>You get information about the functionality of the operators. Using a Visual Applets design, a JPEG compression application is shown. An SDK project is presented which generates JPEG data files.</p> <p>For JPEG compression in VisualApplets two operators are required. These are the <code>ImageBuffer_JPEG_Gray</code> and the <code>JPEG_Encoder_Gray</code>. The image buffer is used to buffer the image data in frame grabber memory and is used for a specific reordering of the pixels. The JPEG encoder performs the JPEG compression itself.</p> <p>The reordering of the pixels is required because for JPEG compression blocks of eight by eight pixels are used. The following figure illustrates the reordering.</p> <p></p> <p>A reordered image will look like the following. The operator keeps the image dimensions of the original image.</p> <p></p> <p>After the reordering the JPEG compression can be performed using operator <code>JPEG_Encoder_Gray</code>. The operator's output is a Huffman stream without JPEG headers. The compression rate depends on the selected quantization table which is changeable during runtime. For Huffman coding the standard luminance table is used.</p> <p>Operator Documentation</p> <p>Refer to the Operator Reference for a detailed description of parameters, input links, and operator functionality.</p>"},{"location":"application-note-jpeg-compression.html#jpeg-compression-design-example","title":"JPEG Compression Design Example","text":"<p>The following design example will show a Visual Applets design which performs a JPEG compression. The design is required to perform the following specifications:</p> <ul> <li>Grab images from a camera-link base area camera.</li> <li>Buffer the image data and perform the JPEG compression.</li> <li>Add a JPEG header to the image in software and write selected images to file.</li> <li>The image height of the camera is not constant. The varying height of the image has to be added to the JPEG header.</li> </ul>"},{"location":"application-note-jpeg-compression.html#visualapplets-design","title":"VisualApplets Design","text":"<p>The following design is used to meet the specifications.</p> <p></p> <p>This simple design is sufficient to meet all specifications. The image is grabbed using a base area camera operator. Next, the image is split into two paths. The first path buffers the image and performs the pixel reordering using operator ImageBuffer_JPEG_Gray. The JPEG_Encoder_Gray is used afterwards for JPEG compression. The JPEG data stream is transferred into host PC memory via a DMA channel. In the second path, the original image data is buffered and transferred to the host PC using a second DMA channel.</p>"},{"location":"application-note-jpeg-compression.html#simulation-of-the-visual-applets-design","title":"Simulation of the Visual Applets Design","text":"<p>The design can be fully simulated. By placing simulation sources and probes on the data links the respective steps of the JPEG compression can be monitored. The figure below shows the design with simulation modules. As can be seen, the pixels of the original image (simModule0) are reordered (simModule1) and the JPEG data stream is generated (simModule2).</p> <p></p> <p>When looking at the JPEG data the length of the stream can be determined (see figure below). If the quality in the JPEG encoder is changed, the data length varies respectively.</p> <p></p>"},{"location":"application-note-jpeg-compression.html#runtime-test-in-microdisplay","title":"Runtime Test in microDisplay","text":"<p>Any applet including a JPEG Encoder can directly be used in microDisplay. For the given example the applet results in one image window for each DMA channel. DMA number one shows the original image grabbed, while the first DMA channel shows the encoded image data along with the DMA length.</p> <p></p>"},{"location":"application-note-jpeg-compression.html#sdk-project-for-jpeg-file-generation","title":"SDK Project for JPEG File Generation","text":"<p>A design file of the example together with a SDK example project can be found in folder <code>examples\\processing\\advanced\\JPEG\\JPEG_gray</code> in the VisualApplets installation path.</p> <p>The SDK project basically grabs the original image and the JPEG data. The original image is directly output to display. A JPEG header is generated and added to the JPEG data. This completes the JPEG file. The user has the possibility to write a JPEG snapshot to file. Furthermore, the encoded JPEG data is decoded using the simple C-code decoder <code>nanojpeg</code>. The decoded image is displayed.</p> <p>The user has the possibilities to resize the image, change the JPEG quality, write jpeg snapshot files or write JPEG data hex file dumps.</p> <p>Note that the header generation is only an example. Users of the Visual Applets JPEG operators should write their own header generators adapted for their applications.</p> <p>JPEG decoder information:</p> <pre><code>NanoJPEG -- KeyJ's Tiny Baseline JPEG Decoder\n\nVersion 1.0 (2009-04-29)\n\nby Martin J. Fiedler &lt;martin.fiedler@gmx.net&gt;\n</code></pre>"},{"location":"application-note-shared-memory.html","title":"Application Note: Shared Memory","text":""},{"location":"application-note-shared-memory.html#using-the-shared-memory-on-imaflex-and-marathon-frame-grabbers","title":"Using the Shared Memory on imaFlex and marathon Frame Grabbers","text":"<p>The imaFlex, microEnable 5 marathon, and LightBridge frame grabbers have shared DRAM memories, the microEnable 5 Ironman frame grabber series don't have shared DRAM memories. This means that on microEnable 5 Ironman, you can use at maximum two or four VisualApplets operators which use a DRAM memory see DRAM operators documentation.</p> <p>Each of the operators which use memory are allocated to one physical memory only on the frame grabber. On the imaFlex, microEnable 5 marathon, and on LightBridge frame grabbers, the concept is different. On these frame grabbers, you can use a much faster DDR4 (on imaFlex) or DDR3 (on marathon and LightBridge) memory. However, this is only one single physical memory so all VisualApplets operators which use the memory share the bandwidth.</p> <p>The memory configuration of a frame grabber can best be determined from the VisualApplets Device Resources Documentation. In this documentation you find information, which is relevant for the usage of a DRAM element within a VisualApplets design: RAM size, RAM data width and bandwidth per RAM (for all platforms except the marathon series) and RAM bandwidth total (shared) for the marathon series.</p> <p>Info</p> <p>The bandwidth values given in the VisualApplets Device Resources Documentation are theoretical, maximum values. In practical use, the efficiency may be reduced.</p> <p>This document guides you to efficiently use the memory for a specific platform by using the information of RAM size and RAM data width. It also helps you to calculate the resulting bandwidth per RAM for the marathon series.</p>"},{"location":"application-note-shared-memory.html#efficient-usage-of-the-dram","title":"Efficient Usage of the DRAM","text":"<p>In the VisualApplets Device Resources Documentation, you find information about the RAM size of a specific platform:</p> <ul> <li>For the imaFlex CXP-12 Quad: 3 x 512 MiB DDR4</li> <li>For the imaFlex CXP-12 Penta: 5 x 512 MiB DDR4</li> <li>For the marathon series and Lightbridge: 4 x 512 MiB DDR3</li> </ul> <p>These values give information about the total RAM size (e.g. for the marathon series: 4 x 512 MiB = 2 GiB (2^31 Byte)) and which partition one VisualApplets operator can use at maximum (for the marathon series: 512 MiB).</p> <p>You can only use this maximum RAM size per operator efficiently, if you use the information of the full RAM data width (see also the VisualApplets Device Resources Documentation):</p> <ul> <li>For the imaFlex CXP-12 Quad, the RAM data width is 384 bit</li> <li>For the imaFlex CXP-12 Penta, the RAM data width is 640 bit</li> <li>For the marathon VCX-QP and VF2, the RAM data width is 512 bit</li> <li>For the marathon VCL, VCLx, and Lightbridge, the RAM data width is 256 bit</li> </ul> <p>The RAM data width is the bit width multiplied with the parallelism and the kernel elements of a link connected with a DRAM operator in a VisualApplets design.</p>"},{"location":"application-note-shared-memory.html#example-usage-of-dram","title":"Example Usage of DRAM","text":"<p>The example uses a simple VisualApplets design for the marathon VCL platform as shown in the following figure.</p> Figure 1: Parallelism 4 RAM Usage <p>The example uses a parallelism of 4 and a bit width of 8 bit. Thus, the example only uses a RAM data width of 4 x 8 = 32 bit. However, to be fully efficient, the bandwidth needs to be 256 bit. Therefore, you must increase the parallelism to 32 as shown in the next figure.</p> Figure 2: Parallelism 32 RAM Usage <p>Now, this design ensures that you can use the DRAM efficiently. In general, it's always best to fully use the available RAM data width. However, sometimes, this is't possible, because you'll need more resources, you' re data format isn't divisible by 256 or the operator's parameter will not allow the full range anymore. Therefore, you need to know if you can use a lower parallelism as well. For this you'll need to understand the memory bandwidth which is explained in the following section.</p>"},{"location":"application-note-shared-memory.html#memory-bandwidth","title":"Memory Bandwidth","text":"<p>You can find platform-specific information about the maximum memory bandwidth for one DRAM element in the VisualApplets Device Resources Documentation. As you need to consider reading and writing from RAM, the maximum bandwidth is divided by 2 for the calculation of the resulting bandwidth :</p> <p></p> <p>You only achieve this value of the resulting bandwidth if you use the full RAM data width (see section Efficient Usage of the DRAM). Therefore, you need to take the ratio RAM data width used/ full RAM data width into account for the calculation of the resulting bandwidth:</p> <p></p> <p>According to this formula, you can calculate the necessary RAM data width:</p> <p><code>bit width * parallelism * kernel elements of a link connected to a RAM element</code> used in the design to achieve a specific resulting bandwidth. This means you can also calculate the minimum required parallelism of the link connected to a RAM element, if you have bit width and kernel elements defined.</p>"},{"location":"application-note-shared-memory.html#example-memory-bandwidth-calculation","title":"Example Memory Bandwidth Calculation","text":"<p>You can calculate the resulting bandwidth for the design examples in section Memory Bandwidth. For the design example displayed in figure 1 with a RAM data width of 32 bit, the resulting bandwidth is:</p> <p></p> <p>For the design example displayed in figure 2 with a RAM data width of 256 bit, the resulting bandwidth is:</p> <p></p>"},{"location":"application-note-shared-memory.html#shared-memory","title":"Shared Memory","text":"<p>The bandwidth calculation formula in section Memory Bandwidth is true for all frame grabber platforms, when only a single DRAM operator exists. It is also true for the bandwidth calculation of each DRAM element in an applet for all platforms except the marathon series. If you use more than one operator, the total memory bandwidth is shared for the marathon series. The resulting bandwidth for one DRAM element is then calculated according to:</p> <p></p>"},{"location":"application-note-shared-memory.html#example-shared-memory","title":"Example Shared Memory","text":"<p>The following example for the marathon VCL platform shows two cameras, two DRAM elements (with RAM data width 32 bit) and two DMAs as shown in the image below:</p> Figure 3: Two Cameras Using RAM at Parallelism 4 <p>The resulting bandwidth is:</p> <p></p> <p>In comparison to the resulting bandwidth calculated in section Memory Bandwidth for a RAM data width of 32 bit but only one DRAM element in the design, the resulting bandwidth with two DRAM elements is half the value as before. To achieve the same bandwidth with two DRAM elements as with one DRAM element, you need to double the RAM data width (= 64 bit).</p>"},{"location":"application-note-shared-memory.html#operator-configuration","title":"Operator Configuration","text":"<p>The operator configuration automatically adapts to the available RAM data width of a given frame grabber hardware. Most operators therefore allow the RAM data width given in the VisualApplets Device Resources Documentation. Some operators only allow a parallelism of one. To overcome the link bit width limitation of 64 bits, some of these operators accept kernels to use an efficient RAM data width as explained in sections Efficient Usage of the DRAM and Memory Bandwidth. There are DRAM operators exceptions, which require special configuration for efficient usage. Details for the best configuration of the operator are available in the operator CoefficientBuffer documentation.</p>"},{"location":"available-patches-for-visualapplets-3-0-6.html","title":"Available Patches for VisualApplets 3.0.6","text":"<p>The installer(s) listed here include fixes of critical issues that became known after release of VisualApplets version 3.0.6.</p> <p>Patches are distributed by Basler in form of complete VisualApplets installers. The installer's file name contains a five-digit number (patch ID) that indicates which patch is included in a specific installer. For example, VAsetup3.0.6-68118.exe is an installer for VisualApplets 3.0.6 including patch 68121.</p> <p>The installer with the highest patch ID contains all fixes available for VisualApplets release 3.0.6.</p> <p>To get the latest installer, contact our Support Department: support@baslerweb.com.</p> Patch ID Fixed Issue Installer Names with Patch ID Available since 68118 When an applet designed with VisualApplets 3.0.6 was saved as *.mcf file (via microDisplay or SDK function Fg_saveConfig), this *.mcf file provoked a crash when it was loaded via SDK function Fg_InitConfig. This has been fixed. (7333) VAsetup3.0.6-68118.exe 11.09.2017"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html","title":"Changes and Fixed Issues in VisualApplets 3.0.3","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#implemented-firmware","title":"Implemented Firmware","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#further-enhancements-of-pocl-detection-mechanism","title":"Further Enhancements of PoCL Detection Mechanism","text":"<ul> <li>The PoCL detection mechanism implemented in VisualApplets for marathon Camera Link and LightBridge frame grabbers has been further extended. A new state of the PoCL controller has been introduced: State <code>NonPoCL_Save</code> is a securing time gap between sensing the PoCL compatibility of a camera and connecting GND.</li> <li> <p>New parameter values in parameters <code>PoCLStatePortA</code>/<code>PoCLStatePortB</code> (operator <code>BoardStatus</code>):</p> <ul> <li>State <code>NonPoCL_Save</code> is reflected as new value of parameter <code>PoCLStatePortA</code>/<code>PoCLStatePortB</code> in operator <code>BoardStatus</code>.</li> <li>State <code>PoCL_Cable_Connection_Stability</code> (introduced in VisualApplets 3.0.2 as 1.8 seconds for verifying the stability of the PoCL compatible signal) is now also reflected as a new value of parameter <code>PoCLStatePortA</code>/<code>PoCLStatePortB</code> in operator <code>BoardStatus</code>.</li> </ul> <p>Parameters <code>PoCLStatePortA</code>/<code>PoCLStatePortB</code> are dynamic-read parameters, i.e., the state of the PoCL controller can be read during runtime.</p> </li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#enhanced-pcie-detection","title":"Enhanced PCIe Detection","text":"<ul> <li>All microEnable 5 marathon, ironman, and LightBridge firmware: Enhanced PCIe detection.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#support-of-pcie-generation-1","title":"Support of PCIe Generation 1","text":"<ul> <li>Now all microEnable 5 marathon and LightBridge firmware also supports PCIe generation 1 (in addition to PCIe generation 2). The implementation of generation 1 consumes less resources than the implementation of generation 2 and is therefore helpful in designs that do not need the high bandwidth of generation 2, but are short of resources.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#all-operators","title":"All Operators","text":"<ul> <li>Adding/deleting nodes on operators, hierarchical boxes, or user library elements is now possible without any side effects. All simulation modules connected to the changed operator/HBox stay connected.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#ramlut","title":"RamLUT","text":"<ul> <li> <p>Faster Loading of Initialization File for <code>RamLUT</code> Operator in Binary Mode:     The loading speed of the initialization file for operator <code>RamLUT</code> in binary mode has been enhanced.</p> </li> <li> <p>Extended Data Output:     Operator <code>RamLUT</code> now supports 128 Bit Data output which allows to use the maximum RAM bandwidth.</p> </li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#o-type-operators","title":"O-type Operators","text":"<ul> <li>O-type operators can be implemented in parallel now also when they get their image data from an infinite source.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#txlink-rxlink","title":"TxLink / RxLink","text":"<ul> <li>Operators <code>TxLink</code> / <code>RxLink</code> don\u2019t cause timing errors anymore when using small parallelisms and bit widths. (was relevant to microEnable IV VD4-CL/-PoCL and microEnable IV VQ4\u2013GE/-GPoE. Fixed.)</li> <li>Enhanced documentation stating recommended settings for bit width and parallelism to ensure good routing results.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#rom-and-lut","title":"ROM and LUT","text":"<p>Operators <code>ROM</code> and <code>LUT</code> have a new parameter <code>ImplementationType</code> that influences the implementation strategy of the operator, i.e., which logic elements are used for instantiating the operator. Available options are AUTO, BRAM, or LUTRAM. This allows to design applets using large LUTs with, e.g., 2^16 addresses on a mE5-MA-VCL (Kintex).</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#sync","title":"SYNC","text":"<ul> <li><code>SYNC</code> operator now accesses valid memory areas also when in SyncToMax mode.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#user-library","title":"User Library","text":"<ul> <li>Update of user library elements is now possible without any side effects. All simulation modules connected to the updated element stay connected.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#cameragrayfull-und-camerargbfull","title":"CameraGrayFull und CameraRgbFull","text":"<ul> <li>Fix of operators <code>CameraGrayFull</code> und <code>CameraRgbFull</code>: Both operators had a bug in 80bit mode AreaScan (8tapx10bit und 10tapx8bit) that in some exceptional situations resulted in the loss of a line within a frame. (LineScan configurations where not affected.) Affected target platforms were ironman and marathon Camera Link frame grabber. This has been fixed.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-3.html#other-fixes","title":"Other Fixes","text":"<ul> <li>Synthesis with Vivado tool chain also works when the VisualApplets installation path contains space characters.</li> <li>Comment boxes in designs now accept UTF-8 characters, i.e., users can add comment boxes now containing, e.g., Korean or Chinese language.</li> <li>In the Project Info panel of the VisualApplets program window, Resources: Now also the consumption of resource \"Embedded ALU\" is stated.</li> <li>Loading and refreshing user libraries works smoothly now.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-4.html","title":"Changes and Fixed Issues in VisualApplets 3.0.4","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-4.html#clhs-camera-discovery","title":"CLHS Camera Discovery","text":"<p>VisualApplets CHLS designs with only one camera port: When using the final applet in a runtime environment, on camera port 2 (not connected) of the frame grabber, the system erroneously detected a camera. Fixed. Only the camera actually connected to the frame grabber running such an applet is detected now.</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-4.html#custom-operators-constraints-files-support-visualapplets-expert-feature","title":"Custom Operators: Constraints Files Support (VisualApplets Expert Feature)","text":"<p>Constraints files for custom operators are fully supported now and handled correctly: Constraints files that have been defined by the user are packed into the custom library. During the build of an applet (*.hap file) that contains a custom operator, the operator constraints files are unpacked. (In the last version, packing into the library and unpacking during build didn\u2019t work properly. Fixed.)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-4.html#custom-operators-in-protected-user-library-elements-visualapplets-expert-feature","title":"Custom Operators in Protected User Library Elements (VisualApplets Expert Feature)","text":"<p>Custom operators can now be used within protected user library elements. (This is the fix of known issue no. 2 in VisualApplets 3.0.3.)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-4.html#operator-selectroi","title":"Operator SelectROI","text":"<p>Operator <code>SelectROI</code> now generates an End-of-Frame tag as soon as it has received the last line in the selected ROI. (This is the fix of known issue no. 20 in VisualApplets 3.0.3.)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-4.html#debugging-library-improved-documentation-visualapplets-expert-feature","title":"Debugging Library: Improved Documentation (VisualApplets Expert Feature)","text":"<p>The documentation of the debugging library (released in VisualApplets 3.0.3 Expert) has been enhanced.</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html","title":"Changes and Fixed Issues in VisualApplets 3.0.6","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#trgboxline","title":"TrgBoxLine","text":"<p>Operator <code>TrgBoxLine</code> (library Prototype):</p> <ul> <li>The value range for parameter <code>ImgTrgDelay</code> has been extended to {0;65535} lines. (6848)</li> <li>The operator's output port <code>Exsync</code> works correctly now. (6608)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#memory-operators","title":"Memory Operators","text":"<p>Memory Operators allow Kernel Size &gt;1</p> <ul> <li>The operators <code>LineMemory</code>, <code>LineMemoryRandomRd</code>, <code>FrameMemory</code>, and <code>FrameMemoryRandomRead</code> (library Memory) now allow a kernel size &gt; 1. (2369)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#pixelneighbours1xm","title":"PixelNeighbours1xM","text":"<ul> <li>Operator <code>PixelNeighbours1xM</code> now supports variable line lengths also during simulation. In earlier versions, variable line lengths were only supported in hardware. (7170)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#instances-of-user-library-elements","title":"Instances of User Library Elements","text":"<p>Improved Handling of Changes</p> <p>Instances of user library elements that have been modified by the user are marked now with a special icon. In addition, when an update or quick update from the user library is started on such an instance, an according message occurs that informs the user that all changes that have been made to this instance will be lost if the update is carried out. This way, changed user library instances cannot be overwritten unintentionally anymore.</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#parameters-library","title":"Parameters Library","text":"<p>VisualApplets detects when due to wrong parametrization of the parameters <code>DisplayHierarchy</code> and <code>Display Name</code> a reference/translation operator module tries to add an operator parameter to a process of a design (which is not allowed). In earlier versions, this could lead to a crash of VisualApplets, or to an applet crash during runtime. Fixed. VisualApplets now informs via an error message how to parameterize the reference/translation operator correctly. (7053)</p> <p>Details: If the reference/translation operator is located on the highest hierarchical level of the design (process level) and <code>DisplayHierarchy</code> is empty, <code>DisplayName</code> must be empty, too, because the process itself is not a hierarchical box and cannot get parameters. Now, VisualApplets detects such situations and throws the according error message <code>DisplayName</code> must be empty when DisplayHierarchy refers to process Level. In earlier versions, it was possible to define a parameter under <code>Display Name</code> also when <code>Display Hierarchy</code> pointed to the process level (i.e., when the reference/translation operator was located on the highest hierarchical level of the design and <code>Display Hierarchy</code> was empty. This could lead to crashes of VisualApplets, or to applet crashes during runtime. This has been fixed.</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#blob-operators","title":"Blob Operators","text":"<p>In VisualApplets version 3.0.4, Operators <code>Blob_Analysis_1D</code> and <code>Blob_Analysis_2D</code> caused a dead lock when being blocked. This has been fixed. (6702)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#div","title":"DIV","text":"<p>The timing closure of the DIV operator (library Arithmetics) has been improved. In earlier versions, under specific circumstances it happened that the DIV operator caused timing errors during build. This has been fixed.(6900)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#ramlut","title":"RamLUT","text":"<p>New Error Code for Initialization File</p> <p>The RamLUT operator now returns error code FG_INVALID_FILESIZE if the size of its initialization file is not correct. In earlier versions, the error code FG_ERR_RANGE_ERROR was output in such situations. The new error code FG_INVALID_FILESIZE is available in conjunction with Basler runtime software version 5.4.4.1 or higher. (6422)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#linememory","title":"LineMemory","text":"<p>Operator <code>LineMemory</code> has been corrected. In earlier versions, under very rare circumstances there was the possibility of data corruption in operator <code>LineMemory</code>. This has been fixed. (6436)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#firoperator","title":"FIRoperator","text":"<p>Inserting nodes to operators (like BRANCH) via context menu could lead to loss of coefficients in subsequent <code>FIRoperator</code> modules. This has been fixed. (5450)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#mandatory-operators-also-in-new-process-0","title":"Mandatory Operators also in New Process 0","text":"<p>Designs for ironman, marathon or LightBridge: If you delete process 0 and then create a new process 0 from scratch, the mandatory operators AppletProperties and BoardStatus are inserted automatically into the new process 0 design. (In earlier versions, after removing and then re-creating process 0, the mandatory operators were missing. Fixed.) (5720)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#add","title":"ADD","text":"<p>The ADD operator has been corrected so that now also two input ports with a bit width of signed 63 bit are allowed. (In earlier versions, the ADD operator did erroneously not allow two input ports with a bit width of signed 63 bit. Fixed.) (7138)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#coefficientbuffer","title":"CoefficientBuffer","text":"<p>Operator <code>CoefficientBuffer</code> now allows to set parameter Ylength = 1. (1763, 3924)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#parameters-library_1","title":"Parameters Library","text":"<p>Enhanced Control Mechanism</p> <p>New error message \"DisplayName must be empty when DisplayHierarchy refers to process level\" is thrown if an operator instance of library Parameters is parameterized in a way that the referenced requested by DisplayName and DisplayHierarchy.</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#simulation","title":"Simulation","text":"<ul> <li><code>RemovePixel</code> Operator: Simulating a design that contains an instance of the RemovePixel operator runs smoothly now. In earlier versions, when a design was simulated that included an instance of the RemovePixel operator, occasionally an error occurred: Removing the last pixel of an image could result in an internal error that immediately stopped the simulation and returned a message about corrupted simulation data. This has been fixed. (6103)</li> <li>Simulation control: Improved simulation control for situations where a single image causes generation of multiple images within an image processing pipeline. (6314)</li> <li>Pixel Data with 64 bit resolution: The calculation of simulation results for situations where pixel data with 64 bit resolution is involved works correctly now. In earlier versions, the results of such calculations were wrong. This has been fixed. (6878)</li> <li>Operator <code>RamLUT</code> now supports variable line length also when a design is simulated. The image doesn't need to be rectangular for simulation anymore, but can also contain empty lines and/or lines of varying length (e.g., a triangular image). (6997)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#deleting-referenced-operators-of-library-parameters","title":"Deleting Referenced Operators of Library Parameters","text":"<p>Operator instances from library parameters can be deleted now from a design also if their parameters are still referenced by other modules. (In earlier versions, a crash of VisualApplets could happen in situations where the parameters of the deleted module were referenced by parameters of other modules (including parameter references due to property 'DisplayName'). Fixed.) (6423)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#overall-resource-estimation-improved","title":"Overall Resource Estimation Improved","text":"<p>The overall resource estimation (displayed under Netlist Generation in the DRC Log after Design Rules Check 2, and in dialog Build Hardware Applet after starting the Build process) now also takes the RAM LUT resources into account. Therefore, a higher amount of resources is calculated than in prior VisualApplets versions where the RAM LUTs where ignored in the overall resource estimation. Now, the overall resource estimation under Netlist Generation is consistent with the information of the FPGA Resource Usage dialog. (6487)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#generating-genicam-xml-code-for-eva-platforms","title":"Generating GenICam XML code for eVA Platforms","text":"<p>Fixed crash of VisualApplets when generating GenICam XML code (applies only to embedded VisualApplets targets) for a design which contains <code>ColorTransform</code> operator with dynamical coefficients. (6625)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#operator-reference-documentation","title":"Operator Reference (Documentation)","text":"<p>Links to Examples of Use</p> <p>Operator reference documentation: Links included in section Examples of Use now link directly to the according examples as intended. (7086)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#loading-and-unloading-applets-in-a-loop","title":"Loading and Unloading Applets in a Loop","text":"<p>Loading and unloading applets (built with VisualApplets 3.0.6 or higher) in a loop doesn't lead to memory leaks anymore. When applets built with earlier versions were loaded and unloaded in a loop, memory leaks could be observed. This has been fixed. (6925)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#roi-fix-cxp-camera-operators-marathon-and-ironman","title":"ROI Fix CXP Camera Operators (marathon and ironman)","text":"<p>Now the ROI settings work correctly with all CXP camera models. In earlier versions, some settings for the ROI frame height lead with some specific CXP cameras to incorrect image acquisition. This has been fixed. (6461)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#pocl-support-improved","title":"PoCL Support Improved","text":"<p>The PoCL support that is automatically implemented in Camera Link Applets for marathon and LightBridge frame grabbers has been improved:</p> <ul> <li>The PoCL detect mechanism has been further enhanced.</li> <li>The support of PoCL cameras that are changing their clock frequency has been improved: Instable clock signals sent by the camera (during reconfiguration of clock frequency in the camera) are tolerated by the applets for a longer period of time.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-0-6.html#camera-link","title":"Camera Link","text":"<p>Improved Stability After Invalid Pixel Signals from Camera</p> <p>When the frame grabber received invalid pixels from the camera before the acquisition was started, the first valid line/frame sent by the camera after start of acquisition was discarded (due to a filter system implemented to discard invalid signals) even if the acquisition was started via trigger. Fixed. The filter system has been improved so that now after start of acquisition via trigger the first line/frame sent by the camera is processed also in cases when invalid pixels have been sent by the camera before start of acquisition. The fix has been implemented into all mE5 marathon, mE 5 ironman, and LightBridge Camera Link frame grabbers, and into microEnable IV AD4 CL/PoCL and microEnable IV VD4 CL/PoCL.</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-1.html","title":"Changes and Fixed Issues in VisualApplets 3.1.1","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-1.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-1.html#imageinjector-and-cofficientbuffer","title":"ImageInjector and CofficientBuffer","text":"<ul> <li>The error message \u201cInvalid file data\u201d is displayed now when trying to load image data to instances of <code>CoefficentBuffer</code> or <code>ImageInjector</code> from a file with improper content. In earlier versions, the misleading message \"Invalid filename\" was shown. Fixed. (8536).</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-1.html#parameters-library","title":"Parameters Library:","text":"<ul> <li>Added support for PI() and E() in formulas. (8711)</li> <li>Improved notification of errors in formulas. (8798)</li> <li>VisualApplets remains stable now when functions in formulas have not the expected number of parameters. In earlier versions, VisualApplets could crash when functions in formulas did not have the right number of parameters. Fixed. (8628)</li> <li>Stability issues have been fixed that occurred when renaming or deleting hierarchical boxes which contained automatically inserted parameters which were referencing parameters of operators from library Parameters. (8449)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-1.html#custom-operators","title":"Custom Operators","text":"<ul> <li> <p>Operator Icons Displayed as Expected</p> <ul> <li>Operator icons may have any file name now. In earlier versions, an operator icon was only shown correctly when at the time of creating the custom operator the icon file name matched the name of the operator. This has been fixed. (8639)</li> </ul> </li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-1.html#installation","title":"Installation","text":"<ul> <li> <p>Installation Folder Freely Selectable</p> <ul> <li>The installation folder can always be selected during installation of VisualApplets. In version 3.1, the installation folder could not be selected in case the update feature was accepted before. Fixed. (8581)</li> </ul> </li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-1.html#license-manager","title":"License Manager","text":"<ul> <li>In earlier versions, on some installations of VisualApplets the tool LicenseManager.exe did not start due to unresolved dynamic link libraries. This has been fixed. (8769)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-1.html#build","title":"Build","text":"<ul> <li> <p>New Option for Meeting Timing Constraints</p> <ul> <li>A mechanism for selecting an alternative style for netlist generation has been added: When building a design fails meeting the timing constraints, it may help to define an environment variable VA_NETLIST_STYLE=2. VisualApplets will then generate the FPGA netlist with an alternative naming scheme which in some cases helps the Xilinx tool flow to generate a better distribution of logic on the FPGA. (8431)</li> </ul> </li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-1.html#gui","title":"GUI","text":"<ul> <li> <p>Operator Selection on Scaled Displays</p> <ul> <li>Mouse selection of operators in operator tool box when being in list view mode also works correctly now when the display scaling is set to 125% or higher (typical scaling on laptops). (8523)</li> </ul> </li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-1.html#simulation-behavior","title":"Simulation Behavior","text":"<ul> <li> <p>Operator SplitImage:</p> <ul> <li>Variable line length is now supported also in simulation as long as parameter ImageHeight is set to 1.</li> </ul> </li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-1.html#windows-10-start-menu-entries","title":"Windows 10 Start Menu Entries","text":"<ul> <li>The entries in the Start Menu of Windows 10 for the components of a VisualApplets installation have been clearly named now. In earlier versions, when VisualApplets was installed together with the Basler runtime software on a PC, the naming of the entries was in some cases ambiguous. Fixed. (8586)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-2.html","title":"Changes and Fixed Issues in VisualApplets 3.1.2","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-2.html#library-parameters","title":"Library Parameters","text":"<ul> <li>In certain situations where modules of library Parameters created parameter references, VisualApplets crashed when the design was closed or certain modules were deleted. This has been fixed. (9025)</li> <li>In certain situations, operators of library Parameters did not detect when parameters got into an invalid state. In particular, after renaming a module it was not detected when references to parameters of that module had been lost. This has been fixed. (8970)</li> <li>In operators of library Parameters, the handling of enumeration names which contain space characters has been fixed. (8446)</li> <li>In parameter-translation operators, the write targets were not checked sufficiently so that it was possible to define invalid write targets. This has been fixed. (8279)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-2.html#sdk-code-generation","title":"SDK Code Generation","text":"<ul> <li>SDK code generation has been updated so that generated code compiles with recent versions of the runtime API. (8841)</li> <li>The SDK code generation for operators which contain inactive parameters (like parameter <code>FvalMode</code> in operator <code>MediumGrayCamera</code> when operating in VALT_LINE1D mode) has been fixed. (8843)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-2.html#default-design-clock","title":"Default Design Clock","text":"<ul> <li>When for a design a non-default value for the clock speed was used, this value was at times preserved when the design was closed and a new design was created. This has been fixed so that creating a new design resets the clock speed to the default value for the selected platform. (8514)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1-2.html#va-tcl-export","title":"VA TCL Export","text":"<ul> <li>When operators formed a closed loop within a hierarchy level then exporting the design to script did not work. This has been fixed. (8873)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html","title":"Changes and Fixed Issues in VisualApplets 3.1","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#three-operators-no-longer-available-for-me5-and-eva-platforms","title":"Three Operators no Longer Available for mE5 and eVA Platforms","text":"<p>The following three operators are no longer available in designs for microEnable 5 or eVA (embedded VisualApplets) platforms. They can still be used in designs for target platforms of the microEnable 4 series (including PixelPlant):</p> <ul> <li><code>ImageBuffer_JPEG_Gray</code></li> <li><code>ImageBufferSpatial</code></li> <li><code>ImageSequence</code></li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#parameters-library","title":"Parameters Library","text":"<ul> <li>Enhanced formula editor: The formula editor of the Parameters library has been enhanced. It offers now syntax highlighting and autocompletion of operator paths and variable names.</li> <li>In the operators of the Parameters library, entering a slash at the end of the value for parameter <code>DisplayHierarchy</code> during design time is inhibited. This avoids problems during runtime, as during runtime, a slash at the end of parameter <code>DisplayHierarchy</code> makes the parameter inaccessible (read only), even when the parameter is a dynamic parameter (read/write). (8262)</li> <li>Various improvements of error handling.</li> <li>Changing parameter type via display parameter: Fixed changing the parameter type between DYNAMIC and STATIC from a display parameter of a <code>HierarchicalBox</code> (parameter generated by a Parameters operator when <code>DisplayName</code> has been specified). Before, this operation could lead to side effects leading to errors in the runtime environment. (8232)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#mult","title":"MULT","text":"<ul> <li>Operator <code>MULT</code> now supports asymmetric arithmetic types on its inputs, i.e., SIGNED and UNSIGNED may be mixed up so that you can multiply an unsigned multiplier with a signed multiplicand or a signed multiplier with an unsigned multiplicand (as well as a signed multiplier with a signed multiplicand or an unsigned multiplier with an unsigned multiplicand). (2729)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#ramlut","title":"RamLUT","text":"<ul> <li>Operator <code>RamLUT</code> supports kernels on the output. (4091)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#streamanalyzer","title":"StreamAnalyzer","text":"<ul> <li>Operator <code>StreamAnalyzer</code> now also supports LINE1D and PIXEL0D formats. (7120)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#imageinjector","title":"ImageInjector","text":"<ul> <li>Incoming links with a bit width up to 64 bit are supported. In earlier versions, when bit width on the the incoming link of <code>ImageInjector</code> was set to more than 32 bit, the operator didn't insert correct image data. This has been fixed. (7366)</li> <li>The operator <code>ImageInjector</code> will not create additional phantom frames anymore. In earlier versions, under special circumstances it was possible that a single injected frame caused several frames. This has been fixed. (7247)</li> <li>Operator <code>ImageInjector</code> works correctly now. In version 3.0.6, there occurred problems loading an image. This has been fixed. (8201)</li> <li>Parameter mode has a new mode Inject. In mode Inject, the operator immediately blocks the input and you can inject an image from file. (6877)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#mediumrgbcamera","title":"MediumRgbCamera","text":"<ul> <li>Order of color components matches now Camera Link Specification 2.1. In earlier versions, green and blue were swapped in modi Tap3x10bit and Tap3x12bit. This has been fixed. (7476)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#blob_analysis_1d-blob_analysis_2d","title":"Blob_Analysis_1D / Blob_Analysis_2D","text":"<ul> <li>Operator works as expected also when the line marker is disabled. In earlier versions, when parameter <code>line_marker</code> was set to <code>not_used</code>, an error message occurred during design rules check (DRC 2). This has been fixed. (7595)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#islastpixel","title":"IsLastPixel","text":"<ul> <li>Operator <code>IsLastPixel</code> now creates correct images also if its output ports are connected to asynchronous sinks, i.e., also if its output ports receive differing data flow signals (for example, if only one of the output ports was stopped). In earlier versions, all output ports of IsLastPixel needed to be connected to the same sink (M operator) to make the operator work stable. This has been fixed. (7731)</li> <li>The operator link <code>IsEmptyO</code> works now as expected. In earlier versions, under specific circumstances a data loss could occur on this link. This has been fixed. (7729)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#synthesis-of-designs-containing-multiple-sqrt-operators","title":"Synthesis of Designs Containing Multiple SQRT Operators","text":"<ul> <li>Synthesis of designs containing multiple instances of the <code>SQRT</code> operator works now as expected. In earlier versions, synthesis was not successful when multiple <code>SQRT</code> operator instances in the same design used differing bit depth configurations. This has been fixed. (7739)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#rximagelink-sdk-generation","title":"RxImageLink \u2013 SDK Generation","text":"<ul> <li>SDK code generated out of a design containing operator <code>RxImageLink</code> is correct now. (In earlier versions, the generated code contained invalid syntax for the parameter definition of <code>RxImageLink</code> which led to compiler errors. Fixed.) (7757)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#insert-port-abovebelow-for-all-operators-with-variable-number-of-ports","title":"Insert Port Above/Below for all Operators with Variable Number of Ports","text":"<ul> <li>All operators with a variable number of ports now offer a context menu \"Insert Port Above/Below\". (Only Exception: Operator SignalToEvent) (7786)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#enumparamtranslator","title":"EnumParamTranslator","text":"<ul> <li>Enumeration names in operator <code>EnumParamTranslator</code> may contain now ','. In earlier versions, during runtime it came to problems when an enumeration name contained a comma. This has been fixed. (7860)</li> </ul> <p>Using comma in enumeration names is not allowed</p> <p>Using comma in enumeration names is not allowed when generated GenICam API code shall be used for eVA platforms (platforms working with embedded VisualApplets).</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#selectbitfield-allows-color-input","title":"SelectBitField allows Color Input","text":"<ul> <li>Operator SelectBitField (Library Base) now also allows color input. (8076)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#color-support-of-rnd-mergepixel-selectbitfield-shiftleft-shiftright-new-round-rnd-implementation","title":"Color support of RND, MergePixel, SelectBitField, ShiftLeft, ShiftRight / New Round (RND) implementation","text":"<ul> <li>The following operators now also support color formats. Each color component is processed separately. (6973)</li> <li>RND has a new Implementation which requires only about the half of the LUTs that have been required for rounding operations before. The behavior of the operator is identical to previous versions. (6973)</li> <li>Affected operators:<ul> <li>RND (library Arithmetics)</li> <li>MergePixel (library Base)</li> <li>SelectBitField (library Base)</li> <li>ShiftLeft (library Arithmetics)</li> <li>ShiftRight (library Arithmetics)</li> </ul> </li> <li>Operators that can be used to modify the maximum image dimensions on a Link</li> <li>These operators now verify that the new image dimensions do not exceed the absolute maximum image dimensions (maximum image width: 2\\^31-1, maximum image height: 2\\^31-1). (4764)</li> <li>Link parameter / operator parameter collisions leading to an MaxImgWidth overflow are detected now and marked red in the VisualApplets GUI to inform the user instantly. (4764)</li> <li>Affected operators:<ul> <li>CastParallel (library Base)</li> <li>PARALLELdn (library Base)</li> <li>PARALLELup (library Base)</li> <li>SampleUp (library Base)</li> <li>PackbitsRLE (library Prototype)</li> <li>InsertPixel (library Synchronization)</li> </ul> </li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#gui","title":"GUI","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#visualapplets-base-license-contains-fpga-resource-estimation-on-module-level","title":"VisualApplets Base License contains FPGA Resource Estimation on Module Level","text":"<ul> <li>The Feature FPGA Resource Estimation on Module Level is now available to all users of VisualApplets. In earlier versions, it was available only to users of the VisualApplets Expert extension. This has been changed.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#new-settings-option-number-of-undo-steps","title":"New Settings Option: Number of Undo-Steps","text":"<ul> <li>In menu Settings -&gt; System Settings -&gt; Design, you can define the number of Undo steps for working with the VisualApplets GUI.</li> <li>If you set the number of Undo steps to 0, option Undo is de-activated.</li> <li>De-activation of Undo leads in complex designs to an enhanced GUI performance. However, if Undo is de-activated, a design cannot be restored after a crash. (7427)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#highlighting-of-selected-elements-in-module-info-window","title":"Highlighting of selected elements in Module Info window","text":"<ul> <li>The selected elements in the currently active design window are highlighted in the Module Info window. In earlier versions, this worked only for selections in the Process0 window. This has been fixed. (7356)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#browsing-the-design-while-dialogs-are-open","title":"Browsing the Design while Dialogs are open","text":"<ul> <li>You can browse (but not change) your design now while the following dialogs are open (7124):<ul> <li>Resources</li> <li>FPGA Resource Usage</li> <li>Bandwidth Analysis</li> <li>Simulation</li> <li>Build Hardware Applet</li> </ul> </li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#zooming-the-help-window-via-strg-mouse-wheel","title":"Zooming the Help Window via Strg + Mouse Wheel","text":"<ul> <li>You can zoom in and out the content of the help window via Strg + mouse wheel. In earlier versions, only the headings of the help where zoomed. This has been fixed. (6978)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#enhanced-display-of-changed-link-parameters","title":"Enhanced Display of Changed Link Parameters","text":"<ul> <li>After the parameters of a link have been changed, the changed link is highlighted in green. Closing the Link Properties dialog doesn't change the highlighting. The highlighting disappears as soon as you click on an empty area of the design window.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#simulation","title":"Simulation","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#paths-to-simulation-images","title":"Paths to Simulation Images","text":"<ul> <li>New option for saving paths for images in simulation sources relative to a given folder. In menu Settings-&gt;System Settings in category Design after Paths for Simulation Source Images it can be specified whether the paths shall be absolute, relative to design location, relative to the VisualApplets installation directory or relative to the default simulation image path specified in category Simulation.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#simulation-settings","title":"Simulation Settings","text":"<ul> <li>The simulation settings (menu Settings-&gt; System Settings -&gt; Simulation) for the I/O Image Library are set per default to TIFF compression = LZW. This reduces the size of the TIFF images. (7693)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#deleting-simulation-probe-modules-in-h-boxes","title":"Deleting Simulation Probe Modules in H Boxes","text":"<ul> <li>Deleting simulation probe modules located at links connected to H box input nodes now works as expected. In earlier versions, deleting such simulation modules could lead to errors or program crash. This has been fixed. (7795)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#simulation-probe-viewer","title":"Simulation Probe Viewer","text":"<ul> <li>Simulation results are displayed properly now also for image sequences containing images with multiple kernel components and varying image width. In earlier versions, simulation results from image sequences that had multiple kernel components and varying image width where not displayed correctly in the Viewer. However, this was a mere display bug, simulation itself was not affected. This has been fixed. (7705)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#simulation-of-64-bit-images","title":"Simulation of 64-bit Images","text":"<ul> <li>Simulation now handles source images with 64-bit components as expected. In earlier versions, under specific circumstances, after simulating 64-bit images the simulation probe only contained 0 values. This has been fixed. (7862)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#mcf-files","title":"MCF Files","text":"<ul> <li>Saving the MCF file now also works when there is no file name defined in operator <code>CoefficientBuffer</code>. In earlier versions, writing the MCF file stopped as soon as there was an empty string detected where a file name was expected in an instance of <code>CoefficientBuffer</code>. This led to incomplete MCF files. This has been fixed. (7939)</li> <li>MCF files generated for a design containing operator <code>CLHSDualCamera</code> (VF2) by microDiplay can be loaded in the runtime using functions <code>Fg_loadConfig</code> / <code>Fg_InitConfig</code> or in microDisplay itself. In earlier versions, under rare circumstances loading such a file during runtime was not possible. This has been fixed. (6158)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#created-sdk-code","title":"Created SDK Code","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#dma-channel-status-grab_active","title":"DMA channel status GRAB_ACTIVE","text":"<ul> <li>The DMA channel status GRAB_ACTIVE can be retrieved using Fg_getStatus/Ex. It is 1 only when a DMA channel was successfully started and has not yet been stopped again. In all other cases it is 0. In the VisualApplets version prior to 3.1 this was not the case. This has been fixed. (6865)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#other-features","title":"Other Features","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#build","title":"Build","text":"<ul> <li>Build flow works correctly also when LED and/or GPO operators are used in designs for microEnable 5 platforms. In earlier versions, using LED and/or GPO operators in designs for microEnable 5 platforms led in some cases to build flow errors (step Optimize Design). This has been fixed. (8427)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#error-message-system","title":"Error Message System","text":"<ul> <li>The set of error messages for the Design Rules Checks (DRC1 and DRC2) has been enhanced. (8086)</li> <li>When VisualApplets during simulation cannot write image data to hard disc because the hard disk is full, an according error message occurs that provides the path to the intended saving location. In earlier versions, a message \"File access denied\" was displayed. This has been fixed.(7919)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#unlimited-number-of-design-elements","title":"Unlimited Number of Design Elements","text":"<ul> <li>Internal limit for the number of allowed design elements has been removed. (In earlier versions, this limit led in extremely complex designs to the following CHDL error message during Design Rule Check 2:</li> </ul> <pre><code>Error: -1 chdl2.cxx:2677:computeOMLatency-Range error\n</code></pre> <p>This has been fixed. (8084)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#tcl-exportimport","title":"TCL Export/Import","text":"<ul> <li>LUT values are saved very efficiently now so that saving to Tcl and loading a Tcl file works much faster. (7790)</li> <li>Floating-point values are now saved to Tcl script absolute precisely.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#genapi-xml-generation","title":"GenAPI XML Generation","text":"<ul> <li>The generation of GenAPI XML content for embedded VisualApplets designs has been improved concerning the compliance with 3<sup>rd</sup> party tools. For embedded VisualApplets platforms new properties may be defined with allow for generating default \\&lt;Visibility&gt; and \\&lt;ImposedAccessMode&gt; entries for features which don't specify these tags. (7024)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#unicode-characters-in-directory-names-supported","title":"Unicode Characters in Directory Names supported","text":"<ul> <li>For naming directories in paths, unicode characters can be used. However, for naming *.va files, only ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic characters are not supported for file names.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#operators-ramlut-and-coefficientbuffer-on-px200","title":"Operators RamLUT and CoefficientBuffer on px200","text":"<ul> <li>Operators <code>RamLUT</code> and <code>CoefficientBuffer</code> can be used freely on px200 again. This is a fix of the known issue no. 23 in Release Notes VisualApplets 3.0.6, issue 8045.<ul> <li>Px200 is only supported on mE4VD4-CL. Support for px200 on mE4VD1 and mE4VQ4 is discontinued.</li> <li>Support for px100 on mE4VD4-CL is discontinued.</li> </ul> </li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-1.html#documentation","title":"Documentation","text":"<ul> <li>In Tutorial and Examples, all sections and subsections of the documentation are contained. (In the last version, in section Processing Examples, the subsections Advanced, Binarization, Blob Analysis, Color, and Debugging and Test were missing. Fixed.) (7327)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html","title":"Changes and Fixed Issues in VisualApplets 3.2.0","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#connection-to-license-dongle","title":"Connection to License Dongle","text":"<ul> <li>Changed behavior of VisualApplets when connection to license dongle is lost: VisualApplets blocks user interaction but saving the current design is still possible. VisualApplets recovers from the blocked state when the license is established again. (8851)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#scope","title":"Scope","text":"<ul> <li>The parametrization of operator Scope has been changed: The max. output image width is now independent of the max. input image width. Note that a configuration where the output image width is larger than the input image width can cause a slowdown of fetching input data. (9315)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#blob_analysis_1d","title":"Blob_Analysis_1D","text":"<ul> <li>The simulation for operator <code>Blob_Analysis_1D</code> has been improved.</li> <li>The documentation for operator <code>Blob_Analysis_1D</code> has been improved. (7604, 7710)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#blob_analysis_1d_1","title":"Blob_Analysis_1D","text":"<ul> <li>The operator <code>Blob_Analysis_1D</code> has been enhanced and can handle empty frames now. (7711)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#blob_analysis_2d","title":"Blob_Analysis_2D","text":"<ul> <li>The documentation for operator <code>Blob_Analysis_2D</code> has been improved. (7710)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#removepixel","title":"RemovePixel","text":"<ul> <li>The simulation of operator <code>RemovePixel</code> now allows variable line lengths and empty lines. (6707)</li> <li>The maximum image width of the output link will be bigger by 1x parallelism if parameter FlushCondition is set to EoF. (6707)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#register","title":"Register","text":"<ul> <li>The simulation of operator <code>Register</code> has been fixed. The simulation can now handle images with variable line lengths and/or empty lines. (In earlier versions: When the input image line was shorter than the input image width and the first 2 pixels in the following line were removed, the 2<sup>nd</sup> pixel in that line contained a wrong value in simulation. This has been fixed.) (9210)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#splitimage","title":"SplitImage","text":"<ul> <li>The simulation of operator <code>SplitImage</code> has been fixed. The simulation can now handle splitting images with variable line lengths and/or empty lines. The biggest line in each image defines the image width. (9212)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#sampledn","title":"SampleDn","text":"<ul> <li>The simulation of operator <code>SampleDn</code> has been fixed and works correctly now also with sampling factors 2^n^.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#pixelreplicator","title":"PixelReplicator","text":"<ul> <li>Operator <code>PixelReplicator</code> has been fixed and works correctly again also in 0D format (image protocol VALT_IMAGE0D).</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#intfieldparamreference","title":"IntFieldParamReference","text":"<ul> <li>Operator <code>IntFieldParamReference</code> now also handles references to unsigned integer (UINT) fields. (In earlier versions, an error message occurred at loading a design containing an instance of <code>IntFieldParamReference</code> with a reference to a UINT field. Fixed.) (9361)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#streamanalyzer","title":"StreamAnalyzer","text":"<ul> <li>Calculation of DataRate in operator <code>StreamAnalyzer</code> works correctly now. (In earlier versions, when the data width of the input was more than 8 bit, a multiple of the pixel rate was displayed. This has been fixed.) (9328)</li> <li>The measuring of IdleFraction works correctly now. Cycles during which no data is moved through the pipeline because it is blocked are not added to the idle count any more. (In earlier versions, operator <code>Streamanalyzer</code> provided a wrong IdleFraction. This has been fixed.) (9329)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#dynamicroi","title":"DynamicROI:","text":"<ul> <li>Operator DynamicROI outputs the correct line length again under all circumstances. (In versions 3.1.x, the operator output the wrong line length under specific circumstances. This has been fixed. (7722)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#parameters-library","title":"Parameters Library","text":"<ul> <li> <p>The error checking of referenced parameter names in formulas has been improved. (8279, 8970)</p> <p>For example, if you re-name a referenced module (and thus the reference parameters in the referencing module get undefined) you get an according warning message immediately.</p> </li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#custom-operators","title":"Custom Operators","text":"<ul> <li>The memory access of custom operators has been fixed. (9151)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#eva-designer","title":"eVA Designer","text":"<ul> <li>In eVA Designer the list of available formats for an <code>ImgIn</code> or <code>ImgOut</code> operator could get inconsistent with the list of formats of the corresponding interface port when such a format was modified or removed. This has been fixed. When an eVA platform description is opened, possible format conflicts get resolved automatically. (9164)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#automatic-bandwidth-analysis","title":"Automatic Bandwidth Analysis","text":"<p>For VisualApplets 3.2, the automatic Bandwidth analysis function has been de-activated. Due to a continuous expansion of the VisualApplets functionality (new operators, new hardware platforms, hardware-specific memory handling), the initially implemented bandwidth analysis function gradually ceased to deliver reliable results.</p> <p>In practical applications, the throughput rate often depends on the actual image content and the timing. In VisualApplets' automatic bandwidth analysis, both these aspects had not been factored in.</p> <p>As practice shows, the bandwidth is generally monitored and calculated by the developer during the design process. To support the developer in calculating, VisualApplets now displays the maximal data throughput rate for each link (optional display via on/off button).</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#user-library","title":"User Library","text":"<ul> <li>Creating a protected user library element which contains modules with a float field parameter works correctly now. (In earlier versions, this lead occasionally to a program crash. This has been fixed.) (9264)</li> <li>Saving a protected user library element that contains integer field parameters with negative coefficients works correctly now. (In earlier versions, during saving of a protected user library element, negative coefficients of integer field parameters got lost (e.g., <code>FIRoperatorNxM</code>). This has been fixed.) (9252)</li> <li>Saving an instantiated user library module that is located within a hierarchical box to a user library: Saving works correctly now also when the output of the module is connected to an output node of the hierarchical box and a simulation module is connected to that link. (In earlier versions, this could cause a crash of VisualApplets. Fixed.) (9246)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#miscellaneous","title":"Miscellaneous","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#addingremoving-module-ports","title":"Adding/Removing Module Ports","text":"<ul> <li>Adding and removing ports of instantiated modules works correctly now. (In earlier versions, in some situations adding or removing ports of instantiated modules could cause a crash of VisualApplets. This has been fixed.) (9304)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#correct-propagation-of-link-parameter-changes","title":"Correct Propagation of Link Parameter Changes","text":"<ul> <li>The mechanism for propagating link parameter changes through the design has been improved. (8874)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#detection-of-vivado-version","title":"Detection of Vivado Version","text":"<ul> <li>VisualApplets now reliably detects the Vivado version. (In earlier versions, in some situations VisualApplets could not detect the Vivado version. In particular this happened when Vivado returned warning messages because of improper definition of environment variables. This has been fixed.) (9099)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-0.html#other-changes","title":"Other Changes","text":"<p>All other changes compared to the previous version of VisualApplets are listed in section New Features.</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html","title":"Changes and Fixed Issues in VisualApplets 3.2.1","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#tcl-expert-feature","title":"Tcl (Expert Feature)","text":"<ul> <li>Scripting commands <code>CopySelected</code> and <code>CutSelected</code> did not copy any content to the clipboard. This has been fixed. (9595)</li> <li>Text can be copied from the Tcl window now under all circumstances. In earlier versions, copying didn't work when an operator or link was selected. This has been fixed. (9455)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#simulating-ramlu","title":"Simulating RamLU","text":"<ul> <li>In earlier versions, a memory leak occurred when operator RamLUT was simulated. This memory leak during simulation has been fixed. (9635)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#simulating-blob_analysis_2d","title":"Simulating Blob_Analysis_2D","text":"<ul> <li>Certain image content caused a crash during simulation. This has been fixed. (9642)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#simulating-removepixel","title":"Simulating RemovePixel","text":"<ul> <li>Operator RemovePixel could cause a crash of VisualApplets during simulation. This has been fixed. (6707)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#simulating-imagetiminggenerator","title":"Simulating ImageTimingGenerator","text":"<ul> <li>Operator ImageTimingGenerator could cause a crash of VisualApplets during simulation in 0D or 1D mode. This has been fixed. (9633)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#simulating-pixeltosignal","title":"Simulating PixelToSignal","text":"<ul> <li>In designs utilizing PixelToSignal modules during simulation, in some cases an early abort of processing could occur when the simulation of data flow synchronization was activated (default). This has been fixed. (9622)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#simulating-pixeltoimage","title":"Simulating PixelToImage","text":"<ul> <li>In designs utilizing PixelToImage modules during simulation, in some cases an early abort of processing could occur when the simulation of data flow synchronization was activated (default). This has been fixed. (9622)</li> <li>PixelToImage now uses a simple simulation model emitting a zero pixel for each incoming pixel at port Sample.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#imagefifo","title":"ImageFifo","text":"<ul> <li>Operator <code>ImageFifo</code> now detects when a given parametrization would exceed available FPGA memory resources. The operator now triggers an according error message. (8875)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#jpeg_encoder","title":"JPEG_Encoder","text":"<ul> <li>The JPEG_Encoder operator can now be used also with non-stoppable sources. In this context, a new parameter <code>InfiniteSource</code> and an overflow management has been implemented. To use the operator with non-stoppable sources, you need to set parameter InfiniteSource to Enabled.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#miscellaneous","title":"Miscellaneous","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#design-conversion-for-new-platform","title":"Design Conversion for New Platform","text":"<ul> <li>Under certain conditions, converting a design to a different platform failed, resulting in a corrupted design file. This has been fixed. (9626)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#vclvclx-platforms-clock-management-placement-constraints","title":"VCL/VCLx platforms: Clock Management Placement Constraints","text":"<ul> <li>The CameraLink interface on VCL/VCLx platforms was missing clock management placement constraints. In most designs, Vivado placed the related clock managers still in correct positions due to the correspondent IO pin locations. However, under unknown circumstances it could happen that Vivado created an illegal placement which lead to an error in the Place &amp; Route build step. The placement of the CameraLink clock managers is now fixed and thus, this issue can never occur again. (9648)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#sdk-generator","title":"SDK Generator","text":"<ul> <li>For writing and reading of 64 bit integer field parameters, no appropriate code was generated. This has been fixed. (9653)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#visibility-of-set-fpga-clock-frequency","title":"Visibility of set FPGA Clock Frequency","text":"<ul> <li>The visibility of the current FPGA clock setting (for mE5 designs) has been improved. Furthermore, a warning message occurs when the clock frequency is set to a very high value, as increasing the clock frequency may result in a build flow fail because the timing constraints can't be met. Whether the build flow with high clock settings succeeds or not strongly depends on the content of the VisualApplets design. (8513)\\</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#saving-drc-log-and-build-log-to-file","title":"Saving DRC log and Build log to File","text":"<ul> <li>You can save the content of the panes \"DRC Log\" and \"Build Log\" to *.txt files. This was not working correctly, but has been fixed now. (9404)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#immediate-update-of-open-properties-dialogs","title":"Immediate Update of open Properties Dialogs","text":"<ul> <li>When the reference parameter of an HBox module is changed: As soon as you click the Apply button in the corresponding properties dialog, all open operator properties dialogs are updated. (9646)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#empty-parameter-values-in-metadata-parameters","title":"Empty Parameter Values in Metadata Parameters","text":"<ul> <li>In metadata parameters, empty parameter values are allowed now. No warning will be displayed. (4882)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#operator-rgb2hsi-documentation","title":"Operator RGB2HSI - Documentation","text":"<ul> <li>The documentation for operator RGB2HSI now names the color space conversion the operator actually carries out: The operator implements the RGB to HSL (Hue Saturation Luminance) color space conversion, and NOT RGB to HSI (Hue Saturation Intensity) or RGB to HSV (Hue Saturation Value).</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-2-1.html#crash-reporter","title":"Crash Reporter","text":"<ul> <li>Means for reporting crashes of VisualApplets have been added. (8892)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html","title":"Changes and Fixed Issues in VisualApplets 3.3.0","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#discontinuation-of-windows-7-and-32-bit-windows","title":"Discontinuation of Windows 7 and 32-bit Windows","text":"<ul> <li>Windows 7 and 32-bit Windows systems are no longer supported. Use previous versions of VisualApplets, if Windows 7 support or support for 32-bit Windows versions is required.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#design-rules-check","title":"Design Rules Check","text":"<ul> <li>A check is now available that detects when operators might cause deadlock because asynchronous inputs are connected to the same O-type network. This affects the operators <code>FrameBufferRandomRead</code>, <code>LineMemoryRandomRd</code>, <code>InsertImage</code>, and <code>InsertLine</code>. Now, a warning is issued when a possible deadlock might occur. (Ticket ID: 7735)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#simulation","title":"Simulation","text":"<ul> <li>The handling of images in simulation probes concerning color images which exceed 48 bit has been fixed. Before, crashes of VisualApplets or invalid display content could occur. (Ticket ID: 9826)</li> <li>The display of pixel values has been fixed in the Simulation Probe Viewer so the brightest color is close to white. Prior to fixing this issue, the bit width did not use the whole range of available gray scales for pixel component bit width of 2, 3, or 4. This has been fixed. (Ticket ID: 7371)</li> <li>A warning is now issued when images used in a simulation have been deleted from the hard disk, are invalid or cannot be read. (Ticket ID: 7921)</li> <li>The File View mode of simulation probes has been fixed. Prior to fixing this issue, in the Simulation Probe Viewer pane Display Alignment, the entries Display and Shown Values were not displayed correctly, when the File View option was selected. In this case, Display and Shown Values in pixel grid and properties window did not match the destination file format properties as defined in the Save Options panel. This has been fixed. Now, the pixel grid and properties window match the data for saving to file according to the  file format properties as defined in the Save Options panel. (Ticket ID: 7738)</li> <li>Pixel value interpretation in the Simulation Probe Viewer has been extended. Now, values may be shown as fixed-point numbers with a given number of fractional bits. Additionally, values may be scaled by an arbitrary number. (Ticket ID: 9811)</li> <li>A possible crash of VisualApplets when simulating custom operators has been fixed. Prior to fixing this issue, simulating a design that contains custom operators worked fine the first time, but opening the simulation dialog a second time resulted in a crash. This has been fixed. (Ticket ID: 9883)</li> <li>The check box Signed in the Simulation Probe Viewer is now set automatically when attaching a simulation probe to a link or changing the format of a link with a connected simulation probe. Whether the check box Signed is checked or cleared, depends on the link data. Before, this check box had to be set manually. However, you can still check or clear the check box manually. (Ticket ID: 9273)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#across-libraries","title":"Across Libraries","text":"<ul> <li>The operators <code>CONST</code>, <code>ClipHigh</code>, <code>ClipLow</code>, <code>GetStatus</code> and <code>FIRkernelNxM</code> have been extended so that they now support 64-bit signed/unsigned. (Ticket ID: Ticket ID: 9858)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#library-accumulator","title":"Library Accumulator","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-modulocount","title":"Operator <code>ModuloCount</code>","text":"<ul> <li>The operator <code>ModuloCount</code> has been extended. It now supports variable line length and simulations for values larger than 32 Bit. (Ticket ID: 2695)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#library-arithmetics","title":"Library Arithmetics","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-add","title":"Operator <code>ADD</code>","text":"<ul> <li>The operator <code>ADD</code> has been optimized to use less resources in certain corner cases, e.g. 3x1 Bit or 5x2 Bit. (Ticket ID: 7455)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#library-base","title":"Library Base","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-const","title":"Operator <code>CONST</code>","text":"<ul> <li>The operator <code>CONST</code> has been changed so the type of the parameter <code>Value</code> matches the arithmetic type of the output link (signed or unsigned). <code>CONST</code> can now be used for setting output values for links with 64 bit unsigned pixels.(Ticket ID: 8474)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-selectroi","title":"Operator <code>SelectROI</code>","text":"<ul> <li>The operator <code>SelectROI</code> has been changed. Prior to fixing this issue, the operator <code>SelectROI</code> appended an empty line to the ROI image when the height of the ingoing frame was less than the appointed ROI height. This has been fixed. (Ticket ID: 8805)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-splitparallel","title":"Operator <code>SplitParallel</code>","text":"<ul> <li>The operator SplitParallel had been restricted to rectangular images during simulation. This limitation was removed from simulation as it does not exist in hardware. Now, the operator can be used for images with varying line lengths. (Ticket ID: 7373)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#library-blob","title":"Library Blob","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-blob_analysis_1d","title":"Operator <code>Blob_Analysis_1D</code>","text":"<ul> <li>The operator <code>Blob_Abalysis_1D</code> has been changed. Prior to fixing this problem, the operator <code>Blob_Analysis_1D</code> did not calculate the correct values for the output bit width of the ports <code>CenterXO</code> and <code>CenterYO</code> in mode <code>use_cX_with_maximum_required_bits</code> and <code>use_cY_with_maximum_required_bits</code>. This has been fixed. (Ticket ID: 9699)</li> <li>Calculation of the required bit width for outputs CoG_x and CoG_y is corrected. Before that, the resulting range was too low.</li> <li>The parameter range for <code>label bits</code> is now limited to 31 bit. Before, that it was limited to 32 bit. (Ticket ID: 9677)</li> <li>The parameter range for <code>max_object_height_bits</code> is limited to 31 bit. Before, it was limited to 64 bit. (Ticket ID: 9676)</li> <li>The simulation has been improved to reflect the known issues documented for the operator <code>Blob_Analysis_1D</code> and now corresponds with the hardware behavior. (Ticket ID: 9664)</li> <li>During simulation, objects are now flushed based on Y1, as it is done also in the hardware. Before, Y0 was considered for flush condition. (Ticket ID: 9663)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-blob_analysis_2d","title":"Operator <code>Blob_Analysis_2D</code>","text":"<ul> <li>The parameter range for <code>label bits</code> is now limited to 31. Before, that it was limited to 32. (Ticket ID: 9678)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#library-color","title":"Library Color","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-colortransform","title":"Operator <code>ColorTransform</code>","text":"<ul> <li>Prior to fixing this issue, netlist generation failed for certain cases when the operator <code>ColorTansform</code> was used with static coefficients. This has been fixed. (Ticket ID: 9085)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#library-debugging","title":"Library Debugging","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-imageinjector","title":"Operator <code>ImageInjector</code>","text":"<ul> <li>Using an <code>ImageInjector</code> with an empty <code>ImageFile</code> parameter resulted in a crash during loading the resulting hardware applet. This has been fixed. (Ticket ID: 9781)</li> <li>The handling of 16-bit TIFF files in the operator <code>ImageInjector</code> has been fixed. Prior to fixing this issue, when the operator <code>ImageInjector</code> was used during runtime for an 8-bit link and 16-bit data was found in the TIFF, the injection did not use the 8 MSBits. Instead, a 16-bit pixel from TIFF was converted into 2x8 bit pixels in runtime. This has been fixed. (Ticket ID: 8904)</li> <li>The operator <code>ImageInjector</code> has been extended: It now has a new parameter <code>EnableInsertModes</code> to enable insert modes <code>INSERT_AFTER_EOF</code> and <code>INSERT_AFTER_EOL</code>. If the parameter is enabled, the operator behaves as M-type, else it is of type P. (Ticket ID: 9804)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-imagemonitor","title":"Operator <code>ImageMonitor</code>","text":"<ul> <li>The operator <code>ImageMonitor</code> has been fixed. Prior to fixing this issue, the operator sometimes did not capture the first data word of an incoming data stream. This resulted in missing leading pixels (equal to the parallelism) when reading out the monitoring data. This has been fixed. (Ticket ID: 9852)</li> <li>The operator <code>ImageMonitor</code> has been fixed. Prior to fixing this issue, the operator did not take the parallelism into account so the x position was reported in the wrong way for parallelism &gt; 1. This has been fixed. (Ticket ID: 9854)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operators-imageinjector-and-imagemonitor","title":"Operators <code>ImageInjector</code> and <code>ImageMonitor</code>","text":"<ul> <li>Prior to fixing this issue, an error occurred during netlist generation when using the operators <code>ImageInjector</code> and <code>ImageMonitor</code> in 1D mode. This has been fixed. (Ticket ID: 7728)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-imagestatistics","title":"Operator <code>ImageStatistics</code>","text":"<ul> <li>The operator <code>ImageStatistics</code> has been changed. Prior to fixing this issue, the operator <code>ImageStatistics</code> caused a DRC2 error for certain numbers of <code>FrameCountWidth</code>. This has been fixed. (Ticket ID: 9721, 9853)</li> <li>Added support for kernels for the operator <code>ImageStatistics</code>. (Ticket ID: 7715)</li> <li>The operator <code>ImageStatistics</code> has been extended. It now contains an additional parameter <code>LineCountWidth</code> for adjusting the resolution for measuring statistics information. Additionally, a new bit in the parameter <code>OverflowMask</code> has been added for indicating an overflow of this measurement. (Ticket ID: 9723)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-imagetiminggenerator","title":"Operator <code>ImageTimingGenerator</code>","text":"<ul> <li>The operator <code>ImageTimingGenerator</code> has been improved for simulation. Now, the operator takes the parameters for generating image sequences into account. (Ticket ID: 9634)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-streamanalyzer","title":"Operator <code>StreamAnalyzer</code>","text":"<ul> <li>The operator <code>StreamAnalyzer</code> has been extended: It now contains an additional parameter <code>OverflowMask</code>, which indicates whether a counter ran into overflow during analysis. (Ticket ID: 9464)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#library-filter","title":"Library Filter","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-firkernelnxm","title":"Operator <code>FIRkernelNxM</code>","text":"<ul> <li>The operator <code>FIRkernelNxM</code> has been modified for handling signed pixel formats. Now, if the pixel arithmetic type is <code>signed</code> and the color format is <code>VAF_GRAY</code>, the module parameter <code>Constant</code> is a signed integer. Note that converting designs from previous versions of VisualApplets may require changing the parameter value of <code>Constant</code>. The previous method of providing two's complement numbers of negative values now shows up as an error. (Ticket ID: 9857)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-pixelneighbours1xm","title":"Operator <code>PixelNeighbours1xM</code>","text":"<ul> <li>The operator <code>PixelNeighbours1xM</code> has been changed. Prior to fixing this issue, when you set the kernel size of the operator <code>PixelNeighbours1xM</code> higher than 30, an error message \"Internal error\" occurred in Design Rules Check (DRC) level 2. This has been fixed. (Ticket ID: 9649)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#library-logic","title":"Library Logic","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-case","title":"Operator <code>CASE</code>","text":"<ul> <li>In certain situations no FPGA resources were estimated for the operator CASE. This has been fixed. (Ticket ID: 9902)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#library-memory","title":"Library Memory","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-ramlut","title":"Operator <code>RamLUT</code>","text":"<ul> <li>Prior to fixing this issue, VisualApplets might have crashed during simulation when changing the input bit width of the operator <code>RamLUT</code> between subsequent simulation runs. This happened, because of a memory leak. This has been fixed. Now, a clean-up function cleans the memory content. (Ticket ID: 9917)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-imagebuffer","title":"Operator <code>ImageBuffer</code>","text":"<ul> <li>The operator <code>ImageBuffer</code> has been extended. It now supports variable line lengths. (Ticket ID: 8770)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#library-parameters","title":"Library Parameters","text":"<ul> <li>Operators of the library Parameters now take into account if target parameters may not be altered during acquisition. Prior to fixing this issue, it was not possible, to change the parameters themselves during acquisition, however a parameter reference could still cause a value change, although the change was then not handed over to the hardware. This has been fixed. Now, during acquisition phase, parameters cannot be altered anymore by reference parameters for the blocked modules. (Ticket ID: 9496)</li> <li>You can now change the order of parameters in hierarchical boxes. Such parameters are either created by adding metadata or using operators of the library Parameters where the fields DisplayName and DisplayHierarchy are set. For hierarchical boxes which contain reference parameters, the Module Properties dialog now shows arrow up and arrow down buttons which may be used to rearrange the parameter order. (Ticket ID: 8408)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#library-synchronization","title":"Library Synchronization","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-createblankimage","title":"Operator <code>CreateBlankImage</code>","text":"<ul> <li>The operator <code>CreateBlankImage</code> has been extended with an option for simulating several frames in one simulation step. You can now adjust the number of frames to simulate in 2D-mode via the operator parameter <code>FramesToSimulate</code>. (Ticket ID: 4519)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-appendline","title":"Operator <code>AppendLine</code>","text":"<ul> <li>The operator <code>AppendLine</code> has been changed regarding the value range of the parameter <code>AppendNumber</code>. For 2D images the range is now limited to the max. image height at input I. For 1D images the range is now limited to the max. image width at output O divided by the parallelism. This limitation is so, because this limit is the max. number of minimal length lines which may be appended and still fits into an output line with max. length. (Ticket ID: 8005)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-pixeltoimage","title":"Operator <code>PixelToImage</code>","text":"<ul> <li>Prior to fixing this issue, during simulation the operator <code>PixelToImage</code> discarded all data from input \"I\" and input \"Sample\" and produced no data. This has been fixed. Now,  the operator <code>PixelToImage</code> discards \"I\" and produces output data according to the dimension of \"Sample\" with values defined by parameter <code>SimulationPixelValue</code>. (Ticket ID: 7708)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#library-transformation","title":"Library Transformation","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#operator-fft","title":"Operator <code>FFT</code>","text":"<ul> <li>Prior to fixing this issue, in the operator <code>FFT</code> it was possible to  set the parameter <code>LineLength</code> to <code>Static</code> although this mode is not supported and would result in a possible malfunction at runtime. This has been fixed. Now, the parameter <code>LineLength</code> is Dynamic-only. (Ticket ID: 9891)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#sdk","title":"SDK","text":"<ul> <li>There is a new, additional check box in the build settings dialog with which you can switch on and off automatic generation of SDK example after build flow. (Ticket ID: 8366)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#tcl-expert-feature","title":"Tcl (Expert Feature)","text":"<ul> <li>The behavior of the Tcl commands <code>DisconnectModules</code>, <code>CreateModule</code>, <code>Rename</code>, and <code>DeleteModule</code> has been changed. Prior to fixing this issue, the behavior of the commands differed from the equivalent actions triggered by user input in the GUI concerning update of the design status. This has been fixed. Now, the Tcl commands and the GUI actions behave consistently. (Ticket ID: 8231)</li> <li>The Tcl command <code>GetModuleProperty</code> has been extended so that a module name can be queried via the keyword <code>name</code>. (Ticket ID: 9729)</li> <li>Added new Tcl scripting command <code>SetModuleParamProperty</code>. This command may be used for setting parameter properties like access mode. This command may substitute the previous command <code>SetModuleParamType</code> and offers access to further properties like the position of a reference parameter of a hierarchical box. (Ticket ID: 9702)</li> <li>You can compare simulation results of the simulation probes via the Tcl command <code>GetSimImageData</code>. Prior to fixing this issue, <code>GetSimImageData</code> returned random results for images with differing line lengths. This meant that you could not compare different probes with the same content. This has been fixed. Now, <code>GetSimImageData</code> returns <code>0</code>  as value when data from undefined regions of a simulation result are queried. (Ticket ID: 9640)</li> <li>Extended the Tcl command <code>ChangePlatform</code> so that a list of available hardware platforms may be queried. (Ticket ID: 9548)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#embedded-visualapplets","title":"Embedded VisualApplets","text":"<ul> <li>In eVA Designer, an option was added to use Vivado design checkpoint files for the top-level netlist. (Ticket ID: 9802)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-0.html#miscellaneous","title":"Miscellaneous","text":"<ul> <li>The third-party libraries for accessing the Wibu CodeMeter license dongle have been updated to version 7.20. This improves the compatibility with other programs which also use CodeMeter for licensing. (Ticket ID: 5718)</li> <li>Handling of configuration files has been improved when installing VisualApplets with <code>Current User</code>. Prior to fixing this issue, VisualApplets did not work properly when starting it with a different user account than the one used during installation of VisualApplets. This has been fixed. (Ticket ID: 7353)</li> <li>Improved handling of changing link properties in a chain across hierarchies. Prior to fixing this issue, VisualApplets might have crashed when changing link properties in a chain across hierarchies while a Link Properties dialog for one link of this chain was open. This has been fixed. (Ticket ID: 9259)</li> <li>Calling microDisplay has been changed. You can now open new versions of microDisplay via the menu Tools -&gt; microDisplay (F5). The <code>microDisplayX.exe</code> of the runtime version, which is shown in the Project Info window, is then started when available. For older runtime versions which do not contain microDisplayX.exe, the legacy program microDisplay.exe is started. If several runtime versions are installed, the used version is determined by the environment variable <code>RUNTIME5</code>. Prior to fixing this issue, if several runtime versions were installed, the legacy program microDisplay.exe of the last installed runtime software was called. This has been fixed. (Ticket ID: 9850)</li> <li>Exporting some designs from marathon or ironman platform resulted in a Tcl script which caused errors during importing, in particular at the step setting the parameters of the output link after a camera operator. The reason was that the code for setting the link and the module parameters was created in wrong order, i.e. it was required to set camera module parameters first, then link parameters. This has been fixed. (Ticket ID: 7773)</li> <li>Applets for the platforms mE5-MA-VCL and mE5-MA-VCLx can now be built with Vivado 2020.2. Prior to fixing this issue, building applets for the platforms mE5-MA-VCL and mE5-MA-VCLx with Vivado 2020.2 led to an error message and the build was aborted. This has been fixed. (Ticket ID: 9848)</li> <li>Prior to fixing this issue, when converting designs from an Ironman to a Marathon platform, links to <code>CameraControl</code> modules were disconnected. This has been fixed. (Ticket ID: 6636)</li> <li>Fixed the command line parameter interpretation when calling VisualApplets with parameter <code>-compile</code>. Before, the provided .hap file path was ignored and the default path was used for output. (Ticket ID: 9916)</li> <li>Prior to fixing this issue, VisualApplets might have crashed when removing a hierarchical box that contained reference parameters from modules which were not located inside this hierarchical box. This has been fixed. (Ticket ID: 9454)</li> <li>Prior to fixing this issue, netlist generation during DRC2 sometimes led to a crash of Windows. This happened, when a large design was consuming the complete memory. This has been fixed. Now, DRC2 provides a Cancel button. Cancelling may prevent a crash of Windows when all available memory is consumed. (Ticket ID: 9736)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html","title":"Changes and Fixed Issues in VisualApplets 3.3.1","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#library-base","title":"Library Base","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#operator-castkernel","title":"Operator <code>CastKernel</code>","text":"<ul> <li>Prior to fixing this issue, when changing the input link parameters of a <code>CastKernel</code> operator, the operator could get into an invalid state which could not be resolved by adjusting the output link format. Also, the error notifications were confusing, because errors were reported for the input link instead of the output link. This has been fixed. Now, the operator accepts any input link format and automatically adjusts the output parallelism. Format errors caused by inappropriate kernel configuration at the output link are reported at the output link. (Ticket ID: 215077 and 229912)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#library-filter","title":"Library Filter","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#operator-firkernelnxm","title":"Operator <code>FIRkernelNxM</code>","text":"<p>The documentation for the operator <code>FIRkernelNxM</code> has been improved and now contains illustration of edge handling. Also, the calculation of the latency has been updated. (Ticket ID: 215181 and 217961)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#library-memory","title":"Library Memory","text":"<ul> <li>When converting a design containing a <code>RamLUT</code> or <code>FrameBufferRandomRead</code> operator to a hardware platform with a different memory layout, an error concerning internal parameters of the module could occur. This has been fixed. (Ticket ID: 224018 and 8708)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#library-hardware-platform","title":"Library Hardware Platform","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#operator-clhssinglecamera","title":"Operator <code>CLHSSingleCamera</code>","text":"<ul> <li>Prior to fixing this issue, when using the camera operator <code>CLHSSingleCamera</code> in designs for the platform mE5-MA-VF2, an error occurred during netlist generation. This has been fixed. (Ticket ID: 229896)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#library-synchronization","title":"Library Synchronization","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#operator-appendimage","title":"Operator <code>AppendImage</code>","text":"<ul> <li>Operator <code>AppendImage</code> did not work correctly in simulation when converting 2D input to 1D output if the top line of the input image was shorter than the bottom line. This has been fixed.(Ticket ID: 223684)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#operator-appendline","title":"Operator <code>AppendLine</code>","text":"<ul> <li>Prior to fixing this issue, when using the operator <code>AppendLine</code> in 1D mode at runtime, the parameter range for the parameter <code>AppendNumber</code> was calculated wrong. As a result in some cases the dynamic parameter <code>AppendNumber</code> did not work properly at runtime. This has been fixed. (Ticket ID: 236171)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#operator-insertimage","title":"Operator <code>InsertImage</code>","text":"<ul> <li>Prior to fixing this issue, in some cases changes of the max. image height or width at the input of the operator <code>InsertImage</code> were not immediately propagated to the output. This has been fixed. (Ticket ID: 233202)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#simulation","title":"Simulation","text":"<ul> <li>Prior to fixing this issue, when changing the display to Signed in the Simulation Source Viewer, the display changed only in the current image, but not in the Sequence Viewer or in the miniature display of the simulation source in the design. This has been fixed. (Ticket ID: 207731)</li> <li>Prior to fixing this issue, some designs where data is converted from 1D to 0D in the processing pipeline simulation didn't work any more when using the new line-by-line mode for 1D simulation. This has been fixed. (Ticket ID: 218377)</li> <li>Fixed issue in Image Histogram of Simulation Probe Viewer: Prior to fixing this issue, when signed mode was selected, in some cases the histogram statistics showed the wrong values after performing a single simulation step. This has been fixed. (Ticket ID: 218694)</li> <li>Prior to fixing this issue, when in an empty simulation probe Line Profile was opened and certain view properties were changed (e.g. the Signed checkbox), VisualApplets crashed. This has been fixed. (Ticket ID: 220074)</li> <li>Prior to fixing this issue, when the Simulation Probe Viewer was open during simulation and Line Profile was displayed, VisualApplets crashed. This has been fixed. (Ticket ID: 220296)</li> <li>Fixed issue with 1D simulation of operator <code>SYNC</code>: Prior to fixing this issue, when line-by-line simulation was not used, the operator <code>SYNC</code> terminated the simulation with an error when the simulated image height did not match the maximum image height of the input link <code>I000</code>. This has been fixed. (Ticket ID: 226041)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#documentation","title":"Documentation","text":"<ul> <li>Updated the table Which Xilinx Toolchain and Version for Which Frame Grabber Platform:<ul> <li>Corrected information regarding Webpack licenses for ironman platforms (not available)</li> <li>All platforms can be built with evaluation license (Ticket ID: 229909)</li> </ul> </li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#embedded-visualapplets-eva","title":"Embedded VisualApplets (eVA)","text":"<ul> <li>Prior to fixing this issue, when building a design with embedded VisualApplets, a build error could occur. This has been fixed. (Ticket ID: 233158)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-1.html#miscellaneous","title":"Miscellaneous","text":"<ul> <li>In the Xilinx ISE toolchain, netlist names are restricted to 255 characters. This can cause problems when building a design with deep hierarchies. Now, an error message occurs in the DRC2 when this limit is exceeded.(Ticket ID: 209388).</li> <li>Test images delivered with VisualApplets in the folder <code>\\&lt;VA_install_folder&gt;/Testimages</code> have been extended by samples for typical image processing tasks. (Ticket ID: 214792)</li> <li>Prior to fixing this issue, when building a design for platform microEnable 5 VF2, an error with error message \"Netlist generation failed due to an internal exception. Reason: general error\" could occur. This has been fixed. (Ticket ID: 221608)</li> <li>In the Help &gt; About dialog of VisualApplets, you can now select the version information and copy it to the clipboard. Please use this feature for providing version information when reporting problems with VisualApplets. (Ticket ID: 229899)</li> <li>Prior to fixing this issue, when converting a hierarchical box to a user library element and when the surrounding design contained parameter references to the hierarchical box, the converted box was displayed with a red error indicator. This has been fixed. (Ticket ID: 230420)</li> <li>Updated the generation process of SDK examples for applets. Now, the generated project files are compliant with Visual Studio 2010 and above. (Ticket ID: 234918)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html","title":"Changes and Fixed Issues in VisualApplets 3.3.2","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#library-base","title":"Library Base","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#operator-sampledn","title":"Operator <code>SampleDn</code>","text":"<ul> <li>Prior to fixing this issue, the <code>SampleDn</code> operator didn't work properly for 2-bit signed inputs. This has been fixed. (Ticket ID: 215638)</li> <li>Prior to fixing this issue, the operator <code>SampleDn</code> sometimes inserted an EOL (end of line) at the beginning of an image, which then led to shifting of the image content. This has been fixed. (Ticket ID: 235838)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#library-color","title":"Library Color","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#operator-colortransform","title":"Operator <code>ColorTransform</code>","text":"<ul> <li>The handling of value ranges for operator <code>ColorTransform</code> has been fixed so that now invalid values are correctly reported. The documentation has been updated to reflect the limitation that negative transformation coefficients can only be used when the input format is signed or the coefficient parameter is static. (Ticket ID: 251344)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#library-debugging","title":"Library Debugging","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#operator-imageflowcontrol","title":"Operator <code>ImageFlowControl</code>","text":"<ul> <li>The parameterization interface in the operator <code>ImageFlowControl</code> has been fixed. Before, the parallelism was not taken into account and setting the parameters <code>DummyFrameWidth</code> and <code>DummyFrameHeight</code> had no effect when image acquisition was stopped. This has been fixed. (Ticket ID 209391)</li> <li>Prior to fixing this issue, when setting the parameter <code>CounterWidth</code> to value <code>32 bits</code> in the operator <code>ImageFlowControl</code>, a build error occurred. This has been fixed. (Ticket ID: 217556)</li> <li>The synchronization rules for the optional output port <code>StatusO</code> of the operator <code>ImageFlowControl</code> have been fixed. Before, the operator was declared as infinite source. Now, the port is O-synchronous with port O. The documentation of the operator has been adapted accordingly. (Ticket ID: 217557)</li> <li>The delayed output of the frame end in the operator <code>ImageFlowControl</code> has been fixed. Before, the frame end was not emitted before the next input frame arrived. Now, the operator performs like the operator <code>ImageFifo</code> when no overflow situation occurs. (Ticket ID: 247826)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#library-filter","title":"Library Filter","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#operator-lineneighboursnx1","title":"Operator <code>LineNeighboursNx1</code>","text":"<ul> <li>The operator <code>LineNeighboursNx1</code> has been changed. Now, at the output link the value for kernel columns can't be changed accidentally anymore. (Ticket ID: 249802)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#library-parameters","title":"Library Parameters","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#operator-linkparamtranslator","title":"Operator <code>LinkParamTranslator</code>","text":"<ul> <li>Prior to fixing this issue, the operator <code>LinkParamTranslator</code> could get into an invalid state when connecting a link with invalid configuration. This has been fixed. (Ticket ID: 239837)</li> <li>Prior to fixing this issue, the operator <code>LinkParamTranslator</code> did not report errors correctly. For parameter errors an appropriate string was shown in the parameter <code>Status</code> but the operator did not go into an error state. This has been fixed. (Ticket ID: 239974)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#library-synchronization","title":"Library Synchronization","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#operator-cutimage","title":"Operator <code>CutImage</code>","text":"<ul> <li>In the operator <code>CutImage</code> the handling of the format at output port O has been changed. The format now follows the format of input I, including the setting for max. image height. If you need to set the maximum dimension to a different format i.e. when it is assured that images of smaller size will be emitted, then use the operator <code>SetDimension</code> after <code>CutImage</code>. (Ticket ID: 242688)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#simulation","title":"Simulation","text":"<ul> <li>The reaction time for canceling the simulation has been improved. In particular, this may drastically reduce the time for aborting a simulation when very large images are processed and simulation shall be stopped because of excessive duration of the simulation or when memory usage gets critically high. (Ticket ID: 234920)</li> <li>Prior to fixing this issue, VisualApplets crashed when you used images larger than 2 GB in a simulation. Now, an error message appears when you run the simulation with an image larger than 2 GByte. (Ticket ID: 240989)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#sdk-examples","title":"SDK Examples","text":"<ul> <li>SDK examples generated with VisualApplets for CXP and Gigabit Ethernet frame grabbers now don't generate code for camera initialization any more when no camera operator is present. This enables executing the generated SDK code when no camera is connected to the frame grabber. (Ticket ID: 239222)</li> <li>Prior to fixing this issue, redundant parameter access code was written into the generated SDK examples when parameters were transferred from other parameters via modules of the library Parameters. This led to redundant access of module parameters. This has been fixed. Now, when parameters are connected via operators of the library Parameters, only the code for the front-end access is written. (Ticket ID: 239454)</li> <li>Prior to fixing this issue, generated SDK examples always calculated the DMA buffer size in <code>int</code>. This led to buffer overflows for large images. This has been fixed. Now, the DMA buffer size is calculated with <code>size_t</code>. (Ticket ID: 248563)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#tcl-scripting","title":"Tcl Scripting","text":"<ul> <li>The Tcl command <code>SetModuleParam</code> has been fixed. Before, no propagation of parameter updates to the output link was performed when a field parameter was set. In earlier versions of VisualApplets in some cases this could result in an inconsistent parameterization of the design. This has been fixed. (Ticket ID: 236891)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-3-2.html#miscellaneous","title":"Miscellaneous","text":"<ul> <li>Prior to fixing this issue, when you selected a not linked operator for moving it to a hierarchical box with Move to Hierarchical Box and then canceled the Enter Inputs / Outputs dialog, the selected operator was lost. This has been fixed. (Ticket ID: 217555)</li> <li>Prior to fixing this issue, when opening the context menu of an operator in the Diagram Window, an additional mouse click could cause that the operator moved in an unintended way in the Diagram Window. This has been fixed. (Ticket ID: 218063)</li> <li>Prior to fixing this issue, unused GPO pins in VisualApplets designs for mE5 marathon platforms resulted in undefined output signal level of trigger output pins. This has been fixed. Due to this fix, the firmware versions increased. (Ticket ID: 221922)</li> <li>The precision for float field parameters has been increased when exporting a VisualApplets design as a script. Before, numbers were saved in a precision as displayed in the module properties dialog. This led to problems when the design was re-imported, because it was not identical to the original design. (Ticket ID: 236969)</li> <li>Prior to fixing this issue, VisualApplets sometimes crashed when a module was deleted that was referenced in a <code>LinkParamTranslator</code> module. This has been fixed. (Ticket ID: 240977)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html","title":"Changes and Fixed Issues in VisualApplets 3.4.0","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#gui","title":"GUI","text":"<ul> <li>Improved handling of zooming in diagram windows. The current zoom factor is now displayed. Zooming is now possible in the range between 10 % and 400 % and zoom factors are now optimized for typical scaling factors in Windows. (Ticket ID: 259340)</li> <li>Improved scaling of the GUI according to the Windows scaling settings. (Ticket ID: 263708)</li> <li>Extended means for handling images in comment boxes. Now, you can scale images in comment boxes via drag and drop or via size dialog. (Ticket ID: 255697)</li> <li>Updated the GUI framework to Qt 6.5.2.</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#accumulator-library","title":"Accumulator Library","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#histogram-operator","title":"<code>Histogram</code> Operator","text":"<ul> <li>Before fixing this issue, the <code>Histogram</code> operator sometimes caused an internal error in the design rules check 2. This has been fixed. (Ticket ID: 215194)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#base-library","title":"Base Library","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#selectroi-operator","title":"<code>SelectROI</code> Operator","text":"<ul> <li>Before fixing this issue, in very special cases it could happen that an output image started with an empty line or the last line was removed. This has been fixed. (Ticket ID: 287999)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#color-library","title":"Color Library","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#whitebalance-operator","title":"<code>WhiteBalance</code> Operator","text":"<ul> <li>The documentation has been corrected. Values in the Supported Link Format section were corrected. (Ticket ID: 215229)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#parameters-library","title":"Parameters Library","text":"<ul> <li>Before fixing this issue, when you deleted or renamed modules with parameters that were referenced in operators of the Parameters library, VisualApplets might have crashed. This has been fixed. (Ticket ID: 265970 and 265828)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#linkparamtranslator-operator","title":"<code>LinkParamTranslator</code> Operator","text":"<ul> <li>Before fixing this issue, the <code>LinkParamTranslator</code> operator could cause DRC errors which couldn't be resolved by changing design parameters. This has been fixed. (Ticket ID: 249298)</li> <li>Before fixing this issue, when writing an invalid value into the <code>WriteAction</code> parameter, the operator didn't display an error. This has been fixed. Now, the operator and the <code>WriteAction</code> parameter field in the Module Properties view are displayed in red, if you write an invalid value into this parameter. (Ticket ID: 265445)</li> <li>Before fixing this issue, when using the <code>LinkParamTranslator</code> operator it could happen that several DRC runs were required for the operator to propagate the link parameters properly. This situation occurred when changing a link parameter caused a change of other link parameters (e.g. when <code>MaxImageWidth</code> was adapted automatically after you have changed the parallelism). This has been fixed. (Ticket ID: 265987)</li> <li>Before fixing this issue, when writing an invalid value to the <code>Color Flavor</code> or <code>Color Format</code> link properties via the <code>LinkParamTranslator</code> operator, VisualApplets sometimes crashed. This has been fixed. (Ticket ID: 292299)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#floatparamtranslator-operator","title":"<code>FloatParamTranslator</code> Operator","text":"<ul> <li>Before fixing this issue, in the <code>FloatParamTranslator</code> and <code>FloatValue</code> operators incrementing and decrementing a value via the spin box arrows sometimes resulted in the value jumping to the maximum value. This has been fixed, the increment now properly takes into account the defined range and step size. (Ticket ID: 270215)</li> <li>Improved the error handling of range increments. Before, defining range increment with floating-point module parameters could lead to conflicts that weren't displayed. This has been fixed. Now, conflicts with range increments are displayed as warnings with tooltips and the conflicts also appear in DRC1. (Ticket ID: 271807)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#synchronization-library","title":"Synchronization Library","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#sync-operator","title":"<code>SYNC</code> Operator","text":"<ul> <li>Before fixing this issue, when the <code>SYNC</code> operator was configured in <code>SyncToMin</code> mode, the output frame wasn't terminated before all input frames were completed. This has been fixed. Now the operator only outputs the end-of-frame after one of the input ports has received an end-of-frame. (Ticket ID: 209386)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#user-libraries","title":"User Libraries","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#jpeg_color-user-library","title":"<code>JPEG_Color</code> User Library","text":"<ul> <li>Fixed elements of the <code>JPEG_Color</code> library. This fix resolves a loss of image quality in vertical direction. This solution was already included in update 2301 for VisualApplets 3.3.2.(Ticket ID: 256723)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#tcl","title":"Tcl","text":"<ul> <li>Now, Tcl export and import supports all available <code>Color Flavor</code> values in the link properties. Before, export and import of Tcl scripts couldn't handle the <code>Color Flavor</code> values <code>LAB</code>, <code>XYZ</code>, <code>HSL</code>, <code>HSV</code>, or <code>YCrCb</code> properly. (Ticket ID: 258727)</li> <li>Before fixing this issue, some text fields containing unicode characters weren't properly written to Tcl during the Tcl export. This led to problems when importing designs from Tcl, because the text was changed after the import. This has been fixed. (Ticket ID: 255019)</li> <li>Before fixing this issue, building designs with the Tcl console sometimes terminated with an error, because detecting Vivado took too long. This has been fixed. (Ticket ID: 272098)</li> <li>The InstUserLibOperator Tcl command now behaves like instantiating a user library element manually. Before, when instantiating a design with the Tcl InstUserLibOperator command, sometimes error indicators were displayed in the GUI, which vanished after design rules check 1. This has been fixed. (Ticket ID: 280260)</li> <li>Before fixing this issue, the Drc Tcl command sometimes returned an error whereas the design rules check only reported warnings. This has been fixed. (Ticket ID: 284291)</li> <li>Before fixing this issue, when building a design in the Tcl batch mode for certain Vivado versions or when running in Windows 11, the Precondition Check wasn't responding due to a Xilinx tool error. This has been fixed. Now VisualApplets detects this situation and continues with the build flow. (Ticket ID: 290581)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-0.html#miscellaneous","title":"Miscellaneous","text":"<ul> <li>Improved VisualApplets runtime components so applets load faster. (Ticket ID: 241826)</li> <li>When simulating the <code>JPEG_Encoder</code> operator now a warning message is generated when the maximum output size for encoded data is reached and further output data is clipped. (Ticket ID: 248308)</li> <li>In the Link Property dialog, fields for maximum image height and maximum image width have been deactivated for SIGNAL links as these values have no meaning for signals. (Ticket ID: 236459)</li> <li>Before fixing this issue, when an image had been selected, the Image Histogram view displayed the histogram of the previous image in the simulation probe. This has been fixed. The Image Historgram now always displays the histogram of the currently selected image. (Ticket ID: 264369)</li> <li>Updated the ImageMagick library. With the previous version it could happen that loading small images in *.tif format didn't work and the error message Image Magick library: Image format is not supported. Error code: -70002 opened up. (Ticket ID: 265278)</li> <li>Improved the Select Folder dialog, which opens up e.g. when defining paths in the System Settings. Before, for some installations of VisualApplets, the displayed folder structure only showed a small subset of the directories of the system. This has been fixed. (Ticket ID: 282851)</li> <li>Fixed detecting the Vivado version for Vivado 2023.1 and later. Before, although a proper installation of Vivado was detected, no version information was found. (Ticket ID: 285232)</li> <li>For some installations of the Vivado build environment, the precondition check terminated with the error message Error checking FPGA software. This has been fixed. (Ticket ID: 291935)</li> <li>Fixed FPGA resource estimation during DRC2. Before fixing this issue, for some operators such as <code>FIRkernelNxM</code>, <code>IF</code>, and <code>DynamicROI</code> the required resources were underestimated. (Ticket ID: 293050)</li> <li>Before fixing this issue, when during VisualApplets installation only one single hardware platform was selected, the installation was incomplete and applets could not be built with this VisualApplets installation. This has been fixed. (Ticket ID: 295891)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html","title":"Changes and Fixed Issues in VisualApplets 3.4.1","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#blob-library","title":"Blob Library","text":"<ul> <li>Before fixing this issue, irritations of the operators <code>Blob_Analysis_1D</code> and <code>Blob_Analysis_2D</code> have been observed. These irritations could get reproduced on different hardware platforms and were mainly related to invalid object features. This has been fixed. (Ticket ID 308514)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#blob_analysis_1d-operator","title":"<code>Blob_Analysis_1D</code> Operator","text":"<ul> <li>Before fixing this issue, VisualApplets crashed during line-by-line simulation of a design with the <code>Blob_Analysis_1D</code> operator when the blob label buffer defined by parameter <code>label_bits</code> wasn't large enough. This has been fixed. (Ticket ID: 298936)</li> <li>Fixed simulation of operator <code>Blob_Analysis_1D</code> in line-by-line mode. Before, it could happen that, depending on the shape, blobs were broken up into several pieces. (Ticket ID 307378)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#hardware-platform-library","title":"Hardware Platform Library","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#dmafrompc-operator","title":"<code>DmaFromPC</code> Operator","text":"<ul> <li>Before fixing this issue, designs with the <code>DmaFromPC</code> operator couldn't be built. This has been fixed. Now, you can build designs with the <code>DmaFromPC</code> operator. (Ticket ID: 299084)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#memory-library","title":"Memory Library","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#framebufferrandomread-operator-on-imaflex-cxp-12-quad","title":"<code>FrameBufferRandomRead</code> Operator on imaFlex CXP-12 Quad","text":"<ul> <li>Before fixing this issue, when the maximum frame size exceeded the available memory, a general processing error prevented the user to open a design that contained the <code>FrameBufferRandomRead</code> operator on imaFlex CXP-12 Quad. This has been fixed. (Ticket ID: 303832)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#imagebuffermultiroidyn-operator","title":"<code>ImageBufferMultiRoIDyn</code> Operator","text":"<ul> <li>The documentation of the <code>ImageBufferMultiRoIDyn</code> operator has been enhanced and the values for <code>Max. Img Width</code>and <code>Max. Img Height</code> have been corrected in the documentation. (Ticket ID: 306276)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#synchronization-library","title":"Synchronization Library","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#tximagelink-and-rximagelink-operators","title":"<code>TxImageLink</code> and <code>RxImageLink</code> Operators","text":"<ul> <li>Before fixing this issue, the <code>Channel_ID</code> parameter of the <code>TxImageLink</code> and <code>RxImageLink</code> operators could be set to <code>-1</code>, which is invalid and could cause undefined behavior. This has been fixed. Now, the <code>Channel_ID</code> parameter can't be set to a negative value anymore. (Ticket ID: 304345)</li> <li>Before fixing this issue, the <code>Channel_ID</code> parameter always jumped to the maximum value when it was set to any value via a <code>WriteAction</code> of the <code>IntParamTranslator</code> operator. This has been fixed. (Ticket ID: 305585)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#user-libraries","title":"User Libraries","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#imagebuffermultiroidyn-operator-in-imaflex_cxp12_tools-user-library","title":"<code>ImageBufferMultiRoIDyn</code> Operator in <code>imaFlex_CXP12_Tools</code> User Library","text":"<ul> <li>Before fixing this issue, the simulation of a design with the <code>ImageBufferMultiRoIDyn</code> operator of the <code>imaFlex_CXP12_Tools</code> user library failed when the <code>Max. Image Width</code> parameter of the coordinate input links was small. This has been fixed. (Ticket ID: 304068)</li> <li>Before fixing this issue, the <code>ImageBufferMultiRoIDyn</code> operator cut out incorrect regions, if the region didn't fit the granularity given by the parallelism. This has been fixed. (Ticket ID: 303031)</li> <li>The device resource index for RAM has been set to <code>-1</code> so that a free RAM resource is automatically assigned when synthesizing the module. (Ticket ID: 295452)</li> <li>Before fixing this issue, the library element could get into an invalid state after changing parameters of the input links. This has been fixed. (Ticket ID: 304273)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#imagebuffermultiroi-operator-in-imaflex_cxp12_tools-user-library","title":"<code>ImageBufferMultiRoI</code> Operator in <code>imaFlex_CXP12_Tools</code> User Library","text":"<ul> <li>The device resource index for RAM has been set to <code>-1</code> so that a free RAM resource is automatically assigned when synthesizing the module. (Ticket ID 295452)</li> <li>Before fixing this issue, the library element could get into an invalid state after changing parameters of the input links. This has been fixed. (Ticket ID: 304273)</li> <li>Before fixing this issue, some designs with the user library element <code>ImageBufferMultiRoI</code> for imaFlex could result in images with smaller width than configured due to incorrect handling of ROI information. This has been fixed. (Ticket ID: 309701)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#enhanced-netlist-synthesis-engine-for-imaflex-platforms","title":"Enhanced Netlist Synthesis Engine for imaFlex Platforms","text":"<ul> <li>If you build designs with long chains of operators that don't have register levels, VisualApplets automatically inserts pipeline registers. Before fixing this issue, VisualApplets crashed when you built such a design in Enhanced mode. This has been fixed. Now, VisualApplets doesn't crash anymore when you build such a design. (Ticket ID: 303808)</li> <li>Before fixing this issue, in some operation modes of certain operators, the Enhanced synthesis mode for building imaFlex applets caused the optimization step of Vivado to fail with the message that unresolved black box instances have been found. This has been fixed. (Ticket ID: 304130)</li> <li>Before fixing this issue, switching between Default and Enhanced synthesis mode led to crashes of VisualApplets. This has been fixed. (Ticket ID: 304269)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-4-1.html#miscellaneous","title":"Miscellaneous","text":"<ul> <li>Before fixing this issue, if Vivado 2024.1 was installed, VisualApplets might have freezed while detecting the Vivado version information from Vivado.exe. This has been fixed. VisualApplets 3.4.1 has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. (Ticket ID: 309714)</li> <li>Before fixing this issue, it could happen that the undo action did jump to an earlier edit step than the most recent one. This has been fixed. (Ticket ID: 297854)</li> <li>Before fixing this issue, for some imaFlex CXP-12 Quad frame grabber boards the configuration of GPIO extension boards failed. This has been fixed. Also, the firmware version of iF-CXP12-Q has been increased to 2.3.<sup>a</sup> (Ticket ID: 304897)</li> <li>Before fixing this issue, sometimes when converting a design from a .va file format to a .vad file format, dummy elements were generated into the design. This led to errors. This has been fixed. (Ticket ID: 306809)</li> <li>Before fixing this issue, when using backslashes in file path specifiers for operators which provide a path name parameter, it could happen that characters following the backslash were interpreted as escaped whitespace. This has been fixed. (Ticket ID: 306881)</li> <li>Before fixing this issue, when working with the .vad design file format or .val library file format, dummy modules that were created when operators weren't available (e.g. after converting the design to a changed hardware platform) didn't preserve the parameters of the originating module. This has been fixed. (Ticket ID: 304378)</li> <li>Before fixing this issue, when the system setting Paths for simulation source images in the category Design was set to anything other than the default value Absolute, and simulation probes were using images which couldn't be addressed by a relative path, then it could happen that VisualApplets design files were saved incorrectly so they couldn't be opened anymore. This has been fixed. This VisualApplets version also implements an autocorrection algorithm with which damaged *.vad files can be opened again. (Ticket ID: 310245)</li> </ul> <ol> <li> <p>Flashing the board anew isn't necessary, previous applets continue to work even after the firmware update.\u00a0\u21a9</p> </li> </ol>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-0.html","title":"Changes and Fixed Issues in VisualApplets 3.5.0","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-0.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-0.html#hardware-platform-library","title":"Hardware Platform Library","text":"<ul> <li>Before fixing this issue, when building a design containing the <code>CXPCameraMultiTap</code> operator with the netlist synthesis engine set to Enhanced, the camera discovery failed. This has been fixed. (Ticket ID: 313179)</li> <li>Before fixing this issue, the <code>CxpTxTrigger</code> operator couldn't handle trigger pulses that were only 1 to 5 cycles long. Small trigger pulses might have got lost. This has been fixed. (Ticket ID: 306596)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-0.html#memory-library","title":"Memory Library","text":"<ul> <li>In applets built with VisualApplets versions 3.4.0 and 3.4.1 it wasn't possible to modify the dynamic parameters XOffset and XLength of the <code>LineMemory</code> operator during runtime. This has been fixed. (Ticket ID: 312662)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-0.html#parameters-library","title":"Parameters Library","text":"<ul> <li>Before fixing this issue, any whitespace was removed in the <code>WriteAction</code> and <code>ReadAction</code> parameters. This caused errors when addressing parameter names with space characters. This has been fixed. (Ticket ID 307409)</li> <li>Before fixing this issue, when deleting modules of the Parameters library which used the <code>DisplayName</code> parameter, it could happen that the parameter list of the hierarchical box elements which displayed the parameter got incomplete. Sometimes this resulted in crashes of VisualApplets. This has been fixed. (Ticket ID: 310698)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-0.html#synchronization-library","title":"Synchronization Library","text":"<ul> <li>The implementation of the <code>PixelReplicator</code> operator has been improved to ease timing-closure during build. (Ticket ID: 308592)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-0.html#gui","title":"GUI","text":"<ul> <li>The FPGA Resource Estimation dialog now also displays the usage of Ultra RAM. (Ticket ID: 303612)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-0.html#simulation","title":"Simulation","text":"<ul> <li>Before fixing this issue, the horizontal axis of the Line Histogram in the Simulation Source Viewer didn't account for the fact that the link bit width could be smaller than the bit width of the loaded image file. Additionally, the histograms were generated for the entire image displayed in the viewer, rather than just the content within the crop rectangle of the image. This has now been fixed, so the histogram more accurately reflects the image that is put on the link. (Ticket ID: 307268)</li> <li>Before fixing this issue, the histogram data in the Simulation Probe viewer was not properly reset when the properties of the observed link had been changed. This could result in showing outdated histogram data after simulating a single step. This has been fixed. (Ticket ID: 310896)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-0.html#enhanced-netlist-synthesis-engine-for-imaflex-platforms","title":"Enhanced Netlist Synthesis Engine for imaFlex Platforms","text":"<ul> <li>The build time when building a design with the enhanced netlist synthesis engine has been reduced. (Ticket ID: 298929)</li> <li>Custom operators now support the memory interface for building applets with the enhanced netlist synthesis engine. (Ticket ID: 291352)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-0.html#miscellaneous","title":"Miscellaneous","text":"<ul> <li>Before fixing this issue, when you opened multiple instances of VisualApplets, the build settings configuration was read only for the first instance while the other instances only used the default build settings. This has been fixed. (Ticket ID: 309983)</li> <li>Before fixing this issue, valid paths in GenICam editors such as those used when editing <code>ReadAction</code> or <code>WriteAction</code> parameters in <code>Translate</code> operators could be incorrectly marked as invalid by a red underline in the editor. This issue has been fixed. Now, only actually invalid input is marked with a red underline. (Ticket ID: 301278)</li> <li>Before fixing this issue, the automatic update notification didn't work: You weren't notified automatically when a new version of VisualApplets was available. This has been fixed. The automatic update notification now works correctly. (Ticket ID: 311264)</li> <li>The default build settings for imaFlex CXP-12 Quad platform has been changed so that building timing-critical designs is now improved. (Ticket ID 313401)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-1.html","title":"Changes and Fixed Issues in VisualApplets 3.5.1","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-1.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-1.html#memory-library","title":"Memory Library","text":"<ul> <li>The <code>RamLUT</code> and <code>RamLUT(imaflex)</code> operators can now be partially initialized with init files of any size. Before, it wasn't possible to overwrite an arbitrary number of LUT entries in the <code>RamLUT</code>, because the init file content had to match the total number of LUT entries. This has been improved. (Ticket ID: 318214)</li> <li>Before fixing this issue, if the ROI width value was equal to the value of <code>Parallelism</code> for the <code>ImageBufferMultiRoiDyn</code> operator, the ROI wasn't read out as expected. Instead, the first pixel/line was repeated ROI height times. This has been fixed. (Ticket ID: 307592)</li> <li>The <code>FrameBufferRandomRead (imaFlex)</code> operator has been enhanced with the new <code>WritePriority</code> parameter. If this parameter ist set to <code>ENABLED</code>, the <code>FrameBufferRandomRead (imaFlex)</code> operator prioritizes writing over reading, but only while the temporary memory data rate is higher than the available bandwidth. (Ticket ID: 301069)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-1.html#parameters-library","title":"Parameters Library","text":"<ul> <li>Before fixing this issue, no error was shown when referencing a parameter with an inappropriate data type in a mathematical term, e.g., referencing a string parameter in a reference to a mathematical term. This has been fixed. Now, parameter translator operators check the data types that are referenced in mathematical terms. Only enumeration, integer or floating-point parameters can be referenced. Referencing other data types now lead to an error notification. (Ticket ID: 310819)</li> <li>Before fixing this issue, for some designs with operators from the Parameters library, a misleading error message was shown when loading the design from a *.vad file. For those cases, calling the DRC1 check fixed the error. This has been fixed. (Ticket ID: 314760)</li> <li>Before fixing this issue, in cases where parameter translator modules caused an infinite loop, VisualApplets could get into a freezing state. This has been fixed: Parameter translator operators have been made more robust against infinite loops. (Ticket ID: 316845)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-1.html#linkparamtranslator-operator","title":"<code>LinkParamTranslator</code> Operator","text":"<ul> <li>Before fixing this issue, it was possible to cause invalid link formats for the <code>LinkParamTranslator</code> operator, which were then propagated through the links in the design. In certain cases this caused crashes of VisualApplets. This has been fixed: Now, a control mechanism has been added to avoid invalid link formats for the <code>LinkParamTranslator</code> operator. Also, the error messages that appear when <code>LinkParamTranslator</code> isn't properly parameterized have been improved. (Ticket ID: 317019)</li> <li>Before fixing this issue, when using the <code>WriteAction</code> parameter of the <code>LinkParamTranslator</code> operator, it could happen that module parameters which had been set to <code>Write</code> didn't work as intended. They could get changed by input link properties instead of being frozen. This has been fixed. (Ticket ID: 318358)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-1.html#examples","title":"Examples","text":"<p>The Processing Examples have been extended with two new examples for Bayer demosaicing for a line scan camera with 10 bit and 12 bit BiColor Bayer patterns. The examples are also documented in the Tutorial and Examples:</p> <ul> <li>Bayer Demosaicing a Line Scan Camera with 10 Bit BiColor Bayer Pattern</li> <li>Bayer Demosaicing a Line Scan Camera with 12 Bit BiColor Bayer Pattern</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-1.html#simulation","title":"Simulation","text":"<ul> <li>Before fixing this issue, when switching between multiple images in the Simulation Probe Viewer and if one of these images was empty, a misleading error message \"Could not open the selected image\" was generated and the Display panel of the Simulation Probe Viewer didn't display anything for the empty image. This has been fixed. (Ticket ID: 316800)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-1.html#tcl-scripting","title":"Tcl Scripting","text":"<ul> <li>Before fixing this issue, when a design was exported to Tcl and it contained references to parameters of <code>LinkParamTranslator</code> modules, it could happen that this Tcl code couldn't be re-imported into VisualApplets. This has been fixed. (Ticket ID: 315689)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-5-1.html#miscellaneous","title":"Miscellaneous","text":"<ul> <li>When opening a design for an unknown platform, modules of unknown types (e.g., platform-specific operators such as <code>DmaToPC</code>) are displayed as dummy modules. When converting the design to a known platform, the dummy modules are replaced by known operators. Before fixing the issue, after the conversion process an unnecessary meta parameter called <code>Replaces</code> remained. This has been fixed. (Ticket ID: 318698)</li> <li>Before fixing this issue, the Help menu didn't open when selecting Help from the context menu of a simulation source or simulation probe. This has been fixed. (Ticket ID: 297853)</li> <li>Before fixing this issue, when a module was deleted while the Parameter Info view still had an active filter applied, VisualApplets sometimes crashed. This has been fixed. (Ticket ID: 316608)</li> <li>Before fixing this issue, elements sometimes disappeared in the Parameter Info view. This issue occurred when a filter was applied, and an element was clicked, followed by clicking another element. If the first element didn't directly match the filter but was displayed, because its parent module matched the filter, it would incorrectly disappear after the second click. This has been fixed. (Ticket ID: 312876)</li> <li>Before fixing this issue, if you built applets with Xilinx Vivado version 2024.2 or higher, the build flow may have failed because of crashes in Vivado. This has been fixed. (Ticket ID: 320463)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html","title":"Changes and Fixed Issues in VisualApplets 3.6.0","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#discontinuations","title":"Discontinuations","text":"<ul> <li>Removed support for building applets that run on 32-bit operating systems. (Ticket ID: 341023)</li> <li>Removed support for all mE4 platforms from VisualApplets: mE4VD1, mE4VD4, mE4VQ4, Pixelplant. (Ticket ID: 339805)</li> <li>Removed the diagram overview from the Project Info window. This feature became obsolete with recent improvements, the diagram windows now provide the best user experience for navigating large designs. (Ticket ID: 340796)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#accumulator-library","title":"Accumulator Library","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#modulocount-operator","title":"<code>ModuloCount</code> Operator","text":"<ul> <li>Improved the implementation of the <code>ModuloCount</code> operator to meet timing requirements at very high FPGA clock frequencies. (Ticket ID: 329840)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#base-library","title":"Base Library","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#selectroi-operator","title":"<code>SelectROI</code> Operator","text":"<ul> <li>Before fixing this issue, when simulating the operator <code>SelectROI</code>, the dummy values for <code>SelectROI</code> were wrongly set to <code>n/a</code>. This has now been corrected to use <code>0</code> instead, as specified in the documentation. (Ticket ID: 340554)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#splitparallel-operator","title":"<code>SplitParallel</code> Operator","text":"<ul> <li>Extended the operator <code>SplitParallel</code> so the output parallelism may be larger than <code>1</code>, as long as the input parallelism is a multiple of the number of output links. (Ticket ID: 214791)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#debugging-library","title":"Debugging Library","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#imageflowcontrol-operator","title":"<code>ImageFlowControl</code> Operator","text":"<ul> <li>Before fixing this issue, using the <code>ImageFlowControl</code> operator in dummy frame generation mode could result in a damaged frame as output. This happened after an overflow situation, when a series of dummy frames was emitted for compensating lost frames. This has been fixed. (Ticket ID: 248227)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#filter-library","title":"Filter Library","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#dilate-operator","title":"<code>DILATE</code> Operator","text":"<ul> <li>Before fixing this issue, the kernel coefficients were applied in mirrored order by the <code>DILATE</code> operator. This has been fixed. (Ticket ID: 267460)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#firoperatornxm-operator","title":"<code>FIRoperatorNxM</code> Operator","text":"<ul> <li>Extended the <code>FIRoperatorNxM</code> operator to allow the use of embedded ALU elements for arithmetic calculations. This option can be selected using the new operator parameter <code>ImplementationType</code>. (Ticket ID: 334371)</li> <li>Extended the <code>FIRoperatorNxM</code> operator to allow filter coefficients to be dynamic parameters that can be changed during runtime. (Ticket ID: 334374)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#hitormiss-operator","title":"<code>HitOrMiss</code> Operator","text":"<ul> <li>Added the option to use dynamic filter coefficients for the <code>HitOrMiss</code> operator. (Ticket ID: 338329)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#hardware-platform-library","title":"Hardware Platform Library","text":"<ul> <li>Added a description of dummy value generation to the documentation of the <code>CXPQuadCamera</code>, <code>CXPDualCamera</code> and <code>CXPSingleCamera</code> operators. (Ticket ID: 215214)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#cxpcamera-operator","title":"<code>CxpCamera</code> Operator","text":"<p>The camera interface has been refined for a stricter protocol alignment. As a result, when using the <code>CxpCamera</code> operator on imaFlex platforms, the image protocol defined at the output link must now match the protocol of the connected camera:</p> <ul> <li>If the image protocol is set to VALT_IMAGE2D, only area scan cameras are supported.</li> <li>If the image protocol is set to VALT_LINE1D, only line scan cameras are supported.</li> </ul> <p>Note</p> <p>If the image protocol doesn't match the camera type, the <code>CxpCamera</code> module may emit corrupted or invalid image data. This stricter enforcement may affect designs that previously worked in version 3.5.1 or earlier, where mismatches were tolerated.</p> <p>(Ticket ID: 343078)</p>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#memory-library","title":"Memory Library","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#framebuffermultiroidyn-operator","title":"<code>FrameBufferMultiRoiDyn</code> Operator","text":"<ul> <li>Added the <code>WritePriority</code> parameter, which enables a write priority mode for the <code>FrameBufferMultiRoiDyn</code> operator, similar to the existing functionality in the <code>LineBuffer</code> operator. (Ticket ID: 295852)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#ramlut-operator","title":"<code>RamLUT</code> Operator","text":"<ul> <li>Before fixing this issue, writing intialization data to the <code>RamLUT</code> operator during acquisition had no effect on imaFlex platforms. Configuring memory content was only possible when the acquisition was stopped. This has been fixed. Now, writing intialization data to the <code>RamLUT</code> operator during acquisition is possible again on imaFlex platforms. (Ticket ID: 319280)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#imagefifo-and-linememory-operators","title":"<code>ImageFifo</code> and <code>LineMemory</code> Operators","text":"<ul> <li>Before, when you wanted to use UltraRAM with the <code>ImageFifo</code> and <code>LineMemory</code> operators, the <code>FifoDepth</code> and <code>FrameWidth</code> parameters weren't allowed to exceed the value of 4096. This limitation has been removed. (Ticket IDs: 320356 and 322131)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#parameters-library","title":"Parameters Library","text":"<ul> <li>Before fixing this issue, the highlighting of braces in the editor for parameter translation terms, was broken. This problem has now been resolved. (Ticket ID: 329769)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#linkparamtranslator-operator","title":"<code>LinkParamTranslator</code> Operator","text":"<ul> <li>Before fixing this issue, VisualApplets could crash when the <code>WriteAction</code> for a <code>LinkParamTranslator</code> module tried to set the <code>Parallelism</code> parameter to <code>0</code>. This problem has now been resolved. (Ticket ID: 321740)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#synchronization-library","title":"Synchronization Library","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#pixelreplicator-operator","title":"<code>PixelReplicator</code> Operator","text":"<ul> <li>Before fixing this issue, when a <code>PixelReplicator</code> module reported an error, the error status would sometimes remain even after resolving the cause of the error. This has been fixed. (Ticket ID: 302650)</li> <li>Improved the implementation of the <code>PixelReplicator</code> operator to meet timing requirements at very high FPGA clock frequencies. (Ticket ID: 318453)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#examples","title":"Examples","text":"<ul> <li>Improved the examples for multi-tap handling on imaFlex platforms. The example for 4 CXP-12 links now uses DRAM memory more efficiently, resulting in higher data throughput. (Ticket ID: 321738)</li> <li>Improved the examples for <code>FrameBufferMultiRoiDyn</code> on imaFlex platforms to use the available memory bandwidth more efficiently. (Ticket ID: 321739)</li> <li>Improved the HDR examples to enhance understandability and facilitate reuse. (Ticket ID: 335648)</li> <li>Restructured the examples by integrating the imaFlex examples into the main folder. Additionally, the examples from the Advanced folder have been moved directly into the Processing folder. (Ticket ID: 333632)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-0.html#miscellaneous","title":"Miscellaneous","text":"<ul> <li>Hyperlinks can now be added to comment boxes. These hyperlinks can be either global URLs or links to files, with various options to define anchors for relative locations. You can edit hyperlinks using the context menu within the comment box text editor. (Ticket ID: 312065)</li> <li>Before fixing this issue, the Up button of the spin box for setting the FPGA clock frequency on imaFlex platforms via the GUI dialog had no effect. This problem has now been resolved. (Ticket ID: 340958)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-1.html","title":"Changes and Fixed Issues in VisualApplets 3.6.1","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-1.html#gui","title":"GUI","text":"<ul> <li>Tab and floating window titles now update immediately when a corresponding Hierarchical Box is renamed. (Ticket ID: 345318)</li> <li>Before fixing this issue, context menu entries in floating windows weren't properly enabled. When clicking on a module, link, or selection, some valid actions in the context menu appeared greyed out. This has been fixed. (Ticket ID: 349250)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-1.html#operators","title":"Operators","text":""},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-1.html#library-hardware-platform","title":"Library Hardware Platform","text":"<ul> <li>Before fixing this issue, the <code>TxTriggerPacketMode</code> parameter of the <code>CxpTxTrigger</code> operator stayed active even when multiple input ports were used. This caused errors with MCF files for storing the applet configuration at runtime. This has been fixed. (Ticket ID: 347507)</li> <li>Before fixing this issue, line scan cameras could no longer be used with the CxpCamera and CxpCameraMultiTap operators when the <code>Image Protocol</code> on the output link was set to <code>VALT_IMAGE2D</code>. This has been fixed. (Ticket ID: 343078)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-1.html#library-memory","title":"Library Memory","text":"<ul> <li>Before fixing this issue, designs with <code>LineMemory</code> or <code>ImageFifo</code> operators using UltraRAM may have caused a build error in Enhanced netlist synthesis mode . This has been fixed. (Ticket ID: 342336)</li> <li>Before fixing this issue, simulating the <code>FrameBufferMultiRoi</code> operator using ROIs with <code>XOffset</code> &gt; <code>0</code> showed black areas in the image. This has been fixed. (Ticket ID: 345327)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-1.html#library-parameters","title":"Library Parameters","text":"<ul> <li>Before fixing this issue, VisualApplets could crash when range terms in operators of the Parameters library caused circular references. This has been fixed. (Ticket ID: 329732)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-1.html#examples","title":"Examples","text":"<ul> <li>Before fixing this issue, the HDR examples incorrectly calculated exposure time in milliseconds instead of microseconds. This has been fixed. (Ticket ID: 342945)</li> <li>Before fixing this issue, the example designs JPEG_DualCXP6x2AreaGray.vad and JPEG_QuadCXP6x1AreaGray.vad for the mE5-MA-VCX-QP platform caused DRC errors. This has been fixed. (Ticket ID: 344392)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-1.html#python-scripting","title":"Python Scripting","text":"<ul> <li>VisualApplets can now also execute python scripts with the command line option <code>-file</code>. Before, this option did only work for Tcl scripts. (Ticket ID: 343946)</li> </ul>"},{"location":"changes-and-fixed-issues-in-visualapplets-3-6-1.html#miscellaneous","title":"Miscellaneous","text":"<ul> <li>Performance improvement when deleting big parts of a design. Before, modifying large designs in VisualApplets caused significant delays. VisualApplets has been optimized to improve performance during such operations. (Ticket ID: 315775)</li> <li>Before fixing this issue, VisualApplets could crash when checking for automatic updates at startup. This has been fixed. (Ticket ID: 342982)</li> <li>VisualApplets now prohibits building designs with Vivado 2025.1 and later as designs built with these versions don't work. (Ticket ID: 348084)</li> </ul>"},{"location":"creating-script-collections.html","title":"Creating Script Collections (Script Libraries)","text":"<p>VisualApplets offers the Script Collection feature, with which you can use the procedures in your scripts most conveniently directly from the VisualApplets GUI. VisualApplets supports Tcl scripts and Python scripts in the Script Collection.</p> <p>In a first step, you create a script collection that contains individual commands. You define each command to call a specific procedure in a specified Tcl or Python script.</p> <p>Afterwards, the individual commands are graphically available directly in the VisualApplets GUI and you can start them via mouse click or drag &amp; drop. This way, you can make use of your Tcl or Python procedures as library elements. When called, the commands are executed in the Scripting Console. If you open the Scripting Console, you can see how the command is carried out.</p> <p>In the pane Script Collection, you see which script collections are already available in your VisualApplets installation and which commands are contained in each collection.</p> <p>To open the Script Collection pane, open the Window menu, select Dock Windows and then Scripting Collection:</p> <p></p> <p>The Scrip Collection pane opens on the right side of the VisualApplets main window:</p> <p></p> <p>You can define a script collection in the following ways:</p> <ul> <li>Using the VisualApplets GUI, or</li> <li>Creating/editing an XML file that defines the script collection.</li> </ul> <p>Info</p> <p>VisualApplets supports script collections for scripts written in Python and in Tcl. The Scripting Console automatically switches to Python when using a Python script collection element and back to Tcl when the console has been set to Tcl.</p> <p>Info</p> <p>Storing all collection information in XML files allows you to use version control systems not only for the individual scripts, but also for the structure and content definitions of your script collections.</p>"},{"location":"creating-script-collections.html#structure-of-a-script-collection","title":"Structure of a Script Collection","text":"<p>Each script collection contains a number of commands (elements of the script collection).</p> <p>This is reflected in the GUI:</p> <p></p> <p>Each command points to one specific procedure within a specific script. When a command is carried out, the procedure it points to is called.</p> <p></p> <p>To define a script collection, you have to define:</p> <ul> <li>The name of the collection</li> <li>The commands contained in the collection</li> <li>Optionally: Some further information such as version number, description, etc.</li> <li>Optionally: A GUI icon representing the script collection.</li> <li>For each individual command:<ul> <li>Command name</li> <li>Tcl or Python file the command points to</li> <li>Tcl or Python procedure within this file the command points to</li> <li>Arguments that must be passed to the Tcl or Python procedure (the values required are prompted when starting a command from the GUI)</li> <li>Command mode (see Adding a Command to a Script Collection below)</li> <li>Optionally: Command scope (see Adding a Command to a Script Collection below)</li> <li>Optionally: Further information such as version number, description, etc.</li> <li>Optionally: A GUI icon representing the command (see Adding a Command to a Script Collection below). If you don't provide an icon file, a default icon is used in the GUI.</li> </ul> </li> </ul> <p>All listed information describing exactly one script collection is stored in one XML file.</p> <p>You can define multiple script collections.</p>"},{"location":"creating-script-collections.html#what-happens-beneath-the-gui","title":"What Happens Beneath the GUI?","text":"<p>In the background, a new XML file is created in the directory you specified for your collection-defining XML files (see Required Settings):</p> <p></p> <p>The file name is the same as the script collection name you have defined in the GUI. The XML file contains all information about the collection currently defined:</p> <p></p> <p>As you haven't specified any commands for your script collection yet, the &lt;Elements&gt; element is still empty.</p> <p>Info</p> <p>For creating new script collections, you can either use the GUI or create XML files from scratch. The results are the same. The GUI always displays the information defined in the XML files.</p>"},{"location":"creating-script-collections.html#command-options","title":"Command Options","text":"<p>When defining a command, you can define whether your command can be started via a button  (i.e. trigger mode) or via drag &amp; drop, which is indicated in the GUI by a hand icon . You can also add a button to the toolbar for your command.</p> <p>For commands set to trigger mode, you can define the command scope. In the command scope, you can limit the command to specific design elements (e.g. module or link) so that the command only applies to these elements.</p>"},{"location":"creating-script-collections.html#requirements","title":"Requirements","text":""},{"location":"creating-script-collections.html#file-requirements","title":"File Requirements","text":"<p>A script collection consists of the following files:</p> <ul> <li>An XML file that defines a script collection. The XML file contains the definition of the collection itself and the definitions of the commands contained in the collection.</li> <li>Tcl or Python files that contain the actual scripts. These files must meet the following requirements:<ul> <li>They're Tcl or Python scrips.</li> <li>The files contain only procedures. They don't contain any commands that are carried out when loading the script file.</li> <li>To avoid naming conflicts, for a command CMD_NAME, stick to the following naming conventions:<ul> <li>Command_CMD_NAME</li> </ul> </li> <li>Store the .tcl or .py file in the same directory as the collection file (*.xml) or in a subdirectory of it.</li> </ul> </li> <li>Optional: A PNG icon file for individual collection or command icons on the VA GUI. The PNG files need to meet the following requirements:<ul> <li>They must contain a square image.</li> <li>The minimum resolution is 16 x 16.</li> <li>Store the icon files in the same directory as the collection file (*.xml) or in a subdirectory of it. If you don't provide an icon file, a default icon is used to represent the command representation in the GUI.</li> </ul> </li> </ul> <p>Info</p> <p>All files required for a working script collection are plain text files. This allows you to store your script collection definitions in version control systems.</p>"},{"location":"creating-script-collections.html#required-settings","title":"Required Settings","text":"<p>You can specify the location of the script collection definition files (XML files) in Visual Applets. As you can define only one storage location for collection script files, Basler recommends to store all collection-defining XML files in the same directory.</p> <p>To set the path to your script collection directory:</p> <ol> <li>From the menu Settings, select System Settings.</li> <li>Select tab Paths.</li> <li>Under Script Collection, specify the path to the directory where you store the collection-defining XML files you want to use. The default setting is &lt;VA installation directory&gt;/ScriptCollection:</li> </ol> <p></p> <p>For each script collection you create via GUI, one XML file is written into the specified directory. If you add new collection-describing XML files to the directory or edit existing XML files stored there, you can make your changes visible in the VisualApplets GUI. To display your changes without re-starting VisualApplets, right-click into the Script Collection pane, and select Rescan Script Collection Directory.</p> <p></p>"},{"location":"creating-script-collections.html#creating-a-script-collection-via-the-gui","title":"Creating a Script Collection via the GUI","text":"<p>You can define script collections completely via the GUI, without touching the underlying XML files. The XML files are created and updated in the background. As soon as you have defined a collection and the contained commands, the collection is displayed in the VisualApplets GUI.</p>"},{"location":"creating-script-collections.html#creating-a-new-script-collection","title":"Creating a New Script Collection","text":"<p>To create a new script collection via graphical user interface:</p> <ol> <li>Right-click the Script Collection pane.</li> <li> <p>From the context menu, select Create New Script Collection.</p> <p></p> <p>A dialog opens.</p> </li> <li> <p>Enter a name for the new script collection and confirm with OK.</p> <p></p> <p>The new collection is displayed in the Script Collection pane:</p> <p></p> </li> </ol>"},{"location":"creating-script-collections.html#adding-a-command-to-a-script-collection","title":"Adding a Command to a Script Collection","text":"<p>To add commands to a script collection via GUI:</p> <ol> <li>Right-click the name of the script collection.</li> <li> <p>From the context menu, select Create Element.</p> <p></p> <p>A dialog opens for describing the command you want to add. The fields highlighted in red are mandatory:</p> <p></p> </li> <li> <p>Command Name (mandatory): Give a name to your command.</p> </li> <li>Version: You can provide version information for your command.</li> <li>Description: The description will be visible as tooltip information. Enter a description of the procedure the command will call.</li> <li>Icon File: If you want a specific command icon to be displayed in the Script Collection pane or in the toolbar, you can provide the path to an icon file here. You can set either an absolute path or a path relative to the collection file (*.xml). (See File Requirements for details). If you don't select an icon file, a default icon is used to represent your new command in the GUI.</li> <li> <p>Script File: Provide the path to and the name of the script that contains the procedure you want to be started via the command. You can define the path relative to the collection file (.xml). Alternatively, instead of defining a script file that contains the procedure the command is to call, you can enter a Tcl or Python procedure directly into the command. The Tcl or Python procedure defined directly in the command will be executed each time you call the command. If you prefer this option, leave the field Script File empty and provide the whole Tcl or Python procedure the command stands for under Command Call in the field Template.</p> <p></p> <p>If you try to carry out a command without selecting the design elements defined as command scope, the Invalid Scope message opens up:</p> <p></p> </li> <li> <p>Command Options: Define how you want the command to be started on the VisualApplets GUI. A command can be started either via clicking a button (trigger mode), or by drag &amp; drop into the design window (Drag &amp; Drop mode). If you use the trigger mode, you can add an additional button for the command in the toolbar of the program window and define under which conditions the command is carried out (scope).</p> <p></p> <ol> <li> <p>Trigger mode: To create a button that starts the command as soon as you click it, clear the Drag &amp; Drop field. The command will be displayed in the Script Collection pane with the Run button:</p> <p></p> <p>To start executing the command, click the Run button.</p> </li> <li> <p>Toolbar option (only trigger mode): To make the command available in the toolbar of VisualApplets: Check the Add to Toolbar option; this is only possible if you clear the Drag &amp; Drop checkbox. On the GUI, a new tool bar is created for the collection and the command icon is displayed:</p> <p></p> <p>Clicking at the command icon in the toolbar has the same effect as clicking the Run button. The text you entered under Description is then visible as tooltip in the toolbar:</p> <p></p> </li> <li> <p>Drag &amp; Drop mode: Select the Drag &amp; Drop checkbox, if you want to start execution via drag &amp; drop operation on the GUI. In this case, a hand icon is displayed in column Action:</p> <p></p> </li> </ol> </li> <li> <p>Define Command Scope (only available in trigger mode): If you want to limit the command to a specific design element in the design, select the Define Command Scope check box. This option is only available, if Drag &amp; Drop is disabled.</p> <p></p> <p>The following options are available:</p> <ul> <li>Module: You must select exactly one module to start this command.</li> <li>Link: You must select exactly one link to start this command.</li> <li>CommentBox: You must select exactly one comment box to start this command.</li> <li>SimModule: You must select exactly one simulation module to start this command.</li> <li>SingleSelect: You must select exactly one design element to start this command. It's not relevant which kind of element you select (module, link, \u2026).</li> <li>MultiSelect: You must select two or more design elements to start this command. It's not relevant which kind of elements you select (module, link, \u2026).</li> </ul> <p>You can combine these options: For example, if you combine the options Module and Link, the command is carried out if you select either exactly one module OR exactly one link. Combining SingleSelect and MultiSelect allows starting the command, if one ore more design elements are selected.</p> <p>The scope of a command (i.e., the scope of the Tcl procedure) is displayed in the Script Collection pane on the VA GUI:</p> <p></p> <p>If you try to carry out a command without selecting the design elements defined as command scope, the Invalid Scope message opens up:</p> <p></p> </li> <li> <p>Command Call: Define here how the command is called.</p> <p></p> <ol> <li>Template: Enter here the template for the command call. Typically, it starts with the name of the Tcl or Python procedure, followed by a list of parameters. The parameters are given as place holders, wrapped in %. For each place holder you define the according parameter in the list below. Follow the syntax of Tcl or Python commands. Alternatively, you can enter here a complete Tcl or Python console command line if you left field Script File above empty.</li> <li>Parameters: Define here the parameters used in the template. The order of the parameters listed here is of no consequence. Just ensure that the parameter names match the place holder names of the template. To add a new parameter to the command definition, click the  plus button.<ol> <li>Name: Provide a name for each parameter. Use the name you used for the argument that carries the value at command call.</li> <li>Type: Define the data type of the parameter. You can define parameters of type string, integer, or double.</li> <li>Mode: Define if your parameter contains a fix value or a variable, or a drop position. <code>dropX</code> and <code>dropY</code> provide the position where the mouse pointer was released during drop. Note that <code>dropX</code> and <code>dropY</code> are only available in Drag &amp; Drop mode. If you define the parameter as variable, you will be asked at starting the command to enter a value for the parameter.</li> <li>Default: Enter here a default value.</li> <li>Min/Max: Enter here the value range for the parameter.</li> <li>Inc: Enter here the step size within the value range.</li> </ol> </li> </ol> </li> </ol> <p>Example:</p> <p></p>"},{"location":"creating-script-collections.html#creating-a-script-collection-via-xml","title":"Creating a Script Collection via XML","text":"<p>You can define script collections completely in XML, without using the VisualApplets GUI.</p> <p>For each script collection, create one XML file.</p> <p>As soon as you have defined a collection and the contained commands in the XML file, the collection is displayed in the VisualApplets GUI. Prerequisite: You have specified the location of the XML files in the System Settings of VisualApplets, see Required Settings.</p> <p>All information regarding structure and content of a script collection is defined in one XML file per script collection. You can provide multiple XML files, each defining one script collection. If an XML file defining a script collection is located in the directory you specify in VisualApplets under menu Settings -&gt; System Settings -&gt; Paths -&gt; Script Collection, the script collection is displayed in the VisualApplets GUI in the Script Collection pane.</p>"},{"location":"creating-script-collections.html#examples","title":"Examples","text":"<p>VisualApplets provides the three example script collections DesignTools, LayoutAssist, and TclExamples. You find them as .xml file as well as as .tcl file in the directory &lt;VA installation directory&gt;/Examples/AdvancedVAFunctions/Script Collection.</p> <p>To display the example script collections in the GUI of VisualApplets:</p> <ol> <li> <p>Define the path to the folder where the example script collections are stored in Settings -&gt; System Settings -&gt; Paths.</p> <p></p> </li> <li> <p>Right-click into the Script Collection pane and select Rescan Script Collection Directory.</p> <p></p> <p>The GUI now displays the example script collections in the Script Collection pane:</p> <p></p> </li> <li> <p>You can now play around with the GUI options and the content of the XML files to see the impact of your actions.</p> </li> </ol> <p>This is how the example DesignTools.xml looks like:</p> <p></p>"},{"location":"creating-script-collections.html#syntax","title":"Syntax","text":"<p>The syntax of the XML file is the following:</p> <p></p> <p>Info</p> <p>Make sure you use the same name for the XML file name as in tag &lt;ScriptCollection&gt; of the XML file.</p> <p>Example:</p> <p>File name:</p> <p>myCollection.xml</p> <p>Collection name within XML file:</p> <p><code>&lt;ScriptCollection name =\"myCollection\" formatVersion=\"1.0\"&gt;</code>.</p> <p>The format is defined the in accordance to the following convention:</p> <ul> <li>Optional, individual elements are enclosed in square brackets [ ].</li> <li>Syntax elements that are allowed to be non-existent, to be there once or to be there multiple times, are enclosed in curly brackets { }.</li> <li>Syntax (..|..) indicates that one of the provided elements can be stated.</li> <li>Parameter values are stated in italic capital letters.</li> </ul>"},{"location":"creating-script-collections.html#the-tags-scope-and-toolbar","title":"The Tags &lt;Scope&gt; and &lt;Toolbar&gt;","text":"<p><code>&lt;Scope&gt;</code>:</p> <p>Use the tag &lt;Scope&gt;, if you want to limit the command to a specific design element in the design.</p> <p>This is an optional tag, allowed only when you set the command mode to <code>Trigger</code>. You can define &lt;Scope&gt; multiple times to specify multiple scopes. The tag isn't allowed when <code>Command mode</code> is set to <code>DragAndDrop</code>.</p> <p>The following options are available:</p> <ul> <li>Module: You must select exactly one module to start this command.</li> <li>Link: You must select exactly one link to start this command.</li> <li>CommentBox: You must select exactly one comment box to start this command.</li> <li>SimModule: You must select exactly one simulation module to start this command.</li> <li>SingleSelect: You must select exactly one design element to start this command. It's not relevant which kind of element you select (module, link, \u2026).</li> <li>MultiSelect: You must select two or more design elements to start this command. It's not relevant which kind of elements you select (module, link, \u2026).</li> </ul> <p>You can combine these options: For example, if you combine the options Module and Link, the command is carried out if you select either exactly one module OR exactly one link. Combining SingleSelect and MultiSelect allows starting the command, if one ore more design elements are selected.</p> <p>If you try to carry out a command without selecting the design elements defined as command scope, the Invalid Scope message opens up:</p> <p></p> <p><code>&lt;Toolbar&gt;</code>:</p> <p>Optional tag, allowed only when you set <code>Command mode</code> to <code>Trigger</code>. If you include the tag, the commando is added to the toolbar of the collection. The tag is not allowed when <code>Command mode</code> is set to <code>DragAndDrop</code>.</p>"},{"location":"creating-script-collections.html#parameters","title":"Parameters","text":"<p>You must write the following values into the parameters written in italic in the image above:</p> <ul> <li>COL_NAME: Name of the script collection.</li> <li>COL_PNG_FILE_PATH: Path to the icon file for the script collection (PNG format, for details see File Requirements). Specify the path relative to the XML file.</li> <li>COL_TOOLTIP_TEXT: Text displayed as tooltip describing the script collection.</li> <li>CMD_NAME: Name of command.</li> <li>CMD_TOOLTIP_TEXT: Text displayed as tooltip describing the command.</li> <li>CMD_VERSION: Command version in the format MAJOR.MINOR (for example, 1.0)</li> <li>TCL_FILE_PATH: Path to the Tcl script that contains the procedure you want to call when executing the command. Specify the path relative to the XML file.</li> <li>CMD_PNG_FILE_PATH: Icon file for the command (PNG format, for details see File Requirements). Specify the path relative to the XML file.</li> <li>CMD_CALL: Name of the procedure within the Tcl script (or whole Tcl procedure) that is called by the command.</li> <li>CMD_PARAM: Parameter names (arguments) that are substituted by actual values at command call. Only specify parameter names that are defined in the following  tags. <li>PAR_NAME: Parameter name.</li> <li>PAR_RANGE_FROM: Start of value range (only for data types int or double).</li> <li>PAR_RANGE_TO: End of value range (only for data types int or double).</li> <li>PAR_RANGE_INC: Step size within the value range (only for data types int or double).</li> <li>PAR_VALUE: Default value for the parameter.</li>"},{"location":"creating-script-collections.html#loading-the-script-collection-into-the-gui","title":"Loading the Script Collection into the GUI","text":"<p>For each script collection you create via GUI, one XML file is written into the directory you have specified under Settings \u2192 System Settings \u2192 Path. If you add new collection-describing XML files to the directory or edit existing XML files stored there, you can make your changes visible in the VisualApplets GUI. To display your changes without re-starting VisualApplets, right-click into the Script Collection pane, and select Rescan Script Collection Directory.</p> <p></p>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-0-3.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.0.3","text":"<p>To use applets designed with VisualApplets 3.0.3, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.0.3 incorporates the following firmware versions:</p> <ul> <li>LightBridge VCL: 1.4 (minimum runtime: 5.4.0)</li> <li>microEnable 5 marathon VF2: 1.6 (minimum runtime: 5.4.2)</li> <li>microEnable 5 marathon VCL: 1.4 (minimum runtime: 5.4.1)</li> <li>microEnable 5 ironman VQ8-CXP6D: 2.9 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VQ8-CXP6B: 2.9 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VD8-PoCL: 1.4 (minimum runtime: 5.4.0)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.0.3 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL: 1.4d (hex) (minimum runtime: 5.2.1)</li> <li>microEnable IV VD4-CL: 1.34 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VD4-PoCL: 1.34 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VQ4-GE: 1.89 (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> <li>microEnable IV VQ4-GPoE: 1.89 (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> </ul> <ol> <li> <p>When the applet contains triggers for action commands via firmware, runtime version 5.4.3 or higher is required.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-0-4.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.0.4","text":"<p>To use applets designed with VisualApplets 3.0.4, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.0.4 incorporates the following firmware versions:</p> <ul> <li>LightBridge VCL: 1.4 (minimum runtime: 5.4.0)</li> <li>microEnable 5 marathon VF2: 2.0 (minimum runtime: 5.4.2)</li> <li>microEnable 5 marathon VCL: 1.4 (minimum runtime: 5.4.1)</li> <li>microEnable 5 ironman VQ8-CXP6D: 2.9 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VQ8-CXP6B: 2.9 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VD8-PoCL: 1.4 (minimum runtime: 5.4.0)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.0.4 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL: 1.4d (hex) (minimum runtime: 5.2.1)</li> <li>microEnable IV VD4-CL: 1.34 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VD4-PoCL: 1.34 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VQ4-GE: 1.8a (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> <li>microEnable IV VQ4-GPoE: 1.8a (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> </ul> <ol> <li> <p>When the applet contains triggers for action commands via firmware, runtime version 5.4.3 or higher is required.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-0.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.0","text":"<p>To use applets designed with VisualApplets 3.0, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.0 incorporates the following firmware versions:</p> <ul> <li>LightBridge VCL: 1.1 (minimum runtime: 5.4.0)</li> <li>microEnable 5 marathon VCL: 1.1 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VQ8-CXP6D: 2.8 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VQ8-CXP6B: 2.9 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VD8-PoCL: 1.3 (minimum runtime: 5.4.0)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.0 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL: 1.4d (hex) (minimum runtime: 5.2.1)</li> <li>microEnable IV VD4-CL: 1.34 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VD4-PoCL: 1.34 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VQ4-GE: 1.89 (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> <li>microEnable IV VQ4-GPoE: 1.89 (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> </ul> <ol> <li> <p>When the applet contains triggers for action commands via firmware, runtime version 5.4.3 or higher is required.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-1-1.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.1","text":"<p>To use applets designed with VisualApplets 3.1, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.1 incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.1 (minimum runtime: 5.6)</li> <li>LightBridge 2 VCL: 1.8 (minimum runtime: 5.5.1)</li> <li>microEnable 5 marathon VCX-QP: 1.3 (minimum runtime: 5.5)</li> <li>microEnable 5 marathon VF2: 2.4 (minimum runtime: 5.4.2)</li> <li>microEnable 5 marathon VCL: 1.8 (minimum runtime: 5.4.1)</li> <li>microEnable 5 ironman VQ8-CXP6D: 2.11 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VD8-PoCL: 1.6 (minimum runtime: 5.4.0)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.1 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL: 1.4d (hex) (minimum runtime: 5.2.1)</li> <li>microEnable IV VD4-CL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VD4-PoCL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VQ4-GE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> <li>microEnable IV VQ4-GPoE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> </ul> <ol> <li> <p>When the applet contains triggers for action commands via firmware, runtime version 5.4.3 or higher is required.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-1-2.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.1.2","text":"<p>To use applets designed with VisualApplets 3.1.2, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.1.2 incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.1 (minimum runtime: 5.6)</li> <li>LightBridge 2 VCL: 1.8 (minimum runtime: 5.5.1)</li> <li>microEnable 5 marathon VCX-QP: 1.3 (minimum runtime: 5.5)</li> <li>microEnable 5 marathon VF2: 2.4 (minimum runtime: 5.4.2)</li> <li>microEnable 5 marathon VCL: 1.8 (minimum runtime: 5.4.1)</li> <li>microEnable 5 ironman VQ8-CXP6D: 2.11 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VD8-PoCL: 1.6 (minimum runtime: 5.4.0)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.1.2 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL: 1.4d (hex) (minimum runtime: 5.2.1)</li> <li>microEnable IV VD4-CL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VD4-PoCL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VQ4-GE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> <li>microEnable IV VQ4-GPoE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> </ul> <ol> <li> <p>When the applet contains triggers for action commands via firmware, runtime version 5.4.3 or higher is required.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-1.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.1.1","text":"<p>To use applets designed with VisualApplets 3.1.1, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.1.1 incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.1 (minimum runtime: 5.6)</li> <li>LightBridge 2 VCL: 1.8 (minimum runtime: 5.5.1)</li> <li>microEnable 5 marathon VCX-QP: 1.3 (minimum runtime: 5.5)</li> <li>microEnable 5 marathon VF2: 2.4 (minimum runtime: 5.4.2)</li> <li>microEnable 5 marathon VCL: 1.8 (minimum runtime: 5.4.1)</li> <li>microEnable 5 ironman VQ8-CXP6D: 2.11 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VD8-PoCL: 1.6 (minimum runtime: 5.4.0)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.1.1 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL: 1.4d (hex) (minimum runtime: 5.2.1)</li> <li>microEnable IV VD4-CL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VD4-PoCL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VQ4-GE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> <li>microEnable IV VQ4-GPoE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> </ul> <ol> <li> <p>When the applet contains triggers for action commands via firmware, runtime version 5.4.3 or higher is required.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-2-0.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.2.0","text":"<p>To use applets designed with VisualApplets 3.2.0, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.2.0 incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.2 (minimum runtime: 5.6)</li> <li>LightBridge 2 VCL: 1.9 (minimum runtime: 5.5.1)</li> <li>microEnable 5 marathon VCX-QP: 1.4 (minimum runtime: 5.5)</li> <li>microEnable 5 marathon VF2: 2.5 (minimum runtime: 5.4.2)</li> <li>microEnable 5 marathon VCL: 1.9 (minimum runtime: 5.4.1)</li> <li>microEnable 5 ironman VQ8-CXP6D: 2.11 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VD8-PoCL: 1.6 (minimum runtime: 5.4.0)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.2.0 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL: 1.4d (hex) (minimum runtime: 5.2.1)</li> <li>microEnable IV VD4-CL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VD4-PoCL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VQ4-GE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> <li>microEnable IV VQ4-GPoE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> </ul> <ol> <li> <p>When the applet contains triggers for action commands via firmware, runtime version 5.4.3 or higher is required.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-2-1.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.2.1","text":"<p>To use applets designed with VisualApplets 3.2.1, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.2.1 incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.2 (minimum runtime: 5.6)</li> <li>LightBridge 2 VCL: 1.9 (minimum runtime: 5.5.1)</li> <li>microEnable 5 marathon VCX-QP: 1.5 (minimum runtime: 5.5)</li> <li>microEnable 5 marathon VF2: 2.6 (minimum runtime: 5.4.2)</li> <li>microEnable 5 marathon VCL: 1.9 (minimum runtime: 5.4.1)</li> <li>microEnable 5 ironman VQ8-CXP6D: 2.11 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VD8-PoCL: 1.6 (minimum runtime: 5.4.0)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.2.1 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL: 1.4d (hex) (minimum runtime: 5.2.1)</li> <li>microEnable IV VD4-CL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VD4-PoCL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VQ4-GE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> <li>microEnable IV VQ4-GPoE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> </ul> <ol> <li> <p>When the applet contains triggers for action commands via firmware, runtime version 5.4.3 or higher is required.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-3-0.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.3.0","text":"<p>To use applets designed with VisualApplets 3.3.0, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.3.0 incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.3 (minimum runtime: 5.6)</li> <li>LightBridge 2 VCL: 1.10 (minimum runtime: 5.5.1)</li> <li>microEnable 5 marathon VCX-QP: 1.6 (minimum runtime: 5.5)</li> <li>microEnable 5 marathon VF2: 2.7 (minimum runtime: 5.4.2)</li> <li>microEnable 5 marathon VCL: 1.10 (minimum runtime: 5.4.1)</li> <li>microEnable 5 ironman VQ8-CXP6D: 2.11 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VD8-PoCL: 1.6 (minimum runtime: 5.4.0)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.3.0 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL: 1.4d (hex) (minimum runtime: 5.2.1)</li> <li>microEnable IV VD4-CL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VD4-PoCL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VQ4-GE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> <li>microEnable IV VQ4-GPoE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> </ul> <ol> <li> <p>When the applet contains triggers for action commands via firmware, runtime version 5.4.3 or higher is required.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-3-1.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.3.1","text":"<p>To use applets designed with VisualApplets 3.3.1, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.3.1 incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.3 (minimum runtime: 5.6)</li> <li>LightBridge 2 VCL: 1.10 (minimum runtime: 5.5.1)</li> <li>microEnable 5 marathon VCX-QP: 1.6 (minimum runtime: 5.5)</li> <li>microEnable 5 marathon VF2: 2.7 (minimum runtime: 5.4.2)</li> <li>microEnable 5 marathon VCL: 1.10 (minimum runtime: 5.4.1)</li> <li>microEnable 5 ironman VQ8-CXP6D: 2.11 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VD8-PoCL: 1.6 (minimum runtime: 5.4.0)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.3.1 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL: 1.4d (hex) (minimum runtime: 5.2.1)</li> <li>microEnable IV VD4-CL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VD4-PoCL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VQ4-GE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> <li>microEnable IV VQ4-GPoE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> </ul> <ol> <li> <p>When the applet contains triggers for action commands via firmware, runtime version 5.4.3 or higher is required.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-3-2.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.3.2","text":"<p>To use applets designed with VisualApplets 3.3.2, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.3.2 incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.4 (minimum runtime: 5.6)</li> <li>LightBridge 2 VCL: 1.11 (minimum runtime: 5.5.1)</li> <li>microEnable 5 marathon VCX-QP: 1.7 (minimum runtime: 5.5)</li> <li>microEnable 5 marathon VF2: 2.8 (minimum runtime: 5.4.2)</li> <li>microEnable 5 marathon VCL: 1.11 (minimum runtime: 5.4.1)</li> <li>microEnable 5 ironman VQ8-CXP6D: 2.11 (minimum runtime: 5.4.0)</li> <li>microEnable 5 ironman VD8-PoCL: 1.6 (minimum runtime: 5.4.0)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.3.2 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL: 1.4d (hex) (minimum runtime: 5.2.1)</li> <li>microEnable IV VD4-CL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VD4-PoCL: 1.35 (hex) (minimum runtime: 5.4.1)</li> <li>microEnable IV VQ4-GE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> <li>microEnable IV VQ4-GPoE: 1.8b (hex) (minimum runtime: 5.4.1<sup>a</sup>)</li> </ul> <ol> <li> <p>When the applet contains triggers for action commands via firmware, runtime version 5.4.3 or higher is required.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-4-0.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.4.0","text":"<p>To use applets designed with VisualApplets 3.4.0, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 6: In microEnable 6 applets, VisualApplets 3.4.0 incorporates the following firmware versions:</p> <ul> <li>microEnable 6 imaFlex CXP-12 Quad: 2.1 (minimum Framegrabber SDK version: 5.11.1)</li> </ul> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.4.0 incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.4 (minimum runtime: 5.7)</li> <li>microEnable 5 marathon VCX-QP: 1.7 (minimum runtime: 5.7)</li> <li>microEnable 5 marathon VCL: 1.11 (minimum runtime: 5.7)</li> <li>microEnable 5 marathon VF2<sup>a</sup>: 2.8 (minimum runtime: 5.7)</li> <li>LightBridge 2 VCL<sup>a</sup>: 1.11 (minimum runtime: 5.7)</li> <li>microEnable 5 ironman VQ8-CXP6D<sup>a</sup>: 2.11 (minimum runtime: 5.7)</li> <li>microEnable 5 ironman VD8-PoCL<sup>a</sup>: 1.6 (minimum runtime: 5.7)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.4.0 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL<sup>a</sup>: 1.4d (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VD4-CL<sup>a</sup>: 1.35 (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VD4-PoCL<sup>a</sup>: 1.35 (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VQ4-GE<sup>a</sup>: 1.8b (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VQ4-GPoE<sup>a</sup>: 1.8b (hex) (minimum runtime: 5.7)</li> </ul> <ol> <li> <p>This hardware is discontinued. See Basler Website - Discontinued Accessories for details on the discontinuation.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-4-1.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.4.1","text":"<p>To use applets designed with VisualApplets 3.4.1, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 6: In microEnable 6 applets, VisualApplets 3.4.1 incorporates the following firmware versions:microEnable 6 imaFlex CXP-12 Quad: 2.3 (minimum Framegrabber SDK version: 5.11.1)</p> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.4.1 incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.4 (minimum runtime: 5.7)</li> <li>microEnable 5 marathon VCX-QP: 1.7 (minimum runtime: 5.7)</li> <li>microEnable 5 marathon VCL: 1.11 (minimum runtime: 5.7)</li> <li>microEnable 5 marathon VF2<sup>a</sup>: 2.8 (minimum runtime: 5.7)</li> <li>LightBridge 2 VCL<sup>a</sup>: 1.11 (minimum runtime: 5.7)</li> <li>microEnable 5 ironman VQ8-CXP6D<sup>a</sup>: 2.11 (minimum runtime: 5.7)</li> <li>microEnable 5 ironman VD8-PoCL<sup>a</sup>: 1.6 (minimum runtime: 5.7)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.4.1 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL<sup>a</sup>: 1.4d (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VD4-CL<sup>a</sup>: 1.35 (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VD4-PoCL<sup>a</sup>: 1.35 (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VQ4-GE<sup>a</sup>: 1.8b (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VQ4-GPoE<sup>a</sup>: 1.8b (hex) (minimum runtime: 5.7)</li> </ul> <ol> <li> <p>This hardware is discontinued. See Basler Website - Discontinued Accessories for details on the discontinuation.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-5-0.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.5.0","text":"<p>To use applets designed with VisualApplets 3.5.0, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 6: In microEnable 6 applets, VisualApplets 3.5.0 incorporates the following firmware versions:</p> <ul> <li>microEnable 6 imaFlex CXP-12 Quad: 2.3 (minimum Framegrabber SDK version: 5.11.1)</li> <li>microEnable 6 imaFlex CXP-12 Penta: 1.0 (minimum Framegrabber SDK version: 5.11.3)</li> </ul> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.5.0 incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.4 (minimum runtime: 5.7)</li> <li>microEnable 5 marathon VCX-QP: 1.7 (minimum runtime: 5.7)</li> <li>microEnable 5 marathon VCL: 1.11 (minimum runtime: 5.7)</li> <li>microEnable 5 marathon VF2<sup>a</sup>: 2.8 (minimum runtime: 5.7)</li> <li>LightBridge 2 VCL<sup>a</sup>: 1.11 (minimum runtime: 5.7)</li> <li>microEnable 5 ironman VQ8-CXP6D<sup>a</sup>: 2.11 (minimum runtime: 5.7)</li> <li>microEnable 5 ironman VD8-PoCL<sup>a</sup>: 1.6 (minimum runtime: 5.7)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.5.0 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL<sup>a</sup>: 1.4d (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VD4-CL<sup>a</sup>: 1.35 (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VD4-PoCL<sup>a</sup>: 1.35 (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VQ4-GE<sup>a</sup>: 1.8b (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VQ4-GPoE<sup>a</sup>: 1.8b (hex) (minimum runtime: 5.7)</li> </ul> <ol> <li> <p>This hardware is discontinued. See Basler Website - Discontinued Accessories for details on the discontinuation.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-5-1.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.5.1","text":"<p>To use applets designed with VisualApplets 3.5.1, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 6: In microEnable 6 applets, VisualApplets 3.5.1 incorporates the following firmware versions:</p> <ul> <li>microEnable 6 imaFlex CXP-12 Quad: 2.3 (minimum Framegrabber SDK version: 5.11.1)</li> <li>microEnable 6 imaFlex CXP-12 Penta: 1.0 (minimum Framegrabber SDK version: 5.11.3)</li> </ul> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, VisualApplets 3.5.1 incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.4 (minimum runtime: 5.7)</li> <li>microEnable 5 marathon VCX-QP: 1.7 (minimum runtime: 5.7)</li> <li>microEnable 5 marathon VCL: 1.11 (minimum runtime: 5.7)</li> <li>microEnable 5 marathon VF2<sup>a</sup>: 2.8 (minimum runtime: 5.7)</li> <li>LightBridge 2 VCL<sup>a</sup>: 1.11 (minimum runtime: 5.7)</li> <li>microEnable 5 ironman VQ8-CXP6D<sup>a</sup>: 2.11 (minimum runtime: 5.7)</li> <li>microEnable 5 ironman VD8-PoCL<sup>a</sup>: 1.6 (minimum runtime: 5.7)</li> </ul> <p>microEnable IV: Designs developed with VisualApplets 3.5.0 should be used on mE IV frame grabbers together with the following firmware versions (or higher):</p> <ul> <li>microEnable IV VD1-CL<sup>a</sup>: 1.4d (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VD4-CL<sup>a</sup>: 1.35 (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VD4-PoCL<sup>a</sup>: 1.35 (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VQ4-GE<sup>a</sup>: 1.8b (hex) (minimum runtime: 5.7)</li> <li>microEnable IV VQ4-GPoE<sup>a</sup>: 1.8b (hex) (minimum runtime: 5.7)</li> </ul> <ol> <li> <p>This hardware is discontinued. See Basler Website - Discontinued Accessories for details on the discontinuation.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-6-0.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.6.0","text":"<p>To use applets designed with VisualApplets 3.6.0, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 6: In microEnable 6 applets, this version of VisualApplets incorporates the following firmware versions:</p> <ul> <li>microEnable 6 imaFlex CXP-12 Quad: 2.3 (minimum Framegrabber SDK version: 5.11.1)</li> <li>microEnable 6 imaFlex CXP-12 Penta: 1.0 (minimum Framegrabber SDK version: 5.11.3)</li> </ul> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, this version of VisualApplets incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.4 (minimum runtime: 5.9)</li> <li>microEnable 5 marathon VCX-QP: 1.7 (minimum runtime: 5.9)</li> <li>microEnable 5 marathon VCL: 1.11 (minimum runtime: 5.9)</li> <li>microEnable 5 marathon VF2<sup>a</sup>: 2.8 (minimum runtime: 5.9)</li> <li>LightBridge 2 VCL<sup>a</sup>: 1.11 (minimum runtime: 5.9)</li> <li>microEnable 5 ironman VQ8-CXP6D<sup>a</sup>: 2.11 (minimum runtime: 5.9)</li> <li>microEnable 5 ironman VD8-PoCL<sup>a</sup>: 1.6 (minimum runtime: 5.9)</li> </ul> <ol> <li> <p>This hardware is discontinued. See Basler Website - Discontinued Accessories for details on the discontinuation.\u00a0\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"firmware-versions-and-runtime-requirements-visualapplets-3-6-1.html","title":"Firmware Versions and Runtime Requirements VisualApplets 3.6.1","text":"<p>To use applets designed with VisualApplets 3.6.1, the minimum runtime version or higher (as specified below) must be installed on the target system.</p> <p>To use the latest VisualApplets features, make sure the latest runtime version is installed on the target system.</p> <p>For information since when a specific feature is supported, check the Release Notes for previous VisualApplets versions and the Release Notes for Framegrabber SDK.</p> <p>microEnable 6: In microEnable 6 applets, this version of VisualApplets incorporates the following firmware versions:</p> <ul> <li>microEnable 6 imaFlex CXP-12 Quad: 2.3 (minimum Framegrabber SDK version: 5.11.1)</li> <li>microEnable 6 imaFlex CXP-12 Penta: 1.0 (minimum Framegrabber SDK version: 5.11.3)</li> </ul> <p>microEnable 5 and LightBridge: In microEnable 5 and LightBridge applets, this version of VisualApplets incorporates the following firmware versions:</p> <ul> <li>microEnable 5 marathon VCLx: 1.4 (minimum runtime: 5.9)</li> <li>microEnable 5 marathon VCX-QP: 1.7 (minimum runtime: 5.9)</li> <li>microEnable 5 marathon VCL: 1.11 (minimum runtime: 5.9)</li> <li>microEnable 5 marathon VF2<sup>a</sup>: 2.8 (minimum runtime: 5.9)</li> <li>LightBridge 2 VCL<sup>a</sup>: 1.11 (minimum runtime: 5.9)</li> <li>microEnable 5 ironman VQ8-CXP6D<sup>a</sup>: 2.11 (minimum runtime: 5.9)</li> <li>microEnable 5 ironman VD8-PoCL<sup>a</sup>: 1.6 (minimum runtime: 5.9)</li> </ul> <ol> <li> <p>This hardware is discontinued. See Basler Website - Discontinued Accessories for details on the discontinuation.\u00a0\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"history.html","title":"History","text":""},{"location":"history.html#version-23-november-2025","title":"Version 23 (November 2025)","text":"<ul> <li>Updated VisualApplets documentation to VisualApplets version 3.6.1. For a complete list of changes, see the Release Notes 3.6.1.</li> </ul>"},{"location":"history.html#version-22-september-2025","title":"Version 22 (September 2025)","text":"<ul> <li>Added new entry for Known Issues: #345327.</li> <li>Fixed information about URAM in the Device Resources.</li> </ul>"},{"location":"history.html#version-21-july-2025","title":"Version 21 (July 2025)","text":"<ul> <li>Added three new entries for the release notes: #343078, #342982 #342945.</li> </ul>"},{"location":"history.html#version-20-july-2025","title":"Version 20 (July 2025)","text":"<ul> <li>Updated VisualApplets documentation to VisualApplets version 3.6.0. For a complete list of changes, see the Release Notes 3.6.0.</li> </ul>"},{"location":"history.html#version-19-march-2025","title":"Version 19 (March 2025)","text":"<ul> <li>Updated Management board in Legal Info.</li> </ul>"},{"location":"history.html#version-18-january-2025","title":"Version 18 (January 2025)","text":"<ul> <li>Removed snow and christmas image.</li> </ul>"},{"location":"history.html#version-17-december-2024","title":"Version 17 (December 2024)","text":"<ul> <li>Updated VisualApplets documentation to VisualApplets version 3.5.1. For a complete list of changes, see the Release Notes 3.5.1.</li> </ul>"},{"location":"history.html#version-16-october-2024","title":"Version 16 (October 2024)","text":"<ul> <li>Updated VisualApplets documentation to VisualApplets version 3.5.0. For a complete list of changes, see the Release Notes 3.5.0.</li> </ul>"},{"location":"history.html#version-15-july-2024","title":"Version 15 (July 2024)","text":"<ul> <li>Added entry for Known Issues VisualApplets 3.4.0 entry about missing automatic update notification.</li> </ul>"},{"location":"history.html#version-14-july-2024","title":"Version 14 (July 2024)","text":"<ul> <li>Updated VisualApplets documentation to VisualApplets version 3.4.1. For a complete list of changes, see the Release Notes 3.4.1.</li> </ul>"},{"location":"history.html#version-13-march-2024","title":"Version 13 (March 2024)","text":"<ul> <li>Added Known Issues entry about too low resource estimation for mE5 and imaFlex platforms.</li> </ul>"},{"location":"history.html#version-12-march-2024","title":"Version 12 (March 2024)","text":"<ul> <li>Fixed missing images in Synchronization Library.</li> </ul>"},{"location":"history.html#version-11-january-2024","title":"Version 11 (January 2024)","text":"<ul> <li>Updated VisualApplets documentation to VisualApplets version 3.4.0. For a complete list of changes, see the Release Notes 3.4.0.</li> </ul>"},{"location":"history.html#version-10-december-2023","title":"Version 10 (December 2023)","text":"<ul> <li>Fixed a misformatted list in topic Tcl Command Reference.</li> </ul>"},{"location":"history.html#version-09-june-2023","title":"Version 09 (June 2023)","text":"<ul> <li>Added missing images in the Operator Reference.</li> </ul>"},{"location":"history.html#version-08-october-2022","title":"Version 08 (October 2022)","text":"<ul> <li>Updated VisualApplets documentation to VisualApplets version 3.3.2. For a complete list of changes, see the Release Notes.</li> </ul>"},{"location":"history.html#version-07-may-2022","title":"Version 07 (May 2022)","text":"<ul> <li>Added notice for new installer of Visual Applets to Release Notes for VisualApplets 3.3.1 and to Known Issues VisualApplets Release 3.3.1.</li> <li>Updated PDF of VisualApplets User Documentation with updated links.</li> <li>Updated Installing the Xilinx Toolchain.</li> </ul>"},{"location":"history.html#version-06-april-2022","title":"Version 06 (April 2022)","text":"<ul> <li>Updated VisualApplets documentation to VisualApplets version 3.3.1. For a complete list of changes, see the Release Notes.</li> </ul>"},{"location":"history.html#version-05-january-2022","title":"Version 05 (January 2022)","text":"<ul> <li>Updated the \"Which Xilinx Toolchain and Version for Which Frame Grabber Platform\" table in the Installing VisualApplets topic:<ul> <li>Added mE4 platforms</li> <li>Corrected information regarding Webpack licenses for ironman platforms</li> <li>All platforms can be built with evaluation license</li> </ul> </li> </ul>"},{"location":"history.html#version-04-november-2021","title":"Version 04 (November 2021)","text":"<ul> <li>Added the Application Note: Shared Memory topic.</li> </ul>"},{"location":"history.html#version-03-october-2021","title":"Version 03 (October 2021)","text":"<ul> <li>Revised the Installing VisualApplets topic.</li> <li>Removed the following discontinued products from the documentation:<ul> <li>microEnable IV AQ4-GE</li> <li>microEnable IV AQ4-GPoE</li> <li>microEnable IV VQ4-GE</li> <li>microEnable IV VQ4-GPoE</li> </ul> </li> </ul>"},{"location":"history.html#version-02-august-2021","title":"Version 02 (August 2021)","text":"<ul> <li>Updated VisualApplets documentation to VisualApplets version 3.3.0.</li> <li>Adapted VisualApplets documentation further to Basler's documentation style.</li> </ul>"},{"location":"history.html#version-01-february-2021","title":"Version 01 (February 2021)","text":"<p>Initial version of this documentation.</p> <p>Content is based on the \"VisualApplets\" topic of the Basler Product Documentation (AW001406), version 45, with the following changes:</p> <ul> <li>Updated design and wording in line with Basler's documentation style.</li> </ul>"},{"location":"installing-visualapplets.html","title":"Installing VisualApplets","text":""},{"location":"installing-visualapplets.html#software-requirements","title":"Software Requirements","text":"<p>VisualApplets and some additional software needs to be installed on the PC that you use for applet development. This is typically another PC than the PC that you use as the host PC within your image processing application.</p> <p></p> <p>You need to install the following software on the PC that you want to use for applet development:</p> <p>The actual VisualApplets program (comes as an *.exe installer file)</p> <ol> <li>VisualApplets IDE license (on USB dongle)</li> <li>Xilinx Design Suite (ISE or Vivado), required for building the applet</li> <li>C++ Compiler (required for compiling the SDK examples)</li> <li>Framegrabber SDK software</li> </ol>"},{"location":"installing-visualapplets.html#system-requirements-for-visualapplets","title":"System Requirements for VisualApplets","text":"<p>The system requirements might differ from VisualApplets version to version, therefore the system requirements are available in the Release Notes.</p>"},{"location":"installing-visualapplets.html#installing-visualapplets-step-by-step","title":"Installing VisualApplets Step-by-Step","text":"<p>For installing VisualApplets, you have to take the following steps (which are described in the sections below):</p> <ul> <li>Install the VisualApplets software</li> <li>Install the required Xilinx tools</li> <li>Configure VisualApplets for accessing the Xilinx tools during Build</li> </ul> <p>Please note: To install the VisualApplets Software:</p> <ol> <li> <p>Run the installer that comes with the VisualApplets DVD or execute the VisualApplets installation file VAsetup3.x.exe by double-clicking the program icon.</p> <p>The Select Setup Install Mode dialog opens up:</p> <p></p> <ul> <li>If you do not have administrator rights on your PC, select Install for me only. As a consequence, you do not have the option All users in the Select Additional Tasks dialog (see step 8) and you cannot install VisualApplets under <code>C:\\Program Files</code>.</li> <li>If you do have administrator rights, you can select Install for all users (recommended).</li> </ul> </li> <li> <p>The Select Setup Language dialog opens up:</p> <p></p> <p>Select the desired language for the setup wizard and confirm with OK.</p> </li> <li> <p>The Legal Disclaimer - Disclaimer for using OpenSSL dialog opens up.</p> <p></p> <p>In this dialog you must accept the legal terms and conditions of using cryptographic software, like OpenSSL, to enable Basler's version control tool. This tool will create an SSL/TLS secured connection to the Basler server. As the export and use of cryptographic software is illegal in some countries, make sure that you don't act against local law when accepting these terms. If you are unsure, click Decline.</p> <ul> <li> <p>If you select Accept and click Next, you are allowed to use the Update feature, which allows you to check on new VisualApplets versions via mouse click (GUI: menu Help &gt; Check for Updates), or to configure VisualApplets to automatically check for newer VisualApplets versions at each program start (GUI: menu Settings &gt; System Settings &gt; Common &gt; Updates). Two OpenSSL libraries are then downloaded that are used to open a SSL/TLS secured connection to the Basler server.</p> <p>Info</p> <p>To use the update feature, make sure you have:</p> <ul> <li>a working internet connection</li> <li>an appropriate firewall exception.</li> </ul> </li> </ul> <p></p> <p>If you accept the use of OpenSSL, the installer immediately checks if a newer version than the one you are about to install is available.</p> <ul> <li>If you are already installing the latest version, you get an according message. Click Next to proceed.<ul> <li>If a newer VisualApplets version is available, you can decide if you want to<ul> <li>switch to installing this newer version (by clicking one of the links), or</li> <li>proceed installing the version of the installer you just started (by clicking Skip).</li> </ul> </li> </ul> </li> </ul> <p>If you decide to install the newer version, the according installer is downloaded and started automatically.</p> <ul> <li>If you select Decline and click Next, Basler's version control tool is not enabled.</li> </ul> </li> <li> <p>The License Agreement dialog opens up with the VisualApplets End User License Agreement (EULA).</p> <p></p> <p>To continue the set-up, you must select I accept the agreement and click Next.</p> </li> <li> <p>The Select Destination Location dialog opens up.</p> <p></p> <p>Select the directory in which you want to install VisualApplets.</p> <p>Click Next.</p> </li> <li> <p>The Select Components dialog opens up. Select the installation components by predefined installation profiles:</p> <p></p> <ul> <li>You can simply use the Full installation profile.</li> <li>If you want to reduce the volume of the installation:<ol> <li>Select the Custom installation profile.</li> <li>Under Hardware platform, clear the support for all platforms you are not planning to write applets for.</li> <li>Under Target operating systems for applets, clear all operating systems that you know will never be used on the host PCs of the image processing systems you are writing the applets for (Windows 32bit, Windows 64bit, Linux 32bit, or Linux 64bit).</li> </ol> </li> </ul> <p></p> <p>Info</p> <p>LightBridge 2 is a Thunderbolt certified product. This certification is for Windows operating systems only. Nevertheless, as support for Thunderbolt is given in the latest kernels from kernel.org, Lightbridge 2 may operate in a Linux environment. This is at your own risk, as no support for Linux is given at the moment.</p> <p>Info</p> <p>The installation of the Microsoft Visual Studio Redistribution Package is mandatory. If you want to receive automatic updates for the Microsoft Visual Studio Redistribution Package, activate the option Receive update for other Microsoft products when you update Windows in your Windows settings under Windows &gt; Settings &gt; Update &amp; Security &gt; Windows Update &gt; Advanced options.</p> </li> <li> <p>The Select Start Menu Folder dialog opens up. Define a name for the group in the Start Menu folder:</p> <p></p> <p>Click Next.</p> </li> <li> <p>The Select Additional Tasks dialog opens up. Select further installation options:</p> <p></p> <p>Options:</p> <ul> <li>All users/Current user: The file VisualApplets.ini will be written into the corresponding windows folder All Users or Current User, considering the windows system user accounts. The option All users is only available, if you selected the option Install for all users (recommended) in the set-up dialog Select Setup Install Mode (see step 1).</li> <li>Portable: All program and configuration data is written into the VisualApplets installation folder.</li> <li>If you want to have an icon of VisualApplets on your desktop, check the box Create a desktop shortcut.</li> </ul> </li> <li> <p>Confirm with Next.     Your complete installation profile is listed:</p> <p></p> <ul> <li>If you want to edit the list, use the Back button to change the settings in the according dialog windows.</li> <li>To start the installation, click the Install button. The progress bar displays the status of the current installation:</li> </ul> <p></p> <p>The installation is completed when the following screen appears:</p> <p></p> </li> <li> <p>Click Finish.</p> </li> </ol>"},{"location":"installing-visualapplets.html#installing-the-xilinx-toolchain","title":"Installing the Xilinx Toolchain","text":"<p>Before you can build your designs created in VisualApplets, i.e., before you can create hardware applets for your device, you need to install the Xilinx ISE or Xilinx Vivado toolchain.</p> <p>Which tool and which tool version you need (and if the according license is free or not) depends on the target frame grabber you are developing for.</p> <p>In addition, in most cases a 30-day evaluation license is available.</p> <p>The table below lists all Basler target hardware and the required Xilinx ISE and/or Vivado licenses.</p> <p>For building designs for mE5 marathon frame grabbers, Basler strongly recommends to use Xilinx Vivado. Using Xilinx Vivado, the build process is much faster, and more complex designs can be fitted on the FPGA.</p> <p>Info</p> <p>Make sure you install the Xilinx toolchain in a directory structure that does not contain any spaces in directory names, e.g., directly under <code>C:\\Xilinx</code>. Do not install Xilinx under <code>C:\\Program Files\\Xilinx</code>.</p>"},{"location":"installing-visualapplets.html#which-xilinx-toolchain-and-version-for-which-frame-grabber-platform","title":"Which Xilinx Toolchain and Version for Which Frame Grabber Platform?","text":"Current Basler Frame Grabber Models WebPACK / Vivado ML Standard (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup><sup>b</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE5 marathon VCX-QP ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> mE5 marathon VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> mE5 marathon VCLx Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> imaFlex CXP-12 Quad ISE is not supportedVivado version 2023.2<sup>d</sup><sup>e</sup><sup>f</sup> Version 2023.2<sup>d</sup><sup>e</sup><sup>f</sup> imaFlex CXP-12 Penta ISE is not supportedVivado version 2023.2<sup>d</sup><sup>e</sup><sup>f</sup> Version 2023.2<sup>d</sup><sup>e</sup><sup>f</sup> Legacy Basler Frame Grabber Models WebPACK / Vivado ML Standard (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup><sup>b</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE5 ironman VQ8 CXP6-D Version 14.7 mE5 ironman VD8-PoCL Version 14.7 mE5 marathon VF2 ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> LightBridge VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> <ol> <li> <p>A free, 30-days evaluation license is available.\u00a0\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Xilinx ISE officially doesn't support Windows 11. If your platform needs to be built with Xilinx ISE, install VisualApplets on a Windows 10 operating system. In this forum discussion you find some hacks how to install ISE under Windows 11 anyways, even though this is officially not supported.\u00a0\u21a9\u21a9</p> </li> <li> <p>Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1., see Known Issues VisualApplets Release 3.4.1, entry with ticket ID 217879 in General section.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Vivado version 2024.1 might lead to freezes of VisualApplets version 3.4.0 or lower. In VisualApplets version 3.4.1 this has been fixed. However, this VisualApplets version has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. See also Known Issues VisualApplets 3.4.0 and Changes and Fixes VisualApplets 3.4.1.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Vivado version 2024.2 might lead to crashes of VisualApplets version 3.5.0 or lower. In VisualApplets version 3.5.1 this has been fixed. However, this VisualApplets version has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. See also Known Issues VisualApplets 3.5.0 and Changes and Fixes VisualApplets 3.5.1.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>VisualApplets prohibits building designs with Vivado 2025.1 and later as designs built with these versions don't work. See also Changes and Fixed Issues in VisualApplets 3.6.1 and Changes and Fixes VisualApplets 3.4.1.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"installing-visualapplets.html#downloading-the-xilinx-toolchain","title":"Downloading the Xilinx Toolchain","text":"<p>Select which package you want to install and download it from the Xilinx website.</p> <p></p>"},{"location":"installing-visualapplets.html#obtaining-a-license-for-the-xilinx-toolchain","title":"Obtaining a License for the Xilinx Toolchain","text":""},{"location":"installing-visualapplets.html#30-day-evaluation-license","title":"30-Day Evaluation License","text":"<p>You can obtain a 30-day evaluation license from the Xilinx Licensing Solution Center.</p>"},{"location":"installing-visualapplets.html#webpack","title":"WebPACK","text":"<p>WebPACK is a free license. Applets for most frame grabbers can be built with a WebPACK license (see  Which Xilinx Toolchain and Version for Which Frame Grabber Platform?).</p>"},{"location":"installing-visualapplets.html#purchased-license","title":"Purchased License","text":"<p>You can obtain a license for purchased products as described at the Xilinx Licensing Solution Center.</p> <p>Info</p> <p>The Xilinx ISE Design Suite is the predecessor of the Xilinx Vivado Design Suite. ISE is distributed by Xilinx together with Vivado, so that if you purchase a Vivado Design Suite license, ISE is automatically licensed, too.</p>"},{"location":"installing-visualapplets.html#generating-and-registering-the-license","title":"Generating and Registering the License","text":"<p>To use the Xilinx toolchain, you must generate and register your license on the Xilinx Licensing Solution Center. Xilinx provides instructions for generating a license key and installing the license:</p> <ul> <li>Vivado Design Suite User Guide: Release Notes, Installation, and Licensing</li> <li>ISE Design Suite 14: Release Notes, Installation, and Licensing</li> </ul>"},{"location":"installing-visualapplets.html#configuring-build-settings-in-visualapplets-for-the-xilinx-toolchain-as-build-tool","title":"Configuring Build Settings in VisualApplets for the Xilinx Toolchain as Build Tool","text":"<p>Before you build your first applet with the Xilinx toolchain, you should configure the VisualApplets Build Settings so that the tools are called as desired. Instructions for setting the build settings are available in the VisualApplets User's Guide.</p>"},{"location":"installing-visualapplets.html#installing-the-framegrabber-sdk","title":"Installing the Framegrabber SDK","text":"<p>The Framegrabber SDK needs to be installed on the host PC in order to run VisualApplets.</p> <p>Minimum Framegrabber SDK version for using VisualApplets: version 5.11.1 for the imaFlex platform, and 5.9 for all other platforms.</p> <p>Info</p> <p>Basler recommends you uninstall all Framegrabber SDK installations on your PC before you start installing the current version.</p> <p>Instructions for installing the Basler Framegrabber SDK are available at Installing the Framegrabber SDK.</p>"},{"location":"installing-visualapplets.html#installing-the-license","title":"Installing the License","text":"<p>Instructions for installing the VisualApplets license are available at VisualApplets Licensing.</p>"},{"location":"known-issues-visualapplets-release-3-0-6.html","title":"Known Issues VisualApplets Release 3.0.6","text":"<p>Windows 10 Fall Creators update (version 1709) on a PC with a Vivado 2017.2 or Vivado 2017.3 Installation</p> <p>If you install the Windows 10 Fall Creators update (version 1709) on a PC that has Xilinx Vivado version 2017.2 or 2017.3 installed, Xilinx Vivado may not properly work afterwards. Thus, you may not be able to build the designs you created with VisualApplets. |</p> <p>Follow the work-around provided by Xilinx Support to make your Xilinx Vivado 2017.2 or 2017.3 installation work again. (See https://www.xilinx.com/support/answers/69908.html).</p> <ol> <li> <p>User-independent installation of VisualApplets in directory programs (Windows) results in access problems.</p> </li> <li> <p>When you build an applet using the Xilinx Vivado Tools, you may get critical warnings (in build step LinkDesign). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. However, as this issue is NOT CRITICAL for designs created in VisualApplets, the warnings can be ignored. Example:</p> <pre><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint\nfor instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance\n\u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the\ninstance type. Instance \u2026/PART1174 belongs to a shape with reference instance\n\u2026/PART1175. Shape elements have relative placement respect to each other.\nThe invalid location might results from a constraint on any of the instance\nin the shape..\n</code></pre> </li> <li> <p>Directory and file names: For naming directories and files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for directory and file names.</p> </li> <li> <p>Bandwidth dialog in designs for microEnable 5 marathon and LightBridge frame grabbers: The values displayed for memory-based operators are not reliable. The actual data throughput of the memory operators may differ because the bandwidth analysis doesn\u2019t factor in the shared RAM concept implemented in marathon and LightBridge frame grabbers. If an operator shares the RAM with other operators, this is not detected by the bandwidth analysis and therefore is not reflected in the displayed values.</p> </li> <li> <p>Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that have been started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings.</p> </li> <li> <p>Hierarchical Boxes: If you are using hierarchical boxes, in some specific situations, the Design Rule Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. You can solve this problem (within the hierarchical box) by placing an NOP operator between the input port of the hierarchical box and the input port of the M-type operator.</p> </li> <li> <p>SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user.</p> </li> <li> <p>Applets for microEnable 5 platforms have to be loaded onto the frame grabber via Firmware flasher tool (microDiagnostics) in order to change the applet.</p> </li> <li> <p>Bandwidth analysis does not show exact values and is only an estimation. Use this feature very carefully and run additional tests on the target hardware. Bandwidth calculation in case of kernel operations does not consider kernel dimensions.</p> </li> <li> <p>Operators of the color library should be used carefully: Some color conversions don't work as a user would assume:</p> <ul> <li>HSI2RGB converts HSL -&gt; RGB ,</li> <li>RGB2YUV converts RGB-&gt;YCbCr,</li> <li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com</li> </ul> </li> <li> <p>Operator <code>FIRKernelNxM</code> may cause processing errors in case the parameter <code>EdgeHandling</code> is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame.</p> </li> <li>Operator <code>CoefficientBuffer</code> cannot be used when frame height is set to 1.</li> <li> <p>Simulation of kernel images: Simulation image data cannot be fed from simulation sources into kernel positions which are unequal to (0,0).</p> </li> <li> <p>After a simulation error has occurred, the simulation conditions need to be reset.</p> </li> <li> <p>Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber.</p> </li> <li> <p>Important note concerning operating systems Microsoft Windows 8 and 7 32bit/64bit, Microsoft Windows Vista 32bit/64bit and Microsoft Windows XP 64bit: It is necessary and recommended to define the user folder as destination folder. Alternatively any other folder with full access rights can be used.</p> </li> <li> <p>The DMA resource indexes have to start with zero and have to be consecutively numbered. This will be checked by the DRC.</p> </li> <li> <p>The operator <code>ImageBufferMultiRoiDyn</code> may cause timing errors in case of very small input images.</p> </li> <li> <p>Parameters Library (VisualApplets Expert Feature): When using multiple reference operators in a chain, the references may not work correctly during runtime.</p> </li> <li> <p>The operator <code>ImageSequence</code> may cause build errors (timing errors). (2422)</p> </li> <li> <p><code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in dialog FPGA Resource Usage) might differ from the estimation displayed by the XilinX tools after Place &amp; Route. (6426)</p> </li> <li> <p>The dependencies of the parameters <code>ExSyncPeriod</code>, <code>ExSync2Delay</code>, and <code>ExSyncExposure</code> on each other are defined as follows:</p> <p>FG_LINEPERIODE &gt;= FG_LINETRIGGERDELAY</p> <p>FG_LINEPERIODE &gt; FG_LINEEXPOSURE</p> <p>However, at the moment it is possible to reset FG_LINEPERIODE to a value smaller than FG_LINETRIGGERDELAY and FG_LINEEXPOSURE. (6567).</p> </li> <li> <p>px200 on microEnable IV VD4 runs into problems with some main boards (such as ASRock Z77 Extreme4, ASUS ATX Z170-A, or Gigabyte X79 UD3) if operator <code>RamLUT</code> is initialized on px200 in binary mode, or if operator <code>CoefficientBuffer</code> is used on px200. These mainboards initialize the mentioned operators with very high performance, so that the transfer of the initialization data to px200 may get corrupted. (8045)</p> <p>Workaround for <code>RamLUT</code> operator: If operator initialization gets corrupted, use an alternative initialization mode (NOT binary mode).</p> <p>Workaround for <code>CoefficientBuffer</code> operator: If operator initialization gets corrupted, you need to move the operator to VD4. The operator cannot be used on px200 in that case.</p> </li> </ol>"},{"location":"known-issues-visualapplets-release-3-1-1.html","title":"Known Issues VisualApplets Release 3.1.1","text":"<p>Windows 10 Fall Creators update (version 1709) on a PC with a Vivado 2017.2 or Vivado 2017.3 Installation</p> <p>If you install the Windows 10 Fall Creators update (version 1709) on a PC that has Xilinx Vivado version 2017.2 or 2017.3 installed, Xilinx Vivado may not properly work afterwards. Thus, you may not be able to build the designs you created with VisualApplets. |</p> <p>Follow the work-around provided by Xilinx Support to make your Xilinx Vivado 2017.2 or 2017.3 installation work again. (See https://www.xilinx.com/support/answers/69908.html).</p> <p>Windows 10 x64 (version 1803) Cumulative Update from 2017-07-10 (KB4338819) on a PC with a ISE 14.7 or Vivado installation older than 2017.4</p> <p>If you install the above Windows 10 update the build flow may not work properly afterwards using Xilinx tools older than Vivado 2017.4. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>For Vivado versions older than Vivado 2017.4 error messages may show up in the log output of the Xilinx tool chain telling that some black box instances have undefined content. For ISE\u00ae even no Xilinx tool version can be determined and the FPGA Type Check fails. Though the 32 bit tool chain of ISE\u00ae works (change the Build Settings: For Xilinx settings batch file use settings32.bat instead of settings64.bat).</p> <p>Follow the work-around provided by Xilinx Support to make the ISE installation work again (See https://www.xilinx.com/support/answers/62380.html, section ISE 14.7 64bit - Turning off SmartHeap). The same work-around can be used for Vivado where you need to perform the file substitution actions in the folder \\&lt;VivadoInstallDir&gt;/ids_lite/ISE/lib/nt64.                                                          |</p> <ol> <li> <p>User-independent installation of VisualApplets in directory programs (Windows) results in access problems.</p> </li> <li> <p>When you build an applet using the Xilinx Vivado Tools, you may get critical warnings (in build step LinkDesign). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. However, as this issue is NOT CRITICAL for designs created in VisualApplets, the warnings can be ignored. Example:</p> <pre><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint\nfor instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance\n\u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the\ninstance type. Instance \u2026/PART1174 belongs to a shape with reference instance\n\u2026/PART1175. Shape elements have relative placement respect to each other.\nThe invalid location might results from a constraint on any of the instance\nin the shape..\n</code></pre> </li> <li> <p>File names: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names.</p> </li> <li> <p>Bandwidth dialog in designs for microEnable 5 marathon and LightBridge frame grabbers: The values displayed for memory-based operators are not reliable. The actual data throughput of the memory operators may differ because the bandwidth analysis doesn\u2019t factor in the shared RAM concept implemented in marathon and LightBridge frame grabbers. If an operator shares the RAM with other operators, this is not detected by the bandwidth analysis and therefore is not reflected in the displayed values.</p> </li> <li> <p>Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that have been started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings.</p> </li> <li> <p>Hierarchical Boxes: If you are using hierarchical boxes, in some specific situations, the Design Rule Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. You can solve this problem (within the hierarchical box) by placing an NOP operator between the input port of the hierarchical box and the input port of the M-type operator.</p> </li> <li> <p>SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user.</p> </li> <li> <p>Applets for microEnable 5 platforms have to be loaded onto the frame grabber via Firmware flasher tool (microDiagnostics) in order to change the applet.</p> </li> <li> <p>Bandwidth analysis does not show exact values and is only an estimation. Use this feature very carefully and run additional tests on the target hardware. Bandwidth calculation in case of kernel operations does not consider kernel dimensions.</p> </li> <li> <p>Operators of the color library should be used carefully: Some color conversions don't work as a user would assume:</p> <ul> <li>HSI2RGB converts HSL -&gt; RGB ,</li> <li>RGB2YUV converts RGB-&gt;YCbCr,</li> <li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com</li> </ul> </li> <li> <p>Operator <code>FIRKernelNxM</code> may cause processing errors in case the parameter <code>EdgeHandling</code> is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame.</p> </li> <li> <p>After a simulation error has occurred, the simulation conditions need to be reset.</p> </li> <li> <p>Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber.</p> </li> <li> <p>Important note concerning operating systems Microsoft Windows 8 and 7 32bit/64bit, Microsoft Windows Vista 32bit/64bit and Microsoft Windows XP 64bit: It is necessary and recommended to define the user folder as destination folder. Alternatively any other folder with full access rights can be used.</p> </li> <li> <p>The DMA resource indexes have to start with zero and have to be consecutively numbered. This will be checked by the DRC.</p> </li> <li> <p>The operator <code>ImageBufferMultiRoiDyn</code> may cause timing errors in case of very small input images.</p> </li> <li> <p>The operator <code>ImageSequence</code> may cause build errors (timing errors). (2422)</p> </li> <li> <p><code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in dialog FPGA Resource Usage) might differ from the estimation displayed by the XilinX tools after Place &amp; Route. (6426)</p> </li> <li> <p>In some cases, changing the platform for a design may lead to the error message \"Invalid parameter value: RamDataWidth is not accepted\" during the design rules check. This may happen for modules which are using the resource RAM when the new target platform has a different memory layout than the previous platform. To resolve this, save and reload the design. (8708)</p> </li> <li> <p>Operator <code>ModuloCount</code>: Parameter <code>Devisor</code> can be theoretically set to a value up to 64 bit, but any parametrization with a value higher than 32 bit causes VisualApplets to crash during simulation. (8901)</p> </li> <li> <p><code>DynamicROI</code>: Under specific conditions, operator <code>DynamicROI</code> outputs a wrong line length (the output line length is wrongly extended by one parallel word). This fault occurs only if all of the following three conditions are met:</p> <ul> <li>Parallelism is not power of two,</li> <li>Xoffset is divisible by parallelism, and</li> <li>Xlength is divisible by parallelism.</li> </ul> <p>If one of these conditions is not met, operator <code>DynamicROI</code> works correctly. This fault occurs in the FPGA implementation. The simulation simulates the correct operator behavior. (7722)</p> </li> <li> <p>The <code>SampleDn</code> operator produces a corrupted image when used with a sampling factor that is dividable by 2 and a parallelism higher than 1.</p> </li> <li>Custom operators, memory access: With specific access patters, memory access out of custom operators resulted in data corruption in VisualApplets versions 3.0.6, 3.1, 3.1.1, and 3.1.2. This issue has been fixed in VisualApplets version 3.2.</li> </ol>"},{"location":"known-issues-visualapplets-release-3-1-2.html","title":"Known Issues VisualApplets Release 3.1.2","text":"<p>Windows 10 Fall Creators update (version 1709) on a PC with a Vivado 2017.2 or Vivado 2017.3 Installation</p> <p>If you install the Windows 10 Fall Creators update (version 1709) on a PC that has Xilinx Vivado version 2017.2 or 2017.3 installed, Xilinx Vivado may not properly work afterwards. Thus, you may not be able to build the designs you created with VisualApplets. |</p> <p>Follow the work-around provided by Xilinx Support to make your Xilinx Vivado 2017.2 or 2017.3 installation work again. (See https://www.xilinx.com/support/answers/69908.html).</p> <p>Windows 10 x64 (version 1803) Cumulative Update from 2017-07-10 (KB4338819) on a PC with a ISE 14.7 or Vivado installation older than 2017.4</p> <p>If you install the above Windows 10 update the build flow may not work properly afterwards using Xilinx tools older than Vivado 2017.4. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>For Vivado versions older than Vivado 2017.4 error messages may show up in the log output of the Xilinx tool chain telling that some black box instances have undefined content. For ISE\u00ae even no Xilinx tool version can be determined and the FPGA Type Check fails. Though the 32 bit tool chain of ISE\u00ae works (change the Build Settings: For Xilinx settings batch file use settings32.bat instead of settings64.bat).</p> <p>Follow the work-around provided by Xilinx Support to make the ISE installation work again (See https://www.xilinx.com/support/answers/62380.html, section ISE 14.7 64bit - Turning off SmartHeap). The same work-around can be used for Vivado where you need to perform the file substitution actions in the folder \\&lt;VivadoInstallDir&gt;/ids_lite/ISE/lib/nt64.                                                          |</p> <ol> <li> <p>User-independent installation of VisualApplets in directory programs (Windows) results in access problems.</p> </li> <li> <p>When you build an applet using the Xilinx Vivado Tools, you may get critical warnings (in build step LinkDesign). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. However, as this issue is NOT CRITICAL for designs created in VisualApplets, the warnings can be ignored. Example:</p> <pre><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint\nfor instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance\n\u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the\ninstance type. Instance \u2026/PART1174 belongs to a shape with reference instance\n\u2026/PART1175. Shape elements have relative placement respect to each other.\nThe invalid location might results from a constraint on any of the instance\nin the shape..\n</code></pre> </li> <li> <p>File names: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names.</p> </li> <li> <p>Bandwidth dialog in designs for microEnable 5 marathon and LightBridge frame grabbers: The values displayed for memory-based operators are not reliable. The actual data throughput of the memory operators may differ because the bandwidth analysis doesn\u2019t factor in the shared RAM concept implemented in marathon and LightBridge frame grabbers. If an operator shares the RAM with other operators, this is not detected by the bandwidth analysis and therefore is not reflected in the displayed values.</p> </li> <li> <p>Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that have been started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings.</p> </li> <li> <p>Hierarchical Boxes: If you are using hierarchical boxes, in some specific situations, the Design Rule Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. You can solve this problem (within the hierarchical box) by placing an NOP operator between the input port of the hierarchical box and the input port of the M-type operator.</p> </li> <li> <p>SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user.</p> </li> <li> <p>Applets for microEnable 5 platforms have to be loaded onto the frame grabber via Firmware flasher tool (microDiagnostics) in order to change the applet.</p> </li> <li> <p>Bandwidth analysis does not show exact values and is only an estimation. Use this feature very carefully and run additional tests on the target hardware. Bandwidth calculation in case of kernel operations does not consider kernel dimensions.</p> </li> <li> <p>Operators of the color library should be used carefully: Some color conversions don't work as a user would assume:</p> <ul> <li>HSI2RGB converts HSL -&gt; RGB ,</li> <li>RGB2YUV converts RGB-&gt;YCbCr,</li> <li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com</li> </ul> </li> <li> <p>Operator <code>FIRKernelNxM</code> may cause processing errors in case the parameter <code>EdgeHandling</code> is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame.</p> </li> <li> <p>After a simulation error has occurred, the simulation conditions need to be reset.</p> </li> <li> <p>Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber.</p> </li> <li> <p>Important note concerning operating systems Microsoft Windows 8 and 7 32bit/64bit, Microsoft Windows Vista 32bit/64bit and Microsoft Windows XP 64bit: It is necessary and recommended to define the user folder as destination folder. Alternatively any other folder with full access rights can be used.</p> </li> <li> <p>The DMA resource indexes have to start with zero and have to be consecutively numbered. This will be checked by the DRC.</p> </li> <li> <p>The operator <code>ImageBufferMultiRoiDyn</code> may cause timing errors in case of very small input images.</p> </li> <li> <p>The operator <code>ImageSequence</code> may cause build errors (timing errors). (2422)</p> </li> <li> <p><code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in dialog FPGA Resource Usage) might differ from the estimation displayed by the XilinX tools after Place &amp; Route. (6426)</p> </li> <li> <p>In some cases, changing the platform for a design may lead to the error message \"Invalid parameter value: RamDataWidth is not accepted\" during the design rules check. This may happen for modules which are using the resource RAM when the new target platform has a different memory layout than the previous platform. To resolve this, save and reload the design. (8708)</p> </li> <li> <p>Operator <code>ModuloCount</code>: Parameter <code>Devisor</code> can be theoretically set to a value up to 64 bit, but any parametrization with a value higher than 32 bit causes VisualApplets to crash during simulation. (8901)</p> </li> <li> <p><code>DynamicROI</code>: Under specific conditions, operator <code>DynamicROI</code> outputs a wrong line length (the output line length is wrongly extended by one parallel word). This fault occurs only if all of the following three conditions are met:</p> <ul> <li>Parallelism is not power of two,</li> <li>Xoffset is divisible by parallelism, and</li> <li>Xlength is divisible by parallelism.</li> </ul> <p>If one of these conditions is not met, operator <code>DynamicROI</code> works correctly. This fault occurs in the FPGA implementation. The simulation simulates the correct operator behavior. (7722)</p> </li> <li> <p>marathon VCL, marathon VCLx, LightBridge 2 VCL: In Camera Link Base applets, on port B: The CC2 and CC4 signals are inverted, so that \"1\" on the corresponding port of CameraControl corresponds to a \"0\" at the output and vice versa. In Medium or Full applets all CC signals are implemented correctly. On port A, also in Base mode all CC signals are implemented correctly.</p> </li> <li> <p>The <code>SampleDn</code> operator</p> <ul> <li>produces a corrupted image when used with a sampling factor that is dividable by 2 and a parallelism higher than 1.</li> <li>creates a pixel containing dummy data at the end of each output line when a) the maximum frame width is bigger than the width of the incoming frame and b) the width of the incoming frame is not divisible by the corresponding downsampling parameter value (i.e., when pixels need to be discarded).</li> </ul> </li> <li> <p>Operator <code>RemovePixel</code> (Library Synchronization): Under specific circumstances it may happen that in EoF mode, an empty line is deleted. (9220)</p> </li> <li>Custom operators, memory access: With specific access patters, memory access out of custom operators resulted in data corruption in VisualApplets versions 3.0.6, 3.1, 3.1.1, and 3.1.2. This issue has been fixed in VisualApplets version 3.2.</li> </ol>"},{"location":"known-issues-visualapplets-release-3-1.html","title":"Known Issues VisualApplets Release 3.1","text":"<p>Windows 10 Fall Creators update (version 1709) on a PC with a Vivado 2017.2 or Vivado 2017.3 Installation</p> <p>If you install the Windows 10 Fall Creators update (version 1709) on a PC that has Xilinx Vivado version 2017.2 or 2017.3 installed, Xilinx Vivado may not properly work afterwards. Thus, you may not be able to build the designs you created with VisualApplets. |</p> <p>Follow the work-around provided by Xilinx Support to make your Xilinx Vivado 2017.2 or 2017.3 installation work again. (See https://www.xilinx.com/support/answers/69908.html).</p> <ol> <li> <p>User-independent installation of VisualApplets in directory programs (Windows) results in access problems.</p> </li> <li> <p>When you build an applet using the Xilinx Vivado Tools, you may get critical warnings (in build step LinkDesign). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. However, as this issue is NOT CRITICAL for designs created in VisualApplets, the warnings can be ignored. Example:</p> <pre><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint\nfor instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance\n\u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the\ninstance type. Instance \u2026/PART1174 belongs to a shape with reference instance\n\u2026/PART1175. Shape elements have relative placement respect to each other.\nThe invalid location might results from a constraint on any of the instance\nin the shape..\n</code></pre> </li> <li> <p>File names: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names.</p> </li> <li> <p>Bandwidth dialog in designs for microEnable 5 marathon and LightBridge frame grabbers: The values displayed for memory-based operators are not reliable. The actual data throughput of the memory operators may differ because the bandwidth analysis doesn\u2019t factor in the shared RAM concept implemented in marathon and LightBridge frame grabbers. If an operator shares the RAM with other operators, this is not detected by the bandwidth analysis and therefore is not reflected in the displayed values.</p> </li> <li> <p>Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that have been started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings.</p> </li> <li> <p>Hierarchical Boxes: If you are using hierarchical boxes, in some specific situations, the Design Rule Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. You can solve this problem (within the hierarchical box) by placing an NOP operator between the input port of the hierarchical box and the input port of the M-type operator.</p> </li> <li> <p>SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user.</p> </li> <li> <p>Applets for microEnable 5 platforms have to be loaded onto the frame grabber via Firmware flasher tool (microDiagnostics) in order to change the applet.</p> </li> <li> <p>Bandwidth analysis does not show exact values and is only an estimation. Use this feature very carefully and run additional tests on the target hardware. Bandwidth calculation in case of kernel operations does not consider kernel dimensions.</p> </li> <li> <p>Operators of the color library should be used carefully: Some color conversions don't work as a user would assume:</p> <ul> <li>HSI2RGB converts HSL -&gt; RGB ,</li> <li>RGB2YUV converts RGB-&gt;YCbCr,</li> <li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com</li> </ul> </li> <li> <p>Operator <code>FIRKernelNxM</code> may cause processing errors in case the parameter <code>EdgeHandling</code> is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame.</p> </li> <li> <p>After a simulation error has occurred, the simulation conditions need to be reset.</p> </li> <li> <p>Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber.</p> </li> <li> <p>Important note concerning operating systems Microsoft Windows 8 and 7 32bit/64bit, Microsoft Windows Vista 32bit/64bit and Microsoft Windows XP 64bit: It is necessary and recommended to define the user folder as destination folder. Alternatively any other folder with full access rights can be used.</p> </li> <li> <p>The DMA resource indexes have to start with zero and have to be consecutively numbered. This will be checked by the DRC.</p> </li> <li> <p>The operator <code>ImageBufferMultiRoiDyn</code> may cause timing errors in case of very small input images.</p> </li> <li> <p>The operator <code>ImageSequence</code> may cause build errors (timing errors). (2422)</p> </li> <li> <p><code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in dialog FPGA Resource Usage) might differ from the estimation displayed by the XilinX tools after Place &amp; Route. (6426)</p> </li> <li> <p><code>DynamicROI</code>: Under specific conditions, operator <code>DynamicROI</code> outputs a wrong line length (the output line length is wrongly extended by one parallel word). This fault occurs only if all of the following three conditions are met:</p> <ul> <li>Parallelism is not power of two,</li> <li>Xoffset is divisible by parallelism, and</li> <li>Xlength is divisible by parallelism.</li> </ul> <p>If one of these conditions is not met, operator <code>DynamicROI</code> works correctly. This fault occurs in the FPGA implementation. The simulation simulates the correct operator behavior. (7722)</p> </li> <li> <p>The <code>SampleDn</code> operator produces a corrupted image when used with a sampling factor that is dividable by 2 and a parallelism higher than 1.</p> </li> <li>Custom operators, memory access: With specific access patters, memory access out of custom operators resulted in data corruption in VisualApplets versions 3.0.6, 3.1, 3.1.1, and 3.1.2. This issue has been fixed in VisualApplets version 3.2.</li> </ol>"},{"location":"known-issues-visualapplets-release-3-2-0.html","title":"Known Issues VisualApplets Release 3.2.0","text":"<p>Windows 10 Fall Creators update (version 1709) on a PC with a Vivado 2017.2 or Vivado 2017.3 Installation</p> <p>If you install the Windows 10 Fall Creators update (version 1709) on a PC that has Xilinx Vivado version 2017.2 or 2017.3 installed, Xilinx Vivado may not properly work afterwards. Thus, you may not be able to build the designs you created with VisualApplets. |</p> <p>Follow the work-around provided by Xilinx Support to make your Xilinx Vivado 2017.2 or 2017.3 installation work again. (See https://www.xilinx.com/support/answers/69908.html).</p> <p>Windows 10 x64 (version 1803) Cumulative Update from 2017-07-10 (KB4338819) on a PC with a ISE 14.7 or Vivado installation older than 2017.4</p> <p>If you install the above Windows 10 update the build flow may not work properly afterwards using Xilinx tools older than Vivado 2017.4. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>For Vivado versions older than Vivado 2017.4 error messages may show up in the log output of the Xilinx tool chain telling that some black box instances have undefined content. For ISE\u00ae even no Xilinx tool version can be determined and the FPGA Type Check fails. Though the 32 bit tool chain of ISE\u00ae works (change the Build Settings: For Xilinx settings batch file use settings32.bat instead of settings64.bat).</p> <p>Follow the work-around provided by Xilinx Support to make the ISE installation work again (See https://www.xilinx.com/support/answers/62380.html, section ISE 14.7 64bit - Turning off SmartHeap). The same work-around can be used for Vivado where you need to perform the file substitution actions in the folder \\&lt;VivadoInstallDir&gt;/ids_lite/ISE/lib/nt64.                                                          |</p> <ol> <li> <p>User-independent installation of VisualApplets in directory programs (Windows) results in access problems.</p> </li> <li> <p>When you build an applet using the Xilinx Vivado Tools, you may get critical warnings (in build step LinkDesign). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. However, as this issue is NOT CRITICAL for designs created in VisualApplets, the warnings can be ignored. Example:</p> <pre><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint\nfor instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance\n\u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the\ninstance type. Instance \u2026/PART1174 belongs to a shape with reference instance\n\u2026/PART1175. Shape elements have relative placement respect to each other.\nThe invalid location might results from a constraint on any of the instance\nin the shape..\n</code></pre> </li> <li> <p>File names: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names.</p> </li> <li> <p>Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that have been started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings.</p> </li> <li> <p>Hierarchical Boxes: If you are using hierarchical boxes, in some specific situations, the Design Rule Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. You can solve this problem (within the hierarchical box) by placing an NOP operator between the input port of the hierarchical box and the input port of the M-type operator.</p> </li> <li> <p>SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user.</p> </li> <li> <p>Applets for microEnable 5 platforms have to be loaded onto the frame grabber via Firmware flasher tool (microDiagnostics) in order to change the applet.</p> </li> <li> <p>Operators of the color library should be used carefully: Some color conversions don't work as a user would assume:</p> <ul> <li>HSI2RGB converts HSL -&gt; RGB ,</li> <li>RGB2YUV converts RGB-&gt;YCbCr,</li> <li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com</li> </ul> </li> <li> <p>Operator <code>FIRKernelNxM</code> may cause processing errors in case the parameter <code>EdgeHandling</code> is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame.</p> </li> <li> <p>After a simulation error has occurred, the simulation conditions need to be reset.</p> </li> <li> <p>Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber.</p> </li> <li> <p>Important note concerning operating systems Microsoft Windows 8 and 7 32bit/64bit, Microsoft Windows Vista 32bit/64bit and Microsoft Windows XP 64bit: It is necessary and recommended to define the user folder as destination folder. Alternatively any other folder with full access rights can be used.</p> </li> <li> <p>The DMA resource indexes have to start with zero and have to be consecutively numbered. This will be checked by the DRC.</p> </li> <li> <p>The operator <code>ImageBufferMultiRoiDyn</code> may cause timing errors in case of very small input images.</p> </li> <li> <p>The operator <code>ImageSequence</code> may cause build errors (timing errors). (2422)</p> </li> <li> <p><code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in dialog FPGA Resource Usage) might differ from the estimation displayed by the XilinX tools after Place &amp; Route. (6426)</p> </li> <li> <p>In some cases, changing the platform for a design may lead to the error message \"Invalid parameter value: RamDataWidth is not accepted\" during the design rules check. This may happen for modules which are using the resource RAM when the new target platform has a different memory layout than the previous platform. To resolve this, save and reload the design. (8708)</p> </li> <li> <p>Operator <code>ModuloCount</code>: Parameter <code>Devisor</code> can be theoretically set to a value up to 64 bit, but any parametrization with a value higher than 32 bit causes VisualApplets to crash during simulation. (8901)</p> </li> <li> <p>Operator <code>RemovePixel</code> (Library Synchronization): Under specific circumstances it may happen that in EoF mode, an empty line is deleted. (9220)</p> </li> <li> <p>Operator <code>SampleDn</code> (Library Base): The truncation of images according to sampling factor in <code>SampleDn</code> is incorrect. There is only a truncation to the maximum width depending on parallelism and X sampling factor. Images can not be bigger than the maximum output width. (7752)</p> </li> <li> <p>Operator <code>Blob_Analysis_1D</code> (Library Blob): Parameter <code>max_object_height_bits</code> must be less or equal to 31 bit. Otherwise, you will get an error during the design rules check. (8880)</p> </li> <li> <p>Custom operators, memory access: With specific access patters, memory access out of custom operators resulted in data corruption in VisualApplets versions 3.0.6, 3.1, 3.1.1, and 3.1.2. This issue has been fixed in VisualApplets version 3.2.</p> </li> <li> <p>Operator <code>GPO</code> (platform-specific library): When a <code>GPO</code> operator for a connector pin[N] is not instantiated inside a VisualApplets design, the correspondent connector pin[N] will drive electrical zero. To avoid this situation, instantiate the <code>GPO</code> operator for unused pins and source it by the <code>VCC</code> operator. This issue concerns all VisualApplets versions up to VA 3.2.</p> </li> <li> <p>TCL commands <code>CopySelected</code> and <code>CutSelected</code> don't work in VisualApplets Version 3.2.0. (9595)</p> </li> </ol>"},{"location":"known-issues-visualapplets-release-3-2-1.html","title":"Known Issues VisualApplets Release 3.2.1","text":"<p>Windows 10 Fall Creators update (version 1709) on a PC with a Vivado 2017.2 or Vivado 2017.3 Installation</p> <p>If you install the Windows 10 Fall Creators update (version 1709) on a PC that has Xilinx Vivado version 2017.2 or 2017.3 installed, Xilinx Vivado may not properly work afterwards. Thus, you may not be able to build the designs you created with VisualApplets. |</p> <p>Follow the work-around provided by Xilinx Support to make your Xilinx Vivado 2017.2 or 2017.3 installation work again. (See https://www.xilinx.com/support/answers/69908.html).</p> <p>Windows 10 x64 (version 1803) Cumulative Update from 2017-07-10 (KB4338819) on a PC with a ISE 14.7 or Vivado installation older than 2017.4</p> <p>If you install the above Windows 10 update the build flow may not work properly afterwards using Xilinx tools older than Vivado 2017.4. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>For Vivado versions older than Vivado 2017.4 error messages may show up in the log output of the Xilinx tool chain telling that some black box instances have undefined content. For ISE\u00ae even no Xilinx tool version can be determined and the FPGA Type Check fails. Though the 32 bit tool chain of ISE\u00ae works (change the Build Settings: For Xilinx settings batch file use settings32.bat instead of settings64.bat).</p> <p>Follow the work-around provided by Xilinx Support to make the ISE installation work again (See https://www.xilinx.com/support/answers/62380.html, section ISE 14.7 64bit - Turning off SmartHeap). The same work-around can be used for Vivado where you need to perform the file substitution actions in the folder \\&lt;VivadoInstallDir&gt;/ids_lite/ISE/lib/nt64.                                                          |</p> <ol> <li> <p>User-independent installation of VisualApplets in directory programs (Windows) results in access problems.</p> </li> <li> <p>When you build an applet using the Xilinx Vivado Tools, you may get critical warnings (in build step LinkDesign). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. However, as this issue is NOT CRITICAL for designs created in VisualApplets, the warnings can be ignored. Example:</p> <pre><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint\nfor instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance\n\u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the\ninstance type. Instance \u2026/PART1174 belongs to a shape with reference instance\n\u2026/PART1175. Shape elements have relative placement respect to each other.\nThe invalid location might results from a constraint on any of the instance\nin the shape..\n</code></pre> </li> <li> <p>File names: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names.</p> </li> <li> <p>Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that have been started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings.</p> </li> <li> <p>Hierarchical Boxes: If you are using hierarchical boxes, in some specific situations, the Design Rule Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. You can solve this problem (within the hierarchical box) by placing an NOP operator between the input port of the hierarchical box and the input port of the M-type operator.</p> </li> <li> <p>SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user.</p> </li> <li> <p>Applets for microEnable 5 platforms have to be loaded onto the frame grabber via Firmware flasher tool (microDiagnostics) in order to change the applet.</p> </li> <li> <p>Operators of the color library should be used carefully: Some color conversions don't work as a user would assume:</p> <ul> <li>HSI2RGB converts HSL -&gt; RGB ,</li> <li>RGB2YUV converts RGB-&gt;YCbCr,</li> <li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com</li> </ul> </li> <li> <p>Operator <code>FIRKernelNxM</code> may cause processing errors in case parameter <code>EdgeHandling</code> is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame.</p> </li> <li> <p>After a simulation error has occurred, the simulation conditions need to be reset.</p> </li> <li> <p>Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber.</p> </li> <li> <p>Important note concerning operating systems Microsoft Windows 8 and 7 32bit/64bit, Microsoft Windows Vista 32bit/64bit and Microsoft Windows XP 64bit: It is necessary and recommended to define the user folder as destination folder. Alternatively any other folder with full access rights can be used.</p> </li> <li> <p>The DMA resource indexes have to start with zero and have to be consecutively numbered. This will be checked by the DRC.</p> </li> <li> <p>The operator <code>ImageBufferMultiRoiDyn</code> may cause timing errors in case of very small input images.</p> </li> <li> <p>The operator <code>ImageSequence</code> may cause build errors (timing errors). (2422)</p> </li> <li> <p><code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in dialog FPGA Resource Usage) might differ from the estimation displayed by the XilinX tools after Place &amp; Route. (6426)</p> </li> <li> <p>In some cases, changing the platform for a design may lead to the error message \"Invalid parameter value: RamDataWidth is not accepted\" during the design rules check. This may happen for modules which are using the resource RAM when the new target platform has a different memory layout than the previous platform. To resolve this, save and reload the design. (8708)</p> </li> <li> <p>Operator <code>ModuloCount</code>: Parameter <code>Devisor</code> can be theoretically set to a value up to 64 bit, but any parametrization with a value higher than 32 bit causes VisualApplets to crash during simulation. (8901)</p> </li> <li> <p>Operator <code>RemovePixel</code> (Library Synchronization): Under specific circumstances it may happen that in EoF mode, an empty line is deleted. (9220)</p> </li> <li> <p>Operator <code>SampleDn</code> (Library Base): The truncation of images according to sampling factor in <code>SampleDn</code> is incorrect. There is only a truncation to the maximum width depending on parallelism and X sampling factor. Images can not be bigger than the maximum output width. (7752)</p> </li> <li> <p>Operator <code>Blob_Analysis_1D</code> (Library Blob): Parameter <code>max_object_height_bits</code> must be less or equal to 31 bit. Otherwise, you will get an error during the design rules check. (8880)</p> </li> <li> <p>Custom operators, memory access: With specific access patters, memory access out of custom operators resulted in data corruption in VisualApplets versions 3.0.6, 3.1, 3.1.1, and 3.1.2. This issue has been fixed in VisualApplets version 3.2.</p> </li> <li> <p>Operator <code>GPO</code> (platform-specific library): When a <code>GPO</code> operator for a connector pin[N] is not instantiated inside a VisualApplets design, the correspondent connector pin[N] will drive electrical zero. To avoid this situation, instantiate the <code>GPO</code> operator for unused pins and source it by the <code>VCC</code> operator. This issue concerns all VisualApplets versions up to VA 3.2.</p> </li> <li> <p>TCL commands <code>CopySelected</code> and <code>CutSelected</code> don't work in VisualApplets Version 3.2.0. (9595)</p> </li> <li> <p>Increasing the FPGA design clock frequency may have the result that the build flow takes very long or even fails because timing constraints cannot be met. This strongly depends on the content of the VisualApplets design. (8513)</p> </li> <li> <p>Operator <code>JPEG_Encoder</code>: To optimize its image throughput rate (band width), the operator outputs the header as soon as header generation is activated - even before image data arrive at the operator's input. This way, the transfer of the header data doesn't interrupt the transfer of image data, as the header is transferred in advance. The drawback of this practice is that the operator's output transfer starts earlier than the actual image data transfer. This may cause irritations under specific circumstances:</p> <ul> <li> <p>Using operator <code>SourceSelector</code> directly after <code>JPEG_Encoder</code>: Operator <code>SourceSelector</code> registers a partly processed frame as soon as it gets the header data. Therefore, if <code>SourceSelector</code> is switched to getting image data from <code>JPEG_Encoder</code>, <code>SourceSelector</code> cannot be switched to any another source as it always detects an unfinished frame. In addition, when header generation is enabled and <code>SourceSelector</code> switches from another source to the <code>JPEG_Encoder</code> channel, the first image is lost.</p> </li> <li> <p>To measure the latency, use operator <code>FrameEndToSignal</code> (instead of <code>FrameStartToSignal</code> and <code>SignalToDelay</code>).</p> </li> <li> <p>If working on eVA devices, please make sure the output is capable to accept data transfer before the sensor transfer is started.</p> </li> </ul> </li> <li> <p>Applets for the platforms mE5-MA-VCL and mE5-MA-VCLx cannot be built with Vivado 2020.2. The latest supported Vivado version for these platforms in VisualApplets 3.2.1 is Vivado 2020.1. (9848)</p> </li> </ol>"},{"location":"known-issues-visualapplets-release-3-3-0.html","title":"Known Issues VisualApplets Release 3.3.0","text":"<p>Windows 10 Fall Creators Update (Version 1709) On a PC with a Vivado 2017.2 or Vivado 2017.3 Installation</p> <p>If you install the Windows 10 Fall Creators update (version 1709) on a PC that has Xilinx Vivado version 2017.2 or 2017.3 installed, Xilinx Vivado may not properly work afterwards. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>Follow the workaround provided by Xilinx Support to make your Xilinx Vivado 2017.2 or 2017.3 installation work again. (See https://www.xilinx.com/support/answers/69908.html).</p> <p>Windows 10 x64 (Version 1803) Cumulative Update from 2017-07-10 (KB4338819) On a PC with an ISE 14.7 or Vivado installation Older Than 2017.4</p> <p>If you install the above Windows 10 update the build flow may not work properly afterwards using Xilinx tools older than Vivado 2017.4. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>For Vivado versions older than Vivado 2017.4 error messages may show up in the log output of the Xilinx tool chain telling that some black box instances have undefined content. For ISE even no Xilinx tool version can be determined and the FPGA Type Check fails.</p> <p>Follow the workaround provided by Xilinx Support to make the ISE installation work again (See https://www.xilinx.com/support/answers/62380.html, section ISE 14.7 64bit - Turning off SmartHeap). The same workaround can be used for Vivado where you need to perform the file substitution actions in the folder \\&lt;VivadoInstallDir&gt;/ids_lite/ISE/lib/nt64.</p>"},{"location":"known-issues-visualapplets-release-3-3-0.html#general","title":"General","text":"Summary: Build Error When Building a Design with Embedded VisualApplets (eVA) Description: When building a design with embedded VisualApplets, a build error might occur. This affects only VisualApplets version 3.3.0. Affected OS: Windows 8 Workaround: Use VisualApplets 3.2.1. Ticket ID: 233158 Summary: Applets for mE5 Platforms Can't Be Built with Xilinx Vivado 2020.2 or Higher Description: Applets for all mE5 platforms can't be built with Vivado 2020.2 or higher. The latest supported Vivado version for these platforms is Vivado 2020.1. Affected OS: Windows 8 Workaround: Use Xilinx Vivado 2020.1 or lower to build applets for mE5 platforms. Ticket ID: 9848 Summary: On a Windows PC, You Must Define the User Folder as Destination Folder Description: Important note concerning operating systems Microsoft Windows 8: It is necessary and recommended to define the user folder as destination folder. Alternatively any other folder with full access rights can be used. Affected OS: Windows 8 Workaround: No workaround is available. Ticket ID: \u2013 Summary: When Converting a Design to a Different Hardware Platform, the Hardware-Dependent Operator Library Might Not Be Available Description: When converting a VisualApplets design to a different hardware platform, then under certain circumstances the hardware-dependent operator library for the target platform might not be available. Workaround: To resolve this restart VisualApplets. Ticket ID: \u2013 Summary: The Dialog Build Hardware Platforms Stays Blank During Build Description: Sometimes the dialog Build Hardware Platforms stays blank during build while the dock window Build Log shows the output. This has no impact on the build flow. Workaround: To resolve this, cancel and restart the build. Ticket ID: \u2013 Summary: You Need to Reset Simulation Conditions After a Simulation Error Description: After a simulation error has occurred, the simulation conditions need to be reset Workaround: No workaround is available. Ticket ID: \u2013 Summary: Xilinx Vivado Warning When Building an Applet Description: When you build an applet using the Xilinx Vivado Tools, you may get critical warnings (in build step LinkDesign). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. Example:<p><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint for instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance \u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the instance type. Instance \u2026/PART1174 belongs to a shape with reference instance \u2026/PART1175. Shape elements have relative placement respect to each other. The invalid location might results from a constraint on any of the instance in the shape.. </code></p> Workaround: Ignore the warnings. This issue is not critical for designs created in VisualApplets. Ticket ID: \u2013 Summary: Only ASCII Characters Are Supported for *.va File Names Description: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Configuration Is Only Saved For First Instance of VisualApplets Description: Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that have been started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Design Rules Check Error When M-Type Operators in a Hierarchical Box Are Connected Directly to the Input Port Description: If you are using hierarchical boxes, in some specific situations, the Design Rules Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. Workaround: You can solve this problem (within the hierarchical box) by placing an NOP operator between the input port of the hierarchical box and the input port of the M-type operator. Ticket ID: \u2013 Summary: Design Rules Check Error When Using the Line-by-Line 1D Simulation Mode Description: For some designs which passed the Design Rules Check in former versions of VisualApplets, link errors concerning the max. image height may be reported. In particular this may happen when 1D processing is involved and the new line-by-line simulation mode is activated (default). The reason is that in the line-by-line-mode some operators propagate the max. image height of input links in a different way to the output links than before. Workaround: You can solve this problem by changing to the legacy simulation mode or by adding SetDimension modules for adjusting the max. image height values. Ticket ID: \u2013 Summary: Increased Operating Time When Using the Line-by-Line 1D Simulation Mode Description: For some designs the operating time for simulation may be much higher than in former versions of VisualApplets. In particular this may happen when 1D processing is involved, the new line-by-line simulation mode is activated (default), and the design contains many simulation probes. Workaround: You can solve this problem by changing to the legacy simulation mode or by reducing the number of simulation probes. Ticket ID: \u2013 Summary: SDK for CXP: Access to the SISO_GenICam Library Have to Be Programmed by the User Description: SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Increasing the FPGA Design Clock Frequency May Lead to Slow Builds Description: Increasing the FPGA design clock frequency may have the result that the build flow takes very long or even fails because timing constraints cannot be met. This strongly depends on the content of the VisualApplets design. Workaround: No workaround is available. Ticket ID: 8513 Summary: Large Images Are Not Displayed in Simulation Probes Description: When simulation probes contain very large images, VisualApplets may fail to display these images correctly due to memory limitations. In that case, a gray image (i.e. all pixels have the value 205 (0xCD)) is shown. Workaround: Use smaller images for simulation. Ticket ID: 6822"},{"location":"known-issues-visualapplets-release-3-3-0.html#library-blob","title":"Library Blob","text":""},{"location":"known-issues-visualapplets-release-3-3-0.html#operator-blob_analysis_1d","title":"Operator <code>Blob_Analysis_1D</code>","text":"Summary: The Operator <code>Blob_Analysis_1D</code> Sets the Flag <code>object size exceeds maximum</code> Not as Expected Description: If an object is truncated due to exceeding the maximum size defined by parameter <code>max_object_height_bits</code>, the corresponding flag <code>object size exceeds maximum</code> is set in the truncated object and not in the proceeding object. Workaround: No workaround is available. Ticket ID: 9685 Summary: The Operator <code>Blob_Analysis_1D</code> Does Not Set the Flag <code>label overflow</code> Description: The flag <code>label overflow</code> indicating that all labels are in use and the current object cannot be tagged, is never set. Workaround: No workaround is available. Ticket ID: 9691 Summary: The Operator <code>Blob_Analysis_1D</code> Allows 20 Labels Less Than Defined per Line Description: The amount of available labels as defined via the parameter <code>Label_bits</code> is reduced by 20 labels. For example, if <code>Label_bits</code> is set to 5, only 12 (2^5 - 20) labels are available, and not 32 as expected (2^5). Workaround: No workaround is available. Ticket ID: 9688 Summary: The Simulation of The Operator <code>Blob_Analysis_1D</code> is Not Equal to Hardware Behavior Description: The order of the object feature output might differ in hardware and software. This is so, because the hardware output depends on the timing of the data which cannot be simulated in VisualApplets. Additionally, the FlushI input is asynchronous to the image data input, so completing output frames may not be simulated in a realistic way. Workaround: No workaround is available. Ticket ID: 7709"},{"location":"known-issues-visualapplets-release-3-3-0.html#library-color","title":"Library Color","text":"Summary: Some Color Conversions Don't Work As Expected Description: Operators of the Color library should be used carefully: Some color conversions don't work as a user would assume:<ul><li>HSI2RGB converts HSL -&gt; RGB ,</li><li>RGB2YUV converts RGB-&gt;YCbCr,</li><li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com </li></ul> Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-3-0.html#operator-bayer5x5linear","title":"Operator <code>BAYER5x5Linear</code>","text":"Summary: The Resource Estimation in VisualApplets for <code>BAYER5x5Linear</code> Differs From the Estimation in Xilinx Description: <code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in dialog FPGA Resource Usage) might differ from the estimation displayed by the Xilinx tools after Place &amp; Route. Workaround: No workaround is available. Ticket ID: 6426"},{"location":"known-issues-visualapplets-release-3-3-0.html#library-compression","title":"Library Compression","text":""},{"location":"known-issues-visualapplets-release-3-3-0.html#operator-jpeg_encoder","title":"Operator <code>JPEG_Encoder</code>","text":"Summary: The Output Transfer Of the Operator <code>JPEG_Encoder</code> Starts Earlier Than the Actual Image Data Transfer Description: Operator : To optimize its image throughput rate (band width), the operator outputs the header as soon as header generation is activated - even before image data arrive at the operator's input. This way, the transfer of the header data doesn't interrupt the transfer of image data, as the header is transferred in advance. The drawback of this practice is that the operator's output transfer starts earlier than the actual image data transfer. This may cause irritations under specific circumstances:  If you are using the operator <code>SourceSelector</code> directly after <code>JPEG_Encoder</code>: Operator <code>SourceSelector</code> registers a partly processed frame as soon as it gets the header data. Therefore, if <code>SourceSelector</code> is switched to getting image data from <code>JPEG_Encoder</code>, <code>SourceSelector</code> cannot be switched to any another source as it always detects an unfinished frame. In addition, when header generation is enabled and <code>SourceSelector</code> switches from another source to the <code>JPEG_Encoder</code> channel, the first image is lost. Workaround: If working on eVA devices, make sure the output is capable to accept data transfer before the sensor transfer is started. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-3-0.html#library-filter","title":"Library Filter","text":""},{"location":"known-issues-visualapplets-release-3-3-0.html#operator-firkernelnxm","title":"Operator <code>FIRKernelNxM</code>","text":"Summary: Operator <code>FIRKernelNxM</code> May Cause Processing Errors Description: The operator <code>FIRKernelNxM</code> may cause processing errors in case parameter <code>EdgeHandling</code> is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame. Workaround: No workaround is available. Ticket ID: 2939"},{"location":"known-issues-visualapplets-release-3-3-0.html#library-hardware-platforms","title":"Library Hardware Platforms","text":""},{"location":"known-issues-visualapplets-release-3-3-0.html#operator-clhssinglecamera","title":"Operator <code>CLHSSingleCamera</code>","text":"Summary: Build Error for Designs With the Operator <code>CLHSSingleCamera</code> for the Platform mE5-MA-VF2 Description: When you use the camera operator <code>CLHSSingleCamera</code> in designs for the platform mE5-MA-VF2, an internal exception occurs during the build flow. Workaround: No workaround is available. Ticket ID: 229896"},{"location":"known-issues-visualapplets-release-3-3-0.html#trigger-operators","title":"Trigger Operators","text":"Summary: Trigger Operators May Cause Spikes at the Trigger Output Line Description: Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-3-0.html#library-memory","title":"Library Memory","text":""},{"location":"known-issues-visualapplets-release-3-3-0.html#operator-imagebuffermultiroidyn","title":"Operator <code>ImageBufferMultiRoiDyn</code>","text":"Summary: Timing Errors with Small Images Description: The operator <code>ImageBufferMultiRoiDyn</code> may cause timing errors in case of very small input images. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-3-0.html#operator-imagesequence","title":"Operator <code>ImageSequence</code>","text":"Summary: Build Errors Caused by the Operator <code>ImageSequence</code> Description: The operator <code>ImageSequence</code> may cause build errors (timing errors). Workaround: No workaround is available. Ticket ID: 2422"},{"location":"known-issues-visualapplets-release-3-3-0.html#operator-ramlut","title":"Operator <code>RamLUT</code>","text":"Summary: Error When Changing the Platform for a Design with the Operator <code>RamLUT</code> Description: When you change the platform for a design with a <code>RamLUT</code> operator, the error message \"Invalid parameter value: RamDataWidth is not accepted\" may occur during the design rules check. This happens, if you are using a module that is using the resource RAM and if the new target platform has a different memory layout than the previous platform. Workaround: To resolve this, save and reload the design. Ticket ID: 8708 and 224018"},{"location":"known-issues-visualapplets-release-3-3-1.html","title":"Known Issues VisualApplets Release 3.3.1","text":"<p>Info</p> <p>If you install the Windows 10 Fall Creators update (version 1709) on a computer that has Xilinx Vivado version 2017.2 or 2017.3 installed, Xilinx Vivado may not work properly. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>Follow the workaround provided by Xilinx Support to make your Xilinx Vivado 2017.2 or 2017.3 installation work again.</p> <p>Info</p> <p>If you install the above Windows 10 update, the build flow may not work properly using Xilinx tools older than Vivado 2017.4. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>For Vivado versions older than Vivado 2017.4, error messages may show up in the log output of the Xilinx tool chain telling that some black box instances have undefined content. For ISE, no Xilinx tool version can be determined and the FPGA type check fails.</p> <p>Follow the workaround provided by Xilinx Support to make the ISE installation work again (section \"ISE 14.7 64-bit - Turning off SmartHeap\"). The same workaround can be used for Vivado where you need to perform the file substitution actions in directory &lt;VivadoInstallDir&gt;/ids_lite/ISE/lib/nt64.</p>"},{"location":"known-issues-visualapplets-release-3-3-1.html#general","title":"General","text":"Summary: Applets Can't Be Built for Ubuntu Linux 18.04 Lts Description: With the VisualApplets installer for version 3.3.1 of March 31, 2022, it is not possible to build applets which work on an Ubuntu 18.04 LTS system. Workaround: This has been fixed with a new installer of April 29, 2022. Download and install the new installer from the Basler Download Site. Ticket ID: 239413 Summary: Xilinx Build Toolchain Doesn't Support Windows 11 Description: The Xilinx build toolchain doesn't support Windows 11. Therefore, building VisualApplets designs doesn't work. Workaround: Don't install VisualApplets on Windows 11. Use Windows 10 or Windows 8.1 instead. Ticket ID: 236990 Summary: Unused GPIO Pins Are Undefined in Designs for mE5 marathon Platforms Description: Unused GPIO pins in VisualApplets designs for mE5 marathon platforms may result in an undefined output signal level of trigger output pins. Workaround: Define all GPIO pins in your design. Ticket ID: 221922 Summary: Applets for mE5-CL Platforms Can't Be Built with Xilinx Vivado 2020.2 or Higher Description: Applets for mE5-CL platforms can't be built with Vivado 2020.2 or higher. The latest supported Vivado version for these platforms is Vivado 2020.1. Workaround: Use Xilinx Vivado 2020.1 or lower to build applets for mE5-CL platforms. Ticket ID: 217879 Summary: SampleDn Operator May Not Work Properly Description: The SampleDn operator doesn't work properly for 2-bit signed inputs. Workaround: Set the input data format to 3-bit signed. Ticket ID: 215638 Summary: On Windows 8, You Must Define the User Directory as Destination Directory Description: On Microsoft Windows 8, you must define the user directory as the destination directory. Alternatively, any other directory with full access rights can be used. Workaround: No workaround is available. Ticket ID: \u2013 Summary: When Converting a Design to a Different Hardware Platform, the Hardware-Dependent Operator Library Might Not Be Available Description: When converting a VisualApplets design to a different hardware platform, then under certain circumstances the hardware-dependent operator library for the target platform might not be available. Workaround: To resolve this restart VisualApplets. Ticket ID: \u2013 Summary: The Dialog Build Hardware Platforms Stays Blank During Build Description: Sometimes the dialog Build Hardware Platforms stays blank during build while the dock window Build Log shows the output. This has no impact on the build flow. Workaround: To resolve this, cancel and restart the build. Ticket ID: \u2013 Summary: You Need to Reset Simulation Conditions After a Simulation Error Description: After a simulation error has occurred, the simulation conditions need to be reset Workaround: No workaround is available. Ticket ID: \u2013 Summary: Xilinx Vivado Warning When Building an Applet Description: When you build an applet using the Xilinx Vivado Tools, you may get critical warnings (in build step LinkDesign). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. Example:<p><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint for instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance \u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the instance type. Instance \u2026/PART1174 belongs to a shape with reference instance \u2026/PART1175. Shape elements have relative placement respect to each other. The invalid location might results from a constraint on any of the instance in the shape.. </code></p> Workaround: Ignore the warnings. This issue is not critical for designs created in VisualApplets. Ticket ID: \u2013 Summary: Only ASCII Characters Are Supported for *.va File Names Description: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Configuration Is Only Saved For First Instance of VisualApplets Description: Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that have been started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Design Rules Check Error When M-Type Operators in a Hierarchical Box Are Connected Directly to the Input Port Description: If you are using hierarchical boxes, in some specific situations, the Design Rules Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. Workaround: You can solve this problem (within the hierarchical box) by placing an NOP operator between the input port of the hierarchical box and the input port of the M-type operator. Ticket ID: \u2013 Summary: Design Rules Check Error When Using the Line-by-Line 1D Simulation Mode Description: For some designs which passed the Design Rules Check in former versions of VisualApplets, link errors concerning the max. image height may be reported. In particular this may happen when 1D processing is involved and the new line-by-line simulation mode is activated (default). The reason is that in the line-by-line-mode some operators propagate the max. image height of input links in a different way to the output links than before. Workaround: You can solve this problem by changing to the legacy simulation mode or by adding SetDimension modules for adjusting the max. image height values. Ticket ID: \u2013 Summary: Increased Operating Time When Using the Line-by-Line 1D Simulation Mode Description: For some designs the operating time for simulation may be much higher than in former versions of VisualApplets. In particular this may happen when 1D processing is involved, the new line-by-line simulation mode is activated (default), and the design contains many simulation probes. Workaround: You can solve this problem by changing to the legacy simulation mode or by reducing the number of simulation probes. Ticket ID: \u2013 Summary: SDK for CXP: Access to the SISO_GenICam Library Have to Be Programmed by the User Description: SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Increasing the FPGA Design Clock Frequency May Lead to Slow Builds Description: Increasing the FPGA design clock frequency may have the result that the build flow takes very long or even fails because timing constraints cannot be met. This strongly depends on the content of the VisualApplets design. Workaround: No workaround is available. Ticket ID: 8513 Summary: Large Images Are Not Displayed in Simulation Probes Description: When simulation probes contain very large images, VisualApplets may fail to display these images correctly due to memory limitations. In that case, a gray image (i.e. all pixels have the value 205 (0xCD)) is shown. Workaround: Use smaller images for simulation. Ticket ID: 6822"},{"location":"known-issues-visualapplets-release-3-3-1.html#library-blob","title":"Library Blob","text":""},{"location":"known-issues-visualapplets-release-3-3-1.html#operator-blob_analysis_1d","title":"Operator <code>Blob_Analysis_1D</code>","text":"Summary: The Operator <code>Blob_Analysis_1D</code> Sets the Flag <code>object size exceeds maximum</code> Not as Expected Description: If an object is truncated due to exceeding the maximum size defined by parameter <code>max_object_height_bits</code>, the corresponding flag <code>object size exceeds maximum</code> is set in the truncated object and not in the proceeding object. Workaround: No workaround is available. Ticket ID: 9685 Summary: The Operator <code>Blob_Analysis_1D</code> Does Not Set the Flag <code>label overflow</code> Description: The flag <code>label overflow</code> indicating that all labels are in use and the current object cannot be tagged, is never set. Workaround: No workaround is available. Ticket ID: 9691 Summary: The Operator <code>Blob_Analysis_1D</code> Allows 20 Labels Less Than Defined per Line Description: The amount of available labels as defined via the parameter <code>Label_bits</code> is reduced by 20 labels. For example, if <code>Label_bits</code> is set to 5, only 12 (2^5 - 20) labels are available, and not 32 as expected (2^5). Workaround: No workaround is available. Ticket ID: 9688 Summary: The Simulation of The Operator <code>Blob_Analysis_1D</code> is Not Equal to Hardware Behavior Description: The order of the object feature output might differ in hardware and software. This is so, because the hardware output depends on the timing of the data which cannot be simulated in VisualApplets. Additionally, the FlushI input is asynchronous to the image data input, so completing output frames may not be simulated in a realistic way. Workaround: No workaround is available. Ticket ID: 7709"},{"location":"known-issues-visualapplets-release-3-3-1.html#library-color","title":"Library Color","text":"Summary: Some Color Conversions Don't Work As Expected Description: Operators of the Color library should be used carefully: Some color conversions don't work as a user would assume:<ul><li>HSI2RGB converts HSL -&gt; RGB ,</li><li>RGB2YUV converts RGB-&gt;YCbCr,</li><li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com </li></ul> Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-3-1.html#operator-bayer5x5linear","title":"Operator <code>BAYER5x5Linear</code>","text":"Summary: The Resource Estimation in VisualApplets for <code>BAYER5x5Linear</code> Differs From the Estimation in Xilinx Description: <code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in dialog FPGA Resource Usage) might differ from the estimation displayed by the Xilinx tools after Place &amp; Route. Workaround: No workaround is available. Ticket ID: 6426"},{"location":"known-issues-visualapplets-release-3-3-1.html#library-compression","title":"Library Compression","text":""},{"location":"known-issues-visualapplets-release-3-3-1.html#operator-jpeg_encoder","title":"Operator <code>JPEG_Encoder</code>","text":"Summary: The Output Transfer Of the Operator <code>JPEG_Encoder</code> Starts Earlier Than the Actual Image Data Transfer Description: Operator : To optimize its image throughput rate (band width), the operator outputs the header as soon as header generation is activated - even before image data arrive at the operator's input. This way, the transfer of the header data doesn't interrupt the transfer of image data, as the header is transferred in advance. The drawback of this practice is that the operator's output transfer starts earlier than the actual image data transfer. This may cause irritations under specific circumstances:  If you are using the operator <code>SourceSelector</code> directly after <code>JPEG_Encoder</code>: Operator <code>SourceSelector</code> registers a partly processed frame as soon as it gets the header data. Therefore, if <code>SourceSelector</code> is switched to getting image data from <code>JPEG_Encoder</code>, <code>SourceSelector</code> cannot be switched to any another source as it always detects an unfinished frame. In addition, when header generation is enabled and <code>SourceSelector</code> switches from another source to the <code>JPEG_Encoder</code> channel, the first image is lost. Workaround: If working on eVA devices, make sure the output is capable to accept data transfer before the sensor transfer is started. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-3-1.html#library-filter","title":"Library Filter","text":""},{"location":"known-issues-visualapplets-release-3-3-1.html#operator-firkernelnxm","title":"Operator <code>FIRKernelNxM</code>","text":"Summary: Operator <code>FIRKernelNxM</code> May Cause Processing Errors Description: The operator <code>FIRKernelNxM</code> may cause processing errors in case parameter <code>EdgeHandling</code> is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame. Workaround: No workaround is available. Ticket ID: 2939"},{"location":"known-issues-visualapplets-release-3-3-1.html#library-hardware-platforms","title":"Library Hardware Platforms","text":""},{"location":"known-issues-visualapplets-release-3-3-1.html#trigger-operators","title":"Trigger Operators","text":"Summary: Trigger Operators May Cause Spikes at the Trigger Output Line Description: Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-3-1.html#library-memory","title":"Library Memory","text":""},{"location":"known-issues-visualapplets-release-3-3-1.html#operator-imagebuffermultiroidyn","title":"Operator <code>ImageBufferMultiRoiDyn</code>","text":"Summary: Timing Errors with Small Images Description: The operator <code>ImageBufferMultiRoiDyn</code> may cause timing errors in case of very small input images. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-3-1.html#operator-imagesequence","title":"Operator <code>ImageSequence</code>","text":"Summary: Build Errors Caused by the Operator <code>ImageSequence</code> Description: The operator <code>ImageSequence</code> may cause build errors (timing errors). Workaround: No workaround is available. Ticket ID: 2422"},{"location":"known-issues-visualapplets-release-3-3-2.html","title":"Known Issues VisualApplets Release 3.3.2","text":"<p>Info</p> <p>While Update 2301 for VisualApplets 3.3.2 enables using VisualApplets in Windows 11, for some installations of Vivado the build flow may stop after the step Design-Rules-Check-2 with the error message Error: -1 Error checking FPGA software. If you encounter this problem, then modify your build settings so that the precondition check is not activated.</p> <p>Info</p> <p>If you install the Windows 10 Fall Creators update (version 1709) on a computer that has Xilinx Vivado version 2017.2 or 2017.3 installed, Xilinx Vivado may not work properly. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>Follow the workaround provided by Xilinx Support to make your Xilinx Vivado 2017.2 or 2017.3 installation work again.</p> <p>Info</p> <p>If you install the above Windows 10 update, the build flow may not work properly using Xilinx tools older than Vivado 2017.4. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>For Vivado versions older than Vivado 2017.4, error messages may show up in the log output of the Xilinx tool chain telling that some black box instances have undefined content. For ISE, no Xilinx tool version can be determined and the FPGA type check fails.</p> <p>Follow the workaround provided by Xilinx Support to make the ISE installation work again (section \"ISE 14.7 64-bit - Turning off SmartHeap\"). The same workaround can be used for Vivado where you need to perform the file substitution actions in directory &lt;VivadoInstallDir&gt;/ids_lite/ISE/lib/nt64.</p>"},{"location":"known-issues-visualapplets-release-3-3-2.html#general","title":"General","text":"Summary: Tcl Scripts with <code>Color Flavor</code> Values <code>LAB</code>, <code>XYZ</code>, <code>HSL</code>, <code>HSV</code>, or <code>YCrCb</code> Cause Errors During Import Description: When exporting a design to a Tcl script with <code>Color Flavor</code> values <code>LAB</code>, <code>XYZ</code>, <code>HSL</code>, <code>HSV</code>, or <code>YCrCb</code> in the link properties, importing the design from the script leads to an error. Workaround: This problem is fixed in VisualApplets 3.4.0. Update your VisualApplets version to 3.4.0 Ticket ID: 258727 Summary: Loading Small Images in TIF Format Leads to Image Magick Error Description: Loading small images in TIF format sometimes fails with the error message Image Magick library: Image format is not supported. Error code: -70002. Workaround: In the VisualApplets System Settings, set I/O Image Library to Native, not to Image Magick. Or update your VisualApplets version to 3.4.0. Ticket ID: 265278 Summary: VisualApplets Sometimes Doesn't Detect a Vivado Version Number Description: If you build an applet with Vivado 2023.1 or higher, VisualApplets doesn't detect the Vivado version number. Workaround: Either update your VisualApplets version to 3.4.0 or patch the file vivado.bat in your Vivado installation by inserting the following lines directly after <code>@echo off</code>:  <code>if \"%1\"==\"-version\" (</code> <code>goto returnVersionInfo</code><code>) else (</code> <code>goto proceed</code><code>)</code><code>:returnVersionInfo</code><code>echo Vivado v2023.1 (64-bit)</code><code>:proceed</code> Ticket ID: 285232 Summary: Xilinx ISE Build Toolchain Doesn't Support Windows 11 Description: The Xilinx ISE build toolchain doesn't support Windows 11. Therefore, building VisualApplets designs doesn't work with Xilinx ISE. Workaround: If you want to build applets for platforms that need to be built with Xilinx ISE, install VisualApplets under Windows 10 or 8.1. If your target platform is supported by Vivado, build the applets with Xilinx Vivado (Vivado supports Windows 11). See in the system requirements which platforms are supported by Vivado. Ticket ID: 236990 Summary: Applets for mE5-CL Platforms Can't Be Built with some Xilinx Vivado Versions Description: Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1. Workaround: This problem has been fixed with Xilinx Vivado version 2021.2. Thus, to avoid this problem, use Vivado version 2021.2 or higher. Ticket ID: 217879 Summary: On Windows 8, You Must Define the User Directory as Destination Directory Description: On Microsoft Windows 8, you must define the user directory as the destination directory. Alternatively, any other directory with full access rights can be used. Workaround: No workaround is available. Ticket ID: \u2013 Summary: When Converting a Design to a Different Hardware Platform, the Hardware-Dependent Operator Library Might Not Be Available Description: When converting a VisualApplets design to a different hardware platform, then under certain circumstances the hardware-dependent operator library for the target platform might not be available. Workaround: To resolve this restart VisualApplets. Ticket ID: \u2013 Summary: You Need to Reset Simulation Conditions After a Simulation Error Description: After a simulation error has occurred, the simulation conditions need to be reset Workaround: No workaround is available. Ticket ID: \u2013 Summary: Xilinx Vivado Warning When Building an Applet Description: When you build an applet using the Xilinx Vivado Tools, you may get critical warnings (in build step LinkDesign). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. Example:<p><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint for instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance \u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the instance type. Instance \u2026/PART1174 belongs to a shape with reference instance \u2026/PART1175. Shape elements have relative placement respect to each other. The invalid location might results from a constraint on any of the instance in the shape.. </code></p> Workaround: Ignore the warnings. This issue is not critical for designs created in VisualApplets. Ticket ID: \u2013 Summary: Only ASCII Characters Are Supported for *.va File Names Description: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Configuration Is Only Saved For First Instance of VisualApplets Description: Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that have been started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Design Rules Check Error When M-Type Operators in a Hierarchical Box Are Connected Directly to the Input Port Description: If you are using hierarchical boxes, in some specific situations, the Design Rules Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. Workaround: You can solve this problem (within the hierarchical box) by placing an NOP operator between the input port of the hierarchical box and the input port of the M-type operator. Ticket ID: \u2013 Summary: Design Rules Check Error When Using the Line-by-Line 1D Simulation Mode Description: For some designs which passed the Design Rules Check in former versions of VisualApplets, link errors concerning the max. image height may be reported. In particular this may happen when 1D processing is involved and the new line-by-line simulation mode is activated (default). The reason is that in the line-by-line-mode some operators propagate the max. image height of input links in a different way to the output links than before. Workaround: You can solve this problem by changing to the legacy simulation mode or by adding SetDimension modules for adjusting the max. image height values. Ticket ID: \u2013 Summary: Increased Operating Time When Using the Line-by-Line 1D Simulation Mode Description: For some designs the operating time for simulation may be much higher than in former versions of VisualApplets. In particular this may happen when 1D processing is involved, the new line-by-line simulation mode is activated (default), and the design contains many simulation probes. Workaround: You can solve this problem by changing to the legacy simulation mode or by reducing the number of simulation probes. Ticket ID: \u2013 Summary: SDK for CXP: Access to the SISO_GenICam Library Have to Be Programmed by the User Description: SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Increasing the FPGA Design Clock Frequency May Lead to Slow Builds Description: Increasing the FPGA design clock frequency may have the result that the build flow takes very long or even fails because timing constraints cannot be met. This strongly depends on the content of the VisualApplets design. Workaround: No workaround is available. Ticket ID: 8513 Summary: Large Images Are Not Displayed in Simulation Probes Description: When simulation probes contain very large images, VisualApplets may fail to display these images correctly due to memory limitations. In that case, a gray image (i.e. all pixels have the value 205 (0xCD)) is shown. Workaround: Use smaller images for simulation. Ticket ID: 6822 Summary: Simulation Only Supports Images Smaller than 2 GB Description: During simulation the internal buffer size for any image is limited to 2 GB. Simulations with an image that is larger than 2 GB, the simulation is stopped with an error message. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Or use images smaller than 2 GB for simulation. Ticket ID: 240989"},{"location":"known-issues-visualapplets-release-3-3-2.html#library-blob","title":"Library Blob","text":""},{"location":"known-issues-visualapplets-release-3-3-2.html#operator-blob_analysis_1d","title":"Operator <code>Blob_Analysis_1D</code>","text":"Summary: The Operator <code>Blob_Analysis_1D</code> Sets the Flag <code>object size exceeds maximum</code> Not as Expected Description: If an object is truncated due to exceeding the maximum size defined by parameter <code>max_object_height_bits</code>, the corresponding flag <code>object size exceeds maximum</code> is set in the truncated object and not in the proceeding object. Workaround: No workaround is available. Ticket ID: 9685 Summary: The Operator <code>Blob_Analysis_1D</code> Does Not Set the Flag <code>label overflow</code> Description: The flag <code>label overflow</code> indicating that all labels are in use and the current object cannot be tagged, is never set. Workaround: No workaround is available. Ticket ID: 9691 Summary: The Operator <code>Blob_Analysis_1D</code> Allows 20 Labels Less Than Defined per Line Description: The amount of available labels as defined via the parameter <code>Label_bits</code> is reduced by 20 labels. For example, if <code>Label_bits</code> is set to 5, only 12 (2^5 - 20) labels are available, and not 32 as expected (2^5). Workaround: No workaround is available. Ticket ID: 9688 Summary: The Simulation of The Operator <code>Blob_Analysis_1D</code> is Not Equal to Hardware Behavior Description: The order of the object feature output might differ in hardware and software. This is so, because the hardware output depends on the timing of the data which cannot be simulated in VisualApplets. Additionally, the FlushI input is asynchronous to the image data input, so completing output frames may not be simulated in a realistic way. Workaround: No workaround is available. Ticket ID: 7709"},{"location":"known-issues-visualapplets-release-3-3-2.html#library-color","title":"Library Color","text":"Summary: Some Color Conversions Don't Work As Expected Description: Operators of the Color library should be used carefully: Some color conversions don't work as a user would assume:<ul><li>HSI2RGB converts HSL -&gt; RGB ,</li><li>RGB2YUV converts RGB-&gt;YCbCr,</li><li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com </li></ul> Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-3-2.html#operator-colortransform","title":"Operator <code>ColorTransform</code>","text":"Summary: Limitations for Negative Transformations Coefficients Description: Operator <code>ColorTransform</code> supports negative transformation coefficients only for the case when the input format is signed or the coefficients are static. Workaround: No workaround is available. Ticket ID: 251344"},{"location":"known-issues-visualapplets-release-3-3-2.html#operator-bayer5x5linear","title":"Operator <code>BAYER5x5Linear</code>","text":"Summary: The Resource Estimation in VisualApplets for <code>BAYER5x5Linear</code> Differs From the Estimation in Xilinx Description: <code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in dialog FPGA Resource Usage) might differ from the estimation displayed by the Xilinx tools after Place &amp; Route. Workaround: No workaround is available. Ticket ID: 6426"},{"location":"known-issues-visualapplets-release-3-3-2.html#library-compression","title":"Library Compression","text":""},{"location":"known-issues-visualapplets-release-3-3-2.html#operator-jpeg_encoder","title":"Operator <code>JPEG_Encoder</code>","text":"Summary: The Output Transfer Of the Operator <code>JPEG_Encoder</code> Starts Earlier Than the Actual Image Data Transfer Description: Operator : To optimize its image throughput rate (band width), the operator outputs the header as soon as header generation is activated - even before image data arrive at the operator's input. This way, the transfer of the header data doesn't interrupt the transfer of image data, as the header is transferred in advance. The drawback of this practice is that the operator's output transfer starts earlier than the actual image data transfer. This may cause irritations under specific circumstances:  If you are using the operator <code>SourceSelector</code> directly after <code>JPEG_Encoder</code>: Operator <code>SourceSelector</code> registers a partly processed frame as soon as it gets the header data. Therefore, if <code>SourceSelector</code> is switched to getting image data from <code>JPEG_Encoder</code>, <code>SourceSelector</code> cannot be switched to any another source as it always detects an unfinished frame. In addition, when header generation is enabled and <code>SourceSelector</code> switches from another source to the <code>JPEG_Encoder</code> channel, the first image is lost. Workaround: If working on eVA devices, make sure the output is capable to accept data transfer before the sensor transfer is started. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-3-2.html#library-debugging","title":"Library Debugging","text":""},{"location":"known-issues-visualapplets-release-3-3-2.html#operator-imageflowcontrol","title":"Operator <code>ImageFlowControl</code>","text":"Summary: Damaged Frame After an Overflow Situation Description: Using the operator <code>ImageFlowControl</code> in dummy frame generation mode may result in a damaged frame as output. This happens after an overflow situation, when a series of dummy frames is emitted for compensating lost frames. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Ticket ID: 248227"},{"location":"known-issues-visualapplets-release-3-3-2.html#library-filter","title":"Library Filter","text":""},{"location":"known-issues-visualapplets-release-3-3-2.html#operator-firkernelnxm","title":"Operator <code>FIRKernelNxM</code>","text":"Summary: Operator <code>FIRKernelNxM</code> May Cause Processing Errors Description: The operator <code>FIRKernelNxM</code> may cause processing errors in case parameter <code>EdgeHandling</code> is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame. Workaround: No workaround is available. Ticket ID: 2939"},{"location":"known-issues-visualapplets-release-3-3-2.html#library-hardware-platforms","title":"Library Hardware Platforms","text":""},{"location":"known-issues-visualapplets-release-3-3-2.html#trigger-operators","title":"Trigger Operators","text":"Summary: Trigger Operators May Cause Spikes at the Trigger Output Line Description: Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-3-2.html#library-memory","title":"Library Memory","text":""},{"location":"known-issues-visualapplets-release-3-3-2.html#operator-imagebuffermultiroidyn","title":"Operator <code>ImageBufferMultiRoiDyn</code>","text":"Summary: Timing Errors with Small Images Description: The operator <code>ImageBufferMultiRoiDyn</code> may cause timing errors in case of very small input images. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-3-2.html#operator-imagesequence","title":"Operator <code>ImageSequence</code>","text":"Summary: Build Errors Caused by the Operator <code>ImageSequence</code> Description: The operator <code>ImageSequence</code> may cause build errors (timing errors). Workaround: No workaround is available. Ticket ID: 2422"},{"location":"known-issues-visualapplets-release-3-4-0.html","title":"Known Issues VisualApplets Release 3.4.0","text":"<p>Info</p> <p>If you install the Windows 10 Fall Creators update (version 1709) on a computer that has Xilinx Vivado version 2017.2 or 2017.3 installed, Xilinx Vivado may not work properly. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>Follow the workaround provided by Xilinx Support to make your Xilinx Vivado 2017.2 or 2017.3 installation work again.</p> <p>Info</p> <p>If you install the above Windows 10 update, the build flow may not work properly using Xilinx tools older than Vivado 2017.4. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>For Vivado versions older than Vivado 2017.4, error messages may show up in the log output of the Xilinx tool chain telling that some black box instances have undefined content. For ISE, no Xilinx tool version can be determined and the FPGA type check fails.</p> <p>Follow the workaround provided by Xilinx Support to make the ISE installation work again (section \"ISE 14.7 64-bit - Turning off SmartHeap\"). The same workaround can be used for Vivado where you need to perform the file substitution actions in directory &lt;VivadoInstallDir&gt;/ids_lite/ISE/lib/nt64.</p>"},{"location":"known-issues-visualapplets-release-3-4-0.html#general","title":"General","text":"Summary: VisualApplets Opened in Multiple Instances Reads the Build Setting Configuration Only in the First Instance Description: When opening multiple instances of VisualApplets, the build settings configuration is read only for the first instance, while the other instances use the default build settings instead. Workaround: No workaround is available. Ticket ID: 309983 Summary: The Automatic Update Notification Doesn't Work Description: For VisualApplets 3.4.0, the automatic update notification doesn't work. This means that you aren't notified automatically when a new version of VisualApplets is available. Workaround: Check for updates of VisualApplets regularily and manually on the Basler Downolads Software site. Ticket ID: 311264 Summary: VisualApplets Might Freeze When Building Applets with Vivado 2024.1 Description: When Vivado 2024.1 is installed, VisualApplets might freeze while detecting the Vivado version information from Vivado.exe. Workaround: To resolve the freeze, terminate the Vivado.exe process. You can then set a different working directory via the Tcl console, e.g. via command cd c:, which enables you to call the build flow. Basler doesn't recommend using Vivado 2024.1 or higher. Use Vivado versions up to 2023.2 instead. Ticket ID: 309714 Summary: For mE5-Platforms and imaFlex-Platforms the Resource Estimation May Be Too Low Description: For mE5- and imaFlex-platforms, the resource estimation for some operators (i.e. <code>Blob</code> and <code>Histogram</code>) may underestimate the number of used block RAMs. Depending on the module configuration, the real usage of block RAM ressources can be more than 50 % higher. Workaround: No workaround is available. Ticket ID: 297790 Summary: Copying Content Using the Clipboard Doesn\u2019t Work Description: It's not possible to copy design content from designs opened in VisualApplets 3.4.0 to designs opened in previous VisualApplets versions using the clipboard (copy&amp;paste). However, copying from previous VisualApplet versions to VisualApplets 3.4.0 works. Workaround: Save your design in the legacy *.va file format, open it in an older version of VisualApplets and copy the content from there. Ticket ID: \u2013 Summary: RGB Images Loaded into the Simulation Probe Viewer Might Be Saved as Mono Image (8-Bit) Description: In the Simulation Probe Viewer, RGB Images that contain the same values across the color channels are saved as a mono image (i.e. 8-bit image), not as 24-bit image. Workaround: If you want to preserve the channels, save your image in the BMP file format. Ticket ID: 266977 Summary: On imaFlex CXP-12 Quad, Custom Operators can't Use the Memory Interface Description: On the imaFlex CXP-12 Quad platform, custom operators can't use the memory interface. Workaround: No workaround is available. Ticket ID: 240876 Summary: Xilinx ISE Build Toolchain Doesn't Support Windows 11 Description: The Xilinx ISE build toolchain doesn't support Windows 11. Therefore, building VisualApplets designs doesn't work with Xilinx ISE. Workaround: If you want to build applets for platforms that need to be built with Xilinx ISE, install VisualApplets under Windows 10. If your target platform is supported by Vivado, build the applets with Xilinx Vivado (Vivado supports Windows 11). See in the system requirements which platforms are supported by Vivado. Ticket ID: 236990 Summary: Applets for mE5-CL Platforms Can't Be Built with some Xilinx Vivado Versions Description: Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1. Workaround: This problem has been fixed with Xilinx Vivado version 2021.2. Thus, to avoid this problem, use Vivado version 2021.2 or higher. Ticket ID: 217879 Summary: When Converting a Design to a Different Hardware Platform, the Hardware-Dependent Operator Library Might Not Be Available Description: When converting a VisualApplets design to a different hardware platform, then, under certain circumstances, the hardware-dependent operator library for the target platform might not be available. Workaround: To resolve this, restart VisualApplets. Ticket ID: \u2013 Summary: Xilinx Vivado Warning When Building an Applet Description: When you build an applet using the Xilinx Vivado tools, you may get critical warnings (in build step LinkDesign). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. Example:<p><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint for instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance \u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the instance type. Instance \u2026/PART1174 belongs to a shape with reference instance \u2026/PART1175. Shape elements have relative placement respect to each other. The invalid location might result from a constraint on any of the instance in the shape.. </code></p> Workaround: Ignore the warnings. This issue is not critical for designs created in VisualApplets. Ticket ID: \u2013 Summary: Only ASCII Characters Are Supported for *.va File Names Description: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Configuration Is Only Saved For First Instance of VisualApplets Description: Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that are started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Design Rules Check Error When M-Type Operators in a Hierarchical Box Are Connected Directly to the Input Port Description: If you are using hierarchical boxes, in some specific situations, the Design Rules Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. Workaround: You can solve this problem (within the hierarchical box) by placing a NOP operator between the input port of the hierarchical box and the input port of the M-type operator. Ticket ID: \u2013 Summary: Design Rules Check Error When Using the Line-by-Line 1D Simulation Mode Description: For some designs which passed the Design Rules Check in former versions of VisualApplets, link errors concerning the maximum image height may be reported. In particular this may happen when 1D processing is involved and the new line-by-line simulation mode is activated (default). The reason is that in the line-by-line-mode some operators propagate the max. image height of input links in a different way to the output links than before. Workaround: You can solve this problem by changing to the legacy simulation mode or by adding SetDimension modules for adjusting the maximum image height values. Ticket ID: \u2013 Summary: Increased Operating Time When Using the Line-by-Line 1D Simulation Mode Description: For some designs the operating time for simulation may be much higher than in former versions of VisualApplets. In particular, this may happen when 1D processing is involved, the new line-by-line simulation mode is activated (default), and the design contains many simulation probes. Workaround: You can solve this problem by changing to the legacy simulation mode or by reducing the number of simulation probes. Ticket ID: \u2013 Summary: SDK for CXP: Accesses to the SISO_GenICam Library Have to Be Programmed by the User Description: SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Increasing the FPGA Design Clock Frequency May Lead to Slow Builds Description: Increasing the FPGA design clock frequency may have the result that the build flow takes very long or even fails because timing constraints cannot be met. This strongly depends on the content of the VisualApplets design. Workaround: No workaround is available. Ticket ID: 8513 Summary: Large Images Are Not Displayed in Simulation Probes Description: When simulation probes contain very large images, VisualApplets may fail to display these images correctly due to memory limitations. In that case, a gray image (i.e. all pixels have the value 205 (0xCD)) is shown. Workaround: Use smaller images for simulation. Ticket ID: 6822 Summary: Simulation Only Supports Images Smaller than 2 GB Description: During simulation the internal buffer size for any image is limited to 2 GB. For simulations with images larger than 2 GB, the simulation is stopped with an error message. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Or use images smaller than 2 GB for simulation. Ticket ID: 240989"},{"location":"known-issues-visualapplets-release-3-4-0.html#library-blob","title":"Library Blob","text":""},{"location":"known-issues-visualapplets-release-3-4-0.html#blob_analysis_1d-operator","title":"<code>Blob_Analysis_1D</code> Operator","text":"Summary: The <code>Blob_Analysis_1D</code> Operator Sets the <code>object size exceeds maximum</code> Flag Not as Expected Description: If an object is truncated due to exceeding the maximum size defined by the <code>max_object_height_bits</code> parameter, the corresponding <code>object size exceeds maximum</code> flag is set in the truncated object and not in the proceeding object. Workaround: No workaround is available. Ticket ID: 9685 Summary: The <code>Blob_Analysis_1D</code> Operator Does Not Set the <code>label overflow</code> Flag Description: The <code>label overflow</code> flag indicating that all labels are in use and the current object cannot be tagged, is never set. Workaround: No workaround is available. Ticket ID: 9691 Summary: The <code>Blob_Analysis_1D</code> Operator Allows 20 Labels Less Than Defined per Line Description: The amount of available labels as defined via the <code>Label_bits</code> parameter is reduced by 20 labels. For example, if <code>Label_bits</code> is set to 5, only 12 (2^5 - 20) labels are available, and not 32 as expected (2^5). Workaround: No workaround is available. Ticket ID: 9688 Summary: The Simulation of The <code>Blob_Analysis_1D</code> Operator is Not Equal to Hardware Behavior Description: The order of the object feature output might differ in hardware and software. This is so, because the hardware output depends on the timing of the data which cannot be simulated in VisualApplets. Additionally, the FlushI input is asynchronous to the image data input, so completing output frames may not be simulated in a realistic way. Workaround: No workaround is available. Ticket ID: 7709"},{"location":"known-issues-visualapplets-release-3-4-0.html#library-color","title":"Library Color","text":"Summary: Some Color Conversions Don't Work As Expected Description: Operators of the Color library should be used carefully: Some color conversions don't work as a user would assume:<ul><li>HSI2RGB converts HSL -&gt; RGB ,</li><li>RGB2YUV converts RGB-&gt;YCbCr,</li><li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com </li></ul> Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-4-0.html#colortransform-operator","title":"<code>ColorTransform</code> Operator","text":"Summary: Limitations for Negative Transformations Coefficients Description: The <code>ColorTransform</code> operator supports negative transformation coefficients only in the case where the input format is signed or the coefficients are static. Workaround: No workaround is available. Ticket ID: 251344"},{"location":"known-issues-visualapplets-release-3-4-0.html#bayer5x5linear-operator","title":"<code>BAYER5x5Linear</code> Operator","text":"Summary: The Resource Estimation in VisualApplets for <code>BAYER5x5Linear</code> Differs From the Estimation in Xilinx Description: <code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in dialog FPGA Resource Usage) might differ from the estimation displayed by the Xilinx tools after Place &amp; Route. Workaround: No workaround is available. Ticket ID: 6426"},{"location":"known-issues-visualapplets-release-3-4-0.html#library-compression","title":"Library Compression","text":""},{"location":"known-issues-visualapplets-release-3-4-0.html#jpeg_encoder-operator","title":"<code>JPEG_Encoder</code> Operator","text":"Summary: The Output Transfer Of the Operator <code>JPEG_Encoder</code> Starts Earlier Than the Actual Image Data Transfer Description: Operator : To optimize its image throughput rate (band width), the operator outputs the header as soon as header generation is activated - even before image data arrive at the operator's input. This way, the transfer of the header data doesn't interrupt the transfer of image data, as the header is transferred in advance. The drawback of this practice is that the operator's output transfer starts earlier than the actual image data transfer. This may cause irritations under specific circumstances:  If you are using the <code>SourceSelector</code> operator directly after <code>JPEG_Encoder</code>: The <code>SourceSelector</code> operator registers a partly processed frame as soon as it gets the header data. Therefore, if <code>SourceSelector</code> is switched to getting image data from <code>JPEG_Encoder</code>, <code>SourceSelector</code> cannot be switched to any another source as it always detects an unfinished frame. In addition, when header generation is enabled and <code>SourceSelector</code> switches from another source to the <code>JPEG_Encoder</code> channel, the first image is lost. Workaround: If working on eVA devices, make sure the output is capable to accept data transfer before the sensor transfer is started. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-4-0.html#library-debugging","title":"Library Debugging","text":""},{"location":"known-issues-visualapplets-release-3-4-0.html#imageflowcontrol-operator","title":"<code>ImageFlowControl</code> Operator","text":"Summary: Damaged Frame After an Overflow Situation Description: Using the <code>ImageFlowControl</code> operator in dummy frame generation mode may result in a damaged frame as output. This happens after an overflow situation, when a series of dummy frames is emitted for compensating lost frames. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Ticket ID: 248227"},{"location":"known-issues-visualapplets-release-3-4-0.html#library-filter","title":"Library Filter","text":""},{"location":"known-issues-visualapplets-release-3-4-0.html#dilate-operator","title":"<code>DILATE</code> Operator","text":"Summary: In the Hardware Implementation of the<code>DILATE</code> Operator, the Structuring Element Is Rotated Description: The hardware implementation of the <code>DILATE</code> operator differs from the simulation and the documentation. In the hardware inplementation, the structuring element is rotated. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Ticket ID: 267460"},{"location":"known-issues-visualapplets-release-3-4-0.html#firkernelnxm-operator","title":"<code>FIRKernelNxM</code> Operator","text":"Summary: Operator <code>FIRKernelNxM</code> May Cause Processing Errors Description: The <code>FIRKernelNxM</code> operator may cause processing errors in case the <code>EdgeHandling</code> parameter is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame. Workaround: No workaround is available. Ticket ID: 2939"},{"location":"known-issues-visualapplets-release-3-4-0.html#library-hardware-platforms","title":"Library Hardware Platforms","text":""},{"location":"known-issues-visualapplets-release-3-4-0.html#trigger-operators","title":"Trigger Operators","text":"Summary: Trigger Operators May Cause Spikes at the Trigger Output Line Description: Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-4-0.html#library-memory","title":"Library Memory","text":""},{"location":"known-issues-visualapplets-release-3-4-0.html#ramlutoperator","title":"<code>RamLUT</code>Operator","text":"Summary: Writing Intialization Data to the <code>RamLUT</code> Operator during Acquisition Has No Effect on imaFlex Platforms Description: Writing intialization data to the <code>RamLUT</code> operator during acquisition has no effect on imaFlex platforms. Configuring memory content is only possible when the acquisition is stopped. Workaround: Stop the acquisition before writing intialization data to the <code>RamLUT</code> operator. Or update VisualApplets to version 3.6.0, since this issue has been fixed in VisualApplets 3.6.0. Ticket ID: 319280"},{"location":"known-issues-visualapplets-release-3-4-0.html#linememory-operator","title":"<code>LineMemory</code> Operator","text":"Summary: Dynamic Parameters Can't be Edited During Runtime Description: In applets built with VisualApplets versions 3.4.0 and 3.4.1 it isn't possible to modify the dynamic parameters <code>XOffset</code> and <code>XLength</code> of the <code>LineMemory</code> operator during runtime. Workaround: This has been fixed in VisualApplets version 3.5.0. Update your VisualApplets version to 3.5.0. Ticket ID: 312662"},{"location":"known-issues-visualapplets-release-3-4-0.html#imagebuffermultiroidyn-operator","title":"<code>ImageBufferMultiRoiDyn</code> Operator","text":"Summary: Timing Errors with Small Images Description: The <code>ImageBufferMultiRoiDyn</code> operator may cause timing errors in case of very small input images. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-4-0.html#imagesequence-operator","title":"<code>ImageSequence</code> Operator","text":"Summary: Build Errors Caused by the Operator <code>ImageSequence</code> Description: The <code>ImageSequence</code> operator may cause build errors (timing errors). Workaround: No workaround is available. Ticket ID: 2422"},{"location":"known-issues-visualapplets-release-3-4-1.html","title":"Known Issues VisualApplets Release 3.4.1","text":"<p>Info</p> <p>If you install the Windows 10 Fall Creators update (version 1709) on a computer that has Xilinx Vivado version 2017.2 or 2017.3 installed, Xilinx Vivado may not work properly. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>Follow the workaround provided by Xilinx Support to make your Xilinx Vivado 2017.2 or 2017.3 installation work again.</p> <p>Info</p> <p>If you install the above Windows 10 update, the build flow may not work properly using Xilinx tools older than Vivado 2017.4. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>For Vivado versions older than Vivado 2017.4, error messages may show up in the log output of the Xilinx tool chain telling that some black box instances have undefined content. For ISE, no Xilinx tool version can be determined and the FPGA type check fails.</p> <p>Follow the workaround provided by Xilinx Support to make the ISE installation work again (section \"ISE 14.7 64-bit - Turning off SmartHeap\"). The same workaround can be used for Vivado where you need to perform the file substitution actions in the &lt;VivadoInstallDir&gt;/ids_lite/ISE/lib/nt64 directory.</p>"},{"location":"known-issues-visualapplets-release-3-4-1.html#general","title":"General","text":"Summary: VisualApplets Opened in Multiple Instances Reads the Build Setting Configuration Only in the First Instance Description: When opening multiple instances of VisualApplets, the build settings configuration is read only for the first instance, while the other instances use the default build settings instead. Workaround: No workaround is available. Ticket ID: 309983 Summary: The Automatic Update Notification Doesn't Work Description: For VisualApplets 3.4.1, the automatic update notification doesn't work. This means that you aren't notified automatically when a new version of VisualApplets is available. Workaround: Check for updates of VisualApplets regularily and manually on the Basler Downolads Software site. Ticket ID: 311264 Summary: For mE5 Platforms and imaFlex Platforms the Resource Estimation May Be Too Low Description: For mE5- and imaFlex platforms, the resource estimation for some operators (i.e. <code>Blob</code> and <code>Histogram</code>) may underestimate the number of used block RAMs. Depending on the module configuration, the real usage of block RAM ressources can be more than 50 % higher. Workaround: No workaround is available. Ticket ID: 297790 Summary: Copying Content Using the Clipboard Doesn\u2019t Work Description: It's not possible to copy design content from designs opened in this VisualApplets version into designs opened in VisualApplets versions 3.3.2 or earlier using the clipboard (copy&amp;paste). However, copying from any VisualApplet version to this version works. Workaround: Save your design in the legacy *.va file format, open it in an older version of VisualApplets and copy the content from there. Ticket ID: \u2013 Summary: RGB Images Loaded into the Simulation Probe Viewer Might Be Saved as Mono Image (8 Bit) Description: In the Simulation Probe Viewer, RGB images that contain the same values across the color channels are saved as mono image (i.e. 8-bit image), not as 24-bit image. Workaround: If you want to preserve the channels, save your image in the BMP file format. Ticket ID: 266977 Summary: On imaFlex CXP-12 Quad, Custom Operators can't Use the Memory Interface Description: On the imaFlex CXP-12 Quad platform, custom operators can't use the memory interface. However, the usual memory interface via the native memory operators works for the imaFlex CXP-12 Quad platform. Workaround: No workaround is available. Ticket ID: 240876 Summary: Xilinx ISE Build Tool Chain Doesn't Support Windows 11 Description: The Xilinx ISE build tool chain doesn't support Windows 11. Therefore, building VisualApplets designs doesn't work with Xilinx ISE. Workaround: If you want to build applets for platforms that need to be built with Xilinx ISE, install VisualApplets under Windows 10. If your target platform is supported by Vivado, build the applets with Xilinx Vivado (Vivado supports Windows 11). See in the system requirements section which platforms are supported by Vivado. Ticket ID: 236990 Summary: Applets for mE5-CL Platforms Can't Be Built with some Xilinx Vivado Versions Description: Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1. Workaround: This problem has been fixed with Xilinx Vivado version 2021.2. Thus, to avoid this problem, use Vivado version 2021.2 or higher. Ticket ID: 217879 Summary: When Converting a Design to a Different Hardware Platform, the Hardware-Dependent Operator Library Might Not Be Available Description: When converting a VisualApplets design to a different hardware platform, under certain circumstances the hardware-dependent operator library for the target platform might not be available. Workaround: To resolve this, restart VisualApplets. Ticket ID: \u2013 Summary: Xilinx Vivado Warning When Building an Applet Description: When you build an applet using the Xilinx Vivado tools, you may get critical warnings (during the LinkDesign build step). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. Example:<p><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint for instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance \u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the instance type. Instance \u2026/PART1174 belongs to a shape with reference instance \u2026/PART1175. Shape elements have relative placement respect to each other. The invalid location might result from a constraint on any of the instance in the shape.. </code></p> Workaround: Ignore the warnings. This issue is not critical for designs created in VisualApplets. Ticket ID: \u2013 Summary: Only ASCII Characters Are Supported for *.va File Names Description: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Configuration Is Only Saved For First Instance of VisualApplets Description: Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that are started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Design Rules Check Error When M-Type Operators in a Hierarchical Box Are Connected Directly to the Input Port Description: If you are using hierarchical boxes, in some specific situations, the Design Rules Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. Workaround: You can solve this problem (within the hierarchical box) by placing a NOP operator between the input port of the hierarchical box and the input port of the M-type operator. Ticket ID: \u2013 Summary: Design Rules Check Error When Using the Line-by-Line 1D Simulation Mode Description: For some designs which passed the Design Rules Check in former versions of VisualApplets, link errors concerning the maximum image height may be reported. In particular, this may happen when 1D processing is involved and the new line-by-line simulation mode is activated (default). The reason is that in the line-by-line-mode some operators propagate the max. image height of input links in a different way to the output links than before. Workaround: You can solve this problem by changing to the legacy simulation mode or by adding SetDimension modules for adjusting the maximum image height values. Ticket ID: \u2013 Summary: Increased Operating Time When Using the Line-by-Line 1D Simulation Mode Description: For some designs the operating time for simulation may be much higher than in former versions of VisualApplets. In particular, this may happen when 1D processing is involved, the new line-by-line simulation mode is activated (default), and the design contains many simulation probes. Workaround: You can solve this problem by changing to the legacy simulation mode or by reducing the number of simulation probes. Ticket ID: \u2013 Summary: SDK for CXP: Accesses to the SISO_GenICam Library Have to Be Programmed by the User Description: SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Increasing the FPGA Design Clock Frequency May Lead to Slow Builds Description: Increasing the FPGA design clock frequency may have the result that the build flow takes very long or even fails because timing constraints cannot be met. This strongly depends on the content of the VisualApplets design. Workaround: No workaround is available. Ticket ID: 8513 Summary: Large Images Are Not Displayed in Simulation Probes Description: When simulation probes contain very large images, VisualApplets may fail to display these images correctly due to memory limitations. In that case, a gray image (i.e. all pixels have the value 205 (0xCD)) is shown. Workaround: Use smaller images for simulation. Ticket ID: 6822 Summary: Simulation Only Supports Images Smaller than 2 GB Description: During simulation the internal buffer size for any image is limited to 2 GB. For simulations with images larger than 2 GB, the simulation is stopped with an error message. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Or use images smaller than 2 GB for simulation. Ticket ID: 240989"},{"location":"known-issues-visualapplets-release-3-4-1.html#blob_analysis_1d-operator","title":"<code>Blob_Analysis_1D</code> Operator","text":"Summary: The <code>Blob_Analysis_1D</code> Operator Sets the <code>object size exceeds maximum</code> Flag Not as Expected Description: If an object is truncated due to exceeding the maximum size defined by the <code>max_object_height_bits</code> parameter, the corresponding <code>object size exceeds maximum</code> flag is set in the truncated object and not in the proceeding object. Workaround: No workaround is available. Ticket ID: 9685 Summary: The <code>Blob_Analysis_1D</code> Operator Does Not Set the <code>label overflow</code> Flag Description: The <code>label overflow</code> flag indicating that all labels are in use and the current object cannot be tagged, is never set. Workaround: No workaround is available. Ticket ID: 9691 Summary: The <code>Blob_Analysis_1D</code> Operator Allows 20 Labels Less Than Defined per Line Description: The amount of available labels as defined by the <code>Label_bits</code> parameter is reduced by 20 labels. For example, if <code>Label_bits</code> is set to 5, only 12 (2^5 - 20) labels are available, and not 32 as expected (2^5). Workaround: No workaround is available. Ticket ID: 9688 Summary: The Simulation of The <code>Blob_Analysis_1D</code> Operator is Not Equal to Hardware Behavior Description: The order of the object feature output might differ in hardware and software. This is so, because the hardware output depends on the timing of the data which cannot be simulated in VisualApplets. Additionally, the FlushI input is asynchronous to the image data input, so completing output frames may not be simulated in a realistic way. Workaround: No workaround is available. Ticket ID: 7709"},{"location":"known-issues-visualapplets-release-3-4-1.html#library-color","title":"Library Color","text":"Summary: Some Color Conversions Don't Work As Expected Description: Operators of the Color library should be used carefully: Some color conversions don't work as a user would assume:<ul><li>HSI2RGB converts HSL -&gt; RGB</li><li>RGB2YUV converts RGB-&gt;YCbCr</li><li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com </li></ul> Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-4-1.html#colortransform-operator","title":"<code>ColorTransform</code> Operator","text":"Summary: Limitations for Negative Transformations Coefficients Description: The <code>ColorTransform</code> operator supports negative transformation coefficients only in the case where the input format is signed or the coefficients are static. Workaround: No workaround is available. Ticket ID: 251344"},{"location":"known-issues-visualapplets-release-3-4-1.html#bayer5x5linear-operator","title":"<code>BAYER5x5Linear</code> Operator","text":"Summary: The Resource Estimation in VisualApplets for <code>BAYER5x5Linear</code> Differs From the Estimation in Xilinx Description: <code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in FPGA Resource Usage dialog) might differ from the estimation displayed by the Xilinx tools after Place &amp; Route. Workaround: No workaround is available. Ticket ID: 6426"},{"location":"known-issues-visualapplets-release-3-4-1.html#library-compression","title":"Library Compression","text":""},{"location":"known-issues-visualapplets-release-3-4-1.html#jpeg_encoder-operator","title":"<code>JPEG_Encoder</code> Operator","text":"Summary: The Output Transfer Of the <code>JPEG_Encoder</code> Operator Starts Earlier Than the Actual Image Data Transfer Description: Operator: To optimize its image throughput rate (band width), the operator outputs the header as soon as header generation is activated - even before image data arrive at the operator's input. This way, the transfer of the header data doesn't interrupt the transfer of image data, as the header is transferred in advance. The drawback of this practice is that the operator's output transfer starts earlier than the actual image data transfer. This may cause irritations under specific circumstances:  If you are using the <code>SourceSelector</code> operator directly after <code>JPEG_Encoder</code>: The <code>SourceSelector</code> operator registers a partly processed frame as soon as it gets the header data. Therefore, if <code>SourceSelector</code> is switched to getting image data from <code>JPEG_Encoder</code>, <code>SourceSelector</code> cannot be switched to any another source as it always detects an unfinished frame. In addition, when header generation is enabled and <code>SourceSelector</code> switches from another source to the <code>JPEG_Encoder</code> channel, the first image is lost. Workaround: If working on eVA devices, make sure the output is capable to accept data transfer before the sensor transfer is started. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-4-1.html#library-debugging","title":"Library Debugging","text":""},{"location":"known-issues-visualapplets-release-3-4-1.html#imageflowcontrol-operator","title":"<code>ImageFlowControl</code> Operator","text":"Summary: Damaged Frame After an Overflow Situation Description: Using the <code>ImageFlowControl</code> operator in dummy frame generation mode may result in a damaged frame as output. This happens after an overflow situation, when a series of dummy frames is emitted for compensating lost frames. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Ticket ID: 248227"},{"location":"known-issues-visualapplets-release-3-4-1.html#library-filter","title":"Library Filter","text":""},{"location":"known-issues-visualapplets-release-3-4-1.html#dilate-operator","title":"<code>DILATE</code> Operator","text":"Summary: In the Hardware Implementation of the <code>DILATE</code> Operator, the Structuring Element Is Rotated Description: The hardware implementation of the <code>DILATE</code> operator differs from the simulation and the documentation. In the hardware inplementation, the structuring element is rotated. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Ticket ID: 267460"},{"location":"known-issues-visualapplets-release-3-4-1.html#firkernelnxm-operator","title":"<code>FIRKernelNxM</code> Operator","text":"Summary: <code>FIRKernelNxM</code> Operator May Cause Processing Errors Description: The <code>FIRKernelNxM</code> operator may cause processing errors in case the <code>EdgeHandling</code> parameter is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame. Workaround: No workaround is available. Ticket ID: 2939"},{"location":"known-issues-visualapplets-release-3-4-1.html#library-hardware-platforms","title":"Library Hardware Platforms","text":""},{"location":"known-issues-visualapplets-release-3-4-1.html#trigger-operators","title":"Trigger Operators","text":"Summary: Trigger Operators May Cause Spikes at the Trigger Output Line Description: Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Small Trigger Pulses Might Get Lost When Using the <code>CxpTxTrigger</code> Operator Description: The <code>CxpTxTrigger</code> operator can't handle trigger pulses that are only 1 to 5 cycles long. Small trigger pulses might get lost. Workaround: This has been fixed in VisualApplets version 3.5.0. Update your VisualApplets version to 3.5.0. Ticket ID: 306596"},{"location":"known-issues-visualapplets-release-3-4-1.html#library-memory","title":"Library Memory","text":""},{"location":"known-issues-visualapplets-release-3-4-1.html#ramlutoperator","title":"<code>RamLUT</code>Operator","text":"Summary: Writing Intialization Data to the <code>RamLUT</code> Operator during Acquisition Has No Effect on imaFlex Platforms Description: Writing intialization data to the <code>RamLUT</code> operator during acquisition has no effect on imaFlex platforms. Configuring memory content is only possible when the acquisition is stopped. Workaround: Stop the acquisition before writing intialization data to the <code>RamLUT</code> operator. Or update VisualApplets to version 3.6.0, since this issue has been fixed in VisualApplets 3.6.0. Ticket ID: 319280"},{"location":"known-issues-visualapplets-release-3-4-1.html#linememory-operator","title":"<code>LineMemory</code> Operator","text":"Summary: Dynamic Parameters Can't be Edited During Runtime Description: In applets built with VisualApplets versions 3.4.0 and 3.4.1 it isn't possible to modify the dynamic parameters <code>XOffset</code> and <code>XLength</code> of the <code>LineMemory</code> operator during runtime. Workaround: This has been fixed in VisualApplets version 3.5.0. Update your VisualApplets version to 3.5.0. Ticket ID: 312662"},{"location":"known-issues-visualapplets-release-3-4-1.html#imagebuffermultiroidyn-operator","title":"<code>ImageBufferMultiRoiDyn</code> Operator","text":"Summary: Timing Errors with Small Images Description: The <code>ImageBufferMultiRoiDyn</code> operator may cause timing errors in case of very small input images. Workaround: No workaround is available. Ticket ID: \u2013 Summary: The <code>ImageBufferMultiRoiDyn</code> Operator Doesn't Work Correctly for ROI Width Values Equal to <code>Parallelism</code> Description: If the value of <code>ROI Width</code> is equal to the value of <code>Parllelism</code>, the ROI isn't read out as expexted. Instead, the first pixel/line is repeated <code>ROI Height</code> times. Workaround: No workaround is available. Ticket ID: 307592"},{"location":"known-issues-visualapplets-release-3-4-1.html#imagesequence-operator","title":"<code>ImageSequence</code> Operator","text":"Summary: Build Errors Caused by the <code>ImageSequence</code> Operator Description: The <code>ImageSequence</code> operator may cause build errors (timing errors). Workaround: No workaround is available. Ticket ID: 2422"},{"location":"known-issues-visualapplets-release-3-5-0.html","title":"Known Issues VisualApplets Release 3.5.0","text":"<p>Info</p> <p>If you install the Windows 10 Fall Creators update (version 1709) on a computer that has Xilinx Vivado version 2017.2 or 2017.3 installed, Xilinx Vivado may not work properly. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>Follow the workaround provided by Xilinx Support to make your Xilinx Vivado 2017.2 or 2017.3 installation work again.</p> <p>Info</p> <p>If you install the above Windows 10 update, the build flow may not work properly using Xilinx tools older than Vivado 2017.4. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>For Vivado versions older than Vivado 2017.4, error messages may show up in the log output of the Xilinx tool chain telling that some black box instances have undefined content. For ISE, no Xilinx tool version can be determined and the FPGA type check fails.</p> <p>Follow the workaround provided by Xilinx Support to make the ISE installation work again (section \"ISE 14.7 64-bit - Turning off SmartHeap\"). The same workaround can be used for Vivado where you need to perform the file substitution actions in the &lt;VivadoInstallDir&gt;/ids_lite/ISE/lib/nt64 directory.</p>"},{"location":"known-issues-visualapplets-release-3-5-0.html#general","title":"General","text":"Summary: Applets Can't Be Built with Xilinx Vivado 2024.2 Description: If you build applets with Xilinx Vivado version 2024.2 or higher, the build flow may fail because of crashes in Vivado. Workaround: This issue has been fixed in VisualApplets version 3.5.1, update your VisualApplets installation to version 3.5.1. Alternatively, use a different Xilinx Vivado version. Ticket ID: 320463 Summary: For mE5 Platforms and imaFlex Platforms the Resource Estimation May Be Too Low Description: For mE5- and imaFlex platforms, the resource estimation for some operators (i.e. <code>Blob</code> and <code>Histogram</code>) may underestimate the number of used block RAMs. Depending on the module configuration, the real usage of block RAM ressources can be more than 50 % higher. Workaround: No workaround is available. Ticket ID: 297790 Summary: Copying Content Using the Clipboard Doesn\u2019t Work Description: It's not possible to copy design content from designs opened in this VisualApplets version into designs opened in VisualApplets versions 3.3.2 or earlier using the clipboard (copy&amp;paste). However, copying from any VisualApplet version to this version works. Workaround: Save your design in the legacy *.va file format, open it in an older version of VisualApplets and copy the content from there. Ticket ID: \u2013 Summary: RGB Images Loaded into the Simulation Probe Viewer Might Be Saved as Mono Image (8 Bit) Description: In the Simulation Probe Viewer, RGB images that contain the same values across the color channels are saved as mono image (i.e. 8-bit image), not as 24-bit image. Workaround: If you want to preserve the channels, save your image in the BMP file format. Ticket ID: 266977 Summary: Xilinx ISE Build Tool Chain Doesn't Support Windows 11 Description: The Xilinx ISE build tool chain doesn't support Windows 11. Therefore, building VisualApplets designs doesn't work with Xilinx ISE. Workaround: If you want to build applets for platforms that need to be built with Xilinx ISE, install VisualApplets under Windows 10. If your target platform is supported by Vivado, build the applets with Xilinx Vivado (Vivado supports Windows 11). See in the system requirements section which platforms are supported by Vivado. Ticket ID: 236990 Summary: Applets for mE5-CL Platforms Can't Be Built with some Xilinx Vivado Versions Description: Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1. Workaround: This problem has been fixed with Xilinx Vivado version 2021.2. Thus, to avoid this problem, use Vivado version 2021.2 or higher. Ticket ID: 217879 Summary: When Converting a Design to a Different Hardware Platform, the Hardware-Dependent Operator Library Might Not Be Available Description: When converting a VisualApplets design to a different hardware platform, under certain circumstances the hardware-dependent operator library for the target platform might not be available. Workaround: To resolve this, restart VisualApplets. Ticket ID: \u2013 Summary: Xilinx Vivado Warning When Building an Applet Description: When you build an applet using the Xilinx Vivado tools, you may get critical warnings (during the LinkDesign build step). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. Example:<p><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint for instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance \u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the instance type. Instance \u2026/PART1174 belongs to a shape with reference instance \u2026/PART1175. Shape elements have relative placement respect to each other. The invalid location might result from a constraint on any of the instance in the shape.. </code></p> Workaround: Ignore the warnings. This issue is not critical for designs created in VisualApplets. Ticket ID: \u2013 Summary: Only ASCII Characters Are Supported for *.va File Names Description: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Configuration Is Only Saved For First Instance of VisualApplets Description: Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that are started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Design Rules Check Error When M-Type Operators in a Hierarchical Box Are Connected Directly to the Input Port Description: If you are using hierarchical boxes, in some specific situations, the Design Rules Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. Workaround: You can solve this problem (within the hierarchical box) by placing a NOP operator between the input port of the hierarchical box and the input port of the M-type operator. Ticket ID: \u2013 Summary: Design Rules Check Error When Using the Line-by-Line 1D Simulation Mode Description: For some designs which passed the Design Rules Check in former versions of VisualApplets, link errors concerning the maximum image height may be reported. In particular, this may happen when 1D processing is involved and the new line-by-line simulation mode is activated (default). The reason is that in the line-by-line-mode some operators propagate the max. image height of input links in a different way to the output links than before. Workaround: You can solve this problem by changing to the legacy simulation mode or by adding SetDimension modules for adjusting the maximum image height values. Ticket ID: \u2013 Summary: Increased Operating Time When Using the Line-by-Line 1D Simulation Mode Description: For some designs the operating time for simulation may be much higher than in former versions of VisualApplets. In particular, this may happen when 1D processing is involved, the new line-by-line simulation mode is activated (default), and the design contains many simulation probes. Workaround: You can solve this problem by changing to the legacy simulation mode or by reducing the number of simulation probes. Ticket ID: \u2013 Summary: SDK for CXP: Accesses to the SISO_GenICam Library Have to Be Programmed by the User Description: SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Increasing the FPGA Design Clock Frequency May Lead to Slow Builds Description: Increasing the FPGA design clock frequency may have the result that the build flow takes very long or even fails because timing constraints cannot be met. This strongly depends on the content of the VisualApplets design. Workaround: No workaround is available. Ticket ID: 8513 Summary: Large Images Are Not Displayed in Simulation Probes Description: When simulation probes contain very large images, VisualApplets may fail to display these images correctly due to memory limitations. In that case, a gray image (i.e. all pixels have the value 205 (0xCD)) is shown. Workaround: Use smaller images for simulation. Ticket ID: 6822 Summary: Simulation Only Supports Images Smaller than 2 GB Description: During simulation the internal buffer size for any image is limited to 2 GB. For simulations with images larger than 2 GB, the simulation is stopped with an error message. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Or use images smaller than 2 GB for simulation. Ticket ID: 240989"},{"location":"known-issues-visualapplets-release-3-5-0.html#blob_analysis_1d-operator","title":"<code>Blob_Analysis_1D</code> Operator","text":"Summary: The <code>Blob_Analysis_1D</code> Operator Sets the <code>object size exceeds maximum</code> Flag Not as Expected Description: If an object is truncated due to exceeding the maximum size defined by the <code>max_object_height_bits</code> parameter, the corresponding <code>object size exceeds maximum</code> flag is set in the truncated object and not in the proceeding object. Workaround: No workaround is available. Ticket ID: 9685 Summary: The <code>Blob_Analysis_1D</code> Operator Does Not Set the <code>label overflow</code> Flag Description: The <code>label overflow</code> flag indicating that all labels are in use and the current object cannot be tagged, is never set. Workaround: No workaround is available. Ticket ID: 9691 Summary: The <code>Blob_Analysis_1D</code> Operator Allows 20 Labels Less Than Defined per Line Description: The amount of available labels as defined by the <code>Label_bits</code> parameter is reduced by 20 labels. For example, if <code>Label_bits</code> is set to 5, only 12 (2^5 - 20) labels are available, and not 32 as expected (2^5). Workaround: No workaround is available. Ticket ID: 9688 Summary: The Simulation of The <code>Blob_Analysis_1D</code> Operator is Not Equal to Hardware Behavior Description: The order of the object feature output might differ in hardware and software. This is so, because the hardware output depends on the timing of the data which cannot be simulated in VisualApplets. Additionally, the FlushI input is asynchronous to the image data input, so completing output frames may not be simulated in a realistic way. Workaround: No workaround is available. Ticket ID: 7709"},{"location":"known-issues-visualapplets-release-3-5-0.html#library-color","title":"Library Color","text":"Summary: Some Color Conversions Don't Work As Expected Description: Operators of the Color library should be used carefully: Some color conversions don't work as a user would assume:<ul><li>HSI2RGB converts HSL -&gt; RGB</li><li>RGB2YUV converts RGB-&gt;YCbCr</li><li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com </li></ul> Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-5-0.html#colortransform-operator","title":"<code>ColorTransform</code> Operator","text":"Summary: Limitations for Negative Transformations Coefficients Description: The <code>ColorTransform</code> operator supports negative transformation coefficients only in the case where the input format is signed or the coefficients are static. Workaround: No workaround is available. Ticket ID: 251344"},{"location":"known-issues-visualapplets-release-3-5-0.html#bayer5x5linear-operator","title":"<code>BAYER5x5Linear</code> Operator","text":"Summary: The Resource Estimation in VisualApplets for <code>BAYER5x5Linear</code> Differs From the Estimation in Xilinx Description: <code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in FPGA Resource Usage dialog) might differ from the estimation displayed by the Xilinx tools after Place &amp; Route. Workaround: No workaround is available. Ticket ID: 6426"},{"location":"known-issues-visualapplets-release-3-5-0.html#library-compression","title":"Library Compression","text":""},{"location":"known-issues-visualapplets-release-3-5-0.html#jpeg_encoder-operator","title":"<code>JPEG_Encoder</code> Operator","text":"Summary: The Output Transfer Of the <code>JPEG_Encoder</code> Operator Starts Earlier Than the Actual Image Data Transfer Description: Operator: To optimize its image throughput rate (band width), the operator outputs the header as soon as header generation is activated - even before image data arrive at the operator's input. This way, the transfer of the header data doesn't interrupt the transfer of image data, as the header is transferred in advance. The drawback of this practice is that the operator's output transfer starts earlier than the actual image data transfer. This may cause irritations under specific circumstances:  If you are using the <code>SourceSelector</code> operator directly after <code>JPEG_Encoder</code>: The <code>SourceSelector</code> operator registers a partly processed frame as soon as it gets the header data. Therefore, if <code>SourceSelector</code> is switched to getting image data from <code>JPEG_Encoder</code>, <code>SourceSelector</code> cannot be switched to any another source as it always detects an unfinished frame. In addition, when header generation is enabled and <code>SourceSelector</code> switches from another source to the <code>JPEG_Encoder</code> channel, the first image is lost. Workaround: If working on eVA devices, make sure the output is capable to accept data transfer before the sensor transfer is started. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-5-0.html#library-debugging","title":"Library Debugging","text":""},{"location":"known-issues-visualapplets-release-3-5-0.html#imageflowcontrol-operator","title":"<code>ImageFlowControl</code> Operator","text":"Summary: Damaged Frame After an Overflow Situation Description: Using the <code>ImageFlowControl</code> operator in dummy frame generation mode may result in a damaged frame as output. This happens after an overflow situation, when a series of dummy frames is emitted for compensating lost frames. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Ticket ID: 248227"},{"location":"known-issues-visualapplets-release-3-5-0.html#library-filter","title":"Library Filter","text":""},{"location":"known-issues-visualapplets-release-3-5-0.html#dilate-operator","title":"<code>DILATE</code> Operator","text":"Summary: In the Hardware Implementation of the <code>DILATE</code> Operator, the Structuring Element Is Rotated Description: The hardware implementation of the <code>DILATE</code> operator differs from the simulation and the documentation. In the hardware inplementation, the structuring element is rotated. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Ticket ID: 267460"},{"location":"known-issues-visualapplets-release-3-5-0.html#firkernelnxm-operator","title":"<code>FIRKernelNxM</code> Operator","text":"Summary: <code>FIRKernelNxM</code> Operator May Cause Processing Errors Description: The <code>FIRKernelNxM</code> operator may cause processing errors in case the <code>EdgeHandling</code> parameter is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame. Workaround: No workaround is available. Ticket ID: 2939"},{"location":"known-issues-visualapplets-release-3-5-0.html#library-hardware-platforms","title":"Library Hardware Platforms","text":""},{"location":"known-issues-visualapplets-release-3-5-0.html#trigger-operators","title":"Trigger Operators","text":"Summary: Trigger Operators May Cause Spikes at the Trigger Output Line Description: Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-5-0.html#library-memory","title":"Library Memory","text":""},{"location":"known-issues-visualapplets-release-3-5-0.html#ramlutoperator","title":"<code>RamLUT</code>Operator","text":"Summary: Writing Intialization Data to the <code>RamLUT</code> Operator during Acquisition Has No Effect on imaFlex Platforms Description: Writing intialization data to the <code>RamLUT</code> operator during acquisition has no effect on imaFlex platforms. Configuring memory content is only possible when the acquisition is stopped. Workaround: Stop the acquisition before writing intialization data to the <code>RamLUT</code> operator. Or update VisualApplets to version 3.6.0, since this issue has been fixed in VisualApplets 3.6.0. Ticket ID: 319280"},{"location":"known-issues-visualapplets-release-3-5-0.html#imagebuffermultiroidyn-operator","title":"<code>ImageBufferMultiRoiDyn</code> Operator","text":"Summary: Timing Errors with Small Images Description: The <code>ImageBufferMultiRoiDyn</code> operator may cause timing errors in case of very small input images. Workaround: No workaround is available. Ticket ID: \u2013 Summary: The <code>ImageBufferMultiRoiDyn</code> Operator Doesn't Work Correctly for ROI Width Values Equal to <code>Parallelism</code> Description: If the value of <code>ROI Width</code> is equal to the value of <code>Parllelism</code>, the ROI isn't read out as expexted. Instead, the first pixel/line is repeated <code>ROI Height</code> times. Workaround: No workaround is available. Ticket ID: 307592"},{"location":"known-issues-visualapplets-release-3-5-0.html#imagesequence-operator","title":"<code>ImageSequence</code> Operator","text":"Summary: Build Errors Caused by the <code>ImageSequence</code> Operator Description: The <code>ImageSequence</code> operator may cause build errors (timing errors). Workaround: No workaround is available. Ticket ID: 2422"},{"location":"known-issues-visualapplets-release-3-5-1.html","title":"Known Issues VisualApplets Release 3.5.1","text":"<p>Info</p> <p>If you install the Windows 10 Fall Creators update (version 1709) on a computer that has Xilinx Vivado version 2017.2 or 2017.3 installed, Xilinx Vivado may not work properly. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>Follow the workaround provided by Xilinx Support to make your Xilinx Vivado 2017.2 or 2017.3 installation work again.</p> <p>Info</p> <p>If you install the above Windows 10 update, the build flow may not work properly using Xilinx tools older than Vivado 2017.4. Thus, you may not be able to build the designs you created with VisualApplets.</p> <p>For Vivado versions older than Vivado 2017.4, error messages may show up in the log output of the Xilinx tool chain telling that some black box instances have undefined content. For ISE, no Xilinx tool version can be determined and the FPGA type check fails.</p> <p>Follow the workaround provided by Xilinx Support to make the ISE installation work again (section \"ISE 14.7 64-bit - Turning off SmartHeap\"). The same workaround can be used for Vivado where you need to perform the file substitution actions in the &lt;VivadoInstallDir&gt;/ids_lite/ISE/lib/nt64 directory.</p>"},{"location":"known-issues-visualapplets-release-3-5-1.html#general","title":"General","text":"Summary: For mE5 Platforms and imaFlex Platforms the Resource Estimation May Be Too Low Description: For mE5- and imaFlex platforms, the resource estimation for some operators (i.e. <code>Blob</code> and <code>Histogram</code>) may underestimate the number of used block RAMs. Depending on the module configuration, the real usage of block RAM ressources can be more than 50 % higher. Workaround: No workaround is available. Ticket ID: 297790 Summary: Copying Content Using the Clipboard Doesn\u2019t Work Description: It's not possible to copy design content from designs opened in this VisualApplets version into designs opened in VisualApplets versions 3.3.2 or earlier using the clipboard (copy&amp;paste). However, copying from any VisualApplet version to this version works. Workaround: Save your design in the legacy *.va file format, open it in an older version of VisualApplets and copy the content from there. Ticket ID: \u2013 Summary: RGB Images Loaded into the Simulation Probe Viewer Might Be Saved as Mono Image (8 Bit) Description: In the Simulation Probe Viewer, RGB images that contain the same values across the color channels are saved as mono image (i.e. 8-bit image), not as 24-bit image. Workaround: Save your image in the BMP file format to preserve the channels. Ticket ID: 266977 Summary: Xilinx ISE Build Tool Chain Doesn't Support Windows 11 Description: The Xilinx ISE build tool chain doesn't support Windows 11. Therefore, building VisualApplets designs doesn't work with Xilinx ISE. Workaround: If you want to build applets for platforms that need to be built with Xilinx ISE, install VisualApplets under Windows 10. If your target platform is supported by Vivado, build the applets with Xilinx Vivado (Vivado supports Windows 11). See in the system requirements section which platforms are supported by Vivado. Ticket ID: 236990 Summary: Applets for mE5-CL Platforms Can't Be Built with some Xilinx Vivado Versions Description: Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1. Workaround: This problem has been fixed with Xilinx Vivado version 2021.2. Thus, to avoid this problem, use Vivado version 2021.2 or higher. Ticket ID: 217879 Summary: When Converting a Design to a Different Hardware Platform, the Hardware-Dependent Operator Library Might Not Be Available Description: When converting a VisualApplets design to a different hardware platform, under certain circumstances the hardware-dependent operator library for the target platform might not be available. Workaround: To resolve this, restart VisualApplets. Ticket ID: \u2013 Summary: Xilinx Vivado Warning When Building an Applet Description: When you build an applet using the Xilinx Vivado tools, you may get critical warnings (during the LinkDesign build step). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. Example:<p><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint for instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance \u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the instance type. Instance \u2026/PART1174 belongs to a shape with reference instance \u2026/PART1175. Shape elements have relative placement respect to each other. The invalid location might result from a constraint on any of the instance in the shape.. </code></p> Workaround: Ignore the warnings. This issue is not critical for designs created in VisualApplets. Ticket ID: \u2013 Summary: Only ASCII Characters Are Supported for *.va File Names Description: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Configuration Is Only Saved For First Instance of VisualApplets Description: Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that are started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Design Rules Check Error When M-Type Operators in a Hierarchical Box Are Connected Directly to the Input Port Description: If you are using hierarchical boxes, in some specific situations, the Design Rules Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. Workaround: You can solve this problem (within the hierarchical box) by placing a NOP operator between the input port of the hierarchical box and the input port of the M-type operator. Ticket ID: \u2013 Summary: Design Rules Check Error When Using the Line-by-Line 1D Simulation Mode Description: For some designs which passed the Design Rules Check in former versions of VisualApplets, link errors concerning the maximum image height may be reported. In particular, this may happen when 1D processing is involved and the new line-by-line simulation mode is activated (default). The reason is that in the line-by-line-mode some operators propagate the max. image height of input links in a different way to the output links than before. Workaround: You can solve this problem by changing to the legacy simulation mode or by adding SetDimension modules for adjusting the maximum image height values. Ticket ID: \u2013 Summary: Increased Operating Time When Using the Line-by-Line 1D Simulation Mode Description: For some designs the operating time for simulation may be much higher than in former versions of VisualApplets. In particular, this may happen when 1D processing is involved, the new line-by-line simulation mode is activated (default), and the design contains many simulation probes. Workaround: You can solve this problem by changing to the legacy simulation mode or by reducing the number of simulation probes. Ticket ID: \u2013 Summary: SDK for CXP: Accesses to the SISO_GenICam Library Have to Be Programmed by the User Description: SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Increasing the FPGA Design Clock Frequency May Lead to Slow Builds Description: Increasing the FPGA design clock frequency may have the result that the build flow takes very long or even fails because timing constraints cannot be met. This strongly depends on the content of the VisualApplets design. Workaround: No workaround is available. Ticket ID: 8513 Summary: Large Images Are Not Displayed in Simulation Probes Description: When simulation probes contain very large images, VisualApplets may fail to display these images correctly due to memory limitations. In that case, a gray image (i.e. all pixels have the value 205 (0xCD)) is shown. Workaround: Use smaller images for simulation. Ticket ID: 6822 Summary: Simulation Only Supports Images Smaller than 2 GB Description: During simulation the internal buffer size for any image is limited to 2 GB. For simulations with images larger than 2 GB, the simulation is stopped with an error message. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Or use images smaller than 2 GB for simulation. Ticket ID: 240989"},{"location":"known-issues-visualapplets-release-3-5-1.html#library-blob","title":"Library Blob","text":""},{"location":"known-issues-visualapplets-release-3-5-1.html#blob_analysis_1d-operator","title":"<code>Blob_Analysis_1D</code> Operator","text":"Summary: The <code>Blob_Analysis_1D</code> Operator Sets the <code>object size exceeds maximum</code> Flag Not as Expected Description: If an object is truncated due to exceeding the maximum size defined by the <code>max_object_height_bits</code> parameter, the corresponding <code>object size exceeds maximum</code> flag is set in the truncated object and not in the proceeding object. Workaround: No workaround is available. Ticket ID: 9685 Summary: The <code>Blob_Analysis_1D</code> Operator Does Not Set the <code>label overflow</code> Flag Description: The <code>label overflow</code> flag indicating that all labels are in use and the current object cannot be tagged, is never set. Workaround: No workaround is available. Ticket ID: 9691 Summary: The <code>Blob_Analysis_1D</code> Operator Allows 20 Labels Less Than Defined per Line Description: The amount of available labels as defined by the <code>Label_bits</code> parameter is reduced by 20 labels. For example, if <code>Label_bits</code> is set to 5, only 12 (2^5 - 20) labels are available, and not 32 as expected (2^5). Workaround: No workaround is available. Ticket ID: 9688 Summary: The Simulation of The <code>Blob_Analysis_1D</code> Operator is Not Equal to Hardware Behavior Description: The order of the object feature output might differ in hardware and software. This is so, because the hardware output depends on the timing of the data which cannot be simulated in VisualApplets. Additionally, the FlushI input is asynchronous to the image data input, so completing output frames may not be simulated in a realistic way. Workaround: No workaround is available. Ticket ID: 7709"},{"location":"known-issues-visualapplets-release-3-5-1.html#library-color","title":"Library Color","text":"Summary: Some Color Conversions Don't Work As Expected Description: Operators of the Color library should be used carefully: Some color conversions don't work as a user would assume:<ul><li>HSI2RGB converts HSL -&gt; RGB</li><li>RGB2YUV converts RGB-&gt;YCbCr</li><li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com </li></ul> Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-5-1.html#colortransform-operator","title":"<code>ColorTransform</code> Operator","text":"Summary: Limitations for Negative Transformations Coefficients Description: The <code>ColorTransform</code> operator supports negative transformation coefficients only in the case where the input format is signed or the coefficients are static. Workaround: No workaround is available. Ticket ID: 251344"},{"location":"known-issues-visualapplets-release-3-5-1.html#bayer5x5linear-operator","title":"<code>BAYER5x5Linear</code> Operator","text":"Summary: The Resource Estimation in VisualApplets for <code>BAYER5x5Linear</code> Differs From the Estimation in Xilinx Description: <code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in FPGA Resource Usage dialog) might differ from the estimation displayed by the Xilinx tools after Place &amp; Route. Workaround: No workaround is available. Ticket ID: 6426"},{"location":"known-issues-visualapplets-release-3-5-1.html#library-compression","title":"Library Compression","text":""},{"location":"known-issues-visualapplets-release-3-5-1.html#jpeg_encoder-operator","title":"<code>JPEG_Encoder</code> Operator","text":"Summary: The Output Transfer Of the <code>JPEG_Encoder</code> Operator Starts Earlier Than the Actual Image Data Transfer Description: Operator: To optimize its image throughput rate (band width), the operator outputs the header as soon as header generation is activated - even before image data arrive at the operator's input. This way, the transfer of the header data doesn't interrupt the transfer of image data, as the header is transferred in advance. The drawback of this practice is that the operator's output transfer starts earlier than the actual image data transfer. This may cause irritations under specific circumstances:  If you are using the <code>SourceSelector</code> operator directly after <code>JPEG_Encoder</code>: The <code>SourceSelector</code> operator registers a partly processed frame as soon as it gets the header data. Therefore, if <code>SourceSelector</code> is switched to getting image data from <code>JPEG_Encoder</code>, <code>SourceSelector</code> cannot be switched to any another source as it always detects an unfinished frame. In addition, when header generation is enabled and <code>SourceSelector</code> switches from another source to the <code>JPEG_Encoder</code> channel, the first image is lost. Workaround: If working on eVA devices, make sure the output is capable to accept data transfer before the sensor transfer is started. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-5-1.html#library-debugging","title":"Library Debugging","text":""},{"location":"known-issues-visualapplets-release-3-5-1.html#imageflowcontrol-operator","title":"<code>ImageFlowControl</code> Operator","text":"Summary: Damaged Frame After an Overflow Situation Description: Using the <code>ImageFlowControl</code> operator in dummy frame generation mode may result in a damaged frame as output. This happens after an overflow situation, when a series of dummy frames is emitted for compensating lost frames. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Ticket ID: 248227"},{"location":"known-issues-visualapplets-release-3-5-1.html#library-filter","title":"Library Filter","text":""},{"location":"known-issues-visualapplets-release-3-5-1.html#dilate-operator","title":"<code>DILATE</code> Operator","text":"Summary: In the Hardware Implementation of the <code>DILATE</code> Operator, the Structuring Element Is Rotated Description: The hardware implementation of the <code>DILATE</code> operator differs from the simulation and the documentation. In the hardware inplementation, the structuring element is rotated. Workaround: Update VisualApplets to version 3.6.0. This issue has been fixed in VisualApplets version 3.6.0. Ticket ID: 267460"},{"location":"known-issues-visualapplets-release-3-5-1.html#firkernelnxm-operator","title":"<code>FIRKernelNxM</code> Operator","text":"Summary: <code>FIRKernelNxM</code> Operator May Cause Processing Errors Description: The <code>FIRKernelNxM</code> operator may cause processing errors in case the <code>EdgeHandling</code> parameter is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame. Workaround: No workaround is available. Ticket ID: 2939"},{"location":"known-issues-visualapplets-release-3-5-1.html#library-hardware-platforms","title":"Library Hardware Platforms","text":""},{"location":"known-issues-visualapplets-release-3-5-1.html#trigger-operators","title":"Trigger Operators","text":"Summary: Trigger Operators May Cause Spikes at the Trigger Output Line Description: Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-5-1.html#library-memory","title":"Library Memory","text":""},{"location":"known-issues-visualapplets-release-3-5-1.html#imagebuffermultiroidyn-operator","title":"<code>ImageBufferMultiRoiDyn</code> Operator","text":"Summary: Timing Errors with Small Images Description: The <code>ImageBufferMultiRoiDyn</code> operator may cause timing errors in case of very small input images. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-5-1.html#imagesequence-operator","title":"<code>ImageSequence</code> Operator","text":"Summary: Build Errors Caused by the <code>ImageSequence</code> Operator Description: The <code>ImageSequence</code> operator may cause build errors (timing errors). Workaround: No workaround is available. Ticket ID: 2422"},{"location":"known-issues-visualapplets-release-3-6-0.html","title":"Known Issues in VisualApplets Release 3.6.0","text":""},{"location":"known-issues-visualapplets-release-3-6-0.html#general","title":"General","text":"Summary: VisualApplets May Crash When Starting If an Update Notification Appears Description: Sometimes, VisualApplets crashes during startup when it tries to show a new update notification. Workaround: This has been fixed in Visual Applets version 3.6.1. Update your VisualApplets to this version. Alternatively, you can disable the automatic update check:Option 1: Edit the configuration file:<ol><li>If VisualApplets was installed as Portable, open the VisualApplets.ini file in the VisualApplets installation directory. For the installation modes Current User and All Users, open the VisualApplets.ini file located in the user-specific or user-wide Windows application data directory.</li><li>In the section [CommonSettings], set the line <code>CheckForUpdates=false</code>.</li></ol>Option 2: Use the VisualApplets GUI:<ol><li>Disconnect your computer from the network.</li><li>Start VisualApplets.</li><li>Go to Settings &gt; System Settings, then open the Common category.</li><li>Disable the update notification.</li></ol>Option 3: <ol><li>Set the environment variable <code>VA_VERSION_UPDATE_FILE</code>= <code>none</code>.</li><li>Start VA 3.6.0 and disable the update notification as described in Option 2.</li><li>Then remove the environment variable <code>VA_VERSION_UPDATE_FILE</code>= <code>none</code> again.</li></ol>Note: Options 1-3 only stop automatic update checks at startup. You can still manually check for updates via Help &gt; Check for Updates. Ticket ID: 342982 Summary: For mE5 Platforms and imaFlex Platforms the Resource Estimation May Be Too Low Description: For mE5- and imaFlex platforms, the resource estimation for some operators (i.e. <code>Blob</code> and <code>Histogram</code>) may underestimate the number of used block RAMs. Depending on the module configuration, the real usage of block RAM ressources can be more than 50 % higher. Workaround: No workaround is available. Ticket ID: 297790 Summary: Copying Content Using the Clipboard Doesn't Work Description: It's not possible to copy design content from designs opened in this VisualApplets version into designs opened in VisualApplets versions 3.3.2 or earlier using the clipboard (copy&amp;paste). However, copying from any VisualApplet version to this version works. Workaround: Save your design in the legacy *.va file format, open it in an older version of VisualApplets and copy the content from there. Ticket ID: \u2013 Summary: When Converting a Design to a Different Hardware Platform, the Hardware-Dependent Operator Library Might Not Be Available Description: When converting a VisualApplets design to a different hardware platform, under certain circumstances the hardware-dependent operator library for the target platform might not be available. Workaround: To resolve this, restart VisualApplets. Ticket ID: \u2013 Summary: Only ASCII Characters Are Supported for *.va File Names Description: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Configuration Is Only Saved For First Instance of VisualApplets Description: Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that are started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Design Rules Check Error When M-Type Operators in a Hierarchical Box Are Connected Directly to the Input Port Description: If you are using hierarchical boxes, in some specific situations, the Design Rules Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. Workaround: You can solve this problem (within the hierarchical box) by placing a NOP operator between the input port of the hierarchical box and the input port of the M-type operator. Ticket ID: \u2013 Summary: Design Rules Check Error When Using the Line-by-Line 1D Simulation Mode Description: For some designs which passed the Design Rules Check in former versions of VisualApplets, link errors concerning the maximum image height may be reported. In particular, this may happen when 1D processing is involved and the new line-by-line simulation mode is activated (default). The reason is that in the line-by-line-mode some operators propagate the max. image height of input links in a different way to the output links than before. Workaround: You can solve this problem by changing to the legacy simulation mode or by adding SetDimension modules for adjusting the maximum image height values. Ticket ID: \u2013 Summary: Increased Operating Time When Using the Line-by-Line 1D Simulation Mode Description: For some designs the operating time for simulation may be much higher than in former versions of VisualApplets. In particular, this may happen when 1D processing is involved, the new line-by-line simulation mode is activated (default), and the design contains many simulation probes. Workaround: You can solve this problem by changing to the legacy simulation mode or by reducing the number of simulation probes. Ticket ID: \u2013 Summary: SDK for CXP: Accesses to the SISO_GenICam Library Have to Be Programmed by the User Description: SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Increasing the FPGA Design Clock Frequency May Lead to Slow Builds Description: Increasing the FPGA design clock frequency may have the result that the build flow takes very long or even fails because timing constraints cannot be met. This strongly depends on the content of the VisualApplets design. Workaround: No workaround is available. Ticket ID: 8513 Summary: Large Images Are Not Displayed in Simulation Probes Description: When simulation probes contain very large images, VisualApplets may fail to display these images correctly due to memory limitations. In that case, a gray image (i.e. all pixels have the value 205 (0xCD)) is shown. Workaround: Use smaller images for simulation. Ticket ID: 6822 Summary: RGB Images Loaded into the Simulation Probe Viewer Might Be Saved as Mono Image (8 Bit) Description: In the Simulation Probe Viewer, RGB images that contain the same values across the color channels are saved as mono image (i.e. 8-bit image), not as 24-bit image. Workaround: If you want to preserve the channels, save your image in the BMP file format. Ticket ID: 266977"},{"location":"known-issues-visualapplets-release-3-6-0.html#xilinx","title":"Xilinx","text":"Summary: Building imaFlex Designs with Vivado Might Fail during the Optimize Step Description: Occasionally, building imaFlex designs with Vivado fails during the Optimize step. This issue can be resolved by running the build process again. Workaround: Run the build process again. Keep the path to the build directory as short as possible. You can set the build directory explicitly in the System Settings dialog  in the Global Build category &gt; Setting Path for building applets. Ticket ID: 341870 Summary: Xilinx ISE Build Tool Chain Doesn't Support Windows 11 Description: The Xilinx ISE build tool chain doesn't support Windows 11. Therefore, building VisualApplets designs doesn't work with Xilinx ISE. Workaround: If you want to build applets for platforms that need to be built with Xilinx ISE, install VisualApplets under Windows 10. If your target platform is supported by Vivado, build the applets with Xilinx Vivado (Vivado supports Windows 11). See in the system requirements section which platforms are supported by Vivado. In this forum discussion you find some hacks how to install ISE under Windows 11 anyways, even though this is officially not supported. Ticket ID: 236990 Summary: Designs for imaFlex Platforms Built with Vivado 2025.1 Can't Be Loaded Description: Designs for imaFlex platforms can't be loaded when built with Vivado 2025.1. VisualApplets version 3.6.0 has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. Workaround: Build your applets with Vivado 2023.2. Ticket ID: 341684 Summary: Applets for mE5-CL Platforms Can't Be Built with some Xilinx Vivado Versions Description: Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1. Workaround: This problem has been fixed with Xilinx Vivado version 2021.2. Thus, to avoid this problem, use Vivado version 2021.2 or higher. Ticket ID: 217879 Summary: Xilinx Vivado Warning When Building an Applet Description: When you build an applet using the Xilinx Vivado tools, you may get critical warnings (during the LinkDesign build step). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. Example:<p><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint for instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance \u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the instance type. Instance \u2026/PART1174 belongs to a shape with reference instance \u2026/PART1175. Shape elements have relative placement respect to each other. The invalid location might result from a constraint on any of the instance in the shape.. </code></p> Workaround: Ignore the warnings. This issue is not critical for designs created in VisualApplets. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-6-0.html#examples","title":"Examples","text":""},{"location":"known-issues-visualapplets-release-3-6-0.html#hdr-examples","title":"HDR Examples","text":"Summary: Incorrect HDR Exposure Time Calculation in the New HDR Examples Description: In the new HDR examples, the exposure time per line is specified in microseconds (\u00b5s). When stacking lines to form a 2D image, the total exposure time accumulates across the image height. As a result, the effective exposure time for the full 2D image depends on the number of lines used. However, the exposure time is incorrectly assumed to be given in milliseconds (ms), instead of microseconds (\u00b5s). This leads to an incorrect calculation of the exposure time. Workaround: This has been fixed in Visual Applets version 3.6.1. Update your VisualApplets to this version. Ticket ID: 342945"},{"location":"known-issues-visualapplets-release-3-6-0.html#library-blob","title":"Library Blob","text":""},{"location":"known-issues-visualapplets-release-3-6-0.html#blob_analysis_1d-operator","title":"<code>Blob_Analysis_1D</code> Operator","text":"Summary: The <code>Blob_Analysis_1D</code> Operator Sets the <code>object size exceeds maximum</code> Flag Not as Expected Description: If an object is truncated due to exceeding the maximum size defined by the <code>max_object_height_bits</code> parameter, the corresponding <code>object size exceeds maximum</code> flag is set in the truncated object and not in the proceeding object. Workaround: Use the new <code>BlobDetector1D</code> operator instead. This issue has been resolved in the new operator. Ticket ID: 9685 Summary: The <code>Blob_Analysis_1D</code> Operator Does Not Set the <code>label overflow</code> Flag Description: The <code>label overflow</code> flag indicating that all labels are in use and the current object cannot be tagged, is never set. Workaround: Use the new <code>BlobDetector1D</code> operator instead. This issue has been resolved in the new operator. Ticket ID: 9691 Summary: The <code>Blob_Analysis_1D</code> Operator Allows 20 Labels Less Than Defined per Line Description: The amount of available labels as defined by the <code>Label_bits</code> parameter is reduced by 20 labels. For example, if <code>Label_bits</code> is set to 5, only 12 (2^5 - 20) labels are available, and not 32 as expected (2^5). Workaround: Use the new <code>BlobDetector1D</code> operator instead. This issue has been resolved in the new operator. Ticket ID: 9688 Summary: The Simulation of The <code>Blob_Analysis_1D</code> Operator is Not Equal to Hardware Behavior Description: The order of the object feature output might differ in hardware and software. This is so, because the hardware output depends on the timing of the data which cannot be simulated in VisualApplets. Additionally, the FlushI input is asynchronous to the image data input, so completing output frames may not be simulated in a realistic way. Workaround: Use the new <code>BlobDetector1D</code> operator instead. This issue has been resolved in the new operator. Ticket ID: 7709"},{"location":"known-issues-visualapplets-release-3-6-0.html#library-color","title":"Library Color","text":"Summary: Some Color Conversions Don't Work As Expected Description: Operators of the Color library should be used carefully: Some color conversions don't work as a user would assume:<ul><li>HSI2RGB converts HSL -&gt; RGB</li><li>RGB2YUV converts RGB-&gt;YCbCr</li><li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com </li></ul> Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-6-0.html#colortransform-operator","title":"<code>ColorTransform</code> Operator","text":"Summary: Limitations for Negative Transformations Coefficients Description: The <code>ColorTransform</code> operator supports negative transformation coefficients only in the case where the input format is signed or the coefficients are static. Workaround: No workaround is available. Ticket ID: 251344"},{"location":"known-issues-visualapplets-release-3-6-0.html#bayer5x5linear-operator","title":"<code>BAYER5x5Linear</code> Operator","text":"Summary: The Resource Estimation in VisualApplets for <code>BAYER5x5Linear</code> Differs From the Estimation in Xilinx Description: <code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in FPGA Resource Usage dialog) might differ from the estimation displayed by the Xilinx tools after Place &amp; Route. Workaround: No workaround is available. Ticket ID: 6426"},{"location":"known-issues-visualapplets-release-3-6-0.html#library-compression","title":"Library Compression","text":""},{"location":"known-issues-visualapplets-release-3-6-0.html#jpeg_encoder-operator","title":"<code>JPEG_Encoder</code> Operator","text":"Summary: The Output Transfer Of the <code>JPEG_Encoder</code> Operator Starts Earlier Than the Actual Image Data Transfer Description: Operator: To optimize its image throughput rate (band width), the operator outputs the header as soon as header generation is activated - even before image data arrive at the operator's input. This way, the transfer of the header data doesn't interrupt the transfer of image data, as the header is transferred in advance. The drawback of this practice is that the operator's output transfer starts earlier than the actual image data transfer. This may cause irritations under specific circumstances:  If you are using the <code>SourceSelector</code> operator directly after <code>JPEG_Encoder</code>: The <code>SourceSelector</code> operator registers a partly processed frame as soon as it gets the header data. Therefore, if <code>SourceSelector</code> is switched to getting image data from <code>JPEG_Encoder</code>, <code>SourceSelector</code> cannot be switched to any another source as it always detects an unfinished frame. In addition, when header generation is enabled and <code>SourceSelector</code> switches from another source to the <code>JPEG_Encoder</code> channel, the first image is lost. Workaround: If working on eVA devices, make sure the output is capable to accept data transfer before the sensor transfer is started. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-6-0.html#library-filter","title":"Library Filter","text":""},{"location":"known-issues-visualapplets-release-3-6-0.html#firkernelnxm-operator","title":"<code>FIRKernelNxM</code> Operator","text":"Summary: <code>FIRKernelNxM</code> Operator May Cause Processing Errors Description: The <code>FIRKernelNxM</code> operator may cause processing errors in case the <code>EdgeHandling</code> parameter is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame. Workaround: No workaround is available. Ticket ID: 2939"},{"location":"known-issues-visualapplets-release-3-6-0.html#library-hardware-platforms","title":"Library Hardware Platforms","text":""},{"location":"known-issues-visualapplets-release-3-6-0.html#trigger-operators","title":"Trigger Operators","text":"Summary: Trigger Operators May Cause Spikes at the Trigger Output Line Description: Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-6-0.html#library-memory","title":"Library Memory","text":""},{"location":"known-issues-visualapplets-release-3-6-0.html#framebuffermultiroi-operator","title":"<code>FrameBufferMultiRoi</code> Operator","text":"Summary: Black Image Areas in the Simulation with the <code>FrameBufferMultiRoi</code> Operator and ROIs Using <code>XOffset</code> &gt; 0 Description: An error in the simulation of the <code>FrameBufferMultiRoi</code> operator may cause black areas to appear in the simulated frame output when using ROIs with <code>XOffset</code> &gt; <code>0</code>. This issue affects only the simulation. The hardware function is not impacted. Workaround: This has been fixed in Visual Applets version 3.6.1. Update your VisualApplets to this version. Alternatively, increase the number of input lines by the maximum value of <code>XOffset</code>. Ticket ID: 345327"},{"location":"known-issues-visualapplets-release-3-6-0.html#linememory-and-imagefifo-operators","title":"<code>LineMemory</code> and <code>ImageFifo</code> Operators","text":"Summary: Designs with <code>LineMemory</code> or <code>ImageFifo</code> Operators Using UltraRAM May Cause a Build Error in Enhanced Netlist Synthesis Mode Description: When building a design that contains the <code>LineMemory</code> or <code>ImageFifo</code> operators with UltraRAM, and if you have selected Enhanced netlist synthesis engine, an error may occur during the Link Design step. Workaround: This issues has been fixed in VisualApplets version 3.6.1. Update your VisualApplets to this version. Alternatively, use the Standard netlist synthesis engine when UltraRAM is required for <code>ImageFifo</code> or <code>LineMemory</code>. Ticket ID: 342336"},{"location":"known-issues-visualapplets-release-3-6-0.html#imagebuffermultiroidyn-operator","title":"<code>ImageBufferMultiRoiDyn</code> Operator","text":"Summary: Timing Errors with Small Images Description: The <code>ImageBufferMultiRoiDyn</code> operator may cause timing errors in case of very small input images. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-6-0.html#library-synchronization","title":"Library Synchronization","text":""},{"location":"known-issues-visualapplets-release-3-6-0.html#islastpixel-operator","title":"<code>IsLastPixel</code> Operator","text":"Summary: The <code>IsLastPixel</code> Operator Incorrectly Indicates That an Image Is Empty Description: The <code>IsEmpty</code> output of the <code>IsLastPixel</code> operator doesn't work correctly when the parameter <code>Mode</code> is set to <code>Frame</code>. This issue affects both simulation and hardware behavior. In hardware, an empty frame may be incorrectly marked as non-empty. In simulation, a non-empty frame may be incorrectly marked as empty. Workaround: Don't use the <code>IsEmpty</code> output when <code>Mode</code> = <code>Frame</code>. Ticket ID: 337672"},{"location":"known-issues-visualapplets-release-3-6-1.html","title":"Known Issues in VisualApplets Release 3.6.1","text":""},{"location":"known-issues-visualapplets-release-3-6-1.html#general","title":"General","text":"Summary: For mE5 Platforms and imaFlex Platforms the Resource Estimation May Be Too Low Description: For mE5- and imaFlex platforms, the resource estimation for some operators (i.e. <code>Blob</code> and <code>Histogram</code>) may underestimate the number of used block RAMs. Depending on the module configuration, the real usage of block RAM ressources can be more than 50 % higher. Workaround: No workaround is available. Ticket ID: 297790 Summary: Copying Content Using the Clipboard Doesn't Work Description: It's not possible to copy design content from designs opened in this VisualApplets version into designs opened in VisualApplets versions 3.3.2 or earlier using the clipboard (copy&amp;paste). However, copying from any VisualApplet version to this version works. Workaround: Save your design in the legacy *.va file format, open it in an older version of VisualApplets and copy the content from there. Ticket ID: \u2013 Summary: When Converting a Design to a Different Hardware Platform, the Hardware-Dependent Operator Library Might Not Be Available Description: When converting a VisualApplets design to a different hardware platform, under certain circumstances the hardware-dependent operator library for the target platform might not be available. Workaround: To resolve this, restart VisualApplets. Ticket ID: \u2013 Summary: Only ASCII Characters Are Supported for *.va File Names Description: For naming *.va files, only fonts based on ASCII characters can be used; this means that, e.g., Asian, Cyrillic, Greek, or Arabic fonts are not supported for file names. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Configuration Is Only Saved For First Instance of VisualApplets Description: Only the first started instance of VisualApplets is able to save its configuration. All VisualApplets instances that are started later have only a temporary configuration which will be discarded when the instance is closed. This concerns, e.g., build settings, library settings, system settings, general VisualApplets settings. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Design Rules Check Error When M-Type Operators in a Hierarchical Box Are Connected Directly to the Input Port Description: If you are using hierarchical boxes, in some specific situations, the Design Rules Check may come up with the following error message: \"The input XYZ of the operator ABC (hierarchical box) must be connected to an O-type operator, e.g., NOP.\" The reason is that some M-type operators placed within a hierarchical box cannot be connected to the input port of the hierarchical box directly. This is only true for some specific M-type operators. Workaround: You can solve this problem (within the hierarchical box) by placing a NOP operator between the input port of the hierarchical box and the input port of the M-type operator. Ticket ID: \u2013 Summary: Design Rules Check Error When Using the Line-by-Line 1D Simulation Mode Description: For some designs which passed the Design Rules Check in former versions of VisualApplets, link errors concerning the maximum image height may be reported. In particular, this may happen when 1D processing is involved and the new line-by-line simulation mode is activated (default). The reason is that in the line-by-line-mode some operators propagate the max. image height of input links in a different way to the output links than before. Workaround: You can solve this problem by changing to the legacy simulation mode or by adding SetDimension modules for adjusting the maximum image height values. Ticket ID: \u2013 Summary: Increased Operating Time When Using the Line-by-Line 1D Simulation Mode Description: For some designs the operating time for simulation may be much higher than in former versions of VisualApplets. In particular, this may happen when 1D processing is involved, the new line-by-line simulation mode is activated (default), and the design contains many simulation probes. Workaround: You can solve this problem by changing to the legacy simulation mode or by reducing the number of simulation probes. Ticket ID: \u2013 Summary: SDK for CXP: Accesses to the SISO_GenICam Library Have to Be Programmed by the User Description: SDK for CXP: Accesses to the SISO_GenICam library are not generated automatically, but have to be programmed by the user. Workaround: No workaround is available. Ticket ID: \u2013 Summary: Increasing the FPGA Design Clock Frequency May Lead to Slow Builds Description: Increasing the FPGA design clock frequency may have the result that the build flow takes very long or even fails because timing constraints cannot be met. This strongly depends on the content of the VisualApplets design. Workaround: No workaround is available. Ticket ID: 8513 Summary: Large Images Are Not Displayed in Simulation Probes Description: When simulation probes contain very large images, VisualApplets may fail to display these images correctly due to memory limitations. In that case, a gray image (i.e. all pixels have the value 205 (0xCD)) is shown. Workaround: Use smaller images for simulation. Ticket ID: 6822 Summary: RGB Images Loaded into the Simulation Probe Viewer Might Be Saved as Mono Image (8 Bit) Description: In the Simulation Probe Viewer, RGB images that contain the same values across the color channels are saved as mono image (i.e. 8-bit image), not as 24-bit image. Workaround: If you want to preserve the channels, save your image in the BMP file format. Ticket ID: 266977"},{"location":"known-issues-visualapplets-release-3-6-1.html#xilinx","title":"Xilinx","text":"Summary: Building imaFlex Designs with Vivado Might Fail during the Optimize Step Description: Occasionally, building imaFlex designs with Vivado fails during the Optimize step. This issue can be resolved by running the build process again. Workaround: Run the build process again. Keep the path to the build directory as short as possible. You can set the build directory explicitly in the System Settings dialog  in the Global Build category &gt; Setting Path for building applets. Ticket ID: 341870 Summary: Xilinx ISE Build Tool Chain Doesn't Support Windows 11 Description: The Xilinx ISE build tool chain doesn't support Windows 11. Therefore, building VisualApplets designs doesn't work with Xilinx ISE. Workaround: If you want to build applets for platforms that need to be built with Xilinx ISE, install VisualApplets under Windows 10. If your target platform is supported by Vivado, build the applets with Xilinx Vivado (Vivado supports Windows 11). See in the system requirements section which platforms are supported by Vivado. In this forum discussion you find some hacks how to install ISE under Windows 11 anyways, even though this is officially not supported. Ticket ID: 236990 Summary: VisualApplets Prohibits Building Designs with Vivado 2025.1 and Later Description: VisualApplets prohibits building designs with Vivado 2025.1 and later as designs built with these versions don't work. Workaround: Build your applets with Vivado 2023.2. Ticket ID: 341684 / 348084 Summary: Applets for mE5-CL Platforms Can't Be Built with some Xilinx Vivado Versions Description: Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1. Workaround: This problem has been fixed with Xilinx Vivado version 2021.2. Thus, to avoid this problem, use Vivado version 2021.2 or higher. Ticket ID: 217879 Summary: Xilinx Vivado Warning When Building an Applet Description: When you build an applet using the Xilinx Vivado tools, you may get critical warnings (during the LinkDesign build step). The warnings are due to an issue within the Xilinx tool chain. The issue is known to Xilinx and fixing is in progress. Example:<p><code>CRITICAL WARNING: [Shape Builder 18-137] Cannot obey LUTNM/HLUTNM constraint for instances \u2026/PART1174 and \u2026/PART1175. Illegal to place instance \u2026/PART1174 on site SLICE_X2Y0. The location site type does not match the instance type. Instance \u2026/PART1174 belongs to a shape with reference instance \u2026/PART1175. Shape elements have relative placement respect to each other. The invalid location might result from a constraint on any of the instance in the shape.. </code></p> Workaround: Ignore the warnings. This issue is not critical for designs created in VisualApplets. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-6-1.html#library-blob","title":"Library Blob","text":""},{"location":"known-issues-visualapplets-release-3-6-1.html#blob_analysis_1d-operator","title":"<code>Blob_Analysis_1D</code> Operator","text":"Summary: The <code>Blob_Analysis_1D</code> Operator Sets the <code>object size exceeds maximum</code> Flag Not as Expected Description: If an object is truncated due to exceeding the maximum size defined by the <code>max_object_height_bits</code> parameter, the corresponding <code>object size exceeds maximum</code> flag is set in the truncated object and not in the proceeding object. Workaround: Use the new <code>BlobDetector1D</code> operator instead. This issue has been resolved in the new operator. Ticket ID: 9685 Summary: The <code>Blob_Analysis_1D</code> Operator Does Not Set the <code>label overflow</code> Flag Description: The <code>label overflow</code> flag indicating that all labels are in use and the current object cannot be tagged, is never set. Workaround: Use the new <code>BlobDetector1D</code> operator instead. This issue has been resolved in the new operator. Ticket ID: 9691 Summary: The <code>Blob_Analysis_1D</code> Operator Allows 20 Labels Less Than Defined per Line Description: The amount of available labels as defined by the <code>Label_bits</code> parameter is reduced by 20 labels. For example, if <code>Label_bits</code> is set to 5, only 12 (2^5 - 20) labels are available, and not 32 as expected (2^5). Workaround: Use the new <code>BlobDetector1D</code> operator instead. This issue has been resolved in the new operator. Ticket ID: 9688 Summary: The Simulation of The <code>Blob_Analysis_1D</code> Operator is Not Equal to Hardware Behavior Description: The order of the object feature output might differ in hardware and software. This is so, because the hardware output depends on the timing of the data which cannot be simulated in VisualApplets. Additionally, the FlushI input is asynchronous to the image data input, so completing output frames may not be simulated in a realistic way. Workaround: Use the new <code>BlobDetector1D</code> operator instead. This issue has been resolved in the new operator. Ticket ID: 7709"},{"location":"known-issues-visualapplets-release-3-6-1.html#library-color","title":"Library Color","text":"Summary: Some Color Conversions Don't Work As Expected Description: Operators of the Color library should be used carefully: Some color conversions don't work as a user would assume:<ul><li>HSI2RGB converts HSL -&gt; RGB</li><li>RGB2YUV converts RGB-&gt;YCbCr</li><li>XYZ2LAB uses constants according to the following definitions: www.easyrgb.com </li></ul> Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-6-1.html#colortransform-operator","title":"<code>ColorTransform</code> Operator","text":"Summary: Limitations for Negative Transformations Coefficients Description: The <code>ColorTransform</code> operator supports negative transformation coefficients only in the case where the input format is signed or the coefficients are static. Workaround: No workaround is available. Ticket ID: 251344"},{"location":"known-issues-visualapplets-release-3-6-1.html#bayer5x5linear-operator","title":"<code>BAYER5x5Linear</code> Operator","text":"Summary: The Resource Estimation in VisualApplets for <code>BAYER5x5Linear</code> Differs From the Estimation in Xilinx Description: <code>BAYER5x5Linear</code>: In some cases, the resource estimation in VisualApplets for this operator (in FPGA Resource Usage dialog) might differ from the estimation displayed by the Xilinx tools after Place &amp; Route. Workaround: No workaround is available. Ticket ID: 6426"},{"location":"known-issues-visualapplets-release-3-6-1.html#library-compression","title":"Library Compression","text":""},{"location":"known-issues-visualapplets-release-3-6-1.html#jpeg_encoder-operator","title":"<code>JPEG_Encoder</code> Operator","text":"Summary: The Output Transfer Of the <code>JPEG_Encoder</code> Operator Starts Earlier Than the Actual Image Data Transfer Description: Operator: To optimize its image throughput rate (band width), the operator outputs the header as soon as header generation is activated - even before image data arrive at the operator's input. This way, the transfer of the header data doesn't interrupt the transfer of image data, as the header is transferred in advance. The drawback of this practice is that the operator's output transfer starts earlier than the actual image data transfer. This may cause irritations under specific circumstances:  If you are using the <code>SourceSelector</code> operator directly after <code>JPEG_Encoder</code>: The <code>SourceSelector</code> operator registers a partly processed frame as soon as it gets the header data. Therefore, if <code>SourceSelector</code> is switched to getting image data from <code>JPEG_Encoder</code>, <code>SourceSelector</code> cannot be switched to any another source as it always detects an unfinished frame. In addition, when header generation is enabled and <code>SourceSelector</code> switches from another source to the <code>JPEG_Encoder</code> channel, the first image is lost. Workaround: If working on eVA devices, make sure the output is capable to accept data transfer before the sensor transfer is started. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-6-1.html#library-filter","title":"Library Filter","text":""},{"location":"known-issues-visualapplets-release-3-6-1.html#firkernelnxm-operator","title":"<code>FIRKernelNxM</code> Operator","text":"Summary: <code>FIRKernelNxM</code> Operator May Cause Processing Errors Description: The <code>FIRKernelNxM</code> operator may cause processing errors in case the <code>EdgeHandling</code> parameter is set to constant, the number of columns &gt; 2*parallelism, the number of kernel columns is an even number, and parallelism &gt; 1. The error can be monitored at the left border of an image, where wrong pixel data is used at the kernel positions inside the frame. Workaround: No workaround is available. Ticket ID: 2939"},{"location":"known-issues-visualapplets-release-3-6-1.html#library-hardware-platforms","title":"Library Hardware Platforms","text":""},{"location":"known-issues-visualapplets-release-3-6-1.html#trigger-operators","title":"Trigger Operators","text":"Summary: Trigger Operators May Cause Spikes at the Trigger Output Line Description: Trigger operators may cause spikes at the trigger output line during initialization phase when loading the applet onto the frame grabber. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-6-1.html#imagebuffermultiroidyn-operator","title":"<code>ImageBufferMultiRoiDyn</code> Operator","text":"Summary: Timing Errors with Small Images Description: The <code>ImageBufferMultiRoiDyn</code> operator may cause timing errors in case of very small input images. Workaround: No workaround is available. Ticket ID: \u2013"},{"location":"known-issues-visualapplets-release-3-6-1.html#library-synchronization","title":"Library Synchronization","text":""},{"location":"known-issues-visualapplets-release-3-6-1.html#islastpixel-operator","title":"<code>IsLastPixel</code> Operator","text":"Summary: The <code>IsLastPixel</code> Operator Incorrectly Indicates That an Image Is Empty Description: The <code>IsEmpty</code> output of the <code>IsLastPixel</code> operator doesn't work correctly when the parameter <code>Mode</code> is set to <code>Frame</code>. This issue affects both simulation and hardware behavior. In hardware, an empty frame may be incorrectly marked as non-empty. In simulation, a non-empty frame may be incorrectly marked as empty. Workaround: Don't use the <code>IsEmpty</code> output when <code>Mode</code> = <code>Frame</code>. Ticket ID: 337672"},{"location":"legal-info.html","title":"Legal Info","text":""},{"location":"legal-info.html#responsible","title":"Responsible","text":"<p>Basler AG An der Strusbek 60-62 22926 Ahrensburg</p> <p>Tel. +49 4102 463 0 Fax +49 4102 463 109</p> <p>info@baslerweb.com</p> <p>Management board: Dr.Ing. Dietmar Ley (CEO), Ines Br\u00fcckel (CFO), Hardy Mehl (CCO/COO)</p> <p>Chairman of the supervisory board: Norbert Basler</p> <p>Amtsgericht Luebeck HRB 4090</p> <p>Value added tax ID: DE 135 098 121</p> <p>WEEE registration number: DE 83888045</p>"},{"location":"new-features-in-visualapplets-3-0-3.html","title":"New Features in VisualApplets 3.0.3","text":""},{"location":"new-features-in-visualapplets-3-0-3.html#visualapplets-expert-extension","title":"VisualApplets Expert (Extension)","text":"<p>VisualApplets Release 3.0.3 for the first time includes the VisualApplets Expert extension<sup>a</sup>. As the name suggests, this extension offers a broad range of completely new expert features valuable for highly advanced users. The most important new features are:</p>"},{"location":"new-features-in-visualapplets-3-0-3.html#custom-operator-libraries","title":"Custom Operator Libraries","text":"<p>With the completely new VisualApplets Custom Operator Functionality, image processing modules designed in VHDL or Verilog can be used in VisualApplets as operators. The modules are incorporated as pre-synthesized IP core netlists. Each IP core builds one operator. After a GUI driven integration procedure, these operators work like built-in VisualApplets operators.</p>"},{"location":"new-features-in-visualapplets-3-0-3.html#debugging-library","title":"Debugging Library","text":"<p>The Debugging library offers a variety of operators with enhanced debugging capabilities. They can be used for debugging VisualApplet Designs in the real runtime environment as well as for debugging custom operators which are still under development. In the latter case, the Debugging library allows to analyze how new custom operators effect the designs they are instantiated in.</p>"},{"location":"new-features-in-visualapplets-3-0-3.html#parameters-library","title":"Parameters Library","text":"<p>Library Parameters allows to set paths to specific parameters which may be deeply embedded in hierarchical structures. This way, even parameters in protected hierarchical boxes (or in protected hierarchical boxes that are nested in other protected hierarchical boxes) can be set and reset during design time and runtime, since their parametrization interface is lifted up in the hierarchy to a hierarchical level that is not access restricted. The translation operators of the library in addition allow translated access (read and write) to parameters of one or several other operators. For calculation, formulas can be defined according to the GenICam API 2.0 standard.</p>"},{"location":"new-features-in-visualapplets-3-0-3.html#embedded-visualapplets-extension","title":"Embedded VisualApplets (Extension)","text":"<p>VisualApplets Release 3.0.3 for the first time includes eVA Designer which is part of the VisualApplets Embedded extension<sup>b</sup>. With eVA Designer, you can set up hardware platforms with image processing FPGA to be programmable with VisualApplets. eVA Designer supports you in defining and testing a custom VisualApplets IP core for your FPGA and generates a dedicated plug-in for VisualApplets that introduces all details of the IP core and surrounding FPGA design to VisualApplets.</p>"},{"location":"new-features-in-visualapplets-3-0-3.html#other-new-features-all-licenses","title":"Other New Features (All Licenses)","text":""},{"location":"new-features-in-visualapplets-3-0-3.html#support-of-new-frame-grabber-hardware-me5-marathon-vf2","title":"Support of New Frame Grabber Hardware mE5 marathon VF2","text":"<p>VisualApplets 3.0.3 supports programming for the new CLHS frame grabber microEnable 5 marathon VF2.</p>"},{"location":"new-features-in-visualapplets-3-0-3.html#cxp-implementation","title":"CXP Implementation","text":"<p>Flexible CXP Implementation: The CXP interpretation implemented in VisualApplets is more flexible now and tolerates small derivations of the CXP standard in incoming image data. This leads to improved runtime stability. The extended CXP flexibility is implemented for all CXP target platforms.</p>"},{"location":"new-features-in-visualapplets-3-0-3.html#operators","title":"Operators","text":""},{"location":"new-features-in-visualapplets-3-0-3.html#new-operator-pixelreplicator","title":"New Operator PixelReplicator","text":"<p>Library Synchronization has a new operator <code>PixelReplicator</code> that allows to replicate input pixels. The operator is available for all target hardware platforms.</p>"},{"location":"new-features-in-visualapplets-3-0-3.html#library-logic-new-parameter-in-comparison-operators","title":"Library Logic: New Parameter in Comparison Operators","text":"<p>All comparison operators of the Logic library have a new parameter <code>ImplementationType</code> that allows the user to influence the implementation of the operator, i.e., to define which logic elements are used for implementing the operator. The comparison operators are: &lt; CMP_AgeB&gt;, &lt; CMP_AgtB&gt;, &lt; CMP_AleB&gt;, &lt; CMP_AltB&gt;, &lt; CMP_Equal&gt;, &lt; CMP_NotEqual&gt;, &lt; IS_Equal&gt;, &lt; IS_GreaterEqual&gt;, &lt; IS_GreaterThan&gt;, &lt; IS_InRange&gt;, &lt; IS_LessEqual&gt;, &lt; IS_LessThan&gt;, &lt; IS_NotEqual&gt;</p>"},{"location":"new-features-in-visualapplets-3-0-3.html#parameter-pcieinterfacetype-for-marathon-and-lightbridge","title":"Parameter PcieInterfaceType for marathon and LightBridge","text":"<p>Operator <code>AppletProperties</code> now offers parameter <code>PcieInterfaceType</code> for all marathon and LightBridge devices. The parameter <code>PcieInterfaceType</code> allows you to select which PCIe interface type is supported by the applet. The selected value { Generation_1, Generation_2} defines the supported DMA bandwidth (reflected in operator DMAtoPC).</p> <ol> <li> <p>To get access to the functionality of the Expert extension, you need an according license key.\u00a0\u21a9</p> </li> <li> <p>To get access to the functionality of the VA Embedder extension, you need an according license key.\u00a0\u21a9</p> </li> </ol>"},{"location":"new-features-in-visualapplets-3-0-4.html","title":"New Features in VisualApplets 3.0.4","text":""},{"location":"new-features-in-visualapplets-3-0-4.html#new-operator-actioncommand-me4-vq4-only","title":"New Operator ActionCommand (mE4 VQ4 only)","text":"<p>The hardware-specific library for microEnable 4 VQ4-GE and microEnable IV VQ4-GPoE has a new operator <code>ActionCommand</code>. The operator allows the communication of GigE Vision action commands to and from the camera via firmware.</p> <p>Compatibility</p> <p>Applets using action commands via firmware need to be used on mE4 VQ4-GE frame grabbers that have firmware version 1.8a (or higher) installed and that are connected to a host PC that runs Basler runtime software version 5.4.3 (or higher).</p>"},{"location":"new-features-in-visualapplets-3-0-6.html","title":"New Features in VisualApplets 3.0.6","text":""},{"location":"new-features-in-visualapplets-3-0-6.html#new-hardware-platform-marathon-vcx-qp-supported","title":"New Hardware Platform marathon VCX-QP Supported","text":"<p>Designs for the completely new Basler frame grabber board mE5 marathon VCX-QP can be designed and built.</p>"},{"location":"new-features-in-visualapplets-3-0-6.html#cxp-camera-operators-allow-to-define-incoming-pixel-format","title":"CXP Camera Operators Allow to Define Incoming Pixel Format","text":"<p>The three CXP camera operators <code>CXPSingleCamera</code>, <code>CXPDualCamera</code>, and C<code>XPQuadCamera</code> now allow to define the pixel format of the image data that are coming in from the camera. Supported are all Mono, RGB, and Bayer pixel formats supported by the CXP specification. For all other CXP pixel formats, the pixel format setting \"RAW\" can be used. The three camera operators are available for all Basler CXP frame grabbers (mE5 marathon VCX-QP, mE5 ironman VQ8-CXP6D, and / mE5 ironman VQ8-CXP6B).</p>"},{"location":"new-features-in-visualapplets-3-0-6.html#improved-protection-of-changes-in-user-library-instances","title":"Improved Protection of Changes in User Library Instances","text":"<p>Instances of user library elements that have been modified by the user are marked now with a special icon. In addition, when an update or quick update from the user library is started on such an instance, an according message occurs that informs the user that all changes that have been made to this instance will be lost if the update is carried out. This way, adapted user library instances cannot be overwritten unintentionally anymore. (4906)</p>"},{"location":"new-features-in-visualapplets-3-0-6.html#applets-for-marathon-vcl-and-lightbridge-vcl-pocl-support-per-default-deactivated","title":"Applets for marathon VCL and LightBridge VCL: PoCL Support per Default Deactivated","text":"<p>Applets you create with VisualApplets 3.0.6 (or higher) for marathon VCL and LightBridge VCL boards: The automatic PoCL detection feature will be disabled on the frame grabber board running the applet. PoCL support needs to be enabled by the user via microDiagnostics (menu Tools -\\Board Settings). microDiagnostics comes as part of the Basler runtime software installation. The option for enabling/disabling PoCL support is implemented in microDiagnostics since runtime version 5.5.1 (and higher).</p>"},{"location":"new-features-in-visualapplets-3-0-6.html#tcl-export-and-import-option","title":"Tcl Export and Import Option","text":"<p>VisualApplets 3.0.6 allows to export VisualApplets designs as human readable Tcl script code (*.tcl). This new feature is intended for revision control and for comparing different versions automatically (by creating \"diffs\"). Earlier exported Tcl script code can be imported into VisualApplets. The Tcl scripts are not intended for being used as the primary file format for saving designs. The generated Tcl scripts do not cover all style information and don't contain the design structure of instantiated user library elements.</p>"},{"location":"new-features-in-visualapplets-3-0-6.html#isfirstpixel-and-islast-pixel-two-new-operators-in-the-synchronization-library","title":"IsFirstPixel and IsLast Pixel \u2013 Two new Operators in the Synchronization Library","text":"<p>Library Synchronization has two new operators:</p> <ul> <li><code>IsFirstPixel</code>: Operator <code>IsFirstPixel</code> marks the first pixel in a line (in line mode) or in a frame (in frame mode). The operator outputs a 1 on its output port <code>IsFirstO</code> for each first pixel of a line/frame.</li> <li><code>IsLastPixel</code>: Operator <code>IsLastPixel</code> marks the last pixel of a line (in line mode) / of a frame (in frame mode). The operator can also be used to mark empty lines (in line mode) or empty frames (in frame mode).</li> </ul>"},{"location":"new-features-in-visualapplets-3-0-6.html#examples","title":"Examples","text":"<p>The set of design examples has been extended:</p> <ul> <li>Print inspection: Two new examples for print inspection have been added that both, though using different methods, allow object detection with identifying defects and correcting the position of detected objects within an image.</li> <li>Triggering: The set of design examples using triggers has been extended. Furthermore, the examples are now available in hardware platform specific variants.</li> <li>Basic Acquisition: The set of basic acquisition examples has been extended. Furthermore, the examples are now available in hardware platform specific variants.</li> </ul>"},{"location":"new-features-in-visualapplets-3-0.html","title":"New Features in VisualApplets 3.0","text":""},{"location":"new-features-in-visualapplets-3-0.html#loop-operators","title":"Loop Operators","text":"<p>With the new operators <code>TxImageLink</code> and <code>RxImageLink</code>, it is now possible to implement loops into designs.</p>"},{"location":"new-features-in-visualapplets-3-0.html#support-of-xilinx-vivado-tools","title":"Support of Xilinx Vivado tools","text":"<p>For all currently available marathon and LightBridge platforms, designs can be built using Xilinx Vivado WebPack<sup>a</sup> (free) or Vivado Design Suite<sup>a</sup> in the tool chain. Xilinx ISE WebPack (free) or ISE Design Suite<sup>a</sup> can also be used.</p>"},{"location":"new-features-in-visualapplets-3-0.html#visualapplets-now-64-bit-design-tool","title":"VisualApplets now 64 bit Design Tool","text":"<p>The VisualApplets design software is now a 64 bit program. This entails advanced simulation and synthesis, especially of large images and sequences.</p>"},{"location":"new-features-in-visualapplets-3-0.html#new-library-type-custom-library","title":"New Library Type: Custom Library","text":"<p>Into the Custom Library, operators provided by a user of VisualApplets Expert<sup>b</sup> can be imported.</p>"},{"location":"new-features-in-visualapplets-3-0.html#blob-and-compression-library-without-runtime-licenses","title":"Blob and Compression Library without Runtime Licenses","text":"<p>Blob library and Compression library are now incorporated as VisualApplets 3 extensions. For using these libraries in VisualApplets 3 designs, a one-time licensing is necessary (licenses are stored on the VisualApplets Dongle). Runtime licenses for platforms using applets including operators of these libraries are no longer required.</p>"},{"location":"new-features-in-visualapplets-3-0.html#fast-fourier-transformation","title":"Fast Fourier Transformation","text":"<p>The operator for Fast Fourier Transformation (FFT) has been refined: Now any power of two value for image width between 3 bit and the platform maximum is allowed.</p>"},{"location":"new-features-in-visualapplets-3-0.html#optimized-use-of-fpga-resources-in-microenable-5-platform-designs","title":"Optimized Use of FPGA Resources in microEnable 5 Platform Designs","text":"<p>Many operators have been optimized so that FPGA resource consumption, depending on the individual design, is reduced. This may also improve synthesis time in some cases.</p>"},{"location":"new-features-in-visualapplets-3-0.html#gui-improvements","title":"GUI Improvements","text":"<p>Various dialogs have been enhanced. The VisualApplets License Management tool is now directly accessible from the GUI.</p> <ol> <li> <p>Registered trade mark of Xilinx Corp.\u00a0\u21a9\u21a9\u21a9</p> </li> <li> <p>VisualApplets Expert is a new VisualApplets extension which will be officially released in a subsequent release. At the moment, VisualApplets Expert can be used only by users who are participants of the VisualApplets Expert evaluation program.\u00a0\u21a9</p> </li> </ol>"},{"location":"new-features-in-visualapplets-3-2-0.html","title":"New Features in VisualApplets 3.2.0","text":""},{"location":"new-features-in-visualapplets-3-2-0.html#jpeg-compression-compression-library-feature","title":"JPEG Compression (Compression Library Feature)","text":""},{"location":"new-features-in-visualapplets-3-2-0.html#new-jpeg-compression-operator","title":"New JPEG Compression Operator","text":"<ul> <li> <p>VisualApplets provides a new JPEG operator JPEG_Encoder. The operator performs a JPEG compression of grayscale 8-bit images. It is available for the following hardware platforms:</p> <ul> <li>microEnable 5 marathon frame grabbers</li> <li>microEnable 5 ironman frame grabbers</li> </ul> </li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#library-jpeg-color","title":"Library JPEG Color","text":"<ul> <li>VisualApplets provides a new user library JPEG_Color that allows JPEG compression of color images. The library elements are tailored for the following hardware platforms:</li> <li>microEnable 5 marathon frame grabbers</li> <li>microEnable 5 ironman frame grabbers</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#tcl-expert-feature","title":"Tcl (Expert Feature)","text":""},{"location":"new-features-in-visualapplets-3-2-0.html#script-collection","title":"Script Collection","text":"<ul> <li>The graphical user interface of VisualApplets offers a new pane Script Collection that allows Tcl users to manage, parametrize and execute their Tcl scripts without leaving the VA GUI.</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#new-commands-for-build-flow","title":"New commands for build flow","text":"<p>The Tcl feature of VisualApplets incorporates four new commands for the build flow:</p> <ul> <li> <p><code>Drc</code>: command for starting the first level of the Design Rule Check.</p> </li> <li> <p><code>Drc2</code>: command for starting the second level of the Design Rule Check.</p> </li> <li> <p><code>SelectBuildConfiguration</code>: command for selecting a saved build configuration as active build configuration.</p> </li> <li> <p><code>Build</code>: command for starting the build flow.</p> </li> <li> <p>Tcl command <code>GetDesignProperty</code> has been extended so that the file path of the currently loaded design can be queried now. (8518)</p> </li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#display-of-maximal-data-throughput-rate-on-links","title":"Display of Maximal Data Throughput Rate on Links","text":"<ul> <li>You can select to have the maximal data throughput rate displayed for each link in the design window. You can switch the display on/off via button in the toolbar. The display may be convenient to monitor and calculate the bandwidth on links during design time. (See also section Changes and Bug Fixes/Automatic Bandwidth Analysis.)</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#hierarchical-boxes","title":"Hierarchical Boxes","text":"<ul> <li>You can select a number of elements and put them into a hierarchical box via mouse click, using the new option Move to Hierarchical Box. (5128)</li> <li>You can rename the input and output ports of hierarchical boxes. Use the context menu of the module nodes for renaming. (3528)</li> <li>You can re-arrange the order of input and output ports of a hierarchical box (via options Move Port Up/Move Port Down from the context sensitive menu). The re-arrangement of port order has no impact on the functionality of the hierarchical box. The re-arranged ports are linked to the same inner and outer design elements as before.</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#user-library","title":"User Library","text":"<ul> <li>You can equip your user library elements now with a GUI icon and with a help file for the users of your custom library element. (7776)</li> <li>You can rename the input and output ports of user library elements. Use the context menu of the module nodes for renaming. (3528)</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#library-parameters","title":"Library Parameters","text":"<ul> <li>Several operators of library Parameters now support the new properties 'Description' and 'Unit'. (7857)</li> <li>Within protected user library elements, operators of library Parameters don't require a VA Expert or Parameters Library license any more. So such modules may be distributed to customers which don't have a VA Expert or Parameters Library license. (9244)</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#operators","title":"Operators","text":""},{"location":"new-features-in-visualapplets-3-2-0.html#clhssinglecamera","title":"CLHSSingleCamera","text":"<ul> <li>The CLHS camera operator <code>CLHSSingleCamera</code> has been extended and now also supports acquisition format RAW. In RAW mode, all line and frame markers coming in from the camera will be ignored. \"RAW\" mode is used to support complex link structures and is exclusively available in operator CLHSSingleCamera.</li> <li>CLHS camera operator <code>CLHSSingleCamera</code> now allows to define a second optional output port HeaderO to allow for dynamic configuration. This new output port HeaderO provides the header information of the video package that is currently worked on. The port provides the header information in a pixel of a width of 64 bit.</li> <li>Operator <code>CLHSSingleCamera</code> now supports complex link structures.</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#signaltopixel","title":"SignalToPixel","text":"<ul> <li>Operator <code>SignalToPixel</code> has a variable number of input ports (up to 64 per operator instance).</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#abs","title":"ABS","text":"<ul> <li>Operator <code>ABS</code> now also supports color formats. Each component in a color format is handled separately. (2687)</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#modulocount","title":"ModuloCount","text":"<ul> <li>Operator <code>ModuloCount</code> now supports images with variable line length and with empty lines also in simulation.</li> <li>For parameter <code>Divisor</code>, the 32-bit limit has been removed.</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#framemax","title":"FrameMax","text":"<ul> <li>Operator <code>FrameMax</code> now also supports images with variable line length and with empty lines. (2692)</li> <li>Simulation of operator <code>FrameMax</code> now works correctly also in 0D and 1D format (image protocols VALT_IMAGE0D and VALT_IMAGE1D).</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#framemin","title":"FrameMin","text":"<ul> <li>Operator <code>FrameMin</code> now also supports images with variable line length and with empty lines. (2693)</li> <li>Simulation of operator <code>FrameMin</code> now works correctly also in 0D and 1D format (image protocols VALT_IMAGE0D and VALT_IMAGE1D).</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#framesum","title":"FrameSum","text":"<ul> <li>Operator <code>FrameSum</code> now also supports variable line length and empty lines in a non-empty image. (2694)</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#rowmax","title":"RowMax","text":"<ul> <li>Operator <code>RowMax</code> now also supports variable line length and empty lines in a non-empty image. (2696)</li> <li>Simulation of operator <code>RowMax</code> now works correctly also in 0D and 1D format (image protocols VALT_IMAGE0D and VALT_IMAGE1D).</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#rowmin","title":"RowMin","text":"<ul> <li>Operator <code>RowMin</code> now also supports variable line length and empty lines in a non-empty image. (2697)</li> <li>Simulation of operator <code>RowMin</code> now works correctly also in 0D and 1D format (image protocols VALT_IMAGE0D and VALT_IMAGE1D).</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#rowsum","title":"RowSum","text":"<ul> <li>Operator <code>RowSum</code> now also supports variable line length and empty lines in a non-empty image. (2698)</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#histogram","title":"Histogram","text":"<ul> <li>Operator <code>Histogram</code> now also supports images with variable line length and with empty lines. (3357)</li> <li>An image is now allowed to be smaller than the maximum image width. (3357)</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#cameracontrol","title":"CameraControl","text":"<ul> <li>In CL Base Mode, operator <code>CameraControl</code>, Port B: The polarity of ports CC2 and CC4 has been inverted. Now the polarity behaves the same way as on Port A. (9167)</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#mergeparallel","title":"MergeParallel","text":"<ul> <li>The operator <code>MergeParallel</code> got a new parameter <code>MergeMode</code> which defines how parallel input pixels are arranged in the output link. (5862)</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#new-simulation-engine","title":"New Simulation Engine","text":"<ul> <li>VisualApplets is equipped with a new simulation Engine. The new engine gives a very realistic depiction of the data flow and allows simulating blocked image data streams. Optionally, the new simulation engine can be disabled in cases where the old simulation engine is preferred. (Enable/disable in Menu System Settings-&gt;Simulation-&gt;Simulate data flow synchronization.)</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#netlist-style-selectable-via-gui","title":"Netlist Style Selectable via GUI","text":"<ul> <li>You can select the style for netlist generation now directly from the GUI. Under menu Settings -&gt; System Settings -&gt; Global Build Special Settings -&gt; Style of synthesized design netlists you can change the netlist style from Default to Optimized. Use Optimized when building timing-critical designs to try to achieve a better timing closure in the build flow. VisualApplets will generate the FPGA netlist with an alternative naming scheme which in some cases helps the Xilinx tool flow to generate a better distribution of logic on the FPGA. (See also Release Notes VisualApplets 3.1.1, Build/New Option for Meeting Timing Constraint.) In earlier versions (since VisualApplets 3.1.1), the mode Optimized was already available via environment variable VA_NETLIST_STYLE.</li> </ul>"},{"location":"new-features-in-visualapplets-3-2-0.html#ultrascaleultrascale-fpgas-supported","title":"Ultrascale/Ultrascale+ FPGAs Supported","text":"<ul> <li>Embedded VisualApplets (eVA) now supports platforms working with Ultrascale or Ultrascale+ FPGAs. (8458)</li> </ul>"},{"location":"new-features-in-visualapplets-3-3-0.html","title":"New Features in VisualApplets 3.3.0","text":""},{"location":"new-features-in-visualapplets-3-3-0.html#new-operators","title":"New Operators","text":""},{"location":"new-features-in-visualapplets-3-3-0.html#in-the-library-base","title":"In the Library Base","text":"<ul> <li>A new operator <code>CastKernel</code> is now available, which enables the re-organization of incoming data with respect to parallelism and kernel size. See the documentation of this operator in the Operator Reference. (Ticket ID: 7045)</li> <li>A new operator <code>ExpandToParallel</code> is now available, which expands the input link I with parallelism 1 to an arbitrary parallelism at output link O by replicating the pixel value. See the documentation of this operator in the Operator Reference. (Ticket ID: 4280)</li> </ul>"},{"location":"new-features-in-visualapplets-3-3-0.html#in-the-library-parameters","title":"In the Library Parameters","text":"<ul> <li>A new operator <code>LinkParamTranslator</code> is now available, which enables manipulating link parameters via translation expressions provided by the module and/or write actions from other parameter translation modules. See the documentation of this operator in the Operator Reference. (Ticket ID: 7039)</li> <li>A new operator <code>ResourceReference</code> is now available, which enables manipulating the mapping of device resources via module parameters. See the documentation of this operator in the Operator Reference.</li> <li>A new operator <code>IntParamSelector</code> is now available, with which you can switch between several referenced module parameters of type signed integer, unsigned integer and enumeration. See the documentation of this operator in the Operator Reference. (Ticket ID: 7202)</li> <li>A new operator <code>FloatParamSelector</code> is now available, with which you can switch between several referenced module parameters of type VA_DOUBLE. See the documentation of this operator in the Operator Reference. (Ticket ID: 7202)</li> </ul>"},{"location":"new-features-in-visualapplets-3-3-0.html#in-the-library-synchronization","title":"In the Library Synchronization","text":"<ul> <li>A new operator <code>Overflow</code> is now available, which provides overflow handling when decoupling a non-stoppable image source from a subsequent processing pipeline which may be blocked sometimes. See the documentation of this operator in the Operator Reference. (Ticket ID: 7293)</li> </ul>"},{"location":"new-features-in-visualapplets-3-3-0.html#simulation","title":"Simulation","text":"<p>The Simulation functionality of VisualApplets has been enhanced with two new features:</p>"},{"location":"new-features-in-visualapplets-3-3-0.html#enhancement-of-1d-simulation","title":"Enhancement of 1D Simulation","text":"<p>A new simulation mode has been added, with which 1D image data flow is simulated line-by-line. This resolves earlier limitations like the number of simulation cycles or the requirement for balancing the image heights of the simulation sources. The simulation is more thorough and realistic and designs may now be simulated which could not be simulated before, like loops over lines.</p> <p>You can switch the simulation modes between the legacy mode and the new line-by-line mode in the System Settings. The new line-by-line mode is activated by default. Note that in some cases, the new mode may be significantly slower than the legacy mode.</p> <p>In line-by-line mode, at the start of each processing cycle the simulation sources determine how many lines of pixel data are fed into the processing pipeline. Depending on the source element, the following cases are implemented:</p> <ul> <li>The operator <code>CreateBlankImage</code> utilizes the parameter <code>LinesToSimulate</code> for determining the generated number of lines.</li> <li>The operator <code>CoefficientBuffer</code> generates lines according to the parameter <code>YLength</code>.</li> <li>Simulation source modules generate lines according to the defined crop rectangle, but the simulation source modules are limited by the maximum image height setting of the connected link.</li> </ul> <p>In line-by-line mode no other operators than <code>CreateBlankImage</code> utilize the parameter <code>LinesToSimulate</code> any more.</p> <p>During a simulation cycle the simulation proceeds as long as data can be processed. In simulation probes connected to 1D links incoming lines are aggregated to 2D images. With the end of a simulation cycle those images are completed.</p>"},{"location":"new-features-in-visualapplets-3-3-0.html#enhancement-of-the-simulation-source-viewer-and-the-simulation-probe-viewer","title":"Enhancement of the Simulation Source Viewer and the Simulation Probe Viewer","text":"<ul> <li> <p>The Simulation Viewer (Simulation Source Viewer and Simulation Probe Viewer) has been extended for the following display tools: Line Profile, Line Histogram, and Image Histogram:</p> <p></p> </li> <li> <p>The Simulation Probe Viewer now provides a fixed-point interpretation and scaling of pixel values with a fixed factor. (Ticket ID: 9811)</p> </li> <li>The Simulation Viewer now contains several new color-maps. (Ticket ID: 9909)</li> </ul> <p>See all changes described in the Simulation Chapter of the User Manual.</p>"},{"location":"new-features-in-visualapplets-3-3-0.html#gui","title":"GUI","text":"<ul> <li>Added means for reordering reference parameters of hierarchical boxes which are created by modules of library Parameters. The parameters may be reordered via the module properties dialog or via the new Tcl command <code>SetModuleParamProperty</code>. (8408)</li> <li>A new keyboard shortcut is available: With Ctlr+Space you can now switch in the design panel between selection mode (mouse cursor as an arrow) and moving-canvas-mode (mouse cursor as a hand). (Ticket ID: 9915)</li> </ul>"},{"location":"new-features-in-visualapplets-3-3-0.html#eva-designer","title":"eVA Designer","text":"<ul> <li>The eVA Designer can now handle top-level netlists provided as Vivado .DCP files.</li> </ul>"},{"location":"new-features-in-visualapplets-3-3-0.html#miscellaneous","title":"Miscellaneous","text":"<ul> <li>You can now open a list of command line options for VisualApplets from the command line by calling <code>/?</code> or <code>--help</code>. (Ticket ID: 9445)</li> <li>Rebranding: Silicon Software GmbH is now Basler AG. Therefore, the icons in the GUI of VisualApplets have been changed and the documentation has been adapted accordingly.</li> </ul>"},{"location":"new-features-in-visualapplets-3-3-1.html","title":"New Features in VisualApplets 3.3.1","text":""},{"location":"new-features-in-visualapplets-3-3-1.html#new-operators","title":"New Operators","text":""},{"location":"new-features-in-visualapplets-3-3-1.html#in-the-library-synchronization","title":"In the Library Synchronization","text":"<ul> <li> <p>A new operator <code>CutLine</code> is now available, which dynamically cuts lines of an input image into a number of shorter lines. See the documentation of this operator in the Operator Reference. (Ticket ID: 206593 / 218083 )</p> </li> <li> <p>A new operator <code>CutImage</code> is now available, which dynamically cuts the input image into a number of smaller images. See the documentation of this operator in the Operator Reference. (Ticket ID: 206593 / 218083 )</p> </li> <li> <p>A new operator <code>AppendLineDyn</code> is now available, which dynamically concatenates image lines from the input image at the link <code>I</code> into a larger line in the output image at the link <code>O</code>. See the documentation of this operator in the Operator Reference. (Ticket ID: 206593 / 218083 )</p> </li> <li> <p>A new operator <code>AppendImageDyn</code> is now available, which dynamically concatenates input images into a larger output image. See the documentation of this operator in the Operator Reference. (Ticket ID: 206593 / 218083 )</p> </li> </ul>"},{"location":"new-features-in-visualapplets-3-3-1.html#installer","title":"Installer","text":"<p>It is now possible to install VisualApplets without admin rights. For installation instructions, see Installing VisualApplets. (Ticket ID: 229651)</p>"},{"location":"new-features-in-visualapplets-3-3-1.html#documentation","title":"Documentation","text":"<p>The new Application Note: Shared Memory explains the concept of shared memory and guides you to efficiently use the memory for a specific platform by using the information of RAM size and RAM data width. It also helps you to calculate the resulting bandwidth per RAM for the marathon frame grabber series. (Ticket ID: 214787)</p> <p>Tutorial and Examples contains a new chapter Filling LUT With Content With the Basler Framegrabber API, which explains how you can easily fill a LUT with content during runtime. (Ticket ID: 215185)</p>"},{"location":"new-features-in-visualapplets-3-3-2.html","title":"New Features in VisualApplets 3.3.2","text":""},{"location":"new-features-in-visualapplets-3-3-2.html#licensing","title":"Licensing","text":"<p>With VisualApplets 3.3.2 you get the full power of VisualApplets for your FPGA graphical programming within one single license.</p> <p>The new single IDE license now incorporates all advanced extensions that had to be purchased with an additional license in previous VisualApplets versions, e.g., the Debugging library, the Custom library, the Parameters library, TLC Console, JPEG compression and Segmentation/Classification libraries.</p> <p>Customers, who now decide to acquire the new VisualApplets IDE license will also benefit from new features and improvements coming with the next major versions of VisualApplets. (Ticket ID: 246623)</p>"},{"location":"new-features-in-visualapplets-3-3-2.html#gui","title":"GUI","text":"<p>When modules from library Parameters define a parameter description, this description can now be viewed in the status line of the Module Properties dialog plus as a parameter tool tip for the parameter to which the description is mapped. When the parameter is mirrored as an hierarchical box parameter (i.e. when <code>DisplayName</code> is defined), the description is also present there.</p>"},{"location":"new-features-in-visualapplets-3-3-2.html#examples","title":"Examples","text":"<p>The OperatorExamples have been extended and are now completely documented in the Tutorial and Examples. The examples don't show detailed image computation examples, instead they are designed to give a good idea on how the operator works. (Ticket ID: 253293)</p>"},{"location":"new-features-in-visualapplets-3-3-2.html#documentation","title":"Documentation","text":"<ul> <li>Tutorial and Examples contains a new chapter Hardware Applet: From Idea to Application, which explains the complete workflow of creating a design in VisualApplets, building a hardware applet from this design and working with this hardware applets on your frame grabber. (Ticket ID: 236790)</li> <li>A new Application Note: Designing Signal Processing Applets for Programmable Frame Grabbers is now available. (Ticket ID: 246841)</li> </ul>"},{"location":"new-features-in-visualapplets-3-4-0.html","title":"New Features in VisualApplets 3.4.0","text":""},{"location":"new-features-in-visualapplets-3-4-0.html#new-platform-imaflex-cxp-12-quad","title":"New Platform imaFlex CXP-12 Quad","text":"<p>VisualApplets now supports the new imaFlex CXP-12 Quad platform. The support of this new mE6 platform also provides the following new operators:</p> <ul> <li><code>CxpCamera</code></li> <li><code>CxpRxTrigger</code></li> <li><code>CxpTxTrigger</code></li> <li><code>CxpCameraMultiTap</code></li> <li><code>CxpPortStatus</code></li> <li><code>DmaFromPC</code></li> <li><code>LineBuffer</code><sup>a</sup></li> <li><code>FrameBufferRandomRead</code><sup>b</sup></li> <li><code>RamLUT</code><sup>b</sup></li> </ul> <ol> <li> <p>This operator is functionally backward compatible with the operator <code>ImageBuffer</code> for mE5 frame grabbers.\u00a0\u21a9</p> </li> <li> <p>These operators are functionally backward compatible with operators for mE5 frame grabbers, but the operators for mE5 platforms have different parameters than the operators for the imaFlex CXP-12 Quad platform.\u00a0\u21a9\u21a9</p> </li> </ol> <p>The following operators have been adapted for imaFlex CXP-12 Quad:</p> <ul> <li><code>AppletProperties</code></li> <li><code>BoardStatus</code></li> <li><code>DmaToPC</code></li> <li><code>GPI</code></li> <li><code>GPO</code></li> <li><code>FFT</code></li> <li><code>LED</code></li> <li><code>LUT</code></li> </ul>"},{"location":"new-features-in-visualapplets-3-4-0.html#new-user-library-for-imaflex-cxp-12-quad","title":"New User Library for imaFlex CXP-12 Quad","text":"<p>The new imaFlex_CXP12_Tools.val user library is available for the imaFlex CXP-12 Quad platform, which contains modules to replace the <code>ImageBufferMultiRoI</code> and <code>ImageBufferMultiRoIDyn</code> operators as well as a customized element for JPEG compression (<code>JPEG_Encoder_Color_iF</code>).</p>"},{"location":"new-features-in-visualapplets-3-4-0.html#enhanced-synthesis-engine-for-building-applets-for-imaflex-cxp-12-quad","title":"Enhanced Synthesis Engine for Building Applets for imaFlex CXP-12 Quad","text":"<p>For building applets with the imaFlex CXP-12 Quad platform, you may use an enhanced synthesis engine, which can help reaching timing closure for complex designs. To activate this engine, change the synthesis engine in the Build dialog via the drop-down menu from Standard to Enhanced.</p>"},{"location":"new-features-in-visualapplets-3-4-0.html#windows-11-support","title":"Windows 11 Support","text":"<p>VisualApplets now supports Windows 11 (64 bit). However, Xilinx ISE doesn't support Windows 11. If you want to build applets for platforms that need to be built with Xilinx ISE, install VisualApplets under Windows 10. If your target platform is supported by Vivado, build the applets with Xilinx Vivado (Vivado supports Windows 11). See in the system requirements which platforms are supported by Vivado.</p>"},{"location":"new-features-in-visualapplets-3-4-0.html#gui","title":"GUI","text":""},{"location":"new-features-in-visualapplets-3-4-0.html#new-look-feel","title":"New Look &amp; Feel","text":"<p>The icons of the toolbar and of the dialogs have been updated. You can select between two sizes of the toolbar icons in the System Settings .</p> <p></p>"},{"location":"new-features-in-visualapplets-3-4-0.html#parameter-info-view","title":"Parameter Info View","text":"<p>A new view is available: The Parameter Info view. The Parameter Info view displays all parameters of all operators in the active design and thus provides a good overview of all configured parameters.</p> <p></p>"},{"location":"new-features-in-visualapplets-3-4-0.html#file-formats","title":"File Formats","text":""},{"location":"new-features-in-visualapplets-3-4-0.html#file-format-for-saving-designs","title":"File Format for Saving Designs","text":"<p>The file format to save designs has changed from *.va to *.vad.</p> <p>The new file format is more efficient, faster to load, and safer than the old file format.</p> <p>Designs saved in the old *.va file format are backward compatible, which means you can still open them in VisualApplets and you can still save your design in the *.va file format. However, if your design in *.va legacy file format contains a protected user library element, the content of the protected element isn't saved along with the design. In this case, the user library that contains this element must be imported in VisualApplets when you want to open the *.va design format.</p> <p>Basler recommends to always use the new file format, if possible.</p>"},{"location":"new-features-in-visualapplets-3-4-0.html#file-format-for-saving-user-library-elements-and-custom-libraries","title":"File Format for Saving User Library Elements and Custom Libraries","text":"<p>The file format to save user library elements and custom operator libraries has changed from *.vl to *.val.</p> <p>The new file format is more efficient, faster to load, and safer than the old file format.</p> <p>User library elements and custom operator libraries saved in the old *.vl file format are backward compatible, which means you can still open them in VisualApplets and you can still save your user library elements and custom operator libraries in the *.vl file format. However, if you save your user library in the *.vl legacy file format, protected elements can't be saved. In this case, either remove the protection or save the user library in the newer and recommended *.val file format.</p> <p>Basler recommends to always use the new file format, if possible.</p>"},{"location":"new-features-in-visualapplets-3-4-0.html#format-for-clipboard-content","title":"Format for Clipboard Content","text":"<p>The format of the clipboard content has changed. With this new format, it's not possible to copy design content from designs opened in VisualApplets 3.4.0 to designs opened in previous VisualApplets versions using the clipboard (copy&amp;paste). However, copying from previous VisualApplet versions to VisualApplets 3.4.0 works.</p>"},{"location":"new-features-in-visualapplets-3-4-0.html#new-naming-scheme-for-instantiated-modules","title":"New Naming Scheme for Instantiated Modules","text":"<p>A new naming scheme for giving a name to new instantiated modules has been implemented. New modules now have the operator's name by default. According to the old naming scheme, the modules were called Module1, Module2 etc. You can restore the old behavior in the System Settings menu, on the Design tab via the Automatic names for modules setting.</p>"},{"location":"new-features-in-visualapplets-3-4-0.html#examples","title":"Examples","text":"<p>The Operator Examples have been extended so that every operator is now included in an example. The examples are documented in Tutorial and Examples. The examples don't show detailed image computation examples, instead, they are designed to give a good idea on how the operator works.</p>"},{"location":"new-features-in-visualapplets-3-4-1.html","title":"New Features in VisualApplets 3.4.1","text":""},{"location":"new-features-in-visualapplets-3-4-1.html#new-parameter-writepriority-for-the-linebuffer-operator","title":"New Parameter <code>WritePriority</code> for the <code>LineBuffer</code> Operator","text":"<p>The <code>LineBuffer</code> operator has been enhanced with a new write priority mode. You can select this mode via a new operator parameter called <code>WritePriority</code>. The new write priority mode helps to avoid buffer overflows during periods in which the needed bandwidth is higher than the DRAM memory bandwidth of the frame grabber. (Ticket ID: 305648)</p>"},{"location":"new-features-in-visualapplets-3-5-0.html","title":"New Features in VisualApplets 3.5.0","text":""},{"location":"new-features-in-visualapplets-3-5-0.html#new-platform-imaflex-cxp-12-penta","title":"New Platform imaFlex CXP-12 Penta","text":"<p>VisualApplets now supports the new imaFlex CXP-12 Penta platform.</p> <p>The following operators have been adapted for imaFlex CXP-12 Penta:</p> <ul> <li><code>AppletProperties</code></li> <li><code>BoardStatus</code></li> <li><code>DmaToPC</code></li> <li><code>GPI</code></li> <li><code>GPO</code></li> <li><code>FFT</code></li> <li><code>LED</code></li> <li><code>LUT</code></li> </ul>"},{"location":"new-features-in-visualapplets-3-5-0.html#new-user-library-for-the-imaflex-cxp-12-platforms","title":"New User Library for the imaFlex CXP-12 Platforms","text":"<p>The new imaFlex_CXP12_Tools_Advanced.val user library is available for the imaFlex CXP-12 platforms, which contains the <code>FrameBufferMultiRoi</code> element that replaces the <code>ImageBufferMultiRoI</code> operator and customized elements for JPEG compression (<code>JPEG_Encoder_Color_iF</code> and <code>JPEG_Encoder_Color_iF_Penta</code>).</p>"},{"location":"new-features-in-visualapplets-3-5-0.html#new-operators","title":"New Operators","text":"<p>VisualApplets 3.5.0 provides the following new operators:</p> <ul> <li>The <code>FrameBufferMultiRoIDyn</code> operator for imaFlex platforms in the Memory library buffers input image data in the frame grabber RAM (DRAM) and reads out multiple dynamic regions of interest (ROI) for each buffered image.</li> <li>The <code>IntFieldVariable</code> operator in the Parameters library generates a software variable field.</li> <li>The <code>EventDataToHost</code> operator in the Base library generates software events with data payload.</li> </ul>"},{"location":"new-features-in-visualapplets-3-5-0.html#examples","title":"Examples","text":"<p>The following new examples are now available for the imaFlex platforms:</p> <ul> <li>Functional Example for the FrameBufferMultRoiDyn Operator on the imaFlex CXP-12 Penta Platform</li> <li>Functional Example for the FrameBufferMultRoi User Library Element on the imaFlex CXP-12 Quad Platform</li> <li>Functional Example for the FrameBufferMultRoi User Library Element on the imaFlex CXP-12 Penta Platform</li> <li>Functional Example for User Lib Operator JPEG_Encoder_Color_iF on imaFlex CXP-12 Quad Platform</li> <li>Functional Example for User Lib Operator JPEG_Encoder_Color_iF_Penta on imaFlex CXP-12 Penta Platform</li> <li>Example for the DMAFromPC Operator on the imaFlex CXP-12 Quad Platform</li> </ul>"},{"location":"new-features-in-visualapplets-3-5-0.html#gui","title":"GUI","text":"<p>Most operators of the Parameters library now provide an autocompletion and syntax highlighting functionality for specific parameters. For details about syntax highlighting and autocompletion, see topic Diagram Parametrization in the VisualApplets User Manual.</p>"},{"location":"new-features-in-visualapplets-3-5-0.html#ultraram-support-for-memory-library-operators","title":"UltraRAM Support for Memory Library Operators","text":"<p>The imaFlex platfoms support a new type of dedicated memory blocks called \"UltraRAM\" or \"URAM\". UltraRam elements provide large FPGA memory capacity, additional to the BRAM resources. Using UltraRam may help when running out of BRAM resources.</p> <p>The following Memory library operators now support both Block RAM and UltraRAM:</p> <ul> <li><code>LineMemory</code> for imaFlex platforms</li> <li><code>ImageFifo</code></li> </ul> <p>You can select the type of used resources via the new <code>ImplementationType</code> parameter.</p> <p>The LUT operator has been improved so UltraRam can now be used with less restrictions for input and output bit width.</p>"},{"location":"new-features-in-visualapplets-3-5-1.html","title":"New Features VisualApplets 3.5.1","text":"<p>Service Release VisualApplets 3.5.1 contains no new features. All changes compared to the previous version of VisualApplets are listed in section Changes and Fixed Issues</p>"},{"location":"new-features-in-visualapplets-3-6-0.html","title":"New Features in VisualApplets 3.6.0","text":""},{"location":"new-features-in-visualapplets-3-6-0.html#python-scripting","title":"Python Scripting","text":"<p>Added Python scripting which may be used as an alternative to Tcl scripting. Python scripting comes with a binary interface to simulation data so Python may be efficiently used to enrich the simulation process by generating stimuli and verifying the output. You find a complete list of all Python commands in topic Python Command Reference.</p> <p>VisualApplets version 3.6.0 also provides examples for Python scripting.</p> <p>You can now also use Python scripting in Script Collections.</p> <p>This version of VisualApplets includes Python 3.13, which is installed in the /lib/python313 folder within the VisualApplets installation directory. You can add Python modules by running <code>lib\\python313\\python.exe -m pip install &lt;module_name&gt;</code>. For example, to install numpy, open the Windows Command Prompt, navigate to the python313 folder, and run <code>python -m pip install numpy</code>.</p>"},{"location":"new-features-in-visualapplets-3-6-0.html#new-operators","title":"New Operators","text":"<p>VisualApplets 3.6.0 provides the following new operators:</p> <p>Memory Library:</p> <ul> <li>FrameBufferMultiRoi for imaFlex platforms: This operator buffers input image data in the frame grabber RAM (DRAM) and outputs an arbitrary number of regions of interest (ROI) for each buffered image. This operator replaces the user library elements <code>ImageBufferMultiRoI</code> from the user library imaFlex_CXP12_Tools and <code>FrameBufferMultiRoi</code> from the user library imaFlex_CXP12_Tools_Advanced. The old user library elements are still delivered with VisualApplets for compatibility reasons.</li> <li>CoefficientBufferMultiRoi for imaFlex platforms: The operator allows you to upload image data from the host PC to the frame grabber RAM (DRAM). It provides continuous data output for an arbitrary number of regions of interest (ROI). This operator can be used for ImaFlex platforms as a replacement for the <code>CoefficientBuffer</code> operator. The difference is that the <code>CoefficientBuffer</code> operator supports multiple output links, whereas the <code>CoefficientBufferMultiRoi</code> operator uses kernel components to output multiple images.</li> </ul> <p>Blob Library:</p> <ul> <li>The new operators BlobDetector1D and BlobDetector2D replace the former operators Blob_Analysis_1D and Blob_Analysis_2D. The new operators support higher clock frequencies and ensure deterministic output order of results. Additionally, error handling has been significantly improved. The new operators come with a set of new examples. The old operators, <code>Blob_Analysis_1D</code> and <code>Blob_Analysis_2D</code>, are retained for backward compatibility.</li> </ul>"},{"location":"new-features-in-visualapplets-3-6-0.html#examples","title":"Examples","text":"<p>The following new examples are now available:</p> <ul> <li>Added a new example for handling image data from 3 tap mono cameras. See Tap Geometry Sorting Examples Documentation for a ist of all tap geometry sorting examples.</li> <li>Added design examples for flat-field correction (Block FFC) that don't use DRAM for storing coefficient data. Instead, these examples use interpolation of a small amount of coefficient data to correct the image.</li> <li>Added new HDR (High Dynamic Range) examples for the racer 2 L line scan camera. (Ticket ID: 336275)</li> </ul>"},{"location":"new-features-in-visualapplets-3-6-0.html#gui-improvements","title":"GUI Improvements","text":"<ul> <li>You can now undock diagram tabs in the Design Panel of the main window so that the design content appears in a floating window. With this new feature you can now edit a design using multiple screens.</li> <li>Added the option to split the Design Panel within the main window, allowing two diagram tabs to be displayed side-by-side.</li> <li>Added detailed notifications for link errors to help resolve conflicts with VisualApplets design rules. These notifications are available as tooltips in the link properties dialog, as tooltips for links in an error state, and as new messages in the DRC log.</li> </ul>"},{"location":"new-features-in-visualapplets-3-6-1.html","title":"New Features in VisualApplets 3.6.1","text":"<p>Service Release VisualApplets 3.6.1 contains no new features. All changes compared to the previous version of VisualApplets are listed in section Changes and Fixed Issues.</p>"},{"location":"new-features-visualapplets-3-1-1.html","title":"New Features VisualApplets 3.1.1","text":"<p>Service Release VisualApplets 3.1.1 contains no new features. All changes compared to the previous version of VisualApplets are listed in section Changes and Fixed Issues</p>"},{"location":"new-features-visualapplets-3-1-2.html","title":"New Features VisualApplets 3.1.2","text":"<p>Service Release VisualApplets 3.1.2 contains no new features. All changes compared to the previous version of VisualApplets are listed in section Changes and Fixed Issues</p>"},{"location":"new-features-visualapplets-3-1.html","title":"New Features VisualApplets 3.1","text":"<p>Service Release VisualApplets 3.1 contains no new features. All changes compared to the previous version of VisualApplets are listed in section Changes and Fixed Issues</p>"},{"location":"new-features-visualapplets-3-2-1.html","title":"New Features VisualApplets 3.2.1","text":"<p>Service Release VisualApplets 3.2.1 contains no new features. All changes compared to the previous version of VisualApplets are listed in section Changes and Fixed Issues</p>"},{"location":"overview-of-embedded-visualapplets.html","title":"Overview of Embedded VisualApplets","text":"<p>Embedded VisualApplets is a framework that allows you to use VisualApplets technology on any FPGA-operated image processing hardware platform.</p> <p>To make a device programmable by VisualApplets, a VisualApplets IP core needs to be integrated into the top-level FPGA design of the device.</p> <p>After integration, this IP core can be programmed and re-programmed with VisualApplets.</p> <p>The embedded VisualApplets framework provides you with all necessary tooling.</p> <p>For more information, see the Basler website.</p>"},{"location":"overview-of-scripting.html","title":"Overview of Scripting","text":"<p>VisualApplets offers two scripting interfaces with which you can manage your designs via the scripting languages Tcl or Python.</p> <p>What are the benefits of describing VisualApplets commands in scripting, rather than using the graphical user interface?</p> <p>Scripting in Python or Tcl provides the power of a programming language while being easy-to-learn. Using it can be as simple as calling commands in a shell. At the same time advanced programming techniques can be used to set up sophisticated processing schemes.</p> <p>To combine VisualApplets with the power of a scripting language allows for an enormous increase of productivity.</p> <p>You can:</p> <ul> <li>automatize the creation of designs: Use scripts to assemble components of your design controlled by parameters. Set up libraries of processing pipelines and create bunches of different designs automatically.</li> <li>automatize the simulation of designs: Scripting allows you to define very extensive simulation runs: You can, for example, specify series of simulation runs over thousands of images stored somewhere in your file system. Or, you can define various simulation runs where different sets of design parameters are used for simulation.</li> </ul> <p>Info</p> <p>To use the scripting feature of VisualApplets, you need to purchase and install either an Expert license or the VisualApplets 4 license.</p> <p>Info</p> <p>You can also export your VisualApplets design as Tcl script. For details, see topic Tcl Export.</p>"},{"location":"overview-of-visualapplets.html","title":"Overview of VisualApplets","text":"<p>Using VisualApplets, you program the central processing element of the platform, the FPGA.</p> <p>Comprehensive libraries support you with more than 200 operators. Drag-and-drop editing allows you to create your design in form of a data flow model, thus minimizing the time effort for designing new solutions. The integrated high-level simulation gives you full control over the final visual result of a design.</p> <p>Via the build function, you generate the actual bitstream that can be loaded onto the FPGA as well as SDK sample code you can integrate into your applications.</p> <p>VisualApplets allows you to develop real-time image processing applications.</p> <p></p> <p>For more information, see the Basler website.</p>"},{"location":"privacy-policy.html","title":"Privacy Policy","text":"<p>Thank you for visiting our website. We would like to inform you about the handling of your data according to Article 13 of the German Data Protection Regulation (DSGVO).</p>"},{"location":"privacy-policy.html#responsibility","title":"Responsibility","text":"<p>Responsibility for the data processing described below is held by the body named in the imprint.</p>"},{"location":"privacy-policy.html#usage-data","title":"Usage Data","text":"<p>When you visit our web pages, usage data is stored on our web server as a log for statistical purposes and evaluated to improve the quality of our web pages. This data set consists of:</p> <ul> <li>the name and address of the requested content;</li> <li>the date and time of the query;</li> <li>the amount of data transferred;</li> <li>the access status (content transferred, content not found);</li> <li>the description of the web browser and operating system used; and</li> <li>the referral link, which indicates from which page you have reached our page.</li> </ul> <p>This log data is evaluated without identifying information.</p>"},{"location":"privacy-policy.html#data-security","title":"Data Security","text":"<p>To protect your data from unwanted access as comprehensively as possible, we take technical and organizational measures. We use an encryption process on our websites. Your data is transferred from your computer to our server and vice versa via the Internet using TLS encryption. In most cases you can recognize this by the appearance of the closed lock symbol in the status bar of your browser, and the prefix https:// in the address line.</p>"},{"location":"privacy-policy.html#required-cookies","title":"Required Cookies","text":"<p>We use cookies on our websites, which are necessary for the use of our websites.</p> <p>Cookies are small text files that are stored on your terminal device and can be read. A distinction is made between session cookies, which are deleted as soon as you close your browser, and permanent cookies, which are stored beyond the individual session. We do not use these required cookies for analysis, tracking or advertising purposes.</p> <p>These cookies only contain information about certain settings and do not identify a user. They may also be necessary to enable user guidance, security and implementation of the site. We use these cookies on the basis of Article 6 paragraph 1 p. 1 lit. f DSGVO.</p> <p>You can set your browser to inform you about the placement of cookies. This makes the use of cookies transparent for you. You can also delete cookies at any time via the appropriate browser setting and prevent the setting of new cookies. Please note that our websites may then not be displayed correctly and some functions may no longer be technically available.</p>"},{"location":"privacy-policy.html#visitor-measurement","title":"Visitor Measurement","text":"<p>We use web analysis tools to design our websites in line with requirements. These create usage profiles based on pseudonyms. For this purpose, permanent cookies are stored on your end device and read by us. In addition, it is possible that we retrieve recognition features for your browser or end device (e.g. a so-called browser fingerprint or your unabbreviated IP address). In this way, we are able to recognize returning visitors and count them as such.</p> <p>These usage profiles, which are created on the basis of pseudonyms, contain evaluations of the following usage parameters, among others:</p> <ul> <li>If possible, the source of the user (via search engine ads, redirection through other websites or similar);</li> <li>The duration of website use;</li> <li>The amount, sequence and names of visited pages;</li> <li>The number of sessions (sessions) on the website;</li> <li>Country, region and, if applicable, city from which the access is made;</li> <li>Functions used on the website and clicks made (\"events\");</li> <li>Searches performed on the website;</li> <li>Information about the used variants of the website within the scope of so-called A/B tests;</li> <li>Information about the browser, device, operating system, etc. used during access.</li> </ul> <p>The data processing is based on your consent according to Article 6 paragraph 1 p. 1 lit. a DSGVO or \u00a7 15 para. 3 p. 1 TMG, if you have given your consent via our banners.</p>"},{"location":"privacy-policy.html#which-third-party-providers-do-we-use-in-this-context","title":"Which Third-Party Providers Do We Use in This Context?","text":"<p>Below we list the third-party providers with whom we work in connection with visitor measurement. If the data is processed outside the EU or EEA in this context, please note that there is a risk that authorities may access the data for security and monitoring purposes without you being informed or having the right to appeal.</p> Provider Maximum storage time Adequate level of data protection Google LLC (USA) 2 years Third-country transfers based on the EU standard contractual clauses <p>Click here to opt-out of Google Analytics</p>"},{"location":"privacy-policy.html#storage-duration","title":"Storage Duration","text":"<p>Unless we have already informed you in detail about the storage period, we delete personal data when they are no longer required for the aforementioned processing purposes and no legal retention obligations prevent deletion.</p>"},{"location":"privacy-policy.html#other-processors","title":"Other Processors","text":"<p>We share your data with service providers who support us in the operation of our websites and related processes as part of order processing pursuant to Article 28 of the DSGVO. These are, for example, hosting service providers. Our service providers are strictly bound by instructions to us and are contractually obligated accordingly.</p> <p>Below, we name the processors with whom we work, where have not already done so in the preceding text of the privacy policy. If data is transferred outside the EU or EEA in this context, we provide information on the appropriate level of data protection.</p> Processor Purpose Adequate level of data protection Kernpunkt GmbH Web hosting and support Processing only within EU/EEA Netlify Inc. (USA) Web hosting and support Third-country transfers based on the EU standard contractual clauses"},{"location":"privacy-policy.html#your-rights-as-a-data-subject","title":"Your Rights as a Data Subject","text":"<p>When your personal data is processed, the GDPR grants you certain rights as a data subject:</p>"},{"location":"privacy-policy.html#right-of-access-article-15-gdpr","title":"Right of Access (Article 15 GDPR)","text":"<p>You have the right to request confirmation as to whether personal data concerning you is being processed; if this is the case, you have a right to information about this personal data and to the information listed in detail in Article 15 of the GDPR.</p>"},{"location":"privacy-policy.html#right-to-rectification-article-16-dsgvo","title":"Right to Rectification (Article 16 DSGVO)","text":"<p>You have the right to request the correction of inaccurate personal data concerning you and, if necessary, the completion of incomplete data without delay.</p>"},{"location":"privacy-policy.html#right-to-erasure-article-17-dsgvo","title":"Right to Erasure (Article 17 DSGVO)","text":"<p>You have the right to request that personal data concerning you be deleted without undue delay, provided that one of the reasons listed in detail in Article 17 of the DSGVO applies.</p>"},{"location":"privacy-policy.html#right-to-restriction-of-processing-article-18-dsgvo","title":"Right to Restriction of Processing (Article 18 DSGVO)","text":"<p>You have the right to request the restriction of processing if one of the conditions listed in Article 18 of the DSGVO is met, e.g. if you have objected to the processing, for the duration of the review by the controller.</p>"},{"location":"privacy-policy.html#right-to-data-portability-article-20-dsgvo","title":"Right to Data Portability (Article 20 DSGVO)","text":"<p>In certain cases, which are listed in detail in Article 20 of the DSGVO, you have the right to receive the personal data concerning you in a structured, common and machine-readable format or to request the transfer of this data to a third party.</p>"},{"location":"privacy-policy.html#right-of-withdrawal-article-7-dsgvo","title":"Right of Withdrawal (Article 7 DSGVO)","text":"<p>If the processing of data is based on your consent, you are entitled to revoke your consent to the use of your personal data at any time in accordance with Art. 7 (3) DSGVO. Please note that the revocation is only effective for the future. Processing that took place before the revocation is not affected.</p>"},{"location":"privacy-policy.html#right-of-objection-article-21-dsgvo","title":"Right of Objection (Article 21 DSGVO)","text":"<p>If data is collected on the basis of Article 6 (1) p. 1 lit. f DSGVO (data processing for the protection of legitimate interests) or on the basis of Article 6 (1) p. 1 lit. e DSGVO (data processing for the protection of public interest or in the exercise of official authority), you have the right to object to the processing at any time for reasons arising from your particular situation. We will then no longer process the personal data unless there are demonstrably compelling legitimate grounds for the processing which override your interests, rights and freedoms, or the processing serves to assert, exercise or defend legal claims.</p>"},{"location":"privacy-policy.html#right-of-appeal-to-a-supervisory-authority-article-77-dsgvo","title":"Right of Appeal to a Supervisory Authority (Article 77 Dsgvo)","text":"<p>Pursuant to Article 77 of the DSGVO, you have the right to lodge a complaint with a supervisory authority if you are of the opinion that the processing of data relating to you violates data protection provisions. The right of complaint may be asserted in particular before a supervisory authority in the Member State of your habitual residence, your place of work or the place of the alleged infringement.</p>"},{"location":"privacy-policy.html#assertion-of-your-rights","title":"Assertion of Your Rights","text":"<p>Unless otherwise described above, please contact the office mentioned in the imprint to assert your data protection rights.</p>"},{"location":"privacy-policy.html#contact-details-of-the-data-protection-officer","title":"Contact Details of the Data Protection Officer","text":"<p>Our external data protection officer will be happy to provide you with information on the subject of data protection under the following contact details:</p> <p>datenschutz nord GmbH Konsul-Smidt-Stra\u00dfe 88 28217 Bremen (Germany)</p> <p>Web: www.datenschutz-nord-gruppe.de E-Mail: office@datenschutz-nord.de</p> <p>If you contact our data protection officer, please also indicate the responsible office in the imprint.</p>"},{"location":"python-command-reference.html","title":"Python Command Reference","text":"<p>Info</p> <p>This reference describes Python functions for designing, simulating, and building VisualApplets designs in an embedded Python interpreter. All Python functions documented here are case sensitive. Use forward slashes (<code>/</code>) for file paths and for specifying hierarchical paths in design elements.</p> <p>Position Parameters in Diagrams Whenever a function expects a position in the design window, a Python tuple <code>(x, y)</code> is used.</p> <p>Port/Link Identification Links and module ports are identified via the tuple <code>(full_module_name, port_name)</code>. <code>full_module_name</code> has the following syntax: <code>&lt;HierLevelPath&gt;/&lt;ModuleName&gt;</code>.</p> <ul> <li><code>&lt;HierLevelPath&gt;</code> specifies the path to the hierarchical level in the design where the module is located. Start on process level. Use forward slashes.</li> <li><code>&lt;ModuleName&gt;</code> specifies the name of the module you want to delete.</li> </ul> <p>Return Values Unless otherwise noted, functions return <code>None</code> if there\u2019s nothing special to return. Some do return specific data (e.g., lists, strings) for queries.</p> <p>Enumeration-Type Parameters In some function calls, certain parameters can be an enumeration type (e.g., <code>LinkParam.Arithmetic</code>, <code>LinkParam.ColorFlavor</code>, etc.) or a string name of that member. For example, <code>SetLinkParams</code> can accept either an enum member (e.g., <code>Arithmetic.UNSIGNED</code>) or a string (e.g., <code>\"UNSIGNED\"</code>).</p> <p>File Overwrite Behavior Functions that write files (e.g., <code>SaveDesign</code>, <code>ChangePlatform</code>) may include a boolean parameter such as <code>overwrite=False</code>. If <code>False</code>, attempting to overwrite an existing file may raise an exception.</p>"},{"location":"python-command-reference.html#creating-loading-and-saving-designs","title":"Creating, Loading, and Saving Designs","text":""},{"location":"python-command-reference.html#loaddesign","title":"LoadDesign","text":"Command Syntax LoadDesign (<code>file_name</code>: str) <p>Command for loading the design <code>file_name</code>. Specify in <code>file_name</code> the path to the file in your file system and the file name itself. Don't forget to state the file name extension (*.va or *.vad). Use slashes for indicating the path to the design file.</p> <p>Example <pre><code>LoadDesign(\"c:/VA_Python/BaseAreaGray8.va\")\n</code></pre></p> <p>If there is already a design loaded: Close the currently loaded design via command <code>CloseDesign</code> before using command <code>LoadDesign</code>.</p>"},{"location":"python-command-reference.html#createdesign","title":"CreateDesign","text":"Command Syntax CreateDesign (<code>design_name</code>: str, <code>platform_name</code>: str) <p>Command for creating a new design with the name for a hardware platform. For specifying the target platform of the design, you can either use</p> <ul> <li>the VisualApplets library name for the platform (e.g., \"iF-CXP12-Q\"), or</li> <li>the full name of the platform (e.g., \"imaFlex CXP-12 Quad\"). </li> </ul> <p>Example <pre><code>CreateDesign(\"MyNewProject\", \"iF-CXP12-Q\")\n</code></pre></p>"},{"location":"python-command-reference.html#savedesign","title":"SaveDesign","text":"Command Syntax SaveDesign (<code>file_name</code>: str, <code>overwrite</code>: bool = False) <p>Command for saving a design under <code>file_name</code>. Specify in <code>file_name</code> the path to the file and the file name itself. Use slashes for indicating the path to the design file.</p> <p>Don't forget to add the file name extension to the file name.</p> <ul> <li>If you specify file extension *.va or *.vad, your design is saved in the standard VisualApplets design format. All contents of the file are saved. Use the *.vad file format as primary data format for your VisualApplets designs.</li> </ul> <p>If you want to overwrite an existing file, set the optional parameter <code>overwrite</code> to <code>True</code>.</p> <p>Example <pre><code>SaveDesign(\"c:/VA_Python/Project1.va\")\n</code></pre></p>"},{"location":"python-command-reference.html#changeplatform","title":"ChangePlatform","text":"Command Syntax ChangePlatform (<code>platform_name</code>: str, <code>file_name</code>: str, <code>overwrite</code>: bool = False) <p>Command for converting the current design to another hardware platform <code>platform_name</code> and saving the converted design as <code>file_name</code>.</p> <p>Specify the name of the desired hardware platform in parameter <code>platform_name</code>. For specifying the target platform of the design, you can either use</p> <ul> <li>the VisualApplets library name for the platform (e.g., \"iF-CXP12-Q\"), or</li> <li>the full name of the platform (e.g., \"imaFlex CXP-12 Quad\").</li> </ul> <p>Specify in <code>file_name</code> the path to the file (using forward slashes), the file name itself, and the file name extension. If you want to overwrite an existing file, set the optional parameter <code>overwrite</code> to <code>True</code>.</p> <p>Example <pre><code>ChangePlatform(\"iF-CXP12-Q\", \"c:/VA_Python/ConvertedDesign.va\")\n</code></pre></p>"},{"location":"python-command-reference.html#closedesign","title":"CloseDesign","text":"Command Syntax CloseDesign (<code>discard</code>: bool = False) <p>Command for closing the currently open design.</p> <p>If you set the optional parameter <code>discard</code> to <code>True</code>, the design will be closed even if it contains changes that you didn't save yet. The unsaved changes will be discarded.</p> <p>If the parameter <code>discard</code> is set to <code>False</code>, and the design containes changes that you didn't save yet, the command will be terminated and you receive an according error message.</p> <p>Example <pre><code>CloseDesign(discard=True)\n</code></pre></p>"},{"location":"python-command-reference.html#setdesignproperty","title":"SetDesignProperty","text":"Command Syntax SetDesignProperty (<code>key</code>: DesignProperty | str, <code>value</code>: str) <p>Use this command to enter design properties for the currently loaded design.</p> <p>There are four keys you can use:</p> <ul> <li><code>ProjectName</code> (the name you want the project to give)</li> <li><code>Version</code> (version of the design)</li> <li><code>Description</code> (description of the project).</li> <li> <p><code>TargetRuntime</code> (specify here the operating system that will be used on the host PC(s) running this applet on the frame grabber.)</p> <p>The following values are allowed:</p> <ul> <li>Win64</li> <li>Win32</li> <li>Linux64</li> <li>Linux32</li> </ul> </li> </ul> <p>The other enums of <code>DesignProperty</code> (e.g. <code>Loaded</code>) can't be set, but can only be read using <code>GetDesignProperty()</code>.</p> <p>Example <pre><code>SetDesignProperty(\"TargetRuntime\", \"Win64\")\nSetDesignProperty(DesignProperty.ProjectName, \"MyProject\")\n</code></pre></p>"},{"location":"python-command-reference.html#setdesignclock","title":"SetDesignClock","text":"Command Syntax SetDesignClock (<code>freq_in_MHz</code>: float) <p>Command for setting the basic clock frequency of the FPGA (in MHz).</p> <p>Example <pre><code>SetDesignClock(320.0)\n</code></pre></p>"},{"location":"python-command-reference.html#developing-a-design","title":"Developing a Design","text":""},{"location":"python-command-reference.html#createprocess","title":"CreateProcess","text":"Command Syntax CreateProcess ( ) <p>Command for creating a new process. VisualApplets automatically numbers new processes.</p> <p>Example <pre><code>CreateProcess()\n</code></pre></p>"},{"location":"python-command-reference.html#deleteprocess","title":"DeleteProcess","text":"Command Syntax DeleteProcess (<code>process_name</code>: str) <p>Command for deleting a process of the name <code>process_name</code>.</p> <p>Example <pre><code>DeleteProcess(\"Process1\")\n</code></pre></p>"},{"location":"python-command-reference.html#createmodule","title":"CreateModule","text":"Command Syntax CreateModule (<code>operator</code>: str, <code>full_module_name</code>: str, <code>mult</code>: None | dict[str,int] = None, <code>pos</code>: tuple[int,int] = (0,0)) <p>Command for creating an instance (module) of an operator <code>OperatorType</code>, and for positioning the module in the design window.</p> <p>The command has two mandatory and two optional arguments:</p> <ul> <li><code>operator</code>: Name of the operator (e.g., <code>\"BRANCH\"</code>, <code>\"NOP\"</code>, <code>\"Add\"</code>, etc.).</li> <li><code>full_module_name</code>: The hierarchical path plus the desired name for the module, e.g., <code>\"Process0/MyModule\"</code>.</li> <li><code>mult</code> (optional argument): Use this argument to specify a multiplicity of ports.   For example: <code>{\"O\": 3}</code> creates 3 output ports on an operator with an output multiport named <code>\"O\"</code>. See description below.</li> <li><code>pos</code> (optional argument): A tuple <code>(x, y)</code> specifying where to place this new module in the design window.</li> </ul> <p>Examples <pre><code># A BRANCH operator with 3 output ports, placed at (43, 123)\nCreateModule(\"BRANCH\", \"Process0/branchz\", {\"O\": 3}, (43, 123))\n\n# A simple NOP operator at position (83, 163)\nCreateModule(\"NOP\", \"Process0/myNop\", pos=(83,163))\n</code></pre></p> <p>Using the optional parameter <code>mult</code>:</p> <p>Many operators are instantiated with a fix number of ports. On the other hand, there are operators with a variable number of ports. During instantiation of an operator with a variable number of ports, you can define how many ports the module will have.</p> <p>For example, when instanciating operator <code>BRANCH</code>, you can define how many output ports the instance will have:</p> <p></p> <p>Thus, the number of output ports O is variable. Ports that have a variable number of ports we call multiports.</p> <p>Multiports are identified via their base name. In <code>BRANCH</code>, for example, the base name of the output ports is <code>O</code>. Via an index that is added to the base name, a specific port can be identified and addressed:</p> <p></p> <p>When using command <code>CreateModule</code>, you can use the optional argument <code>mult</code> to specify the multiplicity of the vector inputs and the vector outputs of a module  with a dictionary where the key is the base name of the port and its value is the number of ports. This way, you can define the number of ports in instances (modules) of operators that have a variable number of ports, like, for example, operators <code>BRANCH</code> or <code>ADD</code>.</p> <p>Example <pre><code>CreateModule(\"BRANCH\", \"Process0/branchz\", {\"O\": 3}, (43, 123))\n</code></pre></p> <p></p> <p>Defaults: If you don't use <code>mult</code>, the module is created with the default number of inports and outports. How many ports are created per default depends on the operator type.</p> <p>Example <pre><code>CreateModule(\"BRANCH\", \"Process0/branch\", {}, (43, 123))\n</code></pre></p> <p></p> <p>The default number of ports is created, 1 input and 2 output ports.</p> <p>Example <pre><code>CreateModule(\"HierarchicalBox\", \"Process0/hier\", {\"I\": 2,\"O\":3}, (123, 163))\n</code></pre></p> <p></p>"},{"location":"python-command-reference.html#instuserliboperator","title":"InstUserLibOperator","text":"Command Syntax InstUserLibOperator (<code>library</code>: str, <code>operator</code>: str, <code>full_module_name</code>: str, <code>pos</code>: tuple[int,int] = (0,0)) <p>Command for instantiating a user library element. Specify the user library via the parameter <code>library</code>, the name of the element (operator) in the library via the parameter <code>operator</code>, the name you want to give the module in your design and where you want to place the module in the hierarchy via the parameter <code>full_module_name</code>, as well as the position of the module in the design window  via the optional parameter <code>pos</code>.</p> <p>Example <pre><code>InstUserLibOperator(\"MyUserLib\", \"MyOperator\", \"Process0/MyModule\", (100,100))\n</code></pre></p>"},{"location":"python-command-reference.html#instcustomliboperator","title":"InstCustomLibOperator","text":"Command Syntax InstCustomLibOperator (<code>library</code>: str, <code>operator</code>: str, <code>full_module_name</code>: str, <code>pos</code>: tuple[int,int] = (0,0)) <p>Command for instantiating a custom library element. Specify the user library via the parameter <code>library</code>, the name of the element (operator) in the library via the parameter <code>operator</code>, the name you want to give the module in your design and where you want to place the module in the hierarchy via the parameter <code>full_module_name</code>, as well as the position of the module in the design window  via the optional optional parameter <code>pos</code>.</p> <p>Example <pre><code>InstCustomLibOperator(\"MyCustomLib\", \"MyOperator\", \"Process0/MyModule\", (100,100))\n</code></pre></p>"},{"location":"python-command-reference.html#deletemodule","title":"DeleteModule","text":"Command Syntax DeleteModule (<code>full_module_name</code>: str) <p>Command for deleting the module <code>full_module_name</code>.</p> <p>Simulation modules can't be deleted via this command. For deleting simulation modules, use the command <code>DeleteSimModule</code>.</p> <p>Example <pre><code>DeleteModule(\"Process0/Branch1\")\n</code></pre></p>"},{"location":"python-command-reference.html#connectmodules","title":"ConnectModules","text":"Command Syntax ConnectModules (<code>from_port</code>: tuple[str,str], <code>to_port</code>: tuple[str,str], <code>x1:</code> int|None = None, <code>y2:</code> int|None = None, <code>x3</code>: int|None = None) <p>Command for connecting module ports.</p> <p>The parameters <code>from_port</code> and <code>to_port</code> are tuples  with the syntax: <code>(full_module_name, port_name)</code>.</p> <p><code>full_module_name</code> has the following syntax: <code>&lt;HierLevelPath&gt;/&lt;ModuleName&gt;</code>.</p> <p>Example <pre><code>ConnectModules((\"Process0/CxpCamera\", \"O\"),(\"Process0/FrameBufferMultiRoi\", \"I\"))\n</code></pre></p> <p></p> <p>Via the optional parameters <code>x1</code>, <code>y2</code>, and <code>x3</code> you can define the geometry of the connecting polygon: horizontal line from <code>from_port</code> to position <code>x1</code>, vertical line to position <code>y2</code>, horizontal line to position <code>x3</code>, vertical line to height of <code>to_port</code>, horizontal line to <code>to_port</code>.</p> <p></p> <p>Examples <pre><code>ConnectModules((\"Process0/CxpCamera\", \"O\"),(\"Process0/FrameBufferMultiRoi\", \"I\"), x1=90, y2=300, x3=120)\n</code></pre></p>"},{"location":"python-command-reference.html#disconnectmodules","title":"DisconnectModules","text":"Command Syntax DisconnectModules (<code>port</code>: tuple[str,str]) <p>Command for deleting the link that is connected to port <code>port</code>.</p> <p>Example <pre><code>DisconnectModules((\"Process0/cam1\", \"O\"))\n</code></pre></p>"},{"location":"python-command-reference.html#createcomment","title":"CreateComment","text":"Command Syntax CreateComment (<code>full_box_name</code>: str, <code>text</code>: str, <code>pos</code>: tuple[int,int] = (0,0)) <p>Command for creating a comment box.</p> <p>The syntax of <code>full_box_name</code> is <code>&lt;HierLevelPath&gt;/&lt;BoxName&gt;</code>.</p> <ul> <li><code>&lt;HierLevelPath&gt;</code> defines the path to a specific hierarchical level in the design. Start on process level. Use forward slashes.</li> <li><code>&lt;BoxName&gt;</code> specifies the name you want the comment box to have.</li> </ul> <p>Example <pre><code>CreateComment(\"Process0/MyComment\", \"This is my comment.\", (400,400))\n</code></pre></p> <p>For the comment box content <code>text</code> you can use Unicode characters.</p> <p>The position of the comment box in the design window you define via the parameter <code>pos</code>.</p> <p>The return value of function <code>CreateComment</code> is <code>full_box_name</code> (the full hierarchical path to the comment box including the name of the comment box).</p>"},{"location":"python-command-reference.html#deletecomment","title":"DeleteComment","text":"Command Syntax DeleteComment (<code>full_box_name</code>: str) <p>Command for deleting the comment box <code>full_box_name</code>.</p> <p>The syntax of <code>full_box_name</code> is <code>&lt;HierLevelPath&gt;/&lt;BoxName&gt;</code>.</p> <ul> <li><code>&lt;HierLevelPath&gt;</code> specifies the path to the hierarchical level in the design where the comment box is located. Start on process level. Use forward slashes.</li> <li><code>&lt;BoxName&gt;</code> specifies the name of the comment box you want to delete. </li> </ul> <p>Example <pre><code>DeleteComment(\"Process0/MyComment\")\n</code></pre></p>"},{"location":"python-command-reference.html#parameterizing-operators-and-links","title":"Parameterizing Operators and Links","text":""},{"location":"python-command-reference.html#setmoduleparam","title":"SetModuleParam","text":"Command Syntax SetModuleParam (<code>full_module_name</code>: str, <code>param_name</code>: str, <code>value</code>: str|int|float|list[int]|list[float], <code>index</code>: int = -1) <p>Command for setting a module parameter.</p> <p>Info</p> <p>Use this command only for setting an existent parameter to a specific value. You can't use this command for creating metadata parameters. For creating new metadata parameters, use the command <code>SetParamString</code> instead.</p> <p>Examples <pre><code>SetModuleParam(\"Process0/module6\", \"XLength\", 512)\nSetModuleParam(\"Process0/LUT1\", \"LUTcontent\", [12, 13, 14, 15], 4)\n</code></pre></p> <p>Field parameters: For setting a field parameter, the <code>index</code> parameter must be provided.</p> <p>Example for editing field parameters:</p> <p>Before entering the command, the Enter values dialog looks as follows:</p> <p></p> <p>Entering the command</p> <pre><code>SetModuleParam(\"Process0/module3\", \"LUTcontent\", [12, 13, 14], 4)\n</code></pre> <p>has the following result:</p> <p></p>"},{"location":"python-command-reference.html#setmoduleparamproperty","title":"SetModuleParamProperty","text":"Command Syntax SetModuleParamProperty (<code>full_module_name</code>: str, <code>param_name</code>: str, <code>prop</code>: ParamProperty|str, <code>value</code>: ParamTypeFlag|str|int|list[ParamTypeFlag]|list[str]) <p>Command for changing the properties of a module parameter, e.g. making it <code>dynamic</code> or <code>static</code>. This command may replace <code>SetModuleParamType</code>. Single property names may have multiple values. You can change the following properties of <code>prop</code>:</p> <ul> <li> <p><code>access</code>: One or more flags like:</p> <ul> <li><code>write</code>: If the parameter can be switched in this direction, (for instance in the operator <code>LinkParamTranslator</code>), it becomes a write-parameter.</li> <li><code>read</code>: If the parameter can be switched in this direction, (for instance in the operator <code>LinkParamTranslator</code>), it becomes a read-parameter.</li> <li><code>dynamic</code>: If the parameter can be either dynamic or static, it hereby becomes a dynamic parameter.</li> <li><code>static</code>: If the parameter can be either dynamic or static, it hereby becomes a static parameter.</li> </ul> </li> <li> <p><code>position</code>: An integer that defines the parameter's position among multiple parameters.</p> </li> </ul> <p>Example <pre><code># Make a parameter dynamic (if supported).\nSetModuleParamProperty(\"Process0/LinkParamTranslator1\", \"MyParam\", \"access\", [\"dynamic\", \"write\"])\n\n# Reposition a parameter in a hierarchical box\nSetModuleParamProperty(\"Process0/hierBox\", \"ParamA\", \"position\", 3)\n</code></pre></p>"},{"location":"python-command-reference.html#setparamstring","title":"SetParamString","text":"Command Syntax SetParamString (<code>full_module_name</code>: str, <code>param_name</code>: str, <code>value</code>: str) <p>Use this command to define metadata parameters for a specific module.</p> <p>Info</p> <p>Don't use this command for setting an existent module parameter to a new value, even if the module parameter is of the type <code>string</code>.</p> <p>For setting an existent module parameter to a new value, always use the command <code>SetModuleParam</code> in your scripts.</p> <p>Example <pre><code>SetParamString(\"Process0/MyModule\", \"MyNewMeta\", \"Some custom meta info.\")\n</code></pre></p>"},{"location":"python-command-reference.html#setmoduleparamtype","title":"SetModuleParamType","text":"Command Syntax SetModuleParamType (<code>full_module_name</code>: str, <code>param_name</code>: str, <code>type_flag</code>: ParamTypeFlag|str|list[ParamTypeFlag]|list[str]) <p>Command for changing the type of a parameter. The following type flags are available:</p> <ul> <li><code>Dynamic</code>: If the parameter can be dynamic or static, this flag makes the parameter a dynamic parameter.</li> <li><code>Static</code>: If the parameter can dynamic or static, this flag makes the parameter a static parameter.</li> </ul> <p><code>Dynamic</code> and <code>Static</code> mutually exclude each other.</p> <p>Example <pre><code>SetModuleParamType(\"Process0/MyOperator\", \"Threshold\", \"Dynamic\")\n</code></pre></p>"},{"location":"python-command-reference.html#setlinkparams","title":"SetLinkParams","text":"Command Syntax SetLinkParams(<code>link</code>: tuple[str,str], <code>param_dict</code>: dict[LinkParam|str, int|&lt;enum&gt;|str]) <p>Command for configuring the format of links, such as bit width, arithmetic mode, color format, etc. The link parameters can be identified either via the <code>LinkParam</code> enum (e.g. <code>LinkParam.BitWidth</code>), via the name of the enum (e.g. \u201cBitWidth\u201d) or via the name in the GUI (e.g. \u201cBit Width\u201d).</p> <ul> <li><code>link</code>: Tuple for identifying the link via a connected module port `(, ) <li><code>param_dict</code>: A dictionary specifying parameter value pairs. The names of the link format parameters are the same as in the VisualApplets GUI. Example keys: <code>LinkParam.BitWidth</code>, <code>\"Arithmetic\"</code>, etc.</li> <p>Example <pre><code>SetLinkParams(\n    (\"Process0/CreateBlankImage\",\"O\"),\n    {\n        \"Parallelism\": 4,\n        \"ImageProtocol\": \"VALT_LINE1D\",\n        \"MaxImageWidth\": \"2048\"\n    }\n)\n</code></pre></p> <p>Info</p> <p>When writing your Python script manually, the command is only applicable for parameters that can be changed. If you try to set a link parameter that cannot be changed, you will get an according error message:</p> <p></p>"},{"location":"python-command-reference.html#setresourcemapping","title":"SetResourceMapping","text":"Command Syntax SetResourceMapping (<code>full_module_name</code>: str, <code>resource_name</code>: str, <code>new_mapping</code>: int, <code>index</code>: int = -1) <p>Command for changing the mapping of resources to a module, e.g., \"RAM\". The resource <code>resource_name</code> will be mapped to the new index <code>new_mapping</code>. In case the module allocates multiple resources of the same type, use the optional parameter <code>index</code> for selecting the resource.</p> <p>Example <pre><code>SetResourceMapping(\"Process0/ImageBuffer\", \"RAM\", 1)\n</code></pre></p>"},{"location":"python-command-reference.html#splitlink","title":"SplitLink","text":"Command Syntax SplitLink (<code>link</code>: tuple[str,str], <code>number</code>: int = 2) <p>Command for creating a module <code>BRANCH</code>. The new branch module is inserted on the link that is identified by <code>link</code>. The new branch module has <code>number</code> outgoing ports. If you don't use the optional parameter <code>number</code>, the new branch module has two out ports.</p> <p>The return value of function <code>SplitLink</code> is the <code>full_module_name</code> of the new branch module (full hierarchical path to the module, including the module name).</p> <p>Example <pre><code>branchName = SplitLink((\"Process0/MyModule\",\"O\"), 3)\n# branchName might be \"Process0/BRANCH_1\"\n</code></pre></p>"},{"location":"python-command-reference.html#querying-design-structure-and-design-details","title":"Querying Design Structure and Design Details","text":""},{"location":"python-command-reference.html#getdesignproperty","title":"GetDesignProperty","text":"Command Syntax GetDesignProperty (<code>key</code>: DesignProperty|str) \u2192 str | bool <p>This command retrieves design properties. You can use the following values for <code>key</code>:</p> <ul> <li><code>ProjectName</code>:name of the project</li> <li><code>FileName</code>: full path of the currently loaded design file</li> <li><code>HardwarePlatform</code>: library name of target hardware platform, for example <code>iF-CXP12-Q</code></li> <li><code>Version</code>: version of the design</li> <li><code>Description</code>: description of the project</li> <li><code>TargetRuntime</code>: specifies the operating system that will be used on the host PC(s) running this applet on the frame grabber</li> <li><code>Loaded</code>: design is loaded; returns a boolean (<code>True</code>/<code>False</code>)</li> </ul> <p>Design property <code>Loaded</code> can be requested while no design is loaded at all. This doesn't cause an error message. Requesting any other design property while no design is loaded causes an error message.</p> <p>Example <pre><code>val = GetDesignProperty(\"ProjectName\")\nprint(val)  # e.g., \"MyProject\"\n</code></pre></p>"},{"location":"python-command-reference.html#getdesignclock","title":"GetDesignClock","text":"Command Syntax GetDesignClock ( ) \u2192 float <p>This command returns the basic clock frequency of the FPGA in MHz as <code>float</code>.</p>"},{"location":"python-command-reference.html#getprocesses","title":"GetProcesses","text":"Command Syntax GetProcesses ( ) \u2192 list[str] <p>This command returns a <code>list[str]</code> with the names of all processes of the design.</p> <p>Example <pre><code>processes = GetProcesses()\n# e.g. [\"Process0\",\"Process1\"]\n</code></pre></p>"},{"location":"python-command-reference.html#getsubmodules","title":"GetSubModules","text":"Command Syntax GetSubModules (<code>hierarchy_name</code>: str) \u2192 list[str] <p>This command returns a <code>list[str]</code> with the names of the modules that are located in the requested hierarchy <code>hierarchy_name</code>.</p> <p>For each sub-module, the full hierarchical name is listed.</p> <p>Example <pre><code>mods = GetSubModules(\"Process0\")\n</code></pre></p>"},{"location":"python-command-reference.html#getparenthier","title":"GetParentHier","text":"Command Syntax GetParentHier (<code>full_element_name</code>: str) \u2192 str <p>This command returns the hierarchical name (<code>full_module_name</code>) of the parent of stated element <code>full_element_name</code>, that is, the <code>full_module_name</code> of the hierarchical element in which element <code>full_element_name</code> is located.</p> <p><code>full_element_name</code> can be a module, a simulation module, or a comment box.</p> <p>Example <pre><code>parent = GetParentHier(\"Process0/MyModule\")\n</code></pre></p>"},{"location":"python-command-reference.html#getmodules","title":"GetModules","text":"Command Syntax GetModules (<code>scope</code>: SearchScope|ModuleScope|str, <code>specifier</code>: str, <code>module_list</code>: list[str]|None = None) \u2192 list[str] <p>This command filters modules by certain criteria. The command returns a list with modules that have the characteristic you specify via <code>scope</code> and <code>specifier</code>. The list contains the <code>full_module_name</code> for all found modules (path to modules including the individual module name). If you don't want to search design-wide, but only in a specific set of modules, you can specify these modules in the optional argument <code>module_list</code> (via their <code>full_module_name</code>).</p> <p><code>scope</code> can have the following values:</p> <ul> <li><code>\"Pattern\"</code>: Use <code>specifier</code> as a wildcard expression for <code>full_module_name</code>. If you state \"*\" as specifier, all modules of the design are returned.</li> <li><code>\"Flat\"</code>: Use <code>specifier</code> as a wildcard expression for the <code>full_module_name</code> of modules (like with \"Pattern\"). Hierarchical boxes will not be returned.</li> <li><code>\"Ordered\"</code>: Returns all modules of the design. Use <code>specifier</code> to define a sorting \"Pattern\". You have the following options:<ul> <li><code>\"path\"</code>: modules are sorted by their position in the design graph (i.e., in the order of the data stream as it runs through the modules during simulation).</li> <li><code>\"name\"</code>: modules are sorted alphabetically by their <code>full_module_name</code>.</li> </ul> </li> <li><code>\"OperatorType\"</code>:  Use <code>specifier</code> to define the operator type of the modules you are looking for (\"O\", \"M\", \"P\", \"O+P\", \"M+P\", \"unknown\").</li> <li><code>\"Operator\"</code>: For getting all instances of a specific operator. Use <code>specifier</code> to name the operator name (for example, \"NOP\").</li> <li><code>\"LibraryType\"</code>: Use <code>specifier</code> to define a specific library type. All modules in the design that are instances of operators contained in libraries of this type are returned. The following values are allowed: operator, user, and custom (see also <code>GetModuleProperty</code>).</li> <li><code>\"Library\"</code>: Use <code>specifier</code> to define a specific library. All modules that are instances of operators of this library are returned.</li> <li><code>\"Version\"</code>: Use <code>specifier</code> to define a specific operator version. All modules that are instances of operators of this version are returned.</li> </ul> <p>Example <pre><code>allModules = GetModules(\"Pattern\", \"*\")  # all modules\n</code></pre></p>"},{"location":"python-command-reference.html#getmoduleports","title":"GetModulePorts","text":"Command Syntax GetModulePorts (<code>full_module_name</code>: str, <code>scope</code>: PortScope|str) \u2192 list[str] <p>This command returns a <code>list[str]</code> with the names of all ports of the specified module. You can use the optional parameter <code>scope</code> to filter for specific ports:</p> <ul> <li><code>\"Inputs\"</code>: only the input ports are returned</li> <li><code>\"Outputs\"</code>: only the output ports are returned</li> <li><code>\"All\"</code>: all ports of the module are returned (default)</li> </ul> <p>Example <pre><code>inPorts = GetModulePorts(\"Process0/Branch1\", \"inputs\")\n</code></pre></p>"},{"location":"python-command-reference.html#getmoduleportproperty","title":"GetModulePortProperty","text":"Command Syntax GetModulePortProperty (<code>port</code>: tuple[str,str], <code>prop</code>: PortProperty | str) <p>This command retrieves the properties of a module port. The following values for <code>prop</code> are available:</p> <ul> <li><code>\"IsConnected\"</code>: Returns returns a boolean (<code>True</code>/<code>False</code>).</li> <li><code>\"Position\"</code>: Returns the position of the specified port in the diagram (design window) as a tuple (<code>xPos</code>, <code>yPos</code>). If <code>port</code> specifies an inner hierarcical box node, for example, for example, <code>(\"Process0/HBox\",\"INBOUND#I000\")</code>, the position of this node within the hierarchical box design window is returned.</li> </ul>"},{"location":"python-command-reference.html#getmoduleproperty","title":"GetModuleProperty","text":"Command Syntax GetModuleProperty (<code>full_module_name</code>: str, <code>prop</code>: ModuleProperty | str) \u2192 varies <p>This command returns the properties of a module.</p> <p>The following values for <code>prop</code> are available:</p> <ul> <li><code>\"Status\"</code>: Returns an integer:  Returns 0 if module isn't in error status; otherwise returns error code.</li> <li><code>\"Operator\"</code>: Returns name of operator the module is an instance of, for example <code>BRANCH</code>.</li> <li><code>\"OperatorType\"</code>: Returns operator type (O, P, M, unknown). \"Unknown\" is returned for hierarchical boxes and user library modules.</li> <li><code>\"LibraryType\"</code>: Returns the library type of the library the operator stems from. One of the following values is returned: <code>operator</code>, <code>user</code>, <code>custom</code>.</li> <li><code>\"Version\"</code>: Returns the version of the operator the module is an instance of.</li> <li><code>\"Type\"</code>: Returns the module type. One of the following values is returned: <code>process</code>, <code>hierBox</code>, <code>operator</code>, <code>user</code>, <code>custom</code>.</li> <li><code>\"IsHierModule\"</code>: Returns <code>True</code> if the stated module is capable of containing submodules; returns <code>False</code> if the stated module cannot have sub-modules.</li> <li><code>\"IsProtected\"</code>: Returns <code>True</code> if the module is an instance of a protected library element.</li> <li><code>\"Library\"</code>: Returns the name of the library the operator stems from.</li> <li><code>\"Position\"</code>: Returns the position in a design window as a list (<code>xPos</code>, <code>yPos</code>).</li> <li><code>\"Resources\"</code>: Returns a list of tuples (ResourceName, ResourceMapping)</li> <li><code>\"Name\"</code>: Returns the module name.</li> </ul> <p>Example <pre><code>operatorName = GetModuleProperty(\"Process0/MyModule\", \"Operator\")\npos         = GetModuleProperty(\"Process0/MyModule\", \"Position\")\n</code></pre></p>"},{"location":"python-command-reference.html#getmoduleparams","title":"GetModuleParams","text":"Command Syntax GetModuleParams (<code>full_module_name</code>: str, <code>select</code>: list[str] | None = None) \u2192 dict <p>Returns a dictionary where the keys are the parameter names and the values are given in a format depending on the value type:</p> <p>Integer parameter: int Floating-Point parameter: float Enumeration parameter: str Field of integers: list[int] Field of floating-point parameters: list[float] String parameter: str</p> <p>If you want to get all parameters of the module together with the currently set values, use command <code>GetModuleParams</code> only with parameter <code>full_module_name</code>.</p> <p>Example:</p> <p></p> <p>If you want to get only the values of specific parameters, you can optionally limit the output with the optional parameter <code>select</code>.</p> <p>Example:</p> <p></p> <p>Example <pre><code>allParams = GetModuleParams(\"Process0/MyModule\")\nsomeParams = GetModuleParams(\"Process0/MyLUT\", [\"LUTcontent\",\"ImplementationType\"])\n</code></pre></p>"},{"location":"python-command-reference.html#getmoduleparamproperty","title":"GetModuleParamProperty","text":"Command Syntax GetModuleParamProperty (<code>full_module_name</code>: str, <code>param_name</code>: str, <code>prop</code>: ParamProperty | str) <p>Command for retrieving parameter properties.</p> <p>For the parameter <code>prop</code>, the following values are available:</p> <ul> <li><code>\"Status\"</code>: Returns an integer:  Returns 0 if module isn't in error status; otherwise returns error code.</li> <li><code>\"Type\"</code>: Returns the parameter type as <code>ParamType</code>, which may be <code>ParamType.Int</code>, <code>ParamType.Float</code>, <code>ParamType.Enum</code>, <code>ParamType.String</code>, <code>ParamType.IntField</code>, or <code>ParamType.FloatField</code>.</li> <li><code>\"Access\"</code>: Returns whether the parameter is a read-only parameter or not: Returns parameter access as <code>ParamTypeFlag</code> which may be <code>ParamTypeFlag.Write</code> or <code>ParamTypeFlag.Read</code>.</li> <li><code>\"Unit\"</code>: Returns the unit of the parameter.</li> <li><code>\"Range\"</code>: For integer and float data types, the command returns the value range as a list containing the three entries <code>Min</code>, <code>Max</code>, <code>Step</code>. For enum parameters, it returns a list of pairs of enum names and enum values.</li> <li><code>\"Size\"</code>: Returns the size of the field. Only for <code>IntField</code> and <code>FloatField</code> parameters.</li> <li><code>\"IsDynamic\"</code>: Returns <code>True</code> if the requested parameter is dynamic; otherwise returns <code>False</code>.</li> <li><code>\"IsStatic\"</code>: Returns <code>True</code> if the requested parameter is static; otherwise returns <code>False</code>.</li> <li><code>\"IsEditable\"</code>: Returns <code>True</code> if the requested parameter can be edited; otherwise returns <code>False</code>.</li> <li><code>\"Position\"</code>: Returns the position in the list of parameters as integer.</li> </ul> <p>Example <pre><code>rangeVal = GetModuleParamProperty(\"Process0/LUT1\", \"LUTcontent\", \"Range\")\n</code></pre></p>"},{"location":"python-command-reference.html#getlinkparams","title":"GetLinkParams","text":"Command Syntax GetLinkParams (<code>link</code>: tuple[str,str], <code>select</code>: list[LinkParam|str]|None = None) \u2192 dict[LinkParam, (various)] <p>Returns a dictionary where the keys are members of <code>LinkParam</code> and the values are given in a format depending on the key:</p> <ul> <li><code>BitWidth</code> : int</li> <li><code>Arithmetic</code> : Arithmetic</li> <li><code>Parallelism</code> : int</li> <li><code>KernelColumns</code> : int</li> <li><code>KernelRows</code> : int</li> <li><code>ImageProtocol</code> : ImageProtocol</li> <li><code>ColorFormat</code> : ColorFormat</li> <li><code>ColorFlavor</code> : ColorFlavor</li> <li><code>MaxImageWidth</code> : int</li> <li><code>MaxImageHeight</code> : int</li> </ul> <p>Use the optional <code>select</code> parameter for providing a list of link parameters for a specific query of those parameters.</p> <p>Example:</p> <p></p> <p>Example <pre><code>params = GetLinkParams((\"Process0/MyModule\",\"O\"))\nbw = params[LinkParam.BitWidth]  # e.g. 8\n</code></pre></p> <p>Example <pre><code>params = GetLinkParams((\"Process0/MyModule\",\"O\"), [LinkParam.BitWidth])\nbw = params[LinkParam.BitWidth]  # e.g. 8\n</code></pre></p>"},{"location":"python-command-reference.html#getlinkparamproperty","title":"GetLinkParamProperty","text":"Command Syntax GetLinkParamProperty (<code>link</code>: (str, str), <code>param</code>: LinkParam | str, <code>prop</code>: ParamProperty | str) \u2192 varies <p>This command retrieves the properties of a specific link parameter.</p> <p>The following values for the parameter <code>prop</code> are possible:</p> <ul> <li><code>Status</code>: Returns an integer:  Returns 0 if module isn't in error status; otherwise returns error code.</li> <li><code>IsEditable</code>: Returns <code>True</code> if parameter value can be changed; otherwise returns <code>False</code>.</li> <li><code>Range</code>:<ul> <li>For integer data types, the command returns the value range either as a tuple containing three elements (Min, Max, Step), or as a tuple containing all allowed values. You distinguish the two kinds of tuples as follows: The Min-Max-Step tuple contains 3 tuple elements; the third tuple element is smaller or equal to the second tuple element. A tuple stating all allowed values starts with the smalles value and ends with the highest value. If only one value is allowed, the value is returned in format {value value 1}, for example, { 4 4 1} for min=4, max=4, step=1.</li> <li>For enum parameters, the command returns a tuple of pairs of enum names and enum values.</li> </ul> </li> <li><code>Type</code>: Returns the parameter type: Returns <code>ParamType.Enum</code> for the parameters <code>LinkParam.Arithmetic</code>, <code>LinkParam.ImageProtocol</code>, <code>LinkParam.ColorFormat</code>, or <code>LinkParam.ColorFlavor</code>. For any other link parameter, <code>ParamType.Int</code> is returned.</li> </ul>"},{"location":"python-command-reference.html#getlinkproperty","title":"GetLinkProperty","text":"Command Syntax GetLinkProperty (<code>link</code>: tuple[str,str], <code>prop</code>: LinkProperty|str) \u2192 varies <p>This command returns a specific property of a specific link. If you address the port of a hierarchical box with the parameter <code>link</code>, the command works as long as there is a link to or from this port within the hierarchical box.</p> <p>The following options for the parameter <code>prop</code> are available, where the return type depends on the parameter:</p> <ul> <li><code>Status</code>: Returns an integer:  Returns 0 if module isn't in error status (i.e., if the parameter settings of the link source and the link target match, and the DRC doesn't find an error); otherwise returns error code.</li> <li><code>From</code>: Returns the starting point of the link. The starting point can be either the out port of a foregoing module, or an inner hierarchical box node (<code>INBOUND#...</code>) the link is connected to. The command returns a tuple containing the two values <code>&lt;FullModulenname&gt;</code> and <code>&lt;PortName&gt;</code>.</li> <li><code>To</code>: Returns the end point of the link. The end point can be either the in port of a following module, or an inner hierarchical box node (<code>OUTBOUND#...</code>) the link is connected to. The command returns a tuple containing the two values <code>&lt;FullModulenname&gt;</code> and <code>&lt;PortName&gt;</code>.</li> <li><code>Source</code>: Returns the tuple containing the link stated by <code>link</code> for all foregoing links up to the source of the link. The link chain is followed up backwards through the hierarchies, from the module you state in <code>&lt;FullModulenname&gt;</code> back to the starting point. The order of the elements within the returned list corresponds to the backward-course of the lookup (the source module is the last entry in the list).</li> <li><code>Dest</code>: Returns a tuple containing the link stated by <code>link</code> for all following links up to the target module of the link. The link chain proceeds forwards through the hierarchies, from the module you state in <code>&lt;FullModulenname&gt;</code>up to the end (sink). The order of the elements within the returned list corresponds to the forward-course of the lookup \u2013 the target module (destination) is the last entry in the list.</li> <li><code>HasConnectedSimModule</code>: Returns <code>True</code> if a simulation module is connected to the link; returns <code>False</code> if no simulation module is connected.</li> <li><code>ConnectedSimModule</code>: Returns the hierarchical name of a connected simulation module.</li> </ul> <p>Example <pre><code>src = GetLinkProperty((\"Process0/MyModule\",\"O\"), \"To\")\n</code></pre></p>"},{"location":"python-command-reference.html#getsimmodules","title":"GetSimModules","text":"Command Syntax GetSimModules (<code>sim_type</code>: SimModuleType|str, <code>scope</code>: SearchScope|str, <code>specifier</code>: str) \u2192 list[str] <p>Returns the full names of simulation modules matching a given type/filter.</p> <ul> <li><code>sim_type</code> can be <code>\"Source\"</code> or <code>\"Probe\"</code>.</li> <li><code>scope</code> can be <code>\"Hierarchy\"</code> or <code>\"\"Pattern\"\"</code>.</li> <li><code>specifier</code> is a string for the filter or hierarchy.</li> </ul> <p>Example <pre><code>simProbes = GetSimModules(\"Probe\",\"\"Pattern\"\",\"*\")\n</code></pre></p>"},{"location":"python-command-reference.html#getcommentboxes","title":"GetCommentBoxes","text":"Command Syntax GetCommentBoxes (<code>scope</code>: SearchScope|str, <code>specifier</code>: str) \u2192 list[str] <p>This command retrieves comment boxes in a design. The command returns a list with all comment boxes that have the characteristic you specify via the parameters <code>scope</code> and <code>specifier</code>. The list contains the <code>FullElmentNames</code> (hierarchical names including box name).</p> <ul> <li><code>scope</code>:  Can be <code>\"Hierarchy\"</code> or <code>\"\"Pattern\"\"</code>.</li> <li><code>specifier</code>: Is the string \"Pattern\" or hierarchy name.</li> </ul>"},{"location":"python-command-reference.html#getcommentproperty","title":"GetCommentProperty","text":"Command Syntax GetCommentProperty (<code>full_box_name</code>: str, <code>prop</code>: CommentProperty | str) \u2192 str | tuple <p>This command retrieves the properties of a comment box.</p> <p><code>full_box_name</code> has the following syntax: <code>&lt;HierLevelPath&gt;/&lt;BoxName&gt;</code>.</p> <ul> <li><code>&lt;HierLevelPath&gt;</code> specifies the path to the hierarchical level in the design where the comment box is located. Start on process level. Use forward slashes.</li> <li><code>&lt;BoxName&gt;</code> specifies the individual name of the comment box.</li> </ul> <p><code>prop</code> has the following options:</p> <ul> <li><code>Content</code>: The content of the comment box is returned as a string.</li> <li><code>Position</code>: the X and Y position of the left upper corner of the comment box in the design window are returned as a tuple.</li> </ul>"},{"location":"python-command-reference.html#editing-the-design-further-commands","title":"Editing the Design \u2013 Further Commands","text":""},{"location":"python-command-reference.html#move","title":"Move","text":"Command Syntax Move (<code>item</code>: tuple[str, str]|str, <code>pos</code>: tuple[int, int]) <p>Command for re-positioning a module, a hierarchical box node, a comment box, or a simulation module to a new position within the design window.</p> <ul> <li><code>item</code> can be:</li> <li>A string <code>\"&lt;FullModuleName&gt;\"</code> for identifying a module, a comment box, or a simulation module.</li> <li>A tuple <code>(&lt;FullModuleName&gt;, &lt;HierNodeName&gt;)</code> for moving a hierarchical node, e.g. <code>(\"Process0/Box1\",\"INBOUND#I000\")</code>.</li> <li><code>pos</code> is <code>(x, y)</code>.</li> </ul> <p>Example <pre><code>Move(\"Process0/MyModule\", (100, 200))\n</code></pre></p>"},{"location":"python-command-reference.html#select","title":"Select","text":"Command Syntax Select <code>(</code>item`: str|tuple[str, str]) <p>Command for selecting a module, a simulation module, a comment box, or a link.</p> <ul> <li><code>item</code> can be either:</li> <li>A string <code>\"&lt;FullModuleName&gt;\"</code> to select a module, a simulation module, or a comment box by name.</li> <li>A tuple <code>(&lt;FullModuleName&gt;, &lt;PortName&gt;)</code> to select a link.</li> </ul> <p>Example <pre><code>Select(\"Process0/MyModule\")\nSelect((\"Process0/Branch1\", \"O\"))\n</code></pre></p>"},{"location":"python-command-reference.html#clearselection","title":"ClearSelection","text":"Command Syntax ClearSelection (<code>parent_hierarchy</code>: str) <p>Command for deleting a selection of elements (modules, hierarchical box nodes, links, comment boxes, or simulation modules).</p> <p>Use the optional parameter <code>parent_hierarchy</code> to deselect all elements on the hierarchical level <code>parent_hierarchy</code>.</p> <p>If you don't use <code>parent_hierarchy</code>, element selection is deleted globally, and after carrying out the command, no elements within the design are selected.</p>"},{"location":"python-command-reference.html#copyselected","title":"CopySelected","text":"Command Syntax CopySelected (<code>parent_hierarchy</code>: str) <p>Command for copying the selected elements on the hierarchical level <code>parent_hierarchy</code>. If you don't use the optional parameter <code>parent_hierarchy</code>, the selected elements on the hierarchical level of the currently active design window are copied.</p>"},{"location":"python-command-reference.html#deleteselected","title":"DeleteSelected","text":"Command Syntax DeleteSelected (<code>parent_hierarchy</code>: str) <p>Command for deleting the selected elements on hierarchical level <code>parent_hierarchy</code>. Only the selected modules of the hierarchical level you specify under <code>parent_hierarchy</code> are deleted, the selected modules on other levels remain. If you don't use the optional parameter <code>parent_hierarchy</code>, the selected elements on the hierarchial level of the currently active design window are deleted.</p>"},{"location":"python-command-reference.html#cutselected","title":"CutSelected","text":"Command Syntax CutSelected (<code>parent_hierarchy</code>: str) <p>Command for cutting out the selected elements on hierarchical level <code>parent_hierarchy</code>. If you don't use the optional parameter <code>parent_hierarchy</code>, the selected elements on the hierarchial level of the currently active design window are cut out.</p>"},{"location":"python-command-reference.html#getselected","title":"GetSelected","text":"Command Syntax GetSelected (<code>scope</code>: SelectionScope|str, <code>parent_hierarchy</code>: str) \u2192 list <p>Returns a list of selected elements on the hierarchical level <code>parent_hierarchy</code>. Via <code>scope</code> you define if you want to get a list of selected modules (<code>\"Modules\"</code>), selected links (<code>\"Links\"</code>), selected simulation modules (<code>\"SimModules\"</code>), or selected comment boxes (<code>\"CommentBoxes\"</code>).</p> <p>If you don't use the optional parameter <code>parent_hierarchy</code>, the selected elements on the hierarchial level of the currently active design window are returned.</p> <p>If you use <code>scope = SelectionScope.Modules/SimModules/CommentBoxes</code>, a list of hierarchical element paths is returned.</p> <p>If you use <code>scope = Links</code> you get a list of link-identifying tuples.</p> <p>Example <pre><code>selectedModules = GetSelected(\"Modules\")\nselectedLinks = GetSelected(\"Links\")\n</code></pre></p>"},{"location":"python-command-reference.html#paste","title":"Paste","text":"Command Syntax Paste (<code>parent_hierarchy</code>: str, <code>pos</code>: tuple[int, int] = (0,0)) <p>Command for pasting elements from the clipboard into the hierarchical level <code>parent_hierarchy</code>. (i.e., pasting elements that have been previously copied or cut out).</p> <p>If you don't use the optional parameter <code>parent_hierarchy</code>, the elements are pasted to the hierarchial level of the currently active design window.</p> <p>Use optional position parameter <code>pos</code> for defining the top left position of the inserted content in the design window.</p>"},{"location":"python-command-reference.html#insertmoduleport","title":"InsertModulePort","text":"Command Syntax InsertModulePort (<code>port</code>: tuple[str,str], <code>where</code>: InsertPosition|str) <p>Command for inserting a new module port next to port <code>port</code>.</p> <p>Info</p> <p>You can only insert those ports you can specify a multiplicity for in command <code>CreateModule</code>.</p> <p><code>where</code> offers the following options:</p> <ul> <li><code>before</code> or <code>above</code>: new port is inserted directly before the port specified in the parameter <code>port</code>.</li> <li><code>after</code> or <code>below</code>: new port is inserted directly after the port specified in the parameter <code>port</code> (default).</li> </ul> <p>If you don't use the optional parameter <code>where</code>, the new port is inserted directly after port <code>port</code>.</p>"},{"location":"python-command-reference.html#removemoduleport","title":"RemoveModulePort","text":"Command Syntax RemoveModulePort (<code>port</code>: tuple[str,str]) <p>Command for deleting a module port.</p> <p>Example <pre><code>RemoveModulePort((\"Process0/BRANCH\", \"O001\"))\n</code></pre></p> <p>Info</p> <p>You can only delete those ports that you can specify a multiplicity for in command <code>CreateModule</code>. The minimum number of a given kind of port will always remain. If you try minimize further below the minimum, you will get an according error message. Example: While you can delete the third output port of operator Branch (port name: O002), the two minimum output ports (O001 and O000) can't be deleted: </p>"},{"location":"python-command-reference.html#appendmoduleport","title":"AppendModulePort","text":"Command Syntax AppendModulePort (<code>full_hier_box_name</code>: str, <code>direction</code>: PortDirection | str) <p>Command for adding an input port or an output port to a hierarchical box.</p> <p>The following values for direction are available:</p> <p><code>PortDirection.Input</code> or <code>\"Input\"</code>: an input port is created.</p> <p><code>PortDirection.Ouput</code> or <code>\"Ouput\"</code>: an ouput port is created.</p> <p>Example <pre><code>AppendModulePort(\"Process0/MyHierBox\", \"Input\")\n</code></pre></p>"},{"location":"python-command-reference.html#rename","title":"Rename","text":"Command Syntax Rename (<code>full_module_name</code>: str, <code>new_name</code>: str) <p>Command for renaming a module or simulation box. In <code>new_name</code> you specify the new individual name of the instance without the hierarchical path.</p> <p>Example <pre><code>Rename(\"Process0/module1\", \"DMA\")\n</code></pre></p>"},{"location":"python-command-reference.html#setactivehierarchy","title":"SetActiveHierarchy","text":"Command Syntax SetActiveHierarchy (<code>hierarchy</code>: str) <p>Command for opening and making the specified design hierarchy window active in VisualApplets.</p> <p>Example <pre><code>SetActiveHierarchy(\"Process0/MyBox\")\n</code></pre></p>"},{"location":"python-command-reference.html#getactivehierarchy","title":"GetActiveHierarchy","text":"Command Syntax GetActiveHierarchy ( ) \u2192 str <p>Returns information about the hierarchical level of the design window that is currently open and active in VisualApplets.</p> <p>Example <pre><code>print(GetActiveHierarchy())\n</code></pre></p>"},{"location":"python-command-reference.html#simulating-the-design","title":"Simulating the Design","text":""},{"location":"python-command-reference.html#createsimsource","title":"CreateSimSource","text":"Command Syntax CreateSimSource (<code>full_sim_module_name</code>: str, <code>pos</code>: tuple[int, int] = (0,0)) \u2192 str <p>Command for creating a simulation source module, and for positioning the module in the design window.</p> <p><code>full_sim_module_name</code> has the following syntax: <code>&lt;HierLevelPath&gt;/&lt;SimModuleName&gt;</code></p> <ul> <li><code>&lt;HierLevelPath&gt;</code> defines the path to a specific hierarchical level in the design.</li> <li><code>&lt;SimModuleName&gt;</code> specifies the individual name you want the simulation source module to have. Alternatively, you can leave <code>&lt;SimModuleName&gt;</code> empty. In this case, you need to terminate <code>full_sim_module_name</code> with a slash; the module will be named automatically.</li> </ul> <p>The return value of function <code>CreateSimSource</code> is the <code>full_module_name</code> of the new simulation source module (full hierarchical path to the simulation source module including the module name).</p> <p>Example <pre><code>srcName = CreateSimSource(\"Process0/MySimSource\", (200,200))\n</code></pre></p>"},{"location":"python-command-reference.html#createsimprobe","title":"CreateSimProbe","text":"Command Syntax CreateSimProbe (<code>full_sim_module_name</code>: str, <code>pos</code>: tuple[int, int] = (0,0)) \u2192 str <p>Command for creating a simulation probe module, and for positioning the module in the design window.</p> <p><code>full_sim_module_name</code> has the following syntax: <code>&lt;HierLevelPath&gt;/&lt;SimModuleName&gt;</code></p> <ul> <li><code>&lt;HierLevelPath&gt;</code> you use to define the path to a specific hierarchical level in the design.</li> <li><code>&lt;SimModuleName&gt;</code> you use for specifying the name you want the simulation probe module to have. Alternatively, you can leave <code>&lt;SimModuleName&gt;</code> empty. In this case, you need to terminate <code>full_sim_module_name</code> with a slash; the module will be named automatically.</li> </ul> <p>The return value of function <code>CreateSimProbe</code> is the <code>full_module_name</code> of the new simulation probe module (full hierarchical path to the simulation probe module including the module name).</p>"},{"location":"python-command-reference.html#deletesimmodule","title":"DeleteSimModule","text":"Command Syntax DeleteSimModule (<code>full_sim_module_name</code>: str) <p>Command for deleting a simulation module (simulation source or simulation probe).</p>"},{"location":"python-command-reference.html#connectsimmodule","title":"ConnectSimModule","text":"Command Syntax ConnectSimModule (<code>full_sim_module_name</code>: str, <code>link</code>: tuple[str,str], <code>pos</code>: tuple[int,int] = (0,0)) <p>Command for connecting a simulation module to an existing link.</p> <p>Example <pre><code>ConnectSimModule(\"Process0/MySimProbe\", (\"Process0/Branch1\",\"O\"))\n</code></pre></p>"},{"location":"python-command-reference.html#disconnectsimmodule","title":"DisconnectSimModule","text":"Command Syntax DisconnectSimModule (<code>full_sim_module_name</code>: str) <p>Command for detaching the simulation module from a link.</p>"},{"location":"python-command-reference.html#setsimmoduleproperty","title":"SetSimModuleProperty","text":"Command Syntax SetSimModuleProperty (<code>full_sim_module_name</code>: str, <code>prop</code>: SimProperty|str, <code>value</code>: bool|int|dict[str,int]) <p>Command for defining the properties of a simulation module.</p> <ul> <li>Common props (with integer as <code>value</code>):</li> <li><code>\"PixelAlignmentOffset\"</code>, <code>\"ImageFileSubPixels\"</code>, <code>\"ImageFilePixelBits\"</code>, <code>\"CurrentImage\"</code></li> <li>Common props (with Boolean as <code>value</code>):</li> <li><code>\"ImageFileNormalize\"</code> can be set to <code>True</code>or <code>False</code></li> <li>Common props (with dict as <code>value</code>):</li> <li><code>\"CropRect\"</code>: pass a dict with keys: <code>{\"index\", \"x\", \"y\", \"width\", \"height\"}</code> for specifying the ROI in a source's image.</li> </ul> <p>Use <code>prop</code> to identify the property you want to set. Set the individual properties in the format stated below. Available are the following properties and according value formats:</p> <pre><code>pixelAlignmentOffset BITS\n</code></pre> <p>Use this parameter to specify the alignment offset as integer value <code>BITS</code>.</p> <pre><code>imageFileSubPixels NUMBER\n</code></pre> <p>Use this parameter to specify the number of file pixels that are assigned to a link pixel as integer value <code>NUMBER</code>.</p> <p>Source: <code>NUMBER</code> pixels are conflated to one pixel.</p> <p>Probe: One pixel is split up into <code>NUMBER</code> pixels in the file.</p> <pre><code>imageFilePixelBits bits\n</code></pre> <p>Use this parameter to specify the bit width in the image file as integer value <code>bits</code>. Allowed are the values 1, 8, and 16.</p> <pre><code>imageFileNormalize choice\n</code></pre> <p>Use this property to configure the way simulation result images are saved.</p> <p>If you want to save a 1-bit simulation result in an 8-bit file format, set <code>imageFileNormalize</code> to 1. \"Normalizing\" in this context means mapping 0 to 0 (black) and 1 to 255 (white).</p> <p>The following values for <code>choice</code> are possible: <code>choice = \"1\" | \"0\"</code></p> <pre><code>cropRect [imageNr] x y width height\n</code></pre> <p>This property is only available for simulation sources. Specifying the image index <code>[imageNr]</code> is mandatory. Use this parameter to crop an image and to specify the region of the image (ROI) you want to use for simulation. With <code>x</code> and <code>y</code> you define the left upper corner of the ROI.</p> <pre><code>currentImage index\n</code></pre> <p>Use this parameter to select an image within the simulation module. Specify <code>index</code> as integer value.</p> <p>Examples <pre><code>SetSimModuleProperty(\"Process0/SimSource1\", \"ImageFileNormalize\", True)\nSetSimModuleProperty(\"Process0/SimSource1\", \"CropRect\",\n                     {\"index\": 0, \"x\":10, \"y\":20, \"width\":100, \"height\":100})\n</code></pre></p>"},{"location":"python-command-reference.html#addimage","title":"AddImage","text":"Command Syntax AddImage (<code>full_sim_module_name</code>: str, <code>image_file_name</code>: str|list[str], <code>image_lib</code>: ImageLibrary|str) <p>Command for adding an image to a simulation source module. If the number of kernel elements of the link the simulation source is connected to is &gt; 1, you must specify as many images as the kernel has elements.</p> <p>Optionally, you can state the image library you want to use ( <code>image_lib</code> = \"Native\" | \"ImageMagick\").</p> <p>Example <pre><code>AddImage(\"Process0/MySimSource\", \"c:/VA_Python/testimage.tif\")\n</code></pre></p>"},{"location":"python-command-reference.html#removeimage","title":"RemoveImage","text":"Command Syntax RemoveImage (<code>full_sim_module_name</code>: str, <code>image_index</code>: int = -1) <p>Command for deleting one or all images from a simulation source module. Use the optional parameter <code>image_index</code> to specify the image you want to delete. If you set <code>image_index</code> to -1, or if you don't use <code>image_index</code> at all, all images in the simulation module are deleted.</p>"},{"location":"python-command-reference.html#simulate","title":"Simulate","text":"Command Syntax Simulate (<code>processing_cycles</code>: int, <code>save_log_file_name</code>: str) <p>Command for simulating a design. Use the <code>processing_cycles</code> parameter for defining how many processing cycles you want to carry out with the command.</p> <p>Use the optional parameter <code>save_log_file_name</code> to save the log of the carried-out cycles to file. Specify in <code>save_log_file_name</code> the path to the file and the file name itself. Use file name extension *.html, as the log is written in HTML format. Use forward slashes for indicating pathes.</p> <p>Example <pre><code>Simulate(1, \"c:/temp/simlog.html\")\n</code></pre></p>"},{"location":"python-command-reference.html#resetsimulation","title":"ResetSimulation","text":"Command Syntax ResetSimulation ( ) <p>Command for resetting the simulation engine. As an effect, all simulation probes in the design are cleared.</p>"},{"location":"python-command-reference.html#getsimmoduleproperty","title":"GetSimModuleProperty","text":"Command Syntax GetSimModuleProperty (<code>full_sim_module_name</code>: str, <code>prop</code>: SimModuleProperty|str , <code>image_index</code>: int = -1) \u2192 varies <p>Command for retrieving the properties of a simulation module. The return type depends on the queried property. The following properties are available:</p> <ul> <li><code>IsConnected</code> \u2192 bool: Returns <code>True</code>, if simulation module is connected to a link; otherwise returns <code>False</code>.</li> <li><code>ConnectedLink</code> \u2192 <code>(FullModuleName, PortName)</code>: Returns a tuple identifying the link to which the simulation module is connected to. The return value always describes the link by a real module port, i.e., it never states an inner H box node (like, for example, <code>INBOUND#I000</code> or <code>OUTBOUND#O000</code>).</li> <li><code>IsSource</code> \u2192 bool: Returns <code>True</code>, if the simulation module is a <code>SimulationSource</code>; otherwise returns <code>False</code>.</li> <li><code>IsProbe</code> \u2192 bool: Returns <code>True</code>, if the simulation module is a <code>SimulationProbe</code>; otherwise returns <code>False</code>.</li> <li><code>Position</code> \u2192 <code>(x,y)</code>: Returns position of the simulation module in the program window as a tuple.</li> <li><code>ImageCount</code> \u2192 int: Returns the number of images in the simulation module.</li> <li><code>PixelAligmentOffset</code> \u2192 int: Returns the alignment offset as integer value.</li> <li><code>ImageFileSubPixels</code> \u2192 bool: Returns the number of file pixels that are assigned to a link pixel as integer value.</li> <li><code>ImageFilePixelBits</code> \u2192 int: Returns the setting for bit width in the image file as integer value. Possible are the values 1, 8, and 16.</li> <li><code>ImageFileNormalize</code> \u2192 bool: Returns <code>True</code> or <code>False</code> according to the settings for saving simulation result images. If set to 1, during saving a 1-bit simulation result to a file in 8-bit * <code>format</code>: 0 is mapped to 0 (black) and 1 is mapped to 255 (white), i.e., the simulation image's format is \"normalized\".</li> <li><code>CropRect</code> \u2192 dict with <code>{\"x\",\"y\",\"width\",\"height\"}</code>: This property is only available for simulation sources. Using parameter <code>image_index</code> is mandatory. Returns the crop rectangle as a dictionary with the keys <code>Index</code>, <code>X</code>, <code>Y</code>, <code>Width</code>, and <code>Height</code>.</li> <li><code>CurrentImage</code> \u2192 int: Returns the currently selected image as integer value.</li> </ul>"},{"location":"python-command-reference.html#setsimimagedata","title":"SetSimImageData","text":"Command Syntax SetSimImageData (<code>full_sim_module_name</code>: str, <code>image_index</code>: int, <code>x</code>: int, <code>y</code>: int, <code>kernel_row</code>: int = 0, <code>kernel_col</code>: int = 0, <code>component</code>: int = 0, <code>width</code>: int 0 1, <code>data</code>: list[str]) <p>Command for overwriting one pixel or several neighboring pixels in an image within a simulation module (source or probe) in memory. This command is useful for test modifications before running the simulation or saving the simulation.</p> <p>You can use this command:</p> <ul> <li>in SimSources for altering an image for simulation.</li> <li> <p>in SimProbes for visualizing the results within an image.</p> </li> <li> <p><code>image_index</code>: Which image to alter, 0-based.</p> </li> <li><code>x</code>, <code>y</code>: The top-left pixel coordinate to write to.</li> <li><code>kernel_row</code>, <code>kernel_col</code>: If the image has a kernel, identify which kernel element you're modifying.</li> <li><code>component</code>: For color images, which color channel to set.</li> <li><code>width</code>: How many consecutive pixels in a row to set. Additional data in <code>data</code> can spill onto subsequent rows.</li> <li><code>data</code>: A list of pixel values in hex string form, e.g. <code>[\"0A\",\"0B\",\"FF\"]</code>.</li> </ul> <p>Example <pre><code>SetSimImageData(\"Process0/SimSource1\", 0, 10, 10, component=0, width=3,\n                data=[\"12\",\"13\",\"14\"])\n</code></pre></p> <p>The alteration of the image is volatile. As soon as you select another image of the same simulation module or re-select the altered image, the altered image is loaded anew from hard disk and your alterations are discarded. You select another image if you enter a command for a new image <code>image_index</code> (of the same simulation module) in the Python console, or if you click another image of the same simulation module in the viewer of the VisualApplets GUI.</p> <p>However, you can make your alteration permanent by saving the altered image  under a new file name as long as it's active.</p> <p>You can use a volatilely altered image for simulation. However, only one image per SimSource module can be used for simulation in altered condition, because altering another image in the same SimSource resets the pixel values of the image you altered before. You can use as many volatilely altered images as you want for simulation as long as you have only one volatilely altered image per simulation module.</p> <p>One value per pixel: Command <code>SetSimImageData</code> allows you to write exactly one value per pixel. Thus, in gray scale pixels, you must carry out the <code>SetSimImageData</code> command only once to write the complete color information per pixel. In color pixels, you will be able to write only one of the three color components per pixel. Thus, if you want to change all three color components of color pixel(s), you have to carry out the <code>SetSimImageData</code> command three times.</p> <p>Writing in images with kernels: When you are writing into images that have a kernel, you must specify which kernel element of the respective pixel(s) you want to overwrite when using command <code>SetSimImageData</code> in addition to the exact position of the (first) pixel you want to overwrite. If you want to overwrite all kernel elements, you must carry out the <code>SetSimImageData</code> command exactly <code>kernel_row * kernel_col</code> times.</p> <p>To use the command:</p> <p>Before using the command, close the image viewer of the simulation module the image you want to change is located in.</p> <p>Specify the image you want to alter with index <code>image_index</code>. Attention: <code>image_index</code> starts with 0, whereas the numbering of the images in a simulation module in the VisualApplets GUI starts with 1. The values map as follows:</p> <p><code>image_index = 0</code> referes to image 1 in the viewer of the VisualApplets GUI.</p> <p><code>image_index = 1</code> referes to image 2 in the viewer of the VisualApplets GUI.</p> <p><code>image_index = 2</code> referes to image 3</p> <p>and so forth.</p> <p>Info</p> <p>On the GUI of VisualApplets, the index of the image that is used in the next simulation cycle is displayed in square brackets and marked by a preceeding \"sim\u201d (e.g., sim[2]).</p> <p>Use <code>kernel_row</code> and <code>kernel_col</code> to specify the kernel element you are going to change a pixel value for.</p> <p>You can see in the link properties of the link the simulation module is connected to which size the kernel of your simulation image has. A link that has a kernel size bigger than 1 pixel is always preceeded by an instance of an operator that allows specifying kernels (as, for example, operator <code>FIRkernelNxM</code>).</p> <p>Counting kernel columns and kernel rows starts with 0. Thus, if you have a kernel with only one element, set both values (<code>kernel_row</code> and <code>kernel_col</code>) to 0:</p> <p></p> <p>For a kernel with 4 elements, you identify an individual kernel element as follows:</p> <p></p> <p>For a kernel with 9 elements, you identify an individual kernel element as follows:</p> <p></p> <p>Use the <code>component</code> parameter to specify the color component of the pixel you want to set. In gray scale images, set <code>component</code> to 0. In multi-component images (color), specify the component you want to write via its position in the color model. Example: Set <code>component</code> to 0 if you want to address the red component in an RGB image, set <code>component</code> to 1 if you want to address the green component in an RGB image, or set <code>component</code> to 2 if you want to address the blue component in an RGB image.</p> <p>Set position (<code>x</code>,<code>y</code>) to define the starting point (first pixel) for your writing within the image.</p> <p>Use <code>width</code> to specify the number of neighboring pixels you want to overwrite per row. If you specify more <code>values</code> than you write pixels in a row (<code>width</code>), writing continues in the next row on position <code>x</code>. This way, you can write a region of interest (ROI) that has the width <code>width</code>.</p> <p>Specify the individual pixel values <code>data</code> in hexadecimal writing without preceding \"0x\u201d. Specify negative values in two's complement notation. How many values you state in <code>data</code> decides how many pixels within the image are altered.</p>"},{"location":"python-command-reference.html#getsimimagedata","title":"GetSimImageData","text":"Command Syntax GetSimImageData (<code>full_sim_module_name</code>: str, <code>image_index</code>: int, <code>x</code>: int, <code>y</code>: int, <code>kernel_row</code>: int = 0, <code>kernel_col</code>: int = 0, <code>component</code>: int = 0, <code>width</code>: int = 1, <code>height</code>: int = 1]) <p>Command for reading values of one or several neighboring pixels in an image within a simulation module (source or probe). Returns a list of hex strings.</p> <p>One value per pixel: Command <code>GetSimImageData</code> returns exactly one value per pixel. Thus, in gray scale pixels, you must carry out the <code>GetSimImageData</code> command only once to retreive the complete color information per pixel. In color pixels, you will be able to retrieve only one of the three color components per pixel. Thus, if you want to read all three color components of color pixel(s), you have to carry out the <code>GetSimImageData</code> command three times.</p> <p>Reading in images with kernels: When you are reading from images that have a kernel, you must specify which kernel element of the respective pixel(s) you want to read when using command <code>GetSimImageData</code> in addition to the exact position of the (first) pixel you want to read. If you want to read all kernel elements, you must carry out the <code>GetSimImageData</code>command exactly <code>kernel_row * kernel_col</code> times.</p> <p>To use the command:</p> <p>Specify the image with index <code>image_index</code>.</p> <p>Attention: <code>image_index</code> starts with 0, whereas the numbering of the images in a simulation module in the VisualApplets GUI starts with 1. The values map as follows:</p> <p><code>image_index = 0</code> referes to image 1 in the viewer of the VisualApplets GUI.</p> <p><code>image_index = 1</code> referes to image 2 in the viewer of the VisualApplets GUI.</p> <p><code>image_index = 2</code> referes to image 3 in the viewer of the VisualApplets GUI,</p> <p>and so forth.</p> <p>Info</p> <p>On the GUI of VisualApplets, the index of the image that is used in the next simulation cycle is displayed in square brackets and marked by a preceeding \"sim\u201d (e.g., sim[2]).</p> <p>Use <code>kernel_row</code> and <code>kernel_col</code> to specify the kernel element you want to read from.</p> <p>Which size the kernel of your simulation image has you can see in the link properties of the link the simulation module is connected to. A link that has a kernel size bigger than 1 element is always preceeded by an instance of an operator that allows specifying kernels (as, for example, operator <code>FIRkernelNxM</code>).</p> <p>Counting the columns and rows of a kernel starts with 0. Thus, if you have a kernel with only one element, set both values to 0.</p> <p></p> <p>For a kernel with 4 elements, you identify an individual kernel element as follows:</p> <p></p> <p>For a kernel with 9 elements, you identify an individual kernel element as follows:</p> <p></p> <p>Use parameter <code>component</code> to specify the color component you want to read of the pixel. In gray scale images, set <code>component</code> to 0. In multi-component images (color), specify the component you want to read via its position in the color model. Example: Set <code>component</code> to 0 if you want to read the red component in an RGB image, set <code>component</code> to 1 if you want to read the green component in an RGB image, or set <code>component</code> to 2 if you want to read the blue component in an RGB image.</p> <p>Set position (<code>x</code>,<code>y</code>) to define the starting point (first pixel) of your reading within the image.</p> <p>If you don't use parameter <code>Width</code>, the value for exactly one pixel is returned. If you specify only <code>width</code>, <code>width</code> values in line <code>y</code> are returned. If you specify <code>width</code> and <code>height</code>, <code>width * height</code> values are returned. Using <code>width</code> and <code>height</code> allows you to define a region of interest (ROI) you want to read the pixel values (gray)/the values of a pixel component (color) for.</p> <p>The individual pixel values are returned in hexadecimal writing without preceding \"0x\u201d. Negative values are returned in two's complement notation.</p> <p>Example <pre><code>vals = GetSimImageData(\"Process0/SimProbe1\", 0, 100, 200, width=4, height=2)\n# E.g., [\"00\",\"00\",\"01\",\"02\",\"03\",\"FF\",\"7A\",\"7B\"]\n</code></pre></p>"},{"location":"python-command-reference.html#createsimimage","title":"CreateSimImage","text":"Command Syntax CreateSimImage (<code>full_sim_module_name</code>: str, <code>shape</code>: tuple[int,int] = (-1,-1)) <p>Command for creating / allocating a new image in a simulation module (typically a source) with the specified <code>height</code> and <code>width</code>.</p> <p>If either dimension is <code>-1</code>, the link's maximum dimension is used.</p> <p>The parameter <code>shape</code> defines the image shape like known for numpy arrays. The first tuple entry is <code>height</code> and the second is <code>width</code>. If <code>shape</code> has three entries, the third one is ignored (the number of components is determined by the link format).</p> <p>Example <pre><code>CreateSimImage(\"Process0/MySimSource\", (768, 1024))\n</code></pre></p>"},{"location":"python-command-reference.html#getsimimageproperty","title":"GetSimImageProperty","text":"Command Syntax GetSimImageProperty (<code>full_sim_module_name</code>: str, <code>image_index</code>: int, <code>prop</code>: SimImageProperty|str, <code>line_index</code>: int = -1, <code>line_count</code>: int = 1) \u2192 varies <p>Command for retrieving the properties of a simulation image (in a source or a probe module).</p> <ul> <li><code>prop</code> can be:</li> <li><code>\"LineWidth\"</code>: Returns a list of line widths (if lineCount &gt; 1).</li> <li><code>\"ImageSize\"</code>: Returns a dict <code>{\"Width\": &lt;width&gt;, \"Height\": &lt;height&gt;}</code> where <code>&lt;width&gt;</code> and <code>&lt;height&gt;</code> are integers for the image width and height.</li> </ul>"},{"location":"python-command-reference.html#createimagememory","title":"CreateImageMemory","text":"Command Syntax CreateImageMemory (<code>format_dict</code>: dict[LinkParam|str, int|&lt;enum&gt;|str] = None ) \u2192 SharedImageMemory <p>Command for creating a VisualApples image memory which may be accessed via an object of the type <code>SharedImageMemory</code>.</p> <ul> <li> <p><code>format_dict</code>: Specifies the memory format with a dictionary equivalent to specifying link formats (using keys such as  <code>LinkParam.MaxImageWidth</code>, <code>LinkParam.MaxImageHeight</code>, <code>LinkParam.ColorFormat</code>, etc.). If omitted, the following defaults are used:</p> <ul> <li><code>LinkParam.MaxImageHeight</code>: <code>1024</code></li> <li><code>LinkParam.MaxImageWidth</code>: <code>1024</code></li> <li><code>LinkParam.ColorFormat</code>: <code>VAF_GRAY</code></li> <li><code>LinkParam.BitWidth</code>: <code>8</code></li> </ul> </li> </ul> <p>The parameter <code>format_dict</code> is optional. If you want to set the image memory by calling <code>CopySimImageData</code>, don't provide any format. The format is then overridden by the simulation module.</p> <p>Memory is allocated at the first time when one of the following actions is performed:</p> <ul> <li>Call of <code>CopySimImageData()</code> for copying data from a simulation element</li> <li>Call of method <code>data()</code> for getting the Python buffer object from <code>SharedImageMemory</code>.</li> </ul> <p>This function returns a <code>SharedImageMemory</code> object that can be used with <code>CopySimImageData</code>.</p> <p>The returned <code>SharedImageMemory</code> object provides the following class methods:</p> <ul> <li><code>data()</code>: Gets a <code>memoryview</code> object, which provides memory access via the Python buffer protocol without copying.</li> <li><code>shape()</code>: Returns the shape (dimensions) of the image either as (<code>Height</code>, <code>Width</code>) for grayscale formats or (<code>Height</code>, <code>Width</code>, <code>Components</code>) for color images.</li> <li><code>datatype()</code>: Returns a string representation of a numpy data type corresponding to the buffer data. This string can be used as argument of the <code>numpy.dtype()</code> function for getting the numpy data type.</li> <li><code>casttype()</code>: Returns the PEP 3118 buffer cast type of the image data. This string can be used for <code>memoryview.cast()</code>.</li> </ul> <p>Example <pre><code>sharedMem = CreateImageMemory({\"Max. Image Width\": 100, \"Max. Image Height\": 100})\nresultMem = CreateImageMemory({LinkParam.MaxImageWidth: 2, LinkParam.MaxImageHeight: 1, LinkParam.BitWidth: 16})\n\n# Access the buffer sharedMem via numpy\nimport numpy as np\n\narr = np.frombuffer(sharedMem.data(0,0), dtype=np.dtype(sharedMem.datatype()))\narr = arr.reshape(sharedMem.shape())\narr[:] = 0 # initialize buffer with zeros\n\n# Access the buffer resultMem via buffer protocol\nresultData = resultMem.data(0,0).cast(resultMem.casttype())\nresultData[0] = 0x1234\nresultData[1] = 0x5678\n</code></pre></p>"},{"location":"python-command-reference.html#copysimimagedata","title":"CopySimImageData","text":"Command Syntax CopySimImageData (<code>full_sim_module_name</code>: str, <code>image_index</code>: int, <code>image_memory</code>: SharedImageMemory, <code>copy_to_sim_module</code>: bool = False) <p>Command for copying data to or from a simulation module to or from a <code>SharedImageMemory</code> buffer. By default, data is copied from the simulation module to the image memory.</p> <ul> <li>If <code>copy_to_sim_module=False</code> (the default), data flows from the sim module into the <code>image_memory</code>.</li> <li>If <code>copy_to_sim_module=True</code>, data in <code>image_memory</code> is written into the sim module's image.</li> </ul> <p>Example <pre><code>buf = CreateImageMemory()\nCopySimImageData(\"Process0/SimProbe1\", 0, buf)  # read data from probe\n# ... do something in Python ...\nCopySimImageData(\"Process0/SimProbe1\", 0, buf, True)  # write it back\n</code></pre></p>"},{"location":"python-command-reference.html#saveimage","title":"SaveImage","text":"Command Syntax SaveImage (<code>full_sim_module_name</code>: str, <code>image_index</code>: int, <code>image_base_name</code>: str) <p>Command for saving one or all result images from a simulation probe.</p> <p>Use the mandatory parameter <code>image_index</code> to save a specific image out of the result images. If you want to save all images of the probe, set <code>image_index</code> to <code>-1</code>.</p> <p>Use <code>image_base_name</code> to specify the path to the directory in your file system where you want to save the image(s), and for specifying the file name of the image file(s). Make sure the directories you specify already exist in your file system. Otherwise, you can create them using command <code>MakeDirectoryPath</code>.</p> <p>Example: \"C:/images/testimage\". In the saving process, the file name extension (for example, *.tif) will be added automatically to the name.</p> <p>If you save all images of the probe, an image index will be automatically added to the file name.</p> <p>Example 1:</p> <p>Enter</p> <pre><code>SaveImage(\"Process0/mySimProbe\", -1, \"C:/images/testimage\")\n</code></pre> <p>to get the following files:</p> <p>C:/images/testimage_0001.tif</p> <p>C:/images/testimage_0002.tif</p> <p>C:/images/testimage_0003.tif</p> <p>\u2026</p> <p>Example 2:</p> <p>Enter</p> <pre><code>SaveImage(\"Process0/mySimProbe\", 4, \"C:/images/testimage\")\n</code></pre> <p>to get the following file:</p> <p>C:/images/testimage.tif</p>"},{"location":"python-command-reference.html#building-the-design","title":"Building the Design","text":""},{"location":"python-command-reference.html#drc","title":"Drc","text":"Command Syntax Drc (<code>save_log_file_name</code>: str = \" \") <p>Command for starting the first level of the Design Rule Check (DRC 1).</p> <p>To get a log output, you can optionally specify the path to and the name of an html log file (*.html) in the <code>save_log_file_name</code> parameter.</p>"},{"location":"python-command-reference.html#drc2","title":"Drc2","text":"Command Syntax Drc2 (<code>save_log_file_name</code>: str = \" \") <p>Command for starting the second level of the Design Rule Check (DRC 2).</p> <p>To get a log output, you can optionally specify the path to and the name of an html log file (*.html) in the <code>save_log_file_name</code> parameter.</p>"},{"location":"python-command-reference.html#selectbuildconfiguration","title":"SelectBuildConfiguration","text":"Command Syntax SelectBuildConfiguration (<code>config_name</code>: str) <p>Command for selecting a saved build configuration as active build configuration.</p> <p>Specify the name of the desired build configuration in parameter <code>config_name</code>.</p> <p>To get an overview over all available build configurations, enter <code>SelectBuildConfiguration(\"?\")</code> - a list of the names of all available build configurations is returned. The currently selected build configuration is displayed in the first entry of the list.</p> <p>Example:</p> <p></p> <p>The command returns the name of the currently selected build configuration. Via this return value you can check if your re-setting the build configuration was successful.</p> <p>Example:</p> <p></p>"},{"location":"python-command-reference.html#build","title":"Build","text":"Command Syntax Build (<code>save_log_file_name</code>: str = \" \", <code>max_time</code>: float | int = 24.0) <p>Command for starting the build flow.</p> <p>To get a log output, you can optionally specify the path to and the name of an html log file (*.html) in parameter <code>save_log_file_name</code>.</p> <p>To set a time limit for the build process, you can optionally specify the maximum build time in parameter <code>max_time</code> (in hours). Parameter <code>max_time</code> is of type floating point. This way, you can specify fractions of an hour. The default setting for <code>max_time</code> is 24 hours.</p> <p>Example for a command creating log file <code>build_log.html</code> and specifying the maximum Build time as \u00bd hour:</p> <p>Example <pre><code>Build(\"build_log.html\", 0.5)  # stop after 30 minutes\n</code></pre></p>"},{"location":"python-command-reference.html#handling-files-paths-program-instances-and-messages","title":"Handling Files, Paths, Program Instances and Messages","text":""},{"location":"python-command-reference.html#source","title":"Source","text":"Command Syntax Source (<code>file_path</code>: str, <code>encoding:</code> str = utf-8) <p>Command for executing another Python script file in the current environment. Use forward slashes for specifying the path. The command automatically replaces the following place holders (like command <code>MakeDirectoryPath</code>):</p> <p><code>%UserDir%</code>: User data directory for the current user (for example, c:/Users/Smith)</p> <p><code>%AppDataDir%</code>: Directory for application data of VisualApplets</p> <p><code>%VaInstallDir%</code>: Installation directory of VisualApplets</p> <p><code>%UserLibDir%</code>: Directory for user libraries.</p> <p><code>%CustomLibDir%</code>: Directory for custom libraries.</p> <p><code>%VaVersion%</code>: VisualApplets program version, for example, \"3.1\"</p> <p><code>%CurrDateTime%</code>: Current date and time according to ISO 8601 (basic format), for example \"20170530T134522\u201d</p> <p><code>%DateTime%</code>: Date and time at start of VisualApplets according to ISO 8601 (basic format), for example \"20170530T134350\u201d</p> <p><code>%CurrDesignDir%</code>: Directory in which the currently loaded design is stored.</p>"},{"location":"python-command-reference.html#makedirectorypath","title":"MakeDirectoryPath","text":"Command Syntax MakeDirectoryPath (<code>full_path</code>: str) \u2192 str <p>Command for creating pathes (and their directories) of any desired depth.</p> <p>The command automatically replaces the following place holders:</p> <p><code>%UserDir%</code>: User data directory for the current user (for example, c:/Users/Smith)</p> <p><code>%AppDataDir%</code>: Directory for application data of VisualApplets</p> <p><code>%VaInstallDir%</code>: Installation directory of VisualApplets</p> <p><code>%UserLibDir%</code>: Directory for user libraries.</p> <p><code>%CustomLibDir%</code>: Directory for custom libraries.</p> <p><code>%VaVersion%</code>: VisualApplets program version, for example, \"3.1\"</p> <p><code>%CurrDateTime%</code>: Current date and time according to ISO 8601 (basic format), for example \"20170530T134522\u201d</p> <p><code>%DateTime%</code>: Date and time at start of VisualApplets according to ISO 8601 (basic format), for example \"20170530T134350\u201d</p> <p><code>%CurrDesignDir%</code>: Directory in which the currently loaded design is stored.</p> <p>If the command has been carried out successfully, the absolute path is returned.</p> <p>Example <pre><code>absPath = MakeDirectoryPath(\"c:/temp/myFolder/sub\")\n</code></pre></p>"},{"location":"python-command-reference.html#getabsolutepath","title":"GetAbsolutePath","text":"Command Syntax GetAbsolutePath (<code>path</code>: str) \u2192 str <p>Returns the absolute path of the path you specify in parameter <code>path</code>.</p> <p>The command automatically replaces the same alias names (place holders) as command <code>MakeDirectoryPath</code>.</p> <p>You are allowed to refer in <code>path</code> to a directory or a file that doesn't exist, so that the resulting path name refers to a directory or a file that doesn't exist.</p>"},{"location":"python-command-reference.html#wait","title":"Wait","text":"Command Syntax Wait (<code>time_in_milli_sec</code>: int) <p>Command for waiting the specified time <code>time_in_milli_sec</code>. The VisualApplets GUI stays active during waiting time.</p> <p>If you set <code>time_in_milli_sec</code> to 0, at least one event loop update of the GUI is carried out by VisualApplets. You can use this to make sure that the GUI displays the results from earlier commands.</p>"},{"location":"python-command-reference.html#message","title":"Message","text":"Command Syntax Message (<code>msg_type</code>: MessageType|str, <code>code</code>: int, <code>text</code>: str) <p>Command for emitting</p> <ul> <li>an error message (<code>msg_type=MessageType.Error</code> or <code>msg_type=\"Error\"</code>),</li> <li>a warning (<code>msg_type=MessageType.Warning</code> or <code>msg_type=\"Warning\"</code>), or</li> <li>an informative message (<code>msg_type=MessageType.Info</code> or <code>msg_type=\"Info\"</code>)</li> </ul> <p>In <code>code</code>, you can define the message code for your message. <code>code</code> has the value range from -999 to +999. To avoid conflicts with the current and/or future versions of VisualAppets, use only values in this range.</p> <p>Use <code>text</code> to enter the message. The message is completed automatically by a dot.</p> <p>Example <pre><code>Message(\"Info\", 100, \"Starting build steps...\")\n</code></pre></p>"},{"location":"python-command-reference.html#flushconsole","title":"FlushConsole","text":"Command Syntax FlushConsole ( ) <p>Transfers the accrued output from Python's <code>stdout</code>/<code>stderr</code> immediately into the VisualApplets console.</p>"},{"location":"python-command-reference.html#exit","title":"Exit","text":"Command Syntax Exit (<code>discard</code>: bool = False) <p>Command for terminating the current VisualApplets session. You can use <code>Exit</code> even if you still have a design open. However, don't forget to save your changes before.</p> <p>If you still have a desing open and the design contains unsaved changes:</p> <ul> <li>If you set the optional parameter <code>discard</code> to <code>True</code>, the open design will be closed even if it containes changes that you didn't save yet. The unsaved changes will be discarded.</li> <li>If you set the optional parameter <code>discard</code> to <code>False</code> and unsaved changes exist, the command will fail.</li> <li>If you use <code>Exit</code> without using the <code>discard</code> parameter although the open design containes unsaved changes, the command will be terminated and you receive an according error message.</li> </ul>"},{"location":"python-script-examples.html","title":"Python Script Examples","text":"<p>You have a set of Python script examples available in your VisualApplets installation.</p> <p>You find them in the following directory: &lt;YourVisualAppletsInstallationDirectory&gt;/Examples/AdvancedVAFunctions/Python Scripting</p> <p>The examples contain extensive notes describing the individual parts of the script.</p> <p></p>"},{"location":"python-script-frequently-used-parameters-syntax.html","title":"Python Script: Frequently Used Parameters - Syntax","text":""},{"location":"python-script-frequently-used-parameters-syntax.html#full_module_name","title":"full_module_name","text":"<p>Scope: Use <code>full_module_name</code> to address specific operator instances (= modules) in a design.</p> <p>Syntax: <code>&lt;HierLevelPath&gt;/&lt;ModuleName&gt;</code></p> <ul> <li><code>HierLevelPath</code> you use to define the path to a specific hierarchical level in the design. Use forward slashes.</li> <li><code>ModuleName</code> you use for specifying the name of the module. The name of the module is the individual name you give to a module, not the name of the operator the module is instantiated from.</li> </ul> <p>Example: <code>Process1/cam</code></p> <p>If you address modules within a hierarchical box, don't forget to state the name of the process the hierarchical box is located in.</p> <p>Example: <code>Process0/BoxName1/module6</code></p>"},{"location":"python-script-frequently-used-parameters-syntax.html#parameter_name","title":"parameter_name","text":"<p>In <code>parameter_name</code>, specify the name of the parameter as it's displayed in the VisualApplets GUI.</p>"},{"location":"python-script-frequently-used-parameters-syntax.html#port","title":"port","text":"<p>Scope: Use <code>port</code> to identify an individual port you want to address on a module. You retrieve information about the <code>port</code> via mouseover in the VisualApplets GUI:</p> <p></p> <p>Ports here are <code>I</code>, <code>PI</code>, <code>Tick</code>, <code>Reset</code>, and <code>O</code>.</p> <p>Whenever a function expects a position in the design window, a Python tuple <code>(x, y)</code> is used.</p> <p>Port names of inner hierarchical box nodes: Inner hierarchical box nodes (inner nodes for connecting <code>BoxName</code> ports) are identified via the prefixes <code>INBOUND#</code> or <code>OUTBOUND#</code>.</p> <p>Example:</p> <p>The two inbound nodes of the hierarchical box in the figure below need to be addressed by <code>INBOUND#I000</code> and <code>INBOUND#I001</code>.</p> <p></p>"},{"location":"python-script-frequently-used-parameters-syntax.html#mult","title":"mult","text":"<p>Scope: Use <code>mult</code> to specify a multiport you want to address on a module. You retrieve information about the base name of a port instance in the VisualApplets GUI:</p> <ul> <li><code>mult</code> specifies what is displayed in the VisualApplets GUI when instantiating an operator that has a varying number of ports. <code>mult</code> is the short name of the multiport name and is displayed in parantheses in the GUI:</li> </ul> <p></p> <p><code>mult</code> here is <code>I</code>.</p> <p>You also find the value of <code>mult</code> in the mouseover information to a port:</p> <p></p> <p><code>mult</code> here is <code>I</code> (followed by the index identifying the individual instances of the multiport on the module).</p>"},{"location":"python-script-frequently-used-parameters-syntax.html#link","title":"link","text":"<p>Scope: Use <code>link</code> to identify the link to a connected module port.</p> <p>Syntax: To identify a link, use the tuple <code>(&lt;FullModuleName&gt;, &lt;PortName&gt;)</code></p> <p><code>full_module_name</code> has the following syntax: <code>&lt;HierLevelPath&gt;/&lt;ModuleName&gt;</code>.</p>"},{"location":"python-script-frequently-used-parameters-syntax.html#full_sim_module_name","title":"full_sim_module_name","text":"<p>Scope: Use <code>full_sim_module_name</code> to identify an individual simulation module. It refers to simulation source and simulation probe modules.</p> <p><code>full_sim_module_name</code> has the following syntax: <code>&lt;HierLevelPath&gt;/&lt;SimModuleName&gt;</code></p>"},{"location":"python-script-frequently-used-parameters-syntax.html#file_name","title":"file_name","text":"<p>Scope: Use <code>file_name</code> to specify the path to the file and the file name itself. Use forward slashes for indicating paths. Don't forget to add the file name extension to the file name.</p> <ul> <li>File extensions .va and .vad indicate that your design is saved in the standard VisualApplets design format. All contents of the design are saved.</li> </ul>"},{"location":"release-notes-for-visualapplets-3-0-3.html","title":"Release Notes for VisualApplets 3.0.3","text":"<p>This section provides the release notes for VisualApplets version 3.0.3. Version 3.0.3 is a service release.</p> <p>VisualApplets 3.0.3 supports all Basler frame grabbers available at the time of release.</p> <p>In the following sub-sections, changes and compatibility information is provided:</p> <p>New Features</p> <p>Changes &amp; Fixed Issues</p> <p>System Requirements</p> <p>Firmware Versions and Runtime Requirements</p>"},{"location":"release-notes-for-visualapplets-3-0-4.html","title":"Release Notes for VisualApplets 3.0.4","text":"<p>This section provides the release notes for VisualApplets version 3.0.4. Version 3.0.4 is a service release.</p> <p>VisualApplets 3.0.4 supports all Basler frame grabbers available at point of release.</p> <p>In the following sub-sections, changes and compatibility information is provided:</p> <p>New Features</p> <p>Changes &amp; Fixed Issues</p> <p>System Requirements</p> <p>Firmware Versions and Runtime Requirements</p>"},{"location":"release-notes-for-visualapplets-3-0-6.html","title":"Release Notes for VisualApplets 3.0.6","text":"<p>This section provides the release notes for VisualApplets version 3.0.6. Version 3.0.6 is a service release.</p> <p>VisualApplets 3.0.6 supports all Basler frame grabbers available at point of release.</p> <p>In the following sub-sections, changes and compatibility information is provided:</p> <p>New Features</p> <p>Changes &amp; Fixed Issues</p> <p>Available Patches</p> <p>System Requirements</p> <p>Known Issues VisualApplets 3.0.6</p>"},{"location":"release-notes-for-visualapplets-3-0.html","title":"Release Notes for VisualApplets 3.0","text":"<p>This section provides the release notes for VisualApplets version 3.0. Version 3.0 is a major release.</p> <p>VisualApplets 3.0 supports all Basler frame grabbers available at the time of release.</p> <p>In the following sub-sections, changes and compatibility information is provided:</p> <p>New Features</p> <p>System Requirements</p> <p>Firmware Versions and Runtime Requirements</p>"},{"location":"release-notes-for-visualapplets-3-1-1.html","title":"Release Notes for VisualApplets 3.1.1","text":"<p>This section provides the release notes for VisualApplets version 3.1.1. VisualApplets 3.1.1 is a service release.</p> <p>VisualApplets 3.1.1 supports all Basler frame grabbers available at the time of release.</p> <p>In the following sub-sections, changes and compatibility information is provided:</p> <p>New Features</p> <p>Changes &amp; Fixed Issues</p> <p>System Requirements</p> <p>Firmware Versions and Runtime Requirements</p> <p>Known Issues VisualApplets 3.1.1</p>"},{"location":"release-notes-for-visualapplets-3-1-2.html","title":"Release Notes for VisualApplets 3.1.2","text":"<p>his section provides the release notes for VisualApplets version 3.1.2. VisualApplets 3.1.2 is a service release.</p> <p>VisualApplets 3.1.2 supports all Basler frame grabbers available at the time of release (April 2019).</p> <p>In the following sub-sections, changes and compatibility information is provided:</p> <p>New Features</p> <p>Changes &amp; Fixed Issues</p> <p>System Requirements</p> <p>Firmware Versions and Runtime Requirements</p> <p>Known Issues VisualApplets 3.1.2</p>"},{"location":"release-notes-for-visualapplets-3-1.html","title":"Release Notes for VisualApplets 3.1","text":"<p>This section provides the release notes for VisualApplets version 3.1. Version 3.1 is a service release.</p> <p>VisualApplets 3.1 supports all Basler frame grabbers available at the time of release.</p> <p>In the following sub-sections, changes and compatibility information is provided:</p> <p>New Features</p> <p>Changes &amp; Fixed Issues</p> <p>System Requirements</p> <p>Firmware Versions and Runtime Requirements</p> <p>Known Issues VisualApplets 3.1</p>"},{"location":"release-notes-for-visualapplets-3-2-0.html","title":"Release Notes for VisualApplets 3.2.0","text":"<p>This section provides the release notes for VisualApplets version 3.2.0. VisualApplets 3.2.0 is a service release.</p> <p>VisualApplets 3.2.0 supports all Basler frame grabbers available at the time of release (October 2019).</p> <p>In the following sub-sections, changes and compatibility information is provided:</p> <p>New Features</p> <p>Changes &amp; Fixed Issues</p> <p>System Requirements</p> <p>Firmware Versions and Runtime Requirements</p> <p>Known Issues VisualApplets 3.2.0</p>"},{"location":"release-notes-for-visualapplets-3-2-1.html","title":"Release Notes for VisualApplets 3.2.1","text":"<p>This section provides the release notes for VisualApplets version 3.2.1. VisualApplets 3.2.1 is a service release.</p> <p>VisualApplets 3.2.1 supports all Basler frame grabbers available at the time of release (May 2020).</p> <p>In the following sub-sections, changes and compatibility information is provided:</p> <p>New Features</p> <p>Changes &amp; Fixed Issues</p> <p>System Requirements</p> <p>Firmware Versions and Runtime Requirements</p> <p>Known Issues VisualApplets 3.2.1</p>"},{"location":"release-notes-for-visualapplets-3-3-0.html","title":"Release Notes for VisualApplets 3.3.0","text":"<p>This section provides the release notes for VisualApplets version 3.3.0. VisualApplets 3.3.0 is a service release.</p> <p>VisualApplets 3.3 supports all Basler frame grabbers available at the time of release (July 2021).</p> <p>In the following sub-sections, changes and compatibility information is provided:</p> <p>New Features</p> <p>Changes &amp; Fixed Issues</p> <p>System Requirements</p> <p>Firmware Versions and Runtime Requirements</p> <p>Known Issues VisualApplets 3.3.0</p>"},{"location":"release-notes-for-visualapplets-3-3-1.html","title":"Release Notes for VisualApplets 3.3.1","text":"<p>This topic provides the release notes for VisualApplets version 3.3.1.</p> <p>VisualApplets 3.3.1 is a maintenance release. It supports all Basler frame grabbers available at point of release (April 2022).</p> <p>Notice</p> <p>With the 3.3.1 VisualApplets installer of March 31, 2022, it is not possible to build applets which work on an Ubuntu 18.04 LTS system. This has been fixed with a new installer of April 29, 2022, which you can download in the Basler Download Site.</p> <p>In the following topics, changes and compatibility information is provided:</p> <ul> <li>New Features</li> <li>Changes &amp; Fixed Issues</li> <li>System Requirements</li> <li>Firmware Versions and Runtime Requirements</li> <li>Known Issues VisualApplets</li> </ul>"},{"location":"release-notes-for-visualapplets-3-3-2.html","title":"Release Notes for VisualApplets 3.3.2","text":"<p>This topic provides the release notes for VisualApplets version 3.3.2.</p> <p>VisualApplets 3.3.2 is a maintenance release (available from November 2022) that supports all Basler current frame grabbers.</p> <p>In the following topics, changes and compatibility information is provided:</p> <ul> <li>New Features</li> <li>Changes &amp; Fixed Issues</li> <li>System Requirements</li> <li>Firmware Versions and Runtime Requirements</li> <li>Known Issues VisualApplets</li> </ul>"},{"location":"release-notes-for-visualapplets-3-4-0.html","title":"Release Notes for VisualApplets 3.4.0","text":"<p>This topic provides the release notes for VisualApplets version 3.4.0</p> <p>VisualApplets 3.4.0 is a service release (available from January 2024) that supports all current Basler frame grabbers.</p> <p>In the following topics, changes and compatibility information is provided:</p> <ul> <li>New Features</li> <li>Changes &amp; Fixed Issues</li> <li>System Requirements</li> <li>Firmware Versions and Runtime Requirements</li> <li>Known Issues VisualApplets</li> </ul>"},{"location":"release-notes-for-visualapplets-3-4-1.html","title":"Release Notes for VisualApplets 3.4.1","text":"<p>This topic provides the release notes for VisualApplets version 3.4.1.</p> <p>VisualApplets 3.4.1 is a service release (available from July 2024) that supports all current Basler frame grabbers.</p> <p>In the following topics, changes and compatibility information is provided:</p> <ul> <li>New Features</li> <li>Changes &amp; Fixed Issues</li> <li>System Requirements</li> <li>Firmware Versions and Runtime Requirements</li> <li>Known Issues VisualApplets</li> </ul>"},{"location":"release-notes-for-visualapplets-3-5-0.html","title":"Release Notes for VisualApplets 3.5.0","text":"<p>This topic provides the release notes for VisualApplets version 3.5.0.</p> <p>VisualApplets 3.5.0 is a service release that supports all current programmable Basler frame grabbers.</p> <p>In the following topics, changes and compatibility information is provided:</p> <ul> <li>New Features</li> <li>Changes &amp; Fixed Issues</li> <li>System Requirements</li> <li>Firmware Versions and Runtime Requirements</li> <li>Known Issues VisualApplets</li> </ul>"},{"location":"release-notes-for-visualapplets-3-5-1.html","title":"Release Notes for VisualApplets 3.5.1","text":"<p>This topic provides the release notes for VisualApplets version 3.5.1.</p> <p>VisualApplets 3.5.1 is a service release that supports all current programmable Basler frame grabbers.</p> <p>In the following topics, changes and compatibility information is provided:</p> <ul> <li>New Features</li> <li>Changes &amp; Fixed Issues</li> <li>System Requirements</li> <li>Firmware Versions and Runtime Requirements</li> <li>Known Issues VisualApplets</li> </ul>"},{"location":"release-notes-for-visualapplets-3-6-0.html","title":"Release Notes for VisualApplets 3.6.0","text":"<p>This topic provides the release notes for VisualApplets version 3.6.0.</p> <p>VisualApplets 3.6.0 is a service release that supports all current programmable Basler frame grabbers.</p> <p>In the following topics, changes and compatibility information is provided:</p> <ul> <li>New Features</li> <li>Changes &amp; Fixed Issues</li> <li>System Requirements</li> <li>Firmware Versions and Runtime Requirements</li> <li>Known Issues VisualApplets</li> </ul>"},{"location":"release-notes-for-visualapplets-3-6-1.html","title":"Release Notes for VisualApplets 3.6.1","text":"<p>This topic provides the release notes for VisualApplets version 3.6.1.</p> <p>VisualApplets 3.6.1 is a service release that supports all current programmable Basler frame grabbers.</p> <p>In the following topics, changes and compatibility information is provided:</p> <ul> <li>New Features</li> <li>Changes &amp; Fixed Issues</li> <li>System Requirements</li> <li>Firmware Versions and Runtime Requirements</li> <li>Known Issues VisualApplets</li> </ul>"},{"location":"release-notes-visual-applets.html","title":"Release Notes VisualApplets","text":"<p>This topic provides the release notes for VisualApplets for all versions.</p> <p>To read about changes and compatibility information, select the VisualApplets version of your choice:</p> <ul> <li>VisualApplets 3.6.1 Release Notes</li> <li>VisualApplets 3.6.0 Release Notes</li> <li>VisualApplets 3.5.1 Release Notes</li> <li>VisualApplets 3.5.0 Release Notes</li> <li>VisualApplets 3.4.1 Release Notes</li> <li>VisualApplets 3.4.0 Release Notes</li> <li>VisualApplets 3.3.2 Release Notes</li> <li>VisualApplets 3.3.1 Release Notes</li> <li>VisualApplets 3.3.0 Release Notes</li> <li>VisualApplets 3.2.1 Release Notes</li> <li>VisualApplets 3.2.0 Release Notes</li> <li>VisualApplets 3.1.2 Release Notes</li> <li>VisualApplets 3.1.1 Release Notes</li> <li>VisualApplets 3.1 Release Notes</li> <li>VisualApplets 3.0.6 Release Notes</li> <li>VisualApplets 3.0.4 Release Notes</li> <li>VisualApplets 3.0.3 Release Notes</li> <li>VisualApplets 3.0 Release Notes</li> </ul>"},{"location":"system-requirements-for-visualapplets-3-3-0.html","title":"System Requirements for VisualApplets 3.3.0","text":""},{"location":"system-requirements-for-visualapplets-3-3-0.html#pc-and-operating-system","title":"PC and Operating System","text":"<ul> <li>OS: Microsoft Windows 8.1, or Windows 10 (64bit)</li> <li>PC Memory: Minimum 4 GByte, recommended: 8 GByte or better</li> <li>Minimum available hard disk space: 1 GByte</li> </ul>"},{"location":"system-requirements-for-visualapplets-3-3-0.html#third-party-software","title":"Third-Party Software","text":"<ul> <li>For compiling the SDK examples, a C++ Compiler is necessary.</li> <li>Depending on the target platform (FPGA type) of the applets designed with VisualApplets, Xilinx Vivado (WebPACK (free) or Design Suite) or Xilinx ISE (WebPACK (free) or Design Suite). For details, see below.</li> </ul> <p>The table below lists all Basler target hardware and the required Xilinx ISE and/or Vivado licenses.</p> <p>Note that for building designs for mE5 marathon frame grabbers, it is strongly recommend to use Xilinx Vivado. Using Xilinx Vivado, the build process is much faster, and more complex designs can be fitted on the FPGA.</p>"},{"location":"system-requirements-for-visualapplets-3-3-0.html#which-xilinx-toolchain-and-version-for-which-frame-grabber-platform","title":"Which Xilinx Toolchain and Version for Which Frame Grabber Platform?","text":"Basler Frame Grabber Model microEnable (mE) WebPACK (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE IV VD1-CL ISE version 9.2 or higher Recommended version: 9.2 PixelPlant PX100,  PixelPlant PX100e ISE version 9.2 or higher Recommended version: 9.2 mE IV VD4-CL/PoCL Recommended version: 9.2 mE IV VQ4-GE/-GPoE Recommended version: 9.2 PixelPlant PX200e Recommended version: 9.2 mE5 ironman VQ8 CXP6-D Version 14.7 mE5 ironman VD8-PoCL Version 14.7 mE5 marathon VF2 ISE version 14.7, Vivado versions between 2016.1 and 2020.1<sup>b</sup> Version 14.7 Versions between 2016.1 and 2020.1<sup>b</sup> mE5 marathon VCX-QP ISE version 14.7, Vivado versions between 2016.1 and 2020.1<sup>b</sup> Version 14.7 Versions between 2016.1 and 2020.1<sup>b</sup> LightBridge VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1<sup>b</sup> Version 14.7 Versions between 2016.1 and 2020.1<sup>b</sup> mE5 marathon VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1<sup>b</sup> Version 14.7 Versions between 2016.1 and 2020.1<sup>b</sup> mE5 marathon VCLx Versions between 2016.1 and 2020.1<sup>b</sup> <ol> <li> <p>A free, 30-days evaluation license is available.\u00a0\u21a9\u21a9</p> </li> <li> <p>Basler recommends to use Vivado 2017.4. Building applets for mE5 platforms only works with Vivado 2020.1 or lower, as described in the Known Issues VisualApplets Release 3.3.1, section General.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"system-requirements-for-visualapplets-3-3-1.html","title":"System Requirements for VisualApplets 3.3.1","text":""},{"location":"system-requirements-for-visualapplets-3-3-1.html#pc-and-operating-system","title":"PC and Operating System","text":"<ul> <li>OS: Microsoft Windows 8.1, Windows 10 (64bit)</li> <li>PC Memory: Minimum 4 GByte, recommended: 8 GByte or better</li> <li>Minimum available hard disk space: 1 GByte</li> </ul>"},{"location":"system-requirements-for-visualapplets-3-3-1.html#third-party-software","title":"Third-Party Software","text":"<ul> <li>For compiling the SDK examples, a C++ Compiler is necessary.</li> <li>Depending on the target platform (FPGA type) of the applets designed with VisualApplets, Xilinx Vivado (WebPACK (free) or Design Suite) or Xilinx ISE (WebPACK (free) or Design Suite). For details, see below.</li> </ul> <p>The table below lists all Basler target hardware and the required Xilinx ISE and/or Vivado licenses.</p> <p>Note that for building designs for mE5 marathon frame grabbers, it is strongly recommend to use Xilinx Vivado. Using Xilinx Vivado, the build process is much faster, and more complex designs can be fitted on the FPGA.</p>"},{"location":"system-requirements-for-visualapplets-3-3-1.html#which-xilinx-toolchain-and-version-for-which-frame-grabber-platform","title":"Which Xilinx Toolchain and Version for Which Frame Grabber Platform?","text":"Basler Frame Grabber Model microEnable (mE) WebPACK (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE IV VD1-CL ISE version 9.2 or higher Recommended version: 9.2 PixelPlant PX100,  PixelPlant PX100e ISE version 9.2 or higher Recommended version: 9.2 mE IV VD4-CL/PoCL Recommended version: 9.2 mE IV VQ4-GE/-GPoE Recommended version: 9.2 PixelPlant PX200e Recommended version: 9.2 mE5 ironman VQ8 CXP6-D Version 14.7 mE5 ironman VD8-PoCL Version 14.7 mE5 marathon VF2 ISE version 14.7, Vivado versions between 2016.1 and 2020.1<sup>b</sup> Version 14.7 Versions between 2016.1 and 2020.1<sup>b</sup> mE5 marathon VCX-QP ISE version 14.7, Vivado versions between 2016.1 and 2020.1<sup>b</sup> Version 14.7 Versions between 2016.1 and 2020.1<sup>b</sup> LightBridge VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1<sup>b</sup> Version 14.7 Versions between 2016.1 and 2020.1<sup>b</sup> mE5 marathon VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1<sup>b</sup> Version 14.7 Versions between 2016.1 and 2020.1<sup>b</sup> mE5 marathon VCLx Versions between 2016.1 and 2020.1<sup>b</sup> <ol> <li> <p>A free, 30-days evaluation license is available.\u00a0\u21a9\u21a9</p> </li> <li> <p>Basler recommends to use Vivado 2017.4. Building applets for mE5 platforms only works with Vivado 2020.1 or lower, as described in the Known Issues VisualApplets Release 3.3.1, section General.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"system-requirements-for-visualapplets-3-3-2.html","title":"System Requirements for VisualApplets 3.3.2","text":""},{"location":"system-requirements-for-visualapplets-3-3-2.html#pc-and-operating-system","title":"PC and Operating System","text":"<ul> <li>OS: Microsoft Windows 8.1, Windows 10 (64bit)</li> <li>PC Memory: Minimum 4 GByte, recommended: 8 GByte or better</li> <li>Minimum available hard disk space: 1 GByte</li> </ul>"},{"location":"system-requirements-for-visualapplets-3-3-2.html#third-party-software","title":"Third-Party Software","text":"<ul> <li>For compiling the SDK examples, a C++ Compiler is necessary.</li> <li>Depending on the target platform (FPGA type) of the applets designed with VisualApplets, Xilinx Vivado (WebPACK (free) or Design Suite) or Xilinx ISE (WebPACK (free) or Design Suite). For details, see below.</li> </ul> <p>The table below lists all Basler target hardware and the required Xilinx ISE and/or Vivado licenses.</p> <p>Note that for building designs for mE5 marathon frame grabbers, it is strongly recommend to use Xilinx Vivado. Using Xilinx Vivado, the build process is much faster, and more complex designs can be fitted on the FPGA.</p>"},{"location":"system-requirements-for-visualapplets-3-3-2.html#which-xilinx-toolchain-and-version-for-which-frame-grabber-platform","title":"Which Xilinx Toolchain and Version for Which Frame Grabber Platform?","text":"Basler Frame Grabber Model microEnable (mE) WebPACK (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE IV VD1-CL ISE version 9.2 or higher Recommended version: 9.2 PixelPlant PX100,  PixelPlant PX100e ISE version 9.2 or higher Recommended version: 9.2 mE IV VD4-CL/PoCL Recommended version: 9.2 mE IV VQ4-GE/-GPoE Recommended version: 9.2 PixelPlant PX200e Recommended version: 9.2 mE5 ironman VQ8 CXP6-D Version 14.7 mE5 ironman VD8-PoCL Version 14.7 mE5 marathon VF2 ISE version 14.7, Vivado versions between 2016.1 and 2020.1<sup>b</sup> Version 14.7 Versions between 2016.1 and 2020.1<sup>b</sup> mE5 marathon VCX-QP ISE version 14.7, Vivado versions between 2016.1 and 2020.1<sup>b</sup> Version 14.7 Versions between 2016.1 and 2020.1<sup>b</sup> LightBridge VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1<sup>b</sup> Version 14.7 Versions between 2016.1 and 2020.1<sup>b</sup> mE5 marathon VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1<sup>b</sup> Version 14.7 Versions between 2016.1 and 2020.1<sup>b</sup> mE5 marathon VCLx Versions between 2016.1 and 2020.1<sup>b</sup> <ol> <li> <p>A free, 30-days evaluation license is available.\u00a0\u21a9\u21a9</p> </li> <li> <p>Basler recommends to use Vivado 2017.4. Building applets for mE5 platforms only works with Vivado 2020.1 or lower, as described in the Known Issues VisualApplets Release 3.3.2, section General.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"system-requirements-for-visualapplets-3-4-0.html","title":"System Requirements for VisualApplets 3.4.0","text":""},{"location":"system-requirements-for-visualapplets-3-4-0.html#pc-and-operating-system","title":"PC and Operating System","text":"<ul> <li>OS: Microsoft Windows 10 (64 bit), and Windows 11 (64 bit)</li> <li>PC Memory: Minimum 4 GByte, recommended: 8 GByte or better</li> <li>Minimum available hard disk space: 1 GByte</li> </ul>"},{"location":"system-requirements-for-visualapplets-3-4-0.html#third-party-software","title":"Third-Party Software","text":"<ul> <li>For compiling the SDK examples, a C++ compiler is necessary.</li> <li>Depending on the target platform (FPGA type) of the applets designed with VisualApplets, you need to install Xilinx Vivado (WebPACK (free) or Design Suite) or Xilinx ISE (WebPACK (free) or Design Suite). Note that Xilinx ISE doesn't support Windows 11. For details, see below.</li> </ul> <p>The table below lists all Basler target hardware and the required Xilinx ISE and/or Vivado licenses.</p> <p>Note that for building designs for mE5 marathon frame grabbers, it is strongly recommended to use Xilinx Vivado. Using Xilinx Vivado, the build process is much faster, and more complex designs can be fitted on the FPGA.</p>"},{"location":"system-requirements-for-visualapplets-3-4-0.html#which-xilinx-toolchain-and-version-for-which-frame-grabber-platform","title":"Which Xilinx Toolchain and Version for Which Frame Grabber Platform?","text":"Basler Frame Grabber Model microEnable (mE) WebPACK (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup> and <sup>b</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE IV VD1-CL ISE version 9.2 or higher Recommended version: 9.2 PixelPlant PX100,  PixelPlant PX100e ISE version 9.2 or higher Recommended version: 9.2 mE IV VD4-CL/PoCL Recommended version: 9.2 mE IV VQ4-GE/-GPoE Recommended version: 9.2 PixelPlant PX200e Recommended version: 9.2 mE5 ironman VQ8 CXP6-D Version 14.7 mE5 ironman VD8-PoCL Version 14.7 mE5 marathon VF2 ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> mE5 marathon VCX-QP ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> LightBridge VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> mE5 marathon VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> mE5 marathon VCLx Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> imaFlex CXP-12 Quad ISE is not supportedVivado version 2023.2<sup>d</sup> Version 2023.2<sup>d</sup> <ol> <li> <p>A free, 30-days evaluation license is available.\u00a0\u21a9\u21a9</p> </li> <li> <p>Xilinx ISE officially doesn't support Windows 11. If your platform needs to be built with Xilinx ISE, install VisualApplets on a Windows 10 operating system. In this forum discussion you find some hacks how to install ISE under Windows 11 anyways, even though this is officially not supported.\u00a0\u21a9</p> </li> <li> <p>Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1., see Known Issues VisualApplets Release 3.4.1, entry with ticket ID 217879 in General section.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Vivado version 2024.1 might lead to freezes of VisualApplets version 3.4.0 or lower. In VisualApplets version 3.4.1 this has been fixed. However, this VisualApplets version has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. See also Known Issues VisualApplets 3.4.0 and Changes and Fixes VisualApplets 3.4.1.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"system-requirements-for-visualapplets-3-4-1.html","title":"System Requirements for VisualApplets 3.4.1","text":""},{"location":"system-requirements-for-visualapplets-3-4-1.html#pc-and-operating-system","title":"PC and Operating System","text":"<ul> <li>OS: Microsoft Windows 10 (64 bit), and Windows 11 (64 bit)</li> <li>PC Memory: Minimum 4 GByte, recommended: 8 GByte or better</li> <li>Minimum available hard disk space: 1 GByte</li> </ul>"},{"location":"system-requirements-for-visualapplets-3-4-1.html#third-party-software","title":"Third-Party Software","text":"<ul> <li>For compiling the SDK examples, a C++ compiler is necessary.</li> <li>Depending on the target platform (FPGA type) of the applets designed with VisualApplets, you need to install Xilinx Vivado (WebPACK (free) or Design Suite) or Xilinx ISE (WebPACK (free) or Design Suite). Note that Xilinx ISE doesn't support Windows 11. For details, see below.</li> </ul> <p>The table below lists all Basler target hardware and the required Xilinx ISE and/or Vivado licenses.</p> <p>Note that for building designs for mE5 marathon frame grabbers, it is strongly recommended to use Xilinx Vivado. Using Xilinx Vivado, the build process is much faster, and more complex designs can be fitted on the FPGA.</p>"},{"location":"system-requirements-for-visualapplets-3-4-1.html#which-xilinx-toolchain-and-version-for-which-frame-grabber-platform","title":"Which Xilinx Toolchain and Version for Which Frame Grabber Platform?","text":"Basler Frame Grabber Model microEnable (mE) WebPACK (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup> and <sup>b</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE IV VD1-CL ISE version 9.2 or higher Recommended version: 9.2 PixelPlant PX100,  PixelPlant PX100e ISE version 9.2 or higher Recommended version: 9.2 mE IV VD4-CL/PoCL Recommended version: 9.2 mE IV VQ4-GE/-GPoE Recommended version: 9.2 PixelPlant PX200e Recommended version: 9.2 mE5 ironman VQ8 CXP6-D Version 14.7 mE5 ironman VD8-PoCL Version 14.7 mE5 marathon VF2 ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> mE5 marathon VCX-QP ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> LightBridge VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> mE5 marathon VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> mE5 marathon VCLx Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup> imaFlex CXP-12 Quad ISE is not supportedVivado version 2023.2<sup>d</sup> Version 2023.2<sup>d</sup> <ol> <li> <p>A free, 30-days evaluation license is available.\u00a0\u21a9\u21a9</p> </li> <li> <p>Xilinx ISE officially doesn't support Windows 11. If your platform needs to be built with Xilinx ISE, install VisualApplets on a Windows 10 operating system. In this forum discussion you find some hacks how to install ISE under Windows 11 anyways, even though this is officially not supported.\u00a0\u21a9</p> </li> <li> <p>Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1., see Known Issues VisualApplets Release 3.4.1, entry with ticket ID 217879 in General section.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Vivado version 2024.1 might lead to freezes of VisualApplets version 3.4.0 or lower. In VisualApplets version 3.4.1 this has been fixed. However, this VisualApplets version has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. See also Known Issues VisualApplets 3.4.0 and Changes and Fixes VisualApplets 3.4.1.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"system-requirements-for-visualapplets-3-5-0.html","title":"System Requirements for VisualApplets 3.5.0","text":""},{"location":"system-requirements-for-visualapplets-3-5-0.html#pc-and-operating-system","title":"PC and Operating System","text":"<ul> <li>OS: Microsoft Windows 10 (64 bit), and Windows 11 (64 bit)</li> <li>PC Memory: Minimum 4 GByte, recommended: 8 GByte or better</li> <li>Minimum available hard disk space: 1 GByte</li> </ul>"},{"location":"system-requirements-for-visualapplets-3-5-0.html#third-party-software","title":"Third-Party Software","text":"<ul> <li>For compiling the SDK examples, a C++ compiler is necessary.</li> <li>Depending on the target platform (FPGA type) of the applets designed with VisualApplets, you need to install Xilinx Vivado (WebPACK (free) or Design Suite) or Xilinx ISE (WebPACK (free) or Design Suite). Note that Xilinx ISE doesn't support Windows 11. For details, see below.</li> </ul> <p>The table below lists all Basler target hardware and the required Xilinx ISE and/or Vivado licenses.</p> <p>Note that for building designs for mE5 marathon frame grabbers, it is strongly recommended to use Xilinx Vivado. Using Xilinx Vivado, the build process is much faster, and more complex designs can be fitted on the FPGA.</p>"},{"location":"system-requirements-for-visualapplets-3-5-0.html#which-xilinx-toolchain-and-version-for-which-frame-grabber-platform","title":"Which Xilinx Toolchain and Version for Which Frame Grabber Platform?","text":"Current Basler Frame Grabber Models WebPACK (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup><sup>b</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE5 marathon VCX-QP ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> mE5 marathon VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> mE5 marathon VCLx Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> imaFlex CXP-12 Quad ISE is not supportedVivado version 2023.2<sup>d</sup><sup>e</sup> Version 2023.2<sup>d</sup><sup>e</sup> imaFlex CXP-12 Penta ISE is not supportedVivado version 2023.2<sup>d</sup><sup>e</sup> Version 2023.2<sup>d</sup><sup>e</sup> Legacy Basler Frame Grabber Models WebPACK (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup><sup>b</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE IV VD1-CL ISE version 9.2 or higher Recommended version: 9.2 PixelPlant PX100,  PixelPlant PX100e ISE version 9.2 or higher Recommended version: 9.2 mE IV VD4-CL/PoCL Recommended version: 9.2 mE IV VQ4-GE/-GPoE Recommended version: 9.2 PixelPlant PX200e Recommended version: 9.2 mE5 ironman VQ8 CXP6-D Version 14.7 mE5 ironman VD8-PoCL Version 14.7 mE5 marathon VF2 ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> LightBridge VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> <ol> <li> <p>A free, 30-days evaluation license is available.\u00a0\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Xilinx ISE officially doesn't support Windows 11. If your platform needs to be built with Xilinx ISE, install VisualApplets on a Windows 10 operating system. In this forum discussion you find some hacks how to install ISE under Windows 11 anyways, even though this is officially not supported.\u00a0\u21a9\u21a9</p> </li> <li> <p>Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1., see Known Issues VisualApplets Release 3.4.1, entry with ticket ID 217879 in General section.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Vivado version 2024.1 might lead to freezes of VisualApplets version 3.4.0 or lower. In VisualApplets version 3.4.1 this has been fixed. However, this VisualApplets version has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. See also Known Issues VisualApplets 3.4.0 and Changes and Fixes VisualApplets 3.4.1.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Vivado version 2024.2 might lead to crashes of VisualApplets version 3.5.0 or lower. In VisualApplets version 3.5.1 this has been fixed. However, this VisualApplets version has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. See also Known Issues VisualApplets 3.5.0 and Changes and Fixes VisualApplets 3.5.1.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"system-requirements-for-visualapplets-3-5-1.html","title":"System Requirements for VisualApplets 3.5.1","text":""},{"location":"system-requirements-for-visualapplets-3-5-1.html#pc-and-operating-system","title":"PC and Operating System","text":"<ul> <li>OS: Microsoft Windows 10 (64 bit), and Windows 11 (64 bit)</li> <li>PC Memory: Minimum 4 GByte, recommended: 8 GByte or better</li> <li>Minimum available hard disk space: 1 GByte</li> </ul>"},{"location":"system-requirements-for-visualapplets-3-5-1.html#third-party-software","title":"Third-Party Software","text":"<ul> <li>For compiling the SDK examples, a C++ compiler is necessary.</li> <li>Depending on the target platform (FPGA type) of the applets designed with VisualApplets, you need to install Xilinx Vivado (WebPACK (free) or Design Suite) or Xilinx ISE (WebPACK (free) or Design Suite). Note that Xilinx ISE doesn't support Windows 11. For details, see below.</li> </ul> <p>The table below lists all Basler target hardware and the required Xilinx ISE and/or Vivado licenses.</p> <p>Note that for building designs for mE5 marathon frame grabbers, it is strongly recommended to use Xilinx Vivado. Using Xilinx Vivado, the build process is much faster, and more complex designs can be fitted on the FPGA.</p>"},{"location":"system-requirements-for-visualapplets-3-5-1.html#which-xilinx-toolchain-and-version-for-which-frame-grabber-platform","title":"Which Xilinx Toolchain and Version for Which Frame Grabber Platform?","text":"Current Basler Frame Grabber Models WebPACK / Vivado ML Standard (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup><sup>b</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE5 marathon VCX-QP ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> mE5 marathon VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> mE5 marathon VCLx Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> imaFlex CXP-12 Quad ISE is not supportedVivado version 2023.2<sup>d</sup><sup>e</sup> Version 2023.2<sup>d</sup><sup>e</sup> imaFlex CXP-12 Penta ISE is not supportedVivado version 2023.2<sup>d</sup><sup>e</sup> Version 2023.2<sup>d</sup><sup>e</sup> Legacy Basler Frame Grabber Models WebPACK / Vivado ML Standard (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup><sup>b</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE IV VD1-CL ISE version 9.2 or higher Recommended version: 9.2 PixelPlant PX100,  PixelPlant PX100e ISE version 9.2 or higher Recommended version: 9.2 mE IV VD4-CL/PoCL Recommended version: 9.2 mE IV VQ4-GE/-GPoE Recommended version: 9.2 PixelPlant PX200e Recommended version: 9.2 mE5 ironman VQ8 CXP6-D Version 14.7 mE5 ironman VD8-PoCL Version 14.7 mE5 marathon VF2 ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> LightBridge VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> <ol> <li> <p>A free, 30-days evaluation license is available.\u00a0\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Xilinx ISE officially doesn't support Windows 11. If your platform needs to be built with Xilinx ISE, install VisualApplets on a Windows 10 operating system. In this forum discussion you find some hacks how to install ISE under Windows 11 anyways, even though this is officially not supported.\u00a0\u21a9\u21a9</p> </li> <li> <p>Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1., see Known Issues VisualApplets Release 3.4.1, entry with ticket ID 217879 in General section.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Vivado version 2024.1 might lead to freezes of VisualApplets version 3.4.0 or lower. In VisualApplets version 3.4.1 this has been fixed. However, this VisualApplets version has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. See also Known Issues VisualApplets 3.4.0 and Changes and Fixes VisualApplets 3.4.1.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Vivado version 2024.2 might lead to crashes of VisualApplets version 3.5.0 or lower. In VisualApplets version 3.5.1 this has been fixed. However, this VisualApplets version has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. See also Known Issues VisualApplets 3.5.0 and Changes and Fixes VisualApplets 3.5.1.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"system-requirements-for-visualapplets-3-6-0.html","title":"System Requirements for VisualApplets 3.6.0","text":""},{"location":"system-requirements-for-visualapplets-3-6-0.html#pc-and-operating-system","title":"PC and Operating System","text":"<ul> <li>OS: Microsoft Windows 10 (64 bit), and Windows 11 (64 bit)</li> <li>PC Memory: Minimum 4 GByte, recommended: 8 GByte or better</li> <li>Minimum available hard disk space: 1 GByte</li> </ul>"},{"location":"system-requirements-for-visualapplets-3-6-0.html#third-party-software","title":"Third-Party Software","text":"<ul> <li>For compiling the SDK examples, a C++ compiler is necessary.</li> <li>Depending on the target platform (FPGA type) of the applets designed with VisualApplets, you need to install Xilinx Vivado (WebPACK (free) or Design Suite) or Xilinx ISE (WebPACK (free) or Design Suite). Note that Xilinx ISE doesn't support Windows 11. For details, see below.</li> </ul> <p>The table below lists all Basler target hardware and the required Xilinx ISE and/or Vivado licenses.</p> <p>Note that for building designs for mE5 marathon frame grabbers, it is strongly recommended to use Xilinx Vivado. Using Xilinx Vivado, the build process is much faster, and more complex designs can be fitted on the FPGA.</p>"},{"location":"system-requirements-for-visualapplets-3-6-0.html#which-xilinx-toolchain-and-version-for-which-frame-grabber-platform","title":"Which Xilinx Toolchain and Version for Which Frame Grabber Platform?","text":"Current Basler Frame Grabber Models WebPACK / Vivado ML Standard (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup><sup>b</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE5 marathon VCX-QP ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> mE5 marathon VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> mE5 marathon VCLx Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> imaFlex CXP-12 Quad ISE is not supportedVivado version 2023.2<sup>d</sup><sup>e</sup> Version 2023.2<sup>d</sup><sup>e</sup> imaFlex CXP-12 Penta ISE is not supportedVivado version 2023.2<sup>d</sup><sup>e</sup> Version 2023.2<sup>d</sup><sup>e</sup> Legacy Basler Frame Grabber Models WebPACK / Vivado ML Standard (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup><sup>b</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE5 ironman VQ8 CXP6-D Version 14.7 mE5 ironman VD8-PoCL Version 14.7 mE5 marathon VF2 ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> LightBridge VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup> <ol> <li> <p>A free, 30-days evaluation license is available.\u00a0\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Xilinx ISE officially doesn't support Windows 11. If your platform needs to be built with Xilinx ISE, install VisualApplets on a Windows 10 operating system. In this forum discussion you find some hacks how to install ISE under Windows 11 anyways, even though this is officially not supported.\u00a0\u21a9\u21a9</p> </li> <li> <p>Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1., see Known Issues VisualApplets Release 3.4.1, entry with ticket ID 217879 in General section.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Vivado version 2024.1 might lead to freezes of VisualApplets version 3.4.0 or lower. In VisualApplets version 3.4.1 this has been fixed. However, this VisualApplets version has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. See also Known Issues VisualApplets 3.4.0 and Changes and Fixes VisualApplets 3.4.1.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Vivado version 2024.2 might lead to crashes of VisualApplets version 3.5.0 or lower. In VisualApplets version 3.6.0 this has been fixed. However, this VisualApplets version has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. See also Known Issues VisualApplets 3.5.0 and Changes and Fixes VisualApplets 3.6.0.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"system-requirements-for-visualapplets-3-6-1.html","title":"System Requirements for VisualApplets 3.6.01","text":""},{"location":"system-requirements-for-visualapplets-3-6-1.html#pc-and-operating-system","title":"PC and Operating System","text":"<ul> <li>OS: Microsoft Windows 10 (64 bit), and Windows 11 (64 bit)</li> <li>PC Memory: Minimum 4 GByte, recommended: 8 GByte or better</li> <li>Minimum available hard disk space: 1 GByte</li> </ul>"},{"location":"system-requirements-for-visualapplets-3-6-1.html#third-party-software","title":"Third-Party Software","text":"<ul> <li>For compiling the SDK examples, a C++ compiler is necessary.</li> <li>Depending on the target platform (FPGA type) of the applets designed with VisualApplets, you need to install Xilinx Vivado (WebPACK (free) or Design Suite) or Xilinx ISE (WebPACK (free) or Design Suite). Note that Xilinx ISE doesn't support Windows 11. For details, see below.</li> </ul> <p>The table below lists all Basler target hardware and the required Xilinx ISE and/or Vivado licenses.</p> <p>Note that for building designs for mE5 marathon frame grabbers, it is strongly recommended to use Xilinx Vivado. Using Xilinx Vivado, the build process is much faster, and more complex designs can be fitted on the FPGA.</p>"},{"location":"system-requirements-for-visualapplets-3-6-1.html#which-xilinx-toolchain-and-version-for-which-frame-grabber-platform","title":"Which Xilinx Toolchain and Version for Which Frame Grabber Platform?","text":"Current Basler Frame Grabber Models WebPACK / Vivado ML Standard (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup><sup>b</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE5 marathon VCX-QP ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> mE5 marathon VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> mE5 marathon VCLx Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> imaFlex CXP-12 Quad ISE is not supportedVivado version 2023.2<sup>d</sup><sup>e</sup><sup>f</sup> Version 2023.2<sup>d</sup><sup>e</sup><sup>f</sup> imaFlex CXP-12 Penta ISE is not supportedVivado version 2023.2<sup>d</sup><sup>e</sup><sup>f</sup> Version 2023.2<sup>d</sup><sup>e</sup><sup>f</sup> Legacy Basler Frame Grabber Models WebPACK / Vivado ML Standard (Free License) ISE Design Suite Logic Edition(Purchase Version<sup>a</sup><sup>b</sup>) Vivado Design Suite (Purchase Version<sup>a</sup>) mE5 ironman VQ8 CXP6-D Version 14.7 mE5 ironman VD8-PoCL Version 14.7 mE5 marathon VF2 ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> LightBridge VCL ISE version 14.7, Vivado versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> Version 14.7 Versions between 2016.1 and 2020.1, or versions between 2021.2 and 2023.2<sup>c</sup><sup>d</sup><sup>e</sup><sup>f</sup> <ol> <li> <p>A free, 30-days evaluation license is available.\u00a0\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Xilinx ISE officially doesn't support Windows 11. If your platform needs to be built with Xilinx ISE, install VisualApplets on a Windows 10 operating system. In this forum discussion you find some hacks how to install ISE under Windows 11 anyways, even though this is officially not supported.\u00a0\u21a9\u21a9</p> </li> <li> <p>Applets for mE5-CL platforms can't be built with Vivado versions between 2020.2 and 2021.1., see Known Issues VisualApplets Release 3.4.1, entry with ticket ID 217879 in General section.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Vivado version 2024.1 might lead to freezes of VisualApplets version 3.4.0 or lower. In VisualApplets version 3.4.1 this has been fixed. However, this VisualApplets version has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. See also Known Issues VisualApplets 3.4.0 and Changes and Fixes VisualApplets 3.4.1.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>Vivado version 2024.2 might lead to crashes of VisualApplets version 3.5.0 or lower. In VisualApplets version 3.5.1 this has been fixed. However, this VisualApplets version has been tested to work best with Vivado 2023.2, so Basler doesn't recommend using a higher version of Vivado. See also Known Issues VisualApplets 3.5.0 and Changes and Fixes VisualApplets 3.5.1.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>VisualApplets prohibits building designs with Vivado 2025.1 and later as designs built with these versions don't work. See also Changes and Fixed Issues in VisualApplets 3.6.1 and Changes and Fixes VisualApplets 3.4.1.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> </ol>"},{"location":"system-requirements.html","title":"System Requirements","text":""},{"location":"system-requirements.html#pc-and-operating-system","title":"PC and Operating System","text":"<ul> <li>OS: Microsoft Windows 7, Windows 8, or Windows 10 (64-bit)</li> <li>PC Memory: Minimum 4 GByte, recommended: 8 GByte or better</li> <li>Minimum available hard disk space: 500 MByte</li> </ul>"},{"location":"system-requirements.html#third-party-software","title":"Third-Party Software","text":"<ul> <li>For compiling the SDK examples, a C++ Compiler is necessary.</li> <li>Depending on the target platform (FPGA type) of the applets designed with VisualApplets, Xilinx Vivado (WebPACK (free) or Design Suite) or Xilinx ISE (WebPACK (free) or Design Suite). For details, see below.</li> </ul> <p>The table below lists all Basler target hardware and the required Xilinx ISE and/or Vivado licenses.</p> <p>Note that for building designs for mE5 marathon frame grabbers, it is strongly recommend to use Xilinx Vivado. Using Xilinx Vivado, the build process is much faster, and more complex designs can be fitted on the FPGA.</p>"},{"location":"system-requirements.html#which-xilinx-toolchain-and-version-for-which-frame-grabber-platform","title":"Which Xilinx Toolchain and Version for Which Frame Grabber Platform?","text":"Basler Frame Grabber Model microEnable (mE) WebPACK (free license) ISE Design Suite Logic Edition(Purchase Version) Vivado Design Suite (Purchase Version) Xilinx ISE 30-Day Evaluation License Version 14.7 Vivado 30-Day Evaluation License PixelPlant PX100,  PixelPlant PX100e ISE version 9.2 or higher Recommended version: 9.2 PixelPlant PX200e Recommended version: 9.2 mE5 ironman VQ8 CXP6-D ISE version 14.7 Version 14.7 ISE 30-Day Eval,version 14.7 mE5 ironman VD8-PoCL ISE version 14.7 Version 14.7 ISE 30-Day Eval,version 14.7 mE5 marathon VF2 ISE version 14.7, Vivado version 2016.1 or higher<sup>a</sup> Version 14.7 Version 2016.1 or higher<sup>a</sup> mE5 marathon VCX-QP ISE version 14.7, Vivado version 2016.1 or higher<sup>a</sup> Version 14.7 Version 2016.1 or higher<sup>a</sup> LightBridge VCL ISE version 14.7, Vivado version 2016.1 or higher<sup>a</sup> Version 14.7 Version 2016.1 or higher<sup>a</sup> mE5 marathon VCL ISE version 14.7, Vivado version 2016.1 or higher<sup>a</sup> <sup>b</sup> Version 14.7 Version 2016.1 or higher<sup>a</sup> mE5 marathon VCLx ISE version 14.7 Version 2016.1 or higher<sup>b</sup> Vivado 30-Day Eval, version 2016.1 or higher<sup>a</sup> <ol> <li> <p>Basler recommends to use Vivado 2017.4. Basler only tested until and including Vivado 2020.2 and thus recommends to use a version between 2016.1 and 2020.2.\u00a0\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9\u21a9</p> </li> <li> <p>In VisualApplets 3.2.1, applets for the platforms mE5-MA-VCL and mE5-MA-VCLx cannot be built with Vivado 2020.2. For further information, see Known Issues VisualApplets Release 3.2.1, entry 28., issue n\u00b0 9848.\u00a0\u21a9\u21a9</p> </li> </ol>"},{"location":"tcl-command-reference.html","title":"Tcl Command Reference","text":"<p>Case Sensitivity and Slashes</p> <p>The following commands are case sensitive. Use forward slashes to indicate paths.</p> <p>Info</p> <p>The notation used below for describing the parameters of individual commands is based on the Wirth Syntax Notation (WSN) :</p> <ul> <li>Parameter names in curly brackets denote that you can specify no value, one value, or multiple values for this parameter in the command line.</li> <li>Parameter names in square brackets denote optional parameters.</li> </ul>"},{"location":"tcl-command-reference.html#creating-loading-and-saving-designs","title":"Creating, Loading, and Saving Designs","text":""},{"location":"tcl-command-reference.html#loaddesign","title":"LoadDesign","text":"Command Syntax LoadDesign <code>FileName</code> <p>Command for loading the design <code>FileName</code>. Specify in <code>FileName</code> the path to the file in your file system and the file name itself. Don't forget to state the file name extension (*.va or *.tcl). Use slashes for indicating the path to the design file.</p> <p>Example: <code>LoadDesign c:/VA_TCL/BaseAreaGray8.va</code></p> <p>If there is already a design loaded: Close the currently loaded design via command <code>CloseDesign</code> before using command <code>LoadDesign</code>.</p>"},{"location":"tcl-command-reference.html#createdesign","title":"CreateDesign","text":"Command Syntax CreateDesign <code>Name</code> <code>Platform</code> <p>Command for creating a new design with the name Name for a hardware platform Platform. For specifying the target platform of the design, you can either use</p> <ul> <li>the VisualApplets library name for the platform (e.g., \"iF-CXP12-Q\"), or</li> <li>the full name of the platform (e.g., \"imaFlex CXP-12 Quad\"). Don't forget to set the full name in quotes as required by Tcl syntax for arguments that contain spaces.</li> </ul> <p>Using capitals in the names has no effect.</p>"},{"location":"tcl-command-reference.html#savedesign","title":"SaveDesign","text":"Command Syntax SaveDesign <code>FileName</code> [<code>SaveOption</code>] <p>Command for saving a design under <code>FileName</code>. Specify in <code>FileName</code> the path to the file and the file name itself. Use slashes for indicating the path to the design file.</p> <p>Don't forget to add the file name extension to the file name.</p> <ul> <li>If you specify file extension \".va\", your design is saved in the standard VisualApplets design format. All contents of the file are saved. Use the *.va file format as primary data format for your VisualApplets designs.</li> <li>If you specify file extension \".tcl\" in <code>FileName</code>, a Tcl script is exported. Some contents of the design can't be exported.</li> </ul> <p>If you want to overwrite an existing file, set the optional parameter <code>SaveOption</code> to <code>overwrite</code>.</p> <p>The following information is lost during export to Tcl script:</p> <ul> <li>The local modifications you made in a user library element instance (to adapt the instance to the surrounding design) are lost. If you re-import a Tcl script into VisualApplets, the instance is inserted as a fresh copy of the user library element. The content of the instance in your design has not been saved in Tcl.</li> <li>The text content of info boxes is kept in Tcl format. However, the formatting of info boxes is lost.</li> </ul>"},{"location":"tcl-command-reference.html#changeplatform","title":"ChangePlatform","text":"Command Syntax ChangePlatform <code>Platform</code> <code>FileName</code> [<code>SaveOption</code>] <p>Command for converting the current design to another hardware platform <code>Platform</code> and saving the converted design as <code>FileName</code>.</p> <p>To get an overview over all available hardware platforms, enter <code>ChangePlatform ?</code> - a list of the names of all available hardware platforms is returned. The currently selected hardware platform is displayed in the first entry of the list.</p> <p>Specify the name of the desired hardware platform in parameter <code>Platform</code>. For specifying the target platform of the design, you can either use</p> <ul> <li>the VisualApplets library name for the platform (e.g., \"iF-CXP12-Q\"), or</li> <li>the full name of the platform (e.g., \"imaFlex CXP-12 Quad\").</li> </ul> <p>Using capitals in the names has no effect. Specify in <code>FileName</code> the path to the file (using forward slashes), the file name itself, and the file name extension. If you want to overwrite an existing file, set the optional parameter <code>SaveOption</code> to <code>overwrite</code>.</p>"},{"location":"tcl-command-reference.html#closedesign","title":"CloseDesign","text":"Command Syntax CloseDesign [<code>Mode</code>] <p>Command for closing the currently open design.</p> <p>If you set the optional parameter <code>Mode</code> to <code>Discard</code>, the design will be closed even if it contains changes that you didn't save yet. The unsaved changes will be discarded.</p> <p>If you use <code>CloseDesign</code> without using parameter <code>Mode</code> although the design contains changes that you didn't save yet, the command will be terminated and you receive an according error message.</p>"},{"location":"tcl-command-reference.html#setdesignproperty","title":"SetDesignProperty","text":"Command Syntax SetDesignProperty <code>Key</code> <code>Value</code> <p>Use this command to enter design properties for the currently loaded design.</p> <p>There are four keys you can use:</p> <ul> <li><code>ProjectName</code> (the name you want the project to give)</li> <li><code>Version</code> (version of the design)</li> <li><code>Description</code> (description of the project).</li> <li> <p><code>TargetRuntime</code> (specify here the operating system that will be used on the host PC(s) running this applet on the frame grabber.)</p> <p>The following values are allowed:</p> <ul> <li>Win64</li> <li>Win32</li> <li>Linux64</li> <li>Linux32</li> </ul> </li> </ul> <p>Example:</p> <pre><code>SetDesignProperty TargetRuntime Win64\n</code></pre>"},{"location":"tcl-command-reference.html#setdesignclock","title":"SetDesignClock","text":"Command Syntax SetDesignClock <code>NewFrequency</code> <p>Command for setting the basic clock frequency of the FPGA (in MHz).</p>"},{"location":"tcl-command-reference.html#developing-a-design","title":"Developing a Design","text":""},{"location":"tcl-command-reference.html#createprocess","title":"CreateProcess","text":"Command Syntax CreateProcess <p>Command for creating a new process. VisualApplets automatically numbers new processes.</p>"},{"location":"tcl-command-reference.html#deleteprocess","title":"DeleteProcess","text":"Command Syntax DeleteProcess <code>ProcName</code> <p>Command for deleting a process of the name <code>ProcName</code>.</p> <p>Example: <code>DeleteProcess Process1</code></p>"},{"location":"tcl-command-reference.html#createmodule","title":"CreateModule","text":"Command Syntax CreateModule <code>OperatorType</code> <code>FullModuleName</code> [<code>InPortMultiplicity</code> [<code>OutPortMultiplicity</code> {<code>NamedPortMultiplicity</code>}]]<code>xPos</code> <code>yPos</code> <p>Command for creating an instance (module) of an operator <code>OperatorType</code>, and for positioning the module in the design window.</p> <p>In <code>OperatorType</code>, simply state the name of the specific operator you want to create an instance from. You do not must specify the library the operator belongs to.</p> <p>With <code>FullModuleName</code> you define the module's hierarchical position within the design.</p> <p><code>FullModuleName</code> has the following syntax:</p> <p><code>&lt;HierLevelPath&gt;/&lt;ModuleName&gt;</code></p> <ul> <li><code>HierLevelPath</code> you use to define the path to a specific hierarchical level in the design. Start on process level. Use forward slashes.</li> <li><code>ModuleName</code> you use for specifying the name you want the module to have. Alternatively, you can leave <code>ModuleName</code> empty. In this case, you must terminate <code>FullModuleName</code> with a slash; the module will be named automatically.</li> </ul> <p>The position of the module in the design window you define via parameters <code>xPos</code> and <code>yPos</code>.</p> <p>Example:</p> <pre><code>CreateModule CxpCamera Process0/cam 123 163\n</code></pre> <p>The return value of function <code>CreateModule</code> is <code>FullModuleName</code> (i.e., the full hierarchical path to the module including the module name).</p> <p>Using the optional parameters <code>InPortMultiplicity</code> and <code>OutPortMultiplicity</code>:</p> <p>Many operators are instantiated with a fix number of ports. On the other hand, there are operators with a variable number of ports. During instantiation of an operator with a variable number of ports, you can define how many ports the module will have.</p> <p>For example, when instanciating operator <code>BRANCH</code>, you can define how many output ports the instance will have:</p> <p></p> <p>Thus, the number of output ports O is variable. Ports that have a variable number of ports we call multiports.</p> <p>Multiports are identified via their base name. In <code>BRANCH</code>, for example, the base name of the output ports is <code>O</code>. Via an index that is added to the base name, a specific port can be identified and addressed:</p> <p></p> <p>When using command <code>CreateModule</code>, you can use the optional value pair <code>InPortMultiplicity</code> and <code>OutPortMultiplicity</code> to specify the multiplicity of the vector inputs and the vector outputs of a module. This way, you can define the number of ports in instances (modules) of operators that have a variable number of ports, like, for example, operators <code>BRANCH</code> or <code>ADD</code>.</p> <p>Example:</p> <pre><code>CreateModule BRANCH Process0/branchz 1 3 43 123\n</code></pre> <p></p> <p>Defaults: If you don't use <code>InPortMultiplicity</code> and <code>OutPortMultiplicity</code>, or if you set them to 0, the module is created with the default number of inports and outports (i.e., setting one or both of the two values to <code>0</code> does not result in zero inports or zero outports.). How many ports are created per default depends on the operator type.</p> <p>Examples:</p> <pre><code>CreateModule BRANCH Process0/branch 43 123\n</code></pre> <p></p> <p>The default number of ports is created, 1 input and 2 output ports.</p> <pre><code>CreateModule BRANCH Process0/branch3 0 3 43 123\n</code></pre> <p></p> <p>1 input (default) and 3 output ports are created.</p> <pre><code>CreateModule BRANCH Process0/branch3 3 3 43 123\n</code></pre> <p></p> <p>1 input and 3 output ports are created. The definition of 3 input ports is ignored, as the operator type allows only 1 input.</p> <pre><code>CreateModule BRANCH Process0/branch4 0 4 43 123\n</code></pre> <p></p> <p>Optional parameter <code>NamedPortMultiplicity</code>: For operators that have various kinds of multiports (i.e., operators that have other multiports than input I or output O), you can use parameter <code>NamedPortMultiplicity</code> to specify the base name of the multiport you want to have on the module, and to specify the multiplicity (number) of this multiport. The format of <code>NamedPortMultiplicity</code> is <code>MultiportBaseName:Number</code>. You can use <code>NamedPortMultiplicity</code> multiple times in one command line. Using <code>NamedPortMultiplicity</code> overrules anything you may have stated in parameters <code>InPortMultiplicity</code> or <code>OutPortMultiplicity</code>.</p> <p>Example:</p> <pre><code>CreateModule BRANCH Process0/branch 0 0 O:3 100 100\n</code></pre> <p>The example command translates as follows: Create an instance (module) of operator <code>BRANCH</code>. Place it in process 0 on top level and give it the name branch. Provide three output ports (multiport base name O for output) and position the module in the design window at position y=100 pixel and x= 100 pixel.</p> <p>For <code>MultiportBaseName</code>, use the base name of the multiport as you find it on the VA GUI. The <code>MultiportBaseName</code> name is displayed in the dialog that appears when instantiating an operator that has a varying number of ports. The multiport base name is the short name of the multiport (displayed in parantheses in the GUI).</p> <p></p> <p>The multiport base name here is <code>I</code>.</p> <p>You also find the multiport base name in the mouse over information to a port:</p> <p></p> <p>Multiport base name here is I (followed by the index identifying the individual instances of multiport <code>I</code> on the module).</p>"},{"location":"tcl-command-reference.html#instuserliboperator","title":"InstUserLibOperator","text":"Command Syntax InstUserLibOperator <code>LibName</code> <code>OperatorName</code> <code>FullModuleName</code> <code>xPos</code> <code>yPos</code> <p>Command for instantiating a user library element. Specify the user library via the parameter <code>LibName</code>, the name of the element (operator) in the library via the parameter <code>OperatorName</code>, the name you want to give the module in your design and where you want to place the module in the hierarchy via the parameter <code>FullModuleName</code>, as well as the position of the module in the design window  via the parameters <code>xPos</code>, and <code>YPos</code>.</p>"},{"location":"tcl-command-reference.html#instcustomliboperator","title":"InstCustomLibOperator","text":"Command Syntax InstCustomLibOperator <code>LibName</code> <code>OperatorName</code> <code>FullModuleName</code> <code>xPos</code> <code>yPos</code> <p>Command for instantiating a custom library element. Specify the user library via the parameter <code>LibName</code>, the name of the element (operator) in the library via the parameter <code>OperatorName</code>, the name you want to give the module in your design and where you want to place the module in the hierarchy via the parameter <code>FullModuleName</code>, as well as the position of the module in the design window  via the parameters <code>xPos</code>, and <code>YPos</code>.</p>"},{"location":"tcl-command-reference.html#deletemodule","title":"DeleteModule","text":"Command Syntax DeleteModule <code>FullModuleName</code> <p>Command for deleting the module <code>FullModuleName</code>.</p> <p><code>FullModuleName</code> has the following syntax: <code>&lt;HierLevelPath&gt;/&lt;ModuleName&gt;</code>.</p> <ul> <li><code>HierLevelPath</code> you use to specify the path to the hierarchical level in the design where the module is located. Start on process level. Use forward slashes.</li> <li><code>ModuleName</code> you use to specify the name of the module you want to delete.</li> </ul> <p>Simulation modules can't be deleted via this command. For deleting simulation modules, use the command <code>DeleteSimModule</code>.</p>"},{"location":"tcl-command-reference.html#connectmodules","title":"ConnectModules","text":"Command Syntax ConnectModules <code>FromModule</code> <code>FromModuleOutputPort</code> <code>ToModule</code> <code>ToModulePort</code> [<code>x1</code> [<code>y2</code> <code>x3</code>]] <p>Command for connecting module ports.</p> <p>The parameters <code>FromModule</code> and <code>ToModule</code> are hierarchical names  with the syntax: <code>&lt;HierLevelPath&gt;/&lt;ModuleName&gt;</code>.</p> <p>Inner hierarchical box nodes (i.e. inner nodes for connecting hierarchical box ports) are identified via the prefixes <code>INBOUND#</code> or <code>OUTBOUND#</code>.</p> <p>Example: The two inbound nodes of the hierarchical box in the figure below must be addressed by <code>INBOUND#I000</code> and <code>INBOUND#I001</code>.</p> <p></p> <p>Via the optional parameters <code>x1</code>, <code>y2</code>, and <code>x3</code> you can define the geometry of the connecting polygon: horizontal line from <code>FromModuleOutputPort</code> to X position <code>x1</code>, vertical line to Y position <code>y2</code>, horizontal line to X position <code>x3</code>, vertical line to height of <code>ToModulePort</code>, horizontal line to <code>ToModulePort</code>.</p> <p></p> <p>Example:</p> <pre><code>ConnectModules Process0/CxpCamera O Process0/FrameBufferMultiRoi I 90 500 120\n</code></pre> <p></p>"},{"location":"tcl-command-reference.html#disconnectmodules","title":"DisconnectModules","text":"Command Syntax DisconnectModules <code>FullModuleName</code> <code>ModulePort</code> <p>Command for deleting the link that is connected to port <code>ModulePort</code> of module <code>FullModuleName</code>.</p> <p>Example:</p> <pre><code>DisconnectModules Process0/Cam1 O\n</code></pre>"},{"location":"tcl-command-reference.html#createcomment","title":"CreateComment","text":"Command Syntax CreateComment <code>FullBoxName</code> <code>Text</code> <code>xPos</code> <code>yPos</code> <p>Command for creating a comment box.</p> <p>The syntax of <code>FullBoxName</code> is <code>&lt;HierLevelPath&gt;/&lt;BoxName&gt;</code>.</p> <ul> <li><code>HierLevelPath</code> you use to define the path to a specific hierarchical level in the design. Start on process level. Use forward slashes.</li> <li><code>BoxName</code> you use for specifying the name you want the comment box to have. Alternatively, you can leave <code>BoxName</code> empty. In this case, you must terminate <code>FullBoxName</code> with a slash; the module will be named automatically.</li> </ul> <p>Example:</p> <pre><code>CreateComment Process0/MyComment \"This is my comment.\" 400 400\n</code></pre> <p>For the comment box content <code>Text</code> you can use Unicode characters. Don't forget to set the comment in quotes. If you use characters that are not part of ASCII, use the according TCL syntax to represent Unicode, for example:</p> <pre><code>[encoding convertfrom utf-8 \"A-Umlaut: \\xc3\\x84\"]\n</code></pre> <p>The position of the comment box in the design window you define via the parameters <code>xPos</code> and <code>yPos</code>.</p> <p>The return value of function <code>CreateComment</code> is <code>FullBoxName</code> (the full hierarchical path to the comment box including the name of the comment box).</p>"},{"location":"tcl-command-reference.html#deletecomment","title":"DeleteComment","text":"Command Syntax DeleteComment <code>FullBoxName</code> <p>Command for deleting comment box <code>FullBoxName</code>.</p> <p>The syntax of <code>FullBoxName</code> is <code>&lt;HierLevelPath&gt;/&lt;BoxName&gt;</code>.</p> <ul> <li><code>HierLevelPath</code> you use to specify the path to the hierarchical level in the design where the comment box is located. Start on process level. Use forward slashes.</li> <li><code>BoxName</code> you use to specify the name of the comment box you want to delete.</li> </ul> <p>Example:</p> <pre><code>DeleteComment Process0/MyComment\n</code></pre> <p>Box name information: To get the name of the comment box you want to delete, you can use TCL to query which boxes are placed in a design, see TCL example QueryDesign.tcl in your VisualApplets installation folder at <code>&lt;VA installation directory&gt;\\Examples\\AdvancedVAFunctions\\Tcl Scripting\\QueryDesign.tcl</code>.</p>"},{"location":"tcl-command-reference.html#parameterizing-operators-and-links","title":"Parameterizing Operators and Links","text":""},{"location":"tcl-command-reference.html#setmoduleparam","title":"SetModuleParam","text":"Command Syntax SetModuleParam <code>FullModuleName</code> <code>ParameterName</code> [<code>FieldIndex</code>] <code>Value</code> {<code>OtherValues</code>} <p>Command for setting a module parameter.</p> <p>Info</p> <p>Use this command only for setting an existent parameter to a specific value. You can't use this command for creating metadata parameters. (For creating new metadata parameters, use command <code>SetParamString</code> instead.)</p> <p>Example:</p> <pre><code>SetModuleParam Process0/HierchBox1/module6 XLength 512\n</code></pre> <p>Field parameters: If you refer to a field parameter, you must specify parameter <code>FieldIndex</code> before specifying a <code>Value</code>. Only when referring to field parameters, you can specify further values after <code>Value</code>.</p> <p>Example for editing field parameters:</p> <p>Before entering the command:</p> <p></p> <p>Entering the command</p> <pre><code>SetModuleParam Process0/module3 LUTcontent 4 12 13 14\n</code></pre> <p>has the following result:</p> <p></p> <p>Command <code>SetModuleParam</code> has the same functionality as (depending on the parameter you use) the commands <code>SetParamInt</code>, <code>SetParamFloat</code>, <code>SetParamEnum</code>, <code>SetParamString</code>, <code>SetParamIntField</code>, and <code>SetParamFloatField</code>. However, these commands are for export only.</p> <p>Use <code>SetModuleParam</code> when you are writing scripts manually.</p> <p>Exception: If you want to add a new metadata parameter, you must use <code>SetParamString</code> when writing scripts manually. See definition of command <code>SetParamString</code>.</p>"},{"location":"tcl-command-reference.html#setmoduleparamproperty","title":"SetModuleParamProperty","text":"Command Syntax SetModuleParamProperty <code>FullModuleName</code> <code>ParameterName</code> <code>PropertyName</code> <code>PropertyValue</code> {<code>OtherPropertyValue</code>} <p>Command for changing the properties of a module parameter. This command may replace <code>SetModuleParamType</code>. Single property names may have multiple values. You can change the following properties:</p> <p><code>access</code>: You can list several flags here as value:</p> <ul> <li><code>write</code>: If the parameter can be switched in this direction, (for instance in the operator <code>LinkParamTranslator</code>), it becomes a write-parameter.</li> <li><code>read</code>: If the parameter can be switched in this direction, (for instance in the operator <code>LinkParamTranslator</code>), it becomes a read-parameter.</li> <li><code>dynamic</code>: If the parameter can be either dynamic or static, it hereby becomes a dynamic parameter (this replaces the command <code>SetParamDynamic</code>).</li> <li><code>static</code>: If the parameter can be either dynamic or static, it hereby becomes a static parameter (this replaces the command <code>SetParamStatic</code>).</li> </ul> <p><code>position</code>: Definition of an integer value for the parameter <code>PropertyValue</code>, which defines the position of the parameter in a list of parameters in a hierarchical box.</p>"},{"location":"tcl-command-reference.html#setparamint","title":"SetParamInt","text":"Command Syntax SetParamInt <code>FullModuleName</code> <code>ParameterName</code> <code>Value</code> <p>Used for TCL export only. Command for setting an integer parameter.</p> <p>Info</p> <p>This command is used in TCL export from VisualApplets to a *.tcl file.</p> <p>Don't use this command in scripts you write manually. Use command <code>SetModuleParam</code> instead.</p>"},{"location":"tcl-command-reference.html#setparamfloat","title":"SetParamFloat","text":"Command Syntax SetParamFloat <code>FullModuleName</code> <code>ParameterName</code> <code>Value</code> <p>Used for TCL export only. Command for setting a floating point parameter.</p> <p>Info</p> <p>This command is used in TCL export from VisualApplets to a *.tcl file.</p> <p>Don't use this command in scripts you write manually. Use command <code>SetModuleParam</code> instead.</p>"},{"location":"tcl-command-reference.html#setparamenum","title":"SetParamEnum","text":"Command Syntax SetParamEnum <code>FullModuleName</code> <code>ParameterName</code> <code>Value</code> <p>Used for TCL export only. Command for setting an addressed enum parameter. <code>Value</code> is the string of the enum value.</p> <p>Example (for an instance of operator <code>SetSignalStatus</code> that is placed on level <code>Process0</code> and has the name <code>SetSigSt</code>):</p> <pre><code>SetParamEnum Process0/SetSigSt Mode High\n</code></pre> <p>Sets parameter <code>Mode</code> of operator <code>SetSigSt</code> that is located in <code>Process0</code> to <code>High</code>.</p> <p>Info</p> <p>This command is used in TCL export from VisualApplets to a *.tcl file.</p> <p>Don't use this command in scripts you write manually. Use command <code>SetModuleParam</code> instead.</p>"},{"location":"tcl-command-reference.html#setparamstring","title":"SetParamString","text":"Command Syntax SetParamString <code>FullModuleName</code> <code>ParameterName</code> <code>Value</code> <p>Use this command to define metadata parameters for a specific module.</p> <p>In TCL export files, command <code>SetParamString</code> is used for setting any string parameter, even if it's an existent module parameter. However, this isn't practicable in scripts you write manually.</p> <p>Info</p> <p>When writing your own scripts, don't use this command for setting an existent module parameter to a new value, even if the module parameter is of type string.</p> <p>For setting an existent module parameter to a new value, always use command <code>SetModuleParam</code> in your scripts.</p>"},{"location":"tcl-command-reference.html#setparamintfield","title":"SetParamIntField","text":"Command Syntax SetParamIntField <code>FullModuleName</code> <code>ParameterName</code> <code>Index</code> <code>Value</code> {<code>OtherValues</code>} <p>Used for TCL export only. Command for setting a field parameter of type integer. Setting field <code>Index</code> to <code>Value1</code>, the following fields are populated with the following values in the given order.</p> <p>Info</p> <p>This command is used in TCL export from VisualApplets to a *.tcl file.</p> <p>Don't use this command in scripts you write manually. Use command <code>SetModuleParam</code> instead.</p>"},{"location":"tcl-command-reference.html#setparamfloatfield","title":"SetParamFloatField","text":"Command Syntax SetParamFloatField <code>FullModuleName</code> <code>ParameterName</code> <code>Index</code> <code>Value</code> {<code>OtherValues</code>} <p>Used for TCL export only. Command for setting a field parameter of type float. Setting field <code>Index</code> to <code>Value1</code>, the following fields are populated with the following values in the given order.</p> <p>Info</p> <p>This command is used in TCL export from VisualApplets to a *.tcl file.</p> <p>Don't use this command in scripts you write manually. Use command <code>SetModuleParam</code> instead.</p>"},{"location":"tcl-command-reference.html#setparamstatic","title":"SetParamStatic","text":"Command Syntax SetParamStatic <code>FullModuleName</code> <code>ParameterName</code> <p>Used for TCL export only. Command for making a parameter static. If a parameter can be static as well as dynamic, in most cases the parameter is set to dynamic per default. Use this command to set such a parameter to static.</p> <p>Info</p> <p>This command is used in TCL export from VisualApplets to a *.tcl file.</p> <p>Don't use this command in scripts you write manually. Use command <code>SetModuleParamType</code> instead.</p>"},{"location":"tcl-command-reference.html#setparamdynamic","title":"SetParamDynamic","text":"Command Syntax SetParamDynamic <code>FullModuleName</code> <code>ParameterName</code> <p>Used for TCL export only. Command for making a parameter dynamic. Works only if the parameter can be dynamic at all.</p> <p>Info</p> <p>This command is used in TCL export from VisualApplets to a *.tcl file.</p> <p>Don't use this command in scripts you write manually. Use command <code>SetModuleParamType</code> instead.</p>"},{"location":"tcl-command-reference.html#setmoduleparamtype","title":"SetModuleParamType","text":"Command Syntax SetModuleParamType <code>FullModuleName</code> <code>ParameterName</code> <code>TypeFlag</code> {<code>OtherTypeFlags</code>} <p>Command for changing the type of a parameter. The following type flags are available:</p> <ul> <li><code>Dynamic</code>: If the parameter can be dynamic or static, this flag makes the parameter a dynamic parameter (replaces command <code>SetParamStatic</code>).</li> <li><code>Static</code>: If the parameter can dynamic or static, this flag makes the parameter a static parameter (replaces command <code>SetParamStatic</code>).</li> </ul> <p><code>Dynamic</code> and <code>Static</code> mutually exclude each other.</p> <p>When using type flags <code>Dynamic</code> or <code>Static</code>, this command has the same functionality as the commands <code>SetParamStatic</code> and <code>SetParamDynamic</code>. However, use <code>SetModuleParamType</code> when you are writing scripts manually.</p>"},{"location":"tcl-command-reference.html#setlinkparam","title":"SetLinkParam","text":"Command Syntax SetLinkParam <code>FullModuleName</code> <code>PortName</code> <code>ParameterName</code> <code>Value</code> {<code>OtherParameterName</code> <code>OtherParameterValue</code>} <p>Command for configuring the format of links. The link is identified via the connection node (port) of a module. The names of the link format parameters are the same as in the VisualApplets GUI.</p> <p>Info</p> <p>When writing your TCL script manually, the command is only applicable for parameters that can be changed. If you try to set a link parameter that can't be changed, you will get an according error message:</p> <p></p>"},{"location":"tcl-command-reference.html#setresourcemapping","title":"SetResourceMapping","text":"Command Syntax SetResourceMapping <code>FullModuleName</code> <code>ResourceName</code> [<code>Index</code>] <code>NewMapping</code> <p>Command for changing the mapping of resources to a module. The resource <code>ResourceName</code> will be mapped to the new index <code>NewMapping</code>. In case the module allocates multiple resources of the same type, use the optional parameter <code>Index</code> for selecting the resource.</p>"},{"location":"tcl-command-reference.html#splitlink","title":"SplitLink","text":"Command Syntax SplitLink <code>FullModuleName</code> <code>PortName</code> [<code>Number</code>] <p>Command for creating a module <code>BRANCH</code>. The new branch module is inserted on the link that goes out of module <code>FullModuleName</code> on port <code>NodeName</code>. The new branch module has <code>Number</code> outgoing ports. If you don't use the optional parameter <code>Number</code>, the new branch module has two out ports.</p> <p>The return value of function <code>SplitLink</code> is the <code>FullModuleName</code> of the new branch module (full hierarchical path to the module, including the module name).</p>"},{"location":"tcl-command-reference.html#querying-design-structure-and-design-details","title":"Querying Design Structure and Design Details","text":""},{"location":"tcl-command-reference.html#getdesignproperty","title":"GetDesignProperty","text":"Command Syntax GetDesignProperty <code>PropertyName</code> <p>This command retrieves design properties. You can use the following values for <code>PropertyName</code>:</p> <ul> <li><code>ProjectName</code>:name of the project</li> <li><code>FileName</code>: path to and name of the currently loaded design file *.va</li> <li><code>HardwarePlatform</code>: library name of target hardware platform, for example iF-CXP12-Q</li> <li><code>Version</code>: version of the design</li> <li><code>Description</code>: description of the project</li> <li><code>Loaded</code>: design is loaded (1 or 0)</li> </ul> <p>Design property <code>Loaded</code> can be requested while no design is loaded at all. This doesn't cause an error message. Requesting any other design property while no design is loaded causes an error message.</p>"},{"location":"tcl-command-reference.html#getdesignclock","title":"GetDesignClock","text":"Command Syntax GetDesignClock <p>This command returns the basic clock frequency of the FPGA (in MHz).</p>"},{"location":"tcl-command-reference.html#getprocesses","title":"GetProcesses","text":"Command Syntax GetProcesses <p>This command returns a list with the names of all processes of the design.</p>"},{"location":"tcl-command-reference.html#getsubmodules","title":"GetSubModules","text":"Command Syntax GetSubModules <code>HierarchyName</code> <p>This command returns a list with the names of the modules that are located in the requested hierarchy <code>HierarchyName</code>.</p> <p>For each sub-module, the full hierarchical name is listed.</p>"},{"location":"tcl-command-reference.html#getparenthier","title":"GetParentHier","text":"Command Syntax GetParentHier <code>FullElementName</code> <p>This command returns the hierarchical name (<code>FullModuleName</code>) of the parent of stated element <code>FullElementName</code>, that is, the <code>FullModuleName</code> of the hierarchical element in which element <code>FullElementName</code> is located.</p> <p><code>FullElementName</code> can be a module, a simulation module, or a comment box.</p>"},{"location":"tcl-command-reference.html#getmodules","title":"GetModules","text":"Command Syntax GetModules <code>Scope</code> <code>Specifier</code> {<code>ModuleList</code>} <p>This command filters specific modules in the design. The command returns a list with modules that have the characteristic you specify via <code>Scope</code> and <code>Specifier</code>. The list contains the <code>FullModuleName</code> for all found modules (path to modules including the individual module name). If you don't want to search design-wide, but only in a specific set of modules, you can specify these modules in <code>ModuleList</code> (via their <code>FullModuleName</code>).</p> <p><code>Scope</code> can have the following values:</p> <ul> <li><code>pattern</code>: Use <code>Specifier</code> as a wildcard expression for <code>FullModuleName</code>. If you state \"*\" as specifier, all modules of the design are returned.</li> <li><code>flat</code>: Use <code>Specifier</code> as a wildcard expression for the <code>FullModuleName</code> of modules (like with pattern). Hierarchical boxes will not be returned.</li> <li><code>ordered</code>: Returns all modules of the design. Use <code>Specifier</code> to define a sorting pattern. You have the following options:<ul> <li><code>path</code>: modules are sorted by their position in the design graph (i.e., in the order of the data stream as it runs through the modules during simulation).</li> <li><code>name</code>: modules are sorted alphabetically by their <code>FullModuleName</code>.</li> </ul> </li> <li><code>operatorType</code>:  Use <code>Specifier</code> to define the operator type of the modules you are looking for (\"O\", \"M\", \"P\", \"O+P\", \"M+P\", \"unknown\").</li> <li><code>operator</code>: For getting all instances of a specific operator. Use <code>Specifier</code> to name the operator name (for example, \"NOP\").</li> <li><code>libraryType</code>: Use <code>Specifier</code> to define a specific library type. All modules in the design that are instances of operators contained in libraries of this type are returned. The following values are allowed: operator, user, and custom (see also <code>GetModuleProperty</code>).</li> <li><code>library</code>: Use <code>Specifier</code> to define a specific library. All modules that are instances of operators of this library are returned.</li> <li><code>version</code>: Use <code>Specifier</code> to define a specific operator version. All modules that are instances of operators of this version are returned.</li> </ul>"},{"location":"tcl-command-reference.html#getmoduleports","title":"GetModulePorts","text":"Command Syntax GetModulePorts <code>FullModuleName</code> [<code>Scope</code>] <p>This command returns a list with the names of all ports of the specified module. You can use the optional parameter <code>Scope</code> to filter for specific ports:</p> <ul> <li><code>inputs</code>: only the input ports are returned</li> <li><code>outputs</code>: only the output ports are returned</li> <li><code>all</code>: all ports of the module are returned (default)</li> </ul>"},{"location":"tcl-command-reference.html#getmoduleportproperty","title":"GetModulePortProperty","text":"Command Syntax GetModulePortProperty <code>FullModuleName</code> <code>PortName</code> <code>Property</code> <p>This command retrieves the properties of a module port. The following values for <code>Property</code> are available:</p> <ul> <li><code>isConnected</code>: Returns 1 if port is connected; otherwise 0.</li> <li><code>position</code>: Returns position of specified port in the diagram (design window) as a list (<code>xPos</code>, <code>yPos</code>). If <code>PortName</code> specifies an inner hierarchical box node (for example, <code>INBOUND#I000</code>), the position of this node within the hierarchical box design window is returned.</li> </ul>"},{"location":"tcl-command-reference.html#getmoduleproperty","title":"GetModuleProperty","text":"Command Syntax GetModuleProperty <code>FullModuleName</code> <code>Property</code> <p>This command returns the properties of a module.</p> <p>The following values for <code>Property</code> are available:</p> <ul> <li><code>status</code>: Returns 0 if module isn't in error status; otherwise returns error code.</li> <li><code>operator</code>: Returns name of operator the module is an instance of, for example <code>BRANCH</code>.</li> <li><code>operatorType</code>: Returns operator type (O, P, M, unknown). \"Unknown\" is returned for hierarchical boxes and user library modules.</li> <li><code>libraryType</code>: Returns the library type of the library the operator stems from. One of the following values is returned: <code>operator</code>, <code>user</code>, <code>custom</code>.</li> <li><code>version</code>: Returns the version of the operator the module is an instance of.</li> <li><code>type</code>: Returns the module type. One of the following values is returned: <code>process</code>, <code>hierBox</code>, <code>operator</code>, <code>user</code>, <code>custom</code>.</li> <li><code>isHierModule</code>: Returns 1 if the stated module is capable of containing submodules; returns 0 if the stated module can't have sub-modules.</li> <li><code>isProtected</code>: Returns 1 if the module is an instance of a protected library element.</li> <li><code>library</code>: Returns the name of the library the operator stems from.</li> <li><code>position</code>: Returns the position in a design window as a list (<code>xPos</code>, <code>yPos</code>).</li> <li><code>resources</code>: Returns a list of pairs (<code>ResourceName</code>,<code>ResourceMapping</code>)</li> <li><code>name</code>: Returns the module name.</li> </ul>"},{"location":"tcl-command-reference.html#getmoduleparams","title":"GetModuleParams","text":"Command Syntax GetModuleParams <code>FullModuleName</code> {<code>ParameterNames</code>} <p>Returns a list of module parameters and their current values.</p> <p>If you want to get all parameters of the module together with the currently set values, use command <code>GetModuleParams</code> only with parameter <code>FullModuleName</code>.</p> <p>Example:</p> <p></p> <p>If you want to get only the values of specific parameters, you can optionally limit the output to the parameters <code>{ParameterNames}</code>. The order of the output corresponds to the order of the parameter names you state in <code>{ParameterNames}</code>.</p> <p>Example:</p> <p></p> <pre><code>puts [GetModuleParams Process0/FrameBufferMultiRoi RamDataWidth MaxFrameCount]\n</code></pre>"},{"location":"tcl-command-reference.html#getmoduleparamproperty","title":"GetModuleParamProperty","text":"Command Syntax GetModuleParamProperty <code>FullModuleName</code> <code>ParameterName</code> <code>Property</code> <p>Command for retrieving parameter properties.</p> <p>For the parameter <code>Property</code>, the following values are available:</p> <ul> <li><code>status</code>: Returns 0, if the parameter isn't in error status; otherwise returns error code.</li> <li><code>type</code>: Returns the parameter type: <code>int</code>, <code>intField</code>, <code>float</code>, <code>floatField</code>, <code>enum</code>, or <code>string</code>.</li> <li><code>access</code>: Returns direction of access: <code>write</code> or <code>read</code>).</li> <li><code>unit</code>: Returns the unit of the parameter.</li> <li><code>range</code>: For integer and float data types, the command returns the value range as a list containing the three entries <code>Min</code>, <code>Max</code>, <code>Step</code>. For enum parameters, it returns a list of pairs of enum names and enum values.</li> <li><code>size</code>: Returns the size of the field. Only for <code>IntField</code> and <code>FloatField</code> parameters.</li> <li><code>isDynamic</code>: Returns 1 if the requested parameter is dynamic; otherwise returns 0.</li> <li><code>isStatic</code>: Returns 1 if the requested parameter is static; otherwise returns 0.</li> <li><code>isEditable</code>: Returns 1 if the requested parameter can be edited; otherwise returns 0.</li> </ul>"},{"location":"tcl-command-reference.html#getlinkparams","title":"GetLinkParams","text":"Command Syntax GetLinkParams <code>FullModuleName</code> <code>PortName</code> {<code>ParameterNames</code>} <p>Returns a list of link parameter names and the currently set values for a specific link. The link is identified via the connection node (port) of a module. The returned list states value pairs <code>&lt;ParameterName&gt;&lt;Value&gt;</code> that correspond to the pairs you would use to set link parameters via <code>SetLinkParam</code>.</p> <p>If you want to get all parameters of the link together with the currently set values, use command <code>GetLinkParams</code> only with parameters <code>FullModuleName</code> and <code>PortName</code>.</p> <p>If you want to get only the values of specific parameters, you can optionally limit the output to the parameters <code>{ParameterNames}</code>. The order of the output corresponds to the order of the parameter names you state in <code>{ParameterNames}</code>.</p> <p>Example:</p> <p></p>"},{"location":"tcl-command-reference.html#getlinkparamproperty","title":"GetLinkParamProperty","text":"Command Syntax GetLinkParamProperty <code>FullModuleName</code> <code>PortName</code> <code>ParameterName</code> <code>Property</code> <p>This command retrieves the properties of a specific link parameter.</p> <p>The following values for the parameter <code>Property</code> are possible:</p> <ul> <li><code>status</code>: Returns 0 if the parameter isn't in error condition; otherwise returns error code.</li> <li><code>isEditable</code>: Returns 1 if parameter value can be changed; otherwise returns 0.</li> <li><code>range</code>:<ul> <li>For integer data types, the command returns the value range either as a list containing three elements (Min, Max, Step), or as a list containing all allowed values. You distinguish the two kinds of lists as follows: The Min-Max-Step list contains 3 list elements; the third list element is smaller or equal to the second list element. A list stating all allowed values starts with the smalles value and ends with the highest value. If only one value is allowed, the value is returned in format {Value Value 1}, for example, { 4 4 1} for min=4, max=4, step=1.</li> <li>For enum parameters, the command returns a list of pairs of enum names and enum values.</li> </ul> </li> </ul>"},{"location":"tcl-command-reference.html#getlinkproperty","title":"GetLinkProperty","text":"Command Syntax GetLinkProperty <code>FullModuleName</code> <code>PortName</code> <code>Property</code> <p>This command returns a specific property of a specific link. If, with <code>FullModuleName</code> and <code>PortName</code>, you address the port of a hierarchical box, the command works as long as there is a link to or from this port within the hierarchical box.</p> <p>The following options for the parameter <code>Property</code> are available:</p> <ul> <li><code>status</code>: Returns 0 if everything is fine (i.e., if the parameter settings of the link source and the link target match, and the DRC doesn't find an error); otherwise returns error code.</li> <li><code>from</code>: Returns the starting point of the link. The starting point can be either the out port of a foregoing module, or an inner hierarchical box node (<code>INBOUND#...</code>) the link is connected to. The command returns a list containing the two values <code>FullModuleName</code> and <code>PortName</code>.</li> <li><code>to</code>: Returns the end point of the link. The end point can be either the in port of a following module, or an inner hierarchical box node (<code>OUTBOUND#...</code>) the link is connected to. The command returns a list containing the two values <code>FullModuleName</code> and <code>PortName</code>.</li> <li><code>source</code>: Returns a list containing the value pairs <code>FullModuleName</code> and <code>PortName</code> for all foregoing links up to the source of the link. The link chain is followed up backwards through the hierarchies, from the module you state in <code>FullModuleName</code> back to the starting point. The order of the elements within the returned list corresponds to the backward-course of the lookup (the source module is the last entry in the list).</li> <li><code>dest</code>: Returns a list containing the value pairs <code>FullModuleName</code> and <code>PortName</code> for all following links up to the target module of the link. The link chain proceeds forwards through the hierarchies, from the module you state in <code>FullModuleName</code> up to the end (sink). The order of the elements within the returned list corresponds to the forward-course of the lookup \u2013 the target module (destination) is the last entry in the list.</li> <li><code>hasConnectedSimModule</code>: Returns 1 if a simulation module is connected to the link; returns 0 if no simulation module is connected.</li> <li><code>connectedSimModule</code>: Returns the hierarchical name of a connected simulation module.</li> </ul>"},{"location":"tcl-command-reference.html#getsimmodules","title":"GetSimModules","text":"Command Syntax GetSimModules <code>Type</code> <code>Scope</code> <code>Specifier</code> <p>This command retrieves the <code>FullModuleName</code> of simulation sources (<code>Type = source</code>) or simulation probes (<code>Type = probe</code>) within a design. The command returns a list with simulation modules that have the characteristic you specify via the parameters <code>Scope</code> and <code>Specifier</code>. The list contains the <code>FullModuleNames</code> (hierarchical pathes to the indivudal simulation modules including the individual pathes).</p> <p><code>Scope</code> provides the following options:</p> <ul> <li><code>hierarchy</code>: Define a specific hierarchy in the parameter <code>Specifier</code>.</li> <li><code>pattern</code>: Use the parameter <code>Specifier</code> as a wildcard expression for <code>FullModuleNames</code> of simulation modules. If you state \"*\" as specifier, all source or probe simulation modules of the design are returned.</li> </ul>"},{"location":"tcl-command-reference.html#getcommentboxes","title":"GetCommentBoxes","text":"Command Syntax GetCommentBoxes <code>Scope</code> <code>Specifier</code> <p>This command retrieves comment boxes in a design. The command returns a list with all comment boxes that have the characteristic you specify via the parameters <code>Scope</code> and <code>Specifier</code>. The list contains the <code>FullElementNames</code> (hierarchical names including box name).</p> <p><code>Scope</code> provides the following options:</p> <ul> <li><code>hierarchy</code>: Define a specific hierarchy (via <code>HierLevelPath</code>) in <code>Specifier</code>.</li> <li><code>pattern</code>: Use <code>Specifier</code> as a wildcard expression for the <code>FullElementName</code> of comment boxes. If you state \"*\" as specifier, all comment boxes in the design are returned.</li> </ul>"},{"location":"tcl-command-reference.html#getcommentproperty","title":"GetCommentProperty","text":"Command Syntax GetCommentProperty <code>FullBoxName</code> <code>Property</code> <p>This command retrieves the properties of a comment box.</p> <p><code>FullBoxName</code> has the following syntax: <code>&lt;HierLevelPath&gt;/&lt;BoxName&gt;</code>.</p> <ul> <li><code>HierLevelPath</code> you use to specify the path to the hierarchical level in the design where the comment box is located. Start on process level. Use forward slashes.</li> <li><code>BoxName</code> you use to specify the individual name of the comment box.</li> </ul> <p><code>Property</code> has the following options:</p> <ul> <li><code>content</code>: The content of the comment box is returned.</li> <li><code>position</code>: the X and Y position of the left upper corner of the comment box in the design window are returned.</li> </ul> <p>Box name information: To get the name of the comment box you want to get details about, you can use TCL to query which boxes are placed in a design, see TCL example <code>QueryDesign.tcl</code> in your VisualApplets installation folder (e.g.,<code>&lt;YourVisualAppletsInstallationDirectory&gt;\\Examples\\AdvancedVAFunctions\\Tcl Scripting\\QueryDesign.tcl</code>)</p>"},{"location":"tcl-command-reference.html#editing-the-design-further-commands","title":"Editing the Design \u2013 Further Commands","text":""},{"location":"tcl-command-reference.html#move","title":"Move","text":"Command Syntax Move <code>FullModuleName</code> [<code>HierNodeName</code>] <code>PosX</code> <code>PosY</code> <p>Command for re-positioning a module, a hierarchical box node, a comment box, or a simulation module to a new position within the design window.</p> <p>Use the parameter <code>[HierNodeName]</code> only for selecting  a hierarchical box node. Nodes within hierarchical boxes are identified via the prefix <code>INBOUND#</code> or <code>OUTBOUND#</code>(like you do when using command <code>ConnectModules</code>), for example, <code>INBOUND#I000</code>.</p>"},{"location":"tcl-command-reference.html#select","title":"Select","text":"Command Syntax Select <code>FullModuleName</code> [<code>PortName</code>] <p>Command for selecting a module, a simulation module, a comment box, or a link. Use parameter <code>PortName</code> only for selecting a link (the link is identified via the port that connects the link with the addressed module).</p>"},{"location":"tcl-command-reference.html#clearselection","title":"ClearSelection","text":"Command Syntax ClearSelection [<code>ParentHierarchy</code>] <p>Command for deleting a selection of elements (modules, hierarchical box nodes, links, comment boxes, or simulation modules).</p> <p>Use the optional parameter <code>ParentHierarchy</code> to deselect all elements on the hierarchical level <code>ParentHierarchy</code>.</p> <p>If you don't use <code>ParentHierarchy</code>, element selection is deleted globally, and after carrying out the command no elements within the design are selected.</p>"},{"location":"tcl-command-reference.html#copyselected","title":"CopySelected","text":"Command Syntax CopySelected [<code>ParentHierarchy</code>] <p>Command for copying the selected elements on hierarchical level <code>ParentHierarchy</code>. If you don't use the optional parameter <code>ParentHierarchy</code>, the selected elements on the hierarchical level of the currently active design window are copied.</p>"},{"location":"tcl-command-reference.html#deleteselected","title":"DeleteSelected","text":"Command Syntax DeleteSelected [<code>ParentHierarchy</code>] <p>Command for deleting the selected elements on hierarchical level <code>ParentHierarchy</code>. Only the selected modules of the hierarchical level you specify under <code>ParentHierarchy</code> are deleted, the selected modules on other levels remain. If you don't use the optional parameter <code>ParentHierarchy</code>, the selected elements on the hierarchial level of the currently active design window are deleted.</p>"},{"location":"tcl-command-reference.html#cutselected","title":"CutSelected","text":"Command Syntax CutSelected [<code>ParentHierarchy</code>] <p>Command for cutting out the selected elements on hierarchical level <code>ParentHierarchy</code>. If you don't use the optional parameter <code>ParentHierarchy</code>, the selected elements on the hierarchial level of the currently active design window are cut out.</p>"},{"location":"tcl-command-reference.html#getselected","title":"GetSelected","text":"Command Syntax GetSelected <code>Scope</code> [<code>ParentHierarchy</code>] <p>Returns a list of selected elements on the hierarchical level <code>ParentHierarchy</code>. Via Scope you define if you want to get a list of selected modules (Modules), of selected links (Links), of selected simulation modules (<code>SimModules</code>), or of selected comment boxes (<code>CommentBoxes</code>).</p> <p>If you don't use the optional parameter <code>ParentHierarchy</code>, the selected elements on the hierarchial level of the currently active design window are returned.</p> <p>If you use <code>Scope = Modules/SimModules/CommentBoxes</code>, a list of <code>FullModuleNames</code> (hierarchical pathes to the respective modules including the module names) is returned.</p> <p>If you use <code>Scope = Links</code> you get a list of link-identifying tuples consisting of <code>FullModuleName</code> and <code>PortName</code> (the port the link is connected to).</p>"},{"location":"tcl-command-reference.html#paste","title":"Paste","text":"Command Syntax Paste [<code>ParentHierarchy</code>] [<code>xPos</code> <code>yPos</code>] <p>Command for pasting elements from the clipboard into the hierarchical level <code>ParentHierarchy</code>. (i.e., pasting elements that have been previously copied or cut out).</p> <p>If you don't use the optional parameter <code>ParentHierarchy</code>, the elements are pasted to the hierarchial level of the currently active design window.</p> <p>Use optional parameters <code>xPos</code> and <code>yPos</code> for defining the top left position of the inserted content in the design window.</p>"},{"location":"tcl-command-reference.html#insertmoduleport","title":"InsertModulePort","text":"Command Syntax InsertModulePort <code>FullModuleName</code> <code>PortName</code> [<code>Where</code>] <p>Command for inserting a new module port next to port <code>PortName</code>.</p> <p>Info</p> <p>You can only insert those ports that you can specify a multiplicity for in command <code>CreateModule</code>.</p> <p>Where offers the following options:</p> <ul> <li><code>before</code> or <code>above</code>: new port is inserted directly before port <code>PortName</code>.</li> <li><code>after</code> or <code>below</code>: new port is inserted directly after port <code>PortName</code> (default).</li> </ul> <p>If you don't use the optional parameter <code>Where</code>, the new port is inserted directly after port <code>PortName</code>.</p>"},{"location":"tcl-command-reference.html#removemoduleport","title":"RemoveModulePort","text":"Command Syntax RemoveModulePort <code>FullModuleName</code> <code>PortName</code> <p>Command for deleting a module port.</p> <p>Info</p> <p>You can only delete those ports that you can specify a multiplicity for in command <code>CreateModule</code>. The minimum number of a given kind of port will always remain. If you try minimize further below the minimum, you will get an according error message. Example: While you can delete the third output port of operator Branch (port name: O002), the two minimum output ports (O001 and O000) can't be deleted:</p> <p></p>"},{"location":"tcl-command-reference.html#appendmoduleport","title":"AppendModulePort","text":"Command Syntax AppendModulePort <code>FullHierBoxName</code> <code>Direction</code> <p>Command for adding an input port or an output port to a hierarchical box.</p> <p><code>FullHierBoxName</code> has the same syntax as <code>FullModuleName</code>.</p> <p><code>Direction=input</code>: an input port is created.</p> <p><code>Direction=output</code>: an output port is created.</p>"},{"location":"tcl-command-reference.html#rename","title":"Rename","text":"Command Syntax Rename <code>FullModuleName</code> <code>NewName</code> <p>Command for renaming a module or simulation box. In <code>NewName</code> you specify the new individual name of the instance without the hierarchical path.</p> <p>Example:</p> <pre><code>Rename Process0/module1 DMA\n</code></pre>"},{"location":"tcl-command-reference.html#setactivewindow","title":"SetActiveWindow","text":"Command Syntax SetActiveWindow <code>Hierarchy</code> <p>Command for opening (and setting active) the design window of hierarchy <code>Hierarchy</code> in VisualApplets.</p>"},{"location":"tcl-command-reference.html#getactivewindow","title":"GetActiveWindow","text":"Command Syntax GetActiveWindow <p>Returns information about the hierarchical level of the design window that is currently open and active in VisualApplets.</p>"},{"location":"tcl-command-reference.html#simulating-the-design","title":"Simulating the Design","text":""},{"location":"tcl-command-reference.html#createsimsource","title":"CreateSimSource","text":"Command Syntax CreateSimSource <code>FullSimModuleName</code> <code>xPos</code> <code>yPos</code> <p>Command for creating a simulation source module, and for positioning the module in the design window.</p> <p><code>FullSimModuleName</code> has the following syntax: <code>&lt;HierLevelPath&gt;/&lt;SimModuleName&gt;</code></p> <ul> <li><code>HierLevelPath</code> you use to define the path to a specific hierarchical level in the design.</li> <li><code>SimModuleName</code> you use for specifying the individual name you want the simulation source module to have. Alternatively, you can leave <code>SimModuleName</code> empty. In this case, you must terminate <code>FullSimModuleName</code> with a slash; the module will be named automatically.</li> </ul> <p>The return value of function <code>CreateSimSource</code> is the <code>FullModuleName</code> of the new simulation source module (full hierarchical path to the simulation source module including the module name).</p>"},{"location":"tcl-command-reference.html#createsimprobe","title":"CreateSimProbe","text":"Command Syntax CreateSimProbe <code>FullSimModuleName</code> <code>xPos</code> <code>yPos</code> <p>Command for creating a simulation probe module, and for positioning the module in the design window.</p> <p><code>FullSimModuleName</code> has the following syntax: <code>&lt;HierLevelPath&gt;/&lt;SimModuleName&gt;</code></p> <ul> <li><code>HierLevelPath</code> you use to define the path to a specific hierarchical level in the design.</li> <li><code>SimModuleName</code> you use for specifying the name you want the simulation probe module to have. Alternatively, you can leave <code>SimModuleName</code> empty. In this case, you must terminate <code>FullSimModuleName</code> with a slash; the module will be named automatically.</li> </ul> <p>The return value of function <code>CreateSimProbe</code> is the <code>FullModuleName</code> of the new simulation probe module (full hierarchical path to the simulation probe module including the module name).</p>"},{"location":"tcl-command-reference.html#deletesimmodule","title":"DeleteSimModule","text":"Command Syntax DeleteSimModule <code>FullSimModuleName</code> <p>Command for deleting a simulation module (simulation source or simulation probe).</p> <p>The syntax of <code>FullSimModuleName</code> is the same as the syntax of <code>FullModuleName</code>.</p>"},{"location":"tcl-command-reference.html#connectsimmodule","title":"ConnectSimModule","text":"Command Syntax ConnectSimModule <code>FullSimModuleName</code> <code>TargetModuleName</code> <code>TargetModulePortName</code> [<code>xPos</code> <code>yPos</code>] <p>Command for connecting a simulation module to a link. You identify the link via the module port the link is connected to.</p> <p>The syntax of <code>FullSimModuleName</code> and <code>TargetModuleName</code> is the same as the syntax of <code>FullModuleName</code>. The syntax of <code>TargetModulePortName</code> is the same as the syntax of <code>PortName</code>.</p> <p>Module <code>TargetModuleName</code> and simulation module <code>FullSimModuleName</code> must be located in the same hierarchy to connect them with each other.</p> <p>Optionally, you can define the position of the connecting point on the link via <code>xPos</code> and <code>yPos</code>.</p>"},{"location":"tcl-command-reference.html#disconnectsimmodule","title":"DisconnectSimModule","text":"Command Syntax DisconnectSimModule <code>FullSimModuleName</code> <p>Command for detaching the simulation module from a link.</p>"},{"location":"tcl-command-reference.html#setsimmoduleproperty","title":"SetSimModuleProperty","text":"Command Syntax SetSimModuleProperty <code>FullSimModuleName</code> <code>Key</code> <code>Value</code> {<code>OtherValue</code>} <p>Command for defining the properties of a simulation module.</p> <p>Use <code>Key</code> to identify the property you want to set. Set the individual properties in the format stated below. Available are the following properties and according value formats:</p> <pre><code>pixelAlignmentOffset BITS\n</code></pre> <p>Use this parameter to specify the alignment offset as integer value <code>BITS</code>.</p> <pre><code>imageFileSubPixels NUMBER\n</code></pre> <p>Use this parameter to specify the number of file pixels that are assigned to a link pixel as integer value <code>NUMBER</code>.</p> <p>Source: <code>NUMBER</code> pixels are conflated to one pixel.</p> <p>Probe: One pixel is split up into <code>NUMBER</code> pixels in the file.</p> <pre><code>imageFilePixelBits BITS\n</code></pre> <p>Use this parameter to specify the bit width in the image file as integer value <code>BITS</code>. Allowed are the values 1, 8, and 16.</p> <pre><code>imageFileNormalize CHOICE\n</code></pre> <p>Use this property to configure the way simulation result images are saved.</p> <p>If you want to save a 1-bit simulation result in an 8-bit file format, set <code>imageFileNormalize</code> to 1. \"Normalizing\" in this context means mapping 0 to 0 (black) and 1 to 255 (white).</p> <p>The following values for <code>CHOICE</code> are possible: <code>CHOICE = \"1\" | \"0\"</code></p> <pre><code>cropRect [imageNr] X Y WIDTH HEIGHT\n</code></pre> <p>This property is only available for simulation sources. Specifying the image index <code>[imageNr]</code> is mandatory. Use this parameter to crop an image and to specify the region of the image (ROI) you want to use for simulation. With <code>X</code> and <code>Y</code> you define the left upper corner of the ROI.</p> <pre><code>currentImage INDEX\n</code></pre> <p>Use this parameter to select an image within the simulation module. Specify <code>INDEX</code> as integer value.</p>"},{"location":"tcl-command-reference.html#addimage","title":"AddImage","text":"Command Syntax AddImage <code>FullSimModuleName</code> <code>ImageFileName1</code> {<code>OtherImageFileName</code>} [<code>ImageLibrary</code>] <p>Command for adding an image to a simulation source module. If the number of kernel elements of the link the simulation source is connected to is &gt; 1, you must specify as many images as the kernel has elements.</p> <p>Optionally, you can state the image library you want to use ( <code>ImageLibrary</code> = \"Native\" | \"ImageMagick\").</p>"},{"location":"tcl-command-reference.html#removeimage","title":"RemoveImage","text":"Command Syntax RemoveImage <code>FullSimSourceName</code> {<code>ImageIndex</code>} <p>Command for deleting one or all images from a simulation source module. Use the optional parameter <code>ImageIndex</code> to specify the image you want to delete. If you set <code>ImageIndex</code> to -1, or if you don't use <code>ImageIndex</code> at all, all images in the simulation module are deleted.</p>"},{"location":"tcl-command-reference.html#simulate","title":"Simulate","text":"Command Syntax Simulate <code>ProcessingCycles</code> [<code>SaveLogfilename</code>] <p>Command for simulating a design. Use parameter <code>ProcessingCycles</code> for defining how many processing cycles you want to carry out with with the command.</p> <p>Use the optional parameter <code>SaveLogfilename</code> to save the log of the carried-out cycles to file. Specify in <code>SaveLogfilename</code> the path to the file and the file name itself. Use file name extension *.html, as the log is written in HTML format. Use forward slashes for indicating pathes.</p> <p>Example:</p> <pre><code>Simulate 1 c:/temp/simlog.html\n</code></pre>"},{"location":"tcl-command-reference.html#resetsimulation","title":"ResetSimulation","text":"Command Syntax ResetSimulation <p>Command for resetting the simulation engine. As effect, all simulation probes in the design are cleared.</p>"},{"location":"tcl-command-reference.html#getsimmoduleproperty","title":"GetSimModuleProperty","text":"Command Syntax GetSimModuleProperty <code>FullSimModuleName</code> <code>Property</code> [<code>ImageIndex</code> [<code>LineIndex</code> [<code>LineCount</code>] ] ] <p>Command for retrieving the properties of a simulation module. The following properties are available:</p> <ul> <li><code>isConnected</code>: returns 1 if simulation module is connected to a link; otherwise returns 0.</li> <li><code>connectedLink</code>: Returns a list containing the <code>FullModuleName</code> of a module the link is connected to, and the port of the module the link is connected to. The return value always describes the link by a real module port, i.e., it never states an inner H box node (like, for example, <code>INBOUND#I000</code> or <code>OUTBOUND#O000</code>).</li> <li><code>isSource</code>: Returns 1 if the simulation module is a <code>SimulationSource</code>; otherwise returns 0.</li> <li><code>isProbe</code>: Returns 1 if the simulation module is a <code>SimulationProbe</code>; otherwise returns 0.</li> <li><code>position</code>: Returns position of the simulation module in the program window as a list (<code>xPos</code>, <code>yPos</code>).</li> <li><code>imageCount</code>: Returns the number of images in the simulation module (=value of <code>IMAGECOUNT</code>).</li> <li><code>imageSize</code>: Using parameter <code>ImageIndex</code> is mandatory. Returns the size of the image you specify in <code>ImageIndex</code> as a list <code>{Width &lt;WIDTH&gt; Height &lt;HEIGHT&gt;}</code>.</li> <li><code>pixelAligmentOffset</code>: Returns the alignment offset as integer value <code>BITS</code>.</li> <li><code>imageFileSubPixels</code>: Returns the number of file pixels that are assigned to a link pixel as integer value <code>NUMBER</code>.</li> <li><code>imageFilePixelBits</code>: Returns the setting for bit width in the image file as integer value <code>BITS</code>. Allowed are the values 1, 8, and 16.</li> <li><code>imageFileNormalize</code>: Returns 1 or 0 according to the settings for saving simulation result images. If set to 1, during saving a 1-bit simulation result to a file in 8-bit * <code>format</code>: 0 is mapped to 0 (black) and 1 is mapped to 255 (white), i.e., the simulation image's format is \"normalized\".</li> <li><code>cropRect</code>: This property is only available for simulation sources. Using parameter <code>ImageIndex</code> is mandatory. Returns a list with the following entries: <code>{X Y WIDTH HEIGHT}</code>.</li> <li><code>currentImage</code>: Returns the currently selected image as integer value <code>INDEX</code>.</li> </ul>"},{"location":"tcl-command-reference.html#setsimimagedata","title":"SetSimImageData","text":"Command Syntax SetSimImageData <code>FullSimModuleName</code> <code>ImageIndex</code> <code>KernelRow</code> <code>KernelCol</code> <code>Component</code> <code>X</code> <code>Y</code> <code>Width</code> <code>Value</code> {<code>OtherValues</code>} <p>Command for overwriting one pixel or several neighboring pixels in an image within a simulation module (source or probe).</p> <p>You can use this command_</p> <ul> <li>in SimSources for altering an image for simulation.</li> <li>in SimProbes for visualizing the results within an image.</li> </ul> <p>The alteration of the image is volatile. As soon as you select another image of the same simulation module or re-select the altered image, the altered image is loaded anew from hard disk and your alterations are discarded. (You select another image if you enter a command for a new image <code>ImageIndex</code> (of the same simulation module) in the TCL console, or if you click on another image of the same simulation module in the viewer of the VisualApplets GUI.)</p> <p>However, you can make your alteration permanent by saving the altered image as long as it's active under a new file name.</p> <p>You can use a volatilely altered image for simulation. However, only one image per SimSource module can be used for simulation in altered condition (because altering another image in the same SimSource resets the pixel values of the image you altered before). You can use as many volatilely altered images as you want for simulation as long as you have only one volatilely altered image per simulation module.</p> <p>One value per Pixel: Command <code>SetSimImageData</code> allows you to write exactly one value per pixel. Thus, in gray scale pixels, you must carry out command <code>SetSimImageData</code> only once to write the complete color information per pixel. In color pixels, you will be able to write only one of the three color components per pixel. Thus, if you want to change all three color components of color pixel(s), you have to carry out command <code>SetSimImageData</code> three times.</p> <p>Writing in images with kernels: When you are writing into images that have a kernel, you must specify (in addition to the exact position of the (first) pixel you want to overwrite) which kernel element of the respective pixel(s) you want to overwrite when using command <code>SetSimImageData</code>. If you want to overwrite all kernel elements, you must carry out command <code>SetSimImageData</code> exactly <code>KernelRow * KernelCol</code> times.</p> <p>To use the command:</p> <p>Before using the command, close the image viewer of the simulation module the image you want to change is located in.</p> <p>Specify the image you want to alter with index <code>ImageIndex</code>.</p> <p><code>ImageIndex</code> starts with 0, whereas the numbering of the images in a simulation module in the VisualApplets GUI starts with 1. The values map as follows:</p> <p><code>ImageIndex = 0</code> referes to image 1 in the viewer of the VisualApplets GUI.</p> <p><code>ImageIndex = 1</code> referes to image 2 in the viewer of the VisualApplets GUI.</p> <p><code>ImageIndex = 2</code> referes to image 3</p> <p>and so forth.</p> <p>Information: On the GUI of VisualApplets, the index of the image that is used in the next simulation cycle is displayed in square brackets and marked by a preceeding \"sim\" (e.g., sim[2]).</p> <p>Use <code>KernelRow</code> and <code>KernelCol</code> to specify the kernel element you are going to change a pixel value for.</p> <p>Which size the kernel of your simulation image has you can see in the link properties of the link the simulation module is connected to. A link that has a kernel size bigger than 1 pixel is always preceeded by an instance of an operator that allows specifying kernels (as, for example, operator <code>FIRkernelNxM</code>).</p> <p>Counting kernel columns and kernel rows starts with 0. Thus, if you have a kernel with only one element, set both values (<code>KernelRow</code> and <code>KernelCol</code>) to 0:</p> <p></p> <p>For a kernel with 4 elements, you identify an individual kernel element as follows:</p> <p></p> <p>For a kernel with 9 elements, you identify an individual kernel element as follows:</p> <p></p> <p>Use parameter <code>Component</code> to specify the color component of the pixel you want to set. In gray scale images, set <code>Component</code> to 0. In multi-component images (color), specify the component you want to write via its position in the color model. Example: Set <code>Component</code> to 0 if you want to address the red component in an RGB image, set <code>Component</code> to 1 if you want to address the green component in an RGB image, or set <code>Component</code> to 2 if you want to address the blue component in an RGB image.</p> <p>Set position (<code>X</code>,<code>Y</code>) to define the starting point (first pixel) for your writing within the image.</p> <p>Use <code>Width</code> to specify the number of neighboring pixels you want to overwrite per row. If you specify more <code>Values</code> than you write pixels in a row (<code>Width</code>), writing continues in the next row on position <code>X</code>. This way, you can write a region of interest (ROI) that has the width <code>Width</code>.</p> <p>Specify the individual pixel values <code>Value {OtherValues}</code> in hexadecimal writing without preceding \"0x\". Specify negative values in two's complement notation. How many values you state in <code>Value {OtherValues}</code> decides how many pixels within the image are altered.</p>"},{"location":"tcl-command-reference.html#getsimimagedata","title":"GetSimImageData","text":"Command Syntax GetSimImageData <code>FullSimModuleName</code> <code>ImageIndex</code> <code>KernelRow</code> <code>KernelCol</code> <code>Component</code> <code>X</code> <code>Y</code> [<code>Width</code> [<code>Height</code>]] <p>Command for reading values of one or several neighboring pixels in an image within a simulation module (source or probe).</p> <p>One value per Pixel: Command <code>GetSimImageData</code> returns exactly one value per pixel. Thus, in gray scale pixels, you must carry out command <code>GetSimImageData</code> only once to retreive the complete color information per pixel. In color pixels, you will be able to retrieve only one of the three color components per pixel. Thus, if you want to read all three color components of color pixel(s), you have to carry out command <code>GetSimImageData</code> three times.</p> <p>Reading in images with kernels: When you are reading from images that have a kernel, you must specify (in addition to the exact position of the (first) pixel you want to read) which kernel element of the respective pixel(s) you want to read when using command <code>GetSimImageData</code>. If you want to read all kernel elements, you must carry out command <code>GetSimImageData</code> exactly <code>KernelRow * KernelCol</code> times.</p> <p>To use the command:</p> <p>Specify the image with index <code>ImageIndex</code>.</p> <p><code>ImageIndex</code> starts with 0, whereas the numbering of the images in a simulation module in the VisualApplets GUI starts with 1. The values map as follows:</p> <p><code>ImageIndex = 0</code> referes to image 1 in the viewer of the VisualApplets GUI.</p> <p><code>ImageIndex = 1</code> referes to image 2 in the viewer of the VisualApplets GUI.</p> <p><code>ImageIndex = 2</code> referes to image 3 in the viewer of the VisualApplets GUI,</p> <p>and so forth.</p> <p>Information: On the GUI of VisualApplets, the index of the image that is used in the next simulation cycle is displayed in square brackets and marked by a preceeding \"sim\" (e.g., sim[2]).</p> <p>Use <code>KernelRow</code> and <code>KernelCol</code> to specify the kernel element you want to read from.</p> <p>Which size the kernel of your simulation image has you can see in the link properties of the link the simulation module is connected to. A link that has a kernel size bigger than 1 element is always preceeded by an instance of an operator that allows specifying kernels (as, for example, operator <code>FIRkernelNxM</code>).</p> <p>Counting the columns and rows of a kernel starts with 0. Thus, if you have a kernel with only one element, set both values to 0.</p> <p></p> <p>For a kernel with 4 elements, you identify an individual kernel element as follows:</p> <p></p> <p>For a kernel with 9 elements, you identify an individual kernel element as follows:</p> <p></p> <p>Use parameter <code>Component</code> to specify the color component you want to read of the pixel. In gray scale images, set <code>Component</code> to 0. In multi-component images (color), specify the component you want to read via its position in the color model. Example: Set <code>Component</code> to 0 if you want to read the red component in an RGB image, set <code>Component</code> to 1 if you want to read the green component in an RGB image, or set <code>Component</code> to 2 if you want to read the blue component in an RGB image.</p> <p>Set position (<code>X</code>,<code>Y</code>) to define the starting point (first pixel) of your reading within the image.</p> <p>If you don't use parameter <code>Width</code>, the value for exactly one pixel is returned. If you specify only <code>Width</code>, <code>Width</code> values in line <code>Y</code> are returned. If you specify <code>Width</code> and <code>Height</code>, <code>Width * Height</code> values are returned. Using <code>Width</code> and <code>Height</code> allows you to define a region of interest (ROI) you want to read the pixel values (gray)/the values of a pixel component (color) for.</p> <p>The individual pixel values are returned in hexadecimal writing without preceding \"0x\". Negative values are returned in two's complement notation.</p>"},{"location":"tcl-command-reference.html#getsimimageproperty","title":"GetSimImageProperty","text":"Command Syntax GetSimImageProperty <code>FullSimModuleName</code> <code>Property</code> <code>ImageIndex</code> [<code>LineIndex</code> [<code>LineCount</code>] ] <p>Command for retrieving the properties of a simulation image (in a source or a probe module).</p> <p>The following value for <code>Property</code> is available:</p> <p><code>LineWidth</code>: Define via <code>LineIndex</code> for which line you want to get information about its width. If you use <code>LineCount</code>, you can get a number of width values (in form of a list). The first value will be the width of line <code>LineIndex</code>.</p>"},{"location":"tcl-command-reference.html#saveimage","title":"SaveImage","text":"Command Syntax SaveImage <code>FullSimProbeName</code> {<code>ImageIndex</code>} <code>ImageBaseName</code> <p>Command for saving one or all result images from a simulation probe.</p> <p>Use the optional parameter <code>ImageIndex</code> if you want to save a specific image out of the result images. Don't use <code>ImageIndex</code> or set it to -1 if you want to save all images of the probe.</p> <p>Use <code>ImageBaseName</code> to specify the path to the directory in your file system where you want to save the image(s), and for specifying the file name of the image file(s). Make sure the directories you specify already exist in your file system. Otherwise, you can create them using command <code>MakeDirectoryPath</code> (see there).</p> <p>Example: \"c:/images/testimage\". In the saving process, the file name extension (for example, *.tif) will be automatically added to the name.</p> <p>If you save all images of the probe, an image index will be automatically added to the file name.</p> <p>Example 1:</p> <p>Enter</p> <pre><code>SaveImage Process0/mySimProbe c:/images/testimage\n</code></pre> <p>to get the following files:</p> <p>c:/images/testimage_0001.tif</p> <p>c:/images/testimage_0002.tif</p> <p>c:/images/testimage_0003.tif</p> <p>\u2026</p> <p>Example 2:</p> <p>Enter</p> <pre><code>SaveImage Process0/mySimProbe 4 c:/images/testimage\n</code></pre> <p>to get the following file:</p> <p>c:/images/testimage.tif</p>"},{"location":"tcl-command-reference.html#building-the-design","title":"Building the Design","text":""},{"location":"tcl-command-reference.html#drc","title":"Drc","text":"Command Syntax Drc [<code>SaveLogfileName</code>] <p>Command for starting the first level of the Design Rule Check (DRC 1).</p> <p>To get a log output, you can optionally specify the path to and the name of an html log file (*.html) in parameter <code>[SaveLogfileName]</code>.</p>"},{"location":"tcl-command-reference.html#drc2","title":"Drc2","text":"Command Syntax Drc2 <code>Name</code> <code>Platform</code> <p>Command for starting the second level of the Design Rule Check (DRC 2).</p> <p>To get a log output, you can optionally specify the path to and the name of an html log file (*.html) in parameter <code>[SaveLogfileName]</code>.</p>"},{"location":"tcl-command-reference.html#selectbuildconfiguration","title":"SelectBuildConfiguration","text":"Command Syntax SelectBuildConfiguration <code>ConfigurationName</code> <p>Command for selecting a saved build configuration as active build configuration.</p> <p>Specify the name of the desired build configuration in parameter <code>ConfigurationName</code>.</p> <p>To get an overview over all available build configurations, enter <code>SelectBuildConfiguration ?</code> - a list of the names of all available build configurations is returned. The currently selected build configuration is displayed in the first entry of the list.</p> <p>Example:</p> <p></p> <p>The command returns the name of the currently selected build configuration. Via this return value you can check if your re-setting the build configuration was successful.</p> <p>Example:</p> <p></p>"},{"location":"tcl-command-reference.html#build","title":"Build","text":"Command Syntax Build [<code>SaveLogfilename</code> [<code>MaxTime</code>] ] <p>Command for starting the build flow.</p> <p>To get a log output, you can optionally specify the path to and the name of an html log file (*.html) in parameter <code>[SaveLogfileName]</code>.</p> <p>To set a time limit for the build process, you can optionally specify the the maximum build time in parameter <code>[MaxTime]</code> (in hours). Parameter <code>[MaxTime]</code> is of type floating point. This way, you can specify fractions of an hour. The default setting for <code>[MaxTime]</code> is 24 hours.</p> <p>Example for a command creating log file <code>build_log.html</code> and specifying the maximum Build time as \u00bd hour:</p> <pre><code>Build build_log.html 0.5\n</code></pre>"},{"location":"tcl-command-reference.html#handling-files-paths-program-instances-and-messages","title":"Handling Files, Paths, Program Instances and Messages","text":""},{"location":"tcl-command-reference.html#source","title":"Source","text":"Command Syntax Source <code>FilePath</code> <p>Command for executing a TCL script out of a file. Use forward slashes for specifying the path. The command works like the TCL command <code>source</code>, but automatically replaces the following place holders (like command <code>MakeDirectoryPath</code>):</p> <p><code>%UserDir%</code>: User data directory for the current user (for example, c:/Users/Smith)</p> <p><code>%AppDataDir%</code>: Directory for application data of VisualApplets</p> <p><code>%VaInstallDir%</code>: Installation directory of VisualApplets</p> <p><code>%UserLibDir%</code>: Directory for user libraries.</p> <p><code>%CustomLibDir%</code>: Directory for custom libraries.</p> <p><code>%VaVersion%</code>: VisualApplets program version, for example, \"3.1\"</p> <p><code>%CurrDateTime%</code>: Current date and time according to ISO 8601 (basic format), for example \"20170530T134522\"</p> <p><code>%DateTime%</code>: Date and time at start of VisualApplets according to ISO 8601 (basic format), for example \"20170530T134350\"</p> <p><code>%CurrDesignDir%</code>: Directory in which the currently loaded design is stored.</p>"},{"location":"tcl-command-reference.html#makedirectorypath","title":"MakeDirectoryPath","text":"Command Syntax MakeDirectoryPath <code>FullPath</code> <p>Command for creating pathes (and their directories) of any desired depth.</p> <p>The command automatically replaces the following place holders:</p> <p><code>%UserDir%</code>: User data directory for the current user (for example, c:/Users/Smith)</p> <p><code>%AppDataDir%</code>: Directory for application data of VisualApplets</p> <p><code>%VaInstallDir%</code>: Installation directory of VisualApplets</p> <p><code>%UserLibDir%</code>: Directory for user libraries.</p> <p><code>%CustomLibDir%</code>: Directory for custom libraries.</p> <p><code>%VaVersion%</code>: VisualApplets program version, for example, \"3.1\"</p> <p><code>%CurrDateTime%</code>: Current date and time according to ISO 8601 (basic format), for example \"20170530T134522\"</p> <p><code>%DateTime%</code>: Date and time at start of VisualApplets according to ISO 8601 (basic format), for example \"20170530T134350\"</p> <p><code>%CurrDesignDir%</code>: Directory in which the currently loaded design is stored.</p> <p>If the command has been carried out successfully, the absolute path is returned.</p>"},{"location":"tcl-command-reference.html#getabsolutepath","title":"GetAbsolutePath","text":"Command Syntax GetAbsolutePath <code>Path</code> <p>Returns the absolute path of the path you specify in parameter <code>Path</code>.</p> <p>The command automatically replaces the same alias names (place holders) as command <code>MakeDirectoryPath</code>.</p> <p>You are allowed to refer in <code>Path</code> to a directory or a file that doesn't exist, so that the resulting path name refers to a directory or a file that doesn't exist.</p>"},{"location":"tcl-command-reference.html#wait","title":"Wait","text":"Command Syntax Wait <code>TimeInMilliseconds</code> <p>Command for waiting the specified time <code>TimeInMilliseconds</code>. The VisualApplets GUI stays active during waiting time.</p> <p>If you set <code>TimeInMilliseconds</code> to 0, at least one event loop update of the GUI is carried out by VisualApplets. You can use this for making sure that the GUI displayes the results from earlier commands.</p>"},{"location":"tcl-command-reference.html#message","title":"Message","text":"Command Syntax Message <code>Type</code> <code>Code</code> <code>Text</code> <p>Command for emitting</p> <ul> <li>an error message (<code>Type=error</code>),</li> <li>a warning (<code>Type=warning</code>), or</li> <li>an informative message (<code>Type=info</code>)</li> </ul> <p>In <code>Code</code>, define the message code for your message. <code>Code</code> has the value range from -999 to +999. Use only values in this range to avoid conflicts with the current and/or future versions of VisualAppets.</p> <p>Use <code>Text</code> to enter the message. The message is completed by a dot automatically.</p>"},{"location":"tcl-command-reference.html#exit","title":"Exit","text":"Command Syntax Exit [<code>Mode</code>] <p>Command for terminating the current VisualApplets session. You can use <code>Exit</code> even if you still have a design open. However, don't forget to save your changes before.</p> <p>If you still have a desing open and the design contains unsaved changes:</p> <ul> <li>If you set the optional parameter <code>Mode</code> to <code>Discard</code>, the open design will be closed even if it containes changes that you didn't save yet. The unsaved changes will be discarded.</li> <li>If you use <code>Exit</code> without using parameter <code>Mode</code> although the open design containes unsaved changes, the command will be terminated and you receive an according error message.</li> </ul>"},{"location":"tcl-script-examples.html","title":"Tcl Script Examples","text":"<p>You have a set of Tcl script examples available in your VisualApplets installation.</p> <p>You find them in the following directory: &lt;YourVisualAppletsInstallationDirectory&gt;/Examples/AdvancedVAFunctions/Tcl Scripting</p> <p>The examples contain extensive notes describing the individual parts of the script.</p> <p></p>"},{"location":"tcl-script-frequently-used-parameters-syntax.html","title":"Tcl Script: Frequently Used Parameters - Syntax","text":""},{"location":"tcl-script-frequently-used-parameters-syntax.html#fullmodulename","title":"FullModuleName","text":"<p>Scope: For addressing specific operator instances (= modules) in a design.</p> <p>Syntax: <code>&lt;HierLevelPath&gt;/&lt;ModuleName&gt;</code></p> <ul> <li><code>HierLevelPath</code> you use to define the path to a specific hierarchical level in the design. Use forward slashes.</li> <li><code>ModuleName</code> you use for specifying the name of the module. The name of the module is the individual name you give to a module, not the name of the operator the module is instantiated from.</li> </ul> <p>Example: <code>Process1/cam</code></p> <p>If you address modules within a hierarchical box, don\u2019t forget to state the name of the process the hierarchical box is located in.</p> <p>Example: <code>Process0/HierchBox1/module6</code></p>"},{"location":"tcl-script-frequently-used-parameters-syntax.html#fullelementname","title":"FullElementName","text":"<p>Scope: For addressing specific elements (modules (i.e., operator instances), hierarchical boxes, simulation sources, simulation probes, and comment boxes) in a design.</p> <p>Syntax: <code>&lt;HierLevelPath&gt;/&lt;ElementName&gt;</code></p> <ul> <li><code>HierLevelPath</code> you use to define the path to a specific hierarchical level in the design. Use forward slashes.</li> <li><code>ElementName</code> you use for specifying the name of the element. <code>ElementName</code> is the individual name you give to an element instance.</li> </ul> <p>Example: <code>Process1/cam1</code></p> <p>If you address elements within a hierarchical box, don\u2019t forget to state the name of the process the hierarchical box is located in.</p> <p>Example: <code>Process0/HierchBox1/module6</code></p>"},{"location":"tcl-script-frequently-used-parameters-syntax.html#hierlevelpath","title":"HierLevelPath","text":"<p>Scope: <code>HierLevelPath</code> you use to define the path to a specific hierarchical level in the design. Use forward slashes.</p> <p>Example: <code>Process1/HierBox_xy/</code></p> <p>If you address elements within a hierarchical box, don\u2019t forget to state the name of the process the hierarchical box is located in.</p> <p>Example: <code>Process0/HierchBox1/</code></p>"},{"location":"tcl-script-frequently-used-parameters-syntax.html#parametername","title":"ParameterName","text":"<p>In <code>Parametername</code>, specify the name of the parameter as it displayed in the VisualApplets GUI.</p>"},{"location":"tcl-script-frequently-used-parameters-syntax.html#multiportbasename","title":"MultiportBaseName","text":"<p>Scope: <code>MultiportBaseName</code> you use to specify the kind of port you want to address on a module. You retrieve information about the base name of a port instance in the VisualApplets GUI:</p> <ul> <li>The <code>MultiportBaseName</code> is displayed in the dialog that appears when instantiating an operator that has a varying number of ports. The <code>MultiportBaseName</code> is the short name of the multiport name and is displayed in parantheses in the GUI:</li> </ul> <p></p> <p>The <code>MultiportBaseName</code> here is <code>I</code>.</p> <p>You also find the <code>MultiportBaseName</code> in the mouseover information to a port:</p> <p></p> <p><code>MultiportBaseName</code> here is <code>I</code> (followed by the index identifying the individual instances of the multiport on the module).</p>"},{"location":"tcl-script-frequently-used-parameters-syntax.html#portname","title":"PortName","text":"<p>Scope: <code>PortName</code> you use to identify an individual port you want to address on a module. You retrieve information about the <code>PortName</code> via mouseover in the VisualApplets GUI:</p> <p></p> <p><code>PortName</code>s here are <code>I</code>, <code>PI</code>, <code>Tick</code>, <code>Reset</code>, and <code>O</code>.</p> <p><code>PortName</code> can also stand for the port name of a multiport. If PortName stands for the port name of a multiport, it has the following syntax: <code>&lt;MultiportBaseName&gt;:Number</code></p> <p>If a multiport is instantiated on a module multiple times, an index number is added to the <code>MultiportBaseName</code>.</p> <p>Example:</p> <p></p> <p><code>MultiportBaseName</code> here is <code>I</code> (followed by the index identifying the individual instances of the multiport on the module).</p> <p>Port names of inner hierarchical box nodes: Inner hierarchical box nodes (inner nodes for connecting <code>HierarchicalBox</code> ports) are identified via the prefixes <code>INBOUND#</code> or <code>OUTBOUND#</code>.</p> <p>Example:</p> <p>The two inbound nodes of the hierarchical box in the figure below need to be addressed by <code>INBOUND#I000</code> and <code>INBOUND#I001</code>.</p> <p></p>"},{"location":"tcl-script-frequently-used-parameters-syntax.html#hiernodename","title":"HierNodeName","text":"<p>Scope: <code>HierNodeName</code> you use to identify a specific inner hierarchical box node you want to address within a hierarchical box.</p> <p>Syntax:</p> <pre><code>INBOUND#&lt;Portname&gt;\n\nOUTBOUND#&lt;Portname&gt;\n</code></pre> <p>Example:</p> <p>The two inbound nodes of the hierarchical box in the figure below need to be addressed by <code>INBOUND#I000</code> and <code>INBOUND#I001</code>.</p> <p></p>"},{"location":"tcl-script-frequently-used-parameters-syntax.html#fullsimmodulename","title":"FullSimModuleName","text":"<p>Scope: <code>FullSimModuleName</code> you use to identify an individual simulation module. It refers to simulation source and simulation probe modules.</p> <p>The syntax is identical to <code>FullElementName</code>: <code>&lt;HierLevelPath&gt;/&lt;ElementName&gt;</code></p>"},{"location":"tcl-script-frequently-used-parameters-syntax.html#fullsimsourcename","title":"FullSimSourceName","text":"<p>Scope: <code>FullSimSourceName</code> you use to identify an individual simulation source module.</p> <p>Syntax: <code>&lt;HierLevelPath&gt;/&lt;ElementName&gt;</code></p> <p>The syntax is identical to <code>FullElementName</code>.</p>"},{"location":"tcl-script-frequently-used-parameters-syntax.html#fullsimprobename","title":"FullSimProbeName","text":"<p>Scope: <code>FullSimProbeName</code> you use to identify an individual simulation probe module.</p> <p>Syntax: <code>&lt;HierLevelPath&gt;/&lt;ElementName&gt;</code></p> <p>The syntax is identical to <code>FullElementName</code>.</p>"},{"location":"tcl-script-frequently-used-parameters-syntax.html#filename","title":"FileName","text":"<p>Scope: Specify in <code>FileName</code> the path to the file and the file name itself. Use forward slashes for indicating pathes. Don\u2019t forget to add the file name extension to the file name.</p> <ul> <li>File extension \u201c.va\u201d indicates that your design is saved in the standard VisualApplets design format. All contents of the design are saved.</li> <li>File extension \u201c.tcl\u201d indicates that a TCL script is exported. Some contents of the design cannot be exported.</li> </ul>"},{"location":"the-visualapplets-scripting-console.html","title":"The VisualApplets Scripting Console","text":"<p>VisualApplets offers a Scripting Console, in which you can enter Python or Tcl commands.</p> <p>To open the Scripting Console in VisualApplets:</p> <ol> <li> <p>From menu Window, select Dock Windows and then Scripting Console.</p> <p></p> <p>The Scripting Console is immediately opened at the bottom of the VisualApplets program window:</p> <p></p> </li> </ol>"},{"location":"the-visualapplets-scripting-console.html#using-the-scripting-console","title":"Using the Scripting Console","text":"<p>In the Scripting Console, you can switch in the Script Interpreter drop-down list, whether you want to use Python or Tcl as scripting language:</p> <p></p> <p>The Scripting Console has the following fields:</p> <p></p> <ol> <li>Enter your command into the input field and strike the Return key.</li> <li> <p>In the scrollable log window above, all commands you have entered are displayed, together with information if the command could be carried out, and with according error messages if not. The Scripting Console lists all commands you enter for design creation (via GUI options, key strokes, or in Tcl/Python).      Commands you entered are marked by a preceding \u201c&gt;\u201d.</p> <p>Errors are highlighted in red.</p> <p></p> </li> <li> <p>Use the Scripting Console to get information about commands and their syntax: Just carry out the action (you want to define in your script) using the GUI options of VisualApplets (clicking, Drag&amp;Drop, key strokes \u2026) and read in the log window of the Scripting Console how this action is defined in Tcl or Python. You can use Copy&amp;Paste to copy commands into your script.</p> </li> <li>Use the Scripting Console to test the commands you want to enter into your script: Just enter the command in the command input field and check if the desired action is carried out by VisualApplets. You can use Copy&amp;Paste to copy a successful command into your script.</li> </ol> <p>Info</p> <p>The Scripting Console lists commands you enter for design creation: Not only commands you enter in Tcl/Python, but also commands you give by using the VisualApplets GUI options. This is very helpful when you start using scripts for VA designs, as you can easily get information about the correct commands and the according command syntax.</p> <p>For a complete list of all VisualApplets-specific Tcl and Python commands, refer to the topics Tcl Command Reference and Python Command Reference.</p>"},{"location":"the-visualapplets-scripting-console.html#starting-scripts-from-the-scripting-console","title":"Starting Scripts from the Scripting Console","text":"<p>You have three options to start a script from the Scripting Console.</p> <p>Info</p> <p>Make sure the correct scripting language is selected in the Script Interpreter drop-down list box before importing the script.</p>"},{"location":"the-visualapplets-scripting-console.html#starting-scripts-via-the-toolbar","title":"Starting Scripts via the Toolbar","text":"<p>You can start a script via the toolbar button Open Script:</p> <p></p> <p>Navigate to the directory where your script is located and select it.</p> <p>Info</p> <p>Make sure the correct scripting language is selected in the Script Interpreter drop-down list box before importing the script.</p>"},{"location":"the-visualapplets-scripting-console.html#starting-scripts-manually","title":"Starting Scripts Manually","text":"<p>You can also type the <code>Source</code> command manually:</p> <p>Tcl Syntax:</p> <ol> <li>Type the command <code>Source</code> into the command input field.</li> <li>Leave a space and type the path to the scripting file and the name of the scripting file directly after the command <code>Source</code>. If path or file name contain spaces, put path + file name into double quotes.</li> <li>Strike the Return key to start executing the script in VisualApplets.</li> </ol> <p>Python Syntax:</p> <ol> <li>Type the command <code>Source</code> into the command input field.</li> <li> <p>Open a parenthesis and quotation marks and type the path to the scripting file and the name of the scripting file directly after the parenthesis and quotation marks. If path or file name contain spaces, put path + file name into double quotes. Close the quotation marks and parenthesis.</p> <p>Example: <code>Source(\"C:/Basler/MyPythonScript.py\")</code></p> </li> <li> <p>Strike the Return key to start executing the script in VisualApplets.</p> <p></p> </li> </ol>"},{"location":"the-visualapplets-scripting-console.html#copying-scripting-code-into-the-console","title":"Copying Scripting Code into the Console","text":"<p>You can also simply copy Tcl or Python code from the clipboard into the command input field:</p> <ol> <li>Mark the code you want to execute in your script and copy it to the clipboard.</li> <li>Past the code from the clipboard into the command input field.</li> <li>Strike the Return key to start executing the code in VisualApplets.</li> </ol>"},{"location":"the-visualapplets-scripting-console.html#quick-command-syntax-information","title":"Quick Command Syntax Information","text":"<p>To get information about the syntax of a command very quickly:</p> <ol> <li>Enter the name of the command into the command input field, followed by:<ul> <li>For Tcl: <code>&lt;CommandName&gt;</code> followed by a space and a question mark</li> <li>For Python: <code>help(&lt;CommandName&gt;)</code></li> </ul> </li> <li>Press Enter.</li> </ol> <p>The syntax of the parameter is displayed in the Scripting Console window.</p> <p>Tcl Example:</p> <p>Enter <code>GetModules ?</code> to get syntax information for command <code>GetModules</code>.</p> <p>The Scripting Console window displays the required information:</p> <p></p> <p>Python Example:</p> <p>Enter <code>help(GetModules)</code> to get syntax information for command <code>GetModules</code>.</p> <p>The Scripting Console window displays the required information:</p> <p></p> <p>For detailed information about individual parameters and allowed values, refer to topics TCL Command Reference and Python Command Reference.</p>"},{"location":"third-party-licenses.html","title":"Third-Party Licenses","text":"<p>The FPGA programming tool VisualApplets contains and uses some code not developed by Basler. This section lists the licenses used and names the authors.</p>"},{"location":"third-party-licenses.html#crashrpt","title":"CrashRpt","text":"<p>Copyright \u00a9 2003, The CrashRpt Project Authors.</p> <p>All rights reserved.</p> <p>Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:</p> <ul> <li>Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.</li> <li>Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.</li> <li>Neither the name of the author nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.</li> </ul> <p>THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.</p>"},{"location":"third-party-licenses.html#docbookweb-help","title":"DocBook/Web Help","text":"<p>DocBook Software License</p> <p>Copyright 1992-2000 HaL Computer Systems, Inc., O'Reilly &amp; Associates, Inc., ArborText, Inc., Fujitsu Software Corporation, Norman Walsh, and the Organization for the Advancement of Structured Information Standards (OASIS).</p> <p>Id: docbookx.dtd,v 1.13 2002/07/17 15:26:16 nwalsh Exp</p> <p>Permission to use, copy, modify and distribute the DocBook XML DTD and its accompanying documentation for any purpose and without fee is hereby granted in perpetuity, provided that the above copyright notice and this paragraph appear in all copies. The copyright holders make no representation about the suitability of the DTD for any purpose. It is provided as is without expressed or implied warranty.</p> <p>If you modify the DocBook DTD in any way, except for declaring and referencing additional sets of general entities and declaring additional notations, label your DTD as a variant of DocBook. See the maintenance documentation for more information.</p> <p>Please direct all questions, bug reports, or suggestions for changes to the docbook@lists.oasis-open.org mailing list. For more information, see http://www.oasis-open.org/docbook/.</p> <p>DocBook License</p> <p>DocBook and the DocBookStylesheets are 100% free software, meeting all terms of the GNU Free Software Definition, the Debian Free Software Guidelines, and the Open Source Definition. That means they're free not only in the sense that they're no-cost, but also in the sense that you're free to use them for any purpose, modify them in any way you want, and distribute your modified versions, without unnecessary restrictions and without needing to ask anybody for permission.</p> <p>However, you are asked to distribute modified version responsibly, meaning that you should name and label them variants so that users will not confuse them with the standard versions.</p> <p>As far as specific licenses, the wording of the license distributed with the DocBookStylesheets is pretty much the same as the MIT/X Consortium license, including the advertising clause, which states that:</p> <p>the names of individuals credited with contribution to this software shall not be used in advertising or otherwise to promote the sale, use or other dealings in this Software without prior written authorization from the individuals in question</p> <p>Though the license distributed with the DocBookDtd does not closely parallel the wording of any other well-known license, it is a 100% free software license.</p> <p>Both DocBook and the DocBookStylesheets are also copyrighted. The copyrights ensure that anybody who redistributes modified versions has to do it under the terms of the same 100% free-software license the copyright holders chose, so it all stays free.</p> <p>Web-based Help from DocBook XML</p> <p>David Cramer</p> <p>david@thingbag.net</p> <p>Kasun Gajasinghe</p> <p>kasunbg@gmail.com</p> <p>Copyright \u00a9 2008-2012 Kasun Gajasinghe, David Cramer</p> <p>Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the Software), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:</p> <ul> <li>The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.</li> <li>Except as contained in this notice, the names of individuals credited with contribution to this software shall not be used in advertising or otherwise to promote the sale, use or other dealings inthis Software without prior written authorization from the individuals in question.</li> <li>Any stylesheet derived from this Software that is publicly distributed will be identified with a different name and the version strings in any derived Software will be changed so that no possibility of confusion between the derived package and this Software will exist.</li> </ul> <p>Warranty: THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL DAVID CRAMER, KASUN GAJASINGHE, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.</p> <p>This package is maintained by Kasun Gajasinghe, kasunbg@gmail.com and David Cramer, david@thingbag.net.</p> <p>This package also includes the following software written and copyrighted by others:</p> <ul> <li>Files in template/common/jquery are copyrighted by JQuery under the MIT License. The file jquery.cookie.js Copyright \u00a9 2006 Klaus Hartl under the MIT license.</li> <li>Some files in the template/content/search and indexer directories were originally part of N. Quaine's htmlsearch DITA plugin. The tmlsearch DITA plugin is available from the files page of the DITA-users yahoogroup. The htmlsearch plugin was released under a BSD-style license. See indexer/license.txt for details.</li> <li>Stemmers from the Snowball project released under a BSD license.</li> <li>Code from the Apache Lucene search engine provides support for tokenizing Chinese, Japanese, and Korean content released under the Apache 2.0 license.</li> <li>Code that provides weighted search results and some other improvements was graciously donated by SyncRO Soft Ltd., the publishers of the oXygen XML Editor.</li> <li>Cosmetic improvements provided by OpenStack.</li> </ul> <p>Webhelp for DocBook was first developed as a Google Summer of Code project.</p> <p>January 2012</p> <p>Moin Moin GPL</p> <p>The GNU General Public License, version 2 (short: GNU GPLv2 or simply GPLv2) is a very popular Free Software License originally written by Richard Stallman for the GNU project and now kept and developed by the Free Software Foundation.</p> <p>Free in the context of this license means the freedom of the user of the software. Basically, the license gives everyone the right to do anything with the software provided they abide by certain (limited) restrictions: code licensed under GPL cannot be distributed in closed source programs.</p> <p>The MoinMoin code is licensed under the GPLv2 or (at the user's option) any later version (except some 3<sup>rd</sup> party modules we use that are licensed under other Free Software licenses compatible with the GPL).</p> <p>Consequences of this are, for example:</p> <p>Changes released by the community will be open source</p> <p>Encouragement and beneficiary of global collaboration.</p>"},{"location":"third-party-licenses.html#imagemagick","title":"ImageMagick","text":"<p>Copyright @ 1999 ImageMagick Studio LLC, a non-profit organization dedicated to making software imaging solutions freely available.</p> <ol> <li>Definitions.</li> </ol> <p>License shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9 of this document.</p> <p>Licensor shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.</p> <p>Legal Entity shall mean the union of the acting entity and all other entities that control, are controlled by, or are under common control with that entity. For the purposes of this definition, control means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such entity.</p> <p>You (or Your) shall mean an individual or Legal Entity exercising permissions granted by this License.</p> <p>Source form shall mean the preferred form for making modifications, including but not limited to software source code, documentation source, and configuration files.</p> <p>Object form shall mean any form resulting from mechanical transformation or translation of a Source form, including but not limited to compiled object code, generated documentation, and conversions to other media types.</p> <p>Work shall mean the work of authorship, whether in Source or Object form, made available under the License, as indicated by a copyright notice that is included in or attached to the work (an example is provided in the Appendix below).</p> <p>Derivative Works shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.</p> <p>Contribution shall mean any work of authorship, including the original version of the Work and any modifications or additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner. For the purposes of this definition, submitted means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding communication that is conspicuously marked or otherwise designated in writing by the copyright owner as Not a Contribution.</p> <p>Contributor shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received by Licensor and subsequently incorporated within the Work.</p> <ol> <li> <p>Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce, prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such Derivative Works in Source or Object form.</p> </li> <li> <p>Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s) with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this License for that Work shall terminate as of the date such litigation is filed.</p> </li> <li> <p>Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with or without modifications, and in Source or Object form, provided that You meet the following conditions:</p> </li> <li> <p>You must give any other recipients of the Work or Derivative Works a copy of this License; and</p> </li> <li>You must cause any modified files to carry prominent notices stating that You changed the files; and</li> <li>You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark, and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the Derivative Works; and</li> <li> <p>If the Work includes a NOTICE text file as part of its distribution, then any Derivative Works that You distribute must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the License. You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.</p> </li> <li> <p>Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate license agreement you may have executed with Licensor regarding such Contributions.</p> </li> <li> <p>Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and reproducing the content of the NOTICE file.</p> </li> <li> <p>Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and each Contributor provides its Contributions) on an AS IS BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this License.</p> </li> <li> <p>Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing, shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or consequential damages of any character arising as a result of this License or out of the use or inability to use the Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such damages.</p> </li> <li> <p>Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason of your accepting any such warranty or additional liability.</p> </li> </ol>"},{"location":"third-party-licenses.html#info-zip","title":"Info Zip","text":"<p>Copyright \u00a9 1990-2007 Info-ZIP. All rights reserved.</p> <p>For the purposes of this copyright and license, Info-ZIP is defined as the following set of individuals:</p> <p>Mark Adler, John Bush, Karl Davis, Harald Denker, Jean-Michel Dubois,   Jean-loup Gailly, Hunter Goatley, Ed Gordon, Ian Gorman, Chris Herborth,   Dirk Haase, Greg Hartwig, Robert Heath, Jonathan Hudson, Paul Kienitz,   David Kirschbaum, Johnny Lee, Onno van der Linden, Igor Mandrichenko,   Steve P. Miller, Sergio Monesi, Keith Owens, George Petrov, Greg Roelofs,   Kai Uwe Rommel, Steve Salisbury, Dave Smith, Steven M. Schweda,   Christian Spieler, Cosmin Truta, Antoine Verheijen, Paul von Behren,   Rich Wales, Mike White.</p> <p>This software is provided as is, without warranty of any kind, express or implied. In no event shall Info-ZIP or its contributors be held liable for any direct, indirect, incidental, special or consequential damages arising out of the use of or inability to use this software.</p> <p>Permission is granted to anyone to use this software for any purpose, including commercial applications, and to alter it and redistribute it freely, subject to the above disclaimer and the following restrictions:</p> <ol> <li>Redistributions of source code (in whole or in part) must retain the above copyright notice, definition, disclaimer, and this list of conditions.</li> <li>Redistributions in binary form (compiled executables and libraries) must reproduce the above copyright notice, definition, disclaimer, and this list of conditions in documentation and/or other materials provided with the distribution. The sole exception to this condition is redistribution of a standard UnZipSFX binary (including SFXWiz) as part of a self-extracting archive; that is permitted without inclusion of this license, as long as the normal SFX banner has not been removed from the binary or disabled.</li> <li>Altered versions\u2013including, but not limited to, ports to new operating systems, existing ports with new graphical interfaces, versions with modified or added functionality, and dynamic, shared, or static library versions not from Info-ZIP\u2013must be plainly marked as such and must not be misrepresented as being the original source or, if binaries, compiled from the original source. Such altered versions also must not be misrepresented as being Info-ZIP releases\u2013including, but not limited to, labeling of the altered versions with the names Info-ZIP (or any variation thereof, including, but not limited to, different capitalizations), Pocket UnZip, WiZ or MacZip without the explicit permission of Info-ZIP. Such altered versions are further prohibited from misrepresentative use of the Zip-Bugs or Info-ZIP e-mail addresses or the Info-ZIP URL(s), such as to imply Info-ZIP will provide support for the altered versions.</li> <li>Info-ZIP retains the right to use the names Info-ZIP, Zip, UnZip, UnZipSFX, WiZ, Pocket UnZip, Pocket Zip, and MacZip for its own source and binary releases.</li> </ol>"},{"location":"third-party-licenses.html#jsoncpp","title":"JsonCpp","text":"<p>Copyright \u00a9 2007-2010 Baptiste Lepilleur and The JsonCpp Authors</p> <p>Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the Software), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:</p> <p>The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.</p> <p>THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.</p>"},{"location":"third-party-licenses.html#libtiff","title":"LibTIFF","text":"<p>LIBTIFF Copyright \u00a9 1988-1996 Sam Leffler Copyright \u00a9 1991-1996 Silicon Graphics, Inc.</p> <p>Permission to use, copy, modify, distribute, and sell this software and its documentation for any purpose is hereby granted without fee, provided that (i) the above copyright notices and this permission notice appear in all copies of the software and related documentation, and (ii) the names of Sam Leffler and Silicon Graphics may not be used in any advertising or publicity relating to the software without the specific, prior written permission of Sam Leffler and Silicon Graphics.</p> <p>THE SOFTWARE IS PROVIDED AS-IS AND WITHOUT WARRANTY OF ANY KIND, EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.</p> <p>IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.</p>"},{"location":"third-party-licenses.html#libzip","title":"libzip","text":"<p>Copyright \u00a9 1999-2020 Dieter Baron and Thomas Klausner</p> <p>The authors can be contacted at info@libzip.org</p> <p>Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:</p> <ol> <li> <p>Redistributions of source code must retain the above copyright  notice, this list of conditions and the following disclaimer.</p> </li> <li> <p>Redistributions in binary form must reproduce the above copyright  notice, this list of conditions and the following disclaimer in  the documentation and/or other materials provided with the  distribution.</p> </li> <li> <p>The names of the authors may not be used to endorse or promote  products derived from this software without specific prior  written permission.</p> </li> </ol> <p>THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.</p>"},{"location":"third-party-licenses.html#mingw","title":"MinGW","text":"<p>Each of the various packages, which is distributed by MinGW.org, is governed by its own individual copyright and licensing terms. In summary, for the most commonly deployed packages:</p> <p>MinGW Runtime: All releases of the MinGW base runtime package, prior to release 4.0, have been placed in the public domain, and are not governed by copyright. This basically means that you can do what you like with the code.</p> <p>Due to inadmissibility of the public domain concept, in certain jurisdictions, we have now chosen to adopt a MIT style license for the principal components of the MinGW runtime, from release 4.0 onwards; you may view this LICENSE, as it is filed in the source code repository. Note that this new license does not carry forward to needing to distribution of said license when you use the MinGW Runtime to build your source. It only covers the distribution of the library, in source or binary form or any part thereof such as mingwm10.dll.</p> <p>w32api: In the case of releases prior to 4.0: you are free to use, modify and copy this package. No restrictions are imposed on programs or object files linked with this library. You may not restrict the the usage of this library. You may distribute this library as part of another package or as a modified package if, and only if, you do not restrict the usage of the portions consisting of this (optionally modified) library. If distributed as a modified package, then a copy of this notice must be included.</p> <p>This library is distributed in the hope that it will be useful, but WITHOUT WARRANTY OF ANY KIND; without even the implied warranties of MERCHANTABILITY or of FITNESS FOR A PARTICULAR PURPOSE.</p> <p>Due to inadmissibility of the public domain concept, in certain jurisdictions, we have now chosen to adopt a MIT style license for the principal components of the w32api, from release 4.0 onwards; you may view this LICENSE, as it is filed in the source code repository. Note that this new license does not carry forward to needing to distribution of said license when you use the w32api to build your source. It only covers the distribution of the library, in source or binary form or any part thereof such as mingwm10.dll.</p> <p>WSL: We have combined the MinGW runtime package and the w32api package into one, which we have dubbed WSL, (an acronym for Windows System Libraries). We have applied a MIT style license to the sources, (where this does not conflict with any existing licenses applying to specific sub-components). You may view this LICENSE, as it is filed in the source code repository. Note that this new license does not carry forward to needing to distribution of said license when you use the WSL to build your source. It only covers the distribution of the library, in source or binary form or any part thereof such as mingwm10.dll.</p> <p>MinGW Profiling Code: MinGW profiling code is distributed under the terms of the GNU General Public License, Version 2.</p> <p>Binutils, GCC, GDB, GNU Make: All of the GNU development tools, such as GNU binutils, GCC, GDB and GNU Make, are governed by the terms of the GNU General Public License; (note that this may be GPLv2 or GPLv3, depending on the preferences of the upstream maintainers, and the specific version of each package which you choose to install; in most cases, the most recent versions are likely to be GPLv3, while older versions may be GPLv2).</p>"},{"location":"third-party-licenses.html#gplv2","title":"GPLv2","text":"<p>GNU GENERAL PUBLIC LICENSE</p> <p>Version 2, June 1991</p> <p>Copyright \u00a9 1989, 1991 Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA</p> <p>Everyone is permitted to copy and distribute verbatim copies of this license document, but changing it is not allowed.</p> <p>Preamble</p> <p>The licenses for most software are designed to take away your freedom to share and change it. By contrast, the GNU General Public License is intended to guarantee your freedom to share and change free software\u2013to make sure the software is free for all its users. This General Public License applies to most of the Free Software Foundation's software and to any other program whose authors commit to using it. (Some other Free Software Foundation software is covered by the GNU Lesser General Public License instead.) You can apply it to your programs, too.</p> <p>When we speak of free software, we are referring to freedom, not price. Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for this service if you wish), that you receive source code or can get it if you want it, that you can change the software or use pieces of it in new free programs; and that you know you can do these things.</p> <p>To protect your rights, we need to make restrictions that forbid anyone to deny you these rights or to ask you to surrender the rights.</p> <p>These restrictions translate to certain responsibilities for you if you distribute copies of the software, or if you modify it. For example, if you distribute copies of such a program, whether gratis or for a fee, you must give the recipients all the rights that you have. You must make sure that they, too, receive or can get the source code. And you must show them these terms so they know their rights.</p> <p>We protect your rights with two steps: (1) copyright the software, and (2) offer you this license which gives you legal permission to copy, distribute and/or modify the software. Also, for each author's protection and ours, we want to make certain that everyone understands that there is no warranty for this free software. If the software is modified by someone else and passed on, we want its recipients to know that what they have is not the original, so that any problems introduced by others will not reflect on the original authors' reputations.</p> <p>Finally, any free program is threatened constantly by software patents. We wish to avoid the danger that redistributors of a free program will individually obtain patent licenses, in effect making the program proprietary. To prevent this, we have made it clear that any patent must be licensed for everyone's free use or not licensed at all.</p> <p>The precise terms and conditions for copying, distribution and modification follow.</p> <p>GNU GENERAL PUBLIC LICENSE</p> <p>TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION</p> <p>1) This License applies to any program or other work which contains a notice placed by the copyright holder saying it may be distributed under the terms of this General Public License. The Program, below, refers to any such program or work, and a work based on the Program means either the Program or any derivative work under copyright law: that is to say, a work containing the Program or a portion of it, either verbatim or with modifications and/or translated into another language. (Hereinafter, translation is included without limitation in the term modification.) Each licensee is addressed as you.</p> <p>Activities other than copying, distribution and modification are not covered by this License; they are outside its scope. The act of running the Program is not restricted, and the output from the Program is covered only if its contents constitute a work based on the Program (independent of having been made by running the Program).</p> <p>Whether that is true depends on what the Program does.</p> <p>1) You may copy and distribute verbatim copies of the Program's source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice and disclaimer of warranty; keep intact all the notices that refer to this License and to the absence of any warranty; and give any other recipients of the Program a copy of this License along with the Program.</p> <p>You may charge a fee for the physical act of transferring a copy, and you may at your option offer warranty protection in exchange for a fee.</p> <p>2) You may modify your copy or copies of the Program or any portion of it, thus forming a work based on the Program, and copy and distribute such modifications or work under the terms of Section 1 above, provided that you also meet all of these conditions:</p> <p>a) You must cause the modified files to carry prominent notices stating that you changed the files and the date of any change.</p> <p>b) You must cause any work that you distribute or publish, that in whole or in part contains or is derived from the Program or any part thereof, to be licensed as a whole at no charge to all third parties under the terms of this License.</p> <p>c) If the modified program normally reads commands interactively when run, you must cause it, when started running for such interactive use in the most ordinary way, to print or display an announcement including an appropriate copyright notice and a notice that there is no warranty (or else, saying that you provide a warranty) and that users may redistribute the program under these conditions, and telling the user how to view a copy of this License. (Exception: if the Program itself is interactive but does not normally print such an announcement, your work based on the Program is not required to print an announcement.)</p> <p>These requirements apply to the modified work as a whole. If identifiable sections of that work are not derived from the Program, and can be reasonably considered independent and separate works in themselves, then this License, and its terms, do not apply to those sections when you distribute them as separate works. But when you distribute the same sections as part of a whole which is a work based on the Program, the distribution of the whole must be on the terms of this License, whose permissions for other licensees extend to the entire whole, and thus to each and every part regardless of who wrote it.</p> <p>Thus, it is not the intent of this section to claim rights or contest your rights to work written entirely by you; rather, the intent is to exercise the right to control the distribution of derivative or collective works based on the Program.</p> <p>In addition, mere aggregation of another work not based on the Program with the Program (or with a work based on the Program) on a volume of a storage or distribution medium does not bring the other work under the scope of this License.</p> <p>3) You may copy and distribute the Program (or a work based on it, under Section 2) in object code or executable form under the terms of Sections 1 and 2 above provided that you also do one of the following:</p> <p>a) Accompany it with the complete corresponding machine-readable source code, which must be distributed under the terms of Sections 1 and 2 above on a medium customarily used for software interchange; or,</p> <p>b) Accompany it with a written offer, valid for at least three years, to give any third party, for a charge no more than your cost of physically performing source distribution, a complete machine-readable copy of the corresponding source code, to be distributed under the terms of Sections 1 and 2 above on a medium customarily used for software interchange; or,</p> <p>c) Accompany it with the information you received as to the offer to distribute corresponding source code. (This alternative is allowed only for noncommercial distribution and only if you received the program in object code or executable form with such an offer, in accord with Subsection b above.)</p> <p>The source code for a work means the preferred form of the work for making modifications to it. For an executable work, complete source code means all the source code for all modules it contains, plus any associated interface definition files, plus the scripts used to control compilation and installation of the executable. However, as a special exception, the source code distributed need not include anything that is normally distributed (in either source or binary form) with the major components (compiler, kernel, and so on) of the operating system on which the executable runs, unless that component itself accompanies the executable.</p> <p>If distribution of executable or object code is made by offering access to copy from a designated place, then offering equivalent access to copy the source code from the same place counts as distribution of the source code, even though third parties are not compelled to copy the source along with the object code.</p> <p>4) You may not copy, modify, sublicense, or distribute the Program except as expressly provided under this License. Any attempt otherwise to copy, modify, sublicense or distribute the Program is void, and will automatically terminate your rights under this License.</p> <p>However, parties who have received copies, or rights, from you under this License will not have their licenses terminated so long as such parties remain in full compliance.</p> <p>5) You are not required to accept this License, since you have not signed it. However, nothing else grants you permission to modify or distribute the Program or its derivative works. These actions are prohibited by law if you do not accept this License. Therefore, by modifying or distributing the Program (or any work based on the Program), you indicate your acceptance of this License to do so, and all its terms and conditions for copying, distributing or modifying the Program or works based on it.</p> <p>6) Each time you redistribute the Program (or any work based on the Program), the recipient automatically receives a license from the original licensor to copy, distribute or modify the Program subject to these terms and conditions. You may not impose any further restrictions on the recipients' exercise of the rights granted herein. You are not responsible for enforcing compliance by third parties to this License.</p> <p>7) If, as a consequence of a court judgment or allegation of patent infringement or for any other reason (not limited to patent issues), conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License. If you cannot distribute so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may not distribute the Program at all. For example, if a patent license would not permit royalty-free redistribution of the Program by all those who receive copies directly or indirectly through you, then the only way you could satisfy both it and this License would be to refrain entirely from distribution of the Program.</p> <p>If any portion of this section is held invalid or unenforceable under any particular circumstance, the balance of the section is intended to apply and the section as a whole is intended to apply in other circumstances.</p> <p>It is not the purpose of this section to induce you to infringe any patents or other property right claims or to contest validity of any such claims; this section has the sole purpose of protecting the integrity of the free software distribution system, which is implemented by public license practices. Many people have made generous contributions to the wide range of software distributed through that system in reliance on consistent application of that system; it is up to the author/donor to decide if he or she is willing to distribute software through any other system and a licensee cannot impose that choice.</p> <p>This section is intended to make thoroughly clear what is believed to be a consequence of the rest of this License.</p> <p>8) If the distribution and/or use of the Program is restricted in certain countries either by patents or by copyrighted interfaces, the original copyright holder who places the Program under this License may add an explicit geographical distribution limitation excluding those countries, so that distribution is permitted only in or among countries not thus excluded. In such case, this License incorporates the limitation as if written in the body of this License.</p> <p>9) The Free Software Foundation may publish revised and/or new versions of the General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.</p> <p>Each version is given a distinguishing version number. If the Program specifies a version number of this License which applies to it and any later version, you have the option of following the terms and conditions either of that version or of any later version published by the Free Software Foundation. If the Program does not specify a version number of this License, you may choose any version ever published by the Free Software Foundation.</p> <p>10) If you wish to incorporate parts of the Program into other free programs whose distribution conditions are different, write to the author to ask for permission. For software which is copyrighted by the Free Software Foundation, write to the Free Software Foundation; we sometimes make exceptions for this. Our decision will be guided by the two goals of preserving the free status of all derivatives of our free software and of promoting the sharing and reuse of software generally.</p> <p>NO WARRANTY</p> <p>11) BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.</p> <p>12) IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</p> <p>END OF TERMS AND CONDITIONS</p> <p>How to Apply These Terms to Your New Programs</p> <p>If you develop a new program, and you want it to be of the greatest possible use to the public, the best way to achieve this is to make it free software which everyone can redistribute and change under these terms.</p> <p>To do so, attach the following notices to the program. It is safest to attach them to the start of each source file to most effectively convey the exclusion of warranty; and each file should have at least the copyright line and a pointer to where the full notice is found.</p> <p>\\&lt;one line to give the program's name and a brief idea of what it does.&gt;</p> <p>Copyright \u00a9 \\&lt;year&gt; \\&lt;name of author&gt;</p> <p>This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.</p> <p>This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.</p> <p>You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.</p> <p>Also add information on how to contact you by electronic and paper mail. If the program is interactive, make it output a short notice like this when it starts in an interactive mode:</p> <p>Gnomovision version 69, Copyright \u00a9 year name of author</p> <p>Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type 'show w'.</p> <p>This is free software, and you are welcome to redistribute it under certain conditions; type 'show c' for details.</p> <p>The hypothetical commands 'show w' and 'show c' should show the appropriate parts of the General Public License. Of course, the commands you use may be called something other than 'show w' and 'show c'; they could even be mouse-clicks or menu items\u2013whatever suits your program.</p> <p>You should also get your employer (if you work as a programmer) or your school, if any, to sign a copyright disclaimer for the program, if necessary. Here is a sample; alter the names:</p> <p>Yoyodyne, Inc., hereby disclaims all copyright interest in the program</p> <p>'Gnomovision' (which makes passes at compilers) written by James Hacker.</p> <p>signature of Ty Coon, 1 April 1989</p> <p>Ty Coon, President of Vice</p> <p>This General Public License does not permit incorporating your program into proprietary programs. If your program is a subroutine library, you may consider it more useful to permit linking proprietary applications with the library. If this is what you want to do, use the GNU Lesser General Public License instead of this License.</p> <p>GNU GENERAL PUBLIC LICENSE</p> <p>Version 3, 29 June 2007</p> <p>Copyright 2007 Free Software Foundation, Inc. http://fsf.org/</p> <p>Everyone is permitted to copy and distribute verbatim copies of this license document, but changing it is not allowed.</p> <p>Preamble</p> <p>The GNU General Public License is a free, copyleft license for software and other kinds of works.</p> <p>The licenses for most software and other practical works are designed to take away your freedom to share and change the works. By contrast, the GNU General Public License is intended to guarantee your freedom to share and change all versions of a program--to make sure it remains free software for all its users. We, the Free Software Foundation, use the GNU General Public License for most of our software; it applies also to any other work released this way by its authors. You can apply it to your programs, too.</p> <p>When we speak of free software, we are referring to freedom, not price. Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for them if you wish), that you receive source code or can get it if you want it, that you can change the software or use pieces of it in new free programs, and that you know you can do these things.</p> <p>To protect your rights, we need to prevent others from denying you these rights or asking you to surrender the rights. Therefore, you have certain responsibilities if you distribute copies of the software, or if you modify it: responsibilities to respect the freedom of others.</p> <p>For example, if you distribute copies of such a program, whether gratis or for a fee, you must pass on to the recipients the same freedoms that you received. You must make sure that they, too, receive or can get the source code. And you must show them these terms so they know their rights.</p> <p>Developers that use the GNU GPL protect your rights with two steps: (1) assert copyright on the software, and (2) offer you this License giving you legal permission to copy, distribute and/or modify it.</p> <p>For the developers' and authors' protection, the GPL clearly explains that there is no warranty for this free software. For both users' and authors' sake, the GPL requires that modified versions be marked as changed, so that their problems will not be attributed erroneously to authors of previous versions.</p> <p>Some devices are designed to deny users access to install or run modified versions of the software inside them, although the manufacturer can do so. This is fundamentally incompatible with the aim of protecting users' freedom to change the software. The systematic pattern of such abuse occurs in the area of products for individuals to use, which is precisely where it is most unacceptable. Therefore, we have designed this version of the GPL to prohibit the practice for those products. If such problems arise substantially in other domains, we stand ready to extend this provision to those domains in future versions of the GPL, as needed to protect the freedom of users.</p> <p>Finally, every program is threatened constantly by software patents. States should not allow patents to restrict development and use of software on general-purpose computers, but in those that do, we wish to avoid the special danger that patents applied to a free program could make it effectively proprietary. To prevent this, the GPL assures that patents cannot be used to render the program non-free.</p> <p>The precise terms and conditions for copying, distribution and modification follow.</p> <p>TERMS AND CONDITIONS</p> <p>0. Definitions.</p> <p>This License refers to version 3 of the GNU General Public License.</p> <p>Copyright also means copyright-like laws that apply to other kinds of works, such as semiconductor masks.</p> <p>The Program refers to any copyrightable work licensed under this License. Each licensee is addressed as you. Licensees and recipients may be individuals or organizations.</p> <p>To modify a work means to copy from or adapt all or part of the work in a fashion requiring copyright permission, other than the making of an exact copy. The resulting work is called a modified version of the earlier work or a work based on the earlier work.</p> <p>A covered work means either the unmodified Program or a work based on the Program.</p> <p>To propagate a work means to do anything with it that, without permission, would make you directly or secondarily liable for infringement under applicable copyright law, except executing it on a computer or modifying a private copy. Propagation includes copying, distribution (with or without modification), making available to the public, and in some countries other activities as well.</p> <p>To convey a work means any kind of propagation that enables other parties to make or receive copies. Mere interaction with a user through a computer network, with no transfer of a copy, is not conveying.</p> <p>An interactive user interface displays Appropriate Legal Notices to the extent that it includes a convenient and prominently visible feature that (1) displays an appropriate copyright notice, and (2) tells the user that there is no warranty for the work (except to the extent that warranties are provided), that licensees may convey the work under this License, and how to view a copy of this License. If the interface presents a list of user commands or options, such as a menu, a prominent item in the list meets this criterion.</p> <p>1. Source Code.</p> <p>The source code for a work means the preferred form of the work for making modifications to it. Object code means any non-source form of a work.</p> <p>A Standard Interface means an interface that either is an official standard defined by a recognized standards body, or, in the case of interfaces specified for a particular programming language, one that is widely used among developers working in that language.</p> <p>The System Libraries of an executable work include anything, other than the work as a whole, that (a) is included in the normal form of packaging a Major Component, but which is not part of that Major Component, and (b) serves only to enable use of the work with that Major Component, or to implement a Standard Interface for which an implementation is available to the public in source code form. A Major Component, in this context, means a major essential component (kernel, window system, and so on) of the specific operating system (if any) on which the executable work runs, or a compiler used to produce the work, or an object code interpreter used to run it.</p> <p>The Corresponding Source for a work in object code form means all the source code needed to generate, install, and (for an executable work) run the object code and to modify the work, including scripts to control those activities. However, it does not include the work's System Libraries, or general-purpose tools or generally available free programs which are used unmodified in performing those activities but which are not part of the work. For example, Corresponding Source includes interface definition files associated with source files for the work, and the source code for shared libraries and dynamically linked subprograms that the work is specifically designed to require, such as by intimate data communication or control flow between those subprograms and other parts of the work.</p> <p>The Corresponding Source need not include anything that users can regenerate automatically from other parts of the Corresponding Source.</p> <p>The Corresponding Source for a work in source code form is that same work.</p> <p>2. Basic Permissions.</p> <p>All rights granted under this License are granted for the term of copyright on the Program, and are irrevocable provided the stated conditions are met. This License explicitly affirms your unlimited permission to run the unmodified Program. The output from running a covered work is covered by this License only if the output, given its content, constitutes a covered work. This License acknowledges your rights of fair use or other equivalent, as provided by copyright law.</p> <p>You may make, run and propagate covered works that you do not convey, without conditions so long as your license otherwise remains in force. You may convey covered works to others for the sole purpose of having them make modifications exclusively for you, or provide you with facilities for running those works, provided that you comply with the terms of this License in conveying all material for which you do not control copyright. Those thus making or running the covered works for you must do so exclusively on your behalf, under your direction and control, on terms that prohibit them from making any copies of your copyrighted material outside their relationship with you.</p> <p>Conveying under any other circumstances is permitted solely under the conditions stated below. Sublicensing is not allowed; section 10 makes it unnecessary.</p> <p>3. Protecting Users' Legal Rights From Anti-Circumvention Law.</p> <p>No covered work shall be deemed part of an effective technological measure under any applicable law fulfilling obligations under article 11 of the WIPO copyright treaty adopted on 20 December 1996, or similar laws prohibiting or restricting circumvention of such measures.</p> <p>When you convey a covered work, you waive any legal power to forbid circumvention of technological measures to the extent such circumvention is effected by exercising rights under this License with respect to the covered work, and you disclaim any intention to limit operation or modification of the work as a means of enforcing, against the work's users, your or third parties' legal rights to forbid circumvention of technological measures.</p> <p>4. Conveying Verbatim Copies.</p> <p>You may convey verbatim copies of the Program's source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice; keep intact all notices stating that this License and any non-permissive terms added in accord with section 7 apply to the code; keep intact all notices of the absence of any warranty; and give all recipients a copy of this License along with the Program.</p> <p>You may charge any price or no price for each copy that you convey, and you may offer support or warranty protection for a fee.</p> <p>5. Conveying Modified Source Versions.</p> <p>You may convey a work based on the Program, or the modifications to produce it from the Program, in the form of source code under the terms of section 4, provided that you also meet all of these conditions:</p> <p>a) The work must carry prominent notices stating that you modified it, and giving a relevant date.</p> <p>b) The work must carry prominent notices stating that it is released under this License and any conditions added under section 7. This requirement modifies the requirement in section 4 to keep intact all notices.</p> <p>c) You must license the entire work, as a whole, under this License to anyone who comes into possession of a copy. This License will therefore apply, along with any applicable section 7 additional terms, to the whole of the work, and all its parts, regardless of how they are packaged. This License gives no permission to license the work in any other way, but it does not invalidate such permission if you have separately received it.</p> <p>d) If the work has interactive user interfaces, each must display Appropriate Legal Notices; however, if the Program has interactive interfaces that do not display Appropriate Legal Notices, your work need not make them do so.</p> <p>A compilation of a covered work with other separate and independent works, which are not by their nature extensions of the covered work, and which are not combined with it such as to form a larger program, in or on a volume of a storage or distribution medium, is called an aggregate if the compilation and its resulting copyright are not used to limit the access or legal rights of the compilation's users beyond what the individual works permit. Inclusion of a covered work in an aggregate does not cause this License to apply to the other parts of the aggregate.</p> <p>6. Conveying Non-Source Forms.</p> <p>You may convey a covered work in object code form under the terms of sections 4 and 5, provided that you also convey the machine-readable Corresponding Source under the terms of this License, in one of these ways:</p> <p>a) Convey the object code in, or embodied in, a physical product (including a physical distribution medium), accompanied by the Corresponding Source fixed on a durable physical medium customarily used for software interchange.</p> <p>b) Convey the object code in, or embodied in, a physical product (including a physical distribution medium), accompanied by a written offer, valid for at least three years and valid for as long as you offer spare parts or customer support for that product model, to give anyone who possesses the object code either (1) a copy of the Corresponding Source for all the software in the product that is covered by this License, on a durable physical medium customarily used for software interchange, for a price no more than your reasonable cost of physically performing this conveying of source, or (2) access to copy the Corresponding Source from a network server at no charge.</p> <p>c) Convey individual copies of the object code with a copy of the written offer to provide the Corresponding Source. This alternative is allowed only occasionally and noncommercially, and only if you received the object code with such an offer, in accord with subsection 6b.</p> <p>d) Convey the object code by offering access from a designated place (gratis or for a charge), and offer equivalent access to the Corresponding Source in the same way through the same place at no further charge. You need not require recipients to copy the Corresponding Source along with the object code. If the place to copy the object code is a network server, the Corresponding Source may be on a different server (operated by you or a third party) that supports equivalent copying facilities, provided you maintain clear directions next to the object code saying where to find the Corresponding Source. Regardless of what server hosts the Corresponding Source, you remain obligated to ensure that it is available for as long as needed to satisfy these requirements.</p> <p>e) Convey the object code using peer-to-peer transmission, provided you inform other peers where the object code and Corresponding Source of the work are being offered to the general public at no charge under subsection 6d.</p> <p>A separable portion of the object code, whose source code is excluded from the Corresponding Source as a System Library, need not be included in conveying the object code work.</p> <p>A User Product is either (1) a consumer product, which means any tangible personal property which is normally used for personal, family, or household purposes, or (2) anything designed or sold for incorporation into a dwelling. In determining whether a product is a consumer product, doubtful cases shall be resolved in favor of coverage. For a particular product received by a particular user, normally used refers to a typical or common use of that class of product, regardless of the status of the particular user or of the way in which the particular user actually uses, or expects or is expected to use, the product. A product is a consumer product regardless of whether the product has substantial commercial, industrial or non-consumer uses, unless such uses represent the only significant mode of use of the product.</p> <p>Installation Information for a User Product means any methods, procedures, authorization keys, or other information required to install and execute modified versions of a covered work in that User Product from a modified version of its Corresponding Source. The information must suffice to ensure that the continued functioning of the modified object code is in no case prevented or interfered with solely because modification has been made.</p> <p>If you convey an object code work under this section in, or with, or specifically for use in, a User Product, and the conveying occurs as part of a transaction in which the right of possession and use of the User Product is transferred to the recipient in perpetuity or for a fixed term (regardless of how the transaction is characterized), the Corresponding Source conveyed under this section must be accompanied by the Installation Information. But this requirement does not apply if neither you nor any third party retains the ability to install modified object code on the User Product (for example, the work has been installed in ROM).</p> <p>The requirement to provide Installation Information does not include a requirement to continue to provide support service, warranty, or updates for a work that has been modified or installed by the recipient, or for the User Product in which it has been modified or installed. Access to a network may be denied when the modification itself materially and adversely affects the operation of the network or violates the rules and protocols for communication across the network.</p> <p>Corresponding Source conveyed, and Installation Information provided, in accord with this section must be in a format that is publicly documented (and with an implementation available to the public in source code form), and must require no special password or key for unpacking, reading or copying.</p> <p>7. Additional Terms.</p> <p>Additional permissions are terms that supplement the terms of this License by making exceptions from one or more of its conditions. Additional permissions that are applicable to the entire Program shall be treated as though they were included in this License, to the extent that they are valid under applicable law. If additional permissions apply only to part of the Program, that part may be used separately under those permissions, but the entire Program remains governed by this License without regard to the additional permissions.</p> <p>When you convey a copy of a covered work, you may at your option remove any additional permissions from that copy, or from any part of it. (Additional permissions may be written to require their own removal in certain cases when you modify the work.) You may place additional permissions on material, added by you to a covered work, for which you have or can give appropriate copyright permission.</p> <p>Notwithstanding any other provision of this License, for material you add to a covered work, you may (if authorized by the copyright holders of that material) supplement the terms of this License with terms:</p> <p>a) Disclaiming warranty or limiting liability differently from the terms of sections 15 and 16 of this License; or</p> <p>b) Requiring preservation of specified reasonable legal notices or author attributions in that material or in the Appropriate Legal Notices displayed by works containing it; or</p> <p>c) Prohibiting misrepresentation of the origin of that material, or requiring that modified versions of such material be marked in reasonable ways as different from the original version; or</p> <p>d) Limiting the use for publicity purposes of names of licensors or authors of the material; or</p> <p>e) Declining to grant rights under trademark law for use of some trade names, trademarks, or service marks; or</p> <p>f) Requiring indemnification of licensors and authors of that material by anyone who conveys the material (or modified versions of it) with contractual assumptions of liability to the recipient, for any liability that these contractual assumptions directly impose on those licensors and authors.</p> <p>All other non-permissive additional terms are considered further restrictions within the meaning of section 10. If the Program as you received it, or any part of it, contains a notice stating that it is governed by this License along with a term that is a further restriction, you may remove that term. If a license document contains a further restriction but permits relicensing or conveying under this License, you may add to a covered work material governed by the terms of that license document, provided that the further restriction does not survive such relicensing or conveying.</p> <p>If you add terms to a covered work in accord with this section, you must place, in the relevant source files, a statement of the additional terms that apply to those files, or a notice indicating where to find the applicable terms.</p> <p>Additional terms, permissive or non-permissive, may be stated in the form of a separately written license, or stated as exceptions; the above requirements apply either way.</p> <p>8. Termination.</p> <p>You may not propagate or modify a covered work except as expressly provided under this License. Any attempt otherwise to propagate or modify it is void, and will automatically terminate your rights under this License (including any patent licenses granted under the third paragraph of section 11).</p> <p>However, if you cease all violation of this License, then your license from a particular copyright holder is reinstated (a) provisionally, unless and until the copyright holder explicitly and finally terminates your license, and (b) permanently, if the copyright holder fails to notify you of the violation by some reasonable means prior to 60 days after the cessation.</p> <p>Moreover, your license from a particular copyright holder is reinstated permanently if the copyright holder notifies you of the violation by some reasonable means, this is the first time you have received notice of violation of this License (for any work) from that copyright holder, and you cure the violation prior to 30 days after your receipt of the notice.</p> <p>Termination of your rights under this section does not terminate the licenses of parties who have received copies or rights from you under this License. If your rights have been terminated and not permanently reinstated, you do not qualify to receive new licenses for the same material under section 10.</p> <p>9. Acceptance Not Required for Having Copies.</p> <p>You are not required to accept this License in order to receive or run a copy of the Program. Ancillary propagation of a covered work occurring solely as a consequence of using peer-to-peer transmission to receive a copy likewise does not require acceptance. However, nothing other than this License grants you permission to propagate or modify any covered work. These actions infringe copyright if you do not accept this License. Therefore, by modifying or propagating a covered work, you indicate your acceptance of this License to do so.</p> <p>10. Automatic Licensing of Downstream Recipients.</p> <p>Each time you convey a covered work, the recipient automatically receives a license from the original licensors, to run, modify and propagate that work, subject to this License. You are not responsible for enforcing compliance by third parties with this License.</p> <p>An entity transaction is a transaction transferring control of an organization, or substantially all assets of one, or subdividing an organization, or merging organizations. If propagation of a covered work results from an entity transaction, each party to that transaction who receives a copy of the work also receives whatever licenses to the work the party's predecessor in interest had or could give under the previous paragraph, plus a right to possession of the Corresponding Source of the work from the predecessor in interest, if the predecessor has it or can get it with reasonable efforts.</p> <p>You may not impose any further restrictions on the exercise of the rights granted or affirmed under this License. For example, you may not impose a license fee, royalty, or other charge for exercise of rights granted under this License, and you may not initiate litigation (including a cross-claim or counterclaim in a lawsuit) alleging that any patent claim is infringed by making, using, selling, offering for sale, or importing the Program or any portion of it.</p> <p>11. Patents.</p> <p>A contributor is a copyright holder who authorizes use under this License of the Program or a work on which the Program is based. The work thus licensed is called the contributor's contributor version.</p> <p>A contributor's essential patent claims are all patent claims owned or controlled by the contributor, whether already acquired or hereafter acquired, that would be infringed by some manner, permitted by this License, of making, using, or selling its contributor version, but do not include claims that would be infringed only as a consequence of further modification of the contributor version. For purposes of this definition, control includes the right to grant patent sublicenses in a manner consistent with the requirements of this License.</p> <p>Each contributor grants you a non-exclusive, worldwide, royalty-free patent license under the contributor's essential patent claims, to make, use, sell, offer for sale, import and otherwise run, modify and propagate the contents of its contributor version.</p> <p>In the following three paragraphs, a patent license is any express agreement or commitment, however denominated, not to enforce a patent (such as an express permission to practice a patent or covenant not to sue for patent infringement). To grant such a patent license to a party means to make such an agreement or commitment not to enforce a patent against the party.</p> <p>If you convey a covered work, knowingly relying on a patent license, and the Corresponding Source of the work is not available for anyone to copy, free of charge and under the terms of this License, through a publicly available network server or other readily accessible means, then you must either (1) cause the Corresponding Source to be so available, or (2) arrange to deprive yourself of the benefit of the patent license for this particular work, or (3) arrange, in a manner consistent with the requirements of this License, to extend the patent license to downstream recipients. Knowingly relying means you have actual knowledge that, but for the patent license, your conveying the covered work in a country, or your recipient's use of the covered work in a country, would infringe one or more identifiable patents in that country that you have reason to believe are valid.</p> <p>If, pursuant to or in connection with a single transaction or arrangement, you convey, or propagate by procuring conveyance of, a covered work, and grant a patent license to some of the parties receiving the covered work authorizing them to use, propagate, modify or convey a specific copy of the covered work, then the patent license you grant is automatically extended to all recipients of the covered work and works based on it.</p> <p>A patent license is discriminatory if it does not include within the scope of its coverage, prohibits the exercise of, or is conditioned on the non-exercise of one or more of the rights that are specifically granted under this License. You may not convey a covered work if you are a party to an arrangement with a third party that is in the business of distributing software, under which you make payment to the third party based on the extent of your activity of conveying the work, and under which the third party grants, to any of the parties who would receive the covered work from you, a discriminatory patent license (a) in connection with copies of the covered work conveyed by you (or copies made from those copies), or (b) primarily for and in connection with specific products or compilations that contain the covered work, unless you entered into that arrangement, or that patent license was granted, prior to 28 March 2007.</p> <p>Nothing in this License shall be construed as excluding or limiting any implied license or other defenses to infringement that may otherwise be available to you under applicable patent law.</p> <p>12. No Surrender of Others' Freedom.</p> <p>If conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License. If you cannot convey a covered work so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may not convey it at all. For example, if you agree to terms that obligate you to collect a royalty for further conveying from those to whom you convey the Program, the only way you could satisfy both those terms and this License would be to refrain entirely from conveying the Program.</p> <p>13. Use with the GNU Affero General Public License.</p> <p>Notwithstanding any other provision of this License, you have permission to link or combine any covered work with a work licensed under version 3 of the GNU Affero General Public License into a single combined work, and to convey the resulting work. The terms of this License will continue to apply to the part which is the covered work, but the special requirements of the GNU Affero General Public License, section 13, concerning interaction through a network will apply to the combination as such.</p> <p>14. Revised Versions of this License.</p> <p>The Free Software Foundation may publish revised and/or new versions of the GNU General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.</p> <p>Each version is given a distinguishing version number. If the Program specifies that a certain numbered version of the GNU General Public License or any later version applies to it, you have the option of following the terms and conditions either of that numbered version or of any later version published by the Free Software Foundation. If the Program does not specify a version number of the GNU General Public License, you may choose any version ever published by the Free Software Foundation.</p> <p>If the Program specifies that a proxy can decide which future versions of the GNU General Public License can be used, that proxy's public statement of acceptance of a version permanently authorizes you to choose that version for the Program.</p> <p>Later license versions may give you additional or different permissions. However, no additional obligations are imposed on any author or copyright holder as a result of your choosing to follow a later version.</p> <p>15. Disclaimer of Warranty.</p> <p>THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.</p> <p>16. Limitation of Liability.</p> <p>IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</p> <p>17. Interpretation of Sections 15 and 16.</p> <p>If the disclaimer of warranty and limitation of liability provided above cannot be given local legal effect according to their terms, reviewing courts shall apply local law that most closely approximates an absolute waiver of all civil liability in connection with the Program, unless a warranty or assumption of liability accompanies a copy of the Program in return for a fee.</p> <p>END OF TERMS AND CONDITIONS</p> <p>How to Apply These Terms to Your New Programs</p> <p>If you develop a new program, and you want it to be of the greatest possible use to the public, the best way to achieve this is to make it free software which everyone can redistribute and change under these terms.</p> <p>To do so, attach the following notices to the program. It is safest to attach them to the start of each source file to most effectively state the exclusion of warranty; and each file should have at least the copyright line and a pointer to where the full notice is found.</p> <p>one line to give the program's name and a brief idea of what it does.</p> <p>Copyright \u00a9 year name of author</p> <p>This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.</p> <p>This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.</p> <p>You should have received a copy of the GNU General Public License along with this program. If not, see http://www.gnu.org/licenses/.</p> <p>Also add information on how to contact you by electronic and paper mail.</p> <p>If the program does terminal interaction, make it output a short notice like this when it starts in an interactive mode:</p> <p>program Copyright \u00a9 year name of author</p> <p>This program comes with ABSOLUTELY NO WARRANTY; for details type 'show w'.</p> <p>This is free software, and you are welcome to redistribute it under certain conditions; type 'show c' for details.</p> <p>The hypothetical commands 'show w' and 'show c' should show the appropriate parts of the General Public License. Of course, your program's commands might be different; for a GUI interface, you would use an about box.</p> <p>You should also get your employer (if you work as a programmer) or school, if any, to sign a copyright disclaimer for the program, if necessary. For more information on this, and how to apply and follow the GNU GPL, see http://www.gnu.org/licenses.</p> <p>The GNU General Public License does not permit incorporating your program into proprietary programs. If your program is a subroutine library, you may consider it more useful to permit linking proprietary applications with the library. If this is what you want to do, use the GNU Lesser General Public License instead of this License. But first, please read http://www.gnu.org/licenses/why-not-lgpl.en.html.</p>"},{"location":"third-party-licenses.html#python","title":"Python","text":"<p>A. HISTORY OF THE SOFTWARE</p> <p>Python was created in the early 1990s by Guido van Rossum at Stichting Mathematisch Centrum (CWI, see https://www.cwi.nl) in the Netherlands as a successor of a language called ABC. Guido remains Python's principal author, although it includes many contributions from others.</p> <p>In 1995, Guido continued his work on Python at the Corporation for National Research Initiatives (CNRI, see https://www.cnri.reston.va.us) in Reston, Virginia where he released several versions of the software.</p> <p>In May 2000, Guido and the Python core development team moved to BeOpen.com to form the BeOpen PythonLabs team. In October of the same year, the PythonLabs team moved to Digital Creations, which became Zope Corporation. In 2001, the Python Software Foundation (PSF, see https://www.python.org/psf/) was formed, a non-profit organization created specifically to own Python-related Intellectual Property. Zope Corporation was a sponsoring member of the PSF.</p> <p>All Python releases are Open Source (see https://opensource.org for the Open Source Definition). Historically, most, but not all, Python releases have also been GPL-compatible; the table below summarizes the various releases.</p> <pre><code>Release         Derived     Year        Owner       GPL-\n                from                                compatible? (1)\n\n0.9.0 thru 1.2              1991-1995   CWI         yes\n1.3 thru 1.5.2  1.2         1995-1999   CNRI        yes\n1.6             1.5.2       2000        CNRI        no\n2.0             1.6         2000        BeOpen.com  no\n1.6.1           1.6         2001        CNRI        yes (2)\n2.1             2.0+1.6.1   2001        PSF         no\n2.0.1           2.0+1.6.1   2001        PSF         yes\n2.1.1           2.1+2.0.1   2001        PSF         yes\n2.1.2           2.1.1       2002        PSF         yes\n2.1.3           2.1.2       2002        PSF         yes\n2.2 and above   2.1.1       2001-now    PSF         yes\n</code></pre> <p>Footnotes:</p> <p>(1) GPL-compatible doesn't mean that we're distributing Python under     the GPL. All Python licenses, unlike the GPL, let you distribute     a modified version without making your changes open source. The     GPL-compatible licenses make it possible to combine Python with     other software that is released under the GPL; the others don't.</p> <p>(2) According to Richard Stallman, 1.6.1 is not GPL-compatible,     because its license has a choice of law clause. According to     CNRI, however, Stallman's lawyer has told CNRI's lawyer that 1.6.1     is \"not incompatible\" with the GPL.</p> <p>Thanks to the many outside volunteers who have worked under Guido's direction to make these releases possible.</p> <p>B. TERMS AND CONDITIONS FOR ACCESSING OR OTHERWISE USING PYTHON</p> <p>Python software and documentation are licensed under the Python Software Foundation License Version 2.</p> <p>Starting with Python 3.8.6, examples, recipes, and other code in the documentation are dual licensed under the PSF License Version 2 and the Zero-Clause BSD license.</p> <p>Some software incorporated into Python is under different licenses. The licenses are listed with code falling under that license.</p> <p>PYTHON SOFTWARE FOUNDATION LICENSE VERSION 2</p> <ol> <li> <p>This LICENSE AGREEMENT is between the Python Software Foundation (\"PSF\"), and the Individual or Organization (\"Licensee\") accessing and otherwise using this software (\"Python\") in source or binary form and its associated documentation.</p> </li> <li> <p>Subject to the terms and conditions of this License Agreement, PSF hereby grants Licensee a nonexclusive, royalty-free, world-wide license to reproduce, analyze, test, perform and/or display publicly, prepare derivative works, distribute, and otherwise use Python alone or in any derivative version, provided, however, that PSF's License Agreement and PSF's notice of copyright, i.e., \"Copyright \u00a9 2001-2024 Python Software Foundation; All Rights Reserved\" are retained in Python alone or in any derivative version prepared by Licensee.</p> </li> <li> <p>In the event Licensee prepares a derivative work that is based on or incorporates Python or any part thereof, and wants to make the derivative work available to others as provided herein, then Licensee hereby agrees to include in any such work a brief summary of the changes made to Python.</p> </li> <li> <p>PSF is making Python available to Licensee on an \"AS IS\" basis. PSF MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE, BUT NOT LIMITATION, PSF MAKES NO AND DISCLAIMS ANY REPRESENTATION OR WARRANTY OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE OF PYTHON WILL NOT INFRINGE ANY THIRD PARTY RIGHTS.</p> </li> <li> <p>PSF SHALL NOT BE LIABLE TO LICENSEE OR ANY OTHER USERS OF PYTHON FOR ANY INCIDENTAL, SPECIAL, OR CONSEQUENTIAL DAMAGES OR LOSS AS A RESULT OF MODIFYING, DISTRIBUTING, OR OTHERWISE USING PYTHON, OR ANY DERIVATIVE THEREOF, EVEN IF ADVISED OF THE POSSIBILITY THEREOF.</p> </li> <li> <p>This License Agreement will automatically terminate upon a material breach of its terms and conditions.</p> </li> <li> <p>Nothing in this License Agreement shall be deemed to create any relationship of agency, partnership, or joint venture between PSF and Licensee. This License Agreement does not grant permission to use PSF trademarks or trade name in a trademark sense to endorse or promote products or services of Licensee, or any third party.</p> </li> <li> <p>By copying, installing or otherwise using Python, Licensee agrees to be bound by the terms and conditions of this License Agreement.</p> </li> </ol> <p>BEOPEN.COM LICENSE AGREEMENT FOR PYTHON 2.0</p> <p>BEOPEN PYTHON OPEN SOURCE LICENSE AGREEMENT VERSION 1</p> <ol> <li> <p>This LICENSE AGREEMENT is between BeOpen.com (\"BeOpen\"), having an office at 160 Saratoga Avenue, Santa Clara, CA 95051, and the Individual or Organization (\"Licensee\") accessing and otherwise using this software in source or binary form and its associated documentation (\"the Software\").</p> </li> <li> <p>Subject to the terms and conditions of this BeOpen Python License Agreement, BeOpen hereby grants Licensee a non-exclusive, royalty-free, world-wide license to reproduce, analyze, test, perform and/or display publicly, prepare derivative works, distribute, and otherwise use the Software alone or in any derivative version, provided, however, that the BeOpen Python License is retained in the Software, alone or in any derivative version prepared by Licensee.</p> </li> <li> <p>BeOpen is making the Software available to Licensee on an \"AS IS\" basis. BEOPEN MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE, BUT NOT LIMITATION, BEOPEN MAKES NO AND DISCLAIMS ANY REPRESENTATION OR WARRANTY OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE OF THE SOFTWARE WILL NOT INFRINGE ANY THIRD PARTY RIGHTS.</p> </li> <li> <p>BEOPEN SHALL NOT BE LIABLE TO LICENSEE OR ANY OTHER USERS OF THE SOFTWARE FOR ANY INCIDENTAL, SPECIAL, OR CONSEQUENTIAL DAMAGES OR LOSS AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THE SOFTWARE, OR ANY DERIVATIVE THEREOF, EVEN IF ADVISED OF THE POSSIBILITY THEREOF.</p> </li> <li> <p>This License Agreement will automatically terminate upon a material breach of its terms and conditions.</p> </li> <li> <p>This License Agreement shall be governed by and interpreted in all respects by the law of the State of California, excluding conflict of law provisions. Nothing in this License Agreement shall be deemed to create any relationship of agency, partnership, or joint venture between BeOpen and Licensee. This License Agreement does not grant permission to use BeOpen trademarks or trade names in a trademark sense to endorse or promote products or services of Licensee, or any third party. As an exception, the \"BeOpen Python\" logos available at http://www.pythonlabs.com/logos.html may be used according to the permissions granted on that web page.</p> </li> <li> <p>By copying, installing or otherwise using the software, Licensee agrees to be bound by the terms and conditions of this License Agreement.</p> </li> </ol> <p>CNRI LICENSE AGREEMENT FOR PYTHON 1.6.1</p> <ol> <li> <p>This LICENSE AGREEMENT is between the Corporation for National Research Initiatives, having an office at 1895 Preston White Drive, Reston, VA 20191 (\"CNRI\"), and the Individual or Organization (\"Licensee\") accessing and otherwise using Python 1.6.1 software in source or binary form and its associated documentation.</p> </li> <li> <p>Subject to the terms and conditions of this License Agreement, CNRI hereby grants Licensee a nonexclusive, royalty-free, world-wide license to reproduce, analyze, test, perform and/or display publicly, prepare derivative works, distribute, and otherwise use Python 1.6.1 alone or in any derivative version, provided, however, that CNRI's License Agreement and CNRI's notice of copyright, i.e., \"Copyright \u00a9 1995-2001 Corporation for National Research Initiatives; All Rights Reserved\" are retained in Python 1.6.1 alone or in any derivative version prepared by Licensee. Alternately, in lieu of CNRI's License Agreement, Licensee may substitute the following text (omitting the quotes): \"Python 1.6.1 is made available subject to the terms and conditions in CNRI's License Agreement. This Agreement together with Python 1.6.1 may be located on the internet using the following unique, persistent identifier (known as a handle): 1895.22/1013. This Agreement may also be obtained from a proxy server on the internet using the following URL: http://hdl.handle.net/1895.22/1013\".</p> </li> <li> <p>In the event Licensee prepares a derivative work that is based on or incorporates Python 1.6.1 or any part thereof, and wants to make the derivative work available to others as provided herein, then Licensee hereby agrees to include in any such work a brief summary of the changes made to Python 1.6.1.</p> </li> <li> <p>CNRI is making Python 1.6.1 available to Licensee on an \"AS IS\" basis. CNRI MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE, BUT NOT LIMITATION, CNRI MAKES NO AND DISCLAIMS ANY REPRESENTATION OR WARRANTY OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE OF PYTHON 1.6.1 WILL NOT INFRINGE ANY THIRD PARTY RIGHTS.</p> </li> <li> <p>CNRI SHALL NOT BE LIABLE TO LICENSEE OR ANY OTHER USERS OF PYTHON 1.6.1 FOR ANY INCIDENTAL, SPECIAL, OR CONSEQUENTIAL DAMAGES OR LOSS AS A RESULT OF MODIFYING, DISTRIBUTING, OR OTHERWISE USING PYTHON 1.6.1, OR ANY DERIVATIVE THEREOF, EVEN IF ADVISED OF THE POSSIBILITY THEREOF.</p> </li> <li> <p>This License Agreement will automatically terminate upon a material breach of its terms and conditions.</p> </li> <li> <p>This License Agreement shall be governed by the federal intellectual property law of the United States, including without limitation the federal copyright law, and, to the extent such U.S. federal law does not apply, by the law of the Commonwealth of Virginia, excluding Virginia's conflict of law provisions. Notwithstanding the foregoing, with regard to derivative works based on Python 1.6.1 that incorporate non-separable material that was previously distributed under the GNU General Public License (GPL), the law of the Commonwealth of Virginia shall govern this License Agreement only as to issues arising under or with respect to Paragraphs 4, 5, and 7 of this License Agreement. Nothing in this License Agreement shall be deemed to create any relationship of agency, partnership, or joint venture between CNRI and Licensee. This License Agreement does not grant permission to use CNRI trademarks or trade name in a trademark sense to endorse or promote products or services of Licensee, or any third party.</p> </li> <li> <p>By clicking on the \"ACCEPT\" button where indicated, or by copying, installing or otherwise using Python 1.6.1, Licensee agrees to be bound by the terms and conditions of this License Agreement.</p> </li> </ol> <p>CWI LICENSE AGREEMENT FOR PYTHON 0.9.0 THROUGH 1.2</p> <p>Copyright \u00a9 1991 - 1995, Stichting Mathematisch Centrum Amsterdam, The Netherlands. All rights reserved.</p> <p>Permission to use, copy, modify, and distribute this software and its documentation for any purpose and without fee is hereby granted, provided that the above copyright notice appear in all copies and that both that copyright notice and this permission notice appear in supporting documentation, and that the name of Stichting Mathematisch Centrum or CWI not be used in advertising or publicity pertaining to distribution of the software without specific, written prior permission.</p> <p>STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.</p> <p>ZERO-CLAUSE BSD LICENSE FOR CODE IN THE PYTHON DOCUMENTATION</p> <p>Permission to use, copy, modify, and/or distribute this software for any purpose with or without fee is hereby granted.</p> <p>THE SOFTWARE IS PROVIDED \"AS IS\" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.</p> <p>Additional Conditions for this Windows binary build</p> <p>This program is linked with and uses Microsoft Distributable Code, copyrighted by Microsoft Corporation. The Microsoft Distributable Code is embedded in each .exe, .dll and .pyd file as a result of running the code through a linker.</p> <p>If you further distribute programs that include the Microsoft Distributable Code, you must comply with the restrictions on distribution specified by Microsoft. In particular, you must require distributors and external end users to agree to terms that protect the Microsoft Distributable Code at least as much as Microsoft's own requirements for the Distributable Code. See Microsoft's documentation (included in its developer tools and on its website at microsoft.com) for specific details.</p> <p>Redistribution of the Windows binary build of the Python interpreter complies with this agreement, provided that you do not:</p> <ul> <li> <p>alter any copyright, trademark or patent notice in Microsoft's Distributable Code;</p> </li> <li> <p>use Microsoft's trademarks in your programs' names or in a way that suggests your programs come from or are endorsed by Microsoft;</p> </li> <li> <p>distribute Microsoft's Distributable Code to run on a platform other than Microsoft operating systems, run-time technologies or application platforms; or</p> </li> <li> <p>include Microsoft Distributable Code in malicious, deceptive or unlawful programs.</p> </li> </ul> <p>These restrictions apply only to the Microsoft Distributable Code as defined above, not to Python itself or any programs running on the Python interpreter. The redistribution of the Python interpreter and libraries is governed by the Python Software License included with this file, or by other licenses as marked.</p> <p>This program, \"bzip2\", the associated library \"libbzip2\", and all documentation, are copyright (C) 1996-2019 Julian R Seward. All rights reserved.</p> <p>Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:</p> <ol> <li> <p>Redistributions of source code must retain the above copyright    notice, this list of conditions and the following disclaimer.</p> </li> <li> <p>The origin of this software must not be misrepresented; you must    not claim that you wrote the original software. If you use this    software in a product, an acknowledgment in the product    documentation would be appreciated but is not required.</p> </li> <li> <p>Altered source versions must be plainly marked as such, and must    not be misrepresented as being the original software.</p> </li> <li> <p>The name of the author may not be used to endorse or promote    products derived from this software without specific prior written    permission.</p> </li> </ol> <p>THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.</p> <p>Julian Seward, jseward@acm.org bzip2/libbzip2 version 1.0.8 of 13 July 2019</p> <p>libffi - Copyright \u00a9 1996-2022  Anthony Green, Red Hat, Inc and others. See source files for details.</p> <p>Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the ``Software''), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:</p> <p>The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.</p> <p>THE SOFTWARE IS PROVIDED ``AS IS'', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.</p> <p>Apache License</p> <p>Version 2.0, January 2004</p> <p>https://www.apache.org/licenses/</p> <p>TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION</p> <ol> <li> <p>Definitions.</p> <p>\"License\" shall mean the terms and conditions for use, reproduction,   and distribution as defined by Sections 1 through 9 of this document.</p> <p>\"Licensor\" shall mean the copyright owner or entity authorized by   the copyright owner that is granting the License.</p> <p>\"Legal Entity\" shall mean the union of the acting entity and all   other entities that control, are controlled by, or are under common   control with that entity. For the purposes of this definition,   \"control\" means (i) the power, direct or indirect, to cause the   direction or management of such entity, whether by contract or   otherwise, or (ii) ownership of fifty percent (50%) or more of the   outstanding shares, or (iii) beneficial ownership of such entity.</p> <p>\"You\" (or \"Your\") shall mean an individual or Legal Entity   exercising permissions granted by this License.</p> <p>\"Source\" form shall mean the preferred form for making modifications,   including but not limited to software source code, documentation   source, and configuration files.</p> <p>\"Object\" form shall mean any form resulting from mechanical   transformation or translation of a Source form, including but   not limited to compiled object code, generated documentation,   and conversions to other media types.</p> <p>\"Work\" shall mean the work of authorship, whether in Source or   Object form, made available under the License, as indicated by a   copyright notice that is included in or attached to the work   (an example is provided in the Appendix below).</p> <p>\"Derivative Works\" shall mean any work, whether in Source or Object   form, that is based on (or derived from) the Work and for which the   editorial revisions, annotations, elaborations, or other modifications   represent, as a whole, an original work of authorship. For the purposes   of this License, Derivative Works shall not include works that remain   separable from, or merely link (or bind by name) to the interfaces of,   the Work and Derivative Works thereof.</p> <p>\"Contribution\" shall mean any work of authorship, including   the original version of the Work and any modifications or additions   to that Work or Derivative Works thereof, that is intentionally   submitted to Licensor for inclusion in the Work by the copyright owner   or by an individual or Legal Entity authorized to submit on behalf of   the copyright owner. For the purposes of this definition, \"submitted\"   means any form of electronic, verbal, or written communication sent   to the Licensor or its representatives, including but not limited to   communication on electronic mailing lists, source code control systems,   and issue tracking systems that are managed by, or on behalf of, the   Licensor for the purpose of discussing and improving the Work, but   excluding communication that is conspicuously marked or otherwise   designated in writing by the copyright owner as \"Not a Contribution.\"</p> <p>\"Contributor\" shall mean Licensor and any individual or Legal Entity   on behalf of whom a Contribution has been received by Licensor and   subsequently incorporated within the Work.</p> </li> <li> <p>Grant of Copyright License. Subject to the terms and conditions of       this License, each Contributor hereby grants to You a perpetual,       worldwide, non-exclusive, no-charge, royalty-free, irrevocable       copyright license to reproduce, prepare Derivative Works of,       publicly display, publicly perform, sublicense, and distribute the       Work and such Derivative Works in Source or Object form.</p> </li> <li> <p>Grant of Patent License. Subject to the terms and conditions of       this License, each Contributor hereby grants to You a perpetual,       worldwide, non-exclusive, no-charge, royalty-free, irrevocable       (except as stated in this section) patent license to make, have made,       use, offer to sell, sell, import, and otherwise transfer the Work,       where such license applies only to those patent claims licensable       by such Contributor that are necessarily infringed by their       Contribution(s) alone or by combination of their Contribution(s)       with the Work to which such Contribution(s) was submitted. If You       institute patent litigation against any entity (including a       cross-claim or counterclaim in a lawsuit) alleging that the Work       or a Contribution incorporated within the Work constitutes direct       or contributory patent infringement, then any patent licenses       granted to You under this License for that Work shall terminate       as of the date such litigation is filed.</p> </li> <li> <p>Redistribution. You may reproduce and distribute copies of the       Work or Derivative Works thereof in any medium, with or without       modifications, and in Source or Object form, provided that You       meet the following conditions:</p> <p>(a) You must give any other recipients of the Work or       Derivative Works a copy of this License; and</p> <p>(b) You must cause any modified files to carry prominent notices       stating that You changed the files; and</p> <p>\u00a9 You must retain, in the Source form of any Derivative Works       that You distribute, all copyright, patent, trademark, and       attribution notices from the Source form of the Work,       excluding those notices that do not pertain to any part of       the Derivative Works; and</p> <p>(d) If the Work includes a \"NOTICE\" text file as part of its       distribution, then any Derivative Works that You distribute must       include a readable copy of the attribution notices contained       within such NOTICE file, excluding those notices that do not       pertain to any part of the Derivative Works, in at least one       of the following places: within a NOTICE text file distributed       as part of the Derivative Works; within the Source form or       documentation, if provided along with the Derivative Works; or,       within a display generated by the Derivative Works, if and       wherever such third-party notices normally appear. The contents       of the NOTICE file are for informational purposes only and       do not modify the License. You may add Your own attribution       notices within Derivative Works that You distribute, alongside       or as an addendum to the NOTICE text from the Work, provided       that such additional attribution notices cannot be construed       as modifying the License.</p> <p>You may add Your own copyright statement to Your modifications and   may provide additional or different license terms and conditions   for use, reproduction, or distribution of Your modifications, or   for any such Derivative Works as a whole, provided Your use,   reproduction, and distribution of the Work otherwise complies with   the conditions stated in this License.</p> </li> <li> <p>Submission of Contributions. Unless You explicitly state otherwise,       any Contribution intentionally submitted for inclusion in the Work       by You to the Licensor shall be under the terms and conditions of       this License, without any additional terms or conditions.       Notwithstanding the above, nothing herein shall supersede or modify       the terms of any separate license agreement you may have executed       with Licensor regarding such Contributions.</p> </li> <li> <p>Trademarks. This License does not grant permission to use the trade       names, trademarks, service marks, or product names of the Licensor,       except as required for reasonable and customary use in describing the       origin of the Work and reproducing the content of the NOTICE file.</p> </li> <li> <p>Disclaimer of Warranty. Unless required by applicable law or       agreed to in writing, Licensor provides the Work (and each       Contributor provides its Contributions) on an \"AS IS\" BASIS,       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or       implied, including, without limitation, any warranties or conditions       of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A       PARTICULAR PURPOSE. You are solely responsible for determining the       appropriateness of using or redistributing the Work and assume any       risks associated with Your exercise of permissions under this License.</p> </li> <li> <p>Limitation of Liability. In no event and under no legal theory,       whether in tort (including negligence), contract, or otherwise,       unless required by applicable law (such as deliberate and grossly       negligent acts) or agreed to in writing, shall any Contributor be       liable to You for damages, including any direct, indirect, special,       incidental, or consequential damages of any character arising as a       result of this License or out of the use or inability to use the       Work (including but not limited to damages for loss of goodwill,       work stoppage, computer failure or malfunction, or any and all       other commercial damages or losses), even if such Contributor       has been advised of the possibility of such damages.</p> </li> <li> <p>Accepting Warranty or Additional Liability. While redistributing       the Work or Derivative Works thereof, You may choose to offer,       and charge a fee for, acceptance of support, warranty, indemnity,       or other liability obligations and/or rights consistent with this       License. However, in accepting such obligations, You may act only       on Your own behalf and on Your sole responsibility, not on behalf       of any other Contributor, and only if You agree to indemnify,       defend, and hold each Contributor harmless for any liability       incurred by, or claims asserted against, such Contributor by reason       of your accepting any such warranty or additional liability.</p> </li> </ol> <p>END OF TERMS AND CONDITIONS</p> <p>This software is copyrighted by the Regents of the University of California, Sun Microsystems, Inc., Scriptics Corporation, ActiveState Corporation and other parties. The following terms apply to all files associated with the software unless explicitly disclaimed in individual files.</p> <p>The authors hereby grant permission to use, copy, modify, distribute, and license this software and its documentation for any purpose, provided that existing copyright notices are retained in all copies and that this notice is included verbatim in any distributions. No written agreement, license, or royalty fee is required for any of the authorized uses. Modifications to this software may be copyrighted by their authors and need not follow the licensing terms described here, provided that the new terms are clearly indicated on the first page of each file where they apply.</p> <p>IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.</p> <p>THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.</p> <p>GOVERNMENT USE: If you are acquiring this software on behalf of the U.S. government, the Government shall have only \"Restricted Rights\" in the software and related documentation as defined in the Federal Acquisition Regulations (FARs) in Clause 52.227.19 \u00a9 (2). If you are acquiring the software on behalf of the Department of Defense, the software shall be classified as \"Commercial Computer Software\" and the Government shall have only \"Restricted Rights\" as defined in Clause 252.227-7014 (b) (3) of DFARs. Notwithstanding the foregoing, the authors grant the U.S. Government and others acting in its behalf permission to use and distribute the software in accordance with the terms specified in this license.</p> <p>This software is copyrighted by the Regents of the University of California, Sun Microsystems, Inc., Scriptics Corporation, ActiveState Corporation, Apple Inc. and other parties. The following terms apply to all files associated with the software unless explicitly disclaimed in individual files.</p> <p>The authors hereby grant permission to use, copy, modify, distribute, and license this software and its documentation for any purpose, provided that existing copyright notices are retained in all copies and that this notice is included verbatim in any distributions. No written agreement, license, or royalty fee is required for any of the authorized uses. Modifications to this software may be copyrighted by their authors and need not follow the licensing terms described here, provided that the new terms are clearly indicated on the first page of each file where they apply.</p> <p>IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.</p> <p>THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.</p> <p>GOVERNMENT USE: If you are acquiring this software on behalf of the U.S. government, the Government shall have only \"Restricted Rights\" in the software and related documentation as defined in the Federal Acquisition Regulations (FARs) in Clause 52.227.19 \u00a9 (2). If you are acquiring the software on behalf of the Department of Defense, the software shall be classified as \"Commercial Computer Software\" and the Government shall have only \"Restricted Rights\" as defined in Clause 252.227-7013 (b) (3) of DFARs. Notwithstanding the foregoing, the authors grant the U.S. Government and others acting in its behalf permission to use and distribute the software in accordance with the terms specified in this license.</p>"},{"location":"third-party-licenses.html#qt","title":"Qt","text":"<p>This software uses the Qt framework, which is licensed under the GNU Lesser General Public License (LGPL) version 3.</p> <p>To allow for relinking with a modified version of Qt, this software uses dynamic linking to the Qt libraries. This software does not statically link Qt components. Users may replace the Qt library files with their own compatible builds of Qt.</p>"},{"location":"third-party-licenses.html#gnu-lesser-general-public-license","title":"GNU LESSER GENERAL PUBLIC LICENSE","text":"<p>Version 3, 29 June 2007</p> <p>Copyright (C) 2007 Free Software Foundation, Inc. http://fsf.org/  Everyone is permitted to copy and distribute verbatim copies  of this license document, but changing it is not allowed.</p> <p>This version of the GNU Lesser General Public License incorporates the terms and conditions of version 3 of the GNU General Public License, supplemented by the additional permissions listed below.</p> <p>0. Additional Definitions.</p> <p>As used herein, \"this License\" refers to version 3 of the GNU Lesser General Public License, and the \"GNU GPL\" refers to version 3 of the GNU General Public License.</p> <p>\"The Library\" refers to a covered work governed by this License, other than an Application or a Combined Work as defined below.</p> <p>An \"Application\" is any work that makes use of an interface provided by the Library, but which is not otherwise based on the Library. Defining a subclass of a class defined by the Library is deemed a mode of using an interface provided by the Library.</p> <p>A \"Combined Work\" is a work produced by combining or linking an Application with the Library. The particular version of the Library with which the Combined Work was made is also called the \"Linked Version\".</p> <p>The \"Minimal Corresponding Source\" for a Combined Work means the Corresponding Source for the Combined Work, excluding any source code for portions of the Combined Work that, considered in isolation, are based on the Application, and not on the Linked Version.</p> <p>The \"Corresponding Application Code\" for a Combined Work means the object code and/or source code for the Application, including any data and utility programs needed for reproducing the Combined Work from the Application, but excluding the System Libraries of the Combined Work.</p> <p>1. Exception to Section 3 of the GNU GPL.</p> <p>You may convey a covered work under sections 3 and 4 of this License without being bound by section 3 of the GNU GPL.</p> <p>2. Conveying Modified Versions.</p> <p>If you modify a copy of the Library, and, in your modifications, a facility refers to a function or data to be supplied by an Application that uses the facility (other than as an argument passed when the facility is invoked), then you may convey a copy of the modified version:</p> <p>a) under this License, provided that you make a good faith effort to    ensure that, in the event an Application does not supply the    function or data, the facility still operates, and performs    whatever part of its purpose remains meaningful, or</p> <p>b) under the GNU GPL, with none of the additional permissions of    this License applicable to that copy.</p> <p>3. Object Code Incorporating Material from Library Header Files.</p> <p>The object code form of an Application may incorporate material from a header file that is part of the Library. You may convey such object code under terms of your choice, provided that, if the incorporated material is not limited to numerical parameters, data structure layouts and accessors, or small macros, inline functions and templates (ten or fewer lines in length), you do both of the following:</p> <p>a) Give prominent notice with each copy of the object code that the    Library is used in it and that the Library and its use are    covered by this License.</p> <p>b) Accompany the object code with a copy of the GNU GPL and this license    document.</p> <p>4. Combined Works.</p> <p>You may convey a Combined Work under terms of your choice that, taken together, effectively do not restrict modification of the portions of the Library contained in the Combined Work and reverse engineering for debugging such modifications, if you also do each of the following:</p> <p>a) Give prominent notice with each copy of the Combined Work that the Library is used in it and that the Library and its use are covered by this License.</p> <p>b) Accompany the Combined Work with a copy of the GNU GPL and this license document.</p> <p>c) For a Combined Work that displays copyright notices during execution, include the copyright notice for the Library among these notices, as well as a reference directing the user to the copies of the GNU GPL and this license document.</p> <p>d) Do one of the following:</p> <ul> <li> <p>Convey the Minimal Corresponding Source under the terms of this License, and the Corresponding Application Code in a form suitable for, and under terms that permit, the user to recombine or relink the Application with a modified version of the Linked Version to produce a modified Combined Work, in the manner specified by section 6 of the GNU GPL for conveying Corresponding Source.</p> </li> <li> <p>Use a suitable shared library mechanism for linking with the Library. A suitable mechanism is one that (a) uses at run time a copy of the Library already present on the user's computer system, and (b) will operate properly with a modified version of the Library that is interface-compatible with the Linked Version.</p> </li> </ul> <p>e) Provide Installation Information, but only if you would otherwise be required to provide such information under section 6 of the GNU GPL, and only to the extent that such information is necessary to install and execute a modified version of the Combined Work produced by recombining or relinking the Application with a modified version of the Linked Version. (If you use option 4d0, the Installation Information must accompany the Minimal Corresponding Source and Corresponding Application Code. If you use option 4d1, you must provide the Installation Information in the manner specified by section 6 of the GNU GPL for conveying Corresponding Source.)</p> <p>5. Combined Libraries.</p> <p>You may place library facilities that are a work based on the Library side by side in a single library together with other library facilities that are not Applications and are not covered by this License, and convey such a combined library under terms of your choice, if you do both of the following:</p> <p>a) Accompany the combined library with a copy of the same work based    on the Library, uncombined with any other library facilities,    conveyed under the terms of this License.</p> <p>b) Give prominent notice with the combined library that part of it    is a work based on the Library, and explaining where to find the    accompanying uncombined form of the same work.</p> <p>6. Revised Versions of the GNU Lesser General Public License.</p> <p>The Free Software Foundation may publish revised and/or new versions of the GNU Lesser General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.</p> <p>Each version is given a distinguishing version number. If the Library as you received it specifies that a certain numbered version of the GNU Lesser General Public License \"or any later version\" applies to it, you have the option of following the terms and conditions either of that published version or of any later version published by the Free Software Foundation. If the Library as you received it does not specify a version number of the GNU Lesser General Public License, you may choose any version of the GNU Lesser General Public License ever published by the Free Software Foundation.</p> <p>If the Library as you received it specifies that a proxy can decide whether future versions of the GNU Lesser General Public License shall apply, that proxy's public statement of acceptance of any version is permanent authorization for you to choose that version for the Library.</p>"},{"location":"third-party-licenses.html#gnu-general-public-license","title":"GNU GENERAL PUBLIC LICENSE","text":"<p>Version 3, 29 June 2007</p> <p>Copyright (C) 2007 Free Software Foundation, Inc. http://fsf.org/  Everyone is permitted to copy and distribute verbatim copies  of this license document, but changing it is not allowed.</p> <p>Preamble</p> <p>The GNU General Public License is a free, copyleft license for software and other kinds of works.</p> <p>The licenses for most software and other practical works are designed to take away your freedom to share and change the works. By contrast, the GNU General Public License is intended to guarantee your freedom to share and change all versions of a program\u2013to make sure it remains free software for all its users. We, the Free Software Foundation, use the GNU General Public License for most of our software; it applies also to any other work released this way by its authors. You can apply it to your programs, too.</p> <p>When we speak of free software, we are referring to freedom, not price. Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for them if you wish), that you receive source code or can get it if you want it, that you can change the software or use pieces of it in new free programs, and that you know you can do these things.</p> <p>To protect your rights, we need to prevent others from denying you these rights or asking you to surrender the rights. Therefore, you have certain responsibilities if you distribute copies of the software, or if you modify it: responsibilities to respect the freedom of others.</p> <p>For example, if you distribute copies of such a program, whether gratis or for a fee, you must pass on to the recipients the same freedoms that you received. You must make sure that they, too, receive or can get the source code. And you must show them these terms so they know their rights.</p> <p>Developers that use the GNU GPL protect your rights with two steps: (1) assert copyright on the software, and (2) offer you this License giving you legal permission to copy, distribute and/or modify it.</p> <p>For the developers' and authors' protection, the GPL clearly explains that there is no warranty for this free software. For both users' and authors' sake, the GPL requires that modified versions be marked as changed, so that their problems will not be attributed erroneously to authors of previous versions.</p> <p>Some devices are designed to deny users access to install or run modified versions of the software inside them, although the manufacturer can do so. This is fundamentally incompatible with the aim of protecting users' freedom to change the software. The systematic pattern of such abuse occurs in the area of products for individuals to use, which is precisely where it is most unacceptable. Therefore, we have designed this version of the GPL to prohibit the practice for those products. If such problems arise substantially in other domains, we stand ready to extend this provision to those domains in future versions of the GPL, as needed to protect the freedom of users.</p> <p>Finally, every program is threatened constantly by software patents. States should not allow patents to restrict development and use of software on general-purpose computers, but in those that do, we wish to avoid the special danger that patents applied to a free program could make it effectively proprietary. To prevent this, the GPL assures that patents cannot be used to render the program non-free.</p> <p>The precise terms and conditions for copying, distribution and modification follow.</p> <p>TERMS AND CONDITIONS</p> <p>0. Definitions.</p> <p>\"This License\" refers to version 3 of the GNU General Public License.</p> <p>\"Copyright\" also means copyright-like laws that apply to other kinds of works, such as semiconductor masks.</p> <p>\"The Program\" refers to any copyrightable work licensed under this License. Each licensee is addressed as \"you\". \"Licensees\" and \"recipients\" may be individuals or organizations.</p> <p>To \"modify\" a work means to copy from or adapt all or part of the work in a fashion requiring copyright permission, other than the making of an exact copy. The resulting work is called a \"modified version\" of the earlier work or a work \"based on\" the earlier work.</p> <p>A \"covered work\" means either the unmodified Program or a work based on the Program.</p> <p>To \"propagate\" a work means to do anything with it that, without permission, would make you directly or secondarily liable for infringement under applicable copyright law, except executing it on a computer or modifying a private copy. Propagation includes copying, distribution (with or without modification), making available to the public, and in some countries other activities as well.</p> <p>To \"convey\" a work means any kind of propagation that enables other parties to make or receive copies. Mere interaction with a user through a computer network, with no transfer of a copy, is not conveying.</p> <p>An interactive user interface displays \"Appropriate Legal Notices\" to the extent that it includes a convenient and prominently visible feature that (1) displays an appropriate copyright notice, and (2) tells the user that there is no warranty for the work (except to the extent that warranties are provided), that licensees may convey the work under this License, and how to view a copy of this License. If the interface presents a list of user commands or options, such as a menu, a prominent item in the list meets this criterion.</p> <p>1. Source Code.</p> <p>The \"source code\" for a work means the preferred form of the work for making modifications to it. \"Object code\" means any non-source form of a work.</p> <p>A \"Standard Interface\" means an interface that either is an official standard defined by a recognized standards body, or, in the case of interfaces specified for a particular programming language, one that is widely used among developers working in that language.</p> <p>The \"System Libraries\" of an executable work include anything, other than the work as a whole, that (a) is included in the normal form of packaging a Major Component, but which is not part of that Major Component, and (b) serves only to enable use of the work with that Major Component, or to implement a Standard Interface for which an implementation is available to the public in source code form. A \"Major Component\", in this context, means a major essential component (kernel, window system, and so on) of the specific operating system (if any) on which the executable work runs, or a compiler used to produce the work, or an object code interpreter used to run it.</p> <p>The \"Corresponding Source\" for a work in object code form means all the source code needed to generate, install, and (for an executable work) run the object code and to modify the work, including scripts to control those activities. However, it does not include the work's System Libraries, or general-purpose tools or generally available free programs which are used unmodified in performing those activities but which are not part of the work. For example, Corresponding Source includes interface definition files associated with source files for the work, and the source code for shared libraries and dynamically linked subprograms that the work is specifically designed to require, such as by intimate data communication or control flow between those subprograms and other parts of the work.</p> <p>The Corresponding Source need not include anything that users can regenerate automatically from other parts of the Corresponding Source.</p> <p>The Corresponding Source for a work in source code form is that same work.</p> <p>2. Basic Permissions.</p> <p>All rights granted under this License are granted for the term of copyright on the Program, and are irrevocable provided the stated conditions are met. This License explicitly affirms your unlimited permission to run the unmodified Program. The output from running a covered work is covered by this License only if the output, given its content, constitutes a covered work. This License acknowledges your rights of fair use or other equivalent, as provided by copyright law.</p> <p>You may make, run and propagate covered works that you do not convey, without conditions so long as your license otherwise remains in force. You may convey covered works to others for the sole purpose of having them make modifications exclusively for you, or provide you with facilities for running those works, provided that you comply with the terms of this License in conveying all material for which you do not control copyright. Those thus making or running the covered works for you must do so exclusively on your behalf, under your direction and control, on terms that prohibit them from making any copies of your copyrighted material outside their relationship with you.</p> <p>Conveying under any other circumstances is permitted solely under the conditions stated below. Sublicensing is not allowed; section 10 makes it unnecessary.</p> <p>3. Protecting Users' Legal Rights From Anti-Circumvention Law.</p> <p>No covered work shall be deemed part of an effective technological measure under any applicable law fulfilling obligations under article 11 of the WIPO copyright treaty adopted on 20 December 1996, or similar laws prohibiting or restricting circumvention of such measures.</p> <p>When you convey a covered work, you waive any legal power to forbid circumvention of technological measures to the extent such circumvention is effected by exercising rights under this License with respect to the covered work, and you disclaim any intention to limit operation or modification of the work as a means of enforcing, against the work's users, your or third parties' legal rights to forbid circumvention of technological measures.</p> <p>4. Conveying Verbatim Copies.</p> <p>You may convey verbatim copies of the Program's source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice; keep intact all notices stating that this License and any non-permissive terms added in accord with section 7 apply to the code; keep intact all notices of the absence of any warranty; and give all recipients a copy of this License along with the Program.</p> <p>You may charge any price or no price for each copy that you convey, and you may offer support or warranty protection for a fee.</p> <p>5. Conveying Modified Source Versions.</p> <p>You may convey a work based on the Program, or the modifications to produce it from the Program, in the form of source code under the terms of section 4, provided that you also meet all of these conditions:</p> <p>a) The work must carry prominent notices stating that you modified it, and giving a relevant date. b) The work must carry prominent notices stating that it is released under this License and any conditions added under section 1. This requirement modifies the requirement in section 4 to \"keep intact all notices\". c) You must license the entire work, as a whole, under this License to anyone who comes into possession of a copy. This License will therefore apply, along with any applicable section 7 additional terms, to the whole of the work, and all its parts, regardless of how they are packaged. This License gives no permission to license the work in any other way, but it does not invalidate such permission if you have separately received it. d) If the work has interactive user interfaces, each must display Appropriate Legal Notices; however, if the Program has interactive interfaces that do not display Appropriate Legal Notices, your work need not make them do so.</p> <p>A compilation of a covered work with other separate and independent works, which are not by their nature extensions of the covered work, and which are not combined with it such as to form a larger program, in or on a volume of a storage or distribution medium, is called an \"aggregate\" if the compilation and its resulting copyright are not used to limit the access or legal rights of the compilation's users beyond what the individual works permit. Inclusion of a covered work in an aggregate does not cause this License to apply to the other parts of the aggregate.</p> <p>6. Conveying Non-Source Forms.</p> <p>You may convey a covered work in object code form under the terms of sections 4 and 5, provided that you also convey the machine-readable Corresponding Source under the terms of this License, in one of these ways:</p> <p>a) Convey the object code in, or embodied in, a physical product (including a physical distribution medium), accompanied by the Corresponding Source fixed on a durable physical medium customarily used for software interchange. b) Convey the object code in, or embodied in, a physical product (including a physical distribution medium), accompanied by a written offer, valid for at least three years and valid for as long as you offer spare parts or customer support for that product model, to give anyone who possesses the object code either (1) a copy of the Corresponding Source for all the software in the product that is covered by this License, on a durable physical medium customarily used for software interchange, for a price no more than your reasonable cost of physically performing this conveying of source, or (2) access to copy the Corresponding Source from a network server at no charge. c) Convey individual copies of the object code with a copy of the written offer to provide the Corresponding Source. This alternative is allowed only occasionally and noncommercially, and only if you received the object code with such an offer, in accord with subsection 6b. d) Convey the object code by offering access from a designated place (gratis or for a charge), and offer equivalent access to the Corresponding Source in the same way through the same place at no further charge. You need not require recipients to copy the Corresponding Source along with the object code. If the place to copy the object code is a network server, the Corresponding Source may be on a different server (operated by you or a third party) that supports equivalent copying facilities, provided you maintain clear directions next to the object code saying where to find the Corresponding Source. Regardless of what server hosts the Corresponding Source, you remain obligated to ensure that it is available for as long as needed to satisfy these requirements. e) Convey the object code using peer-to-peer transmission, provided you inform other peers where the object code and Corresponding Source of the work are being offered to the general public at no charge under subsection 6d.</p> <p>A separable portion of the object code, whose source code is excluded from the Corresponding Source as a System Library, need not be included in conveying the object code work.</p> <p>A \"User Product\" is either (1) a \"consumer product\", which means any tangible personal property which is normally used for personal, family, or household purposes, or (2) anything designed or sold for incorporation into a dwelling. In determining whether a product is a consumer product, doubtful cases shall be resolved in favor of coverage. For a particular product received by a particular user, \"normally used\" refers to a typical or common use of that class of product, regardless of the status of the particular user or of the way in which the particular user actually uses, or expects or is expected to use, the product. A product is a consumer product regardless of whether the product has substantial commercial, industrial or non-consumer uses, unless such uses represent the only significant mode of use of the product.</p> <p>\"Installation Information\" for a User Product means any methods, procedures, authorization keys, or other information required to install and execute modified versions of a covered work in that User Product from a modified version of its Corresponding Source. The information must suffice to ensure that the continued functioning of the modified object code is in no case prevented or interfered with solely because modification has been made.</p> <p>If you convey an object code work under this section in, or with, or specifically for use in, a User Product, and the conveying occurs as part of a transaction in which the right of possession and use of the User Product is transferred to the recipient in perpetuity or for a fixed term (regardless of how the transaction is characterized), the Corresponding Source conveyed under this section must be accompanied by the Installation Information. But this requirement does not apply if neither you nor any third party retains the ability to install modified object code on the User Product (for example, the work has been installed in ROM).</p> <p>The requirement to provide Installation Information does not include a requirement to continue to provide support service, warranty, or updates for a work that has been modified or installed by the recipient, or for the User Product in which it has been modified or installed. Access to a network may be denied when the modification itself materially and adversely affects the operation of the network or violates the rules and protocols for communication across the network.</p> <p>Corresponding Source conveyed, and Installation Information provided, in accord with this section must be in a format that is publicly documented (and with an implementation available to the public in source code form), and must require no special password or key for unpacking, reading or copying.</p> <p>7. Additional Terms.</p> <p>\"Additional permissions\" are terms that supplement the terms of this License by making exceptions from one or more of its conditions. Additional permissions that are applicable to the entire Program shall be treated as though they were included in this License, to the extent that they are valid under applicable law. If additional permissions apply only to part of the Program, that part may be used separately under those permissions, but the entire Program remains governed by this License without regard to the additional permissions.</p> <p>When you convey a copy of a covered work, you may at your option remove any additional permissions from that copy, or from any part of it. (Additional permissions may be written to require their own removal in certain cases when you modify the work.)  You may place additional permissions on material, added by you to a covered work, for which you have or can give appropriate copyright permission.</p> <p>Notwithstanding any other provision of this License, for material you add to a covered work, you may (if authorized by the copyright holders of that material) supplement the terms of this License with terms:</p> <p>a) Disclaiming warranty or limiting liability differently from the terms of sections 15 and 16 of this License; or b) Requiring preservation of specified reasonable legal notices or author attributions in that material or in the Appropriate Legal Notices displayed by works containing it; or c) Prohibiting misrepresentation of the origin of that material, or requiring that modified versions of such material be marked in reasonable ways as different from the original version; or d) Limiting the use for publicity purposes of names of licensors or authors of the material; or e) Declining to grant rights under trademark law for use of some trade names, trademarks, or service marks; or f) Requiring indemnification of licensors and authors of that material by anyone who conveys the material (or modified versions of it) with contractual assumptions of liability to the recipient, for any liability that these contractual assumptions directly impose on those licensors and authors.</p> <p>All other non-permissive additional terms are considered \"further restrictions\" within the meaning of section 10. If the Program as you received it, or any part of it, contains a notice stating that it is governed by this License along with a term that is a further restriction, you may remove that term. If a license document contains a further restriction but permits relicensing or conveying under this License, you may add to a covered work material governed by the terms of that license document, provided that the further restriction does not survive such relicensing or conveying.</p> <p>If you add terms to a covered work in accord with this section, you must place, in the relevant source files, a statement of the additional terms that apply to those files, or a notice indicating where to find the applicable terms.</p> <p>Additional terms, permissive or non-permissive, may be stated in the form of a separately written license, or stated as exceptions; the above requirements apply either way.</p> <p>8. Termination.</p> <p>You may not propagate or modify a covered work except as expressly provided under this License. Any attempt otherwise to propagate or modify it is void, and will automatically terminate your rights under this License (including any patent licenses granted under the third paragraph of section 11).</p> <p>However, if you cease all violation of this License, then your license from a particular copyright holder is reinstated (a) provisionally, unless and until the copyright holder explicitly and finally terminates your license, and (b) permanently, if the copyright holder fails to notify you of the violation by some reasonable means prior to 60 days after the cessation.</p> <p>Moreover, your license from a particular copyright holder is reinstated permanently if the copyright holder notifies you of the violation by some reasonable means, this is the first time you have received notice of violation of this License (for any work) from that copyright holder, and you cure the violation prior to 30 days after your receipt of the notice.</p> <p>Termination of your rights under this section does not terminate the licenses of parties who have received copies or rights from you under this License. If your rights have been terminated and not permanently reinstated, you do not qualify to receive new licenses for the same material under section 10.</p> <p>9. Acceptance Not Required for Having Copies.</p> <p>You are not required to accept this License in order to receive or run a copy of the Program. Ancillary propagation of a covered work occurring solely as a consequence of using peer-to-peer transmission to receive a copy likewise does not require acceptance. However, nothing other than this License grants you permission to propagate or modify any covered work. These actions infringe copyright if you do not accept this License. Therefore, by modifying or propagating a covered work, you indicate your acceptance of this License to do so.</p> <p>10. Automatic Licensing of Downstream Recipients.</p> <p>Each time you convey a covered work, the recipient automatically receives a license from the original licensors, to run, modify and propagate that work, subject to this License. You are not responsible for enforcing compliance by third parties with this License.</p> <p>An \"entity transaction\" is a transaction transferring control of an organization, or substantially all assets of one, or subdividing an organization, or merging organizations. If propagation of a covered work results from an entity transaction, each party to that transaction who receives a copy of the work also receives whatever licenses to the work the party's predecessor in interest had or could give under the previous paragraph, plus a right to possession of the Corresponding Source of the work from the predecessor in interest, if the predecessor has it or can get it with reasonable efforts.</p> <p>You may not impose any further restrictions on the exercise of the rights granted or affirmed under this License. For example, you may not impose a license fee, royalty, or other charge for exercise of rights granted under this License, and you may not initiate litigation (including a cross-claim or counterclaim in a lawsuit) alleging that any patent claim is infringed by making, using, selling, offering for sale, or importing the Program or any portion of it.</p> <p>11. Patents.</p> <p>A \"contributor\" is a copyright holder who authorizes use under this License of the Program or a work on which the Program is based. The work thus licensed is called the contributor's \"contributor version\".</p> <p>A contributor's \"essential patent claims\" are all patent claims owned or controlled by the contributor, whether already acquired or hereafter acquired, that would be infringed by some manner, permitted by this License, of making, using, or selling its contributor version, but do not include claims that would be infringed only as a consequence of further modification of the contributor version. For purposes of this definition, \"control\" includes the right to grant patent sublicenses in a manner consistent with the requirements of this License.</p> <p>Each contributor grants you a non-exclusive, worldwide, royalty-free patent license under the contributor's essential patent claims, to make, use, sell, offer for sale, import and otherwise run, modify and propagate the contents of its contributor version.</p> <p>In the following three paragraphs, a \"patent license\" is any express agreement or commitment, however denominated, not to enforce a patent (such as an express permission to practice a patent or covenant not to sue for patent infringement). To \"grant\" such a patent license to a party means to make such an agreement or commitment not to enforce a patent against the party.</p> <p>If you convey a covered work, knowingly relying on a patent license, and the Corresponding Source of the work is not available for anyone to copy, free of charge and under the terms of this License, through a publicly available network server or other readily accessible means, then you must either (1) cause the Corresponding Source to be so available, or (2) arrange to deprive yourself of the benefit of the patent license for this particular work, or (3) arrange, in a manner consistent with the requirements of this License, to extend the patent license to downstream recipients. \"Knowingly relying\" means you have actual knowledge that, but for the patent license, your conveying the covered work in a country, or your recipient's use of the covered work in a country, would infringe one or more identifiable patents in that country that you have reason to believe are valid.</p> <p>If, pursuant to or in connection with a single transaction or arrangement, you convey, or propagate by procuring conveyance of, a covered work, and grant a patent license to some of the parties receiving the covered work authorizing them to use, propagate, modify or convey a specific copy of the covered work, then the patent license you grant is automatically extended to all recipients of the covered work and works based on it.</p> <p>A patent license is \"discriminatory\" if it does not include within the scope of its coverage, prohibits the exercise of, or is conditioned on the non-exercise of one or more of the rights that are specifically granted under this License. You may not convey a covered work if you are a party to an arrangement with a third party that is in the business of distributing software, under which you make payment to the third party based on the extent of your activity of conveying the work, and under which the third party grants, to any of the parties who would receive the covered work from you, a discriminatory patent license (a) in connection with copies of the covered work conveyed by you (or copies made from those copies), or (b) primarily for and in connection with specific products or compilations that contain the covered work, unless you entered into that arrangement, or that patent license was granted, prior to 28 March 2007.</p> <p>Nothing in this License shall be construed as excluding or limiting any implied license or other defenses to infringement that may otherwise be available to you under applicable patent law.</p> <p>12. No Surrender of Others' Freedom.</p> <p>If conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License. If you cannot convey a covered work so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may not convey it at all. For example, if you agree to terms that obligate you to collect a royalty for further conveying from those to whom you convey the Program, the only way you could satisfy both those terms and this License would be to refrain entirely from conveying the Program.</p> <p>13. Use with the GNU Affero General Public License.</p> <p>Notwithstanding any other provision of this License, you have permission to link or combine any covered work with a work licensed under version 3 of the GNU Affero General Public License into a single combined work, and to convey the resulting work. The terms of this License will continue to apply to the part which is the covered work, but the special requirements of the GNU Affero General Public License, section 13, concerning interaction through a network will apply to the combination as such.</p> <p>14. Revised Versions of this License.</p> <p>The Free Software Foundation may publish revised and/or new versions of the GNU General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.</p> <p>Each version is given a distinguishing version number. If the Program specifies that a certain numbered version of the GNU General Public License \"or any later version\" applies to it, you have the option of following the terms and conditions either of that numbered version or of any later version published by the Free Software Foundation. If the Program does not specify a version number of the GNU General Public License, you may choose any version ever published by the Free Software Foundation.</p> <p>If the Program specifies that a proxy can decide which future versions of the GNU General Public License can be used, that proxy's public statement of acceptance of a version permanently authorizes you to choose that version for the Program.</p> <p>Later license versions may give you additional or different permissions. However, no additional obligations are imposed on any author or copyright holder as a result of your choosing to follow a later version.</p> <p>15. Disclaimer of Warranty.</p> <p>THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.</p> <p>16. Limitation of Liability.</p> <p>IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</p> <p>17. Interpretation of Sections 15 and 16.</p> <p>If the disclaimer of warranty and limitation of liability provided above cannot be given local legal effect according to their terms, reviewing courts shall apply local law that most closely approximates an absolute waiver of all civil liability in connection with the Program, unless a warranty or assumption of liability accompanies a copy of the Program in return for a fee.</p> <p>END OF TERMS AND CONDITIONS</p> <p>How to Apply These Terms to Your New Programs</p> <p>If you develop a new program, and you want it to be of the greatest possible use to the public, the best way to achieve this is to make it free software which everyone can redistribute and change under these terms.</p> <p>To do so, attach the following notices to the program. It is safest to attach them to the start of each source file to most effectively state the exclusion of warranty; and each file should have at least the \"copyright\" line and a pointer to where the full notice is found.</p> <p>&lt;one line to give the program's name and a brief idea of what it does.&gt; Copyright (C) &lt;year&gt;  &lt;name of author&gt; This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version. This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with this program. If not, see http://www.gnu.org/licenses/. Also add information on how to contact you by electronic and paper mail.</p> <p>If the program does terminal interaction, make it output a short notice like this when it starts in an interactive mode:</p> <p>&lt;program&gt;  Copyright (C) &lt;year&gt;  &lt;name of author&gt; This program comes with ABSOLUTELY NO WARRANTY; for details type <code>show w</code>. This is free software, and you are welcome to redistribute it under certain conditions; type `show c' for details.</p> <p>The hypothetical commands <code>show w</code> and <code>show c</code> should show the appropriate parts of the General Public License. Of course, your program's commands might be different; for a GUI interface, you would use an \"about box\".</p> <p>You should also get your employer (if you work as a programmer) or school, if any, to sign a \"copyright disclaimer\" for the program, if necessary. For more information on this, and how to apply and follow the GNU GPL, see http://www.gnu.org/licenses/.</p> <p>The GNU General Public License does not permit incorporating your program into proprietary programs. If your program is a subroutine library, you may consider it more useful to permit linking proprietary applications with the library. If this is what you want to do, use the GNU Lesser General Public License instead of this License. But first, please read http://www.gnu.org/philosophy/why-not-lgpl.html.</p>"},{"location":"third-party-licenses.html#chromium-third-party-licenses","title":"CHROMIUM THIRD PARTY LICENSES","text":"<p>This product includes the Qt WebEngine module, which contains portions of the Chromium project and other third-party components.</p> <p>CHROMIUM LICENSE</p> <p>Copyright 2015 The Chromium Authors</p> <p>Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:</p> <ul> <li>Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.</li> <li>Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.</li> <li>Neither the name of Google LLC nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.</li> </ul> <p>THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.</p> <p>For a full list of related third-party licenses used by chromium, see the document License/Chromium_Third-Party_Licenses.html in the VisualApplets installation folder.</p> <p>See also https://doc.qt.io/qt-6/qtwebengine-licensing.html</p>"},{"location":"third-party-licenses.html#tcl","title":"Tcl","text":"<p>This software is copyrighted by the Regents of the University of California, Sun Microsystems, Inc., Scriptics Corporation, ActiveState Corporation and other parties. The following terms apply to all files associated with the software unless explicitly disclaimed in individual files.</p> <p>The authors hereby grant permission to use, copy, modify, distribute, and license this software and its documentation for any purpose, provided that existing copyright notices are retained in all copies and that this notice is included verbatim in any distributions. No written agreement, license, or royalty fee is required for any of the authorized uses. Modifications to this software may be copyrighted by their authors and need not follow the licensing terms described here, provided that the new terms are clearly indicated on the first page of each file where they apply.</p> <p>IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.</p> <p>THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN AS IS BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.</p> <p>GOVERNMENT USE: If you are acquiring this software on behalf of the U.S. government, the Government shall have only Restricted Rights in the software and related documentation as defined in the Federal Acquisition Regulations (FARs) in Clause 52.227.19 \u00a9 (2). If you are acquiring the software on behalf of the Department of Defense, the software shall be classified as Commercial Computer Software and the Government shall have only Restricted Rights as defined in Clause 252.227-7014 (b) (3) of DFARs. Notwithstanding the foregoing, the authors grant the U.S. Government and others acting in its behalf permission to use and distribute the software in accordance with the terms specified in this license.</p>"},{"location":"visual-applets-licensing.html","title":"VisualApplets Licensing","text":"<p>To run VisualApplets, you need to:</p> <ul> <li>Install the software on your computer</li> <li>Use a dongle holding the VisualApplets license(s) you have purchased.</li> </ul> <p>For VisualApplets licenses, you need to use a CmStick Basic Dongle (Wibu Systems AG).</p> <p></p> <p>You can either use a CmStick dongle you order together with your VisualApplets license, or a CmStick dongle you already have and also use for other licenses. If you use a CmStick dongle you already use, or if you have purchased additional licenses for your VisualApplets installation, you have to add the appropriate license file to the CmStick dongle (see Adding or Updating Licenses).</p> <p>You use always one license file for VisualApplets. If you purchase VisualApplets extensions, you are provided with a new license file that contains the original VisualApplets license and the licenses for the extensions you purchased. See Adding or Updating Licenses for instructions for flashing your CmStick dongle with the new license file.</p> <p>Info</p> <p>Without access to a dongle with the VisualApplets IDE Software License, your VisualApplets installation works in demo mode only.</p> <p>You can order the CmStick Basic Dongle via the Basler website.</p>"},{"location":"visual-applets-licensing.html#available-licenses","title":"Available Licenses","text":""},{"location":"visual-applets-licensing.html#visualapplets-ide-software-license","title":"VisualApplets IDE Software License","text":"<p>For using VisualApplets, you need the VisualApplets IDE Software License. This license contains the features VA Core and VA Gui. VisualApplets 4 IDE Software License also contains all available extension modules except the VisualApplets Embedder. Visual Applets 3 IDE Software license doesn't contain the extension modules. For a detailed description of changes between VisualApplets 3 IDE Software License and VisualApplets4 IDE License, see the Product Change Notification \"Simplified licensing model of VisualApplets\".</p>"},{"location":"visual-applets-licensing.html#extension-modules-for-visualapplets","title":"Extension Modules for VisualApplets","text":"<p>In addition to the VisualApplets 3 IDE Software License, various extension modules are available which you can purchase separately. In the VisualApplets 4 license, all extension modules are already included except the VisualApplets Embedder.</p> <p>When you purchase an extension, you receive a new license file for your individual dongle. The new license file includes not only the license for VisualApplets, but also the license(s) for the extension(s) you have purchased. You need to update your dongle with the new license file to use the extensions you purchased. See Adding or Updating Licenses for more details.</p> <p>The following extension modules are available:</p> <ul> <li>VisualApplets Embedder</li> <li>VisualApplets 3 Expert, containing<ul> <li>Debugging Module (<code>Debugging</code> library)</li> <li>Parameters Translation Module (<code>Parameters</code> library)</li> <li>Custom Operators Feature</li> <li>Protecting user library elements</li> <li>TCL Scripting Feature (automatization of design creation and simulation)</li> </ul> </li> <li>Debugging Module (<code>Debugging</code> library): individual library license</li> <li>Parameters Translation Module (<code>Parameters</code> library): individual library license</li> <li>Segmentation and Classification Library (<code>Blob</code>): individual library license</li> <li><code>JPEG Compression</code> library: individual library license</li> </ul> <p></p> <p>For further information about VisualApplets licenses, contact Basler Support.</p>"},{"location":"visual-applets-licensing.html#mode-of-use","title":"Mode of Use","text":"<p>There are two ways of licensing your software:</p> <ul> <li>Stand-alone license (local dongle), see Using the Stand-Alone License</li> <li>Floating license (network dongle), see Using the Floating License</li> </ul>"},{"location":"visual-applets-licensing.html#using-the-stand-alone-license","title":"Using the Stand-Alone License","text":"<p>Requirements:</p> <ul> <li>Dongle: Make sure you have a CmStick (Wibu Systems AG) available that contains your VisualApplets license.</li> <li>Installation: VisualApplets is installed on the PC.</li> </ul> <p>To use VisualApplets with a local license:</p> <ol> <li>Put the CmStick dongle containing your VisualApplets license into a free USB slot of your PC.</li> <li>You don't need to restart your PC. Just (re)start VisualApplets. Without any additional entries you are able to start working with VisualApplets.</li> </ol> <p>How to update your dongle with a new (extended) license, containing, for example, additional libraries or VisualApplets Embedder, see Adding or Updating Licenses.</p>"},{"location":"visual-applets-licensing.html#using-the-floating-license","title":"Using the Floating License","text":"<p>Requirements:</p> <ul> <li>Dongle: Make sure you have a CmStick (Wibu Systems AG) available that contains your VisualApplets license.</li> <li>License File: Make sure you have the VisualApplets license also available in *.txt format.</li> <li>Installation: VisualApplets is installed on the PCs on which it is intended to be used.</li> </ul> <p>To use VisualApplets with floating license:</p> <ol> <li>Put the CmStick dongle that contains your VisualApplets floating license into a free USB slot of your network server.</li> <li>Install the CmStick User Runtime software to this network server. You can download the software from www.wibu.com.</li> <li>Save the license file *.txt to a place that is available from the local VisualApplets installation. (Save it either to a network server, or to the file system of each local machine.)</li> <li> <p>On each local machine, set the following environment variables:</p> <p><code>VA_LICENSE_SERVER</code>: Specify here the name of you network server.</p> <p><code>VA_LICENSE_FILE</code>: Specify here the path to and the name of the license file *.txt.</p> </li> </ol> <p>Now, you can use the floating licenses on all local machines on which you have set the environment variables and that have access to the network server and to the license file *.txt.</p> <p>If you want to enlarge the number of users contained in your floating license, or if you want to upgrade from a local (node-locked) license to a floating license, contact Basler Support.</p> <p>How to update your dongle with a new (extended) license, containing, for example, additional libraries or VisualApplets Embedder, see Adding or Updating Licenses.</p>"},{"location":"visual-applets-licensing.html#adding-or-updating-licenses","title":"Adding or Updating Licenses","text":"<p>If you have purchased VisualApplets Extensions, or if you come from VisualApplets 2 and want to use VisualApplets 3, you need to update your VisualApplets license on the dongle hardware.</p> <p>To update your license, proceed the following steps:</p> <ol> <li>Request your license file from Basler. Communicate your dongle number in your request message. Also communicate if you have purchased any VisualApplets Extensions.</li> <li>Store your individual license file on your file system.</li> <li>Insert the VisualApplets dongle into a free USB slot on your PC.</li> <li> <p>Open VisualApplets 3 (in demo mode) and from the Tools menu, select menu item License Manager.</p> <p></p> </li> <li> <p>The License Manager window opens:</p> <p> The components of the license stored on your dongle are displayed.</p> </li> <li> <p>Option: You may want to save a backup file of the license currently active on your dongle. To do so, use the Backup Dongle License button.</p> </li> <li> <p>Select the number of the dongle that is used for the VisualApplets license (the number of the dongle you find directly on the dongle hardware item).</p> </li> <li> <p>Select the new License file from your file system.</p> <p></p> </li> <li> <p>Use option Show features of this license file. Now, the components which are part of the new license are displayed. You can switch between the two radio buttons to compare the new license with the license that is currently active on your dongle.</p> </li> <li>If you are satisfied with the contents of the new license file, click button Flash License to Dongle.</li> </ol>"},{"location":"visualapplets-end-user-license-agreement.html","title":"VisualApplets End-User License Agreement","text":"<p>IMPORTANT - PLEASE READ CAREFULLY</p> <p>THIS END-USER LICENSE AGREEMENT (\"AGREEMENT\") IS A LEGAL AGREEMENT BETWEEN END-USER (\u201cCUSTOMER\u201d) AND BASLER AG (\"BASLER\") FOR THE BASLER SOFTWARE PRODUCTS ACCOMPANYING THIS AGREEMENT, WHICH INCLUDES COMPUTER SOFTWARE AND MAY INCLUDE \"ONLINE\" OR ELECTRONIC DOCUMENTATION, ASSOCIATED MEDIA, AND PRINTED MATERIALS (\"SOFTWARE\"). BEFORE CUSTOMER CLICK ON THE \"ACCEPT\" BUTTON BELOW AND COMPLETE THE INSTALLATION PROCESS, OR BEFORE CUSTOMER DOWNLOAD, INSTALL OR USE THE SOFTWARE, CAREFULLY READ THIS AGREEMENT. BY CLICKING THE \"ACCEPT\" BUTTON, OR BY DOWNLOADING, INSTALLING OR USING THE SOFTWARE, CUSTOMER CONSENT TO THE TERMS OF THIS AGREEMENT AND CUSTOMER AGREE TO BE BOUND BY THIS AGREEMENT. IF CUSTOMER DO NOT AGREE TO THE TERMS AND CONDITIONS OF THIS AGREEMENT, CLICK THE \"CANCEL\" BUTTON AND/ OR DO NOT DOWNLOAD, INSTALL OR USE THE SOFTWARE.</p> <p>1. SOFTWARE OF THIRD-PARTY MANUFACTURERS. Notwithstanding the terms and conditions of this AGREEMENT, all or any portion of the SOFTWARE which constitutes non-proprietary BASLER software or software provided under open source license by third parties (\"third-party software\"), is licensed to CUSTOMER subject to the terms and conditions of the software license agreement accompanying such third-party software. Use of the third-party software by CUSTOMER shall be governed entirely by the terms and conditions of such license. CUSTOMER can find the license terms and conditions in the file \"VisualApplets Third-Party Licenses.html\" or contact BASLER support. BASLER software includes some open source software source code that may be used and modified by anyone and everyone, provided they, in turn, make it available to everyone else with the same licensing agreement. Please contact BASLER support for the original source code of components licensed under open source licenses.</p> <p>2. GRANT OF LICENSE. BASLER grants CUSTOMER a personal, non-exclusive, non-transferable right to use the SOFTWARE provided that CUSTOMER comply with all terms and conditions of this AGREEMENT. The transfer of the SOFTWARE, including, but not limited to, sublicensing and distribution to a third party is not permitted. CUSTOMER may not rent, lease, sub-license, or lend the SOFTWARE or any portions thereof to others.</p> <p>3. PERMITTED USE OF THE SOFTWARE, SOFTWARE CONFIGURATIONS. CUSTOMER may install and use the SOFTWARE as provided herein. CUSTOMER may solely use the SOFTWARE for the purpose to develop applications for BASLER or SILICON SOFTWARE GMBH hardware products or third party products, which are qualified for embedded VisualApplets. In particular, this only includes products, which are listed as hardware platforms in VisualApplets.</p> <p>Different rights, obligations and restrictions apply to each Software Configuration. CUSTOMER`S right to install and use the SOFTWARE is determined by the Software Configuration selected, as set forth below:</p> <p>3.1 DEMO VERSION. Starting the SOFTWARE without a developer license leads to entering the Demo mode. CUSTOMER`S right to use the SOFTWARE in this mode is restricted to the purpose of evaluating the SOFTWARE. Except as aforesaid, CUSTOMER may not use the SOFTWARE for any other purposes, including, but not limited to, commercial purposes. In particular, CUSTOMER may not use the Demo mode to develop commercial applications.</p> <p>3.2 DEVELOPMENT VERSION. Starting the SOFTWARE with a developer license allows CUSTOMER to use the functionality of the SOFTWARE as described in the DOCUMENTATION for a certain period of time. The Development version requires a Wibu CodeMeter license dongle with an appropriate stored license. The period of time is unlimited for a given major version of the SOFTWARE. New major versions of the SOFTWARE require a new developer license.</p> <p>CUSTOMER may use the SOFTWARE to create derivatives, including commercial applications. In particular, CUSTOMER may use the Development Version to build FPGA designs for framegrabbers and cameras, which are qualified for VisualApplets or Embedded VisualApplets.</p> <p>4. RESTRICTIONS. CUSTOMER may not copy or use the SOFTWARE except as set forth in this AGREEMENT. CUSTOMER may not remove any proprietary notices or labels on the SOFTWARE; any copies that CUSTOMER are permitted to make pursuant to this AGREEMENT must contain the same copyright and other proprietary notices that appear on and in the SOFTWARE. No right is granted hereunder to use the SOFTWARE or any bitstream generated by use of the SOFTWARE to program or develop designs for devices, which are not qualified for VisualApplets or Embedded VisualApplets.</p> <p>5. LIMITATION ON REVERSE ENGINEERING. CUSTOMER agree not to modify, adapt, reverse engineer, decompile, or disassemble the SOFTWARE or otherwise at